/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyHashMap
extends BaseHashMap {
    Set keySet;
    Collection values;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public LongKeyHashMap() {
        this(16);
    }

    public LongKeyHashMap(int n) throws IllegalArgumentException {
        super(n, 2, 3, false);
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(long l) {
        this.readLock.lock();
        try {
            int n = this.getLookup(l);
            if (n == -1) {
                Object var4_3 = null;
                return var4_3;
            }
            Object object = this.objectValueTable[n];
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(long l, Object object) {
        this.writeLock.lock();
        try {
            Object object2 = super.addOrRemove(l, 0L, null, object, false);
            return object2;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object object) {
        this.readLock.lock();
        try {
            boolean bl = super.containsValue(object);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(long l) {
        this.writeLock.lock();
        try {
            Object object = super.addOrRemove(l, 0L, null, null, true);
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long l) {
        this.readLock.lock();
        try {
            boolean bl = super.containsKey(l);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void putAll(LongKeyHashMap longKeyHashMap) {
        Iterator iterator = longKeyHashMap.keySet().iterator();
        while (iterator.hasNext()) {
            long l = iterator.nextLong();
            this.put(l, longKeyHashMap.get(l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.readLock.lock();
        try {
            if (this.isEmpty()) {
                Object[] objectArray = emptyObjectArray;
                return objectArray;
            }
            Object[] objectArray = new Object[this.size()];
            int n = 0;
            BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(this, false);
            while (baseHashIterator.hasNext()) {
                objectArray[n++] = baseHashIterator.next();
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getOrderedMatchCount(int[] nArray) {
        int n;
        this.readLock.lock();
        try {
            for (n = 0; n < nArray.length; ++n) {
                if (super.containsKey(nArray[n])) continue;
                break;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return n;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    class Values
    implements Collection {
        Values() {
        }

        @Override
        public Iterator iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            longKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyHashMap.this.clear();
        }
    }

    class KeySet
    implements Set {
        KeySet() {
        }

        @Override
        public Iterator iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            longKeyHashMap.getClass();
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object get(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object object) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public void clear() {
            LongKeyHashMap.this.clear();
        }
    }
}

