/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import com.google.api.gax.batching.Semaphore64;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicLong;

class NonBlockingSemaphore
implements Semaphore64 {
    private AtomicLong availablePermits;
    private AtomicLong limit;

    private static void checkNotNegative(long l) {
        Preconditions.checkArgument((l >= 0L ? 1 : 0) != 0, (String)"negative permits not allowed: %s", (long)l);
    }

    NonBlockingSemaphore(long permits) {
        NonBlockingSemaphore.checkNotNegative(permits);
        this.availablePermits = new AtomicLong(permits);
        this.limit = new AtomicLong(permits);
    }

    @Override
    public void release(long permits) {
        long old;
        NonBlockingSemaphore.checkNotNegative(permits);
        while (!this.availablePermits.compareAndSet(old = this.availablePermits.get(), Math.min(old + permits, this.limit.get()))) {
        }
    }

    @Override
    public boolean acquire(long permits) {
        long old;
        NonBlockingSemaphore.checkNotNegative(permits);
        do {
            if ((old = this.availablePermits.get()) >= permits) continue;
            return false;
        } while (!this.availablePermits.compareAndSet(old, old - permits));
        return true;
    }

    @Override
    public boolean acquirePartial(long permits) {
        long old;
        NonBlockingSemaphore.checkNotNegative(permits);
        do {
            if ((old = this.availablePermits.get()) >= Math.min(this.limit.get(), permits)) continue;
            return false;
        } while (!this.availablePermits.compareAndSet(old, old - permits));
        return true;
    }

    @Override
    public void increasePermitLimit(long permits) {
        NonBlockingSemaphore.checkNotNegative(permits);
        this.availablePermits.addAndGet(permits);
        this.limit.addAndGet(permits);
    }

    @Override
    public void reducePermitLimit(long reduction) {
        long oldLimit;
        NonBlockingSemaphore.checkNotNegative(reduction);
        do {
            Preconditions.checkState(((oldLimit = this.limit.get()) - reduction > 0L ? 1 : 0) != 0, (Object)"permit limit underflow");
        } while (!this.limit.compareAndSet(oldLimit, oldLimit - reduction));
        this.availablePermits.addAndGet(-reduction);
    }

    @Override
    public long getPermitLimit() {
        return this.limit.get();
    }
}

