/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.beta.gcp.bigquery;

import java.sql.Connection;
import java.util.Map;
import java.util.regex.Pattern;
import org.flywaydb.beta.gcp.bigquery.BigQueryDatabase;
import org.flywaydb.beta.gcp.bigquery.BigQueryParser;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.internal.database.base.BaseDatabaseType;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.jdbc.JdbcConnectionFactory;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.parser.Parser;
import org.flywaydb.core.internal.parser.ParsingContext;
import org.flywaydb.core.internal.util.ClassUtils;

public class BigQueryDatabaseType
extends BaseDatabaseType {
    private static final String BIGQUERY_JDBC42_DRIVER = "com.simba.googlebigquery.jdbc42.Driver";
    private static final String BIGQUERY_JDBC_DRIVER = "com.simba.googlebigquery.jdbc.Driver";
    private static final Pattern OAUTH_CREDENTIALS_PATTERN = Pattern.compile("OAuth\\w+=([^;]*)", 2);

    public String getName() {
        return "BigQuery";
    }

    public int getNullType() {
        return 0;
    }

    public int getPriority() {
        return -1;
    }

    public Pattern getJDBCCredentialsPattern() {
        return OAUTH_CREDENTIALS_PATTERN;
    }

    public boolean handlesJDBCUrl(String url) {
        boolean gcpBeta = false;
        try {
            gcpBeta = Boolean.parseBoolean(System.getenv("flyway.googleCloudPlatformBeta"));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            LOG.debug("flyway.googleCloudPlatformBeta property missing or of illegal value");
        }
        return url.startsWith("jdbc:bigquery:") && gcpBeta;
    }

    public String getDriverClass(String url, ClassLoader classLoader) {
        return BIGQUERY_JDBC42_DRIVER;
    }

    public String getBackupDriverClass(String url, ClassLoader classLoader) {
        if (ClassUtils.isPresent((String)BIGQUERY_JDBC_DRIVER, (ClassLoader)classLoader)) {
            return BIGQUERY_JDBC_DRIVER;
        }
        return null;
    }

    public boolean handlesDatabaseProductNameAndVersion(String databaseProductName, String databaseProductVersion, Connection connection) {
        return databaseProductName.toLowerCase().contains("bigquery");
    }

    public void setOverridingConnectionProps(Map<String, String> props) {
    }

    public Database createDatabase(Configuration configuration, JdbcConnectionFactory jdbcConnectionFactory, StatementInterceptor statementInterceptor) {
        return new BigQueryDatabase(configuration, jdbcConnectionFactory, statementInterceptor);
    }

    public Parser createParser(Configuration configuration, ResourceProvider resourceProvider, ParsingContext parsingContext) {
        return new BigQueryParser(configuration, parsingContext);
    }

    public String instantiateClassExtendedErrorMessage() {
        return "Failure probably due to inability to load dependencies. Please ensure you have downloaded 'https://cloud.google.com/bigquery/docs/reference/odbc-jdbc-drivers' and extracted to 'flyway/drivers' folder";
    }
}

