/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.beta.gcp.bigquery;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.flywaydb.beta.gcp.bigquery.BigQueryDatabase;
import org.flywaydb.beta.gcp.bigquery.BigQuerySchema;
import org.flywaydb.core.internal.database.InsertRowLock;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;

public class BigQueryTable
extends Table<BigQueryDatabase, BigQuerySchema> {
    private final InsertRowLock insertRowLock;

    BigQueryTable(JdbcTemplate jdbcTemplate, BigQueryDatabase database, BigQuerySchema schema, String name) {
        super(jdbcTemplate, (Database)database, (Schema)schema, name);
        this.insertRowLock = new InsertRowLock(jdbcTemplate, 10);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + ((BigQueryDatabase)this.database).quote(new String[]{((BigQuerySchema)this.schema).getName(), this.name}), new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        if (!((BigQuerySchema)this.schema).exists()) {
            return false;
        }
        return this.jdbcTemplate.queryForInt("SELECT COUNT(table_name) FROM " + ((BigQueryDatabase)this.database).quote(new String[]{((BigQuerySchema)this.schema).getName()}) + ".INFORMATION_SCHEMA.TABLES WHERE table_type='BASE TABLE' AND table_name=?", new String[]{this.name}) > 0;
    }

    protected void doLock() throws SQLException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.add(12, -this.insertRowLock.lockTimeoutMins);
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
        String updateLockStatement = "UPDATE " + (Object)((Object)this) + " SET installed_on = now() WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
        String deleteExpiredLockStatement = " DELETE FROM " + (Object)((Object)this) + " WHERE DESCRIPTION = 'flyway-lock' AND installed_on < TIMESTAMP '" + timestampFormat.format(cal.getTime()) + "'";
        if (this.lockDepth == 0) {
            this.insertRowLock.doLock(((BigQueryDatabase)this.database).getInsertStatement(this), updateLockStatement, deleteExpiredLockStatement, ((BigQueryDatabase)this.database).getBooleanTrue());
        }
    }

    protected void doUnlock() throws SQLException {
        if (this.lockDepth == 1) {
            this.insertRowLock.doUnlock(this.getDeleteLockTemplate());
        }
    }

    private String getDeleteLockTemplate() {
        return "DELETE FROM " + (Object)((Object)this) + " WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
    }
}

