/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.cloud.spanner.jdbc.JdbcTypeConverter;
import com.google.common.base.Preconditions;
import com.google.rpc.Code;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Wrapper;
import java.util.Calendar;

abstract class AbstractJdbcWrapper
implements Wrapper {
    static final String OTHER_NAME = "OTHER";
    private static final String OUT_OF_RANGE_MSG = "Value out of range for %s: %s";

    AbstractJdbcWrapper() {
    }

    static int extractColumnType(Type type) {
        Preconditions.checkNotNull((Object)type);
        if (type.equals((Object)Type.bool())) {
            return 16;
        }
        if (type.equals((Object)Type.bytes())) {
            return -2;
        }
        if (type.equals((Object)Type.date())) {
            return 91;
        }
        if (type.equals((Object)Type.float64())) {
            return 8;
        }
        if (type.equals((Object)Type.int64())) {
            return -5;
        }
        if (type.equals((Object)Type.string())) {
            return -9;
        }
        if (type.equals((Object)Type.timestamp())) {
            return 93;
        }
        if (type.getCode() == Type.Code.ARRAY) {
            return 2003;
        }
        return 1111;
    }

    static String getSpannerTypeName(int sqlType) {
        if (sqlType == 16) {
            return Type.bool().getCode().name();
        }
        if (sqlType == -2) {
            return Type.bytes().getCode().name();
        }
        if (sqlType == 91) {
            return Type.date().getCode().name();
        }
        if (sqlType == 8 || sqlType == 6) {
            return Type.float64().getCode().name();
        }
        if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6) {
            return Type.int64().getCode().name();
        }
        if (sqlType == -9) {
            return Type.string().getCode().name();
        }
        if (sqlType == 93) {
            return Type.timestamp().getCode().name();
        }
        if (sqlType == 2003) {
            return Type.Code.ARRAY.name();
        }
        return OTHER_NAME;
    }

    static String getClassName(int sqlType) {
        if (sqlType == 16) {
            return Boolean.class.getName();
        }
        if (sqlType == -2) {
            return Byte[].class.getName();
        }
        if (sqlType == 91) {
            return java.sql.Date.class.getName();
        }
        if (sqlType == 8 || sqlType == 6) {
            return Double.class.getName();
        }
        if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6) {
            return Long.class.getName();
        }
        if (sqlType == -9) {
            return String.class.getName();
        }
        if (sqlType == 93) {
            return java.sql.Timestamp.class.getName();
        }
        if (sqlType == 2003) {
            return Object.class.getName();
        }
        return null;
    }

    static String getClassName(Type type) {
        Preconditions.checkNotNull((Object)type);
        if (type == Type.bool()) {
            return Boolean.class.getName();
        }
        if (type == Type.bytes()) {
            return byte[].class.getName();
        }
        if (type == Type.date()) {
            return java.sql.Date.class.getName();
        }
        if (type == Type.float64()) {
            return Double.class.getName();
        }
        if (type == Type.int64()) {
            return Long.class.getName();
        }
        if (type == Type.string()) {
            return String.class.getName();
        }
        if (type == Type.timestamp()) {
            return java.sql.Timestamp.class.getName();
        }
        if (type.getCode() == Type.Code.ARRAY) {
            if (type.getArrayElementType() == Type.bool()) {
                return Boolean[].class.getName();
            }
            if (type.getArrayElementType() == Type.bytes()) {
                return byte[][].class.getName();
            }
            if (type.getArrayElementType() == Type.date()) {
                return java.sql.Date[].class.getName();
            }
            if (type.getArrayElementType() == Type.float64()) {
                return Double[].class.getName();
            }
            if (type.getArrayElementType() == Type.int64()) {
                return Long[].class.getName();
            }
            if (type.getArrayElementType() == Type.string()) {
                return String[].class.getName();
            }
            if (type.getArrayElementType() == Type.timestamp()) {
                return java.sql.Timestamp[].class.getName();
            }
        }
        return null;
    }

    static byte checkedCastToByte(long val) throws SQLException {
        if (val > 127L || val < -128L) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "byte", val), Code.OUT_OF_RANGE);
        }
        return (byte)val;
    }

    static short checkedCastToShort(long val) throws SQLException {
        if (val > 32767L || val < -32768L) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "short", val), Code.OUT_OF_RANGE);
        }
        return (short)val;
    }

    static int checkedCastToInt(long val) throws SQLException {
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "int", val), Code.OUT_OF_RANGE);
        }
        return (int)val;
    }

    static float checkedCastToFloat(double val) throws SQLException {
        if (val > 3.4028234663852886E38 || val < -3.4028234663852886E38) {
            throw JdbcSqlExceptionFactory.of(String.format(OUT_OF_RANGE_MSG, "float", val), Code.OUT_OF_RANGE);
        }
        return (float)val;
    }

    static long parseLong(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return Long.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid number", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static double parseDouble(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return Double.valueOf(val);
        }
        catch (NumberFormatException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid number", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static java.sql.Date parseDate(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return JdbcTypeConverter.toSqlDate(Date.parseDate((String)val));
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid date", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static java.sql.Date parseDate(String val, Calendar cal) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        Preconditions.checkNotNull((Object)cal);
        try {
            return JdbcTypeConverter.toSqlDate(Date.parseDate((String)val), cal);
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid date", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static Time parseTime(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return Time.valueOf(val);
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid time", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static Time parseTime(String val, Calendar cal) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        Preconditions.checkNotNull((Object)cal);
        try {
            return JdbcTypeConverter.parseSqlTime(val, cal);
        }
        catch (IllegalArgumentException e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid time", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static java.sql.Timestamp parseTimestamp(String val) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        try {
            return JdbcTypeConverter.toSqlTimestamp(Timestamp.parseTimestamp((String)val));
        }
        catch (Exception e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid timestamp", val), Code.INVALID_ARGUMENT, e);
        }
    }

    static java.sql.Timestamp parseTimestamp(String val, Calendar cal) throws SQLException {
        Preconditions.checkNotNull((Object)val);
        Preconditions.checkNotNull((Object)cal);
        try {
            return JdbcTypeConverter.setTimestampInCalendar(Timestamp.parseTimestamp((String)val).toSqlTimestamp(), cal);
        }
        catch (Exception e) {
            throw JdbcSqlExceptionFactory.of(String.format("%s is not a valid timestamp", val), Code.INVALID_ARGUMENT, e);
        }
    }

    public abstract boolean isClosed() throws SQLException;

    void checkClosed() throws SQLException {
        if (this.isClosed()) {
            throw JdbcSqlExceptionFactory.of("This " + this.getClass().getName() + " has been closed", Code.FAILED_PRECONDITION);
        }
    }

    <T> T checkClosedAndThrowUnsupported(String message) throws SQLException {
        this.checkClosed();
        throw JdbcSqlExceptionFactory.unsupported(message);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (this.isWrapperFor(iface)) {
            return iface.cast(this);
        }
        throw JdbcSqlExceptionFactory.of("Cannot unwrap to " + iface.getName(), Code.INVALID_ARGUMENT);
    }
}

