/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.cockroachdb;

import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.flywaydb.core.internal.database.InsertRowLock;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBDatabase;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBRetryingStrategy;
import org.flywaydb.core.internal.database.cockroachdb.CockroachDBSchema;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.SqlCallable;

public class CockroachDBTable
extends Table<CockroachDBDatabase, CockroachDBSchema> {
    private final InsertRowLock insertRowLock;

    CockroachDBTable(JdbcTemplate jdbcTemplate, CockroachDBDatabase database, CockroachDBSchema schema, String name) {
        super(jdbcTemplate, database, schema, name);
        this.insertRowLock = new InsertRowLock(jdbcTemplate, 10);
    }

    @Override
    protected void doDrop() throws SQLException {
        new CockroachDBRetryingStrategy().execute(new SqlCallable<Integer>(){

            @Override
            public Integer call() throws SQLException {
                CockroachDBTable.this.doDropOnce();
                return null;
            }
        });
    }

    protected void doDropOnce() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE IF EXISTS " + ((CockroachDBDatabase)this.database).quote(((CockroachDBSchema)this.schema).getName(), this.name) + " CASCADE", new Object[0]);
    }

    @Override
    protected boolean doExists() throws SQLException {
        return new CockroachDBRetryingStrategy().execute(new SqlCallable<Boolean>(){

            @Override
            public Boolean call() throws SQLException {
                return CockroachDBTable.this.doExistsOnce();
            }
        });
    }

    protected boolean doExistsOnce() throws SQLException {
        if (((CockroachDBSchema)this.schema).cockroachDB1) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name = ?\n)", ((CockroachDBSchema)this.schema).getName(), this.name);
        }
        if (!((CockroachDBSchema)this.schema).hasSchemaSupport) {
            return this.jdbcTemplate.queryForBoolean("SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_catalog = ?\n   AND    table_schema = 'public'\n   AND    table_name = ?\n)", ((CockroachDBSchema)this.schema).getName(), this.name);
        }
        String sql = "SELECT EXISTS (\n   SELECT 1\n   FROM   information_schema.tables \n   WHERE  table_schema = ?\n   AND    table_name like '%" + this.name + "%' and length(table_name) = length(?)\n)";
        return this.jdbcTemplate.queryForBoolean(sql, ((CockroachDBSchema)this.schema).getName(), this.name);
    }

    @Override
    protected void doLock() throws SQLException {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.add(12, -this.insertRowLock.lockTimeoutMins);
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
        String updateLockStatement = "UPDATE " + this + " SET installed_on = now() WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
        String deleteExpiredLockStatement = " DELETE FROM " + this + " WHERE DESCRIPTION = 'flyway-lock' AND installed_on < TIMESTAMP '" + timestampFormat.format(cal.getTime()) + "'";
        if (this.lockDepth == 0) {
            this.insertRowLock.doLock(((CockroachDBDatabase)this.database).getInsertStatement(this), updateLockStatement, deleteExpiredLockStatement, ((CockroachDBDatabase)this.database).getBooleanTrue());
        }
    }

    @Override
    protected void doUnlock() throws SQLException {
        if (this.lockDepth == 1) {
            this.insertRowLock.doUnlock(this.getDeleteLockTemplate());
        }
    }

    private String getDeleteLockTemplate() {
        return "DELETE FROM " + this + " WHERE version = '?' AND DESCRIPTION = 'flyway-lock'";
    }
}

