/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle;

import java.io.IOException;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.callback.Error;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.callback.CallbackExecutor;
import org.flywaydb.core.internal.database.oracle.OracleResults;
import org.flywaydb.core.internal.database.oracle.pro.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusSpoolData;
import org.flywaydb.core.internal.database.oracle.pro.ServerOutputFormat;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.Result;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.sqlscript.DefaultSqlScriptExecutor;
import org.flywaydb.core.internal.sqlscript.SqlScript;
import org.flywaydb.core.internal.sqlscript.SqlStatement;
import org.flywaydb.core.internal.util.AsciiTable;
import org.flywaydb.core.internal.util.DateUtils;
import org.flywaydb.core.internal.util.StopWatch;
import org.flywaydb.core.internal.util.StringUtils;

public class OracleSqlScriptExecutor
extends DefaultSqlScriptExecutor {
    private static final Log LOG = LogFactory.getLog(OracleSqlScriptExecutor.class);
    private int depth = -1;
    private boolean echo = false;
    private boolean heading = true;
    private boolean time = false;
    private boolean timing = false;
    private boolean serverOutput = false;
    private String serverOutputSize = "UNLIMITED";
    private ServerOutputFormat serverOutputFormat = ServerOutputFormat.WORD_WRAPPED;
    private int lineSize = 80;
    private int feedback = 6;
    private boolean suppressErrors = false;
    private boolean termOut = true;
    private String nullText = "";
    private SQLPlusSpoolData spoolData;

    public OracleSqlScriptExecutor(JdbcTemplate jdbcTemplate, CallbackExecutor callbackExecutor, boolean undo, boolean batch, boolean outputQueryResults, StatementInterceptor statementInterceptor) {
        super(jdbcTemplate, callbackExecutor, undo, batch, outputQueryResults, statementInterceptor);
    }

    @Override
    public void execute(SqlScript sqlScript) {
        ++this.depth;
        try {
            if (this.depth > 20) {
                throw new FlywayException("SP2-0309: SQL*Plus command procedures may only be nested to a depth of 20.");
            }
            super.execute(sqlScript);
        }
        finally {
            --this.depth;
        }
    }

    @Override
    protected void executeStatement(JdbcTemplate jdbcTemplate, SqlScript sqlScript, SqlStatement sqlStatement) {
        StopWatch stopWatch = null;
        if (this.timing && !(sqlStatement instanceof AbstractSQLPlusParsedSqlStatement)) {
            stopWatch = new StopWatch();
            stopWatch.start();
        }
        super.executeStatement(jdbcTemplate, sqlScript, sqlStatement);
        if (stopWatch != null) {
            stopWatch.stop();
            long millis = stopWatch.getTotalTimeMillis();
            this.log("Elapsed: " + String.format("%02d:%02d:%02d.%02d", millis / 3600000L, millis / 60000L, millis % 60000L / 1000L, millis % 1000L / 10L));
        }
    }

    @Override
    protected void logStatementExecution(SqlStatement sqlStatement) {
        if (this.echo || this.time) {
            String output = "";
            if (this.time) {
                output = output + DateUtils.formatTimeAsIsoString(new Date()) + " ";
            }
            output = output + "SQL>";
            if (this.echo) {
                output = output + " " + sqlStatement.getSql() + sqlStatement.getDelimiter();
            }
            this.log(output);
        }
        super.logStatementExecution(sqlStatement);
    }

    @Override
    protected void handleException(Results results, SqlScript sqlScript, SqlStatement sqlStatement) {
        if (this.suppressErrors) {
            for (Error error : results.getErrors()) {
                if (error.isHandled()) continue;
                LOG.warn("DB error ignored (Code: " + error.getCode() + ", State: " + error.getState() + "): " + error.getMessage());
                error.setHandled(true);
            }
            return;
        }
        if (this.spoolData != null) {
            try {
                this.spoolData.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), e);
            }
        }
        super.handleException(results, sqlScript, sqlStatement);
    }

    @Override
    protected void handleResults(Results results, JdbcTemplate jdbcTemplate) {
        if (results instanceof OracleResults) {
            OracleResults oracleResults = (OracleResults)results;
            if (oracleResults.getLineSize() != null) {
                this.lineSize = oracleResults.getLineSize();
            }
            if (oracleResults.getServerOutputSize() != null) {
                this.serverOutputSize = oracleResults.getServerOutputSize();
            }
            if (oracleResults.getServerOutputFormat() != null) {
                this.serverOutputFormat = oracleResults.getServerOutputFormat();
            }
            if (oracleResults.getServerOutput() != null) {
                this.serverOutput = oracleResults.getServerOutput();
            }
            if (oracleResults.getSuppressErrors() != null) {
                this.suppressErrors = oracleResults.getSuppressErrors();
            }
            if (oracleResults.getNullText() != null) {
                this.nullText = oracleResults.getNullText();
            }
            if (oracleResults.getEcho() != null) {
                this.echo = oracleResults.getEcho();
            }
            if (oracleResults.getHeading() != null) {
                this.heading = oracleResults.getHeading();
            }
            if (oracleResults.getTermOut() != null) {
                this.termOut = oracleResults.getTermOut();
            }
            if (oracleResults.getTime() != null) {
                this.time = oracleResults.getTime();
            }
            if (oracleResults.getTiming() != null) {
                this.timing = oracleResults.getTiming();
            }
            if (oracleResults.getFeedback() != null) {
                this.feedback = oracleResults.getFeedback();
            }
            if (oracleResults.getSpoolData() != null) {
                this.spoolData = oracleResults.getSpoolData();
            }
        }
        if (this.serverOutput && (this.termOut || this.depth == 0)) {
            block5: for (String line : this.getServerOutput(jdbcTemplate)) {
                switch (this.serverOutputFormat) {
                    case WRAPPED: {
                        this.log("DB: " + StringUtils.wrap(line, this.lineSize));
                        continue block5;
                    }
                    case WORD_WRAPPED: {
                        this.log("DB: " + StringUtils.wordWrap(line, this.lineSize));
                        continue block5;
                    }
                    case TRUNCATED: {
                        this.log("DB: " + StringUtils.trimOrPad(line, this.lineSize).trim());
                        continue block5;
                    }
                }
                throw new FlywayException("Unknown SERVEROUTPUT FORMAT: " + (Object)((Object)this.serverOutputFormat));
            }
        }
        super.handleResults(results, jdbcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getServerOutput(JdbcTemplate jdbcTemplate) {
        ArrayList<String> result = new ArrayList<String>();
        CallableStatement stmt = null;
        try {
            stmt = jdbcTemplate.getConnection().prepareCall("DECLARE   num INTEGER := 65536;BEGIN   dbms_output.get_lines(?, num);END;");
            stmt.registerOutParameter(1, 2003, "DBMSOUTPUT_LINESARRAY");
            stmt.execute();
            Array array = null;
            try {
                array = stmt.getArray(1);
                for (Object line : (Object[])array.getArray()) {
                    if (line == null) continue;
                    result.add(line.toString());
                }
            }
            finally {
                if (array != null) {
                    array.free();
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new FlywaySqlException("Unable to get server output", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeStatement(stmt);
                throw throwable;
            }
        }
        JdbcUtils.closeStatement(stmt);
        return result;
    }

    @Override
    protected void outputQueryResult(Result result) {
        if (this.outputQueryResults && result.getColumns() != null) {
            this.log(new AsciiTable(result.getColumns(), result.getData(), this.heading, this.nullText, "No rows returned").render());
        }
        if (!this.termOut && this.depth > 0) {
            return;
        }
        this.logRowSelectedFeedback(result);
        this.logRowUpdatedFeedback(result);
    }

    private void logRowUpdatedFeedback(Result result) {
        if (result.getSql() == null) {
            return;
        }
        String sql = result.getSql().toLowerCase(Locale.ENGLISH);
        if (sql.contains("update") || sql.contains("delete") || sql.contains("insert")) {
            this.logRowFeedback("updated", result.getUpdateCount());
        }
    }

    private void logRowSelectedFeedback(Result result) {
        if (result.getColumns() == null) {
            return;
        }
        this.logRowFeedback("selected", result.getData().size());
    }

    private void logRowFeedback(String message, long quantity) {
        if (this.feedback > 0) {
            if (quantity == 0L) {
                this.log("no rows " + message);
            } else if ((long)this.feedback <= quantity) {
                if (quantity == 1L) {
                    this.log("1 row " + message + ".");
                } else {
                    this.log(quantity + " rows " + message);
                }
            }
        }
    }

    private void log(String output) {
        if (this.spoolData != null) {
            this.spoolData.write(output);
        } else {
            LOG.info(output);
        }
    }

    public boolean isServerOutput() {
        return this.serverOutput;
    }

    public String getServerOutputSize() {
        return this.serverOutputSize;
    }

    public ServerOutputFormat getServerOutputFormat() {
        return this.serverOutputFormat;
    }

    public String getNullText() {
        return this.nullText;
    }

    public int getFeedback() {
        return this.feedback;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public boolean isHeading() {
        return this.heading;
    }

    public boolean isTermOut() {
        return this.termOut;
    }

    public boolean isTime() {
        return this.time;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public SQLPlusSpoolData getSpoolData() {
        return this.spoolData;
    }
}

