/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.pro.SQLPlusPlaceholderProvider;

public class SQLPlusPlaceholderReplacingReader
extends FilterReader {
    private static final Log LOG = LogFactory.getLog(SQLPlusPlaceholderReplacingReader.class);
    private final SQLPlusPlaceholderProvider placeholderProvider;
    private StringBuilder buffer = new StringBuilder();
    private String markBuffer;
    private String original;
    private String replacement;
    private int replacementPos;
    private int lastRead = -1;
    private String markOriginal;
    private String markReplacement;
    private int markReplacementPos;
    private int markLastRead;

    public SQLPlusPlaceholderReplacingReader(SQLPlusPlaceholderProvider placeholderProvider, Reader in) {
        super(in);
        this.placeholderProvider = placeholderProvider;
    }

    @Override
    public int read() throws IOException {
        if (this.replacement == null) {
            StringBuilder result;
            block9: {
                int r;
                int c;
                if (this.buffer.length() > 0 && (c = this.processBuffer()) >= -1) {
                    return c;
                }
                do {
                    r = this.lastRead == -1 ? super.read() : this.lastRead;
                    this.lastRead = -1;
                    if (r == -1) break;
                    this.buffer.append((char)r);
                } while (this.placeholderProvider.isDefineOn() && this.placeholderProvider.isEscapeOn() && (char)r == this.placeholderProvider.getEscapeChar());
                int c2 = this.processBuffer();
                if (c2 >= -1) {
                    return c2;
                }
                this.buffer = new StringBuilder();
                result = new StringBuilder();
                while (true) {
                    this.lastRead = this.in.read();
                    if (this.lastRead == -1) break block9;
                    char c1 = (char)this.lastRead;
                    if (!this.isPlaceholderNamePart(c1)) break;
                    result.append(c1);
                }
                if (result.length() == 0) {
                    return r;
                }
            }
            boolean onlyPlaceholder = result.length() == 0 || this.isPlaceholderNamePart(result.charAt(result.length() - 1));
            String placeholder = onlyPlaceholder ? result.toString() : result.substring(0, result.length() - 1);
            this.original = this.placeholderProvider.getDefineChar() + placeholder;
            this.replacement = this.placeholderProvider.getPlaceholderReplacements().get(placeholder.toLowerCase(Locale.ENGLISH));
            if (this.replacement == null) {
                throw new FlywayException("No value provided for variable substitution: " + this.original + ".  Check your configuration. If this is not a SQL*PLus variable intended to be substituted (eg. in a string literal), then you will need to add SET DEFINE OFF in the script beforehand.");
            }
        }
        char result = this.replacement.charAt(this.replacementPos);
        ++this.replacementPos;
        if (this.replacementPos >= this.replacement.length()) {
            if (this.placeholderProvider.isVerifyOn()) {
                LOG.info("old   1: " + this.original.trim());
                LOG.info("new   1: " + this.replacement.trim());
            }
            this.original = null;
            this.replacement = null;
            this.replacementPos = 0;
        }
        return result;
    }

    private int processBuffer() {
        if (this.buffer.length() == 0) {
            return -1;
        }
        char c = this.buffer.charAt(0);
        if (!this.placeholderProvider.isDefineOn()) {
            this.buffer.deleteCharAt(0);
            return c;
        }
        char escapeChar = this.placeholderProvider.getEscapeChar();
        char defineChar = this.placeholderProvider.getDefineChar();
        if (c == escapeChar) {
            this.buffer.deleteCharAt(0);
            if (!this.placeholderProvider.isEscapeOn() || this.buffer.length() == 0) {
                return c;
            }
            c = this.buffer.charAt(0);
            if (c == defineChar || c == escapeChar) {
                this.buffer.deleteCharAt(0);
                return c;
            }
            return escapeChar;
        }
        if (c != defineChar) {
            this.buffer.deleteCharAt(0);
            return c;
        }
        return -2;
    }

    private boolean isPlaceholderNamePart(char c1) {
        return c1 == '_' || c1 >= 'A' && c1 <= 'Z' || c1 >= 'a' && c1 <= 'z' || c1 >= '0' && c1 <= '9';
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = 0;
        for (int i = 0; i < len; ++i) {
            int r = this.read();
            if (r == -1) {
                return count == 0 ? -1 : count;
            }
            cbuf[off + i] = (char)r;
            ++count;
        }
        return count;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        this.markBuffer = this.buffer.toString();
        this.markOriginal = this.original;
        this.markReplacement = this.replacement;
        this.markReplacementPos = this.replacementPos;
        this.markLastRead = this.lastRead;
        super.mark(readAheadLimit + this.placeholderProvider.getReadAheadLimitAdjustment() + 1);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.buffer = new StringBuilder(this.markBuffer);
        this.original = this.markOriginal;
        this.replacement = this.markReplacement;
        this.replacementPos = this.markReplacementPos;
        this.lastRead = this.markLastRead;
    }
}

