/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.pro;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.OracleSqlScriptExecutor;

public class SQLPlusSpoolData
implements Closeable {
    private static final Log LOG = LogFactory.getLog(OracleSqlScriptExecutor.class);
    private final String filePath;
    private PrintWriter printWriter;

    public SQLPlusSpoolData(String filePath, boolean append) {
        if (filePath == null) {
            throw new IllegalArgumentException("SQLPlusSpoolData: filePath null");
        }
        this.filePath = filePath;
        File file = new File(filePath);
        if (!file.exists()) {
            File parentFile = file.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new FlywayException("Failed to create SPOOL output file " + filePath, e);
            }
        }
        try {
            FileWriter fileWriter = new FileWriter(filePath, append);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            this.printWriter = new PrintWriter(bufferedWriter);
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new FlywayException("Failed to open SPOOL output file " + filePath, e);
        }
    }

    public void write(String output) {
        this.printWriter.write(output);
        this.printWriter.write(System.lineSeparator());
        this.printWriter.flush();
    }

    public void printFileContents() throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(this.filePath));){
            String line;
            while ((line = br.readLine()) != null) {
                LOG.info(line);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        this.printWriter = null;
    }

    public String getFilePath() {
        return this.filePath;
    }
}

