/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.DatabaseTypeRegister;
import org.flywaydb.core.internal.database.base.DatabaseType;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.JdbcUtils;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.jdbc.pro.DryRunJdbcProxies;
import org.flywaydb.core.internal.util.ExceptionUtils;

public class JdbcConnectionFactory {
    private static final Log LOG = LogFactory.getLog(JdbcConnectionFactory.class);
    private final DataSource dataSource;
    private final int connectRetries;
    private final DatabaseType databaseType;
    private final String jdbcUrl;
    private final String driverInfo;
    private final String productName;
    private Connection firstConnection;
    private ConnectionInitializer connectionInitializer;
    private final StatementInterceptor statementInterceptor;
    private final boolean supportsBatch;

    public JdbcConnectionFactory(DataSource dataSource, int connectRetries, StatementInterceptor statementInterceptor) {
        this.dataSource = dataSource;
        this.connectRetries = connectRetries;
        this.firstConnection = JdbcUtils.openConnection(dataSource, connectRetries);
        this.databaseType = DatabaseTypeRegister.getDatabaseTypeForConnection(this.firstConnection);
        DatabaseMetaData databaseMetaData = JdbcUtils.getDatabaseMetaData(this.firstConnection);
        this.jdbcUrl = JdbcConnectionFactory.getJdbcUrl(databaseMetaData);
        this.driverInfo = JdbcConnectionFactory.getDriverInfo(databaseMetaData);
        this.productName = JdbcUtils.getDatabaseProductName(databaseMetaData);
        this.supportsBatch = this.determineBatchSupport(databaseMetaData);
        this.statementInterceptor = statementInterceptor;
    }

    public void setConnectionInitializer(ConnectionInitializer connectionInitializer) {
        this.connectionInitializer = connectionInitializer;
    }

    private boolean determineBatchSupport(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.supportsBatchUpdates();
        }
        catch (SQLException e) {
            LOG.debug("Unable to check whether batch updates are supported:\n" + ExceptionUtils.toMessage(e));
            return false;
        }
    }

    public boolean isSupportsBatch() {
        return this.supportsBatch;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getDriverInfo() {
        return this.driverInfo;
    }

    public String getProductName() {
        return this.productName;
    }

    public Connection openConnection() throws FlywayException {
        Connection connection = this.firstConnection == null ? JdbcUtils.openConnection(this.dataSource, this.connectRetries) : this.firstConnection;
        this.firstConnection = null;
        if (this.connectionInitializer != null) {
            this.connectionInitializer.initialize(this, connection);
        }
        if (this.statementInterceptor != null) {
            if (this.databaseType.supportsReadOnlyTransactions()) {
                try {
                    connection.setReadOnly(true);
                }
                catch (SQLException e) {
                    throw new FlywaySqlException("Unable to switch connection to read-only", e);
                }
            }
            return DryRunJdbcProxies.createConnectionProxy(connection, this.statementInterceptor);
        }
        return connection;
    }

    private static String getJdbcUrl(DatabaseMetaData databaseMetaData) {
        String url;
        try {
            url = databaseMetaData.getURL();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to retrieve the JDBC connection URL!", e);
        }
        if (url == null) {
            return "";
        }
        return JdbcConnectionFactory.filterUrl(url);
    }

    static String filterUrl(String url) {
        int questionMark = url.indexOf("?");
        if (questionMark >= 0 && !url.contains("?databaseName=")) {
            url = url.substring(0, questionMark);
        }
        url = url.replaceAll("://.*:.*@", "://");
        return url;
    }

    private static String getDriverInfo(DatabaseMetaData databaseMetaData) {
        try {
            return databaseMetaData.getDriverName() + " " + databaseMetaData.getDriverVersion();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to read database driver info: " + e.getMessage(), e);
        }
    }

    public static interface ConnectionInitializer {
        public void initialize(JdbcConnectionFactory var1, Connection var2);
    }
}

