/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.com.send.parameters;

import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.mariadb.jdbc.internal.ColumnType;
import org.mariadb.jdbc.internal.com.send.parameters.ParameterHolder;
import org.mariadb.jdbc.internal.io.output.PacketOutputStream;
import org.mariadb.jdbc.util.Options;

public class DateParameter
implements Cloneable,
ParameterHolder {
    private final Date date;
    private final TimeZone timeZone;
    private final Options options;

    public DateParameter(Date date, TimeZone timeZone, Options options) {
        this.date = date;
        this.timeZone = timeZone;
        this.options = options;
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        os.write(39);
        os.write(this.dateByteFormat());
        os.write(39);
    }

    private byte[] dateByteFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.options.useLegacyDatetimeCode || this.options.maximizeMysqlCompatibility) {
            sdf.setTimeZone(Calendar.getInstance().getTimeZone());
        } else {
            sdf.setTimeZone(this.timeZone);
        }
        return sdf.format(this.date).getBytes();
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 16;
    }

    @Override
    public void writeBinary(PacketOutputStream pos) throws IOException {
        Calendar calendar = Calendar.getInstance(this.timeZone);
        calendar.setTimeInMillis(this.date.getTime());
        pos.write(7);
        pos.writeShort((short)calendar.get(1));
        pos.write((byte)(calendar.get(2) + 1 & 0xFF));
        pos.write((byte)(calendar.get(5) & 0xFF));
        pos.write(0);
        pos.write(0);
        pos.write(0);
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.DATE;
    }

    @Override
    public String toString() {
        return "'" + this.date.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean isLongData() {
        return false;
    }
}

