/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.database.oracle.teams;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.oracle.teams.AbstractSQLPlusParsedSqlStatement;
import org.flywaydb.core.internal.database.oracle.teams.SQLPlusPlaceholderProvider;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.jdbc.Results;
import org.flywaydb.core.internal.parser.Token;
import org.flywaydb.core.internal.parser.TokenType;
import org.flywaydb.core.internal.sqlscript.SqlScriptExecutor;
import org.flywaydb.core.internal.util.StringUtils;

public class SQLPlusDefineParsedSqlStatement
extends AbstractSQLPlusParsedSqlStatement {
    private static final Log LOG = LogFactory.getLog(SQLPlusDefineParsedSqlStatement.class);
    private final Map<String, String> varsToPrint = new TreeMap<String, String>();

    public SQLPlusDefineParsedSqlStatement(int pos, int line, int col, String sql, List<Token> tokens, SQLPlusPlaceholderProvider sqlPlusPlaceholderProvider) {
        super(pos, line, col, sql);
        String noDefine;
        int idx;
        Token token2;
        String noComment = sql.replace("\r\n", "\n").replace("\n", "");
        ArrayList<Token> reversedTokens = new ArrayList<Token>(tokens);
        Collections.reverse(reversedTokens);
        Iterator<Object> iterator = reversedTokens.iterator();
        while (iterator.hasNext() && ((token2 = (Token)iterator.next()).getType() == TokenType.COMMENT || token2.getType() == TokenType.BLANK_LINES)) {
            noComment = noComment.substring(0, token2.getPos() - 1);
        }
        for (Token token2 : tokens) {
            if (token2.getType() == TokenType.COMMENT) {
                noComment = noComment.substring(token2.getText().length());
                continue;
            }
            if (token2.getType() == TokenType.BLANK_LINES) continue;
        }
        if ((idx = (noDefine = noComment.replaceFirst("(?i)(DEF(INE)?)[ ]?", "")).indexOf("=")) > 0) {
            String varName = noDefine.substring(0, idx).trim();
            String varValue = noDefine.substring(idx + 1).trim();
            if (varValue.startsWith("'") && varValue.endsWith("'")) {
                varValue = varValue.substring(1, varValue.length() - 1);
            }
            sqlPlusPlaceholderProvider.define(varName, varValue);
        } else {
            String varName = noDefine.trim();
            if (StringUtils.hasLength(varName)) {
                this.varsToPrint.put(varName, sqlPlusPlaceholderProvider.getPlaceholderReplacements().get(varName));
            } else {
                this.varsToPrint.putAll(sqlPlusPlaceholderProvider.getPlaceholderReplacements());
            }
        }
    }

    @Override
    public Results execute(JdbcTemplate jdbcTemplate, SqlScriptExecutor sqlScriptExecutor) {
        for (Map.Entry<String, String> entry : this.varsToPrint.entrySet()) {
            if (entry.getValue() == null) {
                LOG.warn("SP2-0135: symbol " + entry.getKey() + " is UNDEFINED");
                continue;
            }
            LOG.info("DEFINE " + entry.getKey() + " = \"" + entry.getValue() + "\" (CHAR)");
        }
        return new Results();
    }
}

