/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.jdbc;

import com.google.cloud.spanner.connection.Connection;
import com.google.cloud.spanner.connection.ConnectionOptions;
import com.google.cloud.spanner.jdbc.AbstractJdbcWrapper;
import com.google.cloud.spanner.jdbc.CloudSpannerJdbcConnection;
import com.google.cloud.spanner.jdbc.JdbcDatabaseMetaData;
import com.google.cloud.spanner.jdbc.JdbcPreconditions;
import com.google.cloud.spanner.jdbc.JdbcSqlException;
import com.google.cloud.spanner.jdbc.JdbcSqlExceptionFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.rpc.Code;
import java.sql.CallableStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Properties;
import java.util.concurrent.Executor;

abstract class AbstractJdbcConnection
extends AbstractJdbcWrapper
implements CloudSpannerJdbcConnection {
    private static final String CALLABLE_STATEMENTS_UNSUPPORTED = "Callable statements are not supported";
    private static final String ONLY_SERIALIZABLE = "Only isolation level TRANSACTION_SERIALIZABLE is supported";
    private static final String ONLY_CLOSE_ALLOWED = "Only holdability CLOSE_CURSORS_AT_COMMIT is supported";
    private static final String SAVEPOINTS_UNSUPPORTED = "Savepoints are not supported";
    private static final String SQLXML_UNSUPPORTED = "SQLXML is not supported";
    private static final String STRUCTS_UNSUPPORTED = "Structs are not supported";
    private static final String ABORT_UNSUPPORTED = "Abort is not supported";
    private static final String NETWORK_TIMEOUT_UNSUPPORTED = "Network timeout is not supported";
    static final String CLIENT_INFO_NOT_SUPPORTED = "Cloud Spanner does not support ClientInfo property %s";
    private final String connectionUrl;
    private final ConnectionOptions options;
    private final Connection spanner;
    private final Properties clientInfo;
    private SQLWarning firstWarning = null;
    private SQLWarning lastWarning = null;

    AbstractJdbcConnection(String connectionUrl, ConnectionOptions options) throws SQLException {
        this.connectionUrl = connectionUrl;
        this.options = options;
        this.spanner = options.getConnection();
        this.clientInfo = new Properties(JdbcDatabaseMetaData.getDefaultClientInfoProperties());
    }

    Connection getSpannerConnection() {
        return this.spanner;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    ConnectionOptions getConnectionOptions() {
        return this.options;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return (CallableStatement)this.checkClosedAndThrowUnsupported(CALLABLE_STATEMENTS_UNSUPPORTED);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return (CallableStatement)this.checkClosedAndThrowUnsupported(CALLABLE_STATEMENTS_UNSUPPORTED);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return (CallableStatement)this.checkClosedAndThrowUnsupported(CALLABLE_STATEMENTS_UNSUPPORTED);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkArgument(level == 8 || level == 4 || level == 1 || level == 2, "Not a transaction isolation level");
        JdbcPreconditions.checkSqlFeatureSupported(level == 8, ONLY_SERIALIZABLE);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 8;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.checkClosed();
        JdbcPreconditions.checkArgument(holdability == 1 || holdability == 2, "Not a holdability value");
        JdbcPreconditions.checkSqlFeatureSupported(holdability == 2, ONLY_CLOSE_ALLOWED);
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return 2;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.firstWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.firstWarning = null;
        this.lastWarning = null;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return (Savepoint)this.checkClosedAndThrowUnsupported(SAVEPOINTS_UNSUPPORTED);
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return (Savepoint)this.checkClosedAndThrowUnsupported(SAVEPOINTS_UNSUPPORTED);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosedAndThrowUnsupported(SAVEPOINTS_UNSUPPORTED);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosedAndThrowUnsupported(SAVEPOINTS_UNSUPPORTED);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return (SQLXML)this.checkClosedAndThrowUnsupported(SQLXML_UNSUPPORTED);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        Properties supported = null;
        try {
            this.checkClosed();
            supported = JdbcDatabaseMetaData.getDefaultClientInfoProperties();
        }
        catch (SQLException e) {
            if (e instanceof JdbcSqlException) {
                throw JdbcSqlExceptionFactory.clientInfoException(e.getMessage(), ((JdbcSqlException)((Object)e)).getCode());
            }
            throw JdbcSqlExceptionFactory.clientInfoException(e.getMessage(), Code.UNKNOWN);
        }
        if (value == null) {
            throw JdbcSqlExceptionFactory.clientInfoException("Null-value is not allowed for client info.", Code.INVALID_ARGUMENT);
        }
        if (value.length() > 63) {
            throw JdbcSqlExceptionFactory.clientInfoException(String.format("Max length of value is %d characters.", 63), Code.INVALID_ARGUMENT);
        }
        if (supported.containsKey(name = name.toUpperCase())) {
            this.clientInfo.setProperty(name, value);
        } else {
            this.pushWarning(new SQLWarning(String.format(CLIENT_INFO_NOT_SUPPORTED, name)));
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkClosed();
        }
        catch (SQLException e) {
            if (e instanceof JdbcSqlException) {
                throw JdbcSqlExceptionFactory.clientInfoException(e.getMessage(), ((JdbcSqlException)((Object)e)).getCode());
            }
            throw JdbcSqlExceptionFactory.clientInfoException(e.getMessage(), Code.UNKNOWN);
        }
        this.clientInfo.clear();
        for (String property : properties.stringPropertyNames()) {
            this.setClientInfo(property, properties.getProperty(property));
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return this.clientInfo.getProperty(name.toUpperCase());
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return (Properties)this.clientInfo.clone();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return (Struct)this.checkClosedAndThrowUnsupported(STRUCTS_UNSUPPORTED);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.checkClosedAndThrowUnsupported(ABORT_UNSUPPORTED);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.checkClosedAndThrowUnsupported(NETWORK_TIMEOUT_UNSUPPORTED);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return (Integer)this.checkClosedAndThrowUnsupported(NETWORK_TIMEOUT_UNSUPPORTED);
    }

    @VisibleForTesting
    void pushWarning(SQLWarning warning) {
        if (this.lastWarning == null) {
            this.firstWarning = warning;
            this.lastWarning = warning;
        } else {
            this.lastWarning.setNextWarning(warning);
            this.lastWarning = warning;
        }
    }
}

