/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.core;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.Key;
import oracle.security.crypto.fips.FIPS_140_2;
import oracle.security.crypto.fips.KeyExportException;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;

public class SymmetricKey
implements SecretKey,
Key {
    private AlgorithmIdentifier a;
    private boolean b = true;
    private byte[] c;

    public SymmetricKey() {
        this(new byte[0]);
    }

    public SymmetricKey(byte[] byArray) {
        this(byArray, null);
    }

    public SymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) {
        this.setBytes(byArray);
        this.a = algorithmIdentifier;
    }

    public AlgorithmIdentifier getAlgID() {
        FIPS_140_2.assertReadyState();
        return this.a;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) {
        FIPS_140_2.assertReadyState();
        this.a = algorithmIdentifier;
    }

    @Override
    public String getAlgorithm() {
        FIPS_140_2.assertReadyState();
        if (this.a != null) {
            ASN1ObjectID aSN1ObjectID = this.a.getOID();
            if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID())) {
                return "DES";
            }
            if (aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
                return "DES-EDE";
            }
            if (aSN1ObjectID.equals(AlgID.aes128_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes128_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes192_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes192_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes256_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes256_ECB.getOID())) {
                return "AES";
            }
            if (aSN1ObjectID.equals(AlgID.RC4.getOID())) {
                return "RC4";
            }
            if (aSN1ObjectID.equals(AlgID.BLOWFISH.getOID()) || aSN1ObjectID.equals(AlgID.blowfishCBC.getOID()) || aSN1ObjectID.equals(AlgID.blowfishECB.getOID())) {
                return "Blowfish";
            }
            if (aSN1ObjectID.equals(AlgID.RC2_CBC.getOID())) {
                return "RC2";
            }
            return this.a.toString();
        }
        return null;
    }

    public int keySize() {
        FIPS_140_2.assertReadyState();
        return this.c.length;
    }

    public void setBytes(byte[] byArray) {
        FIPS_140_2.assertReadyState();
        this.erase();
        if (byArray != null) {
            this.c = (byte[])byArray.clone();
        }
    }

    public byte[] getBytes() {
        this.f();
        return (byte[])this.d().clone();
    }

    byte[] d() {
        FIPS_140_2.assertReadyState();
        return this.c;
    }

    @Override
    public byte[] getEncoded() {
        return this.getBytes();
    }

    byte[] e() {
        return this.d();
    }

    @Override
    public int getBitLength() {
        FIPS_140_2.assertReadyState();
        if (this.c == null) {
            return 0;
        }
        return 8 * this.c.length;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public boolean equals(Object object) {
        FIPS_140_2.assertReadyState();
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SymmetricKey)) {
            return false;
        }
        return Utils.areEqual(((SymmetricKey)object).d(), this.d());
    }

    @Override
    public void erase() {
        if (this.c != null) {
            Utils.setArray(this.c, (byte)0);
            this.c = null;
        }
    }

    public void finalize() {
        this.erase();
    }

    public String toString() {
        FIPS_140_2.assertReadyState();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append("algID=");
        stringBuffer.append(String.valueOf(this.a));
        stringBuffer.append(", ");
        stringBuffer.append("bitLength=");
        stringBuffer.append(this.getBitLength());
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    @Override
    public Object clone() {
        FIPS_140_2.assertReadyState();
        SymmetricKey symmetricKey = new SymmetricKey();
        try {
            if (this.a != null) {
                symmetricKey.a = new AlgorithmIdentifier(Utils.toStream(this.a));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        if (this.c != null) {
            symmetricKey.c = (byte[])this.c.clone();
        }
        symmetricKey.b = this.b;
        return symmetricKey;
    }

    public void setAllowExport(boolean bl) {
        this.b = bl;
    }

    @Override
    public boolean getAllowExport() {
        return this.b;
    }

    protected void f() {
        if (!this.getAllowExport() || !FIPS_140_2.getAllowKeyExport()) {
            throw new KeyExportException("Plaintext key export not allowed");
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FIPS_140_2.assertReadyState();
        this.f();
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        if (this.a != null) {
            aSN1Sequence.addElement(this.a);
        }
        aSN1Sequence.addElement(new ASN1OctetString(this.c));
        objectOutput.writeObject(Utils.toBytes(aSN1Sequence));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        FIPS_140_2.assertReadyState();
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(new UnsyncByteArrayInputStream(byArray));
        this.a = aSN1SequenceInputStream.getCurrentTag() == 16 ? new AlgorithmIdentifier(aSN1SequenceInputStream) : null;
        this.c = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
    }

    static {
        FIPS_140_2.powerUpSelfTest();
    }
}

