/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.community.database.ignite.thin;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.flywaydb.community.database.ignite.thin.IgniteThinConnection;
import org.flywaydb.community.database.ignite.thin.IgniteThinDatabase;
import org.flywaydb.community.database.ignite.thin.IgniteThinTable;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.internal.database.base.Database;
import org.flywaydb.core.internal.database.base.Schema;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.flywaydb.core.internal.util.StringUtils;

public class IgniteThinSchema
extends Schema<IgniteThinDatabase, IgniteThinTable> {
    private static final Log LOG = LogFactory.getLog(IgniteThinSchema.class);

    IgniteThinSchema(JdbcTemplate jdbcTemplate, IgniteThinDatabase database, String name) {
        super(jdbcTemplate, (Database)database, name);
    }

    protected boolean doExists() throws SQLException {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM INFORMATION_SCHEMA.SCHEMATA WHERE SCHEMA_NAME=?", new String[]{this.name}) > 0;
    }

    protected boolean doEmpty() {
        return ((IgniteThinTable[])this.allTables()).length == 0;
    }

    protected void doCreate() throws SQLException {
        this.jdbcTemplate.execute("CREATE SCHEMA " + ((IgniteThinDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP SCHEMA " + ((IgniteThinDatabase)this.database).quote(new String[]{this.name}), new Object[0]);
    }

    protected void doClean() throws SQLException {
        for (IgniteThinTable igniteThinTable : (IgniteThinTable[])this.allTables()) {
            igniteThinTable.drop();
        }
        List<String> sequenceNames = this.listObjectNames("SEQUENCE", "IS_GENERATED = false");
        for (String statement : this.generateDropStatements("SEQUENCE", sequenceNames)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        List<String> constantNames = this.listObjectNames("CONSTANT", "");
        for (String string : this.generateDropStatements("CONSTANT", constantNames)) {
            this.jdbcTemplate.execute(string, new Object[0]);
        }
        List aliasNames = this.jdbcTemplate.queryForStringList("SELECT ALIAS_NAME FROM INFORMATION_SCHEMA.FUNCTION_ALIASES WHERE ALIAS_SCHEMA = ?", new String[]{this.name});
        for (String statement : this.generateDropStatements("ALIAS", aliasNames)) {
            this.jdbcTemplate.execute(statement, new Object[0]);
        }
        List<String> list = this.listObjectNames("DOMAIN", "");
        if (!list.isEmpty()) {
            if (this.name.equals(((IgniteThinConnection)((IgniteThinDatabase)this.database).getMainConnection()).getCurrentSchema().getName())) {
                for (String statement : this.generateDropStatementsForCurrentSchema("DOMAIN", list)) {
                    this.jdbcTemplate.execute(statement, new Object[0]);
                }
            } else {
                LOG.error("Unable to drop DOMAIN objects in schema " + ((IgniteThinDatabase)this.database).quote(new String[]{this.name}));
            }
        }
    }

    private List<String> generateDropStatements(String objectType, List<String> objectNames) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + ((IgniteThinDatabase)this.database).quote(new String[]{this.name, objectName});
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> generateDropStatementsForCurrentSchema(String objectType, List<String> objectNames) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + ((IgniteThinDatabase)this.database).quote(new String[]{objectName});
            statements.add(dropStatement);
        }
        return statements;
    }

    protected IgniteThinTable[] doAllTables() throws SQLException {
        List<String> tableNames = this.listObjectNames("TABLE", "TABLE_TYPE = 'TABLE' AND TABLE_NAME !='__T0'");
        IgniteThinTable[] tables = new IgniteThinTable[tableNames.size()];
        for (int i = 0; i < tableNames.size(); ++i) {
            tables[i] = new IgniteThinTable(this.jdbcTemplate, (IgniteThinDatabase)this.database, this, tableNames.get(i));
        }
        return tables;
    }

    private List<String> listObjectNames(String objectType, String querySuffix) throws SQLException {
        String query = "SELECT " + objectType + "_NAME FROM INFORMATION_SCHEMA." + objectType + "S WHERE " + objectType + "_SCHEMA = ?";
        if (StringUtils.hasLength((String)querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForStringList(query, new String[]{this.name});
    }

    public Table getTable(String tableName) {
        return new IgniteThinTable(this.jdbcTemplate, (IgniteThinDatabase)this.database, this, tableName);
    }
}

