/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.DatabaseManager;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.Iterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;

public abstract class ScriptWriterBase
implements Runnable {
    Database database;
    String outFile;
    OutputStream fileStreamOut;
    FileAccess.FileSync outDescriptor;
    int tableRowCount;
    HsqlNameManager.HsqlName schemaToLog;
    boolean isClosed;
    boolean isCompressed;
    boolean isCrypt;
    boolean isUserScript;
    boolean includeCachedData;
    boolean includeIndexRoots;
    boolean includeTableInit;
    long byteCount;
    long lineCount;
    volatile boolean needsSync;
    private int syncCount;
    static final int INSERT = 0;
    static final int INSERT_WITH_SCHEMA = 1;
    Session currentSession;
    public static final String[] LIST_SCRIPT_FORMATS = new String[]{"TEXT", "BINARY", null, "COMPRESSED"};
    private Object timerTask;
    protected volatile int writeDelay = 60000;

    ScriptWriterBase(Database database, OutputStream outputStream, FileAccess.FileSync fileSync, boolean bl) {
        this.initBuffers();
        this.database = database;
        this.includeCachedData = bl;
        this.includeIndexRoots = !bl;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.fileStreamOut = new BufferedOutputStream(outputStream, 16384);
        this.outDescriptor = fileSync;
    }

    ScriptWriterBase(Database database, String string, boolean bl, boolean bl2, boolean bl3) {
        this.initBuffers();
        boolean bl4 = false;
        bl4 = bl3 ? FileUtil.getFileUtil().exists(string) : database.logger.getFileAccess().isStreamElement(string);
        if (bl4 && bl2) {
            throw Error.error(452, string + " already exists");
        }
        this.database = database;
        this.isUserScript = bl3;
        this.includeCachedData = bl;
        this.includeIndexRoots = !bl;
        this.outFile = string;
        this.currentSession = this.database.sessionManager.getSysSession();
        this.schemaToLog = this.currentSession.loggedSchema = this.currentSession.currentSchema;
        this.openFile();
    }

    public void setIncludeIndexRoots(boolean bl) {
        this.includeIndexRoots = bl;
    }

    public void setIncludeCachedData(boolean bl) {
        this.includeCachedData = bl;
    }

    public void setIncludeTableInit(boolean bl) {
        this.includeTableInit = bl;
    }

    protected abstract void initBuffers();

    public void sync() {
        if (this.isClosed) {
            return;
        }
        if (this.needsSync) {
            this.forceSync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceSync() {
        if (this.isClosed) {
            return;
        }
        this.needsSync = false;
        OutputStream outputStream = this.fileStreamOut;
        synchronized (outputStream) {
            try {
                this.fileStreamOut.flush();
                this.outDescriptor.sync();
                ++this.syncCount;
            }
            catch (IOException iOException) {
                this.database.logger.logWarningEvent("ScriptWriter synch error: ", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.stop();
        if (this.isClosed) {
            return;
        }
        try {
            OutputStream outputStream = this.fileStreamOut;
            synchronized (outputStream) {
                this.finishStream();
                this.forceSync();
                this.fileStreamOut.close();
                this.outDescriptor = null;
                this.isClosed = true;
            }
        }
        catch (IOException iOException) {
            throw Error.error(452);
        }
        this.byteCount = 0L;
        this.lineCount = 0L;
    }

    public long size() {
        return this.byteCount;
    }

    public void writeAll() {
        this.writeDDL();
        this.writeExistingData(true);
    }

    protected void openFile() {
        try {
            FileUtil fileUtil = this.isUserScript ? FileUtil.getFileUtil() : this.database.logger.getFileAccess();
            OutputStream outputStream = fileUtil.openOutputStreamElementAppend(this.outFile);
            this.outDescriptor = fileUtil.getFileSync(outputStream);
            this.fileStreamOut = outputStream;
            this.fileStreamOut = new BufferedOutputStream(outputStream, 16384);
        }
        catch (IOException iOException) {
            throw Error.error(iOException, 452, 26, new String[]{iOException.toString(), this.outFile});
        }
    }

    protected void finishStream() {
    }

    public void writeDDL() {
        try {
            Result result = this.database.getScript(this.includeIndexRoots);
            this.writeSingleColumnResult(result);
        }
        catch (HsqlException hsqlException) {
            this.close();
            throw hsqlException;
        }
    }

    public void writeExistingData(boolean bl) {
        this.currentSession.loggedSchema = null;
        String[] stringArray = this.database.schemaManager.getSchemaNamesArray();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (!bl && "SYSTEM_LOBS".equals(string)) continue;
            Iterator iterator = this.database.schemaManager.databaseObjectIterator(string, 3);
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                boolean bl2 = false;
                switch (table.getTableType()) {
                    case 4: {
                        bl2 = true;
                        break;
                    }
                    case 5: {
                        bl2 = this.includeCachedData;
                        break;
                    }
                    case 7: {
                        boolean bl3 = bl2 = this.includeCachedData && !table.isDataReadOnly();
                    }
                }
                if (!bl2) continue;
                this.writeTableData(table);
            }
        }
        this.writeDataTerm();
    }

    public void writeVersioningData(TimestampData timestampData) {
        this.currentSession.loggedSchema = null;
        String[] stringArray = this.database.schemaManager.getSchemaNamesArray();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            Iterator iterator = this.database.schemaManager.databaseObjectIterator(string, 3);
            while (iterator.hasNext()) {
                Table table = (Table)iterator.next();
                if (!table.isSystemVersioned() || !table.hasPrimaryKey()) continue;
                this.writeTableVersionData(table, timestampData);
            }
        }
        this.writeDataTerm();
    }

    public void writeTableData(Table table) {
        this.schemaToLog = table.getName().schema;
        try {
            this.writeTableInit(table);
            RowIterator rowIterator = table.rowIteratorForScript(table.getRowStore(this.currentSession));
            while (rowIterator.next()) {
                Row row = rowIterator.getCurrentRow();
                this.writeRow(this.currentSession, row, table);
            }
            this.writeTableTerm(table);
        }
        catch (HsqlException hsqlException) {
            this.close();
            throw hsqlException;
        }
    }

    public void writeTableVersionData(Table table, TimestampData timestampData) {
        int n = table.getSystemPeriodStartIndex();
        int n2 = table.getSystemPeriodEndIndex();
        this.schemaToLog = table.getName().schema;
        try {
            this.writeTableInit(table);
            RowIterator rowIterator = table.rowIteratorForScript(table.getRowStore(this.currentSession));
            while (rowIterator.next()) {
                Row row = rowIterator.getCurrentRow();
                TimestampData timestampData2 = (TimestampData)row.getField(n);
                TimestampData timestampData3 = (TimestampData)row.getField(n2);
                if (timestampData2.getSeconds() < timestampData.getSeconds() && (timestampData3.getSeconds() < timestampData.getSeconds() || timestampData3.getSeconds() >= DateTimeType.epochLimitSeconds)) continue;
                this.writeRow(this.currentSession, row, table);
            }
            this.writeTableTerm(table);
        }
        catch (HsqlException hsqlException) {
            this.close();
            throw hsqlException;
        }
    }

    public void writeTableInit(Table table) {
    }

    public void writeTableTerm(Table table) {
    }

    protected void writeSingleColumnResult(Result result) {
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        while (rowSetNavigator.next()) {
            Object[] objectArray = rowSetNavigator.getCurrent();
            this.writeLogStatement(this.currentSession, (String)objectArray[0]);
        }
    }

    public abstract void writeRow(Session var1, Row var2, Table var3);

    protected abstract void writeDataTerm();

    protected abstract void writeSessionIdAndSchema(Session var1);

    public abstract void writeLogStatement(Session var1, String var2);

    public abstract void writeOtherStatement(Session var1, String var2);

    public abstract void writeInsertStatement(Session var1, Row var2, Table var3);

    public abstract void writeDeleteStatement(Session var1, Table var2, Object[] var3);

    public abstract void writeSequenceStatement(Session var1, NumberSequence var2);

    public abstract void writeCommitStatement(Session var1);

    @Override
    public void run() {
        try {
            if (this.writeDelay != 0) {
                this.sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setWriteDelay(int n) {
        this.writeDelay = n;
    }

    public void start() {
        if (this.writeDelay > 0) {
            this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(0L, this.writeDelay, this, false);
        }
    }

    public void stop() {
        if (this.timerTask != null) {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
        }
    }

    public int getWriteDelay() {
        return this.writeDelay;
    }
}

