/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.field;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBClob;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.field.FBBigDecimalField;
import org.firebirdsql.jdbc.field.FBBinaryField;
import org.firebirdsql.jdbc.field.FBBlobField;
import org.firebirdsql.jdbc.field.FBBooleanField;
import org.firebirdsql.jdbc.field.FBCachedBlobField;
import org.firebirdsql.jdbc.field.FBCachedLongVarCharField;
import org.firebirdsql.jdbc.field.FBDateField;
import org.firebirdsql.jdbc.field.FBDoubleField;
import org.firebirdsql.jdbc.field.FBFloatField;
import org.firebirdsql.jdbc.field.FBIntegerField;
import org.firebirdsql.jdbc.field.FBLongField;
import org.firebirdsql.jdbc.field.FBLongVarCharField;
import org.firebirdsql.jdbc.field.FBNullField;
import org.firebirdsql.jdbc.field.FBShortField;
import org.firebirdsql.jdbc.field.FBTimeField;
import org.firebirdsql.jdbc.field.FBTimestampField;
import org.firebirdsql.jdbc.field.FBWorkaroundStringField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.jdbc.field.ObjectConverter;
import org.firebirdsql.jdbc.field.ObjectConverterHolder;
import org.firebirdsql.jdbc.field.TranslatingReader;
import org.firebirdsql.jdbc.field.TypeConversionException;

public abstract class FBField {
    static final String BYTE_CONVERSION_ERROR = "Error converting to byte.";
    static final String SHORT_CONVERSION_ERROR = "Error converting to short.";
    static final String INT_CONVERSION_ERROR = "Error converting to int.";
    static final String LONG_CONVERSION_ERROR = "Error converting to long.";
    static final String FLOAT_CONVERSION_ERROR = "Error converting to float.";
    static final String DOUBLE_CONVERSION_ERROR = "Error converting to double.";
    static final String BIGDECIMAL_CONVERSION_ERROR = "Error converting to big decimal.";
    static final String BIG_INTEGER_CONVERSION_ERROR = "Error converting to BigInteger.";
    static final String BOOLEAN_CONVERSION_ERROR = "Error converting to boolean.";
    static final String STRING_CONVERSION_ERROR = "Error converting to string.";
    static final String OBJECT_CONVERSION_ERROR = "Error converting to object.";
    static final String DATE_CONVERSION_ERROR = "Error converting to date.";
    static final String TIME_CONVERSION_ERROR = "Error converting to time.";
    static final String TIMESTAMP_CONVERSION_ERROR = "Error converting to timestamp.";
    static final String BINARY_STREAM_CONVERSION_ERROR = "Error converting to binary stream.";
    static final String CHARACTER_STREAM_CONVERSION_ERROR = "Error converting to character stream.";
    static final String BYTES_CONVERSION_ERROR = "Error converting to array of bytes.";
    static final String BLOB_CONVERSION_ERROR = "Error converting to Firebird BLOB object";
    static final String CLOB_CONVERSION_ERROR = "Error converting to Firebird CLOB object";
    static final String SQL_TYPE_NOT_SUPPORTED = "SQL type for this field is not yet supported.";
    static final String SQL_ARRAY_NOT_SUPPORTED = "Types.ARRAY: SQL type for this field is not yet supported.";
    static final byte BYTE_NULL_VALUE = 0;
    static final short SHORT_NULL_VALUE = 0;
    static final int INT_NULL_VALUE = 0;
    static final long LONG_NULL_VALUE = 0L;
    static final float FLOAT_NULL_VALUE = 0.0f;
    static final double DOUBLE_NULL_VALUE = 0.0;
    static final boolean BOOLEAN_NULL_VALUE = false;
    static final byte MAX_BYTE_VALUE = 127;
    static final byte MIN_BYTE_VALUE = -128;
    static final short MAX_SHORT_VALUE = Short.MAX_VALUE;
    static final short MIN_SHORT_VALUE = Short.MIN_VALUE;
    static final int MAX_INT_VALUE = Integer.MAX_VALUE;
    static final int MIN_INT_VALUE = Integer.MIN_VALUE;
    static final long MAX_LONG_VALUE = Long.MAX_VALUE;
    static final long MIN_LONG_VALUE = Long.MIN_VALUE;
    static final float MAX_FLOAT_VALUE = Float.MAX_VALUE;
    static final float MIN_FLOAT_VALUE = -3.4028235E38f;
    static final double MAX_DOUBLE_VALUE = Double.MAX_VALUE;
    static final double MIN_DOUBLE_VALUE = -1.7976931348623157E308;
    private static final ObjectConverter OBJECT_CONVERTER = ObjectConverterHolder.INSTANCE.getObjectConverter();
    protected final FieldDescriptor fieldDescriptor;
    private final FieldDataProvider dataProvider;
    protected GDSHelper gdsHelper;
    protected String mappingPath;
    protected int requiredType;
    protected int scale = -1;

    FBField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, int requiredType) throws SQLException {
        if (fieldDescriptor == null) {
            throw new FBSQLException("Cannot create FBField instance with fieldDescriptor null.", "HY009");
        }
        this.fieldDescriptor = fieldDescriptor;
        this.dataProvider = dataProvider;
        this.requiredType = requiredType;
    }

    protected final byte[] getFieldData() {
        return this.dataProvider.getFieldData();
    }

    protected final void setFieldData(byte[] data) {
        this.dataProvider.setFieldData(data);
    }

    protected final ObjectConverter getObjectConverter() {
        return OBJECT_CONVERTER;
    }

    protected final DatatypeCoder getDatatypeCoder() {
        return this.fieldDescriptor.getDatatypeCoder();
    }

    public final boolean isNull() throws SQLException {
        return this.getFieldData() == null;
    }

    public void setNull() {
        this.setFieldData(null);
    }

    public void setConnection(GDSHelper gdsHelper) {
        this.gdsHelper = gdsHelper;
        if (gdsHelper != null) {
            this.mappingPath = gdsHelper.getMappingPath();
        }
    }

    public void setRequiredType(int requiredType) {
        this.requiredType = requiredType;
    }

    public static boolean isType(FieldDescriptor field, int jdbcType) {
        return FBField.isType(field.getType(), field.getSubType(), jdbcType);
    }

    private static boolean isType(int fbType, int subType, int jdbcType) {
        int tempType = fbType & 0xFFFFFFFE;
        switch (tempType) {
            case 540: {
                return jdbcType == 2003;
            }
            case 520: {
                if (subType < 0) {
                    return jdbcType == 2004;
                }
                if (subType == 1) {
                    return jdbcType == -1;
                }
                return jdbcType == -4 || jdbcType == -3 || jdbcType == -2;
            }
            case 530: {
                return false;
            }
            case 480: {
                return jdbcType == 8;
            }
            case 482: {
                return jdbcType == 6;
            }
            case 580: {
                return jdbcType == -5;
            }
            case 496: {
                return jdbcType == 4;
            }
            case 550: {
                return false;
            }
            case 500: {
                return jdbcType == 5;
            }
            case 452: {
                return subType != 1 && jdbcType == 1 || subType == 1 && jdbcType == -2;
            }
            case 510: {
                return jdbcType == 93;
            }
            case 570: {
                return jdbcType == 91;
            }
            case 560: {
                return jdbcType == 92;
            }
            case 448: {
                return subType != 1 && jdbcType == 12 || subType == 1 && jdbcType == -3;
            }
            case 32766: {
                return false;
            }
            case 32764: {
                return jdbcType == 16;
            }
        }
        return false;
    }

    public static FBField createField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, GDSHelper gdsHelper, boolean cached) throws SQLException {
        FBField result = FBField.createField(fieldDescriptor, dataProvider, cached);
        result.setConnection(gdsHelper);
        return result;
    }

    private static FBField createField(FieldDescriptor fieldDescriptor, FieldDataProvider dataProvider, boolean cached) throws SQLException {
        int jdbcType = JdbcTypeConverter.toJdbcType(fieldDescriptor);
        switch (jdbcType) {
            case 5: {
                return new FBShortField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 4: {
                return new FBIntegerField(fieldDescriptor, dataProvider, jdbcType);
            }
            case -5: {
                return new FBLongField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 2: 
            case 3: {
                return new FBBigDecimalField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 6: {
                return new FBFloatField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 8: {
                return new FBDoubleField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 92: {
                return new FBTimeField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 91: {
                return new FBDateField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 93: {
                return new FBTimestampField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 1: 
            case 12: {
                return new FBWorkaroundStringField(fieldDescriptor, dataProvider, jdbcType);
            }
            case -1: {
                if (cached) {
                    return new FBCachedLongVarCharField(fieldDescriptor, dataProvider, jdbcType);
                }
                return new FBLongVarCharField(fieldDescriptor, dataProvider, jdbcType);
            }
            case -3: 
            case -2: {
                return new FBBinaryField(fieldDescriptor, dataProvider, jdbcType);
            }
            case -4: 
            case 2004: {
                if (cached) {
                    return new FBCachedBlobField(fieldDescriptor, dataProvider, jdbcType);
                }
                return new FBBlobField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 16: {
                return new FBBooleanField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 0: {
                return new FBNullField(fieldDescriptor, dataProvider, jdbcType);
            }
            case 2003: {
                throw new FBDriverNotCapableException(SQL_ARRAY_NOT_SUPPORTED);
            }
        }
        throw new FBDriverNotCapableException(SQL_TYPE_NOT_SUPPORTED);
    }

    public String getName() {
        return this.fieldDescriptor.getOriginalName();
    }

    public String getAlias() {
        return this.fieldDescriptor.getFieldName();
    }

    public String getRelationName() {
        return this.fieldDescriptor.getOriginalTableName();
    }

    public void close() throws SQLException {
    }

    public byte getByte() throws SQLException {
        throw new TypeConversionException(BYTE_CONVERSION_ERROR);
    }

    public short getShort() throws SQLException {
        throw new TypeConversionException(SHORT_CONVERSION_ERROR);
    }

    public int getInt() throws SQLException {
        throw new TypeConversionException(INT_CONVERSION_ERROR);
    }

    public long getLong() throws SQLException {
        throw new TypeConversionException(LONG_CONVERSION_ERROR);
    }

    public float getFloat() throws SQLException {
        throw new TypeConversionException(FLOAT_CONVERSION_ERROR);
    }

    public double getDouble() throws SQLException {
        throw new TypeConversionException(DOUBLE_CONVERSION_ERROR);
    }

    public BigDecimal getBigDecimal() throws SQLException {
        throw new TypeConversionException(BIGDECIMAL_CONVERSION_ERROR);
    }

    public BigDecimal getBigDecimal(int scale) throws SQLException {
        return this.getBigDecimal();
    }

    public boolean getBoolean() throws SQLException {
        throw new TypeConversionException(BOOLEAN_CONVERSION_ERROR);
    }

    public String getString() throws SQLException {
        throw new TypeConversionException(STRING_CONVERSION_ERROR);
    }

    public Object getObject() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        switch (this.requiredType) {
            case -1: 
            case 1: 
            case 12: {
                return this.getString();
            }
            case 2: 
            case 3: {
                if (this.scale == -1) {
                    return this.getBigDecimal();
                }
                return this.getBigDecimal(this.scale);
            }
            case -7: 
            case 16: {
                return this.getBoolean();
            }
            case -6: 
            case 4: 
            case 5: {
                return this.getInt();
            }
            case -5: {
                return this.getLong();
            }
            case 7: {
                return Float.valueOf(this.getFloat());
            }
            case 6: 
            case 8: {
                return this.getDouble();
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytes();
            }
            case 91: {
                return this.getDate();
            }
            case 92: {
                return this.getTime();
            }
            case 93: {
                return this.getTimestamp();
            }
            case 2005: {
                return this.getClob();
            }
            case 2004: {
                return this.getBlob();
            }
            case 2003: {
                return this.getArray();
            }
        }
        throw new TypeConversionException(OBJECT_CONVERSION_ERROR);
    }

    public Object getObject(Map<String, Class<?>> map) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public <T> T getObject(Class<T> type) throws SQLException {
        if (type == null) {
            throw new SQLNonTransientException("getObject called with type null");
        }
        switch (type.getName()) {
            case "java.lang.Boolean": {
                return (T)(this.isNull() ? null : Boolean.valueOf(this.getBoolean()));
            }
            case "java.lang.Byte": {
                return (T)(this.isNull() ? null : Byte.valueOf(this.getByte()));
            }
            case "java.lang.Short": {
                return (T)(this.isNull() ? null : Short.valueOf(this.getShort()));
            }
            case "java.lang.Integer": {
                return (T)(this.isNull() ? null : Integer.valueOf(this.getInt()));
            }
            case "java.lang.Long": {
                return (T)(this.isNull() ? null : Long.valueOf(this.getLong()));
            }
            case "java.lang.Float": {
                return (T)(this.isNull() ? null : Float.valueOf(this.getFloat()));
            }
            case "java.lang.Double": {
                return (T)(this.isNull() ? null : Double.valueOf(this.getDouble()));
            }
            case "java.math.BigDecimal": {
                return (T)this.getBigDecimal();
            }
            case "java.math.BigInteger": {
                return (T)this.getBigInteger();
            }
            case "java.lang.String": {
                return (T)this.getString();
            }
            case "[B": {
                return (T)this.getBytes();
            }
            case "java.sql.Date": {
                return (T)this.getDate();
            }
            case "java.util.Date": 
            case "java.sql.Timestamp": {
                return (T)this.getTimestamp();
            }
            case "java.sql.Time": {
                return (T)this.getTime();
            }
            case "java.util.Calendar": {
                if (this.isNull()) {
                    return null;
                }
                Calendar calendar = GregorianCalendar.getInstance();
                calendar.setTimeInMillis(this.getTimestamp().getTime());
                return (T)calendar;
            }
            case "java.sql.Clob": 
            case "java.sql.NClob": {
                return (T)this.getClob();
            }
            case "java.sql.Blob": 
            case "org.firebirdsql.jdbc.FirebirdBlob": {
                return (T)this.getBlob();
            }
            case "java.io.InputStream": {
                return (T)this.getBinaryStream();
            }
            case "java.io.Reader": {
                return (T)this.getCharacterStream();
            }
            case "org.firebirdsql.gds.ng.DatatypeCoder$RawDateTimeStruct": {
                return (T)this.getRawDateTimeStruct();
            }
        }
        return this.getObjectConverter().getObject(this, type);
    }

    public InputStream getBinaryStream() throws SQLException {
        throw new TypeConversionException(BINARY_STREAM_CONVERSION_ERROR);
    }

    public Reader getCharacterStream() throws SQLException {
        InputStream is = this.getBinaryStream();
        if (is == null) {
            return null;
        }
        return TranslatingReader.getInstance(is, this.getDatatypeCoder().getEncodingFactory().getDefaultEncoding().getCharsetName(), this.mappingPath);
    }

    public byte[] getBytes() throws SQLException {
        throw new TypeConversionException(BYTES_CONVERSION_ERROR);
    }

    public Blob getBlob() throws SQLException {
        throw new TypeConversionException(BLOB_CONVERSION_ERROR);
    }

    public Date getDate() throws SQLException {
        throw new TypeConversionException(DATE_CONVERSION_ERROR);
    }

    public Date getDate(Calendar cal) throws SQLException {
        throw new TypeConversionException(DATE_CONVERSION_ERROR);
    }

    public Time getTime() throws SQLException {
        throw new TypeConversionException(TIME_CONVERSION_ERROR);
    }

    public Time getTime(Calendar cal) throws SQLException {
        throw new TypeConversionException(TIME_CONVERSION_ERROR);
    }

    public Timestamp getTimestamp() throws SQLException {
        throw new TypeConversionException(TIMESTAMP_CONVERSION_ERROR);
    }

    public Timestamp getTimestamp(Calendar cal) throws SQLException {
        throw new TypeConversionException(TIMESTAMP_CONVERSION_ERROR);
    }

    public Ref getRef() throws SQLException {
        throw new FBDriverNotCapableException("Type REF not supported");
    }

    public Clob getClob() throws SQLException {
        throw new TypeConversionException(BLOB_CONVERSION_ERROR);
    }

    public Array getArray() throws SQLException {
        throw new FBDriverNotCapableException("Type ARRAY not yet supported");
    }

    public BigInteger getBigInteger() throws SQLException {
        throw new TypeConversionException(BIG_INTEGER_CONVERSION_ERROR);
    }

    public void setByte(byte value) throws SQLException {
        throw new TypeConversionException(BYTE_CONVERSION_ERROR);
    }

    public void setShort(short value) throws SQLException {
        throw new TypeConversionException(SHORT_CONVERSION_ERROR);
    }

    public void setInteger(int value) throws SQLException {
        throw new TypeConversionException(INT_CONVERSION_ERROR);
    }

    public void setLong(long value) throws SQLException {
        throw new TypeConversionException(LONG_CONVERSION_ERROR);
    }

    public void setFloat(float value) throws SQLException {
        throw new TypeConversionException(FLOAT_CONVERSION_ERROR);
    }

    public void setDouble(double value) throws SQLException {
        throw new TypeConversionException(DOUBLE_CONVERSION_ERROR);
    }

    public void setBigDecimal(BigDecimal value) throws SQLException {
        throw new TypeConversionException(BIGDECIMAL_CONVERSION_ERROR);
    }

    public void setBoolean(boolean value) throws SQLException {
        throw new TypeConversionException(BOOLEAN_CONVERSION_ERROR);
    }

    public void setString(String value) throws SQLException {
        throw new TypeConversionException(STRING_CONVERSION_ERROR);
    }

    public void setBigInteger(BigInteger value) throws SQLException {
        throw new TypeConversionException(BIG_INTEGER_CONVERSION_ERROR);
    }

    public void setObject(Object value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        if (value instanceof BigDecimal) {
            this.setBigDecimal((BigDecimal)value);
        } else if (value instanceof Blob) {
            if (value instanceof FBBlob) {
                this.setBlob((FBBlob)value);
            } else {
                this.setBinaryStream(((Blob)value).getBinaryStream());
            }
        } else if (value instanceof InputStream) {
            this.setBinaryStream((InputStream)value);
        } else if (value instanceof Reader) {
            this.setCharacterStream((Reader)value);
        } else if (value instanceof Boolean) {
            this.setBoolean((Boolean)value);
        } else if (value instanceof Byte) {
            this.setByte((Byte)value);
        } else if (value instanceof byte[]) {
            this.setBytes((byte[])value);
        } else if (value instanceof Date) {
            this.setDate((Date)value);
        } else if (value instanceof Double) {
            this.setDouble((Double)value);
        } else if (value instanceof Float) {
            this.setFloat(((Float)value).floatValue());
        } else if (value instanceof Integer) {
            this.setInteger((Integer)value);
        } else if (value instanceof Long) {
            this.setLong((Long)value);
        } else if (value instanceof Short) {
            this.setShort((Short)value);
        } else if (value instanceof String) {
            this.setString((String)value);
        } else if (value instanceof Time) {
            this.setTime((Time)value);
        } else if (value instanceof Timestamp) {
            this.setTimestamp((Timestamp)value);
        } else if (value instanceof DatatypeCoder.RawDateTimeStruct) {
            this.setRawDateTimeStruct((DatatypeCoder.RawDateTimeStruct)value);
        } else if (value instanceof BigInteger) {
            this.setBigInteger((BigInteger)value);
        } else if (!this.getObjectConverter().setObject(this, value)) {
            throw new TypeConversionException(OBJECT_CONVERSION_ERROR);
        }
    }

    protected void setBinaryStreamInternal(InputStream in, long length) throws SQLException {
        throw new TypeConversionException(BINARY_STREAM_CONVERSION_ERROR);
    }

    public final void setBinaryStream(InputStream in, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLNonTransientException("Length needs to be >= 0, was: " + length);
        }
        this.setBinaryStreamInternal(in, length);
    }

    public final void setBinaryStream(InputStream in) throws SQLException {
        this.setBinaryStreamInternal(in, -1L);
    }

    public final void setBinaryStream(InputStream in, int length) throws SQLException {
        this.setBinaryStream(in, (long)length);
    }

    protected void setCharacterStreamInternal(Reader in, long length) throws SQLException {
        throw new TypeConversionException(CHARACTER_STREAM_CONVERSION_ERROR);
    }

    public final void setCharacterStream(Reader in, long length) throws SQLException {
        if (length < 0L) {
            throw new SQLNonTransientException("Length needs to be >= 0, was: " + length);
        }
        this.setCharacterStreamInternal(in, length);
    }

    public final void setCharacterStream(Reader in) throws SQLException {
        this.setCharacterStreamInternal(in, -1L);
    }

    public final void setCharacterStream(Reader in, int length) throws SQLException {
        this.setCharacterStream(in, (long)length);
    }

    public void setBytes(byte[] value) throws SQLException {
        throw new TypeConversionException(BYTES_CONVERSION_ERROR);
    }

    public void setDate(Date value, Calendar cal) throws SQLException {
        throw new TypeConversionException(DATE_CONVERSION_ERROR);
    }

    public void setDate(Date value) throws SQLException {
        throw new TypeConversionException(DATE_CONVERSION_ERROR);
    }

    public void setTime(Time value, Calendar cal) throws SQLException {
        throw new TypeConversionException(TIME_CONVERSION_ERROR);
    }

    public void setTime(Time value) throws SQLException {
        throw new TypeConversionException(TIME_CONVERSION_ERROR);
    }

    public void setTimestamp(Timestamp value, Calendar cal) throws SQLException {
        throw new TypeConversionException(TIMESTAMP_CONVERSION_ERROR);
    }

    public void setTimestamp(Timestamp value) throws SQLException {
        throw new TypeConversionException(TIMESTAMP_CONVERSION_ERROR);
    }

    public void setBlob(FBBlob blob) throws SQLException {
        throw new TypeConversionException(BLOB_CONVERSION_ERROR);
    }

    public void setClob(FBClob clob) throws SQLException {
        throw new TypeConversionException(CLOB_CONVERSION_ERROR);
    }

    public DatatypeCoder.RawDateTimeStruct getRawDateTimeStruct() throws SQLException {
        throw new TypeConversionException(TIMESTAMP_CONVERSION_ERROR);
    }

    public void setRawDateTimeStruct(DatatypeCoder.RawDateTimeStruct raw) throws SQLException {
        throw new TypeConversionException(TIMESTAMP_CONVERSION_ERROR);
    }

    protected boolean isInvertTimeZone() {
        if (this.gdsHelper == null) {
            return false;
        }
        DatabaseParameterBuffer dpb = this.gdsHelper.getDatabaseParameterBuffer();
        return dpb.hasArgument(133);
    }
}

