/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import oracle.security.crypto.cert.PKCS12CertBag;
import oracle.security.crypto.cert.X500Name;
import oracle.security.pki.OracleKSEntry;
import oracle.security.pki.OraclePKIX509CertImpl;

class OracleKSTrustedCertEntry
extends OracleKSEntry {
    private final Certificate a;

    OracleKSTrustedCertEntry(PKCS12CertBag pKCS12CertBag) {
        this.a = new OraclePKIX509CertImpl(pKCS12CertBag.getCert());
    }

    OracleKSTrustedCertEntry(Certificate certificate) {
        this.a = certificate;
    }

    @Override
    Certificate b() {
        return this.a;
    }

    @Override
    boolean d() {
        return true;
    }

    @Override
    String f() {
        String string = null;
        if (this.a instanceof X509Certificate) {
            X500Name x500Name = new X500Name(((X509Certificate)this.a).getSubjectDN().getName());
            string = "CN=" + x500Name.getCommonName();
            if (x500Name.getCommonName() == null) {
                string = "OU=" + x500Name.getOrgUnitName();
            }
            return string;
        }
        return "";
    }
}

