/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.schemahistory.teams;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.MigrationPattern;
import org.flywaydb.core.api.MigrationType;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.output.RepairOutput;
import org.flywaydb.core.api.output.RepairResult;
import org.flywaydb.core.api.resolver.ResolvedMigration;
import org.flywaydb.core.internal.database.base.Table;
import org.flywaydb.core.internal.exception.FlywaySqlException;
import org.flywaydb.core.internal.jdbc.StatementInterceptor;
import org.flywaydb.core.internal.schemahistory.AppliedMigration;
import org.flywaydb.core.internal.schemahistory.SchemaHistory;
import org.flywaydb.core.internal.util.AbbreviationUtils;

public class InMemorySchemaHistory
extends SchemaHistory {
    private boolean exists;
    private final String installedBy;
    private final StatementInterceptor statementInterceptor;
    private final List<AppliedMigration> history = new ArrayList<AppliedMigration>();
    private final Configuration configuration;

    public InMemorySchemaHistory(boolean exists, List<AppliedMigration> existingHistory, Table table, String installedBy, StatementInterceptor statementInterceptor, Configuration configuration) {
        this.table = table;
        this.exists = exists;
        this.installedBy = installedBy;
        this.statementInterceptor = statementInterceptor;
        this.configuration = configuration;
        this.history.addAll(existingHistory);
    }

    @Override
    public <T> T lock(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (SQLException e) {
            throw new FlywaySqlException("Unable to execute changes", e);
        }
        catch (Exception e) {
            throw new FlywayException(e);
        }
    }

    @Override
    public boolean exists() {
        return this.exists;
    }

    @Override
    public void create(boolean baseline) {
        if (!this.exists) {
            this.statementInterceptor.schemaHistoryTableCreate(baseline);
            this.exists = true;
        }
        if (baseline) {
            this.history.add(new AppliedMigration(1, this.configuration.getBaselineVersion(), "'" + AbbreviationUtils.abbreviateDescription(this.configuration.getBaselineDescription()) + "'", MigrationType.BASELINE, "'" + AbbreviationUtils.abbreviateScript(this.configuration.getBaselineDescription()) + "'", null, new Date(), this.configuration.getInstalledBy(), 0, true));
        }
    }

    @Override
    public List<AppliedMigration> allAppliedMigrations() {
        return this.history;
    }

    @Override
    public boolean removeFailedMigrations(RepairResult repairResult, MigrationPattern[] migrationPatternFilter) {
        boolean didRemove = false;
        Iterator<AppliedMigration> iterator = this.history.iterator();
        while (iterator.hasNext()) {
            AppliedMigration appliedMigration = iterator.next();
            if (appliedMigration.isSuccess() || this.isMigrationFilteredOut(appliedMigration, migrationPatternFilter)) continue;
            iterator.remove();
            didRemove = true;
            repairResult.migrationsRemoved.add(new RepairOutput(appliedMigration.getVersion().toString(), appliedMigration.getDescription(), ""));
            this.statementInterceptor.schemaHistoryTableDeleteFailed(this.table, appliedMigration);
        }
        return didRemove;
    }

    private boolean isMigrationFilteredOut(AppliedMigration appliedMigration, MigrationPattern[] migrationPatternFilter) {
        if (migrationPatternFilter == null) {
            return false;
        }
        return Arrays.stream(migrationPatternFilter).noneMatch(mp -> mp.matches(appliedMigration.getVersion(), appliedMigration.getDescription()));
    }

    @Override
    public void update(AppliedMigration applied, ResolvedMigration resolved) {
        AppliedMigration updated = new AppliedMigration(applied.getInstalledRank(), applied.getVersion(), resolved.getDescription(), resolved.getType(), resolved.getScript(), resolved.getChecksum(), applied.getInstalledOn(), applied.getInstalledBy(), applied.getExecutionTime(), applied.isSuccess());
        this.statementInterceptor.schemaHistoryTableInsert(updated);
        this.history.set(applied.getInstalledRank(), updated);
    }

    @Override
    protected void doAddAppliedMigration(int installedRank, MigrationVersion version, String description, MigrationType type, String script, Integer checksum, int executionTime, boolean success) {
        AppliedMigration appliedMigration = new AppliedMigration(installedRank, version, description, type, script, checksum, new Date(), this.installedBy, executionTime, success);
        this.statementInterceptor.schemaHistoryTableInsert(appliedMigration);
        this.history.add(appliedMigration);
    }

    @Override
    public void delete(AppliedMigration appliedMigration) {
        AppliedMigration deleteMigration = new AppliedMigration(this.calculateInstalledRank(), appliedMigration.getVersion(), appliedMigration.getDescription(), MigrationType.DELETE, appliedMigration.getScript(), appliedMigration.getChecksum(), new Date(), this.installedBy, 0, true);
        this.statementInterceptor.schemaHistoryTableInsert(deleteMigration);
        this.history.add(deleteMigration);
    }
}

