/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import java.util.Map;
import org.flywaydb.core.extensibility.ApiExtension;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.secretsmanagement.VaultConfigurationProvider;

public class VaultApiExtension
implements ApiExtension {
    protected String vaultUrl;
    protected String vaultToken;
    protected String[] vaultSecrets;

    public Map<String, String> getConfiguration() throws Exception {
        if (VersionPrinter.EDITION != Edition.ENTERPRISE) {
            throw new FlywayTeamsUpgradeRequiredException("Vault");
        }
        return ConfigUtils.loadConfigurationFromString((String)VaultConfigurationProvider.getConfiguration(this.vaultUrl, this.vaultToken, this.vaultSecrets));
    }

    public void setVaultSecrets(String ... vaultSecrets) {
        this.vaultSecrets = vaultSecrets;
    }

    public void setVaultUrl(String vaultUrl) {
        this.vaultUrl = vaultUrl;
    }

    public void setVaultToken(String vaultToken) {
        this.vaultToken = vaultToken;
    }
}

