/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.secretsmanagement;

import java.util.Map;
import org.flywaydb.core.extensibility.ApiExtension;
import org.flywaydb.core.internal.configuration.ConfigUtils;
import org.flywaydb.core.internal.license.Edition;
import org.flywaydb.core.internal.license.FlywayTeamsUpgradeRequiredException;
import org.flywaydb.core.internal.license.VersionPrinter;
import org.flywaydb.secretsmanagement.GcsmConfigurationProvider;

public class GcsmApiExtension
implements ApiExtension {
    protected String gcsmProject;
    protected String[] gcsmSecrets;

    public Map<String, String> getConfiguration() throws Exception {
        if (VersionPrinter.EDITION != Edition.ENTERPRISE) {
            throw new FlywayTeamsUpgradeRequiredException("Google Cloud Secret Manager");
        }
        return ConfigUtils.loadConfigurationFromString((String)GcsmConfigurationProvider.getConfiguration(this.gcsmProject, this.gcsmSecrets));
    }

    public void setGcsmSecrets(String ... gcsmSecrets) {
        this.gcsmSecrets = gcsmSecrets;
    }

    public void setGcsmProject(String gcsmProject) {
        this.gcsmProject = gcsmProject;
    }
}

