open Prims
let (print_ctx_uvar : FStar_Syntax_Syntax.ctx_uvar -> Prims.string) =
  fun ctx_uvar  -> FStar_Syntax_Print.ctx_uvar_to_string ctx_uvar 
type lstring = Prims.string FStar_Thunk.t
type uvi =
  | TERM of (FStar_Syntax_Syntax.ctx_uvar * FStar_Syntax_Syntax.term) 
  | UNIV of (FStar_Syntax_Syntax.universe_uvar *
  FStar_Syntax_Syntax.universe) 
let (uu___is_TERM : uvi -> Prims.bool) =
  fun projectee  ->
    match projectee with | TERM _0 -> true | uu____49 -> false
  
let (__proj__TERM__item___0 :
  uvi -> (FStar_Syntax_Syntax.ctx_uvar * FStar_Syntax_Syntax.term)) =
  fun projectee  -> match projectee with | TERM _0 -> _0 
let (uu___is_UNIV : uvi -> Prims.bool) =
  fun projectee  ->
    match projectee with | UNIV _0 -> true | uu____84 -> false
  
let (__proj__UNIV__item___0 :
  uvi -> (FStar_Syntax_Syntax.universe_uvar * FStar_Syntax_Syntax.universe))
  = fun projectee  -> match projectee with | UNIV _0 -> _0 
type worklist =
  {
  attempting: FStar_TypeChecker_Common.probs ;
  wl_deferred:
    (Prims.int * lstring * FStar_TypeChecker_Common.prob) Prims.list ;
  ctr: Prims.int ;
  defer_ok: Prims.bool ;
  smt_ok: Prims.bool ;
  umax_heuristic_ok: Prims.bool ;
  tcenv: FStar_TypeChecker_Env.env ;
  wl_implicits: FStar_TypeChecker_Common.implicits }
let (__proj__Mkworklist__item__attempting :
  worklist -> FStar_TypeChecker_Common.probs) =
  fun projectee  ->
    match projectee with
    | { attempting; wl_deferred; ctr; defer_ok; smt_ok; umax_heuristic_ok;
        tcenv; wl_implicits;_} -> attempting
  
let (__proj__Mkworklist__item__wl_deferred :
  worklist ->
    (Prims.int * lstring * FStar_TypeChecker_Common.prob) Prims.list)
  =
  fun projectee  ->
    match projectee with
    | { attempting; wl_deferred; ctr; defer_ok; smt_ok; umax_heuristic_ok;
        tcenv; wl_implicits;_} -> wl_deferred
  
let (__proj__Mkworklist__item__ctr : worklist -> Prims.int) =
  fun projectee  ->
    match projectee with
    | { attempting; wl_deferred; ctr; defer_ok; smt_ok; umax_heuristic_ok;
        tcenv; wl_implicits;_} -> ctr
  
let (__proj__Mkworklist__item__defer_ok : worklist -> Prims.bool) =
  fun projectee  ->
    match projectee with
    | { attempting; wl_deferred; ctr; defer_ok; smt_ok; umax_heuristic_ok;
        tcenv; wl_implicits;_} -> defer_ok
  
let (__proj__Mkworklist__item__smt_ok : worklist -> Prims.bool) =
  fun projectee  ->
    match projectee with
    | { attempting; wl_deferred; ctr; defer_ok; smt_ok; umax_heuristic_ok;
        tcenv; wl_implicits;_} -> smt_ok
  
let (__proj__Mkworklist__item__umax_heuristic_ok : worklist -> Prims.bool) =
  fun projectee  ->
    match projectee with
    | { attempting; wl_deferred; ctr; defer_ok; smt_ok; umax_heuristic_ok;
        tcenv; wl_implicits;_} -> umax_heuristic_ok
  
let (__proj__Mkworklist__item__tcenv : worklist -> FStar_TypeChecker_Env.env)
  =
  fun projectee  ->
    match projectee with
    | { attempting; wl_deferred; ctr; defer_ok; smt_ok; umax_heuristic_ok;
        tcenv; wl_implicits;_} -> tcenv
  
let (__proj__Mkworklist__item__wl_implicits :
  worklist -> FStar_TypeChecker_Common.implicits) =
  fun projectee  ->
    match projectee with
    | { attempting; wl_deferred; ctr; defer_ok; smt_ok; umax_heuristic_ok;
        tcenv; wl_implicits;_} -> wl_implicits
  
let (new_uvar :
  Prims.string ->
    worklist ->
      FStar_Range.range ->
        FStar_Syntax_Syntax.binding Prims.list ->
          (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.arg_qualifier
            FStar_Pervasives_Native.option) Prims.list ->
            FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
              FStar_Syntax_Syntax.should_check_uvar ->
                (FStar_Dyn.dyn * FStar_Syntax_Syntax.term'
                  FStar_Syntax_Syntax.syntax) FStar_Pervasives_Native.option
                  ->
                  (FStar_Syntax_Syntax.ctx_uvar * FStar_Syntax_Syntax.term *
                    worklist))
  =
  fun reason  ->
    fun wl  ->
      fun r  ->
        fun gamma  ->
          fun binders  ->
            fun k  ->
              fun should_check  ->
                fun meta  ->
                  let ctx_uvar =
                    let uu____515 = FStar_Syntax_Unionfind.fresh ()  in
                    {
                      FStar_Syntax_Syntax.ctx_uvar_head = uu____515;
                      FStar_Syntax_Syntax.ctx_uvar_gamma = gamma;
                      FStar_Syntax_Syntax.ctx_uvar_binders = binders;
                      FStar_Syntax_Syntax.ctx_uvar_typ = k;
                      FStar_Syntax_Syntax.ctx_uvar_reason = reason;
                      FStar_Syntax_Syntax.ctx_uvar_should_check =
                        should_check;
                      FStar_Syntax_Syntax.ctx_uvar_range = r;
                      FStar_Syntax_Syntax.ctx_uvar_meta = meta
                    }  in
                  FStar_TypeChecker_Common.check_uvar_ctx_invariant reason r
                    true gamma binders;
                  (let t =
                     FStar_Syntax_Syntax.mk
                       (FStar_Syntax_Syntax.Tm_uvar
                          (ctx_uvar, ([], FStar_Syntax_Syntax.NoUseRange)))
                       FStar_Pervasives_Native.None r
                      in
                   let imp =
                     {
                       FStar_TypeChecker_Common.imp_reason = reason;
                       FStar_TypeChecker_Common.imp_uvar = ctx_uvar;
                       FStar_TypeChecker_Common.imp_tm = t;
                       FStar_TypeChecker_Common.imp_range = r
                     }  in
                   (let uu____547 =
                      FStar_TypeChecker_Env.debug wl.tcenv
                        (FStar_Options.Other "ImplicitTrace")
                       in
                    if uu____547
                    then
                      let uu____551 =
                        FStar_Syntax_Print.uvar_to_string
                          ctx_uvar.FStar_Syntax_Syntax.ctx_uvar_head
                         in
                      FStar_Util.print1 "Just created uvar (Rel) {%s}\n"
                        uu____551
                    else ());
                   (ctx_uvar, t,
                     ((let uu___73_557 = wl  in
                       {
                         attempting = (uu___73_557.attempting);
                         wl_deferred = (uu___73_557.wl_deferred);
                         ctr = (uu___73_557.ctr);
                         defer_ok = (uu___73_557.defer_ok);
                         smt_ok = (uu___73_557.smt_ok);
                         umax_heuristic_ok = (uu___73_557.umax_heuristic_ok);
                         tcenv = (uu___73_557.tcenv);
                         wl_implicits = (imp :: (wl.wl_implicits))
                       }))))
  
let (copy_uvar :
  FStar_Syntax_Syntax.ctx_uvar ->
    FStar_Syntax_Syntax.binders ->
      FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
        worklist ->
          (FStar_Syntax_Syntax.ctx_uvar * FStar_Syntax_Syntax.term *
            worklist))
  =
  fun u  ->
    fun bs  ->
      fun t  ->
        fun wl  ->
          let env =
            let uu___79_590 = wl.tcenv  in
            {
              FStar_TypeChecker_Env.solver =
                (uu___79_590.FStar_TypeChecker_Env.solver);
              FStar_TypeChecker_Env.range =
                (uu___79_590.FStar_TypeChecker_Env.range);
              FStar_TypeChecker_Env.curmodule =
                (uu___79_590.FStar_TypeChecker_Env.curmodule);
              FStar_TypeChecker_Env.gamma =
                (u.FStar_Syntax_Syntax.ctx_uvar_gamma);
              FStar_TypeChecker_Env.gamma_sig =
                (uu___79_590.FStar_TypeChecker_Env.gamma_sig);
              FStar_TypeChecker_Env.gamma_cache =
                (uu___79_590.FStar_TypeChecker_Env.gamma_cache);
              FStar_TypeChecker_Env.modules =
                (uu___79_590.FStar_TypeChecker_Env.modules);
              FStar_TypeChecker_Env.expected_typ =
                (uu___79_590.FStar_TypeChecker_Env.expected_typ);
              FStar_TypeChecker_Env.sigtab =
                (uu___79_590.FStar_TypeChecker_Env.sigtab);
              FStar_TypeChecker_Env.attrtab =
                (uu___79_590.FStar_TypeChecker_Env.attrtab);
              FStar_TypeChecker_Env.instantiate_imp =
                (uu___79_590.FStar_TypeChecker_Env.instantiate_imp);
              FStar_TypeChecker_Env.effects =
                (uu___79_590.FStar_TypeChecker_Env.effects);
              FStar_TypeChecker_Env.generalize =
                (uu___79_590.FStar_TypeChecker_Env.generalize);
              FStar_TypeChecker_Env.letrecs =
                (uu___79_590.FStar_TypeChecker_Env.letrecs);
              FStar_TypeChecker_Env.top_level =
                (uu___79_590.FStar_TypeChecker_Env.top_level);
              FStar_TypeChecker_Env.check_uvars =
                (uu___79_590.FStar_TypeChecker_Env.check_uvars);
              FStar_TypeChecker_Env.use_eq =
                (uu___79_590.FStar_TypeChecker_Env.use_eq);
              FStar_TypeChecker_Env.use_eq_strict =
                (uu___79_590.FStar_TypeChecker_Env.use_eq_strict);
              FStar_TypeChecker_Env.is_iface =
                (uu___79_590.FStar_TypeChecker_Env.is_iface);
              FStar_TypeChecker_Env.admit =
                (uu___79_590.FStar_TypeChecker_Env.admit);
              FStar_TypeChecker_Env.lax =
                (uu___79_590.FStar_TypeChecker_Env.lax);
              FStar_TypeChecker_Env.lax_universes =
                (uu___79_590.FStar_TypeChecker_Env.lax_universes);
              FStar_TypeChecker_Env.phase1 =
                (uu___79_590.FStar_TypeChecker_Env.phase1);
              FStar_TypeChecker_Env.failhard =
                (uu___79_590.FStar_TypeChecker_Env.failhard);
              FStar_TypeChecker_Env.nosynth =
                (uu___79_590.FStar_TypeChecker_Env.nosynth);
              FStar_TypeChecker_Env.uvar_subtyping =
                (uu___79_590.FStar_TypeChecker_Env.uvar_subtyping);
              FStar_TypeChecker_Env.tc_term =
                (uu___79_590.FStar_TypeChecker_Env.tc_term);
              FStar_TypeChecker_Env.type_of =
                (uu___79_590.FStar_TypeChecker_Env.type_of);
              FStar_TypeChecker_Env.universe_of =
                (uu___79_590.FStar_TypeChecker_Env.universe_of);
              FStar_TypeChecker_Env.check_type_of =
                (uu___79_590.FStar_TypeChecker_Env.check_type_of);
              FStar_TypeChecker_Env.use_bv_sorts =
                (uu___79_590.FStar_TypeChecker_Env.use_bv_sorts);
              FStar_TypeChecker_Env.qtbl_name_and_index =
                (uu___79_590.FStar_TypeChecker_Env.qtbl_name_and_index);
              FStar_TypeChecker_Env.normalized_eff_names =
                (uu___79_590.FStar_TypeChecker_Env.normalized_eff_names);
              FStar_TypeChecker_Env.fv_delta_depths =
                (uu___79_590.FStar_TypeChecker_Env.fv_delta_depths);
              FStar_TypeChecker_Env.proof_ns =
                (uu___79_590.FStar_TypeChecker_Env.proof_ns);
              FStar_TypeChecker_Env.synth_hook =
                (uu___79_590.FStar_TypeChecker_Env.synth_hook);
              FStar_TypeChecker_Env.try_solve_implicits_hook =
                (uu___79_590.FStar_TypeChecker_Env.try_solve_implicits_hook);
              FStar_TypeChecker_Env.splice =
                (uu___79_590.FStar_TypeChecker_Env.splice);
              FStar_TypeChecker_Env.mpreprocess =
                (uu___79_590.FStar_TypeChecker_Env.mpreprocess);
              FStar_TypeChecker_Env.postprocess =
                (uu___79_590.FStar_TypeChecker_Env.postprocess);
              FStar_TypeChecker_Env.is_native_tactic =
                (uu___79_590.FStar_TypeChecker_Env.is_native_tactic);
              FStar_TypeChecker_Env.identifier_info =
                (uu___79_590.FStar_TypeChecker_Env.identifier_info);
              FStar_TypeChecker_Env.tc_hooks =
                (uu___79_590.FStar_TypeChecker_Env.tc_hooks);
              FStar_TypeChecker_Env.dsenv =
                (uu___79_590.FStar_TypeChecker_Env.dsenv);
              FStar_TypeChecker_Env.nbe =
                (uu___79_590.FStar_TypeChecker_Env.nbe);
              FStar_TypeChecker_Env.strict_args_tab =
                (uu___79_590.FStar_TypeChecker_Env.strict_args_tab);
              FStar_TypeChecker_Env.erasable_types_tab =
                (uu___79_590.FStar_TypeChecker_Env.erasable_types_tab)
            }  in
          let env1 = FStar_TypeChecker_Env.push_binders env bs  in
          let uu____592 = FStar_TypeChecker_Env.all_binders env1  in
          new_uvar
            (Prims.op_Hat "copy:" u.FStar_Syntax_Syntax.ctx_uvar_reason) wl
            u.FStar_Syntax_Syntax.ctx_uvar_range
            env1.FStar_TypeChecker_Env.gamma uu____592 t
            u.FStar_Syntax_Syntax.ctx_uvar_should_check
            u.FStar_Syntax_Syntax.ctx_uvar_meta
  
type solution =
  | Success of (FStar_TypeChecker_Common.deferred *
  FStar_TypeChecker_Common.implicits) 
  | Failed of (FStar_TypeChecker_Common.prob * lstring) 
let (uu___is_Success : solution -> Prims.bool) =
  fun projectee  ->
    match projectee with | Success _0 -> true | uu____653 -> false
  
let (__proj__Success__item___0 :
  solution ->
    (FStar_TypeChecker_Common.deferred * FStar_TypeChecker_Common.implicits))
  = fun projectee  -> match projectee with | Success _0 -> _0 
let (uu___is_Failed : solution -> Prims.bool) =
  fun projectee  ->
    match projectee with | Failed _0 -> true | uu____688 -> false
  
let (__proj__Failed__item___0 :
  solution -> (FStar_TypeChecker_Common.prob * lstring)) =
  fun projectee  -> match projectee with | Failed _0 -> _0 
type variance =
  | COVARIANT 
  | CONTRAVARIANT 
  | INVARIANT 
let (uu___is_COVARIANT : variance -> Prims.bool) =
  fun projectee  ->
    match projectee with | COVARIANT  -> true | uu____718 -> false
  
let (uu___is_CONTRAVARIANT : variance -> Prims.bool) =
  fun projectee  ->
    match projectee with | CONTRAVARIANT  -> true | uu____729 -> false
  
let (uu___is_INVARIANT : variance -> Prims.bool) =
  fun projectee  ->
    match projectee with | INVARIANT  -> true | uu____740 -> false
  
type tprob = FStar_Syntax_Syntax.typ FStar_TypeChecker_Common.problem
type cprob = FStar_Syntax_Syntax.comp FStar_TypeChecker_Common.problem
type 'a problem_t = 'a FStar_TypeChecker_Common.problem
let (rel_to_string : FStar_TypeChecker_Common.rel -> Prims.string) =
  fun uu___0_758  ->
    match uu___0_758 with
    | FStar_TypeChecker_Common.EQ  -> "="
    | FStar_TypeChecker_Common.SUB  -> "<:"
    | FStar_TypeChecker_Common.SUBINV  -> ":>"
  
let (term_to_string : FStar_Syntax_Syntax.term -> Prims.string) =
  fun t  ->
    let uu____770 = FStar_Syntax_Util.head_and_args t  in
    match uu____770 with
    | (head1,args) ->
        (match head1.FStar_Syntax_Syntax.n with
         | FStar_Syntax_Syntax.Tm_uvar (u,s) ->
             let uu____833 = FStar_Syntax_Print.ctx_uvar_to_string u  in
             let uu____835 =
               match FStar_Pervasives_Native.fst s with
               | [] -> ""
               | s1 ->
                   let uu____850 =
                     let uu____852 = FStar_List.hd s1  in
                     FStar_Syntax_Print.subst_to_string uu____852  in
                   FStar_Util.format1 "@<%s>" uu____850
                in
             let uu____856 = FStar_Syntax_Print.args_to_string args  in
             FStar_Util.format3 "%s%s %s" uu____833 uu____835 uu____856
         | uu____859 -> FStar_Syntax_Print.term_to_string t)
  
let (prob_to_string :
  FStar_TypeChecker_Env.env -> FStar_TypeChecker_Common.prob -> Prims.string)
  =
  fun env  ->
    fun uu___1_871  ->
      match uu___1_871 with
      | FStar_TypeChecker_Common.TProb p ->
          let uu____876 =
            let uu____880 =
              FStar_Util.string_of_int p.FStar_TypeChecker_Common.pid  in
            let uu____882 =
              let uu____886 = term_to_string p.FStar_TypeChecker_Common.lhs
                 in
              let uu____888 =
                let uu____892 =
                  let uu____896 =
                    term_to_string p.FStar_TypeChecker_Common.rhs  in
                  [uu____896]  in
                (rel_to_string p.FStar_TypeChecker_Common.relation) ::
                  uu____892
                 in
              uu____886 :: uu____888  in
            uu____880 :: uu____882  in
          FStar_Util.format "\n%s:\t%s \n\t\t%s\n\t%s\n" uu____876
      | FStar_TypeChecker_Common.CProb p ->
          let uu____907 =
            FStar_Util.string_of_int p.FStar_TypeChecker_Common.pid  in
          let uu____909 =
            FStar_TypeChecker_Normalize.comp_to_string env
              p.FStar_TypeChecker_Common.lhs
             in
          let uu____911 =
            FStar_TypeChecker_Normalize.comp_to_string env
              p.FStar_TypeChecker_Common.rhs
             in
          FStar_Util.format4 "\n%s:\t%s \n\t\t%s\n\t%s" uu____907 uu____909
            (rel_to_string p.FStar_TypeChecker_Common.relation) uu____911
  
let (uvi_to_string : FStar_TypeChecker_Env.env -> uvi -> Prims.string) =
  fun env  ->
    fun uu___2_925  ->
      match uu___2_925 with
      | UNIV (u,t) ->
          let x =
            let uu____931 = FStar_Options.hide_uvar_nums ()  in
            if uu____931
            then "?"
            else
              (let uu____938 = FStar_Syntax_Unionfind.univ_uvar_id u  in
               FStar_All.pipe_right uu____938 FStar_Util.string_of_int)
             in
          let uu____942 = FStar_Syntax_Print.univ_to_string t  in
          FStar_Util.format2 "UNIV %s %s" x uu____942
      | TERM (u,t) ->
          let x =
            let uu____949 = FStar_Options.hide_uvar_nums ()  in
            if uu____949
            then "?"
            else
              (let uu____956 =
                 FStar_Syntax_Unionfind.uvar_id
                   u.FStar_Syntax_Syntax.ctx_uvar_head
                  in
               FStar_All.pipe_right uu____956 FStar_Util.string_of_int)
             in
          let uu____960 = FStar_TypeChecker_Normalize.term_to_string env t
             in
          FStar_Util.format2 "TERM %s %s" x uu____960
  
let (uvis_to_string :
  FStar_TypeChecker_Env.env -> uvi Prims.list -> Prims.string) =
  fun env  ->
    fun uvis  ->
      let uu____979 = FStar_List.map (uvi_to_string env) uvis  in
      FStar_All.pipe_right uu____979 (FStar_String.concat ", ")
  
let (names_to_string : FStar_Syntax_Syntax.bv FStar_Util.set -> Prims.string)
  =
  fun nms  ->
    let uu____1000 =
      let uu____1004 = FStar_Util.set_elements nms  in
      FStar_All.pipe_right uu____1004
        (FStar_List.map FStar_Syntax_Print.bv_to_string)
       in
    FStar_All.pipe_right uu____1000 (FStar_String.concat ", ")
  
let args_to_string :
  'Auu____1023 .
    (FStar_Syntax_Syntax.term * 'Auu____1023) Prims.list -> Prims.string
  =
  fun args  ->
    let uu____1042 =
      FStar_All.pipe_right args
        (FStar_List.map
           (fun uu____1063  ->
              match uu____1063 with
              | (x,uu____1070) -> FStar_Syntax_Print.term_to_string x))
       in
    FStar_All.pipe_right uu____1042 (FStar_String.concat " ")
  
let (empty_worklist : FStar_TypeChecker_Env.env -> worklist) =
  fun env  ->
    {
      attempting = [];
      wl_deferred = [];
      ctr = Prims.int_zero;
      defer_ok = true;
      smt_ok = true;
      umax_heuristic_ok = true;
      tcenv = env;
      wl_implicits = []
    }
  
let (giveup :
  FStar_TypeChecker_Env.env ->
    lstring -> FStar_TypeChecker_Common.prob -> solution)
  =
  fun env  ->
    fun reason  ->
      fun prob  ->
        (let uu____1110 =
           FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
             (FStar_Options.Other "Rel")
            in
         if uu____1110
         then
           let uu____1115 = FStar_Thunk.force reason  in
           let uu____1118 = prob_to_string env prob  in
           FStar_Util.print2 "Failed %s:\n%s\n" uu____1115 uu____1118
         else ());
        Failed (prob, reason)
  
let (giveup_lit :
  FStar_TypeChecker_Env.env ->
    Prims.string -> FStar_TypeChecker_Common.prob -> solution)
  =
  fun env  ->
    fun reason  ->
      fun prob  ->
        let uu____1141 = FStar_Thunk.mk (fun uu____1144  -> reason)  in
        giveup env uu____1141 prob
  
let (invert_rel :
  FStar_TypeChecker_Common.rel -> FStar_TypeChecker_Common.rel) =
  fun uu___3_1150  ->
    match uu___3_1150 with
    | FStar_TypeChecker_Common.EQ  -> FStar_TypeChecker_Common.EQ
    | FStar_TypeChecker_Common.SUB  -> FStar_TypeChecker_Common.SUBINV
    | FStar_TypeChecker_Common.SUBINV  -> FStar_TypeChecker_Common.SUB
  
let invert :
  'Auu____1156 .
    'Auu____1156 FStar_TypeChecker_Common.problem ->
      'Auu____1156 FStar_TypeChecker_Common.problem
  =
  fun p  ->
    let uu___143_1168 = p  in
    {
      FStar_TypeChecker_Common.pid =
        (uu___143_1168.FStar_TypeChecker_Common.pid);
      FStar_TypeChecker_Common.lhs = (p.FStar_TypeChecker_Common.rhs);
      FStar_TypeChecker_Common.relation =
        (invert_rel p.FStar_TypeChecker_Common.relation);
      FStar_TypeChecker_Common.rhs = (p.FStar_TypeChecker_Common.lhs);
      FStar_TypeChecker_Common.element =
        (uu___143_1168.FStar_TypeChecker_Common.element);
      FStar_TypeChecker_Common.logical_guard =
        (uu___143_1168.FStar_TypeChecker_Common.logical_guard);
      FStar_TypeChecker_Common.logical_guard_uvar =
        (uu___143_1168.FStar_TypeChecker_Common.logical_guard_uvar);
      FStar_TypeChecker_Common.reason =
        (uu___143_1168.FStar_TypeChecker_Common.reason);
      FStar_TypeChecker_Common.loc =
        (uu___143_1168.FStar_TypeChecker_Common.loc);
      FStar_TypeChecker_Common.rank =
        (uu___143_1168.FStar_TypeChecker_Common.rank)
    }
  
let maybe_invert :
  'Auu____1176 .
    'Auu____1176 FStar_TypeChecker_Common.problem ->
      'Auu____1176 FStar_TypeChecker_Common.problem
  =
  fun p  ->
    if p.FStar_TypeChecker_Common.relation = FStar_TypeChecker_Common.SUBINV
    then invert p
    else p
  
let (maybe_invert_p :
  FStar_TypeChecker_Common.prob -> FStar_TypeChecker_Common.prob) =
  fun uu___4_1196  ->
    match uu___4_1196 with
    | FStar_TypeChecker_Common.TProb p ->
        FStar_All.pipe_right (maybe_invert p)
          (fun _1202  -> FStar_TypeChecker_Common.TProb _1202)
    | FStar_TypeChecker_Common.CProb p ->
        FStar_All.pipe_right (maybe_invert p)
          (fun _1208  -> FStar_TypeChecker_Common.CProb _1208)
  
let (make_prob_eq :
  FStar_TypeChecker_Common.prob -> FStar_TypeChecker_Common.prob) =
  fun uu___5_1214  ->
    match uu___5_1214 with
    | FStar_TypeChecker_Common.TProb p ->
        FStar_TypeChecker_Common.TProb
          (let uu___155_1220 = p  in
           {
             FStar_TypeChecker_Common.pid =
               (uu___155_1220.FStar_TypeChecker_Common.pid);
             FStar_TypeChecker_Common.lhs =
               (uu___155_1220.FStar_TypeChecker_Common.lhs);
             FStar_TypeChecker_Common.relation = FStar_TypeChecker_Common.EQ;
             FStar_TypeChecker_Common.rhs =
               (uu___155_1220.FStar_TypeChecker_Common.rhs);
             FStar_TypeChecker_Common.element =
               (uu___155_1220.FStar_TypeChecker_Common.element);
             FStar_TypeChecker_Common.logical_guard =
               (uu___155_1220.FStar_TypeChecker_Common.logical_guard);
             FStar_TypeChecker_Common.logical_guard_uvar =
               (uu___155_1220.FStar_TypeChecker_Common.logical_guard_uvar);
             FStar_TypeChecker_Common.reason =
               (uu___155_1220.FStar_TypeChecker_Common.reason);
             FStar_TypeChecker_Common.loc =
               (uu___155_1220.FStar_TypeChecker_Common.loc);
             FStar_TypeChecker_Common.rank =
               (uu___155_1220.FStar_TypeChecker_Common.rank)
           })
    | FStar_TypeChecker_Common.CProb p ->
        FStar_TypeChecker_Common.CProb
          (let uu___159_1228 = p  in
           {
             FStar_TypeChecker_Common.pid =
               (uu___159_1228.FStar_TypeChecker_Common.pid);
             FStar_TypeChecker_Common.lhs =
               (uu___159_1228.FStar_TypeChecker_Common.lhs);
             FStar_TypeChecker_Common.relation = FStar_TypeChecker_Common.EQ;
             FStar_TypeChecker_Common.rhs =
               (uu___159_1228.FStar_TypeChecker_Common.rhs);
             FStar_TypeChecker_Common.element =
               (uu___159_1228.FStar_TypeChecker_Common.element);
             FStar_TypeChecker_Common.logical_guard =
               (uu___159_1228.FStar_TypeChecker_Common.logical_guard);
             FStar_TypeChecker_Common.logical_guard_uvar =
               (uu___159_1228.FStar_TypeChecker_Common.logical_guard_uvar);
             FStar_TypeChecker_Common.reason =
               (uu___159_1228.FStar_TypeChecker_Common.reason);
             FStar_TypeChecker_Common.loc =
               (uu___159_1228.FStar_TypeChecker_Common.loc);
             FStar_TypeChecker_Common.rank =
               (uu___159_1228.FStar_TypeChecker_Common.rank)
           })
  
let (vary_rel :
  FStar_TypeChecker_Common.rel -> variance -> FStar_TypeChecker_Common.rel) =
  fun rel  ->
    fun uu___6_1241  ->
      match uu___6_1241 with
      | INVARIANT  -> FStar_TypeChecker_Common.EQ
      | CONTRAVARIANT  -> invert_rel rel
      | COVARIANT  -> rel
  
let (p_pid : FStar_TypeChecker_Common.prob -> Prims.int) =
  fun uu___7_1248  ->
    match uu___7_1248 with
    | FStar_TypeChecker_Common.TProb p -> p.FStar_TypeChecker_Common.pid
    | FStar_TypeChecker_Common.CProb p -> p.FStar_TypeChecker_Common.pid
  
let (p_rel : FStar_TypeChecker_Common.prob -> FStar_TypeChecker_Common.rel) =
  fun uu___8_1261  ->
    match uu___8_1261 with
    | FStar_TypeChecker_Common.TProb p -> p.FStar_TypeChecker_Common.relation
    | FStar_TypeChecker_Common.CProb p -> p.FStar_TypeChecker_Common.relation
  
let (p_reason : FStar_TypeChecker_Common.prob -> Prims.string Prims.list) =
  fun uu___9_1276  ->
    match uu___9_1276 with
    | FStar_TypeChecker_Common.TProb p -> p.FStar_TypeChecker_Common.reason
    | FStar_TypeChecker_Common.CProb p -> p.FStar_TypeChecker_Common.reason
  
let (p_loc : FStar_TypeChecker_Common.prob -> FStar_Range.range) =
  fun uu___10_1291  ->
    match uu___10_1291 with
    | FStar_TypeChecker_Common.TProb p -> p.FStar_TypeChecker_Common.loc
    | FStar_TypeChecker_Common.CProb p -> p.FStar_TypeChecker_Common.loc
  
let (p_element :
  FStar_TypeChecker_Common.prob ->
    FStar_Syntax_Syntax.bv FStar_Pervasives_Native.option)
  =
  fun uu___11_1305  ->
    match uu___11_1305 with
    | FStar_TypeChecker_Common.TProb p -> p.FStar_TypeChecker_Common.element
    | FStar_TypeChecker_Common.CProb p -> p.FStar_TypeChecker_Common.element
  
let (p_guard : FStar_TypeChecker_Common.prob -> FStar_Syntax_Syntax.term) =
  fun uu___12_1319  ->
    match uu___12_1319 with
    | FStar_TypeChecker_Common.TProb p ->
        p.FStar_TypeChecker_Common.logical_guard
    | FStar_TypeChecker_Common.CProb p ->
        p.FStar_TypeChecker_Common.logical_guard
  
let (p_guard_uvar :
  FStar_TypeChecker_Common.prob -> FStar_Syntax_Syntax.ctx_uvar) =
  fun uu___13_1331  ->
    match uu___13_1331 with
    | FStar_TypeChecker_Common.TProb p ->
        p.FStar_TypeChecker_Common.logical_guard_uvar
    | FStar_TypeChecker_Common.CProb p ->
        p.FStar_TypeChecker_Common.logical_guard_uvar
  
let def_scope_wf :
  'Auu____1347 .
    Prims.string ->
      FStar_Range.range ->
        (FStar_Syntax_Syntax.bv * 'Auu____1347) Prims.list -> unit
  =
  fun msg  ->
    fun rng  ->
      fun r  ->
        let uu____1377 =
          let uu____1379 = FStar_Options.defensive ()  in
          Prims.op_Negation uu____1379  in
        if uu____1377
        then ()
        else
          (let rec aux prev next =
             match next with
             | [] -> ()
             | (bv,uu____1416)::bs ->
                 (FStar_TypeChecker_Env.def_check_closed_in rng msg prev
                    bv.FStar_Syntax_Syntax.sort;
                  aux (FStar_List.append prev [bv]) bs)
              in
           aux [] r)
  
let (p_scope :
  FStar_TypeChecker_Common.prob ->
    (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.arg_qualifier
      FStar_Pervasives_Native.option) Prims.list)
  =
  fun prob  ->
    let r =
      match prob with
      | FStar_TypeChecker_Common.TProb p ->
          let uu____1463 =
            match p_element prob with
            | FStar_Pervasives_Native.None  -> []
            | FStar_Pervasives_Native.Some x ->
                let uu____1487 = FStar_Syntax_Syntax.mk_binder x  in
                [uu____1487]
             in
          FStar_List.append
            (p.FStar_TypeChecker_Common.logical_guard_uvar).FStar_Syntax_Syntax.ctx_uvar_binders
            uu____1463
      | FStar_TypeChecker_Common.CProb p ->
          let uu____1515 =
            match p_element prob with
            | FStar_Pervasives_Native.None  -> []
            | FStar_Pervasives_Native.Some x ->
                let uu____1539 = FStar_Syntax_Syntax.mk_binder x  in
                [uu____1539]
             in
          FStar_List.append
            (p.FStar_TypeChecker_Common.logical_guard_uvar).FStar_Syntax_Syntax.ctx_uvar_binders
            uu____1515
       in
    def_scope_wf "p_scope" (p_loc prob) r; r
  
let (def_check_scoped :
  Prims.string ->
    FStar_TypeChecker_Common.prob -> FStar_Syntax_Syntax.term -> unit)
  =
  fun msg  ->
    fun prob  ->
      fun phi  ->
        let uu____1586 =
          let uu____1588 = FStar_Options.defensive ()  in
          Prims.op_Negation uu____1588  in
        if uu____1586
        then ()
        else
          (let uu____1593 =
             let uu____1596 = p_scope prob  in
             FStar_All.pipe_left (FStar_List.map FStar_Pervasives_Native.fst)
               uu____1596
              in
           FStar_TypeChecker_Env.def_check_closed_in (p_loc prob) msg
             uu____1593 phi)
  
let (def_check_scoped_comp :
  Prims.string ->
    FStar_TypeChecker_Common.prob ->
      FStar_Syntax_Syntax.comp' FStar_Syntax_Syntax.syntax -> unit)
  =
  fun msg  ->
    fun prob  ->
      fun comp  ->
        let uu____1645 =
          let uu____1647 = FStar_Options.defensive ()  in
          Prims.op_Negation uu____1647  in
        if uu____1645
        then ()
        else
          (let uu____1652 = FStar_Syntax_Util.arrow [] comp  in
           def_check_scoped msg prob uu____1652)
  
let (def_check_prob : Prims.string -> FStar_TypeChecker_Common.prob -> unit)
  =
  fun msg  ->
    fun prob  ->
      let uu____1672 =
        let uu____1674 = FStar_Options.defensive ()  in
        Prims.op_Negation uu____1674  in
      if uu____1672
      then ()
      else
        (let msgf m =
           let uu____1688 =
             let uu____1690 =
               let uu____1692 = FStar_Util.string_of_int (p_pid prob)  in
               Prims.op_Hat uu____1692 (Prims.op_Hat "." m)  in
             Prims.op_Hat "." uu____1690  in
           Prims.op_Hat msg uu____1688  in
         (let uu____1697 = msgf "scope"  in
          let uu____1700 = p_scope prob  in
          def_scope_wf uu____1697 (p_loc prob) uu____1700);
         (let uu____1712 = msgf "guard"  in
          def_check_scoped uu____1712 prob (p_guard prob));
         (match prob with
          | FStar_TypeChecker_Common.TProb p ->
              ((let uu____1719 = msgf "lhs"  in
                def_check_scoped uu____1719 prob
                  p.FStar_TypeChecker_Common.lhs);
               (let uu____1722 = msgf "rhs"  in
                def_check_scoped uu____1722 prob
                  p.FStar_TypeChecker_Common.rhs))
          | FStar_TypeChecker_Common.CProb p ->
              ((let uu____1729 = msgf "lhs"  in
                def_check_scoped_comp uu____1729 prob
                  p.FStar_TypeChecker_Common.lhs);
               (let uu____1732 = msgf "rhs"  in
                def_check_scoped_comp uu____1732 prob
                  p.FStar_TypeChecker_Common.rhs))))
  
let (singleton :
  worklist -> FStar_TypeChecker_Common.prob -> Prims.bool -> worklist) =
  fun wl  ->
    fun prob  ->
      fun smt_ok  ->
        let uu___252_1753 = wl  in
        {
          attempting = [prob];
          wl_deferred = (uu___252_1753.wl_deferred);
          ctr = (uu___252_1753.ctr);
          defer_ok = (uu___252_1753.defer_ok);
          smt_ok;
          umax_heuristic_ok = (uu___252_1753.umax_heuristic_ok);
          tcenv = (uu___252_1753.tcenv);
          wl_implicits = (uu___252_1753.wl_implicits)
        }
  
let wl_of_guard :
  'Auu____1761 .
    FStar_TypeChecker_Env.env ->
      ('Auu____1761 * FStar_TypeChecker_Common.prob) Prims.list -> worklist
  =
  fun env  ->
    fun g  ->
      let uu___256_1784 = empty_worklist env  in
      let uu____1785 = FStar_List.map FStar_Pervasives_Native.snd g  in
      {
        attempting = uu____1785;
        wl_deferred = (uu___256_1784.wl_deferred);
        ctr = (uu___256_1784.ctr);
        defer_ok = (uu___256_1784.defer_ok);
        smt_ok = (uu___256_1784.smt_ok);
        umax_heuristic_ok = (uu___256_1784.umax_heuristic_ok);
        tcenv = (uu___256_1784.tcenv);
        wl_implicits = (uu___256_1784.wl_implicits)
      }
  
let (defer :
  lstring -> FStar_TypeChecker_Common.prob -> worklist -> worklist) =
  fun reason  ->
    fun prob  ->
      fun wl  ->
        let uu___261_1806 = wl  in
        {
          attempting = (uu___261_1806.attempting);
          wl_deferred = (((wl.ctr), reason, prob) :: (wl.wl_deferred));
          ctr = (uu___261_1806.ctr);
          defer_ok = (uu___261_1806.defer_ok);
          smt_ok = (uu___261_1806.smt_ok);
          umax_heuristic_ok = (uu___261_1806.umax_heuristic_ok);
          tcenv = (uu___261_1806.tcenv);
          wl_implicits = (uu___261_1806.wl_implicits)
        }
  
let (defer_lit :
  Prims.string -> FStar_TypeChecker_Common.prob -> worklist -> worklist) =
  fun reason  ->
    fun prob  ->
      fun wl  ->
        let uu____1833 = FStar_Thunk.mkv reason  in defer uu____1833 prob wl
  
let (attempt :
  FStar_TypeChecker_Common.prob Prims.list -> worklist -> worklist) =
  fun probs  ->
    fun wl  ->
      FStar_List.iter (def_check_prob "attempt") probs;
      (let uu___269_1852 = wl  in
       {
         attempting = (FStar_List.append probs wl.attempting);
         wl_deferred = (uu___269_1852.wl_deferred);
         ctr = (uu___269_1852.ctr);
         defer_ok = (uu___269_1852.defer_ok);
         smt_ok = (uu___269_1852.smt_ok);
         umax_heuristic_ok = (uu___269_1852.umax_heuristic_ok);
         tcenv = (uu___269_1852.tcenv);
         wl_implicits = (uu___269_1852.wl_implicits)
       })
  
let mk_eq2 :
  'Auu____1866 .
    worklist ->
      FStar_TypeChecker_Env.env ->
        'Auu____1866 ->
          FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
            FStar_Syntax_Syntax.term -> (FStar_Syntax_Syntax.term * worklist)
  =
  fun wl  ->
    fun env  ->
      fun prob  ->
        fun t1  ->
          fun t2  ->
            let uu____1900 = FStar_Syntax_Util.type_u ()  in
            match uu____1900 with
            | (t_type,u) ->
                let binders = FStar_TypeChecker_Env.all_binders env  in
                let uu____1912 =
                  new_uvar "eq2" wl t1.FStar_Syntax_Syntax.pos
                    env.FStar_TypeChecker_Env.gamma binders t_type
                    FStar_Syntax_Syntax.Allow_unresolved
                    FStar_Pervasives_Native.None
                   in
                (match uu____1912 with
                 | (uu____1930,tt,wl1) ->
                     let uu____1933 = FStar_Syntax_Util.mk_eq2 u tt t1 t2  in
                     (uu____1933, wl1))
  
let (p_invert :
  FStar_TypeChecker_Common.prob -> FStar_TypeChecker_Common.prob) =
  fun uu___14_1939  ->
    match uu___14_1939 with
    | FStar_TypeChecker_Common.TProb p ->
        FStar_All.pipe_left
          (fun _1945  -> FStar_TypeChecker_Common.TProb _1945) (invert p)
    | FStar_TypeChecker_Common.CProb p ->
        FStar_All.pipe_left
          (fun _1951  -> FStar_TypeChecker_Common.CProb _1951) (invert p)
  
let (is_top_level_prob : FStar_TypeChecker_Common.prob -> Prims.bool) =
  fun p  ->
    let uu____1959 = FStar_All.pipe_right (p_reason p) FStar_List.length  in
    uu____1959 = Prims.int_one
  
let (next_pid : unit -> Prims.int) =
  let ctr = FStar_Util.mk_ref Prims.int_zero  in
  fun uu____1979  -> FStar_Util.incr ctr; FStar_ST.op_Bang ctr 
let mk_problem :
  'Auu____2021 .
    worklist ->
      (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.arg_qualifier
        FStar_Pervasives_Native.option) Prims.list ->
        FStar_TypeChecker_Common.prob ->
          'Auu____2021 ->
            FStar_TypeChecker_Common.rel ->
              'Auu____2021 ->
                FStar_Syntax_Syntax.bv FStar_Pervasives_Native.option ->
                  Prims.string ->
                    ('Auu____2021 FStar_TypeChecker_Common.problem *
                      worklist)
  =
  fun wl  ->
    fun scope  ->
      fun orig  ->
        fun lhs  ->
          fun rel  ->
            fun rhs  ->
              fun elt  ->
                fun reason  ->
                  let scope1 =
                    match elt with
                    | FStar_Pervasives_Native.None  -> scope
                    | FStar_Pervasives_Native.Some x ->
                        let uu____2108 =
                          let uu____2117 = FStar_Syntax_Syntax.mk_binder x
                             in
                          [uu____2117]  in
                        FStar_List.append scope uu____2108
                     in
                  let bs =
                    FStar_List.append
                      (p_guard_uvar orig).FStar_Syntax_Syntax.ctx_uvar_binders
                      scope1
                     in
                  let gamma =
                    let uu____2160 =
                      let uu____2163 =
                        FStar_List.map
                          (fun b  ->
                             FStar_Syntax_Syntax.Binding_var
                               (FStar_Pervasives_Native.fst b)) scope1
                         in
                      FStar_List.rev uu____2163  in
                    FStar_List.append uu____2160
                      (p_guard_uvar orig).FStar_Syntax_Syntax.ctx_uvar_gamma
                     in
                  let uu____2182 =
                    new_uvar
                      (Prims.op_Hat "mk_problem: logical guard for " reason)
                      wl FStar_Range.dummyRange gamma bs
                      FStar_Syntax_Util.ktype0
                      FStar_Syntax_Syntax.Allow_untyped
                      FStar_Pervasives_Native.None
                     in
                  match uu____2182 with
                  | (ctx_uvar,lg,wl1) ->
                      let prob =
                        let uu____2208 = next_pid ()  in
                        {
                          FStar_TypeChecker_Common.pid = uu____2208;
                          FStar_TypeChecker_Common.lhs = lhs;
                          FStar_TypeChecker_Common.relation = rel;
                          FStar_TypeChecker_Common.rhs = rhs;
                          FStar_TypeChecker_Common.element = elt;
                          FStar_TypeChecker_Common.logical_guard = lg;
                          FStar_TypeChecker_Common.logical_guard_uvar =
                            ctx_uvar;
                          FStar_TypeChecker_Common.reason = (reason ::
                            (p_reason orig));
                          FStar_TypeChecker_Common.loc = (p_loc orig);
                          FStar_TypeChecker_Common.rank =
                            FStar_Pervasives_Native.None
                        }  in
                      (prob, wl1)
  
let (mk_t_problem :
  worklist ->
    (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.arg_qualifier
      FStar_Pervasives_Native.option) Prims.list ->
      FStar_TypeChecker_Common.prob ->
        FStar_Syntax_Syntax.typ ->
          FStar_TypeChecker_Common.rel ->
            FStar_Syntax_Syntax.typ ->
              FStar_Syntax_Syntax.bv FStar_Pervasives_Native.option ->
                Prims.string -> (FStar_TypeChecker_Common.prob * worklist))
  =
  fun wl  ->
    fun scope  ->
      fun orig  ->
        fun lhs  ->
          fun rel  ->
            fun rhs  ->
              fun elt  ->
                fun reason  ->
                  def_check_prob (Prims.op_Hat reason ".mk_t.arg") orig;
                  (let uu____2282 =
                     mk_problem wl scope orig lhs rel rhs elt reason  in
                   match uu____2282 with
                   | (p,wl1) ->
                       (def_check_prob (Prims.op_Hat reason ".mk_t")
                          (FStar_TypeChecker_Common.TProb p);
                        ((FStar_TypeChecker_Common.TProb p), wl1)))
  
let (mk_c_problem :
  worklist ->
    (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.arg_qualifier
      FStar_Pervasives_Native.option) Prims.list ->
      FStar_TypeChecker_Common.prob ->
        FStar_Syntax_Syntax.comp ->
          FStar_TypeChecker_Common.rel ->
            FStar_Syntax_Syntax.comp ->
              FStar_Syntax_Syntax.bv FStar_Pervasives_Native.option ->
                Prims.string -> (FStar_TypeChecker_Common.prob * worklist))
  =
  fun wl  ->
    fun scope  ->
      fun orig  ->
        fun lhs  ->
          fun rel  ->
            fun rhs  ->
              fun elt  ->
                fun reason  ->
                  def_check_prob (Prims.op_Hat reason ".mk_c.arg") orig;
                  (let uu____2370 =
                     mk_problem wl scope orig lhs rel rhs elt reason  in
                   match uu____2370 with
                   | (p,wl1) ->
                       (def_check_prob (Prims.op_Hat reason ".mk_c")
                          (FStar_TypeChecker_Common.CProb p);
                        ((FStar_TypeChecker_Common.CProb p), wl1)))
  
let new_problem :
  'Auu____2408 .
    worklist ->
      FStar_TypeChecker_Env.env ->
        'Auu____2408 ->
          FStar_TypeChecker_Common.rel ->
            'Auu____2408 ->
              FStar_Syntax_Syntax.bv FStar_Pervasives_Native.option ->
                FStar_Range.range ->
                  Prims.string ->
                    ('Auu____2408 FStar_TypeChecker_Common.problem *
                      worklist)
  =
  fun wl  ->
    fun env  ->
      fun lhs  ->
        fun rel  ->
          fun rhs  ->
            fun subject  ->
              fun loc  ->
                fun reason  ->
                  let lg_ty =
                    match subject with
                    | FStar_Pervasives_Native.None  ->
                        FStar_Syntax_Util.ktype0
                    | FStar_Pervasives_Native.Some x ->
                        let bs =
                          let uu____2476 = FStar_Syntax_Syntax.mk_binder x
                             in
                          [uu____2476]  in
                        let uu____2495 =
                          FStar_Syntax_Syntax.mk_Total
                            FStar_Syntax_Util.ktype0
                           in
                        FStar_Syntax_Util.arrow bs uu____2495
                     in
                  let uu____2498 =
                    let uu____2505 = FStar_TypeChecker_Env.all_binders env
                       in
                    new_uvar
                      (Prims.op_Hat "new_problem: logical guard for " reason)
                      (let uu___352_2516 = wl  in
                       {
                         attempting = (uu___352_2516.attempting);
                         wl_deferred = (uu___352_2516.wl_deferred);
                         ctr = (uu___352_2516.ctr);
                         defer_ok = (uu___352_2516.defer_ok);
                         smt_ok = (uu___352_2516.smt_ok);
                         umax_heuristic_ok =
                           (uu___352_2516.umax_heuristic_ok);
                         tcenv = env;
                         wl_implicits = (uu___352_2516.wl_implicits)
                       }) loc env.FStar_TypeChecker_Env.gamma uu____2505
                      lg_ty FStar_Syntax_Syntax.Allow_untyped
                      FStar_Pervasives_Native.None
                     in
                  match uu____2498 with
                  | (ctx_uvar,lg,wl1) ->
                      let lg1 =
                        match subject with
                        | FStar_Pervasives_Native.None  -> lg
                        | FStar_Pervasives_Native.Some x ->
                            let uu____2534 =
                              let uu____2539 =
                                let uu____2540 =
                                  let uu____2549 =
                                    FStar_Syntax_Syntax.bv_to_name x  in
                                  FStar_All.pipe_left
                                    FStar_Syntax_Syntax.as_arg uu____2549
                                   in
                                [uu____2540]  in
                              FStar_Syntax_Syntax.mk_Tm_app lg uu____2539  in
                            uu____2534 FStar_Pervasives_Native.None loc
                         in
                      let prob =
                        let uu____2577 = next_pid ()  in
                        {
                          FStar_TypeChecker_Common.pid = uu____2577;
                          FStar_TypeChecker_Common.lhs = lhs;
                          FStar_TypeChecker_Common.relation = rel;
                          FStar_TypeChecker_Common.rhs = rhs;
                          FStar_TypeChecker_Common.element = subject;
                          FStar_TypeChecker_Common.logical_guard = lg1;
                          FStar_TypeChecker_Common.logical_guard_uvar =
                            ctx_uvar;
                          FStar_TypeChecker_Common.reason = [reason];
                          FStar_TypeChecker_Common.loc = loc;
                          FStar_TypeChecker_Common.rank =
                            FStar_Pervasives_Native.None
                        }  in
                      (prob, wl1)
  
let (problem_using_guard :
  FStar_TypeChecker_Common.prob ->
    FStar_Syntax_Syntax.typ ->
      FStar_TypeChecker_Common.rel ->
        FStar_Syntax_Syntax.typ ->
          FStar_Syntax_Syntax.bv FStar_Pervasives_Native.option ->
            Prims.string ->
              FStar_Syntax_Syntax.typ FStar_TypeChecker_Common.problem)
  =
  fun orig  ->
    fun lhs  ->
      fun rel  ->
        fun rhs  ->
          fun elt  ->
            fun reason  ->
              let p =
                let uu____2625 = next_pid ()  in
                {
                  FStar_TypeChecker_Common.pid = uu____2625;
                  FStar_TypeChecker_Common.lhs = lhs;
                  FStar_TypeChecker_Common.relation = rel;
                  FStar_TypeChecker_Common.rhs = rhs;
                  FStar_TypeChecker_Common.element = elt;
                  FStar_TypeChecker_Common.logical_guard = (p_guard orig);
                  FStar_TypeChecker_Common.logical_guard_uvar =
                    (p_guard_uvar orig);
                  FStar_TypeChecker_Common.reason = (reason ::
                    (p_reason orig));
                  FStar_TypeChecker_Common.loc = (p_loc orig);
                  FStar_TypeChecker_Common.rank =
                    FStar_Pervasives_Native.None
                }  in
              def_check_prob reason (FStar_TypeChecker_Common.TProb p); p
  
let guard_on_element :
  'Auu____2640 .
    worklist ->
      'Auu____2640 FStar_TypeChecker_Common.problem ->
        FStar_Syntax_Syntax.bv ->
          FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
            FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax
  =
  fun wl  ->
    fun problem  ->
      fun x  ->
        fun phi  ->
          match problem.FStar_TypeChecker_Common.element with
          | FStar_Pervasives_Native.None  ->
              let u =
                (wl.tcenv).FStar_TypeChecker_Env.universe_of wl.tcenv
                  x.FStar_Syntax_Syntax.sort
                 in
              FStar_Syntax_Util.mk_forall u x phi
          | FStar_Pervasives_Native.Some e ->
              let uu____2673 =
                let uu____2676 =
                  let uu____2677 =
                    let uu____2684 = FStar_Syntax_Syntax.bv_to_name e  in
                    (x, uu____2684)  in
                  FStar_Syntax_Syntax.NT uu____2677  in
                [uu____2676]  in
              FStar_Syntax_Subst.subst uu____2673 phi
  
let (explain :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob -> lstring -> Prims.string)
  =
  fun env  ->
    fun d  ->
      fun s  ->
        let uu____2706 =
          (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
             (FStar_Options.Other "ExplainRel"))
            ||
            (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
               (FStar_Options.Other "Rel"))
           in
        if uu____2706
        then
          let uu____2714 =
            FStar_All.pipe_left FStar_Range.string_of_range (p_loc d)  in
          let uu____2717 = prob_to_string env d  in
          let uu____2719 =
            FStar_All.pipe_right (p_reason d) (FStar_String.concat "\n\t>")
             in
          let uu____2726 = FStar_Thunk.force s  in
          FStar_Util.format4
            "(%s) Failed to solve the sub-problem\n%s\nWhich arose because:\n\t%s\nFailed because:%s\n"
            uu____2714 uu____2717 uu____2719 uu____2726
        else
          (let d1 = maybe_invert_p d  in
           let rel =
             match p_rel d1 with
             | FStar_TypeChecker_Common.EQ  -> "equal to"
             | FStar_TypeChecker_Common.SUB  -> "a subtype of"
             | uu____2738 -> failwith "impossible"  in
           let uu____2741 =
             match d1 with
             | FStar_TypeChecker_Common.TProb tp ->
                 FStar_TypeChecker_Err.print_discrepancy
                   (FStar_TypeChecker_Normalize.term_to_string env)
                   tp.FStar_TypeChecker_Common.lhs
                   tp.FStar_TypeChecker_Common.rhs
             | FStar_TypeChecker_Common.CProb cp ->
                 FStar_TypeChecker_Err.print_discrepancy
                   (FStar_TypeChecker_Normalize.comp_to_string env)
                   cp.FStar_TypeChecker_Common.lhs
                   cp.FStar_TypeChecker_Common.rhs
              in
           match uu____2741 with
           | (lhs,rhs) ->
               FStar_Util.format3 "%s is not %s the expected type %s" lhs rel
                 rhs)
  
let (commit : uvi Prims.list -> unit) =
  fun uvis  ->
    FStar_All.pipe_right uvis
      (FStar_List.iter
         (fun uu___15_2784  ->
            match uu___15_2784 with
            | UNIV (u,t) ->
                (match t with
                 | FStar_Syntax_Syntax.U_unif u' ->
                     FStar_Syntax_Unionfind.univ_union u u'
                 | uu____2796 -> FStar_Syntax_Unionfind.univ_change u t)
            | TERM (u,t) ->
                ((let uu____2800 =
                    FStar_List.map FStar_Pervasives_Native.fst
                      u.FStar_Syntax_Syntax.ctx_uvar_binders
                     in
                  FStar_TypeChecker_Env.def_check_closed_in
                    t.FStar_Syntax_Syntax.pos "commit" uu____2800 t);
                 FStar_Syntax_Util.set_uvar
                   u.FStar_Syntax_Syntax.ctx_uvar_head t)))
  
let (find_term_uvar :
  FStar_Syntax_Syntax.uvar ->
    uvi Prims.list -> FStar_Syntax_Syntax.term FStar_Pervasives_Native.option)
  =
  fun uv  ->
    fun s  ->
      FStar_Util.find_map s
        (fun uu___16_2831  ->
           match uu___16_2831 with
           | UNIV uu____2834 -> FStar_Pervasives_Native.None
           | TERM (u,t) ->
               let uu____2841 =
                 FStar_Syntax_Unionfind.equiv uv
                   u.FStar_Syntax_Syntax.ctx_uvar_head
                  in
               if uu____2841
               then FStar_Pervasives_Native.Some t
               else FStar_Pervasives_Native.None)
  
let (find_univ_uvar :
  FStar_Syntax_Syntax.universe_uvar ->
    uvi Prims.list ->
      FStar_Syntax_Syntax.universe FStar_Pervasives_Native.option)
  =
  fun u  ->
    fun s  ->
      FStar_Util.find_map s
        (fun uu___17_2869  ->
           match uu___17_2869 with
           | UNIV (u',t) ->
               let uu____2874 = FStar_Syntax_Unionfind.univ_equiv u u'  in
               if uu____2874
               then FStar_Pervasives_Native.Some t
               else FStar_Pervasives_Native.None
           | uu____2881 -> FStar_Pervasives_Native.None)
  
let (whnf' :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term -> FStar_Syntax_Syntax.term)
  =
  fun env  ->
    fun t  ->
      let uu____2893 =
        let uu____2894 =
          let uu____2895 = FStar_Syntax_Util.unmeta t  in
          FStar_TypeChecker_Normalize.normalize
            [FStar_TypeChecker_Env.Beta;
            FStar_TypeChecker_Env.Reify;
            FStar_TypeChecker_Env.Weak;
            FStar_TypeChecker_Env.HNF] env uu____2895
           in
        FStar_Syntax_Subst.compress uu____2894  in
      FStar_All.pipe_right uu____2893 FStar_Syntax_Util.unlazy_emb
  
let (sn' :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term -> FStar_Syntax_Syntax.term)
  =
  fun env  ->
    fun t  ->
      let uu____2907 =
        let uu____2908 =
          FStar_TypeChecker_Normalize.normalize
            [FStar_TypeChecker_Env.Beta; FStar_TypeChecker_Env.Reify] env t
           in
        FStar_Syntax_Subst.compress uu____2908  in
      FStar_All.pipe_right uu____2907 FStar_Syntax_Util.unlazy_emb
  
let (sn :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term -> FStar_Syntax_Syntax.term)
  =
  fun env  ->
    fun t  ->
      let uu____2920 =
        let uu____2924 =
          let uu____2926 = FStar_TypeChecker_Env.current_module env  in
          FStar_Ident.string_of_lid uu____2926  in
        FStar_Pervasives_Native.Some uu____2924  in
      FStar_Profiling.profile (fun uu____2929  -> sn' env t) uu____2920
        "FStar.TypeChecker.Rel.sn"
  
let (norm_with_steps :
  Prims.string ->
    FStar_TypeChecker_Env.steps ->
      FStar_TypeChecker_Env.env ->
        FStar_Syntax_Syntax.term -> FStar_Syntax_Syntax.term)
  =
  fun profiling_tag  ->
    fun steps  ->
      fun env  ->
        fun t  ->
          let uu____2954 =
            let uu____2958 =
              let uu____2960 = FStar_TypeChecker_Env.current_module env  in
              FStar_Ident.string_of_lid uu____2960  in
            FStar_Pervasives_Native.Some uu____2958  in
          FStar_Profiling.profile
            (fun uu____2963  ->
               FStar_TypeChecker_Normalize.normalize steps env t) uu____2954
            profiling_tag
  
let (should_strongly_reduce : FStar_Syntax_Syntax.term -> Prims.bool) =
  fun t  ->
    let uu____2971 = FStar_Syntax_Util.head_and_args t  in
    match uu____2971 with
    | (h,uu____2990) ->
        let uu____3015 =
          let uu____3016 = FStar_Syntax_Subst.compress h  in
          uu____3016.FStar_Syntax_Syntax.n  in
        (match uu____3015 with
         | FStar_Syntax_Syntax.Tm_constant (FStar_Const.Const_reify ) -> true
         | uu____3021 -> false)
  
let (whnf :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term -> FStar_Syntax_Syntax.term)
  =
  fun env  ->
    fun t  ->
      let uu____3034 =
        let uu____3038 =
          let uu____3040 = FStar_TypeChecker_Env.current_module env  in
          FStar_Ident.string_of_lid uu____3040  in
        FStar_Pervasives_Native.Some uu____3038  in
      FStar_Profiling.profile
        (fun uu____3045  ->
           let uu____3046 = should_strongly_reduce t  in
           if uu____3046
           then
             let uu____3049 =
               let uu____3050 =
                 FStar_TypeChecker_Normalize.normalize
                   [FStar_TypeChecker_Env.Beta;
                   FStar_TypeChecker_Env.Reify;
                   FStar_TypeChecker_Env.Exclude FStar_TypeChecker_Env.Zeta;
                   FStar_TypeChecker_Env.UnfoldUntil
                     FStar_Syntax_Syntax.delta_constant] env t
                  in
               FStar_Syntax_Subst.compress uu____3050  in
             FStar_All.pipe_right uu____3049 FStar_Syntax_Util.unlazy_emb
           else whnf' env t) uu____3034 "FStar.TypeChecker.Rel.whnf"
  
let norm_arg :
  'Auu____3061 .
    FStar_TypeChecker_Env.env ->
      (FStar_Syntax_Syntax.term * 'Auu____3061) ->
        (FStar_Syntax_Syntax.term * 'Auu____3061)
  =
  fun env  ->
    fun t  ->
      let uu____3084 = sn env (FStar_Pervasives_Native.fst t)  in
      (uu____3084, (FStar_Pervasives_Native.snd t))
  
let (sn_binders :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.binders ->
      (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.arg_qualifier
        FStar_Pervasives_Native.option) Prims.list)
  =
  fun env  ->
    fun binders  ->
      FStar_All.pipe_right binders
        (FStar_List.map
           (fun uu____3136  ->
              match uu____3136 with
              | (x,imp) ->
                  let uu____3155 =
                    let uu___458_3156 = x  in
                    let uu____3157 = sn env x.FStar_Syntax_Syntax.sort  in
                    {
                      FStar_Syntax_Syntax.ppname =
                        (uu___458_3156.FStar_Syntax_Syntax.ppname);
                      FStar_Syntax_Syntax.index =
                        (uu___458_3156.FStar_Syntax_Syntax.index);
                      FStar_Syntax_Syntax.sort = uu____3157
                    }  in
                  (uu____3155, imp)))
  
let (norm_univ :
  worklist -> FStar_Syntax_Syntax.universe -> FStar_Syntax_Syntax.universe) =
  fun wl  ->
    fun u  ->
      let rec aux u1 =
        let u2 = FStar_Syntax_Subst.compress_univ u1  in
        match u2 with
        | FStar_Syntax_Syntax.U_succ u3 ->
            let uu____3181 = aux u3  in FStar_Syntax_Syntax.U_succ uu____3181
        | FStar_Syntax_Syntax.U_max us ->
            let uu____3185 = FStar_List.map aux us  in
            FStar_Syntax_Syntax.U_max uu____3185
        | uu____3188 -> u2  in
      let uu____3189 = aux u  in
      FStar_TypeChecker_Normalize.normalize_universe wl.tcenv uu____3189
  
let (normalize_refinement :
  FStar_TypeChecker_Env.steps ->
    FStar_TypeChecker_Env.env ->
      FStar_Syntax_Syntax.typ -> FStar_Syntax_Syntax.term)
  =
  fun steps  ->
    fun env  ->
      fun t0  ->
        let uu____3206 =
          let uu____3210 =
            let uu____3212 = FStar_TypeChecker_Env.current_module env  in
            FStar_Ident.string_of_lid uu____3212  in
          FStar_Pervasives_Native.Some uu____3210  in
        FStar_Profiling.profile
          (fun uu____3215  ->
             FStar_TypeChecker_Normalize.normalize_refinement steps env t0)
          uu____3206 "FStar.TypeChecker.Rel.normalize_refinement"
  
let (base_and_refinement_maybe_delta :
  Prims.bool ->
    FStar_TypeChecker_Env.env ->
      FStar_Syntax_Syntax.term ->
        (FStar_Syntax_Syntax.term * (FStar_Syntax_Syntax.bv *
          FStar_Syntax_Syntax.term) FStar_Pervasives_Native.option))
  =
  fun should_delta  ->
    fun env  ->
      fun t1  ->
        let norm_refinement env1 t =
          let steps =
            if should_delta
            then
              [FStar_TypeChecker_Env.Weak;
              FStar_TypeChecker_Env.HNF;
              FStar_TypeChecker_Env.UnfoldUntil
                FStar_Syntax_Syntax.delta_constant]
            else [FStar_TypeChecker_Env.Weak; FStar_TypeChecker_Env.HNF]  in
          normalize_refinement steps env1 t  in
        let rec aux norm1 t11 =
          let t12 = FStar_Syntax_Util.unmeta t11  in
          match t12.FStar_Syntax_Syntax.n with
          | FStar_Syntax_Syntax.Tm_refine (x,phi) ->
              if norm1
              then
                ((x.FStar_Syntax_Syntax.sort),
                  (FStar_Pervasives_Native.Some (x, phi)))
              else
                (let uu____3337 = norm_refinement env t12  in
                 match uu____3337 with
                 | {
                     FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_refine
                       (x1,phi1);
                     FStar_Syntax_Syntax.pos = uu____3352;
                     FStar_Syntax_Syntax.vars = uu____3353;_} ->
                     ((x1.FStar_Syntax_Syntax.sort),
                       (FStar_Pervasives_Native.Some (x1, phi1)))
                 | tt ->
                     let uu____3377 =
                       let uu____3379 = FStar_Syntax_Print.term_to_string tt
                          in
                       let uu____3381 = FStar_Syntax_Print.tag_of_term tt  in
                       FStar_Util.format2 "impossible: Got %s ... %s\n"
                         uu____3379 uu____3381
                        in
                     failwith uu____3377)
          | FStar_Syntax_Syntax.Tm_lazy i ->
              let uu____3397 = FStar_Syntax_Util.unfold_lazy i  in
              aux norm1 uu____3397
          | FStar_Syntax_Syntax.Tm_uinst uu____3398 ->
              if norm1
              then (t12, FStar_Pervasives_Native.None)
              else
                (let t1' = norm_refinement env t12  in
                 let uu____3435 =
                   let uu____3436 = FStar_Syntax_Subst.compress t1'  in
                   uu____3436.FStar_Syntax_Syntax.n  in
                 match uu____3435 with
                 | FStar_Syntax_Syntax.Tm_refine uu____3451 -> aux true t1'
                 | uu____3459 -> (t12, FStar_Pervasives_Native.None))
          | FStar_Syntax_Syntax.Tm_fvar uu____3474 ->
              if norm1
              then (t12, FStar_Pervasives_Native.None)
              else
                (let t1' = norm_refinement env t12  in
                 let uu____3505 =
                   let uu____3506 = FStar_Syntax_Subst.compress t1'  in
                   uu____3506.FStar_Syntax_Syntax.n  in
                 match uu____3505 with
                 | FStar_Syntax_Syntax.Tm_refine uu____3521 -> aux true t1'
                 | uu____3529 -> (t12, FStar_Pervasives_Native.None))
          | FStar_Syntax_Syntax.Tm_app uu____3544 ->
              if norm1
              then (t12, FStar_Pervasives_Native.None)
              else
                (let t1' = norm_refinement env t12  in
                 let uu____3591 =
                   let uu____3592 = FStar_Syntax_Subst.compress t1'  in
                   uu____3592.FStar_Syntax_Syntax.n  in
                 match uu____3591 with
                 | FStar_Syntax_Syntax.Tm_refine uu____3607 -> aux true t1'
                 | uu____3615 -> (t12, FStar_Pervasives_Native.None))
          | FStar_Syntax_Syntax.Tm_type uu____3630 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_constant uu____3645 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_name uu____3660 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_bvar uu____3675 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_arrow uu____3690 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_abs uu____3719 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_quoted uu____3752 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_uvar uu____3773 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_let uu____3800 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_match uu____3828 ->
              (t12, FStar_Pervasives_Native.None)
          | FStar_Syntax_Syntax.Tm_meta uu____3865 ->
              let uu____3872 =
                let uu____3874 = FStar_Syntax_Print.term_to_string t12  in
                let uu____3876 = FStar_Syntax_Print.tag_of_term t12  in
                FStar_Util.format2 "impossible (outer): Got %s ... %s\n"
                  uu____3874 uu____3876
                 in
              failwith uu____3872
          | FStar_Syntax_Syntax.Tm_ascribed uu____3891 ->
              let uu____3918 =
                let uu____3920 = FStar_Syntax_Print.term_to_string t12  in
                let uu____3922 = FStar_Syntax_Print.tag_of_term t12  in
                FStar_Util.format2 "impossible (outer): Got %s ... %s\n"
                  uu____3920 uu____3922
                 in
              failwith uu____3918
          | FStar_Syntax_Syntax.Tm_delayed uu____3937 ->
              let uu____3960 =
                let uu____3962 = FStar_Syntax_Print.term_to_string t12  in
                let uu____3964 = FStar_Syntax_Print.tag_of_term t12  in
                FStar_Util.format2 "impossible (outer): Got %s ... %s\n"
                  uu____3962 uu____3964
                 in
              failwith uu____3960
          | FStar_Syntax_Syntax.Tm_unknown  ->
              let uu____3979 =
                let uu____3981 = FStar_Syntax_Print.term_to_string t12  in
                let uu____3983 = FStar_Syntax_Print.tag_of_term t12  in
                FStar_Util.format2 "impossible (outer): Got %s ... %s\n"
                  uu____3981 uu____3983
                 in
              failwith uu____3979
           in
        let uu____3998 = whnf env t1  in aux false uu____3998
  
let (base_and_refinement :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term ->
      (FStar_Syntax_Syntax.term * (FStar_Syntax_Syntax.bv *
        FStar_Syntax_Syntax.term) FStar_Pervasives_Native.option))
  = fun env  -> fun t  -> base_and_refinement_maybe_delta false env t 
let (unrefine :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ -> FStar_Syntax_Syntax.typ)
  =
  fun env  ->
    fun t  ->
      let uu____4043 = base_and_refinement env t  in
      FStar_All.pipe_right uu____4043 FStar_Pervasives_Native.fst
  
let (trivial_refinement :
  FStar_Syntax_Syntax.term ->
    (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.term))
  =
  fun t  ->
    let uu____4084 = FStar_Syntax_Syntax.null_bv t  in
    (uu____4084, FStar_Syntax_Util.t_true)
  
let (as_refinement :
  Prims.bool ->
    FStar_TypeChecker_Env.env ->
      FStar_Syntax_Syntax.term ->
        (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.term))
  =
  fun delta1  ->
    fun env  ->
      fun t  ->
        let uu____4111 = base_and_refinement_maybe_delta delta1 env t  in
        match uu____4111 with
        | (t_base,refinement) ->
            (match refinement with
             | FStar_Pervasives_Native.None  -> trivial_refinement t_base
             | FStar_Pervasives_Native.Some (x,phi) -> (x, phi))
  
let (force_refinement :
  (FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax *
    (FStar_Syntax_Syntax.bv * FStar_Syntax_Syntax.term)
    FStar_Pervasives_Native.option) -> FStar_Syntax_Syntax.term)
  =
  fun uu____4171  ->
    match uu____4171 with
    | (t_base,refopt) ->
        let uu____4202 =
          match refopt with
          | FStar_Pervasives_Native.Some (y,phi) -> (y, phi)
          | FStar_Pervasives_Native.None  -> trivial_refinement t_base  in
        (match uu____4202 with
         | (y,phi) ->
             FStar_Syntax_Syntax.mk (FStar_Syntax_Syntax.Tm_refine (y, phi))
               FStar_Pervasives_Native.None t_base.FStar_Syntax_Syntax.pos)
  
let (wl_prob_to_string :
  worklist -> FStar_TypeChecker_Common.prob -> Prims.string) =
  fun wl  -> fun prob  -> prob_to_string wl.tcenv prob 
let (wl_to_string : worklist -> Prims.string) =
  fun wl  ->
    let uu____4244 =
      let uu____4248 =
        let uu____4251 =
          FStar_All.pipe_right wl.wl_deferred
            (FStar_List.map
               (fun uu____4276  ->
                  match uu____4276 with | (uu____4284,uu____4285,x) -> x))
           in
        FStar_List.append wl.attempting uu____4251  in
      FStar_List.map (wl_prob_to_string wl) uu____4248  in
    FStar_All.pipe_right uu____4244 (FStar_String.concat "\n\t")
  
type flex_t =
  (FStar_Syntax_Syntax.term * FStar_Syntax_Syntax.ctx_uvar *
    FStar_Syntax_Syntax.args)
let flex_t_to_string :
  'Auu____4306 .
    ('Auu____4306 * FStar_Syntax_Syntax.ctx_uvar * FStar_Syntax_Syntax.args)
      -> Prims.string
  =
  fun uu____4318  ->
    match uu____4318 with
    | (uu____4325,c,args) ->
        let uu____4328 = print_ctx_uvar c  in
        let uu____4330 = FStar_Syntax_Print.args_to_string args  in
        FStar_Util.format2 "%s [%s]" uu____4328 uu____4330
  
let (is_flex : FStar_Syntax_Syntax.term -> Prims.bool) =
  fun t  ->
    let uu____4340 = FStar_Syntax_Util.head_and_args t  in
    match uu____4340 with
    | (head1,_args) ->
        let uu____4384 =
          let uu____4385 = FStar_Syntax_Subst.compress head1  in
          uu____4385.FStar_Syntax_Syntax.n  in
        (match uu____4384 with
         | FStar_Syntax_Syntax.Tm_uvar uu____4389 -> true
         | uu____4403 -> false)
  
let (flex_uvar_head :
  FStar_Syntax_Syntax.term -> FStar_Syntax_Syntax.ctx_uvar) =
  fun t  ->
    let uu____4411 = FStar_Syntax_Util.head_and_args t  in
    match uu____4411 with
    | (head1,_args) ->
        let uu____4454 =
          let uu____4455 = FStar_Syntax_Subst.compress head1  in
          uu____4455.FStar_Syntax_Syntax.n  in
        (match uu____4454 with
         | FStar_Syntax_Syntax.Tm_uvar (u,uu____4459) -> u
         | uu____4476 -> failwith "Not a flex-uvar")
  
let (destruct_flex_t :
  FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
    worklist -> (flex_t * worklist))
  =
  fun t  ->
    fun wl  ->
      let uu____4501 = FStar_Syntax_Util.head_and_args t  in
      match uu____4501 with
      | (head1,args) ->
          let uu____4548 =
            let uu____4549 = FStar_Syntax_Subst.compress head1  in
            uu____4549.FStar_Syntax_Syntax.n  in
          (match uu____4548 with
           | FStar_Syntax_Syntax.Tm_uvar (uv,([],uu____4557)) ->
               ((t, uv, args), wl)
           | FStar_Syntax_Syntax.Tm_uvar (uv,s) ->
               let uu____4590 =
                 FStar_All.pipe_right uv.FStar_Syntax_Syntax.ctx_uvar_gamma
                   (FStar_List.partition
                      (fun uu___18_4615  ->
                         match uu___18_4615 with
                         | FStar_Syntax_Syntax.Binding_var x ->
                             let t_x = FStar_Syntax_Syntax.bv_to_name x  in
                             let t_x' = FStar_Syntax_Subst.subst' s t_x  in
                             let uu____4620 =
                               let uu____4621 =
                                 FStar_Syntax_Subst.compress t_x'  in
                               uu____4621.FStar_Syntax_Syntax.n  in
                             (match uu____4620 with
                              | FStar_Syntax_Syntax.Tm_name y ->
                                  FStar_Syntax_Syntax.bv_eq x y
                              | uu____4626 -> false)
                         | uu____4628 -> true))
                  in
               (match uu____4590 with
                | (new_gamma,dom_binders_rev) ->
                    let dom_binders =
                      let uu____4653 =
                        FStar_List.collect
                          (fun uu___19_4665  ->
                             match uu___19_4665 with
                             | FStar_Syntax_Syntax.Binding_var x ->
                                 let uu____4669 =
                                   FStar_Syntax_Syntax.mk_binder x  in
                                 [uu____4669]
                             | uu____4670 -> []) dom_binders_rev
                         in
                      FStar_All.pipe_right uu____4653 FStar_List.rev  in
                    let uu____4693 =
                      let uu____4700 =
                        let uu____4709 =
                          FStar_All.pipe_right new_gamma
                            (FStar_List.collect
                               (fun uu___20_4731  ->
                                  match uu___20_4731 with
                                  | FStar_Syntax_Syntax.Binding_var x ->
                                      let uu____4735 =
                                        FStar_Syntax_Syntax.mk_binder x  in
                                      [uu____4735]
                                  | uu____4736 -> []))
                           in
                        FStar_All.pipe_right uu____4709 FStar_List.rev  in
                      let uu____4759 =
                        let uu____4762 =
                          FStar_Syntax_Syntax.mk_Total
                            uv.FStar_Syntax_Syntax.ctx_uvar_typ
                           in
                        FStar_Syntax_Util.arrow dom_binders uu____4762  in
                      new_uvar
                        (Prims.op_Hat uv.FStar_Syntax_Syntax.ctx_uvar_reason
                           "; force delayed") wl t.FStar_Syntax_Syntax.pos
                        new_gamma uu____4700 uu____4759
                        uv.FStar_Syntax_Syntax.ctx_uvar_should_check
                        uv.FStar_Syntax_Syntax.ctx_uvar_meta
                       in
                    (match uu____4693 with
                     | (v1,t_v,wl1) ->
                         let args_sol =
                           FStar_List.map
                             (fun uu____4798  ->
                                match uu____4798 with
                                | (x,i) ->
                                    let uu____4817 =
                                      FStar_Syntax_Syntax.bv_to_name x  in
                                    (uu____4817, i)) dom_binders
                            in
                         let sol =
                           FStar_Syntax_Syntax.mk_Tm_app t_v args_sol
                             FStar_Pervasives_Native.None
                             t.FStar_Syntax_Syntax.pos
                            in
                         let args_sol_s =
                           FStar_List.map
                             (fun uu____4848  ->
                                match uu____4848 with
                                | (a,i) ->
                                    let uu____4867 =
                                      FStar_Syntax_Subst.subst' s a  in
                                    (uu____4867, i)) args_sol
                            in
                         let all_args = FStar_List.append args_sol_s args  in
                         let t1 =
                           FStar_Syntax_Syntax.mk_Tm_app t_v all_args
                             FStar_Pervasives_Native.None
                             t.FStar_Syntax_Syntax.pos
                            in
                         (FStar_Syntax_Unionfind.change
                            uv.FStar_Syntax_Syntax.ctx_uvar_head sol;
                          ((t1, v1, all_args), wl1))))
           | uu____4889 -> failwith "Not a flex-uvar")
  
let (u_abs :
  FStar_Syntax_Syntax.typ ->
    FStar_Syntax_Syntax.binders ->
      FStar_Syntax_Syntax.term -> FStar_Syntax_Syntax.term)
  =
  fun k  ->
    fun ys  ->
      fun t  ->
        let uu____4911 =
          let uu____4934 =
            let uu____4935 = FStar_Syntax_Subst.compress k  in
            uu____4935.FStar_Syntax_Syntax.n  in
          match uu____4934 with
          | FStar_Syntax_Syntax.Tm_arrow (bs,c) ->
              if (FStar_List.length bs) = (FStar_List.length ys)
              then
                let uu____5017 = FStar_Syntax_Subst.open_comp bs c  in
                ((ys, t), uu____5017)
              else
                (let uu____5052 = FStar_Syntax_Util.abs_formals t  in
                 match uu____5052 with
                 | (ys',t1,uu____5085) ->
                     let uu____5090 = FStar_Syntax_Util.arrow_formals_comp k
                        in
                     (((FStar_List.append ys ys'), t1), uu____5090))
          | uu____5129 ->
              let uu____5130 =
                let uu____5135 = FStar_Syntax_Syntax.mk_Total k  in
                ([], uu____5135)  in
              ((ys, t), uu____5130)
           in
        match uu____4911 with
        | ((ys1,t1),(xs,c)) ->
            if (FStar_List.length xs) <> (FStar_List.length ys1)
            then
              FStar_Syntax_Util.abs ys1 t1
                (FStar_Pervasives_Native.Some
                   (FStar_Syntax_Util.mk_residual_comp
                      FStar_Parser_Const.effect_Tot_lid
                      FStar_Pervasives_Native.None []))
            else
              (let c1 =
                 let uu____5230 = FStar_Syntax_Util.rename_binders xs ys1  in
                 FStar_Syntax_Subst.subst_comp uu____5230 c  in
               FStar_Syntax_Util.abs ys1 t1
                 (FStar_Pervasives_Native.Some
                    (FStar_Syntax_Util.residual_comp_of_comp c1)))
  
let (solve_prob' :
  Prims.bool ->
    FStar_TypeChecker_Common.prob ->
      FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax
        FStar_Pervasives_Native.option ->
        uvi Prims.list -> worklist -> worklist)
  =
  fun resolve_ok  ->
    fun prob  ->
      fun logical_guard  ->
        fun uvis  ->
          fun wl  ->
            def_check_prob "solve_prob'" prob;
            (let phi =
               match logical_guard with
               | FStar_Pervasives_Native.None  -> FStar_Syntax_Util.t_true
               | FStar_Pervasives_Native.Some phi -> phi  in
             let assign_solution xs uv phi1 =
               (let uu____5308 =
                  FStar_All.pipe_left (FStar_TypeChecker_Env.debug wl.tcenv)
                    (FStar_Options.Other "Rel")
                   in
                if uu____5308
                then
                  let uu____5313 = FStar_Util.string_of_int (p_pid prob)  in
                  let uu____5315 = print_ctx_uvar uv  in
                  let uu____5317 = FStar_Syntax_Print.term_to_string phi1  in
                  FStar_Util.print3 "Solving %s (%s) with formula %s\n"
                    uu____5313 uu____5315 uu____5317
                else ());
               (let phi2 =
                  FStar_Syntax_Util.abs xs phi1
                    (FStar_Pervasives_Native.Some
                       (FStar_Syntax_Util.residual_tot
                          FStar_Syntax_Util.ktype0))
                   in
                (let uu____5326 =
                   let uu____5328 = FStar_Util.string_of_int (p_pid prob)  in
                   Prims.op_Hat "solve_prob'.sol." uu____5328  in
                 let uu____5331 =
                   let uu____5334 = p_scope prob  in
                   FStar_All.pipe_left
                     (FStar_List.map FStar_Pervasives_Native.fst) uu____5334
                    in
                 FStar_TypeChecker_Env.def_check_closed_in (p_loc prob)
                   uu____5326 uu____5331 phi2);
                FStar_Syntax_Util.set_uvar
                  uv.FStar_Syntax_Syntax.ctx_uvar_head phi2)
                in
             let uv = p_guard_uvar prob  in
             let fail1 uu____5367 =
               let uu____5368 =
                 let uu____5370 = FStar_Syntax_Print.ctx_uvar_to_string uv
                    in
                 let uu____5372 =
                   FStar_Syntax_Print.term_to_string (p_guard prob)  in
                 FStar_Util.format2
                   "Impossible: this instance %s has already been assigned a solution\n%s\n"
                   uu____5370 uu____5372
                  in
               failwith uu____5368  in
             let args_as_binders args =
               FStar_All.pipe_right args
                 (FStar_List.collect
                    (fun uu____5438  ->
                       match uu____5438 with
                       | (a,i) ->
                           let uu____5459 =
                             let uu____5460 = FStar_Syntax_Subst.compress a
                                in
                             uu____5460.FStar_Syntax_Syntax.n  in
                           (match uu____5459 with
                            | FStar_Syntax_Syntax.Tm_name x -> [(x, i)]
                            | uu____5486 -> (fail1 (); []))))
                in
             let wl1 =
               let g = whnf wl.tcenv (p_guard prob)  in
               let uu____5496 =
                 let uu____5498 = is_flex g  in Prims.op_Negation uu____5498
                  in
               if uu____5496
               then (if resolve_ok then wl else (fail1 (); wl))
               else
                 (let uu____5507 = destruct_flex_t g wl  in
                  match uu____5507 with
                  | ((uu____5512,uv1,args),wl1) ->
                      ((let uu____5517 = args_as_binders args  in
                        assign_solution uu____5517 uv1 phi);
                       wl1))
                in
             commit uvis;
             (let uu___711_5519 = wl1  in
              {
                attempting = (uu___711_5519.attempting);
                wl_deferred = (uu___711_5519.wl_deferred);
                ctr = (wl1.ctr + Prims.int_one);
                defer_ok = (uu___711_5519.defer_ok);
                smt_ok = (uu___711_5519.smt_ok);
                umax_heuristic_ok = (uu___711_5519.umax_heuristic_ok);
                tcenv = (uu___711_5519.tcenv);
                wl_implicits = (uu___711_5519.wl_implicits)
              }))
  
let (extend_solution : Prims.int -> uvi Prims.list -> worklist -> worklist) =
  fun pid  ->
    fun sol  ->
      fun wl  ->
        (let uu____5544 =
           FStar_All.pipe_left (FStar_TypeChecker_Env.debug wl.tcenv)
             (FStar_Options.Other "Rel")
            in
         if uu____5544
         then
           let uu____5549 = FStar_Util.string_of_int pid  in
           let uu____5551 =
             let uu____5553 = FStar_List.map (uvi_to_string wl.tcenv) sol  in
             FStar_All.pipe_right uu____5553 (FStar_String.concat ", ")  in
           FStar_Util.print2 "Solving %s: with [%s]\n" uu____5549 uu____5551
         else ());
        commit sol;
        (let uu___719_5567 = wl  in
         {
           attempting = (uu___719_5567.attempting);
           wl_deferred = (uu___719_5567.wl_deferred);
           ctr = (wl.ctr + Prims.int_one);
           defer_ok = (uu___719_5567.defer_ok);
           smt_ok = (uu___719_5567.smt_ok);
           umax_heuristic_ok = (uu___719_5567.umax_heuristic_ok);
           tcenv = (uu___719_5567.tcenv);
           wl_implicits = (uu___719_5567.wl_implicits)
         })
  
let (solve_prob :
  FStar_TypeChecker_Common.prob ->
    FStar_Syntax_Syntax.term FStar_Pervasives_Native.option ->
      uvi Prims.list -> worklist -> worklist)
  =
  fun prob  ->
    fun logical_guard  ->
      fun uvis  ->
        fun wl  ->
          def_check_prob "solve_prob.prob" prob;
          FStar_Util.iter_opt logical_guard
            (def_check_scoped "solve_prob.guard" prob);
          (let uu____5603 =
             FStar_All.pipe_left (FStar_TypeChecker_Env.debug wl.tcenv)
               (FStar_Options.Other "Rel")
              in
           if uu____5603
           then
             let uu____5608 =
               FStar_All.pipe_left FStar_Util.string_of_int (p_pid prob)  in
             let uu____5612 =
               let uu____5614 = FStar_List.map (uvi_to_string wl.tcenv) uvis
                  in
               FStar_All.pipe_right uu____5614 (FStar_String.concat ", ")  in
             FStar_Util.print2 "Solving %s: with %s\n" uu____5608 uu____5612
           else ());
          solve_prob' false prob logical_guard uvis wl
  
let (occurs :
  FStar_Syntax_Syntax.ctx_uvar ->
    FStar_Syntax_Syntax.term ->
      (FStar_Syntax_Syntax.ctx_uvar Prims.list * Prims.bool))
  =
  fun uk  ->
    fun t  ->
      let uvars1 =
        let uu____5649 = FStar_Syntax_Free.uvars t  in
        FStar_All.pipe_right uu____5649 FStar_Util.set_elements  in
      let occurs =
        FStar_All.pipe_right uvars1
          (FStar_Util.for_some
             (fun uv  ->
                FStar_Syntax_Unionfind.equiv
                  uv.FStar_Syntax_Syntax.ctx_uvar_head
                  uk.FStar_Syntax_Syntax.ctx_uvar_head))
         in
      (uvars1, occurs)
  
let (occurs_check :
  FStar_Syntax_Syntax.ctx_uvar ->
    FStar_Syntax_Syntax.term ->
      (FStar_Syntax_Syntax.ctx_uvar Prims.list * Prims.bool * Prims.string
        FStar_Pervasives_Native.option))
  =
  fun uk  ->
    fun t  ->
      let uu____5689 = occurs uk t  in
      match uu____5689 with
      | (uvars1,occurs1) ->
          let msg =
            if Prims.op_Negation occurs1
            then FStar_Pervasives_Native.None
            else
              (let uu____5728 =
                 let uu____5730 =
                   FStar_Syntax_Print.uvar_to_string
                     uk.FStar_Syntax_Syntax.ctx_uvar_head
                    in
                 let uu____5732 = FStar_Syntax_Print.term_to_string t  in
                 FStar_Util.format2 "occurs-check failed (%s occurs in %s)"
                   uu____5730 uu____5732
                  in
               FStar_Pervasives_Native.Some uu____5728)
             in
          (uvars1, (Prims.op_Negation occurs1), msg)
  
let rec (maximal_prefix :
  FStar_Syntax_Syntax.binders ->
    FStar_Syntax_Syntax.binders ->
      (FStar_Syntax_Syntax.binders * (FStar_Syntax_Syntax.binders *
        FStar_Syntax_Syntax.binders)))
  =
  fun bs  ->
    fun bs'  ->
      match (bs, bs') with
      | ((b,i)::bs_tail,(b',i')::bs'_tail) ->
          if FStar_Syntax_Syntax.bv_eq b b'
          then
            let uu____5852 = maximal_prefix bs_tail bs'_tail  in
            (match uu____5852 with | (pfx,rest) -> (((b, i) :: pfx), rest))
          else ([], (bs, bs'))
      | uu____5903 -> ([], (bs, bs'))
  
let (extend_gamma :
  FStar_Syntax_Syntax.gamma ->
    FStar_Syntax_Syntax.binders -> FStar_Syntax_Syntax.binding Prims.list)
  =
  fun g  ->
    fun bs  ->
      FStar_List.fold_left
        (fun g1  ->
           fun uu____5960  ->
             match uu____5960 with
             | (x,uu____5972) -> (FStar_Syntax_Syntax.Binding_var x) :: g1) g
        bs
  
let (gamma_until :
  FStar_Syntax_Syntax.gamma ->
    FStar_Syntax_Syntax.binders -> FStar_Syntax_Syntax.binding Prims.list)
  =
  fun g  ->
    fun bs  ->
      let uu____5990 = FStar_List.last bs  in
      match uu____5990 with
      | FStar_Pervasives_Native.None  -> []
      | FStar_Pervasives_Native.Some (x,uu____6014) ->
          let uu____6025 =
            FStar_Util.prefix_until
              (fun uu___21_6040  ->
                 match uu___21_6040 with
                 | FStar_Syntax_Syntax.Binding_var x' ->
                     FStar_Syntax_Syntax.bv_eq x x'
                 | uu____6043 -> false) g
             in
          (match uu____6025 with
           | FStar_Pervasives_Native.None  -> []
           | FStar_Pervasives_Native.Some (uu____6057,bx,rest) -> bx :: rest)
  
let (restrict_ctx :
  FStar_Syntax_Syntax.ctx_uvar ->
    FStar_Syntax_Syntax.ctx_uvar -> worklist -> worklist)
  =
  fun tgt  ->
    fun src  ->
      fun wl  ->
        let uu____6094 =
          maximal_prefix tgt.FStar_Syntax_Syntax.ctx_uvar_binders
            src.FStar_Syntax_Syntax.ctx_uvar_binders
           in
        match uu____6094 with
        | (pfx,uu____6104) ->
            let g = gamma_until src.FStar_Syntax_Syntax.ctx_uvar_gamma pfx
               in
            let uu____6116 =
              new_uvar
                (Prims.op_Hat "restrict:"
                   src.FStar_Syntax_Syntax.ctx_uvar_reason) wl
                src.FStar_Syntax_Syntax.ctx_uvar_range g pfx
                src.FStar_Syntax_Syntax.ctx_uvar_typ
                src.FStar_Syntax_Syntax.ctx_uvar_should_check
                src.FStar_Syntax_Syntax.ctx_uvar_meta
               in
            (match uu____6116 with
             | (uu____6124,src',wl1) ->
                 (FStar_Syntax_Unionfind.change
                    src.FStar_Syntax_Syntax.ctx_uvar_head src';
                  wl1))
  
let (restrict_all_uvars :
  FStar_Syntax_Syntax.ctx_uvar ->
    FStar_Syntax_Syntax.ctx_uvar Prims.list -> worklist -> worklist)
  =
  fun tgt  ->
    fun sources  ->
      fun wl  -> FStar_List.fold_right (restrict_ctx tgt) sources wl
  
let (intersect_binders :
  FStar_Syntax_Syntax.gamma ->
    FStar_Syntax_Syntax.binders ->
      FStar_Syntax_Syntax.binders -> FStar_Syntax_Syntax.binders)
  =
  fun g  ->
    fun v1  ->
      fun v2  ->
        let as_set1 v3 =
          FStar_All.pipe_right v3
            (FStar_List.fold_left
               (fun out  ->
                  fun x  ->
                    FStar_Util.set_add (FStar_Pervasives_Native.fst x) out)
               FStar_Syntax_Syntax.no_names)
           in
        let v1_set = as_set1 v1  in
        let ctx_binders =
          FStar_List.fold_left
            (fun out  ->
               fun b  ->
                 match b with
                 | FStar_Syntax_Syntax.Binding_var x ->
                     FStar_Util.set_add x out
                 | uu____6238 -> out) FStar_Syntax_Syntax.no_names g
           in
        let uu____6239 =
          FStar_All.pipe_right v2
            (FStar_List.fold_left
               (fun uu____6303  ->
                  fun uu____6304  ->
                    match (uu____6303, uu____6304) with
                    | ((isect,isect_set),(x,imp)) ->
                        let uu____6407 =
                          let uu____6409 = FStar_Util.set_mem x v1_set  in
                          FStar_All.pipe_left Prims.op_Negation uu____6409
                           in
                        if uu____6407
                        then (isect, isect_set)
                        else
                          (let fvs =
                             FStar_Syntax_Free.names
                               x.FStar_Syntax_Syntax.sort
                              in
                           let uu____6443 =
                             FStar_Util.set_is_subset_of fvs isect_set  in
                           if uu____6443
                           then
                             let uu____6460 = FStar_Util.set_add x isect_set
                                in
                             (((x, imp) :: isect), uu____6460)
                           else (isect, isect_set))) ([], ctx_binders))
           in
        match uu____6239 with | (isect,uu____6510) -> FStar_List.rev isect
  
let binders_eq :
  'Auu____6546 'Auu____6547 .
    (FStar_Syntax_Syntax.bv * 'Auu____6546) Prims.list ->
      (FStar_Syntax_Syntax.bv * 'Auu____6547) Prims.list -> Prims.bool
  =
  fun v1  ->
    fun v2  ->
      ((FStar_List.length v1) = (FStar_List.length v2)) &&
        (FStar_List.forall2
           (fun uu____6605  ->
              fun uu____6606  ->
                match (uu____6605, uu____6606) with
                | ((a,uu____6625),(b,uu____6627)) ->
                    FStar_Syntax_Syntax.bv_eq a b) v1 v2)
  
let name_exists_in_binders :
  'Auu____6643 .
    FStar_Syntax_Syntax.bv ->
      (FStar_Syntax_Syntax.bv * 'Auu____6643) Prims.list -> Prims.bool
  =
  fun x  ->
    fun bs  ->
      FStar_Util.for_some
        (fun uu____6674  ->
           match uu____6674 with
           | (y,uu____6681) -> FStar_Syntax_Syntax.bv_eq x y) bs
  
let pat_vars :
  'Auu____6691 .
    FStar_TypeChecker_Env.env ->
      (FStar_Syntax_Syntax.bv * 'Auu____6691) Prims.list ->
        (FStar_Syntax_Syntax.term * FStar_Syntax_Syntax.arg_qualifier
          FStar_Pervasives_Native.option) Prims.list ->
          FStar_Syntax_Syntax.binders FStar_Pervasives_Native.option
  =
  fun env  ->
    fun ctx  ->
      fun args  ->
        let rec aux seen args1 =
          match args1 with
          | [] -> FStar_Pervasives_Native.Some (FStar_List.rev seen)
          | (arg,i)::args2 ->
              let hd1 = sn env arg  in
              (match hd1.FStar_Syntax_Syntax.n with
               | FStar_Syntax_Syntax.Tm_name a ->
                   let uu____6853 =
                     (name_exists_in_binders a seen) ||
                       (name_exists_in_binders a ctx)
                      in
                   if uu____6853
                   then FStar_Pervasives_Native.None
                   else aux ((a, i) :: seen) args2
               | uu____6886 -> FStar_Pervasives_Native.None)
           in
        aux [] args
  
type match_result =
  | MisMatch of (FStar_Syntax_Syntax.delta_depth
  FStar_Pervasives_Native.option * FStar_Syntax_Syntax.delta_depth
  FStar_Pervasives_Native.option) 
  | HeadMatch of Prims.bool 
  | FullMatch 
let (uu___is_MisMatch : match_result -> Prims.bool) =
  fun projectee  ->
    match projectee with | MisMatch _0 -> true | uu____6938 -> false
  
let (__proj__MisMatch__item___0 :
  match_result ->
    (FStar_Syntax_Syntax.delta_depth FStar_Pervasives_Native.option *
      FStar_Syntax_Syntax.delta_depth FStar_Pervasives_Native.option))
  = fun projectee  -> match projectee with | MisMatch _0 -> _0 
let (uu___is_HeadMatch : match_result -> Prims.bool) =
  fun projectee  ->
    match projectee with | HeadMatch _0 -> true | uu____6982 -> false
  
let (__proj__HeadMatch__item___0 : match_result -> Prims.bool) =
  fun projectee  -> match projectee with | HeadMatch _0 -> _0 
let (uu___is_FullMatch : match_result -> Prims.bool) =
  fun projectee  ->
    match projectee with | FullMatch  -> true | uu____7003 -> false
  
let (string_of_match_result : match_result -> Prims.string) =
  fun uu___22_7011  ->
    match uu___22_7011 with
    | MisMatch (d1,d2) ->
        let uu____7023 =
          let uu____7025 =
            FStar_Common.string_of_option
              FStar_Syntax_Print.delta_depth_to_string d1
             in
          let uu____7027 =
            let uu____7029 =
              let uu____7031 =
                FStar_Common.string_of_option
                  FStar_Syntax_Print.delta_depth_to_string d2
                 in
              Prims.op_Hat uu____7031 ")"  in
            Prims.op_Hat ") (" uu____7029  in
          Prims.op_Hat uu____7025 uu____7027  in
        Prims.op_Hat "MisMatch (" uu____7023
    | HeadMatch u ->
        let uu____7038 = FStar_Util.string_of_bool u  in
        Prims.op_Hat "HeadMatch " uu____7038
    | FullMatch  -> "FullMatch"
  
let (head_match : match_result -> match_result) =
  fun uu___23_7047  ->
    match uu___23_7047 with
    | MisMatch (i,j) -> MisMatch (i, j)
    | HeadMatch (true ) -> HeadMatch true
    | uu____7064 -> HeadMatch false
  
let (fv_delta_depth :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.fv -> FStar_Syntax_Syntax.delta_depth)
  =
  fun env  ->
    fun fv  ->
      let d = FStar_TypeChecker_Env.delta_depth_of_fv env fv  in
      match d with
      | FStar_Syntax_Syntax.Delta_abstract d1 ->
          if
            ((env.FStar_TypeChecker_Env.curmodule).FStar_Ident.str =
               ((fv.FStar_Syntax_Syntax.fv_name).FStar_Syntax_Syntax.v).FStar_Ident.nsstr)
              && (Prims.op_Negation env.FStar_TypeChecker_Env.is_iface)
          then d1
          else FStar_Syntax_Syntax.delta_constant
      | FStar_Syntax_Syntax.Delta_constant_at_level i when i > Prims.int_zero
          ->
          let uu____7086 =
            FStar_TypeChecker_Env.lookup_definition
              [FStar_TypeChecker_Env.Unfold
                 FStar_Syntax_Syntax.delta_constant] env
              (fv.FStar_Syntax_Syntax.fv_name).FStar_Syntax_Syntax.v
             in
          (match uu____7086 with
           | FStar_Pervasives_Native.None  ->
               FStar_Syntax_Syntax.delta_constant
           | uu____7097 -> d)
      | d1 -> d1
  
let rec (delta_depth_of_term :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term ->
      FStar_Syntax_Syntax.delta_depth FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun t  ->
      let t1 = FStar_Syntax_Util.unmeta t  in
      match t1.FStar_Syntax_Syntax.n with
      | FStar_Syntax_Syntax.Tm_meta uu____7121 -> failwith "Impossible"
      | FStar_Syntax_Syntax.Tm_delayed uu____7131 -> failwith "Impossible"
      | FStar_Syntax_Syntax.Tm_lazy i ->
          let uu____7158 = FStar_Syntax_Util.unfold_lazy i  in
          delta_depth_of_term env uu____7158
      | FStar_Syntax_Syntax.Tm_unknown  -> FStar_Pervasives_Native.None
      | FStar_Syntax_Syntax.Tm_bvar uu____7159 ->
          FStar_Pervasives_Native.None
      | FStar_Syntax_Syntax.Tm_name uu____7160 ->
          FStar_Pervasives_Native.None
      | FStar_Syntax_Syntax.Tm_uvar uu____7161 ->
          FStar_Pervasives_Native.None
      | FStar_Syntax_Syntax.Tm_let uu____7174 -> FStar_Pervasives_Native.None
      | FStar_Syntax_Syntax.Tm_match uu____7188 ->
          FStar_Pervasives_Native.None
      | FStar_Syntax_Syntax.Tm_uinst (t2,uu____7212) ->
          delta_depth_of_term env t2
      | FStar_Syntax_Syntax.Tm_ascribed (t2,uu____7218,uu____7219) ->
          delta_depth_of_term env t2
      | FStar_Syntax_Syntax.Tm_app (t2,uu____7261) ->
          delta_depth_of_term env t2
      | FStar_Syntax_Syntax.Tm_refine
          ({ FStar_Syntax_Syntax.ppname = uu____7286;
             FStar_Syntax_Syntax.index = uu____7287;
             FStar_Syntax_Syntax.sort = t2;_},uu____7289)
          -> delta_depth_of_term env t2
      | FStar_Syntax_Syntax.Tm_constant uu____7297 ->
          FStar_Pervasives_Native.Some FStar_Syntax_Syntax.delta_constant
      | FStar_Syntax_Syntax.Tm_type uu____7298 ->
          FStar_Pervasives_Native.Some FStar_Syntax_Syntax.delta_constant
      | FStar_Syntax_Syntax.Tm_arrow uu____7299 ->
          FStar_Pervasives_Native.Some FStar_Syntax_Syntax.delta_constant
      | FStar_Syntax_Syntax.Tm_quoted uu____7314 ->
          FStar_Pervasives_Native.Some FStar_Syntax_Syntax.delta_constant
      | FStar_Syntax_Syntax.Tm_abs uu____7321 ->
          FStar_Pervasives_Native.Some FStar_Syntax_Syntax.delta_constant
      | FStar_Syntax_Syntax.Tm_fvar fv ->
          let uu____7341 = fv_delta_depth env fv  in
          FStar_Pervasives_Native.Some uu____7341
  
let rec (head_matches :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term -> FStar_Syntax_Syntax.term -> match_result)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        let t11 = FStar_Syntax_Util.unmeta t1  in
        let t21 = FStar_Syntax_Util.unmeta t2  in
        match ((t11.FStar_Syntax_Syntax.n), (t21.FStar_Syntax_Syntax.n)) with
        | (FStar_Syntax_Syntax.Tm_lazy
           { FStar_Syntax_Syntax.blob = uu____7360;
             FStar_Syntax_Syntax.lkind = FStar_Syntax_Syntax.Lazy_embedding
               uu____7361;
             FStar_Syntax_Syntax.ltyp = uu____7362;
             FStar_Syntax_Syntax.rng = uu____7363;_},uu____7364)
            ->
            let uu____7375 = FStar_Syntax_Util.unlazy t11  in
            head_matches env uu____7375 t21
        | (uu____7376,FStar_Syntax_Syntax.Tm_lazy
           { FStar_Syntax_Syntax.blob = uu____7377;
             FStar_Syntax_Syntax.lkind = FStar_Syntax_Syntax.Lazy_embedding
               uu____7378;
             FStar_Syntax_Syntax.ltyp = uu____7379;
             FStar_Syntax_Syntax.rng = uu____7380;_})
            ->
            let uu____7391 = FStar_Syntax_Util.unlazy t21  in
            head_matches env t11 uu____7391
        | (FStar_Syntax_Syntax.Tm_name x,FStar_Syntax_Syntax.Tm_name y) ->
            if FStar_Syntax_Syntax.bv_eq x y
            then FullMatch
            else
              MisMatch
                (FStar_Pervasives_Native.None, FStar_Pervasives_Native.None)
        | (FStar_Syntax_Syntax.Tm_fvar f,FStar_Syntax_Syntax.Tm_fvar g) ->
            let uu____7403 = FStar_Syntax_Syntax.fv_eq f g  in
            if uu____7403
            then FullMatch
            else
              (let uu____7408 =
                 let uu____7417 =
                   let uu____7420 = fv_delta_depth env f  in
                   FStar_Pervasives_Native.Some uu____7420  in
                 let uu____7421 =
                   let uu____7424 = fv_delta_depth env g  in
                   FStar_Pervasives_Native.Some uu____7424  in
                 (uu____7417, uu____7421)  in
               MisMatch uu____7408)
        | (FStar_Syntax_Syntax.Tm_uinst
           (f,uu____7430),FStar_Syntax_Syntax.Tm_uinst (g,uu____7432)) ->
            let uu____7441 = head_matches env f g  in
            FStar_All.pipe_right uu____7441 head_match
        | (FStar_Syntax_Syntax.Tm_constant (FStar_Const.Const_reify
           ),FStar_Syntax_Syntax.Tm_constant (FStar_Const.Const_reify )) ->
            FullMatch
        | (FStar_Syntax_Syntax.Tm_constant (FStar_Const.Const_reify
           ),uu____7442) -> HeadMatch true
        | (uu____7444,FStar_Syntax_Syntax.Tm_constant
           (FStar_Const.Const_reify )) -> HeadMatch true
        | (FStar_Syntax_Syntax.Tm_constant c,FStar_Syntax_Syntax.Tm_constant
           d) ->
            let uu____7448 = FStar_Const.eq_const c d  in
            if uu____7448
            then FullMatch
            else
              MisMatch
                (FStar_Pervasives_Native.None, FStar_Pervasives_Native.None)
        | (FStar_Syntax_Syntax.Tm_uvar
           (uv,uu____7458),FStar_Syntax_Syntax.Tm_uvar (uv',uu____7460)) ->
            let uu____7493 =
              FStar_Syntax_Unionfind.equiv
                uv.FStar_Syntax_Syntax.ctx_uvar_head
                uv'.FStar_Syntax_Syntax.ctx_uvar_head
               in
            if uu____7493
            then FullMatch
            else
              MisMatch
                (FStar_Pervasives_Native.None, FStar_Pervasives_Native.None)
        | (FStar_Syntax_Syntax.Tm_refine
           (x,uu____7503),FStar_Syntax_Syntax.Tm_refine (y,uu____7505)) ->
            let uu____7514 =
              head_matches env x.FStar_Syntax_Syntax.sort
                y.FStar_Syntax_Syntax.sort
               in
            FStar_All.pipe_right uu____7514 head_match
        | (FStar_Syntax_Syntax.Tm_refine (x,uu____7516),uu____7517) ->
            let uu____7522 = head_matches env x.FStar_Syntax_Syntax.sort t21
               in
            FStar_All.pipe_right uu____7522 head_match
        | (uu____7523,FStar_Syntax_Syntax.Tm_refine (x,uu____7525)) ->
            let uu____7530 = head_matches env t11 x.FStar_Syntax_Syntax.sort
               in
            FStar_All.pipe_right uu____7530 head_match
        | (FStar_Syntax_Syntax.Tm_type uu____7531,FStar_Syntax_Syntax.Tm_type
           uu____7532) -> HeadMatch false
        | (FStar_Syntax_Syntax.Tm_arrow
           uu____7534,FStar_Syntax_Syntax.Tm_arrow uu____7535) ->
            HeadMatch false
        | (FStar_Syntax_Syntax.Tm_app
           (head1,uu____7566),FStar_Syntax_Syntax.Tm_app (head',uu____7568))
            ->
            let uu____7617 = head_matches env head1 head'  in
            FStar_All.pipe_right uu____7617 head_match
        | (FStar_Syntax_Syntax.Tm_app (head1,uu____7619),uu____7620) ->
            let uu____7645 = head_matches env head1 t21  in
            FStar_All.pipe_right uu____7645 head_match
        | (uu____7646,FStar_Syntax_Syntax.Tm_app (head1,uu____7648)) ->
            let uu____7673 = head_matches env t11 head1  in
            FStar_All.pipe_right uu____7673 head_match
        | (FStar_Syntax_Syntax.Tm_let uu____7674,FStar_Syntax_Syntax.Tm_let
           uu____7675) -> HeadMatch true
        | (FStar_Syntax_Syntax.Tm_match
           uu____7703,FStar_Syntax_Syntax.Tm_match uu____7704) ->
            HeadMatch true
        | (FStar_Syntax_Syntax.Tm_abs uu____7750,FStar_Syntax_Syntax.Tm_abs
           uu____7751) -> HeadMatch true
        | uu____7789 ->
            let uu____7794 =
              let uu____7803 = delta_depth_of_term env t11  in
              let uu____7806 = delta_depth_of_term env t21  in
              (uu____7803, uu____7806)  in
            MisMatch uu____7794
  
let (head_matches_delta :
  FStar_TypeChecker_Env.env ->
    worklist ->
      FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
        FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
          (match_result * (FStar_Syntax_Syntax.typ * FStar_Syntax_Syntax.typ)
            FStar_Pervasives_Native.option))
  =
  fun env  ->
    fun wl  ->
      fun t1  ->
        fun t2  ->
          let maybe_inline t =
            let head1 =
              let uu____7875 = unrefine env t  in
              FStar_Syntax_Util.head_of uu____7875  in
            (let uu____7877 =
               FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                 (FStar_Options.Other "RelDelta")
                in
             if uu____7877
             then
               let uu____7882 = FStar_Syntax_Print.term_to_string t  in
               let uu____7884 = FStar_Syntax_Print.term_to_string head1  in
               FStar_Util.print2 "Head of %s is %s\n" uu____7882 uu____7884
             else ());
            (let uu____7889 =
               let uu____7890 = FStar_Syntax_Util.un_uinst head1  in
               uu____7890.FStar_Syntax_Syntax.n  in
             match uu____7889 with
             | FStar_Syntax_Syntax.Tm_fvar fv ->
                 let uu____7896 =
                   FStar_TypeChecker_Env.lookup_definition
                     [FStar_TypeChecker_Env.Unfold
                        FStar_Syntax_Syntax.delta_constant;
                     FStar_TypeChecker_Env.Eager_unfolding_only] env
                     (fv.FStar_Syntax_Syntax.fv_name).FStar_Syntax_Syntax.v
                    in
                 (match uu____7896 with
                  | FStar_Pervasives_Native.None  ->
                      ((let uu____7910 =
                          FStar_All.pipe_left
                            (FStar_TypeChecker_Env.debug env)
                            (FStar_Options.Other "RelDelta")
                           in
                        if uu____7910
                        then
                          let uu____7915 =
                            FStar_Syntax_Print.term_to_string head1  in
                          FStar_Util.print1 "No definition found for %s\n"
                            uu____7915
                        else ());
                       FStar_Pervasives_Native.None)
                  | FStar_Pervasives_Native.Some uu____7920 ->
                      let basic_steps =
                        [FStar_TypeChecker_Env.UnfoldUntil
                           FStar_Syntax_Syntax.delta_constant;
                        FStar_TypeChecker_Env.Weak;
                        FStar_TypeChecker_Env.HNF;
                        FStar_TypeChecker_Env.Primops;
                        FStar_TypeChecker_Env.Beta;
                        FStar_TypeChecker_Env.Eager_unfolding;
                        FStar_TypeChecker_Env.Iota]  in
                      let steps =
                        if wl.smt_ok
                        then basic_steps
                        else
                          (FStar_TypeChecker_Env.Exclude
                             FStar_TypeChecker_Env.Zeta)
                          :: basic_steps
                         in
                      let t' =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.1" steps env
                          t
                         in
                      let uu____7938 =
                        let uu____7940 = FStar_Syntax_Util.eq_tm t t'  in
                        uu____7940 = FStar_Syntax_Util.Equal  in
                      if uu____7938
                      then FStar_Pervasives_Native.None
                      else
                        ((let uu____7947 =
                            FStar_All.pipe_left
                              (FStar_TypeChecker_Env.debug env)
                              (FStar_Options.Other "RelDelta")
                             in
                          if uu____7947
                          then
                            let uu____7952 =
                              FStar_Syntax_Print.term_to_string t  in
                            let uu____7954 =
                              FStar_Syntax_Print.term_to_string t'  in
                            FStar_Util.print2 "Inlined %s to %s\n" uu____7952
                              uu____7954
                          else ());
                         FStar_Pervasives_Native.Some t'))
             | uu____7959 -> FStar_Pervasives_Native.None)
             in
          let success d r t11 t21 =
            (r,
              (if d > Prims.int_zero
               then FStar_Pervasives_Native.Some (t11, t21)
               else FStar_Pervasives_Native.None))
             in
          let fail1 d r t11 t21 =
            (r,
              (if d > Prims.int_zero
               then FStar_Pervasives_Native.Some (t11, t21)
               else FStar_Pervasives_Native.None))
             in
          let rec aux retry1 n_delta t11 t21 =
            let r = head_matches env t11 t21  in
            (let uu____8111 =
               FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                 (FStar_Options.Other "RelDelta")
                in
             if uu____8111
             then
               let uu____8116 = FStar_Syntax_Print.term_to_string t11  in
               let uu____8118 = FStar_Syntax_Print.term_to_string t21  in
               let uu____8120 = string_of_match_result r  in
               FStar_Util.print3 "head_matches (%s, %s) = %s\n" uu____8116
                 uu____8118 uu____8120
             else ());
            (let reduce_one_and_try_again d1 d2 =
               let d1_greater_than_d2 =
                 FStar_TypeChecker_Common.delta_depth_greater_than d1 d2  in
               let uu____8148 =
                 if d1_greater_than_d2
                 then
                   let t1' =
                     normalize_refinement
                       [FStar_TypeChecker_Env.UnfoldUntil d2;
                       FStar_TypeChecker_Env.Weak;
                       FStar_TypeChecker_Env.HNF] env t11
                      in
                   (t1', t21)
                 else
                   (let t2' =
                      normalize_refinement
                        [FStar_TypeChecker_Env.UnfoldUntil d1;
                        FStar_TypeChecker_Env.Weak;
                        FStar_TypeChecker_Env.HNF] env t21
                       in
                    (t11, t2'))
                  in
               match uu____8148 with
               | (t12,t22) -> aux retry1 (n_delta + Prims.int_one) t12 t22
                in
             let reduce_both_and_try_again d r1 =
               let uu____8196 = FStar_TypeChecker_Common.decr_delta_depth d
                  in
               match uu____8196 with
               | FStar_Pervasives_Native.None  -> fail1 n_delta r1 t11 t21
               | FStar_Pervasives_Native.Some d1 ->
                   let t12 =
                     normalize_refinement
                       [FStar_TypeChecker_Env.UnfoldUntil d1;
                       FStar_TypeChecker_Env.Weak;
                       FStar_TypeChecker_Env.HNF] env t11
                      in
                   let t22 =
                     normalize_refinement
                       [FStar_TypeChecker_Env.UnfoldUntil d1;
                       FStar_TypeChecker_Env.Weak;
                       FStar_TypeChecker_Env.HNF] env t21
                      in
                   aux retry1 (n_delta + Prims.int_one) t12 t22
                in
             match r with
             | MisMatch
                 (FStar_Pervasives_Native.Some
                  (FStar_Syntax_Syntax.Delta_equational_at_level
                  i),FStar_Pervasives_Native.Some
                  (FStar_Syntax_Syntax.Delta_equational_at_level j))
                 when
                 ((i > Prims.int_zero) || (j > Prims.int_zero)) && (i <> j)
                 ->
                 reduce_one_and_try_again
                   (FStar_Syntax_Syntax.Delta_equational_at_level i)
                   (FStar_Syntax_Syntax.Delta_equational_at_level j)
             | MisMatch
                 (FStar_Pervasives_Native.Some
                  (FStar_Syntax_Syntax.Delta_equational_at_level
                  uu____8234),uu____8235)
                 ->
                 if Prims.op_Negation retry1
                 then fail1 n_delta r t11 t21
                 else
                   (let uu____8256 =
                      let uu____8265 = maybe_inline t11  in
                      let uu____8268 = maybe_inline t21  in
                      (uu____8265, uu____8268)  in
                    match uu____8256 with
                    | (FStar_Pervasives_Native.None
                       ,FStar_Pervasives_Native.None ) ->
                        fail1 n_delta r t11 t21
                    | (FStar_Pervasives_Native.Some
                       t12,FStar_Pervasives_Native.None ) ->
                        aux false (n_delta + Prims.int_one) t12 t21
                    | (FStar_Pervasives_Native.None
                       ,FStar_Pervasives_Native.Some t22) ->
                        aux false (n_delta + Prims.int_one) t11 t22
                    | (FStar_Pervasives_Native.Some
                       t12,FStar_Pervasives_Native.Some t22) ->
                        aux false (n_delta + Prims.int_one) t12 t22)
             | MisMatch
                 (uu____8311,FStar_Pervasives_Native.Some
                  (FStar_Syntax_Syntax.Delta_equational_at_level uu____8312))
                 ->
                 if Prims.op_Negation retry1
                 then fail1 n_delta r t11 t21
                 else
                   (let uu____8333 =
                      let uu____8342 = maybe_inline t11  in
                      let uu____8345 = maybe_inline t21  in
                      (uu____8342, uu____8345)  in
                    match uu____8333 with
                    | (FStar_Pervasives_Native.None
                       ,FStar_Pervasives_Native.None ) ->
                        fail1 n_delta r t11 t21
                    | (FStar_Pervasives_Native.Some
                       t12,FStar_Pervasives_Native.None ) ->
                        aux false (n_delta + Prims.int_one) t12 t21
                    | (FStar_Pervasives_Native.None
                       ,FStar_Pervasives_Native.Some t22) ->
                        aux false (n_delta + Prims.int_one) t11 t22
                    | (FStar_Pervasives_Native.Some
                       t12,FStar_Pervasives_Native.Some t22) ->
                        aux false (n_delta + Prims.int_one) t12 t22)
             | MisMatch
                 (FStar_Pervasives_Native.Some
                  d1,FStar_Pervasives_Native.Some d2)
                 when d1 = d2 -> reduce_both_and_try_again d1 r
             | MisMatch
                 (FStar_Pervasives_Native.Some
                  d1,FStar_Pervasives_Native.Some d2)
                 -> reduce_one_and_try_again d1 d2
             | MisMatch uu____8400 -> fail1 n_delta r t11 t21
             | uu____8409 -> success n_delta r t11 t21)
             in
          let r = aux true Prims.int_zero t1 t2  in
          (let uu____8424 =
             FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
               (FStar_Options.Other "RelDelta")
              in
           if uu____8424
           then
             let uu____8429 = FStar_Syntax_Print.term_to_string t1  in
             let uu____8431 = FStar_Syntax_Print.term_to_string t2  in
             let uu____8433 =
               string_of_match_result (FStar_Pervasives_Native.fst r)  in
             let uu____8441 =
               if FStar_Option.isNone (FStar_Pervasives_Native.snd r)
               then "None"
               else
                 (let uu____8458 =
                    FStar_All.pipe_right (FStar_Pervasives_Native.snd r)
                      FStar_Util.must
                     in
                  FStar_All.pipe_right uu____8458
                    (fun uu____8493  ->
                       match uu____8493 with
                       | (t11,t21) ->
                           let uu____8501 =
                             FStar_Syntax_Print.term_to_string t11  in
                           let uu____8503 =
                             let uu____8505 =
                               FStar_Syntax_Print.term_to_string t21  in
                             Prims.op_Hat "; " uu____8505  in
                           Prims.op_Hat uu____8501 uu____8503))
                in
             FStar_Util.print4 "head_matches_delta (%s, %s) = %s (%s)\n"
               uu____8429 uu____8431 uu____8433 uu____8441
           else ());
          r
  
let (kind_type :
  FStar_Syntax_Syntax.binders -> FStar_Range.range -> FStar_Syntax_Syntax.typ)
  =
  fun binders  ->
    fun r  ->
      let uu____8522 = FStar_Syntax_Util.type_u ()  in
      FStar_All.pipe_right uu____8522 FStar_Pervasives_Native.fst
  
let (rank_t_num : FStar_TypeChecker_Common.rank_t -> Prims.int) =
  fun uu___24_8537  ->
    match uu___24_8537 with
    | FStar_TypeChecker_Common.Rigid_rigid  -> Prims.int_zero
    | FStar_TypeChecker_Common.Flex_rigid_eq  -> Prims.int_one
    | FStar_TypeChecker_Common.Flex_flex_pattern_eq  -> (Prims.of_int (2))
    | FStar_TypeChecker_Common.Flex_rigid  -> (Prims.of_int (3))
    | FStar_TypeChecker_Common.Rigid_flex  -> (Prims.of_int (4))
    | FStar_TypeChecker_Common.Flex_flex  -> (Prims.of_int (5))
  
let (rank_leq :
  FStar_TypeChecker_Common.rank_t ->
    FStar_TypeChecker_Common.rank_t -> Prims.bool)
  = fun r1  -> fun r2  -> (rank_t_num r1) <= (rank_t_num r2) 
let (rank_less_than :
  FStar_TypeChecker_Common.rank_t ->
    FStar_TypeChecker_Common.rank_t -> Prims.bool)
  = fun r1  -> fun r2  -> (r1 <> r2) && ((rank_t_num r1) <= (rank_t_num r2)) 
let (compress_tprob :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term FStar_TypeChecker_Common.problem ->
      FStar_Syntax_Syntax.term FStar_TypeChecker_Common.problem)
  =
  fun tcenv  ->
    fun p  ->
      let uu___1208_8586 = p  in
      let uu____8589 = whnf tcenv p.FStar_TypeChecker_Common.lhs  in
      let uu____8590 = whnf tcenv p.FStar_TypeChecker_Common.rhs  in
      {
        FStar_TypeChecker_Common.pid =
          (uu___1208_8586.FStar_TypeChecker_Common.pid);
        FStar_TypeChecker_Common.lhs = uu____8589;
        FStar_TypeChecker_Common.relation =
          (uu___1208_8586.FStar_TypeChecker_Common.relation);
        FStar_TypeChecker_Common.rhs = uu____8590;
        FStar_TypeChecker_Common.element =
          (uu___1208_8586.FStar_TypeChecker_Common.element);
        FStar_TypeChecker_Common.logical_guard =
          (uu___1208_8586.FStar_TypeChecker_Common.logical_guard);
        FStar_TypeChecker_Common.logical_guard_uvar =
          (uu___1208_8586.FStar_TypeChecker_Common.logical_guard_uvar);
        FStar_TypeChecker_Common.reason =
          (uu___1208_8586.FStar_TypeChecker_Common.reason);
        FStar_TypeChecker_Common.loc =
          (uu___1208_8586.FStar_TypeChecker_Common.loc);
        FStar_TypeChecker_Common.rank =
          (uu___1208_8586.FStar_TypeChecker_Common.rank)
      }
  
let (compress_prob :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob -> FStar_TypeChecker_Common.prob)
  =
  fun tcenv  ->
    fun p  ->
      match p with
      | FStar_TypeChecker_Common.TProb p1 ->
          let uu____8605 = compress_tprob tcenv p1  in
          FStar_All.pipe_right uu____8605
            (fun _8610  -> FStar_TypeChecker_Common.TProb _8610)
      | FStar_TypeChecker_Common.CProb uu____8611 -> p
  
let (rank :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob ->
      (FStar_TypeChecker_Common.rank_t * FStar_TypeChecker_Common.prob))
  =
  fun tcenv  ->
    fun pr  ->
      let prob =
        let uu____8634 = compress_prob tcenv pr  in
        FStar_All.pipe_right uu____8634 maybe_invert_p  in
      match prob with
      | FStar_TypeChecker_Common.TProb tp ->
          let uu____8642 =
            FStar_Syntax_Util.head_and_args tp.FStar_TypeChecker_Common.lhs
             in
          (match uu____8642 with
           | (lh,lhs_args) ->
               let uu____8689 =
                 FStar_Syntax_Util.head_and_args
                   tp.FStar_TypeChecker_Common.rhs
                  in
               (match uu____8689 with
                | (rh,rhs_args) ->
                    let uu____8736 =
                      match ((lh.FStar_Syntax_Syntax.n),
                              (rh.FStar_Syntax_Syntax.n))
                      with
                      | (FStar_Syntax_Syntax.Tm_uvar
                         uu____8749,FStar_Syntax_Syntax.Tm_uvar uu____8750)
                          ->
                          (match (lhs_args, rhs_args) with
                           | ([],[]) when
                               tp.FStar_TypeChecker_Common.relation =
                                 FStar_TypeChecker_Common.EQ
                               ->
                               (FStar_TypeChecker_Common.Flex_flex_pattern_eq,
                                 tp)
                           | uu____8839 ->
                               (FStar_TypeChecker_Common.Flex_flex, tp))
                      | (FStar_Syntax_Syntax.Tm_uvar uu____8866,uu____8867)
                          when
                          tp.FStar_TypeChecker_Common.relation =
                            FStar_TypeChecker_Common.EQ
                          -> (FStar_TypeChecker_Common.Flex_rigid_eq, tp)
                      | (uu____8882,FStar_Syntax_Syntax.Tm_uvar uu____8883)
                          when
                          tp.FStar_TypeChecker_Common.relation =
                            FStar_TypeChecker_Common.EQ
                          -> (FStar_TypeChecker_Common.Flex_rigid_eq, tp)
                      | (FStar_Syntax_Syntax.Tm_uvar
                         uu____8898,FStar_Syntax_Syntax.Tm_arrow uu____8899)
                          ->
                          (FStar_TypeChecker_Common.Flex_rigid_eq,
                            (let uu___1259_8929 = tp  in
                             {
                               FStar_TypeChecker_Common.pid =
                                 (uu___1259_8929.FStar_TypeChecker_Common.pid);
                               FStar_TypeChecker_Common.lhs =
                                 (uu___1259_8929.FStar_TypeChecker_Common.lhs);
                               FStar_TypeChecker_Common.relation =
                                 FStar_TypeChecker_Common.EQ;
                               FStar_TypeChecker_Common.rhs =
                                 (uu___1259_8929.FStar_TypeChecker_Common.rhs);
                               FStar_TypeChecker_Common.element =
                                 (uu___1259_8929.FStar_TypeChecker_Common.element);
                               FStar_TypeChecker_Common.logical_guard =
                                 (uu___1259_8929.FStar_TypeChecker_Common.logical_guard);
                               FStar_TypeChecker_Common.logical_guard_uvar =
                                 (uu___1259_8929.FStar_TypeChecker_Common.logical_guard_uvar);
                               FStar_TypeChecker_Common.reason =
                                 (uu___1259_8929.FStar_TypeChecker_Common.reason);
                               FStar_TypeChecker_Common.loc =
                                 (uu___1259_8929.FStar_TypeChecker_Common.loc);
                               FStar_TypeChecker_Common.rank =
                                 (uu___1259_8929.FStar_TypeChecker_Common.rank)
                             }))
                      | (FStar_Syntax_Syntax.Tm_uvar
                         uu____8932,FStar_Syntax_Syntax.Tm_type uu____8933)
                          ->
                          (FStar_TypeChecker_Common.Flex_rigid_eq,
                            (let uu___1259_8949 = tp  in
                             {
                               FStar_TypeChecker_Common.pid =
                                 (uu___1259_8949.FStar_TypeChecker_Common.pid);
                               FStar_TypeChecker_Common.lhs =
                                 (uu___1259_8949.FStar_TypeChecker_Common.lhs);
                               FStar_TypeChecker_Common.relation =
                                 FStar_TypeChecker_Common.EQ;
                               FStar_TypeChecker_Common.rhs =
                                 (uu___1259_8949.FStar_TypeChecker_Common.rhs);
                               FStar_TypeChecker_Common.element =
                                 (uu___1259_8949.FStar_TypeChecker_Common.element);
                               FStar_TypeChecker_Common.logical_guard =
                                 (uu___1259_8949.FStar_TypeChecker_Common.logical_guard);
                               FStar_TypeChecker_Common.logical_guard_uvar =
                                 (uu___1259_8949.FStar_TypeChecker_Common.logical_guard_uvar);
                               FStar_TypeChecker_Common.reason =
                                 (uu___1259_8949.FStar_TypeChecker_Common.reason);
                               FStar_TypeChecker_Common.loc =
                                 (uu___1259_8949.FStar_TypeChecker_Common.loc);
                               FStar_TypeChecker_Common.rank =
                                 (uu___1259_8949.FStar_TypeChecker_Common.rank)
                             }))
                      | (FStar_Syntax_Syntax.Tm_type
                         uu____8952,FStar_Syntax_Syntax.Tm_uvar uu____8953)
                          ->
                          (FStar_TypeChecker_Common.Flex_rigid_eq,
                            (let uu___1259_8969 = tp  in
                             {
                               FStar_TypeChecker_Common.pid =
                                 (uu___1259_8969.FStar_TypeChecker_Common.pid);
                               FStar_TypeChecker_Common.lhs =
                                 (uu___1259_8969.FStar_TypeChecker_Common.lhs);
                               FStar_TypeChecker_Common.relation =
                                 FStar_TypeChecker_Common.EQ;
                               FStar_TypeChecker_Common.rhs =
                                 (uu___1259_8969.FStar_TypeChecker_Common.rhs);
                               FStar_TypeChecker_Common.element =
                                 (uu___1259_8969.FStar_TypeChecker_Common.element);
                               FStar_TypeChecker_Common.logical_guard =
                                 (uu___1259_8969.FStar_TypeChecker_Common.logical_guard);
                               FStar_TypeChecker_Common.logical_guard_uvar =
                                 (uu___1259_8969.FStar_TypeChecker_Common.logical_guard_uvar);
                               FStar_TypeChecker_Common.reason =
                                 (uu___1259_8969.FStar_TypeChecker_Common.reason);
                               FStar_TypeChecker_Common.loc =
                                 (uu___1259_8969.FStar_TypeChecker_Common.loc);
                               FStar_TypeChecker_Common.rank =
                                 (uu___1259_8969.FStar_TypeChecker_Common.rank)
                             }))
                      | (uu____8972,FStar_Syntax_Syntax.Tm_uvar uu____8973)
                          -> (FStar_TypeChecker_Common.Rigid_flex, tp)
                      | (FStar_Syntax_Syntax.Tm_uvar uu____8988,uu____8989)
                          -> (FStar_TypeChecker_Common.Flex_rigid, tp)
                      | (uu____9004,FStar_Syntax_Syntax.Tm_uvar uu____9005)
                          -> (FStar_TypeChecker_Common.Rigid_flex, tp)
                      | (uu____9020,uu____9021) ->
                          (FStar_TypeChecker_Common.Rigid_rigid, tp)
                       in
                    (match uu____8736 with
                     | (rank,tp1) ->
                         let uu____9034 =
                           FStar_All.pipe_right
                             (let uu___1279_9038 = tp1  in
                              {
                                FStar_TypeChecker_Common.pid =
                                  (uu___1279_9038.FStar_TypeChecker_Common.pid);
                                FStar_TypeChecker_Common.lhs =
                                  (uu___1279_9038.FStar_TypeChecker_Common.lhs);
                                FStar_TypeChecker_Common.relation =
                                  (uu___1279_9038.FStar_TypeChecker_Common.relation);
                                FStar_TypeChecker_Common.rhs =
                                  (uu___1279_9038.FStar_TypeChecker_Common.rhs);
                                FStar_TypeChecker_Common.element =
                                  (uu___1279_9038.FStar_TypeChecker_Common.element);
                                FStar_TypeChecker_Common.logical_guard =
                                  (uu___1279_9038.FStar_TypeChecker_Common.logical_guard);
                                FStar_TypeChecker_Common.logical_guard_uvar =
                                  (uu___1279_9038.FStar_TypeChecker_Common.logical_guard_uvar);
                                FStar_TypeChecker_Common.reason =
                                  (uu___1279_9038.FStar_TypeChecker_Common.reason);
                                FStar_TypeChecker_Common.loc =
                                  (uu___1279_9038.FStar_TypeChecker_Common.loc);
                                FStar_TypeChecker_Common.rank =
                                  (FStar_Pervasives_Native.Some rank)
                              })
                             (fun _9041  ->
                                FStar_TypeChecker_Common.TProb _9041)
                            in
                         (rank, uu____9034))))
      | FStar_TypeChecker_Common.CProb cp ->
          let uu____9045 =
            FStar_All.pipe_right
              (let uu___1283_9049 = cp  in
               {
                 FStar_TypeChecker_Common.pid =
                   (uu___1283_9049.FStar_TypeChecker_Common.pid);
                 FStar_TypeChecker_Common.lhs =
                   (uu___1283_9049.FStar_TypeChecker_Common.lhs);
                 FStar_TypeChecker_Common.relation =
                   (uu___1283_9049.FStar_TypeChecker_Common.relation);
                 FStar_TypeChecker_Common.rhs =
                   (uu___1283_9049.FStar_TypeChecker_Common.rhs);
                 FStar_TypeChecker_Common.element =
                   (uu___1283_9049.FStar_TypeChecker_Common.element);
                 FStar_TypeChecker_Common.logical_guard =
                   (uu___1283_9049.FStar_TypeChecker_Common.logical_guard);
                 FStar_TypeChecker_Common.logical_guard_uvar =
                   (uu___1283_9049.FStar_TypeChecker_Common.logical_guard_uvar);
                 FStar_TypeChecker_Common.reason =
                   (uu___1283_9049.FStar_TypeChecker_Common.reason);
                 FStar_TypeChecker_Common.loc =
                   (uu___1283_9049.FStar_TypeChecker_Common.loc);
                 FStar_TypeChecker_Common.rank =
                   (FStar_Pervasives_Native.Some
                      FStar_TypeChecker_Common.Rigid_rigid)
               }) (fun _9052  -> FStar_TypeChecker_Common.CProb _9052)
             in
          (FStar_TypeChecker_Common.Rigid_rigid, uu____9045)
  
let (next_prob :
  worklist ->
    (FStar_TypeChecker_Common.prob * FStar_TypeChecker_Common.prob Prims.list
      * FStar_TypeChecker_Common.rank_t) FStar_Pervasives_Native.option)
  =
  fun wl  ->
    let rec aux uu____9112 probs =
      match uu____9112 with
      | (min_rank,min1,out) ->
          (match probs with
           | [] ->
               (match (min1, min_rank) with
                | (FStar_Pervasives_Native.Some
                   p,FStar_Pervasives_Native.Some r) ->
                    FStar_Pervasives_Native.Some (p, out, r)
                | uu____9193 -> FStar_Pervasives_Native.None)
           | hd1::tl1 ->
               let uu____9214 = rank wl.tcenv hd1  in
               (match uu____9214 with
                | (rank1,hd2) ->
                    if rank_leq rank1 FStar_TypeChecker_Common.Flex_rigid_eq
                    then
                      (match min1 with
                       | FStar_Pervasives_Native.None  ->
                           FStar_Pervasives_Native.Some
                             (hd2, (FStar_List.append out tl1), rank1)
                       | FStar_Pervasives_Native.Some m ->
                           FStar_Pervasives_Native.Some
                             (hd2, (FStar_List.append out (m :: tl1)), rank1))
                    else
                      (let uu____9275 =
                         (min_rank = FStar_Pervasives_Native.None) ||
                           (let uu____9280 = FStar_Option.get min_rank  in
                            rank_less_than rank1 uu____9280)
                          in
                       if uu____9275
                       then
                         match min1 with
                         | FStar_Pervasives_Native.None  ->
                             aux
                               ((FStar_Pervasives_Native.Some rank1),
                                 (FStar_Pervasives_Native.Some hd2), out) tl1
                         | FStar_Pervasives_Native.Some m ->
                             aux
                               ((FStar_Pervasives_Native.Some rank1),
                                 (FStar_Pervasives_Native.Some hd2), (m ::
                                 out)) tl1
                       else aux (min_rank, min1, (hd2 :: out)) tl1)))
       in
    aux (FStar_Pervasives_Native.None, FStar_Pervasives_Native.None, [])
      wl.attempting
  
let (flex_prob_closing :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.binders ->
      FStar_TypeChecker_Common.prob -> Prims.bool)
  =
  fun tcenv  ->
    fun bs  ->
      fun p  ->
        let flex_will_be_closed t =
          let uu____9353 = FStar_Syntax_Util.head_and_args t  in
          match uu____9353 with
          | (hd1,uu____9372) ->
              let uu____9397 =
                let uu____9398 = FStar_Syntax_Subst.compress hd1  in
                uu____9398.FStar_Syntax_Syntax.n  in
              (match uu____9397 with
               | FStar_Syntax_Syntax.Tm_uvar (u,uu____9403) ->
                   FStar_All.pipe_right
                     u.FStar_Syntax_Syntax.ctx_uvar_binders
                     (FStar_Util.for_some
                        (fun uu____9438  ->
                           match uu____9438 with
                           | (y,uu____9447) ->
                               FStar_All.pipe_right bs
                                 (FStar_Util.for_some
                                    (fun uu____9470  ->
                                       match uu____9470 with
                                       | (x,uu____9479) ->
                                           FStar_Syntax_Syntax.bv_eq x y))))
               | uu____9484 -> false)
           in
        let uu____9486 = rank tcenv p  in
        match uu____9486 with
        | (r,p1) ->
            (match p1 with
             | FStar_TypeChecker_Common.CProb uu____9495 -> true
             | FStar_TypeChecker_Common.TProb p2 ->
                 (match r with
                  | FStar_TypeChecker_Common.Rigid_rigid  -> true
                  | FStar_TypeChecker_Common.Flex_rigid_eq  -> true
                  | FStar_TypeChecker_Common.Flex_flex_pattern_eq  -> true
                  | FStar_TypeChecker_Common.Flex_rigid  ->
                      flex_will_be_closed p2.FStar_TypeChecker_Common.lhs
                  | FStar_TypeChecker_Common.Rigid_flex  ->
                      flex_will_be_closed p2.FStar_TypeChecker_Common.rhs
                  | FStar_TypeChecker_Common.Flex_flex  ->
                      (p2.FStar_TypeChecker_Common.relation =
                         FStar_TypeChecker_Common.EQ)
                        &&
                        ((flex_will_be_closed p2.FStar_TypeChecker_Common.lhs)
                           ||
                           (flex_will_be_closed
                              p2.FStar_TypeChecker_Common.rhs))))
  
type univ_eq_sol =
  | UDeferred of worklist 
  | USolved of worklist 
  | UFailed of lstring 
let (uu___is_UDeferred : univ_eq_sol -> Prims.bool) =
  fun projectee  ->
    match projectee with | UDeferred _0 -> true | uu____9550 -> false
  
let (__proj__UDeferred__item___0 : univ_eq_sol -> worklist) =
  fun projectee  -> match projectee with | UDeferred _0 -> _0 
let (uu___is_USolved : univ_eq_sol -> Prims.bool) =
  fun projectee  ->
    match projectee with | USolved _0 -> true | uu____9569 -> false
  
let (__proj__USolved__item___0 : univ_eq_sol -> worklist) =
  fun projectee  -> match projectee with | USolved _0 -> _0 
let (uu___is_UFailed : univ_eq_sol -> Prims.bool) =
  fun projectee  ->
    match projectee with | UFailed _0 -> true | uu____9588 -> false
  
let (__proj__UFailed__item___0 : univ_eq_sol -> lstring) =
  fun projectee  -> match projectee with | UFailed _0 -> _0 
let (ufailed_simple : Prims.string -> univ_eq_sol) =
  fun s  -> let uu____9605 = FStar_Thunk.mkv s  in UFailed uu____9605 
let (ufailed_thunk : (unit -> Prims.string) -> univ_eq_sol) =
  fun s  -> let uu____9620 = FStar_Thunk.mk s  in UFailed uu____9620 
let rec (really_solve_universe_eq :
  Prims.int ->
    worklist ->
      FStar_Syntax_Syntax.universe ->
        FStar_Syntax_Syntax.universe -> univ_eq_sol)
  =
  fun pid_orig  ->
    fun wl  ->
      fun u1  ->
        fun u2  ->
          let u11 =
            FStar_TypeChecker_Normalize.normalize_universe wl.tcenv u1  in
          let u21 =
            FStar_TypeChecker_Normalize.normalize_universe wl.tcenv u2  in
          let rec occurs_univ v1 u =
            match u with
            | FStar_Syntax_Syntax.U_max us ->
                FStar_All.pipe_right us
                  (FStar_Util.for_some
                     (fun u3  ->
                        let uu____9672 = FStar_Syntax_Util.univ_kernel u3  in
                        match uu____9672 with
                        | (k,uu____9680) ->
                            (match k with
                             | FStar_Syntax_Syntax.U_unif v2 ->
                                 FStar_Syntax_Unionfind.univ_equiv v1 v2
                             | uu____9693 -> false)))
            | uu____9695 -> occurs_univ v1 (FStar_Syntax_Syntax.U_max [u])
             in
          let rec filter_out_common_univs u12 u22 =
            let common_elts =
              FStar_All.pipe_right u12
                (FStar_List.fold_left
                   (fun uvs  ->
                      fun uv1  ->
                        let uu____9747 =
                          FStar_All.pipe_right u22
                            (FStar_List.existsML
                               (fun uv2  ->
                                  let uu____9755 =
                                    FStar_Syntax_Util.compare_univs uv1 uv2
                                     in
                                  uu____9755 = Prims.int_zero))
                           in
                        if uu____9747 then uv1 :: uvs else uvs) [])
               in
            let filter1 =
              FStar_List.filter
                (fun u  ->
                   let uu____9776 =
                     FStar_All.pipe_right common_elts
                       (FStar_List.existsML
                          (fun u'  ->
                             let uu____9784 =
                               FStar_Syntax_Util.compare_univs u u'  in
                             uu____9784 = Prims.int_zero))
                      in
                   Prims.op_Negation uu____9776)
               in
            let uu____9788 = filter1 u12  in
            let uu____9791 = filter1 u22  in (uu____9788, uu____9791)  in
          let try_umax_components u12 u22 msg =
            if Prims.op_Negation wl.umax_heuristic_ok
            then ufailed_simple "Unable to unify universe terms with umax"
            else
              (match (u12, u22) with
               | (FStar_Syntax_Syntax.U_max us1,FStar_Syntax_Syntax.U_max
                  us2) ->
                   let uu____9826 = filter_out_common_univs us1 us2  in
                   (match uu____9826 with
                    | (us11,us21) ->
                        if
                          (FStar_List.length us11) = (FStar_List.length us21)
                        then
                          let rec aux wl1 us12 us22 =
                            match (us12, us22) with
                            | (u13::us13,u23::us23) ->
                                let uu____9886 =
                                  really_solve_universe_eq pid_orig wl1 u13
                                    u23
                                   in
                                (match uu____9886 with
                                 | USolved wl2 -> aux wl2 us13 us23
                                 | failed -> failed)
                            | uu____9889 -> USolved wl1  in
                          aux wl us11 us21
                        else
                          ufailed_thunk
                            (fun uu____9906  ->
                               let uu____9907 =
                                 FStar_Syntax_Print.univ_to_string u12  in
                               let uu____9909 =
                                 FStar_Syntax_Print.univ_to_string u22  in
                               FStar_Util.format2
                                 "Unable to unify universes: %s and %s"
                                 uu____9907 uu____9909))
               | (FStar_Syntax_Syntax.U_max us,u') ->
                   let rec aux wl1 us1 =
                     match us1 with
                     | [] -> USolved wl1
                     | u::us2 ->
                         let uu____9935 =
                           really_solve_universe_eq pid_orig wl1 u u'  in
                         (match uu____9935 with
                          | USolved wl2 -> aux wl2 us2
                          | failed -> failed)
                      in
                   aux wl us
               | (u',FStar_Syntax_Syntax.U_max us) ->
                   let rec aux wl1 us1 =
                     match us1 with
                     | [] -> USolved wl1
                     | u::us2 ->
                         let uu____9961 =
                           really_solve_universe_eq pid_orig wl1 u u'  in
                         (match uu____9961 with
                          | USolved wl2 -> aux wl2 us2
                          | failed -> failed)
                      in
                   aux wl us
               | uu____9964 ->
                   ufailed_thunk
                     (fun uu____9975  ->
                        let uu____9976 =
                          FStar_Syntax_Print.univ_to_string u12  in
                        let uu____9978 =
                          FStar_Syntax_Print.univ_to_string u22  in
                        FStar_Util.format3
                          "Unable to unify universes: %s and %s (%s)"
                          uu____9976 uu____9978 msg))
             in
          match (u11, u21) with
          | (FStar_Syntax_Syntax.U_bvar uu____9981,uu____9982) ->
              let uu____9984 =
                let uu____9986 = FStar_Syntax_Print.univ_to_string u11  in
                let uu____9988 = FStar_Syntax_Print.univ_to_string u21  in
                FStar_Util.format2
                  "Impossible: found an de Bruijn universe variable or unknown universe: %s, %s"
                  uu____9986 uu____9988
                 in
              failwith uu____9984
          | (FStar_Syntax_Syntax.U_unknown ,uu____9991) ->
              let uu____9992 =
                let uu____9994 = FStar_Syntax_Print.univ_to_string u11  in
                let uu____9996 = FStar_Syntax_Print.univ_to_string u21  in
                FStar_Util.format2
                  "Impossible: found an de Bruijn universe variable or unknown universe: %s, %s"
                  uu____9994 uu____9996
                 in
              failwith uu____9992
          | (uu____9999,FStar_Syntax_Syntax.U_bvar uu____10000) ->
              let uu____10002 =
                let uu____10004 = FStar_Syntax_Print.univ_to_string u11  in
                let uu____10006 = FStar_Syntax_Print.univ_to_string u21  in
                FStar_Util.format2
                  "Impossible: found an de Bruijn universe variable or unknown universe: %s, %s"
                  uu____10004 uu____10006
                 in
              failwith uu____10002
          | (uu____10009,FStar_Syntax_Syntax.U_unknown ) ->
              let uu____10010 =
                let uu____10012 = FStar_Syntax_Print.univ_to_string u11  in
                let uu____10014 = FStar_Syntax_Print.univ_to_string u21  in
                FStar_Util.format2
                  "Impossible: found an de Bruijn universe variable or unknown universe: %s, %s"
                  uu____10012 uu____10014
                 in
              failwith uu____10010
          | (FStar_Syntax_Syntax.U_name x,FStar_Syntax_Syntax.U_name y) ->
              if x.FStar_Ident.idText = y.FStar_Ident.idText
              then USolved wl
              else ufailed_simple "Incompatible universes"
          | (FStar_Syntax_Syntax.U_zero ,FStar_Syntax_Syntax.U_zero ) ->
              USolved wl
          | (FStar_Syntax_Syntax.U_succ u12,FStar_Syntax_Syntax.U_succ u22)
              -> really_solve_universe_eq pid_orig wl u12 u22
          | (FStar_Syntax_Syntax.U_unif v1,FStar_Syntax_Syntax.U_unif v2) ->
              let uu____10044 = FStar_Syntax_Unionfind.univ_equiv v1 v2  in
              if uu____10044
              then USolved wl
              else
                (let wl1 = extend_solution pid_orig [UNIV (v1, u21)] wl  in
                 USolved wl1)
          | (FStar_Syntax_Syntax.U_unif v1,u) ->
              let u3 = norm_univ wl u  in
              let uu____10061 = occurs_univ v1 u3  in
              if uu____10061
              then
                let uu____10064 =
                  let uu____10066 =
                    FStar_Syntax_Print.univ_to_string
                      (FStar_Syntax_Syntax.U_unif v1)
                     in
                  let uu____10068 = FStar_Syntax_Print.univ_to_string u3  in
                  FStar_Util.format2 "Failed occurs check: %s occurs in %s"
                    uu____10066 uu____10068
                   in
                try_umax_components u11 u21 uu____10064
              else
                (let uu____10073 =
                   extend_solution pid_orig [UNIV (v1, u3)] wl  in
                 USolved uu____10073)
          | (u,FStar_Syntax_Syntax.U_unif v1) ->
              let u3 = norm_univ wl u  in
              let uu____10085 = occurs_univ v1 u3  in
              if uu____10085
              then
                let uu____10088 =
                  let uu____10090 =
                    FStar_Syntax_Print.univ_to_string
                      (FStar_Syntax_Syntax.U_unif v1)
                     in
                  let uu____10092 = FStar_Syntax_Print.univ_to_string u3  in
                  FStar_Util.format2 "Failed occurs check: %s occurs in %s"
                    uu____10090 uu____10092
                   in
                try_umax_components u11 u21 uu____10088
              else
                (let uu____10097 =
                   extend_solution pid_orig [UNIV (v1, u3)] wl  in
                 USolved uu____10097)
          | (FStar_Syntax_Syntax.U_max uu____10098,uu____10099) ->
              if wl.defer_ok
              then UDeferred wl
              else
                (let u12 = norm_univ wl u11  in
                 let u22 = norm_univ wl u21  in
                 let uu____10107 = FStar_Syntax_Util.eq_univs u12 u22  in
                 if uu____10107
                 then USolved wl
                 else try_umax_components u12 u22 "")
          | (uu____10113,FStar_Syntax_Syntax.U_max uu____10114) ->
              if wl.defer_ok
              then UDeferred wl
              else
                (let u12 = norm_univ wl u11  in
                 let u22 = norm_univ wl u21  in
                 let uu____10122 = FStar_Syntax_Util.eq_univs u12 u22  in
                 if uu____10122
                 then USolved wl
                 else try_umax_components u12 u22 "")
          | (FStar_Syntax_Syntax.U_succ
             uu____10128,FStar_Syntax_Syntax.U_zero ) ->
              ufailed_simple "Incompatible universes"
          | (FStar_Syntax_Syntax.U_succ
             uu____10130,FStar_Syntax_Syntax.U_name uu____10131) ->
              ufailed_simple "Incompatible universes"
          | (FStar_Syntax_Syntax.U_zero ,FStar_Syntax_Syntax.U_succ
             uu____10133) -> ufailed_simple "Incompatible universes"
          | (FStar_Syntax_Syntax.U_zero ,FStar_Syntax_Syntax.U_name
             uu____10135) -> ufailed_simple "Incompatible universes"
          | (FStar_Syntax_Syntax.U_name
             uu____10137,FStar_Syntax_Syntax.U_succ uu____10138) ->
              ufailed_simple "Incompatible universes"
          | (FStar_Syntax_Syntax.U_name
             uu____10140,FStar_Syntax_Syntax.U_zero ) ->
              ufailed_simple "Incompatible universes"
  
let (solve_universe_eq :
  Prims.int ->
    worklist ->
      FStar_Syntax_Syntax.universe ->
        FStar_Syntax_Syntax.universe -> univ_eq_sol)
  =
  fun orig  ->
    fun wl  ->
      fun u1  ->
        fun u2  ->
          if (wl.tcenv).FStar_TypeChecker_Env.lax_universes
          then USolved wl
          else really_solve_universe_eq orig wl u1 u2
  
let match_num_binders :
  'a 'b .
    ('a Prims.list * ('a Prims.list -> 'b)) ->
      ('a Prims.list * ('a Prims.list -> 'b)) ->
        (('a Prims.list * 'b) * ('a Prims.list * 'b))
  =
  fun bc1  ->
    fun bc2  ->
      let uu____10247 = bc1  in
      match uu____10247 with
      | (bs1,mk_cod1) ->
          let uu____10291 = bc2  in
          (match uu____10291 with
           | (bs2,mk_cod2) ->
               let rec aux bs11 bs21 =
                 match (bs11, bs21) with
                 | (x::xs,y::ys) ->
                     let uu____10402 = aux xs ys  in
                     (match uu____10402 with
                      | ((xs1,xr),(ys1,yr)) ->
                          (((x :: xs1), xr), ((y :: ys1), yr)))
                 | (xs,ys) ->
                     let uu____10485 =
                       let uu____10492 = mk_cod1 xs  in ([], uu____10492)  in
                     let uu____10495 =
                       let uu____10502 = mk_cod2 ys  in ([], uu____10502)  in
                     (uu____10485, uu____10495)
                  in
               aux bs1 bs2)
  
let (guard_of_prob :
  FStar_TypeChecker_Env.env ->
    worklist ->
      tprob ->
        FStar_Syntax_Syntax.term ->
          FStar_Syntax_Syntax.term -> (FStar_Syntax_Syntax.term * worklist))
  =
  fun env  ->
    fun wl  ->
      fun problem  ->
        fun t1  ->
          fun t2  ->
            let has_type_guard t11 t21 =
              match problem.FStar_TypeChecker_Common.element with
              | FStar_Pervasives_Native.Some t ->
                  let uu____10571 = FStar_Syntax_Syntax.bv_to_name t  in
                  FStar_Syntax_Util.mk_has_type t11 uu____10571 t21
              | FStar_Pervasives_Native.None  ->
                  let x =
                    FStar_Syntax_Syntax.new_bv FStar_Pervasives_Native.None
                      t11
                     in
                  let u_x = env.FStar_TypeChecker_Env.universe_of env t11  in
                  let uu____10574 =
                    let uu____10575 = FStar_Syntax_Syntax.bv_to_name x  in
                    FStar_Syntax_Util.mk_has_type t11 uu____10575 t21  in
                  FStar_Syntax_Util.mk_forall u_x x uu____10574
               in
            match problem.FStar_TypeChecker_Common.relation with
            | FStar_TypeChecker_Common.EQ  ->
                mk_eq2 wl env (FStar_TypeChecker_Common.TProb problem) t1 t2
            | FStar_TypeChecker_Common.SUB  ->
                let uu____10580 = has_type_guard t1 t2  in (uu____10580, wl)
            | FStar_TypeChecker_Common.SUBINV  ->
                let uu____10581 = has_type_guard t2 t1  in (uu____10581, wl)
  
let is_flex_pat :
  'Auu____10591 'Auu____10592 'Auu____10593 .
    ('Auu____10591 * 'Auu____10592 * 'Auu____10593 Prims.list) -> Prims.bool
  =
  fun uu___25_10607  ->
    match uu___25_10607 with
    | (uu____10616,uu____10617,[]) -> true
    | uu____10621 -> false
  
let (quasi_pattern :
  FStar_TypeChecker_Env.env ->
    flex_t ->
      (FStar_Syntax_Syntax.binders * FStar_Syntax_Syntax.typ)
        FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun f  ->
      let uu____10654 = f  in
      match uu____10654 with
      | (uu____10661,{ FStar_Syntax_Syntax.ctx_uvar_head = uu____10662;
                       FStar_Syntax_Syntax.ctx_uvar_gamma = uu____10663;
                       FStar_Syntax_Syntax.ctx_uvar_binders = ctx;
                       FStar_Syntax_Syntax.ctx_uvar_typ = t_hd;
                       FStar_Syntax_Syntax.ctx_uvar_reason = uu____10666;
                       FStar_Syntax_Syntax.ctx_uvar_should_check =
                         uu____10667;
                       FStar_Syntax_Syntax.ctx_uvar_range = uu____10668;
                       FStar_Syntax_Syntax.ctx_uvar_meta = uu____10669;_},args)
          ->
          let name_exists_in x bs =
            FStar_Util.for_some
              (fun uu____10739  ->
                 match uu____10739 with
                 | (y,uu____10748) -> FStar_Syntax_Syntax.bv_eq x y) bs
             in
          let rec aux pat_binders formals t_res args1 =
            match (formals, args1) with
            | ([],[]) ->
                let uu____10902 =
                  let uu____10917 =
                    let uu____10920 = FStar_Syntax_Syntax.mk_Total t_res  in
                    FStar_Syntax_Util.arrow formals uu____10920  in
                  ((FStar_List.rev pat_binders), uu____10917)  in
                FStar_Pervasives_Native.Some uu____10902
            | (uu____10953,[]) ->
                let uu____10984 =
                  let uu____10999 =
                    let uu____11002 = FStar_Syntax_Syntax.mk_Total t_res  in
                    FStar_Syntax_Util.arrow formals uu____11002  in
                  ((FStar_List.rev pat_binders), uu____10999)  in
                FStar_Pervasives_Native.Some uu____10984
            | ((formal,formal_imp)::formals1,(a,a_imp)::args2) ->
                let uu____11093 =
                  let uu____11094 = FStar_Syntax_Subst.compress a  in
                  uu____11094.FStar_Syntax_Syntax.n  in
                (match uu____11093 with
                 | FStar_Syntax_Syntax.Tm_name x ->
                     let uu____11114 =
                       (name_exists_in x ctx) ||
                         (name_exists_in x pat_binders)
                        in
                     if uu____11114
                     then
                       aux ((formal, formal_imp) :: pat_binders) formals1
                         t_res args2
                     else
                       (let x1 =
                          let uu___1611_11144 = x  in
                          {
                            FStar_Syntax_Syntax.ppname =
                              (uu___1611_11144.FStar_Syntax_Syntax.ppname);
                            FStar_Syntax_Syntax.index =
                              (uu___1611_11144.FStar_Syntax_Syntax.index);
                            FStar_Syntax_Syntax.sort =
                              (formal.FStar_Syntax_Syntax.sort)
                          }  in
                        let subst1 =
                          let uu____11148 =
                            let uu____11149 =
                              let uu____11156 =
                                FStar_Syntax_Syntax.bv_to_name x1  in
                              (formal, uu____11156)  in
                            FStar_Syntax_Syntax.NT uu____11149  in
                          [uu____11148]  in
                        let formals2 =
                          FStar_Syntax_Subst.subst_binders subst1 formals1
                           in
                        let t_res1 = FStar_Syntax_Subst.subst subst1 t_res
                           in
                        aux
                          (((let uu___1617_11172 = x1  in
                             {
                               FStar_Syntax_Syntax.ppname =
                                 (uu___1617_11172.FStar_Syntax_Syntax.ppname);
                               FStar_Syntax_Syntax.index =
                                 (uu___1617_11172.FStar_Syntax_Syntax.index);
                               FStar_Syntax_Syntax.sort =
                                 (formal.FStar_Syntax_Syntax.sort)
                             }), a_imp) :: pat_binders) formals2 t_res1 args2)
                 | uu____11173 ->
                     aux ((formal, formal_imp) :: pat_binders) formals1 t_res
                       args2)
            | ([],args2) ->
                let uu____11213 =
                  let uu____11220 =
                    FStar_TypeChecker_Normalize.unfold_whnf env t_res  in
                  FStar_Syntax_Util.arrow_formals uu____11220  in
                (match uu____11213 with
                 | (more_formals,t_res1) ->
                     (match more_formals with
                      | [] -> FStar_Pervasives_Native.None
                      | uu____11279 ->
                          aux pat_binders more_formals t_res1 args2))
             in
          (match args with
           | [] -> FStar_Pervasives_Native.Some ([], t_hd)
           | uu____11304 ->
               let uu____11305 = FStar_Syntax_Util.arrow_formals t_hd  in
               (match uu____11305 with
                | (formals,t_res) -> aux [] formals t_res args))
  
let rec (solve : FStar_TypeChecker_Env.env -> worklist -> solution) =
  fun env  ->
    fun probs  ->
      (let uu____11601 =
         FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
           (FStar_Options.Other "Rel")
          in
       if uu____11601
       then
         let uu____11606 = wl_to_string probs  in
         FStar_Util.print1 "solve:\n\t%s\n" uu____11606
       else ());
      (let uu____11612 =
         FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
           (FStar_Options.Other "ImplicitTrace")
          in
       if uu____11612
       then
         let uu____11617 =
           FStar_TypeChecker_Common.implicits_to_string probs.wl_implicits
            in
         FStar_Util.print1 "solve: wl_implicits = %s\n" uu____11617
       else ());
      (let uu____11622 = next_prob probs  in
       match uu____11622 with
       | FStar_Pervasives_Native.Some (hd1,tl1,rank1) ->
           let probs1 =
             let uu___1644_11649 = probs  in
             {
               attempting = tl1;
               wl_deferred = (uu___1644_11649.wl_deferred);
               ctr = (uu___1644_11649.ctr);
               defer_ok = (uu___1644_11649.defer_ok);
               smt_ok = (uu___1644_11649.smt_ok);
               umax_heuristic_ok = (uu___1644_11649.umax_heuristic_ok);
               tcenv = (uu___1644_11649.tcenv);
               wl_implicits = (uu___1644_11649.wl_implicits)
             }  in
           (def_check_prob "solve,hd" hd1;
            (match hd1 with
             | FStar_TypeChecker_Common.CProb cp ->
                 solve_c env (maybe_invert cp) probs1
             | FStar_TypeChecker_Common.TProb tp ->
                 let uu____11658 =
                   FStar_Util.physical_equality
                     tp.FStar_TypeChecker_Common.lhs
                     tp.FStar_TypeChecker_Common.rhs
                    in
                 if uu____11658
                 then
                   let uu____11661 =
                     solve_prob hd1 FStar_Pervasives_Native.None [] probs1
                      in
                   solve env uu____11661
                 else
                   if
                     (rank1 = FStar_TypeChecker_Common.Rigid_rigid) ||
                       ((tp.FStar_TypeChecker_Common.relation =
                           FStar_TypeChecker_Common.EQ)
                          && (rank1 <> FStar_TypeChecker_Common.Flex_flex))
                   then solve_t env tp probs1
                   else
                     if probs1.defer_ok
                     then
                       (let uu____11668 =
                          defer_lit
                            "deferring flex_rigid or flex_flex subtyping" hd1
                            probs1
                           in
                        solve env uu____11668)
                     else
                       if rank1 = FStar_TypeChecker_Common.Flex_flex
                       then
                         solve_t env
                           (let uu___1656_11674 = tp  in
                            {
                              FStar_TypeChecker_Common.pid =
                                (uu___1656_11674.FStar_TypeChecker_Common.pid);
                              FStar_TypeChecker_Common.lhs =
                                (uu___1656_11674.FStar_TypeChecker_Common.lhs);
                              FStar_TypeChecker_Common.relation =
                                FStar_TypeChecker_Common.EQ;
                              FStar_TypeChecker_Common.rhs =
                                (uu___1656_11674.FStar_TypeChecker_Common.rhs);
                              FStar_TypeChecker_Common.element =
                                (uu___1656_11674.FStar_TypeChecker_Common.element);
                              FStar_TypeChecker_Common.logical_guard =
                                (uu___1656_11674.FStar_TypeChecker_Common.logical_guard);
                              FStar_TypeChecker_Common.logical_guard_uvar =
                                (uu___1656_11674.FStar_TypeChecker_Common.logical_guard_uvar);
                              FStar_TypeChecker_Common.reason =
                                (uu___1656_11674.FStar_TypeChecker_Common.reason);
                              FStar_TypeChecker_Common.loc =
                                (uu___1656_11674.FStar_TypeChecker_Common.loc);
                              FStar_TypeChecker_Common.rank =
                                (uu___1656_11674.FStar_TypeChecker_Common.rank)
                            }) probs1
                       else
                         solve_rigid_flex_or_flex_rigid_subtyping rank1 env
                           tp probs1))
       | FStar_Pervasives_Native.None  ->
           (match probs.wl_deferred with
            | [] -> Success ([], (probs.wl_implicits))
            | uu____11699 ->
                let uu____11709 =
                  FStar_All.pipe_right probs.wl_deferred
                    (FStar_List.partition
                       (fun uu____11774  ->
                          match uu____11774 with
                          | (c,uu____11784,uu____11785) -> c < probs.ctr))
                   in
                (match uu____11709 with
                 | (attempt1,rest) ->
                     (match attempt1 with
                      | [] ->
                          let uu____11833 =
                            let uu____11838 =
                              FStar_List.map
                                (fun uu____11859  ->
                                   match uu____11859 with
                                   | (uu____11875,x,y) ->
                                       let uu____11886 = FStar_Thunk.force x
                                          in
                                       (uu____11886, y)) probs.wl_deferred
                               in
                            (uu____11838, (probs.wl_implicits))  in
                          Success uu____11833
                      | uu____11890 ->
                          let uu____11900 =
                            let uu___1674_11901 = probs  in
                            let uu____11902 =
                              FStar_All.pipe_right attempt1
                                (FStar_List.map
                                   (fun uu____11923  ->
                                      match uu____11923 with
                                      | (uu____11931,uu____11932,y) -> y))
                               in
                            {
                              attempting = uu____11902;
                              wl_deferred = rest;
                              ctr = (uu___1674_11901.ctr);
                              defer_ok = (uu___1674_11901.defer_ok);
                              smt_ok = (uu___1674_11901.smt_ok);
                              umax_heuristic_ok =
                                (uu___1674_11901.umax_heuristic_ok);
                              tcenv = (uu___1674_11901.tcenv);
                              wl_implicits = (uu___1674_11901.wl_implicits)
                            }  in
                          solve env uu____11900))))

and (solve_one_universe_eq :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob ->
      FStar_Syntax_Syntax.universe ->
        FStar_Syntax_Syntax.universe -> worklist -> solution)
  =
  fun env  ->
    fun orig  ->
      fun u1  ->
        fun u2  ->
          fun wl  ->
            let uu____11941 = solve_universe_eq (p_pid orig) wl u1 u2  in
            match uu____11941 with
            | USolved wl1 ->
                let uu____11943 =
                  solve_prob orig FStar_Pervasives_Native.None [] wl1  in
                solve env uu____11943
            | UFailed msg -> giveup env msg orig
            | UDeferred wl1 ->
                let uu____11946 = defer_lit "" orig wl1  in
                solve env uu____11946

and (solve_maybe_uinsts :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob ->
      FStar_Syntax_Syntax.term ->
        FStar_Syntax_Syntax.term -> worklist -> univ_eq_sol)
  =
  fun env  ->
    fun orig  ->
      fun t1  ->
        fun t2  ->
          fun wl  ->
            let rec aux wl1 us1 us2 =
              match (us1, us2) with
              | ([],[]) -> USolved wl1
              | (u1::us11,u2::us21) ->
                  let uu____11997 = solve_universe_eq (p_pid orig) wl1 u1 u2
                     in
                  (match uu____11997 with
                   | USolved wl2 -> aux wl2 us11 us21
                   | failed_or_deferred -> failed_or_deferred)
              | uu____12000 -> ufailed_simple "Unequal number of universes"
               in
            let t11 = whnf env t1  in
            let t21 = whnf env t2  in
            match ((t11.FStar_Syntax_Syntax.n), (t21.FStar_Syntax_Syntax.n))
            with
            | (FStar_Syntax_Syntax.Tm_uinst
               ({ FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_fvar f;
                  FStar_Syntax_Syntax.pos = uu____12013;
                  FStar_Syntax_Syntax.vars = uu____12014;_},us1),FStar_Syntax_Syntax.Tm_uinst
               ({ FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_fvar g;
                  FStar_Syntax_Syntax.pos = uu____12017;
                  FStar_Syntax_Syntax.vars = uu____12018;_},us2))
                -> let b = FStar_Syntax_Syntax.fv_eq f g  in aux wl us1 us2
            | (FStar_Syntax_Syntax.Tm_uinst uu____12031,uu____12032) ->
                failwith "Impossible: expect head symbols to match"
            | (uu____12040,FStar_Syntax_Syntax.Tm_uinst uu____12041) ->
                failwith "Impossible: expect head symbols to match"
            | uu____12049 -> USolved wl

and (giveup_or_defer :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob -> worklist -> lstring -> solution)
  =
  fun env  ->
    fun orig  ->
      fun wl  ->
        fun msg  ->
          if wl.defer_ok
          then
            ((let uu____12060 =
                FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                  (FStar_Options.Other "Rel")
                 in
              if uu____12060
              then
                let uu____12065 = prob_to_string env orig  in
                let uu____12067 = FStar_Thunk.force msg  in
                FStar_Util.print2 "\n\t\tDeferring %s\n\t\tBecause %s\n"
                  uu____12065 uu____12067
              else ());
             solve env (defer msg orig wl))
          else giveup env msg orig

and (solve_rigid_flex_or_flex_rigid_subtyping :
  FStar_TypeChecker_Common.rank_t ->
    FStar_TypeChecker_Env.env -> tprob -> worklist -> solution)
  =
  fun rank1  ->
    fun env  ->
      fun tp  ->
        fun wl  ->
          def_check_prob "solve_rigid_flex_or_flex_rigid_subtyping"
            (FStar_TypeChecker_Common.TProb tp);
          (let flip = rank1 = FStar_TypeChecker_Common.Flex_rigid  in
           let meet_or_join op ts env1 wl1 =
             let eq_prob t1 t2 wl2 =
               let uu____12160 =
                 new_problem wl2 env1 t1 FStar_TypeChecker_Common.EQ t2
                   FStar_Pervasives_Native.None t1.FStar_Syntax_Syntax.pos
                   "join/meet refinements"
                  in
               match uu____12160 with
               | (p,wl3) ->
                   (def_check_prob "meet_or_join"
                      (FStar_TypeChecker_Common.TProb p);
                    ((FStar_TypeChecker_Common.TProb p), wl3))
                in
             let pairwise t1 t2 wl2 =
               (let uu____12215 =
                  FStar_All.pipe_left (FStar_TypeChecker_Env.debug env1)
                    (FStar_Options.Other "Rel")
                   in
                if uu____12215
                then
                  let uu____12220 = FStar_Syntax_Print.term_to_string t1  in
                  let uu____12222 = FStar_Syntax_Print.term_to_string t2  in
                  FStar_Util.print2 "[meet/join]: pairwise: %s and %s\n"
                    uu____12220 uu____12222
                else ());
               (let uu____12227 = head_matches_delta env1 wl2 t1 t2  in
                match uu____12227 with
                | (mr,ts1) ->
                    (match mr with
                     | HeadMatch (true ) ->
                         let uu____12273 = eq_prob t1 t2 wl2  in
                         (match uu____12273 with | (p,wl3) -> (t1, [p], wl3))
                     | MisMatch uu____12294 ->
                         let uu____12303 = eq_prob t1 t2 wl2  in
                         (match uu____12303 with | (p,wl3) -> (t1, [p], wl3))
                     | FullMatch  ->
                         (match ts1 with
                          | FStar_Pervasives_Native.None  -> (t1, [], wl2)
                          | FStar_Pervasives_Native.Some (t11,t21) ->
                              (t11, [], wl2))
                     | HeadMatch (false ) ->
                         let uu____12353 =
                           match ts1 with
                           | FStar_Pervasives_Native.Some (t11,t21) ->
                               let uu____12368 =
                                 FStar_Syntax_Subst.compress t11  in
                               let uu____12369 =
                                 FStar_Syntax_Subst.compress t21  in
                               (uu____12368, uu____12369)
                           | FStar_Pervasives_Native.None  ->
                               let uu____12374 =
                                 FStar_Syntax_Subst.compress t1  in
                               let uu____12375 =
                                 FStar_Syntax_Subst.compress t2  in
                               (uu____12374, uu____12375)
                            in
                         (match uu____12353 with
                          | (t11,t21) ->
                              let try_eq t12 t22 wl3 =
                                let uu____12406 =
                                  FStar_Syntax_Util.head_and_args t12  in
                                match uu____12406 with
                                | (t1_hd,t1_args) ->
                                    let uu____12451 =
                                      FStar_Syntax_Util.head_and_args t22  in
                                    (match uu____12451 with
                                     | (t2_hd,t2_args) ->
                                         if
                                           (FStar_List.length t1_args) <>
                                             (FStar_List.length t2_args)
                                         then FStar_Pervasives_Native.None
                                         else
                                           (let uu____12517 =
                                              let uu____12524 =
                                                let uu____12535 =
                                                  FStar_Syntax_Syntax.as_arg
                                                    t1_hd
                                                   in
                                                uu____12535 :: t1_args  in
                                              let uu____12552 =
                                                let uu____12561 =
                                                  FStar_Syntax_Syntax.as_arg
                                                    t2_hd
                                                   in
                                                uu____12561 :: t2_args  in
                                              FStar_List.fold_left2
                                                (fun uu____12610  ->
                                                   fun uu____12611  ->
                                                     fun uu____12612  ->
                                                       match (uu____12610,
                                                               uu____12611,
                                                               uu____12612)
                                                       with
                                                       | ((probs,wl4),
                                                          (a1,uu____12662),
                                                          (a2,uu____12664))
                                                           ->
                                                           let uu____12701 =
                                                             eq_prob a1 a2
                                                               wl4
                                                              in
                                                           (match uu____12701
                                                            with
                                                            | (p,wl5) ->
                                                                ((p ::
                                                                  probs),
                                                                  wl5)))
                                                ([], wl3) uu____12524
                                                uu____12552
                                               in
                                            match uu____12517 with
                                            | (probs,wl4) ->
                                                let wl' =
                                                  let uu___1828_12727 = wl4
                                                     in
                                                  {
                                                    attempting = probs;
                                                    wl_deferred = [];
                                                    ctr =
                                                      (uu___1828_12727.ctr);
                                                    defer_ok = false;
                                                    smt_ok = false;
                                                    umax_heuristic_ok =
                                                      (uu___1828_12727.umax_heuristic_ok);
                                                    tcenv =
                                                      (uu___1828_12727.tcenv);
                                                    wl_implicits = []
                                                  }  in
                                                let tx =
                                                  FStar_Syntax_Unionfind.new_transaction
                                                    ()
                                                   in
                                                let uu____12738 =
                                                  solve env1 wl'  in
                                                (match uu____12738 with
                                                 | Success (uu____12741,imps)
                                                     ->
                                                     (FStar_Syntax_Unionfind.commit
                                                        tx;
                                                      FStar_Pervasives_Native.Some
                                                        ((let uu___1837_12745
                                                            = wl4  in
                                                          {
                                                            attempting =
                                                              (uu___1837_12745.attempting);
                                                            wl_deferred =
                                                              (uu___1837_12745.wl_deferred);
                                                            ctr =
                                                              (uu___1837_12745.ctr);
                                                            defer_ok =
                                                              (uu___1837_12745.defer_ok);
                                                            smt_ok =
                                                              (uu___1837_12745.smt_ok);
                                                            umax_heuristic_ok
                                                              =
                                                              (uu___1837_12745.umax_heuristic_ok);
                                                            tcenv =
                                                              (uu___1837_12745.tcenv);
                                                            wl_implicits =
                                                              (FStar_List.append
                                                                 wl4.wl_implicits
                                                                 imps)
                                                          })))
                                                 | Failed uu____12746 ->
                                                     (FStar_Syntax_Unionfind.rollback
                                                        tx;
                                                      FStar_Pervasives_Native.None))))
                                 in
                              let combine t12 t22 wl3 =
                                let uu____12778 =
                                  base_and_refinement_maybe_delta false env1
                                    t12
                                   in
                                match uu____12778 with
                                | (t1_base,p1_opt) ->
                                    let uu____12814 =
                                      base_and_refinement_maybe_delta false
                                        env1 t22
                                       in
                                    (match uu____12814 with
                                     | (t2_base,p2_opt) ->
                                         let combine_refinements t_base
                                           p1_opt1 p2_opt1 =
                                           let refine1 x t =
                                             let uu____12913 =
                                               FStar_Syntax_Util.is_t_true t
                                                in
                                             if uu____12913
                                             then x.FStar_Syntax_Syntax.sort
                                             else
                                               FStar_Syntax_Util.refine x t
                                              in
                                           match (p1_opt1, p2_opt1) with
                                           | (FStar_Pervasives_Native.Some
                                              (x,phi1),FStar_Pervasives_Native.Some
                                              (y,phi2)) ->
                                               let x1 =
                                                 FStar_Syntax_Syntax.freshen_bv
                                                   x
                                                  in
                                               let subst1 =
                                                 [FStar_Syntax_Syntax.DB
                                                    (Prims.int_zero, x1)]
                                                  in
                                               let phi11 =
                                                 FStar_Syntax_Subst.subst
                                                   subst1 phi1
                                                  in
                                               let phi21 =
                                                 FStar_Syntax_Subst.subst
                                                   subst1 phi2
                                                  in
                                               let uu____12966 =
                                                 op phi11 phi21  in
                                               refine1 x1 uu____12966
                                           | (FStar_Pervasives_Native.None
                                              ,FStar_Pervasives_Native.Some
                                              (x,phi)) ->
                                               let x1 =
                                                 FStar_Syntax_Syntax.freshen_bv
                                                   x
                                                  in
                                               let subst1 =
                                                 [FStar_Syntax_Syntax.DB
                                                    (Prims.int_zero, x1)]
                                                  in
                                               let phi1 =
                                                 FStar_Syntax_Subst.subst
                                                   subst1 phi
                                                  in
                                               let uu____12998 =
                                                 op FStar_Syntax_Util.t_true
                                                   phi1
                                                  in
                                               refine1 x1 uu____12998
                                           | (FStar_Pervasives_Native.Some
                                              (x,phi),FStar_Pervasives_Native.None
                                              ) ->
                                               let x1 =
                                                 FStar_Syntax_Syntax.freshen_bv
                                                   x
                                                  in
                                               let subst1 =
                                                 [FStar_Syntax_Syntax.DB
                                                    (Prims.int_zero, x1)]
                                                  in
                                               let phi1 =
                                                 FStar_Syntax_Subst.subst
                                                   subst1 phi
                                                  in
                                               let uu____13030 =
                                                 op FStar_Syntax_Util.t_true
                                                   phi1
                                                  in
                                               refine1 x1 uu____13030
                                           | uu____13033 -> t_base  in
                                         let uu____13050 =
                                           try_eq t1_base t2_base wl3  in
                                         (match uu____13050 with
                                          | FStar_Pervasives_Native.Some wl4
                                              ->
                                              let uu____13064 =
                                                combine_refinements t1_base
                                                  p1_opt p2_opt
                                                 in
                                              (uu____13064, [], wl4)
                                          | FStar_Pervasives_Native.None  ->
                                              let uu____13071 =
                                                base_and_refinement_maybe_delta
                                                  true env1 t12
                                                 in
                                              (match uu____13071 with
                                               | (t1_base1,p1_opt1) ->
                                                   let uu____13107 =
                                                     base_and_refinement_maybe_delta
                                                       true env1 t22
                                                      in
                                                   (match uu____13107 with
                                                    | (t2_base1,p2_opt1) ->
                                                        let uu____13143 =
                                                          eq_prob t1_base1
                                                            t2_base1 wl3
                                                           in
                                                        (match uu____13143
                                                         with
                                                         | (p,wl4) ->
                                                             let t =
                                                               combine_refinements
                                                                 t1_base1
                                                                 p1_opt1
                                                                 p2_opt1
                                                                in
                                                             (t, [p], wl4))))))
                                 in
                              let uu____13167 = combine t11 t21 wl2  in
                              (match uu____13167 with
                               | (t12,ps,wl3) ->
                                   ((let uu____13200 =
                                       FStar_All.pipe_left
                                         (FStar_TypeChecker_Env.debug env1)
                                         (FStar_Options.Other "Rel")
                                        in
                                     if uu____13200
                                     then
                                       let uu____13205 =
                                         FStar_Syntax_Print.term_to_string
                                           t12
                                          in
                                       FStar_Util.print1
                                         "pairwise fallback2 succeeded: %s"
                                         uu____13205
                                     else ());
                                    (t12, ps, wl3))))))
                in
             let rec aux uu____13247 ts1 =
               match uu____13247 with
               | (out,probs,wl2) ->
                   (match ts1 with
                    | [] -> (out, probs, wl2)
                    | t::ts2 ->
                        let uu____13310 = pairwise out t wl2  in
                        (match uu____13310 with
                         | (out1,probs',wl3) ->
                             aux
                               (out1, (FStar_List.append probs probs'), wl3)
                               ts2))
                in
             let uu____13346 =
               let uu____13357 = FStar_List.hd ts  in (uu____13357, [], wl1)
                in
             let uu____13366 = FStar_List.tl ts  in
             aux uu____13346 uu____13366  in
           let uu____13373 =
             if flip
             then
               ((tp.FStar_TypeChecker_Common.lhs),
                 (tp.FStar_TypeChecker_Common.rhs))
             else
               ((tp.FStar_TypeChecker_Common.rhs),
                 (tp.FStar_TypeChecker_Common.lhs))
              in
           match uu____13373 with
           | (this_flex,this_rigid) ->
               let uu____13399 =
                 let uu____13400 = FStar_Syntax_Subst.compress this_rigid  in
                 uu____13400.FStar_Syntax_Syntax.n  in
               (match uu____13399 with
                | FStar_Syntax_Syntax.Tm_arrow (_bs,comp) ->
                    let uu____13425 =
                      FStar_Syntax_Util.is_tot_or_gtot_comp comp  in
                    if uu____13425
                    then
                      let uu____13428 = destruct_flex_t this_flex wl  in
                      (match uu____13428 with
                       | (flex,wl1) ->
                           let uu____13435 = quasi_pattern env flex  in
                           (match uu____13435 with
                            | FStar_Pervasives_Native.None  ->
                                giveup_lit env
                                  "flex-arrow subtyping, not a quasi pattern"
                                  (FStar_TypeChecker_Common.TProb tp)
                            | FStar_Pervasives_Native.Some (flex_bs,flex_t)
                                ->
                                ((let uu____13454 =
                                    FStar_All.pipe_left
                                      (FStar_TypeChecker_Env.debug env)
                                      (FStar_Options.Other "Rel")
                                     in
                                  if uu____13454
                                  then
                                    let uu____13459 =
                                      FStar_Util.string_of_int
                                        tp.FStar_TypeChecker_Common.pid
                                       in
                                    FStar_Util.print1
                                      "Trying to solve by imitating arrow:%s\n"
                                      uu____13459
                                  else ());
                                 imitate_arrow
                                   (FStar_TypeChecker_Common.TProb tp) env
                                   wl1 flex flex_bs flex_t
                                   tp.FStar_TypeChecker_Common.relation
                                   this_rigid)))
                    else
                      (let uu____13466 =
                         attempt
                           [FStar_TypeChecker_Common.TProb
                              ((let uu___1939_13469 = tp  in
                                {
                                  FStar_TypeChecker_Common.pid =
                                    (uu___1939_13469.FStar_TypeChecker_Common.pid);
                                  FStar_TypeChecker_Common.lhs =
                                    (uu___1939_13469.FStar_TypeChecker_Common.lhs);
                                  FStar_TypeChecker_Common.relation =
                                    FStar_TypeChecker_Common.EQ;
                                  FStar_TypeChecker_Common.rhs =
                                    (uu___1939_13469.FStar_TypeChecker_Common.rhs);
                                  FStar_TypeChecker_Common.element =
                                    (uu___1939_13469.FStar_TypeChecker_Common.element);
                                  FStar_TypeChecker_Common.logical_guard =
                                    (uu___1939_13469.FStar_TypeChecker_Common.logical_guard);
                                  FStar_TypeChecker_Common.logical_guard_uvar
                                    =
                                    (uu___1939_13469.FStar_TypeChecker_Common.logical_guard_uvar);
                                  FStar_TypeChecker_Common.reason =
                                    (uu___1939_13469.FStar_TypeChecker_Common.reason);
                                  FStar_TypeChecker_Common.loc =
                                    (uu___1939_13469.FStar_TypeChecker_Common.loc);
                                  FStar_TypeChecker_Common.rank =
                                    (uu___1939_13469.FStar_TypeChecker_Common.rank)
                                }))] wl
                          in
                       solve env uu____13466)
                | uu____13470 ->
                    ((let uu____13472 =
                        FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                          (FStar_Options.Other "Rel")
                         in
                      if uu____13472
                      then
                        let uu____13477 =
                          FStar_Util.string_of_int
                            tp.FStar_TypeChecker_Common.pid
                           in
                        FStar_Util.print1
                          "Trying to solve by meeting refinements:%s\n"
                          uu____13477
                      else ());
                     (let uu____13482 =
                        FStar_Syntax_Util.head_and_args this_flex  in
                      match uu____13482 with
                      | (u,_args) ->
                          let uu____13525 =
                            let uu____13526 = FStar_Syntax_Subst.compress u
                               in
                            uu____13526.FStar_Syntax_Syntax.n  in
                          (match uu____13525 with
                           | FStar_Syntax_Syntax.Tm_uvar (ctx_uvar,_subst) ->
                               let equiv1 t =
                                 let uu____13554 =
                                   FStar_Syntax_Util.head_and_args t  in
                                 match uu____13554 with
                                 | (u',uu____13573) ->
                                     let uu____13598 =
                                       let uu____13599 = whnf env u'  in
                                       uu____13599.FStar_Syntax_Syntax.n  in
                                     (match uu____13598 with
                                      | FStar_Syntax_Syntax.Tm_uvar
                                          (ctx_uvar',_subst') ->
                                          FStar_Syntax_Unionfind.equiv
                                            ctx_uvar.FStar_Syntax_Syntax.ctx_uvar_head
                                            ctx_uvar'.FStar_Syntax_Syntax.ctx_uvar_head
                                      | uu____13621 -> false)
                                  in
                               let uu____13623 =
                                 FStar_All.pipe_right wl.attempting
                                   (FStar_List.partition
                                      (fun uu___26_13646  ->
                                         match uu___26_13646 with
                                         | FStar_TypeChecker_Common.TProb tp1
                                             ->
                                             let tp2 = maybe_invert tp1  in
                                             (match tp2.FStar_TypeChecker_Common.rank
                                              with
                                              | FStar_Pervasives_Native.Some
                                                  rank' when rank1 = rank' ->
                                                  if flip
                                                  then
                                                    equiv1
                                                      tp2.FStar_TypeChecker_Common.lhs
                                                  else
                                                    equiv1
                                                      tp2.FStar_TypeChecker_Common.rhs
                                              | uu____13660 -> false)
                                         | uu____13664 -> false))
                                  in
                               (match uu____13623 with
                                | (bounds_probs,rest) ->
                                    let bounds_typs =
                                      let uu____13679 = whnf env this_rigid
                                         in
                                      let uu____13680 =
                                        FStar_List.collect
                                          (fun uu___27_13686  ->
                                             match uu___27_13686 with
                                             | FStar_TypeChecker_Common.TProb
                                                 p ->
                                                 let uu____13692 =
                                                   if flip
                                                   then
                                                     whnf env
                                                       (maybe_invert p).FStar_TypeChecker_Common.rhs
                                                   else
                                                     whnf env
                                                       (maybe_invert p).FStar_TypeChecker_Common.lhs
                                                    in
                                                 [uu____13692]
                                             | uu____13696 -> [])
                                          bounds_probs
                                         in
                                      uu____13679 :: uu____13680  in
                                    let uu____13697 =
                                      meet_or_join
                                        (if flip
                                         then FStar_Syntax_Util.mk_conj_simp
                                         else FStar_Syntax_Util.mk_disj_simp)
                                        bounds_typs env wl
                                       in
                                    (match uu____13697 with
                                     | (bound,sub_probs,wl1) ->
                                         let uu____13730 =
                                           let flex_u =
                                             flex_uvar_head this_flex  in
                                           let bound1 =
                                             let uu____13745 =
                                               let uu____13746 =
                                                 FStar_Syntax_Subst.compress
                                                   bound
                                                  in
                                               uu____13746.FStar_Syntax_Syntax.n
                                                in
                                             match uu____13745 with
                                             | FStar_Syntax_Syntax.Tm_refine
                                                 (x,phi) when
                                                 (tp.FStar_TypeChecker_Common.relation
                                                    =
                                                    FStar_TypeChecker_Common.SUB)
                                                   &&
                                                   (let uu____13758 =
                                                      occurs flex_u
                                                        x.FStar_Syntax_Syntax.sort
                                                       in
                                                    FStar_Pervasives_Native.snd
                                                      uu____13758)
                                                 ->
                                                 x.FStar_Syntax_Syntax.sort
                                             | uu____13769 -> bound  in
                                           let uu____13770 =
                                             new_problem wl1 env bound1
                                               FStar_TypeChecker_Common.EQ
                                               this_flex
                                               FStar_Pervasives_Native.None
                                               tp.FStar_TypeChecker_Common.loc
                                               (if flip
                                                then "joining refinements"
                                                else "meeting refinements")
                                              in
                                           (bound1, uu____13770)  in
                                         (match uu____13730 with
                                          | (bound_typ,(eq_prob,wl')) ->
                                              (def_check_prob "meet_or_join2"
                                                 (FStar_TypeChecker_Common.TProb
                                                    eq_prob);
                                               (let uu____13805 =
                                                  FStar_All.pipe_left
                                                    (FStar_TypeChecker_Env.debug
                                                       env)
                                                    (FStar_Options.Other
                                                       "Rel")
                                                   in
                                                if uu____13805
                                                then
                                                  let wl'1 =
                                                    let uu___1999_13811 = wl1
                                                       in
                                                    {
                                                      attempting =
                                                        ((FStar_TypeChecker_Common.TProb
                                                            eq_prob) ::
                                                        sub_probs);
                                                      wl_deferred =
                                                        (uu___1999_13811.wl_deferred);
                                                      ctr =
                                                        (uu___1999_13811.ctr);
                                                      defer_ok =
                                                        (uu___1999_13811.defer_ok);
                                                      smt_ok =
                                                        (uu___1999_13811.smt_ok);
                                                      umax_heuristic_ok =
                                                        (uu___1999_13811.umax_heuristic_ok);
                                                      tcenv =
                                                        (uu___1999_13811.tcenv);
                                                      wl_implicits =
                                                        (uu___1999_13811.wl_implicits)
                                                    }  in
                                                  let uu____13812 =
                                                    wl_to_string wl'1  in
                                                  FStar_Util.print1
                                                    "After meet/join refinements: %s\n"
                                                    uu____13812
                                                else ());
                                               (let tx =
                                                  FStar_Syntax_Unionfind.new_transaction
                                                    ()
                                                   in
                                                let uu____13818 =
                                                  solve_t env eq_prob
                                                    (let uu___2004_13820 =
                                                       wl'  in
                                                     {
                                                       attempting = sub_probs;
                                                       wl_deferred =
                                                         (uu___2004_13820.wl_deferred);
                                                       ctr =
                                                         (uu___2004_13820.ctr);
                                                       defer_ok = false;
                                                       smt_ok =
                                                         (uu___2004_13820.smt_ok);
                                                       umax_heuristic_ok =
                                                         (uu___2004_13820.umax_heuristic_ok);
                                                       tcenv =
                                                         (uu___2004_13820.tcenv);
                                                       wl_implicits = []
                                                     })
                                                   in
                                                match uu____13818 with
                                                | Success (uu____13822,imps)
                                                    ->
                                                    let wl2 =
                                                      let uu___2010_13825 =
                                                        wl'  in
                                                      {
                                                        attempting = rest;
                                                        wl_deferred =
                                                          (uu___2010_13825.wl_deferred);
                                                        ctr =
                                                          (uu___2010_13825.ctr);
                                                        defer_ok =
                                                          (uu___2010_13825.defer_ok);
                                                        smt_ok =
                                                          (uu___2010_13825.smt_ok);
                                                        umax_heuristic_ok =
                                                          (uu___2010_13825.umax_heuristic_ok);
                                                        tcenv =
                                                          (uu___2010_13825.tcenv);
                                                        wl_implicits =
                                                          (uu___2010_13825.wl_implicits)
                                                      }  in
                                                    let wl3 =
                                                      let uu___2013_13827 =
                                                        wl2  in
                                                      {
                                                        attempting =
                                                          (uu___2013_13827.attempting);
                                                        wl_deferred =
                                                          (uu___2013_13827.wl_deferred);
                                                        ctr =
                                                          (uu___2013_13827.ctr);
                                                        defer_ok =
                                                          (uu___2013_13827.defer_ok);
                                                        smt_ok =
                                                          (uu___2013_13827.smt_ok);
                                                        umax_heuristic_ok =
                                                          (uu___2013_13827.umax_heuristic_ok);
                                                        tcenv =
                                                          (uu___2013_13827.tcenv);
                                                        wl_implicits =
                                                          (FStar_List.append
                                                             wl'.wl_implicits
                                                             imps)
                                                      }  in
                                                    let g =
                                                      FStar_List.fold_left
                                                        (fun g  ->
                                                           fun p  ->
                                                             FStar_Syntax_Util.mk_conj
                                                               g (p_guard p))
                                                        eq_prob.FStar_TypeChecker_Common.logical_guard
                                                        sub_probs
                                                       in
                                                    let wl4 =
                                                      solve_prob' false
                                                        (FStar_TypeChecker_Common.TProb
                                                           tp)
                                                        (FStar_Pervasives_Native.Some
                                                           g) [] wl3
                                                       in
                                                    let uu____13843 =
                                                      FStar_List.fold_left
                                                        (fun wl5  ->
                                                           fun p  ->
                                                             solve_prob' true
                                                               p
                                                               FStar_Pervasives_Native.None
                                                               [] wl5) wl4
                                                        bounds_probs
                                                       in
                                                    (FStar_Syntax_Unionfind.commit
                                                       tx;
                                                     solve env wl4)
                                                | Failed (p,msg) ->
                                                    ((let uu____13855 =
                                                        FStar_All.pipe_left
                                                          (FStar_TypeChecker_Env.debug
                                                             env)
                                                          (FStar_Options.Other
                                                             "Rel")
                                                         in
                                                      if uu____13855
                                                      then
                                                        let uu____13860 =
                                                          let uu____13862 =
                                                            FStar_List.map
                                                              (prob_to_string
                                                                 env)
                                                              ((FStar_TypeChecker_Common.TProb
                                                                  eq_prob) ::
                                                              sub_probs)
                                                             in
                                                          FStar_All.pipe_right
                                                            uu____13862
                                                            (FStar_String.concat
                                                               "\n")
                                                           in
                                                        FStar_Util.print1
                                                          "meet/join attempted and failed to solve problems:\n%s\n"
                                                          uu____13860
                                                      else ());
                                                     (let uu____13875 =
                                                        let uu____13890 =
                                                          base_and_refinement
                                                            env bound_typ
                                                           in
                                                        (rank1, uu____13890)
                                                         in
                                                      match uu____13875 with
                                                      | (FStar_TypeChecker_Common.Rigid_flex
                                                         ,(t_base,FStar_Pervasives_Native.Some
                                                           uu____13912))
                                                          ->
                                                          (FStar_Syntax_Unionfind.rollback
                                                             tx;
                                                           (let uu____13938 =
                                                              new_problem wl1
                                                                env t_base
                                                                FStar_TypeChecker_Common.EQ
                                                                this_flex
                                                                FStar_Pervasives_Native.None
                                                                tp.FStar_TypeChecker_Common.loc
                                                                "widened subtyping"
                                                               in
                                                            match uu____13938
                                                            with
                                                            | (eq_prob1,wl2)
                                                                ->
                                                                (def_check_prob
                                                                   "meet_or_join3"
                                                                   (FStar_TypeChecker_Common.TProb
                                                                    eq_prob1);
                                                                 (let wl3 =
                                                                    solve_prob'
                                                                    false
                                                                    (FStar_TypeChecker_Common.TProb
                                                                    tp)
                                                                    (FStar_Pervasives_Native.Some
                                                                    (p_guard
                                                                    (FStar_TypeChecker_Common.TProb
                                                                    eq_prob1)))
                                                                    [] wl2
                                                                     in
                                                                  let uu____13958
                                                                    =
                                                                    attempt
                                                                    [
                                                                    FStar_TypeChecker_Common.TProb
                                                                    eq_prob1]
                                                                    wl3  in
                                                                  solve env
                                                                    uu____13958))))
                                                      | (FStar_TypeChecker_Common.Flex_rigid
                                                         ,(t_base,FStar_Pervasives_Native.Some
                                                           (x,phi)))
                                                          ->
                                                          (FStar_Syntax_Unionfind.rollback
                                                             tx;
                                                           (let uu____13983 =
                                                              new_problem wl1
                                                                env t_base
                                                                FStar_TypeChecker_Common.EQ
                                                                this_flex
                                                                FStar_Pervasives_Native.None
                                                                tp.FStar_TypeChecker_Common.loc
                                                                "widened subtyping"
                                                               in
                                                            match uu____13983
                                                            with
                                                            | (eq_prob1,wl2)
                                                                ->
                                                                (def_check_prob
                                                                   "meet_or_join4"
                                                                   (FStar_TypeChecker_Common.TProb
                                                                    eq_prob1);
                                                                 (let phi1 =
                                                                    guard_on_element
                                                                    wl2 tp x
                                                                    phi  in
                                                                  let wl3 =
                                                                    let uu____14003
                                                                    =
                                                                    let uu____14008
                                                                    =
                                                                    FStar_Syntax_Util.mk_conj
                                                                    phi1
                                                                    (p_guard
                                                                    (FStar_TypeChecker_Common.TProb
                                                                    eq_prob1))
                                                                     in
                                                                    FStar_Pervasives_Native.Some
                                                                    uu____14008
                                                                     in
                                                                    solve_prob'
                                                                    false
                                                                    (FStar_TypeChecker_Common.TProb
                                                                    tp)
                                                                    uu____14003
                                                                    [] wl2
                                                                     in
                                                                  let uu____14014
                                                                    =
                                                                    attempt
                                                                    [
                                                                    FStar_TypeChecker_Common.TProb
                                                                    eq_prob1]
                                                                    wl3  in
                                                                  solve env
                                                                    uu____14014))))
                                                      | uu____14015 ->
                                                          let uu____14030 =
                                                            FStar_Thunk.map
                                                              (fun s  ->
                                                                 Prims.op_Hat
                                                                   "failed to solve the sub-problems: "
                                                                   s) msg
                                                             in
                                                          giveup env
                                                            uu____14030 p)))))))
                           | uu____14037 when flip ->
                               let uu____14038 =
                                 let uu____14040 =
                                   FStar_Util.string_of_int
                                     (rank_t_num rank1)
                                    in
                                 let uu____14042 =
                                   prob_to_string env
                                     (FStar_TypeChecker_Common.TProb tp)
                                    in
                                 FStar_Util.format2
                                   "Impossible: (rank=%s) Not a flex-rigid: %s"
                                   uu____14040 uu____14042
                                  in
                               failwith uu____14038
                           | uu____14045 ->
                               let uu____14046 =
                                 let uu____14048 =
                                   FStar_Util.string_of_int
                                     (rank_t_num rank1)
                                    in
                                 let uu____14050 =
                                   prob_to_string env
                                     (FStar_TypeChecker_Common.TProb tp)
                                    in
                                 FStar_Util.format2
                                   "Impossible: (rank=%s) Not a rigid-flex: %s"
                                   uu____14048 uu____14050
                                  in
                               failwith uu____14046)))))

and (imitate_arrow :
  FStar_TypeChecker_Common.prob ->
    FStar_TypeChecker_Env.env ->
      worklist ->
        flex_t ->
          FStar_Syntax_Syntax.binders ->
            FStar_Syntax_Syntax.term ->
              FStar_TypeChecker_Common.rel ->
                FStar_Syntax_Syntax.term -> solution)
  =
  fun orig  ->
    fun env  ->
      fun wl  ->
        fun lhs  ->
          fun bs_lhs  ->
            fun t_res_lhs  ->
              fun rel  ->
                fun arrow1  ->
                  let bs_lhs_args =
                    FStar_List.map
                      (fun uu____14086  ->
                         match uu____14086 with
                         | (x,i) ->
                             let uu____14105 =
                               FStar_Syntax_Syntax.bv_to_name x  in
                             (uu____14105, i)) bs_lhs
                     in
                  let uu____14108 = lhs  in
                  match uu____14108 with
                  | (uu____14109,u_lhs,uu____14111) ->
                      let imitate_comp bs bs_terms c wl1 =
                        let imitate_tot_or_gtot t uopt f wl2 =
                          let uu____14208 =
                            match uopt with
                            | FStar_Pervasives_Native.None  ->
                                FStar_Syntax_Util.type_u ()
                            | FStar_Pervasives_Native.Some univ ->
                                let uu____14218 =
                                  FStar_Syntax_Syntax.mk
                                    (FStar_Syntax_Syntax.Tm_type univ)
                                    FStar_Pervasives_Native.None
                                    t.FStar_Syntax_Syntax.pos
                                   in
                                (uu____14218, univ)
                             in
                          match uu____14208 with
                          | (k,univ) ->
                              let uu____14225 =
                                copy_uvar u_lhs (FStar_List.append bs_lhs bs)
                                  k wl2
                                 in
                              (match uu____14225 with
                               | (uu____14242,u,wl3) ->
                                   let uu____14245 =
                                     f u (FStar_Pervasives_Native.Some univ)
                                      in
                                   (uu____14245, wl3))
                           in
                        match c.FStar_Syntax_Syntax.n with
                        | FStar_Syntax_Syntax.Total (t,uopt) ->
                            imitate_tot_or_gtot t uopt
                              FStar_Syntax_Syntax.mk_Total' wl1
                        | FStar_Syntax_Syntax.GTotal (t,uopt) ->
                            imitate_tot_or_gtot t uopt
                              FStar_Syntax_Syntax.mk_GTotal' wl1
                        | FStar_Syntax_Syntax.Comp ct ->
                            let uu____14271 =
                              let uu____14284 =
                                let uu____14295 =
                                  FStar_Syntax_Syntax.as_arg
                                    ct.FStar_Syntax_Syntax.result_typ
                                   in
                                uu____14295 ::
                                  (ct.FStar_Syntax_Syntax.effect_args)
                                 in
                              FStar_List.fold_right
                                (fun uu____14346  ->
                                   fun uu____14347  ->
                                     match (uu____14346, uu____14347) with
                                     | ((a,i),(out_args,wl2)) ->
                                         let uu____14448 =
                                           let uu____14455 =
                                             let uu____14458 =
                                               FStar_Syntax_Util.type_u ()
                                                in
                                             FStar_All.pipe_left
                                               FStar_Pervasives_Native.fst
                                               uu____14458
                                              in
                                           copy_uvar u_lhs [] uu____14455 wl2
                                            in
                                         (match uu____14448 with
                                          | (uu____14487,t_a,wl3) ->
                                              let uu____14490 =
                                                copy_uvar u_lhs bs t_a wl3
                                                 in
                                              (match uu____14490 with
                                               | (uu____14509,a',wl4) ->
                                                   (((a', i) :: out_args),
                                                     wl4)))) uu____14284
                                ([], wl1)
                               in
                            (match uu____14271 with
                             | (out_args,wl2) ->
                                 let ct' =
                                   let uu___2124_14565 = ct  in
                                   let uu____14566 =
                                     let uu____14569 = FStar_List.hd out_args
                                        in
                                     FStar_Pervasives_Native.fst uu____14569
                                      in
                                   let uu____14584 = FStar_List.tl out_args
                                      in
                                   {
                                     FStar_Syntax_Syntax.comp_univs =
                                       (uu___2124_14565.FStar_Syntax_Syntax.comp_univs);
                                     FStar_Syntax_Syntax.effect_name =
                                       (uu___2124_14565.FStar_Syntax_Syntax.effect_name);
                                     FStar_Syntax_Syntax.result_typ =
                                       uu____14566;
                                     FStar_Syntax_Syntax.effect_args =
                                       uu____14584;
                                     FStar_Syntax_Syntax.flags =
                                       (uu___2124_14565.FStar_Syntax_Syntax.flags)
                                   }  in
                                 ((let uu___2127_14602 = c  in
                                   {
                                     FStar_Syntax_Syntax.n =
                                       (FStar_Syntax_Syntax.Comp ct');
                                     FStar_Syntax_Syntax.pos =
                                       (uu___2127_14602.FStar_Syntax_Syntax.pos);
                                     FStar_Syntax_Syntax.vars =
                                       (uu___2127_14602.FStar_Syntax_Syntax.vars)
                                   }), wl2))
                         in
                      let uu____14605 =
                        FStar_Syntax_Util.arrow_formals_comp arrow1  in
                      (match uu____14605 with
                       | (formals,c) ->
                           let rec aux bs bs_terms formals1 wl1 =
                             match formals1 with
                             | [] ->
                                 let uu____14643 =
                                   imitate_comp bs bs_terms c wl1  in
                                 (match uu____14643 with
                                  | (c',wl2) ->
                                      let lhs' =
                                        FStar_Syntax_Util.arrow bs c'  in
                                      let sol =
                                        let uu____14654 =
                                          let uu____14659 =
                                            FStar_Syntax_Util.abs bs_lhs lhs'
                                              (FStar_Pervasives_Native.Some
                                                 (FStar_Syntax_Util.residual_tot
                                                    t_res_lhs))
                                             in
                                          (u_lhs, uu____14659)  in
                                        TERM uu____14654  in
                                      let uu____14660 =
                                        mk_t_problem wl2 [] orig lhs' rel
                                          arrow1 FStar_Pervasives_Native.None
                                          "arrow imitation"
                                         in
                                      (match uu____14660 with
                                       | (sub_prob,wl3) ->
                                           let uu____14674 =
                                             let uu____14675 =
                                               solve_prob orig
                                                 FStar_Pervasives_Native.None
                                                 [sol] wl3
                                                in
                                             attempt [sub_prob] uu____14675
                                              in
                                           solve env uu____14674))
                             | (x,imp)::formals2 ->
                                 let uu____14697 =
                                   let uu____14704 =
                                     let uu____14707 =
                                       FStar_Syntax_Util.type_u ()  in
                                     FStar_All.pipe_right uu____14707
                                       FStar_Pervasives_Native.fst
                                      in
                                   copy_uvar u_lhs
                                     (FStar_List.append bs_lhs bs)
                                     uu____14704 wl1
                                    in
                                 (match uu____14697 with
                                  | (_ctx_u_x,u_x,wl2) ->
                                      let y =
                                        let uu____14728 =
                                          let uu____14731 =
                                            FStar_Syntax_Syntax.range_of_bv x
                                             in
                                          FStar_Pervasives_Native.Some
                                            uu____14731
                                           in
                                        FStar_Syntax_Syntax.new_bv
                                          uu____14728 u_x
                                         in
                                      let uu____14732 =
                                        let uu____14735 =
                                          let uu____14738 =
                                            let uu____14739 =
                                              FStar_Syntax_Syntax.bv_to_name
                                                y
                                               in
                                            (uu____14739, imp)  in
                                          [uu____14738]  in
                                        FStar_List.append bs_terms
                                          uu____14735
                                         in
                                      aux (FStar_List.append bs [(y, imp)])
                                        uu____14732 formals2 wl2)
                              in
                           let uu____14766 = occurs_check u_lhs arrow1  in
                           (match uu____14766 with
                            | (uu____14779,occurs_ok,msg) ->
                                if Prims.op_Negation occurs_ok
                                then
                                  let uu____14795 =
                                    FStar_Thunk.mk
                                      (fun uu____14799  ->
                                         let uu____14800 =
                                           FStar_Option.get msg  in
                                         Prims.op_Hat "occurs-check failed: "
                                           uu____14800)
                                     in
                                  giveup_or_defer env orig wl uu____14795
                                else aux [] [] formals wl))

and (solve_binders :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.binders ->
      FStar_Syntax_Syntax.binders ->
        FStar_TypeChecker_Common.prob ->
          worklist ->
            (worklist ->
               FStar_Syntax_Syntax.binders ->
                 FStar_TypeChecker_Env.env ->
                   FStar_Syntax_Syntax.subst_elt Prims.list ->
                     (FStar_TypeChecker_Common.prob * worklist))
              -> solution)
  =
  fun env  ->
    fun bs1  ->
      fun bs2  ->
        fun orig  ->
          fun wl  ->
            fun rhs  ->
              (let uu____14833 =
                 FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                   (FStar_Options.Other "Rel")
                  in
               if uu____14833
               then
                 let uu____14838 =
                   FStar_Syntax_Print.binders_to_string ", " bs1  in
                 let uu____14841 =
                   FStar_Syntax_Print.binders_to_string ", " bs2  in
                 FStar_Util.print3 "solve_binders\n\t%s\n%s\n\t%s\n"
                   uu____14838 (rel_to_string (p_rel orig)) uu____14841
               else ());
              (let rec aux wl1 scope env1 subst1 xs ys =
                 match (xs, ys) with
                 | ([],[]) ->
                     let uu____14972 = rhs wl1 scope env1 subst1  in
                     (match uu____14972 with
                      | (rhs_prob,wl2) ->
                          ((let uu____14995 =
                              FStar_All.pipe_left
                                (FStar_TypeChecker_Env.debug env1)
                                (FStar_Options.Other "Rel")
                               in
                            if uu____14995
                            then
                              let uu____15000 = prob_to_string env1 rhs_prob
                                 in
                              FStar_Util.print1 "rhs_prob = %s\n" uu____15000
                            else ());
                           (let formula = p_guard rhs_prob  in
                            (env1, (FStar_Util.Inl ([rhs_prob], formula)),
                              wl2))))
                 | ((hd1,imp)::xs1,(hd2,imp')::ys1) when
                     let uu____15078 = FStar_Syntax_Util.eq_aqual imp imp'
                        in
                     uu____15078 = FStar_Syntax_Util.Equal ->
                     let hd11 =
                       let uu___2197_15080 = hd1  in
                       let uu____15081 =
                         FStar_Syntax_Subst.subst subst1
                           hd1.FStar_Syntax_Syntax.sort
                          in
                       {
                         FStar_Syntax_Syntax.ppname =
                           (uu___2197_15080.FStar_Syntax_Syntax.ppname);
                         FStar_Syntax_Syntax.index =
                           (uu___2197_15080.FStar_Syntax_Syntax.index);
                         FStar_Syntax_Syntax.sort = uu____15081
                       }  in
                     let hd21 =
                       let uu___2200_15085 = hd2  in
                       let uu____15086 =
                         FStar_Syntax_Subst.subst subst1
                           hd2.FStar_Syntax_Syntax.sort
                          in
                       {
                         FStar_Syntax_Syntax.ppname =
                           (uu___2200_15085.FStar_Syntax_Syntax.ppname);
                         FStar_Syntax_Syntax.index =
                           (uu___2200_15085.FStar_Syntax_Syntax.index);
                         FStar_Syntax_Syntax.sort = uu____15086
                       }  in
                     let uu____15089 =
                       let uu____15094 =
                         FStar_All.pipe_left invert_rel (p_rel orig)  in
                       mk_t_problem wl1 scope orig
                         hd11.FStar_Syntax_Syntax.sort uu____15094
                         hd21.FStar_Syntax_Syntax.sort
                         FStar_Pervasives_Native.None "Formal parameter"
                        in
                     (match uu____15089 with
                      | (prob,wl2) ->
                          let hd12 = FStar_Syntax_Syntax.freshen_bv hd11  in
                          let subst2 =
                            let uu____15117 =
                              FStar_Syntax_Subst.shift_subst Prims.int_one
                                subst1
                               in
                            (FStar_Syntax_Syntax.DB (Prims.int_zero, hd12))
                              :: uu____15117
                             in
                          let env2 = FStar_TypeChecker_Env.push_bv env1 hd12
                             in
                          let uu____15124 =
                            aux wl2 (FStar_List.append scope [(hd12, imp)])
                              env2 subst2 xs1 ys1
                             in
                          (match uu____15124 with
                           | (env3,FStar_Util.Inl (sub_probs,phi),wl3) ->
                               let phi1 =
                                 let uu____15196 =
                                   FStar_TypeChecker_Env.close_forall env3
                                     [(hd12, imp)] phi
                                    in
                                 FStar_Syntax_Util.mk_conj (p_guard prob)
                                   uu____15196
                                  in
                               ((let uu____15214 =
                                   FStar_All.pipe_left
                                     (FStar_TypeChecker_Env.debug env3)
                                     (FStar_Options.Other "Rel")
                                    in
                                 if uu____15214
                                 then
                                   let uu____15219 =
                                     FStar_Syntax_Print.term_to_string phi1
                                      in
                                   let uu____15221 =
                                     FStar_Syntax_Print.bv_to_string hd12  in
                                   FStar_Util.print2
                                     "Formula is %s\n\thd1=%s\n" uu____15219
                                     uu____15221
                                 else ());
                                (env3,
                                  (FStar_Util.Inl ((prob :: sub_probs), phi1)),
                                  wl3))
                           | fail1 -> fail1))
                 | uu____15256 ->
                     (env1,
                       (FStar_Util.Inr "arity or argument-qualifier mismatch"),
                       wl1)
                  in
               let uu____15292 = aux wl [] env [] bs1 bs2  in
               match uu____15292 with
               | (env1,FStar_Util.Inr msg,wl1) -> giveup_lit env1 msg orig
               | (env1,FStar_Util.Inl (sub_probs,phi),wl1) ->
                   let wl2 =
                     solve_prob orig (FStar_Pervasives_Native.Some phi) []
                       wl1
                      in
                   let uu____15351 = attempt sub_probs wl2  in
                   solve env1 uu____15351)

and (try_solve_without_smt_or_else :
  FStar_TypeChecker_Env.env ->
    worklist ->
      (FStar_TypeChecker_Env.env -> worklist -> solution) ->
        (FStar_TypeChecker_Env.env ->
           worklist -> (FStar_TypeChecker_Common.prob * lstring) -> solution)
          -> solution)
  =
  fun env  ->
    fun wl  ->
      fun try_solve  ->
        fun else_solve  ->
          let wl' =
            let uu___2238_15371 = wl  in
            {
              attempting = [];
              wl_deferred = [];
              ctr = (uu___2238_15371.ctr);
              defer_ok = false;
              smt_ok = false;
              umax_heuristic_ok = false;
              tcenv = (uu___2238_15371.tcenv);
              wl_implicits = []
            }  in
          let tx = FStar_Syntax_Unionfind.new_transaction ()  in
          let uu____15383 = try_solve env wl'  in
          match uu____15383 with
          | Success (uu____15384,imps) ->
              (FStar_Syntax_Unionfind.commit tx;
               (let wl1 =
                  let uu___2247_15388 = wl  in
                  {
                    attempting = (uu___2247_15388.attempting);
                    wl_deferred = (uu___2247_15388.wl_deferred);
                    ctr = (uu___2247_15388.ctr);
                    defer_ok = (uu___2247_15388.defer_ok);
                    smt_ok = (uu___2247_15388.smt_ok);
                    umax_heuristic_ok = (uu___2247_15388.umax_heuristic_ok);
                    tcenv = (uu___2247_15388.tcenv);
                    wl_implicits = (FStar_List.append wl.wl_implicits imps)
                  }  in
                solve env wl1))
          | Failed (p,s) ->
              (FStar_Syntax_Unionfind.rollback tx; else_solve env wl (p, s))

and (solve_t : FStar_TypeChecker_Env.env -> tprob -> worklist -> solution) =
  fun env  ->
    fun problem  ->
      fun wl  ->
        def_check_prob "solve_t" (FStar_TypeChecker_Common.TProb problem);
        (let uu____15397 = compress_tprob wl.tcenv problem  in
         solve_t' env uu____15397 wl)

and (solve_t_flex_rigid_eq :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob ->
      worklist -> flex_t -> FStar_Syntax_Syntax.term -> solution)
  =
  fun env  ->
    fun orig  ->
      fun wl  ->
        fun lhs  ->
          fun rhs  ->
            let binders_as_bv_set bs =
              let uu____15411 = FStar_List.map FStar_Pervasives_Native.fst bs
                 in
              FStar_Util.as_set uu____15411 FStar_Syntax_Syntax.order_bv  in
            let mk_solution env1 lhs1 bs rhs1 =
              let uu____15445 = lhs1  in
              match uu____15445 with
              | (uu____15448,ctx_u,uu____15450) ->
                  let sol =
                    match bs with
                    | [] -> rhs1
                    | uu____15458 ->
                        let uu____15459 = sn_binders env1 bs  in
                        u_abs ctx_u.FStar_Syntax_Syntax.ctx_uvar_typ
                          uu____15459 rhs1
                     in
                  [TERM (ctx_u, sol)]
               in
            let try_quasi_pattern orig1 env1 wl1 lhs1 rhs1 =
              let uu____15508 = quasi_pattern env1 lhs1  in
              match uu____15508 with
              | FStar_Pervasives_Native.None  ->
                  ((FStar_Util.Inl "Not a quasi-pattern"), wl1)
              | FStar_Pervasives_Native.Some (bs,uu____15542) ->
                  let uu____15547 = lhs1  in
                  (match uu____15547 with
                   | (t_lhs,ctx_u,args) ->
                       let uu____15562 = occurs_check ctx_u rhs1  in
                       (match uu____15562 with
                        | (uvars1,occurs_ok,msg) ->
                            if Prims.op_Negation occurs_ok
                            then
                              let uu____15613 =
                                let uu____15621 =
                                  let uu____15623 = FStar_Option.get msg  in
                                  Prims.op_Hat
                                    "quasi-pattern, occurs-check failed: "
                                    uu____15623
                                   in
                                FStar_Util.Inl uu____15621  in
                              (uu____15613, wl1)
                            else
                              (let fvs_lhs =
                                 binders_as_bv_set
                                   (FStar_List.append
                                      ctx_u.FStar_Syntax_Syntax.ctx_uvar_binders
                                      bs)
                                  in
                               let fvs_rhs = FStar_Syntax_Free.names rhs1  in
                               let uu____15651 =
                                 let uu____15653 =
                                   FStar_Util.set_is_subset_of fvs_rhs
                                     fvs_lhs
                                    in
                                 Prims.op_Negation uu____15653  in
                               if uu____15651
                               then
                                 ((FStar_Util.Inl
                                     "quasi-pattern, free names on the RHS are not included in the LHS"),
                                   wl1)
                               else
                                 (let uu____15680 =
                                    let uu____15688 =
                                      mk_solution env1 lhs1 bs rhs1  in
                                    FStar_Util.Inr uu____15688  in
                                  let uu____15694 =
                                    restrict_all_uvars ctx_u uvars1 wl1  in
                                  (uu____15680, uu____15694)))))
               in
            let imitate_app orig1 env1 wl1 lhs1 bs_lhs t_res_lhs rhs1 =
              let uu____15738 = FStar_Syntax_Util.head_and_args rhs1  in
              match uu____15738 with
              | (rhs_hd,args) ->
                  let uu____15781 = FStar_Util.prefix args  in
                  (match uu____15781 with
                   | (args_rhs,last_arg_rhs) ->
                       let rhs' =
                         FStar_Syntax_Syntax.mk_Tm_app rhs_hd args_rhs
                           FStar_Pervasives_Native.None
                           rhs1.FStar_Syntax_Syntax.pos
                          in
                       let uu____15853 = lhs1  in
                       (match uu____15853 with
                        | (t_lhs,u_lhs,_lhs_args) ->
                            let uu____15857 =
                              let uu____15868 =
                                let uu____15875 =
                                  let uu____15878 =
                                    FStar_Syntax_Util.type_u ()  in
                                  FStar_All.pipe_left
                                    FStar_Pervasives_Native.fst uu____15878
                                   in
                                copy_uvar u_lhs [] uu____15875 wl1  in
                              match uu____15868 with
                              | (uu____15905,t_last_arg,wl2) ->
                                  let uu____15908 =
                                    let uu____15915 =
                                      let uu____15916 =
                                        let uu____15925 =
                                          FStar_Syntax_Syntax.null_binder
                                            t_last_arg
                                           in
                                        [uu____15925]  in
                                      FStar_List.append bs_lhs uu____15916
                                       in
                                    copy_uvar u_lhs uu____15915 t_res_lhs wl2
                                     in
                                  (match uu____15908 with
                                   | (uu____15960,lhs',wl3) ->
                                       let uu____15963 =
                                         copy_uvar u_lhs bs_lhs t_last_arg
                                           wl3
                                          in
                                       (match uu____15963 with
                                        | (uu____15980,lhs'_last_arg,wl4) ->
                                            (lhs', lhs'_last_arg, wl4)))
                               in
                            (match uu____15857 with
                             | (lhs',lhs'_last_arg,wl2) ->
                                 let sol =
                                   let uu____16001 =
                                     let uu____16002 =
                                       let uu____16007 =
                                         let uu____16008 =
                                           let uu____16011 =
                                             let uu____16016 =
                                               let uu____16017 =
                                                 FStar_Syntax_Syntax.as_arg
                                                   lhs'_last_arg
                                                  in
                                               [uu____16017]  in
                                             FStar_Syntax_Syntax.mk_Tm_app
                                               lhs' uu____16016
                                              in
                                           uu____16011
                                             FStar_Pervasives_Native.None
                                             t_lhs.FStar_Syntax_Syntax.pos
                                            in
                                         FStar_Syntax_Util.abs bs_lhs
                                           uu____16008
                                           (FStar_Pervasives_Native.Some
                                              (FStar_Syntax_Util.residual_tot
                                                 t_res_lhs))
                                          in
                                       (u_lhs, uu____16007)  in
                                     TERM uu____16002  in
                                   [uu____16001]  in
                                 let uu____16042 =
                                   let uu____16049 =
                                     mk_t_problem wl2 [] orig1 lhs'
                                       FStar_TypeChecker_Common.EQ rhs'
                                       FStar_Pervasives_Native.None
                                       "first-order lhs"
                                      in
                                   match uu____16049 with
                                   | (p1,wl3) ->
                                       let uu____16069 =
                                         mk_t_problem wl3 [] orig1
                                           lhs'_last_arg
                                           FStar_TypeChecker_Common.EQ
                                           (FStar_Pervasives_Native.fst
                                              last_arg_rhs)
                                           FStar_Pervasives_Native.None
                                           "first-order rhs"
                                          in
                                       (match uu____16069 with
                                        | (p2,wl4) -> ([p1; p2], wl4))
                                    in
                                 (match uu____16042 with
                                  | (sub_probs,wl3) ->
                                      let uu____16101 =
                                        let uu____16102 =
                                          solve_prob orig1
                                            FStar_Pervasives_Native.None sol
                                            wl3
                                           in
                                        attempt sub_probs uu____16102  in
                                      solve env1 uu____16101))))
               in
            let first_order orig1 env1 wl1 lhs1 rhs1 =
              let is_app rhs2 =
                let uu____16136 = FStar_Syntax_Util.head_and_args rhs2  in
                match uu____16136 with
                | (uu____16154,args) ->
                    (match args with | [] -> false | uu____16190 -> true)
                 in
              let is_arrow rhs2 =
                let uu____16209 =
                  let uu____16210 = FStar_Syntax_Subst.compress rhs2  in
                  uu____16210.FStar_Syntax_Syntax.n  in
                match uu____16209 with
                | FStar_Syntax_Syntax.Tm_arrow uu____16214 -> true
                | uu____16230 -> false  in
              let uu____16232 = quasi_pattern env1 lhs1  in
              match uu____16232 with
              | FStar_Pervasives_Native.None  ->
                  let msg =
                    FStar_Thunk.mk
                      (fun uu____16250  ->
                         let uu____16251 = prob_to_string env1 orig1  in
                         FStar_Util.format1
                           "first_order heuristic cannot solve %s; lhs not a quasi-pattern"
                           uu____16251)
                     in
                  giveup_or_defer env1 orig1 wl1 msg
              | FStar_Pervasives_Native.Some (bs_lhs,t_res_lhs) ->
                  let uu____16260 = is_app rhs1  in
                  if uu____16260
                  then imitate_app orig1 env1 wl1 lhs1 bs_lhs t_res_lhs rhs1
                  else
                    (let uu____16265 = is_arrow rhs1  in
                     if uu____16265
                     then
                       imitate_arrow orig1 env1 wl1 lhs1 bs_lhs t_res_lhs
                         FStar_TypeChecker_Common.EQ rhs1
                     else
                       (let msg =
                          FStar_Thunk.mk
                            (fun uu____16277  ->
                               let uu____16278 = prob_to_string env1 orig1
                                  in
                               FStar_Util.format1
                                 "first_order heuristic cannot solve %s; rhs not an app or arrow"
                                 uu____16278)
                           in
                        giveup_or_defer env1 orig1 wl1 msg))
               in
            match p_rel orig with
            | FStar_TypeChecker_Common.SUB  ->
                if wl.defer_ok
                then
                  let uu____16282 = FStar_Thunk.mkv "flex-rigid subtyping"
                     in
                  giveup_or_defer env orig wl uu____16282
                else solve_t_flex_rigid_eq env (make_prob_eq orig) wl lhs rhs
            | FStar_TypeChecker_Common.SUBINV  ->
                if wl.defer_ok
                then
                  let uu____16288 = FStar_Thunk.mkv "flex-rigid subtyping"
                     in
                  giveup_or_defer env orig wl uu____16288
                else solve_t_flex_rigid_eq env (make_prob_eq orig) wl lhs rhs
            | FStar_TypeChecker_Common.EQ  ->
                let uu____16293 = lhs  in
                (match uu____16293 with
                 | (_t1,ctx_uv,args_lhs) ->
                     let uu____16297 =
                       pat_vars env
                         ctx_uv.FStar_Syntax_Syntax.ctx_uvar_binders args_lhs
                        in
                     (match uu____16297 with
                      | FStar_Pervasives_Native.Some lhs_binders ->
                          let rhs1 = sn env rhs  in
                          let names_to_string1 fvs =
                            let uu____16315 =
                              let uu____16319 = FStar_Util.set_elements fvs
                                 in
                              FStar_List.map FStar_Syntax_Print.bv_to_string
                                uu____16319
                               in
                            FStar_All.pipe_right uu____16315
                              (FStar_String.concat ", ")
                             in
                          let fvs1 =
                            binders_as_bv_set
                              (FStar_List.append
                                 ctx_uv.FStar_Syntax_Syntax.ctx_uvar_binders
                                 lhs_binders)
                             in
                          let fvs2 = FStar_Syntax_Free.names rhs1  in
                          let uu____16340 = occurs_check ctx_uv rhs1  in
                          (match uu____16340 with
                           | (uvars1,occurs_ok,msg) ->
                               if Prims.op_Negation occurs_ok
                               then
                                 let uu____16369 =
                                   let uu____16370 =
                                     let uu____16372 = FStar_Option.get msg
                                        in
                                     Prims.op_Hat "occurs-check failed: "
                                       uu____16372
                                      in
                                   FStar_All.pipe_left FStar_Thunk.mkv
                                     uu____16370
                                    in
                                 giveup_or_defer env orig wl uu____16369
                               else
                                 (let uu____16380 =
                                    FStar_Util.set_is_subset_of fvs2 fvs1  in
                                  if uu____16380
                                  then
                                    let sol =
                                      mk_solution env lhs lhs_binders rhs1
                                       in
                                    let wl1 =
                                      restrict_all_uvars ctx_uv uvars1 wl  in
                                    let uu____16387 =
                                      solve_prob orig
                                        FStar_Pervasives_Native.None sol wl1
                                       in
                                    solve env uu____16387
                                  else
                                    if wl.defer_ok
                                    then
                                      (let msg1 =
                                         FStar_Thunk.mk
                                           (fun uu____16400  ->
                                              let uu____16401 =
                                                names_to_string1 fvs2  in
                                              let uu____16403 =
                                                names_to_string1 fvs1  in
                                              let uu____16405 =
                                                FStar_Syntax_Print.binders_to_string
                                                  ", "
                                                  (FStar_List.append
                                                     ctx_uv.FStar_Syntax_Syntax.ctx_uvar_binders
                                                     lhs_binders)
                                                 in
                                              FStar_Util.format3
                                                "free names in the RHS {%s} are out of scope for the LHS: {%s}, {%s}"
                                                uu____16401 uu____16403
                                                uu____16405)
                                          in
                                       giveup_or_defer env orig wl msg1)
                                    else first_order orig env wl lhs rhs1))
                      | uu____16417 ->
                          if wl.defer_ok
                          then
                            let uu____16421 = FStar_Thunk.mkv "Not a pattern"
                               in
                            giveup_or_defer env orig wl uu____16421
                          else
                            (let uu____16426 =
                               try_quasi_pattern orig env wl lhs rhs  in
                             match uu____16426 with
                             | (FStar_Util.Inr sol,wl1) ->
                                 let uu____16452 =
                                   solve_prob orig
                                     FStar_Pervasives_Native.None sol wl1
                                    in
                                 solve env uu____16452
                             | (FStar_Util.Inl msg,uu____16454) ->
                                 first_order orig env wl lhs rhs)))

and (solve_t_flex_flex :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob -> worklist -> flex_t -> flex_t -> solution)
  =
  fun env  ->
    fun orig  ->
      fun wl  ->
        fun lhs  ->
          fun rhs  ->
            match p_rel orig with
            | FStar_TypeChecker_Common.SUB  ->
                if wl.defer_ok
                then
                  let uu____16472 = FStar_Thunk.mkv "flex-flex subtyping"  in
                  giveup_or_defer env orig wl uu____16472
                else solve_t_flex_flex env (make_prob_eq orig) wl lhs rhs
            | FStar_TypeChecker_Common.SUBINV  ->
                if wl.defer_ok
                then
                  let uu____16478 = FStar_Thunk.mkv "flex-flex subtyping"  in
                  giveup_or_defer env orig wl uu____16478
                else solve_t_flex_flex env (make_prob_eq orig) wl lhs rhs
            | FStar_TypeChecker_Common.EQ  ->
                if
                  wl.defer_ok &&
                    ((Prims.op_Negation (is_flex_pat lhs)) ||
                       (Prims.op_Negation (is_flex_pat rhs)))
                then
                  let uu____16500 = FStar_Thunk.mkv "flex-flex non-pattern"
                     in
                  giveup_or_defer env orig wl uu____16500
                else
                  (let uu____16505 =
                     let uu____16522 = quasi_pattern env lhs  in
                     let uu____16529 = quasi_pattern env rhs  in
                     (uu____16522, uu____16529)  in
                   match uu____16505 with
                   | (FStar_Pervasives_Native.Some
                      (binders_lhs,t_res_lhs),FStar_Pervasives_Native.Some
                      (binders_rhs,t_res_rhs)) ->
                       let uu____16572 = lhs  in
                       (match uu____16572 with
                        | ({ FStar_Syntax_Syntax.n = uu____16573;
                             FStar_Syntax_Syntax.pos = range;
                             FStar_Syntax_Syntax.vars = uu____16575;_},u_lhs,uu____16577)
                            ->
                            let uu____16580 = rhs  in
                            (match uu____16580 with
                             | (uu____16581,u_rhs,uu____16583) ->
                                 let uu____16584 =
                                   (FStar_Syntax_Unionfind.equiv
                                      u_lhs.FStar_Syntax_Syntax.ctx_uvar_head
                                      u_rhs.FStar_Syntax_Syntax.ctx_uvar_head)
                                     && (binders_eq binders_lhs binders_rhs)
                                    in
                                 if uu____16584
                                 then
                                   let uu____16591 =
                                     solve_prob orig
                                       FStar_Pervasives_Native.None [] wl
                                      in
                                   solve env uu____16591
                                 else
                                   (let uu____16594 =
                                      maximal_prefix
                                        u_lhs.FStar_Syntax_Syntax.ctx_uvar_binders
                                        u_rhs.FStar_Syntax_Syntax.ctx_uvar_binders
                                       in
                                    match uu____16594 with
                                    | (ctx_w,(ctx_l,ctx_r)) ->
                                        let gamma_w =
                                          gamma_until
                                            u_lhs.FStar_Syntax_Syntax.ctx_uvar_gamma
                                            ctx_w
                                           in
                                        let zs =
                                          intersect_binders gamma_w
                                            (FStar_List.append ctx_l
                                               binders_lhs)
                                            (FStar_List.append ctx_r
                                               binders_rhs)
                                           in
                                        let uu____16626 =
                                          let uu____16633 =
                                            let uu____16636 =
                                              FStar_Syntax_Syntax.mk_Total
                                                t_res_lhs
                                               in
                                            FStar_Syntax_Util.arrow zs
                                              uu____16636
                                             in
                                          new_uvar
                                            (Prims.op_Hat "flex-flex quasi:"
                                               (Prims.op_Hat "\tlhs="
                                                  (Prims.op_Hat
                                                     u_lhs.FStar_Syntax_Syntax.ctx_uvar_reason
                                                     (Prims.op_Hat "\trhs="
                                                        u_rhs.FStar_Syntax_Syntax.ctx_uvar_reason))))
                                            wl range gamma_w ctx_w
                                            uu____16633
                                            FStar_Syntax_Syntax.Strict
                                            FStar_Pervasives_Native.None
                                           in
                                        (match uu____16626 with
                                         | (uu____16648,w,wl1) ->
                                             let w_app =
                                               let uu____16654 =
                                                 let uu____16659 =
                                                   FStar_List.map
                                                     (fun uu____16670  ->
                                                        match uu____16670
                                                        with
                                                        | (z,uu____16678) ->
                                                            let uu____16683 =
                                                              FStar_Syntax_Syntax.bv_to_name
                                                                z
                                                               in
                                                            FStar_Syntax_Syntax.as_arg
                                                              uu____16683) zs
                                                    in
                                                 FStar_Syntax_Syntax.mk_Tm_app
                                                   w uu____16659
                                                  in
                                               uu____16654
                                                 FStar_Pervasives_Native.None
                                                 w.FStar_Syntax_Syntax.pos
                                                in
                                             ((let uu____16685 =
                                                 FStar_All.pipe_left
                                                   (FStar_TypeChecker_Env.debug
                                                      env)
                                                   (FStar_Options.Other "Rel")
                                                  in
                                               if uu____16685
                                               then
                                                 let uu____16690 =
                                                   let uu____16694 =
                                                     flex_t_to_string lhs  in
                                                   let uu____16696 =
                                                     let uu____16700 =
                                                       flex_t_to_string rhs
                                                        in
                                                     let uu____16702 =
                                                       let uu____16706 =
                                                         term_to_string w  in
                                                       let uu____16708 =
                                                         let uu____16712 =
                                                           FStar_Syntax_Print.binders_to_string
                                                             ", "
                                                             (FStar_List.append
                                                                ctx_l
                                                                binders_lhs)
                                                            in
                                                         let uu____16721 =
                                                           let uu____16725 =
                                                             FStar_Syntax_Print.binders_to_string
                                                               ", "
                                                               (FStar_List.append
                                                                  ctx_r
                                                                  binders_rhs)
                                                              in
                                                           let uu____16734 =
                                                             let uu____16738
                                                               =
                                                               FStar_Syntax_Print.binders_to_string
                                                                 ", " zs
                                                                in
                                                             [uu____16738]
                                                              in
                                                           uu____16725 ::
                                                             uu____16734
                                                            in
                                                         uu____16712 ::
                                                           uu____16721
                                                          in
                                                       uu____16706 ::
                                                         uu____16708
                                                        in
                                                     uu____16700 ::
                                                       uu____16702
                                                      in
                                                   uu____16694 :: uu____16696
                                                    in
                                                 FStar_Util.print
                                                   "flex-flex quasi:\n\tlhs=%s\n\trhs=%s\n\tsol=%s\n\tctx_l@binders_lhs=%s\n\tctx_r@binders_rhs=%s\n\tzs=%s\n"
                                                   uu____16690
                                               else ());
                                              (let sol =
                                                 let s1 =
                                                   let uu____16755 =
                                                     let uu____16760 =
                                                       FStar_Syntax_Util.abs
                                                         binders_lhs w_app
                                                         (FStar_Pervasives_Native.Some
                                                            (FStar_Syntax_Util.residual_tot
                                                               t_res_lhs))
                                                        in
                                                     (u_lhs, uu____16760)  in
                                                   TERM uu____16755  in
                                                 let uu____16761 =
                                                   FStar_Syntax_Unionfind.equiv
                                                     u_lhs.FStar_Syntax_Syntax.ctx_uvar_head
                                                     u_rhs.FStar_Syntax_Syntax.ctx_uvar_head
                                                    in
                                                 if uu____16761
                                                 then [s1]
                                                 else
                                                   (let s2 =
                                                      let uu____16769 =
                                                        let uu____16774 =
                                                          FStar_Syntax_Util.abs
                                                            binders_rhs w_app
                                                            (FStar_Pervasives_Native.Some
                                                               (FStar_Syntax_Util.residual_tot
                                                                  t_res_lhs))
                                                           in
                                                        (u_rhs, uu____16774)
                                                         in
                                                      TERM uu____16769  in
                                                    [s1; s2])
                                                  in
                                               let uu____16775 =
                                                 solve_prob orig
                                                   FStar_Pervasives_Native.None
                                                   sol wl1
                                                  in
                                               solve env uu____16775))))))
                   | uu____16776 ->
                       let uu____16793 =
                         FStar_Thunk.mkv "flex-flex: non-patterns"  in
                       giveup_or_defer env orig wl uu____16793)

and (solve_t' : FStar_TypeChecker_Env.env -> tprob -> worklist -> solution) =
  fun env  ->
    fun problem  ->
      fun wl  ->
        def_check_prob "solve_t'.1" (FStar_TypeChecker_Common.TProb problem);
        (let giveup_or_defer1 orig msg = giveup_or_defer env orig wl msg  in
         let rigid_heads_match env1 need_unif torig wl1 t1 t2 =
           let orig = FStar_TypeChecker_Common.TProb torig  in
           (let uu____16847 =
              FStar_All.pipe_left (FStar_TypeChecker_Env.debug env1)
                (FStar_Options.Other "Rel")
               in
            if uu____16847
            then
              let uu____16852 = FStar_Syntax_Print.term_to_string t1  in
              let uu____16854 = FStar_Syntax_Print.tag_of_term t1  in
              let uu____16856 = FStar_Syntax_Print.term_to_string t2  in
              let uu____16858 = FStar_Syntax_Print.tag_of_term t2  in
              FStar_Util.print5 "Heads %s: %s (%s) and %s (%s)\n"
                (if need_unif then "need unification" else "match")
                uu____16852 uu____16854 uu____16856 uu____16858
            else ());
           (let uu____16869 = FStar_Syntax_Util.head_and_args t1  in
            match uu____16869 with
            | (head1,args1) ->
                let uu____16912 = FStar_Syntax_Util.head_and_args t2  in
                (match uu____16912 with
                 | (head2,args2) ->
                     let solve_head_then wl2 k =
                       if need_unif
                       then k true wl2
                       else
                         (let uu____16982 =
                            solve_maybe_uinsts env1 orig head1 head2 wl2  in
                          match uu____16982 with
                          | USolved wl3 -> k true wl3
                          | UFailed msg -> giveup env1 msg orig
                          | UDeferred wl3 ->
                              let uu____16987 =
                                defer_lit "universe constraints" orig wl3  in
                              k false uu____16987)
                        in
                     let nargs = FStar_List.length args1  in
                     if nargs <> (FStar_List.length args2)
                     then
                       let uu____17008 =
                         FStar_Thunk.mk
                           (fun uu____17015  ->
                              let uu____17016 =
                                FStar_Syntax_Print.term_to_string head1  in
                              let uu____17018 = args_to_string args1  in
                              let uu____17022 =
                                FStar_Syntax_Print.term_to_string head2  in
                              let uu____17024 = args_to_string args2  in
                              FStar_Util.format4
                                "unequal number of arguments: %s[%s] and %s[%s]"
                                uu____17016 uu____17018 uu____17022
                                uu____17024)
                          in
                       giveup env1 uu____17008 orig
                     else
                       (let uu____17031 =
                          (nargs = Prims.int_zero) ||
                            (let uu____17036 =
                               FStar_Syntax_Util.eq_args args1 args2  in
                             uu____17036 = FStar_Syntax_Util.Equal)
                           in
                        if uu____17031
                        then
                          (if need_unif
                           then
                             solve_t env1
                               (let uu___2503_17040 = problem  in
                                {
                                  FStar_TypeChecker_Common.pid =
                                    (uu___2503_17040.FStar_TypeChecker_Common.pid);
                                  FStar_TypeChecker_Common.lhs = head1;
                                  FStar_TypeChecker_Common.relation =
                                    (uu___2503_17040.FStar_TypeChecker_Common.relation);
                                  FStar_TypeChecker_Common.rhs = head2;
                                  FStar_TypeChecker_Common.element =
                                    (uu___2503_17040.FStar_TypeChecker_Common.element);
                                  FStar_TypeChecker_Common.logical_guard =
                                    (uu___2503_17040.FStar_TypeChecker_Common.logical_guard);
                                  FStar_TypeChecker_Common.logical_guard_uvar
                                    =
                                    (uu___2503_17040.FStar_TypeChecker_Common.logical_guard_uvar);
                                  FStar_TypeChecker_Common.reason =
                                    (uu___2503_17040.FStar_TypeChecker_Common.reason);
                                  FStar_TypeChecker_Common.loc =
                                    (uu___2503_17040.FStar_TypeChecker_Common.loc);
                                  FStar_TypeChecker_Common.rank =
                                    (uu___2503_17040.FStar_TypeChecker_Common.rank)
                                }) wl1
                           else
                             solve_head_then wl1
                               (fun ok  ->
                                  fun wl2  ->
                                    if ok
                                    then
                                      let uu____17050 =
                                        solve_prob orig
                                          FStar_Pervasives_Native.None [] wl2
                                         in
                                      solve env1 uu____17050
                                    else solve env1 wl2))
                        else
                          (let uu____17055 = base_and_refinement env1 t1  in
                           match uu____17055 with
                           | (base1,refinement1) ->
                               let uu____17080 = base_and_refinement env1 t2
                                  in
                               (match uu____17080 with
                                | (base2,refinement2) ->
                                    (match (refinement1, refinement2) with
                                     | (FStar_Pervasives_Native.None
                                        ,FStar_Pervasives_Native.None ) ->
                                         let mk_sub_probs wl2 =
                                           let argp =
                                             if need_unif
                                             then
                                               FStar_List.zip
                                                 ((head1,
                                                    FStar_Pervasives_Native.None)
                                                 :: args1)
                                                 ((head2,
                                                    FStar_Pervasives_Native.None)
                                                 :: args2)
                                             else FStar_List.zip args1 args2
                                              in
                                           let uu____17245 =
                                             FStar_List.fold_right
                                               (fun uu____17285  ->
                                                  fun uu____17286  ->
                                                    match (uu____17285,
                                                            uu____17286)
                                                    with
                                                    | (((a1,uu____17338),
                                                        (a2,uu____17340)),
                                                       (probs,wl3)) ->
                                                        let uu____17389 =
                                                          mk_problem wl3 []
                                                            orig a1
                                                            FStar_TypeChecker_Common.EQ
                                                            a2
                                                            FStar_Pervasives_Native.None
                                                            "index"
                                                           in
                                                        (match uu____17389
                                                         with
                                                         | (prob',wl4) ->
                                                             (((FStar_TypeChecker_Common.TProb
                                                                  prob') ::
                                                               probs), wl4)))
                                               argp ([], wl2)
                                              in
                                           match uu____17245 with
                                           | (subprobs,wl3) ->
                                               ((let uu____17432 =
                                                   FStar_All.pipe_left
                                                     (FStar_TypeChecker_Env.debug
                                                        env1)
                                                     (FStar_Options.Other
                                                        "Rel")
                                                    in
                                                 if uu____17432
                                                 then
                                                   let uu____17437 =
                                                     FStar_Syntax_Print.list_to_string
                                                       (prob_to_string env1)
                                                       subprobs
                                                      in
                                                   FStar_Util.print1
                                                     "Adding subproblems for arguments: %s"
                                                     uu____17437
                                                 else ());
                                                (let uu____17443 =
                                                   FStar_Options.defensive ()
                                                    in
                                                 if uu____17443
                                                 then
                                                   FStar_List.iter
                                                     (def_check_prob
                                                        "solve_t' subprobs")
                                                     subprobs
                                                 else ());
                                                (subprobs, wl3))
                                            in
                                         let solve_sub_probs env2 wl2 =
                                           solve_head_then wl2
                                             (fun ok  ->
                                                fun wl3  ->
                                                  if Prims.op_Negation ok
                                                  then solve env2 wl3
                                                  else
                                                    (let uu____17470 =
                                                       mk_sub_probs wl3  in
                                                     match uu____17470 with
                                                     | (subprobs,wl4) ->
                                                         let formula =
                                                           let uu____17486 =
                                                             FStar_List.map
                                                               (fun p  ->
                                                                  p_guard p)
                                                               subprobs
                                                              in
                                                           FStar_Syntax_Util.mk_conj_l
                                                             uu____17486
                                                            in
                                                         let wl5 =
                                                           solve_prob orig
                                                             (FStar_Pervasives_Native.Some
                                                                formula) []
                                                             wl4
                                                            in
                                                         let uu____17494 =
                                                           attempt subprobs
                                                             wl5
                                                            in
                                                         solve env2
                                                           uu____17494))
                                            in
                                         let solve_sub_probs_no_smt env2 wl2
                                           =
                                           solve_head_then wl2
                                             (fun ok  ->
                                                fun wl3  ->
                                                  let uu____17519 =
                                                    mk_sub_probs wl3  in
                                                  match uu____17519 with
                                                  | (subprobs,wl4) ->
                                                      let formula =
                                                        let uu____17535 =
                                                          FStar_List.map
                                                            (fun p  ->
                                                               p_guard p)
                                                            subprobs
                                                           in
                                                        FStar_Syntax_Util.mk_conj_l
                                                          uu____17535
                                                         in
                                                      let wl5 =
                                                        solve_prob orig
                                                          (FStar_Pervasives_Native.Some
                                                             formula) [] wl4
                                                         in
                                                      let uu____17543 =
                                                        attempt subprobs wl5
                                                         in
                                                      solve env2 uu____17543)
                                            in
                                         let unfold_and_retry d env2 wl2
                                           uu____17571 =
                                           match uu____17571 with
                                           | (prob,reason) ->
                                               ((let uu____17588 =
                                                   FStar_All.pipe_left
                                                     (FStar_TypeChecker_Env.debug
                                                        env2)
                                                     (FStar_Options.Other
                                                        "Rel")
                                                    in
                                                 if uu____17588
                                                 then
                                                   let uu____17593 =
                                                     prob_to_string env2 orig
                                                      in
                                                   let uu____17595 =
                                                     prob_to_string env2 prob
                                                      in
                                                   let uu____17597 =
                                                     FStar_Thunk.force reason
                                                      in
                                                   FStar_Util.print3
                                                     "Failed to solve %s because sub-problem %s is not solvable without SMT because %s"
                                                     uu____17593 uu____17595
                                                     uu____17597
                                                 else ());
                                                (let uu____17603 =
                                                   let uu____17612 =
                                                     FStar_TypeChecker_Normalize.unfold_head_once
                                                       env2 t1
                                                      in
                                                   let uu____17615 =
                                                     FStar_TypeChecker_Normalize.unfold_head_once
                                                       env2 t2
                                                      in
                                                   (uu____17612, uu____17615)
                                                    in
                                                 match uu____17603 with
                                                 | (FStar_Pervasives_Native.Some
                                                    t1',FStar_Pervasives_Native.Some
                                                    t2') ->
                                                     let uu____17628 =
                                                       FStar_Syntax_Util.head_and_args
                                                         t1'
                                                        in
                                                     (match uu____17628 with
                                                      | (head1',uu____17646)
                                                          ->
                                                          let uu____17671 =
                                                            FStar_Syntax_Util.head_and_args
                                                              t2'
                                                             in
                                                          (match uu____17671
                                                           with
                                                           | (head2',uu____17689)
                                                               ->
                                                               let uu____17714
                                                                 =
                                                                 let uu____17719
                                                                   =
                                                                   FStar_Syntax_Util.eq_tm
                                                                    head1'
                                                                    head1
                                                                    in
                                                                 let uu____17720
                                                                   =
                                                                   FStar_Syntax_Util.eq_tm
                                                                    head2'
                                                                    head2
                                                                    in
                                                                 (uu____17719,
                                                                   uu____17720)
                                                                  in
                                                               (match uu____17714
                                                                with
                                                                | (FStar_Syntax_Util.Equal
                                                                   ,FStar_Syntax_Util.Equal
                                                                   ) ->
                                                                    (
                                                                    (
                                                                    let uu____17722
                                                                    =
                                                                    FStar_All.pipe_left
                                                                    (FStar_TypeChecker_Env.debug
                                                                    env2)
                                                                    (FStar_Options.Other
                                                                    "Rel")
                                                                     in
                                                                    if
                                                                    uu____17722
                                                                    then
                                                                    let uu____17727
                                                                    =
                                                                    FStar_Syntax_Print.term_to_string
                                                                    t1  in
                                                                    let uu____17729
                                                                    =
                                                                    FStar_Syntax_Print.term_to_string
                                                                    t1'  in
                                                                    let uu____17731
                                                                    =
                                                                    FStar_Syntax_Print.term_to_string
                                                                    t2  in
                                                                    let uu____17733
                                                                    =
                                                                    FStar_Syntax_Print.term_to_string
                                                                    t2'  in
                                                                    FStar_Util.print4
                                                                    "Unfolding didn't make progress ... got %s ~> %s;\nand %s ~> %s\n"
                                                                    uu____17727
                                                                    uu____17729
                                                                    uu____17731
                                                                    uu____17733
                                                                    else ());
                                                                    solve_sub_probs
                                                                    env2 wl2)
                                                                | uu____17738
                                                                    ->
                                                                    let torig'
                                                                    =
                                                                    let uu___2591_17746
                                                                    = torig
                                                                     in
                                                                    {
                                                                    FStar_TypeChecker_Common.pid
                                                                    =
                                                                    (uu___2591_17746.FStar_TypeChecker_Common.pid);
                                                                    FStar_TypeChecker_Common.lhs
                                                                    = t1';
                                                                    FStar_TypeChecker_Common.relation
                                                                    =
                                                                    (uu___2591_17746.FStar_TypeChecker_Common.relation);
                                                                    FStar_TypeChecker_Common.rhs
                                                                    = t2';
                                                                    FStar_TypeChecker_Common.element
                                                                    =
                                                                    (uu___2591_17746.FStar_TypeChecker_Common.element);
                                                                    FStar_TypeChecker_Common.logical_guard
                                                                    =
                                                                    (uu___2591_17746.FStar_TypeChecker_Common.logical_guard);
                                                                    FStar_TypeChecker_Common.logical_guard_uvar
                                                                    =
                                                                    (uu___2591_17746.FStar_TypeChecker_Common.logical_guard_uvar);
                                                                    FStar_TypeChecker_Common.reason
                                                                    =
                                                                    (uu___2591_17746.FStar_TypeChecker_Common.reason);
                                                                    FStar_TypeChecker_Common.loc
                                                                    =
                                                                    (uu___2591_17746.FStar_TypeChecker_Common.loc);
                                                                    FStar_TypeChecker_Common.rank
                                                                    =
                                                                    (uu___2591_17746.FStar_TypeChecker_Common.rank)
                                                                    }  in
                                                                    ((
                                                                    let uu____17748
                                                                    =
                                                                    FStar_All.pipe_left
                                                                    (FStar_TypeChecker_Env.debug
                                                                    env2)
                                                                    (FStar_Options.Other
                                                                    "Rel")
                                                                     in
                                                                    if
                                                                    uu____17748
                                                                    then
                                                                    let uu____17753
                                                                    =
                                                                    prob_to_string
                                                                    env2
                                                                    (FStar_TypeChecker_Common.TProb
                                                                    torig')
                                                                     in
                                                                    FStar_Util.print1
                                                                    "Unfolded and now trying %s\n"
                                                                    uu____17753
                                                                    else ());
                                                                    solve_t
                                                                    env2
                                                                    torig'
                                                                    wl2))))
                                                 | uu____17758 ->
                                                     solve_sub_probs env2 wl2))
                                            in
                                         let d =
                                           let uu____17770 =
                                             delta_depth_of_term env1 head1
                                              in
                                           match uu____17770 with
                                           | FStar_Pervasives_Native.None  ->
                                               FStar_Pervasives_Native.None
                                           | FStar_Pervasives_Native.Some d
                                               ->
                                               FStar_TypeChecker_Common.decr_delta_depth
                                                 d
                                            in
                                         let treat_as_injective =
                                           let uu____17778 =
                                             let uu____17779 =
                                               FStar_Syntax_Util.un_uinst
                                                 head1
                                                in
                                             uu____17779.FStar_Syntax_Syntax.n
                                              in
                                           match uu____17778 with
                                           | FStar_Syntax_Syntax.Tm_fvar fv
                                               ->
                                               FStar_TypeChecker_Env.fv_has_attr
                                                 env1 fv
                                                 FStar_Parser_Const.unifier_hint_injective_lid
                                           | uu____17784 -> false  in
                                         (match d with
                                          | FStar_Pervasives_Native.Some d1
                                              when
                                              wl1.smt_ok &&
                                                (Prims.op_Negation
                                                   treat_as_injective)
                                              ->
                                              try_solve_without_smt_or_else
                                                env1 wl1
                                                solve_sub_probs_no_smt
                                                (unfold_and_retry d1)
                                          | uu____17787 ->
                                              solve_sub_probs env1 wl1)
                                     | uu____17790 ->
                                         let lhs =
                                           force_refinement
                                             (base1, refinement1)
                                            in
                                         let rhs =
                                           force_refinement
                                             (base2, refinement2)
                                            in
                                         solve_t env1
                                           (let uu___2611_17826 = problem  in
                                            {
                                              FStar_TypeChecker_Common.pid =
                                                (uu___2611_17826.FStar_TypeChecker_Common.pid);
                                              FStar_TypeChecker_Common.lhs =
                                                lhs;
                                              FStar_TypeChecker_Common.relation
                                                =
                                                (uu___2611_17826.FStar_TypeChecker_Common.relation);
                                              FStar_TypeChecker_Common.rhs =
                                                rhs;
                                              FStar_TypeChecker_Common.element
                                                =
                                                (uu___2611_17826.FStar_TypeChecker_Common.element);
                                              FStar_TypeChecker_Common.logical_guard
                                                =
                                                (uu___2611_17826.FStar_TypeChecker_Common.logical_guard);
                                              FStar_TypeChecker_Common.logical_guard_uvar
                                                =
                                                (uu___2611_17826.FStar_TypeChecker_Common.logical_guard_uvar);
                                              FStar_TypeChecker_Common.reason
                                                =
                                                (uu___2611_17826.FStar_TypeChecker_Common.reason);
                                              FStar_TypeChecker_Common.loc =
                                                (uu___2611_17826.FStar_TypeChecker_Common.loc);
                                              FStar_TypeChecker_Common.rank =
                                                (uu___2611_17826.FStar_TypeChecker_Common.rank)
                                            }) wl1))))))
            in
         let try_match_heuristic env1 orig wl1 s1 s2 t1t2_opt =
           let try_solve_branch scrutinee p =
             let uu____17902 = destruct_flex_t scrutinee wl1  in
             match uu____17902 with
             | ((_t,uv,_args),wl2) ->
                 let uu____17913 =
                   FStar_TypeChecker_PatternUtils.pat_as_exp true env1 p  in
                 (match uu____17913 with
                  | (xs,pat_term,uu____17929,uu____17930) ->
                      let uu____17935 =
                        FStar_List.fold_left
                          (fun uu____17958  ->
                             fun x  ->
                               match uu____17958 with
                               | (subst1,wl3) ->
                                   let t_x =
                                     FStar_Syntax_Subst.subst subst1
                                       x.FStar_Syntax_Syntax.sort
                                      in
                                   let uu____17979 = copy_uvar uv [] t_x wl3
                                      in
                                   (match uu____17979 with
                                    | (uu____17998,u,wl4) ->
                                        let subst2 =
                                          (FStar_Syntax_Syntax.NT (x, u)) ::
                                          subst1  in
                                        (subst2, wl4))) ([], wl2) xs
                         in
                      (match uu____17935 with
                       | (subst1,wl3) ->
                           let pat_term1 =
                             FStar_Syntax_Subst.subst subst1 pat_term  in
                           let uu____18019 =
                             new_problem wl3 env1 scrutinee
                               FStar_TypeChecker_Common.EQ pat_term1
                               FStar_Pervasives_Native.None
                               scrutinee.FStar_Syntax_Syntax.pos
                               "match heuristic"
                              in
                           (match uu____18019 with
                            | (prob,wl4) ->
                                let wl' =
                                  let uu___2651_18036 = wl4  in
                                  {
                                    attempting =
                                      [FStar_TypeChecker_Common.TProb prob];
                                    wl_deferred = [];
                                    ctr = (uu___2651_18036.ctr);
                                    defer_ok = false;
                                    smt_ok = false;
                                    umax_heuristic_ok =
                                      (uu___2651_18036.umax_heuristic_ok);
                                    tcenv = (uu___2651_18036.tcenv);
                                    wl_implicits = []
                                  }  in
                                let tx =
                                  FStar_Syntax_Unionfind.new_transaction ()
                                   in
                                let uu____18047 = solve env1 wl'  in
                                (match uu____18047 with
                                 | Success (uu____18050,imps) ->
                                     let wl'1 =
                                       let uu___2659_18053 = wl'  in
                                       {
                                         attempting = [orig];
                                         wl_deferred =
                                           (uu___2659_18053.wl_deferred);
                                         ctr = (uu___2659_18053.ctr);
                                         defer_ok =
                                           (uu___2659_18053.defer_ok);
                                         smt_ok = (uu___2659_18053.smt_ok);
                                         umax_heuristic_ok =
                                           (uu___2659_18053.umax_heuristic_ok);
                                         tcenv = (uu___2659_18053.tcenv);
                                         wl_implicits =
                                           (uu___2659_18053.wl_implicits)
                                       }  in
                                     let uu____18054 = solve env1 wl'1  in
                                     (match uu____18054 with
                                      | Success (uu____18057,imps') ->
                                          (FStar_Syntax_Unionfind.commit tx;
                                           FStar_Pervasives_Native.Some
                                             ((let uu___2667_18061 = wl4  in
                                               {
                                                 attempting =
                                                   (uu___2667_18061.attempting);
                                                 wl_deferred =
                                                   (uu___2667_18061.wl_deferred);
                                                 ctr = (uu___2667_18061.ctr);
                                                 defer_ok =
                                                   (uu___2667_18061.defer_ok);
                                                 smt_ok =
                                                   (uu___2667_18061.smt_ok);
                                                 umax_heuristic_ok =
                                                   (uu___2667_18061.umax_heuristic_ok);
                                                 tcenv =
                                                   (uu___2667_18061.tcenv);
                                                 wl_implicits =
                                                   (FStar_List.append
                                                      wl4.wl_implicits
                                                      (FStar_List.append imps
                                                         imps'))
                                               })))
                                      | Failed uu____18062 ->
                                          (FStar_Syntax_Unionfind.rollback tx;
                                           FStar_Pervasives_Native.None))
                                 | uu____18068 ->
                                     (FStar_Syntax_Unionfind.rollback tx;
                                      FStar_Pervasives_Native.None)))))
              in
           match t1t2_opt with
           | FStar_Pervasives_Native.None  ->
               FStar_Util.Inr FStar_Pervasives_Native.None
           | FStar_Pervasives_Native.Some (t1,t2) ->
               ((let uu____18091 =
                   FStar_All.pipe_left (FStar_TypeChecker_Env.debug env1)
                     (FStar_Options.Other "Rel")
                    in
                 if uu____18091
                 then
                   let uu____18096 = FStar_Syntax_Print.term_to_string t1  in
                   let uu____18098 = FStar_Syntax_Print.term_to_string t2  in
                   FStar_Util.print2 "Trying match heuristic for %s vs. %s\n"
                     uu____18096 uu____18098
                 else ());
                (let uu____18103 =
                   let uu____18124 =
                     let uu____18133 = FStar_Syntax_Util.unmeta t1  in
                     (s1, uu____18133)  in
                   let uu____18140 =
                     let uu____18149 = FStar_Syntax_Util.unmeta t2  in
                     (s2, uu____18149)  in
                   (uu____18124, uu____18140)  in
                 match uu____18103 with
                 | ((uu____18179,{
                                   FStar_Syntax_Syntax.n =
                                     FStar_Syntax_Syntax.Tm_match
                                     (scrutinee,branches);
                                   FStar_Syntax_Syntax.pos = uu____18182;
                                   FStar_Syntax_Syntax.vars = uu____18183;_}),
                    (s,t)) ->
                     let uu____18254 =
                       let uu____18256 = is_flex scrutinee  in
                       Prims.op_Negation uu____18256  in
                     if uu____18254
                     then
                       ((let uu____18267 =
                           FStar_All.pipe_left
                             (FStar_TypeChecker_Env.debug env1)
                             (FStar_Options.Other "Rel")
                            in
                         if uu____18267
                         then
                           let uu____18272 =
                             FStar_Syntax_Print.term_to_string scrutinee  in
                           FStar_Util.print1
                             "match head %s is not a flex term\n" uu____18272
                         else ());
                        FStar_Util.Inr FStar_Pervasives_Native.None)
                     else
                       if wl1.defer_ok
                       then
                         ((let uu____18291 =
                             FStar_All.pipe_left
                               (FStar_TypeChecker_Env.debug env1)
                               (FStar_Options.Other "Rel")
                              in
                           if uu____18291
                           then FStar_Util.print_string "Deferring ... \n"
                           else ());
                          FStar_Util.Inl "defer")
                       else
                         ((let uu____18306 =
                             FStar_All.pipe_left
                               (FStar_TypeChecker_Env.debug env1)
                               (FStar_Options.Other "Rel")
                              in
                           if uu____18306
                           then
                             let uu____18311 =
                               FStar_Syntax_Print.term_to_string scrutinee
                                in
                             let uu____18313 =
                               FStar_Syntax_Print.term_to_string t  in
                             FStar_Util.print2
                               "Heuristic applicable with scrutinee %s and other side = %s\n"
                               uu____18311 uu____18313
                           else ());
                          (let pat_discriminates uu___28_18338 =
                             match uu___28_18338 with
                             | ({
                                  FStar_Syntax_Syntax.v =
                                    FStar_Syntax_Syntax.Pat_constant
                                    uu____18354;
                                  FStar_Syntax_Syntax.p = uu____18355;_},FStar_Pervasives_Native.None
                                ,uu____18356) -> true
                             | ({
                                  FStar_Syntax_Syntax.v =
                                    FStar_Syntax_Syntax.Pat_cons uu____18370;
                                  FStar_Syntax_Syntax.p = uu____18371;_},FStar_Pervasives_Native.None
                                ,uu____18372) -> true
                             | uu____18399 -> false  in
                           let head_matching_branch =
                             FStar_All.pipe_right branches
                               (FStar_Util.try_find
                                  (fun b  ->
                                     if pat_discriminates b
                                     then
                                       let uu____18502 =
                                         FStar_Syntax_Subst.open_branch b  in
                                       match uu____18502 with
                                       | (uu____18504,uu____18505,t') ->
                                           let uu____18523 =
                                             head_matches_delta env1 wl1 s t'
                                              in
                                           (match uu____18523 with
                                            | (FullMatch ,uu____18535) ->
                                                true
                                            | (HeadMatch
                                               uu____18549,uu____18550) ->
                                                true
                                            | uu____18565 -> false)
                                     else false))
                              in
                           match head_matching_branch with
                           | FStar_Pervasives_Native.None  ->
                               ((let uu____18602 =
                                   FStar_All.pipe_left
                                     (FStar_TypeChecker_Env.debug env1)
                                     (FStar_Options.Other "Rel")
                                    in
                                 if uu____18602
                                 then
                                   FStar_Util.print_string
                                     "No head_matching branch\n"
                                 else ());
                                (let try_branches =
                                   let uu____18613 =
                                     FStar_Util.prefix_until
                                       (fun b  ->
                                          Prims.op_Negation
                                            (pat_discriminates b)) branches
                                      in
                                   match uu____18613 with
                                   | FStar_Pervasives_Native.Some
                                       (branches1,uu____18701,uu____18702) ->
                                       branches1
                                   | uu____18847 -> branches  in
                                 let uu____18902 =
                                   FStar_Util.find_map try_branches
                                     (fun b  ->
                                        let uu____18911 =
                                          FStar_Syntax_Subst.open_branch b
                                           in
                                        match uu____18911 with
                                        | (p,uu____18915,uu____18916) ->
                                            try_solve_branch scrutinee p)
                                    in
                                 FStar_All.pipe_left
                                   (fun _18945  -> FStar_Util.Inr _18945)
                                   uu____18902))
                           | FStar_Pervasives_Native.Some b ->
                               let uu____18975 =
                                 FStar_Syntax_Subst.open_branch b  in
                               (match uu____18975 with
                                | (p,uu____18984,e) ->
                                    ((let uu____19003 =
                                        FStar_All.pipe_left
                                          (FStar_TypeChecker_Env.debug env1)
                                          (FStar_Options.Other "Rel")
                                         in
                                      if uu____19003
                                      then
                                        let uu____19008 =
                                          FStar_Syntax_Print.pat_to_string p
                                           in
                                        let uu____19010 =
                                          FStar_Syntax_Print.term_to_string e
                                           in
                                        FStar_Util.print2
                                          "Found head matching branch %s -> %s\n"
                                          uu____19008 uu____19010
                                      else ());
                                     (let uu____19015 =
                                        try_solve_branch scrutinee p  in
                                      FStar_All.pipe_left
                                        (fun _19030  -> FStar_Util.Inr _19030)
                                        uu____19015)))))
                 | ((s,t),(uu____19033,{
                                         FStar_Syntax_Syntax.n =
                                           FStar_Syntax_Syntax.Tm_match
                                           (scrutinee,branches);
                                         FStar_Syntax_Syntax.pos =
                                           uu____19036;
                                         FStar_Syntax_Syntax.vars =
                                           uu____19037;_}))
                     ->
                     let uu____19106 =
                       let uu____19108 = is_flex scrutinee  in
                       Prims.op_Negation uu____19108  in
                     if uu____19106
                     then
                       ((let uu____19119 =
                           FStar_All.pipe_left
                             (FStar_TypeChecker_Env.debug env1)
                             (FStar_Options.Other "Rel")
                            in
                         if uu____19119
                         then
                           let uu____19124 =
                             FStar_Syntax_Print.term_to_string scrutinee  in
                           FStar_Util.print1
                             "match head %s is not a flex term\n" uu____19124
                         else ());
                        FStar_Util.Inr FStar_Pervasives_Native.None)
                     else
                       if wl1.defer_ok
                       then
                         ((let uu____19143 =
                             FStar_All.pipe_left
                               (FStar_TypeChecker_Env.debug env1)
                               (FStar_Options.Other "Rel")
                              in
                           if uu____19143
                           then FStar_Util.print_string "Deferring ... \n"
                           else ());
                          FStar_Util.Inl "defer")
                       else
                         ((let uu____19158 =
                             FStar_All.pipe_left
                               (FStar_TypeChecker_Env.debug env1)
                               (FStar_Options.Other "Rel")
                              in
                           if uu____19158
                           then
                             let uu____19163 =
                               FStar_Syntax_Print.term_to_string scrutinee
                                in
                             let uu____19165 =
                               FStar_Syntax_Print.term_to_string t  in
                             FStar_Util.print2
                               "Heuristic applicable with scrutinee %s and other side = %s\n"
                               uu____19163 uu____19165
                           else ());
                          (let pat_discriminates uu___28_19190 =
                             match uu___28_19190 with
                             | ({
                                  FStar_Syntax_Syntax.v =
                                    FStar_Syntax_Syntax.Pat_constant
                                    uu____19206;
                                  FStar_Syntax_Syntax.p = uu____19207;_},FStar_Pervasives_Native.None
                                ,uu____19208) -> true
                             | ({
                                  FStar_Syntax_Syntax.v =
                                    FStar_Syntax_Syntax.Pat_cons uu____19222;
                                  FStar_Syntax_Syntax.p = uu____19223;_},FStar_Pervasives_Native.None
                                ,uu____19224) -> true
                             | uu____19251 -> false  in
                           let head_matching_branch =
                             FStar_All.pipe_right branches
                               (FStar_Util.try_find
                                  (fun b  ->
                                     if pat_discriminates b
                                     then
                                       let uu____19354 =
                                         FStar_Syntax_Subst.open_branch b  in
                                       match uu____19354 with
                                       | (uu____19356,uu____19357,t') ->
                                           let uu____19375 =
                                             head_matches_delta env1 wl1 s t'
                                              in
                                           (match uu____19375 with
                                            | (FullMatch ,uu____19387) ->
                                                true
                                            | (HeadMatch
                                               uu____19401,uu____19402) ->
                                                true
                                            | uu____19417 -> false)
                                     else false))
                              in
                           match head_matching_branch with
                           | FStar_Pervasives_Native.None  ->
                               ((let uu____19454 =
                                   FStar_All.pipe_left
                                     (FStar_TypeChecker_Env.debug env1)
                                     (FStar_Options.Other "Rel")
                                    in
                                 if uu____19454
                                 then
                                   FStar_Util.print_string
                                     "No head_matching branch\n"
                                 else ());
                                (let try_branches =
                                   let uu____19465 =
                                     FStar_Util.prefix_until
                                       (fun b  ->
                                          Prims.op_Negation
                                            (pat_discriminates b)) branches
                                      in
                                   match uu____19465 with
                                   | FStar_Pervasives_Native.Some
                                       (branches1,uu____19553,uu____19554) ->
                                       branches1
                                   | uu____19699 -> branches  in
                                 let uu____19754 =
                                   FStar_Util.find_map try_branches
                                     (fun b  ->
                                        let uu____19763 =
                                          FStar_Syntax_Subst.open_branch b
                                           in
                                        match uu____19763 with
                                        | (p,uu____19767,uu____19768) ->
                                            try_solve_branch scrutinee p)
                                    in
                                 FStar_All.pipe_left
                                   (fun _19797  -> FStar_Util.Inr _19797)
                                   uu____19754))
                           | FStar_Pervasives_Native.Some b ->
                               let uu____19827 =
                                 FStar_Syntax_Subst.open_branch b  in
                               (match uu____19827 with
                                | (p,uu____19836,e) ->
                                    ((let uu____19855 =
                                        FStar_All.pipe_left
                                          (FStar_TypeChecker_Env.debug env1)
                                          (FStar_Options.Other "Rel")
                                         in
                                      if uu____19855
                                      then
                                        let uu____19860 =
                                          FStar_Syntax_Print.pat_to_string p
                                           in
                                        let uu____19862 =
                                          FStar_Syntax_Print.term_to_string e
                                           in
                                        FStar_Util.print2
                                          "Found head matching branch %s -> %s\n"
                                          uu____19860 uu____19862
                                      else ());
                                     (let uu____19867 =
                                        try_solve_branch scrutinee p  in
                                      FStar_All.pipe_left
                                        (fun _19882  -> FStar_Util.Inr _19882)
                                        uu____19867)))))
                 | uu____19883 ->
                     ((let uu____19905 =
                         FStar_All.pipe_left
                           (FStar_TypeChecker_Env.debug env1)
                           (FStar_Options.Other "Rel")
                          in
                       if uu____19905
                       then
                         let uu____19910 = FStar_Syntax_Print.tag_of_term t1
                            in
                         let uu____19912 = FStar_Syntax_Print.tag_of_term t2
                            in
                         FStar_Util.print2
                           "Heuristic not applicable: tag lhs=%s, rhs=%s\n"
                           uu____19910 uu____19912
                       else ());
                      FStar_Util.Inr FStar_Pervasives_Native.None)))
            in
         let rigid_rigid_delta env1 torig wl1 head1 head2 t1 t2 =
           let orig = FStar_TypeChecker_Common.TProb torig  in
           (let uu____19958 =
              FStar_All.pipe_left (FStar_TypeChecker_Env.debug env1)
                (FStar_Options.Other "RelDelta")
               in
            if uu____19958
            then
              let uu____19963 = FStar_Syntax_Print.tag_of_term t1  in
              let uu____19965 = FStar_Syntax_Print.tag_of_term t2  in
              let uu____19967 = FStar_Syntax_Print.term_to_string t1  in
              let uu____19969 = FStar_Syntax_Print.term_to_string t2  in
              FStar_Util.print4 "rigid_rigid_delta of %s-%s (%s, %s)\n"
                uu____19963 uu____19965 uu____19967 uu____19969
            else ());
           (let uu____19974 = head_matches_delta env1 wl1 t1 t2  in
            match uu____19974 with
            | (m,o) ->
                (match (m, o) with
                 | (MisMatch uu____20005,uu____20006) ->
                     let rec may_relate head3 =
                       let uu____20034 =
                         let uu____20035 = FStar_Syntax_Subst.compress head3
                            in
                         uu____20035.FStar_Syntax_Syntax.n  in
                       match uu____20034 with
                       | FStar_Syntax_Syntax.Tm_name uu____20039 -> true
                       | FStar_Syntax_Syntax.Tm_match uu____20041 -> true
                       | FStar_Syntax_Syntax.Tm_fvar fv ->
                           let uu____20066 =
                             FStar_TypeChecker_Env.delta_depth_of_fv env1 fv
                              in
                           (match uu____20066 with
                            | FStar_Syntax_Syntax.Delta_equational_at_level
                                uu____20068 -> true
                            | FStar_Syntax_Syntax.Delta_abstract uu____20071
                                ->
                                problem.FStar_TypeChecker_Common.relation =
                                  FStar_TypeChecker_Common.EQ
                            | uu____20072 -> false)
                       | FStar_Syntax_Syntax.Tm_ascribed
                           (t,uu____20075,uu____20076) -> may_relate t
                       | FStar_Syntax_Syntax.Tm_uinst (t,uu____20118) ->
                           may_relate t
                       | FStar_Syntax_Syntax.Tm_meta (t,uu____20124) ->
                           may_relate t
                       | uu____20129 -> false  in
                     let uu____20131 =
                       try_match_heuristic env1 orig wl1 t1 t2 o  in
                     (match uu____20131 with
                      | FStar_Util.Inl _defer_ok ->
                          let uu____20144 =
                            FStar_Thunk.mkv "delaying match heuristic"  in
                          giveup_or_defer1 orig uu____20144
                      | FStar_Util.Inr (FStar_Pervasives_Native.Some wl2) ->
                          solve env1 wl2
                      | FStar_Util.Inr (FStar_Pervasives_Native.None ) ->
                          let uu____20154 =
                            ((may_relate head1) || (may_relate head2)) &&
                              wl1.smt_ok
                             in
                          if uu____20154
                          then
                            let uu____20157 =
                              guard_of_prob env1 wl1 problem t1 t2  in
                            (match uu____20157 with
                             | (guard,wl2) ->
                                 let uu____20164 =
                                   solve_prob orig
                                     (FStar_Pervasives_Native.Some guard) []
                                     wl2
                                    in
                                 solve env1 uu____20164)
                          else
                            (let uu____20167 =
                               FStar_Thunk.mk
                                 (fun uu____20174  ->
                                    let uu____20175 =
                                      FStar_Syntax_Print.term_to_string head1
                                       in
                                    let uu____20177 =
                                      let uu____20179 =
                                        let uu____20183 =
                                          delta_depth_of_term env1 head1  in
                                        FStar_Util.bind_opt uu____20183
                                          (fun x  ->
                                             let uu____20190 =
                                               FStar_Syntax_Print.delta_depth_to_string
                                                 x
                                                in
                                             FStar_Pervasives_Native.Some
                                               uu____20190)
                                         in
                                      FStar_Util.dflt "" uu____20179  in
                                    let uu____20195 =
                                      FStar_Syntax_Print.term_to_string head2
                                       in
                                    let uu____20197 =
                                      let uu____20199 =
                                        let uu____20203 =
                                          delta_depth_of_term env1 head2  in
                                        FStar_Util.bind_opt uu____20203
                                          (fun x  ->
                                             let uu____20210 =
                                               FStar_Syntax_Print.delta_depth_to_string
                                                 x
                                                in
                                             FStar_Pervasives_Native.Some
                                               uu____20210)
                                         in
                                      FStar_Util.dflt "" uu____20199  in
                                    FStar_Util.format4
                                      "head mismatch (%s (%s) vs %s (%s))"
                                      uu____20175 uu____20177 uu____20195
                                      uu____20197)
                                in
                             giveup env1 uu____20167 orig))
                 | (HeadMatch (true ),uu____20216) when
                     problem.FStar_TypeChecker_Common.relation <>
                       FStar_TypeChecker_Common.EQ
                     ->
                     if wl1.smt_ok
                     then
                       let uu____20231 = guard_of_prob env1 wl1 problem t1 t2
                          in
                       (match uu____20231 with
                        | (guard,wl2) ->
                            let uu____20238 =
                              solve_prob orig
                                (FStar_Pervasives_Native.Some guard) [] wl2
                               in
                            solve env1 uu____20238)
                     else
                       (let uu____20241 =
                          FStar_Thunk.mk
                            (fun uu____20246  ->
                               let uu____20247 =
                                 FStar_Syntax_Print.term_to_string t1  in
                               let uu____20249 =
                                 FStar_Syntax_Print.term_to_string t2  in
                               FStar_Util.format2
                                 "head mismatch for subtyping (%s vs %s)"
                                 uu____20247 uu____20249)
                           in
                        giveup env1 uu____20241 orig)
                 | (uu____20252,FStar_Pervasives_Native.Some (t11,t21)) ->
                     solve_t env1
                       (let uu___2842_20266 = problem  in
                        {
                          FStar_TypeChecker_Common.pid =
                            (uu___2842_20266.FStar_TypeChecker_Common.pid);
                          FStar_TypeChecker_Common.lhs = t11;
                          FStar_TypeChecker_Common.relation =
                            (uu___2842_20266.FStar_TypeChecker_Common.relation);
                          FStar_TypeChecker_Common.rhs = t21;
                          FStar_TypeChecker_Common.element =
                            (uu___2842_20266.FStar_TypeChecker_Common.element);
                          FStar_TypeChecker_Common.logical_guard =
                            (uu___2842_20266.FStar_TypeChecker_Common.logical_guard);
                          FStar_TypeChecker_Common.logical_guard_uvar =
                            (uu___2842_20266.FStar_TypeChecker_Common.logical_guard_uvar);
                          FStar_TypeChecker_Common.reason =
                            (uu___2842_20266.FStar_TypeChecker_Common.reason);
                          FStar_TypeChecker_Common.loc =
                            (uu___2842_20266.FStar_TypeChecker_Common.loc);
                          FStar_TypeChecker_Common.rank =
                            (uu___2842_20266.FStar_TypeChecker_Common.rank)
                        }) wl1
                 | (HeadMatch need_unif,FStar_Pervasives_Native.None ) ->
                     rigid_heads_match env1 need_unif torig wl1 t1 t2
                 | (FullMatch ,FStar_Pervasives_Native.None ) ->
                     rigid_heads_match env1 false torig wl1 t1 t2))
            in
         let orig = FStar_TypeChecker_Common.TProb problem  in
         def_check_prob "solve_t'.2" orig;
         (let uu____20293 =
            FStar_Util.physical_equality problem.FStar_TypeChecker_Common.lhs
              problem.FStar_TypeChecker_Common.rhs
             in
          if uu____20293
          then
            let uu____20296 =
              solve_prob orig FStar_Pervasives_Native.None [] wl  in
            solve env uu____20296
          else
            (let t1 = problem.FStar_TypeChecker_Common.lhs  in
             let t2 = problem.FStar_TypeChecker_Common.rhs  in
             (let uu____20302 =
                let uu____20305 = p_scope orig  in
                FStar_List.map FStar_Pervasives_Native.fst uu____20305  in
              FStar_TypeChecker_Env.def_check_closed_in (p_loc orig) "ref.t1"
                uu____20302 t1);
             (let uu____20324 =
                let uu____20327 = p_scope orig  in
                FStar_List.map FStar_Pervasives_Native.fst uu____20327  in
              FStar_TypeChecker_Env.def_check_closed_in (p_loc orig) "ref.t2"
                uu____20324 t2);
             (let uu____20346 =
                FStar_TypeChecker_Env.debug env (FStar_Options.Other "Rel")
                 in
              if uu____20346
              then
                let uu____20350 =
                  FStar_Util.string_of_int
                    problem.FStar_TypeChecker_Common.pid
                   in
                let uu____20352 =
                  let uu____20354 = FStar_Syntax_Print.tag_of_term t1  in
                  let uu____20356 =
                    let uu____20358 = FStar_Syntax_Print.term_to_string t1
                       in
                    Prims.op_Hat "::" uu____20358  in
                  Prims.op_Hat uu____20354 uu____20356  in
                let uu____20361 =
                  let uu____20363 = FStar_Syntax_Print.tag_of_term t2  in
                  let uu____20365 =
                    let uu____20367 = FStar_Syntax_Print.term_to_string t2
                       in
                    Prims.op_Hat "::" uu____20367  in
                  Prims.op_Hat uu____20363 uu____20365  in
                FStar_Util.print4 "Attempting %s (%s vs %s); rel = (%s)\n"
                  uu____20350 uu____20352 uu____20361
                  (rel_to_string problem.FStar_TypeChecker_Common.relation)
              else ());
             (let r = FStar_TypeChecker_Env.get_range env  in
              match ((t1.FStar_Syntax_Syntax.n), (t2.FStar_Syntax_Syntax.n))
              with
              | (FStar_Syntax_Syntax.Tm_delayed uu____20374,uu____20375) ->
                  failwith "Impossible: terms were not compressed"
              | (uu____20399,FStar_Syntax_Syntax.Tm_delayed uu____20400) ->
                  failwith "Impossible: terms were not compressed"
              | (FStar_Syntax_Syntax.Tm_ascribed uu____20424,uu____20425) ->
                  let uu____20452 =
                    let uu___2873_20453 = problem  in
                    let uu____20454 = FStar_Syntax_Util.unascribe t1  in
                    {
                      FStar_TypeChecker_Common.pid =
                        (uu___2873_20453.FStar_TypeChecker_Common.pid);
                      FStar_TypeChecker_Common.lhs = uu____20454;
                      FStar_TypeChecker_Common.relation =
                        (uu___2873_20453.FStar_TypeChecker_Common.relation);
                      FStar_TypeChecker_Common.rhs =
                        (uu___2873_20453.FStar_TypeChecker_Common.rhs);
                      FStar_TypeChecker_Common.element =
                        (uu___2873_20453.FStar_TypeChecker_Common.element);
                      FStar_TypeChecker_Common.logical_guard =
                        (uu___2873_20453.FStar_TypeChecker_Common.logical_guard);
                      FStar_TypeChecker_Common.logical_guard_uvar =
                        (uu___2873_20453.FStar_TypeChecker_Common.logical_guard_uvar);
                      FStar_TypeChecker_Common.reason =
                        (uu___2873_20453.FStar_TypeChecker_Common.reason);
                      FStar_TypeChecker_Common.loc =
                        (uu___2873_20453.FStar_TypeChecker_Common.loc);
                      FStar_TypeChecker_Common.rank =
                        (uu___2873_20453.FStar_TypeChecker_Common.rank)
                    }  in
                  solve_t' env uu____20452 wl
              | (FStar_Syntax_Syntax.Tm_meta uu____20455,uu____20456) ->
                  let uu____20463 =
                    let uu___2879_20464 = problem  in
                    let uu____20465 = FStar_Syntax_Util.unmeta t1  in
                    {
                      FStar_TypeChecker_Common.pid =
                        (uu___2879_20464.FStar_TypeChecker_Common.pid);
                      FStar_TypeChecker_Common.lhs = uu____20465;
                      FStar_TypeChecker_Common.relation =
                        (uu___2879_20464.FStar_TypeChecker_Common.relation);
                      FStar_TypeChecker_Common.rhs =
                        (uu___2879_20464.FStar_TypeChecker_Common.rhs);
                      FStar_TypeChecker_Common.element =
                        (uu___2879_20464.FStar_TypeChecker_Common.element);
                      FStar_TypeChecker_Common.logical_guard =
                        (uu___2879_20464.FStar_TypeChecker_Common.logical_guard);
                      FStar_TypeChecker_Common.logical_guard_uvar =
                        (uu___2879_20464.FStar_TypeChecker_Common.logical_guard_uvar);
                      FStar_TypeChecker_Common.reason =
                        (uu___2879_20464.FStar_TypeChecker_Common.reason);
                      FStar_TypeChecker_Common.loc =
                        (uu___2879_20464.FStar_TypeChecker_Common.loc);
                      FStar_TypeChecker_Common.rank =
                        (uu___2879_20464.FStar_TypeChecker_Common.rank)
                    }  in
                  solve_t' env uu____20463 wl
              | (uu____20466,FStar_Syntax_Syntax.Tm_ascribed uu____20467) ->
                  let uu____20494 =
                    let uu___2885_20495 = problem  in
                    let uu____20496 = FStar_Syntax_Util.unascribe t2  in
                    {
                      FStar_TypeChecker_Common.pid =
                        (uu___2885_20495.FStar_TypeChecker_Common.pid);
                      FStar_TypeChecker_Common.lhs =
                        (uu___2885_20495.FStar_TypeChecker_Common.lhs);
                      FStar_TypeChecker_Common.relation =
                        (uu___2885_20495.FStar_TypeChecker_Common.relation);
                      FStar_TypeChecker_Common.rhs = uu____20496;
                      FStar_TypeChecker_Common.element =
                        (uu___2885_20495.FStar_TypeChecker_Common.element);
                      FStar_TypeChecker_Common.logical_guard =
                        (uu___2885_20495.FStar_TypeChecker_Common.logical_guard);
                      FStar_TypeChecker_Common.logical_guard_uvar =
                        (uu___2885_20495.FStar_TypeChecker_Common.logical_guard_uvar);
                      FStar_TypeChecker_Common.reason =
                        (uu___2885_20495.FStar_TypeChecker_Common.reason);
                      FStar_TypeChecker_Common.loc =
                        (uu___2885_20495.FStar_TypeChecker_Common.loc);
                      FStar_TypeChecker_Common.rank =
                        (uu___2885_20495.FStar_TypeChecker_Common.rank)
                    }  in
                  solve_t' env uu____20494 wl
              | (uu____20497,FStar_Syntax_Syntax.Tm_meta uu____20498) ->
                  let uu____20505 =
                    let uu___2891_20506 = problem  in
                    let uu____20507 = FStar_Syntax_Util.unmeta t2  in
                    {
                      FStar_TypeChecker_Common.pid =
                        (uu___2891_20506.FStar_TypeChecker_Common.pid);
                      FStar_TypeChecker_Common.lhs =
                        (uu___2891_20506.FStar_TypeChecker_Common.lhs);
                      FStar_TypeChecker_Common.relation =
                        (uu___2891_20506.FStar_TypeChecker_Common.relation);
                      FStar_TypeChecker_Common.rhs = uu____20507;
                      FStar_TypeChecker_Common.element =
                        (uu___2891_20506.FStar_TypeChecker_Common.element);
                      FStar_TypeChecker_Common.logical_guard =
                        (uu___2891_20506.FStar_TypeChecker_Common.logical_guard);
                      FStar_TypeChecker_Common.logical_guard_uvar =
                        (uu___2891_20506.FStar_TypeChecker_Common.logical_guard_uvar);
                      FStar_TypeChecker_Common.reason =
                        (uu___2891_20506.FStar_TypeChecker_Common.reason);
                      FStar_TypeChecker_Common.loc =
                        (uu___2891_20506.FStar_TypeChecker_Common.loc);
                      FStar_TypeChecker_Common.rank =
                        (uu___2891_20506.FStar_TypeChecker_Common.rank)
                    }  in
                  solve_t' env uu____20505 wl
              | (FStar_Syntax_Syntax.Tm_quoted
                 (t11,uu____20509),FStar_Syntax_Syntax.Tm_quoted
                 (t21,uu____20511)) ->
                  let uu____20520 =
                    solve_prob orig FStar_Pervasives_Native.None [] wl  in
                  solve env uu____20520
              | (FStar_Syntax_Syntax.Tm_bvar uu____20521,uu____20522) ->
                  failwith
                    "Only locally nameless! We should never see a de Bruijn variable"
              | (uu____20524,FStar_Syntax_Syntax.Tm_bvar uu____20525) ->
                  failwith
                    "Only locally nameless! We should never see a de Bruijn variable"
              | (FStar_Syntax_Syntax.Tm_type u1,FStar_Syntax_Syntax.Tm_type
                 u2) -> solve_one_universe_eq env orig u1 u2 wl
              | (FStar_Syntax_Syntax.Tm_arrow
                 (bs1,c1),FStar_Syntax_Syntax.Tm_arrow (bs2,c2)) ->
                  let mk_c c uu___29_20595 =
                    match uu___29_20595 with
                    | [] -> c
                    | bs ->
                        let uu____20623 =
                          FStar_Syntax_Syntax.mk
                            (FStar_Syntax_Syntax.Tm_arrow (bs, c))
                            FStar_Pervasives_Native.None
                            c.FStar_Syntax_Syntax.pos
                           in
                        FStar_Syntax_Syntax.mk_Total uu____20623
                     in
                  let uu____20634 =
                    match_num_binders (bs1, (mk_c c1)) (bs2, (mk_c c2))  in
                  (match uu____20634 with
                   | ((bs11,c11),(bs21,c21)) ->
                       solve_binders env bs11 bs21 orig wl
                         (fun wl1  ->
                            fun scope  ->
                              fun env1  ->
                                fun subst1  ->
                                  let c12 =
                                    FStar_Syntax_Subst.subst_comp subst1 c11
                                     in
                                  let c22 =
                                    FStar_Syntax_Subst.subst_comp subst1 c21
                                     in
                                  let rel =
                                    let uu____20783 =
                                      FStar_Options.use_eq_at_higher_order ()
                                       in
                                    if uu____20783
                                    then FStar_TypeChecker_Common.EQ
                                    else
                                      problem.FStar_TypeChecker_Common.relation
                                     in
                                  mk_c_problem wl1 scope orig c12 rel c22
                                    FStar_Pervasives_Native.None
                                    "function co-domain"))
              | (FStar_Syntax_Syntax.Tm_abs
                 (bs1,tbody1,lopt1),FStar_Syntax_Syntax.Tm_abs
                 (bs2,tbody2,lopt2)) ->
                  let mk_t t l uu___30_20872 =
                    match uu___30_20872 with
                    | [] -> t
                    | bs ->
                        FStar_Syntax_Syntax.mk
                          (FStar_Syntax_Syntax.Tm_abs (bs, t, l))
                          FStar_Pervasives_Native.None
                          t.FStar_Syntax_Syntax.pos
                     in
                  let uu____20914 =
                    match_num_binders (bs1, (mk_t tbody1 lopt1))
                      (bs2, (mk_t tbody2 lopt2))
                     in
                  (match uu____20914 with
                   | ((bs11,tbody11),(bs21,tbody21)) ->
                       solve_binders env bs11 bs21 orig wl
                         (fun wl1  ->
                            fun scope  ->
                              fun env1  ->
                                fun subst1  ->
                                  let uu____21059 =
                                    FStar_Syntax_Subst.subst subst1 tbody11
                                     in
                                  let uu____21060 =
                                    FStar_Syntax_Subst.subst subst1 tbody21
                                     in
                                  mk_t_problem wl1 scope orig uu____21059
                                    problem.FStar_TypeChecker_Common.relation
                                    uu____21060 FStar_Pervasives_Native.None
                                    "lambda co-domain"))
              | (FStar_Syntax_Syntax.Tm_abs uu____21062,uu____21063) ->
                  let is_abs t =
                    match t.FStar_Syntax_Syntax.n with
                    | FStar_Syntax_Syntax.Tm_abs uu____21094 -> true
                    | uu____21114 -> false  in
                  let maybe_eta t =
                    if is_abs t
                    then FStar_Util.Inl t
                    else
                      (let t3 =
                         FStar_TypeChecker_Normalize.eta_expand wl.tcenv t
                          in
                       if is_abs t3
                       then FStar_Util.Inl t3
                       else FStar_Util.Inr t3)
                     in
                  let force_eta t =
                    if is_abs t
                    then t
                    else
                      (let uu____21174 =
                         env.FStar_TypeChecker_Env.type_of
                           (let uu___2993_21182 = env  in
                            {
                              FStar_TypeChecker_Env.solver =
                                (uu___2993_21182.FStar_TypeChecker_Env.solver);
                              FStar_TypeChecker_Env.range =
                                (uu___2993_21182.FStar_TypeChecker_Env.range);
                              FStar_TypeChecker_Env.curmodule =
                                (uu___2993_21182.FStar_TypeChecker_Env.curmodule);
                              FStar_TypeChecker_Env.gamma =
                                (uu___2993_21182.FStar_TypeChecker_Env.gamma);
                              FStar_TypeChecker_Env.gamma_sig =
                                (uu___2993_21182.FStar_TypeChecker_Env.gamma_sig);
                              FStar_TypeChecker_Env.gamma_cache =
                                (uu___2993_21182.FStar_TypeChecker_Env.gamma_cache);
                              FStar_TypeChecker_Env.modules =
                                (uu___2993_21182.FStar_TypeChecker_Env.modules);
                              FStar_TypeChecker_Env.expected_typ =
                                FStar_Pervasives_Native.None;
                              FStar_TypeChecker_Env.sigtab =
                                (uu___2993_21182.FStar_TypeChecker_Env.sigtab);
                              FStar_TypeChecker_Env.attrtab =
                                (uu___2993_21182.FStar_TypeChecker_Env.attrtab);
                              FStar_TypeChecker_Env.instantiate_imp =
                                (uu___2993_21182.FStar_TypeChecker_Env.instantiate_imp);
                              FStar_TypeChecker_Env.effects =
                                (uu___2993_21182.FStar_TypeChecker_Env.effects);
                              FStar_TypeChecker_Env.generalize =
                                (uu___2993_21182.FStar_TypeChecker_Env.generalize);
                              FStar_TypeChecker_Env.letrecs =
                                (uu___2993_21182.FStar_TypeChecker_Env.letrecs);
                              FStar_TypeChecker_Env.top_level =
                                (uu___2993_21182.FStar_TypeChecker_Env.top_level);
                              FStar_TypeChecker_Env.check_uvars =
                                (uu___2993_21182.FStar_TypeChecker_Env.check_uvars);
                              FStar_TypeChecker_Env.use_eq =
                                (uu___2993_21182.FStar_TypeChecker_Env.use_eq);
                              FStar_TypeChecker_Env.use_eq_strict =
                                (uu___2993_21182.FStar_TypeChecker_Env.use_eq_strict);
                              FStar_TypeChecker_Env.is_iface =
                                (uu___2993_21182.FStar_TypeChecker_Env.is_iface);
                              FStar_TypeChecker_Env.admit =
                                (uu___2993_21182.FStar_TypeChecker_Env.admit);
                              FStar_TypeChecker_Env.lax = true;
                              FStar_TypeChecker_Env.lax_universes =
                                (uu___2993_21182.FStar_TypeChecker_Env.lax_universes);
                              FStar_TypeChecker_Env.phase1 =
                                (uu___2993_21182.FStar_TypeChecker_Env.phase1);
                              FStar_TypeChecker_Env.failhard =
                                (uu___2993_21182.FStar_TypeChecker_Env.failhard);
                              FStar_TypeChecker_Env.nosynth =
                                (uu___2993_21182.FStar_TypeChecker_Env.nosynth);
                              FStar_TypeChecker_Env.uvar_subtyping =
                                (uu___2993_21182.FStar_TypeChecker_Env.uvar_subtyping);
                              FStar_TypeChecker_Env.tc_term =
                                (uu___2993_21182.FStar_TypeChecker_Env.tc_term);
                              FStar_TypeChecker_Env.type_of =
                                (uu___2993_21182.FStar_TypeChecker_Env.type_of);
                              FStar_TypeChecker_Env.universe_of =
                                (uu___2993_21182.FStar_TypeChecker_Env.universe_of);
                              FStar_TypeChecker_Env.check_type_of =
                                (uu___2993_21182.FStar_TypeChecker_Env.check_type_of);
                              FStar_TypeChecker_Env.use_bv_sorts = true;
                              FStar_TypeChecker_Env.qtbl_name_and_index =
                                (uu___2993_21182.FStar_TypeChecker_Env.qtbl_name_and_index);
                              FStar_TypeChecker_Env.normalized_eff_names =
                                (uu___2993_21182.FStar_TypeChecker_Env.normalized_eff_names);
                              FStar_TypeChecker_Env.fv_delta_depths =
                                (uu___2993_21182.FStar_TypeChecker_Env.fv_delta_depths);
                              FStar_TypeChecker_Env.proof_ns =
                                (uu___2993_21182.FStar_TypeChecker_Env.proof_ns);
                              FStar_TypeChecker_Env.synth_hook =
                                (uu___2993_21182.FStar_TypeChecker_Env.synth_hook);
                              FStar_TypeChecker_Env.try_solve_implicits_hook
                                =
                                (uu___2993_21182.FStar_TypeChecker_Env.try_solve_implicits_hook);
                              FStar_TypeChecker_Env.splice =
                                (uu___2993_21182.FStar_TypeChecker_Env.splice);
                              FStar_TypeChecker_Env.mpreprocess =
                                (uu___2993_21182.FStar_TypeChecker_Env.mpreprocess);
                              FStar_TypeChecker_Env.postprocess =
                                (uu___2993_21182.FStar_TypeChecker_Env.postprocess);
                              FStar_TypeChecker_Env.is_native_tactic =
                                (uu___2993_21182.FStar_TypeChecker_Env.is_native_tactic);
                              FStar_TypeChecker_Env.identifier_info =
                                (uu___2993_21182.FStar_TypeChecker_Env.identifier_info);
                              FStar_TypeChecker_Env.tc_hooks =
                                (uu___2993_21182.FStar_TypeChecker_Env.tc_hooks);
                              FStar_TypeChecker_Env.dsenv =
                                (uu___2993_21182.FStar_TypeChecker_Env.dsenv);
                              FStar_TypeChecker_Env.nbe =
                                (uu___2993_21182.FStar_TypeChecker_Env.nbe);
                              FStar_TypeChecker_Env.strict_args_tab =
                                (uu___2993_21182.FStar_TypeChecker_Env.strict_args_tab);
                              FStar_TypeChecker_Env.erasable_types_tab =
                                (uu___2993_21182.FStar_TypeChecker_Env.erasable_types_tab)
                            }) t
                          in
                       match uu____21174 with
                       | (uu____21187,ty,uu____21189) ->
                           let ty1 =
                             let rec aux ty1 =
                               let ty2 =
                                 FStar_TypeChecker_Normalize.unfold_whnf env
                                   ty1
                                  in
                               let uu____21198 =
                                 let uu____21199 =
                                   FStar_Syntax_Subst.compress ty2  in
                                 uu____21199.FStar_Syntax_Syntax.n  in
                               match uu____21198 with
                               | FStar_Syntax_Syntax.Tm_refine uu____21202 ->
                                   let uu____21209 =
                                     FStar_Syntax_Util.unrefine ty2  in
                                   aux uu____21209
                               | uu____21210 -> ty2  in
                             aux ty  in
                           let r1 =
                             FStar_TypeChecker_Normalize.eta_expand_with_type
                               env t ty1
                              in
                           ((let uu____21213 =
                               FStar_All.pipe_left
                                 (FStar_TypeChecker_Env.debug wl.tcenv)
                                 (FStar_Options.Other "Rel")
                                in
                             if uu____21213
                             then
                               let uu____21218 =
                                 FStar_Syntax_Print.term_to_string t  in
                               let uu____21220 =
                                 let uu____21222 =
                                   FStar_TypeChecker_Normalize.unfold_whnf
                                     env ty1
                                    in
                                 FStar_Syntax_Print.term_to_string
                                   uu____21222
                                  in
                               let uu____21223 =
                                 FStar_Syntax_Print.term_to_string r1  in
                               FStar_Util.print3
                                 "force_eta of (%s) at type (%s) = %s\n"
                                 uu____21218 uu____21220 uu____21223
                             else ());
                            r1))
                     in
                  let uu____21228 =
                    let uu____21245 = maybe_eta t1  in
                    let uu____21252 = maybe_eta t2  in
                    (uu____21245, uu____21252)  in
                  (match uu____21228 with
                   | (FStar_Util.Inl t11,FStar_Util.Inl t21) ->
                       solve_t env
                         (let uu___3014_21294 = problem  in
                          {
                            FStar_TypeChecker_Common.pid =
                              (uu___3014_21294.FStar_TypeChecker_Common.pid);
                            FStar_TypeChecker_Common.lhs = t11;
                            FStar_TypeChecker_Common.relation =
                              (uu___3014_21294.FStar_TypeChecker_Common.relation);
                            FStar_TypeChecker_Common.rhs = t21;
                            FStar_TypeChecker_Common.element =
                              (uu___3014_21294.FStar_TypeChecker_Common.element);
                            FStar_TypeChecker_Common.logical_guard =
                              (uu___3014_21294.FStar_TypeChecker_Common.logical_guard);
                            FStar_TypeChecker_Common.logical_guard_uvar =
                              (uu___3014_21294.FStar_TypeChecker_Common.logical_guard_uvar);
                            FStar_TypeChecker_Common.reason =
                              (uu___3014_21294.FStar_TypeChecker_Common.reason);
                            FStar_TypeChecker_Common.loc =
                              (uu___3014_21294.FStar_TypeChecker_Common.loc);
                            FStar_TypeChecker_Common.rank =
                              (uu___3014_21294.FStar_TypeChecker_Common.rank)
                          }) wl
                   | (FStar_Util.Inl t_abs,FStar_Util.Inr not_abs) ->
                       let uu____21315 =
                         (is_flex not_abs) &&
                           ((p_rel orig) = FStar_TypeChecker_Common.EQ)
                          in
                       if uu____21315
                       then
                         let uu____21318 = destruct_flex_t not_abs wl  in
                         (match uu____21318 with
                          | (flex,wl1) ->
                              solve_t_flex_rigid_eq env orig wl1 flex t_abs)
                       else
                         (let t11 = force_eta t1  in
                          let t21 = force_eta t2  in
                          if (is_abs t11) && (is_abs t21)
                          then
                            solve_t env
                              (let uu___3031_21335 = problem  in
                               {
                                 FStar_TypeChecker_Common.pid =
                                   (uu___3031_21335.FStar_TypeChecker_Common.pid);
                                 FStar_TypeChecker_Common.lhs = t11;
                                 FStar_TypeChecker_Common.relation =
                                   (uu___3031_21335.FStar_TypeChecker_Common.relation);
                                 FStar_TypeChecker_Common.rhs = t21;
                                 FStar_TypeChecker_Common.element =
                                   (uu___3031_21335.FStar_TypeChecker_Common.element);
                                 FStar_TypeChecker_Common.logical_guard =
                                   (uu___3031_21335.FStar_TypeChecker_Common.logical_guard);
                                 FStar_TypeChecker_Common.logical_guard_uvar
                                   =
                                   (uu___3031_21335.FStar_TypeChecker_Common.logical_guard_uvar);
                                 FStar_TypeChecker_Common.reason =
                                   (uu___3031_21335.FStar_TypeChecker_Common.reason);
                                 FStar_TypeChecker_Common.loc =
                                   (uu___3031_21335.FStar_TypeChecker_Common.loc);
                                 FStar_TypeChecker_Common.rank =
                                   (uu___3031_21335.FStar_TypeChecker_Common.rank)
                               }) wl
                          else
                            (let uu____21338 =
                               FStar_Thunk.mkv
                                 "head tag mismatch: RHS is an abstraction"
                                in
                             giveup env uu____21338 orig))
                   | (FStar_Util.Inr not_abs,FStar_Util.Inl t_abs) ->
                       let uu____21361 =
                         (is_flex not_abs) &&
                           ((p_rel orig) = FStar_TypeChecker_Common.EQ)
                          in
                       if uu____21361
                       then
                         let uu____21364 = destruct_flex_t not_abs wl  in
                         (match uu____21364 with
                          | (flex,wl1) ->
                              solve_t_flex_rigid_eq env orig wl1 flex t_abs)
                       else
                         (let t11 = force_eta t1  in
                          let t21 = force_eta t2  in
                          if (is_abs t11) && (is_abs t21)
                          then
                            solve_t env
                              (let uu___3031_21381 = problem  in
                               {
                                 FStar_TypeChecker_Common.pid =
                                   (uu___3031_21381.FStar_TypeChecker_Common.pid);
                                 FStar_TypeChecker_Common.lhs = t11;
                                 FStar_TypeChecker_Common.relation =
                                   (uu___3031_21381.FStar_TypeChecker_Common.relation);
                                 FStar_TypeChecker_Common.rhs = t21;
                                 FStar_TypeChecker_Common.element =
                                   (uu___3031_21381.FStar_TypeChecker_Common.element);
                                 FStar_TypeChecker_Common.logical_guard =
                                   (uu___3031_21381.FStar_TypeChecker_Common.logical_guard);
                                 FStar_TypeChecker_Common.logical_guard_uvar
                                   =
                                   (uu___3031_21381.FStar_TypeChecker_Common.logical_guard_uvar);
                                 FStar_TypeChecker_Common.reason =
                                   (uu___3031_21381.FStar_TypeChecker_Common.reason);
                                 FStar_TypeChecker_Common.loc =
                                   (uu___3031_21381.FStar_TypeChecker_Common.loc);
                                 FStar_TypeChecker_Common.rank =
                                   (uu___3031_21381.FStar_TypeChecker_Common.rank)
                               }) wl
                          else
                            (let uu____21384 =
                               FStar_Thunk.mkv
                                 "head tag mismatch: RHS is an abstraction"
                                in
                             giveup env uu____21384 orig))
                   | uu____21387 ->
                       failwith
                         "Impossible: at least one side is an abstraction")
              | (uu____21405,FStar_Syntax_Syntax.Tm_abs uu____21406) ->
                  let is_abs t =
                    match t.FStar_Syntax_Syntax.n with
                    | FStar_Syntax_Syntax.Tm_abs uu____21437 -> true
                    | uu____21457 -> false  in
                  let maybe_eta t =
                    if is_abs t
                    then FStar_Util.Inl t
                    else
                      (let t3 =
                         FStar_TypeChecker_Normalize.eta_expand wl.tcenv t
                          in
                       if is_abs t3
                       then FStar_Util.Inl t3
                       else FStar_Util.Inr t3)
                     in
                  let force_eta t =
                    if is_abs t
                    then t
                    else
                      (let uu____21517 =
                         env.FStar_TypeChecker_Env.type_of
                           (let uu___2993_21525 = env  in
                            {
                              FStar_TypeChecker_Env.solver =
                                (uu___2993_21525.FStar_TypeChecker_Env.solver);
                              FStar_TypeChecker_Env.range =
                                (uu___2993_21525.FStar_TypeChecker_Env.range);
                              FStar_TypeChecker_Env.curmodule =
                                (uu___2993_21525.FStar_TypeChecker_Env.curmodule);
                              FStar_TypeChecker_Env.gamma =
                                (uu___2993_21525.FStar_TypeChecker_Env.gamma);
                              FStar_TypeChecker_Env.gamma_sig =
                                (uu___2993_21525.FStar_TypeChecker_Env.gamma_sig);
                              FStar_TypeChecker_Env.gamma_cache =
                                (uu___2993_21525.FStar_TypeChecker_Env.gamma_cache);
                              FStar_TypeChecker_Env.modules =
                                (uu___2993_21525.FStar_TypeChecker_Env.modules);
                              FStar_TypeChecker_Env.expected_typ =
                                FStar_Pervasives_Native.None;
                              FStar_TypeChecker_Env.sigtab =
                                (uu___2993_21525.FStar_TypeChecker_Env.sigtab);
                              FStar_TypeChecker_Env.attrtab =
                                (uu___2993_21525.FStar_TypeChecker_Env.attrtab);
                              FStar_TypeChecker_Env.instantiate_imp =
                                (uu___2993_21525.FStar_TypeChecker_Env.instantiate_imp);
                              FStar_TypeChecker_Env.effects =
                                (uu___2993_21525.FStar_TypeChecker_Env.effects);
                              FStar_TypeChecker_Env.generalize =
                                (uu___2993_21525.FStar_TypeChecker_Env.generalize);
                              FStar_TypeChecker_Env.letrecs =
                                (uu___2993_21525.FStar_TypeChecker_Env.letrecs);
                              FStar_TypeChecker_Env.top_level =
                                (uu___2993_21525.FStar_TypeChecker_Env.top_level);
                              FStar_TypeChecker_Env.check_uvars =
                                (uu___2993_21525.FStar_TypeChecker_Env.check_uvars);
                              FStar_TypeChecker_Env.use_eq =
                                (uu___2993_21525.FStar_TypeChecker_Env.use_eq);
                              FStar_TypeChecker_Env.use_eq_strict =
                                (uu___2993_21525.FStar_TypeChecker_Env.use_eq_strict);
                              FStar_TypeChecker_Env.is_iface =
                                (uu___2993_21525.FStar_TypeChecker_Env.is_iface);
                              FStar_TypeChecker_Env.admit =
                                (uu___2993_21525.FStar_TypeChecker_Env.admit);
                              FStar_TypeChecker_Env.lax = true;
                              FStar_TypeChecker_Env.lax_universes =
                                (uu___2993_21525.FStar_TypeChecker_Env.lax_universes);
                              FStar_TypeChecker_Env.phase1 =
                                (uu___2993_21525.FStar_TypeChecker_Env.phase1);
                              FStar_TypeChecker_Env.failhard =
                                (uu___2993_21525.FStar_TypeChecker_Env.failhard);
                              FStar_TypeChecker_Env.nosynth =
                                (uu___2993_21525.FStar_TypeChecker_Env.nosynth);
                              FStar_TypeChecker_Env.uvar_subtyping =
                                (uu___2993_21525.FStar_TypeChecker_Env.uvar_subtyping);
                              FStar_TypeChecker_Env.tc_term =
                                (uu___2993_21525.FStar_TypeChecker_Env.tc_term);
                              FStar_TypeChecker_Env.type_of =
                                (uu___2993_21525.FStar_TypeChecker_Env.type_of);
                              FStar_TypeChecker_Env.universe_of =
                                (uu___2993_21525.FStar_TypeChecker_Env.universe_of);
                              FStar_TypeChecker_Env.check_type_of =
                                (uu___2993_21525.FStar_TypeChecker_Env.check_type_of);
                              FStar_TypeChecker_Env.use_bv_sorts = true;
                              FStar_TypeChecker_Env.qtbl_name_and_index =
                                (uu___2993_21525.FStar_TypeChecker_Env.qtbl_name_and_index);
                              FStar_TypeChecker_Env.normalized_eff_names =
                                (uu___2993_21525.FStar_TypeChecker_Env.normalized_eff_names);
                              FStar_TypeChecker_Env.fv_delta_depths =
                                (uu___2993_21525.FStar_TypeChecker_Env.fv_delta_depths);
                              FStar_TypeChecker_Env.proof_ns =
                                (uu___2993_21525.FStar_TypeChecker_Env.proof_ns);
                              FStar_TypeChecker_Env.synth_hook =
                                (uu___2993_21525.FStar_TypeChecker_Env.synth_hook);
                              FStar_TypeChecker_Env.try_solve_implicits_hook
                                =
                                (uu___2993_21525.FStar_TypeChecker_Env.try_solve_implicits_hook);
                              FStar_TypeChecker_Env.splice =
                                (uu___2993_21525.FStar_TypeChecker_Env.splice);
                              FStar_TypeChecker_Env.mpreprocess =
                                (uu___2993_21525.FStar_TypeChecker_Env.mpreprocess);
                              FStar_TypeChecker_Env.postprocess =
                                (uu___2993_21525.FStar_TypeChecker_Env.postprocess);
                              FStar_TypeChecker_Env.is_native_tactic =
                                (uu___2993_21525.FStar_TypeChecker_Env.is_native_tactic);
                              FStar_TypeChecker_Env.identifier_info =
                                (uu___2993_21525.FStar_TypeChecker_Env.identifier_info);
                              FStar_TypeChecker_Env.tc_hooks =
                                (uu___2993_21525.FStar_TypeChecker_Env.tc_hooks);
                              FStar_TypeChecker_Env.dsenv =
                                (uu___2993_21525.FStar_TypeChecker_Env.dsenv);
                              FStar_TypeChecker_Env.nbe =
                                (uu___2993_21525.FStar_TypeChecker_Env.nbe);
                              FStar_TypeChecker_Env.strict_args_tab =
                                (uu___2993_21525.FStar_TypeChecker_Env.strict_args_tab);
                              FStar_TypeChecker_Env.erasable_types_tab =
                                (uu___2993_21525.FStar_TypeChecker_Env.erasable_types_tab)
                            }) t
                          in
                       match uu____21517 with
                       | (uu____21530,ty,uu____21532) ->
                           let ty1 =
                             let rec aux ty1 =
                               let ty2 =
                                 FStar_TypeChecker_Normalize.unfold_whnf env
                                   ty1
                                  in
                               let uu____21541 =
                                 let uu____21542 =
                                   FStar_Syntax_Subst.compress ty2  in
                                 uu____21542.FStar_Syntax_Syntax.n  in
                               match uu____21541 with
                               | FStar_Syntax_Syntax.Tm_refine uu____21545 ->
                                   let uu____21552 =
                                     FStar_Syntax_Util.unrefine ty2  in
                                   aux uu____21552
                               | uu____21553 -> ty2  in
                             aux ty  in
                           let r1 =
                             FStar_TypeChecker_Normalize.eta_expand_with_type
                               env t ty1
                              in
                           ((let uu____21556 =
                               FStar_All.pipe_left
                                 (FStar_TypeChecker_Env.debug wl.tcenv)
                                 (FStar_Options.Other "Rel")
                                in
                             if uu____21556
                             then
                               let uu____21561 =
                                 FStar_Syntax_Print.term_to_string t  in
                               let uu____21563 =
                                 let uu____21565 =
                                   FStar_TypeChecker_Normalize.unfold_whnf
                                     env ty1
                                    in
                                 FStar_Syntax_Print.term_to_string
                                   uu____21565
                                  in
                               let uu____21566 =
                                 FStar_Syntax_Print.term_to_string r1  in
                               FStar_Util.print3
                                 "force_eta of (%s) at type (%s) = %s\n"
                                 uu____21561 uu____21563 uu____21566
                             else ());
                            r1))
                     in
                  let uu____21571 =
                    let uu____21588 = maybe_eta t1  in
                    let uu____21595 = maybe_eta t2  in
                    (uu____21588, uu____21595)  in
                  (match uu____21571 with
                   | (FStar_Util.Inl t11,FStar_Util.Inl t21) ->
                       solve_t env
                         (let uu___3014_21637 = problem  in
                          {
                            FStar_TypeChecker_Common.pid =
                              (uu___3014_21637.FStar_TypeChecker_Common.pid);
                            FStar_TypeChecker_Common.lhs = t11;
                            FStar_TypeChecker_Common.relation =
                              (uu___3014_21637.FStar_TypeChecker_Common.relation);
                            FStar_TypeChecker_Common.rhs = t21;
                            FStar_TypeChecker_Common.element =
                              (uu___3014_21637.FStar_TypeChecker_Common.element);
                            FStar_TypeChecker_Common.logical_guard =
                              (uu___3014_21637.FStar_TypeChecker_Common.logical_guard);
                            FStar_TypeChecker_Common.logical_guard_uvar =
                              (uu___3014_21637.FStar_TypeChecker_Common.logical_guard_uvar);
                            FStar_TypeChecker_Common.reason =
                              (uu___3014_21637.FStar_TypeChecker_Common.reason);
                            FStar_TypeChecker_Common.loc =
                              (uu___3014_21637.FStar_TypeChecker_Common.loc);
                            FStar_TypeChecker_Common.rank =
                              (uu___3014_21637.FStar_TypeChecker_Common.rank)
                          }) wl
                   | (FStar_Util.Inl t_abs,FStar_Util.Inr not_abs) ->
                       let uu____21658 =
                         (is_flex not_abs) &&
                           ((p_rel orig) = FStar_TypeChecker_Common.EQ)
                          in
                       if uu____21658
                       then
                         let uu____21661 = destruct_flex_t not_abs wl  in
                         (match uu____21661 with
                          | (flex,wl1) ->
                              solve_t_flex_rigid_eq env orig wl1 flex t_abs)
                       else
                         (let t11 = force_eta t1  in
                          let t21 = force_eta t2  in
                          if (is_abs t11) && (is_abs t21)
                          then
                            solve_t env
                              (let uu___3031_21678 = problem  in
                               {
                                 FStar_TypeChecker_Common.pid =
                                   (uu___3031_21678.FStar_TypeChecker_Common.pid);
                                 FStar_TypeChecker_Common.lhs = t11;
                                 FStar_TypeChecker_Common.relation =
                                   (uu___3031_21678.FStar_TypeChecker_Common.relation);
                                 FStar_TypeChecker_Common.rhs = t21;
                                 FStar_TypeChecker_Common.element =
                                   (uu___3031_21678.FStar_TypeChecker_Common.element);
                                 FStar_TypeChecker_Common.logical_guard =
                                   (uu___3031_21678.FStar_TypeChecker_Common.logical_guard);
                                 FStar_TypeChecker_Common.logical_guard_uvar
                                   =
                                   (uu___3031_21678.FStar_TypeChecker_Common.logical_guard_uvar);
                                 FStar_TypeChecker_Common.reason =
                                   (uu___3031_21678.FStar_TypeChecker_Common.reason);
                                 FStar_TypeChecker_Common.loc =
                                   (uu___3031_21678.FStar_TypeChecker_Common.loc);
                                 FStar_TypeChecker_Common.rank =
                                   (uu___3031_21678.FStar_TypeChecker_Common.rank)
                               }) wl
                          else
                            (let uu____21681 =
                               FStar_Thunk.mkv
                                 "head tag mismatch: RHS is an abstraction"
                                in
                             giveup env uu____21681 orig))
                   | (FStar_Util.Inr not_abs,FStar_Util.Inl t_abs) ->
                       let uu____21704 =
                         (is_flex not_abs) &&
                           ((p_rel orig) = FStar_TypeChecker_Common.EQ)
                          in
                       if uu____21704
                       then
                         let uu____21707 = destruct_flex_t not_abs wl  in
                         (match uu____21707 with
                          | (flex,wl1) ->
                              solve_t_flex_rigid_eq env orig wl1 flex t_abs)
                       else
                         (let t11 = force_eta t1  in
                          let t21 = force_eta t2  in
                          if (is_abs t11) && (is_abs t21)
                          then
                            solve_t env
                              (let uu___3031_21724 = problem  in
                               {
                                 FStar_TypeChecker_Common.pid =
                                   (uu___3031_21724.FStar_TypeChecker_Common.pid);
                                 FStar_TypeChecker_Common.lhs = t11;
                                 FStar_TypeChecker_Common.relation =
                                   (uu___3031_21724.FStar_TypeChecker_Common.relation);
                                 FStar_TypeChecker_Common.rhs = t21;
                                 FStar_TypeChecker_Common.element =
                                   (uu___3031_21724.FStar_TypeChecker_Common.element);
                                 FStar_TypeChecker_Common.logical_guard =
                                   (uu___3031_21724.FStar_TypeChecker_Common.logical_guard);
                                 FStar_TypeChecker_Common.logical_guard_uvar
                                   =
                                   (uu___3031_21724.FStar_TypeChecker_Common.logical_guard_uvar);
                                 FStar_TypeChecker_Common.reason =
                                   (uu___3031_21724.FStar_TypeChecker_Common.reason);
                                 FStar_TypeChecker_Common.loc =
                                   (uu___3031_21724.FStar_TypeChecker_Common.loc);
                                 FStar_TypeChecker_Common.rank =
                                   (uu___3031_21724.FStar_TypeChecker_Common.rank)
                               }) wl
                          else
                            (let uu____21727 =
                               FStar_Thunk.mkv
                                 "head tag mismatch: RHS is an abstraction"
                                in
                             giveup env uu____21727 orig))
                   | uu____21730 ->
                       failwith
                         "Impossible: at least one side is an abstraction")
              | (FStar_Syntax_Syntax.Tm_refine
                 (x1,phi1),FStar_Syntax_Syntax.Tm_refine (x2,phi2)) ->
                  let uu____21760 =
                    let uu____21765 =
                      head_matches_delta env wl x1.FStar_Syntax_Syntax.sort
                        x2.FStar_Syntax_Syntax.sort
                       in
                    match uu____21765 with
                    | (FullMatch ,FStar_Pervasives_Native.Some (t11,t21)) ->
                        ((let uu___3054_21793 = x1  in
                          {
                            FStar_Syntax_Syntax.ppname =
                              (uu___3054_21793.FStar_Syntax_Syntax.ppname);
                            FStar_Syntax_Syntax.index =
                              (uu___3054_21793.FStar_Syntax_Syntax.index);
                            FStar_Syntax_Syntax.sort = t11
                          }),
                          (let uu___3056_21795 = x2  in
                           {
                             FStar_Syntax_Syntax.ppname =
                               (uu___3056_21795.FStar_Syntax_Syntax.ppname);
                             FStar_Syntax_Syntax.index =
                               (uu___3056_21795.FStar_Syntax_Syntax.index);
                             FStar_Syntax_Syntax.sort = t21
                           }))
                    | (HeadMatch uu____21796,FStar_Pervasives_Native.Some
                       (t11,t21)) ->
                        ((let uu___3054_21811 = x1  in
                          {
                            FStar_Syntax_Syntax.ppname =
                              (uu___3054_21811.FStar_Syntax_Syntax.ppname);
                            FStar_Syntax_Syntax.index =
                              (uu___3054_21811.FStar_Syntax_Syntax.index);
                            FStar_Syntax_Syntax.sort = t11
                          }),
                          (let uu___3056_21813 = x2  in
                           {
                             FStar_Syntax_Syntax.ppname =
                               (uu___3056_21813.FStar_Syntax_Syntax.ppname);
                             FStar_Syntax_Syntax.index =
                               (uu___3056_21813.FStar_Syntax_Syntax.index);
                             FStar_Syntax_Syntax.sort = t21
                           }))
                    | uu____21814 -> (x1, x2)  in
                  (match uu____21760 with
                   | (x11,x21) ->
                       let t11 = FStar_Syntax_Util.refine x11 phi1  in
                       let t21 = FStar_Syntax_Util.refine x21 phi2  in
                       let uu____21833 = as_refinement false env t11  in
                       (match uu____21833 with
                        | (x12,phi11) ->
                            let uu____21841 = as_refinement false env t21  in
                            (match uu____21841 with
                             | (x22,phi21) ->
                                 ((let uu____21850 =
                                     FStar_TypeChecker_Env.debug env
                                       (FStar_Options.Other "Rel")
                                      in
                                   if uu____21850
                                   then
                                     ((let uu____21855 =
                                         FStar_Syntax_Print.bv_to_string x12
                                          in
                                       let uu____21857 =
                                         FStar_Syntax_Print.term_to_string
                                           x12.FStar_Syntax_Syntax.sort
                                          in
                                       let uu____21859 =
                                         FStar_Syntax_Print.term_to_string
                                           phi11
                                          in
                                       FStar_Util.print3
                                         "ref1 = (%s):(%s){%s}\n" uu____21855
                                         uu____21857 uu____21859);
                                      (let uu____21862 =
                                         FStar_Syntax_Print.bv_to_string x22
                                          in
                                       let uu____21864 =
                                         FStar_Syntax_Print.term_to_string
                                           x22.FStar_Syntax_Syntax.sort
                                          in
                                       let uu____21866 =
                                         FStar_Syntax_Print.term_to_string
                                           phi21
                                          in
                                       FStar_Util.print3
                                         "ref2 = (%s):(%s){%s}\n" uu____21862
                                         uu____21864 uu____21866))
                                   else ());
                                  (let uu____21871 =
                                     mk_t_problem wl [] orig
                                       x12.FStar_Syntax_Syntax.sort
                                       problem.FStar_TypeChecker_Common.relation
                                       x22.FStar_Syntax_Syntax.sort
                                       problem.FStar_TypeChecker_Common.element
                                       "refinement base type"
                                      in
                                   match uu____21871 with
                                   | (base_prob,wl1) ->
                                       let x13 =
                                         FStar_Syntax_Syntax.freshen_bv x12
                                          in
                                       let subst1 =
                                         [FStar_Syntax_Syntax.DB
                                            (Prims.int_zero, x13)]
                                          in
                                       let phi12 =
                                         FStar_Syntax_Subst.subst subst1
                                           phi11
                                          in
                                       let phi22 =
                                         FStar_Syntax_Subst.subst subst1
                                           phi21
                                          in
                                       let env1 =
                                         FStar_TypeChecker_Env.push_bv env
                                           x13
                                          in
                                       let mk_imp1 imp phi13 phi23 =
                                         let uu____21942 = imp phi13 phi23
                                            in
                                         FStar_All.pipe_right uu____21942
                                           (guard_on_element wl1 problem x13)
                                          in
                                       let fallback uu____21954 =
                                         let impl =
                                           if
                                             problem.FStar_TypeChecker_Common.relation
                                               = FStar_TypeChecker_Common.EQ
                                           then
                                             mk_imp1 FStar_Syntax_Util.mk_iff
                                               phi12 phi22
                                           else
                                             mk_imp1 FStar_Syntax_Util.mk_imp
                                               phi12 phi22
                                            in
                                         let guard =
                                           FStar_Syntax_Util.mk_conj
                                             (p_guard base_prob) impl
                                            in
                                         (let uu____21967 =
                                            let uu____21970 = p_scope orig
                                               in
                                            FStar_List.map
                                              FStar_Pervasives_Native.fst
                                              uu____21970
                                             in
                                          FStar_TypeChecker_Env.def_check_closed_in
                                            (p_loc orig) "ref.1" uu____21967
                                            (p_guard base_prob));
                                         (let uu____21989 =
                                            let uu____21992 = p_scope orig
                                               in
                                            FStar_List.map
                                              FStar_Pervasives_Native.fst
                                              uu____21992
                                             in
                                          FStar_TypeChecker_Env.def_check_closed_in
                                            (p_loc orig) "ref.2" uu____21989
                                            impl);
                                         (let wl2 =
                                            solve_prob orig
                                              (FStar_Pervasives_Native.Some
                                                 guard) [] wl1
                                             in
                                          let uu____22011 =
                                            attempt [base_prob] wl2  in
                                          solve env1 uu____22011)
                                          in
                                       let has_uvars =
                                         (let uu____22016 =
                                            let uu____22018 =
                                              FStar_Syntax_Free.uvars phi12
                                               in
                                            FStar_Util.set_is_empty
                                              uu____22018
                                             in
                                          Prims.op_Negation uu____22016) ||
                                           (let uu____22022 =
                                              let uu____22024 =
                                                FStar_Syntax_Free.uvars phi22
                                                 in
                                              FStar_Util.set_is_empty
                                                uu____22024
                                               in
                                            Prims.op_Negation uu____22022)
                                          in
                                       if
                                         (problem.FStar_TypeChecker_Common.relation
                                            = FStar_TypeChecker_Common.EQ)
                                           ||
                                           ((Prims.op_Negation
                                               env1.FStar_TypeChecker_Env.uvar_subtyping)
                                              && has_uvars)
                                       then
                                         let uu____22028 =
                                           let uu____22033 =
                                             let uu____22042 =
                                               FStar_Syntax_Syntax.mk_binder
                                                 x13
                                                in
                                             [uu____22042]  in
                                           mk_t_problem wl1 uu____22033 orig
                                             phi12
                                             FStar_TypeChecker_Common.EQ
                                             phi22
                                             FStar_Pervasives_Native.None
                                             "refinement formula"
                                            in
                                         (match uu____22028 with
                                          | (ref_prob,wl2) ->
                                              let tx =
                                                FStar_Syntax_Unionfind.new_transaction
                                                  ()
                                                 in
                                              let uu____22065 =
                                                solve env1
                                                  (let uu___3099_22067 = wl2
                                                      in
                                                   {
                                                     attempting = [ref_prob];
                                                     wl_deferred = [];
                                                     ctr =
                                                       (uu___3099_22067.ctr);
                                                     defer_ok = false;
                                                     smt_ok =
                                                       (uu___3099_22067.smt_ok);
                                                     umax_heuristic_ok =
                                                       (uu___3099_22067.umax_heuristic_ok);
                                                     tcenv =
                                                       (uu___3099_22067.tcenv);
                                                     wl_implicits =
                                                       (uu___3099_22067.wl_implicits)
                                                   })
                                                 in
                                              (match uu____22065 with
                                               | Failed (prob,msg) ->
                                                   (FStar_Syntax_Unionfind.rollback
                                                      tx;
                                                    if
                                                      ((Prims.op_Negation
                                                          env1.FStar_TypeChecker_Env.uvar_subtyping)
                                                         && has_uvars)
                                                        ||
                                                        (Prims.op_Negation
                                                           wl2.smt_ok)
                                                    then giveup env1 msg prob
                                                    else fallback ())
                                               | Success uu____22082 ->
                                                   (FStar_Syntax_Unionfind.commit
                                                      tx;
                                                    (let guard =
                                                       let uu____22091 =
                                                         FStar_All.pipe_right
                                                           (p_guard ref_prob)
                                                           (guard_on_element
                                                              wl2 problem x13)
                                                          in
                                                       FStar_Syntax_Util.mk_conj
                                                         (p_guard base_prob)
                                                         uu____22091
                                                        in
                                                     let wl3 =
                                                       solve_prob orig
                                                         (FStar_Pervasives_Native.Some
                                                            guard) [] wl2
                                                        in
                                                     let wl4 =
                                                       let uu___3112_22100 =
                                                         wl3  in
                                                       {
                                                         attempting =
                                                           (uu___3112_22100.attempting);
                                                         wl_deferred =
                                                           (uu___3112_22100.wl_deferred);
                                                         ctr =
                                                           (wl3.ctr +
                                                              Prims.int_one);
                                                         defer_ok =
                                                           (uu___3112_22100.defer_ok);
                                                         smt_ok =
                                                           (uu___3112_22100.smt_ok);
                                                         umax_heuristic_ok =
                                                           (uu___3112_22100.umax_heuristic_ok);
                                                         tcenv =
                                                           (uu___3112_22100.tcenv);
                                                         wl_implicits =
                                                           (uu___3112_22100.wl_implicits)
                                                       }  in
                                                     let uu____22102 =
                                                       attempt [base_prob]
                                                         wl4
                                                        in
                                                     solve env1 uu____22102))))
                                       else fallback ())))))
              | (FStar_Syntax_Syntax.Tm_uvar
                 uu____22105,FStar_Syntax_Syntax.Tm_uvar uu____22106) ->
                  let uu____22131 = destruct_flex_t t1 wl  in
                  (match uu____22131 with
                   | (f1,wl1) ->
                       let uu____22138 = destruct_flex_t t2 wl1  in
                       (match uu____22138 with
                        | (f2,wl2) -> solve_t_flex_flex env orig wl2 f1 f2))
              | (FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22145;
                    FStar_Syntax_Syntax.pos = uu____22146;
                    FStar_Syntax_Syntax.vars = uu____22147;_},uu____22148),FStar_Syntax_Syntax.Tm_uvar
                 uu____22149) ->
                  let uu____22198 = destruct_flex_t t1 wl  in
                  (match uu____22198 with
                   | (f1,wl1) ->
                       let uu____22205 = destruct_flex_t t2 wl1  in
                       (match uu____22205 with
                        | (f2,wl2) -> solve_t_flex_flex env orig wl2 f1 f2))
              | (FStar_Syntax_Syntax.Tm_uvar
                 uu____22212,FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22213;
                    FStar_Syntax_Syntax.pos = uu____22214;
                    FStar_Syntax_Syntax.vars = uu____22215;_},uu____22216))
                  ->
                  let uu____22265 = destruct_flex_t t1 wl  in
                  (match uu____22265 with
                   | (f1,wl1) ->
                       let uu____22272 = destruct_flex_t t2 wl1  in
                       (match uu____22272 with
                        | (f2,wl2) -> solve_t_flex_flex env orig wl2 f1 f2))
              | (FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22279;
                    FStar_Syntax_Syntax.pos = uu____22280;
                    FStar_Syntax_Syntax.vars = uu____22281;_},uu____22282),FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22283;
                    FStar_Syntax_Syntax.pos = uu____22284;
                    FStar_Syntax_Syntax.vars = uu____22285;_},uu____22286))
                  ->
                  let uu____22359 = destruct_flex_t t1 wl  in
                  (match uu____22359 with
                   | (f1,wl1) ->
                       let uu____22366 = destruct_flex_t t2 wl1  in
                       (match uu____22366 with
                        | (f2,wl2) -> solve_t_flex_flex env orig wl2 f1 f2))
              | (FStar_Syntax_Syntax.Tm_uvar uu____22373,uu____22374) when
                  problem.FStar_TypeChecker_Common.relation =
                    FStar_TypeChecker_Common.EQ
                  ->
                  let uu____22387 = destruct_flex_t t1 wl  in
                  (match uu____22387 with
                   | (f1,wl1) -> solve_t_flex_rigid_eq env orig wl1 f1 t2)
              | (FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22394;
                    FStar_Syntax_Syntax.pos = uu____22395;
                    FStar_Syntax_Syntax.vars = uu____22396;_},uu____22397),uu____22398)
                  when
                  problem.FStar_TypeChecker_Common.relation =
                    FStar_TypeChecker_Common.EQ
                  ->
                  let uu____22435 = destruct_flex_t t1 wl  in
                  (match uu____22435 with
                   | (f1,wl1) -> solve_t_flex_rigid_eq env orig wl1 f1 t2)
              | (uu____22442,FStar_Syntax_Syntax.Tm_uvar uu____22443) when
                  problem.FStar_TypeChecker_Common.relation =
                    FStar_TypeChecker_Common.EQ
                  -> solve_t env (invert problem) wl
              | (uu____22456,FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22457;
                    FStar_Syntax_Syntax.pos = uu____22458;
                    FStar_Syntax_Syntax.vars = uu____22459;_},uu____22460))
                  when
                  problem.FStar_TypeChecker_Common.relation =
                    FStar_TypeChecker_Common.EQ
                  -> solve_t env (invert problem) wl
              | (FStar_Syntax_Syntax.Tm_uvar
                 uu____22497,FStar_Syntax_Syntax.Tm_arrow uu____22498) ->
                  solve_t' env
                    (let uu___3212_22526 = problem  in
                     {
                       FStar_TypeChecker_Common.pid =
                         (uu___3212_22526.FStar_TypeChecker_Common.pid);
                       FStar_TypeChecker_Common.lhs =
                         (uu___3212_22526.FStar_TypeChecker_Common.lhs);
                       FStar_TypeChecker_Common.relation =
                         FStar_TypeChecker_Common.EQ;
                       FStar_TypeChecker_Common.rhs =
                         (uu___3212_22526.FStar_TypeChecker_Common.rhs);
                       FStar_TypeChecker_Common.element =
                         (uu___3212_22526.FStar_TypeChecker_Common.element);
                       FStar_TypeChecker_Common.logical_guard =
                         (uu___3212_22526.FStar_TypeChecker_Common.logical_guard);
                       FStar_TypeChecker_Common.logical_guard_uvar =
                         (uu___3212_22526.FStar_TypeChecker_Common.logical_guard_uvar);
                       FStar_TypeChecker_Common.reason =
                         (uu___3212_22526.FStar_TypeChecker_Common.reason);
                       FStar_TypeChecker_Common.loc =
                         (uu___3212_22526.FStar_TypeChecker_Common.loc);
                       FStar_TypeChecker_Common.rank =
                         (uu___3212_22526.FStar_TypeChecker_Common.rank)
                     }) wl
              | (FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22527;
                    FStar_Syntax_Syntax.pos = uu____22528;
                    FStar_Syntax_Syntax.vars = uu____22529;_},uu____22530),FStar_Syntax_Syntax.Tm_arrow
                 uu____22531) ->
                  solve_t' env
                    (let uu___3212_22583 = problem  in
                     {
                       FStar_TypeChecker_Common.pid =
                         (uu___3212_22583.FStar_TypeChecker_Common.pid);
                       FStar_TypeChecker_Common.lhs =
                         (uu___3212_22583.FStar_TypeChecker_Common.lhs);
                       FStar_TypeChecker_Common.relation =
                         FStar_TypeChecker_Common.EQ;
                       FStar_TypeChecker_Common.rhs =
                         (uu___3212_22583.FStar_TypeChecker_Common.rhs);
                       FStar_TypeChecker_Common.element =
                         (uu___3212_22583.FStar_TypeChecker_Common.element);
                       FStar_TypeChecker_Common.logical_guard =
                         (uu___3212_22583.FStar_TypeChecker_Common.logical_guard);
                       FStar_TypeChecker_Common.logical_guard_uvar =
                         (uu___3212_22583.FStar_TypeChecker_Common.logical_guard_uvar);
                       FStar_TypeChecker_Common.reason =
                         (uu___3212_22583.FStar_TypeChecker_Common.reason);
                       FStar_TypeChecker_Common.loc =
                         (uu___3212_22583.FStar_TypeChecker_Common.loc);
                       FStar_TypeChecker_Common.rank =
                         (uu___3212_22583.FStar_TypeChecker_Common.rank)
                     }) wl
              | (uu____22584,FStar_Syntax_Syntax.Tm_uvar uu____22585) ->
                  let uu____22598 =
                    attempt [FStar_TypeChecker_Common.TProb problem] wl  in
                  solve env uu____22598
              | (uu____22599,FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22600;
                    FStar_Syntax_Syntax.pos = uu____22601;
                    FStar_Syntax_Syntax.vars = uu____22602;_},uu____22603))
                  ->
                  let uu____22640 =
                    attempt [FStar_TypeChecker_Common.TProb problem] wl  in
                  solve env uu____22640
              | (FStar_Syntax_Syntax.Tm_uvar uu____22641,uu____22642) ->
                  let uu____22655 =
                    attempt [FStar_TypeChecker_Common.TProb problem] wl  in
                  solve env uu____22655
              | (FStar_Syntax_Syntax.Tm_app
                 ({
                    FStar_Syntax_Syntax.n = FStar_Syntax_Syntax.Tm_uvar
                      uu____22656;
                    FStar_Syntax_Syntax.pos = uu____22657;
                    FStar_Syntax_Syntax.vars = uu____22658;_},uu____22659),uu____22660)
                  ->
                  let uu____22697 =
                    attempt [FStar_TypeChecker_Common.TProb problem] wl  in
                  solve env uu____22697
              | (FStar_Syntax_Syntax.Tm_refine uu____22698,uu____22699) ->
                  let t21 =
                    let uu____22707 = base_and_refinement env t2  in
                    FStar_All.pipe_left force_refinement uu____22707  in
                  solve_t env
                    (let uu___3247_22733 = problem  in
                     {
                       FStar_TypeChecker_Common.pid =
                         (uu___3247_22733.FStar_TypeChecker_Common.pid);
                       FStar_TypeChecker_Common.lhs =
                         (uu___3247_22733.FStar_TypeChecker_Common.lhs);
                       FStar_TypeChecker_Common.relation =
                         (uu___3247_22733.FStar_TypeChecker_Common.relation);
                       FStar_TypeChecker_Common.rhs = t21;
                       FStar_TypeChecker_Common.element =
                         (uu___3247_22733.FStar_TypeChecker_Common.element);
                       FStar_TypeChecker_Common.logical_guard =
                         (uu___3247_22733.FStar_TypeChecker_Common.logical_guard);
                       FStar_TypeChecker_Common.logical_guard_uvar =
                         (uu___3247_22733.FStar_TypeChecker_Common.logical_guard_uvar);
                       FStar_TypeChecker_Common.reason =
                         (uu___3247_22733.FStar_TypeChecker_Common.reason);
                       FStar_TypeChecker_Common.loc =
                         (uu___3247_22733.FStar_TypeChecker_Common.loc);
                       FStar_TypeChecker_Common.rank =
                         (uu___3247_22733.FStar_TypeChecker_Common.rank)
                     }) wl
              | (uu____22734,FStar_Syntax_Syntax.Tm_refine uu____22735) ->
                  let t11 =
                    let uu____22743 = base_and_refinement env t1  in
                    FStar_All.pipe_left force_refinement uu____22743  in
                  solve_t env
                    (let uu___3254_22769 = problem  in
                     {
                       FStar_TypeChecker_Common.pid =
                         (uu___3254_22769.FStar_TypeChecker_Common.pid);
                       FStar_TypeChecker_Common.lhs = t11;
                       FStar_TypeChecker_Common.relation =
                         (uu___3254_22769.FStar_TypeChecker_Common.relation);
                       FStar_TypeChecker_Common.rhs =
                         (uu___3254_22769.FStar_TypeChecker_Common.rhs);
                       FStar_TypeChecker_Common.element =
                         (uu___3254_22769.FStar_TypeChecker_Common.element);
                       FStar_TypeChecker_Common.logical_guard =
                         (uu___3254_22769.FStar_TypeChecker_Common.logical_guard);
                       FStar_TypeChecker_Common.logical_guard_uvar =
                         (uu___3254_22769.FStar_TypeChecker_Common.logical_guard_uvar);
                       FStar_TypeChecker_Common.reason =
                         (uu___3254_22769.FStar_TypeChecker_Common.reason);
                       FStar_TypeChecker_Common.loc =
                         (uu___3254_22769.FStar_TypeChecker_Common.loc);
                       FStar_TypeChecker_Common.rank =
                         (uu___3254_22769.FStar_TypeChecker_Common.rank)
                     }) wl
              | (FStar_Syntax_Syntax.Tm_match
                 (s1,brs1),FStar_Syntax_Syntax.Tm_match (s2,brs2)) ->
                  let by_smt uu____22851 =
                    let uu____22852 = guard_of_prob env wl problem t1 t2  in
                    match uu____22852 with
                    | (guard,wl1) ->
                        let uu____22859 =
                          solve_prob orig
                            (FStar_Pervasives_Native.Some guard) [] wl1
                           in
                        solve env uu____22859
                     in
                  let rec solve_branches wl1 brs11 brs21 =
                    match (brs11, brs21) with
                    | (br1::rs1,br2::rs2) ->
                        let uu____23078 = br1  in
                        (match uu____23078 with
                         | (p1,w1,uu____23107) ->
                             let uu____23124 = br2  in
                             (match uu____23124 with
                              | (p2,w2,uu____23147) ->
                                  let uu____23152 =
                                    let uu____23154 =
                                      FStar_Syntax_Syntax.eq_pat p1 p2  in
                                    Prims.op_Negation uu____23154  in
                                  if uu____23152
                                  then FStar_Pervasives_Native.None
                                  else
                                    (let uu____23181 =
                                       FStar_Syntax_Subst.open_branch' br1
                                        in
                                     match uu____23181 with
                                     | ((p11,w11,e1),s) ->
                                         let uu____23218 = br2  in
                                         (match uu____23218 with
                                          | (p21,w21,e2) ->
                                              let w22 =
                                                FStar_Util.map_opt w21
                                                  (FStar_Syntax_Subst.subst s)
                                                 in
                                              let e21 =
                                                FStar_Syntax_Subst.subst s e2
                                                 in
                                              let scope =
                                                let uu____23251 =
                                                  FStar_Syntax_Syntax.pat_bvs
                                                    p11
                                                   in
                                                FStar_All.pipe_left
                                                  (FStar_List.map
                                                     FStar_Syntax_Syntax.mk_binder)
                                                  uu____23251
                                                 in
                                              let uu____23256 =
                                                match (w11, w22) with
                                                | (FStar_Pervasives_Native.Some
                                                   uu____23287,FStar_Pervasives_Native.None
                                                   ) ->
                                                    FStar_Pervasives_Native.None
                                                | (FStar_Pervasives_Native.None
                                                   ,FStar_Pervasives_Native.Some
                                                   uu____23308) ->
                                                    FStar_Pervasives_Native.None
                                                | (FStar_Pervasives_Native.None
                                                   ,FStar_Pervasives_Native.None
                                                   ) ->
                                                    FStar_Pervasives_Native.Some
                                                      ([], wl1)
                                                | (FStar_Pervasives_Native.Some
                                                   w12,FStar_Pervasives_Native.Some
                                                   w23) ->
                                                    let uu____23367 =
                                                      mk_t_problem wl1 scope
                                                        orig w12
                                                        FStar_TypeChecker_Common.EQ
                                                        w23
                                                        FStar_Pervasives_Native.None
                                                        "when clause"
                                                       in
                                                    (match uu____23367 with
                                                     | (p,wl2) ->
                                                         FStar_Pervasives_Native.Some
                                                           ([(scope, p)],
                                                             wl2))
                                                 in
                                              FStar_Util.bind_opt uu____23256
                                                (fun uu____23439  ->
                                                   match uu____23439 with
                                                   | (wprobs,wl2) ->
                                                       let uu____23476 =
                                                         mk_t_problem wl2
                                                           scope orig e1
                                                           FStar_TypeChecker_Common.EQ
                                                           e21
                                                           FStar_Pervasives_Native.None
                                                           "branch body"
                                                          in
                                                       (match uu____23476
                                                        with
                                                        | (prob,wl3) ->
                                                            ((let uu____23497
                                                                =
                                                                FStar_All.pipe_left
                                                                  (FStar_TypeChecker_Env.debug
                                                                    wl3.tcenv)
                                                                  (FStar_Options.Other
                                                                    "Rel")
                                                                 in
                                                              if uu____23497
                                                              then
                                                                let uu____23502
                                                                  =
                                                                  prob_to_string
                                                                    env prob
                                                                   in
                                                                let uu____23504
                                                                  =
                                                                  FStar_Syntax_Print.binders_to_string
                                                                    ", "
                                                                    scope
                                                                   in
                                                                FStar_Util.print2
                                                                  "Created problem for branches %s with scope %s\n"
                                                                  uu____23502
                                                                  uu____23504
                                                              else ());
                                                             (let uu____23510
                                                                =
                                                                solve_branches
                                                                  wl3 rs1 rs2
                                                                 in
                                                              FStar_Util.bind_opt
                                                                uu____23510
                                                                (fun
                                                                   uu____23546
                                                                    ->
                                                                   match uu____23546
                                                                   with
                                                                   | 
                                                                   (r1,wl4)
                                                                    ->
                                                                    FStar_Pervasives_Native.Some
                                                                    (((scope,
                                                                    prob) ::
                                                                    (FStar_List.append
                                                                    wprobs r1)),
                                                                    wl4))))))))))
                    | ([],[]) -> FStar_Pervasives_Native.Some ([], wl1)
                    | uu____23675 -> FStar_Pervasives_Native.None  in
                  let uu____23716 = solve_branches wl brs1 brs2  in
                  (match uu____23716 with
                   | FStar_Pervasives_Native.None  ->
                       if wl.smt_ok
                       then by_smt ()
                       else
                         (let uu____23742 =
                            FStar_Thunk.mkv "Tm_match branches don't match"
                             in
                          giveup env uu____23742 orig)
                   | FStar_Pervasives_Native.Some (sub_probs,wl1) ->
                       let uu____23769 =
                         mk_t_problem wl1 [] orig s1
                           FStar_TypeChecker_Common.EQ s2
                           FStar_Pervasives_Native.None "match scrutinee"
                          in
                       (match uu____23769 with
                        | (sc_prob,wl2) ->
                            let sub_probs1 = ([], sc_prob) :: sub_probs  in
                            let formula =
                              let uu____23803 =
                                FStar_List.map
                                  (fun uu____23815  ->
                                     match uu____23815 with
                                     | (scope,p) ->
                                         FStar_TypeChecker_Env.close_forall
                                           wl2.tcenv scope (p_guard p))
                                  sub_probs1
                                 in
                              FStar_Syntax_Util.mk_conj_l uu____23803  in
                            let tx =
                              FStar_Syntax_Unionfind.new_transaction ()  in
                            let wl3 =
                              solve_prob orig
                                (FStar_Pervasives_Native.Some formula) [] wl2
                               in
                            let uu____23824 =
                              let uu____23825 =
                                let uu____23826 =
                                  FStar_List.map FStar_Pervasives_Native.snd
                                    sub_probs1
                                   in
                                attempt uu____23826
                                  (let uu___3353_23834 = wl3  in
                                   {
                                     attempting =
                                       (uu___3353_23834.attempting);
                                     wl_deferred =
                                       (uu___3353_23834.wl_deferred);
                                     ctr = (uu___3353_23834.ctr);
                                     defer_ok = (uu___3353_23834.defer_ok);
                                     smt_ok = false;
                                     umax_heuristic_ok =
                                       (uu___3353_23834.umax_heuristic_ok);
                                     tcenv = (uu___3353_23834.tcenv);
                                     wl_implicits =
                                       (uu___3353_23834.wl_implicits)
                                   })
                                 in
                              solve env uu____23825  in
                            (match uu____23824 with
                             | Success (ds,imp) ->
                                 (FStar_Syntax_Unionfind.commit tx;
                                  Success (ds, imp))
                             | Failed uu____23839 ->
                                 (FStar_Syntax_Unionfind.rollback tx;
                                  if wl3.smt_ok
                                  then by_smt ()
                                  else
                                    (let uu____23848 =
                                       FStar_Thunk.mkv
                                         "Could not unify matches without SMT"
                                        in
                                     giveup env uu____23848 orig)))))
              | (FStar_Syntax_Syntax.Tm_match uu____23851,uu____23852) ->
                  let head1 =
                    let uu____23876 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____23876
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____23922 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____23922
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____23968 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____23968
                    then
                      let uu____23972 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____23974 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____23976 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____23972 uu____23974 uu____23976
                    else ());
                   (let no_free_uvars t =
                      (let uu____23990 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____23990) &&
                        (let uu____23994 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____23994)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____24013 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____24013 = FStar_Syntax_Util.Equal  in
                    let uu____24014 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____24014
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____24018 = equal t1 t2  in
                         (if uu____24018
                          then
                            let uu____24021 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____24021
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____24026 =
                            let uu____24033 = equal t1 t2  in
                            if uu____24033
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____24046 = mk_eq2 wl env orig t1 t2  in
                               match uu____24046 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____24026 with
                          | (guard,wl1) ->
                              let uu____24067 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____24067))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (FStar_Syntax_Syntax.Tm_uinst uu____24070,uu____24071) ->
                  let head1 =
                    let uu____24079 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____24079
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____24125 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____24125
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____24171 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____24171
                    then
                      let uu____24175 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____24177 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____24179 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____24175 uu____24177 uu____24179
                    else ());
                   (let no_free_uvars t =
                      (let uu____24193 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____24193) &&
                        (let uu____24197 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____24197)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____24216 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____24216 = FStar_Syntax_Util.Equal  in
                    let uu____24217 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____24217
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____24221 = equal t1 t2  in
                         (if uu____24221
                          then
                            let uu____24224 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____24224
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____24229 =
                            let uu____24236 = equal t1 t2  in
                            if uu____24236
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____24249 = mk_eq2 wl env orig t1 t2  in
                               match uu____24249 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____24229 with
                          | (guard,wl1) ->
                              let uu____24270 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____24270))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (FStar_Syntax_Syntax.Tm_name uu____24273,uu____24274) ->
                  let head1 =
                    let uu____24276 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____24276
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____24322 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____24322
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____24368 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____24368
                    then
                      let uu____24372 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____24374 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____24376 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____24372 uu____24374 uu____24376
                    else ());
                   (let no_free_uvars t =
                      (let uu____24390 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____24390) &&
                        (let uu____24394 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____24394)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____24413 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____24413 = FStar_Syntax_Util.Equal  in
                    let uu____24414 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____24414
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____24418 = equal t1 t2  in
                         (if uu____24418
                          then
                            let uu____24421 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____24421
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____24426 =
                            let uu____24433 = equal t1 t2  in
                            if uu____24433
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____24446 = mk_eq2 wl env orig t1 t2  in
                               match uu____24446 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____24426 with
                          | (guard,wl1) ->
                              let uu____24467 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____24467))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (FStar_Syntax_Syntax.Tm_constant uu____24470,uu____24471) ->
                  let head1 =
                    let uu____24473 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____24473
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____24519 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____24519
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____24565 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____24565
                    then
                      let uu____24569 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____24571 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____24573 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____24569 uu____24571 uu____24573
                    else ());
                   (let no_free_uvars t =
                      (let uu____24587 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____24587) &&
                        (let uu____24591 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____24591)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____24610 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____24610 = FStar_Syntax_Util.Equal  in
                    let uu____24611 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____24611
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____24615 = equal t1 t2  in
                         (if uu____24615
                          then
                            let uu____24618 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____24618
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____24623 =
                            let uu____24630 = equal t1 t2  in
                            if uu____24630
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____24643 = mk_eq2 wl env orig t1 t2  in
                               match uu____24643 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____24623 with
                          | (guard,wl1) ->
                              let uu____24664 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____24664))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (FStar_Syntax_Syntax.Tm_fvar uu____24667,uu____24668) ->
                  let head1 =
                    let uu____24670 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____24670
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____24716 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____24716
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____24762 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____24762
                    then
                      let uu____24766 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____24768 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____24770 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____24766 uu____24768 uu____24770
                    else ());
                   (let no_free_uvars t =
                      (let uu____24784 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____24784) &&
                        (let uu____24788 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____24788)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____24807 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____24807 = FStar_Syntax_Util.Equal  in
                    let uu____24808 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____24808
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____24812 = equal t1 t2  in
                         (if uu____24812
                          then
                            let uu____24815 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____24815
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____24820 =
                            let uu____24827 = equal t1 t2  in
                            if uu____24827
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____24840 = mk_eq2 wl env orig t1 t2  in
                               match uu____24840 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____24820 with
                          | (guard,wl1) ->
                              let uu____24861 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____24861))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (FStar_Syntax_Syntax.Tm_app uu____24864,uu____24865) ->
                  let head1 =
                    let uu____24883 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____24883
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____24929 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____24929
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____24975 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____24975
                    then
                      let uu____24979 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____24981 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____24983 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____24979 uu____24981 uu____24983
                    else ());
                   (let no_free_uvars t =
                      (let uu____24997 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____24997) &&
                        (let uu____25001 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____25001)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____25020 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____25020 = FStar_Syntax_Util.Equal  in
                    let uu____25021 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____25021
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____25025 = equal t1 t2  in
                         (if uu____25025
                          then
                            let uu____25028 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____25028
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____25033 =
                            let uu____25040 = equal t1 t2  in
                            if uu____25040
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____25053 = mk_eq2 wl env orig t1 t2  in
                               match uu____25053 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____25033 with
                          | (guard,wl1) ->
                              let uu____25074 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____25074))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (uu____25077,FStar_Syntax_Syntax.Tm_match uu____25078) ->
                  let head1 =
                    let uu____25102 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____25102
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____25148 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____25148
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____25194 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____25194
                    then
                      let uu____25198 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____25200 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____25202 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____25198 uu____25200 uu____25202
                    else ());
                   (let no_free_uvars t =
                      (let uu____25216 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____25216) &&
                        (let uu____25220 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____25220)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____25239 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____25239 = FStar_Syntax_Util.Equal  in
                    let uu____25240 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____25240
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____25244 = equal t1 t2  in
                         (if uu____25244
                          then
                            let uu____25247 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____25247
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____25252 =
                            let uu____25259 = equal t1 t2  in
                            if uu____25259
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____25272 = mk_eq2 wl env orig t1 t2  in
                               match uu____25272 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____25252 with
                          | (guard,wl1) ->
                              let uu____25293 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____25293))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (uu____25296,FStar_Syntax_Syntax.Tm_uinst uu____25297) ->
                  let head1 =
                    let uu____25305 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____25305
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____25351 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____25351
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____25397 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____25397
                    then
                      let uu____25401 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____25403 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____25405 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____25401 uu____25403 uu____25405
                    else ());
                   (let no_free_uvars t =
                      (let uu____25419 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____25419) &&
                        (let uu____25423 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____25423)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____25442 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____25442 = FStar_Syntax_Util.Equal  in
                    let uu____25443 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____25443
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____25447 = equal t1 t2  in
                         (if uu____25447
                          then
                            let uu____25450 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____25450
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____25455 =
                            let uu____25462 = equal t1 t2  in
                            if uu____25462
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____25475 = mk_eq2 wl env orig t1 t2  in
                               match uu____25475 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____25455 with
                          | (guard,wl1) ->
                              let uu____25496 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____25496))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (uu____25499,FStar_Syntax_Syntax.Tm_name uu____25500) ->
                  let head1 =
                    let uu____25502 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____25502
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____25548 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____25548
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____25588 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____25588
                    then
                      let uu____25592 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____25594 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____25596 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____25592 uu____25594 uu____25596
                    else ());
                   (let no_free_uvars t =
                      (let uu____25610 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____25610) &&
                        (let uu____25614 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____25614)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____25633 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____25633 = FStar_Syntax_Util.Equal  in
                    let uu____25634 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____25634
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____25638 = equal t1 t2  in
                         (if uu____25638
                          then
                            let uu____25641 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____25641
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____25646 =
                            let uu____25653 = equal t1 t2  in
                            if uu____25653
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____25666 = mk_eq2 wl env orig t1 t2  in
                               match uu____25666 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____25646 with
                          | (guard,wl1) ->
                              let uu____25687 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____25687))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (uu____25690,FStar_Syntax_Syntax.Tm_constant uu____25691) ->
                  let head1 =
                    let uu____25693 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____25693
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____25733 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____25733
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____25773 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____25773
                    then
                      let uu____25777 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____25779 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____25781 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____25777 uu____25779 uu____25781
                    else ());
                   (let no_free_uvars t =
                      (let uu____25795 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____25795) &&
                        (let uu____25799 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____25799)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____25818 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____25818 = FStar_Syntax_Util.Equal  in
                    let uu____25819 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____25819
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____25823 = equal t1 t2  in
                         (if uu____25823
                          then
                            let uu____25826 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____25826
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____25831 =
                            let uu____25838 = equal t1 t2  in
                            if uu____25838
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____25851 = mk_eq2 wl env orig t1 t2  in
                               match uu____25851 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____25831 with
                          | (guard,wl1) ->
                              let uu____25872 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____25872))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (uu____25875,FStar_Syntax_Syntax.Tm_fvar uu____25876) ->
                  let head1 =
                    let uu____25878 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____25878
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____25924 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____25924
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____25970 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____25970
                    then
                      let uu____25974 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____25976 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____25978 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____25974 uu____25976 uu____25978
                    else ());
                   (let no_free_uvars t =
                      (let uu____25992 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____25992) &&
                        (let uu____25996 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____25996)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____26015 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____26015 = FStar_Syntax_Util.Equal  in
                    let uu____26016 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____26016
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____26020 = equal t1 t2  in
                         (if uu____26020
                          then
                            let uu____26023 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____26023
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____26028 =
                            let uu____26035 = equal t1 t2  in
                            if uu____26035
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____26048 = mk_eq2 wl env orig t1 t2  in
                               match uu____26048 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____26028 with
                          | (guard,wl1) ->
                              let uu____26069 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____26069))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (uu____26072,FStar_Syntax_Syntax.Tm_app uu____26073) ->
                  let head1 =
                    let uu____26091 = FStar_Syntax_Util.head_and_args t1  in
                    FStar_All.pipe_right uu____26091
                      FStar_Pervasives_Native.fst
                     in
                  let head2 =
                    let uu____26131 = FStar_Syntax_Util.head_and_args t2  in
                    FStar_All.pipe_right uu____26131
                      FStar_Pervasives_Native.fst
                     in
                  ((let uu____26171 =
                      FStar_TypeChecker_Env.debug env
                        (FStar_Options.Other "Rel")
                       in
                    if uu____26171
                    then
                      let uu____26175 =
                        FStar_Util.string_of_int
                          problem.FStar_TypeChecker_Common.pid
                         in
                      let uu____26177 =
                        FStar_Syntax_Print.term_to_string head1  in
                      let uu____26179 =
                        FStar_Syntax_Print.term_to_string head2  in
                      FStar_Util.print3
                        ">> (%s)\n>>> head1 = %s\n>>> head2 = %s\n"
                        uu____26175 uu____26177 uu____26179
                    else ());
                   (let no_free_uvars t =
                      (let uu____26193 = FStar_Syntax_Free.uvars t  in
                       FStar_Util.set_is_empty uu____26193) &&
                        (let uu____26197 = FStar_Syntax_Free.univs t  in
                         FStar_Util.set_is_empty uu____26197)
                       in
                    let equal t11 t21 =
                      let t12 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.2"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t11
                         in
                      let t22 =
                        norm_with_steps
                          "FStar.TypeChecker.Rel.norm_with_steps.3"
                          [FStar_TypeChecker_Env.UnfoldUntil
                             FStar_Syntax_Syntax.delta_constant;
                          FStar_TypeChecker_Env.Primops;
                          FStar_TypeChecker_Env.Beta;
                          FStar_TypeChecker_Env.Eager_unfolding;
                          FStar_TypeChecker_Env.Iota] env t21
                         in
                      let uu____26216 = FStar_Syntax_Util.eq_tm t12 t22  in
                      uu____26216 = FStar_Syntax_Util.Equal  in
                    let uu____26217 =
                      ((((FStar_TypeChecker_Env.is_interpreted env head1) ||
                           (FStar_TypeChecker_Env.is_interpreted env head2))
                          &&
                          (problem.FStar_TypeChecker_Common.relation =
                             FStar_TypeChecker_Common.EQ))
                         && (no_free_uvars t1))
                        && (no_free_uvars t2)
                       in
                    if uu____26217
                    then
                      (if Prims.op_Negation wl.smt_ok
                       then
                         let uu____26221 = equal t1 t2  in
                         (if uu____26221
                          then
                            let uu____26224 =
                              solve_prob orig FStar_Pervasives_Native.None []
                                wl
                               in
                            solve env uu____26224
                          else
                            rigid_rigid_delta env problem wl head1 head2 t1
                              t2)
                       else
                         (let uu____26229 =
                            let uu____26236 = equal t1 t2  in
                            if uu____26236
                            then (FStar_Pervasives_Native.None, wl)
                            else
                              (let uu____26249 = mk_eq2 wl env orig t1 t2  in
                               match uu____26249 with
                               | (g,wl1) ->
                                   ((FStar_Pervasives_Native.Some g), wl1))
                             in
                          match uu____26229 with
                          | (guard,wl1) ->
                              let uu____26270 = solve_prob orig guard [] wl1
                                 in
                              solve env uu____26270))
                    else rigid_rigid_delta env problem wl head1 head2 t1 t2))
              | (FStar_Syntax_Syntax.Tm_let
                 uu____26273,FStar_Syntax_Syntax.Tm_let uu____26274) ->
                  let uu____26301 = FStar_Syntax_Util.term_eq t1 t2  in
                  if uu____26301
                  then
                    let uu____26304 =
                      solve_prob orig FStar_Pervasives_Native.None [] wl  in
                    solve env uu____26304
                  else
                    (let uu____26307 = FStar_Thunk.mkv "Tm_let mismatch"  in
                     giveup env uu____26307 orig)
              | (FStar_Syntax_Syntax.Tm_let uu____26310,uu____26311) ->
                  let uu____26325 =
                    let uu____26331 =
                      let uu____26333 = FStar_Syntax_Print.tag_of_term t1  in
                      let uu____26335 = FStar_Syntax_Print.tag_of_term t2  in
                      let uu____26337 = FStar_Syntax_Print.term_to_string t1
                         in
                      let uu____26339 = FStar_Syntax_Print.term_to_string t2
                         in
                      FStar_Util.format4
                        "Internal error: unexpected flex-flex of %s and %s\n>>> (%s) -- (%s)"
                        uu____26333 uu____26335 uu____26337 uu____26339
                       in
                    (FStar_Errors.Fatal_UnificationNotWellFormed,
                      uu____26331)
                     in
                  FStar_Errors.raise_error uu____26325
                    t1.FStar_Syntax_Syntax.pos
              | (uu____26343,FStar_Syntax_Syntax.Tm_let uu____26344) ->
                  let uu____26358 =
                    let uu____26364 =
                      let uu____26366 = FStar_Syntax_Print.tag_of_term t1  in
                      let uu____26368 = FStar_Syntax_Print.tag_of_term t2  in
                      let uu____26370 = FStar_Syntax_Print.term_to_string t1
                         in
                      let uu____26372 = FStar_Syntax_Print.term_to_string t2
                         in
                      FStar_Util.format4
                        "Internal error: unexpected flex-flex of %s and %s\n>>> (%s) -- (%s)"
                        uu____26366 uu____26368 uu____26370 uu____26372
                       in
                    (FStar_Errors.Fatal_UnificationNotWellFormed,
                      uu____26364)
                     in
                  FStar_Errors.raise_error uu____26358
                    t1.FStar_Syntax_Syntax.pos
              | uu____26376 ->
                  let uu____26381 = FStar_Thunk.mkv "head tag mismatch"  in
                  giveup env uu____26381 orig))))

and (solve_c :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.comp FStar_TypeChecker_Common.problem ->
      worklist -> solution)
  =
  fun env  ->
    fun problem  ->
      fun wl  ->
        let c1 = problem.FStar_TypeChecker_Common.lhs  in
        let c2 = problem.FStar_TypeChecker_Common.rhs  in
        let orig = FStar_TypeChecker_Common.CProb problem  in
        let sub_prob wl1 t1 rel t2 reason =
          mk_t_problem wl1 [] orig t1 rel t2 FStar_Pervasives_Native.None
            reason
           in
        let solve_eq c1_comp c2_comp g_lift =
          (let uu____26447 =
             FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
               (FStar_Options.Other "EQ")
              in
           if uu____26447
           then
             let uu____26452 =
               let uu____26454 = FStar_Syntax_Syntax.mk_Comp c1_comp  in
               FStar_Syntax_Print.comp_to_string uu____26454  in
             let uu____26455 =
               let uu____26457 = FStar_Syntax_Syntax.mk_Comp c2_comp  in
               FStar_Syntax_Print.comp_to_string uu____26457  in
             FStar_Util.print2
               "solve_c is using an equality constraint (%s vs %s)\n"
               uu____26452 uu____26455
           else ());
          (let uu____26461 =
             let uu____26463 =
               FStar_Ident.lid_equals c1_comp.FStar_Syntax_Syntax.effect_name
                 c2_comp.FStar_Syntax_Syntax.effect_name
                in
             Prims.op_Negation uu____26463  in
           if uu____26461
           then
             let uu____26466 =
               FStar_Thunk.mk
                 (fun uu____26471  ->
                    let uu____26472 =
                      FStar_Syntax_Print.lid_to_string
                        c1_comp.FStar_Syntax_Syntax.effect_name
                       in
                    let uu____26474 =
                      FStar_Syntax_Print.lid_to_string
                        c2_comp.FStar_Syntax_Syntax.effect_name
                       in
                    FStar_Util.format2 "incompatible effects: %s <> %s"
                      uu____26472 uu____26474)
                in
             giveup env uu____26466 orig
           else
             if
               (FStar_List.length c1_comp.FStar_Syntax_Syntax.effect_args) <>
                 (FStar_List.length c2_comp.FStar_Syntax_Syntax.effect_args)
             then
               (let uu____26496 =
                  FStar_Thunk.mk
                    (fun uu____26501  ->
                       let uu____26502 =
                         FStar_Syntax_Print.args_to_string
                           c1_comp.FStar_Syntax_Syntax.effect_args
                          in
                       let uu____26504 =
                         FStar_Syntax_Print.args_to_string
                           c2_comp.FStar_Syntax_Syntax.effect_args
                          in
                       FStar_Util.format2
                         "incompatible effect arguments: %s <> %s"
                         uu____26502 uu____26504)
                   in
                giveup env uu____26496 orig)
             else
               (let uu____26509 =
                  FStar_List.fold_left2
                    (fun uu____26530  ->
                       fun u1  ->
                         fun u2  ->
                           match uu____26530 with
                           | (univ_sub_probs,wl1) ->
                               let uu____26551 =
                                 let uu____26556 =
                                   FStar_Syntax_Syntax.mk
                                     (FStar_Syntax_Syntax.Tm_type u1)
                                     FStar_Pervasives_Native.None
                                     FStar_Range.dummyRange
                                    in
                                 let uu____26557 =
                                   FStar_Syntax_Syntax.mk
                                     (FStar_Syntax_Syntax.Tm_type u2)
                                     FStar_Pervasives_Native.None
                                     FStar_Range.dummyRange
                                    in
                                 sub_prob wl1 uu____26556
                                   FStar_TypeChecker_Common.EQ uu____26557
                                   "effect universes"
                                  in
                               (match uu____26551 with
                                | (p,wl2) ->
                                    ((FStar_List.append univ_sub_probs [p]),
                                      wl2))) ([], wl)
                    c1_comp.FStar_Syntax_Syntax.comp_univs
                    c2_comp.FStar_Syntax_Syntax.comp_univs
                   in
                match uu____26509 with
                | (univ_sub_probs,wl1) ->
                    let uu____26577 =
                      sub_prob wl1 c1_comp.FStar_Syntax_Syntax.result_typ
                        FStar_TypeChecker_Common.EQ
                        c2_comp.FStar_Syntax_Syntax.result_typ
                        "effect ret type"
                       in
                    (match uu____26577 with
                     | (ret_sub_prob,wl2) ->
                         let uu____26585 =
                           FStar_List.fold_right2
                             (fun uu____26622  ->
                                fun uu____26623  ->
                                  fun uu____26624  ->
                                    match (uu____26622, uu____26623,
                                            uu____26624)
                                    with
                                    | ((a1,uu____26668),(a2,uu____26670),
                                       (arg_sub_probs,wl3)) ->
                                        let uu____26703 =
                                          sub_prob wl3 a1
                                            FStar_TypeChecker_Common.EQ a2
                                            "effect arg"
                                           in
                                        (match uu____26703 with
                                         | (p,wl4) ->
                                             ((p :: arg_sub_probs), wl4)))
                             c1_comp.FStar_Syntax_Syntax.effect_args
                             c2_comp.FStar_Syntax_Syntax.effect_args
                             ([], wl2)
                            in
                         (match uu____26585 with
                          | (arg_sub_probs,wl3) ->
                              let sub_probs =
                                let uu____26730 =
                                  let uu____26733 =
                                    let uu____26736 =
                                      FStar_All.pipe_right
                                        g_lift.FStar_TypeChecker_Common.deferred
                                        (FStar_List.map
                                           FStar_Pervasives_Native.snd)
                                       in
                                    FStar_List.append arg_sub_probs
                                      uu____26736
                                     in
                                  FStar_List.append [ret_sub_prob]
                                    uu____26733
                                   in
                                FStar_List.append univ_sub_probs uu____26730
                                 in
                              let guard =
                                let guard =
                                  let uu____26758 =
                                    FStar_List.map p_guard sub_probs  in
                                  FStar_Syntax_Util.mk_conj_l uu____26758  in
                                match g_lift.FStar_TypeChecker_Common.guard_f
                                with
                                | FStar_TypeChecker_Common.Trivial  -> guard
                                | FStar_TypeChecker_Common.NonTrivial f ->
                                    FStar_Syntax_Util.mk_conj guard f
                                 in
                              let wl4 =
                                let uu___3505_26767 = wl3  in
                                {
                                  attempting = (uu___3505_26767.attempting);
                                  wl_deferred = (uu___3505_26767.wl_deferred);
                                  ctr = (uu___3505_26767.ctr);
                                  defer_ok = (uu___3505_26767.defer_ok);
                                  smt_ok = (uu___3505_26767.smt_ok);
                                  umax_heuristic_ok =
                                    (uu___3505_26767.umax_heuristic_ok);
                                  tcenv = (uu___3505_26767.tcenv);
                                  wl_implicits =
                                    (FStar_List.append
                                       g_lift.FStar_TypeChecker_Common.implicits
                                       wl3.wl_implicits)
                                }  in
                              let wl5 =
                                solve_prob orig
                                  (FStar_Pervasives_Native.Some guard) [] wl4
                                 in
                              let uu____26769 = attempt sub_probs wl5  in
                              solve env uu____26769))))
           in
        let solve_layered_sub c11 edge c21 =
          (let uu____26787 =
             FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
               (FStar_Options.Other "LayeredEffects")
              in
           if uu____26787
           then
             let uu____26792 =
               let uu____26794 =
                 FStar_All.pipe_right c11 FStar_Syntax_Syntax.mk_Comp  in
               FStar_All.pipe_right uu____26794
                 FStar_Syntax_Print.comp_to_string
                in
             let uu____26796 =
               let uu____26798 =
                 FStar_All.pipe_right c21 FStar_Syntax_Syntax.mk_Comp  in
               FStar_All.pipe_right uu____26798
                 FStar_Syntax_Print.comp_to_string
                in
             FStar_Util.print2 "solve_layered_sub c1: %s and c2: %s\n"
               uu____26792 uu____26796
           else ());
          (let uu____26803 =
             let uu____26808 =
               let uu____26813 =
                 FStar_All.pipe_right c11 FStar_Syntax_Syntax.mk_Comp  in
               FStar_All.pipe_right uu____26813
                 ((edge.FStar_TypeChecker_Env.mlift).FStar_TypeChecker_Env.mlift_wp
                    env)
                in
             FStar_All.pipe_right uu____26808
               (fun uu____26830  ->
                  match uu____26830 with
                  | (c,g) ->
                      let uu____26841 = FStar_Syntax_Util.comp_to_comp_typ c
                         in
                      (uu____26841, g))
              in
           match uu____26803 with
           | (c12,g_lift) ->
               ((let uu____26845 =
                   FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                     (FStar_Options.Other "LayeredEffects")
                    in
                 if uu____26845
                 then
                   let uu____26850 =
                     let uu____26852 =
                       FStar_All.pipe_right c12 FStar_Syntax_Syntax.mk_Comp
                        in
                     FStar_All.pipe_right uu____26852
                       FStar_Syntax_Print.comp_to_string
                      in
                   let uu____26854 =
                     let uu____26856 =
                       FStar_All.pipe_right c21 FStar_Syntax_Syntax.mk_Comp
                        in
                     FStar_All.pipe_right uu____26856
                       FStar_Syntax_Print.comp_to_string
                      in
                   FStar_Util.print2
                     "solve_layered_sub after lift c1: %s and c2: %s\n"
                     uu____26850 uu____26854
                 else ());
                if
                  problem.FStar_TypeChecker_Common.relation =
                    FStar_TypeChecker_Common.EQ
                then solve_eq c12 c21 g_lift
                else
                  (let r = FStar_TypeChecker_Env.get_range env  in
                   let wl1 =
                     let uu___3525_26866 = wl  in
                     {
                       attempting = (uu___3525_26866.attempting);
                       wl_deferred = (uu___3525_26866.wl_deferred);
                       ctr = (uu___3525_26866.ctr);
                       defer_ok = (uu___3525_26866.defer_ok);
                       smt_ok = (uu___3525_26866.smt_ok);
                       umax_heuristic_ok =
                         (uu___3525_26866.umax_heuristic_ok);
                       tcenv = (uu___3525_26866.tcenv);
                       wl_implicits =
                         (FStar_List.append
                            g_lift.FStar_TypeChecker_Common.implicits
                            wl.wl_implicits)
                     }  in
                   let uu____26867 =
                     let rec is_uvar1 t =
                       let uu____26881 =
                         let uu____26882 = FStar_Syntax_Subst.compress t  in
                         uu____26882.FStar_Syntax_Syntax.n  in
                       match uu____26881 with
                       | FStar_Syntax_Syntax.Tm_uvar uu____26886 -> true
                       | FStar_Syntax_Syntax.Tm_uinst (t1,uu____26901) ->
                           is_uvar1 t1
                       | FStar_Syntax_Syntax.Tm_app (t1,uu____26907) ->
                           is_uvar1 t1
                       | uu____26932 -> false  in
                     FStar_List.fold_right2
                       (fun uu____26966  ->
                          fun uu____26967  ->
                            fun uu____26968  ->
                              match (uu____26966, uu____26967, uu____26968)
                              with
                              | ((a1,uu____27012),(a2,uu____27014),(is_sub_probs,wl2))
                                  ->
                                  let uu____27047 = is_uvar1 a1  in
                                  if uu____27047
                                  then
                                    ((let uu____27057 =
                                        FStar_All.pipe_left
                                          (FStar_TypeChecker_Env.debug env)
                                          (FStar_Options.Other
                                             "LayeredEffects")
                                         in
                                      if uu____27057
                                      then
                                        let uu____27062 =
                                          FStar_Syntax_Print.term_to_string
                                            a1
                                           in
                                        let uu____27064 =
                                          FStar_Syntax_Print.term_to_string
                                            a2
                                           in
                                        FStar_Util.print2
                                          "solve_layered_sub: adding index equality for %s and %s (since a1 uvar)\n"
                                          uu____27062 uu____27064
                                      else ());
                                     (let uu____27069 =
                                        sub_prob wl2 a1
                                          FStar_TypeChecker_Common.EQ a2
                                          "l.h.s. effect index uvar"
                                         in
                                      match uu____27069 with
                                      | (p,wl3) -> ((p :: is_sub_probs), wl3)))
                                  else (is_sub_probs, wl2))
                       c12.FStar_Syntax_Syntax.effect_args
                       c21.FStar_Syntax_Syntax.effect_args ([], wl1)
                      in
                   match uu____26867 with
                   | (is_sub_probs,wl2) ->
                       let uu____27097 =
                         sub_prob wl2 c12.FStar_Syntax_Syntax.result_typ
                           problem.FStar_TypeChecker_Common.relation
                           c21.FStar_Syntax_Syntax.result_typ "result type"
                          in
                       (match uu____27097 with
                        | (ret_sub_prob,wl3) ->
                            let uu____27105 =
                              let uu____27110 =
                                let uu____27111 =
                                  FStar_All.pipe_right
                                    c21.FStar_Syntax_Syntax.effect_name
                                    (FStar_TypeChecker_Env.get_effect_decl
                                       env)
                                   in
                                FStar_All.pipe_right uu____27111
                                  FStar_Syntax_Util.get_stronger_vc_combinator
                                 in
                              FStar_All.pipe_right uu____27110
                                (fun ts  ->
                                   FStar_TypeChecker_Env.inst_tscheme_with ts
                                     c21.FStar_Syntax_Syntax.comp_univs)
                               in
                            (match uu____27105 with
                             | (uu____27118,stronger_t) ->
                                 let stronger_t_shape_error s =
                                   let uu____27129 =
                                     FStar_Ident.string_of_lid
                                       c21.FStar_Syntax_Syntax.effect_name
                                      in
                                   let uu____27131 =
                                     FStar_Syntax_Print.term_to_string
                                       stronger_t
                                      in
                                   FStar_Util.format3
                                     "Unexpected shape of stronger for %s, reason: %s (t:%s)"
                                     uu____27129 s uu____27131
                                    in
                                 let uu____27134 =
                                   let uu____27163 =
                                     let uu____27164 =
                                       FStar_Syntax_Subst.compress stronger_t
                                        in
                                     uu____27164.FStar_Syntax_Syntax.n  in
                                   match uu____27163 with
                                   | FStar_Syntax_Syntax.Tm_arrow (bs,c) when
                                       (FStar_List.length bs) >=
                                         (Prims.of_int (2))
                                       ->
                                       let uu____27224 =
                                         FStar_Syntax_Subst.open_comp bs c
                                          in
                                       (match uu____27224 with
                                        | (a::bs1,c3) ->
                                            let uu____27280 =
                                              let uu____27299 =
                                                FStar_All.pipe_right bs1
                                                  (FStar_List.splitAt
                                                     ((FStar_List.length bs1)
                                                        - Prims.int_one))
                                                 in
                                              FStar_All.pipe_right
                                                uu____27299
                                                (fun uu____27403  ->
                                                   match uu____27403 with
                                                   | (l1,l2) ->
                                                       let uu____27476 =
                                                         FStar_List.hd l2  in
                                                       (l1, uu____27476))
                                               in
                                            (match uu____27280 with
                                             | (rest_bs,f_b) ->
                                                 (a, rest_bs, f_b, c3)))
                                   | uu____27581 ->
                                       let uu____27582 =
                                         let uu____27588 =
                                           stronger_t_shape_error
                                             "not an arrow or not enough binders"
                                            in
                                         (FStar_Errors.Fatal_UnexpectedExpressionType,
                                           uu____27588)
                                          in
                                       FStar_Errors.raise_error uu____27582 r
                                    in
                                 (match uu____27134 with
                                  | (a_b,rest_bs,f_b,stronger_c) ->
                                      let uu____27664 =
                                        let uu____27671 =
                                          let uu____27672 =
                                            let uu____27673 =
                                              let uu____27680 =
                                                FStar_All.pipe_right a_b
                                                  FStar_Pervasives_Native.fst
                                                 in
                                              (uu____27680,
                                                (c21.FStar_Syntax_Syntax.result_typ))
                                               in
                                            FStar_Syntax_Syntax.NT
                                              uu____27673
                                             in
                                          [uu____27672]  in
                                        FStar_TypeChecker_Env.uvars_for_binders
                                          env rest_bs uu____27671
                                          (fun b  ->
                                             let uu____27696 =
                                               FStar_Syntax_Print.binder_to_string
                                                 b
                                                in
                                             let uu____27698 =
                                               FStar_Ident.string_of_lid
                                                 c21.FStar_Syntax_Syntax.effect_name
                                                in
                                             let uu____27700 =
                                               FStar_Range.string_of_range r
                                                in
                                             FStar_Util.format3
                                               "implicit for binder %s in stronger of %s at %s"
                                               uu____27696 uu____27698
                                               uu____27700) r
                                         in
                                      (match uu____27664 with
                                       | (rest_bs_uvars,g_uvars) ->
                                           ((let uu____27710 =
                                               FStar_All.pipe_left
                                                 (FStar_TypeChecker_Env.debug
                                                    env)
                                                 (FStar_Options.Other
                                                    "LayeredEffects")
                                                in
                                             if uu____27710
                                             then
                                               let uu____27715 =
                                                 FStar_List.fold_left
                                                   (fun s  ->
                                                      fun u  ->
                                                        let uu____27724 =
                                                          let uu____27726 =
                                                            FStar_Syntax_Print.term_to_string
                                                              u
                                                             in
                                                          Prims.op_Hat ";;;;"
                                                            uu____27726
                                                           in
                                                        Prims.op_Hat s
                                                          uu____27724) ""
                                                   rest_bs_uvars
                                                  in
                                               FStar_Util.print1
                                                 "Introduced uvars for subcomp: %s\n"
                                                 uu____27715
                                             else ());
                                            (let wl4 =
                                               let uu___3597_27734 = wl3  in
                                               {
                                                 attempting =
                                                   (uu___3597_27734.attempting);
                                                 wl_deferred =
                                                   (uu___3597_27734.wl_deferred);
                                                 ctr = (uu___3597_27734.ctr);
                                                 defer_ok =
                                                   (uu___3597_27734.defer_ok);
                                                 smt_ok =
                                                   (uu___3597_27734.smt_ok);
                                                 umax_heuristic_ok =
                                                   (uu___3597_27734.umax_heuristic_ok);
                                                 tcenv =
                                                   (uu___3597_27734.tcenv);
                                                 wl_implicits =
                                                   (FStar_List.append
                                                      g_uvars.FStar_TypeChecker_Common.implicits
                                                      wl3.wl_implicits)
                                               }  in
                                             let substs =
                                               FStar_List.map2
                                                 (fun b  ->
                                                    fun t  ->
                                                      let uu____27759 =
                                                        let uu____27766 =
                                                          FStar_All.pipe_right
                                                            b
                                                            FStar_Pervasives_Native.fst
                                                           in
                                                        (uu____27766, t)  in
                                                      FStar_Syntax_Syntax.NT
                                                        uu____27759) (a_b ::
                                                 rest_bs)
                                                 ((c21.FStar_Syntax_Syntax.result_typ)
                                                 :: rest_bs_uvars)
                                                in
                                             let uu____27783 =
                                               let f_sort_is =
                                                 let uu____27793 =
                                                   let uu____27794 =
                                                     let uu____27797 =
                                                       let uu____27798 =
                                                         FStar_All.pipe_right
                                                           f_b
                                                           FStar_Pervasives_Native.fst
                                                          in
                                                       uu____27798.FStar_Syntax_Syntax.sort
                                                        in
                                                     FStar_Syntax_Subst.compress
                                                       uu____27797
                                                      in
                                                   uu____27794.FStar_Syntax_Syntax.n
                                                    in
                                                 match uu____27793 with
                                                 | FStar_Syntax_Syntax.Tm_app
                                                     (uu____27809,uu____27810::is)
                                                     ->
                                                     let uu____27852 =
                                                       FStar_All.pipe_right
                                                         is
                                                         (FStar_List.map
                                                            FStar_Pervasives_Native.fst)
                                                        in
                                                     FStar_All.pipe_right
                                                       uu____27852
                                                       (FStar_List.map
                                                          (FStar_Syntax_Subst.subst
                                                             substs))
                                                 | uu____27885 ->
                                                     let uu____27886 =
                                                       let uu____27892 =
                                                         stronger_t_shape_error
                                                           "type of f is not a repr type"
                                                          in
                                                       (FStar_Errors.Fatal_UnexpectedExpressionType,
                                                         uu____27892)
                                                        in
                                                     FStar_Errors.raise_error
                                                       uu____27886 r
                                                  in
                                               let uu____27898 =
                                                 FStar_All.pipe_right
                                                   c12.FStar_Syntax_Syntax.effect_args
                                                   (FStar_List.map
                                                      FStar_Pervasives_Native.fst)
                                                  in
                                               FStar_List.fold_left2
                                                 (fun uu____27933  ->
                                                    fun f_sort_i  ->
                                                      fun c1_i  ->
                                                        match uu____27933
                                                        with
                                                        | (ps,wl5) ->
                                                            let uu____27954 =
                                                              sub_prob wl5
                                                                f_sort_i
                                                                FStar_TypeChecker_Common.EQ
                                                                c1_i
                                                                "indices of c1"
                                                               in
                                                            (match uu____27954
                                                             with
                                                             | (p,wl6) ->
                                                                 ((FStar_List.append
                                                                    ps 
                                                                    [p]),
                                                                   wl6)))
                                                 ([], wl4) f_sort_is
                                                 uu____27898
                                                in
                                             match uu____27783 with
                                             | (f_sub_probs,wl5) ->
                                                 let stronger_ct =
                                                   let uu____27979 =
                                                     FStar_All.pipe_right
                                                       stronger_c
                                                       (FStar_Syntax_Subst.subst_comp
                                                          substs)
                                                      in
                                                   FStar_All.pipe_right
                                                     uu____27979
                                                     FStar_Syntax_Util.comp_to_comp_typ
                                                    in
                                                 let uu____27980 =
                                                   let g_sort_is =
                                                     let uu____27990 =
                                                       let uu____27991 =
                                                         FStar_Syntax_Subst.compress
                                                           stronger_ct.FStar_Syntax_Syntax.result_typ
                                                          in
                                                       uu____27991.FStar_Syntax_Syntax.n
                                                        in
                                                     match uu____27990 with
                                                     | FStar_Syntax_Syntax.Tm_app
                                                         (uu____27996,uu____27997::is)
                                                         ->
                                                         FStar_All.pipe_right
                                                           is
                                                           (FStar_List.map
                                                              FStar_Pervasives_Native.fst)
                                                     | uu____28057 ->
                                                         let uu____28058 =
                                                           let uu____28064 =
                                                             stronger_t_shape_error
                                                               "return type is not a repr type"
                                                              in
                                                           (FStar_Errors.Fatal_UnexpectedExpressionType,
                                                             uu____28064)
                                                            in
                                                         FStar_Errors.raise_error
                                                           uu____28058 r
                                                      in
                                                   let uu____28070 =
                                                     FStar_All.pipe_right
                                                       c21.FStar_Syntax_Syntax.effect_args
                                                       (FStar_List.map
                                                          FStar_Pervasives_Native.fst)
                                                      in
                                                   FStar_List.fold_left2
                                                     (fun uu____28105  ->
                                                        fun g_sort_i  ->
                                                          fun c2_i  ->
                                                            match uu____28105
                                                            with
                                                            | (ps,wl6) ->
                                                                let uu____28126
                                                                  =
                                                                  sub_prob
                                                                    wl6
                                                                    g_sort_i
                                                                    FStar_TypeChecker_Common.EQ
                                                                    c2_i
                                                                    "indices of c2"
                                                                   in
                                                                (match uu____28126
                                                                 with
                                                                 | (p,wl7) ->
                                                                    ((FStar_List.append
                                                                    ps [p]),
                                                                    wl7)))
                                                     ([], wl5) g_sort_is
                                                     uu____28070
                                                    in
                                                 (match uu____27980 with
                                                  | (g_sub_probs,wl6) ->
                                                      let fml =
                                                        let uu____28153 =
                                                          let uu____28158 =
                                                            FStar_List.hd
                                                              stronger_ct.FStar_Syntax_Syntax.comp_univs
                                                             in
                                                          let uu____28159 =
                                                            let uu____28160 =
                                                              FStar_List.hd
                                                                stronger_ct.FStar_Syntax_Syntax.effect_args
                                                               in
                                                            FStar_Pervasives_Native.fst
                                                              uu____28160
                                                             in
                                                          (uu____28158,
                                                            uu____28159)
                                                           in
                                                        match uu____28153
                                                        with
                                                        | (u,wp) ->
                                                            FStar_TypeChecker_Env.pure_precondition_for_trivial_post
                                                              env u
                                                              stronger_ct.FStar_Syntax_Syntax.result_typ
                                                              wp
                                                              FStar_Range.dummyRange
                                                         in
                                                      let sub_probs =
                                                        let uu____28188 =
                                                          let uu____28191 =
                                                            let uu____28194 =
                                                              let uu____28197
                                                                =
                                                                FStar_All.pipe_right
                                                                  g_lift.FStar_TypeChecker_Common.deferred
                                                                  (FStar_List.map
                                                                    FStar_Pervasives_Native.snd)
                                                                 in
                                                              FStar_List.append
                                                                g_sub_probs
                                                                uu____28197
                                                               in
                                                            FStar_List.append
                                                              f_sub_probs
                                                              uu____28194
                                                             in
                                                          FStar_List.append
                                                            is_sub_probs
                                                            uu____28191
                                                           in
                                                        ret_sub_prob ::
                                                          uu____28188
                                                         in
                                                      let guard =
                                                        let guard =
                                                          let uu____28221 =
                                                            FStar_List.map
                                                              p_guard
                                                              sub_probs
                                                             in
                                                          FStar_Syntax_Util.mk_conj_l
                                                            uu____28221
                                                           in
                                                        match g_lift.FStar_TypeChecker_Common.guard_f
                                                        with
                                                        | FStar_TypeChecker_Common.Trivial
                                                             -> guard
                                                        | FStar_TypeChecker_Common.NonTrivial
                                                            f ->
                                                            FStar_Syntax_Util.mk_conj
                                                              guard f
                                                         in
                                                      let wl7 =
                                                        let uu____28232 =
                                                          let uu____28235 =
                                                            FStar_Syntax_Util.mk_conj
                                                              guard fml
                                                             in
                                                          FStar_All.pipe_left
                                                            (fun _28238  ->
                                                               FStar_Pervasives_Native.Some
                                                                 _28238)
                                                            uu____28235
                                                           in
                                                        solve_prob orig
                                                          uu____28232 [] wl6
                                                         in
                                                      let uu____28239 =
                                                        attempt sub_probs wl7
                                                         in
                                                      solve env uu____28239))))))))))
           in
        let solve_sub c11 edge c21 =
          let r = FStar_TypeChecker_Env.get_range env  in
          let lift_c1 uu____28262 =
            let univs1 =
              match c11.FStar_Syntax_Syntax.comp_univs with
              | [] ->
                  let uu____28264 =
                    env.FStar_TypeChecker_Env.universe_of env
                      c11.FStar_Syntax_Syntax.result_typ
                     in
                  [uu____28264]
              | x -> x  in
            let c12 =
              let uu___3663_28267 = c11  in
              {
                FStar_Syntax_Syntax.comp_univs = univs1;
                FStar_Syntax_Syntax.effect_name =
                  (uu___3663_28267.FStar_Syntax_Syntax.effect_name);
                FStar_Syntax_Syntax.result_typ =
                  (uu___3663_28267.FStar_Syntax_Syntax.result_typ);
                FStar_Syntax_Syntax.effect_args =
                  (uu___3663_28267.FStar_Syntax_Syntax.effect_args);
                FStar_Syntax_Syntax.flags =
                  (uu___3663_28267.FStar_Syntax_Syntax.flags)
              }  in
            let uu____28268 =
              let uu____28273 =
                FStar_All.pipe_right
                  (let uu___3666_28275 = c12  in
                   {
                     FStar_Syntax_Syntax.comp_univs = univs1;
                     FStar_Syntax_Syntax.effect_name =
                       (uu___3666_28275.FStar_Syntax_Syntax.effect_name);
                     FStar_Syntax_Syntax.result_typ =
                       (uu___3666_28275.FStar_Syntax_Syntax.result_typ);
                     FStar_Syntax_Syntax.effect_args =
                       (uu___3666_28275.FStar_Syntax_Syntax.effect_args);
                     FStar_Syntax_Syntax.flags =
                       (uu___3666_28275.FStar_Syntax_Syntax.flags)
                   }) FStar_Syntax_Syntax.mk_Comp
                 in
              FStar_All.pipe_right uu____28273
                ((edge.FStar_TypeChecker_Env.mlift).FStar_TypeChecker_Env.mlift_wp
                   env)
               in
            FStar_All.pipe_right uu____28268
              (fun uu____28289  ->
                 match uu____28289 with
                 | (c,g) ->
                     let uu____28296 =
                       let uu____28298 = FStar_TypeChecker_Env.is_trivial g
                          in
                       Prims.op_Negation uu____28298  in
                     if uu____28296
                     then
                       let uu____28301 =
                         let uu____28307 =
                           let uu____28309 =
                             FStar_Ident.string_of_lid
                               c12.FStar_Syntax_Syntax.effect_name
                              in
                           let uu____28311 =
                             FStar_Ident.string_of_lid
                               c21.FStar_Syntax_Syntax.effect_name
                              in
                           FStar_Util.format2
                             "Lift between wp-effects (%s~>%s) should not have returned a non-trivial guard"
                             uu____28309 uu____28311
                            in
                         (FStar_Errors.Fatal_UnexpectedEffect, uu____28307)
                          in
                       FStar_Errors.raise_error uu____28301 r
                     else FStar_Syntax_Util.comp_to_comp_typ c)
             in
          let uu____28317 =
            FStar_TypeChecker_Env.is_layered_effect env
              c21.FStar_Syntax_Syntax.effect_name
             in
          if uu____28317
          then solve_layered_sub c11 edge c21
          else
            if
              problem.FStar_TypeChecker_Common.relation =
                FStar_TypeChecker_Common.EQ
            then
              (let uu____28323 = lift_c1 ()  in
               solve_eq uu____28323 c21 FStar_TypeChecker_Env.trivial_guard)
            else
              (let is_null_wp_2 =
                 FStar_All.pipe_right c21.FStar_Syntax_Syntax.flags
                   (FStar_Util.for_some
                      (fun uu___31_28332  ->
                         match uu___31_28332 with
                         | FStar_Syntax_Syntax.TOTAL  -> true
                         | FStar_Syntax_Syntax.MLEFFECT  -> true
                         | FStar_Syntax_Syntax.SOMETRIVIAL  -> true
                         | uu____28337 -> false))
                  in
               let uu____28339 =
                 match ((c11.FStar_Syntax_Syntax.effect_args),
                         (c21.FStar_Syntax_Syntax.effect_args))
                 with
                 | ((wp1,uu____28369)::uu____28370,(wp2,uu____28372)::uu____28373)
                     -> (wp1, wp2)
                 | uu____28446 ->
                     let uu____28471 =
                       let uu____28477 =
                         let uu____28479 =
                           FStar_Syntax_Print.lid_to_string
                             c11.FStar_Syntax_Syntax.effect_name
                            in
                         let uu____28481 =
                           FStar_Syntax_Print.lid_to_string
                             c21.FStar_Syntax_Syntax.effect_name
                            in
                         FStar_Util.format2
                           "Got effects %s and %s, expected normalized effects"
                           uu____28479 uu____28481
                          in
                       (FStar_Errors.Fatal_ExpectNormalizedEffect,
                         uu____28477)
                        in
                     FStar_Errors.raise_error uu____28471
                       env.FStar_TypeChecker_Env.range
                  in
               match uu____28339 with
               | (wpc1,wpc2) ->
                   let uu____28491 = FStar_Util.physical_equality wpc1 wpc2
                      in
                   if uu____28491
                   then
                     let uu____28494 =
                       problem_using_guard orig
                         c11.FStar_Syntax_Syntax.result_typ
                         problem.FStar_TypeChecker_Common.relation
                         c21.FStar_Syntax_Syntax.result_typ
                         FStar_Pervasives_Native.None "result type"
                        in
                     solve_t env uu____28494 wl
                   else
                     (let uu____28498 =
                        let uu____28505 =
                          FStar_TypeChecker_Env.effect_decl_opt env
                            c21.FStar_Syntax_Syntax.effect_name
                           in
                        FStar_Util.must uu____28505  in
                      match uu____28498 with
                      | (c2_decl,qualifiers) ->
                          let uu____28526 =
                            FStar_All.pipe_right qualifiers
                              (FStar_List.contains
                                 FStar_Syntax_Syntax.Reifiable)
                             in
                          if uu____28526
                          then
                            let c1_repr =
                              let uu____28533 =
                                let uu____28534 =
                                  let uu____28535 = lift_c1 ()  in
                                  FStar_Syntax_Syntax.mk_Comp uu____28535  in
                                let uu____28536 =
                                  env.FStar_TypeChecker_Env.universe_of env
                                    c11.FStar_Syntax_Syntax.result_typ
                                   in
                                FStar_TypeChecker_Env.reify_comp env
                                  uu____28534 uu____28536
                                 in
                              norm_with_steps
                                "FStar.TypeChecker.Rel.norm_with_steps.4"
                                [FStar_TypeChecker_Env.UnfoldUntil
                                   FStar_Syntax_Syntax.delta_constant;
                                FStar_TypeChecker_Env.Weak;
                                FStar_TypeChecker_Env.HNF] env uu____28533
                               in
                            let c2_repr =
                              let uu____28539 =
                                let uu____28540 =
                                  FStar_Syntax_Syntax.mk_Comp c21  in
                                let uu____28541 =
                                  env.FStar_TypeChecker_Env.universe_of env
                                    c21.FStar_Syntax_Syntax.result_typ
                                   in
                                FStar_TypeChecker_Env.reify_comp env
                                  uu____28540 uu____28541
                                 in
                              norm_with_steps
                                "FStar.TypeChecker.Rel.norm_with_steps.5"
                                [FStar_TypeChecker_Env.UnfoldUntil
                                   FStar_Syntax_Syntax.delta_constant;
                                FStar_TypeChecker_Env.Weak;
                                FStar_TypeChecker_Env.HNF] env uu____28539
                               in
                            let uu____28543 =
                              let uu____28548 =
                                let uu____28550 =
                                  FStar_Syntax_Print.term_to_string c1_repr
                                   in
                                let uu____28552 =
                                  FStar_Syntax_Print.term_to_string c2_repr
                                   in
                                FStar_Util.format2
                                  "sub effect repr: %s <: %s" uu____28550
                                  uu____28552
                                 in
                              sub_prob wl c1_repr
                                problem.FStar_TypeChecker_Common.relation
                                c2_repr uu____28548
                               in
                            (match uu____28543 with
                             | (prob,wl1) ->
                                 let wl2 =
                                   solve_prob orig
                                     (FStar_Pervasives_Native.Some
                                        (p_guard prob)) [] wl1
                                    in
                                 let uu____28558 = attempt [prob] wl2  in
                                 solve env uu____28558)
                          else
                            (let g =
                               if env.FStar_TypeChecker_Env.lax
                               then FStar_Syntax_Util.t_true
                               else
                                 (let wpc1_2 =
                                    let uu____28578 = lift_c1 ()  in
                                    FStar_All.pipe_right uu____28578
                                      (fun ct  ->
                                         FStar_List.hd
                                           ct.FStar_Syntax_Syntax.effect_args)
                                     in
                                  if is_null_wp_2
                                  then
                                    ((let uu____28601 =
                                        FStar_All.pipe_left
                                          (FStar_TypeChecker_Env.debug env)
                                          (FStar_Options.Other "Rel")
                                         in
                                      if uu____28601
                                      then
                                        FStar_Util.print_string
                                          "Using trivial wp ... \n"
                                      else ());
                                     (let c1_univ =
                                        env.FStar_TypeChecker_Env.universe_of
                                          env
                                          c11.FStar_Syntax_Syntax.result_typ
                                         in
                                      let trivial =
                                        let uu____28611 =
                                          FStar_All.pipe_right c2_decl
                                            FStar_Syntax_Util.get_wp_trivial_combinator
                                           in
                                        match uu____28611 with
                                        | FStar_Pervasives_Native.None  ->
                                            failwith
                                              "Rel doesn't yet handle undefined trivial combinator in an effect"
                                        | FStar_Pervasives_Native.Some t -> t
                                         in
                                      let uu____28618 =
                                        let uu____28625 =
                                          let uu____28626 =
                                            let uu____28643 =
                                              FStar_TypeChecker_Env.inst_effect_fun_with
                                                [c1_univ] env c2_decl trivial
                                               in
                                            let uu____28646 =
                                              let uu____28657 =
                                                FStar_Syntax_Syntax.as_arg
                                                  c11.FStar_Syntax_Syntax.result_typ
                                                 in
                                              [uu____28657; wpc1_2]  in
                                            (uu____28643, uu____28646)  in
                                          FStar_Syntax_Syntax.Tm_app
                                            uu____28626
                                           in
                                        FStar_Syntax_Syntax.mk uu____28625
                                         in
                                      uu____28618
                                        FStar_Pervasives_Native.None r))
                                  else
                                    (let c2_univ =
                                       env.FStar_TypeChecker_Env.universe_of
                                         env
                                         c21.FStar_Syntax_Syntax.result_typ
                                        in
                                     let stronger =
                                       FStar_All.pipe_right c2_decl
                                         FStar_Syntax_Util.get_stronger_vc_combinator
                                        in
                                     let uu____28706 =
                                       let uu____28713 =
                                         let uu____28714 =
                                           let uu____28731 =
                                             FStar_TypeChecker_Env.inst_effect_fun_with
                                               [c2_univ] env c2_decl stronger
                                              in
                                           let uu____28734 =
                                             let uu____28745 =
                                               FStar_Syntax_Syntax.as_arg
                                                 c21.FStar_Syntax_Syntax.result_typ
                                                in
                                             let uu____28754 =
                                               let uu____28765 =
                                                 FStar_Syntax_Syntax.as_arg
                                                   wpc2
                                                  in
                                               [uu____28765; wpc1_2]  in
                                             uu____28745 :: uu____28754  in
                                           (uu____28731, uu____28734)  in
                                         FStar_Syntax_Syntax.Tm_app
                                           uu____28714
                                          in
                                       FStar_Syntax_Syntax.mk uu____28713  in
                                     uu____28706 FStar_Pervasives_Native.None
                                       r))
                                in
                             (let uu____28819 =
                                FStar_All.pipe_left
                                  (FStar_TypeChecker_Env.debug env)
                                  (FStar_Options.Other "Rel")
                                 in
                              if uu____28819
                              then
                                let uu____28824 =
                                  let uu____28826 =
                                    FStar_TypeChecker_Normalize.normalize
                                      [FStar_TypeChecker_Env.Iota;
                                      FStar_TypeChecker_Env.Eager_unfolding;
                                      FStar_TypeChecker_Env.Primops;
                                      FStar_TypeChecker_Env.Simplify] env g
                                     in
                                  FStar_Syntax_Print.term_to_string
                                    uu____28826
                                   in
                                FStar_Util.print1
                                  "WP guard (simplifed) is (%s)\n"
                                  uu____28824
                              else ());
                             (let uu____28830 =
                                sub_prob wl
                                  c11.FStar_Syntax_Syntax.result_typ
                                  problem.FStar_TypeChecker_Common.relation
                                  c21.FStar_Syntax_Syntax.result_typ
                                  "result type"
                                 in
                              match uu____28830 with
                              | (base_prob,wl1) ->
                                  let wl2 =
                                    let uu____28839 =
                                      let uu____28842 =
                                        FStar_Syntax_Util.mk_conj
                                          (p_guard base_prob) g
                                         in
                                      FStar_All.pipe_left
                                        (fun _28845  ->
                                           FStar_Pervasives_Native.Some
                                             _28845) uu____28842
                                       in
                                    solve_prob orig uu____28839 [] wl1  in
                                  let uu____28846 = attempt [base_prob] wl2
                                     in
                                  solve env uu____28846))))
           in
        let uu____28847 = FStar_Util.physical_equality c1 c2  in
        if uu____28847
        then
          let uu____28850 =
            solve_prob orig FStar_Pervasives_Native.None [] wl  in
          solve env uu____28850
        else
          ((let uu____28854 =
              FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                (FStar_Options.Other "Rel")
               in
            if uu____28854
            then
              let uu____28859 = FStar_Syntax_Print.comp_to_string c1  in
              let uu____28861 = FStar_Syntax_Print.comp_to_string c2  in
              FStar_Util.print3 "solve_c %s %s %s\n" uu____28859
                (rel_to_string problem.FStar_TypeChecker_Common.relation)
                uu____28861
            else ());
           (let uu____28866 =
              let uu____28875 =
                FStar_TypeChecker_Normalize.ghost_to_pure env c1  in
              let uu____28878 =
                FStar_TypeChecker_Normalize.ghost_to_pure env c2  in
              (uu____28875, uu____28878)  in
            match uu____28866 with
            | (c11,c21) ->
                (match ((c11.FStar_Syntax_Syntax.n),
                         (c21.FStar_Syntax_Syntax.n))
                 with
                 | (FStar_Syntax_Syntax.GTotal
                    (t1,uu____28896),FStar_Syntax_Syntax.Total
                    (t2,uu____28898)) when
                     FStar_TypeChecker_Env.non_informative env t2 ->
                     let uu____28915 =
                       problem_using_guard orig t1
                         problem.FStar_TypeChecker_Common.relation t2
                         FStar_Pervasives_Native.None "result type"
                        in
                     solve_t env uu____28915 wl
                 | (FStar_Syntax_Syntax.GTotal
                    uu____28917,FStar_Syntax_Syntax.Total uu____28918) ->
                     let uu____28935 =
                       FStar_Thunk.mkv
                         "incompatible monad ordering: GTot </: Tot"
                        in
                     giveup env uu____28935 orig
                 | (FStar_Syntax_Syntax.Total
                    (t1,uu____28939),FStar_Syntax_Syntax.Total
                    (t2,uu____28941)) ->
                     let uu____28958 =
                       problem_using_guard orig t1
                         problem.FStar_TypeChecker_Common.relation t2
                         FStar_Pervasives_Native.None "result type"
                        in
                     solve_t env uu____28958 wl
                 | (FStar_Syntax_Syntax.GTotal
                    (t1,uu____28961),FStar_Syntax_Syntax.GTotal
                    (t2,uu____28963)) ->
                     let uu____28980 =
                       problem_using_guard orig t1
                         problem.FStar_TypeChecker_Common.relation t2
                         FStar_Pervasives_Native.None "result type"
                        in
                     solve_t env uu____28980 wl
                 | (FStar_Syntax_Syntax.Total
                    (t1,uu____28983),FStar_Syntax_Syntax.GTotal
                    (t2,uu____28985)) when
                     problem.FStar_TypeChecker_Common.relation =
                       FStar_TypeChecker_Common.SUB
                     ->
                     let uu____29002 =
                       problem_using_guard orig t1
                         problem.FStar_TypeChecker_Common.relation t2
                         FStar_Pervasives_Native.None "result type"
                        in
                     solve_t env uu____29002 wl
                 | (FStar_Syntax_Syntax.Total
                    (t1,uu____29005),FStar_Syntax_Syntax.GTotal
                    (t2,uu____29007)) ->
                     let uu____29024 = FStar_Thunk.mkv "GTot =/= Tot"  in
                     giveup env uu____29024 orig
                 | (FStar_Syntax_Syntax.GTotal
                    uu____29027,FStar_Syntax_Syntax.Comp uu____29028) ->
                     let uu____29037 =
                       let uu___3790_29040 = problem  in
                       let uu____29043 =
                         let uu____29044 =
                           FStar_TypeChecker_Env.comp_to_comp_typ env c11  in
                         FStar_All.pipe_left FStar_Syntax_Syntax.mk_Comp
                           uu____29044
                          in
                       {
                         FStar_TypeChecker_Common.pid =
                           (uu___3790_29040.FStar_TypeChecker_Common.pid);
                         FStar_TypeChecker_Common.lhs = uu____29043;
                         FStar_TypeChecker_Common.relation =
                           (uu___3790_29040.FStar_TypeChecker_Common.relation);
                         FStar_TypeChecker_Common.rhs =
                           (uu___3790_29040.FStar_TypeChecker_Common.rhs);
                         FStar_TypeChecker_Common.element =
                           (uu___3790_29040.FStar_TypeChecker_Common.element);
                         FStar_TypeChecker_Common.logical_guard =
                           (uu___3790_29040.FStar_TypeChecker_Common.logical_guard);
                         FStar_TypeChecker_Common.logical_guard_uvar =
                           (uu___3790_29040.FStar_TypeChecker_Common.logical_guard_uvar);
                         FStar_TypeChecker_Common.reason =
                           (uu___3790_29040.FStar_TypeChecker_Common.reason);
                         FStar_TypeChecker_Common.loc =
                           (uu___3790_29040.FStar_TypeChecker_Common.loc);
                         FStar_TypeChecker_Common.rank =
                           (uu___3790_29040.FStar_TypeChecker_Common.rank)
                       }  in
                     solve_c env uu____29037 wl
                 | (FStar_Syntax_Syntax.Total
                    uu____29045,FStar_Syntax_Syntax.Comp uu____29046) ->
                     let uu____29055 =
                       let uu___3790_29058 = problem  in
                       let uu____29061 =
                         let uu____29062 =
                           FStar_TypeChecker_Env.comp_to_comp_typ env c11  in
                         FStar_All.pipe_left FStar_Syntax_Syntax.mk_Comp
                           uu____29062
                          in
                       {
                         FStar_TypeChecker_Common.pid =
                           (uu___3790_29058.FStar_TypeChecker_Common.pid);
                         FStar_TypeChecker_Common.lhs = uu____29061;
                         FStar_TypeChecker_Common.relation =
                           (uu___3790_29058.FStar_TypeChecker_Common.relation);
                         FStar_TypeChecker_Common.rhs =
                           (uu___3790_29058.FStar_TypeChecker_Common.rhs);
                         FStar_TypeChecker_Common.element =
                           (uu___3790_29058.FStar_TypeChecker_Common.element);
                         FStar_TypeChecker_Common.logical_guard =
                           (uu___3790_29058.FStar_TypeChecker_Common.logical_guard);
                         FStar_TypeChecker_Common.logical_guard_uvar =
                           (uu___3790_29058.FStar_TypeChecker_Common.logical_guard_uvar);
                         FStar_TypeChecker_Common.reason =
                           (uu___3790_29058.FStar_TypeChecker_Common.reason);
                         FStar_TypeChecker_Common.loc =
                           (uu___3790_29058.FStar_TypeChecker_Common.loc);
                         FStar_TypeChecker_Common.rank =
                           (uu___3790_29058.FStar_TypeChecker_Common.rank)
                       }  in
                     solve_c env uu____29055 wl
                 | (FStar_Syntax_Syntax.Comp
                    uu____29063,FStar_Syntax_Syntax.GTotal uu____29064) ->
                     let uu____29073 =
                       let uu___3802_29076 = problem  in
                       let uu____29079 =
                         let uu____29080 =
                           FStar_TypeChecker_Env.comp_to_comp_typ env c21  in
                         FStar_All.pipe_left FStar_Syntax_Syntax.mk_Comp
                           uu____29080
                          in
                       {
                         FStar_TypeChecker_Common.pid =
                           (uu___3802_29076.FStar_TypeChecker_Common.pid);
                         FStar_TypeChecker_Common.lhs =
                           (uu___3802_29076.FStar_TypeChecker_Common.lhs);
                         FStar_TypeChecker_Common.relation =
                           (uu___3802_29076.FStar_TypeChecker_Common.relation);
                         FStar_TypeChecker_Common.rhs = uu____29079;
                         FStar_TypeChecker_Common.element =
                           (uu___3802_29076.FStar_TypeChecker_Common.element);
                         FStar_TypeChecker_Common.logical_guard =
                           (uu___3802_29076.FStar_TypeChecker_Common.logical_guard);
                         FStar_TypeChecker_Common.logical_guard_uvar =
                           (uu___3802_29076.FStar_TypeChecker_Common.logical_guard_uvar);
                         FStar_TypeChecker_Common.reason =
                           (uu___3802_29076.FStar_TypeChecker_Common.reason);
                         FStar_TypeChecker_Common.loc =
                           (uu___3802_29076.FStar_TypeChecker_Common.loc);
                         FStar_TypeChecker_Common.rank =
                           (uu___3802_29076.FStar_TypeChecker_Common.rank)
                       }  in
                     solve_c env uu____29073 wl
                 | (FStar_Syntax_Syntax.Comp
                    uu____29081,FStar_Syntax_Syntax.Total uu____29082) ->
                     let uu____29091 =
                       let uu___3802_29094 = problem  in
                       let uu____29097 =
                         let uu____29098 =
                           FStar_TypeChecker_Env.comp_to_comp_typ env c21  in
                         FStar_All.pipe_left FStar_Syntax_Syntax.mk_Comp
                           uu____29098
                          in
                       {
                         FStar_TypeChecker_Common.pid =
                           (uu___3802_29094.FStar_TypeChecker_Common.pid);
                         FStar_TypeChecker_Common.lhs =
                           (uu___3802_29094.FStar_TypeChecker_Common.lhs);
                         FStar_TypeChecker_Common.relation =
                           (uu___3802_29094.FStar_TypeChecker_Common.relation);
                         FStar_TypeChecker_Common.rhs = uu____29097;
                         FStar_TypeChecker_Common.element =
                           (uu___3802_29094.FStar_TypeChecker_Common.element);
                         FStar_TypeChecker_Common.logical_guard =
                           (uu___3802_29094.FStar_TypeChecker_Common.logical_guard);
                         FStar_TypeChecker_Common.logical_guard_uvar =
                           (uu___3802_29094.FStar_TypeChecker_Common.logical_guard_uvar);
                         FStar_TypeChecker_Common.reason =
                           (uu___3802_29094.FStar_TypeChecker_Common.reason);
                         FStar_TypeChecker_Common.loc =
                           (uu___3802_29094.FStar_TypeChecker_Common.loc);
                         FStar_TypeChecker_Common.rank =
                           (uu___3802_29094.FStar_TypeChecker_Common.rank)
                       }  in
                     solve_c env uu____29091 wl
                 | (FStar_Syntax_Syntax.Comp
                    uu____29099,FStar_Syntax_Syntax.Comp uu____29100) ->
                     let uu____29101 =
                       (((FStar_Syntax_Util.is_ml_comp c11) &&
                           (FStar_Syntax_Util.is_ml_comp c21))
                          ||
                          ((FStar_Syntax_Util.is_total_comp c11) &&
                             (FStar_Syntax_Util.is_total_comp c21)))
                         ||
                         (((FStar_Syntax_Util.is_total_comp c11) &&
                             (FStar_Syntax_Util.is_ml_comp c21))
                            &&
                            (problem.FStar_TypeChecker_Common.relation =
                               FStar_TypeChecker_Common.SUB))
                        in
                     if uu____29101
                     then
                       let uu____29104 =
                         problem_using_guard orig
                           (FStar_Syntax_Util.comp_result c11)
                           problem.FStar_TypeChecker_Common.relation
                           (FStar_Syntax_Util.comp_result c21)
                           FStar_Pervasives_Native.None "result type"
                          in
                       solve_t env uu____29104 wl
                     else
                       (let c1_comp =
                          FStar_TypeChecker_Env.comp_to_comp_typ env c11  in
                        let c2_comp =
                          FStar_TypeChecker_Env.comp_to_comp_typ env c21  in
                        if
                          problem.FStar_TypeChecker_Common.relation =
                            FStar_TypeChecker_Common.EQ
                        then
                          let uu____29111 =
                            let uu____29116 =
                              FStar_Ident.lid_equals
                                c1_comp.FStar_Syntax_Syntax.effect_name
                                c2_comp.FStar_Syntax_Syntax.effect_name
                               in
                            if uu____29116
                            then (c1_comp, c2_comp)
                            else
                              (let uu____29125 =
                                 FStar_TypeChecker_Env.unfold_effect_abbrev
                                   env c11
                                  in
                               let uu____29126 =
                                 FStar_TypeChecker_Env.unfold_effect_abbrev
                                   env c21
                                  in
                               (uu____29125, uu____29126))
                             in
                          match uu____29111 with
                          | (c1_comp1,c2_comp1) ->
                              solve_eq c1_comp1 c2_comp1
                                FStar_TypeChecker_Env.trivial_guard
                        else
                          (let c12 =
                             FStar_TypeChecker_Env.unfold_effect_abbrev env
                               c11
                              in
                           let c22 =
                             FStar_TypeChecker_Env.unfold_effect_abbrev env
                               c21
                              in
                           (let uu____29134 =
                              FStar_All.pipe_left
                                (FStar_TypeChecker_Env.debug env)
                                (FStar_Options.Other "Rel")
                               in
                            if uu____29134
                            then
                              FStar_Util.print2 "solve_c for %s and %s\n"
                                (c12.FStar_Syntax_Syntax.effect_name).FStar_Ident.str
                                (c22.FStar_Syntax_Syntax.effect_name).FStar_Ident.str
                            else ());
                           (let uu____29142 =
                              FStar_TypeChecker_Env.monad_leq env
                                c12.FStar_Syntax_Syntax.effect_name
                                c22.FStar_Syntax_Syntax.effect_name
                               in
                            match uu____29142 with
                            | FStar_Pervasives_Native.None  ->
                                let uu____29145 =
                                  FStar_Thunk.mk
                                    (fun uu____29150  ->
                                       let uu____29151 =
                                         FStar_Syntax_Print.lid_to_string
                                           c12.FStar_Syntax_Syntax.effect_name
                                          in
                                       let uu____29153 =
                                         FStar_Syntax_Print.lid_to_string
                                           c22.FStar_Syntax_Syntax.effect_name
                                          in
                                       FStar_Util.format2
                                         "incompatible monad ordering: %s </: %s"
                                         uu____29151 uu____29153)
                                   in
                                giveup env uu____29145 orig
                            | FStar_Pervasives_Native.Some edge ->
                                solve_sub c12 edge c22))))))

let (print_pending_implicits :
  FStar_TypeChecker_Common.guard_t -> Prims.string) =
  fun g  ->
    let uu____29164 =
      FStar_All.pipe_right g.FStar_TypeChecker_Common.implicits
        (FStar_List.map
           (fun i  ->
              FStar_Syntax_Print.term_to_string
                i.FStar_TypeChecker_Common.imp_tm))
       in
    FStar_All.pipe_right uu____29164 (FStar_String.concat ", ")
  
let (ineqs_to_string :
  (FStar_Syntax_Syntax.universe Prims.list * (FStar_Syntax_Syntax.universe *
    FStar_Syntax_Syntax.universe) Prims.list) -> Prims.string)
  =
  fun ineqs  ->
    let vars =
      let uu____29214 =
        FStar_All.pipe_right (FStar_Pervasives_Native.fst ineqs)
          (FStar_List.map FStar_Syntax_Print.univ_to_string)
         in
      FStar_All.pipe_right uu____29214 (FStar_String.concat ", ")  in
    let ineqs1 =
      let uu____29239 =
        FStar_All.pipe_right (FStar_Pervasives_Native.snd ineqs)
          (FStar_List.map
             (fun uu____29270  ->
                match uu____29270 with
                | (u1,u2) ->
                    let uu____29278 = FStar_Syntax_Print.univ_to_string u1
                       in
                    let uu____29280 = FStar_Syntax_Print.univ_to_string u2
                       in
                    FStar_Util.format2 "%s < %s" uu____29278 uu____29280))
         in
      FStar_All.pipe_right uu____29239 (FStar_String.concat ", ")  in
    FStar_Util.format2 "Solving for {%s}; inequalities are {%s}" vars ineqs1
  
let (guard_to_string :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.guard_t -> Prims.string)
  =
  fun env  ->
    fun g  ->
      match ((g.FStar_TypeChecker_Common.guard_f),
              (g.FStar_TypeChecker_Common.deferred),
              (g.FStar_TypeChecker_Common.univ_ineqs))
      with
      | (FStar_TypeChecker_Common.Trivial ,[],(uu____29317,[])) when
          let uu____29344 = FStar_Options.print_implicits ()  in
          Prims.op_Negation uu____29344 -> "{}"
      | uu____29347 ->
          let form =
            match g.FStar_TypeChecker_Common.guard_f with
            | FStar_TypeChecker_Common.Trivial  -> "trivial"
            | FStar_TypeChecker_Common.NonTrivial f ->
                let uu____29374 =
                  ((FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                      (FStar_Options.Other "Rel"))
                     ||
                     (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                        FStar_Options.Extreme))
                    || (FStar_Options.print_implicits ())
                   in
                if uu____29374
                then FStar_TypeChecker_Normalize.term_to_string env f
                else "non-trivial"
             in
          let carry =
            let uu____29386 =
              FStar_List.map
                (fun uu____29399  ->
                   match uu____29399 with
                   | (uu____29406,x) -> prob_to_string env x)
                g.FStar_TypeChecker_Common.deferred
               in
            FStar_All.pipe_right uu____29386 (FStar_String.concat ",\n")  in
          let imps = print_pending_implicits g  in
          let uu____29417 =
            ineqs_to_string g.FStar_TypeChecker_Common.univ_ineqs  in
          FStar_Util.format4
            "\n\t{guard_f=%s;\n\t deferred={\n%s};\n\t univ_ineqs={%s};\n\t implicits={%s}}\n"
            form carry uu____29417 imps
  
let (new_t_problem :
  worklist ->
    FStar_TypeChecker_Env.env ->
      FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
        FStar_TypeChecker_Common.rel ->
          FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
            FStar_Syntax_Syntax.bv FStar_Pervasives_Native.option ->
              FStar_Range.range -> (FStar_TypeChecker_Common.prob * worklist))
  =
  fun wl  ->
    fun env  ->
      fun lhs  ->
        fun rel  ->
          fun rhs  ->
            fun elt  ->
              fun loc  ->
                let reason =
                  let uu____29474 =
                    (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                       (FStar_Options.Other "ExplainRel"))
                      ||
                      (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                         (FStar_Options.Other "Rel"))
                     in
                  if uu____29474
                  then
                    let uu____29482 =
                      FStar_TypeChecker_Normalize.term_to_string env lhs  in
                    let uu____29484 =
                      FStar_TypeChecker_Normalize.term_to_string env rhs  in
                    FStar_Util.format3 "Top-level:\n%s\n\t%s\n%s" uu____29482
                      (rel_to_string rel) uu____29484
                  else "TOP"  in
                let uu____29490 =
                  new_problem wl env lhs rel rhs elt loc reason  in
                match uu____29490 with
                | (p,wl1) ->
                    (def_check_prob (Prims.op_Hat "new_t_problem." reason)
                       (FStar_TypeChecker_Common.TProb p);
                     ((FStar_TypeChecker_Common.TProb p), wl1))
  
let (new_t_prob :
  worklist ->
    FStar_TypeChecker_Env.env ->
      FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
        FStar_TypeChecker_Common.rel ->
          FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
            (FStar_TypeChecker_Common.prob * FStar_Syntax_Syntax.bv *
              worklist))
  =
  fun wl  ->
    fun env  ->
      fun t1  ->
        fun rel  ->
          fun t2  ->
            let x =
              let uu____29550 =
                let uu____29553 = FStar_TypeChecker_Env.get_range env  in
                FStar_All.pipe_left
                  (fun _29556  -> FStar_Pervasives_Native.Some _29556)
                  uu____29553
                 in
              FStar_Syntax_Syntax.new_bv uu____29550 t1  in
            let uu____29557 =
              let uu____29562 = FStar_TypeChecker_Env.get_range env  in
              new_t_problem wl env t1 rel t2 (FStar_Pervasives_Native.Some x)
                uu____29562
               in
            match uu____29557 with | (p,wl1) -> (p, x, wl1)
  
let (solve_and_commit :
  FStar_TypeChecker_Env.env ->
    worklist ->
      ((FStar_TypeChecker_Common.prob * lstring) ->
         (FStar_TypeChecker_Common.deferred *
           FStar_TypeChecker_Common.implicits) FStar_Pervasives_Native.option)
        ->
        (FStar_TypeChecker_Common.deferred *
          FStar_TypeChecker_Common.implicits) FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun probs  ->
      fun err  ->
        let tx = FStar_Syntax_Unionfind.new_transaction ()  in
        (let uu____29620 =
           FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
             (FStar_Options.Other "RelBench")
            in
         if uu____29620
         then
           let uu____29625 =
             FStar_Common.string_of_list
               (fun p  -> FStar_Util.string_of_int (p_pid p))
               probs.attempting
              in
           FStar_Util.print1 "solving problems %s {\n" uu____29625
         else ());
        (let uu____29632 =
           FStar_Util.record_time (fun uu____29639  -> solve env probs)  in
         match uu____29632 with
         | (sol,ms) ->
             ((let uu____29651 =
                 FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                   (FStar_Options.Other "RelBench")
                  in
               if uu____29651
               then
                 let uu____29656 = FStar_Util.string_of_int ms  in
                 FStar_Util.print1 "} solved in %s ms\n" uu____29656
               else ());
              (match sol with
               | Success (deferred,implicits) ->
                   let uu____29669 =
                     FStar_Util.record_time
                       (fun uu____29676  -> FStar_Syntax_Unionfind.commit tx)
                      in
                   (match uu____29669 with
                    | ((),ms1) ->
                        ((let uu____29687 =
                            FStar_All.pipe_left
                              (FStar_TypeChecker_Env.debug env)
                              (FStar_Options.Other "RelBench")
                             in
                          if uu____29687
                          then
                            let uu____29692 = FStar_Util.string_of_int ms1
                               in
                            FStar_Util.print1 "committed in %s ms\n"
                              uu____29692
                          else ());
                         FStar_Pervasives_Native.Some (deferred, implicits)))
               | Failed (d,s) ->
                   ((let uu____29704 =
                       (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                          (FStar_Options.Other "ExplainRel"))
                         ||
                         (FStar_All.pipe_left
                            (FStar_TypeChecker_Env.debug env)
                            (FStar_Options.Other "Rel"))
                        in
                     if uu____29704
                     then
                       let uu____29711 = explain env d s  in
                       FStar_All.pipe_left FStar_Util.print_string
                         uu____29711
                     else ());
                    (let result = err (d, s)  in
                     FStar_Syntax_Unionfind.rollback tx; result)))))
  
let (simplify_guard :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  =
  fun env  ->
    fun g  ->
      match g.FStar_TypeChecker_Common.guard_f with
      | FStar_TypeChecker_Common.Trivial  -> g
      | FStar_TypeChecker_Common.NonTrivial f ->
          ((let uu____29737 =
              FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                (FStar_Options.Other "Simplification")
               in
            if uu____29737
            then
              let uu____29742 = FStar_Syntax_Print.term_to_string f  in
              FStar_Util.print1 "Simplifying guard %s\n" uu____29742
            else ());
           (let f1 =
              norm_with_steps "FStar.TypeChecker.Rel.norm_with_steps.6"
                [FStar_TypeChecker_Env.Beta;
                FStar_TypeChecker_Env.Eager_unfolding;
                FStar_TypeChecker_Env.Simplify;
                FStar_TypeChecker_Env.Primops;
                FStar_TypeChecker_Env.NoFullNorm] env f
               in
            (let uu____29750 =
               FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                 (FStar_Options.Other "Simplification")
                in
             if uu____29750
             then
               let uu____29755 = FStar_Syntax_Print.term_to_string f1  in
               FStar_Util.print1 "Simplified guard to %s\n" uu____29755
             else ());
            (let f2 =
               let uu____29761 =
                 let uu____29762 = FStar_Syntax_Util.unmeta f1  in
                 uu____29762.FStar_Syntax_Syntax.n  in
               match uu____29761 with
               | FStar_Syntax_Syntax.Tm_fvar fv when
                   FStar_Syntax_Syntax.fv_eq_lid fv
                     FStar_Parser_Const.true_lid
                   -> FStar_TypeChecker_Common.Trivial
               | uu____29766 -> FStar_TypeChecker_Common.NonTrivial f1  in
             let uu___3919_29767 = g  in
             {
               FStar_TypeChecker_Common.guard_f = f2;
               FStar_TypeChecker_Common.deferred =
                 (uu___3919_29767.FStar_TypeChecker_Common.deferred);
               FStar_TypeChecker_Common.univ_ineqs =
                 (uu___3919_29767.FStar_TypeChecker_Common.univ_ineqs);
               FStar_TypeChecker_Common.implicits =
                 (uu___3919_29767.FStar_TypeChecker_Common.implicits)
             })))
  
let (with_guard :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.prob ->
      (FStar_TypeChecker_Common.deferred *
        FStar_TypeChecker_Common.implicits) FStar_Pervasives_Native.option ->
        FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun prob  ->
      fun dopt  ->
        match dopt with
        | FStar_Pervasives_Native.None  -> FStar_Pervasives_Native.None
        | FStar_Pervasives_Native.Some (deferred,implicits) ->
            let uu____29810 =
              let uu____29811 =
                let uu____29812 =
                  FStar_All.pipe_right (p_guard prob)
                    (fun _29813  ->
                       FStar_TypeChecker_Common.NonTrivial _29813)
                   in
                {
                  FStar_TypeChecker_Common.guard_f = uu____29812;
                  FStar_TypeChecker_Common.deferred = deferred;
                  FStar_TypeChecker_Common.univ_ineqs = ([], []);
                  FStar_TypeChecker_Common.implicits = implicits
                }  in
              simplify_guard env uu____29811  in
            FStar_All.pipe_left
              (fun _29820  -> FStar_Pervasives_Native.Some _29820)
              uu____29810
  
let with_guard_no_simp :
  'Auu____29830 .
    'Auu____29830 ->
      FStar_TypeChecker_Common.prob ->
        (FStar_TypeChecker_Common.deferred *
          FStar_TypeChecker_Common.implicits) FStar_Pervasives_Native.option
          -> FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option
  =
  fun env  ->
    fun prob  ->
      fun dopt  ->
        match dopt with
        | FStar_Pervasives_Native.None  -> FStar_Pervasives_Native.None
        | FStar_Pervasives_Native.Some (deferred,implicits) ->
            let uu____29870 =
              let uu____29871 =
                FStar_All.pipe_right (p_guard prob)
                  (fun _29872  -> FStar_TypeChecker_Common.NonTrivial _29872)
                 in
              {
                FStar_TypeChecker_Common.guard_f = uu____29871;
                FStar_TypeChecker_Common.deferred = deferred;
                FStar_TypeChecker_Common.univ_ineqs = ([], []);
                FStar_TypeChecker_Common.implicits = implicits
              }  in
            FStar_Pervasives_Native.Some uu____29870
  
let (try_teq :
  Prims.bool ->
    FStar_TypeChecker_Env.env ->
      FStar_Syntax_Syntax.typ ->
        FStar_Syntax_Syntax.typ ->
          FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun smt_ok  ->
    fun env  ->
      fun t1  ->
        fun t2  ->
          (let uu____29905 =
             FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
               (FStar_Options.Other "Rel")
              in
           if uu____29905
           then
             let uu____29910 = FStar_Syntax_Print.term_to_string t1  in
             let uu____29912 = FStar_Syntax_Print.term_to_string t2  in
             FStar_Util.print2 "try_teq of %s and %s {\n" uu____29910
               uu____29912
           else ());
          (let uu____29917 =
             let uu____29922 = FStar_TypeChecker_Env.get_range env  in
             new_t_problem (empty_worklist env) env t1
               FStar_TypeChecker_Common.EQ t2 FStar_Pervasives_Native.None
               uu____29922
              in
           match uu____29917 with
           | (prob,wl) ->
               let g =
                 let uu____29930 =
                   solve_and_commit env (singleton wl prob smt_ok)
                     (fun uu____29938  -> FStar_Pervasives_Native.None)
                    in
                 FStar_All.pipe_left (with_guard env prob) uu____29930  in
               ((let uu____29956 =
                   FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                     (FStar_Options.Other "Rel")
                    in
                 if uu____29956
                 then
                   let uu____29961 =
                     FStar_Common.string_of_option (guard_to_string env) g
                      in
                   FStar_Util.print1 "} res = %s\n" uu____29961
                 else ());
                g))
  
let (teq :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ ->
      FStar_Syntax_Syntax.typ -> FStar_TypeChecker_Common.guard_t)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        let uu____29982 = try_teq true env t1 t2  in
        match uu____29982 with
        | FStar_Pervasives_Native.None  ->
            ((let uu____29987 = FStar_TypeChecker_Env.get_range env  in
              let uu____29988 =
                FStar_TypeChecker_Err.basic_type_error env
                  FStar_Pervasives_Native.None t2 t1
                 in
              FStar_Errors.log_issue uu____29987 uu____29988);
             FStar_TypeChecker_Common.trivial_guard)
        | FStar_Pervasives_Native.Some g ->
            ((let uu____29996 =
                FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                  (FStar_Options.Other "Rel")
                 in
              if uu____29996
              then
                let uu____30001 = FStar_Syntax_Print.term_to_string t1  in
                let uu____30003 = FStar_Syntax_Print.term_to_string t2  in
                let uu____30005 = guard_to_string env g  in
                FStar_Util.print3
                  "teq of %s and %s succeeded with guard %s\n" uu____30001
                  uu____30003 uu____30005
              else ());
             g)
  
let (get_teq_predicate :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ ->
      FStar_Syntax_Syntax.typ ->
        FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        (let uu____30029 =
           FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
             (FStar_Options.Other "Rel")
            in
         if uu____30029
         then
           let uu____30034 = FStar_Syntax_Print.term_to_string t1  in
           let uu____30036 = FStar_Syntax_Print.term_to_string t2  in
           FStar_Util.print2 "get_teq_predicate of %s and %s {\n" uu____30034
             uu____30036
         else ());
        (let uu____30041 =
           new_t_prob (empty_worklist env) env t1 FStar_TypeChecker_Common.EQ
             t2
            in
         match uu____30041 with
         | (prob,x,wl) ->
             let g =
               let uu____30056 =
                 solve_and_commit env (singleton wl prob true)
                   (fun uu____30065  -> FStar_Pervasives_Native.None)
                  in
               FStar_All.pipe_left (with_guard env prob) uu____30056  in
             ((let uu____30083 =
                 FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                   (FStar_Options.Other "Rel")
                  in
               if uu____30083
               then
                 let uu____30088 =
                   FStar_Common.string_of_option (guard_to_string env) g  in
                 FStar_Util.print1 "} res teq predicate = %s\n" uu____30088
               else ());
              (match g with
               | FStar_Pervasives_Native.None  ->
                   FStar_Pervasives_Native.None
               | FStar_Pervasives_Native.Some g1 ->
                   let uu____30096 =
                     let uu____30097 = FStar_Syntax_Syntax.mk_binder x  in
                     FStar_TypeChecker_Env.abstract_guard uu____30097 g1  in
                   FStar_Pervasives_Native.Some uu____30096)))
  
let (subtype_fail :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term ->
      FStar_Syntax_Syntax.typ -> FStar_Syntax_Syntax.typ -> unit)
  =
  fun env  ->
    fun e  ->
      fun t1  ->
        fun t2  ->
          let uu____30119 = FStar_TypeChecker_Env.get_range env  in
          let uu____30120 =
            FStar_TypeChecker_Err.basic_type_error env
              (FStar_Pervasives_Native.Some e) t2 t1
             in
          FStar_Errors.log_issue uu____30119 uu____30120
  
let (sub_comp :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.comp ->
      FStar_Syntax_Syntax.comp ->
        FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun c1  ->
      fun c2  ->
        let rel =
          if env.FStar_TypeChecker_Env.use_eq
          then FStar_TypeChecker_Common.EQ
          else FStar_TypeChecker_Common.SUB  in
        (let uu____30149 =
           FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
             (FStar_Options.Other "Rel")
            in
         if uu____30149
         then
           let uu____30154 = FStar_Syntax_Print.comp_to_string c1  in
           let uu____30156 = FStar_Syntax_Print.comp_to_string c2  in
           FStar_Util.print3 "sub_comp of %s --and-- %s --with-- %s\n"
             uu____30154 uu____30156
             (if rel = FStar_TypeChecker_Common.EQ then "EQ" else "SUB")
         else ());
        (let uu____30167 =
           let uu____30174 = FStar_TypeChecker_Env.get_range env  in
           new_problem (empty_worklist env) env c1 rel c2
             FStar_Pervasives_Native.None uu____30174 "sub_comp"
            in
         match uu____30167 with
         | (prob,wl) ->
             let prob1 = FStar_TypeChecker_Common.CProb prob  in
             (def_check_prob "sub_comp" prob1;
              (let uu____30187 =
                 FStar_Util.record_time
                   (fun uu____30199  ->
                      let uu____30200 =
                        solve_and_commit env (singleton wl prob1 true)
                          (fun uu____30209  -> FStar_Pervasives_Native.None)
                         in
                      FStar_All.pipe_left (with_guard env prob1) uu____30200)
                  in
               match uu____30187 with
               | (r,ms) ->
                   ((let uu____30237 =
                       FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                         (FStar_Options.Other "RelBench")
                        in
                     if uu____30237
                     then
                       let uu____30242 = FStar_Syntax_Print.comp_to_string c1
                          in
                       let uu____30244 = FStar_Syntax_Print.comp_to_string c2
                          in
                       let uu____30246 = FStar_Util.string_of_int ms  in
                       FStar_Util.print4
                         "sub_comp of %s --and-- %s --with-- %s --- solved in %s ms\n"
                         uu____30242 uu____30244
                         (if rel = FStar_TypeChecker_Common.EQ
                          then "EQ"
                          else "SUB") uu____30246
                     else ());
                    r))))
  
let (solve_universe_inequalities' :
  FStar_Syntax_Unionfind.tx ->
    FStar_TypeChecker_Env.env ->
      (FStar_Syntax_Syntax.universe Prims.list *
        (FStar_Syntax_Syntax.universe * FStar_Syntax_Syntax.universe)
        Prims.list) -> unit)
  =
  fun tx  ->
    fun env  ->
      fun uu____30284  ->
        match uu____30284 with
        | (variables,ineqs) ->
            let fail1 u1 u2 =
              FStar_Syntax_Unionfind.rollback tx;
              (let uu____30327 =
                 let uu____30333 =
                   let uu____30335 = FStar_Syntax_Print.univ_to_string u1  in
                   let uu____30337 = FStar_Syntax_Print.univ_to_string u2  in
                   FStar_Util.format2 "Universe %s and %s are incompatible"
                     uu____30335 uu____30337
                    in
                 (FStar_Errors.Fatal_IncompatibleUniverse, uu____30333)  in
               let uu____30341 = FStar_TypeChecker_Env.get_range env  in
               FStar_Errors.raise_error uu____30327 uu____30341)
               in
            let equiv1 v1 v' =
              let uu____30354 =
                let uu____30359 = FStar_Syntax_Subst.compress_univ v1  in
                let uu____30360 = FStar_Syntax_Subst.compress_univ v'  in
                (uu____30359, uu____30360)  in
              match uu____30354 with
              | (FStar_Syntax_Syntax.U_unif v0,FStar_Syntax_Syntax.U_unif
                 v0') -> FStar_Syntax_Unionfind.univ_equiv v0 v0'
              | uu____30380 -> false  in
            let sols =
              FStar_All.pipe_right variables
                (FStar_List.collect
                   (fun v1  ->
                      let uu____30411 = FStar_Syntax_Subst.compress_univ v1
                         in
                      match uu____30411 with
                      | FStar_Syntax_Syntax.U_unif uu____30418 ->
                          let lower_bounds_of_v =
                            FStar_All.pipe_right ineqs
                              (FStar_List.collect
                                 (fun uu____30447  ->
                                    match uu____30447 with
                                    | (u,v') ->
                                        let uu____30456 = equiv1 v1 v'  in
                                        if uu____30456
                                        then
                                          let uu____30461 =
                                            FStar_All.pipe_right variables
                                              (FStar_Util.for_some (equiv1 u))
                                             in
                                          (if uu____30461 then [] else [u])
                                        else []))
                             in
                          let lb =
                            FStar_TypeChecker_Normalize.normalize_universe
                              env
                              (FStar_Syntax_Syntax.U_max lower_bounds_of_v)
                             in
                          [(lb, v1)]
                      | uu____30482 -> []))
               in
            let uu____30487 =
              let wl =
                let uu___4030_30491 = empty_worklist env  in
                {
                  attempting = (uu___4030_30491.attempting);
                  wl_deferred = (uu___4030_30491.wl_deferred);
                  ctr = (uu___4030_30491.ctr);
                  defer_ok = false;
                  smt_ok = (uu___4030_30491.smt_ok);
                  umax_heuristic_ok = (uu___4030_30491.umax_heuristic_ok);
                  tcenv = (uu___4030_30491.tcenv);
                  wl_implicits = (uu___4030_30491.wl_implicits)
                }  in
              FStar_All.pipe_right sols
                (FStar_List.map
                   (fun uu____30510  ->
                      match uu____30510 with
                      | (lb,v1) ->
                          let uu____30517 =
                            solve_universe_eq (~- Prims.int_one) wl lb v1  in
                          (match uu____30517 with
                           | USolved wl1 -> ()
                           | uu____30520 -> fail1 lb v1)))
               in
            let rec check_ineq uu____30531 =
              match uu____30531 with
              | (u,v1) ->
                  let u1 =
                    FStar_TypeChecker_Normalize.normalize_universe env u  in
                  let v2 =
                    FStar_TypeChecker_Normalize.normalize_universe env v1  in
                  (match (u1, v2) with
                   | (FStar_Syntax_Syntax.U_zero ,uu____30543) -> true
                   | (FStar_Syntax_Syntax.U_succ
                      u0,FStar_Syntax_Syntax.U_succ v0) ->
                       check_ineq (u0, v0)
                   | (FStar_Syntax_Syntax.U_name
                      u0,FStar_Syntax_Syntax.U_name v0) ->
                       FStar_Ident.ident_equals u0 v0
                   | (FStar_Syntax_Syntax.U_unif
                      u0,FStar_Syntax_Syntax.U_unif v0) ->
                       FStar_Syntax_Unionfind.univ_equiv u0 v0
                   | (FStar_Syntax_Syntax.U_name
                      uu____30567,FStar_Syntax_Syntax.U_succ v0) ->
                       check_ineq (u1, v0)
                   | (FStar_Syntax_Syntax.U_unif
                      uu____30569,FStar_Syntax_Syntax.U_succ v0) ->
                       check_ineq (u1, v0)
                   | (FStar_Syntax_Syntax.U_max us,uu____30580) ->
                       FStar_All.pipe_right us
                         (FStar_Util.for_all (fun u2  -> check_ineq (u2, v2)))
                   | (uu____30588,FStar_Syntax_Syntax.U_max vs) ->
                       FStar_All.pipe_right vs
                         (FStar_Util.for_some
                            (fun v3  -> check_ineq (u1, v3)))
                   | uu____30597 -> false)
               in
            let uu____30603 =
              FStar_All.pipe_right ineqs
                (FStar_Util.for_all
                   (fun uu____30620  ->
                      match uu____30620 with
                      | (u,v1) ->
                          let uu____30628 = check_ineq (u, v1)  in
                          if uu____30628
                          then true
                          else
                            ((let uu____30636 =
                                FStar_All.pipe_left
                                  (FStar_TypeChecker_Env.debug env)
                                  (FStar_Options.Other "GenUniverses")
                                 in
                              if uu____30636
                              then
                                let uu____30641 =
                                  FStar_Syntax_Print.univ_to_string u  in
                                let uu____30643 =
                                  FStar_Syntax_Print.univ_to_string v1  in
                                FStar_Util.print2 "%s </= %s" uu____30641
                                  uu____30643
                              else ());
                             false)))
               in
            if uu____30603
            then ()
            else
              ((let uu____30653 =
                  FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                    (FStar_Options.Other "GenUniverses")
                   in
                if uu____30653
                then
                  ((let uu____30659 = ineqs_to_string (variables, ineqs)  in
                    FStar_Util.print1
                      "Partially solved inequality constraints are: %s\n"
                      uu____30659);
                   FStar_Syntax_Unionfind.rollback tx;
                   (let uu____30671 = ineqs_to_string (variables, ineqs)  in
                    FStar_Util.print1
                      "Original solved inequality constraints are: %s\n"
                      uu____30671))
                else ());
               (let uu____30684 = FStar_TypeChecker_Env.get_range env  in
                FStar_Errors.raise_error
                  (FStar_Errors.Fatal_FailToSolveUniverseInEquality,
                    "Failed to solve universe inequalities for inductives")
                  uu____30684))
  
let (solve_universe_inequalities :
  FStar_TypeChecker_Env.env ->
    (FStar_Syntax_Syntax.universe Prims.list * (FStar_Syntax_Syntax.universe
      * FStar_Syntax_Syntax.universe) Prims.list) -> unit)
  =
  fun env  ->
    fun ineqs  ->
      let tx = FStar_Syntax_Unionfind.new_transaction ()  in
      solve_universe_inequalities' tx env ineqs;
      FStar_Syntax_Unionfind.commit tx
  
let (try_solve_deferred_constraints :
  Prims.bool ->
    FStar_TypeChecker_Env.env ->
      FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  =
  fun defer_ok  ->
    fun env  ->
      fun g  ->
        let fail1 uu____30757 =
          match uu____30757 with
          | (d,s) ->
              let msg = explain env d s  in
              FStar_Errors.raise_error
                (FStar_Errors.Fatal_ErrorInSolveDeferredConstraints, msg)
                (p_loc d)
           in
        let wl =
          let uu___4107_30780 =
            wl_of_guard env g.FStar_TypeChecker_Common.deferred  in
          {
            attempting = (uu___4107_30780.attempting);
            wl_deferred = (uu___4107_30780.wl_deferred);
            ctr = (uu___4107_30780.ctr);
            defer_ok;
            smt_ok = (uu___4107_30780.smt_ok);
            umax_heuristic_ok = (uu___4107_30780.umax_heuristic_ok);
            tcenv = (uu___4107_30780.tcenv);
            wl_implicits = (uu___4107_30780.wl_implicits)
          }  in
        (let uu____30783 =
           FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
             (FStar_Options.Other "Rel")
            in
         if uu____30783
         then
           let uu____30788 = FStar_Util.string_of_bool defer_ok  in
           let uu____30790 = wl_to_string wl  in
           let uu____30792 =
             FStar_Util.string_of_int
               (FStar_List.length g.FStar_TypeChecker_Common.implicits)
              in
           FStar_Util.print3
             "Trying to solve carried problems (defer_ok=%s): begin\n\t%s\nend\n and %s implicits\n"
             uu____30788 uu____30790 uu____30792
         else ());
        (let g1 =
           let uu____30798 = solve_and_commit env wl fail1  in
           match uu____30798 with
           | FStar_Pervasives_Native.Some
               (uu____30805::uu____30806,uu____30807) when
               Prims.op_Negation defer_ok ->
               failwith "Impossible: Unexpected deferred constraints remain"
           | FStar_Pervasives_Native.Some (deferred,imps) ->
               let uu___4122_30836 = g  in
               {
                 FStar_TypeChecker_Common.guard_f =
                   (uu___4122_30836.FStar_TypeChecker_Common.guard_f);
                 FStar_TypeChecker_Common.deferred = deferred;
                 FStar_TypeChecker_Common.univ_ineqs =
                   (uu___4122_30836.FStar_TypeChecker_Common.univ_ineqs);
                 FStar_TypeChecker_Common.implicits =
                   (FStar_List.append g.FStar_TypeChecker_Common.implicits
                      imps)
               }
           | uu____30837 ->
               failwith "Impossible: should have raised a failure already"
            in
         solve_universe_inequalities env
           g1.FStar_TypeChecker_Common.univ_ineqs;
         (let uu___4127_30846 = g1  in
          {
            FStar_TypeChecker_Common.guard_f =
              (uu___4127_30846.FStar_TypeChecker_Common.guard_f);
            FStar_TypeChecker_Common.deferred =
              (uu___4127_30846.FStar_TypeChecker_Common.deferred);
            FStar_TypeChecker_Common.univ_ineqs = ([], []);
            FStar_TypeChecker_Common.implicits =
              (uu___4127_30846.FStar_TypeChecker_Common.implicits)
          }))
  
let (solve_deferred_constraints :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  = fun env  -> fun g  -> try_solve_deferred_constraints false env g 
let (solve_some_deferred_constraints :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  = fun env  -> fun g  -> try_solve_deferred_constraints true env g 
let (discharge_guard' :
  (unit -> Prims.string) FStar_Pervasives_Native.option ->
    FStar_TypeChecker_Env.env ->
      FStar_TypeChecker_Common.guard_t ->
        Prims.bool ->
          FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun use_env_range_msg  ->
    fun env  ->
      fun g  ->
        fun use_smt  ->
          let debug1 =
            ((FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                (FStar_Options.Other "Rel"))
               ||
               (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                  (FStar_Options.Other "SMTQuery")))
              ||
              (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                 (FStar_Options.Other "Tac"))
             in
          let g1 = solve_deferred_constraints env g  in
          let ret_g =
            let uu___4139_30923 = g1  in
            {
              FStar_TypeChecker_Common.guard_f =
                FStar_TypeChecker_Common.Trivial;
              FStar_TypeChecker_Common.deferred =
                (uu___4139_30923.FStar_TypeChecker_Common.deferred);
              FStar_TypeChecker_Common.univ_ineqs =
                (uu___4139_30923.FStar_TypeChecker_Common.univ_ineqs);
              FStar_TypeChecker_Common.implicits =
                (uu___4139_30923.FStar_TypeChecker_Common.implicits)
            }  in
          let uu____30924 =
            let uu____30926 = FStar_TypeChecker_Env.should_verify env  in
            Prims.op_Negation uu____30926  in
          if uu____30924
          then FStar_Pervasives_Native.Some ret_g
          else
            (match g1.FStar_TypeChecker_Common.guard_f with
             | FStar_TypeChecker_Common.Trivial  ->
                 FStar_Pervasives_Native.Some ret_g
             | FStar_TypeChecker_Common.NonTrivial vc ->
                 (if debug1
                  then
                    (let uu____30938 = FStar_TypeChecker_Env.get_range env
                        in
                     let uu____30939 =
                       let uu____30941 = FStar_Syntax_Print.term_to_string vc
                          in
                       FStar_Util.format1 "Before normalization VC=\n%s\n"
                         uu____30941
                        in
                     FStar_Errors.diag uu____30938 uu____30939)
                  else ();
                  (let vc1 =
                     let uu____30947 =
                       let uu____30951 =
                         let uu____30953 =
                           FStar_TypeChecker_Env.current_module env  in
                         FStar_Ident.string_of_lid uu____30953  in
                       FStar_Pervasives_Native.Some uu____30951  in
                     FStar_Profiling.profile
                       (fun uu____30956  ->
                          FStar_TypeChecker_Normalize.normalize
                            [FStar_TypeChecker_Env.Eager_unfolding;
                            FStar_TypeChecker_Env.Simplify;
                            FStar_TypeChecker_Env.Primops] env vc)
                       uu____30947 "FStar.TypeChecker.Rel.vc_normalization"
                      in
                   if debug1
                   then
                     (let uu____30960 = FStar_TypeChecker_Env.get_range env
                         in
                      let uu____30961 =
                        let uu____30963 =
                          FStar_Syntax_Print.term_to_string vc1  in
                        FStar_Util.format1 "After normalization VC=\n%s\n"
                          uu____30963
                         in
                      FStar_Errors.diag uu____30960 uu____30961)
                   else ();
                   (let uu____30969 = FStar_TypeChecker_Env.get_range env  in
                    FStar_TypeChecker_Env.def_check_closed_in_env uu____30969
                      "discharge_guard'" env vc1);
                   (let uu____30971 =
                      FStar_TypeChecker_Common.check_trivial vc1  in
                    match uu____30971 with
                    | FStar_TypeChecker_Common.Trivial  ->
                        FStar_Pervasives_Native.Some ret_g
                    | FStar_TypeChecker_Common.NonTrivial vc2 ->
                        if Prims.op_Negation use_smt
                        then
                          (if debug1
                           then
                             (let uu____30980 =
                                FStar_TypeChecker_Env.get_range env  in
                              let uu____30981 =
                                let uu____30983 =
                                  FStar_Syntax_Print.term_to_string vc2  in
                                FStar_Util.format1
                                  "Cannot solve without SMT : %s\n"
                                  uu____30983
                                 in
                              FStar_Errors.diag uu____30980 uu____30981)
                           else ();
                           FStar_Pervasives_Native.None)
                        else
                          (if debug1
                           then
                             (let uu____30993 =
                                FStar_TypeChecker_Env.get_range env  in
                              let uu____30994 =
                                let uu____30996 =
                                  FStar_Syntax_Print.term_to_string vc2  in
                                FStar_Util.format1 "Checking VC=\n%s\n"
                                  uu____30996
                                 in
                              FStar_Errors.diag uu____30993 uu____30994)
                           else ();
                           (let vcs =
                              let uu____31010 = FStar_Options.use_tactics ()
                                 in
                              if uu____31010
                              then
                                FStar_Options.with_saved_options
                                  (fun uu____31032  ->
                                     (let uu____31034 =
                                        FStar_Options.set_options
                                          "--no_tactics"
                                         in
                                      FStar_All.pipe_left (fun a1  -> ())
                                        uu____31034);
                                     (let vcs =
                                        (env.FStar_TypeChecker_Env.solver).FStar_TypeChecker_Env.preprocess
                                          env vc2
                                         in
                                      FStar_All.pipe_right vcs
                                        (FStar_List.map
                                           (fun uu____31078  ->
                                              match uu____31078 with
                                              | (env1,goal,opts) ->
                                                  let uu____31094 =
                                                    norm_with_steps
                                                      "FStar.TypeChecker.Rel.norm_with_steps.7"
                                                      [FStar_TypeChecker_Env.Simplify;
                                                      FStar_TypeChecker_Env.Primops]
                                                      env1 goal
                                                     in
                                                  (env1, uu____31094, opts)))))
                              else
                                (let uu____31098 =
                                   let uu____31105 = FStar_Options.peek ()
                                      in
                                   (env, vc2, uu____31105)  in
                                 [uu____31098])
                               in
                            FStar_All.pipe_right vcs
                              (FStar_List.iter
                                 (fun uu____31138  ->
                                    match uu____31138 with
                                    | (env1,goal,opts) ->
                                        let uu____31148 =
                                          FStar_TypeChecker_Common.check_trivial
                                            goal
                                           in
                                        (match uu____31148 with
                                         | FStar_TypeChecker_Common.Trivial 
                                             ->
                                             if debug1
                                             then
                                               FStar_Util.print_string
                                                 "Goal completely solved by tactic\n"
                                             else ()
                                         | FStar_TypeChecker_Common.NonTrivial
                                             goal1 ->
                                             (FStar_Options.push ();
                                              FStar_Options.set opts;
                                              if debug1
                                              then
                                                (let uu____31159 =
                                                   FStar_TypeChecker_Env.get_range
                                                     env1
                                                    in
                                                 let uu____31160 =
                                                   let uu____31162 =
                                                     FStar_Syntax_Print.term_to_string
                                                       goal1
                                                      in
                                                   let uu____31164 =
                                                     FStar_TypeChecker_Env.string_of_proof_ns
                                                       env1
                                                      in
                                                   FStar_Util.format2
                                                     "Trying to solve:\n> %s\nWith proof_ns:\n %s\n"
                                                     uu____31162 uu____31164
                                                    in
                                                 FStar_Errors.diag
                                                   uu____31159 uu____31160)
                                              else ();
                                              if debug1
                                              then
                                                (let uu____31171 =
                                                   FStar_TypeChecker_Env.get_range
                                                     env1
                                                    in
                                                 let uu____31172 =
                                                   let uu____31174 =
                                                     FStar_Syntax_Print.term_to_string
                                                       goal1
                                                      in
                                                   FStar_Util.format1
                                                     "Before calling solver VC=\n%s\n"
                                                     uu____31174
                                                    in
                                                 FStar_Errors.diag
                                                   uu____31171 uu____31172)
                                              else ();
                                              (env1.FStar_TypeChecker_Env.solver).FStar_TypeChecker_Env.solve
                                                use_env_range_msg env1 goal1;
                                              FStar_Options.pop ())))));
                           FStar_Pervasives_Native.Some ret_g)))))
  
let (discharge_guard_no_smt :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  =
  fun env  ->
    fun g  ->
      let uu____31192 =
        discharge_guard' FStar_Pervasives_Native.None env g false  in
      match uu____31192 with
      | FStar_Pervasives_Native.Some g1 -> g1
      | FStar_Pervasives_Native.None  ->
          let uu____31201 = FStar_TypeChecker_Env.get_range env  in
          FStar_Errors.raise_error
            (FStar_Errors.Fatal_ExpectTrivialPreCondition,
              "Expected a trivial pre-condition") uu____31201
  
let (discharge_guard :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  =
  fun env  ->
    fun g  ->
      let uu____31215 =
        discharge_guard' FStar_Pervasives_Native.None env g true  in
      match uu____31215 with
      | FStar_Pervasives_Native.Some g1 -> g1
      | FStar_Pervasives_Native.None  ->
          failwith
            "Impossible, with use_smt = true, discharge_guard' should never have returned None"
  
let (teq_nosmt :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ ->
      FStar_Syntax_Syntax.typ ->
        FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        let uu____31245 = try_teq false env t1 t2  in
        match uu____31245 with
        | FStar_Pervasives_Native.None  -> FStar_Pervasives_Native.None
        | FStar_Pervasives_Native.Some g ->
            discharge_guard' FStar_Pervasives_Native.None env g false
  
let (resolve_implicits' :
  FStar_TypeChecker_Env.env ->
    Prims.bool ->
      Prims.bool ->
        FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  =
  fun env  ->
    fun must_total  ->
      fun forcelax  ->
        fun g  ->
          let rec unresolved ctx_u =
            let uu____31289 =
              FStar_Syntax_Unionfind.find
                ctx_u.FStar_Syntax_Syntax.ctx_uvar_head
               in
            match uu____31289 with
            | FStar_Pervasives_Native.Some r ->
                (match ctx_u.FStar_Syntax_Syntax.ctx_uvar_meta with
                 | FStar_Pervasives_Native.None  -> false
                 | FStar_Pervasives_Native.Some uu____31302 ->
                     let uu____31315 =
                       let uu____31316 = FStar_Syntax_Subst.compress r  in
                       uu____31316.FStar_Syntax_Syntax.n  in
                     (match uu____31315 with
                      | FStar_Syntax_Syntax.Tm_uvar (ctx_u',uu____31321) ->
                          unresolved ctx_u'
                      | uu____31338 -> false))
            | FStar_Pervasives_Native.None  -> true  in
          let rec until_fixpoint acc implicits =
            let uu____31362 = acc  in
            match uu____31362 with
            | (out,changed) ->
                (match implicits with
                 | [] ->
                     if Prims.op_Negation changed
                     then out
                     else until_fixpoint ([], false) out
                 | hd1::tl1 ->
                     let uu____31381 = hd1  in
                     (match uu____31381 with
                      | { FStar_TypeChecker_Common.imp_reason = reason;
                          FStar_TypeChecker_Common.imp_uvar = ctx_u;
                          FStar_TypeChecker_Common.imp_tm = tm;
                          FStar_TypeChecker_Common.imp_range = r;_} ->
                          if
                            ctx_u.FStar_Syntax_Syntax.ctx_uvar_should_check =
                              FStar_Syntax_Syntax.Allow_unresolved
                          then until_fixpoint (out, true) tl1
                          else
                            (let uu____31392 = unresolved ctx_u  in
                             if uu____31392
                             then
                               match ctx_u.FStar_Syntax_Syntax.ctx_uvar_meta
                               with
                               | FStar_Pervasives_Native.None  ->
                                   until_fixpoint ((hd1 :: out), changed) tl1
                               | FStar_Pervasives_Native.Some (env_dyn,tau)
                                   ->
                                   let env1 = FStar_Dyn.undyn env_dyn  in
                                   ((let uu____31416 =
                                       FStar_TypeChecker_Env.debug env1
                                         (FStar_Options.Other "Tac")
                                        in
                                     if uu____31416
                                     then
                                       let uu____31420 =
                                         FStar_Syntax_Print.ctx_uvar_to_string
                                           ctx_u
                                          in
                                       FStar_Util.print1
                                         "Running tactic for meta-arg %s\n"
                                         uu____31420
                                     else ());
                                    (let t =
                                       env1.FStar_TypeChecker_Env.synth_hook
                                         env1
                                         (hd1.FStar_TypeChecker_Common.imp_uvar).FStar_Syntax_Syntax.ctx_uvar_typ
                                         tau
                                        in
                                     let extra =
                                       let uu____31429 = teq_nosmt env1 t tm
                                          in
                                       match uu____31429 with
                                       | FStar_Pervasives_Native.None  ->
                                           failwith
                                             "resolve_implicits: unifying with an unresolved uvar failed?"
                                       | FStar_Pervasives_Native.Some g1 ->
                                           g1.FStar_TypeChecker_Common.implicits
                                        in
                                     let ctx_u1 =
                                       let uu___4252_31439 = ctx_u  in
                                       {
                                         FStar_Syntax_Syntax.ctx_uvar_head =
                                           (uu___4252_31439.FStar_Syntax_Syntax.ctx_uvar_head);
                                         FStar_Syntax_Syntax.ctx_uvar_gamma =
                                           (uu___4252_31439.FStar_Syntax_Syntax.ctx_uvar_gamma);
                                         FStar_Syntax_Syntax.ctx_uvar_binders
                                           =
                                           (uu___4252_31439.FStar_Syntax_Syntax.ctx_uvar_binders);
                                         FStar_Syntax_Syntax.ctx_uvar_typ =
                                           (uu___4252_31439.FStar_Syntax_Syntax.ctx_uvar_typ);
                                         FStar_Syntax_Syntax.ctx_uvar_reason
                                           =
                                           (uu___4252_31439.FStar_Syntax_Syntax.ctx_uvar_reason);
                                         FStar_Syntax_Syntax.ctx_uvar_should_check
                                           =
                                           (uu___4252_31439.FStar_Syntax_Syntax.ctx_uvar_should_check);
                                         FStar_Syntax_Syntax.ctx_uvar_range =
                                           (uu___4252_31439.FStar_Syntax_Syntax.ctx_uvar_range);
                                         FStar_Syntax_Syntax.ctx_uvar_meta =
                                           FStar_Pervasives_Native.None
                                       }  in
                                     let hd2 =
                                       let uu___4255_31447 = hd1  in
                                       {
                                         FStar_TypeChecker_Common.imp_reason
                                           =
                                           (uu___4255_31447.FStar_TypeChecker_Common.imp_reason);
                                         FStar_TypeChecker_Common.imp_uvar =
                                           ctx_u1;
                                         FStar_TypeChecker_Common.imp_tm =
                                           (uu___4255_31447.FStar_TypeChecker_Common.imp_tm);
                                         FStar_TypeChecker_Common.imp_range =
                                           (uu___4255_31447.FStar_TypeChecker_Common.imp_range)
                                       }  in
                                     until_fixpoint (out, true)
                                       (FStar_List.append extra tl1)))
                             else
                               if
                                 ctx_u.FStar_Syntax_Syntax.ctx_uvar_should_check
                                   = FStar_Syntax_Syntax.Allow_untyped
                               then until_fixpoint (out, true) tl1
                               else
                                 (let env1 =
                                    let uu___4259_31458 = env  in
                                    {
                                      FStar_TypeChecker_Env.solver =
                                        (uu___4259_31458.FStar_TypeChecker_Env.solver);
                                      FStar_TypeChecker_Env.range =
                                        (uu___4259_31458.FStar_TypeChecker_Env.range);
                                      FStar_TypeChecker_Env.curmodule =
                                        (uu___4259_31458.FStar_TypeChecker_Env.curmodule);
                                      FStar_TypeChecker_Env.gamma =
                                        (ctx_u.FStar_Syntax_Syntax.ctx_uvar_gamma);
                                      FStar_TypeChecker_Env.gamma_sig =
                                        (uu___4259_31458.FStar_TypeChecker_Env.gamma_sig);
                                      FStar_TypeChecker_Env.gamma_cache =
                                        (uu___4259_31458.FStar_TypeChecker_Env.gamma_cache);
                                      FStar_TypeChecker_Env.modules =
                                        (uu___4259_31458.FStar_TypeChecker_Env.modules);
                                      FStar_TypeChecker_Env.expected_typ =
                                        (uu___4259_31458.FStar_TypeChecker_Env.expected_typ);
                                      FStar_TypeChecker_Env.sigtab =
                                        (uu___4259_31458.FStar_TypeChecker_Env.sigtab);
                                      FStar_TypeChecker_Env.attrtab =
                                        (uu___4259_31458.FStar_TypeChecker_Env.attrtab);
                                      FStar_TypeChecker_Env.instantiate_imp =
                                        (uu___4259_31458.FStar_TypeChecker_Env.instantiate_imp);
                                      FStar_TypeChecker_Env.effects =
                                        (uu___4259_31458.FStar_TypeChecker_Env.effects);
                                      FStar_TypeChecker_Env.generalize =
                                        (uu___4259_31458.FStar_TypeChecker_Env.generalize);
                                      FStar_TypeChecker_Env.letrecs =
                                        (uu___4259_31458.FStar_TypeChecker_Env.letrecs);
                                      FStar_TypeChecker_Env.top_level =
                                        (uu___4259_31458.FStar_TypeChecker_Env.top_level);
                                      FStar_TypeChecker_Env.check_uvars =
                                        (uu___4259_31458.FStar_TypeChecker_Env.check_uvars);
                                      FStar_TypeChecker_Env.use_eq =
                                        (uu___4259_31458.FStar_TypeChecker_Env.use_eq);
                                      FStar_TypeChecker_Env.use_eq_strict =
                                        (uu___4259_31458.FStar_TypeChecker_Env.use_eq_strict);
                                      FStar_TypeChecker_Env.is_iface =
                                        (uu___4259_31458.FStar_TypeChecker_Env.is_iface);
                                      FStar_TypeChecker_Env.admit =
                                        (uu___4259_31458.FStar_TypeChecker_Env.admit);
                                      FStar_TypeChecker_Env.lax =
                                        (uu___4259_31458.FStar_TypeChecker_Env.lax);
                                      FStar_TypeChecker_Env.lax_universes =
                                        (uu___4259_31458.FStar_TypeChecker_Env.lax_universes);
                                      FStar_TypeChecker_Env.phase1 =
                                        (uu___4259_31458.FStar_TypeChecker_Env.phase1);
                                      FStar_TypeChecker_Env.failhard =
                                        (uu___4259_31458.FStar_TypeChecker_Env.failhard);
                                      FStar_TypeChecker_Env.nosynth =
                                        (uu___4259_31458.FStar_TypeChecker_Env.nosynth);
                                      FStar_TypeChecker_Env.uvar_subtyping =
                                        (uu___4259_31458.FStar_TypeChecker_Env.uvar_subtyping);
                                      FStar_TypeChecker_Env.tc_term =
                                        (uu___4259_31458.FStar_TypeChecker_Env.tc_term);
                                      FStar_TypeChecker_Env.type_of =
                                        (uu___4259_31458.FStar_TypeChecker_Env.type_of);
                                      FStar_TypeChecker_Env.universe_of =
                                        (uu___4259_31458.FStar_TypeChecker_Env.universe_of);
                                      FStar_TypeChecker_Env.check_type_of =
                                        (uu___4259_31458.FStar_TypeChecker_Env.check_type_of);
                                      FStar_TypeChecker_Env.use_bv_sorts =
                                        (uu___4259_31458.FStar_TypeChecker_Env.use_bv_sorts);
                                      FStar_TypeChecker_Env.qtbl_name_and_index
                                        =
                                        (uu___4259_31458.FStar_TypeChecker_Env.qtbl_name_and_index);
                                      FStar_TypeChecker_Env.normalized_eff_names
                                        =
                                        (uu___4259_31458.FStar_TypeChecker_Env.normalized_eff_names);
                                      FStar_TypeChecker_Env.fv_delta_depths =
                                        (uu___4259_31458.FStar_TypeChecker_Env.fv_delta_depths);
                                      FStar_TypeChecker_Env.proof_ns =
                                        (uu___4259_31458.FStar_TypeChecker_Env.proof_ns);
                                      FStar_TypeChecker_Env.synth_hook =
                                        (uu___4259_31458.FStar_TypeChecker_Env.synth_hook);
                                      FStar_TypeChecker_Env.try_solve_implicits_hook
                                        =
                                        (uu___4259_31458.FStar_TypeChecker_Env.try_solve_implicits_hook);
                                      FStar_TypeChecker_Env.splice =
                                        (uu___4259_31458.FStar_TypeChecker_Env.splice);
                                      FStar_TypeChecker_Env.mpreprocess =
                                        (uu___4259_31458.FStar_TypeChecker_Env.mpreprocess);
                                      FStar_TypeChecker_Env.postprocess =
                                        (uu___4259_31458.FStar_TypeChecker_Env.postprocess);
                                      FStar_TypeChecker_Env.is_native_tactic
                                        =
                                        (uu___4259_31458.FStar_TypeChecker_Env.is_native_tactic);
                                      FStar_TypeChecker_Env.identifier_info =
                                        (uu___4259_31458.FStar_TypeChecker_Env.identifier_info);
                                      FStar_TypeChecker_Env.tc_hooks =
                                        (uu___4259_31458.FStar_TypeChecker_Env.tc_hooks);
                                      FStar_TypeChecker_Env.dsenv =
                                        (uu___4259_31458.FStar_TypeChecker_Env.dsenv);
                                      FStar_TypeChecker_Env.nbe =
                                        (uu___4259_31458.FStar_TypeChecker_Env.nbe);
                                      FStar_TypeChecker_Env.strict_args_tab =
                                        (uu___4259_31458.FStar_TypeChecker_Env.strict_args_tab);
                                      FStar_TypeChecker_Env.erasable_types_tab
                                        =
                                        (uu___4259_31458.FStar_TypeChecker_Env.erasable_types_tab)
                                    }  in
                                  let tm1 =
                                    norm_with_steps
                                      "FStar.TypeChecker.Rel.norm_with_steps.8"
                                      [FStar_TypeChecker_Env.Beta] env1 tm
                                     in
                                  let env2 =
                                    if forcelax
                                    then
                                      let uu___4264_31463 = env1  in
                                      {
                                        FStar_TypeChecker_Env.solver =
                                          (uu___4264_31463.FStar_TypeChecker_Env.solver);
                                        FStar_TypeChecker_Env.range =
                                          (uu___4264_31463.FStar_TypeChecker_Env.range);
                                        FStar_TypeChecker_Env.curmodule =
                                          (uu___4264_31463.FStar_TypeChecker_Env.curmodule);
                                        FStar_TypeChecker_Env.gamma =
                                          (uu___4264_31463.FStar_TypeChecker_Env.gamma);
                                        FStar_TypeChecker_Env.gamma_sig =
                                          (uu___4264_31463.FStar_TypeChecker_Env.gamma_sig);
                                        FStar_TypeChecker_Env.gamma_cache =
                                          (uu___4264_31463.FStar_TypeChecker_Env.gamma_cache);
                                        FStar_TypeChecker_Env.modules =
                                          (uu___4264_31463.FStar_TypeChecker_Env.modules);
                                        FStar_TypeChecker_Env.expected_typ =
                                          (uu___4264_31463.FStar_TypeChecker_Env.expected_typ);
                                        FStar_TypeChecker_Env.sigtab =
                                          (uu___4264_31463.FStar_TypeChecker_Env.sigtab);
                                        FStar_TypeChecker_Env.attrtab =
                                          (uu___4264_31463.FStar_TypeChecker_Env.attrtab);
                                        FStar_TypeChecker_Env.instantiate_imp
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.instantiate_imp);
                                        FStar_TypeChecker_Env.effects =
                                          (uu___4264_31463.FStar_TypeChecker_Env.effects);
                                        FStar_TypeChecker_Env.generalize =
                                          (uu___4264_31463.FStar_TypeChecker_Env.generalize);
                                        FStar_TypeChecker_Env.letrecs =
                                          (uu___4264_31463.FStar_TypeChecker_Env.letrecs);
                                        FStar_TypeChecker_Env.top_level =
                                          (uu___4264_31463.FStar_TypeChecker_Env.top_level);
                                        FStar_TypeChecker_Env.check_uvars =
                                          (uu___4264_31463.FStar_TypeChecker_Env.check_uvars);
                                        FStar_TypeChecker_Env.use_eq =
                                          (uu___4264_31463.FStar_TypeChecker_Env.use_eq);
                                        FStar_TypeChecker_Env.use_eq_strict =
                                          (uu___4264_31463.FStar_TypeChecker_Env.use_eq_strict);
                                        FStar_TypeChecker_Env.is_iface =
                                          (uu___4264_31463.FStar_TypeChecker_Env.is_iface);
                                        FStar_TypeChecker_Env.admit =
                                          (uu___4264_31463.FStar_TypeChecker_Env.admit);
                                        FStar_TypeChecker_Env.lax = true;
                                        FStar_TypeChecker_Env.lax_universes =
                                          (uu___4264_31463.FStar_TypeChecker_Env.lax_universes);
                                        FStar_TypeChecker_Env.phase1 =
                                          (uu___4264_31463.FStar_TypeChecker_Env.phase1);
                                        FStar_TypeChecker_Env.failhard =
                                          (uu___4264_31463.FStar_TypeChecker_Env.failhard);
                                        FStar_TypeChecker_Env.nosynth =
                                          (uu___4264_31463.FStar_TypeChecker_Env.nosynth);
                                        FStar_TypeChecker_Env.uvar_subtyping
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.uvar_subtyping);
                                        FStar_TypeChecker_Env.tc_term =
                                          (uu___4264_31463.FStar_TypeChecker_Env.tc_term);
                                        FStar_TypeChecker_Env.type_of =
                                          (uu___4264_31463.FStar_TypeChecker_Env.type_of);
                                        FStar_TypeChecker_Env.universe_of =
                                          (uu___4264_31463.FStar_TypeChecker_Env.universe_of);
                                        FStar_TypeChecker_Env.check_type_of =
                                          (uu___4264_31463.FStar_TypeChecker_Env.check_type_of);
                                        FStar_TypeChecker_Env.use_bv_sorts =
                                          (uu___4264_31463.FStar_TypeChecker_Env.use_bv_sorts);
                                        FStar_TypeChecker_Env.qtbl_name_and_index
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.qtbl_name_and_index);
                                        FStar_TypeChecker_Env.normalized_eff_names
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.normalized_eff_names);
                                        FStar_TypeChecker_Env.fv_delta_depths
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.fv_delta_depths);
                                        FStar_TypeChecker_Env.proof_ns =
                                          (uu___4264_31463.FStar_TypeChecker_Env.proof_ns);
                                        FStar_TypeChecker_Env.synth_hook =
                                          (uu___4264_31463.FStar_TypeChecker_Env.synth_hook);
                                        FStar_TypeChecker_Env.try_solve_implicits_hook
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.try_solve_implicits_hook);
                                        FStar_TypeChecker_Env.splice =
                                          (uu___4264_31463.FStar_TypeChecker_Env.splice);
                                        FStar_TypeChecker_Env.mpreprocess =
                                          (uu___4264_31463.FStar_TypeChecker_Env.mpreprocess);
                                        FStar_TypeChecker_Env.postprocess =
                                          (uu___4264_31463.FStar_TypeChecker_Env.postprocess);
                                        FStar_TypeChecker_Env.is_native_tactic
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.is_native_tactic);
                                        FStar_TypeChecker_Env.identifier_info
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.identifier_info);
                                        FStar_TypeChecker_Env.tc_hooks =
                                          (uu___4264_31463.FStar_TypeChecker_Env.tc_hooks);
                                        FStar_TypeChecker_Env.dsenv =
                                          (uu___4264_31463.FStar_TypeChecker_Env.dsenv);
                                        FStar_TypeChecker_Env.nbe =
                                          (uu___4264_31463.FStar_TypeChecker_Env.nbe);
                                        FStar_TypeChecker_Env.strict_args_tab
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.strict_args_tab);
                                        FStar_TypeChecker_Env.erasable_types_tab
                                          =
                                          (uu___4264_31463.FStar_TypeChecker_Env.erasable_types_tab)
                                      }
                                    else env1  in
                                  (let uu____31468 =
                                     FStar_All.pipe_left
                                       (FStar_TypeChecker_Env.debug env2)
                                       (FStar_Options.Other "Rel")
                                      in
                                   if uu____31468
                                   then
                                     let uu____31473 =
                                       FStar_Syntax_Print.uvar_to_string
                                         ctx_u.FStar_Syntax_Syntax.ctx_uvar_head
                                        in
                                     let uu____31475 =
                                       FStar_Syntax_Print.term_to_string tm1
                                        in
                                     let uu____31477 =
                                       FStar_Syntax_Print.term_to_string
                                         ctx_u.FStar_Syntax_Syntax.ctx_uvar_typ
                                        in
                                     let uu____31479 =
                                       FStar_Range.string_of_range r  in
                                     FStar_Util.print5
                                       "Checking uvar %s resolved to %s at type %s, introduce for %s at %s\n"
                                       uu____31473 uu____31475 uu____31477
                                       reason uu____31479
                                   else ());
                                  (let g1 =
                                     try
                                       (fun uu___4270_31486  ->
                                          match () with
                                          | () ->
                                              env2.FStar_TypeChecker_Env.check_type_of
                                                must_total env2 tm1
                                                ctx_u.FStar_Syntax_Syntax.ctx_uvar_typ)
                                         ()
                                     with
                                     | e when FStar_Errors.handleable e ->
                                         ((let uu____31493 =
                                             let uu____31503 =
                                               let uu____31511 =
                                                 let uu____31513 =
                                                   FStar_Syntax_Print.uvar_to_string
                                                     ctx_u.FStar_Syntax_Syntax.ctx_uvar_head
                                                    in
                                                 let uu____31515 =
                                                   FStar_TypeChecker_Normalize.term_to_string
                                                     env2 tm1
                                                    in
                                                 let uu____31517 =
                                                   FStar_TypeChecker_Normalize.term_to_string
                                                     env2
                                                     ctx_u.FStar_Syntax_Syntax.ctx_uvar_typ
                                                    in
                                                 FStar_Util.format3
                                                   "Failed while checking implicit %s set to %s of expected type %s"
                                                   uu____31513 uu____31515
                                                   uu____31517
                                                  in
                                               (FStar_Errors.Error_BadImplicit,
                                                 uu____31511, r)
                                                in
                                             [uu____31503]  in
                                           FStar_Errors.add_errors
                                             uu____31493);
                                          FStar_Exn.raise e)
                                      in
                                   let g' =
                                     let uu____31536 =
                                       discharge_guard'
                                         (FStar_Pervasives_Native.Some
                                            (fun uu____31547  ->
                                               let uu____31548 =
                                                 FStar_Syntax_Print.term_to_string
                                                   tm1
                                                  in
                                               let uu____31550 =
                                                 FStar_Range.string_of_range
                                                   r
                                                  in
                                               let uu____31552 =
                                                 FStar_Range.string_of_range
                                                   tm1.FStar_Syntax_Syntax.pos
                                                  in
                                               FStar_Util.format4
                                                 "%s (Introduced at %s for %s resolved at %s)"
                                                 uu____31548 uu____31550
                                                 reason uu____31552)) env2 g1
                                         true
                                        in
                                     match uu____31536 with
                                     | FStar_Pervasives_Native.Some g2 -> g2
                                     | FStar_Pervasives_Native.None  ->
                                         failwith
                                           "Impossible, with use_smt = true, discharge_guard' should never have returned None"
                                      in
                                   until_fixpoint
                                     ((FStar_List.append
                                         g'.FStar_TypeChecker_Common.implicits
                                         out), true) tl1)))))
             in
          let uu___4282_31560 = g  in
          let uu____31561 =
            until_fixpoint ([], false) g.FStar_TypeChecker_Common.implicits
             in
          {
            FStar_TypeChecker_Common.guard_f =
              (uu___4282_31560.FStar_TypeChecker_Common.guard_f);
            FStar_TypeChecker_Common.deferred =
              (uu___4282_31560.FStar_TypeChecker_Common.deferred);
            FStar_TypeChecker_Common.univ_ineqs =
              (uu___4282_31560.FStar_TypeChecker_Common.univ_ineqs);
            FStar_TypeChecker_Common.implicits = uu____31561
          }
  
let (resolve_implicits :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  =
  fun env  ->
    fun g  ->
      resolve_implicits' env
        ((Prims.op_Negation env.FStar_TypeChecker_Env.phase1) &&
           (Prims.op_Negation env.FStar_TypeChecker_Env.lax)) false g
  
let (resolve_implicits_tac :
  FStar_TypeChecker_Env.env ->
    FStar_TypeChecker_Common.guard_t -> FStar_TypeChecker_Common.guard_t)
  = fun env  -> fun g  -> resolve_implicits' env false true g 
let (force_trivial_guard :
  FStar_TypeChecker_Env.env -> FStar_TypeChecker_Common.guard_t -> unit) =
  fun env  ->
    fun g  ->
      let g1 =
        let uu____31601 = solve_deferred_constraints env g  in
        FStar_All.pipe_right uu____31601 (resolve_implicits env)  in
      match g1.FStar_TypeChecker_Common.implicits with
      | [] ->
          let uu____31602 = discharge_guard env g1  in
          FStar_All.pipe_left (fun a2  -> ()) uu____31602
      | imp::uu____31604 ->
          let uu____31607 =
            let uu____31613 =
              let uu____31615 =
                FStar_Syntax_Print.uvar_to_string
                  (imp.FStar_TypeChecker_Common.imp_uvar).FStar_Syntax_Syntax.ctx_uvar_head
                 in
              let uu____31617 =
                FStar_TypeChecker_Normalize.term_to_string env
                  (imp.FStar_TypeChecker_Common.imp_uvar).FStar_Syntax_Syntax.ctx_uvar_typ
                 in
              FStar_Util.format3
                "Failed to resolve implicit argument %s of type %s introduced for %s"
                uu____31615 uu____31617
                imp.FStar_TypeChecker_Common.imp_reason
               in
            (FStar_Errors.Fatal_FailToResolveImplicitArgument, uu____31613)
             in
          FStar_Errors.raise_error uu____31607
            imp.FStar_TypeChecker_Common.imp_range
  
let (teq_force :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ -> FStar_Syntax_Syntax.typ -> unit)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        let uu____31637 = teq env t1 t2  in
        force_trivial_guard env uu____31637
  
let (teq_nosmt_force :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ -> FStar_Syntax_Syntax.typ -> Prims.bool)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        let uu____31656 = teq_nosmt env t1 t2  in
        match uu____31656 with
        | FStar_Pervasives_Native.None  -> false
        | FStar_Pervasives_Native.Some g -> (force_trivial_guard env g; true)
  
let (universe_inequality :
  FStar_Syntax_Syntax.universe ->
    FStar_Syntax_Syntax.universe -> FStar_TypeChecker_Common.guard_t)
  =
  fun u1  ->
    fun u2  ->
      let uu___4307_31675 = FStar_TypeChecker_Common.trivial_guard  in
      {
        FStar_TypeChecker_Common.guard_f =
          (uu___4307_31675.FStar_TypeChecker_Common.guard_f);
        FStar_TypeChecker_Common.deferred =
          (uu___4307_31675.FStar_TypeChecker_Common.deferred);
        FStar_TypeChecker_Common.univ_ineqs = ([], [(u1, u2)]);
        FStar_TypeChecker_Common.implicits =
          (uu___4307_31675.FStar_TypeChecker_Common.implicits)
      }
  
let (check_subtyping :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
      FStar_Syntax_Syntax.term' FStar_Syntax_Syntax.syntax ->
        (FStar_Syntax_Syntax.bv * FStar_TypeChecker_Common.guard_t)
          FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        (let uu____31711 =
           FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
             (FStar_Options.Other "Rel")
            in
         if uu____31711
         then
           let uu____31716 =
             FStar_TypeChecker_Normalize.term_to_string env t1  in
           let uu____31718 =
             FStar_TypeChecker_Normalize.term_to_string env t2  in
           FStar_Util.print2 "check_subtyping of %s and %s\n" uu____31716
             uu____31718
         else ());
        (let uu____31723 =
           new_t_prob (empty_worklist env) env t1
             FStar_TypeChecker_Common.SUB t2
            in
         match uu____31723 with
         | (prob,x,wl) ->
             let g =
               let uu____31742 =
                 solve_and_commit env (singleton wl prob true)
                   (fun uu____31751  -> FStar_Pervasives_Native.None)
                  in
               FStar_All.pipe_left (with_guard env prob) uu____31742  in
             ((let uu____31769 =
                 (FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
                    (FStar_Options.Other "Rel"))
                   && (FStar_Util.is_some g)
                  in
               if uu____31769
               then
                 let uu____31774 =
                   FStar_TypeChecker_Normalize.term_to_string env t1  in
                 let uu____31776 =
                   FStar_TypeChecker_Normalize.term_to_string env t2  in
                 let uu____31778 =
                   let uu____31780 = FStar_Util.must g  in
                   guard_to_string env uu____31780  in
                 FStar_Util.print3
                   "check_subtyping succeeded: %s <: %s\n\tguard is %s\n"
                   uu____31774 uu____31776 uu____31778
               else ());
              (match g with
               | FStar_Pervasives_Native.None  ->
                   FStar_Pervasives_Native.None
               | FStar_Pervasives_Native.Some g1 ->
                   FStar_Pervasives_Native.Some (x, g1))))
  
let (get_subtyping_predicate :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ ->
      FStar_Syntax_Syntax.typ ->
        FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        let uu____31817 = check_subtyping env t1 t2  in
        match uu____31817 with
        | FStar_Pervasives_Native.None  -> FStar_Pervasives_Native.None
        | FStar_Pervasives_Native.Some (x,g) ->
            let uu____31836 =
              let uu____31837 = FStar_Syntax_Syntax.mk_binder x  in
              FStar_TypeChecker_Env.abstract_guard uu____31837 g  in
            FStar_Pervasives_Native.Some uu____31836
  
let (get_subtyping_prop :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ ->
      FStar_Syntax_Syntax.typ ->
        FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        let uu____31856 = check_subtyping env t1 t2  in
        match uu____31856 with
        | FStar_Pervasives_Native.None  -> FStar_Pervasives_Native.None
        | FStar_Pervasives_Native.Some (x,g) ->
            let uu____31875 =
              let uu____31876 =
                let uu____31877 = FStar_Syntax_Syntax.mk_binder x  in
                [uu____31877]  in
              FStar_TypeChecker_Env.close_guard env uu____31876 g  in
            FStar_Pervasives_Native.Some uu____31875
  
let (subtype_nosmt :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ ->
      FStar_Syntax_Syntax.typ ->
        FStar_TypeChecker_Common.guard_t FStar_Pervasives_Native.option)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        (let uu____31915 =
           FStar_All.pipe_left (FStar_TypeChecker_Env.debug env)
             (FStar_Options.Other "Rel")
            in
         if uu____31915
         then
           let uu____31920 =
             FStar_TypeChecker_Normalize.term_to_string env t1  in
           let uu____31922 =
             FStar_TypeChecker_Normalize.term_to_string env t2  in
           FStar_Util.print2 "try_subtype_no_smt of %s and %s\n" uu____31920
             uu____31922
         else ());
        (let uu____31927 =
           new_t_prob (empty_worklist env) env t1
             FStar_TypeChecker_Common.SUB t2
            in
         match uu____31927 with
         | (prob,x,wl) ->
             let g =
               let uu____31942 =
                 solve_and_commit env (singleton wl prob false)
                   (fun uu____31951  -> FStar_Pervasives_Native.None)
                  in
               FStar_All.pipe_left (with_guard env prob) uu____31942  in
             (match g with
              | FStar_Pervasives_Native.None  -> FStar_Pervasives_Native.None
              | FStar_Pervasives_Native.Some g1 ->
                  let g2 =
                    let uu____31972 =
                      let uu____31973 = FStar_Syntax_Syntax.mk_binder x  in
                      [uu____31973]  in
                    FStar_TypeChecker_Env.close_guard env uu____31972 g1  in
                  discharge_guard' FStar_Pervasives_Native.None env g2 false))
  
let (subtype_nosmt_force :
  FStar_TypeChecker_Env.env ->
    FStar_Syntax_Syntax.typ -> FStar_Syntax_Syntax.typ -> Prims.bool)
  =
  fun env  ->
    fun t1  ->
      fun t2  ->
        let uu____32014 = subtype_nosmt env t1 t2  in
        match uu____32014 with
        | FStar_Pervasives_Native.None  -> false
        | FStar_Pervasives_Native.Some g -> (force_trivial_guard env g; true)
  