open FStar_Range
open FStar_Tactics_Types
open FStar_Tactics_Result
open FStar_Tactics_Basic
open FStar_Syntax_Syntax

module N = FStar_TypeChecker_Normalize
module C = FStar_TypeChecker_Cfg
module BU = FStar_Util
module NBETerm = FStar_TypeChecker_NBETerm
module O = FStar_Options

(* These definitions are ≡ to the ones generated by F*'s extraction of the
   tactic effect.  We need them here to break a circular dependency between the
   compiler and ulib (cf. tactics meeting of 2017-08-03). *)
type 'a __tac = FStar_Tactics_Types.proofstate -> 'a __result

let r = dummyRange

type itac = FStar_TypeChecker_Cfg.psc -> FStar_Syntax_Embeddings.norm_cb -> args -> term option
type nbe_itac =  NBETerm.nbe_cbs -> NBETerm.args -> NBETerm.t option

type native_primitive_step =
    { name: FStar_Ident.lid;
      arity: Prims.int;
      strong_reduction_ok: bool;
      tactic: itac}

let perr  s   = if O.debug_any () then BU.print_error s
let perr1 s x = if O.debug_any () then BU.print1_error s x

let compiled_tactics: native_primitive_step list ref = ref []

let list_all () =
    if FStar_Options.no_plugins ()
    then []
    else !compiled_tactics

let is_native_tactic lid =
    BU.is_some (BU.try_find (fun x -> FStar_Ident.lid_equals lid x.name) !compiled_tactics)

let register_plugin (s: string) (arity: Prims.int) (t: itac) (n:nbe_itac) =
    let step =
           { C.name=FStar_Ident.lid_of_str s;
             C.arity=arity;
             C.auto_reflect=None;
             C.strong_reduction_ok=true;
             C.requires_binder_substitution = false;
             C.interpretation=t;
             C.univ_arity=Z.of_int 0; (* TODO: bogus for now, just as in Tactics.Interpreter *)
             C.interpretation_nbe = n;
          }
    in
    FStar_TypeChecker_Cfg.register_plugin step;
    perr1 "Registered plugin %s\n" s

let register_tactic (s: string) (arity: Prims.int) (t: itac)=
    let step =
        { name=FStar_Ident.lid_of_str s;
          arity = arity;
          strong_reduction_ok=true;
          tactic=t } in
    compiled_tactics := step :: !compiled_tactics;
    perr1 "Registered tactic %s\n" s

let interpret_tactic (ps: proofstate) (t: proofstate -> 'a __result) = t ps

let from_tactic_0 (t: 'b __tac): ('b tac) =
    (fun (ps: proofstate) ->
        perr "In compiled code (0)\n";
        interpret_tactic ps t) |> mk_tac

let from_tactic_1 (t: 'a -> 'b __tac): ('a -> 'b tac) =
    fun (x: 'a) ->
        (fun (ps: proofstate) ->
            perr "In compiled code (1)\n";
            interpret_tactic ps (t x)) |> mk_tac

let from_tactic_2 (t: 'a -> 'b -> 'c __tac): ('a -> 'b -> 'c tac) =
    fun (x: 'a) ->
        fun (y: 'b) ->
            (fun (ps: proofstate) ->
                perr "In compiled code (2)\n";
                interpret_tactic ps (t x y)) |> mk_tac

let from_tactic_3 (t: 'a -> 'b -> 'c -> 'd __tac): ('a -> 'b -> 'c -> 'd tac) =
    fun (x: 'a) ->
        fun (y: 'b) ->
            fun (z: 'c) ->
                (fun (ps: proofstate) ->
                    perr "In compiled code (3)\n";
                    interpret_tactic ps (t x y z)) |> mk_tac

let from_tactic_4 (t: 'a -> 'b -> 'c -> 'd -> 'e __tac): ('a -> 'b -> 'c -> 'd -> 'e tac) =
    fun (x: 'a) ->
        fun (y: 'b) ->
            fun (z: 'c) ->
                fun (w: 'd) ->
                    (fun (ps: proofstate) ->
                        perr "In compiled code (4)\n";
                        interpret_tactic ps (t x y z w)) |> mk_tac

let from_tactic_5 (t: 'a -> 'b -> 'c -> 'd -> 'e -> 'f __tac): ('a -> 'b -> 'c -> 'd -> 'e -> 'f tac) =
    fun (x: 'a) ->
        fun (y: 'b) ->
            fun (z: 'c) ->
                fun (w: 'd) ->
                    fun (v: 'e) ->
                        (fun (ps: proofstate) ->
                            perr "In compiled code (5)\n";
                            interpret_tactic ps (t x y z w v)) |> mk_tac

let from_tactic_6 (t: 'a -> 'b -> 'c -> 'd -> 'e -> 'f -> 'g __tac): ('a -> 'b -> 'c -> 'd -> 'e -> 'f -> 'g tac) =
    fun (x: 'a) ->
        fun (y: 'b) ->
            fun (z: 'c) ->
                fun (w: 'd) ->
                    fun (v: 'e) ->
                        fun (u: 'f) ->
                            (fun (ps: proofstate) ->
                                perr "In compiled code (6)\n";
                                interpret_tactic ps (t x y z w v u)) |> mk_tac


let from_tactic_13 (t:'t1 -> 't2 -> 't3 -> 't4 -> 't5 -> 't6 -> 't7 -> 't8 -> 't9 -> 't10 -> 't11 -> 't12 -> 't13 -> 'r __tac):
                     ('t1 -> 't2 -> 't3 -> 't4 -> 't5 -> 't6 -> 't7 -> 't8 -> 't9 -> 't10 -> 't11 -> 't12 -> 't13 -> 'r tac)
                    =
    fun (a1: 't1) ->
    fun (a2: 't2) ->
    fun (a3: 't3) ->
    fun (a4: 't4) ->
    fun (a5: 't5) ->
    fun (a6: 't6) ->
    fun (a7: 't7) ->
    fun (a8: 't8) ->
    fun (a9: 't9) ->
    fun (a10: 't10) ->
    fun (a11: 't11) ->
    fun (a12: 't12) ->
    fun (a13: 't13) ->
    (fun (ps: proofstate) ->
       perr "In compiled code (13)\n";
       interpret_tactic ps (t a1 a2 a3 a4 a5 a6 a7 a8 a9 a10 a11 a12 a13)) |> mk_tac

