"""
Classes mockup used for unit tests.
"""

from weakref import ref

class NullLogger:
    def __init__(self):
        self.show = False

    def debug(self, message, sender=None):
        self.display(message)

    def info(self, message, sender=None):
        self.display(message)

    def warning(self, message, sender=None):
        self.display(message)

    def error(self, message, sender=None):
        self.display(message)

    def display(self, message):
        if not self.show:
            return
        print message

class MTA:
    def __init__(self, logger=None):
        if not logger:
            logger = NullLogger()
        self.logger = logger

class Application:
    pass

class Project:
    def __init__(self, logger=None):
        self._mta = MTA(logger)
        self.mta = ref(self._mta)

    def registerAgent(self, agent):
        pass

    def unregisterAgent(self, agent):
        pass

