from os import system as os_system
from fusil.tools import minmax
from fusil.os_tools import RUNNING_LINUX, RUNNING_WINDOWS
if RUNNING_LINUX:
    from fusil.linux.proc import readProcessProcList, readProcessLink, ProcError
if RUNNING_WINDOWS:
    from win32process import SetPriorityClass, BELOW_NORMAL_PRIORITY_CLASS, IDLE_PRIORITY_CLASS
    from win32api import GetCurrentProcessId, OpenProcess
    from win32con import PROCESS_ALL_ACCESS

    def limitMemory(nbytes):
        pass

    def beNice(very_nice=False):
        if very_nice:
            value = BELOW_NORMAL_PRIORITY_CLASS
        else:
            value = IDLE_PRIORITY_CLASS

        pid = GetCurrentProcessId()
        handle = OpenProcess(PROCESS_ALL_ACCESS, True, pid)
        SetPriorityClass(handle, value)
else:
    from resource import setrlimit, RLIMIT_AS
    from os import nice

    def limitMemory(nbytes):
        setrlimit(RLIMIT_AS, (nbytes, -1))

    def beNice(very_nice=False):
        if very_nice:
            value = 10
        else:
            value = 5
        nice(value)

def getSignalNames():
    """
    Create signal names dictionay (eg. 9 => 'SIGKILL') using dir(signal)
    """
    import signal
    names = [ name for name in dir(signal) if name.startswith("SIG") ]
    names = dict( (getattr(signal,name), name) for name in names )
    return names
SIGNAMES = getSignalNames()

def dumpProcessInfo(agent, pid):
    agent.info("Process ID: %s" % pid)
    if RUNNING_LINUX:
        try:
            agent.info("Process command line: %r" % readProcessProcList(pid, 'cmdline'))
        except ProcError:
            # Permission denied
            pass
        try:
            agent.info("Process environment: %r" % readProcessProcList(pid, 'environ'))
        except ProcError:
            # Permission denied
            pass
        try:
            agent.info("Process working directory: %s" % readProcessLink(pid, 'cwd'))
        except ProcError:
            # Permission denied
            pass

def displayProcessStatus(log, status):
    if status == 0:
        log("Process exited normally")
    elif status < 0:
        signum = -status
        log("Process killed by signal %s" %
            SIGNAMES.get(signum, signum))
    else:
        log("Process exited with error code: %s" % status)

def system(logger, command):
    logger.info("Run command: %r" % command)
    exit_code = os_system(command)
    if not exit_code:
        return
    raise RuntimeError("Unable to run command %r (error %r)" % (
        command, exit_code))

