from hotshot import Profile
from hotshot.stats import load as loadStats
from os import unlink
try:
    from cStringIO import StringIO
except ImportError:
    from StringIO import StringIO

def print_stats(log, stat, *amount):
    for filename in stat.files:
        print >> stat.stream, filename
    if stat.files: print >> stat.stream
    indent = ' ' * 8
    for func in stat.top_level:
        print >> stat.stream, indent, func_get_function_name(func)

    print >> stat.stream, indent, stat.total_calls, "function calls",
    if stat.total_calls != stat.prim_calls:
        print >> stat.stream, "(%d primitive calls)" % stat.prim_calls,
    print >> stat.stream, "in %.3f CPU seconds" % stat.total_tt
    print >> stat.stream
    width, list = stat.get_print_list(amount)
    if list:
        stat.print_title()
        for func in list:
            stat.print_line(func)
        print >> stat.stream
        print >> stat.stream

def runProfiler(logger, func, args=tuple(), kw={}, verbose=True, nb_func=25, sort_by=('cumulative', 'calls')):
    profile_filename = "/tmp/profiler"
    prof = Profile(profile_filename)
    try:
        logger.warning("Run profiler")
        result = prof.runcall(func, *args, **kw)
        prof.close()
        logger.error("Profiler: Process data...")
        stat = loadStats(profile_filename)
        stat.strip_dirs()
        stat.sort_stats(*sort_by)

        logger.error("Profiler: Result:")
        log = StringIO()
        stat.stream = log
        stat.print_stats(nb_func)
        log.seek(0)
        for line in log:
            logger.error(line.rstrip())
        return result
    finally:
        pass # unlink(profile_filename)

