--# -path=.:../romance:../common:../abstract:../../prelude

concrete LexiconCat of Lexicon = CatCat ** open 
  (M=MorphoCat), ParadigmsCat, BeschCat in {

flags 
  coding=utf8 ;
  optimize=values ;

oper
    regFN : Str -> N = \s -> femN (regN s) ;
    regMN : Str -> N = \s -> regN s ; 
	irregMN : Str -> Str -> N = \pa,pans -> M.mkNounIrreg pa pans masculine ** {lock_N=<>} ;
	saberV : V = verbV (saber_99 "saber") ;

lin
   airplane_N = regMN "avió" ;  

   answer_V2S = mkV2S (verbV (compondre_26 "respondre")) dative ;
   apartment_N = regMN "pis" ;
   apple_N = regFN "poma" ;
   art_N = regMN "art" ;    
   ask_V2Q = mkV2Q (mkV "preguntar") dative ;
   baby_N = regMN "nadó" ;
   bad_A = mkADeg (regA "dolent") (regA "pitjor") ;
   bank_N = regMN "banc" ;
   beautiful_A = prefA (regADeg "bell") ;
   become_VA = reflV (mkV "tornar") ;  -- esdevenir
   beer_N = regFN "cervesa" ;
   beg_V2V = mkV2V (mkV "demanar") accusative dative ;
   big_A = regADeg "gros" ;
   bike_N = regFN "bicicleta" ;
   bird_N = regMN "ocell" ;
   black_A = compADeg (mkA "negre" "negra" "negres" "negres" "negrament") ; 
   blue_A = compADeg (mkA "blau" "blava" "blaus" "blaves" "blavament") ;
   boat_N = regFN "barca" ;
   book_N = regMN "llibre" ;
   boot_N = regFN "bota" ;
   boss_N = regMN "cap" ;
   boy_N = regMN "noi" ;
   bread_N = irregMN "pa" "pans" ;
   break_V2 = dirV2 (verbV (trencar_112 "trencar")) ;
   broad_A = regADeg "ample" ; -- put it in MorphoCat?: like  black_A
   brother_N2 = deN2 (regMN "germà") ;
   brown_A = compADeg (mkA "marró" "marrona" "marrons" "marrones" "marronament") ;
   butter_N = regFN "mantega" ;
   buy_V2 = dirV2 (mkV "comprar") ;
   camera_N = regFN "càmara" ;
   cap_N = regFN "gorra" ;
   car_N = regMN "cotxe" ;
   carpet_N = regFN "catifa" ;
   cat_N = regMN "gat" ;        -- gata
   ceiling_N = regMN "sostre" ;
   chair_N = regFN "cadira" ;
   cheese_N = regMN "formatge" ;
   child_N = regMN "nen" ;      -- nena
   church_N = regFN "església" ;
   city_N =  regFN "ciutat" ;   
   clean_A = regADeg "net" ;
   clever_A = regADeg "inteligent" ;
   close_V2 = dirV2 (verbV (trencar_112 "tancar")) ;
   coat_N = regMN "abric" ;
   cold_A = regADeg "fred" ;
   come_V = verbV (venir_117 "venir") ;
   computer_N = regMN "ordinador" ;    
   country_N = mkN "país" "països" masculine ; 
   cousin_N = regMN "cosí" ;
   cow_N = mkN "vaca" ;
   die_V = verbV (morir_71 "morir") ;
   dirty_A = regADeg "brut" ;
   distance_N3 = mkN3 (regFN "distància") genitive dative ;
   doctor_N = regMN "metge" ;   -- metgessa
   dog_N = mkN "gos" ;        -- gossa
   door_N = regFN "porta" ;
   drink_V2 = dirV2 (verbV (beure_11 "beure")) ;
   easy_A2V = mkA2V (regA "fácil") dative genitive ;
   eat_V2 = dirV2 (verbV (envejar_48 "menjar")) ;
   empty_A = compADeg (mkA "buit" "buida" "buits" "buides" "buidament") ;
   enemy_N = regMN "enemic" ;       -- enemiga
   factory_N = regFN "fàbrica" ;
   father_N2 = deN2 (regMN "pare") ;
   fear_VS = mkVS (verbV (témer_107 "témer")) ;
   find_V2 = dirV2 (mkV "trobar") ;
   fish_N = mkN "peix" ; -- peixos
   floor_N = regMN "terra" ;        -- sòl
   forget_V2 = dirV2 (mkV "oblidar") ;
   fridge_N = regFN "nevera" ;
   friend_N = regMN "amic" ;        -- amiga
   fruit_N = regFN "fruita" ;
   fun_AV = mkAV (regA "divertit") genitive ;
   garden_N = regMN "jardí" ;
   girl_N = regFN "noia" ;
   glove_N = regMN "guant" ;
   gold_N = regMN "or" ;
   good_A = prefA (mkADeg (mkA "bo" "bona") (mkA "millor")) ;
   go_V = (verbV (anar_4 "anar")) ;
   green_A = regADeg "verd" ;
   harbour_N = regMN "port" ;
   hate_V2 = dirV2 (verbV (canviar_16 "odiar")) ;
   hat_N = regMN "barret" ;
   hear_V2 = mkV2 (mkV "escoltar") dative ; -- Must be "oir". Add it to Besch
   hill_N = regMN "turó" ;
   hope_VS = mkVS (mkV "esperar") ;
   horse_N = regMN "cavall" ;
   hot_A = regADeg "calent" ;
   house_N = regFN "casa" ;
   important_A = regADeg "important" ;
   industry_N = regFN "indústria" ;
   iron_N = regMN "ferro" ;
   king_N = regMN "rei" ; 
   know_V2 = dirV2 saberV ;
   know_VQ = mkVQ saberV;
   know_VS = mkVS saberV;
   lake_N = regMN "llac" ;
   lamp_N = regFN "làmpada" ;
   learn_V2 = dirV2 (verbV (aprendre_6 "aprendre")) ;
   leather_N = regMN "cuiro" ;
   leave_V2 = dirV2 (mkV "partir") ;
   like_V2 = dirV2 (verbV (canviar_16 "apreciar")) ;
   listen_V2 = dirV2 (mkV "escoltar") ;
   live_V = verbV (viure_119 "viure") ;
   long_A = regADeg "llarg" ;
   lose_V2 = dirV2 (verbV (perdre_83 "perdre")) ;
   love_N = regMN "amor" ;
   love_V2 = dirV2 (mkV "estimar") ;
   man_N = regMN "home" ;       -- masc
   married_A2 = mkA2 (regA "casat") dative ;
   meat_N = regFN "carn" ;
   milk_N = regFN "llet" ;
   moon_N = regFN "lluna" ;
   mother_N2 = deN2 (regFN "mare") ;    -- fem
   mountain_N = regFN "muntanya" ;
   music_N = regFN "música" ;
   narrow_A = regADeg "estret" ;
   new_A = prefixA (compADeg (mkA "nou" "nova" "nous" "noves" "novament")) ;
   newspaper_N = regMN "diari" ;        -- periòdic  
   oil_N = regMN "oli" ;
   old_A =  regADeg "vell" ;
   open_V2 = dirV2 (verbV (obrir_77 "obrir")) ;
   paint_V2A = mkV2A (mkV "pintar") accusative (mkPrep "en") ;
   paper_N = regMN "paper" ;
   paris_PN = mkPN "Paris" masculine ;
   peace_N = regFN "pau" ;
   pen_N = regMN "llapis" ;
   planet_N = regMN "planeta" ;
   plastic_N = regMN "plàstic" ;
   play_V2 = dirV2 (verbV (pregar_86 "jugar")) ;
   policeman_N = regMN "policia" ;  -- fem refers to the institution
   priest_N = regMN "capellà" ;     -- masc
   probable_AS = mkAS (regA "probable") ; 
   queen_N = regN "reina" ;
   radio_N = regFN "ràdio" ;
   rain_V0 = mkV0 (verbV (moure_72 "ploure")) ;
   read_V2 = dirV2 (verbV (servir_101 "llegir")) ;
   red_A = regADeg "vermell" ;
   religion_N = mkN "religió" "religions" feminine ;
   restaurant_N = regMN "restaurant" ;      
   river_N = regMN "riu" ;
   rock_N = regFN "roca" ;
   roof_N = regFN "teulada" ;
   rubber_N = regFN "goma" ;
   run_V = verbV (córrer_30 "córrer") ;
   say_VS = mkVS (verbV (dir_41 "dir")) ;
   school_N = regFN "escola" ;
   science_N = regFN "ciència" ;
   sea_N = regMN "mar" ;            -- masc & fem 
   seek_V2 = dirV2 (verbV (trencar_112 "buscar")) ;
   see_V2 = dirV2 (verbV (veure_118 "veure")) ;
   sell_V3 = dirV3 (verbV (vendre_116 "vendre")) dative ;
   send_V3 = dirV3 (verbV (canviar_16 "enviar")) dative ;
   sheep_N = regFN "ovella" ;   -- xai
   ship_N = regMN "vaixell" ;
   shirt_N = regFN "camisa" ;
   shoe_N = regFN "sabata" ;
   shop_N = regFN "botiga" ;
   short_A = regADeg "curt" ; --- breu
   silver_N = regFN "plata" ;
   sister_N = regFN "germana" ;
   sleep_V = verbV (dormir_44 "dormir") ;
   small_A = prefA (mkA "petit" "petita" "petits" "petites" "petitament") ;
   snake_N = regFN "serp" ;     -- fem
   sock_N = regMN "mitjó" ;
   speak_V2 = dirV2 (mkV "parlar") ;
   star_N = regFN "estrella" ;
   steel_N = regMN "acer" ;
   stone_N = regFN "pedra" ;
   stove_N = regMN "forn" ; 
   student_N = regN "estudiant" ;   -- used both for fem & masc
   stupid_A = regADeg "estúpid" ;
   sun_N = regMN "sol" ;    
   switch8off_V2 = dirV2 (verbV (pregar_86 "apagar")) ;
   switch8on_V2 = dirV2 (verbV (atendre_8 "encendre")) ;
   table_N = regFN "taula" ; 
   talk_V3 = mkV3 (mkV "parlar") dative genitive ;
   teacher_N = regMN "mestre" ;     -- mestra
   teach_V2 = dirV2 (mkV "ensenyar") ;
   television_N = mkN "televisió" "televisions" feminine ;  -- televisor masc
   thick_A = compADeg (mkA "gruixut" "gruixuda" "gruixuts" "gruixudes" "gruixudament") ;
   thin_A = compADeg (mkA "fi" "fina" "fins" "fines" "finament") ;
   train_N = regMN "tren" ;
   travel_V = verbV (envejar_48 "viatjar") ;
   tree_N = regMN "arbre" ;
  --- trousers_N = regN "pantalón" ;    -- masc
   ugly_A = compADeg (mkA "lleig" "lletja" "lletjos" "lletges" "lletjament") ;
   understand_V2 = dirV2 (verbV (atendre_8 "entendre")) ;
   university_N = regFN "universitat" ;
   village_N = regMN "poble" ;
   wait_V2 = mkV2 (mkV "esperar") dative ;
   walk_V = mkV "caminar" ;
   warm_A = compADeg (mkA "tebi" "tèbia" "tebis" "tèbies" "tèbiament") ;
   war_N = regFN "guerra" ;
   watch_V2 = dirV2 (mkV "mirar") ;
   water_N = mkN "aigua" ; -- aigües
   white_A = compADeg (mkA "blanc" "blanca" "blancs" "blanques" "blancament") ;
   window_N = regFN "finestra" ;
   wine_N = regMN "vi" ;
   win_V2 = dirV2 (mkV "guanyar") ;
   woman_N = regFN "dona" ;
   wonder_VQ = mkVQ (reflV (mkV "preguntar")) ;
   wood_N = regFN "fusta" ;
   write_V2 = dirV2 (verbV (escriure_50 "escriure")) ;
   yellow_A = compADeg (mkA "groc" "groga" "grocs" "grogues" "grogament") ;
   young_A = compADeg (mkA "jove" "jove" "joves" "joves" "jovement") ;
   do_V2 =  dirV2 (verbV (fer_56 "fer")) ;
   now_Adv = mkAdv "ara" ;
   already_Adv = mkAdv "ja" ;
   song_N = mkN "cançó" "cançons" feminine ;
   add_V3 = dirV3 (mkV "afegir") dative ; -- also: (mkV "sumar")
   number_N = regMN "número" ;
   put_V2 = dirV2 (mkV "posar") ;
   stop_V = mkV "aturar" ; 
   jump_V = mkV "saltar" ;
   left_Ord = M.mkOrd (regA "esquerra") ;
   right_Ord = M.mkOrd (regA "dreta") ;
   far_Adv = mkAdv "lluny" ;
   correct_A = regA "correcte" ;
   dry_A = regA "sec" ;
   dull_A = regA "balb" ;
   full_A = regA "ple" ;
   heavy_A = regA "pesat" ;
   near_A = regA "proper" ;
   rotten_A = regA "podrit" ;
   round_A = regA "rodó" ;
   sharp_A = regA "esmolat" ; -- punxegut
   smooth_A = regA "llis" ;
   straight_A = regA "directe" ;
   wet_A = regA "moll" ;
   wide_A = regA "extens" ;
   animal_N = regMN "animal" ;           -- masc (sometimes fem when adj)
   ashes_N = regMN "cendra" ;
   back_N = regFN "esquena" ;
   bark_N = regFN "escorça" ;
   belly_N = regFN "panxa" ;
   blood_N = regFN "sang" ;
   bone_N = regMN "os" ; -- ossos
   breast_N = regFN "sina" ;             -- pit
   cloud_N = regMN "núvol" ;
   day_N = regMN "dia" ;
   dust_N = regFN "pols" ;
   ear_N = regFN "orella" ;
   earth_N = regFN "terra" ;
   egg_N = regMN "ou" ;
   eye_N = regMN "ull" ;
   fat_N = regMN "greix" ;
   feather_N = regFN "pluma" ;
   fingernail_N = regFN "ungla" ;
   fire_N = regMN "foc" ;
   flower_N = regFN "flor" ;
   fog_N = regFN "boira" ;
   foot_N = regMN "peu" ;
   forest_N = regMN "bosc" ;
   grass_N = regFN "herba" ;             
   guts_N = regMN "budell" ;
   hair_N = regMN "cabell" ;
   hand_N = regFN "mà" ;
   head_N = regMN "cap" ;
   heart_N = regMN "cor" ;
   horn_N = regFN "banya" ;
   husband_N = regMN "marit" ;  -- espòs
   ice_N = regMN "gel" ;
   knee_N = regMN "genoll" ;
   leaf_N = regFN "fulla" ;
   leg_N = regFN "cama" ;
   liver_N = regMN "fetge" ;
   louse_N = regMN "poll" ;
   mouth_N = regFN "boca" ;
   name_N = regMN "nom" ;
   neck_N = regMN "coll" ;
   night_N = regFN "nit" ;
   nose_N = regMN "nas" ;
   person_N = regFN "persona" ;
   rain_N = regFN "pluja" ; -- pluges
   road_N = regMN "carrer" ;               
   root_N = regFN "arrel" ;
   rope_N = regN "corda" ;
   salt_N = regFN "sal" ;
   sand_N = regFN "sorra" ;
   seed_N = regFN "llavor" ;
   skin_N = regFN "pell" ;        -- fem
   sky_N = regMN "cel" ;
   smoke_N = regMN "fum" ;
   snow_N = regFN "neu" ;       -- fem
   stick_N = regMN "bastó"  ;               
   tail_N = regFN "cua" ;
   tongue_N = mkN "llengua" ; -- llengües
   tooth_N = regFN "dent" ;
   wife_N = regFN "esposa" ;
   wind_N = regMN "vent" ;
   wing_N = regFN "ala" ;
   worm_N = regMN "cuc" ;             
   year_N = regMN "any" ;
   bite_V2 = dirV2 (verbV (pregar_86 "mossegar")) ;
   blow_V = mkV "bufar" ;
   burn_V = mkV "cremar" ;
   count_V2 = dirV2 (mkV "comptar") ;
   cut_V2 = dirV2 (mkV "tallar") ;
   dig_V = mkV "cavar" ;
   fall_V = verbV (caure_18 "caure") ;
   fear_V2 = dirV2 (verbV (témer_107 "témer")) ;
   fight_V2 = dirV2 (mkV "lluitar") ;
   float_V = mkV "surar" ;
   flow_V = verbV (reduir_94 "fluir") ; -- also: mkV "circular"
   fly_V = mkV "volar" ;
   freeze_V = mkV "congelar" ;
   give_V3 = dirdirV3 (verbV (donar_43 "donar")) ;
   hit_V2 = dirV2 (verbV (trencar_112 "picar")) ;
   hold_V2 = dirV2 (verbV (obtenir_78 "sostenir")) ;
   hunt_V2 = dirV2 (verbV (començar_22 "caçar")) ;
   kill_V2 = dirV2 (mkV "matar") ;
   laugh_V = verbV (riure_96 "riure") ; 
   lie_V = reflV (verbV (jeure_62 "jeure")) ;
   play_V = verbV (pregar_86 "jugar") ;
   pull_V2 = dirV2 (mkV "tibar") ;
   push_V2 = dirV2 (verbV (atènyer_59 "empènyer")) ;
   rub_V2 = dirV2 (verbV (pregar_86 "refregar")) ;
   scratch_V2 = dirV2 (mkV "gratar") ;
   sew_V = verbV (cosir_31 "cosir") ;
   sing_V = mkV "cantar" ;
   sit_V = reflV (verbV (seure_102 "seure")) ;
   smell_V = mkV "ensumar" ;
   spit_V = verbV (escopir_49 "escopir") ;
   split_V2 = dirV2 (mkV "separar") ; -- dividir,) ;
   squeeze_V2 = dirV2 (verbV (servir_101 "exprimir")) ;
   stab_V2 = dirV2 (mkV "apunyalar") ;
   stand_V = verbV (estar_54 "estar") ; ---- "estar dret"
   suck_V2 = dirV2 (mkV "xuclar") ;
   swell_V = mkV "inflar" ;
   swim_V = mkV "nedar" ;
   think_V = mkV "pensar" ;
   throw_V2 = dirV2 (verbV (començar_22 "llençar")) ;
   tie_V2 = dirV2 (verbV (pregar_86 "lligar")) ;
   turn_V = mkV "girar" ;
   vomit_V = mkV "vomitar" ;
   wash_V2 = dirV2 (mkV "rentar") ;
   wipe_V2 = dirV2 (verbV (pregar_86 "eixugar")) ;
   breathe_V = mkV "respirar" ;
   john_PN = mkPN "Joan" masculine ;
   today_Adv = mkAdv "avui" ;

  grammar_N = regFN "gramàtica" ;
  language_N = mkN "llengua" ; -- llengües
  rule_N = regFN "regla" ;
  question_N = regFN "pregunta" ;
  ready_A = regA "preparat" ;
  reason_N = regFN "raó" ;
  uncertain_A = regA "incert" ;


} ;
