--# -path=.:../abstract:../common:../prelude: -- types and rections: Hans Leiß 3/2015

concrete DictVerbsGer of DictVerbsGerAbs = 
   CatGer ** open (R=ResGer), (P=Prelude), ParadigmsGer 
in { 

lincat 
  V0 = V ;  -- there are no grammar rules yet for V0,V3S,VSA,VS2,V4 
  VS2, VSA = V2 ;
  V3S = V3 ;
  V4 = R.Verb ** { c2,c3,c4 : R.Preposition } ; 

oper
  -- === Extensions to ResGer: ====
  -- param  CPrep = CAnDat | CInAcc | CInDat | CZuDat | CVonDat 
  --                | CBeiDat ; -- HL
  --
  -- oper 
  --   NPNom : PCase = NPC Nom ;
  --   prepC : PCase -> {s : Str ; c : Case} = \cp -> case cp of {
  --     NPC c      => {s = []   ; c = c} ;
  --     NPP CAnDat => {s = "an" ; c = Dat} ;
  --     NPP CInAcc => {s = "in" ; c = Acc} ;
  --     NPP CInDat => {s = "in" ; c = Dat} ;
  --     NPP CZuDat => {s = "zu" ; c = Dat} ;
  --     NPP CVonDat => {s = "von" ; c = Dat}
  --     NPP CBeiDat => {s = "bei" ; c = Dat} -- HL
  --     } ;

  -- === Extensions to ParadigmsGer: ===
  -- for als(nom), wie(nom):
  nomPrep : Prep =
  lin Prep {s = [] ; s2 = [] ; c = nominative ; isPrep = P.False } ;

  aus_Prep   = mkPrep "aus" dative ; 
  -- beiDat_Case = NPP CBeiDat ; 
  -- bei_Prep   = mkPrep [] beiDat_Case ; 
  bei_Prep   = mkPrep "bei" dative ; 
  durch_Prep = mkPrep "durch" accusative ;
  fuer_Prep  = mkPrep "für" accusative ;
  gegen_Prep = mkPrep "gegen" accusative ;
  mit_Prep   = mkPrep "mit" dative ;
  nach_Prep  = mkPrep "nach" dative ;
  um_Prep    = mkPrep "um" accusative ;

  -- ad-hoc sharing of several prepositions:
  dir_Prep : Prep = 
  lin Prep { s = variants{"an" ; "auf" ; "hinter" ; "in" ; 
                          "vor" ; "über" ; "unter"} ;
             s2 = [] ;
             c = accusative ; 
             isPrep = P.True 
        } ;

  loc_Prep = lin Prep { 
    s = variants{"an" ; "auf" ; "hinter" ; "in" ; 
                 "vor" ; "über" ; "unter"} ;
    s2 = [] ;
    c = dative ; 
    isPrep = P.True 
    } ;

  istr_Prep : Prep = 
  lin Prep { s = variants{"mit" ; "durch" ; "mittels"} ;
               s2 = [] ;
             c = dative ; isPrep = P.True } ;

  adv_Prep : Prep = -- TODO: adv- vs. adj-arguments, or adv-modifications?
    mkPrep "adv" nominative ; -- dummy

  auxVV : V -> R.Verb ** {isAux : P.Bool} = 
         \v -> lin VV (habenV v ** { isAux = P.True }) ;

  -- verb constructions:
  reflVV : V -> Case -> VV ;
  reflVV v c = mkVV (reflV v c) ;

  reflVS : V -> Case -> VS ; 
  reflVS v c = mkVS (reflV v c) ;

  reflV2 : V -> Case -> Prep -> V2 ; -- reflexive, with case and prep-object
  reflV2 v c p = prepV2 (reflV v c) p ;

  reflV3 : V -> Case -> Prep -> Prep -> V3 ; -- reflexive, with case, and prep-objects
  reflV3 v c p q = mkV3 (reflV v c) p q ;

  dirV2S : V -> V2S ;
  dirV2S v = (dirV2 v) ** {lock_V2S = <>};

  dirV2V : V -> V2V ;
  dirV2V v = (dirV2 v) ** {isAux = P.False ; lock_V2V = <>} ;

  -- intended restrictions on the subject (not inforced)
  --   dassV* = subject should be sentence
  --   infzuV* = subject should be zu-infinitive
  --   pl*V* = subject should be plural NP

  esV, dassV : V -> V = \v -> v ; 
  dassV2 : V -> Prep -> V2 = mkV2 ;   
  dassVS : V -> VS = mkVS ;   

  infzuV : V -> V = \v -> v ; 
  infzuV2 : V -> Prep -> V2 = mkV2 ; 
  infzuVA : V -> VA = mkVA ;

  pldirV2 : V -> V2 = dirV2 ; 
  plV : V -> V = \v -> v ;    
  plVS : V -> VS = mkVS ;     

  -- quaternary verbs:
  mkV4 : V -> Prep -> Prep -> Prep -> V4 = 
         \v,p2,p3,p4 -> lin V4 (v ** { c2=p2 ; c3=p3 ; c4=p4 }) ;
  dirV4 : V -> Prep -> Prep -> V4 = \v,c,d -> mkV4 v accPrep c d ;

  -- restrictions on arguments other than subject: (so far: useless verbs)

  mkV3S : V -> Prep -> Prep -> V3S = \v,p2,p3 -> lin V3S (mkV3 v p2 p3) ;
  mkVSA : V -> VSA = \v -> lin VSA (mkV2 v) ;  
  mkVS2 : V -> Prep -> VS2 = \v,p -> lin VS2 (prepV2 v p) ; -- may be equate VS2 and V2S ?

  -- some ad-hoc pseudo-reductions to reflexive verbs: (TODO properly)

  reciV : V -> Case -> V = reflV ; -- TODO: insertObj (\\a => "einander") 
  reciV2 = overload {
             reciV2 : V -> Case -> Prep -> V2 = \v,c,p -> mkV2 (reflV v c) ;
             reciV2 : V -> Case -> V2 = \v,c -> mkV2 (reflV v c) ;
         } ;
  reflVA : V -> Case -> VA = \v,c -> mkVA (reflV v c);

lin

  aalen_rV = reflV (regV "aalen") accusative ;
  aasen_mit_V2 = prepV2 (regV "aasen") mit_Prep ;
  abaasen_V2 = dirV2 (prefixV "ab" (regV "aasen"))  ;
  abacheln_V2 = dirV2 (prefixV "ab" (regV "acheln"))  ;
  abaendern_V2 = dirV2 (prefixV "ab" (regV "ändern"))  ;
  abaengstigen_rV = reflV (prefixV "ab" (regV "ängstigen")) accusative ;
  abaesen_V2 = dirV2 (prefixV "ab" (regV "äsen"))  ;
  abaesten_V2 = dirV2 (prefixV "ab" (regV "ästen"))  ;
  abaetzen_V2 = dirV2 (prefixV "ab" (regV "ätzen"))  ;
  abalienieren_dat_V3 = accdatV3 (prefixV "ab" (irregV "alienieren" "alieniert" "alienierte" "alienierte" "gealieniert"))  ;
  abalienieren_V2 = dirV2 (prefixV "ab" (irregV "alienieren" "alieniert" "alienierte" "alienierte" "gealieniert"))  ;
  abandonnieren_V2 = dirV2 (regV "abandonnieren")  ;
  abarbeiten_an_rV2 = reflV2 (prefixV "ab" (regV "arbeiten")) accusative (mkPrep "an" accusative) ;
  abarbeiten_rV = reflV (prefixV "ab" (regV "arbeiten")) accusative ;
  abarten_V = prefixV "ab" (regV "arten") ;
  abasten_V2 = dirV2 (prefixV "ab" (regV "asten"))  ;
  abatmen_V2 = dirV2 (prefixV "ab" (regV "atmen"))  ;
  abbacken_V2 = dirV2 (prefixV "ab" (irregV "backen" "backt" "buk" "büke" "gebacken"))  ;
  abbaden_V2 = dirV2 (prefixV "ab" (regV "baden"))  ;
  abbaggern_V2 = dirV2 (prefixV "ab" (regV "baggern"))  ;
  abbaken_V2 = dirV2 (prefixV "ab" (regV "baken"))  ;
  abbalgen_rV = reflV (prefixV "ab" (regV "balgen")) accusative ;
  abballern_V2 = dirV2 (prefixV "ab" (regV "ballern"))  ;
  abbalzen_V = prefixV "ab" (regV "balzen") ;
  abbangen_dat_V3 = accdatV3 (prefixV "ab" (regV "bangen"))  ;
  abbasten_V2 = dirV2 (prefixV "ab" (irregV "basten" "bastet" "baste" "baste" "gebastet"))  ;
  abbauen_V2 = dirV2 (prefixV "ab" (regV "bauen"))  ;
  abbaumen_V2 = dirV2 (prefixV "ab" (regV "baumen"))  ;
  abbedingen_rV2 = reflV2 (prefixV "ab" (irregV "bedingen" "bedingt" "bedang" "bedänge" "bedungen")) accusative accPrep ;
  abbeeren_V2 = dirV2 (prefixV "ab" (regV "beeren"))  ;
  abbefehlen_V2 = dirV2 (prefixV "ab" (irregV "befehlen" "befiehlt" "befahl" "befahl" "befohlen"))  ;
  abbegehren_von_V3 = dirV3 (prefixV "ab" (regV "begehren")) von_Prep ;
  abbehalten_V2 = dirV2 (prefixV "ab" (irregV "behalten" "behält" "behielt" "behielte" "behalten"))  ;
  abbeissen_V2 = dirV2 (prefixV "ab" (irregV "beißen" "beißt" "biss" "bisse" "gebissen"))  ;
  abbeizen_V2 = dirV2 (prefixV "ab" (regV "beizen"))  ;
  abbekommen_V2 = dirV2 (prefixV "ab" (irregV "bekommen" "bekommt" "bekam" "bekäme" "bekommen"))  ;
  abberufen_V2 = dirV2 (prefixV "ab" (irregV "berufen" "beruft" "berief" "beriefe" "berufen"))  ;
  abbestellen_V2 = dirV2 (prefixV "ab" (irregV "bestellen" "bestellt" "bestellte" "bestellte" "bestellt"))  ;
  abbetteln_dat_V3 = accdatV3 (prefixV "ab" (regV "betteln"))  ;
  abbeuteln_V2 = dirV2 (prefixV "ab" (regV "beuteln"))  ;
  abbezahlen_bei_V3 = dirV3 (prefixV "ab" (regV "bezahlen")) bei_Prep ;
  abbezahlen_V2 = dirV2 (prefixV "ab" (regV "bezahlen"))  ;
  abbiegen_V = prefixV "ab" (irregV "biegen" "biegt" "bog" "böge" "gebogen") ;
  abbilden_V2 = dirV2 (prefixV "ab" (regV "bilden"))  ;
  abbimsen_V2 = dirV2 (prefixV "ab" (regV "bimsen"))  ;
  abbinden_V2 = dirV2 (prefixV "ab" (irregV "binden" "bindet" "band" "bände" "gebunden"))  ;
  abbitten_dat_V3 = accdatV3 (prefixV "ab" (irregV "bitten" "bittet" "bat" "bäte" "gebeten"))  ;
  abblaettern_V = prefixV "ab" (regV "blättern") ;
  abblasen_V2 = dirV2 (prefixV "ab" (irregV "blasen" "blast" "blies" "bliese" "geblasen"))  ;
  abblassen_V = prefixV "ab" (regV "blassen") ;
  abbleiben_loc_V2 = prepV2 (prefixV "ab" (irregV "bleiben" "bleibt" "blieb" "blieb" "geblieben")) loc_Prep ;
  abbleiben_V = prefixV "ab" (irregV "bleiben" "bleibt" "blieb" "blieb" "geblieben") ;
  abbleichen_V2 = dirV2 (prefixV "ab" (regV "bleichen"))  ;
  abblenden_V2 = dirV2 (prefixV "ab" (regV "blenden"))  ;
  abblitzen_bei_V2 = prepV2 (prefixV "ab" (regV "blitzen")) bei_Prep ;
  abblitzen_V = prefixV "ab" (regV "blitzen") ;
  abblocken_V2 = dirV2 (prefixV "ab" (regV "blocken"))  ;
  abbluehen_V = prefixV "ab" (regV "blühen") ;
  abboeschen_V2 = dirV2 (prefixV "ab" (regV "böschen"))  ;
  abbrauchen_V2 = dirV2 (prefixV "ab" (regV "brauchen"))  ;
  abbrechen_V2 = dirV2 (prefixV "ab" (irregV "brechen" "brecht" "brach" "bräche" "gebrochen"))  ;
  abbremsen_V2 = dirV2 (prefixV "ab" (regV "bremsen"))  ;
  abbrennen_V2 = dirV2 (prefixV "ab" (irregV "brennen" "brennt" "brannte" "brannte" "gebrannt"))  ;
  abbreviieren_V2 = dirV2 (prefixV "ab" (regV "breviieren"))  ;
  abbringen_von_V3 = dirV3 (prefixV "ab" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht")) von_Prep ;
  abbrocken_V2 = dirV2 (prefixV "ab" (regV "brocken"))  ;
  abbroeckeln_von_V2 = prepV2 (prefixV "ab" (regV "bröckeln")) von_Prep ;
  abbroeckeln_V = prefixV "ab" (regV "bröckeln") ;
  abbroeseln_von_V2 = prepV2 (prefixV "ab" (regV "bröseln")) von_Prep ;
  abbroeseln_V = prefixV "ab" (regV "bröseln") ;
  abbuchen_V2 = dirV2 (prefixV "ab" (regV "buchen"))  ;
  abbuchen_von_V3 = dirV3 (prefixV "ab" (regV "buchen")) von_Prep ;
  abbuessen_V2 = dirV2 (prefixV "ab" (regV "büßen"))  ;
  abbuffen_V2 = dirV2 (prefixV "ab" (regV "buffen"))  ;
  abbummeln_V2 = dirV2 (prefixV "ab" (regV "bummeln"))  ;
  abbusseln_V2 = dirV2 (prefixV "ab" (regV "busseln"))  ;
  abchangieren_V = prefixV "ab" (regV "changieren") ;
  abchecken_V2 = dirV2 (prefixV "ab" (regV "checken"))  ;
  abchoppen_V2 = dirV2 (prefixV "ab" (regV "choppen"))  ;
  abchoppen_V = prefixV "ab" (regV "choppen") ;
  abdaemmen_V2 = dirV2 (prefixV "ab" (regV "dämmen"))  ;
  abdanken_V = prefixV "ab" (regV "danken") ;
  abdecken_V2 = dirV2 (prefixV "ab" (regV "decken"))  ;
  abdichten_V2 = dirV2 (prefixV "ab" (regV "dichten"))  ;
  abdienen_V2 = dirV2 (prefixV "ab" (regV "dienen"))  ;
  abdingen_dat_V3 = accdatV3 (prefixV "ab" (regV "dingen"))  ;
  abdizieren_V = prefixV "ab" (regV "dizieren") ;
  abdrehen_V2 = dirV2 (prefixV "ab" (regV "drehen"))  ;
  abdriften_V = prefixV "ab" (regV "driften") ;
  abdrucken_V2 = dirV2 (prefixV "ab" (regV "drucken"))  ;
  abdruecken_V = prefixV "ab" (regV "drücken") ;
  abdunkeln_V2 = dirV2 (prefixV "ab" (regV "dunkeln"))  ;
  abduzieren_V2 = dirV2 (prefixV "ab" (regV "duzieren"))  ;
  abduzieren_VS = mkVS (prefixV "ab" (regV "duzieren"))  ;
  abecedieren_V2 = dirV2 (regV "abecedieren")  ;
  abeisen_V2 = dirV2 (prefixV "ab" (regV "eisen"))  ;
  aberkennen_dat_V3 = accdatV3 (prefixV "ab" (irregV "erkennen" "erkennt" "erkannte" "erkannte" "erkannt"))  ;
  abernten_V2 = dirV2 (prefixV "ab" (regV "ernten"))  ;
  abern_V = regV "abern" ;
  aberrieren_von_V2 = prepV2 (prefixV "ab" (regV "errieren")) von_Prep ;
  abfackeln_V2 = dirV2 (prefixV "ab" (regV "fackeln"))  ;
  abfaelschen_V2 = dirV2 (prefixV "ab" (regV "fälschen"))  ;
  abfaerben_V = prefixV "ab" (regV "färben") ;
  abfahren_V = prefixV "ab" (irregV "fahren" "fährt" "fuhr" "führe" "gefahren") ;
  abfallen_von_V2 = prepV2 (prefixV "ab" (irregV "fallen" "fällt" "fiel" "fiele" "gefallen")) von_Prep ;
  abfangen_V2 = dirV2 (prefixV "ab" (irregV "fangen" "fängt" "fing" "finge" "gefangen"))  ;
  abfasen_V2 = dirV2 (prefixV "ab" (regV "fasen"))  ;
  abfedern_V2 = dirV2 (prefixV "ab" (regV "federn"))  ;
  abfegen_V2 = dirV2 (prefixV "ab" (regV "fegen"))  ;
  abfeiern_V2 = dirV2 (prefixV "ab" (regV "feiern"))  ;
  abfertigen_V2 = dirV2 (prefixV "ab" (regV "fertigen"))  ;
  abfeuern_V2 = dirV2 (prefixV "ab" (regV "feuern"))  ;
  abfieseln_V2 = dirV2 (prefixV "ab" (regV "fieseln"))  ;
  abfinden_V2 = dirV2 (prefixV "ab" (irregV "finden" "findet" "fand" "fände" "gefunden"))  ;
  abflachen_V = prefixV "ab" (regV "flachen") ;
  abflauen_V = prefixV "ab" (regV "flauen") ;
  abfliegen_V = prefixV "ab" (irregV "fliegen" "fliegt" "flog" "flöge" "geflogen") ;
  abfliessen_V = prefixV "ab" (irregV "fließen" "fließt" "floss" "floss" "geflossen") ;
  abformen_V0 = mkV0 (prefixV "ab" (regV "formen"))  ;
  abfotografieren_V2 = dirV2 (prefixV "ab" (regV "fotografieren"))  ;
  abfragen_V2 = dirV2 (prefixV "ab" (regV "fragen"))  ;
  abfruehstuecken_V0 = mkV0 (prefixV "ab" (regV "frühstücken"))  ;
  abfuehren_V2 = dirV2 (prefixV "ab" (regV "führen"))  ;
  abgeben_V2 = dirV2 (prefixV "ab" (irregV "geben" "gibt" "gab" "gäbe" "gegeben"))  ;
  abgehen_V = prefixV "ab" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  abgenzern_V2 = dirV2 (prefixV "ab" (regV "genzern"))  ;
  abgeraten_von_V2 = prepV2 (prefixV "ab" (irregV "geraten" "gerät" "geriet" "geriete" "geraten")) von_Prep ;
  abgewoehnen_rV2 = reflV2 (prefixV "ab" (regV "gewöhnen")) accusative accPrep ;
  abgewoehnen_rVV = reflVV (prefixV "ab" (regV "gewöhnen")) accusative ;
  abgraebeln_V = prefixV "ab" (regV "gräbeln") ;
  abgraten_V2 = dirV2 (prefixV "ab" (regV "graten"))  ;
  abgrenzen_V2 = dirV2 (prefixV "ab" (regV "grenzen"))  ;
  abhacken_V2 = dirV2 (prefixV "ab" (regV "hacken"))  ;
  abhaengen_von_V2 = prepV2 (prefixV "ab" (irregV "hängen" "hängt" "hing" "hinge" "gehangen")) von_Prep ;
  abhaeuten_V2 = dirV2 (prefixV "ab" (regV "häuten"))  ;
  abhaken_V2 = dirV2 (prefixV "ab" (regV "haken"))  ;
  abhalten_von_V3 = dirV3 (prefixV "ab" (irregV "halten" "hält" "hielt" "hielte" "gehalten")) von_Prep ;
  abhandeln_V2 = dirV2 (prefixV "ab" (regV "handeln"))  ;
  abhandenkommen_dat_V2 = mkV2 (prefixV "abhanden" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) datPrep ;
  abhauben_V2 = dirV2 (prefixV "ab" (regV "hauben"))  ;
  abhauen_V = prefixV "ab" (regV "hauen") ;
  abheben_V = prefixV "ab" (irregV "heben" "hebt" "hob" "höbe" "gehoben") ;
  abhebern_V2 = dirV2 (prefixV "ab" (regV "hebern"))  ;
  abhetzen_rV = reflV (prefixV "ab" (regV "hetzen")) accusative ;
  abhobeln_V2 = dirV2 (prefixV "ab" (regV "hobeln"))  ;
  abholen_V2 = dirV2 (prefixV "ab" (regV "holen"))  ;
  abholzen_V2 = dirV2 (prefixV "ab" (regV "holzen"))  ;
  abisolieren_V2 = dirV2 (prefixV "ab" (regV "isolieren"))  ;
  abkacken_V = prefixV "ab" (regV "kacken") ;
  abkarten_V2 = dirV2 (prefixV "ab" (regV "karten"))  ;
  abkaufen_dat_V3 = accdatV3 (prefixV "ab" (regV "kaufen"))  ;
  abkindern_V2 = dirV2 (prefixV "ab" (regV "kindern"))  ;
  abklatschen_V2 = dirV2 (prefixV "ab" (regV "klatschen"))  ;
  abklemmen_V2 = dirV2 (prefixV "ab" (regV "klemmen"))  ;
  abknapsen_rV2 = reflV2 (prefixV "ab" (regV "knapsen")) accusative accPrep ;
  abknicken_V2 = dirV2 (prefixV "ab" (regV "knicken"))  ;
  abknoepfen_dat_V3 = accdatV3 (prefixV "ab" (regV "knöpfen"))  ;
  abknutschen_V2 = dirV2 (prefixV "ab" (regV "knutschen"))  ;
  abkommen_von_V2 = prepV2 (prefixV "ab" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) von_Prep ;
  abkrageln_V2 = dirV2 (prefixV "ab" (regV "krageln"))  ;
  abkratzen_V = prefixV "ab" (regV "kratzen") ;
  abkroeschen_V2 = dirV2 (prefixV "ab" (regV "kröschen"))  ;
  abkrueppeln_V = prefixV "ab" (regV "krüppeln") ;
  abkuehlen_V = prefixV "ab" (regV "kühlen") ;
  abkuendigen_V2 = dirV2 (prefixV "ab" (regV "kündigen"))  ;
  abkuessen_V2 = dirV2 (prefixV "ab" (regV "küssen"))  ;
  abkupfern_bei_V3 = dirV3 (prefixV "ab" (regV "kupfern")) bei_Prep ;
  abkupfern_V2 = dirV2 (prefixV "ab" (regV "kupfern"))  ;
  abladen_bei_V3 = dirV3 (prefixV "ab" (irregV "laden" "lädt" "lud" "lüde" "geladen")) bei_Prep ;
  abladen_V2 = dirV2 (prefixV "ab" (irregV "laden" "lädt" "lud" "lüde" "geladen"))  ;
  ablassen_von_V2 = prepV2 (prefixV "ab" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen")) von_Prep ;
  ablaufen_V = prefixV "ab" (irregV "laufen" "lauft" "lief" "liefe" "gelaufen") ;
  ablegen_V = prefixV "ab" (regV "legen") ;
  ablehnen_V2 = dirV2 (prefixV "ab" (regV "lehnen"))  ;
  ableiten_von_V3 = dirV3 (prefixV "ab" (regV "leiten")) von_Prep ;
  ablenken_von_V3 = dirV3 (prefixV "ab" (regV "lenken")) von_Prep ;
  abloeschen_mit_V3 = dirV3 (prefixV "ab" (regV "löschen")) mit_Prep ;
  abloeschen_V2 = dirV2 (prefixV "ab" (regV "löschen"))  ;
  abloesen_von_V3 = dirV3 (prefixV "ab" (regV "lösen")) von_Prep ;
  abmagern_V = prefixV "ab" (regV "magern") ;
  abmahnen_V2 = dirV2 (prefixV "ab" (regV "mahnen"))  ;
  abmalen_V2 = dirV2 (prefixV "ab" (regV "malen"))  ;
  abmalen_von_V3 = dirV3 (prefixV "ab" (regV "malen")) von_Prep ;
  abmarachen_rV = reflV (prefixV "ab" (regV "marachen")) accusative ;
  abmessen_V2 = dirV2 (prefixV "ab" (irregV "messen" "misst" "maß" "maß" "gemessen"))  ;
  abmurksen_V2 = dirV2 (prefixV "ab" (regV "murksen"))  ;
  abnabeln_von_V3 = dirV3 (prefixV "ab" (regV "nabeln")) von_Prep ;
  abnehmen_V = prefixV "ab" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen") ;
  abnicken_V2 = dirV2 (prefixV "ab" (regV "nicken"))  ;
  abnippeln_V = prefixV "ab" (regV "nippeln") ;
  abnuetzen_rV = reflV (prefixV "ab" (regV "nützen")) accusative ;
  abnutzen_rV = reflV (prefixV "ab" (regV "nutzen")) accusative ;
  abonnieren_V2 = dirV2 (irregV "abonnieren" "abonniert" "abonnierte" "abonnierte" "abonniert")  ;
  abpausen_V2 = dirV2 (prefixV "ab" (regV "pausen"))  ;
  abpimmeln_V = prefixV "ab" (regV "pimmeln") ;
  abpoelen_V2 = dirV2 (prefixV "ab" (regV "pölen"))  ;
  abprotzen_V = prefixV "ab" (regV "protzen") ;
  abraeumen_V2 = dirV2 (prefixV "ab" (regV "räumen"))  ;
  abreisen_V = prefixV "ab" (regV "reisen") ;
  abreissen_von_V3 = dirV3 (prefixV "ab" (irregV "reißen" "reißt" "riss" "risse" "gerissen")) von_Prep ;
  abriegeln_V2 = dirV2 (prefixV "ab" (regV "riegeln"))  ;
  abrocken_V = prefixV "ab" (regV "rocken") ;
  abruecken_von_V2 = prepV2 (prefixV "ab" (regV "rücken")) von_Prep ;
  abrufen_V2 = dirV2 (prefixV "ab" (irregV "rufen" "ruft" "rief" "riefe" "gerufen"))  ;
  absaegen_V2 = dirV2 (prefixV "ab" (regV "sägen"))  ;
  absagen_V2 = dirV2 (prefixV "ab" (regV "sagen"))  ;
  absahnen_V2 = dirV2 (prefixV "ab" (regV "sahnen"))  ;
  abschachern_dat_V3 = accdatV3 (prefixV "ab" (regV "schachern"))  ;
  abschaffen_V2 = dirV2 (prefixV "ab" (regV "schaffen"))  ;
  abschauen_bei_rV3 = reflV3 (prefixV "ab" (irregV "schauen" "schaut" "schaute" "schaute" "geschaut")) accusative accPrep bei_Prep ;
  abschauen_bei_V3 = dirV3 (prefixV "ab" (irregV "schauen" "schaut" "schaute" "schaute" "geschaut")) bei_Prep ;
  abschauen_rV2 = reflV2 (prefixV "ab" (irregV "schauen" "schaut" "schaute" "schaute" "geschaut")) accusative accPrep ;
  abschenken_V2 = dirV2 (prefixV "ab" (regV "schenken"))  ;
  abschenken_V = prefixV "ab" (regV "schenken") ;
  abschicken_V2 = dirV2 (prefixV "ab" (regV "schicken"))  ;
  abschieben_V2 = dirV2 (prefixV "ab" (irregV "schieben" "schiebt" "schob" "schöbe" "geschoben"))  ;
  abschlagen_dat_V3 = accdatV3 (prefixV "ab" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen"))  ;
  abschleppen_V2 = dirV2 (prefixV "ab" (regV "schleppen"))  ;
  abschliessen_V2 = dirV2 (prefixV "ab" (irregV "schließen" "schließt" "schloss" "schlösse" "geschlossen"))  ;
  abschmettern_V2 = dirV2 (prefixV "ab" (irregV "schmettern" "schmettert" "schmetterte" "schmetterte" "geschmettert"))  ;
  abschmieren_V = prefixV "ab" (regV "schmieren") ;
  abschminken_rV2 = reflV2 (prefixV "ab" (regV "schminken")) accusative accPrep ;
  abschminken_V2 = dirV2 (prefixV "ab" (regV "schminken"))  ;
  abschmirgeln_V2 = dirV2 (prefixV "ab" (regV "schmirgeln"))  ;
  abschmuecken_V2 = dirV2 (prefixV "ab" (regV "schmücken"))  ;
  abschneiden_V2 = dirV2 (prefixV "ab" (irregV "schneiden" "schneidet" "schnitt" "schnitte" "geschnitten"))  ;
  abschneiden_von_V3 = dirV3 (prefixV "ab" (irregV "schneiden" "schneidet" "schnitt" "schnitte" "geschnitten")) von_Prep ;
  abschoepfen_V2 = dirV2 (prefixV "ab" (regV "schöpfen"))  ;
  abschoepfen_von_V3 = dirV3 (prefixV "ab" (regV "schöpfen")) von_Prep ;
  abschotten_mit_gegen_V4 = dirV4 (prefixV "ab" (regV "schotten")) mit_Prep gegen_Prep ;
  abschotten_mit_von_V4 = dirV4 (prefixV "ab" (regV "schotten")) mit_Prep von_Prep ;
  abschrecken_V2 = dirV2 (prefixV "ab" (regV "schrecken"))  ;
  abschrecken_von_V3 = dirV3 (prefixV "ab" (regV "schrecken")) von_Prep ;
  abschreiben_V2 = dirV2 (prefixV "ab" (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben"))  ;
  abschreiben_von_V3 = dirV3 (prefixV "ab" (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben")) von_Prep ;
  abschwaechen_V2 = dirV2 (prefixV "ab" (regV "schwächen"))  ;
  abschwaechen_zu_V3 = dirV3 (prefixV "ab" (regV "schwächen")) zu_Prep ;
  absegeln_V = prefixV "ab" (regV "segeln") ;
  absegnen_V2 = dirV2 (prefixV "ab" (regV "segnen"))  ;
  abseihen_V2 = dirV2 (prefixV "ab" (regV "seihen"))  ;
  abseilen_rV = reflV (prefixV "ab" (regV "seilen")) accusative ;
  abseilen_V2 = dirV2 (prefixV "ab" (regV "seilen"))  ;
  absenden_V2 = dirV2 (prefixV "ab" (irregV "senden" "sendet" "sandte" "sandte" "gesandt"))  ;
  absentieren_von_rV2 = reflV2 (regV "absentieren") accusative von_Prep ;
  absetzen_von_rV2 = reflV2 (prefixV "ab" (regV "setzen")) accusative von_Prep ;
  absichern_V2 = dirV2 (prefixV "ab" (regV "sichern"))  ;
  absolutieren_V2 = dirV2 (regV "absolutieren")  ;
  absolvieren_V2 = dirV2 (prefixV "ab" (regV "solvieren"))  ;
  absondern_V2 = dirV2 (prefixV "ab" (regV "sondern"))  ;
  absorbieren_V2 = dirV2 (regV "absorbieren")  ;
  abspecken_V2 = dirV2 (prefixV "ab" (regV "specken"))  ;
  abspecken_V = prefixV "ab" (regV "specken") ;
  abspeichern_V2 = dirV2 (prefixV "ab" (regV "speichern"))  ;
  abspinnen_V2 = dirV2 (prefixV "ab" (irregV "spinnen" "spinnt" "spann" "spänne" "gesponnen"))  ;
  absprechen_mit_rV2 = reflV2 (prefixV "ab" (irregV "sprechen" "spricht" "sprach" "spräche" "gesprochen")) accusative mit_Prep ;
  absprechen_rcV = reciV (prefixV "ab" (irregV "sprechen" "spricht" "sprach" "spräche" "gesprochen")) accusative ;
  abspritzen_V2 = dirV2 (prefixV "ab" (regV "spritzen"))  ;
  abspuelen_V2 = dirV2 (prefixV "ab" (regV "spülen"))  ;
  abspuelen_V = prefixV "ab" (regV "spülen") ;
  abstammen_von_V2 = prepV2 (prefixV "ab" (regV "stammen")) von_Prep ;
  abstecken_V2 = dirV2 (prefixV "ab" (regV "stecken"))  ;
  absteigen_dir_V2 = prepV2 (prefixV "ab" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen")) dir_Prep ;
  absteigen_von_V2 = prepV2 (prefixV "ab" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen")) von_Prep ;
  absteigen_V = prefixV "ab" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen") ;
  abstellen_V2 = dirV2 (prefixV "ab" (regV "stellen"))  ;
  absterben_V = prefixV "ab" (irregV "sterben" "stirbt" "starb" "starb" "gestorben") ;
  abstillen_V = prefixV "ab" (regV "stillen") ;
  abstimmen_auf_V3 = dirV3 (prefixV "ab" (regV "stimmen")) (mkPrep "auf" accusative) ;
  abstimmen_ueber_rcV2 = reciV2 (prefixV "ab" (regV "stimmen")) accusative (mkPrep "über" accusative) ;
  abstimmen_ueber_V2 = prepV2 (prefixV "ab" (regV "stimmen")) (mkPrep "über" accusative) ;
  abstimmen_V = prefixV "ab" (regV "stimmen") ;
  abstottern_V2 = dirV2 (prefixV "ab" (regV "stottern"))  ;
  abstrafen_V2 = dirV2 (prefixV "ab" (regV "strafen"))  ;
  abstrahieren_von_V2 = prepV2 (regV "abstrahieren") von_Prep ;
  abstuerzen_V = prefixV "ab" (regV "stürzen") ;
  abstuetzen_V2 = dirV2 (prefixV "ab" (regV "stützen"))  ;
  abtakeln_V2 = dirV2 (prefixV "ab" (regV "takeln"))  ;
  abtauchen_V = prefixV "ab" (regV "tauchen") ;
  abtauschen_V2 = dirV2 (prefixV "ab" (regV "tauschen"))  ;
  abtragen_V2 = dirV2 (prefixV "ab" (irregV "tragen" "trägt" "trug" "trug" "getragen"))  ;
  abtransportieren_V2 = dirV2 (prefixV "ab" (regV "transportieren"))  ;
  abtreiben_V = prefixV "ab" (irregV "treiben" "treibt" "trieb" "trieb" "getrieben") ;
  abtrennen_V2 = dirV2 (prefixV "ab" (regV "trennen"))  ;
  abtreten_V = prefixV "ab" (irregV "treten" "tritt" "trat" "träte" "getreten") ;
  abtun_als_V3 = dirV3 (prefixV "ab" (irregV "tun" "tut" "tat" "täte" "getan")) (mkPrep "als" accusative) ;
  abtun_V2 = dirV2 (prefixV "ab" (irregV "tun" "tut" "tat" "täte" "getan"))  ;
  abwaegen_V2 = dirV2 (prefixV "ab" (irregV "wägen" "wägt" "wog" "wöge" "gewogen"))  ;
  abwandern_V = prefixV "ab" (regV "wandern") ;
  abwarten_V = prefixV "ab" (regV "warten") ;
  abweichen_von_V2 = prepV2 (prefixV "ab" (regV "weichen")) von_Prep ;
  abweisen_V2 = dirV2 (prefixV "ab" (irregV "weisen" "weist" "wies" "wiese" "gewiesen"))  ;
  abwerfen_V2 = dirV2 (prefixV "ab" (irregV "werfen" "werft" "warf" "würfe" "geworfen"))  ;
  abwerten_V2 = dirV2 (prefixV "ab" (regV "werten"))  ;
  abwickeln_V2 = dirV2 (prefixV "ab" (regV "wickeln"))  ;
  abwiegeln_V2 = mkV2 (prefixV "ab" (regV "wiegeln")) nomPrep ;
  abwiegen_V2 = dirV2 (prefixV "ab" (irregV "wiegen" "wiegt" "wog" "wöge" "gewogen"))  ;
  abwracken_V2 = dirV2 (prefixV "ab" (regV "wracken"))  ;
  abwuergen_V2 = dirV2 (prefixV "ab" (regV "würgen"))  ;
  abzeichnen_V2 = dirV2 (prefixV "ab" (regV "zeichnen"))  ;
  abziehen_V2 = dirV2 (prefixV "ab" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen"))  ;
  abziehen_von_V3 = dirV3 (prefixV "ab" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen")) von_Prep ;
  abzielen_auf_V3 = dirV3 (prefixV "ab" (regV "zielen")) (mkPrep "auf" accusative) ;
  abzocken_V2 = dirV2 (prefixV "ab" (regV "zocken"))  ;
  abzundern_V2 = dirV2 (prefixV "ab" (regV "zundern"))  ;
  abzweigen_von_V3 = dirV3 (prefixV "ab" (regV "zweigen")) von_Prep ;
  acheln_V2 = dirV2 (regV "acheln")  ;
  achten_auf_V2 = prepV2 (regV "achten") (mkPrep "auf" accusative) ;
  achten_V2 = dirV2 (regV "achten")  ;
  ackern_V = regV "ackern" ;
  acylieren_V2 = dirV2 (regV "acylieren")  ;
  adaptieren_an_V3 = dirV3 (regV "adaptieren") (mkPrep "an" accusative) ;
  addieren_V2 = dirV2 (regV "addieren")  ;
  addieren_zu_V3 = dirV3 (regV "addieren") zu_Prep ;
  adeln_sV2 = dassV2 (regV "adeln") accPrep ;
  adeln_V2 = dirV2 (regV "adeln")  ;
  adjungieren_an_V3 = dirV3 (regV "adjungieren") (mkPrep "an" accusative) ;
  adoptieren_V2 = dirV2 (regV "adoptieren")  ;
  adressieren_an_V3 = dirV3 (regV "adressieren") (mkPrep "an" accusative) ;
  adskribieren_dat_V2S = mkV2S (regV "adskribieren") datPrep ;
  adskribieren_dat_V3 = accdatV3 (regV "adskribieren")  ;
  adsorbieren_V2 = dirV2 (regV "adsorbieren")  ;
  aechten_V2 = dirV2 (regV "ächten")  ;
  aechzen_V = regV "ächzen" ;
  aedern_V2 = dirV2 (regV "ädern")  ;
  aehneln_dat_V2 = mkV2 (regV "ähneln") datPrep ;
  aehneln_rcV = reciV (regV "ähneln") dative ;
  aehnlichsehen_dat_V2 = mkV2 (prefixV "ähnlich" (irregV "sehen" "sieht" "sah" "sah" "gesehen")) datPrep ;
  aehnlichsehen_rcV = reciV (prefixV "ähnlich" (irregV "sehen" "sieht" "sah" "sah" "gesehen")) dative ;
  aendern_rV = reflV (regV "ändern") accusative ;
  aendern_V2 = dirV2 (regV "ändern")  ;
  aengstigen_mit_V3 = dirV3 (regV "ängstigen") mit_Prep ;
  aepfeln_V = regV "äpfeln" ;
  aequilibrieren_V0 = mkV0 (regV "äquilibrieren")  ;
  aergern_durch_V3 = dirV3 (regV "ärgern") durch_Prep ;
  aergern_mit_V3 = dirV3 (regV "ärgern") mit_Prep ;
  aergern_sV2 = dassV2 (regV "ärgern") accPrep ;
  aergern_ueber_rV2 = reflV2 (regV "ärgern") accusative (mkPrep "über" accusative) ;
  aergern_V2 = dirV2 (regV "ärgern")  ;
  aeschern_V2 = dirV2 (regV "äschern")  ;
  aesen_V = regV "äsen" ;
  aesthetisieren_V2 = dirV2 (regV "ästhetisieren")  ;
  aesthetisieren_VS = mkVS (regV "ästhetisieren")  ;
  aestimieren_V2 = dirV2 (regV "ästimieren")  ;
  aestimieren_VS = mkVS (regV "ästimieren")  ;
  aetherisieren_V2 = dirV2 (regV "ätherisieren")  ;
  aetzen_mit_V3 = dirV3 (regV "ätzen") mit_Prep ;
  aeufnen_V2 = dirV2 (regV "äufnen")  ;
  aeussern_ueber_rV2 = reflV2 (regV "äußern") accusative (mkPrep "über" accusative) ;
  aeussern_V2 = dirV2 (regV "äußern")  ;
  aeussern_VS = mkVS (regV "äußern")  ;
  aeussern_zu_rV2 = reflV2 (regV "äußern") accusative zu_Prep ;
  affichieren_V2 = dirV2 (regV "affichieren")  ;
  affigieren_an_V3 = dirV3 (regV "affigieren") (mkPrep "an" accusative) ;
  affizieren_sV2 = dassV2 (regV "affizieren") accPrep ;
  affizieren_V2 = dirV2 (regV "affizieren")  ;
  afrikanisieren_V2 = dirV2 (regV "afrikanisieren")  ;
  agglomerieren_V2 = dirV2 (regV "agglomerieren")  ;
  agglutinieren_an_V3 = dirV3 (regV "agglutinieren") (mkPrep "an" accusative) ;
  aggregieren_V2 = dirV2 (regV "aggregieren")  ;
  agieren_adv_V2 = prepV2 (regV "agieren") adv_Prep ;
  agitieren_V2 = dirV2 (regV "agitieren")  ;
  ahnden_V2 = dirV2 (regV "ahnden")  ;
  ahnden_VS = mkVS (regV "ahnden")  ;
  ahnen_V2 = dirV2 (regV "ahnen")  ;
  ahnen_VS = mkVS (regV "ahnen")  ;
  airbrushen_V = regV "airbrushen" ;
  akademisieren_V2 = dirV2 (regV "akademisieren")  ;
  akkommodieren_V2V = dirV2V (regV "akkommodieren")  ;
  akkreditieren_fuer_V3 = dirV3 (regV "akkreditieren") fuer_Prep ;
  akkumulieren_V2 = dirV2 (regV "akkumulieren")  ;
  akquirieren_V2 = dirV2 (regV "akquirieren")  ;
  aktivieren_V2 = dirV2 (regV "aktivieren")  ;
  aktualisieren_V2 = dirV2 (regV "aktualisieren")  ;
  akupunktieren_V2 = dirV2 (regV "akupunktieren")  ;
  akzentuieren_V2 = dirV2 (regV "akzentuieren")  ;
  akzeptieren_V2 = dirV2 (regV "akzeptieren")  ;
  akzeptieren_VS = mkVS (regV "akzeptieren")  ;
  alarmieren_sV2 = dassV2 (regV "alarmieren") accPrep ;
  alarmieren_V2 = dirV2 (regV "alarmieren")  ;
  albern_V = regV "albern" ;
  alienieren_V2 = dirV2 (regV "alienieren")  ;
  alimentieren_V2 = dirV2 (regV "alimentieren")  ;
  aliquotieren_V2 = dirV2 (regV "aliquotieren")  ;
  alkoholisieren_V2 = dirV2 (regV "alkoholisieren")  ;
  allegorisieren_V2 = dirV2 (regV "allegorisieren")  ;
  alloaktivieren_V0 = mkV0 (regV "alloaktivieren")  ;
  allokieren_V2 = dirV2 (regV "allokieren")  ;
  allozieren_V2 = dirV2 (regV "allozieren")  ;
  alphabetisieren_V2 = dirV2 (regV "alphabetisieren")  ;
  alteln_V = regV "alteln" ;
  alterieren_sV2 = dassV2 (regV "alterieren") accPrep ;
  alterieren_V2 = dirV2 (regV "alterieren")  ;
  altern_V = irregV "altern" "altert" "alterte" "altere" "gealtert" ;
  altertuemeln_V = regV "altertümeln" ;
  amalgamieren_mit_V3 = dirV3 (regV "amalgamieren") mit_Prep ;
  amalgamieren_V2 = dirV2 (regV "amalgamieren")  ;
  amateurisieren_V2 = dirV2 (regV "amateurisieren")  ;
  ambulieren_loc_V2 = prepV2 (regV "ambulieren") loc_Prep ;
  ameliorieren_V2 = dirV2 (regV "ameliorieren")  ;
  amerikanern_V = regV "amerikanern" ;
  amerikanisieren_V2 = dirV2 (regV "amerikanisieren")  ;
  amnestieren_V2 = dirV2 (regV "amnestieren")  ;
  amortisieren_rV = reflV (regV "amortisieren") accusative ;
  amplifizieren_V2 = dirV2 (regV "amplifizieren")  ;
  amputieren_V2 = dirV2 (regV "amputieren")  ;
  amtieren_als_V2 = prepV2 (regV "amtieren") (mkPrep "als" nominative) ;
  amuesieren_sV2 = dassV2 (regV "amüsieren") accPrep ;
  amuesieren_ueber_rV2 = reflV2 (regV "amüsieren") accusative (mkPrep "über" accusative) ;
  amuesieren_V2 = dirV2 (regV "amüsieren")  ;
  anaesthesieren_V2 = dirV2 (regV "anästhesieren")  ;
  anaesthetisieren_V2 = dirV2 (regV "anästhetisieren")  ;
  analysieren_V2 = dirV2 (regV "analysieren")  ;
  analysieren_VS = mkVS (regV "analysieren")  ;
  anastomosieren_plV = plV (prefixV "an" (irregV "astomosieren" "astomosiert" "astomosierte" "astomosierte" "geastomosiert"))  ;
  anastomosieren_unter_rV2 = reflV2 (prefixV "an" (irregV "astomosieren" "astomosiert" "astomosierte" "astomosierte" "geastomosiert")) accusative (mkPrep "unter" dative) ;
  anatagonisieren_V = regV "anatagonisieren" ;
  anbauen_V2 = dirV2 (prefixV "an" (regV "bauen"))  ;
  anbeissen_V = prefixV "an" (irregV "beißen" "beißt" "biss" "bisse" "gebissen") ;
  anbellen_V2 = dirV2 (prefixV "an" (regV "bellen"))  ;
  anberaumen_auf_V3 = dirV3 (prefixV "an" (regV "beraumen")) (mkPrep "auf" accusative) ;
  anberaumen_um_V3 = dirV3 (prefixV "an" (regV "beraumen")) um_Prep ;
  anbeten_V2 = dirV2 (prefixV "an" (regV "beten"))  ;
  anbieten_dat_V3 = accdatV3 (prefixV "an" (irregV "bieten" "bietet" "bot" "böte" "geboten"))  ;
  anbinden_am_V3 = dirV3 (prefixV "an" (regV "binden")) (mkPrep "an" dative) ;
  anbinden_an_V3 = dirV3 (prefixV "an" (regV "binden")) (mkPrep "an" accusative) ;
  anblinzeln_V2 = dirV2 (prefixV "an" (regV "blinzeln"))  ;
  anbrechen_V = prefixV "an" (irregV "brechen" "brecht" "brach" "bräche" "gebrochen") ;
  anbrennen_V = prefixV "an" (irregV "brennen" "brennt" "brannte" "brannte" "gebrannt") ;
  anbringen_V2 = dirV2 (prefixV "an" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  andauern_sV = dassV (prefixV "an" (regV "dauern"))  ;
  andauern_V = prefixV "an" (regV "dauern") ;
  andeuten_V2 = dirV2 (prefixV "an" (regV "deuten"))  ;
  andeuten_VS = mkVS (prefixV "an" (regV "deuten"))  ;
  andicken_V2 = dirV2 (prefixV "an" (regV "dicken"))  ;
  andrehen_dat_V3 = accdatV3 (prefixV "an" (regV "drehen"))  ;
  anellieren_an_V3 = dirV3 (regV "anellieren") (mkPrep "an" accusative) ;
  anerkennen_als_V3 = dirV3 (prefixV "an" (irregV "erkennen" "erkennt" "erkannte" "erkannte" "erkannt")) (mkPrep "als" accusative) ;
  anerkennen_VS = mkVS (prefixV "an" (irregV "erkennen" "erkennt" "erkannte" "erkannte" "erkannt"))  ;
  anfahren_V = prefixV "an" (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren") ;
  anfallen_V2 = dirV2 (prefixV "an" (regV "fallen"))  ;
  anfangen_mit_V2 = prepV2 (prefixV "an" (irregV "fangen" "fangt" "fing" "finge" "gefangen")) mit_Prep ;
  anfasen_V2 = dirV2 (prefixV "an" (regV "fasen"))  ;
  anfassen_V2 = dirV2 (prefixV "an" (regV "fassen"))  ;
  anfechten_V2 = dirV2 (prefixV "an" (irregV "fechten" "ficht" "focht" "föchte" "gefochten"))  ;
  anfertigen_V2 = dirV2 (prefixV "an" (regV "fertigen"))  ;
  anfeuern_V2 = dirV2 (prefixV "an" (regV "feuern"))  ;
  anfinden_loc_V3 = dirV3 (prefixV "an" (irregV "finden" "findet" "fand" "fände" "gefunden")) loc_Prep ;
  anflehen_V2 = dirV2 (prefixV "an" (regV "flehen"))  ;
  anfreunden_mit_rV2 = reflV2 (prefixV "an" (regV "freunden")) accusative mit_Prep ;
  anfuehlen_V2 = dirV2 (prefixV "an" (regV "fühlen"))  ;
  anfuehlen_wie_rV2 = reflV2 (prefixV "an" (regV "fühlen")) accusative (mkPrep "wie" nominative) ;
  angeben_mit_V2 = prepV2 (prefixV "an" (irregV "geben" "gebt" "gab" "gäbe" "gegeben")) mit_Prep ;
  angehen_sV = dassV (prefixV "an" (irregV "gehen" "geht" "ging" "ginge" "gegangen"))  ;
  angehen_V2 = dirV2 (prefixV "an" (irregV "gehen" "geht" "ging" "ginge" "gegangen"))  ;
  angehoeren_dat_V2 = mkV2 (prefixV "an" (regV "gehören")) datPrep ;
  angeln_V2 = dirV2 (regV "angeln")  ;
  angeln_V = regV "angeln" ;
  anglikanisieren_V2 = dirV2 (regV "anglikanisieren")  ;
  anglisieren_V2 = dirV2 (regV "anglisieren")  ;
  angreifen_V2 = dirV2 (prefixV "an" (irregV "greifen" "greift" "griff" "griffe" "gegriffen"))  ;
  angreifen_V = prefixV "an" (irregV "greifen" "greift" "griff" "griffe" "gegriffen") ;
  angrenzen_an_V2 = prepV2 (prefixV "an" (regV "grenzen")) (mkPrep "an" accusative) ;
  angrillen_V = prefixV "an" (regV "grillen") ;
  anhaben_dat_V3 = accdatV3 (prefixV "an" (irregV "haben" "hat" "hatte" "hatte" "gehabt"))  ;
  anhaben_V2 = dirV2 (prefixV "an" (irregV "haben" "hat" "hatte" "hatte" "gehabt"))  ;
  anhaeufen_V2 = dirV2 (prefixV "an" (regV "häufen"))  ;
  anhaften_dat_V2 = mkV2 (prefixV "an" (regV "haften")) datPrep ;
  anhalten_V2 = dirV2 (prefixV "an" (irregV "halten" "hält" "hielt" "hielte" "gehalten"))  ;
  anheben_V2 = dirV2 (prefixV "an" (irregV "heben" "hebt" "hob" "höbe" "gehoben"))  ;
  anheimstellen_dat_V2Q = mkV2Q (prefixV "anheim" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt")) datPrep ;
  anheimstellen_dat_V3 = accdatV3 (prefixV "anheim" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt"))  ;
  anhobbeln_V2 = dirV2 (prefixV "an" (regV "hobbeln"))  ;
  anhoeren_V2 = dirV2 (prefixV "an" (regV "hören"))  ;
  anhydrisieren_V2 = dirV2 (regV "anhydrisieren")  ;
  animalisieren_V2 = dirV2 (regV "animalisieren")  ;
  animieren_V2 = dirV2 (regV "animieren")  ;
  ankacken_V2 = dirV2 (prefixV "an" (regV "kacken"))  ;
  ankennen_dat_V3 = accdatV3 (prefixV "an" (irregV "kennen" "kennt" "kannte" "kannte" "gekannt"))  ;
  ankern_V = prefixV "an" (irregV "kern" "kert" "kerte" "kerte" "gekert") ;
  anklagen_gen_V3 = dirV3 (prefixV "an" (regV "klagen")) genPrep ;
  anklagen_V2 = dirV2 (prefixV "an" (regV "klagen"))  ;
  anklagen_V2V = dirV2V (prefixV "an" (regV "klagen"))  ;
  ankleben_V2 = dirV2 (prefixV "an" (regV "kleben"))  ;
  anklopfen_bei_V2 = prepV2 (prefixV "an" (regV "klopfen")) bei_Prep ;
  ankommen_loc_V2 = prepV2 (prefixV "an" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) loc_Prep ;
  ankommen_V = prefixV "an" (irregV "kommen" "kommt" "kam" "käme" "gekommen") ;
  ankreiden_dat_V2S = mkV2S (prefixV "an" (regV "kreiden")) datPrep ;
  ankreuzen_V2 = dirV2 (prefixV "an" (regV "kreuzen"))  ;
  ankuendigen_dat_V2S = mkV2S (prefixV "an" (regV "kündigen")) datPrep ;
  ankuendigen_dat_V2V = mkV2V (prefixV "an" (regV "kündigen")) datPrep ;
  ankuendigen_dat_V3 = accdatV3 (prefixV "an" (regV "kündigen"))  ;
  ankuendigen_V2 = dirV2 (prefixV "an" (regV "kündigen"))  ;
  ankuendigen_VS = mkVS (prefixV "an" (regV "kündigen"))  ;
  ankuendigen_VV = mkVV (prefixV "an" (regV "kündigen"))  ;
  anlabern_V2 = dirV2 (prefixV "an" (regV "labern"))  ;
  anlachen_V2 = dirV2 (prefixV "an" (regV "lachen"))  ;
  anlaecheln_V2 = dirV2 (prefixV "an" (regV "lächeln"))  ;
  anlangen_loc_V2 = prepV2 (prefixV "an" (regV "langen")) loc_Prep ;
  anlangen_V = prefixV "an" (regV "langen") ;
  anlassen_V2 = dirV2 (prefixV "an" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  anlegen_V = prefixV "an" (regV "legen") ;
  anlocken_mit_V3 = dirV3 (prefixV "an" (regV "locken")) mit_Prep ;
  anlocken_V2 = dirV2 (prefixV "an" (regV "locken"))  ;
  anluegen_V2 = dirV2 (prefixV "an" (irregV "lügen" "lügt" "log" "log" "gelogen"))  ;
  anmachen_V = prefixV "an" (regV "machen") ;
  anmalen_V2 = dirV2 (prefixV "an" (regV "malen"))  ;
  anmassen_rVV = reflVV (prefixV "an" (regV "maßen")) accusative ;
  anmelden_bei_V3 = dirV3 (prefixV "an" (regV "melden")) bei_Prep ;
  anmelden_im_V3 = dirV3 (prefixV "an" (regV "melden")) (mkPrep "in" dative) ;
  anmelden_V2 = dirV2 (prefixV "an" (regV "melden"))  ;
  anmieten_V2 = dirV2 (prefixV "an" (regV "mieten"))  ;
  anmuten_dat_V2V = mkV2V (prefixV "an" (irregV "muten" "mutet" "mutete" "mutete" "angemutet")) datPrep ;
  anmuten_iVA = infzuVA (prefixV "an" (irregV "muten" "mutet" "mutete" "mutete" "angemutet"))  ;
  anmuten_V2 = dirV2 (prefixV "an" (irregV "muten" "mutet" "mutete" "mutete" "angemutet"))  ;
  anmuten_VA = mkVA (prefixV "an" (irregV "muten" "mutet" "mutete" "mutete" "angemutet"))  ;
  annehmen_V2 = dirV2 (prefixV "an" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  annektieren_V2 = dirV2 (regV "annektieren")  ;
  annullieren_V2 = dirV2 (regV "annullieren")  ;
  anonymisieren_V2 = dirV2 (regV "anonymisieren")  ;
  anordnen_VS = mkVS (prefixV "an" (regV "ordnen"))  ;
  anpassen_an_V3 = dirV3 (prefixV "an" (regV "passen")) (mkPrep "an" accusative) ;
  anpassen_rcV2 = reciV2 (prefixV "an" (regV "passen")) accusative ;
  anpingen_V2 = dirV2 (prefixV "an" (regV "pingen"))  ;
  anpissen_V2 = dirV2 (prefixV "an" (regV "pissen"))  ;
  anprangern_V2 = dirV2 (prefixV "an" (regV "prangern"))  ;
  anprangern_VS = mkVS (prefixV "an" (regV "prangern"))  ;
  anpummeln_V = prefixV "an" (regV "pummeln") ;
  anranzen_V2 = dirV2 (prefixV "an" (regV "ranzen"))  ;
  anreden_mit_V3 = dirV3 (prefixV "an" (regV "reden")) mit_Prep ;
  anreden_V2 = dirV2 (prefixV "an" (regV "reden"))  ;
  anregen_V2 = dirV2 (prefixV "an" (regV "regen"))  ;
  anregen_VS = mkVS (prefixV "an" (regV "regen"))  ;
  anregen_VV = mkVV (prefixV "an" (regV "regen"))  ;
  anrichten_V2 = dirV2 (prefixV "an" (regV "richten"))  ;
  anruehren_V2 = dirV2 (prefixV "an" (regV "rühren"))  ;
  anrufen_bei_V2 = prepV2 (prefixV "an" (irregV "rufen" "ruft" "rief" "riefe" "gerufen")) (mkPrep "bei" dative) ;
  anrufen_V2 = dirV2 (prefixV "an" (irregV "rufen" "ruft" "rief" "riefe" "gerufen"))  ;
  ansagen_V2 = dirV2 (prefixV "an" (regV "sagen"))  ;
  ansalben_V2 = dirV2 (prefixV "an" (regV "salben"))  ;
  anschaffen_V2 = dirV2 (prefixV "an" (regV "schaffen"))  ;
  anschalten_V2 = dirV2 (prefixV "an" (regV "schalten"))  ;
  anschauen_V2 = dirV2 (prefixV "an" (regV "schauen"))  ;
  anschliessen_an_V3 = dirV3 (irregV "anschließen" "schließt" "schloss" "schlösse" "geschlossen") (mkPrep "an" accusative) ;
  anschliessen_V2 = dirV2 (irregV "anschließen" "schließt" "schloss" "schlösse" "geschlossen")  ;
  anschmieren_V2 = dirV2 (prefixV "an" (regV "schmieren"))  ;
  anschnallen_V2 = dirV2 (prefixV "an" (regV "schnallen"))  ;
  anschneien_V = prefixV "an" (regV "schneien") ;
  anschrauben_V2 = dirV2 (prefixV "an" (regV "schrauben"))  ;
  anschuhen_V2 = dirV2 (prefixV "an" (regV "schuhen"))  ;
  anschuldigen_gen_V3 = dirV3 (prefixV "an" (regV "schuldigen")) genPrep ;
  anschuldigen_V2S = dirV2S (prefixV "an" (regV "schuldigen"))  ;
  anschwaerzen_bei_V3 = dirV3 (prefixV "an" (regV "schwärzen")) (mkPrep "bei" dative) ;
  anschwaerzen_V2 = dirV2 (prefixV "an" (regV "schwärzen"))  ;
  anschwitzen_V2 = dirV2 (prefixV "an" (regV "schwitzen"))  ;
  ansegeln_V2 = dirV2 (prefixV "an" (regV "segeln"))  ;
  ansehen_V2 = dirV2 (prefixV "an" (irregV "sehen" "seht" "sah" "sähe" "gesehen"))  ;
  anspielen_auf_V2 = prepV2 (prefixV "an" (regV "spielen")) (mkPrep "auf" accusative) ;
  ansprechen_auf_V3 = dirV3 (prefixV "an" (irregV "sprechen" "spricht" "sprach" "spräche" "gesprochen")) (mkPrep "auf" accusative) ;
  ansprechen_V2 = dirV2 (prefixV "an" (irregV "sprechen" "spricht" "sprach" "spräche" "gesprochen"))  ;
  anstarren_V2 = dirV2 (prefixV "an" (regV "starren"))  ;
  anstecken_V2 = dirV2 (prefixV "an" (irregV "stecken" "steckt" "steckte" "steckte" "gesteckt"))  ;
  anstehen_loc_V2 = prepV2 (prefixV "an" (irregV "stehen" "steht" "stand" "stände" "gestanden")) loc_Prep ;
  anstehen_V = prefixV "an" (irregV "stehen" "steht" "stand" "stände" "gestanden") ;
  ansteigen_V = prefixV "an" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen") ;
  anstellen_V2 = dirV2 (prefixV "an" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt"))  ;
  anstimmen_V2 = dirV2 (prefixV "an" (regV "stimmen"))  ;
  anstreben_V2 = dirV2 (prefixV "an" (regV "streben"))  ;
  anstreben_VS = mkVS (prefixV "an" (regV "streben"))  ;
  anstreichen_V2 = dirV2 (prefixV "an" (irregV "streichen" "streicht" "strich" "strich" "gestrichen"))  ;
  anstrengen_rV = reflV (prefixV "an" (regV "strengen")) accusative ;
  antichambrieren_bei_V2 = prepV2 (regV "antichambrieren") bei_Prep ;
  antikisieren_V2 = dirV2 (regV "antikisieren")  ;
  antilogarithmieren_V2 = dirV2 (regV "antilogarithmieren")  ;
  antizipieren_V2 = dirV2 (regV "antizipieren")  ;
  antizipieren_VS = mkVS (regV "antizipieren")  ;
  antreiben_V2 = dirV2 (prefixV "an" (irregV "treiben" "treibt" "trieb" "triebe" "getrieben"))  ;
  antreiben_zu_V3 = dirV3 (prefixV "an" (irregV "treiben" "treibt" "trieb" "triebe" "getrieben")) zu_Prep ;
  antreten_V = prefixV "an" (irregV "treten" "tritt" "trat" "träte" "getreten") ;
  antreten_VV = mkVV (prefixV "an" (irregV "treten" "tritt" "trat" "träte" "getreten"))  ;
  antreten_zu_V2 = prepV2 (prefixV "an" (irregV "treten" "tritt" "trat" "träte" "getreten")) zu_Prep ;
  antun_dat_V3 = accdatV3 (prefixV "an" (irregV "tun" "tut" "tat" "täte" "getan"))  ;
  antworten_dat_auf_V3S = mkV3S (regV "antworten") datPrep (mkPrep "auf" accusative) ;
  antworten_dat_auf_V4 = mkV4 (regV "antworten") datPrep (mkPrep "auf" accusative) accPrep ;
  anvertrauen_dat_V2S = mkV2S (prefixV "an" (regV "vertrauen")) datPrep ;
  anvertrauen_dat_V3 = accdatV3 (prefixV "an" (regV "vertrauen"))  ;
  anvisieren_V2 = dirV2 (prefixV "an" (regV "visieren"))  ;
  anwachsen_V = prefixV "an" (regV "wachsen") ;
  anweisen_V2V = dirV2V (prefixV "an" (irregV "weisen" "weist" "wies" "wiese" "gewiesen"))  ;
  anwenden_V2 = dirV2 (prefixV "an" (regV "wenden"))  ;
  anzeigen_V2 = dirV2 (prefixV "an" (regV "zeigen"))  ;
  anziehen_V2 = dirV2 (prefixV "an" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen"))  ;
  anzuenden_V2 = dirV2 (prefixV "an" (regV "zünden"))  ;
  anzweifeln_V2 = dirV2 (prefixV "an" (regV "zweifeln"))  ;
  anzweifeln_VS = mkVS (prefixV "an" (regV "zweifeln"))  ;
  apologetisieren_V2 = dirV2 (regV "apologetisieren")  ;
  apologisieren_V2 = dirV2 (regV "apologisieren")  ;
  apostrophieren_V2 = dirV2 (regV "apostrophieren")  ;
  apparieren_V = regV "apparieren" ;
  appellieren_an_V2V = mkV2V (regV "appellieren") (mkPrep "an" accusative) ;
  applaudieren_dat_V2 = mkV2 (regV "applaudieren") datPrep ;
  applizieren_loc_V3 = dirV3 (regV "applizieren") loc_Prep ;
  apponieren_V2 = dirV2 (regV "apponieren")  ;
  approbieren_V2 = dirV2 (regV "approbieren")  ;
  appropriieren_V2 = dirV2 (regV "appropriieren")  ;
  aquarellieren_V2 = dirV2 (regV "aquarellieren")  ;
  arabisieren_V2 = dirV2 (regV "arabisieren")  ;
  arbeiten_als_V2 = prepV2 (regV "arbeiten") (mkPrep "als" nominative) ;
  arbeiten_am_V2 = prepV2 (regV "arbeiten") (mkPrep "an" dative) ;
  archaisieren_V2 = dirV2 (regV "archaisieren")  ;
  archivieren_V2 = dirV2 (regV "archivieren")  ;
  argumentieren_fuer_V2 = prepV2 (regV "argumentieren") fuer_Prep ;
  argumentieren_gegen_V2 = prepV2 (regV "argumentieren") gegen_Prep ;
  argwoehnen_V2 = dirV2 (regV "argwöhnen")  ;
  argwoehnen_VS = mkVS (regV "argwöhnen")  ;
  arisieren_V2 = dirV2 (regV "arisieren")  ;
  armieren_V2 = dirV2 (regV "armieren")  ;
  aromatisieren_mit_V3 = dirV3 (regV "aromatisieren") mit_Prep ;
  arrangieren_mit_rV2 = reflV2 (regV "arrangieren") accusative mit_Prep ;
  arrangieren_rV = reflV (regV "arrangieren") accusative ;
  arrangieren_V2 = dirV2 (regV "arrangieren")  ;
  arrangieren_VS = mkVS (regV "arrangieren")  ;
  arrestieren_V2 = dirV2 (regV "arrestieren")  ;
  arretieren_V2 = dirV2 (regV "arretieren")  ;
  arrivieren_V = regV "arrivieren" ;
  arschen_V = regV "arschen" ;
  artikulieren_adv_rV2 = reflV2 (regV "artikulieren") accusative adv_Prep ;
  artikulieren_V2 = dirV2 (regV "artikulieren")  ;
  artikulieren_VS = mkVS (regV "artikulieren")  ;
  assemblieren_V2 = dirV2 (regV "assemblieren")  ;
  assimilieren_an_V3 = dirV3 (regV "assimilieren") (mkPrep "an" accusative) ;
  assoziieren_mit_V3 = dirV3 (regV "assoziieren") mit_Prep ;
  atmen_V = irregV "atmen" "atmet" "atmete" "atmete" "geatmet" ;
  atrophieren_V = regV "atrophieren" ;
  attackieren_V2 = dirV2 (regV "attackieren")  ;
  attentieren_V0 = mkV0 (regV "attentieren")  ;
  attenuieren_V0 = mkV0 (regV "attenuieren")  ;
  attestieren_dat_V2S = mkV2S (regV "attestieren") datPrep ;
  attestieren_dat_V3 = accdatV3 (regV "attestieren")  ;
  attrahieren_V2 = dirV2 (regV "attrahieren")  ;
  atzen_V2 = dirV2 (regV "atzen")  ;
  aufarbeiten_V2 = dirV2 (prefixV "auf" (regV "arbeiten"))  ;
  aufbaeumen_rV = reflV (prefixV "auf" (regV "bäumen")) accusative ;
  aufbahren_V2 = dirV2 (prefixV "auf" (regV "bahren"))  ;
  aufbauen_rV = reflV (prefixV "auf" (regV "bauen")) accusative ;
  aufbauen_V2 = dirV2 (prefixV "auf" (regV "bauen"))  ;
  aufbauschen_V2 = dirV2 (prefixV "auf" (regV "bauschen"))  ;
  aufbegehren_V = prefixV "auf" (regV "begehren") ;
  aufbetten_dat_V2 = mkV2 (prefixV "auf" (regV "betten")) datPrep ;
  aufbewahren_loc_V3 = dirV3 (prefixV "auf" (regV "bewahren")) loc_Prep ;
  aufbewahren_V2 = dirV2 (prefixV "auf" (regV "bewahren"))  ;
  aufblasen_V2 = dirV2 (prefixV "auf" (irregV "blasen" "bläst" "blies" "blies" "geblasen"))  ;
  aufbleiben_V = prefixV "auf" (irregV "bleiben" "bleibt" "blieb" "blieb" "geblieben") ;
  aufblitzen_V = prefixV "auf" (regV "blitzen") ;
  aufbrechen_V = prefixV "auf" (irregV "brechen" "brecht" "brach" "bräche" "gebrochen") ;
  aufbringen_gegen_V3 = dirV3 (prefixV "auf" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht")) (mkPrep "gegen" accusative) ;
  aufbringen_V2 = dirV2 (prefixV "auf" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  aufdecken_V2 = dirV2 (prefixV "auf" (regV "decken"))  ;
  aufdonnern_rV = reflV (prefixV "auf" (irregV "donnern" "donnert" "donnerte" "donnerte" "gedonnert")) accusative ;
  aufdraengen_dat_rV2 = reflV2 (prefixV "auf" (regV "drängen")) accusative datPrep ;
  aufdrehen_V2 = dirV2 (prefixV "auf" (regV "drehen"))  ;
  aufdrehen_V = prefixV "auf" (regV "drehen") ;
  auferstehen_V = prefixV "auf" (irregV "erstehen" "ersteht" "erstand" "erstände" "erstanden") ;
  aufessen_V2 = dirV2 (prefixV "auf" (irregV "essen" "isst" "aß" "aß" "gegessen"))  ;
  auffahren_V2 = dirV2 (prefixV "auf" (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren"))  ;
  auffallen_dat_V2 = mkV2 (prefixV "auf" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen")) datPrep ;
  auffassen_als_V3 = dirV3 (prefixV "auf" (regV "fassen")) (mkPrep "als" accusative) ;
  auffrieren_V = prefixV "auf" (irregV "frieren" "friert" "fror" "fröre" "gefroren") ;
  auffuehren_V2 = dirV2 (prefixV "auf" (regV "führen"))  ;
  aufgeben_V2 = dirV2 (prefixV "auf" (irregV "geben" "gebt" "gab" "gäbe" "gegeben"))  ;
  aufgeben_V = prefixV "auf" (irregV "geben" "gebt" "gab" "gäbe" "gegeben") ;
  aufgeben_VV = mkVV (prefixV "auf" (irregV "geben" "gebt" "gab" "gäbe" "gegeben"))  ;
  aufgehen_dat_V2 = mkV2 (prefixV "auf" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) datPrep ;
  aufgehen_V = prefixV "auf" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  aufhaengen_V2 = dirV2 (prefixV "auf" (regV "hängen"))  ;
  aufhalten_V2 = dirV2 (prefixV "auf" (irregV "halten" "hält" "hielt" "hielte" "gehalten"))  ;
  aufheben_dat_V3 = accdatV3 (prefixV "auf" (irregV "heben" "hebt" "hob" "höbe" "gehoben"))  ;
  aufheben_V2 = dirV2 (prefixV "auf" (irregV "heben" "hebt" "hob" "höbe" "gehoben"))  ;
  aufheitern_sV2 = dassV2 (prefixV "auf" (regV "heitern")) accPrep ;
  aufheitern_V2 = dirV2 (prefixV "auf" (regV "heitern"))  ;
  aufhoeren_mit_V2 = prepV2 (prefixV "auf" (regV "hören")) mit_Prep ;
--  aufhoeren_V = prefixV "auf" (irregV "hören" "hört" "hörte" "hörte" "gehört") ;
  aufhoeren_VV = mkVV (prefixV "auf" (regV "hören"))  ;
  aufklaeren_V2 = dirV2 (prefixV "auf" (regV "klären"))  ;
  aufklaren_V2 = dirV2 (prefixV "auf" (regV "klaren"))  ;
  aufkleben_V2 = dirV2 (prefixV "auf" (regV "kleben"))  ;
  aufkochen_V2 = dirV2 (prefixV "auf" (regV "kochen"))  ;
  aufkommen_fuer_V2 = prepV2 (prefixV "auf" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) (mkPrep "für" accusative) ;
  aufkreuzen_loc_V2 = prepV2 (prefixV "auf" (regV "kreuzen")) loc_Prep ;
  aufladen_auf_V3 = dirV3 (prefixV "auf" (irregV "laden" "lädt" "lud" "lüde" "geladen")) (mkPrep "auf" accusative) ;
  aufladen_V2 = dirV2 (prefixV "auf" (irregV "laden" "lädt" "lud" "lüde" "geladen"))  ;
  auflassen_V2 = dirV2 (prefixV "auf" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  auflegen_V2 = dirV2 (prefixV "auf" (regV "legen"))  ;
  auflehnen_rV = reflV (prefixV "auf" (irregV "lehnen" "lehnt" "lehnte" "lehnte" "gelehnt")) accusative ;
  aufliefern_V2 = dirV2 (prefixV "auf" (regV "liefern"))  ;
  aufloesen_in_rV2 = reflV2 (prefixV "auf" (regV "lösen")) accusative (mkPrep "in" accusative) ;
  aufloesen_V2 = dirV2 (prefixV "auf" (regV "lösen"))  ;
--  aufloesen_V = prefixV "auf" (irregV "lösen" "löst" "löste" "löste" "gelöst") ;
  aufmachen_V2 = dirV2 (prefixV "auf" (regV "machen"))  ;
  aufmandeln_rV = reflV (prefixV "auf" (regV "mandeln")) accusative ;
  aufmerken_V = prefixV "auf" (regV "merken") ;
  aufmischen_V2 = dirV2 (prefixV "auf" (regV "mischen"))  ;
  aufmotzen_V2 = dirV2 (prefixV "auf" (regV "motzen"))  ;
  aufmucken_V = prefixV "auf" (regV "mucken") ;
  aufmuntern_sV2 = dassV2 (prefixV "auf" (regV "muntern")) accPrep ;
  aufmuntern_V2 = dirV2 (prefixV "auf" (regV "muntern"))  ;
  aufnehmen_V2 = dirV2 (prefixV "auf" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  aufnoetigen_dat_V2V = mkV2V (prefixV "auf" (regV "nötigen")) datPrep ;
  aufnoetigen_dat_V3 = accdatV3 (prefixV "auf" (regV "nötigen"))  ;
  aufoktroyieren_dat_V2V = mkV2V (prefixV "auf" (regV "oktroyieren")) datPrep ;
  aufoktroyieren_dat_V3 = accdatV3 (prefixV "auf" (regV "oktroyieren"))  ;
  aufpaeppeln_V2 = dirV2 (prefixV "auf" (irregV "päppeln" "päppelt" "päppelt" "päppelt" "gepäppelt"))  ;
  aufpassen_auf_V2 = prepV2 (prefixV "auf" (regV "passen")) (mkPrep "auf" accusative) ;
  aufpassen_V = prefixV "auf" (regV "passen") ;
  aufpeppeln_V2 = dirV2 (prefixV "auf" (regV "peppeln"))  ;
  aufpeppen_V2 = dirV2 (prefixV "auf" (regV "peppen"))  ;
  aufpflanzen_V2 = dirV2 (prefixV "auf" (regV "pflanzen"))  ;
  aufpflanzen_vor_rV2 = reflV2 (prefixV "auf" (regV "pflanzen")) accusative (mkPrep "vor" dative) ;
  aufplustern_rV = reflV (irregV "aufplustern" "plustert" "plusterte" "plusterte" "aufgeplustert") accusative ;
  aufprallen_auf_V2 = prepV2 (prefixV "auf" (regV "prallen")) (mkPrep "auf" accusative) ;
  aufpudeln_rV = reflV (prefixV "auf" (regV "pudeln")) accusative ;
  aufpudeln_ueber_rV2 = reflV2 (prefixV "auf" (regV "pudeln")) accusative (mkPrep "über" accusative) ;
  aufraeumen_V2 = dirV2 (prefixV "auf" (regV "räumen"))  ;
  aufrebbeln_V2 = dirV2 (prefixV "auf" (regV "rebbeln"))  ;
  aufrechnen_V2 = dirV2 (prefixV "auf" (regV "rechnen"))  ;
  aufrechterhalten_V2 = dirV2 (prefixV "aufrecht" (regV "erhalten"))  ;
  aufregen_rV = reflV (prefixV "auf" (regV "regen")) accusative ;
  aufreiben_rV = reflV (prefixV "auf" (irregV "reiben" "reibt" "rieb" "riebe" "gerieben")) accusative ;
  aufrichten_V2 = dirV2 (prefixV "auf" (regV "richten"))  ;
  aufrufen_V2 = dirV2 (prefixV "auf" (irregV "rufen" "ruft" "rief" "rief" "gerufen"))  ;
  aufrunden_V2 = dirV2 (prefixV "auf" (regV "runden"))  ;
  aufscheinen_V = prefixV "auf" (irregV "scheinen" "scheint" "schien" "schien" "geschienen") ;
  aufschlagen_loc_V2 = prepV2 (prefixV "auf" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen")) loc_Prep ;
  aufschlagen_loc_V3 = dirV3 (prefixV "auf" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen")) loc_Prep ;
  aufschlagen_V2 = dirV2 (prefixV "auf" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen"))  ;
  aufschlagen_V = prefixV "auf" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen") ;
  aufschliessen_V2 = dirV2 (prefixV "auf" (irregV "schließen" "schließt" "schloss" "schloss" "geschlossen"))  ;
  aufschneiden_V = prefixV "auf" (irregV "schneiden" "schneidet" "schnitt" "schnitt" "geschnitten") ;
  aufschreiben_V2 = dirV2 (prefixV "auf" (irregV "schreiben" "schreibt" "schrieb" "schrieb" "geschrieben"))  ;
  aufschweissen_V2 = dirV2 (prefixV "auf" (regV "schweißen"))  ;
  aufsehen_V = prefixV "auf" (irregV "sehen" "sieht" "sah" "sah" "gesehen") ;
  aufsitzen_V = prefixV "auf" (irregV "sitzen" "sitzt" "saß" "säße" "gesessen") ;
  aufstehen_V = prefixV "auf" (irregV "stehen" "steht" "stand" "stände" "gestanden") ;
  aufsteigen_auf_V2 = prepV2 (prefixV "auf" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen")) (mkPrep "auf" accusative) ;
  aufsteigen_V = prefixV "auf" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen") ;
  aufstellen_rV = reflV (prefixV "auf" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt")) accusative ;
  aufstellen_V2 = dirV2 (prefixV "auf" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt"))  ;
  aufsticken_auf_V3 = dirV3 (prefixV "auf" (regV "sticken")) (mkPrep "auf" accusative) ;
  aufstocken_V2 = dirV2 (prefixV "auf" (regV "stocken"))  ;
  aufstossen_dat_sV2 = dassV2 (prefixV "auf" (irregV "stoßen" "stößt" "stieß" "stieß" "gestoßen")) datPrep ;
  auftakeln_V2 = dirV2 (prefixV "auf" (regV "takeln"))  ;
  auftauchen_V = prefixV "auf" (regV "tauchen") ;
  aufteen_V2 = dirV2 (irregV "aufteen" "teet" "teete" "teete" "aufgeteet")  ;
  aufteen_V = irregV "aufteen" "teet" "teete" "teete" "aufgeteet" ;
  aufteilen_V2 = dirV2 (prefixV "auf" (irregV "teilen" "teilt" "teilte" "teilte" "geteilt"))  ;
  auftischen_dat_V3 = accdatV3 (prefixV "auf" (regV "tischen"))  ;
  auftragen_dat_V2V = mkV2V (prefixV "auf" (irregV "tragen" "tragt" "trug" "trüge" "getragen")) datPrep ;
  auftragen_dat_V3 = accdatV3 (prefixV "auf" (irregV "tragen" "tragt" "trug" "trüge" "getragen"))  ;
  auftrennen_V2 = dirV2 (prefixV "auf" (irregV "trennen" "trennt" "trennte" "trennte" "getrennt"))  ;
  auftreppen_V2 = dirV2 (prefixV "auf" (regV "treppen"))  ;
  auftreten_loc_V2 = prepV2 (prefixV "auf" (irregV "treten" "tritt" "trat" "träte" "getreten")) loc_Prep ;
  auftreten_V = prefixV "auf" (irregV "treten" "tritt" "trat" "träte" "getreten") ;
  aufwachen_V = prefixV "auf" (regV "wachen") ;
  aufwachsen_loc_V2 = prepV2 (prefixV "auf" (irregV "wachsen" "wachst" "wuchs" "wüchse" "gewachsen")) loc_Prep ;
  aufwaermen_V2 = dirV2 (prefixV "auf" (regV "wärmen"))  ;
  aufwecken_V2 = dirV2 (prefixV "auf" (regV "wecken"))  ;
  aufweisen_V2 = dirV2 (prefixV "auf" (irregV "weisen" "weist" "wies" "wiese" "gewiesen"))  ;
  aufwenden_V2 = dirV2 (prefixV "auf" (irregV "wenden" "wendet" "wandte" "wandte" "gewandt"))  ;
  aufwerfen_V2 = dirV2 (prefixV "auf" (irregV "werfen" "werft" "warf" "würfe" "geworfen"))  ;
  aufwerten_V2 = dirV2 (prefixV "auf" (regV "werten"))  ;
  aufwickeln_V2 = dirV2 (prefixV "auf" (regV "wickeln"))  ;
--  aufzeigen_V = prefixV "auf" (irregV "zeigen" "zeigt" "zeigte" "zeigte" "gezeigt") ;
  aufzeigen_V = prefixV "auf" (regV "zeigen") ;
  aufzeigen_VS = mkVS (prefixV "auf" (regV "zeigen"))  ;
  aufziehen_mit_V3 = dirV3 (prefixV "auf" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen")) mit_Prep ;
  aufziehen_V2 = dirV2 (prefixV "auf" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen"))  ;
  auktionieren_V2 = dirV2 (regV "auktionieren")  ;
  ausantworten_dat_V3 = accdatV3 (prefixV "aus" (regV "antworten"))  ;
  ausarbeiten_V2 = dirV2 (prefixV "aus" (regV "arbeiten"))  ;
  ausarten_V = prefixV "aus" (regV "arten") ;
  ausatmen_V = prefixV "aus" (regV "atmen") ;
  ausbacken_V2 = dirV2 (prefixV "aus" (irregV "backen" "bäckt" "buk" "buk" "gebacken"))  ;
  ausbaden_V2 = dirV2 (prefixV "aus" (regV "baden"))  ;
  ausbaldowern_V2 = dirV2 (prefixV "aus" (regV "baldowern"))  ;
  ausbauen_V2 = dirV2 (prefixV "aus" (regV "bauen"))  ;
  ausbeinen_V2 = dirV2 (prefixV "aus" (regV "beinen"))  ;
  ausbessern_V2 = dirV2 (prefixV "aus" (regV "bessern"))  ;
  ausbilden_V2 = dirV2 (prefixV "aus" (regV "bilden"))  ;
  ausbilden_zu_V3 = dirV3 (prefixV "aus" (regV "bilden")) zu_Prep ;
  ausbleiben_V = prefixV "aus" (irregV "bleiben" "bleibt" "blieb" "bliebe" "geblieben") ;
  ausbojen_V2 = dirV2 (regV "ausbojen")  ;
  ausbrechen_aus_V2 = prepV2 (prefixV "aus" (irregV "brechen" "brecht" "brach" "bräche" "gebrochen")) aus_Prep ;
  ausbreiten_V2 = dirV2 (prefixV "aus" (irregV "breiten" "breitet" "breite" "breite" "gebreitet"))  ;
  ausbrueten_V2 = dirV2 (prefixV "aus" (regV "brüten"))  ;
  ausbuexen_von_V2 = prepV2 (prefixV "aus" (regV "büxen")) von_Prep ;
  ausbuexen_V = prefixV "aus" (regV "büxen") ;
  ausdehnen_rV = reflV (prefixV "aus" (regV "dehnen")) accusative ;
  ausdenken_rV2 = reflV2 (prefixV "aus" (irregV "denken" "denkt" "dachte" "dächte" "gedacht")) accusative accPrep ;
  ausdruecken_rVA = reflVA (prefixV "aus" (regV "drücken")) accusative ;
  ausdruecken_V2 = dirV2 (prefixV "aus" (regV "drücken"))  ;
--  ausdruecken_V = prefixV "aus" (irregV "drücken" "drückt" "drückte" "drückte" "gedrückt") ;
  auseinandersetzen_mit_rV2 = reflV2 (prefixV "auseinander" (regV "setzen")) accusative mit_Prep ;
  auserkiesen_V2 = dirV2 (prefixV "aus" (irregV "erkiesen" "erkiest" "erkor" "erköre" "erkoren"))  ;
  ausfallen_V = prefixV "aus" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen") ;
  ausflippen_V = prefixV "aus" (regV "flippen") ;
  ausfragen_V2 = dirV2 (prefixV "aus" (regV "fragen"))  ;
  ausfratscheln_V2 = dirV2 (prefixV "aus" (regV "fratscheln"))  ;
  ausfuehren_V2 = dirV2 (prefixV "aus" (regV "führen"))  ;
  ausfuehren_VS = mkVS (prefixV "aus" (regV "führen"))  ;
  ausfuellen_V2 = dirV2 (prefixV "aus" (regV "füllen"))  ;
  ausgeben_V2 = dirV2 (prefixV "aus" (irregV "geben" "gebt" "gab" "gäbe" "gegeben"))  ;
  ausgehen_mit_V2 = prepV2 (prefixV "aus" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) mit_Prep ;
  ausgehen_V = prefixV "aus" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  ausgleichen_durch_V3 = dirV3 (prefixV "aus" (irregV "gleichen" "gleicht" "glich" "gliche" "geglichen")) durch_Prep ;
  ausgleichen_V2 = dirV2 (prefixV "aus" (irregV "gleichen" "gleicht" "glich" "gliche" "geglichen"))  ;
  ausgraben_V2 = dirV2 (prefixV "aus" (irregV "graben" "gräbt" "grub" "grub" "gegraben"))  ;
  ausgrauen_V2 = dirV2 (prefixV "aus" (regV "grauen"))  ;
  ausgrenzen_V2 = dirV2 (prefixV "aus" (regV "grenzen"))  ;
  aushaendigen_dat_V3 = accdatV3 (prefixV "aus" (regV "händigen"))  ;
  aushaerten_V = prefixV "aus" (regV "härten") ;
  aushalten_V2 = dirV2 (prefixV "aus" (irregV "halten" "hält" "hielt" "hielte" "gehalten"))  ;
  aushandeln_mit_V3 = dirV3 (prefixV "aus" (regV "handeln")) mit_Prep ;
  aushandeln_plV2 = pldirV2 (prefixV "aus" (regV "handeln"))  ;
  aushebeln_V2 = dirV2 (prefixV "aus" (regV "hebeln"))  ;
  aushebern_V2 = dirV2 (regV "aushebern")  ;
  aushungern_V2 = dirV2 (prefixV "aus" (regV "hungern"))  ;
  ausixen_V = prefixV "aus" (regV "ixen") ;
  auskehren_V2 = dirV2 (prefixV "aus" (regV "kehren"))  ;
  ausklammern_V2 = dirV2 (prefixV "aus" (regV "klammern"))  ;
  auskleiden_V2 = dirV2 (prefixV "aus" (regV "kleiden"))  ;
  auskommentieren_V2 = dirV2 (prefixV "aus" (regV "kommentieren"))  ;
  auskristallisieren_V = prefixV "aus" (regV "kristallisieren") ;
  auslachen_V2 = dirV2 (prefixV "aus" (regV "lachen"))  ;
  ausladen_V2 = dirV2 (prefixV "aus" (irregV "laden" "lädt" "lud" "lüde" "geladen"))  ;
  auslassen_V2 = dirV2 (prefixV "aus" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  auslassen_VS = mkVS (prefixV "aus" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  auslatschen_V2 = dirV2 (prefixV "aus" (regV "latschen"))  ;
  auslaufen_V = prefixV "aus" (irregV "laufen" "lauft" "lief" "liefe" "gelaufen") ;
  auslaugen_aus_V3 = dirV3 (prefixV "aus" (regV "laugen")) aus_Prep ;
  auslaugen_V = prefixV "aus" (regV "laugen") ;
  auslegen_dat_V3 = accdatV3 (prefixV "aus" (regV "legen"))  ;
  auslegen_V2 = dirV2 (prefixV "aus" (regV "legen"))  ;
  ausliefern_dat_V3 = accdatV3 (prefixV "aus" (regV "liefern"))  ;
  ausliefern_V2 = dirV2 (prefixV "aus" (regV "liefern"))  ;
  auslitern_V2 = dirV2 (prefixV "aus" (irregV "litern" "litert" "literte" "literte" "gelitert"))  ;
  ausloben_V2 = dirV2 (prefixV "aus" (regV "loben"))  ;
  ausloeffeln_V2 = dirV2 (prefixV "aus" (regV "löffeln"))  ;
  ausloesen_V2 = dirV2 (prefixV "aus" (regV "lösen"))  ;
  auslosen_V2 = dirV2 (prefixV "aus" (regV "losen"))  ;
  ausmachen_mit_V2S = mkV2S (prefixV "aus" (regV "machen")) mit_Prep ;
  ausmachen_V2 = dirV2 (prefixV "aus" (regV "machen"))  ;
  ausmalen_rVS = reflVS (prefixV "aus" (regV "malen")) accusative ;
  ausmalen_V2 = dirV2 (prefixV "aus" (regV "malen"))  ;
  ausmerzen_V2 = dirV2 (prefixV "aus" (regV "merzen"))  ;
  ausmieten_V2 = dirV2 (prefixV "aus" (regV "mieten"))  ;
  ausmuellen_V2 = dirV2 (regV "ausmüllen")  ;
  ausmustern_V2 = dirV2 (prefixV "aus" (irregV "mustern" "mustert" "musterte" "musterte" "gemustert"))  ;
  ausnehmen_V2 = dirV2 (prefixV "aus" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  ausnehmen_VS = mkVS (prefixV "aus" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  ausnutzen_V2 = dirV2 (prefixV "aus" (regV "nutzen"))  ;
  ausnutzen_VS = mkVS (prefixV "aus" (regV "nutzen"))  ;
  auspacken_mit_V2 = prepV2 (prefixV "aus" (regV "packen")) mit_Prep ;
  auspacken_V = prefixV "aus" (regV "packen") ;
  auspowern_rV = reflV (prefixV "aus" (regV "powern")) accusative ;
  auspraegen_V2 = dirV2 (prefixV "aus" (irregV "prägen" "prägt" "prägte" "prägte" "geprägt"))  ;
  ausrasten_V = prefixV "aus" (regV "rasten") ;
  ausrechnen_V2 = dirV2 (prefixV "aus" (regV "rechnen"))  ;
  ausreden_V = prefixV "aus" (regV "reden") ;
  ausreichen_fuer_V2 = prepV2 (prefixV "aus" (regV "reichen")) (mkPrep "für" accusative) ;
  ausreichen_V = prefixV "aus" (regV "reichen") ;
  ausreichen_zu_V2 = prepV2 (prefixV "aus" (regV "reichen")) zu_Prep ;
  ausreissen_V = prefixV "aus" (irregV "reißen" "reißt" "riss" "riss" "gerissen") ;
  ausreizen_V2 = dirV2 (prefixV "aus" (regV "reizen"))  ;
  ausrichten_V2 = dirV2 (prefixV "aus" (regV "richten"))  ;
  ausrotten_V2 = dirV2 (prefixV "aus" (regV "rotten"))  ;
  ausruesten_V2 = dirV2 (prefixV "aus" (regV "rüsten"))  ;
  ausrutschen_auf_V2 = prepV2 (prefixV "aus" (regV "rutschen")) (mkPrep "auf" dative) ;
  ausrutschen_V = prefixV "aus" (regV "rutschen") ;
  aussagen_V2 = dirV2 (prefixV "aus" (regV "sagen"))  ;
  aussaugen_V2 = dirV2 (prefixV "aus" (regV "saugen"))  ;
  ausschaffen_V2 = dirV2 (prefixV "aus" (regV "schaffen"))  ;
  ausschalten_V2 = dirV2 (prefixV "aus" (regV "schalten"))  ;
  ausschauen_VA = mkVA (prefixV "aus" (regV "schauen"))  ;
  ausscheiden_V2 = dirV2 (prefixV "aus" (irregV "scheiden" "scheidet" "schied" "schiede" "geschieden"))  ;
  ausschlachten_V2 = dirV2 (prefixV "aus" (regV "schlachten"))  ;
  ausschlafen_V = prefixV "aus" (irregV "schlafen" "schlaft" "schlief" "schliefe" "geschlafen") ;
  ausschlagen_V2 = dirV2 (prefixV "aus" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen"))  ;
  ausschliessen_V2 = dirV2 (prefixV "aus" (irregV "schließen" "schließt" "schloss" "schlösse" "geschlossen"))  ;
  ausschmuecken_V2 = dirV2 (prefixV "aus" (regV "schmücken"))  ;
  ausschoten_V2 = dirV2 (regV "ausschoten")  ;
  ausschreiben_V2 = dirV2 (prefixV "aus" (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben"))  ;
  aussehen_VA = mkVA (prefixV "aus" (irregV "sehen" "seht" "sah" "sähe" "gesehen"))  ;
  aussetzen_dat_V3 = dirV3 (prefixV "aus" (regV "setzen")) datPrep ;
  aussetzen_V2 = dirV2 (prefixV "aus" (regV "setzen"))  ;
--  aussetzen_V = prefixV "aus" (irregV "setzen" "setzt" "setzte" "setzte" "gesetzt") ;
  aussetzen_V = prefixV "aus" (regV "setzen") ;
  aussitzen_V2 = dirV2 (prefixV "aus" (irregV "sitzen" "sitzt" "saß" "säße" "gesessen"))  ;
  aussoehnen_mit_rV2 = reflV2 (regV "aussöhnen") accusative mit_Prep ;
  aussoehnen_mit_V3 = dirV3 (regV "aussöhnen") mit_Prep ;
  aussoehnen_rV = reflV (regV "aussöhnen") accusative ;
  aussoehnen_V2 = dirV2 (regV "aussöhnen")  ;
  aussortieren_V2 = dirV2 (prefixV "aus" (regV "sortieren"))  ;
  ausspeichern_V2 = dirV2 (prefixV "aus" (regV "speichern"))  ;
  ausspionieren_V2 = dirV2 (prefixV "aus" (regV "spionieren"))  ;
  aussprechen_V2 = dirV2 (prefixV "aus" (irregV "sprechen" "sprecht" "sprach" "spräche" "gesprochen"))  ;
  aussprechen_VS = mkVS (prefixV "aus" (irregV "sprechen" "sprecht" "sprach" "spräche" "gesprochen"))  ;
  ausspucken_vor_V2 = prepV2 (prefixV "aus" (regV "spucken")) (mkPrep "vor" dative) ;
  ausspucken_V = prefixV "aus" (regV "spucken") ;
  ausstatten_mit_V3 = dirV3 (prefixV "aus" (regV "statten")) mit_Prep ;
  ausstatten_V2 = dirV2 (prefixV "aus" (regV "statten"))  ;
  aussteigen_aus_V2 = prepV2 (prefixV "aus" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen")) aus_Prep ;
  ausstellen_V2 = dirV2 (prefixV "aus" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt"))  ;
  aussterben_V = prefixV "aus" (irregV "sterben" "stirbt" "starb" "starb" "gestorben") ;
  ausstopfen_V2 = dirV2 (prefixV "aus" (regV "stopfen"))  ;
  ausstrahlen_V2 = dirV2 (prefixV "aus" (regV "strahlen"))  ;
  ausstrecken_rV = reflV (prefixV "aus" (regV "strecken")) accusative ;
  ausstrecken_V2 = dirV2 (prefixV "aus" (regV "strecken"))  ;
  austarieren_V2 = dirV2 (prefixV "aus" (regV "tarieren"))  ;
  austauschen_V2 = dirV2 (prefixV "aus" (regV "tauschen"))  ;
  austreten_aus_V2 = prepV2 (prefixV "aus" (irregV "treten" "tritt" "trat" "trat" "getreten")) aus_Prep ;
  austreten_V2 = dirV2 (prefixV "aus" (irregV "treten" "tritt" "trat" "trat" "getreten"))  ;
  austreten_V = prefixV "aus" (irregV "treten" "tritt" "trat" "trat" "getreten") ;
  austrinken_V2 = dirV2 (prefixV "aus" (irregV "trinken" "trinkt" "trank" "tränke" "getrunken"))  ;
  ausueben_V2 = dirV2 (prefixV "aus" (regV "üben"))  ;
  auswaehlen_V2 = dirV2 (prefixV "aus" (regV "wählen"))  ;
  auswandern_V = prefixV "aus" (regV "wandern") ;
  ausweichen_dat_V2 = mkV2 (prefixV "aus" (irregV "weichen" "weicht" "wich" "wiche" "gewichen")) datPrep ;
  ausweisen_rV = reflV (prefixV "aus" (irregV "weisen" "weist" "wies" "wiese" "gewiesen")) accusative ;
  ausweisen_V2 = dirV2 (prefixV "aus" (irregV "weisen" "weist" "wies" "wiese" "gewiesen"))  ;
  auswerten_V2 = dirV2 (prefixV "aus" (regV "werten"))  ;
  auszeichnen_V2 = dirV2 (prefixV "aus" (regV "zeichnen"))  ;
  ausziehen_V2 = dirV2 (prefixV "aus" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen"))  ;
  authentifizieren_V2 = dirV2 (regV "authentifizieren")  ;
  autorisieren_V2V = dirV2V (regV "autorisieren")  ;
  avancieren_zu_V2 = prepV2 (regV "avancieren") zu_Prep ;
  avisieren_V2 = dirV2 (regV "avisieren")  ;
  babbeln_V = regV "babbeln" ;
  backen_V2 = dirV2 (irregV "backen" "backt" "buk" "büke" "gebacken")  ;
--  backen_V = regV "backen" ;
  baden_V2 = dirV2 (regV "baden")  ;
  baehen_V2 = dirV2 (regV "bähen")  ;
  baendigen_V2 = dirV2 (regV "bändigen")  ;
  bagatellisieren_V2 = dirV2 (irregV "bagatellisieren" "bagatellisiert" "bagatellisierte" "bagatellisierte" "bagatellisiert")  ;
  baggern_V = regV "baggern" ;
  balancieren_auf_V2 = prepV2 (regV "balancieren") (mkPrep "auf" dative) ;
  balancieren_V = regV "balancieren" ;
  balgen_mit_rV2 = reflV2 (regV "balgen") accusative mit_Prep ;
  balgen_plV = plV (regV "balgen")  ;
  balkanisieren_V2 = dirV2 (regV "balkanisieren")  ;
  ballen_rV = reflV (regV "ballen") accusative ;
  ballern_V = regV "ballern" ;
  ballestern_V = irregV "ballestern" "ballestert" "(hab" "(hab" "ballestert" ;
  balsamieren_V2 = dirV2 (regV "balsamieren")  ;
  bandagieren_V2 = dirV2 (regV "bandagieren")  ;
  bannen_V2 = dirV2 (regV "bannen")  ;
  barabern_V = regV "barabern" ;
  barbieren_V2 = dirV2 (regV "barbieren")  ;
  bardieren_V2 = dirV2 (regV "bardieren")  ;
  barmen_rV = reflV (regV "barmen") accusative ;
  basieren_auf_V2 = prepV2 (regV "basieren") (mkPrep "auf" dative) ;
  bastardieren_V2 = dirV2 (regV "bastardieren")  ;
  basteln_V2 = dirV2 (irregV "basteln" "bastelt" "bastelte" "bastele" "gebastelt")  ;
  bauchpinseln_V2 = dirV2 (regV "bauchpinseln")  ;
  bauen_auf_V2 = prepV2 (regV "bauen") (mkPrep "auf" accusative) ;
  bauen_V2 = dirV2 (regV "bauen")  ;
  baumeln_von_V2 = prepV2 (regV "baumeln") von_Prep ;
  beabsichtigen_VV = mkVV (regV "beabsichtigen")  ;
  beachten_VS = mkVS (irregV "beachten" "beachtet" "beachtete" "beachte" "beachtet")  ;
  beackern_V2 = dirV2 (regV "beackern")  ;
  beaeugen_V2 = dirV2 (regV "beäugen")  ;
  beamen_an_V3 = dirV3 (regV "beamen") (mkPrep "an" accusative) ;
  beanspruchen_V2 = dirV2 (regV "beanspruchen")  ;
  beanstanden_V2 = dirV2 (regV "beanstanden")  ;
  beanstanden_VS = mkVS (regV "beanstanden")  ;
  beantragen_V2 = dirV2 (regV "beantragen")  ;
  beantragen_VS = mkVS (regV "beantragen")  ;
  beantragen_VV = mkVV (regV "beantragen")  ;
  beantworten_dat_V3 = accdatV3 (irregV "beantworten" "beantwortet" "beantwortete" "beantworte" "beantwortet")  ;
  beantworten_V2 = dirV2 (irregV "beantworten" "beantwortet" "beantwortete" "beantworte" "beantwortet")  ;
  bearbeiten_V2 = dirV2 (irregV "bearbeiten" "bearbeitet" "bearbeitete" "bearbeite" "bearbeitet")  ;
  beaten_V = irregV "beaten" "beatet" "beatete" "beate" "gebeatet" ;
  beauftragen_mit_V3 = dirV3 (regV "beauftragen") mit_Prep ;
  beauftragen_V2 = dirV2 (regV "beauftragen")  ;
  bebauen_V2 = dirV2 (regV "bebauen")  ;
  beben_V = regV "beben" ;
  bechern_V = regV "bechern" ;
  becircen_V2 = dirV2 (regV "becircen")  ;
  beckmessern_V = regV "beckmessern" ;
  bedachen_mit_V3 = dirV3 (regV "bedachen") mit_Prep ;
  bedauern_V2 = dirV2 (regV "bedauern")  ;
  bedauern_VS = mkVS (regV "bedauern")  ;
  bedauern_VV = mkVV (regV "bedauern")  ;
  bedecken_V2 = dirV2 (regV "bedecken")  ;
  bedenken_V2 = dirV2 (irregV "bedenken" "bedenkt" "bedachte" "bedächte" "bedacht")  ;
  bedenken_VS = mkVS (irregV "bedenken" "bedenkt" "bedachte" "bedächte" "bedacht")  ;
  bedeuten_dat_V3 = accdatV3 (irregV "bedeuten" "bedeutet" "bedeutete" "bedeutete" "bedeutet")  ;
  bedeuten_sVS = dassVS (irregV "bedeuten" "bedeutet" "bedeutete" "bedeutete" "bedeutet")  ;
  bedienen_gen_rV2 = reflV2 (regV "bedienen") accusative genPrep ;
  bedienen_V2 = dirV2 (regV "bedienen")  ;
  bedingen_V2 = dirV2 (regV "bedingen")  ;
  bedonnern_V2 = dirV2 (regV "bedonnern")  ;
  bedraengen_V2 = dirV2 (regV "bedrängen")  ;
  bedrohen_V2 = dirV2 (regV "bedrohen")  ;
  beduerfen_gen_V2 = mkV2 (irregV "bedürfen" "bedürft" "bedurfte" "bedürfte" "bedurft") genPrep ;
  beeindrucken_V2 = dirV2 (regV "beeindrucken")  ;
  beeinflussen_V2 = dirV2 (regV "beeinflussen")  ;
  beeintraechtigen_V2 = dirV2 (regV "beeinträchtigen")  ;
  beenden_V2 = dirV2 (regV "beenden")  ;
  beerdigen_V2 = dirV2 (regV "beerdigen")  ;
  befaehigen_V2V = dirV2V (regV "befähigen")  ;
  befehlen_dat_V2V = mkV2V (irregV "befehlen" "befehlt" "befahl" "befähle" "befohlen") datPrep ;
  befestigen_V2 = dirV2 (regV "befestigen")  ;
  befeuchten_V2 = dirV2 (regV "befeuchten")  ;
  befinden_loc_rV2 = reflV2 (irregV "befinden" "befindet" "befand" "befände" "befunden") accusative loc_Prep ;
  befleissen_gen_rV2 = reflV2 (irregV "befleißen" "befleißt" "befliss" "beflisse" "beflissen") accusative genPrep ;
  befleissigen_gen_rV2 = reflV2 (regV "befleißigen") accusative genPrep ;
  beflocken_mit_V3 = dirV3 (regV "beflocken") mit_Prep ;
  befluegeln_sV2 = dassV2 (regV "beflügeln") accPrep ;
  befluegeln_V2 = dirV2 (regV "beflügeln")  ;
  befoerdern_V2 = dirV2 (regV "befördern")  ;
  befolgen_V2 = dirV2 (regV "befolgen")  ;
  befragen_V2 = dirV2 (regV "befragen")  ;
  befreien_V2 = dirV2 (regV "befreien")  ;
  befremden_sV2 = dassV2 (regV "befremden") accPrep ;
  befriedigen_sV2 = dassV2 (regV "befriedigen") accPrep ;
  befriedigen_V2 = dirV2 (regV "befriedigen")  ;
  befristen_auf_V3 = dirV3 (irregV "befristen" "befristet" "befristete" "befristete" "befristet") (mkPrep "auf" accusative) ;
  befruchten_V2 = dirV2 (irregV "befruchten" "befruchtet" "befruchtete" "befruchte" "befruchtet")  ;
  befuehlen_V2 = dirV2 (regV "befühlen")  ;
  befuellen_V2 = dirV2 (regV "befüllen")  ;
  befuerchten_V2 = dirV2 (irregV "befürchten" "befürchtet" "befürchtete" "befürchtete" "befürchtet")  ;
  befuerchten_VS = mkVS (irregV "befürchten" "befürchtet" "befürchtete" "befürchtete" "befürchtet")  ;
  befuerchten_VV = mkVV (irregV "befürchten" "befürchtet" "befürchtete" "befürchtete" "befürchtet")  ;
  befuerworten_V2 = dirV2 (irregV "befürworten" "befürwortet" "befürwortete" "befürwortete" "befürwortet")  ;
  befuerworten_VS = mkVS (irregV "befürworten" "befürwortet" "befürwortete" "befürwortete" "befürwortet")  ;
  begatten_rcV = reciV (irregV "begatten" "begattet" "begattete" "begatte" "begattet") accusative ;
  begatten_V2 = dirV2 (irregV "begatten" "begattet" "begattete" "begatte" "begattet")  ;
  begeben_dir_rV2 = reflV2 (prefixV "begeb" (irregV "en" "begibt" "begab" "begab" "begeben")) accusative dir_Prep ;
  begeben_rV = reflV (prefixV "begeb" (irregV "en" "begibt" "begab" "begab" "begeben")) accusative ;
  begegnen_dat_V2 = mkV2 (regV "begegnen") datPrep ;
  begehen_V2 = dirV2 (irregV "begehen" "begeht" "beging" "beginge" "begangen")  ;
  begehren_V2 = dirV2 (regV "begehren")  ;
  begeistern_V2 = dirV2 (irregV "begeistern" "begeistert" "begeisterte" "begeisterte" "begeistert")  ;
  beginnen_mit_V2 = prepV2 (irregV "beginnen" "beginnt" "begann" "begänne" "begonnen") mit_Prep ;
  beginnen_mit_V3 = dirV3 (irregV "beginnen" "beginnt" "begann" "begänne" "begonnen") mit_Prep ;
  beginnen_VV = mkVV (irregV "beginnen" "beginnt" "begann" "begänne" "begonnen")  ;
  begleichen_mit_V3 = dirV3 (irregV "begleichen" "begleicht" "beglich" "beglich" "beglichen") mit_Prep ;
  begleichen_V2 = dirV2 (irregV "begleichen" "begleicht" "beglich" "beglich" "beglichen")  ;
  begleiten_V2 = dirV2 (irregV "begleiten" "begleitet" "begleitete" "begleite" "begleitet")  ;
  begnadigen_V2 = dirV2 (regV "begnadigen")  ;
  begoeschen_V2 = dirV2 (regV "begöschen")  ;
  begraben_V2 = dirV2 (irregV "begraben" "begrabt" "begrub" "begrübe" "begraben")  ;
  begreifen_V2 = dirV2 (irregV "begreifen" "begreift" "begriff" "begriffe" "begriffen")  ;
  begreifen_VS = mkVS (irregV "begreifen" "begreift" "begriff" "begriffe" "begriffen")  ;
  begrenzen_V2 = dirV2 (regV "begrenzen")  ;
  begruenden_V2 = dirV2 (regV "begründen")  ;
  begruenden_VS = mkVS (regV "begründen")  ;
  begruenen_V2 = dirV2 (regV "begrünen")  ;
  begruessen_V2 = dirV2 (regV "begrüßen")  ;
  beguenstigen_V2 = dirV2 (regV "begünstigen")  ;
  behaendigen_V = regV "behändigen" ;
  behagen_dat_sV2 = dassV2 (regV "behagen") datPrep ;
  behalten_V2 = dirV2 (irregV "behalten" "behält" "behielt" "behielte" "behalten")  ;
  behandeln_als_V3 = dirV3 (regV "behandeln") (mkPrep "als" accusative) ;
  behandeln_mit_V3 = dirV3 (regV "behandeln") mit_Prep ;
  behaupten_VS = mkVS (irregV "behaupten" "behauptet" "behauptete" "behaupte" "behauptet")  ;
  behelfen_mit_rV2 = reflV2 (irregV "behelfen" "behilft" "behalf" "behalf" "beholfen") accusative mit_Prep ;
  behelligen_mit_V3 = dirV3 (regV "behelligen") mit_Prep ;
  beherbergen_V2 = dirV2 (regV "beherbergen")  ;
  beherrschen_V2 = dirV2 (regV "beherrschen")  ;
  beherzigen_V2 = dirV2 (regV "beherzigen")  ;
  beherzigen_VS = mkVS (regV "beherzigen")  ;
  behindern_V2 = dirV2 (regV "behindern")  ;
  beibehalten_V2 = dirV2 (prefixV "bei" (irregV "behalten" "behält" "behielt" "behielte" "behalten"))  ;
  beibringen_dat_V2S = mkV2S (prefixV "bei" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht")) datPrep ;
  beibringen_dat_V2V = mkV2V (prefixV "bei" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht")) datPrep ;
  beibringen_dat_V3 = accdatV3 (prefixV "bei" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  beichten_V = irregV "beichten" "beichtet" "beichtete" "beichte" "gebeichtet" ;
  beifuegen_dat_V3 = accdatV3 (prefixV "bei" (regV "fügen"))  ;
  beifuegen_zu_V3 = dirV3 (prefixV "bei" (regV "fügen")) zu_Prep ;
  beigen_V2 = dirV2 (regV "beigen")  ;
  beilegen_dat_V3 = accdatV3 (prefixV "bei" (regV "legen"))  ;
  beilegen_V2 = dirV2 (prefixV "bei" (regV "legen"))  ;
  beinhalten_V2 = dirV2 (irregV "beinhalten" "beinhaltet" "beinhaltete" "beinhaltete" "beinhaltet")  ;
  beipflichten_dat_im_V3 = mkV3 (prefixV "bei" (regV "pflichten")) datPrep (mkPrep "in" dative) ;
  beipflichten_dat_V2 = mkV2 (prefixV "bei" (regV "pflichten")) datPrep ;
  beiseitelegen_V2 = dirV2 (prefixV "beiseite" (regV "legen"))  ;
  beisetzen_V2 = dirV2 (prefixV "bei" (regV "setzen"))  ;
  beispringen_dat_V2 = mkV2 (prefixV "bei" (irregV "springen" "springt" "sprang" "spränge" "gesprungen")) datPrep ;
  beissen_V2 = dirV2 (irregV "beißen" "beißt" "biss" "bisse" "gebissen")  ;
  beistehen_dat_V2 = mkV2 (prefixV "bei" (irregV "stehen" "steht" "stand" "stände" "gestanden")) datPrep ;
  beistellen_dat_V3 = accdatV3 (prefixV "bei" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt"))  ;
  beisteuern_zu_V3 = dirV3 (prefixV "bei" (regV "steuern")) zu_Prep ;
  beistimmen_dat_V2 = mkV2 (prefixV "bei" (regV "stimmen")) datPrep ;
  beiten_V = regV "beiten" ;
  beitragen_zu_V2 = prepV2 (prefixV "bei" (irregV "tragen" "tragt" "trug" "trüge" "getragen")) zu_Prep ;
  beitragen_zu_V3 = dirV3 (prefixV "bei" (irregV "tragen" "tragt" "trug" "trüge" "getragen")) zu_Prep ;
  beitreten_dat_V2 = mkV2 (prefixV "bei" (irregV "treten" "tritt" "trat" "träte" "getreten")) datPrep ;
  beiwohnen_dat_V2 = mkV2 (prefixV "bei" (regV "wohnen")) datPrep ;
  bejahen_V2 = dirV2 (regV "bejahen")  ;
  bejahen_VS = mkVS (regV "bejahen")  ;
  bekaempfen_V2 = dirV2 (regV "bekämpfen")  ;
  bekaempfen_VS = mkVS (regV "bekämpfen")  ;
  bekennen_zu_rV2 = reflV2 (irregV "bekennen" "bekennt" "bekannte" "bekannte" "bekannt") accusative zu_Prep ;
  beklagen_V2 = dirV2 (regV "beklagen")  ;
  beklagen_VS = mkVS (regV "beklagen")  ;
  beklatschen_V2 = dirV2 (regV "beklatschen")  ;
  beklemmen_sV2 = dassV2 (regV "beklemmen") accPrep ;
  bekochen_V2 = dirV2 (regV "bekochen")  ;
  bekommen_V2 = dirV2 (irregV "bekommen" "bekommt" "bekam" "bekäme" "bekommen")  ;
  bekraeftigen_V2 = dirV2 (regV "bekräftigen")  ;
  bekraeftigen_VS = mkVS (regV "bekräftigen")  ;
  bekriegen_V2 = dirV2 (regV "bekriegen")  ;
  belabern_V2 = dirV2 (regV "belabern")  ;
  belaestigen_mit_V3 = dirV3 (regV "belästigen") mit_Prep ;
  belaestigen_V2 = dirV2 (regV "belästigen")  ;
  belagern_V2 = dirV2 (regV "belagern")  ;
  belangen_V2 = dirV2 (regV "belangen")  ;
  belassen_auf_V3 = dirV3 (irregV "belassen" "belasst" "beließ" "beließe" "belassen") (mkPrep "auf" dative) ;
  belasten_mit_V3 = dirV3 (irregV "belasten" "belastet" "belastete" "belastete" "belastet") mit_Prep ;
  beleben_V2 = dirV2 (regV "beleben")  ;
  belegen_mit_V3 = dirV3 (regV "belegen") mit_Prep ;
  beleidigen_V2 = dirV2 (regV "beleidigen")  ;
  beleuchten_V2 = dirV2 (irregV "beleuchten" "beleuchtet" "beleuchtete" "beleuchtete" "beleuchtet")  ;
  belfern_V = regV "belfern" ;
  beliefern_mit_V3 = dirV3 (regV "beliefern") mit_Prep ;
  beliefern_V2 = dirV2 (regV "beliefern")  ;
  bellen_V = regV "bellen" ;
  belohnen_mit_V3 = dirV3 (regV "belohnen") mit_Prep ;
  belohnen_V2 = dirV2 (regV "belohnen")  ;
  beluegen_V2 = dirV2 (irregV "belügen" "belügt" "belog" "belöge" "belogen")  ;
  belustigen_rV = reflV (regV "belustigen") accusative ;
  bemaengeln_V2 = dirV2 (regV "bemängeln")  ;
  bemerken_V2 = dirV2 (regV "bemerken")  ;
  bemuessigen_gen_rV2 = reflV2 (regV "bemüßigen") accusative genPrep ;
  bemustern_V2 = dirV2 (irregV "bemustern" "bemustert" "bemusterte" "bemustere" "bemustert")  ;
  benachrichtigen_V2 = dirV2 (regV "benachrichtigen")  ;
  benachrichtigen_V2S = dirV2S (regV "benachrichtigen")  ;
  benedeien_V2 = dirV2 (regV "benedeien")  ;
  benehmen_rV = reflV (irregV "benehmen" "benimmt" "benahm" "benähme" "benommen") accusative ;
  beneiden_um_V3 = dirV3 (regV "beneiden") um_Prep ;
  beneiden_V2 = dirV2 (regV "beneiden")  ;
  benennen_V2 = dirV2 (irregV "benennen" "benennt" "benannte" "benannte" "benannt")  ;
  benoetigen_V2 = dirV2 (regV "benötigen")  ;
  benoetigen_V2V = dirV2V (regV "benötigen")  ;
  benuetzen_V2 = dirV2 (regV "benützen")  ;
  benuetzen_V2V = dirV2V (regV "benützen")  ;
  benutzen_V2 = dirV2 (regV "benutzen")  ;
  benutzen_V2V = dirV2V (regV "benutzen")  ;
  beobachten_mit_V3 = dirV3 (irregV "beobachten" "beobachtet" "beobachtete" "beobachte" "beobachtet") mit_Prep ;
  beobachten_V2 = dirV2 (irregV "beobachten" "beobachtet" "beobachtete" "beobachte" "beobachtet")  ;
  bepflanzen_mit_V3 = dirV3 (regV "bepflanzen") mit_Prep ;
  bepflanzen_V2 = dirV2 (regV "bepflanzen")  ;
  beraten_V2 = dirV2 (irregV "beraten" "berät" "beriet" "beriete" "beraten")  ;
  berechnen_V2 = dirV2 (regV "berechnen")  ;
  bereedern_V2 = dirV2 (regV "bereedern")  ;
  bereifen_V2 = dirV2 (regV "bereifen")  ;
  bereiten_dat_V3 = accdatV3 (irregV "bereiten" "bereitet" "bereitete" "bereite" "bereitet")  ;
  bereitstellen_dat_V3 = accdatV3 (prefixV "bereit" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt"))  ;
  bereitstellen_V2 = dirV2 (prefixV "bereit" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt"))  ;
  bereuen_V2 = dirV2 (regV "bereuen")  ;
  bergen_V2 = dirV2 (irregV "bergen" "bergt" "barg" "bärge" "geborgen")  ;
  bergsteigen_V = irregV "bergsteigen" "bergsteigt" "bergstieg" "bergstieg" "berggestiegen" ;
  berichten_dat_V2S = mkV2S (irregV "berichten" "berichtet" "berichtete" "berichtete" "berichtet") datPrep ;
  berichten_dat_V3 = accdatV3 (irregV "berichten" "berichtet" "berichtete" "berichtete" "berichtet")  ;
  berichten_V2 = dirV2 (irregV "berichten" "berichtet" "berichtete" "berichtete" "berichtet")  ;
  berichten_VS = mkVS (irregV "berichten" "berichtet" "berichtete" "berichtete" "berichtet")  ;
  berichtigen_V2 = dirV2 (regV "berichtigen")  ;
  beringen_V2 = dirV2 (regV "beringen")  ;
  berlinern_V = regV "berlinern" ;
  bersten_V = irregV "bersten" "birst" "barst" "bärste" "geborsten" ;
  beruecksichtigen_V2 = dirV2 (regV "berücksichtigen")  ;
  beruehren_V2 = dirV2 (regV "berühren")  ;
  beruhen_auf_V2 = prepV2 (regV "beruhen") (mkPrep "auf" dative) ;
  beruhigen_V2 = dirV2 (regV "beruhigen")  ;
  besaenftigen_V2 = dirV2 (regV "besänftigen")  ;
  besagen_sVS = dassVS (regV "besagen")  ;
  beschaedigen_V2 = dirV2 (regV "beschädigen")  ;
  beschaeftigen_mit_rV2 = reflV2 (regV "beschäftigen") accusative mit_Prep ;
  beschaeftigen_V2 = dirV2 (regV "beschäftigen")  ;
  beschaelen_V2 = dirV2 (regV "beschälen")  ;
  beschaemen_V2 = dirV2 (regV "beschämen")  ;
  beschaffen_V2 = dirV2 (regV "beschaffen")  ;
  beschatten_V2 = dirV2 (irregV "beschatten" "beschattet" "beschattete" "beschattete" "beschattet")  ;
  bescheinigen_dat_V2S = mkV2S (regV "bescheinigen") datPrep ;
  bescheissen_um_V3 = dirV3 (irregV "bescheißen" "bescheißt" "beschiss" "beschiss" "beschissen") um_Prep ;
  bescheissen_V2 = dirV2 (irregV "bescheißen" "bescheißt" "beschiss" "beschiss" "beschissen")  ;
  bescheren_dat_V3 = accdatV3 (regV "bescheren")  ;
  beschichten_V2 = dirV2 (regV "beschichten")  ;
  beschicken_V2 = dirV2 (regV "beschicken")  ;
  beschimpfen_V2 = dirV2 (regV "beschimpfen")  ;
  beschlafen_V2 = dirV2 (irregV "beschlafen" "beschläft" "beschlief" "beschlief" "beschlafen")  ;
  beschleichen_V2 = dirV2 (irregV "beschleichen" "beschleicht" "beschlich" "beschliche" "beschlichen")  ;
  beschleunigen_V2 = dirV2 (regV "beschleunigen")  ;
  beschleunigen_V = regV "beschleunigen" ;
  beschliessen_V2 = dirV2 (irregV "beschließen" "beschließt" "beschloss" "beschlösse" "beschlossen")  ;
  beschmieren_mit_V3 = dirV3 (regV "beschmieren") mit_Prep ;
  beschmieren_V2 = dirV2 (regV "beschmieren")  ;
  beschmutzen_durch_V3 = dirV3 (regV "beschmutzen") durch_Prep ;
  beschmutzen_mit_V3 = dirV3 (regV "beschmutzen") mit_Prep ;
  beschmutzen_V2 = dirV2 (regV "beschmutzen")  ;
  beschneiden_V2 = dirV2 (irregV "beschneiden" "beschneidet" "beschnitt" "beschnitte" "beschnitten")  ;
  beschoenigen_V2 = dirV2 (regV "beschönigen")  ;
  beschoenigen_VS = mkVS (regV "beschönigen")  ;
  beschraenken_auf_V3 = dirV3 (regV "beschränken") (mkPrep "auf" accusative) ;
  beschreiben_V2 = dirV2 (irregV "beschreiben" "beschreibt" "beschrieb" "beschriebe" "beschrieben")  ;
  beschuetzen_durch_V3 = dirV3 (regV "beschützen") durch_Prep ;
  beschuetzen_mit_V3 = dirV3 (regV "beschützen") mit_Prep ;
  beschuetzen_V2 = dirV2 (regV "beschützen")  ;
  beschulen_V2 = dirV2 (regV "beschulen")  ;
  beschweigen_V2 = dirV2 (irregV "beschweigen" "beschweigt" "beschwieg" "beschwieg" "beschwiegen")  ;
  beschweren_mit_V3 = dirV3 (regV "beschweren") mit_Prep ;
  beschweren_ueber_rV2 = reflV2 (regV "beschweren") accusative (mkPrep "über" accusative) ;
  beschweren_V2 = dirV2 (regV "beschweren")  ;
  beschwindeln_V2 = dirV2 (regV "beschwindeln")  ;
  beschwoeren_V2 = dirV2 (irregV "beschwören" "beschwört" "beschwor/beschwur" "beschwor/beschwur" "beschworen")  ;
  beschwoeren_VS = mkVS (irregV "beschwören" "beschwört" "beschwor/beschwur" "beschwor/beschwur" "beschworen")  ;
  besebeln_V2 = dirV2 (regV "besebeln")  ;
  beseitigen_V2 = dirV2 (regV "beseitigen")  ;
  besetzen_mit_V3 = dirV3 (regV "besetzen") mit_Prep ;
  besetzen_V2 = dirV2 (regV "besetzen")  ;
  besichtigen_V2 = dirV2 (regV "besichtigen")  ;
  besiegeln_V2 = dirV2 (regV "besiegeln")  ;
  besiegen_V2 = dirV2 (regV "besiegen")  ;
  besingen_V2 = dirV2 (irregV "besingen" "besingt" "besang" "besänge" "besungen")  ;
  besinnen_auf_rV2 = reflV2 (irregV "besinnen" "besinnt" "besann" "besänne" "besonnen") accusative (mkPrep "auf" accusative) ;
  besitzen_V2 = dirV2 (irregV "besitzen" "besitzt" "besaß" "besäße" "besessen")  ;
  besorgen_dat_V3 = accdatV3 (regV "besorgen")  ;
  besorgen_V2 = dirV2 (regV "besorgen")  ;
  bespassen_V2 = dirV2 (regV "bespaßen")  ;
  besprechen_mit_V3 = dirV3 (irregV "besprechen" "besprecht" "besprach" "bespräche" "besprochen") mit_Prep ;
  besprechen_plV2 = pldirV2 (irregV "besprechen" "besprecht" "besprach" "bespräche" "besprochen")  ;
  bespruehen_mit_V3 = dirV3 (regV "besprühen") mit_Prep ;
  bespruehen_V2 = dirV2 (regV "besprühen")  ;
  besseren_rV = reflV (regV "besseren") accusative ;
  bessern_rV = reflV (regV "bessern") accusative ;
  bestaerken_im_V3 = dirV3 (regV "bestärken") (mkPrep "in" dative) ;
  bestaetigen_dat_V2S = mkV2S (regV "bestätigen") datPrep ;
  bestaetigen_VS = mkVS (regV "bestätigen")  ;
  bestatten_V2 = dirV2 (irregV "bestatten" "bestattet" "bestattete" "bestattete" "bestattet")  ;
  bestechen_V2 = dirV2 (irregV "bestechen" "bestecht" "bestach" "bestäche" "bestochen")  ;
  bestehen_V2 = dirV2 (irregV "bestehen" "besteht" "bestand" "bestände" "bestanden")  ;
  besteigen_V2 = dirV2 (irregV "besteigen" "besteigt" "bestieg" "bestiege" "bestiegen")  ;
  bestellen_bei_V3 = dirV3 (irregV "bestellen" "bestellt" "bestellte" "bestelle" "bestellt") (mkPrep "bei" dative) ;
  bestellen_V2 = dirV2 (irregV "bestellen" "bestellt" "bestellte" "bestelle" "bestellt")  ;
  bestimmen_V2 = dirV2 (regV "bestimmen")  ;
  bestrafen_V2 = dirV2 (regV "bestrafen")  ;
  bestuhlen_V2 = dirV2 (regV "bestuhlen")  ;
  besuchen_V2 = dirV2 (regV "besuchen")  ;
  besudeln_V2 = dirV2 (regV "besudeln")  ;
  betaetigen_V2 = dirV2 (regV "betätigen")  ;
  beteiligen_am_rV2 = reflV2 (irregV "beteiligen" "beteiligt" "beteiligte" "beteiligte" "beteiligt") accusative (mkPrep "an" dative) ;
  beten_V = irregV "beten" "betet" "betete" "bete" "gebetet" ;
  beteuern_VS = mkVS (irregV "beteuern" "beteuert" "beteuerte" "beteuerte" "beteuert")  ;
  betiteln_als_V2 = prepV2 (irregV "betiteln" "betitelt" "betitelte" "betitelte" "betitelt") (mkPrep "als" accusative) ;
  betoeren_V2 = dirV2 (regV "betören")  ;
  betonen_V2 = dirV2 (regV "betonen")  ;
  betrachten_V2 = dirV2 (irregV "betrachten" "betrachtet" "betrachtete" "betrachtete" "betrachtet")  ;
  betragen_rV = reflV (irregV "betragen" "betragt" "betrug" "betrüge" "betragen") accusative ;
  betreffen_V2 = dirV2 (irregV "betreffen" "betrefft" "betraf" "beträfe" "betroffen")  ;
  betreiben_V2 = dirV2 (irregV "betreiben" "betreibt" "betrieb" "betriebe" "betrieben")  ;
  betreten_V2 = dirV2 (irregV "betreten" "betritt" "betrat" "beträte" "betreten")  ;
  betreuen_V2 = dirV2 (regV "betreuen")  ;
  betrueben_V2 = dirV2 (regV "betrüben")  ;
  betruegen_V2 = dirV2 (irregV "betrügen" "betrügt" "betrog" "betröge" "betrogen")  ;
  betten_V2 = dirV2 (regV "betten")  ;
  betuetern_V2 = dirV2 (irregV "betütern" "betütert" "betüterte" "betütere" "betütert")  ;
  betuppen_V2 = dirV2 (regV "betuppen")  ;
  beugen_V2 = dirV2 (regV "beugen")  ;
  beulen_rV = reflV (regV "beulen") accusative ;
  beunruhigen_sV2 = dassV2 (regV "beunruhigen") accPrep ;
  beunruhigen_V2 = dirV2 (regV "beunruhigen")  ;
  beurteilen_V2 = dirV2 (irregV "beurteilen" "beurteilt" "beurteilte" "beurteilte" "beurteilt")  ;
  bevormunden_V2 = dirV2 (regV "bevormunden")  ;
  bevorzugen_V2 = dirV2 (regV "bevorzugen")  ;
  bevorzugen_vor_V3 = dirV3 (regV "bevorzugen") (mkPrep "vor" dative) ;
  bewachen_V2 = dirV2 (regV "bewachen")  ;
  bewaeltigen_V2 = dirV2 (regV "bewältigen")  ;
  bewaessern_V2 = dirV2 (regV "bewässern")  ;
  bewaffnen_V2 = dirV2 (irregV "bewaffnen" "bewaffnet" "bewaffnete" "bewaffnete" "bewaffnet")  ;
  bewahren_V2 = dirV2 (regV "bewahren")  ;
  bewegen_rV = reflV (regV "bewegen") accusative ;
  bewegen_V2 = dirV2 (regV "bewegen")  ;
  bewehren_mit_V3 = dirV3 (regV "bewehren") mit_Prep ;
  beweihraeuchern_V2 = dirV2 (regV "beweihräuchern")  ;
  beweinen_V2 = dirV2 (regV "beweinen")  ;
  beweisen_V2 = dirV2 (irregV "beweisen" "beweist" "bewies" "bewiese" "bewiesen")  ;
  bewenden_bei_V3 = dirV3 (regV "bewenden") (mkPrep "bei" dative) ;
  bewerben_um_rV2 = reflV2 (irregV "bewerben" "bewerbt" "bewarb" "bewürbe" "beworben") accusative um_Prep ;
  bewerkstelligen_V2 = dirV2 (irregV "bewerkstelligen" "bewerkstelligt" "bewerkstelligte" "bewerkstelligte" "bewerkstelligt")  ;
  bewerkstelligen_VS = mkVS (irregV "bewerkstelligen" "bewerkstelligt" "bewerkstelligte" "bewerkstelligte" "bewerkstelligt")  ;
  bewirken_V2 = dirV2 (regV "bewirken")  ;
  bewirken_VS = mkVS (regV "bewirken")  ;
  bewirten_V2 = dirV2 (irregV "bewirten" "bewirtet" "bewirtete" "bewirtete" "bewirtet")  ;
  bewohnen_V2 = dirV2 (regV "bewohnen")  ;
  bewundern_V2 = dirV2 (regV "bewundern")  ;
  bezahlen_V2 = dirV2 (regV "bezahlen")  ;
  bezeichnen_als_V3 = dirV3 (regV "bezeichnen") (mkPrep "als" accusative) ;
  bezichtigen_gen_V3 = dirV3 (regV "bezichtigen") genPrep ;
  beziehen_V2 = dirV2 (irregV "beziehen" "bezieht" "bezog" "bezöge" "bezogen")  ;
  beziffern_auf_V3 = dirV3 (regV "beziffern") (mkPrep "auf" accusative) ;
  bezirzen_V2 = dirV2 (regV "bezirzen")  ;
  bezwingen_V2 = dirV2 (irregV "bezwingen" "bezwingt" "bezwang" "bezwänge" "bezwungen")  ;
  bibbern_V = regV "bibbern" ;
  bibliografieren_V = regV "bibliografieren" ;
  biegen_V2 = dirV2 (irregV "biegen" "biegt" "bog" "böge" "gebogen")  ;
  bieten_dat_V3 = accdatV3 (irregV "bieten" "bietet" "bot" "böte" "geboten")  ;
  bilden_rV = reflV (regV "bilden") accusative ;
  billigen_V2 = dirV2 (regV "billigen")  ;
  billigen_VS = mkVS (regV "billigen")  ;
  bimmeln_V = regV "bimmeln" ;
  binden_V2 = dirV2 (irregV "binden" "bindet" "band" "bände" "gebunden")  ;
  bitten_um_V3 = dirV3 (irregV "bitten" "bittet" "bat" "bäte" "gebeten") um_Prep ;
  biwakieren_loc_V2 = prepV2 (regV "biwakieren") loc_Prep ;
  blaettern_im_V2 = prepV2 (irregV "blättern" "blättert" "blätterte" "blätterte" "geblättert") (mkPrep "in" dative) ;
  blaffen_V = regV "blaffen" ;
  blaken_V = regV "blaken" ;
  blamieren_V2 = dirV2 (regV "blamieren")  ;
  blanchieren_V2 = dirV2 (regV "blanchieren")  ;
  blankziehen_V = prefixV "blank" (irregV "ziehen" "zieht" "zog" "zog" "gezogen") ;
  blasen_dat_V3 = accdatV3 (irregV "blasen" "blast" "blies" "bliese" "geblasen")  ;
  blasen_V2 = dirV2 (irregV "blasen" "blast" "blies" "bliese" "geblasen")  ;
  blasen_V = irregV "blasen" "blast" "blies" "bliese" "geblasen" ;
  blauen_V = regV "blauen" ;
  blechen_V2 = dirV2 (regV "blechen")  ;
  blecken_V2 = dirV2 (regV "blecken")  ;
  bleiben_loc_V2 = prepV2 (irregV "bleiben" "bleibt" "blieb" "blieb" "geblieben") loc_Prep ;
  blicken_dir_V2 = prepV2 (regV "blicken") dir_Prep ;
  blicken_VA = mkVA (regV "blicken")  ;
  blinken_V = regV "blinken" ;
  blinzeln_V = regV "blinzeln" ;
  blitzen_es_esV = esV (regV "blitzen")  ;
  blitzen_V2 = dirV2 (regV "blitzen")  ;
  blockieren_V2 = dirV2 (irregV "blockieren" "blockiert" "blockierte" "blockierte" "blockiert")  ;
  bloedeln_V = regV "blödeln" ;
  bloeken_V = regV "blöken" ;
  blubbern_V = regV "blubbern" ;
  bluehen_dat_sV2 = dassV2 (regV "blühen") datPrep ;
  bluehen_dat_V2 = mkV2 (regV "blühen") datPrep ;
  bluehen_V = regV "blühen" ;
  bluten_V = irregV "bluten" "blutet" "blutete" "blute" "geblutet" ;
  bodigen_V2 = dirV2 (regV "bodigen")  ;
  boellern_V = regV "böllern" ;
  bohren_V2 = dirV2 (regV "bohren")  ;
  bohren_V = regV "bohren" ;
  bolzen_V = regV "bolzen" ;
  bonitieren_V2 = dirV2 (regV "bonitieren")  ;
  booten_dir_V3 = dirV3 (regV "booten") dir_Prep ;
  borgen_dat_V3 = accdatV3 (regV "borgen")  ;
  bosseln_am_V2 = prepV2 (regV "bosseln") (mkPrep "an" dative) ;
  botanisieren_V = regV "botanisieren" ;
  bowlen_V = regV "bowlen" ;
  boxen_V = regV "boxen" ;
  boykottieren_V2 = dirV2 (regV "boykottieren")  ;
  brabbeln_V2 = dirV2 (regV "brabbeln")  ;
  braeteln_V2 = dirV2 (regV "bräteln")  ;
  braeteln_V = regV "bräteln" ;
  braeunen_V2 = dirV2 (regV "bräunen")  ;
  bramarbasieren_V = regV "bramarbasieren" ;
  branden_an_V2 = prepV2 (regV "branden") (mkPrep "an" accusative) ;
  brandmarken_V2 = dirV2 (regV "brandmarken")  ;
  brandmarken_VS = mkVS (regV "brandmarken")  ;
  brandschatzen_V2 = dirV2 (regV "brandschatzen")  ;
  braten_V2 = dirV2 (irregV "braten" "brät" "briet" "briete" "gebraten")  ;
  brauchen_V2 = dirV2 (regV "brauchen")  ;
  brauen_V2 = dirV2 (regV "brauen")  ;
  brausen_dir_V2 = prepV2 (regV "brausen") dir_Prep ;
  brechen_V2 = dirV2 (irregV "brechen" "brecht" "brach" "bräche" "gebrochen")  ;
  brechen_V = irregV "brechen" "brecht" "brach" "bräche" "gebrochen" ;
  bremsen_V2 = dirV2 (regV "bremsen")  ;
  bremsen_V = regV "bremsen" ;
  brennen_V = irregV "brennen" "brennt" "brannte" "brennte" "gebrannt" ;
  bringen_dat_V3 = accdatV3 (irregV "bringen" "bringt" "brachte" "brächte" "gebracht")  ;
  brocken_V2 = dirV2 (regV "brocken")  ;
  broeckeln_V = regV "bröckeln" ;
  broeseln_V2 = dirV2 (regV "bröseln")  ;
  broeseln_V = regV "bröseln" ;
  bruellen_V = regV "brüllen" ;
  brueskieren_V2 = dirV2 (regV "brüskieren")  ;
  bruesten_mit_rV2 = reflV2 (regV "brüsten") accusative mit_Prep ;
  brueten_ueber_V2 = prepV2 (regV "brüten") (mkPrep "über" dative) ;
  brueten_V = regV "brüten" ;
  brummen_V2 = dirV2 (regV "brummen")  ;
  brummen_V = regV "brummen" ;
  brummen_VS = mkVS (regV "brummen")  ;
  brunchen_V = regV "brunchen" ;
  brunzen_V = regV "brunzen" ;
  brutzeln_dat_V3 = accdatV3 (regV "brutzeln")  ;
  brutzeln_V = regV "brutzeln" ;
  buchen_V2 = dirV2 (regV "buchen")  ;
  buchstabieren_V2 = dirV2 (regV "buchstabieren")  ;
  buddeln_loc_V2 = prepV2 (regV "buddeln") loc_Prep ;
  budgetieren_fuer_V3 = dirV3 (regV "budgetieren") fuer_Prep ;
  bueffeln_V = regV "büffeln" ;
  buegeln_V2 = dirV2 (regV "bügeln")  ;
  buegeln_V = regV "bügeln" ;
  buendeln_V2 = dirV2 (regV "bündeln")  ;
  buergen_fuer_V2 = prepV2 (regV "bürgen") fuer_Prep ;
  buersten_V2 = dirV2 (regV "bürsten")  ;
  buessen_fuer_V2 = prepV2 (regV "büßen") fuer_Prep ;
  buffieren_V2 = dirV2 (regV "buffieren")  ;
  bugsieren_dir_V3 = dirV3 (regV "bugsieren") dir_Prep ;
  buhlen_um_V2 = prepV2 (regV "buhlen") um_Prep ;
  bummeln_dir_V2 = prepV2 (regV "bummeln") dir_Prep ;
  bumsen_V2 = dirV2 (regV "bumsen")  ;
  bunkern_V2 = dirV2 (regV "bunkern")  ;
  busseln_V2 = dirV2 (regV "busseln")  ;
  buttern_V2 = dirV2 (regV "buttern")  ;
  camouflieren_V2 = dirV2 (regV "camouflieren")  ;
  campen_loc_V2 = prepV2 (regV "campen") loc_Prep ;
  campieren_loc_V2 = prepV2 (regV "campieren") loc_Prep ;
  canceln_V2 = dirV2 (regV "canceln")  ;
  casten_V2 = dirV2 (regV "casten")  ;
  changieren_zwischen_V2 = prepV2 (regV "changieren") (mkPrep "zwischen" accusative) ;
  charakterisieren_V2 = dirV2 (regV "charakterisieren")  ;
  chargieren_mit_V3 = dirV3 (regV "chargieren") mit_Prep ;
  chargieren_V = regV "chargieren" ;
  chartern_V2 = dirV2 (regV "chartern")  ;
  chatten_mit_V2 = prepV2 (irregV "chatten" "chattet" "chattete" "chatte" "gechattet") mit_Prep ;
  chauffieren_dir_V3 = dirV3 (regV "chauffieren") dir_Prep ;
  checken_V2 = dirV2 (regV "checken")  ;
  checken_VS = mkVS (regV "checken")  ;
  chelatisieren_V = regV "chelatisieren" ;
  chemisieren_V2 = dirV2 (regV "chemisieren")  ;
  chiffrieren_V2 = dirV2 (regV "chiffrieren")  ;
  chillen_V = regV "chillen" ;
  chippen_V2 = dirV2 (regV "chippen")  ;
  chippen_V = regV "chippen" ;
  choreographieren_V2 = dirV2 (regV "choreographieren")  ;
  christeln_V = regV "christeln" ;
  christianisieren_V2 = dirV2 (regV "christianisieren")  ;
  clonen_V2 = dirV2 (regV "clonen")  ;
  coachen_V2 = dirV2 (regV "coachen")  ;
  codieren_V2 = dirV2 (regV "codieren")  ;
  colorieren_V2 = dirV2 (regV "colorieren")  ;
  computerisieren_V2 = dirV2 (regV "computerisieren")  ;
  conchieren_V2 = dirV2 (regV "conchieren")  ;
  containerisieren_V2 = dirV2 (regV "containerisieren")  ;
  copolymerisieren_plV = plV (regV "copolymerisieren")  ;
  crawlen_dir_V2 = prepV2 (regV "crawlen") dir_Prep ;
  cremen_V2 = dirV2 (regV "cremen")  ;
  dachen_V2 = dirV2 (regV "dachen")  ;
  daddeln_V = regV "daddeln" ;
  daemmen_V2 = dirV2 (regV "dämmen")  ;
  daemmern_dat_sV2 = dassV2 (regV "dämmern") datPrep ;
  daemmern_es_esV = esV (regV "dämmern")  ;
  daemonisieren_V2 = dirV2 (regV "dämonisieren")  ;
  daemonisieren_VS = mkVS (regV "dämonisieren")  ;
  daempfen_V2 = dirV2 (regV "dämpfen")  ;
  daenisieren_V2 = dirV2 (regV "dänisieren")  ;
  dahaben_V2 = dirV2 (prefixV "da" (irregV "haben" "hat" "hatte" "hatte" "gehabt"))  ;
  daheimbleiben_V = prefixV "daheim" (irregV "bleiben" "bleibt" "blieb" "blieb" "geblieben") ;
  damnififizieren_V2 = dirV2 (regV "damnififizieren")  ;
  damnififizieren_VS = mkVS (regV "damnififizieren")  ;
  dampfen_V = regV "dampfen" ;
  daniederliegen_V = prefixV "danieder" (irregV "liegen" "liegt" "lag" "lag" "gelegen") ;
  danisieren_V2 = dirV2 (regV "danisieren")  ;
  danken_dat_fuer_V3 = mkV3 (regV "danken") datPrep fuer_Prep ;
  darben_V = regV "darben" ;
  darlegen_dat_V2S = mkV2S (prefixV "dar" (regV "legen")) datPrep ;
  darlegen_dat_V3 = accdatV3 (prefixV "dar" (regV "legen"))  ;
  darniederliegen_V = prefixV "darnieder" (irregV "liegen" "liegt" "lag" "lag" "gelegen") ;
  darstellen_als_rV2 = reflV2 (prefixV "dar" (regV "stellen")) accusative (mkPrep "als" nominative) ;
  darstellen_V2 = dirV2 (prefixV "dar" (regV "stellen"))  ;
--  darstellen_V = prefixV "dar" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt") ;
  dartun_dat_V2S = mkV2S (prefixV "dar" (irregV "tun" "tut" "tat" "täte" "getan")) datPrep ;
  dartun_dat_V3 = accdatV3 (prefixV "dar" (irregV "tun" "tut" "tat" "täte" "getan"))  ;
  dastehen_V = prefixV "da" (irregV "stehen" "steht" "stand" "stand" "gestanden") ;
  dauern_sV2 = dassV2 (regV "dauern") accPrep ;
  dauern_V2 = dirV2 (regV "dauern")  ;
  dazustellen_V = prefixV "dazu" (regV "stellen") ;
  deaktivieren_V2 = dirV2 (irregV "deaktivieren" "deaktiviert" "deaktivierte" "deaktivierte" "deaktiviert")  ;
  dealen_mit_V2 = prepV2 (regV "dealen") mit_Prep ;
  debattieren_mit_ueber_V3 = mkV3 (irregV "debattieren" "debattiert" "debattierte" "debattierte" "debattiert") mit_Prep (mkPrep "über" accusative) ;
  debattieren_mit_V2 = prepV2 (irregV "debattieren" "debattiert" "debattierte" "debattierte" "debattiert") mit_Prep ;
  debattieren_plV = plV (irregV "debattieren" "debattiert" "debattierte" "debattierte" "debattiert")  ;
  debattieren_ueber_V2 = prepV2 (irregV "debattieren" "debattiert" "debattierte" "debattierte" "debattiert") (mkPrep "über" accusative) ;
  debridieren_V2 = dirV2 (irregV "debridieren" "debridiert" "debridierte" "debridierte" "debridiert")  ;
  debuetieren_im_V2 = prepV2 (regV "debütieren") (mkPrep "in" dative) ;
  debuetieren_V = regV "debütieren" ;
  dechiffrieren_V2 = dirV2 (irregV "dechiffrieren" "dechiffriert" "dechiffrierte" "dechiffrierte" "dechiffriert")  ;
  deckeln_V2 = dirV2 (regV "deckeln")  ;
  decken_V2 = dirV2 (regV "decken")  ;
  decken_VS = mkVS (regV "decken")  ;
  dedizieren_dat_V3 = accdatV3 (irregV "dedizieren" "dediziert" "dedizierte" "dedizierte" "dediziert")  ;
  deduzieren_V2 = dirV2 (irregV "deduzieren" "deduziert" "deduzierte" "deduzierte" "deduziert")  ;
  deeskalieren_V2 = dirV2 (irregV "deeskalieren" "deeskaliert" "deeskalierte" "deeskalierte" "deeskaliert")  ;
  defilieren_V = irregV "defilieren" "defiliert" "defilierte" "defilierte" "defiliert" ;
  definieren_durch_rV2 = reflV2 (regV "definieren") accusative durch_Prep ;
  definieren_ueber_rV2 = reflV2 (regV "definieren") accusative (mkPrep "über" accusative) ;
  deflorieren_V2 = dirV2 (irregV "deflorieren" "defloriert" "deflorierte" "deflorierte" "defloriert")  ;
  deformieren_V2 = dirV2 (irregV "deformieren" "deformiert" "deformierte" "deformierte" "deformiert")  ;
  degagieren_V2 = dirV2 (regV "degagieren")  ;
  degenerieren_V = irregV "degenerieren" "degeneriert" "degenerierte" "degenerierte" "degeneriert" ;
  degoutieren_V2 = dirV2 (irregV "degoutieren" "degoutiert" "degoutierte" "degoutierte" "degoutiert")  ;
  degoutieren_VS = mkVS (irregV "degoutieren" "degoutiert" "degoutierte" "degoutierte" "degoutiert")  ;
  degradieren_V2 = dirV2 (irregV "degradieren" "degradiert" "degradierte" "degradierte" "degradiert")  ;
  degraissieren_V2 = dirV2 (irregV "degraissieren" "degraissiert" "degraissierte" "degraissierte" "degraissiert")  ;
  degustieren_V2 = dirV2 (irregV "degustieren" "degustiert" "degustierte" "degustierte" "degustiert")  ;
  dehnen_V2 = dirV2 (regV "dehnen")  ;
  dehydratisieren_V2 = dirV2 (irregV "dehydratisieren" "dehydratisiert" "dehydratisierte" "dehydratisierte" "dehydratisiert")  ;
  dehydrieren_V = irregV "dehydrieren" "dehydriert" "dehydrierte" "dehydrierte" "dehydriert" ;
  deichseln_V2 = dirV2 (regV "deichseln")  ;
  deichseln_VS = mkVS (regV "deichseln")  ;
  deinstallieren_V2 = dirV2 (irregV "deinstallieren" "deinstalliert" "deinstallierte" "deinstallierte" "deinstalliert")  ;
  dekantieren_V2 = dirV2 (irregV "dekantieren" "dekantiert" "dekantierte" "dekantierte" "dekantiert")  ;
  deklamieren_V2 = dirV2 (regV "deklamieren")  ;
  deklamieren_VS = mkVS (regV "deklamieren")  ;
  deklarieren_als_V3 = dirV3 (irregV "deklarieren" "deklariert" "deklarierte" "deklarierte" "deklariert") (mkPrep "als" accusative) ;
  deklassieren_V2 = dirV2 (irregV "deklassieren" "deklassiert" "deklassierte" "deklassierte" "deklassiert")  ;
  deklinieren_V2 = dirV2 (regV "deklinieren")  ;
  dekompilieren_V2 = dirV2 (irregV "dekompilieren" "dekompiliert" "dekompilierte" "dekompilierte" "dekompiliert")  ;
  dekorieren_mit_V3 = dirV3 (regV "dekorieren") mit_Prep ;
  dekretieren_V2 = dirV2 (regV "dekretieren")  ;
  dekretieren_VS = mkVS (regV "dekretieren")  ;
  dekuvrieren_V2 = dirV2 (irregV "dekuvrieren" "dekuvriert" "dekuvrierte" "dekuvrierte" "dekuvriert")  ;
  delegieren_an_V3 = dirV3 (irregV "delegieren" "delegiert" "delegierte" "delegierte" "delegiert") (mkPrep "an" accusative) ;
  delirieren_V = regV "delirieren" ;
  delogarithmieren_V2 = dirV2 (irregV "delogarithmieren" "delogarithmiert" "delogarithmierte" "delogarithmierte" "delogarithmiert")  ;
  dementieren_V2 = dirV2 (regV "dementieren")  ;
  dementieren_VS = mkVS (regV "dementieren")  ;
  demokratisieren_V2 = dirV2 (regV "demokratisieren")  ;
  demolieren_V2 = dirV2 (irregV "demolieren" "demoliert" "demolierte" "demolierte" "demoliert")  ;
  demonstrieren_fuer_V2 = prepV2 (regV "demonstrieren") fuer_Prep ;
  demonstrieren_gegen_V2 = prepV2 (regV "demonstrieren") gegen_Prep ;
  demonstrieren_istr_V3 = dirV3 (regV "demonstrieren") istr_Prep ;
  demonstrieren_istr_VS2 = mkVS2 (regV "demonstrieren") istr_Prep ;
  demontieren_V2 = dirV2 (irregV "demontieren" "demontiert" "demontierte" "demontierte" "demontiert")  ;
  demoralisieren_sV2 = dassV2 (irregV "demoralisieren" "demoralisiert" "demoralisierte" "demoralisierte" "demoralisiert") accPrep ;
  demoralisieren_V2 = dirV2 (irregV "demoralisieren" "demoralisiert" "demoralisierte" "demoralisierte" "demoralisiert")  ;
  demotivieren_sV2 = dassV2 (irregV "demotivieren" "demotiviert" "demotivierte" "demotivierte" "demotiviert") accPrep ;
  demotivieren_V2 = dirV2 (irregV "demotivieren" "demotiviert" "demotivierte" "demotivierte" "demotiviert")  ;
  demuetigen_sV2 = dassV2 (irregV "demütigen" "demütigt" "demütigte" "demütigte" "demütigt") accPrep ;
  demuetigen_V2 = dirV2 (irregV "demütigen" "demütigt" "demütigte" "demütigte" "demütigt")  ;
  denaturieren_V2 = dirV2 (irregV "denaturieren" "denaturiert" "denaturierte" "denaturierte" "denaturiert")  ;
  denaturieren_V = irregV "denaturieren" "denaturiert" "denaturierte" "denaturierte" "denaturiert" ;
  dengeln_V2 = dirV2 (irregV "dengeln" "dengelt" "dengelte" "dengelte" "dengelt")  ;
  denken_an_V2 = prepV2 (irregV "denken" "denkt" "dachte" "dächte" "gedacht") (mkPrep "an" accusative) ;
  denken_ueber_V2S = mkV2S (irregV "denken" "denkt" "dachte" "dächte" "gedacht") (mkPrep "über" accusative) ;
  denken_ueber_V3 = mkV3 (irregV "denken" "denkt" "dachte" "dächte" "gedacht") (mkPrep "über" accusative) accPrep ;
  denken_V2 = dirV2 (irregV "denken" "denkt" "dachte" "dächte" "gedacht")  ;
  denken_VS = mkVS (irregV "denken" "denkt" "dachte" "dächte" "gedacht")  ;
  denominieren_V2 = dirV2 (irregV "denominieren" "denominiert" "denominierte" "denominierte" "denominiert")  ;
  denunzieren_V2 = dirV2 (regV "denunzieren")  ;
  depigmentieren_V2 = dirV2 (irregV "depigmentieren" "depigmentiert" "depigmentierte" "depigmentierte" "depigmentiert")  ;
  deponieren_loc_V3 = dirV3 (regV "deponieren") loc_Prep ;
  deportieren_V2 = dirV2 (irregV "deportieren" "deportiert" "deportierte" "deportierte" "deportiert")  ;
  depravieren_gen_V3 = dirV3 (irregV "depravieren" "depraviert" "depravierte" "depravierte" "depraviert") genPrep ;
  deprimieren_sV2 = dassV2 (regV "deprimieren") accPrep ;
  deprimieren_V2 = dirV2 (regV "deprimieren")  ;
  deputieren_zu_V3 = dirV3 (irregV "deputieren" "deputiert" "deputierte" "deputierte" "deputiert") zu_Prep ;
  derangieren_V2 = dirV2 (irregV "derangieren" "derangiert" "derangierte" "derangierte" "derangiert")  ;
  derblecken_V2 = dirV2 (irregV "derblecken" "derbleckt" "derbleckte" "derbleckte" "derbleckt")  ;
  derogieren_dat_V2 = mkV2 (irregV "derogieren" "derogiert" "derogierte" "derogierte" "derogiert") datPrep ;
  desachalandieren_dat_V3 = accdatV3 (irregV "desachalandieren" "desachalandiert" "desachalandierte" "desachalandierte" "desachalandiert")  ;
  desarmieren_V2 = dirV2 (regV "desarmieren")  ;
  desavouieren_sV2 = dassV2 (regV "desavouieren") accPrep ;
  desavouieren_V2 = dirV2 (regV "desavouieren")  ;
  desensibilisieren_V2 = dirV2 (irregV "desensibilisieren" "desensibilisiert" "desensibilisierte" "desensibilisierte" "desensibilisiert")  ;
  desertieren_dir_V2 = prepV2 (regV "desertieren") dir_Prep ;
  designen_V2 = dirV2 (irregV "designen" "designt" "designte" "designte" "designt")  ;
  designieren_V2 = dirV2 (irregV "designieren" "designiert" "designierte" "designierte" "designiert")  ;
  desillusionieren_sV2 = dassV2 (regV "desillusionieren") accPrep ;
  desillusionieren_V2 = dirV2 (regV "desillusionieren")  ;
  desistieren_auf_V2 = prepV2 (irregV "desistieren" "desistiert" "desistierte" "desistierte" "desistiert") (mkPrep "auf" dative) ;
  despektieren_V2 = dirV2 (irregV "despektieren" "despektiert" "despektierte" "despektierte" "despektiert")  ;
  destillieren_V2 = dirV2 (irregV "destillieren" "destilliert" "destillierte" "destillierte" "destilliert")  ;
  destruieren_V2 = dirV2 (irregV "destruieren" "destruiert" "destruierte" "destruierte" "destruiert")  ;
  detachieren_V2 = dirV2 (irregV "detachieren" "detachiert" "detachierte" "detachierte" "detachiert")  ;
  detaillieren_V2 = dirV2 (regV "detaillieren")  ;
  detektieren_V = irregV "detektieren" "detektiert" "detektierte" "detektierte" "detektiert" ;
  determinieren_V2 = dirV2 (irregV "determinieren" "determiniert" "determinierte" "determiniere" "determiniert")  ;
  detonieren_V = irregV "detonieren" "detoniert" "detonierte" "detonierte" "detoniert" ;
  deuten_auf_V2 = prepV2 (regV "deuten") (mkPrep "auf" accusative) ;
  deutscheln_V = regV "deutscheln" ;
  deutschtuemeln_V = regV "deutschtümeln" ;
  dezidieren_dat_V3 = accdatV3 (irregV "dezidieren" "dezidiert" "dezidierte" "dezidierte" "dezidiert")  ;
  dezimieren_V2 = dirV2 (irregV "dezimieren" "dezimiert" "dezimierte" "dezimierte" "dezimiert")  ;
  diagnostizieren_V2 = dirV2 (irregV "diagnostizieren" "diagnostiziert" "diagnostizierte" "diagnostizierte" "diagnostiziert")  ;
  dialysieren_V0 = mkV0 (irregV "dialysieren" "dialysiert" "dialysierte" "dialysierte" "dialysiert")  ;
  dibbern_V = irregV "dibbern" "dibbert" "dibberte" "dibberte" "dibbert" ;
  dichten_V2 = dirV2 (regV "dichten")  ;
  dichten_V = regV "dichten" ;
  dichtmachen_V2 = dirV2 (prefixV "dicht" (regV "machen"))  ;
  dichtmachen_V = prefixV "dicht" (regV "machen") ;
  dienen_dat_V2 = mkV2 (regV "dienen") datPrep ;
  diffamieren_V2 = dirV2 (regV "diffamieren")  ;
  differenzieren_V2 = dirV2 (irregV "differenzieren" "differenziert" "differenzierte" "differenzierte" "differenziert")  ;
  differieren_plV = plV (irregV "differieren" "differiert" "differierte" "differierte" "differiert")  ;
  differieren_um_V2 = prepV2 (irregV "differieren" "differiert" "differierte" "differierte" "differiert") um_Prep ;
  diffundieren_in_V2 = prepV2 (irregV "diffundieren" "diffundiert" "diffundierte" "diffundierte" "diffundiert") (mkPrep "in" accusative) ;
  digitalisieren_V2 = dirV2 (irregV "digitalisieren" "digitalisiert" "digitalisierte" "digitalisierte" "digitalisiert")  ;
  diktieren_dat_V2S = mkV2S (regV "diktieren") datPrep ;
  diktieren_dat_V3 = accdatV3 (regV "diktieren")  ;
  dilatieren_V2 = dirV2 (irregV "dilatieren" "dilatiert" "dilatierte" "dilatierte" "dilatiert")  ;
  dilettieren_im_V2 = prepV2 (regV "dilettieren") (mkPrep "in" dative) ;
  diluieren_V2 = dirV2 (irregV "diluieren" "diluiert" "diluierte" "diluierte" "diluiert")  ;
  dimerisieren_V0 = mkV0 (irregV "dimerisieren" "dimerisiert" "dimerisierte" "dimerisierte" "dimerisiert")  ;
  dimmen_V2 = dirV2 (irregV "dimmen" "dimmt" "dimmte" "dimmte" "gedimmt")  ;
  dingen_V2 = dirV2 (regV "dingen")  ;
  dinieren_V = regV "dinieren" ;
  dippen_in_V3 = dirV3 (irregV "dippen" "dippt" "dippte" "dippte" "gedippt") (mkPrep "in" accusative) ;
  dirigieren_V2 = dirV2 (regV "dirigieren")  ;
  dirimieren_V2 = dirV2 (irregV "dirimieren" "dirimiert" "dirimierte" "dirimierte" "dirimiert")  ;
  disambiguieren_V2 = dirV2 (regV "disambiguieren")  ;
  disassoziieren_V0 = mkV0 (regV "disassoziieren")  ;
  diskreditieren_V2 = dirV2 (regV "diskreditieren")  ;
  diskriminieren_V2 = dirV2 (regV "diskriminieren")  ;
  diskutieren_mit_ueber_V3 = mkV3 (regV "diskutieren") mit_Prep (mkPrep "über" accusative) ;
  diskutieren_mit_V2Q = mkV2Q (regV "diskutieren") mit_Prep ;
  diskutieren_mit_V3 = mkV3 (regV "diskutieren") mit_Prep accPrep ;
  diskutieren_plV2 = pldirV2 (regV "diskutieren")  ;
  diskutieren_ueber_V2 = prepV2 (regV "diskutieren") (mkPrep "über" accusative) ;
  diskutieren_VQ = mkVQ (regV "diskutieren")  ;
  dislozieren_V2 = dirV2 (regV "dislozieren")  ;
  dislozieren_V = regV "dislozieren" ;
  dispensieren_V2 = dirV2 (regV "dispensieren")  ;
  dispergieren_im_V3 = dirV3 (regV "dispergieren") (mkPrep "in" dative) ;
  disponieren_V = regV "disponieren" ;
  disputieren_mit_ueber_V3 = mkV3 (regV "disputieren") mit_Prep (mkPrep "über" accusative) ;
  disputieren_ueber_V2 = prepV2 (regV "disputieren") (mkPrep "über" accusative) ;
  dissentieren_im_V2 = prepV2 (regV "dissentieren") (mkPrep "in" dative) ;
  dissen_V2 = dirV2 (irregV "dissen" "disst" "disste" "disste" "gedisst")  ;
  dissoziieren_V2 = dirV2 (regV "dissoziieren")  ;
  distanzieren_von_rV2 = reflV2 (regV "distanzieren") accusative von_Prep ;
  disziplinieren_sV2 = dassV2 (regV "disziplinieren") accPrep ;
  disziplinieren_V2 = dirV2 (regV "disziplinieren")  ;
  ditschen_an_V2 = prepV2 (irregV "ditschen" "ditscht" "ditschte" "ditschte" "geditscht") (mkPrep "an" accusative) ;
  divergieren_im_V2 = prepV2 (regV "divergieren") (mkPrep "in" dative) ;
  divergieren_von_im_V3 = mkV3 (regV "divergieren") von_Prep (mkPrep "in" dative) ;
  diversifizieren_V2 = dirV2 (regV "diversifizieren")  ;
  dividieren_V2 = dirV2 (regV "dividieren")  ;
  doelmern_V = regV "dölmern" ;
  doenern_V = regV "dönern" ;
  doerren_V2 = dirV2 (regV "dörren")  ;
  doesen_loc_V2 = prepV2 (regV "dösen") loc_Prep ;
  doesen_V = regV "dösen" ;
  dogmatisieren_V2 = dirV2 (regV "dogmatisieren")  ;
  dogmatisieren_VS = mkVS (regV "dogmatisieren")  ;
  doktorieren_V = regV "doktorieren" ;
  dokumentieren_V2 = dirV2 (regV "dokumentieren")  ;
  dokumentieren_VS = mkVS (regV "dokumentieren")  ;
  dolmetschen_dir_V3 = dirV3 (regV "dolmetschen") dir_Prep ;
  dolmetschen_dir_VS2 = mkVS2 (regV "dolmetschen") dir_Prep ;
  domestizieren_V2 = dirV2 (regV "domestizieren")  ;
  dominieren_V2 = dirV2 (regV "dominieren")  ;
  donnern_es_esV = esV (regV "donnern")  ;
  dopen_V2 = dirV2 (regV "dopen")  ;
  doppelklicken_V = regV "doppelklicken" ;
  dorren_V = regV "dorren" ;
  dosieren_V2 = dirV2 (regV "dosieren")  ;
  dotieren_mit_V3 = dirV3 (regV "dotieren") mit_Prep ;
  doubeln_V2 = dirV2 (regV "doubeln")  ;
  dozieren_V2 = dirV2 (regV "dozieren")  ;
  dozieren_VS = mkVS (regV "dozieren")  ;
  draengen_V2V = dirV2V (regV "drängen")  ;
  draengen_zu_V3 = dirV3 (regV "drängen") zu_Prep ;
  draeuen_dat_V2 = mkV2 (regV "dräuen") datPrep ;
  dragieren_V2 = dirV2 (regV "dragieren")  ;
  drahten_VS = mkVS (regV "drahten")  ;
  dramatisieren_V2 = dirV2 (regV "dramatisieren")  ;
  dramatisieren_VS = mkVS (regV "dramatisieren")  ;
  drangsalieren_V2 = dirV2 (regV "drangsalieren")  ;
  drapieren_loc_V3 = dirV3 (regV "drapieren") loc_Prep ;
  drausbringen_V2 = dirV2 (prefixV "draus" (irregV "bringen" "bringt" "brachte" "brachte" "gebracht"))  ;
  drechseln_V2 = dirV2 (regV "drechseln")  ;
  drehen_V2 = dirV2 (regV "drehen")  ;
  drehen_VS = mkVS (regV "drehen")  ;
  dreschen_V2 = dirV2 (irregV "dreschen" "drescht" "drosch" "drösche" "gedroschen")  ;
  dressen_V2 = dirV2 (regV "dressen")  ;
  dressieren_V2 = dirV2 (regV "dressieren")  ;
  dribbeln_V = regV "dribbeln" ;
  driften_dir_V2 = prepV2 (irregV "driften" "driftet" "driftete" "drifte" "gedriftet") dir_Prep ;
  drillen_V2 = dirV2 (regV "drillen")  ;
  dringen_auf_V2 = prepV2 (irregV "dringen" "dringt" "drang" "dränge" "gedrungen") (mkPrep "auf" accusative) ;
  dringen_durch_V2 = prepV2 (irregV "dringen" "dringt" "drang" "dränge" "gedrungen") durch_Prep ;
  drohen_dat_mit_V3 = mkV3 (regV "drohen") datPrep mit_Prep ;
  drucken_V2 = dirV2 (regV "drucken")  ;
  druecken_vor_rV2 = reflV2 (regV "drücken") accusative (mkPrep "vor" dative) ;
  druseln_V = regV "druseln" ;
  ducken_dir_V3 = dirV3 (regV "ducken") dir_Prep ;
  ducken_V2 = dirV2 (regV "ducken")  ;
  duckmaeusern_V = regV "duckmäusern" ;
  duebeln_loc_V3 = dirV3 (regV "dübeln") loc_Prep ;
  duellieren_mit_rV2 = reflV2 (regV "duellieren") accusative mit_Prep ;
  duellieren_rV = reflV (regV "duellieren") accusative ;
  duempeln_loc_V2 = prepV2 (regV "dümpeln") loc_Prep ;
  duenken_VS = mkVS (irregV "dünken" "dünkt" "deuchte" "deuche" "gedeucht")  ;
  duensten_V2 = dirV2 (regV "dünsten")  ;
  duensten_V = regV "dünsten" ;
  duepieren_V2 = dirV2 (regV "düpieren")  ;
  duerfen_inf_VV = auxVV (irregV "dürfen" "dürft" "durfte" "dürfte" "gedurft")  ;
  duersten_es_nach_V3 = dirV3 (regV "dürsten") nach_Prep ;
  duersten_nach_V2 = prepV2 (regV "dürsten") nach_Prep ;
  duften_nach_V2 = prepV2 (regV "duften") (mkPrep "nach" dative) ;
  duften_V = regV "duften" ;
  dulden_V2 = dirV2 (regV "dulden")  ;
  dulden_VS = mkVS (regV "dulden")  ;
  duplizieren_V2 = dirV2 (regV "duplizieren")  ;
  durchbrechen_V2 = dirV2 (prefixV "durch" (irregV "brechen" "brecht" "brach" "bräche" "gebrochen"))  ;
  durchbrennen_mit_V2 = prepV2 (prefixV "durch" (irregV "brennen" "brennt" "brannte" "brannte" "gebrannt")) mit_Prep ;
  durchbrennen_V = prefixV "durch" (irregV "brennen" "brennt" "brannte" "brannte" "gebrannt") ;
  durchdenken_V2 = dirV2 (irregV "durchdenken" "denkt" "dachte" "dächte" "gedacht")  ;
  durchdrehen_V = prefixV "durch" (regV "drehen") ;
  durchdringen_V2 = dirV2 (prefixV "durch" (irregV "dringen" "dringt" "drang" "dränge" "gedrungen"))  ;
  durchfahren_sV2 = dassV2 (irregV "durchfahren" "durchfahrt" "durchfuhr" "durchführe" "durchfahren") accPrep ;
  durchfahren_V2 = dirV2 (irregV "durchfahren" "durchfahrt" "durchfuhr" "durchführe" "durchfahren")  ;
  durchficken_V2 = dirV2 (prefixV "durch" (regV "ficken"))  ;
  durchfliessen_V2 = dirV2 (irregV "durchfließen" "durchfließt" "durchfloss" "durchflösse" "durchflossen")  ;
  durchfuehren_V2 = dirV2 (prefixV "durch" (regV "führen"))  ;
  durchgehen_als_V2 = prepV2 (prefixV "durch" (irregV "gehen" "geht" "ging" "ging" "gegangen")) (mkPrep "als" nominative) ;
  durchgehen_durch_V2 = prepV2 (prefixV "durch" (irregV "gehen" "geht" "ging" "ging" "gegangen")) durch_Prep ;
  durchgehen_V2 = dirV2 (prefixV "durch" (irregV "gehen" "geht" "ging" "ging" "gegangen"))  ;
  durchgehen_V = prefixV "durch" (irregV "gehen" "geht" "ging" "ging" "gegangen") ;
  durchhaengen_V = prefixV "durch" (irregV "hängen" "hängt" "hing" "hinge" "gehangen") ;
  durchhalten_V = prefixV "durch" (irregV "halten" "hält" "hielt" "hielte" "gehalten") ;
  durchixen_V2 = dirV2 (prefixV "durch" (regV "ixen"))  ;
  durchlassen_V2 = dirV2 (prefixV "durch" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  durchmachen_V2 = dirV2 (prefixV "durch" (regV "machen"))  ;
  durchmachen_V = prefixV "durch" (regV "machen") ;
  durchregieren_V = prefixV "durch" (regV "regieren") ;
  durchsagen_V2 = dirV2 (prefixV "durch" (regV "sagen"))  ;
  durchschauen_V2 = dirV2 (regV "durchschauen")  ;
  durchsetzen_mit_V3 = dirV3 (prefixV "durch" (regV "setzen")) mit_Prep ;
  durchstarten_V = prefixV "durch" (regV "starten") ;
  durchstroemen_V2 = dirV2 (regV "durchströmen")  ;
  durchsuchen_V2 = dirV2 (regV "durchsuchen")  ;
  durchwachsen_V2 = dirV2 (prefixV "durch" (irregV "wachsen" "wächst" "wuchs" "wuchs" "gewachsen"))  ;
  durchwinken_V2 = dirV2 (prefixV "durch" (regV "winken"))  ;
  durchziehen_V2 = dirV2 (prefixV "durch" (irregV "ziehen" "zieht" "zog" "zog" "gezogen"))  ;
  dursten_V = regV "dursten" ;
  duschen_V2 = dirV2 (regV "duschen")  ;
  duschen_V = regV "duschen" ;
  duzen_V2 = dirV2 (regV "duzen")  ;
  ebben_es_esV = esV (irregV "ebben" "ebbt" "ebbte" "ebbte" "ebbt")  ;
  ebnen_V2 = dirV2 (regV "ebnen")  ;
  echauffieren_rV = reflV (regV "echauffieren") accusative ;
  echoen_VS = mkVS (regV "echoen")  ;
  edieren_V2 = dirV2 (regV "edieren")  ;
  editieren_V2 = dirV2 (regV "editieren")  ;
  effektuieren_V2 = dirV2 (regV "effektuieren")  ;
  egalisieren_V2 = dirV2 (regV "egalisieren")  ;
  ehelichen_V2 = dirV2 (regV "ehelichen")  ;
  ehren_sV2 = dassV2 (regV "ehren") accPrep ;
  ehren_V2 = dirV2 (regV "ehren")  ;
  eichen_V2 = dirV2 (regV "eichen")  ;
  eiern_um_V2 = prepV2 (irregV "eiern" "eiert" "eierte" "eierte" "geeiert") um_Prep ;
  eilen_dir_V2 = prepV2 (irregV "eilen" "eilt" "eilte" "eilte" "eilt") dir_Prep ;
  eilen_V = irregV "eilen" "eilt" "eilte" "eilte" "eilt" ;
  einatmen_V2 = dirV2 (prefixV "ein" (regV "atmen"))  ;
  einatmen_V = prefixV "ein" (regV "atmen") ;
  einbauen_V2 = dirV2 (prefixV "ein" (regV "bauen"))  ;
  einbezahlen_V = prefixV "ein" (regV "bezahlen") ;
  einbeziehen_in_V3 = dirV3 (prefixV "ein" (irregV "beziehen" "bezieht" "bezog" "bezöge" "bezogen")) (mkPrep "in" accusative) ;
  einbeziehen_V2 = dirV2 (prefixV "ein" (irregV "beziehen" "bezieht" "bezog" "bezöge" "bezogen"))  ;
  einbeziehen_VS = mkVS (prefixV "ein" (irregV "beziehen" "bezieht" "bezog" "bezöge" "bezogen"))  ;
  einblaeuen_dat_V2S = mkV2S (prefixV "ein" (regV "bläuen")) datPrep ;
  einblaeuen_dat_V2V = mkV2V (prefixV "ein" (regV "bläuen")) datPrep ;
  einblaeuen_dat_V3 = accdatV3 (prefixV "ein" (regV "bläuen"))  ;
  einblasen_in_V3 = dirV3 (prefixV "ein" (irregV "blasen" "blast" "blies" "bliese" "geblasen")) (mkPrep "in" accusative) ;
  einbrechen_in_V2 = prepV2 (irregV "einbrechen" "brecht" "brach" "bräche" "gebrochen") (mkPrep "in" accusative) ;
  einbrennen_dat_V3 = accdatV3 (prefixV "ein" (irregV "brennen" "brennt" "brannte" "brannte" "gebrannt"))  ;
  einbringen_rV = reflV (prefixV "ein" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht")) accusative ;
  einbrocken_dat_V2S = mkV2S (prefixV "ein" (regV "brocken")) datPrep ;
  einbrocken_dat_V3 = accdatV3 (prefixV "ein" (regV "brocken"))  ;
  eincremen_V2 = dirV2 (prefixV "ein" (regV "cremen"))  ;
  eindosen_V2 = dirV2 (prefixV "ein" (regV "dosen"))  ;
  eindringen_in_V2 = prepV2 (prefixV "ein" (irregV "dringen" "dringt" "drang" "dränge" "gedrungen")) (mkPrep "in" accusative) ;
  einengen_sV2 = dassV2 (prefixV "ein" (regV "engen")) accPrep ;
  einenglischen_V2 = dirV2 (prefixV "ein" (regV "englischen"))  ;
  einen_sV2 = dassV2 (regV "einen") accPrep ;
  einen_V2 = dirV2 (regV "einen")  ;
  einfallen_dat_sV2 = dassV2 (prefixV "ein" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen")) datPrep ;
  einfallen_in_V2 = prepV2 (prefixV "ein" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen")) (mkPrep "in" accusative) ;
  einfangen_rV2 = reflV2 (prefixV "ein" (irregV "fangen" "fängt" "fing" "fing" "gefangen")) accusative accPrep ;
  einfangen_V2 = dirV2 (prefixV "ein" (irregV "fangen" "fängt" "fing" "fing" "gefangen"))  ;
  einfinden_loc_rV2 = reflV2 (prefixV "ein" (irregV "finden" "findet" "fand" "fände" "gefunden")) accusative loc_Prep ;
  einfloessen_dat_V2S = mkV2S (prefixV "ein" (irregV "flößen" "flößt" "flöße" "flöße" "geflößt")) datPrep ;
  einfloessen_dat_V3 = accdatV3 (prefixV "ein" (irregV "flößen" "flößt" "flöße" "flöße" "geflößt"))  ;
  einfrieren_V2 = dirV2 (prefixV "ein" (irregV "frieren" "friert" "fror" "fröre" "gefroren"))  ;
  einfrieren_V = prefixV "ein" (irregV "frieren" "friert" "fror" "fröre" "gefroren") ;
  einfuegen_in_V3 = dirV3 (prefixV "ein" (regV "fügen")) (mkPrep "in" accusative) ;
  einfuegen_rV = reflV (prefixV "ein" (regV "fügen")) accusative ;
  einfuehren_in_V3 = dirV3 (prefixV "ein" (regV "führen")) (mkPrep "in" accusative) ;
  einfuehren_V2 = dirV2 (prefixV "ein" (regV "führen"))  ;
  eingeben_in_V3 = dirV3 (prefixV "ein" (irregV "geben" "gebt" "gab" "gäbe" "gegeben")) (mkPrep "in" accusative) ;
  eingehen_in_V2 = prepV2 (prefixV "ein" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) (mkPrep "in" accusative) ;
  eingehen_V = prefixV "ein" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  eingemeinden_V2 = dirV2 (prefixV "ein" (irregV "gemeinden" "gemeindet" "gemeindete" "gemeindete" "gemeindet"))  ;
  eingestehen_dat_V2S = mkV2S (prefixV "ein" (irregV "gestehen" "gesteht" "gestand" "gestand" "gestanden")) datPrep ;
  eingreifen_in_V2 = prepV2 (prefixV "ein" (irregV "greifen" "greift" "griff" "griffe" "gegriffen")) (mkPrep "in" accusative) ;
  eingreifen_V = prefixV "ein" (irregV "greifen" "greift" "griff" "griffe" "gegriffen") ;
  eingrenzen_V2 = dirV2 (prefixV "ein" (regV "grenzen"))  ;
  einhaendigen_V = prefixV "ein" (regV "händigen") ;
  einheften_V2 = dirV2 (prefixV "ein" (regV "heften"))  ;
  einheimsen_V2 = dirV2 (prefixV "ein" (regV "heimsen"))  ;
  einhergehen_mit_V2 = prepV2 (prefixV "einher" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) mit_Prep ;
  einholen_rV2 = reflV2 (prefixV "ein" (regV "holen")) dative accPrep ;
  einholen_V2 = dirV2 (prefixV "ein" (regV "holen"))  ;
  einigen_mit_auf_rV3 = reflV3 (regV "einigen") accusative mit_Prep (mkPrep "auf" accusative) ;
  einiggehen_im_V2 = prepV2 (prefixV "einig" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) (mkPrep "in" dative) ;
  einiggehen_plV = plV (prefixV "einig" (irregV "gehen" "geht" "ging" "ginge" "gegangen"))  ;
  einimpfen_dat_V3 = accdatV3 (prefixV "ein" (regV "impfen"))  ;
  einkaesteln_V2 = dirV2 (prefixV "ein" (regV "kästeln"))  ;
  einkaesten_V2 = dirV2 (prefixV "ein" (regV "kästen"))  ;
  einkampfern_V2 = dirV2 (prefixV "ein" (regV "kampfern"))  ;
  einkaufen_V2 = dirV2 (prefixV "ein" (regV "kaufen"))  ;
  einkerkern_V2 = dirV2 (prefixV "ein" (regV "kerkern"))  ;
  einkleiden_V2 = dirV2 (prefixV "ein" (regV "kleiden"))  ;
  einkochen_V2 = dirV2 (prefixV "ein" (regV "kochen"))  ;
  einkoffern_V2 = dirV2 (prefixV "ein" (regV "koffern"))  ;
  einkoppeln_in_V3 = dirV3 (prefixV "ein" (regV "koppeln")) (mkPrep "in" accusative) ;
  einkreisen_V2 = dirV2 (prefixV "ein" (regV "kreisen"))  ;
  einladen_V2 = dirV2 (prefixV "ein" (irregV "laden" "lädt" "lud" "lüde" "geladen"))  ;
  einlassen_V2 = dirV2 (prefixV "ein" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  einlasten_V2 = dirV2 (prefixV "ein" (regV "lasten"))  ;
  einlaufen_in_V2 = prepV2 (prefixV "ein" (irregV "laufen" "lauft" "lief" "liefe" "gelaufen")) (mkPrep "in" accusative) ;
  einlaufen_V = prefixV "ein" (irregV "laufen" "lauft" "lief" "liefe" "gelaufen") ;
  einlenken_V = prefixV "ein" (regV "lenken") ;
  einleuchten_dat_sV2 = dassV2 (prefixV "ein" (regV "leuchten")) datPrep ;
  einloggen_in_rV2 = reflV2 (prefixV "ein" (regV "loggen")) accusative (mkPrep "in" accusative) ;
  einloggen_rV = reflV (prefixV "ein" (regV "loggen")) accusative ;
  einlullen_V2 = dirV2 (prefixV "ein" (regV "lullen"))  ;
  einmachen_V2 = dirV2 (prefixV "ein" (regV "machen"))  ;
  einmahnen_V2 = dirV2 (prefixV "ein" (regV "mahnen"))  ;
  einmargerieren_V2 = dirV2 (prefixV "ein" (regV "margerieren"))  ;
  einmischen_in_rV2 = reflV2 (prefixV "ein" (regV "mischen")) accusative (mkPrep "in" accusative) ;
  einnaessen_V2 = dirV2 (prefixV "ein" (regV "nässen"))  ;
  einnehmen_fuer_V3 = dirV3 (prefixV "ein" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen")) fuer_Prep ;
  einnehmen_V2 = dirV2 (prefixV "ein" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  einnisten_loc_rV2 = reflV2 (prefixV "ein" (regV "nisten")) accusative loc_Prep ;
  einnorden_V2 = dirV2 (prefixV "ein" (regV "norden"))  ;
  einordnen_V2 = dirV2 (prefixV "ein" (regV "ordnen"))  ;
  einpacken_V2 = dirV2 (prefixV "ein" (regV "packen"))  ;
  einpflegen_in_V3 = dirV3 (prefixV "ein" (regV "pflegen")) (mkPrep "in" accusative) ;
  einpreisen_in_V3 = dirV3 (prefixV "ein" (regV "preisen")) (mkPrep "in" accusative) ;
  einraeumen_dat_V2S = mkV2S (prefixV "ein" (regV "räumen")) datPrep ;
  einraeumen_V2 = dirV2 (prefixV "ein" (regV "räumen"))  ;
  einraeumen_VS = mkVS (prefixV "ein" (regV "räumen"))  ;
  einreiben_mit_V3 = dirV3 (prefixV "ein" (irregV "reiben" "reibt" "rieb" "rieb" "gerieben")) mit_Prep ;
  einreichen_V2 = dirV2 (prefixV "ein" (regV "reichen"))  ;
  einrexen_V2 = dirV2 (prefixV "ein" (regV "rexen"))  ;
  einrichten_V2 = dirV2 (prefixV "ein" (regV "richten"))  ;
  einsagen_dat_V3 = accdatV3 (prefixV "ein" (regV "sagen"))  ;
  einsalben_V2 = dirV2 (prefixV "ein" (regV "salben"))  ;
  einsargen_V2 = dirV2 (prefixV "ein" (regV "sargen"))  ;
  einschaetzen_VQ = mkVQ (prefixV "ein" (regV "schätzen"))  ;
  einschalten_V2 = dirV2 (prefixV "ein" (regV "schalten"))  ;
  einschieben_V2 = dirV2 (prefixV "ein" (irregV "schieben" "schiebt" "schob" "schöbe" "geschoben"))  ;
  einschlaefern_V2 = dirV2 (prefixV "ein" (regV "schläfern"))  ;
  einschlafen_V = prefixV "ein" (irregV "schlafen" "schlaft" "schlief" "schliefe" "geschlafen") ;
  einschlagen_auf_V3 = dirV3 (prefixV "ein" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen")) (mkPrep "auf" accusative) ;
  einschlagen_V2 = dirV2 (prefixV "ein" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen"))  ;
  einschliessen_in_V3 = dirV3 (prefixV "ein" (irregV "schließen" "schließt" "schloss" "schlösse" "geschlossen")) (mkPrep "in" accusative) ;
  einschliessen_sVS = dassVS (prefixV "ein" (irregV "schließen" "schließt" "schloss" "schlösse" "geschlossen"))  ;
  einschliessen_V2 = dirV2 (prefixV "ein" (irregV "schließen" "schließt" "schloss" "schlösse" "geschlossen"))  ;
  einschraenken_V2 = dirV2 (prefixV "ein" (regV "schränken"))  ;
  einschreiben_rV = reflV (prefixV "ein" (irregV "schreiben" "schreibt" "schrieb" "schrieb" "geschrieben")) accusative ;
  einschuechtern_V2 = dirV2 (prefixV "ein" (irregV "schüchtern" "schüchtert" "schüchterte" "schüchterte" "geschüchtert"))  ;
  einsehen_V2 = dirV2 (prefixV "ein" (irregV "sehen" "seht" "sah" "sähe" "gesehen"))  ;
  einsehen_VS = mkVS (prefixV "ein" (irregV "sehen" "seht" "sah" "sähe" "gesehen"))  ;
  einseifen_V2 = dirV2 (prefixV "ein" (regV "seifen"))  ;
  einsetzen_in_V3 = dirV3 (prefixV "ein" (regV "setzen")) (mkPrep "in" accusative) ;
  einsetzen_V2 = dirV2 (prefixV "ein" (regV "setzen"))  ;
  einsparen_V2 = dirV2 (prefixV "ein" (regV "sparen"))  ;
  einspeisen_in_V3 = dirV3 (prefixV "ein" (regV "speisen")) (mkPrep "in" accusative) ;
  einsperren_in_V3 = dirV3 (prefixV "ein" (regV "sperren")) (mkPrep "in" accusative) ;
  einspringen_fuer_V2 = prepV2 (prefixV "ein" (irregV "springen" "springt" "sprang" "sprang" "gesprungen")) fuer_Prep ;
  einstallen_V2 = dirV2 (prefixV "ein" (regV "stallen"))  ;
  einsteigen_V2 = dirV2 (prefixV "ein" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen"))  ;
  einstellen_auf_rV2 = reflV2 (prefixV "ein" (regV "stellen")) accusative (mkPrep "auf" accusative) ;
  einstellen_V2 = dirV2 (prefixV "ein" (regV "stellen"))  ;
--  einstellen_V = prefixV "ein" (irregV "stellen" "stellt" "stell" "stelle" "gestellt") ;
  einstimmen_in_V2 = prepV2 (prefixV "ein" (regV "stimmen")) (mkPrep "in" accusative) ;
  eintauchen_V2 = dirV2 (prefixV "ein" (regV "tauchen"))  ;
  einteilen_in_V3 = dirV3 (prefixV "ein" (irregV "teilen" "teilt" "teilte" "teilte" "geteilt")) (mkPrep "in" accusative) ;
  eintragen_in_V3 = dirV3 (prefixV "ein" (irregV "tragen" "tragt" "trug" "trüge" "getragen")) (mkPrep "in" accusative) ;
  eintreffen_im_V3 = dirV3 (prefixV "ein" (irregV "treffen" "trefft" "traf" "träfe" "getroffen")) (mkPrep "in" dative) ;
  eintreten_sV = dassV (prefixV "ein" (irregV "treten" "tritt" "trat" "trat" "getreten"))  ;
  eintreten_V2 = dirV2 (prefixV "ein" (irregV "treten" "tritt" "trat" "trat" "getreten"))  ;
  eintueten_in_V3 = dirV3 (prefixV "ein" (regV "tüten")) (mkPrep "in" accusative) ;
  eintunken_in_V3 = dirV3 (prefixV "ein" (regV "tunken")) (mkPrep "in" accusative) ;
  einurnen_V2 = dirV2 (prefixV "ein" (regV "urnen"))  ;
  einverleiben_rV2 = reflV2 (prefixV "ein" (regV "verleiben")) dative accPrep ;
  einwecken_V2 = dirV2 (prefixV "ein" (regV "wecken"))  ;
  einweihen_V2 = dirV2 (prefixV "ein" (regV "weihen"))  ;
  einweisen_in_V3 = dirV3 (prefixV "ein" (irregV "weisen" "weist" "wies" "wiese" "gewiesen")) (mkPrep "in" accusative) ;
  einwenden_VS = mkVS (prefixV "ein" (regV "wenden"))  ;
  einwerben_V2 = dirV2 (prefixV "ein" (irregV "werben" "werbt" "warb" "würbe" "geworben"))  ;
  einwickeln_V2 = dirV2 (prefixV "ein" (regV "wickeln"))  ;
  einwilligen_in_V2 = prepV2 (prefixV "ein" (regV "willigen")) (mkPrep "in" accusative) ;
  einwirken_auf_V2 = prepV2 (prefixV "ein" (regV "wirken")) (mkPrep "auf" accusative) ;
  einzahlen_auf_V3 = dirV3 (prefixV "ein" (regV "zahlen")) (mkPrep "auf" accusative) ;
  einzeichnen_in_V3 = dirV3 (prefixV "ein" (regV "zeichnen")) (mkPrep "in" accusative) ;
  einziehen_in_V2 = prepV2 (prefixV "ein" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen")) (mkPrep "in" accusative) ;
  eislaufen_V = prefixV "eis" (irregV "laufen" "läuft" "lief" "lief" "gelaufen") ;
  eitern_V = irregV "eitern" "eitert" "eiterte" "eitere" "geeitert" ;
  ejakulieren_V = regV "ejakulieren" ;
  ekeln_sV2 = dassV2 (regV "ekeln") accPrep ;
  ekeln_V2 = dirV2 (regV "ekeln")  ;
  ekeln_vor_rV2 = reflV2 (regV "ekeln") accusative (mkPrep "vor" dative) ;
  ektomieren_V2 = dirV2 (regV "ektomieren")  ;
  elaborieren_V2 = dirV2 (regV "elaborieren")  ;
  elektrifizieren_V2 = dirV2 (regV "elektrifizieren")  ;
  elidieren_V2 = dirV2 (regV "elidieren")  ;
  eliminieren_V = regV "eliminieren" ;
  elizitieren_dat_V3 = accdatV3 (regV "elizitieren")  ;
  ellboegeln_V = irregV "ellbögeln" "ellbögelt" "ellbögelte" "ellbögelte" "ellbögelt" ;
  eluieren_V0 = mkV0 (regV "eluieren")  ;
  emanzipieren_von_V3 = dirV3 (regV "emanzipieren") von_Prep ;
  emendieren_V2 = dirV2 (regV "emendieren")  ;
  emeritieren_V2 = dirV2 (regV "emeritieren")  ;
  emigrieren_nach_V2 = prepV2 (regV "emigrieren") nach_Prep ;
  emittieren_V2 = dirV2 (regV "emittieren")  ;
  empfangen_aus_V3 = dirV3 (irregV "empfangen" "empfangt" "empfing" "empfinge" "empfangen") aus_Prep ;
  empfangen_von_V3 = dirV3 (irregV "empfangen" "empfangt" "empfing" "empfinge" "empfangen") von_Prep ;
  empfehlen_dat_V2V = mkV2V (irregV "empfehlen" "empfehlt" "empfahl" "empfähle" "empfohlen") datPrep ;
  empfehlen_dat_V3 = accdatV3 (irregV "empfehlen" "empfehlt" "empfahl" "empfähle" "empfohlen")  ;
  empfinden_V2 = dirV2 (irregV "empfinden" "empfindet" "empfand" "empfände" "empfunden")  ;
  empfinden_VSA = mkVSA (irregV "empfinden" "empfindet" "empfand" "empfände" "empfunden")  ;
  employieren_V2 = dirV2 (regV "employieren")  ;
  empoeren_sV2 = dassV2 (irregV "empören" "empört" "empörte" "empörte" "empört") accPrep ;
  empoeren_ueber_rV2 = reflV2 (irregV "empören" "empört" "empörte" "empörte" "empört") accusative (mkPrep "über" accusative) ;
  empoeren_V2 = dirV2 (irregV "empören" "empört" "empörte" "empörte" "empört")  ;
  emulgieren_V0 = mkV0 (irregV "emulgieren" "emulgiert" "emulgierte" "emulgierte" "emulgiert")  ;
  emulieren_V2 = dirV2 (irregV "emulieren" "emuliert" "emulierte" "emulierte" "emuliert")  ;
  enden_V = irregV "enden" "endet" "endete" "endete" "endet" ;
  enervieren_sV2 = dassV2 (irregV "enervieren" "enerviert" "enervierte" "enervierte" "enerviert") accPrep ;
  engagieren_als_V3 = dirV3 (regV "engagieren") (mkPrep "als" accusative) ;
  engagieren_fuer_rV2 = reflV2 (regV "engagieren") accusative fuer_Prep ;
  englisieren_V2 = dirV2 (regV "englisieren")  ;
  ennuyieren_V2 = dirV2 (irregV "ennuyieren" "ennuyiert" "ennuyierte" "ennuyierte" "ennuyiert")  ;
  entbehren_V2 = dirV2 (irregV "entbehren" "entbehrt" "entbehrte" "entbehrte" "entbehrt")  ;
  entbloeden_rVV = reflVV (irregV "entblöden" "entblödet" "entblödete" "entblödete" "entblödet") accusative ;
  entchristlichen_V2 = dirV2 (irregV "entchristlichen" "entchristlicht" "entchristlichte" "entchristlichte" "entchristlicht")  ;
  entdecken_V2 = dirV2 (irregV "entdecken" "entdeckt" "entdeckte" "entdeckte" "entdeckt")  ;
  entdecken_VS = mkVS (irregV "entdecken" "entdeckt" "entdeckte" "entdeckte" "entdeckt")  ;
  entehren_V2 = dirV2 (irregV "entehren" "entehrt" "entehrte" "entehrte" "entehrt")  ;
  enteilen_in_V3 = dirV3 (irregV "enteilen" "enteilt" "enteilte" "enteile" "enteilt") (mkPrep "in" accusative) ;
  enteisenen_V2 = dirV2 (irregV "enteisenen" "enteisent" "enteisente" "enteisente" "enteisent")  ;
  enteisen_V2 = dirV2 (irregV "enteisen" "enteist" "enteiste" "enteiste" "enteist")  ;
  enterben_V2 = dirV2 (irregV "enterben" "enterbt" "enterbte" "enterbte" "enterbt")  ;
  entern_V2 = dirV2 (regV "entern")  ;
  entfachen_V2 = dirV2 (irregV "entfachen" "entfacht" "entfachte" "entfachte" "entfacht")  ;
  entfallen_auf_V2 = prepV2 (irregV "entfallen" "entfallt" "entfiel" "entfiele" "entfallen") (mkPrep "auf" accusative) ;
  entfalten_V2 = dirV2 (irregV "entfalten" "entfaltet" "entfaltete" "entfaltete" "entfaltet")  ;
  entfernen_V2 = dirV2 (irregV "entfernen" "entfernt" "entfernte" "entfernte" "entfernt")  ;
  entfernen_von_V3 = dirV3 (irregV "entfernen" "entfernt" "entfernte" "entfernte" "entfernt") von_Prep ;
  entfesseln_V2 = dirV2 (irregV "entfesseln" "entfesselt" "entfesselte" "entfesselte" "entfesselt")  ;
  entflammen_V2 = dirV2 (irregV "entflammen" "entflammt" "entflammte" "entflammte" "entflammt")  ;
  entfuehren_V2 = dirV2 (irregV "entführen" "entführt" "entführte" "entführte" "entführt")  ;
  entgegenarbeiten_dat_V2 = mkV2 (prefixV "entgegen" (regV "arbeiten")) datPrep ;
  entgegenkommen_dat_V2 = mkV2 (prefixV "entgegen" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) datPrep ;
  entgegenwirken_dat_V2 = mkV2 (irregV "entgegenwirken" "entgegenwirkt" "entgegenwirkte" "entgegenwirkte" "entgegenwirkt") datPrep ;
  entgegnen_dat_V2S = mkV2S (irregV "entgegnen" "entgegnet" "entgegnete" "entgegnete" "entgegnet") datPrep ;
  entgegnen_dat_V3 = accdatV3 (irregV "entgegnen" "entgegnet" "entgegnete" "entgegnete" "entgegnet")  ;
  entgehen_dat_sV2 = dassV2 (irregV "entgehen" "entgeht" "entging" "entginge" "entgangen") datPrep ;
  entgehen_dat_V2 = mkV2 (irregV "entgehen" "entgeht" "entging" "entginge" "entgangen") datPrep ;
  entgeistigen_V2 = dirV2 (irregV "entgeistigen" "entgeistigt" "entgeistigte" "entgeistigte" "entgeistigt")  ;
  entgleisen_V = irregV "entgleisen" "entgleist" "entgleiste" "entgleiste" "entgleist" ;
  entgoettern_V2 = dirV2 (irregV "entgöttern" "entgöttert" "entgötterte" "entgötterte" "entgöttert")  ;
  entgraeten_V2 = dirV2 (irregV "entgräten" "entgrätet" "entgrätete" "entgrätete" "entgrätet")  ;
  enthalten_gen_rV2 = reflV2 (irregV "enthalten" "enthält" "enthielt" "enthielte" "enthalten") accusative genPrep ;
  enthalten_V2 = dirV2 (irregV "enthalten" "enthält" "enthielt" "enthielte" "enthalten")  ;
  enthaupten_V2 = dirV2 (irregV "enthaupten" "enthauptet" "enthauptete" "enthauptete" "enthauptet")  ;
  entheben_gen_V3 = dirV3 (irregV "entheben" "enthebt" "enthob" "enthöbe" "enthoben") genPrep ;
  entheimen_V2 = dirV2 (irregV "entheimen" "entheimt" "entheimte" "entheimte" "entheimt")  ;
  enthuellen_V2 = dirV2 (irregV "enthüllen" "enthüllt" "enthüllte" "enthüllte" "enthüllt")  ;
  entjudaisieren_V2 = dirV2 (irregV "entjudaisieren" "entjudaisiert" "entjudaisierte" "entjudaisierte" "entjudaisiert")  ;
  entjuden_V2 = dirV2 (irregV "entjuden" "entjudet" "entjudete" "entjudete" "entjudet")  ;
  entjungfern_V2 = dirV2 (irregV "entjungfern" "entjungfert" "entjungferte" "entjungferte" "entjungfert")  ;
  entkeimen_V2 = dirV2 (irregV "entkeimen" "entkeimt" "entkeimte" "entkeimte" "entkeimt")  ;
  entkokainisieren_V2 = dirV2 (irregV "entkokainisieren" "entkokainisiert" "entkokainisierte" "entkokainisierte" "entkokainisiert")  ;
  entkommen_von_V2 = prepV2 (irregV "entkommen" "entkommt" "entkam" "entkäme" "entkommen") von_Prep ;
  entkorken_V2 = dirV2 (irregV "entkorken" "entkorkt" "entkorkte" "entkorkte" "entkorkt")  ;
  entkraeften_V2 = dirV2 (irregV "entkräften" "entkräftet" "entkräftete" "entkräftete" "entkräftet")  ;
  entlarven_als_V3 = dirV3 (irregV "entlarven" "entlarvt" "entlarvte" "entlarvte" "entlarvt") (mkPrep "als" accusative) ;
  entlassen_V2 = dirV2 (irregV "entlassen" "entlasst" "entließ" "entließe" "entlassen")  ;
  entledigen_gen_rV2 = reflV2 (irregV "entledigen" "entledigt" "entledigte" "entledigte" "entledigt") accusative genPrep ;
  entleeren_V2 = dirV2 (irregV "entleeren" "entleert" "entleerte" "entleerte" "entleert")  ;
  entleihen_V2 = dirV2 (irregV "entleihen" "entleiht" "entlieh" "entliehe" "entliehen")  ;
  entlogarithmieren_V2 = dirV2 (irregV "entlogarithmieren" "entlogarithmiert" "entlogarithmierte" "entlogarithmierte" "entlogarithmiert")  ;
  entlohnen_V2 = dirV2 (irregV "entlohnen" "entlohnt" "entlohnte" "entlohnte" "entlohnt")  ;
  entmachten_V2 = dirV2 (irregV "entmachten" "entmachtet" "entmachtete" "entmachtete" "entmachtet")  ;
  entmoenchen_V2 = dirV2 (irregV "entmönchen" "entmöncht" "entmönchte" "entmönchte" "entmöncht")  ;
  entmuendigen_V2 = dirV2 (irregV "entmündigen" "entmündigt" "entmündigte" "entmündigte" "entmündigt")  ;
  entmutigen_sV2 = dassV2 (irregV "entmutigen" "entmutigt" "entmutigte" "entmutigte" "entmutigt") accPrep ;
  entmutigen_V2 = dirV2 (irregV "entmutigen" "entmutigt" "entmutigte" "entmutigte" "entmutigt")  ;
  entnehmen_gen_V3 = dirV3 (irregV "entnehmen" "entnimmt" "entnahm" "entnähme" "entnommen") genPrep ;
  entnehmen_gen_VS2 = mkVS2 (irregV "entnehmen" "entnimmt" "entnahm" "entnähme" "entnommen") genPrep ;
  entpacken_V2 = dirV2 (irregV "entpacken" "entpackt" "entpackte" "entpackte" "entpackt")  ;
  entpersoenlichen_V2 = dirV2 (irregV "entpersönlichen" "entpersönlicht" "entpersönlichte" "entpersönlichte" "entpersönlicht")  ;
  entpflichten_von_V3 = dirV3 (irregV "entpflichten" "entpflichtet" "entpflichtete" "entpflichtete" "entpflichtet") von_Prep ;
  entrappen_V2 = dirV2 (irregV "entrappen" "entrappt" "entrappte" "entrappte" "entrappt")  ;
  entrauschen_V = irregV "entrauschen" "entrauscht" "entrauschte" "entrauschte" "entrauscht" ;
  entreissen_dat_V3 = accdatV3 (irregV "entreißen" "entreißt" "entriss" "entriss" "entrissen")  ;
  entrichten_V2 = dirV2 (irregV "entrichten" "entrichtet" "entrichtete" "entrichtete" "entrichtet")  ;
  entriegeln_V2 = dirV2 (irregV "entriegeln" "entriegelt" "entriegelte" "entriegelte" "entriegelt")  ;
  entrinnen_dat_V2 = mkV2 (irregV "entrinnen" "entrinnt" "entrann" "entränne" "entronnen") datPrep ;
  entruesten_ueber_rV2 = reflV2 (irregV "entrüsten" "entrüstet" "entrüstete" "entrüstete" "entrüstet") accusative (mkPrep "über" accusative) ;
  entsaften_V2 = dirV2 (irregV "entsaften" "entsaftet" "entsaftete" "entsaftete" "entsaftet")  ;
  entsalzen_V2 = dirV2 (irregV "entsalzen" "entsalzt" "entsalzte" "entsalzte" "entsalzt")  ;
  entschaerfen_V2 = dirV2 (irregV "entschärfen" "entschärft" "entschärfte" "entschärfte" "entschärft")  ;
  entschandeln_V2 = dirV2 (irregV "entschandeln" "entschandelt" "entschandelte" "entschandelte" "entschandelt")  ;
  entschanden_V2 = dirV2 (irregV "entschanden" "entschandet" "entschandete" "entschandete" "entschandet")  ;
  entscheiden_rV = reflV (irregV "entscheiden" "entscheidet" "entschied" "entschiede" "entschieden") accusative ;
  entscheiden_VQ = mkVQ (irregV "entscheiden" "entscheidet" "entschied" "entschiede" "entschieden")  ;
  entscheiden_VS = mkVS (irregV "entscheiden" "entscheidet" "entschied" "entschiede" "entschieden")  ;
  entschlagen_gen_rV2 = reflV2 (irregV "entschlagen" "entschlägt" "entschlug" "entschlug" "entschlagen") accusative genPrep ;
  entschliessen_zu_rV2 = reflV2 (irregV "entschließen" "entschließt" "entschloss" "entschloss" "entschlossen") accusative zu_Prep ;
  entschluesseln_V2 = dirV2 (irregV "entschlüsseln" "entschlüsselt" "entschlüsselte" "entschlüsselte" "entschlüsselt")  ;
  entschuhen_V2 = dirV2 (irregV "entschuhen" "entschuht" "entschuhte" "entschuhte" "entschuht")  ;
  entschuldigen_bei_fuer_rV3 = reflV3 (irregV "entschuldigen" "entschuldigt" "entschuldigte" "entschuldigte" "entschuldigt") accusative bei_Prep fuer_Prep ;
  entschuldigen_bei_mit_V4 = dirV4 (irregV "entschuldigen" "entschuldigt" "entschuldigte" "entschuldigte" "entschuldigt") bei_Prep mit_Prep ;
  entschuldigen_bei_V3 = dirV3 (irregV "entschuldigen" "entschuldigt" "entschuldigte" "entschuldigte" "entschuldigt") bei_Prep ;
  entsichern_V2 = dirV2 (irregV "entsichern" "entsichert" "entsicherte" "entsicherte" "entsichert")  ;
  entsorgen_V2 = dirV2 (irregV "entsorgen" "entsorgt" "entsorgte" "entsorgte" "entsorgt")  ;
  entspannen_rV = reflV (irregV "entspannen" "entspannt" "entspannte" "entspannte" "entspannt") accusative ;
  entsprechen_dat_V2 = mkV2 (irregV "entsprechen" "entsprecht" "entsprach" "entspräche" "entsprochen") datPrep ;
  entsprechen_rcV = reciV (irregV "entsprechen" "entsprecht" "entsprach" "entspräche" "entsprochen") dative ;
  entspringen_loc_V2 = prepV2 (irregV "entspringen" "entspringt" "entsprang" "entspränge" "entsprungen") loc_Prep ;
  entstaatlichen_V2 = dirV2 (irregV "entstaatlichen" "entstaatlicht" "entstaatlichte" "entstaatlichte" "entstaatlicht")  ;
  entstammen_gen_V2 = mkV2 (irregV "entstammen" "entstammt" "entstammte" "entstammte" "entstammt") genPrep ;
  entstehen_V = irregV "entstehen" "entsteht" "entstand" "entstände" "entstanden" ;
  enttabuisieren_V2 = dirV2 (irregV "enttabuisieren" "enttabuisiert" "enttabuisierte" "enttabuisierte" "enttabuisiert")  ;
  enttaeuschen_V2 = dirV2 (irregV "enttäuschen" "enttäuscht" "enttäuschte" "enttäuschte" "enttäuscht")  ;
  enttarnen_V2 = dirV2 (irregV "enttarnen" "enttarnt" "enttarnte" "enttarnte" "enttarnt")  ;
  entthronen_V2 = dirV2 (irregV "entthronen" "entthront" "entthronte" "entthronte" "entthront")  ;
  entvolken_V2 = dirV2 (irregV "entvolken" "entvolkt" "entvolkte" "entvolkte" "entvolkt")  ;
  entwaffnen_V2 = dirV2 (irregV "entwaffnen" "entwaffnet" "entwaffnte" "entwaffnte" "entwaffnt")  ;
  entwalden_V2 = dirV2 (irregV "entwalden" "entwaldet" "entwaldete" "entwaldete" "entwaldet")  ;
  entweihen_V2 = dirV2 (irregV "entweihen" "entweiht" "entweihte" "entweihte" "entweiht")  ;
  entwenden_V2 = dirV2 (irregV "entwenden" "entwendet" "entwendete" "entwendete" "entwendet")  ;
  entwerfen_V2 = dirV2 (irregV "entwerfen" "entwerft" "entwarf" "entwürfe" "entworfen")  ;
  entwickeln_V2 = dirV2 (irregV "entwickeln" "entwickelt" "entwickelte" "entwickelte" "entwickelt")  ;
  entwoehnen_gen_V3 = dirV3 (irregV "entwöhnen" "entwöhnt" "entwöhnte" "entwöhnte" "entwöhnt") genPrep ;
  entwoehnen_von_V3 = dirV3 (irregV "entwöhnen" "entwöhnt" "entwöhnte" "entwöhnte" "entwöhnt") von_Prep ;
  entziehen_dat_V3 = accdatV3 (irregV "entziehen" "entzieht" "entzog" "entzöge" "entzogen")  ;
  entzuenden_V2 = dirV2 (irregV "entzünden" "entzündet" "entzündete" "entzündete" "entzündet")  ;
  entzweibrechen_V = prefixV "entzwei" (irregV "brechen" "bricht" "brach" "bräche" "gebrochen") ;
  entzweien_mit_rV2 = reflV2 (irregV "entzweien" "entzweit" "entzweite" "entzweite" "entzweit") accusative mit_Prep ;
  entzweien_rV = reflV (irregV "entzweien" "entzweit" "entzweite" "entzweite" "entzweit") accusative ;
  entzweien_sV2 = dassV2 (irregV "entzweien" "entzweit" "entzweite" "entzweite" "entzweit") accPrep ;
  entzweien_V2 = dirV2 (irregV "entzweien" "entzweit" "entzweite" "entzweite" "entzweit")  ;
  epilieren_V2 = dirV2 (irregV "epilieren" "epiliert" "epilierte" "epilierte" "epiliert")  ;
--  epoxidieren_V = irregV "epoxidieren" "epoxidiert" "epoxidierte" "epoxidierte" "epoxidiert" ;
  erarbeiten_rV2 = reflV2 (irregV "erarbeiten" "erarbeitet" "erarbeitete" "erarbeitete" "erarbeitet") dative accPrep ;
  erbarmen_gen_rV2 = reflV2 (irregV "erbarmen" "erbarmt" "erbarmte" "erbarmte" "erbarmt") accusative genPrep ;
  erbauen_am_rV2 = reflV2 (irregV "erbauen" "erbaut" "erbaute" "erbaute" "erbaut") accusative (mkPrep "an" dative) ;
  erben_von_V3 = dirV3 (regV "erben") von_Prep ;
  erbieten_rVV = reflVV (irregV "erbieten" "erbietet" "erbot" "erböte" "erboten") accusative ;
  erbittern_sV2 = dassV2 (irregV "erbittern" "erbittert" "erbitterte" "erbittere" "erbittert") accPrep ;
  erbittern_V2 = dirV2 (irregV "erbittern" "erbittert" "erbitterte" "erbittere" "erbittert")  ;
  erblassen_V = irregV "erblassen" "erblasst" "erblasste" "erblasste" "erblasst" ;
  erbleichen_V = irregV "erbleichen" "erbleicht" "erbleichte" "erbleichte" "erbleicht" ;
  erbosen_sV2 = dassV2 (irregV "erbosen" "erbost" "erboste" "erboste" "erbost") accPrep ;
  erbosen_ueber_rV2 = reflV2 (irregV "erbosen" "erbost" "erboste" "erboste" "erbost") accusative (mkPrep "über" accusative) ;
  erbosen_V2 = dirV2 (irregV "erbosen" "erbost" "erboste" "erboste" "erbost")  ;
  erbrechen_V2 = dirV2 (irregV "erbrechen" "erbrecht" "erbrach" "erbräche" "erbrochen")  ;
  erbrechen_V = irregV "erbrechen" "erbrecht" "erbrach" "erbräche" "erbrochen" ;
  erbringen_V2 = dirV2 (irregV "erbringen" "erbringt" "erbrachte" "erbrächte" "erbracht")  ;
  erdenken_V2 = dirV2 (irregV "erdenken" "erdenkt" "erdachte" "erdächte" "erdacht")  ;
  erdolchen_V2 = dirV2 (irregV "erdolchen" "erdolcht" "erdolchte" "erdolchte" "erdolcht")  ;
  erdreisten_rVV = reflVV (irregV "erdreisten" "erdreistt" "erdreistte" "erdreistete" "erdreistet") accusative ;
  erdrosseln_V2 = dirV2 (irregV "erdrosseln" "erdrosselt" "erdrosselte" "erdrosselte" "erdrosselt")  ;
  erfahren_VS = mkVS (irregV "erfahren" "erfahrt" "erfuhr" "erführe" "erfahren")  ;
  erfassen_V2 = dirV2 (irregV "erfassen" "erfasst" "erfasste" "erfasste" "erfasst")  ;
  erfassen_VS = mkVS (irregV "erfassen" "erfasst" "erfasste" "erfasste" "erfasst")  ;
  erfinden_V2 = dirV2 (irregV "erfinden" "erfindet" "erfand" "erfände" "erfunden")  ;
  erfolgen_sV = dassV (irregV "erfolgen" "erfolgt" "erfolgte" "erfolgte" "erfolgt")  ;
  erfolgen_V = irregV "erfolgen" "erfolgt" "erfolgte" "erfolgte" "erfolgt" ;
  erfordern_V2 = dirV2 (irregV "erfordern" "erfordert" "erforderte" "erforderte" "erfordert")  ;
  erfragen_V2 = dirV2 (irregV "erfragen" "erfragt" "erfragte" "erfragte" "erfragt")  ;
  erfragen_VQ = mkVQ (irregV "erfragen" "erfragt" "erfragte" "erfragte" "erfragt")  ;
  erfrechen_rVV = reflVV (irregV "erfrechen" "erfrecht" "erfrechte" "erfrechte" "erfrecht") accusative ;
  erfreuen_gen_rV2 = reflV2 (irregV "erfreuen" "erfreut" "erfreute" "erfreute" "erfreut") accusative genPrep ;
  erfuehlen_V2 = dirV2 (irregV "erfühlen" "erfühlt" "erfühlte" "erfühlte" "erfühlt")  ;
  erfuellen_V2 = dirV2 (irregV "erfüllen" "erfüllt" "erfüllte" "erfüllte" "erfüllt")  ;
  ergaenzen_durch_V3 = dirV3 (irregV "ergänzen" "ergänzt" "ergänzte" "ergänzte" "ergänzt") durch_Prep ;
  ergaenzen_mit_V3 = dirV3 (irregV "ergänzen" "ergänzt" "ergänzte" "ergänzte" "ergänzt") mit_Prep ;
  ergattern_V2 = dirV2 (irregV "ergattern" "ergattert" "ergatterte" "ergattere" "ergattert")  ;
  ergaunern_V2 = dirV2 (irregV "ergaunern" "ergaunert" "ergaunerte" "ergaunerte" "ergaunert")  ;
  ergeben_dat_rV2 = reflV2 (irregV "ergeben" "ergebt" "ergab" "ergäbe" "ergeben") accusative datPrep ;
  ergetzen_am_V2 = prepV2 (irregV "ergetzen" "ergetzt" "ergetzte" "ergetzte" "ergetzt") (mkPrep "an" dative) ;
  ergiessen_in_V2 = prepV2 (irregV "ergießen" "ergießt" "ergoss" "ergösse" "ergossen") (mkPrep "in" accusative) ;
  ergiessen_ueber_V2 = prepV2 (irregV "ergießen" "ergießt" "ergoss" "ergösse" "ergossen") (mkPrep "über" accusative) ;
  ergoetzen_sV2 = dassV2 (irregV "ergötzen" "ergötzt" "ergötzte" "ergötzte" "ergötzt") accPrep ;
  ergoetzen_V2 = dirV2 (irregV "ergötzen" "ergötzt" "ergötzte" "ergötzte" "ergötzt")  ;
  ergrauen_V = irregV "ergrauen" "ergraut" "ergraute" "ergraute" "ergraut" ;
  ergreifen_V2 = dirV2 (irregV "ergreifen" "ergreift" "ergriff" "ergriffe" "ergriffen")  ;
  ergreifen_zu_V3 = dirV3 (irregV "ergreifen" "ergreift" "ergriff" "ergriffe" "ergriffen") zu_Prep ;
  ergrimmen_V = irregV "ergrimmen" "ergrimmt" "ergrimmte" "ergrimmte" "ergrimmt" ;
  ergruenden_V2 = dirV2 (irregV "ergründen" "ergründet" "ergründete" "ergründete" "ergründet")  ;
  erhaengen_rV = reflV (irregV "erhängen" "erhängt" "erhängte" "erhängte" "erhängt") accusative ;
  erhaengen_V2 = dirV2 (irregV "erhängen" "erhängt" "erhängte" "erhängte" "erhängt")  ;
  erhalten_V2 = dirV2 (irregV "erhalten" "erhält" "erhielt" "erhielte" "erhalten")  ;
  erhausen_V2 = dirV2 (irregV "erhausen" "erhaust" "erhauste" "erhauste" "erhaust")  ;
  erheben_rV = reflV (irregV "erheben" "erhebt" "erhob" "erhöbe" "erhoben") accusative ;
  erheischen_V2 = dirV2 (irregV "erheischen" "erheischt" "erheischte" "erheischte" "erheischt")  ;
  erheitern_sV2 = dassV2 (irregV "erheitern" "erheitert" "erheiterte" "erheiterte" "erheitert") accPrep ;
  erheitern_V2 = dirV2 (irregV "erheitern" "erheitert" "erheiterte" "erheiterte" "erheitert")  ;
  erhitzen_V2 = dirV2 (irregV "erhitzen" "erhitzt" "erhitzte" "erhitzte" "erhitzt")  ;
  erhoehen_V2 = dirV2 (irregV "erhöhen" "erhöht" "erhöhte" "erhöhte" "erhöht")  ;
  erhoeren_V2 = dirV2 (irregV "erhören" "erhört" "erhörte" "erhörte" "erhört")  ;
  erholen_rV = reflV (irregV "erholen" "erholt" "erholte" "erholte" "erholt") accusative ;
  erigieren_V = irregV "erigieren" "erigiert" "erigierte" "erigierte" "erigiert" ;
  erinnern_an_rV2 = reflV2 (irregV "erinnern" "erinnert" "erinnerte" "erinnerte" "erinnert") accusative (mkPrep "an" accusative) ;
  erinnern_an_V3 = dirV3 (irregV "erinnern" "erinnert" "erinnerte" "erinnerte" "erinnert") (mkPrep "an" accusative) ;
  erinnern_gen_rV2 = reflV2 (irregV "erinnern" "erinnert" "erinnerte" "erinnerte" "erinnert") accusative genPrep ;
  erkalten_V = irregV "erkalten" "erkaltet" "erkaltete" "erkaltete" "erkaltet" ;
  erkennen_V2 = dirV2 (irregV "erkennen" "erkennt" "erkannte" "erkannte" "erkannt")  ;
  erkennen_VS = mkVS (irregV "erkennen" "erkennt" "erkannte" "erkannte" "erkannt")  ;
  erkiesen_zu_V3 = dirV3 (irregV "erkiesen" "erkiest" "erkor" "erköre" "erkoren") zu_Prep ;
  erklaeren_dat_V2S = mkV2S (irregV "erklären" "erklärt" "erklärte" "erklärte" "erklärt") datPrep ;
  erklaeren_dat_V3 = accdatV3 (irregV "erklären" "erklärt" "erklärte" "erklärte" "erklärt")  ;
  erklimmen_V2 = dirV2 (irregV "erklimmen" "erklimmt" "erklomm" "erklömme" "erklommen")  ;
  erkobern_V2 = dirV2 (irregV "erkobern" "erkobert" "erkoberte" "erkoberte" "erkobert")  ;
  erkranken_V = irregV "erkranken" "erkrankt" "erkrankte" "erkrankte" "erkrankt" ;
  erkundigen_nach_rV2 = reflV2 (irregV "erkundigen" "erkundigt" "erkundigte" "erkundigte" "erkundigt") accusative nach_Prep ;
  erkundigen_ueber_rV2 = reflV2 (irregV "erkundigen" "erkundigt" "erkundigte" "erkundigte" "erkundigt") accusative (mkPrep "über" accusative) ;
  erlaeutern_dat_V2S = mkV2S (irregV "erläutern" "erläutert" "erläuterte" "erläutere" "erläutert") datPrep ;
  erlaeutern_dat_V3 = accdatV3 (irregV "erläutern" "erläutert" "erläuterte" "erläutere" "erläutert")  ;
  erlangen_V2 = dirV2 (irregV "erlangen" "erlangt" "erlangte" "erlangte" "erlangt")  ;
  erlassen_dat_V3 = accdatV3 (irregV "erlassen" "erlasst" "erließ" "erließe" "erlassen")  ;
  erlassen_V2 = dirV2 (irregV "erlassen" "erlasst" "erließ" "erließe" "erlassen")  ;
  erlauben_dat_V2S = mkV2S (irregV "erlauben" "erlaubt" "erlaubte" "erlaubte" "erlaubt") datPrep ;
  erlauben_dat_V3 = accdatV3 (irregV "erlauben" "erlaubt" "erlaubte" "erlaubte" "erlaubt")  ;
  erleben_V2 = dirV2 (irregV "erleben" "erlebt" "erlebte" "erlebte" "erlebt")  ;
  erleben_VS = mkVS (irregV "erleben" "erlebt" "erlebte" "erlebte" "erlebt")  ;
  erledigen_sV2 = dassV2 (irregV "erledigen" "erledigt" "erledigte" "erledigte" "erledigt") accPrep ;
  erledigen_V2 = dirV2 (irregV "erledigen" "erledigt" "erledigte" "erledigte" "erledigt")  ;
  erledigen_VV = mkVV (irregV "erledigen" "erledigt" "erledigte" "erledigte" "erledigt")  ;
  erlegen_V2 = dirV2 (irregV "erlegen" "erlegt" "erlegte" "erlegte" "erlegt")  ;
  erleichtern_dat_V2S = mkV2S (irregV "erleichtern" "erleichtert" "erleichterte" "erleichtere" "erleichtert") datPrep ;
  erleichtern_dat_V3 = accdatV3 (irregV "erleichtern" "erleichtert" "erleichterte" "erleichtere" "erleichtert")  ;
  erleichtern_rV = reflV (irregV "erleichtern" "erleichtert" "erleichterte" "erleichtere" "erleichtert") accusative ;
  erleiden_V2 = dirV2 (irregV "erleiden" "erleidet" "erlitt" "erlitte" "erlitten")  ;
  erlernen_V2 = dirV2 (irregV "erlernen" "erlernt" "erlernte" "erlernte" "erlernt")  ;
  erlesen_rV2 = reflV2 (irregV "erlesen" "erlest" "erlas" "erläse" "erlesen") accusative accPrep ;
  erleuchten_V2 = dirV2 (irregV "erleuchten" "erleuchtet" "erleuchtete" "erleuchtete" "erleuchtet")  ;
  erloeschen_V = irregV "erlöschen" "erlöscht" "erlosch" "erlösche" "erloschen" ;
  erloesen_V2 = dirV2 (irregV "erlösen" "erlöst" "erlöste" "erlöste" "erlöst")  ;
  ermaechtigen_zu_V3 = dirV3 (irregV "ermächtigen" "ermächtigt" "ermächtigte" "ermächtigte" "ermächtigt") zu_Prep ;
  ermatten_sV2 = dassV2 (irregV "ermatten" "ermattet" "ermattete" "ermattete" "ermattet") accPrep ;
  ermatten_V2 = dirV2 (irregV "ermatten" "ermattet" "ermattete" "ermattete" "ermattet")  ;
  ermatten_V = irregV "ermatten" "ermattet" "ermattete" "ermattete" "ermattet" ;
  ermitteln_im_V2 = prepV2 (irregV "ermitteln" "ermittelt" "ermittelte" "ermittele" "ermittelt") (mkPrep "in" dative) ;
  ermoeglichen_dat_V2V = mkV2V (irregV "ermöglichen" "ermöglicht" "ermöglichte" "ermöglichte" "ermöglicht") datPrep ;
  ermoeglichen_dat_V3 = accdatV3 (irregV "ermöglichen" "ermöglicht" "ermöglichte" "ermöglichte" "ermöglicht")  ;
  ermorden_V2 = dirV2 (irregV "ermorden" "ermordet" "ermordete" "ermordete" "ermordet")  ;
  ermueden_V = irregV "ermüden" "ermüdet" "ermüdete" "ermüdete" "ermüdet" ;
  ermuntern_sV2 = dassV2 (irregV "ermuntern" "ermuntert" "ermunterte" "ermuntere" "ermuntert") accPrep ;
  ermuntern_V2 = dirV2 (irregV "ermuntern" "ermuntert" "ermunterte" "ermuntere" "ermuntert")  ;
  ermuntern_zu_V3 = dirV3 (irregV "ermuntern" "ermuntert" "ermunterte" "ermuntere" "ermuntert") zu_Prep ;
  ermutigen_zu_V3 = dirV3 (irregV "ermutigen" "ermutigt" "ermutigte" "ermutigte" "ermutigt") zu_Prep ;
  ernaehren_V2 = dirV2 (irregV "ernähren" "ernährt" "ernährte" "ernährte" "ernährt")  ;
  ernennen_zu_V3 = dirV3 (irregV "ernennen" "ernennt" "ernannte" "ernannte" "ernannt") zu_Prep ;
  erneuen_V2 = dirV2 (irregV "erneuen" "erneut" "erneute" "erneute" "erneut")  ;
  erneuern_V2 = dirV2 (irregV "erneuern" "erneuert" "erneuerte" "erneuerte" "erneuert")  ;
  erniedrigen_sV2 = dassV2 (irregV "erniedrigen" "erniedrigt" "erniedrigte" "erniedrigte" "erniedrigt") accPrep ;
  erniedrigen_V2 = dirV2 (irregV "erniedrigen" "erniedrigt" "erniedrigte" "erniedrigte" "erniedrigt")  ;
  ernten_V2 = dirV2 (regV "ernten")  ;
  erobern_V2 = dirV2 (irregV "erobern" "erobert" "eroberte" "eroberte" "erobert")  ;
  erodieren_V = irregV "erodieren" "erodiert" "erodierte" "erodierte" "erodiert" ;
  eroeffnen_V2 = dirV2 (irregV "eröffnen" "eröffnet" "eröffnete" "eröffnete" "eröffnet")  ;
  eroertern_V2 = dirV2 (irregV "erörtern" "erörtert" "erörterte" "erörterte" "erörtert")  ;
  eroertern_VQ = mkVQ (irregV "erörtern" "erörtert" "erörterte" "erörterte" "erörtert")  ;
  erotisieren_sV2 = dassV2 (irregV "erotisieren" "erotisiert" "erotisierte" "erotisierte" "erotisiert") accPrep ;
  erotisieren_V2 = dirV2 (irregV "erotisieren" "erotisiert" "erotisierte" "erotisierte" "erotisiert")  ;
  erpflegen_V2 = dirV2 (irregV "erpflegen" "erpflegt" "erpflegte" "erpflegte" "erpflegt")  ;
  erpressen_V2 = dirV2 (irregV "erpressen" "erpresst" "erpresste" "erpresste" "erpresst")  ;
  erproben_V2 = dirV2 (irregV "erproben" "erprobt" "erprobte" "erprobte" "erprobt")  ;
  erquicken_V2 = dirV2 (irregV "erquicken" "erquickt" "erquickte" "erquickte" "erquickt")  ;
  erraten_V2 = dirV2 (irregV "erraten" "errät" "erriet" "erriete" "erraten")  ;
  erraten_VQ = mkVQ (irregV "erraten" "errät" "erriet" "erriete" "erraten")  ;
  erraten_VS = mkVS (irregV "erraten" "errät" "erriet" "erriete" "erraten")  ;
  erregen_V2 = dirV2 (irregV "erregen" "erregt" "erregte" "erregte" "erregt")  ;
  erreichen_V2 = dirV2 (irregV "erreichen" "erreicht" "erreichte" "erreichte" "erreicht")  ;
  erreichen_VS = mkVS (irregV "erreichen" "erreicht" "erreichte" "erreichte" "erreicht")  ;
  errichten_V2 = dirV2 (irregV "errichten" "errichtet" "errichtete" "errichte" "errichtet")  ;
  erroeten_V = irregV "erröten" "errötet" "errötete" "errötete" "errötet" ;
  ersaufen_V2 = dirV2 (irregV "ersaufen" "ersäuft" "ersoff" "ersoff" "ersoffen")  ;
  erschachern_rV2 = reflV2 (irregV "erschachern" "erschachert" "erschacherte" "erschacherte" "erschachert") dative accPrep ;
  erschachern_V2 = dirV2 (irregV "erschachern" "erschachert" "erschacherte" "erschacherte" "erschachert")  ;
  erschaffen_V2 = dirV2 (irregV "erschaffen" "erschafft" "erschuf" "erschüfe" "erschaffen")  ;
  erscheinen_loc_V2 = prepV2 (irregV "erscheinen" "erscheint" "erschien" "erschiene" "erschienen") loc_Prep ;
  erscheinen_V = irregV "erscheinen" "erscheint" "erschien" "erschiene" "erschienen" ;
  erschiessen_V2 = dirV2 (irregV "erschießen" "erschießt" "erschoss" "erschoss" "erschossen")  ;
  erschlaffen_sV2 = dassV2 (irregV "erschlaffen" "erschlafft" "erschlaffte" "erschlaffte" "erschlafft") accPrep ;
  erschlaffen_V2 = dirV2 (irregV "erschlaffen" "erschlafft" "erschlaffte" "erschlaffte" "erschlafft")  ;
  erschlagen_V2 = dirV2 (irregV "erschlagen" "erschlägt" "erschlug" "erschlug" "erschlagen")  ;
  erschleichen_rV2 = reflV2 (irregV "erschleichen" "erschleicht" "erschlich" "erschliche" "erschlichen") dative accPrep ;
  erschleichen_V2 = dirV2 (irregV "erschleichen" "erschleicht" "erschlich" "erschliche" "erschlichen")  ;
  erschliessen_dat_rV2 = reflV2 (irregV "erschließen" "erschließt" "erschloss" "erschlösse" "erschlossen") accusative datPrep ;
  erschliessen_V2 = dirV2 (irregV "erschließen" "erschließt" "erschloss" "erschlösse" "erschlossen")  ;
  erschoepfen_V2 = dirV2 (irregV "erschöpfen" "erschöpft" "erschöpfte" "erschöpfte" "erschöpft")  ;
  erschrecken_V2 = dirV2 (irregV "erschrecken" "erschreckt" "erschreckte" "erschreckte" "erschreckt")  ;
  erschrecken_V = irregV "erschrecken" "erschreckt" "erschreckte" "erschreckte" "erschreckt" ;
  erschrecken_vor_V2 = prepV2 (irregV "erschrecken" "erschreckt" "erschreckte" "erschreckte" "erschreckt") (mkPrep "vor" dative) ;
  erschuettern_V2 = dirV2 (irregV "erschüttern" "erschüttert" "erschütterte" "erschüttere" "erschüttert")  ;
  erschweren_sVS = dassVS (irregV "erschweren" "erschwert" "erschwerte" "erschwerte" "erschwert")  ;
  erschweren_V2 = dirV2 (irregV "erschweren" "erschwert" "erschwerte" "erschwerte" "erschwert")  ;
  ersetzen_durch_V3 = dirV3 (irregV "ersetzen" "ersetzt" "ersetzte" "ersetzte" "ersetzt") (mkPrep "durch" accusative) ;
  ersetzen_V2 = dirV2 (irregV "ersetzen" "ersetzt" "ersetzte" "ersetzte" "ersetzt")  ;
  ersinnen_V2 = dirV2 (irregV "ersinnen" "ersinnt" "ersann" "ersänne" "ersonnen")  ;
  ersitzen_rV2 = reflV2 (irregV "ersitzen" "ersitzt" "ersaß" "ersäße" "ersessen") dative accPrep ;
  ersorgen_V2 = dirV2 (irregV "ersorgen" "ersorgt" "ersorgte" "ersorgte" "ersorgt")  ;
  erstarren_V = irregV "erstarren" "erstarrt" "erstarrte" "erstarrte" "erstarrt" ;
  erstatten_dat_V3 = accdatV3 (irregV "erstatten" "erstattet" "erstattete" "erstattete" "erstattet")  ;
  erstaunen_sV2 = dassV2 (irregV "erstaunen" "erstaunt" "erstaunte" "erstaunte" "erstaunt") accPrep ;
  erstaunen_V = irregV "erstaunen" "erstaunt" "erstaunte" "erstaunte" "erstaunt" ;
  erstechen_V2 = dirV2 (irregV "erstechen" "erstecht" "erstach" "erstäche" "erstochen")  ;
  erstehen_V2 = dirV2 (irregV "erstehen" "ersteht" "erstand" "erstände" "erstanden")  ;
  ersteigen_V2 = dirV2 (irregV "ersteigen" "ersteigt" "erstieg" "erstiege" "erstiegen")  ;
  erstellen_V2 = dirV2 (irregV "erstellen" "erstellt" "erstellte" "erstelle" "erstellt")  ;
  ersticken_V = irregV "ersticken" "erstickt" "erstickte" "erstickte" "erstickt" ;
  erstreben_V2 = dirV2 (irregV "erstreben" "erstrebt" "erstrebte" "erstrebte" "erstrebt")  ;
  erstrecken_ueber_rV2 = reflV2 (irregV "erstrecken" "erstreckt" "erstreckte" "erstreckte" "erstreckt") accusative (mkPrep "über" accusative) ;
  ersuchen_um_V3 = dirV3 (irregV "ersuchen" "ersucht" "ersuchte" "ersuchte" "ersucht") um_Prep ;
  ertappen_bei_V3 = dirV3 (irregV "ertappen" "ertappt" "ertappte" "ertappte" "ertappt") bei_Prep ;
  erteilen_dat_V3 = accdatV3 (irregV "erteilen" "erteilt" "erteilte" "erteilte" "erteilt")  ;
  ertoenen_V = irregV "ertönen" "ertönt" "ertönte" "ertönte" "ertönt" ;
  ertraenken_V2 = dirV2 (irregV "ertränken" "ertränkt" "ertränkte" "ertränkte" "ertränkt")  ;
  ertragen_V2 = dirV2 (irregV "ertragen" "ertragt" "ertrug" "ertrüge" "ertragen")  ;
  ertragen_VS = mkVS (irregV "ertragen" "ertragt" "ertrug" "ertrüge" "ertragen")  ;
  ertrinken_V = irregV "ertrinken" "ertrinkt" "ertrank" "ertränke" "ertrunken" ;
  ertuechtigen_rV = reflV (irregV "ertüchtigen" "ertüchtigt" "ertüchtigte" "ertüchtigte" "ertüchtigt") accusative ;
  ertuechtigen_sV2 = dassV2 (irregV "ertüchtigen" "ertüchtigt" "ertüchtigte" "ertüchtigte" "ertüchtigt") accPrep ;
  eruebrigen_V2 = dirV2 (irregV "erübrigen" "erübrigt" "erübrigte" "erübrigte" "erübrigt")  ;
  eruieren_V2 = dirV2 (irregV "eruieren" "eruiert" "eruierte" "eruierte" "eruiert")  ;
  eruieren_VS = mkVS (irregV "eruieren" "eruiert" "eruierte" "eruierte" "eruiert")  ;
  erwachen_V = irregV "erwachen" "erwacht" "erwachte" "erwachte" "erwacht" ;
  erwachsen_dat_V2 = mkV2 (irregV "erwachsen" "erwachst" "erwuchs" "erwüchse" "erwachsen") datPrep ;
  erwaegen_V2 = dirV2 (irregV "erwägen" "erwägt" "erwog" "erwöge" "erwogen")  ;
  erwaegen_VQ = mkVQ (irregV "erwägen" "erwägt" "erwog" "erwöge" "erwogen")  ;
  erwaehnen_V2 = dirV2 (irregV "erwähnen" "erwähnt" "erwähnte" "erwähnte" "erwähnt")  ;
  erwaehnen_VS = mkVS (irregV "erwähnen" "erwähnt" "erwähnte" "erwähnte" "erwähnt")  ;
  erwaermen_fuer_rV2 = reflV2 (irregV "erwärmen" "erwärmt" "erwärmte" "erwärmte" "erwärmt") accusative fuer_Prep ;
  erwaermen_V2 = dirV2 (irregV "erwärmen" "erwärmt" "erwärmte" "erwärmte" "erwärmt")  ;
  erwahren_V2 = dirV2 (irregV "erwahren" "erwahrt" "erwahrte" "erwahrte" "erwahrt")  ;
  erwarten_V2 = dirV2 (irregV "erwarten" "erwartet" "erwartete" "erwarte" "erwartet")  ;
  erwarten_von_rV3 = reflV3 (irregV "erwarten" "erwartet" "erwartete" "erwarte" "erwartet") accusative accPrep von_Prep ;
  erweichen_V2 = dirV2 (irregV "erweichen" "erweicht" "erweichte" "erweichte" "erweicht")  ;
  erweisen_dat_V3 = accdatV3 (irregV "erweisen" "erweist" "erwies" "erwiese" "erwiesen")  ;
  erweitern_V2 = dirV2 (irregV "erweitern" "erweitert" "erweiterte" "erweiterte" "erweitert")  ;
  erwerben_V2 = dirV2 (irregV "erwerben" "erwerbt" "erwarb" "erwürbe" "erworben")  ;
  erwidern_VS = mkVS (irregV "erwidern" "erwidert" "erwiderte" "erwiderte" "erwidert")  ;
  erwischen_bei_V3 = dirV3 (irregV "erwischen" "erwischt" "erwischte" "erwischte" "erwischt") bei_Prep ;
  erzaehlen_dat_V2S = mkV2S (irregV "erzählen" "erzählt" "erzählte" "erzählte" "erzählt") datPrep ;
  erzaehlen_dat_V3 = accdatV3 (irregV "erzählen" "erzählt" "erzählte" "erzählte" "erzählt")  ;
  erzaehlen_V2 = dirV2 (irregV "erzählen" "erzählt" "erzählte" "erzählte" "erzählt")  ;
  erzaehlen_VS = mkVS (irregV "erzählen" "erzählt" "erzählte" "erzählte" "erzählt")  ;
  erzen_V2 = dirV2 (irregV "erzen" "erzt" "erzte" "erzte" "geerzt")  ;
  erzeugen_V2 = dirV2 (irregV "erzeugen" "erzeugt" "erzeugte" "erzeugte" "erzeugt")  ;
  erziehen_V2 = dirV2 (irregV "erziehen" "erzieht" "erzog" "erzöge" "erzogen")  ;
  erzielen_V2 = dirV2 (irregV "erzielen" "erzielt" "erzielte" "erzielte" "erzielt")  ;
  erzuernen_V = irregV "erzürnen" "erzürnt" "erzürnte" "erzürnte" "erzürnt" ;
  eskalieren_V = irregV "eskalieren" "eskaliert" "eskalierte" "eskalierte" "eskaliert" ;
  eskortieren_V2 = dirV2 (irregV "eskortieren" "eskortiert" "eskortierte" "eskortierte" "eskortiert")  ;
  essen_V2 = dirV2 (irregV "essen" "esst" "aß" "äße" "gegessen")  ;
  etablieren_loc_V3 = dirV3 (irregV "etablieren" "etabliert" "etablierte" "etablierte" "etabliert") loc_Prep ;
  etiolieren_V = irregV "etiolieren" "etioliert" "etiolierte" "etiolierte" "etioliert" ;
  eulanisieren_V2 = dirV2 (irregV "eulanisieren" "eulanisiert" "eulanisierte" "eulanisierte" "eulanisiert")  ;
  euphorisieren_sV2 = dassV2 (regV "euphorisieren") accPrep ;
  euphorisieren_V2 = dirV2 (regV "euphorisieren")  ;
  europaeisieren_sV2 = dassV2 (irregV "europäisieren" "europäisiert" "europäisierte" "europäisierte" "europäisiert") accPrep ;
  europaeisieren_V2 = dirV2 (irregV "europäisieren" "europäisiert" "europäisierte" "europäisierte" "europäisiert")  ;
  evakuieren_aus_V3 = dirV3 (irregV "evakuieren" "evakuiert" "evakuierte" "evakuierte" "evakuiert") aus_Prep ;
  evakuieren_dir_V3 = dirV3 (irregV "evakuieren" "evakuiert" "evakuierte" "evakuierte" "evakuiert") dir_Prep ;
  evakuieren_V2 = dirV2 (irregV "evakuieren" "evakuiert" "evakuierte" "evakuierte" "evakuiert")  ;
  evaluieren_V2 = dirV2 (irregV "evaluieren" "evaluiert" "evaluierte" "evaluierte" "evaluiert")  ;
  evangelisieren_V2 = dirV2 (regV "evangelisieren")  ;
  evaporisieren_V = regV "evaporisieren" ;
  evozieren_V2 = dirV2 (regV "evozieren")  ;
  examinieren_V2 = dirV2 (regV "examinieren")  ;
  exekutieren_V2 = dirV2 (regV "exekutieren")  ;
  exemplifizieren_am_V3 = dirV3 (regV "exemplifizieren") (mkPrep "an" dative) ;
  exemplifizieren_am_VS2 = mkVS2 (regV "exemplifizieren") (mkPrep "an" dative) ;
  exerzieren_V = regV "exerzieren" ;
  exhalieren_V2 = dirV2 (regV "exhalieren")  ;
  exhumieren_V2 = dirV2 (regV "exhumieren")  ;
  existieren_V = irregV "existieren" "existiert" "existierte" "existierte" "existiert" ;
  exkludieren_V2 = dirV2 (irregV "exkludieren" "exkludiert" "exkludierte" "exkludierte" "exkludiert")  ;
  exkommunizieren_V2 = dirV2 (irregV "exkommunizieren" "exkommuniziert" "exkommunizierte" "exkommunizierte" "exkommuniziert")  ;
  exkulpieren_sV2 = dassV2 (regV "exkulpieren") accPrep ;
  exkulpieren_V2 = dirV2 (regV "exkulpieren")  ;
  exmatrikulieren_aus_V3 = dirV3 (regV "exmatrikulieren") aus_Prep ;
  expandieren_V = regV "expandieren" ;
  expatriieren_V2 = dirV2 (regV "expatriieren")  ;
  experimentieren_mit_V2 = prepV2 (regV "experimentieren") mit_Prep ;
  explizieren_V2 = dirV2 (regV "explizieren")  ;
  explizieren_VS = mkVS (regV "explizieren")  ;
  explodieren_V = regV "explodieren" ;
  exponenzieren_V2 = dirV2 (regV "exponenzieren")  ;
  exponieren_V2 = dirV2 (regV "exponieren")  ;
  exportieren_V2 = dirV2 (regV "exportieren")  ;
  expressivieren_V = regV "expressivieren" ;
  exprimieren_V2 = dirV2 (regV "exprimieren")  ;
  extemporieren_V = regV "extemporieren" ;
  exterminieren_V2 = dirV2 (regV "exterminieren")  ;
  externalisieren_V2 = dirV2 (regV "externalisieren")  ;
  extrahieren_V2 = dirV2 (regV "extrahieren")  ;
  extrudieren_V2 = dirV2 (regV "extrudieren")  ;
  exzerpieren_V2 = dirV2 (regV "exzerpieren")  ;
  fabrizieren_V2 = dirV2 (regV "fabrizieren")  ;
  fabulieren_V = regV "fabulieren" ;
  fabulieren_VS = mkVS (regV "fabulieren")  ;
  faecheln_mit_V2 = prepV2 (regV "fächeln") mit_Prep ;
  faedeln_durch_V3 = dirV3 (regV "fädeln") (mkPrep "durch" accusative) ;
  faedeln_V2 = dirV2 (regV "fädeln")  ;
  faellen_V2 = dirV2 (regV "fällen")  ;
  faelschen_V2 = dirV2 (regV "fälschen")  ;
  faerben_V2 = dirV2 (regV "färben")  ;
  fahnden_nach_V2 = prepV2 (regV "fahnden") nach_Prep ;
  fahren_dir_V2 = prepV2 (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren") dir_Prep ;
  fahren_dir_V3 = dirV3 (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren") dir_Prep ;
  fahren_V2 = dirV2 (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren")  ;
  faksimilieren_V2 = dirV2 (regV "faksimilieren")  ;
  fakturieren_V2 = dirV2 (regV "fakturieren")  ;
  fallen_V = irregV "fallen" "fallt" "fiel" "fiele" "gefallen" ;
  fallieren_V = regV "fallieren" ;
  falsifizieren_V2 = dirV2 (regV "falsifizieren")  ;
  falsifizieren_VS = mkVS (regV "falsifizieren")  ;
  falten_V2 = dirV2 (regV "falten")  ;
  famulieren_V = regV "famulieren" ;
  fanatisieren_V2 = dirV2 (regV "fanatisieren")  ;
  fangen_V2 = dirV2 (irregV "fangen" "fangt" "fing" "finge" "gefangen")  ;
  fantasieren_V2 = dirV2 (regV "fantasieren")  ;
  fantasieren_VS = mkVS (regV "fantasieren")  ;
  faschieren_V2 = dirV2 (regV "faschieren")  ;
  faseln_V2 = dirV2 (regV "faseln")  ;
  faseln_VS = mkVS (regV "faseln")  ;
  fassen_dir_V2 = prepV2 (regV "fassen") dir_Prep ;
  fassen_V2 = dirV2 (regV "fassen")  ;
  fasten_V = regV "fasten" ;
  faszinieren_sV2 = dassV2 (regV "faszinieren") accPrep ;
  faszinieren_V2 = dirV2 (regV "faszinieren")  ;
  fauchen_V = regV "fauchen" ;
  faulen_V = regV "faulen" ;
  faulenzen_V = regV "faulenzen" ;
  faulenzern_V = regV "faulenzern" ;
  favorisieren_V2 = dirV2 (regV "favorisieren")  ;
  favorisieren_VS = mkVS (regV "favorisieren")  ;
  fechten_gegen_V2 = prepV2 (irregV "fechten" "ficht" "focht" "föchte" "gefochten") gegen_Prep ;
  fechten_mit_V2 = prepV2 (irregV "fechten" "ficht" "focht" "föchte" "gefochten") mit_Prep ;
  fegen_V2 = dirV2 (regV "fegen")  ;
  fehlen_dat_sV2 = dassV2 (regV "fehlen") datPrep ;
  fehlen_dat_V2 = mkV2 (regV "fehlen") datPrep ;
  fehlschlagen_iV = infzuV (irregV "fehlschlagen" "schlagt" "schlug" "schlüge" "geschlagen")  ;
  fehlschlagen_V = irregV "fehlschlagen" "schlagt" "schlug" "schlüge" "geschlagen" ;
  feien_gegen_V3 = dirV3 (regV "feien") gegen_Prep ;
  feiern_V2 = dirV2 (regV "feiern")  ;
  feiern_VS = mkVS (regV "feiern")  ;
  feilbieten_dat_V3 = accdatV3 (prefixV "feil" (irregV "bieten" "bietet" "bot" "böte" "geboten"))  ;
  feilen_am_V2 = prepV2 (regV "feilen") (mkPrep "an" dative) ;
  feilen_durch_V3 = dirV3 (regV "feilen") durch_Prep ;
  feilen_in_V3 = dirV3 (regV "feilen") (mkPrep "in" accusative) ;
  feilhalten_V2 = dirV2 (prefixV "feil" (irregV "halten" "hält" "hielt" "hielte" "gehalten"))  ;
  feilschen_mit_um_V3 = mkV3 (regV "feilschen") mit_Prep um_Prep ;
  feilschen_um_V2 = prepV2 (regV "feilschen") um_Prep ;
--  feinen_V = regV "feinen" ;
  feixen_V = regV "feixen" ;
  feixen_VS = mkVS (regV "feixen")  ;
  fellieren_V2 = dirV2 (regV "fellieren")  ;
  feminieren_V2 = dirV2 (regV "feminieren")  ;
  feminisieren_V2 = dirV2 (regV "feminisieren")  ;
  fensterln_bei_V2 = prepV2 (regV "fensterln") bei_Prep ;
--  fensterln_V = irregV "fensterln" "fenstert" "fensterte" "fenstere" "gefensterlt" ;
  fensterln_V = regV "fensterln" ;
  ferkeln_V = regV "ferkeln" ;
  fermentieren_V = regV "fermentieren" ;
  fernsehen_V = prefixV "fern" (irregV "sehen" "seht" "sah" "sähe" "gesehen") ;
  fertigen_V2 = dirV2 (regV "fertigen")  ;
  fertigmachen_V2 = dirV2 (prefixV "fertig" (regV "machen"))  ;
  fesseln_V2 = dirV2 (regV "fesseln")  ;
  festhalten_V2 = dirV2 (prefixV "fest" (irregV "halten" "hält" "hielt" "hielte" "gehalten"))  ;
  festigen_V2 = dirV2 (prefixV "fest" (irregV "igen" "igt" "igte" "igte" "geigt"))  ;
  festkehren_V2 = dirV2 (prefixV "fest" (regV "kehren"))  ;
  festlegen_auf_rV2 = reflV2 (prefixV "fest" (regV "legen")) accusative (mkPrep "auf" accusative) ;
  festnageln_auf_V3 = dirV3 (prefixV "fest" (regV "nageln")) (mkPrep "auf" accusative) ;
  festschreiben_V2 = dirV2 (prefixV "fest" (irregV "schreiben" "schreibt" "schrieb" "schrieb" "geschrieben"))  ;
  festschreiben_VS = mkVS (prefixV "fest" (irregV "schreiben" "schreibt" "schrieb" "schrieb" "geschrieben"))  ;
  festsetzen_V2 = dirV2 (prefixV "fest" (regV "setzen"))  ;
  feststellen_VQ = mkVQ (prefixV "fest" (regV "stellen"))  ;
  feststellen_VS = mkVS (prefixV "fest" (regV "stellen"))  ;
  fetischisieren_V2 = dirV2 (regV "fetischisieren")  ;
  fetten_V2 = dirV2 (regV "fetten")  ;
  fetzen_mit_rV2 = reflV2 (regV "fetzen") accusative mit_Prep ;
  fetzen_rV = reflV (regV "fetzen") accusative ;
  feudeln_V2 = dirV2 (regV "feudeln")  ;
  feuern_V2 = dirV2 (regV "feuern")  ;
  ficken_mit_V2 = prepV2 (regV "ficken") mit_Prep ;
  ficken_plV = plV (regV "ficken")  ;
  ficken_V2 = dirV2 (regV "ficken")  ;
  fickern_V = regV "fickern" ;
  fiebern_nach_V2 = prepV2 (regV "fiebern") nach_Prep ;
  fiedeln_V2 = dirV2 (regV "fiedeln")  ;
  fieren_V2 = dirV2 (regV "fieren")  ;
  fighten_mit_um_V3 = mkV3 (regV "fighten") mit_Prep um_Prep ;
  fighten_um_V2 = prepV2 (regV "fighten") um_Prep ;
  filetieren_V2 = dirV2 (regV "filetieren")  ;
  filibustern_V = irregV "filibustern" "filibustert" "filibusterte" "filibusterte" "filibustert" ;
  filmen_V2 = dirV2 (regV "filmen")  ;
  filtrieren_V2 = dirV2 (regV "filtrieren")  ;
  filzen_V2 = dirV2 (regV "filzen")  ;
  finanzieren_V2 = dirV2 (regV "finanzieren")  ;
  finassieren_V = regV "finassieren" ;
  finden_V2 = dirV2 (irregV "finden" "findet" "fand" "fände" "gefunden")  ;
  finden_VS = mkVS (irregV "finden" "findet" "fand" "fände" "gefunden")  ;
  fingern_an_V2 = prepV2 (regV "fingern") (mkPrep "an" accusative) ;
  fingieren_V2 = dirV2 (regV "fingieren")  ;
  fingieren_VS = mkVS (regV "fingieren")  ;
  finishen_V = regV "finishen" ;
  firlefanzen_V = regV "firlefanzen" ;
  firmen_V2 = dirV2 (regV "firmen")  ;
  firmieren_als_V2 = prepV2 (regV "firmieren") (mkPrep "als" nominative) ;
  firnen_V2 = dirV2 (regV "firnen")  ;
  firnissen_V2 = dirV2 (regV "firnissen")  ;
  fischen_V2 = dirV2 (regV "fischen")  ;
  fiskalisieren_V2 = dirV2 (regV "fiskalisieren")  ;
  fixen_V2 = dirV2 (regV "fixen")  ;
  fixen_V = regV "fixen" ;
  fixieren_V2 = dirV2 (regV "fixieren")  ;
  flachsen_VS = mkVS (regV "flachsen")  ;
  flackern_V = regV "flackern" ;
  fladern_V2 = dirV2 (irregV "fladern" "fladert" "fladerte" "fladerte" "gefladert")  ;
  flaezen_auf_rV2 = reflV2 (regV "fläzen") accusative (mkPrep "auf" accusative) ;
  flambieren_V2 = dirV2 (regV "flambieren")  ;
  flanieren_dir_V2 = prepV2 (regV "flanieren") dir_Prep ;
  flanken_dir_V3 = dirV3 (regV "flanken") dir_Prep ;
  flankieren_V2 = dirV2 (regV "flankieren")  ;
  flashen_V2 = dirV2 (regV "flashen")  ;
  flattern_V = irregV "flattern" "flattert" "flatterte" "flatterte" "geflattert" ;
  flechten_V2 = dirV2 (irregV "flechten" "flicht" "flocht" "flöchte" "geflochten")  ;
  fleddern_V2 = dirV2 (regV "fleddern")  ;
  flegeln_V = regV "flegeln" ;
  flehen_um_V2 = prepV2 (regV "flehen") um_Prep ;
  flehmen_V = regV "flehmen" ;
  flektieren_V2 = dirV2 (regV "flektieren")  ;
  flennen_V = regV "flennen" ;
  fletschen_V2 = dirV2 (regV "fletschen")  ;
  fleuchen_dir_V2 = prepV2 (regV "fleuchen") dir_Prep ;
  flexibilisieren_V2 = dirV2 (regV "flexibilisieren")  ;
  flicken_V2 = dirV2 (regV "flicken")  ;
  fliegen_V2 = dirV2 (irregV "fliegen" "fliegt" "flog" "flöge" "geflogen")  ;
  fliehen_V2 = dirV2 (irregV "fliehen" "flieht" "floh" "flöhe" "geflohen")  ;
  fliehen_vor_V2 = prepV2 (irregV "fliehen" "flieht" "floh" "flöhe" "geflohen") (mkPrep "vor" dative) ;
  fliesen_V2 = dirV2 (regV "fliesen")  ;
  fliessen_dir_V2 = prepV2 (irregV "fließen" "fließt" "floss" "flösse" "geflossen") dir_Prep ;
  fliessen_V = irregV "fließen" "fließt" "floss" "flösse" "geflossen" ;
  flimmern_V = regV "flimmern" ;
  flippern_V = regV "flippern" ;
  flirren_V = regV "flirren" ;
  flirten_mit_V2 = prepV2 (regV "flirten") mit_Prep ;
  flirten_plV = plV (regV "flirten")  ;
  flitschen_V2 = dirV2 (regV "flitschen")  ;
  floehen_V2 = dirV2 (regV "flöhen")  ;
  floeten_V2 = dirV2 (regV "flöten")  ;
  floeten_VS = mkVS (regV "flöten")  ;
  florieren_V = regV "florieren" ;
  flottieren_plV = plV (regV "flottieren")  ;
  fluchen_V = regV "fluchen" ;
  fluchen_VS = mkVS (regV "fluchen")  ;
  fluechten_vor_rV2 = reflV2 (regV "flüchten") accusative (mkPrep "vor" dative) ;
  fluechten_vor_V2 = prepV2 (regV "flüchten") (mkPrep "vor" dative) ;
  fluegeln_V2 = dirV2 (regV "flügeln")  ;
  fluegeln_V = regV "flügeln" ;
  fluestern_V2 = dirV2 (regV "flüstern")  ;
  fluestern_VS = mkVS (regV "flüstern")  ;
  fluktuieren_plV = plV (regV "fluktuieren")  ;
  flunkern_VS = mkVS (regV "flunkern")  ;
  fluoreszieren_V = regV "fluoreszieren" ;
  fluten_V2 = dirV2 (regV "fluten")  ;
  foederalisieren_V2 = dirV2 (regV "föderalisieren")  ;
  foehnen_V2 = dirV2 (regV "föhnen")  ;
  foenen_V2 = dirV2 (regV "fönen")  ;
  foerdern_V2 = dirV2 (regV "fördern")  ;
  fokussieren_auf_V3 = dirV3 (regV "fokussieren") (mkPrep "auf" accusative) ;
  folgen_aus_V2 = prepV2 (regV "folgen") aus_Prep ;
  folgen_dat_V2 = mkV2 (regV "folgen") datPrep ;
  folgern_aus_VS2 = mkVS2 (regV "folgern") aus_Prep ;
  folgern_VS = mkVS (regV "folgern")  ;
  foltern_V2 = dirV2 (regV "foltern")  ;
  foppen_V2 = dirV2 (regV "foppen")  ;
  forcieren_V2 = dirV2 (regV "forcieren")  ;
  forcieren_VS = mkVS (regV "forcieren")  ;
  fordern_sV2 = dassV2 (regV "fordern") accPrep ;
  fordern_V2 = dirV2 (regV "fordern")  ;
  fordern_von_V2S = mkV2S (regV "fordern") von_Prep ;
  fordern_von_V3 = mkV3 (regV "fordern") von_Prep accPrep ;
  forkeln_V = regV "forkeln" ;
  formalisieren_V2 = dirV2 (regV "formalisieren")  ;
  formatieren_V2 = dirV2 (regV "formatieren")  ;
  formen_V2 = dirV2 (regV "formen")  ;
  formulieren_V2 = dirV2 (regV "formulieren")  ;
  formulieren_VS = mkVS (regV "formulieren")  ;
  forschen_nach_V2 = prepV2 (regV "forschen") nach_Prep ;
  fortbewegen_rV = reflV (prefixV "fort" (regV "bewegen")) accusative ;
  fortbewegen_V2 = dirV2 (prefixV "fort" (regV "bewegen"))  ;
  fortbilden_rV = reflV (prefixV "fort" (regV "bilden")) accusative ;
  fortbleiben_V = prefixV "fort" (irregV "bleiben" "bleibt" "blieb" "bliebe" "geblieben") ;
  fortdenken_V2 = dirV2 (prefixV "fort" (irregV "denken" "denkt" "dachte" "dächte" "gedacht"))  ;
  forteilen_V = prefixV "fort" (regV "eilen") ;
  fortfahren_mit_V2 = prepV2 (prefixV "fort" (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren")) mit_Prep ;
  fortfahren_V = prefixV "fort" (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren") ;
  fortfallen_V = prefixV "fort" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen") ;
  fortgehen_von_V2 = prepV2 (prefixV "fort" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) von_Prep ;
  fortgehen_V = prefixV "fort" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  fortlegen_V2 = dirV2 (prefixV "fort" (regV "legen"))  ;
  fortloben_V2 = dirV2 (prefixV "fort" (regV "loben"))  ;
  fortpflanzen_rV = reflV (regV "fortpflanzen") accusative ;
  fortschicken_V2 = dirV2 (prefixV "fort" (regV "schicken"))  ;
  fortschreiben_V2 = dirV2 (prefixV "fort" (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben"))  ;
  fortschreiten_sV = dassV (regV "fortschreiten")  ;
  fortschreiten_V = regV "fortschreiten" ;
  fortsetzen_mit_V2 = prepV2 (prefixV "fort" (regV "setzen")) mit_Prep ;
  fortsetzen_V2 = dirV2 (prefixV "fort" (regV "setzen"))  ;
  fortstossen_V2 = dirV2 (prefixV "fort" (irregV "stoßen" "stoßt" "stieß" "stieße" "gestoßen"))  ;
  fortwischen_V2 = dirV2 (prefixV "fort" (regV "wischen"))  ;
  fotografieren_V2 = dirV2 (regV "fotografieren")  ;
  fotzen_V2 = dirV2 (regV "fotzen")  ;
  foulen_V2 = dirV2 (regV "foulen")  ;
  fouragieren_V = regV "fouragieren" ;
  foxtrotten_V = regV "foxtrotten" ;
  fragen_V2 = dirV2 (regV "fragen")  ;
  fragen_V2Q = mkV2Q (regV "fragen") accPrep ;
--  fraktionieren_V = regV "fraktionieren" ;
  frakturieren_V = regV "frakturieren" ;
  frankieren_V2 = dirV2 (regV "frankieren")  ;
  franzoeseln_V = irregV "französeln" "französelt" "französelte" "französelte" "französelt" ;
  franzoesieren_V2 = dirV2 (regV "französieren")  ;
  franzoesisieren_V2 = dirV2 (regV "französisieren")  ;
  frappieren_sV2 = dassV2 (regV "frappieren") accPrep ;
  frappieren_V2 = dirV2 (regV "frappieren")  ;
  freien_V2 = dirV2 (regV "freien")  ;
  freigeben_V2 = dirV2 (prefixV "frei" (irregV "geben" "gibt" "gab" "gab" "gegeben"))  ;
  freilassen_V2 = dirV2 (prefixV "frei" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  freimachen_V2 = dirV2 (prefixV "frei" (regV "machen"))  ;
  freisetzen_V2 = dirV2 (prefixV "frei" (regV "setzen"))  ;
  freistellen_von_V3 = dirV3 (prefixV "frei" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt")) von_Prep ;
  fremdeln_V = regV "fremdeln" ;
  fremdgehen_V = prefixV "fremd" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  fremdschaemen_rV = reflV (prefixV "fremd" (regV "schämen")) accusative ;
  frequentieren_V2 = dirV2 (regV "frequentieren")  ;
  fressen_V2 = dirV2 (irregV "fressen" "fresst" "fraß" "fräße" "gefressen")  ;
  freuen_sV2 = dassV2 (regV "freuen") accPrep ;
  freuen_ueber_rV2 = reflV2 (regV "freuen") accusative (mkPrep "über" accusative) ;
  freuen_V2 = dirV2 (regV "freuen")  ;
  frickeln_am_V2 = prepV2 (regV "frickeln") (mkPrep "an" dative) ;
  friemeln_V2 = dirV2 (regV "friemeln")  ;
  frieren_V = irregV "frieren" "friert" "fror" "fröre" "gefroren" ;
  fringsen_V = irregV "fringsen" "fringst" "fingste" "fingste" "gefringst" ;
  frischen_V = regV "frischen" ;
  frisieren_V2 = dirV2 (regV "frisieren")  ;
  frittieren_V2 = dirV2 (regV "frittieren")  ;
  froemmeln_V = regV "frömmeln" ;
  froenen_gen_V2 = mkV2 (regV "frönen") genPrep ;
  froesteln_V = regV "frösteln" ;
  frohlocken_V = regV "frohlocken" ;
  frosten_V2 = dirV2 (regV "frosten")  ;
  frosten_V = regV "frosten" ;
  frotzeln_VS = mkVS (regV "frotzeln")  ;
  fruehstuecken_V = regV "frühstücken" ;
  frusten_sV2 = dassV2 (regV "frusten") accPrep ;
  frusten_V2 = dirV2 (regV "frusten")  ;
  frustrieren_sV2 = dassV2 (regV "frustrieren") accPrep ;
  frustrieren_V2 = dirV2 (regV "frustrieren")  ;
  fuchsen_sV2 = dassV2 (regV "fuchsen") accPrep ;
  fuchsen_V2 = dirV2 (regV "fuchsen")  ;
  fuchteln_mit_V2 = prepV2 (regV "fuchteln") mit_Prep ;
  fuckeln_V2 = dirV2 (regV "fuckeln")  ;
  fuckeln_V = regV "fuckeln" ;
  fuegen_dat_rV2 = reflV2 (regV "fügen") accusative datPrep ;
  fuehlen_V2 = dirV2 (regV "fühlen")  ;
  fuehlen_VS = mkVS (regV "fühlen")  ;
  fuehren_dir_V3 = dirV3 (regV "führen") dir_Prep ;
  fuehren_V2 = dirV2 (regV "führen")  ;
  fuellen_mit_V3 = dirV3 (regV "füllen") mit_Prep ;
  fuellen_V2 = dirV2 (regV "füllen")  ;
  fuerchten_V2 = dirV2 (regV "fürchten")  ;
  fuerchten_vor_rV2 = reflV2 (regV "fürchten") accusative (mkPrep "vor" dative) ;
  fuerchten_VS = mkVS (regV "fürchten")  ;
  fuesilieren_V2 = dirV2 (regV "füsilieren")  ;
  fuesseln_V2 = dirV2 (regV "füßeln")  ;
  fuesseln_V = regV "füßeln" ;
  fuettern_mit_V3 = dirV3 (regV "füttern") mit_Prep ;
  fuettern_V2 = dirV2 (regV "füttern")  ;
  fuhrwerken_V2 = dirV2 (regV "fuhrwerken")  ;
  fuhrwerken_V = regV "fuhrwerken" ;
  fummeln_am_V2 = prepV2 (regV "fummeln") (mkPrep "an" dative) ;
  fummeln_V2 = dirV2 (regV "fummeln")  ;
  fundieren_V2 = dirV2 (regV "fundieren")  ;
  fungieren_als_V2 = prepV2 (regV "fungieren") (mkPrep "als" nominative) ;
  funktionalisieren_V2 = dirV2 (regV "funktionalisieren")  ;
  funktionieren_V = regV "funktionieren" ;
  funzeln_V = regV "funzeln" ;
  funzen_V = regV "funzen" ;
  furzen_V = regV "furzen" ;
  fusionieren_mit_V2 = prepV2 (regV "fusionieren") mit_Prep ;
  fusionieren_plV = plV (regV "fusionieren")  ;
  fusseln_V = regV "fußeln" ;
  fussen_auf_V2 = prepV2 (regV "fußen") (mkPrep "auf" dative) ;
  futtern_V2 = dirV2 (regV "futtern")  ;
  futtern_V = regV "futtern" ;
  gabeln_rV = reflV (regV "gabeln") accusative ;
  gackern_V = regV "gackern" ;
  gaehnen_V = regV "gähnen" ;
  gaengeln_V2 = dirV2 (regV "gängeln")  ;
  gaeren_V = irregV "gären" "gärt" "gor" "gor" "gegoren" ;
  gaerteln_V = regV "gärteln" ;
  gaertnern_V = regV "gärtnern" ;
  gaffen_dir_V2 = prepV2 (regV "gaffen") dir_Prep ;
  gallisieren_V2 = dirV2 (regV "gallisieren")  ;
  galoppieren_V = regV "galoppieren" ;
  gammeln_V = regV "gammeln" ;
  garantieren_dat_V2V = mkV2V (regV "garantieren") datPrep ;
  garantieren_dat_V3 = accdatV3 (regV "garantieren")  ;
  garantieren_V2 = dirV2 (regV "garantieren")  ;
  garantieren_VV = mkVV (regV "garantieren")  ;
  garen_V = regV "garen" ;
  garnieren_mit_V3 = dirV3 (regV "garnieren") mit_Prep ;
  garnisonieren_V2 = dirV2 (regV "garnisonieren")  ;
  garrottieren_V2 = dirV2 (regV "garrottieren")  ;
  gasen_V = regV "gasen" ;
  gasifizieren_V2 = dirV2 (regV "gasifizieren")  ;
  gastieren_loc_V2 = prepV2 (regV "gastieren") loc_Prep ;
  gaumen_V2 = dirV2 (regV "gaumen")  ;
  gautschen_V2 = dirV2 (regV "gautschen")  ;
  gautschen_V = regV "gautschen" ;
  gebaerden_adv_rV2 = reflV2 (irregV "gebärden" "gebärdet" "gebärdete" "gebärdete" "gebärdet") accusative adv_Prep ;
  gebaerden_als_rV2 = reflV2 (irregV "gebärden" "gebärdet" "gebärdete" "gebärdete" "gebärdet") accusative (mkPrep "als" nominative) ;
  gebaerden_wie_rV2 = reflV2 (irregV "gebärden" "gebärdet" "gebärdete" "gebärdete" "gebärdet") accusative (mkPrep "wie" nominative) ;
  gebaeren_V2 = dirV2 (irregV "gebären" "gebärt" "gebar" "gebäre" "geboren")  ;
  geben_dat_V3 = accdatV3 (irregV "geben" "gebt" "gab" "gäbe" "gegeben")  ;
  gebieten_dat_V2V = mkV2V (irregV "gebieten" "gebietet" "gebot" "geböte" "geboten") datPrep ;
  gebrauchen_V2 = dirV2 (irregV "gebrauchen" "gebraucht" "gebrauchte" "gebrauchte" "gebraucht")  ;
  gebuehren_dat_sV2 = dassV2 (irregV "gebühren" "gebührt" "gebührte" "gebührte" "gebührt") datPrep ;
  gebuehren_dat_V2 = mkV2 (irregV "gebühren" "gebührt" "gebührte" "gebührte" "gebührt") datPrep ;
  gedeihen_V = irregV "gedeihen" "gedeiht" "gedieh" "gediehe" "gediehen" ;
  gedenken_gen_V2 = mkV2 (irregV "gedenken" "gedenkt" "gedachte" "gedächte" "gedacht") genPrep ;
  gedenken_VV = mkVV (irregV "gedenken" "gedenkt" "gedachte" "gedächte" "gedacht")  ;
  gefaehrden_sV2 = dassV2 (irregV "gefährden" "gefährdet" "gefährdete" "gefährdete" "gefährdet") accPrep ;
  gefaehrden_V2 = dirV2 (irregV "gefährden" "gefährdet" "gefährdete" "gefährdete" "gefährdet")  ;
  gefallen_dat_sV2 = dassV2 (irregV "gefallen" "gefallt" "gefiel" "gefiele" "gefallen") datPrep ;
  gefallen_dat_V2 = mkV2 (irregV "gefallen" "gefallt" "gefiel" "gefiele" "gefallen") datPrep ;
  gefrieren_V = irregV "gefrieren" "gefriert" "gefror" "gefröre" "gefroren" ;
  gegenlesen_V2 = dirV2 (prefixV "gegen" (irregV "lesen" "lest" "las" "läse" "gelesen"))  ;
  gegenzeichnen_V2 = dirV2 (prefixV "gegen" (regV "zeichnen"))  ;
  geheien_V2 = dirV2 (irregV "geheien" "geheit" "geheite" "geheite" "geheit")  ;
  geheien_V = irregV "geheien" "geheit" "geheite" "geheite" "geheit" ;
  gehen_es_dat_V2A = mkV2A (irregV "gehen" "geht" "ging" "ginge" "gegangen") datPrep ;
  gehen_V = irregV "gehen" "geht" "ging" "ginge" "gegangen" ;
  gehoeren_dat_V2 = mkV2 (irregV "gehören" "gehört" "gehörte" "gehörte" "gehört") datPrep ;
  gehorchen_dat_V2 = mkV2 (irregV "gehorchen" "gehorcht" "gehorchte" "gehorchte" "gehorcht") datPrep ;
  geifern_V = regV "geifern" ;
  geifern_VS = mkVS (regV "geifern")  ;
  geigen_V2 = dirV2 (regV "geigen")  ;
  geisseln_V2 = dirV2 (regV "geißeln")  ;
  geisseln_VS = mkVS (regV "geißeln")  ;
  geistreicheln_V = regV "geistreicheln" ;
  geizen_mit_V2 = prepV2 (regV "geizen") mit_Prep ;
  gelangen_zu_V2 = prepV2 (irregV "gelangen" "gelangt" "gelangte" "gelangte" "gelangt") zu_Prep ;
  gelieren_V = irregV "gelieren" "geliert" "gelierte" "gelierte" "geliert" ;
  gelingen_dat_iV2 = infzuV2 (irregV "gelingen" "gelingt" "gelang" "gelänge" "gelungen") datPrep ;
  gelingen_dat_V2 = mkV2 (irregV "gelingen" "gelingt" "gelang" "gelänge" "gelungen") datPrep ;
  geloben_V2 = dirV2 (irregV "geloben" "gelobt" "gelobte" "gelobte" "gelobt")  ;
  geloben_VS = mkVS (irregV "geloben" "gelobt" "gelobte" "gelobte" "gelobt")  ;
  gelten_dat_V2 = mkV2 (irregV "gelten" "gilt" "galt" "gälte" "gegolten") datPrep ;
  genehmigen_dat_V2S = mkV2S (irregV "genehmigen" "genehmigt" "genehmigte" "genehmigte" "genehmigt") datPrep ;
  genehmigen_dat_V3 = accdatV3 (irregV "genehmigen" "genehmigt" "genehmigte" "genehmigte" "genehmigt")  ;
  generalisieren_V2 = dirV2 (regV "generalisieren")  ;
  generalisieren_VS = mkVS (regV "generalisieren")  ;
  generieren_V2 = dirV2 (irregV "generieren" "generiert" "generierte" "generierte" "generiert")  ;
  genesen_von_V2 = prepV2 (irregV "genesen" "genest" "genas" "genäse" "genesen") von_Prep ;
  genieren_fuer_rV2 = reflV2 (regV "genieren") accusative fuer_Prep ;
  genieren_rVV = reflVV (regV "genieren") accusative ;
  genieren_sV2 = dassV2 (regV "genieren") accPrep ;
  genieren_V2 = dirV2 (regV "genieren")  ;
  genieren_vor_rV2 = reflV2 (regV "genieren") accusative (mkPrep "vor" dative) ;
  geniessen_V2 = dirV2 (irregV "genießen" "genießt" "genoss" "genösse" "genossen")  ;
  geniessen_VS = mkVS (irregV "genießen" "genießt" "genoss" "genösse" "genossen")  ;
  genuegen_dat_sV2 = dassV2 (irregV "genügen" "genügt" "genügte" "genügte" "genügt") datPrep ;
  genuegen_dat_V2 = mkV2 (irregV "genügen" "genügt" "genügte" "genügte" "genügt") datPrep ;
  geraten_in_V2 = prepV2 (irregV "geraten" "gerät" "geriet" "geriete" "geraten") (mkPrep "in" accusative) ;
  gerben_V2 = dirV2 (regV "gerben")  ;
  gereichen_dat_zu_V3 = mkV3 (irregV "gereichen" "gereicht" "gereichte" "gereichte" "gereicht") datPrep zu_Prep ;
  geren_V = regV "geren" ;
  gerieren_adv_rV2 = reflV2 (irregV "gerieren" "geriert" "gerierte" "gerierte" "geriert") accusative adv_Prep ;
  gerieren_als_rV2 = reflV2 (irregV "gerieren" "geriert" "gerierte" "gerierte" "geriert") accusative (mkPrep "als" nominative) ;
  gerieren_wie_rV2 = reflV2 (irregV "gerieren" "geriert" "gerierte" "gerierte" "geriert") accusative (mkPrep "wie" nominative) ;
  gerinnen_V = irregV "gerinnen" "gerinnt" "gerann" "geränne" "geronnen" ;
  gernhaben_V2 = dirV2 (prefixV "gern" (irregV "haben" "hat" "hatte" "hatte" "gehabt"))  ;
  geschehen_dat_V2A = mkV2A (irregV "geschehen" "gescheht" "geschah" "geschähe" "geschehen") datPrep ;
  geschehen_sV = dassV (irregV "geschehen" "gescheht" "geschah" "geschähe" "geschehen")  ;
  gestalten_V2 = dirV2 (irregV "gestalten" "gestaltet" "gestaltete" "gestaltete" "gestaltet")  ;
  gestatten_dat_V2S = mkV2S (irregV "gestatten" "gestattet" "gestattete" "gestattete" "gestattet") datPrep ;
  gestatten_dat_V3 = accdatV3 (irregV "gestatten" "gestattet" "gestattete" "gestattete" "gestattet")  ;
  gestikulieren_V = regV "gestikulieren" ;
  getrauen_rVV = reflVV (irregV "getrauen" "getraut" "getraute" "getraute" "getraut") dative ;
  gettoisieren_V2 = dirV2 (regV "gettoisieren")  ;
  gewaehren_dat_V3 = accdatV3 (irregV "gewähren" "gewährt" "gewährte" "gewährte" "gewährt")  ;
  gewaehrleisten_dat_V2S = mkV2S (irregV "gewährleisten" "gewährleistet" "gewährleistete" "gewährleistete" "gewährleistet") datPrep ;
  gewaertigen_V2 = dirV2 (regV "gewärtigen")  ;
  gewaertigen_VS = mkVS (regV "gewärtigen")  ;
  gewichten_V2 = dirV2 (regV "gewichten")  ;
  gewinnen_V2 = dirV2 (irregV "gewinnen" "gewinnt" "gewann" "gewänne" "gewonnen")  ;
  gewoehnen_an_V3 = dirV3 (irregV "gewöhnen" "gewöhnt" "gewöhnte" "gewöhnte" "gewöhnt") (mkPrep "an" accusative) ;
  gickeln_V = regV "gickeln" ;
  gickern_V = regV "gickern" ;
  gicksen_V = regV "gicksen" ;
  gieksen_V = regV "gieksen" ;
  gieren_nach_V2 = prepV2 (regV "gieren") nach_Prep ;
  giessen_in_V3 = dirV3 (irregV "gießen" "gießt" "goss" "gösse" "gegossen") (mkPrep "in" accusative) ;
  giften_rV = reflV (regV "giften") accusative ;
  giften_V = regV "giften" ;
  giggeln_V = regV "giggeln" ;
  giksen_V = regV "giksen" ;
  gipfeln_im_V2 = prepV2 (regV "gipfeln") (mkPrep "in" dative) ;
  girieren_V2 = dirV2 (regV "girieren")  ;
  girren_V = regV "girren" ;
--  gittern_V = regV "gittern" ;
  glaenzen_V = regV "glänzen" ;
  glaetten_V2 = dirV2 (regV "glätten")  ;
  glaren_V = regV "glaren" ;
  glasieren_V2 = dirV2 (regV "glasieren")  ;
  glauben_an_V2 = prepV2 (regV "glauben") (mkPrep "an" accusative) ;
  glauben_dat_V2S = mkV2S (regV "glauben") datPrep ;
  glauben_dat_V3 = accdatV3 (regV "glauben")  ;
  gleichen_dat_V2 = mkV2 (irregV "gleichen" "gleicht" "glich" "gliche" "geglichen") datPrep ;
  gleichen_rcV = reciV (irregV "gleichen" "gleicht" "glich" "gliche" "geglichen") dative ;
  gleichtun_dat_V2S = mkV2S (prefixV "gleich" (irregV "tun" "tut" "tat" "täte" "getan")) datPrep ;
  gleiten_ueber_V2 = prepV2 (irregV "gleiten" "gleitet" "glitt" "glitt" "geglitten") (mkPrep "über" accusative) ;
  gliedern_in_V3 = dirV3 (regV "gliedern") (mkPrep "in" accusative) ;
  glimmen_V = irregV "glimmen" "glimmt" "glomm" "glömme" "geglommen" ;
  glitzern_V = regV "glitzern" ;
  globalisieren_V2 = dirV2 (regV "globalisieren")  ;
  glorifizieren_V2 = dirV2 (regV "glorifizieren")  ;
  glorifizieren_VS = mkVS (regV "glorifizieren")  ;
  glossieren_V2 = dirV2 (regV "glossieren")  ;
  glotzen_V = regV "glotzen" ;
  gluecken_dat_sV2 = dassV2 (regV "glücken") datPrep ;
  gluecken_dat_V2 = mkV2 (regV "glücken") datPrep ;
  gluehen_V = regV "glühen" ;
  gneissen_V = regV "gneißen" ;
  gniedeln_V = regV "gniedeln" ;
  goennen_dat_V2S = mkV2S (regV "gönnen") datPrep ;
  goennen_dat_V3 = accdatV3 (regV "gönnen")  ;
  golfen_V = regV "golfen" ;
  gondeln_dir_V2 = prepV2 (regV "gondeln") dir_Prep ;
  googeln_V = regV "googeln" ;
  goutieren_V2 = dirV2 (regV "goutieren")  ;
  goutieren_VS = mkVS (regV "goutieren")  ;
  grabbeln_loc_V2 = prepV2 (regV "grabbeln") loc_Prep ;
  graben_V2 = dirV2 (irregV "graben" "grabt" "grub" "grübe" "gegraben")  ;
  graben_V = irregV "graben" "grabt" "grub" "grübe" "gegraben" ;
  grabschen_V = regV "grabschen" ;
  gradieren_V2 = dirV2 (regV "gradieren")  ;
  graduieren_V2 = dirV2 (regV "graduieren")  ;
  graemen_sV2 = dassV2 (regV "grämen") accPrep ;
  graemen_ueber_rV2 = reflV2 (regV "grämen") accusative (mkPrep "über" accusative) ;
  graemen_V2 = dirV2 (regV "grämen")  ;
  graetschen_V = regV "grätschen" ;
  graezisieren_V2 = dirV2 (regV "gräzisieren")  ;
  grammatikalisieren_V2 = dirV2 (regV "grammatikalisieren")  ;
  granteln_V = regV "granteln" ;
  granulieren_V2 = dirV2 (regV "granulieren")  ;
  grapschen_V = regV "grapschen" ;
  grassieren_V = regV "grassieren" ;
  gratinieren_V2 = dirV2 (regV "gratinieren")  ;
  gratulieren_dat_zu_V3 = mkV3 (regV "gratulieren") datPrep zu_Prep ;
  grauen_es_dat_vor_V3 = mkV3 (regV "grauen") datPrep (mkPrep "vor" dative) ;
  grauen_es_esV = esV (regV "grauen")  ;
  grausen_es_dat_vor_V3 = mkV3 (regV "grausen") datPrep (mkPrep "vor" dative) ;
  grausen_sV2 = dassV2 (regV "grausen") accPrep ;
  grausen_V2 = dirV2 (regV "grausen")  ;
  greifen_dir_V2 = prepV2 (irregV "greifen" "greift" "griff" "griffe" "gegriffen") dir_Prep ;
  greifen_rV2 = reflV2 (irregV "greifen" "greift" "griff" "griffe" "gegriffen") accusative accPrep ;
  greinen_V = regV "greinen" ;
  grenzen_an_V2 = prepV2 (regV "grenzen") (mkPrep "an" accusative) ;
  grienen_V = regV "grienen" ;
  grillen_V2 = dirV2 (regV "grillen")  ;
  grillieren_V2 = dirV2 (regV "grillieren")  ;
  grimassieren_V = regV "grimassieren" ;
  grinsen_V = regV "grinsen" ;
  groelen_V2 = dirV2 (regV "grölen")  ;
  groelen_V = regV "grölen" ;
  groelen_VS = mkVS (regV "grölen")  ;
  grollen_dat_V2 = mkV2 (regV "grollen") datPrep ;
  grossschreiben_V2 = dirV2 (prefixV "groß" (irregV "schreiben" "schreibt" "schrieb" "schrieb" "geschrieben"))  ;
  grossziehen_V2 = dirV2 (prefixV "groß" (irregV "ziehen" "zieht" "zog" "zog" "gezogen"))  ;
  gruebeln_ueber_V2 = prepV2 (regV "grübeln") (mkPrep "über" accusative) ;
  gruenden_auf_V3 = dirV3 (regV "gründen") (mkPrep "auf" accusative) ;
  gruenden_V2 = dirV2 (regV "gründen")  ;
  gruessen_V2 = dirV2 (regV "grüßen")  ;
  grummeln_V2 = dirV2 (regV "grummeln")  ;
  grummeln_V = regV "grummeln" ;
  grummeln_VS = mkVS (regV "grummeln")  ;
  gruppieren_V2 = dirV2 (regV "gruppieren")  ;
  gruseln_sV2 = dassV2 (regV "gruseln") accPrep ;
  gruseln_V2 = dirV2 (regV "gruseln")  ;
  gucken_V = regV "gucken" ;
  guellen_V2 = dirV2 (regV "güllen")  ;
  guerten_mit_rV2 = reflV2 (irregV "gürten" "gürtet" "gürtete" "gürte" "gegürtet") accusative mit_Prep ;
  guerten_rV = reflV (irregV "gürten" "gürtet" "gürtete" "gürte" "gegürtet") accusative ;
  guillotinieren_V2 = dirV2 (regV "guillotinieren")  ;
  gurgeln_V2 = dirV2 (regV "gurgeln")  ;
  gurgeln_VS = mkVS (regV "gurgeln")  ;
  gurren_V2 = dirV2 (regV "gurren")  ;
  gurren_VS = mkVS (regV "gurren")  ;
  gustieren_V2 = dirV2 (regV "gustieren")  ;
  gustieren_VS = mkVS (regV "gustieren")  ;
  gutheissen_V2 = dirV2 (prefixV "gut" (irregV "heißen" "heißt" "hieß" "hieß" "geheißen"))  ;
  gutheissen_VS = mkVS (prefixV "gut" (irregV "heißen" "heißt" "hieß" "hieß" "geheißen"))  ;
  haaren_V = regV "haaren" ;
  haben_V2 = dirV2 (irregV "haben" "habt" "hatte" "hätte" "gehabt")  ;
  habilitieren_rV = reflV (regV "habilitieren") accusative ;
  habilitieren_ueber_V2 = prepV2 (regV "habilitieren") (mkPrep "über" accusative) ;
  habilitieren_V2 = dirV2 (regV "habilitieren")  ;
  habitualisieren_V0 = mkV0 (regV "habitualisieren")  ;
  hacken_V2 = dirV2 (regV "hacken")  ;
  hacken_V = regV "hacken" ;
  hadern_mit_V2 = prepV2 (regV "hadern") mit_Prep ;
  haekeln_V2 = dirV2 (regV "häkeln")  ;
  haemmern_V2 = dirV2 (regV "hämmern")  ;
  haengen_dir_V3 = dirV3 (irregV "hängen" "hängt" "hing" "hinge" "gehangen") dir_Prep ;
  haenseln_V2 = dirV2 (regV "hänseln")  ;
  haerten_V2 = dirV2 (regV "härten")  ;
  haetscheln_V2 = dirV2 (regV "hätscheln")  ;
  haeuten_V2 = dirV2 (regV "häuten")  ;
  haften_fuer_V2 = prepV2 (regV "haften") fuer_Prep ;
  hageln_es_esV = esV (regV "hageln")  ;
  hageln_es_V2 = dirV2 (regV "hageln")  ;
  haken_es_am_V2 = prepV2 (regV "haken") (mkPrep "an" dative) ;
  halbieren_V2 = dirV2 (regV "halbieren")  ;
  halftern_V2 = dirV2 (regV "halftern")  ;
  hallen_V = regV "hallen" ;
  halluzinieren_V2 = dirV2 (regV "halluzinieren")  ;
  halluzinieren_VS = mkVS (regV "halluzinieren")  ;
  halsen_V2 = dirV2 (regV "halsen")  ;
  halsen_V = regV "halsen" ;
  halten_V2 = dirV2 (irregV "halten" "hält" "hielt" "hielte" "gehalten")  ;
  hamstern_V2 = dirV2 (irregV "hamstern" "hamstert" "hamsterte" "hamsterte" "gehamstert")  ;
  handeln_mit_V2 = prepV2 (regV "handeln") mit_Prep ;
  handeln_V = regV "handeln" ;
  handhaben_V2 = dirV2 (regV "handhaben")  ;
  handlangern_dat_V2 = mkV2 (regV "handlangern") datPrep ;
  hantieren_mit_V2 = prepV2 (regV "hantieren") mit_Prep ;
  hapern_es_bei_am_V3 = mkV3 (regV "hapern") bei_Prep (mkPrep "an" dative) ;
  harangieren_V = regV "harangieren" ;
  harfen_V = regV "harfen" ;
  harnen_V = regV "harnen" ;
  harren_gen_V2 = mkV2 (regV "harren") genPrep ;
  harschen_V = regV "harschen" ;
  hasardieren_V = regV "hasardieren" ;
  haschen_V2 = dirV2 (regV "haschen")  ;
  haschieren_V2 = dirV2 (regV "haschieren")  ;
  haselieren_V = regV "haselieren" ;
  haspeln_V2 = dirV2 (regV "haspeln")  ;
  haspeln_V = regV "haspeln" ;
  haspeln_VS = mkVS (regV "haspeln")  ;
  hassen_V2 = dirV2 (regV "hassen")  ;
  hassen_VS = mkVS (regV "hassen")  ;
  hasten_dir_V2 = prepV2 (regV "hasten") dir_Prep ;
  hauchen_V2 = dirV2 (regV "hauchen")  ;
  hauchen_VS = mkVS (regV "hauchen")  ;
  hauen_auf_V2 = prepV2 (regV "hauen") (mkPrep "auf" accusative) ;
  hauen_V2 = dirV2 (regV "hauen")  ;
  hausen_loc_V2 = prepV2 (regV "hausen") loc_Prep ;
  haushalten_mit_V2 = prepV2 (regV "haushalten") mit_Prep ;
  hausieren_V = regV "hausieren" ;
  headbangen_V = regV "headbangen" ;
  hebeln_V2 = dirV2 (regV "hebeln")  ;
  heben_V2 = dirV2 (irregV "heben" "hebt" "hob" "höbe" "gehoben")  ;
  hecheln_V = regV "hecheln" ;
  hecken_V2 = dirV2 (regV "hecken")  ;
  hecken_V = regV "hecken" ;
  hegen_V2 = dirV2 (regV "hegen")  ;
  hehlen_mit_V2 = prepV2 (regV "hehlen") mit_Prep ;
  heilen_V2 = dirV2 (regV "heilen")  ;
  heiligen_V2 = dirV2 (regV "heiligen")  ;
  heimleuchten_dat_V2 = mkV2 (prefixV "heim" (regV "leuchten")) datPrep ;
  heimzahlen_dat_V3 = accdatV3 (prefixV "heim" (regV "zahlen"))  ;
  heiraten_plV = plV (regV "heiraten")  ;
  heiraten_rcV = reciV (regV "heiraten") accusative ;
  heiraten_V2 = dirV2 (regV "heiraten")  ;
  heischen_V2 = dirV2 (regV "heischen")  ;
  heissen_V2 = dirV2 (irregV "heißen" "heißt" "hieß" "hieße" "geheißen")  ;
  heissen_V2V = dirV2V (irregV "heißen" "heißt" "hieß" "hieße" "geheißen")  ;
  heissen_V3 = dirV3 (irregV "heißen" "heißt" "hieß" "hieße" "geheißen") accPrep ;
  heizen_V2 = dirV2 (regV "heizen")  ;
  heizen_V = regV "heizen" ;
  helfen_dat_bei_V3 = mkV3 (irregV "helfen" "hilft" "half" "hülfe" "geholfen") datPrep bei_Prep ;
--  helfen_V = irregV "helfen" "helft" "half" "hälfe" "geholfen" ;
  hellen_es_esV = esV (regV "hellen")  ;
  hellenisieren_V2 = dirV2 (regV "hellenisieren")  ;
  hemmen_sV2 = dassV2 (regV "hemmen") accPrep ;
  hemmen_V2 = dirV2 (regV "hemmen")  ;
  henken_V2 = dirV2 (regV "henken")  ;
  herabblicken_auf_V2 = prepV2 (prefixV "herab" (regV "blicken")) (mkPrep "auf" accusative) ;
  herabfallen_von_V2 = prepV2 (prefixV "herab" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen")) von_Prep ;
  herabfallen_V = prefixV "herab" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen") ;
  herabsetzen_V2 = dirV2 (prefixV "herab" (regV "setzen"))  ;
  herankommen_an_V2 = prepV2 (prefixV "heran" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) (mkPrep "an" accusative) ;
  herannahen_V = prefixV "heran" (regV "nahen") ;
  heranwachsen_V = prefixV "heran" (irregV "wachsen" "wächst" "wuchs" "wüchse" "gewachsen") ;
  heranwachsen_zu_V2 = prepV2 (prefixV "heran" (irregV "wachsen" "wächst" "wuchs" "wüchse" "gewachsen")) zu_Prep ;
  heraufbeschwoeren_V2 = dirV2 (prefixV "herauf" (irregV "beschwören" "beschwört" "beschwor" "beschwor" "beschworen"))  ;
  heraufbeschwoeren_VS = mkVS (prefixV "herauf" (irregV "beschwören" "beschwört" "beschwor" "beschwor" "beschworen"))  ;
  heraufkommen_V = prefixV "herauf" (irregV "kommen" "kommt" "kam" "käme" "gekommen") ;
  herausarbeiten_V2 = dirV2 (prefixV "heraus" (regV "arbeiten"))  ;
  herausarbeiten_VS = mkVS (prefixV "heraus" (regV "arbeiten"))  ;
  herausfinden_V2 = dirV2 (prefixV "heraus" (irregV "finden" "findet" "fand" "fände" "gefunden"))  ;
  herausfinden_VS = mkVS (prefixV "heraus" (irregV "finden" "findet" "fand" "fände" "gefunden"))  ;
  herausgeben_V2 = dirV2 (prefixV "heraus" (irregV "geben" "gebt" "gab" "gäbe" "gegeben"))  ;
  herauskommen_aus_V2 = prepV2 (prefixV "heraus" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) aus_Prep ;
  herauskommen_sV = dassV (prefixV "heraus" (irregV "kommen" "kommt" "kam" "käme" "gekommen"))  ;
  herauskristallisieren_rV = reflV (prefixV "heraus" (regV "kristallisieren")) accusative ;
  herausnehmen_rV2 = reflV2 (prefixV "heraus" (irregV "nehmen" "nimmt" "nahm" "nahm" "genommen")) dative accPrep ;
  herausnehmen_rVV = reflVV (prefixV "heraus" (irregV "nehmen" "nimmt" "nahm" "nahm" "genommen")) dative ;
  herausschmecken_V2 = dirV2 (prefixV "heraus" (regV "schmecken"))  ;
  herausstellen_rV = reflV (prefixV "heraus" (regV "stellen")) accusative ;
  herausstellen_V2 = dirV2 (prefixV "heraus" (regV "stellen"))  ;
  herbeifuehren_V2 = dirV2 (prefixV "herbei" (regV "führen"))  ;
  herbeifuehren_VS = mkVS (prefixV "herbei" (regV "führen"))  ;
  herbringen_V2 = dirV2 (prefixV "her" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  herbsten_es_esV = esV (regV "herbsten")  ;
  hereingeheimnissen_in_V3 = dirV3 (prefixV "herein" (regV "geheimnissen")) (mkPrep "in" accusative) ;
  hereinkommen_in_V2 = prepV2 (prefixV "herein" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) (mkPrep "in" accusative) ;
  hereinkommen_V = prefixV "herein" (irregV "kommen" "kommt" "kam" "käme" "gekommen") ;
  herhoeren_V = prefixV "her" (regV "hören") ;
  herkommen_von_V2 = prepV2 (prefixV "her" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) von_Prep ;
  herleiten_von_V3 = dirV3 (prefixV "her" (regV "leiten")) von_Prep ;
  heroisieren_V2 = dirV2 (regV "heroisieren")  ;
  heroisieren_VS = mkVS (regV "heroisieren")  ;
  herrschen_ueber_V2 = prepV2 (regV "herrschen") (mkPrep "über" accusative) ;
  herrschen_V = regV "herrschen" ;
  herruehren_von_V2 = prepV2 (prefixV "her" (regV "rühren")) von_Prep ;
  hersollen_von_V2 = prepV2 (prefixV "her" (regV "sollen")) von_Prep ;
  herstammen_von_V2 = prepV2 (prefixV "her" (regV "stammen")) von_Prep ;
  herstellen_V2 = dirV2 (prefixV "her" (regV "stellen"))  ;
  herumdrucksen_V = prefixV "herum" (regV "drucksen") ;
  herumfuhrwerken_mit_V2 = prepV2 (prefixV "herum" (regV "fuhrwerken")) mit_Prep ;
  herumfuhrwerken_V = prefixV "herum" (regV "fuhrwerken") ;
  herumhacken_auf_V2 = prepV2 (prefixV "herum" (regV "hacken")) (mkPrep "auf" dative) ;
  herumhuren_mit_V2 = prepV2 (prefixV "herum" (regV "huren")) mit_Prep ;
  herumhuren_V = prefixV "herum" (regV "huren") ;
  herumkramen_V = prefixV "herum" (regV "kramen") ;
  herumlaufen_loc_V2 = prepV2 (prefixV "herum" (irregV "laufen" "läuft" "lief" "liefe" "gelaufen")) loc_Prep ;
  herummaekeln_am_V2 = prepV2 (prefixV "herum" (regV "mäkeln")) (mkPrep "an" dative) ;
  herumplagen_mit_rV2 = reflV2 (prefixV "herum" (regV "plagen")) accusative mit_Prep ;
  herumzeigen_V2 = dirV2 (prefixV "herum" (regV "zeigen"))  ;
  herunterfallen_von_V2 = prepV2 (prefixV "herunter" (irregV "fallen" "fällt" "fiel" "fiele" "gefallen")) von_Prep ;
  herunterkommen_dat_V2 = mkV2 (prefixV "herunter" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) datPrep ;
  herunterladen_von_V3 = dirV3 (prefixV "herunter" (irregV "laden" "lädt" "lud" "lüde" "geladen")) von_Prep ;
  herunternehmen_von_V3 = dirV3 (prefixV "herunter" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen")) von_Prep ;
  herunterspielen_V2 = dirV2 (prefixV "herunter" (regV "spielen"))  ;
  hervorbringen_V2 = dirV2 (prefixV "hervor" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  hervorbringen_VS = mkVS (prefixV "hervor" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  hervorgehen_aus_V2 = prepV2 (prefixV "hervor" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) aus_Prep ;
  hervorheben_V2 = dirV2 (prefixV "hervor" (irregV "heben" "hebt" "hob" "höbe" "gehoben"))  ;
  hervorheben_VS = mkVS (prefixV "hervor" (irregV "heben" "hebt" "hob" "höbe" "gehoben"))  ;
  hervorrufen_aus_V3 = dirV3 (prefixV "hervor" (irregV "rufen" "ruft" "rief" "riefe" "gerufen")) aus_Prep ;
  hervorrufen_sVS = dassVS (prefixV "hervor" (irregV "rufen" "ruft" "rief" "riefe" "gerufen"))  ;
  herzen_V2 = dirV2 (regV "herzen")  ;
  herziehen_V = prefixV "her" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen") ;
  herzukommen_zu_V2 = prepV2 (prefixV "herzu" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) zu_Prep ;
  heucheln_V2 = dirV2 (regV "heucheln")  ;
  heucheln_VS = mkVS (regV "heucheln")  ;
  heuen_V = regV "heuen" ;
  heulen_V = regV "heulen" ;
  hierarchisieren_V2 = dirV2 (regV "hierarchisieren")  ;
  hinausfliegen_aus_V2 = prepV2 (prefixV "hinaus" (irregV "fliegen" "fliegt" "flog" "flöge" "geflogen")) aus_Prep ;
  hinausfuehren_aus_V3 = dirV3 (prefixV "hinaus" (regV "führen")) aus_Prep ;
  hindern_am_V2 = prepV2 (regV "hindern") (mkPrep "an" dative) ;
  hindurchgehen_durch_V2 = prepV2 (prefixV "hindurch" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) durch_Prep ;
  hineindenken_in_rV2 = reflV2 (prefixV "hinein" (irregV "denken" "denkt" "dachte" "dächte" "gedacht")) accusative (mkPrep "in" accusative) ;
  hineingeheimnissen_in_V3 = dirV3 (prefixV "hinein" (irregV "geheimnissen" "geheimnist" "geheimniste" "geheimniste" "geheimnist")) (mkPrep "in" accusative) ;
  hinhalten_V2 = dirV2 (prefixV "hin" (irregV "halten" "hält" "hielt" "hielte" "gehalten"))  ;
  hinken_dir_V2 = prepV2 (regV "hinken") dir_Prep ;
  hinkommen_sV = dassV (prefixV "hin" (irregV "kommen" "kommt" "kam" "käme" "gekommen"))  ;
  hinlegen_V2 = dirV2 (prefixV "hin" (regV "legen"))  ;
  hinnehmen_V2 = dirV2 (prefixV "hin" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  hinnehmen_VS = mkVS (prefixV "hin" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  hinpflanzen_rV = reflV (prefixV "hin" (regV "pflanzen")) accusative ;
  hinreichen_dat_V3 = accdatV3 (prefixV "hin" (regV "reichen"))  ;
  hinreichen_fuer_V2 = prepV2 (prefixV "hin" (regV "reichen")) fuer_Prep ;
  hinreissen_zu_V3 = dirV3 (prefixV "hin" (irregV "reißen" "reißt" "riss" "risse" "gerissen")) zu_Prep ;
  hinrichten_V2 = dirV2 (prefixV "hin" (regV "richten"))  ;
  hinsetzen_rV = reflV (prefixV "hin" (regV "setzen")) accusative ;
  hinstellen_loc_V3 = dirV3 (prefixV "hin" (regV "stellen")) loc_Prep ;
  hintanstellen_VS = mkVS (prefixV "hintan" (regV "stellen"))  ;
  hinterfragen_V2 = dirV2 (irregV "hinterfragen" "hinterfragt" "hinterfragte" "hinterfragte" "hinterfragt")  ;
  hinterfragen_VS = mkVS (irregV "hinterfragen" "hinterfragt" "hinterfragte" "hinterfragte" "hinterfragt")  ;
  hinterlassen_dat_V3 = accdatV3 (irregV "hinterlassen" "hinterlasst" "hinterließ" "hinterließe" "hinterlassen")  ;
  hinterlaufen_V2 = dirV2 (irregV "hinterlaufen" "hinterläuft" "hinterlief" "hinterlief" "hinterlaufen")  ;
  hinterlegen_V2 = dirV2 (irregV "hinterlegen" "hinterlegt" "hinterlegte" "hinterlegte" "hinterlegt")  ;
  hintertreiben_VS = mkVS (irregV "hintertreiben" "hintertreibt" "hintertrieb" "triebe" "hintertrieben")  ;
  hintreten_zu_V2 = prepV2 (prefixV "hin" (irregV "treten" "tritt" "trat" "träte" "getreten")) zu_Prep ;
  hinweisen_auf_V2 = prepV2 (prefixV "hin" (irregV "weisen" "weist" "wies" "wiese" "gewiesen")) (mkPrep "auf" accusative) ;
  hinziehen_rV = reflV (prefixV "hin" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen")) accusative ;
  hinzufuegen_dat_V3 = accdatV3 (prefixV "hinzu" (regV "fügen"))  ;
  hispanisieren_V2 = dirV2 (regV "hispanisieren")  ;
  hissen_V2 = dirV2 (regV "hissen")  ;
  historisieren_V2 = dirV2 (regV "historisieren")  ;
  hitchhiken_dir_V2 = prepV2 (regV "hitchhiken") dir_Prep ;
  hoagaschten_plV = plV (regV "hoagaschten")  ;
  hochfahren_V = prefixV "hoch" (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren") ;
  hochheben_V2 = dirV2 (prefixV "hoch" (irregV "heben" "hebt" "hob" "höbe" "gehoben"))  ;
  hochhieven_V2 = dirV2 (prefixV "hoch" (regV "hieven"))  ;
  hochkommen_V = prefixV "hoch" (irregV "kommen" "kommt" "kam" "käme" "gekommen") ;
  hochkrempeln_V2 = dirV2 (prefixV "hoch" (regV "krempeln"))  ;
  hochladen_V2 = dirV2 (prefixV "hoch" (irregV "laden" "lädt" "lud" "lüde" "geladen"))  ;
  hochzeiten_plV = plV (regV "hochzeiten")  ;
  hocken_loc_V2 = prepV2 (regV "hocken") loc_Prep ;
  hoehnen_VS = mkVS (regV "höhnen")  ;
  hoeren_V2 = dirV2 (regV "hören")  ;
  hoeren_VS = mkVS (regV "hören")  ;
  hoffen_auf_V2 = prepV2 (regV "hoffen") (mkPrep "auf" accusative) ;
  hofieren_V2 = dirV2 (regV "hofieren")  ;
  holen_V2 = dirV2 (regV "holen")  ;
  hollaendern_V = regV "holländern" ;
  homogenisieren_V2 = dirV2 (irregV "homogenisieren" "homogenisiert" "homogenisierte" "homogenisierte" "homogenisiert")  ;
  honen_V2 = dirV2 (regV "honen")  ;
  honorieren_V2 = dirV2 (regV "honorieren")  ;
  honorieren_VS = mkVS (regV "honorieren")  ;
  horchen_V = regV "horchen" ;
  hospitalisieren_V2 = dirV2 (regV "hospitalisieren")  ;
  hospitieren_loc_V2 = prepV2 (regV "hospitieren") loc_Prep ;
  hudeln_V = regV "hudeln" ;
  hudern_V2 = dirV2 (regV "hudern")  ;
  hudern_V = regV "hudern" ;
  huellen_in_V3 = dirV3 (regV "hüllen") (mkPrep "in" accusative) ;
  huepfen_V = regV "hüpfen" ;
  huesteln_V = regV "hüsteln" ;
  hueten_V2 = dirV2 (regV "hüten")  ;
  hueten_vor_rV2 = reflV2 (regV "hüten") accusative (mkPrep "vor" dative) ;
  huldigen_dat_V2 = mkV2 (regV "huldigen") datPrep ;
  humanisieren_sV2 = dassV2 (regV "humanisieren") accPrep ;
  humanisieren_V2 = dirV2 (regV "humanisieren")  ;
  humorisieren_V2 = dirV2 (regV "humorisieren")  ;
  hungern_nach_V2 = prepV2 (regV "hungern") nach_Prep ;
  hungern_V = regV "hungern" ;
  hunzen_V2 = dirV2 (regV "hunzen")  ;
  hupen_V = regV "hupen" ;
  huren_V = regV "huren" ;
  huschen_dir_V2 = prepV2 (regV "huschen") dir_Prep ;
  hussen_V = regV "hussen" ;
  husten_V = regV "husten" ;
  hybridisieren_V0 = mkV0 (regV "hybridisieren")  ;
  hydratisieren_V0 = mkV0 (regV "hydratisieren")  ;
  hydrieren_V = regV "hydrieren" ;
  hydrolisieren_V0 = mkV0 (regV "hydrolisieren")  ;
  hydrolysieren_V0 = mkV0 (regV "hydrolysieren")  ;
  hypen_V2 = dirV2 (regV "hypen")  ;
  hypostasieren_V2 = dirV2 (regV "hypostasieren")  ;
  iahen_V = regV "iahen" ;
  idealisieren_V2 = dirV2 (regV "idealisieren")  ;
  identifizieren_als_V3 = dirV3 (regV "identifizieren") (mkPrep "als" accusative) ;
  identifizieren_mit_rV2 = reflV2 (regV "identifizieren") accusative mit_Prep ;
  identifizieren_mit_V3 = dirV3 (regV "identifizieren") mit_Prep ;
  ideologisieren_V2 = dirV2 (regV "ideologisieren")  ;
  idolisieren_V2 = dirV2 (regV "idolisieren")  ;
  idyllisieren_V2 = dirV2 (regV "idyllisieren")  ;
  idyllisieren_VS = mkVS (regV "idyllisieren")  ;
  ignorieren_V2 = dirV2 (regV "ignorieren")  ;
  ignorieren_VS = mkVS (regV "ignorieren")  ;
  ihrzen_V2 = dirV2 (regV "ihrzen")  ;
  illuminieren_V2 = dirV2 (regV "illuminieren")  ;
  illustrieren_V2 = dirV2 (regV "illustrieren")  ;
  imitieren_V2 = dirV2 (irregV "imitieren" "imitiert" "imitierte" "imitierte" "imitiert")  ;
  imkern_V = irregV "imkern" "imkert" "imkerte" "imkerte" "imkert" ;
  immatrikulieren_am_V3 = dirV3 (regV "immatrikulieren") (mkPrep "an" dative) ;
  immatrikulieren_im_V3 = dirV3 (regV "immatrikulieren") (mkPrep "in" dative) ;
  immatrikulieren_loc_V3 = dirV3 (regV "immatrikulieren") loc_Prep ;
  immortalisieren_V2 = dirV2 (regV "immortalisieren")  ;
  immunisieren_V2 = dirV2 (regV "immunisieren")  ;
  immunreagieren_V = regV "immunreagieren" ;
  immunstimulieren_V = regV "immunstimulieren" ;
  impfen_gegen_V3 = dirV3 (regV "impfen") gegen_Prep ;
  implantieren_dat_V3 = accdatV3 (regV "implantieren")  ;
  implantieren_in_V3 = dirV3 (regV "implantieren") (mkPrep "in" accusative) ;
  implementieren_V2 = dirV2 (regV "implementieren")  ;
  implizieren_VS = mkVS (regV "implizieren")  ;
  imponieren_dat_sV2 = dassV2 (regV "imponieren") datPrep ;
  imponieren_dat_V2 = mkV2 (regV "imponieren") datPrep ;
  importieren_V2 = dirV2 (regV "importieren")  ;
  impraegnieren_V2 = dirV2 (regV "imprägnieren")  ;
  improvisieren_V2 = dirV2 (regV "improvisieren")  ;
  inaktivieren_V2 = dirV2 (regV "inaktivieren")  ;
  inaugurieren_V2 = dirV2 (regV "inaugurieren")  ;
  indexieren_V2 = dirV2 (regV "indexieren")  ;
  indignieren_rV = reflV (regV "indignieren") accusative ;
  indizieren_V2 = dirV2 (regV "indizieren")  ;
  indoktrinieren_mit_V3 = dirV3 (regV "indoktrinieren") mit_Prep ;
  indossieren_V2 = dirV2 (regV "indossieren")  ;
  industrialisieren_V2 = dirV2 (regV "industrialisieren")  ;
  induzieren_V2 = dirV2 (regV "induzieren")  ;
  infiltrieren_plV2 = pldirV2 (regV "infiltrieren")  ;
  infizieren_mit_V3 = dirV3 (regV "infizieren") mit_Prep ;
  influenzieren_V2 = dirV2 (regV "influenzieren")  ;
  informieren_ueber_V3 = dirV3 (regV "informieren") (mkPrep "über" accusative) ;
  inhaftieren_V2 = dirV2 (regV "inhaftieren")  ;
  inhalieren_V2 = dirV2 (regV "inhalieren")  ;
  inhibieren_V2 = dirV2 (regV "inhibieren")  ;
  initialisieren_V2 = dirV2 (regV "initialisieren")  ;
  initiieren_V2 = dirV2 (regV "initiieren")  ;
  initiieren_VS = mkVS (regV "initiieren")  ;
  injizieren_dat_V3 = accdatV3 (regV "injizieren")  ;
  inkommodieren_V2 = dirV2 (regV "inkommodieren")  ;
  inkorporieren_V2 = dirV2 (regV "inkorporieren")  ;
  inkriminieren_V2 = dirV2 (regV "inkriminieren")  ;
  inkubieren_V2 = dirV2 (regV "inkubieren")  ;
  innehaben_V2 = dirV2 (prefixV "inne" (irregV "haben" "hat" "hatte" "hatte" "gehabt"))  ;
  innehalten_V = prefixV "inne" (irregV "halten" "hält" "hielt" "hielte" "gehalten") ;
  innervieren_V2 = dirV2 (irregV "innervieren" "innerviert" "innervierte" "innervierte" "innerviert")  ;
  innewohnen_dat_sV2 = dassV2 (prefixV "inne" (regV "wohnen")) datPrep ;
  inquirieren_V2 = dirV2 (regV "inquirieren")  ;
  insinuieren_VS = mkVS (regV "insinuieren")  ;
  insistieren_auf_V2 = prepV2 (regV "insistieren") (mkPrep "auf" dative) ;
  inskribieren_rV = reflV (regV "inskribieren") accusative ;
  inspirieren_V2 = dirV2 (regV "inspirieren")  ;
  inspizieren_V2 = dirV2 (regV "inspizieren")  ;
  installieren_V2 = dirV2 (regV "installieren")  ;
  instillieren_V0 = mkV0 (regV "instillieren")  ;
  instituieren_V2 = dirV2 (regV "instituieren")  ;
  institutionalisieren_V2 = dirV2 (regV "institutionalisieren")  ;
  institutionalisieren_VS = mkVS (regV "institutionalisieren")  ;
  instruieren_V2 = dirV2 (regV "instruieren")  ;
  instrumentalisieren_V2 = dirV2 (regV "instrumentalisieren")  ;
  instrumentieren_V2 = dirV2 (regV "instrumentieren")  ;
  inszenieren_V2 = dirV2 (regV "inszenieren")  ;
  inszenieren_VS = mkVS (regV "inszenieren")  ;
  intarsieren_V2 = dirV2 (regV "intarsieren")  ;
  integrieren_in_V3 = dirV3 (regV "integrieren") (mkPrep "in" accusative) ;
  intellektualisieren_V2 = dirV2 (regV "intellektualisieren")  ;
  intendieren_VV = mkVV (regV "intendieren")  ;
  intensivieren_V2 = dirV2 (regV "intensivieren")  ;
  interagieren_mit_V2 = prepV2 (regV "interagieren") mit_Prep ;
  interessieren_fuer_rV2 = reflV2 (regV "interessieren") accusative fuer_Prep ;
  interessieren_sV2 = dassV2 (regV "interessieren") accPrep ;
  interessieren_V2 = dirV2 (regV "interessieren")  ;
  interferieren_plV = plV (regV "interferieren")  ;
  intermittieren_V = regV "intermittieren" ;
  internalisieren_V2 = dirV2 (regV "internalisieren")  ;
  internalisieren_VS = mkVS (regV "internalisieren")  ;
  internieren_V2 = dirV2 (regV "internieren")  ;
  interpellieren_V2 = dirV2 (regV "interpellieren")  ;
  interponieren_V = regV "interponieren" ;
  interpretieren_als_V3 = dirV3 (regV "interpretieren") (mkPrep "als" accusative) ;
  interpretieren_als_VS2 = mkVS2 (regV "interpretieren") (mkPrep "als" accusative) ;
  interpretieren_V2 = dirV2 (regV "interpretieren")  ;
  interpretieren_VS = mkVS (regV "interpretieren")  ;
  interpungieren_V = regV "interpungieren" ;
  interpunktieren_V2 = dirV2 (regV "interpunktieren")  ;
  interpunktieren_V = regV "interpunktieren" ;
  intervenieren_bei_V2 = prepV2 (regV "intervenieren") bei_Prep ;
  intervenieren_im_V2 = prepV2 (regV "intervenieren") (mkPrep "in" dative) ;
  interviewen_V2 = dirV2 (irregV "interviewen" "interviewt" "interviewte" "interviewte" "interviewt")  ;
  interzedieren_fuer_V2 = prepV2 (regV "interzedieren") fuer_Prep ;
  inthronisieren_V2 = dirV2 (regV "inthronisieren")  ;
  intonieren_V2 = dirV2 (regV "intonieren")  ;
  intrigieren_gegen_V2 = prepV2 (regV "intrigieren") gegen_Prep ;
  intubieren_V2 = dirV2 (regV "intubieren")  ;
  invadieren_plV2 = pldirV2 (regV "invadieren")  ;
  inventarisieren_V2 = dirV2 (regV "inventarisieren")  ;
  inventieren_V2 = dirV2 (regV "inventieren")  ;
  investieren_in_V3 = dirV3 (regV "investieren") (mkPrep "in" accusative) ;
  investigieren_V2 = dirV2 (regV "investigieren")  ;
  involvieren_in_V3 = dirV3 (regV "involvieren") (mkPrep "in" accusative) ;
  irisieren_V = regV "irisieren" ;
  ironisieren_V2 = dirV2 (regV "ironisieren")  ;
  ironisieren_VS = mkVS (regV "ironisieren")  ;
  irren_im_rV2 = reflV2 (regV "irren") accusative (mkPrep "in" dative) ;
  irren_im_V2 = prepV2 (regV "irren") (mkPrep "in" dative) ;
  irrigieren_V2 = dirV2 (regV "irrigieren")  ;
  irritieren_sV2 = dassV2 (regV "irritieren") accPrep ;
  irritieren_V2 = dirV2 (regV "irritieren")  ;
  islamisieren_V2 = dirV2 (regV "islamisieren")  ;
  isolieren_aus_V3 = dirV3 (regV "isolieren") aus_Prep ;
  isolieren_von_V3 = dirV3 (regV "isolieren") von_Prep ;
  italianisieren_V2 = dirV2 (regV "italianisieren")  ;
  italienisieren_V2 = dirV2 (regV "italienisieren")  ;
  jaehren_rV = reflV (regV "jähren") accusative ;
  jaeten_V2 = dirV2 (regV "jäten")  ;
  jagen_V2 = dirV2 (regV "jagen")  ;
  jammern_ueber_V2 = prepV2 (regV "jammern") (mkPrep "über" accusative) ;
  jammern_V = regV "jammern" ;
  japsen_V = regV "japsen" ;
  jauchen_V2 = dirV2 (regV "jauchen")  ;
  jauchzen_V = regV "jauchzen" ;
  jaulen_V = regV "jaulen" ;
  jausen_V = regV "jausen" ;
  jazzen_V = regV "jazzen" ;
  jobben_loc_V2 = prepV2 (regV "jobben") loc_Prep ;
  jodeln_V = regV "jodeln" ;
  joggen_dir_V2 = prepV2 (regV "joggen") dir_Prep ;
  johlen_V = regV "johlen" ;
  johlen_VS = mkVS (regV "johlen")  ;
  jonglieren_dir_V3 = dirV3 (regV "jonglieren") dir_Prep ;
  jonglieren_mit_V2 = prepV2 (regV "jonglieren") mit_Prep ;
  jubeln_ueber_V2 = prepV2 (regV "jubeln") (mkPrep "über" accusative) ;
  jubeln_VS = mkVS (regV "jubeln")  ;
  jubilieren_V = regV "jubilieren" ;
  jubilieren_VS = mkVS (regV "jubilieren")  ;
  juchen_V = regV "juchen" ;
  juchen_VS = mkVS (regV "juchen")  ;
  juchzen_V = regV "juchzen" ;
  juchzen_VS = mkVS (regV "juchzen")  ;
  jucken_es_V2 = dirV2 (regV "jucken")  ;
  jucken_iV2 = infzuV2 (regV "jucken") accPrep ;
  jumpen_dir_V2 = prepV2 (regV "jumpen") dir_Prep ;
  justieren_V2 = dirV2 (regV "justieren")  ;
  justifizieren_V2 = dirV2 (regV "justifizieren")  ;
  juxen_VS = mkVS (regV "juxen")  ;
  kacheln_V2 = dirV2 (regV "kacheln")  ;
  kacken_V = regV "kacken" ;
  kaduzieren_V2 = dirV2 (regV "kaduzieren")  ;
  kaelbern_V = regV "kälbern" ;
  kaelken_V2 = dirV2 (regV "kälken")  ;
  kaemmen_dat_V3 = accdatV3 (regV "kämmen")  ;
  kaemmen_rV = reflV (regV "kämmen") accusative ;
  kaempfen_mit_um_V3 = mkV3 (regV "kämpfen") mit_Prep um_Prep ;
  kaempfen_um_V2 = prepV2 (regV "kämpfen") um_Prep ;
  kalauern_V = regV "kalauern" ;
  kalben_V = regV "kalben" ;
  kalfatern_V2 = dirV2 (irregV "kalfatern" "kalfatert" "kalfaterte" "kalfatere" "kalfatert")  ;
  kalibrieren_V = regV "kalibrieren" ;
  kalken_V2 = dirV2 (regV "kalken")  ;
  kalkulieren_V2 = dirV2 (regV "kalkulieren")  ;
  kalligraphieren_V = regV "kalligraphieren" ;
  kalmieren_rV = reflV (regV "kalmieren") accusative ;
  kalorisieren_V2 = dirV2 (regV "kalorisieren")  ;
  kampeln_plV = plV (regV "kampeln")  ;
  kampieren_loc_V2 = prepV2 (regV "kampieren") loc_Prep ;
  kanalisieren_V2 = dirV2 (regV "kanalisieren")  ;
  kandidieren_fuer_V2 = prepV2 (regV "kandidieren") fuer_Prep ;
  kandieren_V2 = dirV2 (regV "kandieren")  ;
  kapern_V2 = dirV2 (regV "kapern")  ;
  kapieren_V2 = dirV2 (regV "kapieren")  ;
  kapieren_VS = mkVS (regV "kapieren")  ;
  kapitalisieren_V2 = dirV2 (regV "kapitalisieren")  ;
  kapitulieren_vor_V2 = prepV2 (regV "kapitulieren") (mkPrep "vor" dative) ;
  kappen_V2 = dirV2 (regV "kappen")  ;
  kaprizieren_auf_rV2 = reflV2 (regV "kaprizieren") accusative (mkPrep "auf" accusative) ;
  kaptivieren_V2 = dirV2 (regV "kaptivieren")  ;
  kaputtmachen_V2 = dirV2 (prefixV "kaputt" (regV "machen"))  ;
  karamellisieren_V2 = dirV2 (regV "karamellisieren")  ;
  karden_V2 = dirV2 (regV "karden")  ;
  karessieren_mit_V2 = prepV2 (regV "karessieren") mit_Prep ;
  karessieren_V2 = dirV2 (regV "karessieren")  ;
  karikieren_V2 = dirV2 (regV "karikieren")  ;
  karteln_plV = plV (regV "karteln")  ;
  kartografieren_V2 = dirV2 (regV "kartografieren")  ;
  kaschen_V2 = dirV2 (regV "kaschen")  ;
  kaschieren_V2 = dirV2 (regV "kaschieren")  ;
  kaschieren_VS = mkVS (regV "kaschieren")  ;
  kasemattieren_V2 = dirV2 (regV "kasemattieren")  ;
  kasernieren_V2 = dirV2 (regV "kasernieren")  ;
  kaspern_V = regV "kaspern" ;
  kassettieren_V2 = dirV2 (regV "kassettieren")  ;
  kassibern_V = irregV "kassibern" "kassibert" "kassiberte" "kassiberte" "kassibert" ;
  kassieren_V2 = dirV2 (regV "kassieren")  ;
  kasteien_rV = reflV (regV "kasteien") accusative ;
  kastrieren_V2 = dirV2 (regV "kastrieren")  ;
  katalogisieren_V2 = dirV2 (regV "katalogisieren")  ;
  katalysieren_V2 = dirV2 (regV "katalysieren")  ;
  katastrieren_V2 = dirV2 (regV "katastrieren")  ;
  katechisieren_V2 = dirV2 (regV "katechisieren")  ;
  kategorisieren_V2 = dirV2 (regV "kategorisieren")  ;
  katheterisieren_V2 = dirV2 (regV "katheterisieren")  ;
  kathetern_V2 = dirV2 (irregV "kathetern" "kathetert" "katheterte" "katheterte" "kathetert")  ;
  katholisieren_V2 = dirV2 (regV "katholisieren")  ;
  kauen_am_V2 = prepV2 (regV "kauen") (mkPrep "an" dative) ;
  kauen_V2 = dirV2 (regV "kauen")  ;
  kauern_loc_V2 = prepV2 (regV "kauern") loc_Prep ;
  kaufen_bei_fuer_V4 = dirV4 (regV "kaufen") bei_Prep fuer_Prep ;
  kaufen_im_fuer_V4 = dirV4 (regV "kaufen") (mkPrep "in" dative) fuer_Prep ;
  kaufen_von_fuer_V4 = dirV4 (regV "kaufen") von_Prep fuer_Prep ;
  kegeln_V = regV "kegeln" ;
  kehren_um_rV2 = reflV2 (regV "kehren") accusative um_Prep ;
  keifen_V = regV "keifen" ;
  keifen_VS = mkVS (regV "keifen")  ;
  kellnern_V = regV "kellnern" ;
  keltern_V2 = dirV2 (regV "keltern")  ;
  kennenlernen_V2 = dirV2 (prefixV "kennen" (regV "lernen"))  ;
  kennen_V2 = dirV2 (irregV "kennen" "kennt" "kannte" "kennte" "gekannt")  ;
  kennzeichnen_V2 = dirV2 (regV "kennzeichnen")  ;
  kentern_V = regV "kentern" ;
  keppeln_mit_rV2 = reflV2 (regV "keppeln") accusative mit_Prep ;
  ketteln_V2 = dirV2 (regV "ketteln")  ;
  ketten_an_V3 = dirV3 (regV "ketten") (mkPrep "an" accusative) ;
  ketten_dir_V3 = dirV3 (regV "ketten") dir_Prep ;
  ketzern_gegen_V2 = prepV2 (regV "ketzern") gegen_Prep ;
  keuchen_V2 = dirV2 (regV "keuchen")  ;
  keuchen_VS = mkVS (regV "keuchen")  ;
  kichern_V = regV "kichern" ;
  kicken_dir_V3 = dirV3 (regV "kicken") dir_Prep ;
  kidnappen_V2 = dirV2 (regV "kidnappen")  ;
  kiebitzen_V2 = dirV2 (regV "kiebitzen")  ;
  kieken_dir_V2 = prepV2 (regV "kieken") dir_Prep ;
  kiesen_V2 = dirV2 (regV "kiesen")  ;
  kiffen_V2 = dirV2 (regV "kiffen")  ;
  kiffen_V = regV "kiffen" ;
  killen_V2 = dirV2 (regV "killen")  ;
  kippen_dir_V3 = dirV3 (regV "kippen") dir_Prep ;
  kirren_V2 = dirV2 (regV "kirren")  ;
  kitten_V2 = dirV2 (regV "kitten")  ;
  kitzeln_V2 = dirV2 (regV "kitzeln")  ;
  klaeffen_V = regV "kläffen" ;
  klaeren_rV = reflV (regV "klären") accusative ;
  klaeren_VQ = mkVQ (regV "klären")  ;
  klaffen_loc_V2 = prepV2 (regV "klaffen") loc_Prep ;
  klagen_gegen_V2 = prepV2 (regV "klagen") gegen_Prep ;
  klagen_ueber_V2 = prepV2 (regV "klagen") (mkPrep "über" accusative) ;
  klammern_an_rV2 = reflV2 (regV "klammern") accusative (mkPrep "an" accusative) ;
  klampfen_V = regV "klampfen" ;
  klamuesern_V2 = dirV2 (irregV "klamüsern" "klamüsert" "klamüserte" "klamüserte" "klamüsert")  ;
  klappen_sV = dassV (regV "klappen")  ;
  klappern_V = regV "klappern" ;
  klarieren_V2 = dirV2 (regV "klarieren")  ;
  klassieren_als_V3 = dirV3 (regV "klassieren") (mkPrep "als" accusative) ;
  klassieren_V2 = dirV2 (regV "klassieren")  ;
  klassifizieren_V2 = dirV2 (regV "klassifizieren")  ;
  klatschen_V2 = dirV2 (regV "klatschen")  ;
  klatschen_V = regV "klatschen" ;
  klauben_aus_V3 = dirV3 (regV "klauben") aus_Prep ;
  klauben_von_V3 = dirV3 (regV "klauben") von_Prep ;
  klauen_dat_V3 = accdatV3 (regV "klauen")  ;
  kleben_dat_V3 = accdatV3 (regV "kleben")  ;
  kleben_dir_V3 = dirV3 (regV "kleben") dir_Prep ;
  kleben_V2 = dirV2 (regV "kleben")  ;
  kleckern_dir_V3 = dirV3 (regV "kleckern") dir_Prep ;
  klecksen_dir_V3 = dirV3 (regV "klecksen") dir_Prep ;
  kleiden_V2 = dirV2 (regV "kleiden")  ;
  kleinkriegen_V2 = dirV2 (prefixV "klein" (regV "kriegen"))  ;
  kleinreden_V2 = dirV2 (prefixV "klein" (regV "reden"))  ;
  kleinschreiben_V2 = dirV2 (prefixV "klein" (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben"))  ;
  kleistern_dir_V3 = dirV3 (regV "kleistern") dir_Prep ;
  kleistern_V2 = dirV2 (regV "kleistern")  ;
  klemmen_dir_V3 = dirV3 (regV "klemmen") dir_Prep ;
  klettern_auf_V2 = prepV2 (regV "klettern") (mkPrep "auf" accusative) ;
  klicken_dir_V2 = prepV2 (regV "klicken") dir_Prep ;
  klieben_V2 = dirV2 (irregV "klieben" "kliebt" "klob" "klöbe" "gekloben")  ;
  klimpern_mit_V2 = prepV2 (regV "klimpern") mit_Prep ;
  klingeln_V = regV "klingeln" ;
  klingen_nach_V2 = prepV2 (irregV "klingen" "klingt" "klang" "klänge" "geklungen") nach_Prep ;
  klirren_V = regV "klirren" ;
  kloehnen_mit_ueber_V3 = mkV3 (regV "klöhnen") mit_Prep (mkPrep "über" accusative) ;
  kloehnen_ueber_V2 = prepV2 (regV "klöhnen") (mkPrep "über" accusative) ;
  kloenen_mit_ueber_V3 = mkV3 (regV "klönen") mit_Prep (mkPrep "über" accusative) ;
  kloenen_ueber_V2 = prepV2 (regV "klönen") (mkPrep "über" accusative) ;
  kloetern_V = regV "klötern" ;
  klonen_V2 = dirV2 (regV "klonen")  ;
  klopfen_an_V2 = prepV2 (regV "klopfen") (mkPrep "an" accusative) ;
  klopfen_es_esV = esV (regV "klopfen")  ;
  kloppen_mit_rV2 = reflV2 (regV "kloppen") accusative mit_Prep ;
  kloppen_rV = reflV (regV "kloppen") accusative ;
  klotzen_V = regV "klotzen" ;
  kluegeln_V = regV "klügeln" ;
  kluengeln_mit_V2 = prepV2 (regV "klüngeln") mit_Prep ;
  knabbern_am_V2 = prepV2 (regV "knabbern") (mkPrep "an" dative) ;
  knacken_es_esV = esV (regV "knacken")  ;
  knacken_V2 = dirV2 (regV "knacken")  ;
  knallen_dir_V3 = dirV3 (regV "knallen") dir_Prep ;
  knapsen_am_V2 = prepV2 (regV "knapsen") (mkPrep "an" dative) ;
  knatschen_V = regV "knatschen" ;
  knattern_V = regV "knattern" ;
  knausern_mit_V2 = prepV2 (regV "knausern") mit_Prep ;
  knebeln_V2 = dirV2 (regV "knebeln")  ;
  knechten_V2 = dirV2 (regV "knechten")  ;
  kneifen_vor_V2 = prepV2 (irregV "kneifen" "kneift" "kniff" "kniffe" "gekniffen") (mkPrep "vor" dative) ;
  kneippen_V = regV "kneippen" ;
  kneten_V2 = dirV2 (regV "kneten")  ;
  knetschen_V = regV "knetschen" ;
  knicksen_V = regV "knicksen" ;
  knien_V = regV "knien" ;
  knietschen_V = regV "knietschen" ;
  kniffen_V2 = dirV2 (regV "kniffen")  ;
  knipsen_V2 = dirV2 (regV "knipsen")  ;
  knirschen_V = regV "knirschen" ;
  knistern_V = regV "knistern" ;
  knittern_V = regV "knittern" ;
  knobeln_am_V2 = prepV2 (regV "knobeln") (mkPrep "an" dative) ;
  knoepfen_V2 = dirV2 (regV "knöpfen")  ;
  knoten_an_V3 = dirV3 (regV "knoten") (mkPrep "an" accusative) ;
  knottern_V = regV "knottern" ;
  knuddeln_V2 = dirV2 (regV "knuddeln")  ;
  knuepfen_an_V3 = dirV3 (regV "knüpfen") (mkPrep "an" accusative) ;
  knueppeln_V2 = dirV2 (regV "knüppeln")  ;
  knuffen_V2 = dirV2 (regV "knuffen")  ;
  knurren_V2 = dirV2 (regV "knurren")  ;
  knurren_VS = mkVS (regV "knurren")  ;
  knuscheln_V = regV "knuscheln" ;
  knutschen_mit_V2 = prepV2 (regV "knutschen") mit_Prep ;
  knutschen_plV = plV (regV "knutschen")  ;
  knutschen_V2 = dirV2 (regV "knutschen")  ;
  koalieren_mit_V2 = prepV2 (regV "koalieren") mit_Prep ;
  koalieren_plV = plV (regV "koalieren")  ;
  koalisieren_V0 = mkV0 (irregV "koalisieren" "koalisiert" "koalisierte" "koalisierte" "koalisiert")  ;
  kobern_V = irregV "kobern" "kobert" "koberte" "koberte" "kobert" ;
  kochen_V2 = dirV2 (regV "kochen")  ;
  kodieren_V2 = dirV2 (regV "kodieren")  ;
  kodifizieren_V2 = dirV2 (regV "kodifizieren")  ;
  koecheln_V2 = dirV2 (regV "köcheln")  ;
  koedern_V2 = dirV2 (regV "ködern")  ;
  koelschen_V = regV "kölschen" ;
  koennen_inf_VV = auxVV (irregV "können" "kann" "konnte" "könnte" "gekonnt")  ;
  koepfeln_V2 = dirV2 (regV "köpfeln")  ;
  koepfeln_V = regV "köpfeln" ;
  koepfen_V2 = dirV2 (regV "köpfen")  ;
  kohlen_VS = mkVS (regV "kohlen")  ;
  koitieren_mit_V2 = prepV2 (regV "koitieren") mit_Prep ;
  kokeln_mit_V2 = prepV2 (regV "kokeln") mit_Prep ;
  kokettieren_mit_V2 = prepV2 (regV "kokettieren") mit_Prep ;
  koksen_V = regV "koksen" ;
  kollabieren_V = regV "kollabieren" ;
  kollaborieren_mit_V2 = prepV2 (regV "kollaborieren") mit_Prep ;
  kollaterieren_V = regV "kollaterieren" ;
  kollektivieren_V2 = dirV2 (regV "kollektivieren")  ;
  kollidieren_mit_V2 = prepV2 (regV "kollidieren") mit_Prep ;
  kolonialisieren_V2 = dirV2 (regV "kolonialisieren")  ;
  kolorieren_V2 = dirV2 (regV "kolorieren")  ;
  kolportieren_VS = mkVS (regV "kolportieren")  ;
  kombinieren_mit_V3 = dirV3 (regV "kombinieren") mit_Prep ;
  kombinieren_V2 = dirV2 (regV "kombinieren")  ;
  kommandieren_V2 = dirV2 (regV "kommandieren")  ;
  kommen_dir_V2 = prepV2 (irregV "kommen" "kommt" "kam" "käme" "gekommen") dir_Prep ;
  kommentieren_V2 = dirV2 (regV "kommentieren")  ;
  kommentieren_VS = mkVS (regV "kommentieren")  ;
  kommen_V = irregV "kommen" "kommt" "kam" "käme" "gekommen" ;
  kommerzialisieren_V2 = dirV2 (regV "kommerzialisieren")  ;
  kommissionieren_V2 = dirV2 (regV "kommissionieren")  ;
  kommunalisieren_V2 = dirV2 (regV "kommunalisieren")  ;
  kommunizieren_mit_ueber_V3 = mkV3 (regV "kommunizieren") mit_Prep (mkPrep "über" accusative) ;
  kommunizieren_mit_V2 = prepV2 (regV "kommunizieren") mit_Prep ;
  komparieren_mit_V3 = dirV3 (regV "komparieren") mit_Prep ;
  kompensieren_mit_V3 = dirV3 (regV "kompensieren") mit_Prep ;
  kompensieren_mit_VS2 = mkVS2 (regV "kompensieren") mit_Prep ;
  kompilieren_V2 = dirV2 (irregV "kompilieren" "kompiliert" "kompilierte" "kompilierte" "kompiliert")  ;
  komplementieren_V2 = dirV2 (regV "komplementieren")  ;
  komplettieren_V2 = dirV2 (regV "komplettieren")  ;
  komplexieren_V0 = mkV0 (regV "komplexieren")  ;
  komplimentieren_dir_V3 = dirV3 (regV "komplimentieren") dir_Prep ;
  komplizieren_V2 = dirV2 (regV "komplizieren")  ;
  komponieren_V2 = dirV2 (regV "komponieren")  ;
  komprimieren_V2 = dirV2 (regV "komprimieren")  ;
  kompromisseln_V = regV "kompromisseln" ;
  kompromittieren_mit_V3 = dirV3 (regV "kompromittieren") mit_Prep ;
  kompromittieren_sV2 = dassV2 (regV "kompromittieren") accPrep ;
  kompromittieren_V2 = dirV2 (regV "kompromittieren")  ;
  kondensieren_V = regV "kondensieren" ;
  kondizieren_V2 = dirV2 (regV "kondizieren")  ;
  kondolieren_dat_V2 = mkV2 (regV "kondolieren") datPrep ;
  konfektionieren_V2 = dirV2 (regV "konfektionieren")  ;
  konferieren_mit_V2 = prepV2 (regV "konferieren") mit_Prep ;
  konferieren_plV = plV (regV "konferieren")  ;
  konfessionalisieren_V2 = dirV2 (regV "konfessionalisieren")  ;
  konfigurieren_V2 = dirV2 (irregV "konfigurieren" "konfiguriert" "konfigurierte" "konfigurierte" "konfiguriert")  ;
  konfiszieren_V2 = dirV2 (regV "konfiszieren")  ;
  konfligieren_mit_V2 = prepV2 (regV "konfligieren") mit_Prep ;
  konfrontieren_mit_V3 = dirV3 (regV "konfrontieren") mit_Prep ;
  konfundieren_mit_V3 = dirV3 (regV "konfundieren") mit_Prep ;
  konjugieren_V2 = dirV2 (regV "konjugieren")  ;
  konkatenieren_mit_V3 = dirV3 (regV "konkatenieren") mit_Prep ;
  konkludieren_VS = mkVS (regV "konkludieren")  ;
  konkretisieren_V2 = dirV2 (regV "konkretisieren")  ;
  konkurrieren_mit_V2 = prepV2 (regV "konkurrieren") mit_Prep ;
  konnotieren_V2 = dirV2 (regV "konnotieren")  ;
  konsekrieren_V2 = dirV2 (regV "konsekrieren")  ;
  konservieren_V2 = dirV2 (regV "konservieren")  ;
  konsolidieren_V2 = dirV2 (regV "konsolidieren")  ;
  konspektieren_V2 = dirV2 (regV "konspektieren")  ;
  konspirieren_gegen_V2 = prepV2 (regV "konspirieren") gegen_Prep ;
  konspirieren_mit_gegen_V3 = mkV3 (regV "konspirieren") mit_Prep gegen_Prep ;
  konstatieren_V2 = dirV2 (regV "konstatieren")  ;
  konstatieren_VS = mkVS (regV "konstatieren")  ;
  konsternieren_sV2 = dassV2 (regV "konsternieren") accPrep ;
  konsternieren_V2 = dirV2 (regV "konsternieren")  ;
  konstituieren_rV = reflV (regV "konstituieren") accusative ;
  konstituieren_V2 = dirV2 (regV "konstituieren")  ;
  konstruieren_V2 = dirV2 (regV "konstruieren")  ;
  konsultieren_V2 = dirV2 (regV "konsultieren")  ;
  konsumieren_V2 = dirV2 (regV "konsumieren")  ;
  kontaktieren_V2 = dirV2 (irregV "kontaktieren" "kontaktiert" "kontaktierte" "kontaktierte" "kontaktiert")  ;
  kontaminieren_mit_V3 = dirV3 (regV "kontaminieren") mit_Prep ;
  konterfeien_V2 = dirV2 (irregV "konterfeien" "konterfeit" "konterfeite" "konterfeite" "gekonterfeit")  ;
  konterkarieren_VS = mkVS (regV "konterkarieren")  ;
  konterminieren_V2 = dirV2 (regV "konterminieren")  ;
  konterminieren_V = regV "konterminieren" ;
  kontern_mit_V3 = dirV3 (regV "kontern") mit_Prep ;
  kontern_V = regV "kontern" ;
  kontern_VS = mkVS (regV "kontern")  ;
  kontingentieren_V2 = dirV2 (regV "kontingentieren")  ;
  kontinuieren_V2 = dirV2 (regV "kontinuieren")  ;
  kontrahieren_V2 = dirV2 (irregV "kontrahieren" "kontrahiert" "kontrahierte" "kontrahierte" "kontrahiert")  ;
  kontrastieren_mit_V3 = dirV3 (regV "kontrastieren") mit_Prep ;
  kontrastieren_V2 = dirV2 (regV "kontrastieren")  ;
  kontrollieren_V2 = dirV2 (regV "kontrollieren")  ;
  kontrollieren_VS = mkVS (regV "kontrollieren")  ;
  konturieren_V2 = dirV2 (regV "konturieren")  ;
  konvenieren_dat_sV2 = dassV2 (irregV "konvenieren" "konveniert" "konvenierte" "konvenierte" "konveniert") datPrep ;
  konvergieren_plV = plV (irregV "konvergieren" "konvergiert" "konvergierte" "konvergierte" "konvergiert")  ;
  konversieren_mit_V2 = prepV2 (irregV "konversieren" "konversiert" "konversierte" "konversierte" "konversiert") mit_Prep ;
  konvertieren_zu_V2 = prepV2 (irregV "konvertieren" "konvertiert" "konvertierte" "konvertierte" "konvertiert") zu_Prep ;
  konzedieren_dat_V2S = mkV2S (irregV "konzedieren" "konzediert" "konzedierte" "konzedierte" "konzediert") datPrep ;
  konzentrieren_auf_rV2 = reflV2 (irregV "konzentrieren" "konzentriert" "konzentrierte" "konzentrierte" "konzentriert") accusative (mkPrep "auf" accusative) ;
  konzeptualisieren_V2 = dirV2 (regV "konzeptualisieren")  ;
  konzertieren_loc_rV2 = reflV2 (irregV "konzertieren" "konzertiert" "konzertierte" "konzertierte" "konzertiert") accusative loc_Prep ;
  konzipieren_V2 = dirV2 (regV "konzipieren")  ;
  kooperieren_mit_V2 = prepV2 (irregV "kooperieren" "kooperiert" "kooperierte" "kooperierte" "kooperiert") mit_Prep ;
  kooptieren_V2 = dirV2 (irregV "kooptieren" "kooptiert" "kooptierte" "kooptierte" "kooptiert")  ;
  koordinieren_mit_V3 = dirV3 (regV "koordinieren") mit_Prep ;
  koordinieren_V2 = dirV2 (regV "koordinieren")  ;
  kopieren_V2 = dirV2 (regV "kopieren")  ;
  kopieren_VQ = mkVQ (regV "kopieren")  ;
  koppeln_an_V3 = dirV3 (regV "koppeln") (mkPrep "an" accusative) ;
  koppen_V2 = dirV2 (irregV "koppen" "koppt" "koppte" "koppte" "koppt")  ;
  koppen_V = irregV "koppen" "koppt" "koppte" "koppte" "koppt" ;
  kopulieren_plV = plV (irregV "kopulieren" "kopuliert" "kopulierte" "kopulierte" "kopuliert")  ;
  korrelieren_mit_V3 = dirV3 (regV "korrelieren") mit_Prep ;
  korrelieren_V2 = dirV2 (regV "korrelieren")  ;
  korrespondieren_mit_V2 = prepV2 (regV "korrespondieren") mit_Prep ;
  korrigieren_V2 = dirV2 (regV "korrigieren")  ;
  korrumpieren_sV2 = dassV2 (regV "korrumpieren") accPrep ;
  korrumpieren_V2 = dirV2 (regV "korrumpieren")  ;
  kosen_V2 = dirV2 (regV "kosen")  ;
  kosten_V2 = dirV2 (regV "kosten")  ;
  kostuemieren_V2 = dirV2 (regV "kostümieren")  ;
  koten_V = regV "koten" ;
  kotieren_V2 = dirV2 (regV "kotieren")  ;
  kotonisieren_V2 = dirV2 (regV "kotonisieren")  ;
  kotzen_V = regV "kotzen" ;
  krabbeln_V = regV "krabbeln" ;
  krachen_mit_rV2 = reflV2 (regV "krachen") accusative mit_Prep ;
  krachen_rV = reflV (regV "krachen") accusative ;
  kraechzen_V2 = dirV2 (regV "krächzen")  ;
  kraechzen_VS = mkVS (regV "krächzen")  ;
  kraehen_V2 = dirV2 (regV "krähen")  ;
  kraehen_VS = mkVS (regV "krähen")  ;
  kraengen_rV = reflV (regV "krängen") accusative ;
  kraenkeln_V = regV "kränkeln" ;
  kraenken_mit_V3 = dirV3 (regV "kränken") mit_Prep ;
  kraenken_sV2 = dassV2 (regV "kränken") accPrep ;
  kraenken_V2 = dirV2 (regV "kränken")  ;
  kraeuseln_V2 = dirV2 (regV "kräuseln")  ;
  krakeelen_V2 = dirV2 (regV "krakeelen")  ;
  krakeelen_V = regV "krakeelen" ;
  krakeelen_VS = mkVS (regV "krakeelen")  ;
  krakeln_dir_V3 = dirV3 (regV "krakeln") dir_Prep ;
  krallen_rV2 = reflV2 (regV "krallen") accusative accPrep ;
  kramen_aus_V3 = dirV3 (regV "kramen") aus_Prep ;
  kramen_in_nach_V3 = mkV3 (regV "kramen") (mkPrep "in" accusative) nach_Prep ;
  kranken_am_V2 = prepV2 (regV "kranken") (mkPrep "an" dative) ;
  krankschreiben_V2 = dirV2 (prefixV "krank" (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben"))  ;
  kratzen_V2 = dirV2 (regV "kratzen")  ;
  kratzen_V = regV "kratzen" ;
  krauchen_V = regV "krauchen" ;
  kraulen_dir_V2 = prepV2 (regV "kraulen") dir_Prep ;
  kraulen_V2 = dirV2 (regV "kraulen")  ;
  kraulen_V = regV "kraulen" ;
  krawallen_V = irregV "krawallen" "krawallt" "krawallte" "krawallte" "krawallt" ;
  krawallieren_V = regV "krawallieren" ;
  kraxeln_auf_V2 = prepV2 (regV "kraxeln") (mkPrep "auf" accusative) ;
  kraxeln_dir_V2 = prepV2 (regV "kraxeln") dir_Prep ;
  kredenzen_dat_V3 = accdatV3 (regV "kredenzen")  ;
  kreditieren_V = regV "kreditieren" ;
  kreiden_V2 = dirV2 (regV "kreiden")  ;
  kreiden_V = regV "kreiden" ;
  kreieren_V2 = dirV2 (regV "kreieren")  ;
  kreischen_V2 = dirV2 (regV "kreischen")  ;
  kreischen_V = regV "kreischen" ;
  kreischen_VS = mkVS (regV "kreischen")  ;
  kreisen_um_V2 = prepV2 (regV "kreisen") um_Prep ;
  kreissen_V = regV "kreißen" ;
  kremieren_V2 = dirV2 (regV "kremieren")  ;
  krepieren_V = regV "krepieren" ;
  kreuzen_mit_V3 = dirV3 (regV "kreuzen") mit_Prep ;
  kreuzen_V2 = dirV2 (regV "kreuzen")  ;
  kreuzhybridisieren_V0 = mkV0 (regV "kreuzhybridisieren")  ;
  kreuzigen_V2 = dirV2 (regV "kreuzigen")  ;
  kreuzreagieren_V0 = mkV0 (regV "kreuzreagieren")  ;
  kribbeln_V = regV "kribbeln" ;
  kriechen_V = irregV "kriechen" "kriecht" "kroch" "kröche" "gekrochen" ;
  kriegen_V2 = dirV2 (regV "kriegen")  ;
  kriminalisieren_V2 = dirV2 (regV "kriminalisieren")  ;
  kringeln_V2 = dirV2 (regV "kringeln")  ;
  kritikastern_V = irregV "kritikastern" "kritikastert" "kritikasterte" "kritikasterte" "kritikastert" ;
  kritisieren_V2 = dirV2 (regV "kritisieren")  ;
  kritisieren_VS = mkVS (regV "kritisieren")  ;
  kritteln_am_V2 = prepV2 (regV "kritteln") (mkPrep "an" dative) ;
  kritzeln_dir_V3 = dirV3 (regV "kritzeln") dir_Prep ;
  kroekeln_V = regV "krökeln" ;
  kroenen_V2 = dirV2 (regV "krönen")  ;
  kronen_V2 = dirV2 (regV "kronen")  ;
  kruemeln_auf_V3 = dirV3 (regV "krümeln") (mkPrep "auf" accusative) ;
  kruemeln_dir_V3 = dirV3 (regV "krümeln") dir_Prep ;
  kruemeln_in_V3 = dirV3 (regV "krümeln") (mkPrep "in" accusative) ;
  kruemmen_V2 = dirV2 (regV "krümmen")  ;
  kruschteln_V0 = mkV0 (regV "kruschteln")  ;
  kucken_V = regV "kucken" ;
  kuefern_V2 = dirV2 (regV "küfern")  ;
  kuehlen_V2 = dirV2 (regV "kühlen")  ;
  kuemmeln_V2 = dirV2 (regV "kümmeln")  ;
  kuemmern_sV2 = dassV2 (regV "kümmern") accPrep ;
  kuemmern_um_rV2 = reflV2 (regV "kümmern") accusative um_Prep ;
  kuemmern_V2 = dirV2 (regV "kümmern")  ;
  kuendigen_dat_V3 = accdatV3 (regV "kündigen")  ;
  kuensteln_V = regV "künsteln" ;
  kueren_zu_V3 = dirV3 (regV "küren") zu_Prep ;
  kuerzen_V2 = dirV2 (regV "kürzen")  ;
  kuessen_V2 = dirV2 (regV "küssen")  ;
  kugeln_dir_V3 = dirV3 (regV "kugeln") dir_Prep ;
  kugeln_rV = reflV (regV "kugeln") accusative ;
  kujonieren_V2 = dirV2 (regV "kujonieren")  ;
  kullern_dir_V3 = dirV3 (regV "kullern") dir_Prep ;
  kulminieren_im_V2 = prepV2 (regV "kulminieren") (mkPrep "in" dative) ;
  kultivieren_V2 = dirV2 (regV "kultivieren")  ;
  kumulieren_mit_V3 = dirV3 (regV "kumulieren") mit_Prep ;
  kumulieren_V2 = dirV2 (regV "kumulieren")  ;
  kundtun_VS = mkVS (irregV "kundtun" "tut" "tat" "täte" "getan")  ;
  kungeln_mit_V2 = prepV2 (regV "kungeln") mit_Prep ;
  kungeln_plV = plV (regV "kungeln")  ;
  kupfern_V2 = dirV2 (regV "kupfern")  ;
  kupieren_V2 = dirV2 (regV "kupieren")  ;
  kuppeln_V2 = dirV2 (regV "kuppeln")  ;
  kuppeln_V = regV "kuppeln" ;
  kuratieren_V2 = dirV2 (regV "kuratieren")  ;
  kurbeln_am_V2 = prepV2 (regV "kurbeln") (mkPrep "an" dative) ;
  kuren_V = regV "kuren" ;
  kurieren_V2 = dirV2 (regV "kurieren")  ;
  kursieren_V = regV "kursieren" ;
  kuscheln_dir_rV2 = reflV2 (regV "kuscheln") accusative dir_Prep ;
  kuscheln_mit_V2 = prepV2 (regV "kuscheln") mit_Prep ;
  kuscheln_plV = plV (regV "kuscheln")  ;
  kuschen_vor_V2 = prepV2 (regV "kuschen") (mkPrep "vor" dative) ;
  kutschieren_dir_V2 = prepV2 (regV "kutschieren") dir_Prep ;
  kutschieren_dir_V3 = dirV3 (regV "kutschieren") dir_Prep ;
  laben_V2 = dirV2 (regV "laben")  ;
  labern_V2 = dirV2 (regV "labern")  ;
  labern_VS = mkVS (regV "labern")  ;
  laborieren_am_V2 = prepV2 (regV "laborieren") (mkPrep "an" dative) ;
  laborieren_V = regV "laborieren" ;
  lachen_ueber_V2 = prepV2 (regV "lachen") (mkPrep "über" accusative) ;
  lachen_V = regV "lachen" ;
  lacken_V2 = dirV2 (regV "lacken")  ;
  lackieren_V2 = dirV2 (regV "lackieren")  ;
  lackmeiern_V2 = dirV2 (regV "lackmeiern")  ;
  laden_V2 = dirV2 (irregV "laden" "lädt" "lud" "lüde" "geladen")  ;
  laecheln_V = regV "lächeln" ;
  laedieren_V2 = dirV2 (regV "lädieren")  ;
  laehmen_V2 = dirV2 (regV "lähmen")  ;
  laengen_V2 = dirV2 (regV "längen")  ;
  laeppen_V2 = dirV2 (regV "läppen")  ;
  laeppern_rV = reflV (regV "läppern") accusative ;
  laermen_V = regV "lärmen" ;
  laestern_ueber_V2 = prepV2 (regV "lästern") (mkPrep "über" accusative) ;
  laeuten_an_V2 = prepV2 (regV "läuten") (mkPrep "an" accusative) ;
  laeuten_mit_V2 = prepV2 (regV "läuten") mit_Prep ;
  laeuten_V2 = dirV2 (regV "läuten")  ;
  laeutern_sV2 = dassV2 (regV "läutern") accPrep ;
  laeutern_V2 = dirV2 (regV "läutern")  ;
  lagern_loc_V3 = dirV3 (regV "lagern") loc_Prep ;
  lahmlegen_V2 = dirV2 (prefixV "lahm" (regV "legen"))  ;
  laiben_V2 = dirV2 (regV "laiben")  ;
  lakonisieren_V2 = dirV2 (regV "lakonisieren")  ;
  laktieren_V2 = dirV2 (regV "laktieren")  ;
  lallen_V2 = dirV2 (regV "lallen")  ;
  lallen_V = regV "lallen" ;
  lallen_VS = mkVS (regV "lallen")  ;
  lamentieren_ueber_V2 = prepV2 (regV "lamentieren") (mkPrep "über" accusative) ;
  lancieren_V2 = dirV2 (regV "lancieren")  ;
  landen_loc_V3 = dirV3 (regV "landen") loc_Prep ;
  langen_dat_sV2 = dassV2 (regV "langen") datPrep ;
  langen_dat_V2 = mkV2 (regV "langen") datPrep ;
  langen_dir_V2 = prepV2 (regV "langen") dir_Prep ;
  langen_dir_V3 = dirV3 (regV "langen") dir_Prep ;
  langweilen_V2 = dirV2 (regV "langweilen")  ;
  lasieren_V2 = dirV2 (regV "lasieren")  ;
  lassen_VV = mkVV (irregV "lassen" "lasst" "ließ" "ließe" "gelassen")  ;
  latinisieren_V2 = dirV2 (regV "latinisieren")  ;
  latschen_dir_V2 = prepV2 (regV "latschen") dir_Prep ;
  lauern_auf_V2 = prepV2 (regV "lauern") (mkPrep "auf" accusative) ;
  laufen_V = irregV "laufen" "läuft" "lief" "liefe" "gelaufen" ;
  lauschen_dat_V2 = mkV2 (regV "lauschen") datPrep ;
  lausen_V2 = dirV2 (regV "lausen")  ;
  lauten_V = regV "lauten" ;
  lavieren_V = regV "lavieren" ;
  layouten_V2 = dirV2 (regV "layouten")  ;
  leasen_bei_fuer_V4 = dirV4 (regV "leasen") bei_Prep fuer_Prep ;
  leasen_von_fuer_V4 = dirV4 (regV "leasen") von_Prep fuer_Prep ;
  leben_loc_V2 = prepV2 (regV "leben") loc_Prep ;
  lechzen_nach_V2 = prepV2 (regV "lechzen") nach_Prep ;
  lecken_am_V2 = prepV2 (regV "lecken") (mkPrep "an" dative) ;
  lecken_V2 = dirV2 (regV "lecken")  ;
  lecken_V = regV "lecken" ;
  ledern_V2 = dirV2 (regV "ledern")  ;
  leeren_V2 = dirV2 (regV "leeren")  ;
  legalisieren_V2 = dirV2 (regV "legalisieren")  ;
  legalisieren_VS = mkVS (regV "legalisieren")  ;
  legen_dir_V3 = dirV3 (regV "legen") dir_Prep ;
  legieren_V2 = dirV2 (irregV "legieren" "legiert" "legierte" "legierte" "legiert")  ;
  legitimieren_V2 = dirV2 (regV "legitimieren")  ;
  legitimieren_VS = mkVS (regV "legitimieren")  ;
  legitimisieren_V2 = dirV2 (regV "legitimisieren")  ;
  legitimisieren_VS = mkVS (regV "legitimisieren")  ;
  lehnen_an_V3 = dirV3 (regV "lehnen") (mkPrep "an" accusative) ;
  lehnen_gegen_V3 = dirV3 (regV "lehnen") gegen_Prep ;
  lehren_V2S = dirV2S (regV "lehren")  ;
  lehren_V3 = dirV3 (regV "lehren") accPrep ;
  leiben_V = regV "leiben" ;
  leichtern_V2 = dirV2 (regV "leichtern")  ;
  leiden_am_V2 = prepV2 (irregV "leiden" "leidet" "litt" "litte" "gelitten") (mkPrep "an" dative) ;
  leiden_V2 = dirV2 (irregV "leiden" "leidet" "litt" "litte" "gelitten")  ;
  leidtun_dat_sV2 = dassV2 (prefixV "leid" (irregV "tun" "tut" "tat" "täte" "getan")) datPrep ;
  leidtun_dat_V2 = mkV2 (prefixV "leid" (irregV "tun" "tut" "tat" "täte" "getan")) datPrep ;
  leihen_bei_rV3 = reflV3 (irregV "leihen" "leiht" "lieh" "liehe" "geliehen") accusative accPrep bei_Prep ;
  leihen_dat_V3 = accdatV3 (irregV "leihen" "leiht" "lieh" "liehe" "geliehen")  ;
  leihen_im_rV3 = reflV3 (irregV "leihen" "leiht" "lieh" "liehe" "geliehen") accusative accPrep (mkPrep "in" dative) ;
  leihen_von_rV3 = reflV3 (irregV "leihen" "leiht" "lieh" "liehe" "geliehen") accusative accPrep von_Prep ;
  leimen_V2 = dirV2 (regV "leimen")  ;
  leisten_rV2 = reflV2 (irregV "leisten" "leistet" "leistete" "leiste" "geleistet") accusative accPrep ;
  leisten_V2 = dirV2 (irregV "leisten" "leistet" "leistete" "leiste" "geleistet")  ;
  leitartikeln_V = regV "leitartikeln" ;
  leiten_V2 = dirV2 (irregV "leiten" "leitet" "leitete" "leite" "geleitet")  ;
  lemmatisieren_V0 = mkV0 (regV "lemmatisieren")  ;
  lenken_V2 = dirV2 (regV "lenken")  ;
  lenzen_V2 = dirV2 (regV "lenzen")  ;
  lenzen_V = regV "lenzen" ;
  lernen_V2 = dirV2 (regV "lernen")  ;
  lesen_V2 = dirV2 (irregV "lesen" "lest" "las" "läse" "gelesen")  ;
  lesen_VS = mkVS (irregV "lesen" "lest" "las" "läse" "gelesen")  ;
  letzen_rV = reflV (regV "letzen") accusative ;
  leuchten_dat_V2 = mkV2 (regV "leuchten") datPrep ;
  leuchten_V = regV "leuchten" ;
  leugnen_V2 = dirV2 (regV "leugnen")  ;
  leugnen_VS = mkVS (regV "leugnen")  ;
  levitieren_V2 = dirV2 (regV "levitieren")  ;
  liberalisieren_V2 = dirV2 (regV "liberalisieren")  ;
  liebaeugeln_mit_V2 = prepV2 (regV "liebäugeln") mit_Prep ;
  liebbehalten_V2 = dirV2 (prefixV "lieb" (irregV "behalten" "behält" "behielt" "behielte" "behalten"))  ;
  lieben_V2 = dirV2 (regV "lieben")  ;
  lieben_VS = mkVS (regV "lieben")  ;
  liebhaben_V2 = dirV2 (prefixV "lieb" (irregV "haben" "hat" "hatte" "hatte" "gehabt"))  ;
--  liebhaben_V = prefixV "lieb" (irregV "haben" "hat" "hatte" "hatte" "") ;
  liebkosen_V2 = dirV2 (regV "liebkosen")  ;
  liefern_dat_V3 = accdatV3 (regV "liefern")  ;
  liegen_loc_V2 = prepV2 (irregV "liegen" "liegt" "lag" "läge" "gelegen") loc_Prep ;
  liegen_V = irregV "liegen" "liegt" "lag" "läge" "gelegen" ;
  liften_V2 = dirV2 (regV "liften")  ;
  ligieren_V0 = mkV0 (regV "ligieren")  ;
  liieren_mit_V3 = dirV3 (regV "liieren") mit_Prep ;
  liieren_rV = reflV (regV "liieren") accusative ;
  liieren_V2 = dirV2 (regV "liieren")  ;
  limitieren_V2 = dirV2 (regV "limitieren")  ;
  linken_V2 = dirV2 (regV "linken")  ;
  liquidieren_V2 = dirV2 (regV "liquidieren")  ;
  lispeln_V = regV "lispeln" ;
  literarisieren_V2 = dirV2 (regV "literarisieren")  ;
  lithografieren_V2 = dirV2 (regV "lithografieren")  ;
  lithographieren_V2 = dirV2 (regV "lithographieren")  ;
  lizenzieren_V2 = dirV2 (regV "lizenzieren")  ;
  loben_V2 = dirV2 (regV "loben")  ;
  loben_VS = mkVS (regV "loben")  ;
  lobhudeln_dat_V2 = mkV2 (regV "lobhudeln") datPrep ;
  lobpreisen_V2 = dirV2 (irregV "lobpreisen" "lobpreist" "lobpries" "lobpries" "lobgepriesen")  ;
  locken_dir_V3 = dirV3 (regV "locken") dir_Prep ;
  lockern_V2 = dirV2 (regV "lockern")  ;
  loechern_V2 = dirV2 (regV "löchern")  ;
  loecken_gegen_V2 = prepV2 (regV "löcken") gegen_Prep ;
  loeffeln_V2 = dirV2 (regV "löffeln")  ;
  loehnen_an_fuer_V4 = dirV4 (regV "löhnen") (mkPrep "an" accusative) fuer_Prep ;
  loeschen_V2 = dirV2 (regV "löschen")  ;
  loesen_aus_V3 = dirV3 (regV "lösen") aus_Prep ;
  loesen_im_V3 = dirV3 (regV "lösen") (mkPrep "in" dative) ;
  loesen_von_V3 = dirV3 (regV "lösen") von_Prep ;
  loeten_V2 = dirV2 (regV "löten")  ;
  logarithmieren_V2 = dirV2 (regV "logarithmieren")  ;
  loggen_V2 = dirV2 (regV "loggen")  ;
  logieren_loc_V2 = prepV2 (regV "logieren") loc_Prep ;
  lohen_V = regV "lohen" ;
  lohnen_dat_V2S = mkV2S (regV "lohnen") datPrep ;
  lohnen_dat_V3 = accdatV3 (regV "lohnen")  ;
  lohnen_fuer_rV2 = reflV2 (regV "lohnen") accusative fuer_Prep ;
  lokalisieren_V2 = dirV2 (regV "lokalisieren")  ;
  lorgnettieren_V2 = dirV2 (regV "lorgnettieren")  ;
  losen_mit_um_V3 = mkV3 (regV "losen") mit_Prep um_Prep ;
  losen_um_V2 = prepV2 (regV "losen") um_Prep ;
  losketten_V2 = dirV2 (prefixV "los" (regV "ketten"))  ;
  losketten_von_V3 = dirV3 (prefixV "los" (regV "ketten")) von_Prep ;
  loslassen_V2 = dirV2 (prefixV "los" (irregV "lassen" "lässt" "ließ" "ließe" "gelassen"))  ;
  losschlagen_mit_V2 = prepV2 (prefixV "los" (irregV "schlagen" "schlägt" "schlug" "schlüge" "geschlagen")) mit_Prep ;
  losschlagen_V2 = dirV2 (prefixV "los" (irregV "schlagen" "schlägt" "schlug" "schlüge" "geschlagen"))  ;
  lostaeuen_von_V3 = dirV3 (prefixV "los" (regV "täuen")) von_Prep ;
  lotsen_dir_V3 = dirV3 (regV "lotsen") dir_Prep ;
  luebeckern_V = regV "lübeckern" ;
  lueften_V2 = dirV2 (regV "lüften")  ;
  luegen_VS = mkVS (irregV "lügen" "lügt" "log" "löge" "gelogen")  ;
  luepfen_V2 = dirV2 (regV "lüpfen")  ;
  lugen_dir_V2 = prepV2 (regV "lugen") dir_Prep ;
  lukrieren_V2 = dirV2 (regV "lukrieren")  ;
  lullen_am_V2 = prepV2 (regV "lullen") (mkPrep "an" dative) ;
  lullen_in_V2 = prepV2 (regV "lullen") (mkPrep "in" accusative) ;
  lunchen_V = regV "lunchen" ;
  lungern_loc_V2 = prepV2 (regV "lungern") loc_Prep ;
  lupfen_V2 = dirV2 (regV "lupfen")  ;
  luschern_V = regV "luschern" ;
  lustwandeln_V = regV "lustwandeln" ;
  lynchen_V2 = dirV2 (regV "lynchen")  ;
  lysieren_V2 = dirV2 (regV "lysieren")  ;
  machen_rV = reflV (regV "machen") accusative ;
  machen_V2 = dirV2 (regV "machen")  ;
  machen_VS = mkVS (regV "machen")  ;
  machen_zu_V3 = dirV3 (regV "machen") zu_Prep ;
  madjarisieren_V2 = dirV2 (regV "madjarisieren")  ;
  maeandern_V = regV "mäandern" ;
  maeandrieren_V = regV "mäandrieren" ;
  maehen_V2 = dirV2 (regV "mähen")  ;
  maehlen_dat_V3 = accdatV3 (regV "mählen")  ;
  maehlen_V2 = dirV2 (regV "mählen")  ;
  maekeln_V = regV "mäkeln" ;
  maelzen_V2 = dirV2 (regV "mälzen")  ;
  maessigen_rV = reflV (regV "mäßigen") accusative ;
  maessigen_V2 = dirV2 (regV "mäßigen")  ;
  maesten_V2 = dirV2 (regV "mästen")  ;
  magazinieren_V2 = dirV2 (regV "magazinieren")  ;
  mahlen_V2 = dirV2 (regV "mahlen")  ;
  mahnen_zu_V3 = dirV3 (regV "mahnen") zu_Prep ;
  maikaefern_V = regV "maikäfern" ;
  mailen_dat_V2S = mkV2S (regV "mailen") datPrep ;
  mailen_dat_V3 = accdatV3 (regV "mailen")  ;
  majorisieren_V2 = dirV2 (regV "majorisieren")  ;
  maledeien_V2 = dirV2 (regV "maledeien")  ;
  malen_V2 = dirV2 (regV "malen")  ;
  malern_V2 = dirV2 (regV "malern")  ;
  malmen_mit_V2 = prepV2 (regV "malmen") mit_Prep ;
  malochen_V = regV "malochen" ;
  maltraetieren_V2 = dirV2 (regV "malträtieren")  ;
  mampfen_V2 = dirV2 (regV "mampfen")  ;
  managen_V2 = dirV2 (regV "managen")  ;
  mangeln_V2 = dirV2 (regV "mangeln")  ;
  manifestieren_im_rV2 = reflV2 (regV "manifestieren") accusative (mkPrep "in" dative) ;
  manikueren_V2 = dirV2 (regV "maniküren")  ;
  manipulieren_V2 = dirV2 (regV "manipulieren")  ;
  manoevrieren_dir_V3 = dirV3 (regV "manövrieren") dir_Prep ;
  marachen_V = irregV "marachen" "maracht" "marachte" "marachte" "maracht" ;
  marginalisieren_V2 = dirV2 (regV "marginalisieren")  ;
  marinieren_V2 = dirV2 (regV "marinieren")  ;
  markieren_V2 = dirV2 (regV "markieren")  ;
  marmorieren_V2 = dirV2 (regV "marmorieren")  ;
  marodieren_plV = plV (regV "marodieren")  ;
  marschieren_dir_V2 = prepV2 (regV "marschieren") dir_Prep ;
  martern_V2 = dirV2 (regV "martern")  ;
  maschinisieren_V2 = dirV2 (regV "maschinisieren")  ;
  masern_V2 = dirV2 (regV "masern")  ;
  maskieren_V2 = dirV2 (regV "maskieren")  ;
  massakrieren_V2 = dirV2 (regV "massakrieren")  ;
  massieren_V2 = dirV2 (regV "massieren")  ;
  massolieren_V2 = dirV2 (regV "massolieren")  ;
  massregeln_V2 = dirV2 (regV "maßregeln")  ;
  mastizieren_V2 = dirV2 (irregV "mastizieren" "mastiziert" "mastizierte" "mastizierte" "mastiziert")  ;
  masturbieren_V = regV "masturbieren" ;
  mathematisieren_V2 = dirV2 (regV "mathematisieren")  ;
  mattieren_V2 = dirV2 (regV "mattieren")  ;
  maturieren_V = regV "maturieren" ;
  mauern_V2 = dirV2 (regV "mauern")  ;
  maulen_V = regV "maulen" ;
  maunzen_V = regV "maunzen" ;
  mauscheln_V = regV "mauscheln" ;
  mausen_V = regV "mausen" ;
  mausern_V = regV "mausern" ;
  mausern_zu_rV2 = reflV2 (regV "mausern") accusative zu_Prep ;
  maximieren_V2 = dirV2 (regV "maximieren")  ;
  mechanisieren_V2 = dirV2 (regV "mechanisieren")  ;
  meckern_V2 = dirV2 (regV "meckern")  ;
  meckern_VS = mkVS (regV "meckern")  ;
  mediatisieren_V2 = dirV2 (regV "mediatisieren")  ;
  medisieren_V = regV "medisieren" ;
  meditieren_ueber_V2 = prepV2 (regV "meditieren") (mkPrep "über" accusative) ;
  meditieren_V = regV "meditieren" ;
  mehren_V2 = dirV2 (regV "mehren")  ;
  meiden_V2 = dirV2 (irregV "meiden" "meidet" "mied" "miede" "gemieden")  ;
  meinen_V2 = dirV2 (regV "meinen")  ;
  meinen_VS = mkVS (regV "meinen")  ;
  meisseln_in_V3 = dirV3 (regV "meißeln") (mkPrep "in" accusative) ;
  melden_dat_V2S = mkV2S (regV "melden") datPrep ;
  melden_dat_V3 = accdatV3 (regV "melden")  ;
  melieren_V2 = dirV2 (regV "melieren")  ;
  meliorieren_V2 = dirV2 (regV "meliorieren")  ;
  melken_V2 = dirV2 (regV "melken")  ;
  menscheln_V = regV "menscheln" ;
  mensendiecken_V = regV "mensendiecken" ;
  mensen_V = regV "mensen" ;
  mentorisieren_V2 = dirV2 (regV "mentorisieren")  ;
  mercerisieren_V = regV "mercerisieren" ;
  merken_rV2 = reflV2 (regV "merken") dative accPrep ;
  merken_rVS = reflVS (regV "merken") dative ;
  merzerisieren_V0 = mkV0 (regV "merzerisieren")  ;
  messen_V2 = dirV2 (irregV "messen" "messt" "maß" "mäße" "gemessen")  ;
  messern_V2 = dirV2 (regV "messern")  ;
  metabolisieren_V = regV "metabolisieren" ;
  metamorphosieren_V2 = dirV2 (regV "metamorphosieren")  ;
  metastasieren_V = regV "metastasieren" ;
  methodisieren_V2 = dirV2 (regV "methodisieren")  ;
  meucheln_V2 = dirV2 (regV "meucheln")  ;
  miauen_V = regV "miauen" ;
  miefen_es_esV = esV (regV "miefen")  ;
  miesepetern_V = regV "miesepetern" ;
  mieten_von_fuer_V4 = dirV4 (regV "mieten") von_Prep fuer_Prep ;
  migrieren_nach_V2 = prepV2 (regV "migrieren") nach_Prep ;
  mikroskopieren_V2 = dirV2 (regV "mikroskopieren")  ;
  militarisieren_V2 = dirV2 (regV "militarisieren")  ;
  mimen_V2 = dirV2 (regV "mimen")  ;
  mimen_VS = mkVS (regV "mimen")  ;
  minimieren_V2 = dirV2 (regV "minimieren")  ;
  mischen_mit_V3 = dirV3 (regV "mischen") mit_Prep ;
  mischen_V2 = dirV2 (regV "mischen")  ;
  missachten_V2 = dirV2 (irregV "missachten" "missachtet" "missachtete" "missachtete" "missachtet")  ;
  missbilligen_V2 = dirV2 (irregV "missbilligen" "missbilligt" "missbilligte" "missbilligte" "missbilligt")  ;
  missfallen_dat_sV2 = dassV2 (irregV "missfallen" "missfällt" "missfiel" "missfiel" "missfallen") datPrep ;
  missfallen_dat_V2 = mkV2 (irregV "missfallen" "missfällt" "missfiel" "missfiel" "missfallen") datPrep ;
  misshandeln_V2 = dirV2 (irregV "misshandeln" "misshandelt" "misshandelte" "misshandelte" "misshandelt")  ;
  missionieren_V2 = dirV2 (irregV "missionieren" "missioniert" "missionierte" "missionierte" "missioniert")  ;
  misslingen_dat_iV2 = infzuV2 (irregV "misslingen" "misslingt" "misslang" "misslänge" "misslungen") datPrep ;
  misstrauen_dat_V2 = mkV2 (irregV "misstrauen" "misstraut" "misstraute" "misstraute" "misstraut") datPrep ;
  mitbringen_dat_V3 = accdatV3 (prefixV "mit" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  mitdenken_V = prefixV "mit" (irregV "denken" "denkt" "dachte" "dächte" "gedacht") ;
  miterleben_VS = mkVS (prefixV "mit" (irregV "erleben" "erlebt" "erlebte" "erlebte" "erlebt"))  ;
  mitessen_mit_V2 = prepV2 (prefixV "mit" (irregV "essen" "isst" "aß" "aß" "gegessen")) mit_Prep ;
  mitfuehlen_mit_V2 = prepV2 (prefixV "mit" (regV "fühlen")) mit_Prep ;
  mitgeben_V2 = dirV2 (prefixV "mit" (irregV "geben" "gebt" "gab" "gäbe" "gegeben"))  ;
  mitgehen_mit_V2 = prepV2 (prefixV "mit" (irregV "gehen" "geht" "ging" "ging" "gegangen")) mit_Prep ;
  mitkommen_mit_V2 = prepV2 (prefixV "mit" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) mit_Prep ;
  mitmischen_bei_V2 = prepV2 (prefixV "mit" (regV "mischen")) bei_Prep ;
  mitnehmen_zu_V3 = dirV3 (prefixV "mit" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen")) zu_Prep ;
  mitreissen_mit_V2 = prepV2 (prefixV "mit" (irregV "reißen" "reißt" "riss" "riss" "gerissen")) mit_Prep ;
  mitschneiden_V2 = dirV2 (prefixV "mit" (irregV "schneiden" "schneidet" "schnitt" "schnitte" "geschnitten"))  ;
  mitschwingen_sV = dassV (prefixV "mit" (irregV "schwingen" "schwingt" "schwang" "schwänge" "geschwungen"))  ;
  mitsegeln_mit_V2 = prepV2 (prefixV "mit" (regV "segeln")) mit_Prep ;
  mitteilen_V2 = dirV2 (prefixV "mit" (regV "teilen"))  ;
  mitteilen_VS = mkVS (prefixV "mit" (regV "teilen"))  ;
  mitwirken_am_V2 = prepV2 (prefixV "mit" (regV "wirken")) (mkPrep "an" dative) ;
  mitzaehlen_mit_V2 = prepV2 (prefixV "mit" (regV "zählen")) mit_Prep ;
  mixen_V2 = dirV2 (regV "mixen")  ;
  mobben_V2 = dirV2 (regV "mobben")  ;
  moderieren_V2 = dirV2 (regV "moderieren")  ;
  modernisieren_V2 = dirV2 (regV "modernisieren")  ;
  modern_V = regV "modern" ;
  modifizieren_V2 = dirV2 (regV "modifizieren")  ;
  modulieren_V2 = dirV2 (regV "modulieren")  ;
  moeblieren_V2 = dirV2 (regV "möblieren")  ;
  moegen_V2 = dirV2 (irregV "mögen" "mögt" "mochte" "möchte" "gemocht")  ;
  moegen_VS = mkVS (irregV "mögen" "mögt" "mochte" "möchte" "gemocht")  ;
  mogeln_V = regV "mogeln" ;
  mokieren_ueber_rV2 = reflV2 (regV "mokieren") accusative (mkPrep "über" accusative) ;
  monetarisieren_V2 = dirV2 (regV "monetarisieren")  ;
  monieren_V2 = dirV2 (regV "monieren")  ;
  monieren_VS = mkVS (regV "monieren")  ;
  monogrammieren_V2 = dirV2 (regV "monogrammieren")  ;
  monologisieren_V = regV "monologisieren" ;
  monophthongieren_V2 = dirV2 (regV "monophthongieren")  ;
  monopolisieren_V2 = dirV2 (regV "monopolisieren")  ;
  montieren_dir_V3 = dirV3 (regV "montieren") dir_Prep ;
  monumentalisieren_V2 = dirV2 (regV "monumentalisieren")  ;
  mopsen_V2 = dirV2 (regV "mopsen")  ;
  moralisieren_V2 = dirV2 (regV "moralisieren")  ;
  morden_V2 = dirV2 (regV "morden")  ;
  morsen_dat_V2S = mkV2S (regV "morsen") datPrep ;
  morsen_dat_V3 = accdatV3 (regV "morsen")  ;
  mosern_ueber_V2 = prepV2 (regV "mosern") (mkPrep "über" accusative) ;
  motivieren_zu_V3 = dirV3 (regV "motivieren") zu_Prep ;
  motorisieren_V2 = dirV2 (regV "motorisieren")  ;
  motzen_VS = mkVS (regV "motzen")  ;
  muddeln_am_V2 = prepV2 (regV "muddeln") (mkPrep "an" dative) ;
  muddeln_V = regV "muddeln" ;
  mueffeln_V = regV "müffeln" ;
  muemmeln_V = regV "mümmeln" ;
  muenden_in_V2 = prepV2 (regV "münden") (mkPrep "in" accusative) ;
  muessen_VV = mkVV (irregV "müssen" "müsst" "musste" "müsste" "gemusst")  ;
  muffeln_V = regV "muffeln" ;
  muffen_es_nach_V2 = prepV2 (regV "muffen") nach_Prep ;
  muffen_V = regV "muffen" ;
  mulatieren_V = regV "mulatieren" ;
  multiplizieren_mit_V3 = dirV3 (regV "multiplizieren") mit_Prep ;
  munden_dat_V2 = mkV2 (regV "munden") datPrep ;
  mundieren_V2 = dirV2 (regV "mundieren")  ;
  munizipalisieren_V2 = dirV2 (regV "munizipalisieren")  ;
  munkeln_V2 = dirV2 (regV "munkeln")  ;
  munkeln_VS = mkVS (regV "munkeln")  ;
  murksen_V = regV "murksen" ;
  murmeln_VS = mkVS (regV "murmeln")  ;
  murren_gegen_V2 = prepV2 (regV "murren") gegen_Prep ;
  musizieren_V2 = dirV2 (regV "musizieren")  ;
  musizieren_V = regV "musizieren" ;
  mustern_V2 = dirV2 (regV "mustern")  ;
  muten_V2 = dirV2 (regV "muten")  ;
  mutieren_zu_V2 = prepV2 (regV "mutieren") zu_Prep ;
  mutmassen_V2 = dirV2 (regV "mutmaßen")  ;
  mutmassen_VS = mkVS (regV "mutmaßen")  ;
  mystifizieren_V2 = dirV2 (regV "mystifizieren")  ;
  mythisieren_V2 = dirV2 (regV "mythisieren")  ;
  mythologisieren_V2 = dirV2 (regV "mythologisieren")  ;
  nachaeffen_V2 = dirV2 (prefixV "nach" (regV "äffen"))  ;
  nachahmen_V2 = dirV2 (prefixV "nach" (regV "ahmen"))  ;
  nachbilden_V2 = dirV2 (prefixV "nach" (regV "bilden"))  ;
  nachdenken_ueber_V2 = prepV2 (prefixV "nach" (irregV "denken" "denkt" "dachte" "dächte" "gedacht")) (mkPrep "über" accusative) ;
  nachfolgen_dat_V2 = mkV2 (prefixV "nach" (regV "folgen")) datPrep ;
  nachforschen_VQ = mkVQ (prefixV "nach" (regV "forschen"))  ;
  nachfuehlen_dat_V2S = mkV2S (prefixV "nach" (regV "fühlen")) datPrep ;
  nachfuehlen_dat_V3 = accdatV3 (prefixV "nach" (regV "fühlen"))  ;
  nachgeben_dat_V2 = mkV2 (prefixV "nach" (irregV "geben" "gebt" "gab" "gäbe" "gegeben")) datPrep ;
  nachgehen_dat_V2 = mkV2 (prefixV "nach" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) datPrep ;
  nachgruebeln_ueber_V2 = prepV2 (prefixV "nach" (regV "grübeln")) (mkPrep "über" dative) ;
  nachhaken_bei_V2 = prepV2 (prefixV "nach" (regV "haken")) bei_Prep ;
  nachhaken_V = prefixV "nach" (regV "haken") ;
  nachhelfen_dat_V2 = mkV2 (prefixV "nach" (irregV "helfen" "helft" "half" "hälfe" "geholfen")) datPrep ;
  nachhelfen_dat_V2V = mkV2V (prefixV "nach" (irregV "helfen" "helft" "half" "hälfe" "geholfen")) datPrep ;
  nachkarten_V = prefixV "nach" (regV "karten") ;
  nachlassen_dat_V3 = accdatV3 (prefixV "nach" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  nachlassen_im_V2 = prepV2 (prefixV "nach" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen")) (mkPrep "in" dative) ;
  nachpruefen_V2 = dirV2 (prefixV "nach" (regV "prüfen"))  ;
  nachpruefen_VS = mkVS (prefixV "nach" (regV "prüfen"))  ;
  nachrechnen_V2 = dirV2 (prefixV "nach" (regV "rechnen"))  ;
  nachrechnen_VQ = mkVQ (prefixV "nach" (regV "rechnen"))  ;
  nachsagen_dat_V2S = mkV2S (prefixV "nach" (regV "sagen")) datPrep ;
  nachsagen_dat_V3 = accdatV3 (prefixV "nach" (regV "sagen"))  ;
  nachschlagen_V2 = dirV2 (prefixV "nach" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen"))  ;
  nachschlagen_VS = mkVS (prefixV "nach" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen"))  ;
  nachsehen_dat_V2S = mkV2S (prefixV "nach" (irregV "sehen" "sieht" "sah" "sah" "gesehen")) datPrep ;
  nachsehen_dat_V3 = accdatV3 (prefixV "nach" (irregV "sehen" "sieht" "sah" "sah" "gesehen"))  ;
  nachsetzen_dat_V2 = mkV2 (prefixV "nach" (regV "setzen")) datPrep ;
  nachstellen_dat_V2 = mkV2 (prefixV "nach" (irregV "stellen" "stellt" "stellte" "stellte" "gestellt")) datPrep ;
  nachtarocken_V = prefixV "nach" (regV "tarocken") ;
  nachvollziehen_VS = mkVS (prefixV "nach" (irregV "vollziehen" "vollzieht" "vollzog" "vollzöge" "vollzogen"))  ;
  nachweisen_dat_V2S = mkV2S (prefixV "nach" (irregV "weisen" "weist" "wies" "wies" "gewiesen")) datPrep ;
  nachweisen_dat_V3 = accdatV3 (prefixV "nach" (irregV "weisen" "weist" "wies" "wies" "gewiesen"))  ;
  nachweisen_VS = mkVS (prefixV "nach" (irregV "weisen" "weist" "wies" "wies" "gewiesen"))  ;
  nacktbaden_V = prefixV "nackt" (regV "baden") ;
  nadeln_V2 = dirV2 (regV "nadeln")  ;
  naechtigen_loc_V2 = prepV2 (regV "nächtigen") loc_Prep ;
  naehen_V2 = dirV2 (regV "nähen")  ;
  naehren_V2 = dirV2 (regV "nähren")  ;
  naeseln_V2 = dirV2 (regV "näseln")  ;
  naeseln_V = regV "näseln" ;
  naeseln_VS = mkVS (regV "näseln")  ;
  nageln_an_V3 = dirV3 (regV "nageln") (mkPrep "an" accusative) ;
  nagen_am_V2 = prepV2 (regV "nagen") (mkPrep "an" dative) ;
  nahen_dat_V2 = mkV2 (regV "nahen") datPrep ;
  nappieren_V2 = dirV2 (regV "nappieren")  ;
  narren_V2 = dirV2 (regV "narren")  ;
  nasalieren_V2 = dirV2 (regV "nasalieren")  ;
  naschen_V2 = dirV2 (regV "naschen")  ;
  nasfuehren_V2 = dirV2 (regV "nasführen")  ;
  nationalisieren_V2 = dirV2 (regV "nationalisieren")  ;
  naturalisieren_V2 = dirV2 (regV "naturalisieren")  ;
  naturieren_V2 = dirV2 (regV "naturieren")  ;
  navigieren_dir_V2 = prepV2 (regV "navigieren") dir_Prep ;
  nazifizieren_V2 = dirV2 (regV "nazifizieren")  ;
  nebeln_es_esV = esV (regV "nebeln")  ;
  necken_V2 = dirV2 (regV "necken")  ;
  negieren_V2 = dirV2 (regV "negieren")  ;
  negieren_VS = mkVS (regV "negieren")  ;
  negoziieren_V = regV "negoziieren" ;
  nehmen_auf_V3 = dirV3 (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen") (mkPrep "auf" accusative) ;
  nehmen_aus_V3 = dirV3 (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen") aus_Prep ;
  nehmen_von_V3 = dirV3 (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen") von_Prep ;
  neiden_dat_V2S = mkV2S (regV "neiden") datPrep ;
  neiden_dat_V3 = accdatV3 (regV "neiden")  ;
  neigen_zu_V2 = prepV2 (regV "neigen") zu_Prep ;
  nennen_V3 = dirV3 (irregV "nennen" "nennt" "nannte" "nennte" "genannt") accPrep ;
  neppen_V2 = dirV2 (regV "neppen")  ;
  nerven_sV2 = dassV2 (regV "nerven") accPrep ;
  nerven_V2 = dirV2 (regV "nerven")  ;
  nesteln_am_V2 = prepV2 (regV "nesteln") (mkPrep "an" dative) ;
  netzwerken_V = regV "netzwerken" ;
  neurotisieren_sV2 = dassV2 (regV "neurotisieren") accPrep ;
  neurotisieren_V2 = dirV2 (regV "neurotisieren")  ;
  neutralisieren_V2 = dirV2 (regV "neutralisieren")  ;
  nicken_V = regV "nicken" ;
  niedermetzeln_V2 = dirV2 (prefixV "nieder" (regV "metzeln"))  ;
  niederschlagen_V2 = dirV2 (prefixV "nieder" (irregV "schlagen" "schlagt" "schlug" "schlüge" "geschlagen"))  ;
  niederschreiben_V2 = dirV2 (prefixV "nieder" (irregV "schreiben" "schreibt" "schrieb" "schrieb" "geschrieben"))  ;
  niesen_V = regV "niesen" ;
  niffeln_V2 = dirV2 (irregV "niffeln" "niffe" "niffe" "niffe" "geniffe")  ;
  niffeln_V = irregV "niffeln" "niffe" "niffe" "niffe" "geniffe" ;
  nippen_am_V2 = prepV2 (regV "nippen") (mkPrep "an" dative) ;
  nitrieren_V2 = dirV2 (regV "nitrieren")  ;
  nivellieren_V2 = dirV2 (regV "nivellieren")  ;
  noelen_V2 = dirV2 (regV "nölen")  ;
  noelen_VS = mkVS (regV "nölen")  ;
  noeren_V = regV "nören" ;
  noergeln_am_V2 = prepV2 (regV "nörgeln") (mkPrep "an" dative) ;
  noergeln_VS = mkVS (regV "nörgeln")  ;
  noetigen_zu_V3 = dirV3 (regV "nötigen") zu_Prep ;
  nominalisieren_V2 = dirV2 (regV "nominalisieren")  ;
  nominieren_als_V3 = dirV3 (regV "nominieren") (mkPrep "als" accusative) ;
  nominieren_zu_V3 = dirV3 (regV "nominieren") zu_Prep ;
  normalisieren_V2 = dirV2 (regV "normalisieren")  ;
  normen_V2 = dirV2 (regV "normen")  ;
  normieren_V2 = dirV2 (regV "normieren")  ;
  notieren_V2 = dirV2 (regV "notieren")  ;
  notieren_VS = mkVS (regV "notieren")  ;
  notwassern_V = regV "notwassern" ;
  novellieren_V2 = dirV2 (regV "novellieren")  ;
  nuancieren_V2 = dirV2 (regV "nuancieren")  ;
  nuckeln_am_V2 = prepV2 (regV "nuckeln") (mkPrep "an" dative) ;
  nueffeln_V2 = dirV2 (regV "nüffeln")  ;
  nueffeln_V = regV "nüffeln" ;
  nuetzen_dat_bei_V3 = mkV3 (regV "nützen") datPrep bei_Prep ;
  nuetzen_dat_fuer_V3 = mkV3 (regV "nützen") datPrep fuer_Prep ;
  nuetzen_dat_zu_V3 = mkV3 (regV "nützen") datPrep zu_Prep ;
  nuetzen_zu_V3 = dirV3 (regV "nützen") zu_Prep ;
  nullifizieren_V2 = dirV2 (regV "nullifizieren")  ;
  numerieren_V2 = dirV2 (regV "numerieren")  ;
  nummerieren_V2 = dirV2 (regV "nummerieren")  ;
  nuscheln_V2 = dirV2 (regV "nuscheln")  ;
  nuscheln_V = regV "nuscheln" ;
  nuscheln_VS = mkVS (regV "nuscheln")  ;
  nuten_V2 = dirV2 (regV "nuten")  ;
  nutzen_dat_bei_V3 = mkV3 (regV "nutzen") datPrep bei_Prep ;
  nutzen_dat_fuer_V3 = mkV3 (regV "nutzen") datPrep fuer_Prep ;
  nutzen_dat_zu_V3 = mkV3 (regV "nutzen") datPrep zu_Prep ;
  nutzen_fuer_V3 = dirV3 (regV "nutzen") fuer_Prep ;
  nutzen_zu_V3 = dirV3 (regV "nutzen") zu_Prep ;
  obduzieren_V2 = dirV2 (regV "obduzieren")  ;
  obedieren_dat_V2 = mkV2 (regV "obedieren") datPrep ;
  objektivieren_V2 = dirV2 (regV "objektivieren")  ;
  obliegen_dat_sV2 = dassV2 (irregV "obliegen" "obliegt" "oblag" "obläge" "oblegen") datPrep ;
  obligieren_V2V = dirV2V (regV "obligieren")  ;
  observieren_V2 = dirV2 (regV "observieren")  ;
  obsiegen_ueber_V2 = prepV2 (regV "obsiegen") (mkPrep "über" accusative) ;
  obsiegen_V = regV "obsiegen" ;
  obsignieren_V2 = dirV2 (irregV "obsignieren" "obsigniert" "obsinierte" "obsinierte" "obsigniert")  ;
  obstruieren_V2 = dirV2 (regV "obstruieren")  ;
  oeffnen_V2 = dirV2 (regV "öffnen")  ;
  oelen_V2 = dirV2 (regV "ölen")  ;
  offenbaren_dat_rV2 = reflV2 (irregV "offenbaren" "offenbart" "offenbarte" "offenbarte" "offenbart") accusative datPrep ;
  offenbaren_dat_V2S = mkV2S (irregV "offenbaren" "offenbart" "offenbarte" "offenbarte" "offenbart") datPrep ;
  offenbaren_dat_V3 = accdatV3 (irregV "offenbaren" "offenbart" "offenbarte" "offenbarte" "offenbart")  ;
  offenbaren_V2 = dirV2 (irregV "offenbaren" "offenbart" "offenbarte" "offenbarte" "offenbart")  ;
  offerieren_dat_V2S = mkV2S (regV "offerieren") datPrep ;
  offerieren_dat_V3 = accdatV3 (regV "offerieren")  ;
  ohrfeigen_V2 = dirV2 (regV "ohrfeigen")  ;
  okkupieren_V2 = dirV2 (regV "okkupieren")  ;
  oktavieren_V = irregV "oktavieren" "oktaviert" "oktavierte" "oktavierte" "oktaviert" ;
  oktroyieren_V2 = dirV2 (irregV "oktroyieren" "oktroyiert" "oktroyierte" "oktroyierte" "oktroyiert")  ;
  oligomerisieren_V0 = mkV0 (regV "oligomerisieren")  ;
  onanieren_V = regV "onanieren" ;
  ondulieren_V2 = dirV2 (regV "ondulieren")  ;
  opalisieren_V = regV "opalisieren" ;
  operationalisieren_V2 = dirV2 (regV "operationalisieren")  ;
  operieren_loc_V2 = prepV2 (regV "operieren") loc_Prep ;
  operieren_V2 = dirV2 (regV "operieren")  ;
  opfern_V2 = dirV2 (regV "opfern")  ;
  opponieren_gegen_V2 = prepV2 (regV "opponieren") gegen_Prep ;
  opportunisteln_V = regV "opportunisteln" ;
  opsonieren_V0 = mkV0 (irregV "opsonieren" "opsoniert" "opsonierte" "opsonierte" "opsoniert")  ;
  optieren_fuer_V2 = prepV2 (regV "optieren") fuer_Prep ;
  optimieren_V2 = dirV2 (regV "optimieren")  ;
  orakeln_V2 = dirV2 (irregV "orakeln" "orakelt" "orakelte" "orakelte" "orakelt")  ;
  orakeln_VS = mkVS (irregV "orakeln" "orakelt" "orakelte" "orakelte" "orakelt")  ;
  orchestrieren_V2 = dirV2 (regV "orchestrieren")  ;
  ordern_bei_V3 = dirV3 (regV "ordern") bei_Prep ;
  ordern_von_V3 = dirV3 (regV "ordern") von_Prep ;
  ordnen_V2 = dirV2 (regV "ordnen")  ;
  organisieren_V2 = dirV2 (regV "organisieren")  ;
  orgeln_V = regV "orgeln" ;
  orientieren_am_rV2 = reflV2 (regV "orientieren") accusative (mkPrep "an" dative) ;
  orientieren_ueber_V3 = dirV3 (regV "orientieren") (mkPrep "über" accusative) ;
  ornamentieren_V2 = dirV2 (regV "ornamentieren")  ;
  orten_V2 = dirV2 (regV "orten")  ;
  oszillieren_V = regV "oszillieren" ;
  outen_als_rV2 = reflV2 (regV "outen") accusative (mkPrep "als" nominative) ;
  outrieren_V = regV "outrieren" ;
  outsourcen_V2 = dirV2 (regV "outsourcen")  ;
  oxidieren_V = regV "oxidieren" ;
  oxidieren_zu_V2 = prepV2 (regV "oxidieren") zu_Prep ;
  oxidieren_zu_V3 = dirV3 (regV "oxidieren") zu_Prep ;
  oxydieren_V = regV "oxydieren" ;
  oxygenieren_V0 = mkV0 (regV "oxygenieren")  ;
  paaren_mit_rV2 = reflV2 (regV "paaren") accusative mit_Prep ;
  paaren_rV = reflV (regV "paaren") accusative ;
  pachten_V2 = dirV2 (regV "pachten")  ;
  packen_V2 = dirV2 (regV "packen")  ;
  paddeln_dir_V2 = prepV2 (regV "paddeln") dir_Prep ;
  paeppeln_V2 = dirV2 (regV "päppeln")  ;
  paffen_V2 = dirV2 (regV "paffen")  ;
  paginieren_V2 = dirV2 (regV "paginieren")  ;
  paktieren_mit_V2 = prepV2 (regV "paktieren") mit_Prep ;
  paktieren_plV = plV (regV "paktieren")  ;
  palatalisieren_V2 = dirV2 (regV "palatalisieren")  ;
  palavern_mit_ueber_V3 = mkV3 (regV "palavern") mit_Prep (mkPrep "über" accusative) ;
  palavern_ueber_V2 = prepV2 (regV "palavern") (mkPrep "über" accusative) ;
  pampern_V2 = dirV2 (regV "pampern")  ;
  panaschieren_V2 = dirV2 (regV "panaschieren")  ;
  paneelieren_V2 = dirV2 (regV "paneelieren")  ;
  panieren_V2 = dirV2 (regV "panieren")  ;
  panschen_V2 = dirV2 (regV "panschen")  ;
  pantschen_V2 = dirV2 (regV "pantschen")  ;
  panzern_V2 = dirV2 (regV "panzern")  ;
  pappen_dir_V3 = dirV3 (regV "pappen") dir_Prep ;
  paradieren_dir_V2 = prepV2 (regV "paradieren") dir_Prep ;
  paradieren_V = regV "paradieren" ;
  parallelisieren_mit_V3 = dirV3 (regV "parallelisieren") mit_Prep ;
  parallelisieren_V2 = dirV2 (regV "parallelisieren")  ;
  paralysieren_V2 = dirV2 (regV "paralysieren")  ;
  parametrisieren_V2 = dirV2 (regV "parametrisieren")  ;
  paraphieren_V2 = dirV2 (regV "paraphieren")  ;
  paraphrasieren_V2 = dirV2 (regV "paraphrasieren")  ;
  parfuemieren_V2 = dirV2 (regV "parfümieren")  ;
  parieren_adv_V2 = prepV2 (regV "parieren") adv_Prep ;
  parieren_V2 = dirV2 (regV "parieren")  ;
  parken_loc_V3 = dirV3 (regV "parken") loc_Prep ;
  parkieren_V2 = dirV2 (regV "parkieren")  ;
  parlieren_mit_ueber_V3 = mkV3 (regV "parlieren") mit_Prep (mkPrep "über" accusative) ;
  parlieren_ueber_V2 = prepV2 (regV "parlieren") (mkPrep "über" accusative) ;
  parodieren_V2 = dirV2 (regV "parodieren")  ;
  parodieren_VS = mkVS (regV "parodieren")  ;
  parsen_V2 = dirV2 (regV "parsen")  ;
  partizipieren_am_V2 = prepV2 (regV "partizipieren") (mkPrep "an" dative) ;
  parzellieren_V2 = dirV2 (regV "parzellieren")  ;
  passen_dat_sV2 = dassV2 (regV "passen") datPrep ;
  passen_dat_V2 = mkV2 (regV "passen") datPrep ;
  passieren_durch_V3 = dirV3 (regV "passieren") durch_Prep ;
  passivieren_V2 = dirV2 (regV "passivieren")  ;
  pasteurisieren_V2 = dirV2 (regV "pasteurisieren")  ;
  patentieren_V2 = dirV2 (regV "patentieren")  ;
  patrouillieren_loc_V2 = prepV2 (regV "patrouillieren") loc_Prep ;
  patzen_V = regV "patzen" ;
  pauken_V2 = dirV2 (regV "pauken")  ;
  pauschalisieren_V = regV "pauschalisieren" ;
  pausen_V2 = dirV2 (regV "pausen")  ;
  pausieren_V = regV "pausieren" ;
  pedikueren_V2 = dirV2 (regV "pediküren")  ;
  peilen_V2 = dirV2 (regV "peilen")  ;
  peinigen_V2 = dirV2 (regV "peinigen")  ;
  peitschen_V2 = dirV2 (regV "peitschen")  ;
  pellen_V2 = dirV2 (regV "pellen")  ;
  pelletisieren_V0 = mkV0 (regV "pelletisieren")  ;
  pendeln_V = regV "pendeln" ;
  penetrieren_V2 = dirV2 (regV "penetrieren")  ;
  pennen_V = regV "pennen" ;
  pensionieren_V2 = dirV2 (regV "pensionieren")  ;
  perennieren_V = regV "perennieren" ;
  perfektionieren_V2 = dirV2 (regV "perfektionieren")  ;
  perforieren_V2 = dirV2 (regV "perforieren")  ;
  perfundieren_V0 = mkV0 (regV "perfundieren")  ;
  perhorreszieren_V = regV "perhorreszieren" ;
  perpetuieren_V2 = dirV2 (regV "perpetuieren")  ;
  perseverieren_loc_V2 = prepV2 (regV "perseverieren") loc_Prep ;
  persiflieren_V2 = dirV2 (regV "persiflieren")  ;
  personalisieren_V2 = dirV2 (regV "personalisieren")  ;
  perzipieren_V2 = dirV2 (regV "perzipieren")  ;
  perzipieren_VS = mkVS (regV "perzipieren")  ;
  pesen_dir_V2 = prepV2 (regV "pesen") dir_Prep ;
  petzen_dat_V2S = mkV2S (regV "petzen") datPrep ;
  petzen_dat_V3 = accdatV3 (regV "petzen")  ;
  pfaenden_V2 = dirV2 (regV "pfänden")  ;
  pfeffern_dir_V3 = dirV3 (regV "pfeffern") dir_Prep ;
  pfeffern_V2 = dirV2 (regV "pfeffern")  ;
  pfeifen_auf_V2 = prepV2 (irregV "pfeifen" "pfeift" "pfiff" "pfiffe" "gepfiffen") (mkPrep "auf" accusative) ;
  pfeifen_V2 = dirV2 (irregV "pfeifen" "pfeift" "pfiff" "pfiffe" "gepfiffen")  ;
  pferchen_in_V3 = dirV3 (regV "pferchen") (mkPrep "in" accusative) ;
  pflanzen_dir_V3 = dirV3 (regV "pflanzen") dir_Prep ;
  pflastern_V2 = dirV2 (regV "pflastern")  ;
  pflegen_V2 = dirV2 (regV "pflegen")  ;
  pflegen_VV = mkVV (regV "pflegen")  ;
  pfluecken_V2 = dirV2 (regV "pflücken")  ;
  pfluegen_V2 = dirV2 (regV "pflügen")  ;
  pfropfen_auf_V3 = dirV3 (regV "pfropfen") (mkPrep "auf" accusative) ;
  pfuschen_V = regV "pfuschen" ;
  pfuzgen_V = irregV "pfuzgen" "pfuzget" "(pfuzgte)" "(pfuzgte)" "(ge)pfuzget" ;
  phantasieren_V2 = dirV2 (regV "phantasieren")  ;
  phantasieren_VS = mkVS (regV "phantasieren")  ;
  pharyngalisieren_V2 = dirV2 (regV "pharyngalisieren")  ;
  philosophieren_ueber_V2 = prepV2 (regV "philosophieren") (mkPrep "über" accusative) ;
  phosphorylieren_V0 = mkV0 (regV "phosphorylieren")  ;
  photographieren_V2 = dirV2 (regV "photographieren")  ;
  picheln_V = regV "picheln" ;
  pichen_V2 = dirV2 (regV "pichen")  ;
  picken_V2 = dirV2 (regV "picken")  ;
  picknicken_V = regV "picknicken" ;
  piepen_V2 = dirV2 (regV "piepen")  ;
  piepen_VS = mkVS (regV "piepen")  ;
  piepsen_V2 = dirV2 (regV "piepsen")  ;
  piepsen_VS = mkVS (regV "piepsen")  ;
  piercen_V2 = dirV2 (regV "piercen")  ;
  piesacken_V2 = dirV2 (regV "piesacken")  ;
  pigmentieren_V2 = dirV2 (regV "pigmentieren")  ;
  piken_V = regV "piken" ;
  pikieren_V2 = dirV2 (regV "pikieren")  ;
  pikieren_V = regV "pikieren" ;
  piksen_V2 = dirV2 (regV "piksen")  ;
  pilgern_dir_V2 = prepV2 (regV "pilgern") dir_Prep ;
  pilotieren_V2 = dirV2 (regV "pilotieren")  ;
  pimpern_plV = plV (regV "pimpern")  ;
  pinkeln_V = regV "pinkeln" ;
  pinnen_dir_V3 = dirV3 (regV "pinnen") dir_Prep ;
  pinseln_dir_V3 = dirV3 (regV "pinseln") dir_Prep ;
  pinseln_V2 = dirV2 (regV "pinseln")  ;
  pissen_V = regV "pissen" ;
  placieren_loc_V3 = dirV3 (regV "placieren") loc_Prep ;
  plaedieren_fuer_V2 = prepV2 (regV "plädieren") fuer_Prep ;
  plaedieren_gegen_V2 = prepV2 (regV "plädieren") gegen_Prep ;
  plaerren_V = regV "plärren" ;
  plaetschern_V = regV "plätschern" ;
  plagen_mit_V3 = dirV3 (regV "plagen") mit_Prep ;
  plagen_sV2 = dassV2 (regV "plagen") accPrep ;
  plagen_V2 = dirV2 (regV "plagen")  ;
  planen_V2 = dirV2 (regV "planen")  ;
  planen_VS = mkVS (regV "planen")  ;
  planschen_V = regV "planschen" ;
  plantschen_V = regV "plantschen" ;
  plappern_V2 = dirV2 (regV "plappern")  ;
  plappern_VS = mkVS (regV "plappern")  ;
  platzen_dat_V3 = accdatV3 (regV "platzen")  ;
  platzen_V = regV "platzen" ;
  platzieren_loc_V3 = dirV3 (regV "platzieren") loc_Prep ;
  plaudern_mit_ueber_V3 = mkV3 (regV "plaudern") mit_Prep (mkPrep "über" accusative) ;
  plaudern_ueber_V2 = prepV2 (regV "plaudern") (mkPrep "über" accusative) ;
  plauschen_mit_ueber_V3 = mkV3 (regV "plauschen") mit_Prep (mkPrep "über" accusative) ;
  plauschen_ueber_V2 = prepV2 (regV "plauschen") (mkPrep "über" accusative) ;
  plazieren_loc_V3 = dirV3 (regV "plazieren") loc_Prep ;
  plempern_mit_V2 = prepV2 (regV "plempern") mit_Prep ;
  plenken_V = regV "plenken" ;
  plieren_dir_V2 = prepV2 (regV "plieren") dir_Prep ;
  plinkern_dir_V2 = prepV2 (regV "plinkern") dir_Prep ;
  plissieren_V2 = dirV2 (regV "plissieren")  ;
  plombieren_V2 = dirV2 (regV "plombieren")  ;
  pludern_V2 = dirV2 (regV "pludern")  ;
  pluendern_V2 = dirV2 (regV "plündern")  ;
  plumpsen_in_V2 = prepV2 (regV "plumpsen") (mkPrep "in" accusative) ;
  pochen_auf_V2 = prepV2 (regV "pochen") (mkPrep "auf" accusative) ;
  pochieren_V2 = dirV2 (regV "pochieren")  ;
  poebeln_V2 = dirV2 (regV "pöbeln")  ;
  poebeln_V = regV "pöbeln" ;
  poebeln_VS = mkVS (regV "pöbeln")  ;
  poekeln_V2 = dirV2 (regV "pökeln")  ;
  poenalisieren_V2 = dirV2 (regV "pönalisieren")  ;
  poetisieren_V2 = dirV2 (regV "poetisieren")  ;
  pofen_V = regV "pofen" ;
  pogen_V = regV "pogen" ;
  pokern_mit_um_V3 = mkV3 (regV "pokern") mit_Prep um_Prep ;
  pokern_um_V2 = prepV2 (regV "pokern") um_Prep ;
  pokulieren_V = regV "pokulieren" ;
  polarisieren_V2 = dirV2 (regV "polarisieren")  ;
  polemisieren_gegen_V2 = prepV2 (regV "polemisieren") gegen_Prep ;
  polieren_V2 = dirV2 (regV "polieren")  ;
  politisieren_V = regV "politisieren" ;
  polonisieren_V2 = dirV2 (regV "polonisieren")  ;
  polstern_V2 = dirV2 (regV "polstern")  ;
  poltern_V = regV "poltern" ;
  polymerisieren_V0 = mkV0 (regV "polymerisieren")  ;
  pomadisieren_V2 = dirV2 (regV "pomadisieren")  ;
  ponieren_V = regV "ponieren" ;
  ponieren_VS = mkVS (regV "ponieren")  ;
  poolen_mit_V3 = dirV3 (regV "poolen") mit_Prep ;
  poolen_V2 = dirV2 (regV "poolen")  ;
  popeln_V = regV "popeln" ;
  poppen_V = regV "poppen" ;
  popularisieren_V2 = dirV2 (regV "popularisieren")  ;
  portieren_V2 = dirV2 (regV "portieren")  ;
  portraetieren_V2 = dirV2 (regV "porträtieren")  ;
  portraitieren_V2 = dirV2 (regV "portraitieren")  ;
  poschieren_V2 = dirV2 (regV "poschieren")  ;
  posieren_loc_V2 = prepV2 (regV "posieren") loc_Prep ;
  posieren_V = regV "posieren" ;
  positionieren_loc_V3 = dirV3 (regV "positionieren") loc_Prep ;
  posten_V2 = dirV2 (regV "posten")  ;
  postieren_loc_V3 = dirV3 (regV "postieren") loc_Prep ;
  postulieren_V2 = dirV2 (regV "postulieren")  ;
  postulieren_VS = mkVS (regV "postulieren")  ;
  potenzieren_V2 = dirV2 (regV "potenzieren")  ;
  poussieren_mit_V2 = prepV2 (regV "poussieren") mit_Prep ;
  poussieren_plV = plV (regV "poussieren")  ;
  powern_V = regV "powern" ;
  praedestinieren_zu_V3 = dirV3 (regV "prädestinieren") zu_Prep ;
  praedikatisieren_V2 = dirV2 (regV "prädikatisieren")  ;
  praedizieren_ueber_V2S = mkV2S (regV "prädizieren") (mkPrep "über" accusative) ;
  praedizieren_ueber_V3 = mkV3 (regV "prädizieren") (mkPrep "über" accusative) accPrep ;
  praedizieren_von_V2S = mkV2S (regV "prädizieren") von_Prep ;
  praedizieren_von_V3 = mkV3 (regV "prädizieren") von_Prep accPrep ;
  praeferieren_V2 = dirV2 (regV "präferieren")  ;
  praeferieren_VS = mkVS (regV "präferieren")  ;
  praegen_V2 = dirV2 (irregV "prägen" "prägt" "prägte" "prägte" "prägt")  ;
  praejudizieren_V2 = dirV2 (irregV "präjudizieren" "präjudiziert" "präjudizierte" "präjudizierte" "präjudiziert")  ;
  praekludieren_V2 = dirV2 (irregV "präkludieren" "präkludiert" "präkludierte" "präkludierte" "präkludiert")  ;
  praemieren_V2 = dirV2 (regV "prämieren")  ;
  praemieren_VS = mkVS (regV "prämieren")  ;
  praeparieren_V2 = dirV2 (irregV "präparieren" "präpariert" "präparierte" "präparierte" "präpariert")  ;
  praesentieren_dat_V3 = accdatV3 (regV "präsentieren")  ;
  praesidieren_V = regV "präsidieren" ;
  praetendieren_VV = mkVV (irregV "prätendieren" "prätendiert" "prätendierte" "prätendierte" "prätendiert")  ;
  praeterieren_V2 = dirV2 (irregV "präterieren" "präteriert" "präterierte" "präterierte" "präteriert")  ;
  praezipitieren_V0 = mkV0 (irregV "präzipitieren" "präzipitiert" "präzipitierte" "präzipitierte" "präzipitiert")  ;
  praezisieren_V2 = dirV2 (regV "präzisieren")  ;
  praezisieren_VS = mkVS (regV "präzisieren")  ;
  prahlen_mit_V2 = prepV2 (regV "prahlen") mit_Prep ;
  praktizieren_V2 = dirV2 (regV "praktizieren")  ;
  praktizieren_V = regV "praktizieren" ;
  prangen_loc_V2 = prepV2 (regV "prangen") loc_Prep ;
  pranzen_V = regV "pranzen" ;
  predigen_ueber_V2 = prepV2 (regV "predigen") (mkPrep "über" accusative) ;
  predigen_V2 = dirV2 (regV "predigen")  ;
  preisen_V2 = dirV2 (irregV "preisen" "preist" "pries" "priese" "gepriesen")  ;
  preisen_VS = mkVS (irregV "preisen" "preist" "pries" "priese" "gepriesen")  ;
  preisgeben_V2 = dirV2 (prefixV "preis" (irregV "geben" "gibt" "gab" "gab" "gegeben"))  ;
  prellen_um_V3 = dirV3 (regV "prellen") um_Prep ;
  preschen_dir_V2 = prepV2 (regV "preschen") dir_Prep ;
  pressen_dir_V3 = dirV3 (regV "pressen") dir_Prep ;
  pressieren_dat_sV2 = dassV2 (regV "pressieren") datPrep ;
  primen_V = regV "primen" ;
  privatisieren_V2 = dirV2 (regV "privatisieren")  ;
  privilegieren_sV2 = dassV2 (regV "privilegieren") accPrep ;
  privilegieren_V2 = dirV2 (regV "privilegieren")  ;
  proben_V2 = dirV2 (regV "proben")  ;
  probieren_V2 = dirV2 (regV "probieren")  ;
  probieren_VQ = mkVQ (regV "probieren")  ;
  problematisieren_V2 = dirV2 (regV "problematisieren")  ;
  produzieren_V2 = dirV2 (regV "produzieren")  ;
  profilieren_mit_rV2 = reflV2 (irregV "profilieren" "profiliert" "profilierte" "profilierte" "profiliert") accusative mit_Prep ;
  profitieren_von_V2 = prepV2 (regV "profitieren") von_Prep ;
  proggen_V = irregV "proggen" "proggt" "proggte" "proggte" "proggt" ;
  prognostizieren_V2 = dirV2 (regV "prognostizieren")  ;
  prognostizieren_VS = mkVS (regV "prognostizieren")  ;
  projektieren_V2 = dirV2 (irregV "projektieren" "projektiert" "projektierte" "projektierte" "projektiert")  ;
  projektieren_VV = mkVV (irregV "projektieren" "projektiert" "projektierte" "projektierte" "projektiert")  ;
  projizieren_dir_V3 = dirV3 (irregV "projizieren" "projiziert" "projizierte" "projizierte" "projiziert") dir_Prep ;
  prokeln_loc_V2 = prepV2 (irregV "prokeln" "prokelt" "prokelte" "prokelte" "prokelt") loc_Prep ;
  proklamieren_V2 = dirV2 (regV "proklamieren")  ;
  prokrastinieren_V2 = dirV2 (regV "prokrastinieren")  ;
  proliferieren_V0 = mkV0 (regV "proliferieren")  ;
  prollen_V = irregV "prollen" "prollt" "prollte" "prollte" "prollt" ;
  prolongieren_V2 = dirV2 (regV "prolongieren")  ;
  promenieren_dir_V2 = prepV2 (regV "promenieren") dir_Prep ;
  promenieren_loc_V2 = prepV2 (regV "promenieren") loc_Prep ;
  promoten_V2 = dirV2 (irregV "promoten" "promotet" "promotete" "promotete" "promotet")  ;
  promovieren_V2 = dirV2 (irregV "promovieren" "promoviert" "promovierte" "promovierte" "promoviert")  ;
  promovieren_V = irregV "promovieren" "promoviert" "promovierte" "promovierte" "promoviert" ;
  prononcieren_V2 = dirV2 (irregV "prononcieren" "prononciert" "prononcierte" "prononcierte" "prononciert")  ;
  propagieren_V2 = dirV2 (regV "propagieren")  ;
  propagieren_VS = mkVS (regV "propagieren")  ;
  prophezeien_dat_V2S = mkV2S (irregV "prophezeien" "prophezeit" "prophezeite" "prophezeite" "prophezeit") datPrep ;
  prophezeien_dat_V3 = accdatV3 (irregV "prophezeien" "prophezeit" "prophezeite" "prophezeite" "prophezeit")  ;
  prosperieren_V = irregV "prosperieren" "prosperiert" "prosperierte" "prosperierte" "prosperiert" ;
  prosten_V = regV "prosten" ;
  prostituieren_rV = reflV (regV "prostituieren") accusative ;
  prostituieren_V2 = dirV2 (regV "prostituieren")  ;
  protegieren_V2 = dirV2 (regV "protegieren")  ;
  protestieren_gegen_V2 = prepV2 (irregV "protestieren" "protestiert" "protestierte" "protestierte" "protestiert") gegen_Prep ;
  protokollieren_V2 = dirV2 (regV "protokollieren")  ;
  protokollieren_VS = mkVS (regV "protokollieren")  ;
  protrahieren_V2 = dirV2 (irregV "protrahieren" "protrahiert" "protrahierte" "protrahierte" "protrahiert")  ;
  protzen_mit_V2 = prepV2 (regV "protzen") mit_Prep ;
  proviantieren_V2 = dirV2 (regV "proviantieren")  ;
  provinzialisieren_V2 = dirV2 (regV "provinzialisieren")  ;
  provozieren_zu_V3 = dirV3 (irregV "provozieren" "provoziert" "provozierte" "provozierte" "provoziert") zu_Prep ;
  prozessieren_gegen_V2 = prepV2 (irregV "prozessieren" "prozessiert" "prozessierte" "prozessierte" "prozessiert") gegen_Prep ;
  prozessieren_mit_V2 = prepV2 (irregV "prozessieren" "prozessiert" "prozessierte" "prozessierte" "prozessiert") mit_Prep ;
  pruefen_V2 = dirV2 (regV "prüfen")  ;
  pruefen_VS = mkVS (regV "prüfen")  ;
  pruegeln_mit_rV2 = reflV2 (regV "prügeln") accusative mit_Prep ;
  pruegeln_rV = reflV (regV "prügeln") accusative ;
  pruegeln_V2 = dirV2 (regV "prügeln")  ;
  prusten_V2 = dirV2 (regV "prusten")  ;
  prusten_V = regV "prusten" ;
  prusten_VS = mkVS (regV "prusten")  ;
  psychiatrieren_V2 = dirV2 (regV "psychiatrieren")  ;
  pubertieren_V = regV "pubertieren" ;
  publizieren_V2 = dirV2 (regV "publizieren")  ;
  publizieren_VS = mkVS (regV "publizieren")  ;
  pudern_V2 = dirV2 (regV "pudern")  ;
  puenkteln_V2 = dirV2 (regV "pünkteln")  ;
  puerieren_V2 = dirV2 (regV "pürieren")  ;
  puffen_dir_V3 = dirV3 (regV "puffen") dir_Prep ;
  pulen_loc_V2 = prepV2 (regV "pulen") loc_Prep ;
  pullern_V = regV "pullern" ;
  pulsieren_V = regV "pulsieren" ;
  pulverisieren_V2 = dirV2 (regV "pulverisieren")  ;
  pulvern_dir_V3 = dirV3 (regV "pulvern") dir_Prep ;
  pulvern_V2 = dirV2 (regV "pulvern")  ;
  pumpen_bei_rV3 = reflV3 (regV "pumpen") dative accPrep bei_Prep ;
  pumpen_dat_V3 = accdatV3 (regV "pumpen")  ;
  pumpen_im_rV3 = reflV3 (regV "pumpen") dative accPrep (mkPrep "in" dative) ;
  pumpen_von_rV3 = reflV3 (regV "pumpen") dative accPrep von_Prep ;
  punkten_V = regV "punkten" ;
  punktieren_V2 = dirV2 (regV "punktieren")  ;
  pupen_V = regV "pupen" ;
  pupsen_V = regV "pupsen" ;
  purgieren_V2 = dirV2 (regV "purgieren")  ;
  purzeln_von_V2 = prepV2 (regV "purzeln") von_Prep ;
  puschen_V2 = dirV2 (regV "puschen")  ;
  pushen_dir_V3 = dirV3 (regV "pushen") dir_Prep ;
  pusseln_V = regV "pusseln" ;
  pusten_V = irregV "pusten" "pustet" "pustete" "puste" "gepustet" ;
  putschen_gegen_V2 = prepV2 (regV "putschen") gegen_Prep ;
  putzen_V2 = dirV2 (regV "putzen")  ;
  quacksalbern_V = regV "quacksalbern" ;
  quadraeteln_V = irregV "quadräteln" "quadrätelt" "quadrätelte" "quadrätele" "quadrätelt" ;
  quadrieren_V2 = dirV2 (regV "quadrieren")  ;
  quaeken_V2 = dirV2 (regV "quäken")  ;
  quaeken_VS = mkVS (regV "quäken")  ;
  quaelen_mit_V3 = dirV3 (regV "quälen") mit_Prep ;
  quaelen_sV2 = dassV2 (regV "quälen") accPrep ;
  quaelen_V2 = dirV2 (regV "quälen")  ;
  quaken_V2 = dirV2 (regV "quaken")  ;
  quaken_VS = mkVS (regV "quaken")  ;
  qualifizieren_als_V3 = dirV3 (regV "qualifizieren") (mkPrep "als" accusative) ;
  qualifizieren_fuer_rV2 = reflV2 (regV "qualifizieren") accusative fuer_Prep ;
  qualifizieren_zu_V3 = dirV3 (regV "qualifizieren") zu_Prep ;
  qualmen_V2 = dirV2 (regV "qualmen")  ;
  quanteln_V2 = dirV2 (regV "quanteln")  ;
  quantifizieren_V2 = dirV2 (regV "quantifizieren")  ;
  quantisieren_V2 = dirV2 (regV "quantisieren")  ;
  quantitieren_V2 = dirV2 (regV "quantitieren")  ;
  quarzen_V2 = dirV2 (regV "quarzen")  ;
  quasseln_V2 = dirV2 (regV "quasseln")  ;
  quasseln_VS = mkVS (regV "quasseln")  ;
  quatschen_V2 = dirV2 (regV "quatschen")  ;
  quatschen_VS = mkVS (regV "quatschen")  ;
  quellen_V = irregV "quellen" "quellt" "quoll" "quölle" "gequollen" ;
  quengeln_V = regV "quengeln" ;
  quengeln_VS = mkVS (regV "quengeln")  ;
  quetschen_dat_V3 = accdatV3 (regV "quetschen")  ;
  quieken_V2 = dirV2 (regV "quieken")  ;
  quieken_VS = mkVS (regV "quieken")  ;
  quieksen_V2 = dirV2 (regV "quieksen")  ;
  quieksen_VS = mkVS (regV "quieksen")  ;
  quietschen_V2 = dirV2 (regV "quietschen")  ;
  quietschen_VS = mkVS (regV "quietschen")  ;
  quittieren_dat_V2S = mkV2S (regV "quittieren") datPrep ;
  quittieren_dat_V3 = accdatV3 (regV "quittieren")  ;
  quittieren_V2 = dirV2 (regV "quittieren")  ;
  quizzen_V = regV "quizzen" ;
  quotieren_V2 = dirV2 (regV "quotieren")  ;
  quotisieren_V2 = dirV2 (regV "quotisieren")  ;
  rabattieren_V2 = dirV2 (regV "rabattieren")  ;
  rackern_V = regV "rackern" ;
  radebrechen_V = irregV "radebrechen" "radebrecht" "radebrechte" "radebrechte" "radebrecht" ;
  radebrechen_VS = mkVS (irregV "radebrechen" "radebrecht" "radebrechte" "radebrechte" "radebrecht")  ;
  radeln_dir_V2 = prepV2 (regV "radeln") dir_Prep ;
  radieren_V2 = dirV2 (regV "radieren")  ;
  radikalisieren_V2 = dirV2 (regV "radikalisieren")  ;
  radizieren_V2 = dirV2 (regV "radizieren")  ;
  radotieren_ueber_V2 = prepV2 (irregV "radotieren" "radotiert" "radotierte" "radotierte" "radotiert") (mkPrep "über" accusative) ;
  raechen_am_fuer_rV3 = reflV3 (regV "rächen") accusative (mkPrep "an" dative) fuer_Prep ;
  raechen_V2 = dirV2 (regV "rächen")  ;
  raedern_V2 = dirV2 (regV "rädern")  ;
  raekeln_rV = reflV (regV "räkeln") accusative ;
  raesonieren_ueber_V2 = prepV2 (regV "räsonieren") (mkPrep "über" accusative) ;
  raetseln_ueber_V2 = prepV2 (regV "rätseln") (mkPrep "über" accusative) ;
  raeumen_V2 = dirV2 (regV "räumen")  ;
  raeuspern_rV = reflV (regV "räuspern") accusative ;
  raffen_V2 = dirV2 (regV "raffen")  ;
  raffinieren_V = regV "raffinieren" ;
  rahmen_V2 = dirV2 (regV "rahmen")  ;
  raiden_V = irregV "raiden" "raidet" "raidete" "raidete" "geraidet" ;
  rallen_V2 = dirV2 (regV "rallen")  ;
  ramifizieren_V = regV "ramifizieren" ;
  rammeln_V = regV "rammeln" ;
  rammen_V2 = dirV2 (regV "rammen")  ;
  ramponieren_V2 = dirV2 (regV "ramponieren")  ;
  randalieren_V = regV "randalieren" ;
  randen_V2 = dirV2 (regV "randen")  ;
  randomisieren_V2 = dirV2 (regV "randomisieren")  ;
  rangeln_mit_V2 = prepV2 (regV "rangeln") mit_Prep ;
  rangeln_plV = plV (regV "rangeln")  ;
  rangieren_dir_V3 = dirV3 (regV "rangieren") dir_Prep ;
  ranlassen_an_V3 = dirV3 (prefixV "ran" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen")) (mkPrep "an" accusative) ;
  rappeln_V2 = dirV2 (regV "rappeln")  ;
  rappeln_V = regV "rappeln" ;
  rappen_V = regV "rappen" ;
  rapportieren_V2 = dirV2 (regV "rapportieren")  ;
  rasen_V = regV "rasen" ;
  rasieren_V2 = dirV2 (regV "rasieren")  ;
  raspeln_V2 = dirV2 (regV "raspeln")  ;
  rasten_V = regV "rasten" ;
  rastern_V2 = dirV2 (regV "rastern")  ;
  raten_dat_zu_V3 = mkV3 (irregV "raten" "rät" "riet" "riete" "geraten") datPrep zu_Prep ;
  raten_V2 = dirV2 (irregV "raten" "rät" "riet" "riete" "geraten")  ;
  raten_VS = mkVS (irregV "raten" "rät" "riet" "riete" "geraten")  ;
  ratifizieren_V2 = dirV2 (regV "ratifizieren")  ;
  rationalisieren_V2 = dirV2 (regV "rationalisieren")  ;
  rationieren_V2 = dirV2 (regV "rationieren")  ;
  ratschen_mit_ueber_V3 = mkV3 (regV "ratschen") mit_Prep (mkPrep "über" accusative) ;
  ratschen_ueber_V2 = prepV2 (regV "ratschen") (mkPrep "über" accusative) ;
  ratschlagen_mit_ueber_V3 = mkV3 (regV "ratschlagen") mit_Prep (mkPrep "über" accusative) ;
  ratschlagen_ueber_V2 = prepV2 (regV "ratschlagen") (mkPrep "über" accusative) ;
  rattern_V = irregV "rattern" "rattert" "ratterte" "ratterte" "gerattert" ;
  ratzen_V = regV "ratzen" ;
  rauben_dat_V3 = accdatV3 (regV "rauben")  ;
  rauchen_V2 = dirV2 (regV "rauchen")  ;
  raufen_mit_V2 = prepV2 (regV "raufen") mit_Prep ;
  raufen_plV = plV (regV "raufen")  ;
  raunen_V2 = dirV2 (regV "raunen")  ;
  raunen_VS = mkVS (regV "raunen")  ;
  raunzen_VS = mkVS (regV "raunzen")  ;
  rauschen_V = regV "rauschen" ;
  reagieren_auf_V2 = prepV2 (regV "reagieren") (mkPrep "auf" accusative) ;
  realisieren_V2 = dirV2 (regV "realisieren")  ;
  realisieren_VS = mkVS (regV "realisieren")  ;
  rean_V = irregV "rean" "reat" "reate" "reate" "gereat" ;
  rebellieren_gegen_V2 = prepV2 (regV "rebellieren") gegen_Prep ;
  rechen_V2 = dirV2 (regV "rechen")  ;
  recherchieren_V2 = dirV2 (regV "recherchieren")  ;
  recherchieren_V = regV "recherchieren" ;
  recherchieren_VS = mkVS (regV "recherchieren")  ;
  rechnen_auf_V2 = prepV2 (regV "rechnen") (mkPrep "auf" accusative) ;
  rechnen_mit_V2 = prepV2 (regV "rechnen") mit_Prep ;
  rechten_mit_V2 = prepV2 (regV "rechten") mit_Prep ;
  rechtfertigen_mit_rV2 = reflV2 (regV "rechtfertigen") accusative mit_Prep ;
  rechtfertigen_V2 = dirV2 (regV "rechtfertigen")  ;
  recken_rV = reflV (irregV "recken" "reckt" "reckte" "reckte" "reckt") accusative ;
  reden_ueber_V2 = prepV2 (regV "reden") (mkPrep "über" accusative) ;
  reden_V2 = dirV2 (regV "reden")  ;
  reden_von_V2 = prepV2 (regV "reden") von_Prep ;
  redhibieren_V2 = dirV2 (irregV "redhibieren" "redhibiert" "redhibierte" "redhibierte" "redhibiert")  ;
  redigieren_V2 = dirV2 (regV "redigieren")  ;
  reduzieren_auf_V3 = dirV3 (regV "reduzieren") (mkPrep "auf" accusative) ;
  referenzieren_auf_V2 = prepV2 (regV "referenzieren") (mkPrep "auf" accusative) ;
  referenzieren_V2 = dirV2 (regV "referenzieren")  ;
  referieren_V2 = dirV2 (regV "referieren")  ;
  referieren_VS = mkVS (regV "referieren")  ;
  reffen_V2 = dirV2 (regV "reffen")  ;
  reflektieren_ueber_V2 = prepV2 (irregV "reflektieren" "reflektiert" "reflektierte" "reflektierte" "reflektiert") (mkPrep "über" accusative) ;
  reformieren_V2 = dirV2 (irregV "reformieren" "reformiert" "reformierte" "reformierte" "reformiert")  ;
  refuesieren_V2 = dirV2 (irregV "refüsieren" "refüsiert" "refüsierte" "refüsierte" "refüsiert")  ;
  refutieren_V2 = dirV2 (irregV "refutieren" "refutiert" "refutierte" "refutierte" "refutiert")  ;
  regalieren_mit_V3 = dirV3 (irregV "regalieren" "regaliert" "regalierte" "regalierte" "regaliert") mit_Prep ;
  regeln_V2 = dirV2 (regV "regeln")  ;
  regeln_VS = mkVS (regV "regeln")  ;
  regenerieren_rV = reflV (irregV "regenerieren" "regeneriert" "regenerierte" "regenerierte" "regeneriert") accusative ;
  regen_rV = reflV (irregV "regen" "regt" "regte" "regte" "regt") accusative ;
  regieren_V2 = dirV2 (regV "regieren")  ;
  regionalisieren_V2 = dirV2 (regV "regionalisieren")  ;
  registrieren_V2 = dirV2 (regV "registrieren")  ;
  registrieren_VS = mkVS (regV "registrieren")  ;
  reglementieren_V2 = dirV2 (regV "reglementieren")  ;
  reglementieren_VQ = mkVQ (regV "reglementieren")  ;
  regredieren_zu_V2 = prepV2 (irregV "regredieren" "regrediert" "regredierte" "regredierte" "regrediert") zu_Prep ;
  regularisieren_V2 = dirV2 (regV "regularisieren")  ;
  regulieren_V2 = dirV2 (regV "regulieren")  ;
  rehabilitieren_V2 = dirV2 (regV "rehabilitieren")  ;
  reiben_am_V3 = dirV3 (irregV "reiben" "reibt" "rieb" "riebe" "gerieben") (mkPrep "an" dative) ;
  reichen_dat_sV2 = dassV2 (regV "reichen") datPrep ;
  reichen_dat_V2 = mkV2 (regV "reichen") datPrep ;
  reichen_dat_V3 = accdatV3 (regV "reichen")  ;
  reifen_V = irregV "reifen" "reift" "reifte" "reifte" "reift" ;
  reihen_V2 = dirV2 (regV "reihen")  ;
  reihern_V = regV "reihern" ;
  reimen_auf_V3 = dirV3 (regV "reimen") (mkPrep "auf" accusative) ;
  reimen_V2 = dirV2 (regV "reimen")  ;
  reinchecken_in_V2 = prepV2 (prefixV "rein" (regV "checken")) (mkPrep "in" accusative) ;
  reinchecken_rV2 = reflV2 (prefixV "rein" (regV "checken")) accusative accPrep ;
  reinigen_V2 = dirV2 (regV "reinigen")  ;
  reinpfeifen_rV2 = reflV2 (prefixV "rein" (irregV "pfeifen" "pfeift" "pfiff" "priffe" "reingepfiffen")) accusative accPrep ;
  reinziehen_in_V3 = dirV3 (prefixV "rein" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen")) (mkPrep "in" accusative) ;
  reisen_dir_V2 = prepV2 (regV "reisen") dir_Prep ;
  reissen_V2 = dirV2 (irregV "reißen" "reißt" "riss" "risse" "gerissen")  ;
  reiten_dir_V2 = prepV2 (irregV "reiten" "reitet" "ritt" "ritte" "geritten") dir_Prep ;
  reiten_V2 = dirV2 (irregV "reiten" "reitet" "ritt" "ritte" "geritten")  ;
  reizen_V2 = dirV2 (regV "reizen")  ;
  reizen_V = regV "reizen" ;
  rekapitulieren_VS = mkVS (regV "rekapitulieren")  ;
  rekeln_rV = reflV (regV "rekeln") accusative ;
  reklamieren_V2 = dirV2 (regV "reklamieren")  ;
  reklamieren_VS = mkVS (regV "reklamieren")  ;
  rekognoszieren_V2 = dirV2 (regV "rekognoszieren")  ;
  rekombinieren_V2 = dirV2 (regV "rekombinieren")  ;
  rekonstituieren_rV = reflV (regV "rekonstituieren") accusative ;
  rekonstruieren_V2 = dirV2 (regV "rekonstruieren")  ;
  rekrutieren_aus_rV2 = reflV2 (regV "rekrutieren") accusative aus_Prep ;
  rekrutieren_aus_V3 = dirV3 (regV "rekrutieren") aus_Prep ;
  rekuperieren_V2 = dirV2 (regV "rekuperieren")  ;
  rekurrieren_auf_V2 = prepV2 (regV "rekurrieren") (mkPrep "auf" accusative) ;
  relativieren_V2 = dirV2 (irregV "relativieren" "relativiert" "relativierte" "relativierte" "relativiert")  ;
  relativieren_VS = mkVS (irregV "relativieren" "relativiert" "relativierte" "relativierte" "relativiert")  ;
  relaxen_V = irregV "relaxen" "relaxt" "relaxte" "relaxte" "relaxt" ;
  relegieren_V2 = dirV2 (regV "relegieren")  ;
  reliefieren_V2 = dirV2 (regV "reliefieren")  ;
  remittieren_V2 = dirV2 (regV "remittieren")  ;
  rempeln_V2 = dirV2 (regV "rempeln")  ;
  rennen_V = irregV "rennen" "rennt" "rannte" "rannte" "gerannt" ;
  renommieren_V = irregV "renommieren" "renommiert" "renommierte" "renommierte" "renommiert" ;
  renovieren_V2 = dirV2 (regV "renovieren")  ;
  rentieren_fuer_rV2 = reflV2 (regV "rentieren") accusative fuer_Prep ;
  reparieren_V2 = dirV2 (regV "reparieren")  ;
  repatriieren_V2 = dirV2 (regV "repatriieren")  ;
  repetieren_V2 = dirV2 (regV "repetieren")  ;
  repetieren_VS = mkVS (regV "repetieren")  ;
  replizieren_V2 = dirV2 (irregV "replizieren" "repliziert" "replizierte" "replizierte" "repliziert")  ;
  reponieren_V2 = dirV2 (irregV "reponieren" "reponiert" "reponierte" "reponierte" "reponiert")  ;
  repraesentieren_V2 = dirV2 (regV "repräsentieren")  ;
  reprimieren_V2 = dirV2 (irregV "reprimieren" "reprimiert" "reprimierte" "reprimierte" "reprimiert")  ;
  requirieren_V2 = dirV2 (regV "requirieren")  ;
  reservieren_V2 = dirV2 (irregV "reservieren" "reserviert" "reservierte" "reservierte" "reserviert")  ;
  resettieren_V0 = mkV0 (irregV "resettieren" "resettiert" "resettierte" "resettierte" "resettiert")  ;
  residieren_loc_V2 = prepV2 (regV "residieren") loc_Prep ;
  resignieren_V = irregV "resignieren" "resigniert" "resignierte" "resignierte" "resigniert" ;
  resorbieren_V2 = dirV2 (irregV "resorbieren" "resorbiert" "resorbierte" "resorbierte" "resorbiert")  ;
  respektieren_V2 = dirV2 (regV "respektieren")  ;
  respektieren_VS = mkVS (regV "respektieren")  ;
  restaurieren_V2 = dirV2 (regV "restaurieren")  ;
  restringieren_V2 = dirV2 (regV "restringieren")  ;
  restrukturieren_V2 = dirV2 (regV "restrukturieren")  ;
  resuemieren_V2 = dirV2 (regV "resümieren")  ;
  resuemieren_VS = mkVS (regV "resümieren")  ;
  resultieren_aus_V2 = prepV2 (irregV "resultieren" "resultiert" "resultierte" "resultierte" "resultiert") aus_Prep ;
  retournieren_V2 = dirV2 (regV "retournieren")  ;
  retten_V2 = dirV2 (regV "retten")  ;
  retuschieren_V2 = dirV2 (irregV "retuschieren" "retuschiert" "retuschierte" "retuschierte" "retuschiert")  ;
  reuen_sV2 = dassV2 (regV "reuen") accPrep ;
  reuen_V2 = dirV2 (regV "reuen")  ;
  reuessieren_V = irregV "reüssieren" "reüssiert" "reüssierte" "reüssierte" "reüssiert" ;
  revanchieren_bei_fuer_rV3 = reflV3 (regV "revanchieren") accusative bei_Prep fuer_Prep ;
  revidieren_V2 = dirV2 (irregV "revidieren" "revidiert" "revidierte" "revidierte" "revidiert")  ;
  revozieren_V2 = dirV2 (irregV "revozieren" "revoziert" "revozierte" "revozierte" "revoziert")  ;
  rezipieren_V2 = dirV2 (regV "rezipieren")  ;
  rezyklieren_V2 = dirV2 (irregV "rezyklieren" "rezykliert" "rezyklierte" "rezyklierte" "rezykliert")  ;
  richten_dir_V3 = dirV3 (regV "richten") dir_Prep ;
  richten_V2 = dirV2 (regV "richten")  ;
  riechen_V2 = dirV2 (irregV "riechen" "riecht" "roch" "röche" "gerochen")  ;
  riechen_VA = mkVA (irregV "riechen" "riecht" "roch" "röche" "gerochen")  ;
  rieseln_V = irregV "rieseln" "rieselt" "rieselte" "rieselte" "rieselt" ;
  riestern_V = irregV "riestern" "riestert" "riesterte" "riesterte" "geriestert" ;
  riffeln_V2 = dirV2 (regV "riffeln")  ;
  rigolen_V2 = dirV2 (irregV "rigolen" "rigolt" "rigolte" "rigolte" "rigolt")  ;
  rillen_V2 = dirV2 (regV "rillen")  ;
  ringeln_V2 = dirV2 (regV "ringeln")  ;
  ringen_mit_V2 = prepV2 (irregV "ringen" "ringt" "rang" "ränge" "gerungen") mit_Prep ;
  rinnen_V = irregV "rinnen" "rinnt" "rann" "ränne" "geronnen" ;
  rippen_V2 = dirV2 (irregV "rippen" "rippt" "rippte" "rippte" "rippt")  ;
  riskieren_V2 = dirV2 (irregV "riskieren" "riskiert" "riskierte" "riskierte" "riskiert")  ;
  riskieren_VS = mkVS (irregV "riskieren" "riskiert" "riskierte" "riskierte" "riskiert")  ;
  ritualisieren_V2 = dirV2 (regV "ritualisieren")  ;
  ritualisieren_VV = mkVV (regV "ritualisieren")  ;
  ritzen_dir_V3 = dirV3 (regV "ritzen") dir_Prep ;
  ritzen_V2 = dirV2 (regV "ritzen")  ;
  robben_V = regV "robben" ;
  roboten_V = irregV "roboten" "robotet" "robotete" "robote" "robotet" ;
  rochieren_mit_V2 = prepV2 (regV "rochieren") mit_Prep ;
  rochieren_plV = plV (regV "rochieren")  ;
  rodeln_dir_V2 = prepV2 (regV "rodeln") dir_Prep ;
  roden_V2 = dirV2 (regV "roden")  ;
  roecheln_V2 = dirV2 (regV "röcheln")  ;
  roecheln_VS = mkVS (regV "röcheln")  ;
  roedeln_um_V2 = prepV2 (regV "rödeln") um_Prep ;
  roedeln_V = regV "rödeln" ;
  roentgen_V2 = dirV2 (regV "röntgen")  ;
  roesten_V2 = dirV2 (regV "rösten")  ;
  rollen_V2 = dirV2 (regV "rollen")  ;
  rollen_V = regV "rollen" ;
  romanisieren_V2 = dirV2 (regV "romanisieren")  ;
  romantisieren_V2 = dirV2 (regV "romantisieren")  ;
  romantisieren_VS = mkVS (regV "romantisieren")  ;
  rosten_V = regV "rosten" ;
  rotieren_um_V2 = prepV2 (regV "rotieren") um_Prep ;
  rotieren_V = regV "rotieren" ;
  rotten_rV = reflV (regV "rotten") accusative ;
  rotten_V = regV "rotten" ;
  rotzen_dir_V2 = prepV2 (regV "rotzen") dir_Prep ;
  rubbeln_V2 = dirV2 (regV "rubbeln")  ;
  rubrizieren_V2 = dirV2 (regV "rubrizieren")  ;
  rudern_dir_V2 = prepV2 (regV "rudern") dir_Prep ;
  rudern_dir_V3 = dirV3 (regV "rudern") dir_Prep ;
  ruecken_dir_V2 = prepV2 (regV "rücken") dir_Prep ;
  rueffeln_V2 = dirV2 (regV "rüffeln")  ;
  ruegen_V2 = dirV2 (regV "rügen")  ;
  ruegen_VS = mkVS (regV "rügen")  ;
  ruehmen_gen_rV2 = reflV2 (regV "rühmen") accusative genPrep ;
  ruehmen_mit_rV2 = reflV2 (regV "rühmen") accusative mit_Prep ;
  ruehmen_V2 = dirV2 (regV "rühmen")  ;
  ruehmen_VS = mkVS (regV "rühmen")  ;
  ruehren_rV = reflV (regV "rühren") accusative ;
  ruehren_V2 = dirV2 (regV "rühren")  ;
  ruelpsen_V = regV "rülpsen" ;
  ruempfen_V2 = dirV2 (regV "rümpfen")  ;
  rueschen_V2 = dirV2 (regV "rüschen")  ;
  ruesten_fuer_rV2 = reflV2 (regV "rüsten") accusative fuer_Prep ;
  ruesten_fuer_V3 = dirV3 (regV "rüsten") fuer_Prep ;
  ruesten_gegen_rV2 = reflV2 (regV "rüsten") accusative gegen_Prep ;
  ruesten_gegen_V3 = dirV3 (regV "rüsten") gegen_Prep ;
  ruetteln_am_V2 = prepV2 (regV "rütteln") (mkPrep "an" dative) ;
  ruetteln_V2 = dirV2 (regV "rütteln")  ;
  rufen_dir_V3 = dirV3 (irregV "rufen" "ruft" "rief" "riefe" "gerufen") dir_Prep ;
  rufen_V2 = dirV2 (irregV "rufen" "ruft" "rief" "riefe" "gerufen")  ;
  rufen_VS = mkVS (irregV "rufen" "ruft" "rief" "riefe" "gerufen")  ;
  ruhen_V = regV "ruhen" ;
  ruinieren_V2 = dirV2 (regV "ruinieren")  ;
  rumhuren_V = prefixV "rum" (regV "huren") ;
  rumkriegen_V2 = dirV2 (prefixV "rum" (regV "kriegen"))  ;
  rumoren_es_loc_V2 = prepV2 (regV "rumoren") loc_Prep ;
  rumoren_V = regV "rumoren" ;
  runden_V2 = dirV2 (regV "runden")  ;
  runterfallen_V = prefixV "runter" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen") ;
  rutschen_V = regV "rutschen" ;
  sabbeln_V2 = dirV2 (regV "sabbeln")  ;
  sabbeln_VS = mkVS (regV "sabbeln")  ;
  sabbern_V = regV "sabbern" ;
  sabotieren_V2 = dirV2 (regV "sabotieren")  ;
  sabotieren_VS = mkVS (regV "sabotieren")  ;
  saechseln_V = regV "sächseln" ;
  saeen_V2 = dirV2 (regV "säen")  ;
  saegen_V = regV "sägen" ;
  saekularisieren_V2 = dirV2 (regV "säkularisieren")  ;
  saettigen_V2 = dirV2 (regV "sättigen")  ;
  saeubern_V2 = dirV2 (regV "säubern")  ;
  saeugen_V2 = dirV2 (regV "säugen")  ;
  saeuseln_V2 = dirV2 (regV "säuseln")  ;
  saeuseln_VS = mkVS (regV "säuseln")  ;
  saften_V = regV "saften" ;
  sagen_V2 = dirV2 (regV "sagen")  ;
  sagen_VS = mkVS (regV "sagen")  ;
  sakralisieren_V2 = dirV2 (regV "sakralisieren")  ;
  salbadern_V = regV "salbadern" ;
  salben_V2 = dirV2 (regV "salben")  ;
  saldieren_V2 = dirV2 (regV "saldieren")  ;
  salutieren_vor_V2 = prepV2 (regV "salutieren") (mkPrep "vor" dative) ;
  salzen_V2 = dirV2 (regV "salzen")  ;
  sammeln_V2 = dirV2 (regV "sammeln")  ;
  sanieren_V2 = dirV2 (regV "sanieren")  ;
  sanktionieren_V2 = dirV2 (regV "sanktionieren")  ;
  sanktionieren_VS = mkVS (regV "sanktionieren")  ;
  satteln_V2 = dirV2 (regV "satteln")  ;
  saturieren_V2 = dirV2 (regV "saturieren")  ;
  sauen_V = regV "sauen" ;
  saufen_V2 = dirV2 (irregV "saufen" "sauft" "soff" "söffe" "gesoffen")  ;
  saufen_V = irregV "saufen" "sauft" "soff" "söffe" "gesoffen" ;
  saugen_am_V2 = prepV2 (regV "saugen") (mkPrep "an" dative) ;
  saugen_V = regV "saugen" ;
  saunen_V = regV "saunen" ;
  saunieren_V = regV "saunieren" ;
  sausen_V = regV "sausen" ;
  sautieren_V2 = dirV2 (regV "sautieren")  ;
  saven_V2 = dirV2 (regV "saven")  ;
  scannen_V2 = dirV2 (regV "scannen")  ;
  schaben_V2 = dirV2 (regV "schaben")  ;
  schabernacken_V = regV "schabernacken" ;
  schablonisieren_V2 = dirV2 (regV "schablonisieren")  ;
  schachern_mit_um_V3 = mkV3 (regV "schachern") mit_Prep um_Prep ;
  schachern_um_V2 = prepV2 (regV "schachern") um_Prep ;
  schachten_V2 = dirV2 (regV "schachten")  ;
  schachten_V = regV "schachten" ;
  schaden_dat_V2 = mkV2 (regV "schaden") datPrep ;
  schaechten_V2 = dirV2 (regV "schächten")  ;
  schaedigen_V2 = dirV2 (regV "schädigen")  ;
  schaekern_mit_V2 = prepV2 (regV "schäkern") mit_Prep ;
  schaekern_plV = plV (regV "schäkern")  ;
  schaelen_V2 = dirV2 (regV "schälen")  ;
  schaemen_rV = reflV (regV "schämen") accusative ;
  schaenden_V2 = dirV2 (regV "schänden")  ;
  schaeren_V2 = dirV2 (regV "schären")  ;
  schaetzen_als_V3 = dirV3 (regV "schätzen") (mkPrep "als" accusative) ;
  schaetzen_auf_V3 = dirV3 (regV "schätzen") (mkPrep "auf" accusative) ;
  schaetzen_V2 = dirV2 (regV "schätzen")  ;
  schaetzen_VS = mkVS (regV "schätzen")  ;
  schaeumen_V2 = dirV2 (regV "schäumen")  ;
  schaffen_V = irregV "schaffen" "schafft" "schuf" "schüfe" "geschaffen" ;
  schaffen_VS = mkVS (irregV "schaffen" "schafft" "schuf" "schüfe" "geschaffen")  ;
  schalten_V = regV "schalten" ;
  schamottieren_V2 = dirV2 (regV "schamottieren")  ;
  schanghaien_V2 = dirV2 (regV "schanghaien")  ;
  scharren_loc_V2 = prepV2 (regV "scharren") loc_Prep ;
  scharrieren_V2 = dirV2 (regV "scharrieren")  ;
  scharwenzeln_mit_V2 = prepV2 (regV "scharwenzeln") mit_Prep ;
  scharwenzeln_um_V2 = prepV2 (regV "scharwenzeln") um_Prep ;
  schassen_V2 = dirV2 (regV "schassen")  ;
  schattieren_V2 = dirV2 (regV "schattieren")  ;
  schauen_auf_V2 = prepV2 (regV "schauen") (mkPrep "auf" accusative) ;
  schauen_V = regV "schauen" ;
  schaukeln_V = regV "schaukeln" ;
  schauspielern_V = regV "schauspielern" ;
  scheffeln_V2 = dirV2 (regV "scheffeln")  ;
  scheiden_von_V2 = prepV2 (irregV "scheiden" "scheidet" "schied" "schiede" "geschieden") von_Prep ;
  scheinen_dat_V2A = mkV2A (irregV "scheinen" "scheint" "schien" "schiene" "geschienen") datPrep ;
  scheinen_es_VS = mkVS (irregV "scheinen" "scheint" "schien" "schiene" "geschienen")  ;
  scheissen_auf_V2 = prepV2 (irregV "scheißen" "scheißt" "schiss" "schisse" "geschissen") (mkPrep "auf" accusative) ;
  scheissen_V = irregV "scheißen" "scheißt" "schiss" "schisse" "geschissen" ;
  scheiteln_V2 = dirV2 (regV "scheiteln")  ;
  scheitern_mit_V2 = prepV2 (regV "scheitern") mit_Prep ;
  schellen_am_V2 = prepV2 (regV "schellen") (mkPrep "an" dative) ;
  schellen_V2 = dirV2 (regV "schellen")  ;
  schelten_V2 = dirV2 (irregV "schelten" "schilt" "schalt" "schölte" "gescholten")  ;
  schematisieren_V2 = dirV2 (regV "schematisieren")  ;
  schenken_dat_V3 = accdatV3 (regV "schenken")  ;
  schenken_rV2 = reflV2 (regV "schenken") accusative accPrep ;
  schenken_rVV = reflVV (regV "schenken") accusative ;
  scheppen_V2 = dirV2 (regV "scheppen")  ;
  scheppern_V = regV "scheppern" ;
  scheren_2_V = regV "scheren" ;
  scheren_sV2 = dassV2 (irregV "scheren" "schert" "schor" "schöre" "geschoren") accPrep ;
  scheren_um_rV2 = reflV2 (irregV "scheren" "schert" "schor" "schöre" "geschoren") accusative um_Prep ;
  scheren_V2 = dirV2 (irregV "scheren" "schert" "schor" "schöre" "geschoren")  ;
  scherzen_mit_V2 = prepV2 (regV "scherzen") mit_Prep ;
  scherzen_V = regV "scherzen" ;
  scherzen_VS = mkVS (regV "scherzen")  ;
  schesen_dir_V2 = prepV2 (regV "schesen") dir_Prep ;
  scheuchen_dir_V3 = dirV3 (regV "scheuchen") dir_Prep ;
  scheuen_V2 = dirV2 (regV "scheuen")  ;
  scheuen_vor_rV2 = reflV2 (regV "scheuen") accusative (mkPrep "vor" dative) ;
  schicken_dat_V3 = accdatV3 (regV "schicken")  ;
  schicken_dir_V3 = dirV3 (regV "schicken") dir_Prep ;
  schickern_V = regV "schickern" ;
  schieben_dir_V3 = dirV3 (irregV "schieben" "schiebt" "schob" "schöbe" "geschoben") dir_Prep ;
  schiedsrichtern_V = regV "schiedsrichtern" ;
  schielen_dir_V2 = prepV2 (regV "schielen") dir_Prep ;
  schienen_V2 = dirV2 (regV "schienen")  ;
  schiessen_auf_V2 = prepV2 (irregV "schießen" "schießt" "schoss" "schösse" "geschossen") (mkPrep "auf" accusative) ;
  schiessen_V2 = dirV2 (irregV "schießen" "schießt" "schoss" "schösse" "geschossen")  ;
  schiffen_V = regV "schiffen" ;
  schiften_V2 = dirV2 (regV "schiften")  ;
  schikanieren_V2 = dirV2 (regV "schikanieren")  ;
  schildern_dat_V2S = mkV2S (regV "schildern") datPrep ;
  schildern_dat_V3 = accdatV3 (regV "schildern")  ;
  schillern_V = regV "schillern" ;
  schimmeln_V = regV "schimmeln" ;
  schimmern_durch_V2 = prepV2 (regV "schimmern") durch_Prep ;
  schimpfen_auf_V2 = prepV2 (regV "schimpfen") (mkPrep "auf" accusative) ;
  schimpfen_ueber_V2 = prepV2 (regV "schimpfen") (mkPrep "über" accusative) ;
  schimpfen_V2 = dirV2 (regV "schimpfen")  ;
  schindeln_V2 = dirV2 (regV "schindeln")  ;
  schinden_V2 = dirV2 (regV "schinden")  ;
  schlachten_V2 = dirV2 (regV "schlachten")  ;
  schlaegern_rV = reflV (regV "schlägern") accusative ;
  schlaegern_V2 = dirV2 (regV "schlägern")  ;
  schlafen_mit_V2 = prepV2 (irregV "schlafen" "schläft" "schlief" "schliefe" "geschlafen") mit_Prep ;
  schlafen_V = irregV "schlafen" "schläft" "schlief" "schliefe" "geschlafen" ;
  schlagen_dir_V2 = prepV2 (irregV "schlagen" "schlägt" "schlug" "schlüge" "geschlagen") dir_Prep ;
  schlagen_mit_rV2 = reflV2 (irregV "schlagen" "schlägt" "schlug" "schlüge" "geschlagen") accusative mit_Prep ;
  schlagen_rV = reflV (irregV "schlagen" "schlägt" "schlug" "schlüge" "geschlagen") accusative ;
  schlagen_V2 = dirV2 (irregV "schlagen" "schlägt" "schlug" "schlüge" "geschlagen")  ;
  schlampen_V = regV "schlampen" ;
  schlauchen_sV2 = dassV2 (regV "schlauchen") accPrep ;
  schlecken_V2 = dirV2 (regV "schlecken")  ;
  schleichen_V = irregV "schleichen" "schleicht" "schlich" "schliche" "geschlichen" ;
  schleifen_V2 = dirV2 (regV "schleifen")  ;
  schleimen_um_V2 = prepV2 (regV "schleimen") um_Prep ;
  schlemmen_V2 = dirV2 (regV "schlemmen")  ;
  schlendern_dir_V2 = prepV2 (regV "schlendern") dir_Prep ;
  schlenzen_dir_V3 = dirV3 (regV "schlenzen") dir_Prep ;
  schleppen_V2 = dirV2 (regV "schleppen")  ;
  schleudern_V2 = dirV2 (regV "schleudern")  ;
  schleusen_dir_V3 = dirV3 (regV "schleusen") dir_Prep ;
  schlichten_V2 = dirV2 (regV "schlichten")  ;
  schlickern_V = regV "schlickern" ;
  schlieren_V = regV "schlieren" ;
  schliessen_V2 = dirV2 (irregV "schließen" "schließt" "schloss" "schlösse" "geschlossen")  ;
  schlingen_um_V3 = dirV3 (irregV "schlingen" "schlingt" "schlang" "schlänge" "geschlungen") um_Prep ;
  schlittern_V = regV "schlittern" ;
  schlossern_V2 = dirV2 (regV "schlossern")  ;
  schlottern_V = regV "schlottern" ;
  schlotzen_V2 = dirV2 (regV "schlotzen")  ;
  schluchzen_V2 = dirV2 (regV "schluchzen")  ;
  schluchzen_V = regV "schluchzen" ;
  schluchzen_VS = mkVS (regV "schluchzen")  ;
  schlucken_V = regV "schlucken" ;
  schludern_V = regV "schludern" ;
  schluerfen_V2 = dirV2 (regV "schlürfen")  ;
  schluerfen_V = regV "schlürfen" ;
  schluffen_dir_V2 = prepV2 (regV "schluffen") dir_Prep ;
  schlummern_V = regV "schlummern" ;
  schlupfen_dir_V2 = prepV2 (regV "schlupfen") dir_Prep ;
  schlurfen_dir_V2 = prepV2 (regV "schlurfen") dir_Prep ;
  schlussfolgern_VS = mkVS (regV "schlussfolgern")  ;
  schmachten_nach_V2 = prepV2 (regV "schmachten") nach_Prep ;
  schmadern_V = regV "schmadern" ;
  schmaehen_V2 = dirV2 (regV "schmähen")  ;
  schmaelen_V2 = dirV2 (regV "schmälen")  ;
  schmaelern_V2 = dirV2 (regV "schmälern")  ;
  schmaelzen_V2 = dirV2 (regV "schmälzen")  ;
  schmalzen_V2 = dirV2 (regV "schmalzen")  ;
  schmarotzen_V = regV "schmarotzen" ;
  schmatzen_V = regV "schmatzen" ;
  schmauchen_V2 = dirV2 (regV "schmauchen")  ;
  schmausen_V2 = dirV2 (regV "schmausen")  ;
  schmecken_dat_V2 = mkV2 (regV "schmecken") datPrep ;
  schmecken_V2 = dirV2 (regV "schmecken")  ;
  schmeicheln_dat_sV2 = dassV2 (regV "schmeicheln") datPrep ;
  schmeicheln_dat_V2 = mkV2 (regV "schmeicheln") datPrep ;
  schmeissen_dir_V3 = dirV3 (irregV "schmeißen" "schmeißt" "schmiss" "schmisse" "geschmissen") dir_Prep ;
  schmeissen_V2 = dirV2 (irregV "schmeißen" "schmeißt" "schmiss" "schmisse" "geschmissen")  ;
  schmelzen_V2 = dirV2 (irregV "schmelzen" "schmelzt" "schmolz" "schmölze" "geschmolzen")  ;
  schmerzen_sV2 = dassV2 (regV "schmerzen") accPrep ;
  schmerzen_V2 = dirV2 (regV "schmerzen")  ;
  schmerzen_V = regV "schmerzen" ;
  schmettern_V2 = dirV2 (regV "schmettern")  ;
  schmieden_V2 = dirV2 (regV "schmieden")  ;
  schmieren_dir_V3 = dirV3 (regV "schmieren") dir_Prep ;
  schmieren_V2 = dirV2 (regV "schmieren")  ;
  schmieren_V = regV "schmieren" ;
  schminken_V2 = dirV2 (regV "schminken")  ;
  schmirgeln_V2 = dirV2 (regV "schmirgeln")  ;
  schmoeken_V2 = dirV2 (regV "schmöken")  ;
  schmoekern_im_V2 = prepV2 (regV "schmökern") (mkPrep "in" dative) ;
  schmoekern_V = regV "schmökern" ;
  schmollen_dat_V2 = mkV2 (regV "schmollen") datPrep ;
  schmollen_V = regV "schmollen" ;
  schmoren_V2 = dirV2 (regV "schmoren")  ;
  schmuecken_V2 = dirV2 (regV "schmücken")  ;
  schmuggeln_dir_V3 = dirV3 (regV "schmuggeln") dir_Prep ;
  schmulen_V = regV "schmulen" ;
  schmunzeln_V = regV "schmunzeln" ;
  schmusen_mit_V2 = prepV2 (regV "schmusen") mit_Prep ;
  schmusen_plV = plV (regV "schmusen")  ;
  schnabulieren_V2 = dirV2 (regV "schnabulieren")  ;
  schnacken_mit_ueber_V3 = mkV3 (regV "schnacken") mit_Prep (mkPrep "über" accusative) ;
  schnacken_ueber_V2 = prepV2 (regV "schnacken") (mkPrep "über" accusative) ;
  schnackseln_mit_V2 = prepV2 (regV "schnackseln") mit_Prep ;
  schnaeuzen_rV = reflV (regV "schnäuzen") accusative ;
  schnallen_V2 = dirV2 (regV "schnallen")  ;
  schnalzen_mit_V2 = prepV2 (regV "schnalzen") mit_Prep ;
  schnappen_nach_V2 = prepV2 (regV "schnappen") (mkPrep "nach" dative) ;
  schnappen_rV2 = reflV2 (regV "schnappen") dative accPrep ;
  schnapseln_V = regV "schnapseln" ;
  schnarchen_V = regV "schnarchen" ;
  schnarren_V2 = dirV2 (regV "schnarren")  ;
  schnarren_VS = mkVS (regV "schnarren")  ;
  schnattern_V2 = dirV2 (regV "schnattern")  ;
  schnattern_VS = mkVS (regV "schnattern")  ;
  schnauben_V = regV "schnauben" ;
  schnaufen_V = regV "schnaufen" ;
  schneiden_V2 = dirV2 (irregV "schneiden" "schneidet" "schnitt" "schnitte" "geschnitten")  ;
  schneidern_V2 = dirV2 (regV "schneidern")  ;
  schneuzen_rV = reflV (regV "schneuzen") accusative ;
  schnippen_V = regV "schnippen" ;
  schnipsen_V = regV "schnipsen" ;
  schnitzen_V2 = dirV2 (regV "schnitzen")  ;
  schnoekern_V2 = dirV2 (regV "schnökern")  ;
  schnoekern_V = regV "schnökern" ;
  schnorcheln_V = regV "schnorcheln" ;
  schnorren_bei_V3 = dirV3 (regV "schnorren") bei_Prep ;
  schnorren_von_V3 = dirV3 (regV "schnorren") von_Prep ;
  schnucken_V = regV "schnucken" ;
  schnueffeln_im_V2 = prepV2 (regV "schnüffeln") (mkPrep "in" dative) ;
  schnupfen_V2 = dirV2 (regV "schnupfen")  ;
  schnuppern_am_V2 = prepV2 (regV "schnuppern") (mkPrep "an" dative) ;
  schnurren_V = regV "schnurren" ;
  schocken_V2 = dirV2 (regV "schocken")  ;
  schockieren_sV2 = dassV2 (regV "schockieren") accPrep ;
  schockieren_V2 = dirV2 (regV "schockieren")  ;
  schoenen_V2 = dirV2 (regV "schönen")  ;
  schoenreden_V2 = dirV2 (prefixV "schön" (regV "reden"))  ;
  schoenreden_VS = mkVS (prefixV "schön" (regV "reden"))  ;
  schoepfen_V2 = dirV2 (regV "schöpfen")  ;
  schonen_V2 = dirV2 (regV "schonen")  ;
  schraffieren_V2 = dirV2 (regV "schraffieren")  ;
  schrammeln_V = regV "schrammeln" ;
  schrauben_dir_V3 = dirV3 (regV "schrauben") dir_Prep ;
  schrecken_sV2 = dassV2 (regV "schrecken") accPrep ;
  schrecken_V2 = dirV2 (regV "schrecken")  ;
  schreiben_ueber_V2 = prepV2 (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben") (mkPrep "über" accusative) ;
  schreiben_V2 = dirV2 (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben")  ;
  schreiben_von_V2 = prepV2 (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben") von_Prep ;
  schreiben_VS = mkVS (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben")  ;
  schreien_V2 = dirV2 (irregV "schreien" "schreit" "schrie" "schriee" "geschrien")  ;
  schreien_VS = mkVS (irregV "schreien" "schreit" "schrie" "schriee" "geschrien")  ;
  schreinern_V2 = dirV2 (regV "schreinern")  ;
  schreiten_dir_V2 = prepV2 (regV "schreiten") dir_Prep ;
  schriftstellern_V = regV "schriftstellern" ;
  schrillen_V = regV "schrillen" ;
  schroepfen_V2 = dirV2 (regV "schröpfen")  ;
  schrotten_V2 = dirV2 (irregV "schrotten" "schrottet" "schrottete" "schrotte" "geschrottet")  ;
  schrumpfen_V = regV "schrumpfen" ;
  schubsen_V2 = dirV2 (regV "schubsen")  ;
  schueren_V2 = dirV2 (regV "schüren")  ;
  schuerfen_nach_V2 = prepV2 (regV "schürfen") (mkPrep "nach" dative) ;
  schuerzen_V2 = dirV2 (regV "schürzen")  ;
  schuetteln_sV2 = dassV2 (regV "schütteln") accPrep ;
  schuetteln_V2 = dirV2 (regV "schütteln")  ;
  schuetten_dir_V3 = dirV3 (regV "schütten") dir_Prep ;
  schuetzen_vor_V3 = dirV3 (regV "schützen") (mkPrep "vor" dative) ;
  schuften_am_V2 = prepV2 (regV "schuften") (mkPrep "an" dative) ;
  schuften_V = regV "schuften" ;
  schulden_dat_V2S = mkV2S (regV "schulden") datPrep ;
  schulden_dat_V3 = accdatV3 (regV "schulden")  ;
  schulen_V2 = dirV2 (regV "schulen")  ;
  schultern_V2 = dirV2 (regV "schultern")  ;
  schummeln_V = regV "schummeln" ;
  schunkeln_mit_V2 = prepV2 (regV "schunkeln") mit_Prep ;
  schunkeln_V = regV "schunkeln" ;
  schurigeln_V2 = dirV2 (regV "schurigeln")  ;
  schustern_V2 = dirV2 (regV "schustern")  ;
  schwadronieren_V2 = dirV2 (regV "schwadronieren")  ;
  schwadronieren_VS = mkVS (regV "schwadronieren")  ;
  schwaebeln_V = regV "schwäbeln" ;
  schwaecheln_V = regV "schwächeln" ;
  schwaengern_V2 = dirV2 (regV "schwängern")  ;
  schwaenzen_V2 = dirV2 (regV "schwänzen")  ;
  schwaermen_fuer_V2 = prepV2 (regV "schwärmen") fuer_Prep ;
  schwaermen_von_V2 = prepV2 (regV "schwärmen") von_Prep ;
  schwaerzen_V2 = dirV2 (regV "schwärzen")  ;
  schwaetzen_mit_V2 = prepV2 (regV "schwätzen") mit_Prep ;
  schwafeln_V2 = dirV2 (regV "schwafeln")  ;
  schwafeln_VS = mkVS (regV "schwafeln")  ;
  schwanen_dat_V2 = mkV2 (regV "schwanen") datPrep ;
  schwanen_es_dat_V2S = mkV2S (regV "schwanen") datPrep ;
  schwanken_V = regV "schwanken" ;
  schwarzsehen_V = prefixV "schwarz" (irregV "sehen" "sieht" "sah" "sähe" "gesehen") ;
  schwatzen_V2 = dirV2 (regV "schwatzen")  ;
  schwatzen_VS = mkVS (regV "schwatzen")  ;
  schweben_ueber_V2 = prepV2 (regV "schweben") (mkPrep "über" dative) ;
  schweben_V = regV "schweben" ;
  schweigen_V = irregV "schweigen" "schweigt" "schwieg" "schwiege" "geschwiegen" ;
  schweissen_V2 = dirV2 (regV "schweißen")  ;
  schwelen_V = regV "schwelen" ;
  schwelgen_in_V2 = prepV2 (regV "schwelgen") (mkPrep "in" accusative) ;
  schwellen_V = irregV "schwellen" "schwellt" "schwoll" "schwölle" "geschwollen" ;
  schwenken_V2 = dirV2 (regV "schwenken")  ;
  schwimmen_V = irregV "schwimmen" "schwimmt" "schwamm" "schwämme" "geschwommen" ;
  schwindeln_V = regV "schwindeln" ;
  schwindeln_VS = mkVS (regV "schwindeln")  ;
  schwinden_dat_V2 = mkV2 (irregV "schwinden" "schwindet" "schwand" "schwände" "geschwunden") datPrep ;
  schwinden_V = irregV "schwinden" "schwindet" "schwand" "schwände" "geschwunden" ;
  schwingen_V2 = dirV2 (irregV "schwingen" "schwingt" "schwang" "schwänge" "geschwungen")  ;
  schwitzen_V = regV "schwitzen" ;
  schwoeren_V2 = dirV2 (irregV "schwören" "schwört" "schwor" "schwöre" "geschworen")  ;
  schwoeren_VS = mkVS (irregV "schwören" "schwört" "schwor" "schwöre" "geschworen")  ;
  schwofen_mit_V2 = prepV2 (regV "schwofen") mit_Prep ;
  schwofen_V = regV "schwofen" ;
  schwurbeln_V = regV "schwurbeln" ;
  screenen_V2 = dirV2 (regV "screenen")  ;
  scrollen_V = regV "scrollen" ;
  sedieren_V2 = dirV2 (regV "sedieren")  ;
  segeln_V = regV "segeln" ;
  segmentieren_V2 = dirV2 (regV "segmentieren")  ;
  segnen_V2 = dirV2 (regV "segnen")  ;
  sehen_V2 = dirV2 (irregV "sehen" "seht" "sah" "sähe" "gesehen")  ;
  sehen_VS = mkVS (irregV "sehen" "seht" "sah" "sähe" "gesehen")  ;
  sehnen_nach_rV2 = reflV2 (regV "sehnen") accusative nach_Prep ;
  seichen_V = regV "seichen" ;
  seiern_V2 = dirV2 (regV "seiern")  ;
  seiern_V = regV "seiern" ;
  seifen_V2 = dirV2 (regV "seifen")  ;
  seigern_V2 = dirV2 (regV "seigern")  ;
  seigern_V = regV "seigern" ;
  seihen_V2 = dirV2 (regV "seihen")  ;
  sekkieren_V2 = dirV2 (irregV "sekkieren" "sekkiert" "sekkierte" "sekkierte" "sekkiert")  ;
  sekretieren_V2 = dirV2 (irregV "sekretieren" "sekretiert" "sekretierte" "sekretierte" "sekretiert")  ;
  sekundieren_dat_V2 = mkV2 (regV "sekundieren") datPrep ;
  selchen_V2 = dirV2 (regV "selchen")  ;
  selegieren_V2 = dirV2 (irregV "selegieren" "selegiert" "selegierte" "selegierte" "selegiert")  ;
  selektieren_V2 = dirV2 (irregV "selektieren" "selektiert" "selektierte" "selektierte" "selektiert")  ;
  senden_dat_V3 = accdatV3 (regV "senden")  ;
  senden_dir_V3 = dirV3 (regV "senden") dir_Prep ;
  senden_V2 = dirV2 (regV "senden")  ;
  senden_VS = mkVS (regV "senden")  ;
  sengen_V2 = dirV2 (regV "sengen")  ;
  senken_dir_V3 = dirV3 (regV "senken") dir_Prep ;
  sensen_V2 = dirV2 (regV "sensen")  ;
  sensibilisieren_sV2 = dassV2 (regV "sensibilisieren") accPrep ;
  sensibilisieren_V2 = dirV2 (regV "sensibilisieren")  ;
  sensitivieren_sV2 = dassV2 (regV "sensitivieren") accPrep ;
  sensitivieren_V2 = dirV2 (regV "sensitivieren")  ;
  separieren_von_V3 = dirV3 (regV "separieren") von_Prep ;
  sequenzieren_V2 = dirV2 (regV "sequenzieren")  ;
  serbeln_V = regV "serbeln" ;
  servieren_dat_V3 = accdatV3 (regV "servieren")  ;
  setzen_auf_V2 = prepV2 (regV "setzen") (mkPrep "auf" accusative) ;
  seufzen_V2 = dirV2 (regV "seufzen")  ;
  seufzen_V = regV "seufzen" ;
  seufzen_VS = mkVS (regV "seufzen")  ;
  sexualisieren_V2 = dirV2 (regV "sexualisieren")  ;
  sezemieren_V0 = mkV0 (irregV "sezemieren" "sezemiert" "sezemierte" "sezemierte" "sezemiert")  ;
  sezernieren_V2 = dirV2 (irregV "sezernieren" "sezerniert" "sezernierte" "sezernierte" "sezerniert")  ;
  sezieren_V2 = dirV2 (irregV "sezieren" "seziert" "sezierte" "sezierte" "seziert")  ;
  shoppen_V = regV "shoppen" ;
  sichern_V2 = dirV2 (irregV "sichern" "sichert" "sicherte" "sicherte" "sichert")  ;
  sicherstellen_V2 = dirV2 (prefixV "sicher" (irregV "stellen" "stellt" "stellte" "stelle" "gestellt"))  ;
  sichten_V2 = dirV2 (regV "sichten")  ;
  sicken_V = regV "sicken" ;
  sickern_dir_V2 = prepV2 (regV "sickern") dir_Prep ;
  sieben_V2 = dirV2 (regV "sieben")  ;
  siechen_V = regV "siechen" ;
  siedeln_loc_V2 = prepV2 (regV "siedeln") loc_Prep ;
  sieden_V = regV "sieden" ;
  siegeln_V2 = dirV2 (regV "siegeln")  ;
  siegen_ueber_V2 = prepV2 (regV "siegen") (mkPrep "über" accusative) ;
  siezen_V2 = dirV2 (regV "siezen")  ;
  signalisieren_dat_V2S = mkV2S (regV "signalisieren") datPrep ;
  signalisieren_dat_V3 = accdatV3 (regV "signalisieren")  ;
  signieren_V2 = dirV2 (regV "signieren")  ;
  simplifizieren_V2 = dirV2 (regV "simplifizieren")  ;
  simsen_mit_V2 = prepV2 (irregV "simsen" "simst" "simste" "simste" "simst") mit_Prep ;
  simsen_plV = plV (irregV "simsen" "simst" "simste" "simste" "simst")  ;
  simulieren_V2 = dirV2 (irregV "simulieren" "simuliert" "simulierte" "simulierte" "simuliert")  ;
  singen_V2 = dirV2 (irregV "singen" "singt" "sang" "sänge" "gesungen")  ;
  sinken_V = irregV "sinken" "sinkt" "sank" "sänke" "gesunken" ;
  sinnen_ueber_V2 = prepV2 (irregV "sinnen" "sinnt" "sann" "sänne" "gesonnen") (mkPrep "über" accusative) ;
  sinnieren_ueber_V2 = prepV2 (regV "sinnieren") (mkPrep "über" accusative) ;
  sirren_V = regV "sirren" ;
  sistieren_V2 = dirV2 (regV "sistieren")  ;
  situieren_loc_V3 = dirV3 (regV "situieren") loc_Prep ;
  sitzen_V = irregV "sitzen" "sitzt" "saß" "säße" "gesessen" ;
  skalieren_V2 = dirV2 (regV "skalieren")  ;
  skalpieren_V2 = dirV2 (regV "skalpieren")  ;
  skandieren_V2 = dirV2 (regV "skandieren")  ;
  skandieren_VS = mkVS (regV "skandieren")  ;
  skartieren_V2 = dirV2 (regV "skartieren")  ;
  skaten_dir_V2 = prepV2 (regV "skaten") dir_Prep ;
  skizzieren_V2 = dirV2 (regV "skizzieren")  ;
  skontieren_V2 = dirV2 (regV "skontieren")  ;
  skoptisieren_V = irregV "skoptisieren" "skoptisiert" "skoptisierte" "skoptisierte" "skoptisiert" ;
  skypen_mit_V2 = prepV2 (irregV "skypen" "skypt" "skypte" "skypte" "skypt") mit_Prep ;
  slawisieren_V2 = dirV2 (regV "slawisieren")  ;
  slippen_V2 = dirV2 (regV "slippen")  ;
  sohlen_V2 = dirV2 (regV "sohlen")  ;
  solidarisieren_mit_rV2 = reflV2 (regV "solidarisieren") accusative mit_Prep ;
  sollen_inf_VV = auxVV (irregV "sollen" "sollt" "sollte" "sollte" "sollt")  ;
  sollizitieren_zu_V2 = prepV2 (irregV "sollizitieren" "sollizitiert" "sollizitierte" "sollizitierte" "sollizitiert") zu_Prep ;
  solubilisieren_V0 = mkV0 (irregV "solubilisieren" "solubilisiert" "solubilisierte" "solubilisierte" "solubilisiert")  ;
  solvatisieren_V0 = mkV0 (irregV "solvatisieren" "solvatisiert" "solvatisierte" "solvatisierte" "solvatisiert")  ;
  sondern_von_V3 = dirV3 (regV "sondern") (mkPrep "von" dative) ;
  sondieren_V2 = dirV2 (regV "sondieren")  ;
  sondieren_VQ = mkVQ (regV "sondieren")  ;
  sonnen_im_rV2 = reflV2 (regV "sonnen") accusative (mkPrep "in" dative) ;
  sorgen_fuer_V2 = prepV2 (regV "sorgen") fuer_Prep ;
  sorgen_um_rV2 = reflV2 (regV "sorgen") accusative um_Prep ;
  sortieren_V2 = dirV2 (regV "sortieren")  ;
  soufflieren_dat_V2S = mkV2S (regV "soufflieren") datPrep ;
  soufflieren_dat_V3 = accdatV3 (regV "soufflieren")  ;
  soupieren_V = regV "soupieren" ;
  spachteln_V2 = dirV2 (regV "spachteln")  ;
  spaehen_V = regV "spähen" ;
  spaenen_V2 = dirV2 (regV "spänen")  ;
  spalten_V2 = dirV2 (irregV "spalten" "spaltet" "spaltete" "spaltete" "gespalten")  ;
  spannen_dir_V3 = dirV3 (regV "spannen") dir_Prep ;
  spannen_V2 = dirV2 (regV "spannen")  ;
  spannen_VS = mkVS (regV "spannen")  ;
  sparen_an_V2 = prepV2 (regV "sparen") (mkPrep "an" accusative) ;
  sparen_mit_V2 = prepV2 (regV "sparen") mit_Prep ;
  sparen_rV2 = reflV2 (regV "sparen") accusative accPrep ;
  sparen_rVV = reflVV (regV "sparen") accusative ;
  sparen_V2 = dirV2 (regV "sparen")  ;
  spassen_mit_V2 = prepV2 (regV "spaßen") mit_Prep ;
  spassen_VS = mkVS (regV "spaßen")  ;
  spawnen_V = regV "spawnen" ;
  spazieren_dir_V2 = prepV2 (regV "spazieren") dir_Prep ;
  spechteln_V = regV "spechteln" ;
  speiben_V = irregV "speiben" "speibt" "spieb" "spiebe" "gespieben" ;
  speichern_V2 = dirV2 (regV "speichern")  ;
  speien_V = irregV "speien" "speit" "spie" "spiee" "gespien" ;
  speisen_V2 = dirV2 (regV "speisen")  ;
  spekulieren_auf_V2 = prepV2 (regV "spekulieren") (mkPrep "auf" accusative) ;
  spenden_an_V3 = dirV3 (regV "spenden") (mkPrep "an" accusative) ;
  spenden_dat_V3 = accdatV3 (regV "spenden")  ;
  spenden_fuer_V3 = dirV3 (regV "spenden") fuer_Prep ;
  spendieren_dat_V3 = accdatV3 (regV "spendieren")  ;
  spendieren_fuer_V3 = dirV3 (regV "spendieren") fuer_Prep ;
  sperren_V2 = dirV2 (regV "sperren")  ;
  spezialisieren_auf_rV2 = reflV2 (regV "spezialisieren") accusative (mkPrep "auf" accusative) ;
  spezifizieren_V2 = dirV2 (regV "spezifizieren")  ;
  spicken_dir_V2 = prepV2 (regV "spicken") dir_Prep ;
  spicken_mit_V3 = dirV3 (regV "spicken") mit_Prep ;
  spiegeln_V2 = dirV2 (regV "spiegeln")  ;
  spielen_V2 = dirV2 (regV "spielen")  ;
  spielen_VS = mkVS (regV "spielen")  ;
  spiessern_V = regV "spießern" ;
  spinnen_V2 = dirV2 (irregV "spinnen" "spinnt" "spann" "spänne" "gesponnen")  ;
  spinnen_V = irregV "spinnen" "spinnt" "spann" "spänne" "gesponnen" ;
  spionieren_V = regV "spionieren" ;
  spitzeln_V = regV "spitzeln" ;
  spleissen_V2 = dirV2 (regV "spleißen")  ;
  splittern_V = irregV "splittern" "splittert" "splitterte" "splitterte" "gesplittert" ;
  spoetteln_ueber_V2 = prepV2 (regV "spötteln") (mkPrep "über" accusative) ;
  spoetteln_VS = mkVS (regV "spötteln")  ;
  sponsern_V2 = dirV2 (regV "sponsern")  ;
  spornen_V2 = dirV2 (regV "spornen")  ;
  sporteln_V = regV "sporteln" ;
  spotten_ueber_V2 = prepV2 (irregV "spotten" "spottet" "spottete" "spotte" "gespottet") (mkPrep "über" accusative) ;
  spratzeln_V = regV "spratzeln" ;
  spratzen_V = regV "spratzen" ;
  sprechen_ueber_V2 = prepV2 (irregV "sprechen" "spricht" "sprach" "spräche" "gesprochen") (mkPrep "über" accusative) ;
  sprechen_VS = mkVS (irregV "sprechen" "spricht" "sprach" "spräche" "gesprochen")  ;
  spreizen_V2 = dirV2 (regV "spreizen")  ;
  sprengen_V2 = dirV2 (regV "sprengen")  ;
  springen_dir_V2 = prepV2 (irregV "springen" "springt" "sprang" "spränge" "gesprungen") dir_Prep ;
  springen_V = irregV "springen" "springt" "sprang" "spränge" "gesprungen" ;
  sprinten_dir_V2 = prepV2 (regV "sprinten") dir_Prep ;
  spritzen_dat_V3 = accdatV3 (regV "spritzen")  ;
  sprudeln_V = regV "sprudeln" ;
  spruehen_V2 = dirV2 (regV "sprühen")  ;
  spucken_V = regV "spucken" ;
  spuelen_V2 = dirV2 (regV "spülen")  ;
  spueren_V2 = dirV2 (regV "spüren")  ;
  spueren_VS = mkVS (regV "spüren")  ;
  spuken_es_loc_V2 = prepV2 (regV "spuken") loc_Prep ;
  spuken_loc_V2 = prepV2 (regV "spuken") loc_Prep ;
  spuren_V2 = dirV2 (regV "spuren")  ;
  spuren_V = regV "spuren" ;
  spurten_dir_V2 = prepV2 (regV "spurten") dir_Prep ;
  sputen_rV = reflV (regV "sputen") accusative ;
  stabilisieren_V2 = dirV2 (regV "stabilisieren")  ;
  staehlen_V2 = dirV2 (regV "stählen")  ;
  staengeln_V2 = dirV2 (regV "stängeln")  ;
  staenkern_V = regV "stänkern" ;
  staerken_V2 = dirV2 (regV "stärken")  ;
  staffeln_V2 = dirV2 (regV "staffeln")  ;
  staffieren_V2 = dirV2 (irregV "staffieren" "staffiert" "staffierte" "staffierte" "staffiert")  ;
  stagnieren_V = irregV "stagnieren" "stagniert" "stagnierte" "stagnierte" "stagniert" ;
  staken_in_V2 = prepV2 (regV "staken") (mkPrep "in" accusative) ;
  staken_V2 = dirV2 (regV "staken")  ;
  staken_V = regV "staken" ;
  stammeln_V2 = dirV2 (regV "stammeln")  ;
  stammeln_V = regV "stammeln" ;
  stammeln_VS = mkVS (regV "stammeln")  ;
  stammen_von_V2 = prepV2 (regV "stammen") (mkPrep "von" dative) ;
  stampfen_V = regV "stampfen" ;
  standardisieren_V2 = dirV2 (regV "standardisieren")  ;
  standhalten_dat_V2 = mkV2 (prefixV "stand" (irregV "halten" "hält" "hielt" "hielt" "gehalten")) datPrep ;
  stanzen_V2 = dirV2 (regV "stanzen")  ;
  stapeln_V2 = dirV2 (regV "stapeln")  ;
  stapfen_dir_V2 = prepV2 (regV "stapfen") dir_Prep ;
  starren_dir_V2 = prepV2 (regV "starren") dir_Prep ;
  starten_V2 = dirV2 (regV "starten")  ;
  starten_V = regV "starten" ;
  stationieren_loc_V3 = dirV3 (regV "stationieren") loc_Prep ;
  stattfinden_sV = dassV (prefixV "statt" (irregV "finden" "findet" "fand" "fände" "gefunden"))  ;
  stattfinden_V = prefixV "statt" (irregV "finden" "findet" "fand" "fände" "gefunden") ;
  stattgeben_dat_V2 = mkV2 (prefixV "statt" (irregV "geben" "gibt" "gab" "gab" "gegeben")) datPrep ;
  statuieren_V2 = dirV2 (regV "statuieren")  ;
  stauben_V = regV "stauben" ;
  staubsaugen_V = regV "staubsaugen" ;
  stauen_rV = reflV (regV "stauen") accusative ;
  staunen_ueber_V2 = prepV2 (regV "staunen") (mkPrep "über" accusative) ;
  stechen_V2 = dirV2 (irregV "stechen" "stecht" "stach" "stäche" "gestochen")  ;
  stecken_in_V3 = dirV3 (irregV "stecken" "steckt" "steckte" "stecke" "gesteckt") (mkPrep "in" accusative) ;
  stehen_loc_V2 = prepV2 (irregV "stehen" "steht" "stand" "stände" "gestanden") loc_Prep ;
  stehlen_dat_V3 = accdatV3 (irregV "stehlen" "stehlt" "stahl" "stähle" "gestohlen")  ;
  steigen_auf_V2 = prepV2 (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen") (mkPrep "auf" accusative) ;
  steigen_V = irregV "steigen" "steigt" "stieg" "stiege" "gestiegen" ;
  steigern_V2 = dirV2 (regV "steigern")  ;
  steinigen_V2 = dirV2 (regV "steinigen")  ;
  stellen_dir_V3 = dirV3 (regV "stellen") dir_Prep ;
  stelzen_V = irregV "stelzen" "stelzt" "stelzte" "stelzte" "gestelzt" ;
  stemmen_V2 = dirV2 (regV "stemmen")  ;
  stempeln_V2 = dirV2 (irregV "stempeln" "stempelt" "stempelte" "stempele" "gestempelt")  ;
  stenographieren_V2 = dirV2 (regV "stenographieren")  ;
  stenographieren_VS = mkVS (regV "stenographieren")  ;
  stenotypieren_V2 = dirV2 (regV "stenotypieren")  ;
  stenotypieren_VS = mkVS (regV "stenotypieren")  ;
  sterben_V = irregV "sterben" "sterbt" "starb" "stürbe" "gestorben" ;
  stereotypieren_V2 = dirV2 (regV "stereotypieren")  ;
  sterilisieren_V2 = dirV2 (regV "sterilisieren")  ;
  sternen_V2 = dirV2 (regV "sternen")  ;
  steuern_V2 = dirV2 (irregV "steuern" "steuert" "steuerte" "steuere" "gesteuert")  ;
  stibitzen_dat_V3 = accdatV3 (regV "stibitzen")  ;
  sticken_V2 = dirV2 (regV "sticken")  ;
  stieben_V = irregV "stieben" "stiebt" "stob" "stöbe" "gestoben" ;
  stiefeln_dir_V2 = prepV2 (regV "stiefeln") dir_Prep ;
  stieren_V = regV "stieren" ;
  stierln_nach_V2 = prepV2 (regV "stierln") nach_Prep ;
  stifteln_V2 = dirV2 (regV "stifteln")  ;
  stiften_dat_V3 = accdatV3 (regV "stiften")  ;
  stiften_V2 = dirV2 (regV "stiften")  ;
  stigmatisieren_sV2 = dassV2 (regV "stigmatisieren") accPrep ;
  stigmatisieren_V2 = dirV2 (regV "stigmatisieren")  ;
  stilisieren_als_V3 = dirV3 (regV "stilisieren") (mkPrep "als" accusative) ;
  stilisieren_V2 = dirV2 (regV "stilisieren")  ;
  stilisieren_zu_V3 = dirV3 (regV "stilisieren") zu_Prep ;
  stillen_V2 = dirV2 (regV "stillen")  ;
  stillstehen_V = prefixV "still" (irregV "stehen" "steht" "stand" "stand" "gestanden") ;
  stimmen_fuer_V2 = prepV2 (regV "stimmen") fuer_Prep ;
  stimmen_gegen_V2 = prepV2 (regV "stimmen") gegen_Prep ;
  stimmen_V2 = dirV2 (regV "stimmen")  ;
  stimulieren_V2 = dirV2 (irregV "stimulieren" "stimuliert" "stimulierte" "stimulierte" "stimuliert")  ;
  stinken_dat_sV2 = dassV2 (irregV "stinken" "stinkt" "stank" "stänke" "gestunken") datPrep ;
  stinken_dat_V2 = mkV2 (irregV "stinken" "stinkt" "stank" "stänke" "gestunken") datPrep ;
  stippen_in_V3 = dirV3 (regV "stippen") (mkPrep "in" accusative) ;
  stippen_V2 = dirV2 (regV "stippen")  ;
  stipulieren_VS = mkVS (regV "stipulieren")  ;
  stochen_V2 = dirV2 (regV "stochen")  ;
  stochern_im_V2 = prepV2 (regV "stochern") (mkPrep "in" dative) ;
  stocken_V = regV "stocken" ;
  stoebern_loc_V2 = prepV2 (regV "stöbern") loc_Prep ;
  stoeckeln_dir_V2 = prepV2 (regV "stöckeln") dir_Prep ;
  stoehnen_ueber_V2 = prepV2 (regV "stöhnen") (mkPrep "über" accusative) ;
  stoehnen_V2 = dirV2 (regV "stöhnen")  ;
  stoehnen_VS = mkVS (regV "stöhnen")  ;
  stoeren_V2 = dirV2 (regV "stören")  ;
  stolpern_V = regV "stolpern" ;
  stolzieren_dir_V2 = prepV2 (regV "stolzieren") dir_Prep ;
  stopfen_dir_V3 = dirV3 (regV "stopfen") dir_Prep ;
  stopfen_V2 = dirV2 (regV "stopfen")  ;
  stoppen_V2 = dirV2 (regV "stoppen")  ;
  stoppen_V = regV "stoppen" ;
  stornieren_V2 = dirV2 (regV "stornieren")  ;
  stossen_an_V2 = prepV2 (irregV "stoßen" "stoßt" "stieß" "stieße" "gestoßen") (mkPrep "an" accusative) ;
  stossen_V2 = dirV2 (irregV "stoßen" "stoßt" "stieß" "stieße" "gestoßen")  ;
  stottern_V2 = dirV2 (regV "stottern")  ;
  stottern_VS = mkVS (regV "stottern")  ;
  straehnen_V2 = dirV2 (regV "strähnen")  ;
  straeuben_dat_rV2 = reflV2 (regV "sträuben") accusative datPrep ;
  straeuben_gegen_rV2 = reflV2 (regV "sträuben") accusative gegen_Prep ;
  strafen_mit_V3 = dirV3 (regV "strafen") mit_Prep ;
  straffen_V2 = dirV2 (regV "straffen")  ;
  strammstehen_V = prefixV "stramm" (irregV "stehen" "steht" "stand" "stand" "gestanden") ;
  strampeln_dir_V2 = prepV2 (regV "strampeln") dir_Prep ;
  stranden_loc_V2 = prepV2 (regV "stranden") loc_Prep ;
  strangulieren_V2 = dirV2 (regV "strangulieren")  ;
  strapazieren_V2 = dirV2 (regV "strapazieren")  ;
  stratifizieren_V2 = dirV2 (regV "stratifizieren")  ;
  straucheln_V = regV "straucheln" ;
  strawanzen_V = regV "strawanzen" ;
  streben_nach_V2 = prepV2 (regV "streben") nach_Prep ;
  strebern_V = regV "strebern" ;
  strecken_V2 = dirV2 (regV "strecken")  ;
  streicheln_V2 = dirV2 (regV "streicheln")  ;
  streichen_V2 = dirV2 (irregV "streichen" "streicht" "strich" "striche" "gestrichen")  ;
  streifen_V2 = dirV2 (regV "streifen")  ;
  streiken_V = regV "streiken" ;
  streiten_mit_ueber_rV3 = reflV3 (irregV "streiten" "streitet" "stritt" "stritte" "gestritten") accusative mit_Prep (mkPrep "über" accusative) ;
  streiten_mit_ueber_V3 = mkV3 (irregV "streiten" "streitet" "stritt" "stritte" "gestritten") mit_Prep (mkPrep "über" accusative) ;
  streiten_mit_um_rV3 = reflV3 (irregV "streiten" "streitet" "stritt" "stritte" "gestritten") accusative mit_Prep um_Prep ;
  streiten_mit_um_V3 = mkV3 (irregV "streiten" "streitet" "stritt" "stritte" "gestritten") mit_Prep um_Prep ;
  streiten_ueber_rV2 = reflV2 (irregV "streiten" "streitet" "stritt" "stritte" "gestritten") accusative (mkPrep "über" accusative) ;
  streiten_ueber_V2 = prepV2 (irregV "streiten" "streitet" "stritt" "stritte" "gestritten") (mkPrep "über" accusative) ;
  streiten_um_rV2 = reflV2 (irregV "streiten" "streitet" "stritt" "stritte" "gestritten") accusative um_Prep ;
  streiten_um_V2 = prepV2 (irregV "streiten" "streitet" "stritt" "stritte" "gestritten") um_Prep ;
  stressen_sV2 = dassV2 (regV "stressen") accPrep ;
  stressen_V2 = dirV2 (regV "stressen")  ;
  streuen_dir_V3 = dirV3 (regV "streuen") dir_Prep ;
  streunen_um_V2 = prepV2 (regV "streunen") um_Prep ;
  stricken_V2 = dirV2 (regV "stricken")  ;
  striegeln_V2 = dirV2 (regV "striegeln")  ;
  striezen_V2 = dirV2 (regV "striezen")  ;
  strippen_V = regV "strippen" ;
  stroemen_dir_V2 = prepV2 (regV "strömen") dir_Prep ;
  strolchen_dir_V2 = prepV2 (regV "strolchen") dir_Prep ;
  stromern_dir_V2 = prepV2 (regV "stromern") dir_Prep ;
  studieren_V2 = dirV2 (regV "studieren")  ;
  studieren_VQ = mkVQ (regV "studieren")  ;
  stuempern_V = regV "stümpern" ;
  stuermen_dir_V2 = prepV2 (regV "stürmen") dir_Prep ;
  stuermen_V2 = dirV2 (regV "stürmen")  ;
  stuerzen_dir_V2 = prepV2 (regV "stürzen") dir_Prep ;
  stuerzen_V2 = dirV2 (regV "stürzen")  ;
  stuetzen_auf_rV2 = reflV2 (regV "stützen") accusative (mkPrep "auf" accusative) ;
  stuetzen_V2 = dirV2 (regV "stützen")  ;
  stufen_V2 = dirV2 (regV "stufen")  ;
  stumpfen_V2 = dirV2 (regV "stumpfen")  ;
  stunden_dat_V3 = accdatV3 (regV "stunden")  ;
  stupsen_V2 = dirV2 (regV "stupsen")  ;
  stutzen_ueber_V2 = prepV2 (regV "stutzen") (mkPrep "über" accusative) ;
  stutzen_V2 = dirV2 (regV "stutzen")  ;
  stylen_V2 = dirV2 (regV "stylen")  ;
  subjektivieren_V2 = dirV2 (regV "subjektivieren")  ;
  sublimieren_V2 = dirV2 (irregV "sublimieren" "sublimiert" "sublimierte" "sublimierte" "sublimiert")  ;
  subministrieren_dat_V2 = mkV2 (regV "subministrieren") datPrep ;
  submittieren_um_rV2 = reflV2 (irregV "submittieren" "submittiert" "submittierte" "submittierte" "submittiert") accusative um_Prep ;
  subrogieren_an_V3 = dirV3 (irregV "subrogieren" "subrogiert" "subrogierte" "subrogierte" "subrogiert") (mkPrep "an" accusative) ;
  subskribieren_V2 = dirV2 (regV "subskribieren")  ;
  substantivieren_V2 = dirV2 (regV "substantivieren")  ;
  substanziieren_V2 = dirV2 (regV "substanziieren")  ;
  substituieren_durch_V3 = dirV3 (regV "substituieren") durch_Prep ;
  subsumieren_unter_V3 = dirV3 (regV "subsumieren") (mkPrep "unter" accusative) ;
  subtrahieren_von_V3 = dirV3 (regV "subtrahieren") von_Prep ;
  subventionieren_V2 = dirV2 (regV "subventionieren")  ;
  suchen_V2 = dirV2 (regV "suchen")  ;
  suckeln_am_V2 = prepV2 (regV "suckeln") (mkPrep "an" dative) ;
  sueffeln_V2 = dirV2 (regV "süffeln")  ;
  suehnen_fuer_V2 = prepV2 (regV "sühnen") fuer_Prep ;
  suehnen_V2 = dirV2 (regV "sühnen")  ;
  suelzen_V2 = dirV2 (regV "sülzen")  ;
  suelzen_VS = mkVS (regV "sülzen")  ;
  suendigen_V = regV "sündigen" ;
  suessen_V2 = dirV2 (regV "süßen")  ;
  suffigieren_V2 = dirV2 (regV "suffigieren")  ;
  suggeln_V2 = dirV2 (regV "suggeln")  ;
  suggerieren_dat_V2S = mkV2S (regV "suggerieren") datPrep ;
  suggerieren_dat_V3 = accdatV3 (regV "suggerieren")  ;
  suhlen_im_rV2 = reflV2 (regV "suhlen") accusative (mkPrep "in" dative) ;
  summen_V2 = dirV2 (regV "summen")  ;
  summen_VS = mkVS (regV "summen")  ;
  summieren_V2 = dirV2 (regV "summieren")  ;
  summieren_zu_rV2 = reflV2 (regV "summieren") accusative zu_Prep ;
  sumpfen_V = regV "sumpfen" ;
  supponieren_V2 = dirV2 (regV "supponieren")  ;
  supponieren_VS = mkVS (regV "supponieren")  ;
  supprimieren_V0 = mkV0 (regV "supprimieren")  ;
  surfen_dir_V2 = prepV2 (regV "surfen") dir_Prep ;
  suspendieren_von_V3 = dirV3 (regV "suspendieren") von_Prep ;
  syllabieren_V2 = dirV2 (regV "syllabieren")  ;
  symbolisieren_mit_V3 = dirV3 (regV "symbolisieren") mit_Prep ;
  sympathisieren_mit_V2 = prepV2 (regV "sympathisieren") mit_Prep ;
  synchronisieren_mit_V3 = dirV3 (regV "synchronisieren") mit_Prep ;
  synchronisieren_V2 = dirV2 (regV "synchronisieren")  ;
  synthetisieren_V2 = dirV2 (regV "synthetisieren")  ;
  systematisieren_V2 = dirV2 (regV "systematisieren")  ;
  tabellarisieren_V2 = dirV2 (regV "tabellarisieren")  ;
  tabellieren_V2 = dirV2 (regV "tabellieren")  ;
  tablettieren_V2 = dirV2 (regV "tablettieren")  ;
  tabuieren_V2 = dirV2 (regV "tabuieren")  ;
  tabuieren_VS = mkVS (regV "tabuieren")  ;
  tabuisieren_V2 = dirV2 (regV "tabuisieren")  ;
  tabuisieren_VS = mkVS (regV "tabuisieren")  ;
  tackern_V2 = dirV2 (regV "tackern")  ;
  tadeln_V2 = dirV2 (regV "tadeln")  ;
  tadeln_VS = mkVS (regV "tadeln")  ;
  taefeln_V2 = dirV2 (regV "täfeln")  ;
  taefern_V2 = dirV2 (regV "täfern")  ;
  taenzeln_dir_V2 = prepV2 (regV "tänzeln") dir_Prep ;
  taenzeln_V = regV "tänzeln" ;
  taetigen_V2 = dirV2 (regV "tätigen")  ;
  taetowieren_V2 = dirV2 (regV "tätowieren")  ;
  taetscheln_V2 = dirV2 (regV "tätscheln")  ;
  taeuschen_im_rV2 = reflV2 (regV "täuschen") accusative (mkPrep "in" dative) ;
  tafeln_V = regV "tafeln" ;
  tagen_es_esV = esV (regV "tagen")  ;
  tagen_plV = plV (regV "tagen")  ;
  tagen_V = regV "tagen" ;
  taillieren_V2 = dirV2 (regV "taillieren")  ;
  takeln_V2 = dirV2 (regV "takeln")  ;
  taktieren_V = regV "taktieren" ;
  talgen_V2 = dirV2 (regV "talgen")  ;
  talkumieren_V2 = dirV2 (regV "talkumieren")  ;
  tamponieren_V2 = dirV2 (regV "tamponieren")  ;
  tangieren_sV2 = dassV2 (regV "tangieren") accPrep ;
  tangieren_V2 = dirV2 (regV "tangieren")  ;
  tanken_V2 = dirV2 (regV "tanken")  ;
  tanzen_mit_V2 = prepV2 (regV "tanzen") mit_Prep ;
  tanzen_V = regV "tanzen" ;
  tapezieren_V2 = dirV2 (regV "tapezieren")  ;
  tarnen_V2 = dirV2 (regV "tarnen")  ;
  tasten_nach_V2 = prepV2 (regV "tasten") nach_Prep ;
  tatschen_dir_V2 = prepV2 (regV "tatschen") dir_Prep ;
  tattern_V = regV "tattern" ;
  tauchen_loc_V2 = prepV2 (regV "tauchen") loc_Prep ;
  tauchen_V = regV "tauchen" ;
  taufen_V2 = dirV2 (regV "taufen")  ;
  taugen_zu_V2 = prepV2 (regV "taugen") zu_Prep ;
  taumeln_dir_V2 = prepV2 (regV "taumeln") dir_Prep ;
  taumeln_V = regV "taumeln" ;
  tauschen_fuer_V3 = dirV3 (regV "tauschen") fuer_Prep ;
  tauschen_gegen_V3 = dirV3 (regV "tauschen") gegen_Prep ;
  taxieren_V2 = dirV2 (regV "taxieren")  ;
  technifizieren_V2 = dirV2 (regV "technifizieren")  ;
  technisieren_V2 = dirV2 (regV "technisieren")  ;
  technologisieren_V2 = dirV2 (regV "technologisieren")  ;
  teeren_V2 = dirV2 (irregV "teeren" "teert" "teerte" "teerte" "geteert")  ;
  teilen_V2 = dirV2 (irregV "teilen" "teilt" "teilte" "teile" "geteilt")  ;
  teilnehmen_am_V2 = prepV2 (prefixV "teil" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen")) (mkPrep "an" dative) ;
  telefonieren_mit_V2 = prepV2 (regV "telefonieren") mit_Prep ;
  telefonieren_nach_V2 = prepV2 (regV "telefonieren") nach_Prep ;
  telegrafieren_nach_V2S = mkV2S (regV "telegrafieren") nach_Prep ;
  telegrafieren_nach_V3 = mkV3 (regV "telegrafieren") nach_Prep accPrep ;
  telegraphieren_nach_V2S = mkV2S (regV "telegraphieren") nach_Prep ;
  telegraphieren_nach_V3 = mkV3 (regV "telegraphieren") nach_Prep accPrep ;
  telephonieren_mit_V2 = prepV2 (regV "telephonieren") mit_Prep ;
  telephonieren_nach_V2 = prepV2 (regV "telephonieren") nach_Prep ;
  teleportieren_dir_V3 = dirV3 (regV "teleportieren") dir_Prep ;
  telexen_nach_V2S = mkV2S (regV "telexen") nach_Prep ;
  telexen_nach_V3 = mkV3 (regV "telexen") nach_Prep accPrep ;
  tendieren_zu_V2 = prepV2 (regV "tendieren") zu_Prep ;
  terminieren_V2 = dirV2 (regV "terminieren")  ;
  terrassieren_V2 = dirV2 (regV "terrassieren")  ;
  territorialisieren_V2 = dirV2 (regV "territorialisieren")  ;
  terrorisieren_V2 = dirV2 (regV "terrorisieren")  ;
  testen_V2 = dirV2 (regV "testen")  ;
  testen_VQ = mkVQ (regV "testen")  ;
  testieren_dat_V2S = mkV2S (regV "testieren") datPrep ;
  teuern_V2 = dirV2 (regV "teuern")  ;
  teufen_V2 = dirV2 (regV "teufen")  ;
  texten_V2 = dirV2 (regV "texten")  ;
  texten_VS = mkVS (regV "texten")  ;
  thematisieren_V2 = dirV2 (regV "thematisieren")  ;
  thematisieren_VS = mkVS (regV "thematisieren")  ;
  therapieren_V2 = dirV2 (regV "therapieren")  ;
  thesaurieren_V2 = dirV2 (regV "thesaurieren")  ;
  thronen_loc_V2 = prepV2 (regV "thronen") loc_Prep ;
  ticken_VA = mkVA (regV "ticken")  ;
  tigern_dir_V2 = prepV2 (regV "tigern") dir_Prep ;
  tilgen_V2 = dirV2 (regV "tilgen")  ;
  timbrieren_V2 = dirV2 (regV "timbrieren")  ;
  timen_V2 = dirV2 (regV "timen")  ;
  tingeln_dir_V2 = prepV2 (regV "tingeln") dir_Prep ;
  tingieren_V2A = mkV2A (regV "tingieren") accPrep ;
  tingieren_V2 = dirV2 (regV "tingieren")  ;
  tippeln_dir_V2 = prepV2 (regV "tippeln") dir_Prep ;
  tippen_auf_V2 = prepV2 (regV "tippen") (mkPrep "auf" accusative) ;
  tippen_V2 = dirV2 (regV "tippen")  ;
  tippen_V = regV "tippen" ;
  tirilieren_V = regV "tirilieren" ;
  tischlern_V2 = dirV2 (regV "tischlern")  ;
  titrieren_V2 = dirV2 (regV "titrieren")  ;
  titulieren_als_V3 = dirV3 (regV "titulieren") (mkPrep "als" accusative) ;
  toasten_V2 = dirV2 (regV "toasten")  ;
  toben_dir_V2 = prepV2 (regV "toben") dir_Prep ;
  toben_V = regV "toben" ;
  toelpeln_V = regV "tölpeln" ;
  toelten_V = regV "tölten" ;
  toenen_V2 = dirV2 (regV "tönen")  ;
  toenen_VS = mkVS (regV "tönen")  ;
  toepfern_V2 = dirV2 (regV "töpfern")  ;
  toerggelen_V = regV "törggelen" ;
  toeten_V2 = dirV2 (irregV "töten" "tötet" "tötete" "töte" "getötet")  ;
  tolerieren_V2 = dirV2 (regV "tolerieren")  ;
  tolerieren_VS = mkVS (regV "tolerieren")  ;
  tollen_dir_V2 = prepV2 (regV "tollen") dir_Prep ;
  tonsurieren_V2 = dirV2 (regV "tonsurieren")  ;
  torkeln_V = regV "torkeln" ;
  torpedieren_V2 = dirV2 (regV "torpedieren")  ;
  totschweigen_V2 = dirV2 (prefixV "tot" (irregV "schweigen" "schweigt" "schwieg" "schwieg" "geschwiegen"))  ;
  tottrampeln_V2 = dirV2 (prefixV "tot" (regV "trampeln"))  ;
  touchieren_V2 = dirV2 (regV "touchieren")  ;
  toupieren_V2 = dirV2 (regV "toupieren")  ;
  touren_dir_V2 = prepV2 (regV "touren") dir_Prep ;
  traben_V = regV "traben" ;
  tracheotomieren_V2 = dirV2 (regV "tracheotomieren")  ;
  trachten_nach_V2 = prepV2 (regV "trachten") nach_Prep ;
  tracken_V2 = dirV2 (regV "tracken")  ;
  tradieren_V2 = dirV2 (regV "tradieren")  ;
  tradieren_VS = mkVS (regV "tradieren")  ;
  traellern_V2 = dirV2 (regV "trällern")  ;
  traellern_VS = mkVS (regV "trällern")  ;
  traenken_V2 = dirV2 (regV "tränken")  ;
  traeufeln_dir_V3 = dirV3 (regV "träufeln") dir_Prep ;
  traeufen_dir_V3 = dirV3 (regV "träufen") dir_Prep ;
  traeumen_es_dat_von_V3 = mkV3 (regV "träumen") datPrep von_Prep ;
  traeumen_V2 = dirV2 (regV "träumen")  ;
  traeumen_von_V2 = prepV2 (regV "träumen") von_Prep ;
  traeumen_VS = mkVS (regV "träumen")  ;
  tragen_V2 = dirV2 (irregV "tragen" "tragt" "trug" "trüge" "getragen")  ;
  trainieren_V2 = dirV2 (regV "trainieren")  ;
  traktandieren_V2 = dirV2 (regV "traktandieren")  ;
  traktieren_mit_V3 = dirV3 (regV "traktieren") mit_Prep ;
  trampen_dir_V2 = prepV2 (regV "trampen") dir_Prep ;
  tranchieren_V2 = dirV2 (regV "tranchieren")  ;
  transaktivieren_V0 = mkV0 (regV "transaktivieren")  ;
  transduzieren_V0 = mkV0 (regV "transduzieren")  ;
  transfektieren_V0 = mkV0 (regV "transfektieren")  ;
  transferieren_dir_V3 = dirV3 (regV "transferieren") dir_Prep ;
  transfizieren_V0 = mkV0 (regV "transfizieren")  ;
  transformieren_V2 = dirV2 (regV "transformieren")  ;
  transkribieren_V2 = dirV2 (regV "transkribieren")  ;
  transpirieren_V = regV "transpirieren" ;
  transplantieren_V2 = dirV2 (regV "transplantieren")  ;
  transponieren_dir_V3 = dirV3 (regV "transponieren") dir_Prep ;
  transportieren_V2 = dirV2 (regV "transportieren")  ;
  transzendieren_V2 = dirV2 (regV "transzendieren")  ;
  trassieren_V2 = dirV2 (regV "trassieren")  ;
  tratschen_V2 = dirV2 (regV "tratschen")  ;
  tratschen_VS = mkVS (regV "tratschen")  ;
  trauen_dat_V2 = mkV2 (regV "trauen") datPrep ;
  trauen_V2 = dirV2 (regV "trauen")  ;
  trauern_ueber_V2 = prepV2 (regV "trauern") (mkPrep "über" accusative) ;
  trauern_um_V2 = prepV2 (regV "trauern") um_Prep ;
  traumatisieren_V2 = dirV2 (regV "traumatisieren")  ;
  traversieren_V2 = dirV2 (regV "traversieren")  ;
  treffen_mit_rV2 = reflV2 (irregV "treffen" "trifft" "traf" "träfe" "getroffen") accusative mit_Prep ;
  treffen_V2 = dirV2 (irregV "treffen" "trifft" "traf" "träfe" "getroffen")  ;
  treiben_dir_V3 = dirV3 (irregV "treiben" "treibt" "trieb" "triebe" "getrieben") dir_Prep ;
  treiben_V = irregV "treiben" "treibt" "trieb" "triebe" "getrieben" ;
  treideln_dir_V3 = dirV3 (regV "treideln") dir_Prep ;
  tremolieren_V = regV "tremolieren" ;
  trennen_V2 = dirV2 (regV "trennen")  ;
  trennen_von_rV2 = reflV2 (regV "trennen") accusative von_Prep ;
  trennen_von_V3 = dirV3 (regV "trennen") von_Prep ;
  trenzen_V = regV "trenzen" ;
  trepanieren_V2 = dirV2 (regV "trepanieren")  ;
  treten_nach_V2 = prepV2 (irregV "treten" "tritt" "trat" "träte" "getreten") (mkPrep "nach" dative) ;
  treten_V2 = dirV2 (irregV "treten" "tritt" "trat" "träte" "getreten")  ;
  triagieren_V2 = dirV2 (regV "triagieren")  ;
  triangulieren_V2 = dirV2 (regV "triangulieren")  ;
  tricksen_V = regV "tricksen" ;
  triefen_V = irregV "triefen" "trieft" "troff" "tröffe" "getroffen" ;
  trielen_V = regV "trielen" ;
  triezen_V2 = dirV2 (regV "triezen")  ;
  triggern_V2 = dirV2 (regV "triggern")  ;
  trimmen_V2 = dirV2 (regV "trimmen")  ;
  trinken_V2 = dirV2 (irregV "trinken" "trinkt" "trank" "tränke" "getrunken")  ;
  trinken_V = irregV "trinken" "trinkt" "trank" "tränke" "getrunken" ;
  trippeln_dir_V2 = prepV2 (regV "trippeln") dir_Prep ;
  trischakeln_V2 = dirV2 (regV "trischakeln")  ;
  triumphieren_ueber_V2 = prepV2 (regV "triumphieren") (mkPrep "über" accusative) ;
  triumphieren_V = regV "triumphieren" ;
  trivialisieren_V2 = dirV2 (regV "trivialisieren")  ;
  trocknen_V2 = dirV2 (regV "trocknen")  ;
  trocknen_V = regV "trocknen" ;
  troedeln_V = regV "trödeln" ;
  troepfeln_V = regV "tröpfeln" ;
  troesten_sV2 = dassV2 (regV "trösten") accPrep ;
  troesten_V2 = dirV2 (regV "trösten")  ;
  troeten_V = regV "tröten" ;
  trommeln_fuer_V2 = prepV2 (regV "trommeln") fuer_Prep ;
  trompeten_V2 = dirV2 (regV "trompeten")  ;
  trompeten_V = regV "trompeten" ;
  trompeten_VS = mkVS (regV "trompeten")  ;
  tropfen_dir_V3 = dirV3 (regV "tropfen") dir_Prep ;
  trotteln_V = regV "trotteln" ;
  trotten_dir_V2 = prepV2 (regV "trotten") dir_Prep ;
  trotzen_dat_V2 = mkV2 (regV "trotzen") datPrep ;
  trueben_V2 = dirV2 (regV "trüben")  ;
  trueffeln_V2 = dirV2 (regV "trüffeln")  ;
  truegen_sV2 = dassV2 (irregV "trügen" "trügt" "trog" "tröge" "getrogen") accPrep ;
  truegen_V2 = dirV2 (irregV "trügen" "trügt" "trog" "tröge" "getrogen")  ;
  trutzen_dat_V2 = mkV2 (regV "trutzen") datPrep ;
  tschalpen_V = regV "tschalpen" ;
  tschechern_V2 = dirV2 (regV "tschechern")  ;
  tschechern_V = regV "tschechern" ;
  tschechisieren_V2 = dirV2 (regV "tschechisieren")  ;
  tschilpen_V = regV "tschilpen" ;
  tuchen_V0 = mkV0 (regV "tuchen")  ;
  tueddeln_V = regV "tüddeln" ;
  tuenchen_V2 = dirV2 (regV "tünchen")  ;
  tuepfeln_V2 = dirV2 (regV "tüpfeln")  ;
  tuerken_V2 = dirV2 (regV "türken")  ;
  tuerkisieren_V2 = dirV2 (regV "türkisieren")  ;
  tuermen_aus_V2 = prepV2 (regV "türmen") aus_Prep ;
  tummeln_im_rV2 = reflV2 (regV "tummeln") accusative (mkPrep "in" dative) ;
  tunen_V2 = dirV2 (regV "tunen")  ;
  tunken_in_V3 = dirV3 (regV "tunken") (mkPrep "in" accusative) ;
  tun_V2 = dirV2 (irregV "tun" "tut" "tat" "täte" "getan")  ;
  tupfen_V2 = dirV2 (regV "tupfen")  ;
  turnen_dir_V2 = prepV2 (regV "turnen") dir_Prep ;
  turnen_V2 = dirV2 (regV "turnen")  ;
  turteln_mit_V2 = prepV2 (regV "turteln") mit_Prep ;
  tuscheln_mit_ueber_V3 = mkV3 (regV "tuscheln") mit_Prep (mkPrep "über" accusative) ;
  tuscheln_ueber_V2 = prepV2 (regV "tuscheln") (mkPrep "über" accusative) ;
  twisten_V = regV "twisten" ;
  twittern_mit_V2 = prepV2 (irregV "twittern" "twittert" "twitterte" "twitterte" "getwittert") mit_Prep ;
  typisieren_V2 = dirV2 (regV "typisieren")  ;
  tyrannisieren_V2 = dirV2 (regV "tyrannisieren")  ;
  ueben_am_V3 = dirV3 (regV "üben") (mkPrep "an" dative) ;
  ueben_im_rV2 = reflV2 (regV "üben") accusative (mkPrep "in" dative) ;
  ueberanstrengen_rV = reflV (irregV "überanstrengen" "überanstrengt" "überanstrengte" "überanstrengte" "überanstrengt") accusative ;
  ueberantworten_dat_V3 = accdatV3 (irregV "überantworten" "überantwortet" "überantwortete" "überantworte" "überantwortet")  ;
  ueberarbeiten_V2 = dirV2 (irregV "überarbeiten" "überarbeitet" "überarbeitete" "überarbeitete" "überarbeitet")  ;
  ueberbacken_V2 = dirV2 (irregV "überbacken" "überbackt" "überbackte" "überbackte" "überbacken")  ;
  ueberblicken_V2 = dirV2 (irregV "überblicken" "überblickt" "überblickte" "überblickte" "überblickt")  ;
  ueberbruecken_V2 = dirV2 (irregV "überbrücken" "überbrückt" "überbrückte" "überbrückte" "überbrückt")  ;
  ueberdecken_V2 = dirV2 (irregV "überdecken" "überdeckt" "überdeckte" "überdeckte" "überdeckt")  ;
  ueberdenken_V2 = dirV2 (irregV "überdenken" "überdenkt" "überdachte" "überdächte" "überdacht")  ;
  uebereinstimmen_mit_im_V3 = mkV3 (prefixV "überein" (regV "stimmen")) mit_Prep (mkPrep "in" dative) ;
  uebereinstimmen_mit_V2 = prepV2 (prefixV "überein" (regV "stimmen")) mit_Prep ;
  ueberexprimieren_V = irregV "überexprimieren" "überexprimiert" "überexprimierte" "überexprimierte" "überexprimiert" ;
  ueberfallen_V2 = dirV2 (irregV "überfallen" "überfallt" "überfiel" "überfiele" "überfallen")  ;
  ueberfeinern_V2 = dirV2 (irregV "überfeinern" "überfeinert" "überfeinerte" "überfeinerte" "überfeinert")  ;
  ueberfliegen_V2 = dirV2 (irregV "überfliegen" "überfliegt" "überflog" "überflögee" "überflogen")  ;
  ueberfordern_V2 = dirV2 (irregV "überfordern" "überfordert" "überforderte" "überforderte" "überfordert")  ;
  ueberfuehren_gen_V3 = mkV3 (irregV "überführen" "überführt" "überführte" "überführte" "überführt") genPrep accPrep ;
  uebergeben_dat_V3 = accdatV3 (irregV "übergeben" "übergebt" "übergab" "übergäbe" "übergeben")  ;
  uebergeben_rV = reflV (irregV "übergeben" "übergebt" "übergab" "übergäbe" "übergeben") accusative ;
  uebergehen_V2 = dirV2 (irregV "übergehen" "übergeht" "überging" "überginge" "übergegangen")  ;
  uebergehen_VS = mkVS (irregV "übergehen" "übergeht" "überging" "überginge" "übergegangen")  ;
  ueberholen_V2 = dirV2 (irregV "überholen" "überholt" "überholte" "überholte" "überholt")  ;
  ueberkommen_dat_V3 = accdatV3 (irregV "überkommen" "überkommt" "überkam" "überkäme" "überkommen")  ;
  ueberkommen_V2 = dirV2 (irregV "überkommen" "überkommt" "überkam" "überkäme" "überkommen")  ;
  ueberlappen_rcV = reciV (irregV "überlappen" "überlappt" "überlappte" "überlappte" "überlappt") accusative ;
  ueberlassen_dat_V2V = mkV2V (irregV "überlassen" "überlasst" "überließ" "überließe" "übergelassen") datPrep ;
  ueberlassen_dat_V3 = accdatV3 (irregV "überlassen" "überlasst" "überließ" "überließe" "übergelassen")  ;
  ueberlaufen_zu_V2 = prepV2 (prefixV "über" (irregV "laufen" "läuft" "lief" "lief" "gelaufen")) zu_Prep ;
  ueberleben_V2 = dirV2 (irregV "überleben" "überlebt" "überlebte" "überlebte" "überlebt")  ;
  ueberlegen_V2 = dirV2 (irregV "überlegen" "überlegt" "überlegte" "überlegte" "überlegt")  ;
  ueberlegen_VQ = mkVQ (irregV "überlegen" "überlegt" "überlegte" "überlegte" "überlegt")  ;
  ueberlisten_V2 = dirV2 (irregV "überlisten" "überlistet" "überlistete" "überlistete" "überlistet")  ;
  uebernachten_loc_V2 = prepV2 (irregV "übernachten" "übernachtet" "übernachtete" "übernachtete" "übernachtet") loc_Prep ;
  uebernehmen_rV = reflV (irregV "übernehmen" "übernimmt" "übernahm" "übernähme" "übernommen") accusative ;
  uebernehmen_von_V3 = dirV3 (irregV "übernehmen" "übernimmt" "übernahm" "übernähme" "übernommen") von_Prep ;
  ueberproduzieren_V2 = dirV2 (irregV "überproduzieren" "überproduziert" "überproduzierte" "überproduzierte" "überproduziert")  ;
  ueberpruefen_V2 = dirV2 (irregV "überprüfen" "überprüft" "überprüfte" "überprüfte" "überprüft")  ;
  ueberqueren_V2 = dirV2 (irregV "überqueren" "überquert" "überquerte" "überquerte" "überquert")  ;
  ueberragen_V2 = dirV2 (irregV "überragen" "überragt" "überragte" "überragte" "überragt")  ;
  ueberraschen_bei_V3 = dirV3 (irregV "überraschen" "überrascht" "überraschte" "überraschte" "überrascht") bei_Prep ;
  ueberraschen_sV2 = dassV2 (irregV "überraschen" "überrascht" "überraschte" "überraschte" "überrascht") accPrep ;
  ueberraschen_V2 = dirV2 (irregV "überraschen" "überrascht" "überraschte" "überraschte" "überrascht")  ;
  ueberreden_zu_V3 = dirV3 (irregV "überreden" "überredet" "überredete" "überredete" "überredet") zu_Prep ;
  ueberreichen_dat_V3 = accdatV3 (irregV "überreichen" "überreicht" "überreichte" "überreichte" "überreicht")  ;
  ueberrunden_V2 = dirV2 (irregV "überrunden" "überrundet" "überrundete" "überrundete" "überrundet")  ;
  ueberschaetzen_V2 = dirV2 (irregV "überschätzen" "überschätzt" "überschätzte" "überschätzte" "überschätzt")  ;
  uebersehen_V2 = dirV2 (irregV "übersehen" "überseht" "übersah" "übersähe" "übersehen")  ;
  uebersehen_VS = mkVS (irregV "übersehen" "überseht" "übersah" "übersähe" "übersehen")  ;
  uebersetzen_ueber_V2 = prepV2 (irregV "übersetzen" "übersetzt" "übersetzte" "übersetzte" "übersetzt") (mkPrep "über" accusative) ;
  uebersetzen_V2 = dirV2 (irregV "übersetzen" "übersetzt" "übersetzte" "übersetzte" "übersetzt")  ;
  uebersiedeln_dir_V2 = prepV2 (prefixV "über" (irregV "siedeln" "siedelt" "siede" "siedele" "siedelt")) dir_Prep ;
  ueberspannen_V2 = dirV2 (irregV "überspannen" "überspannt" "überspannte" "überspannte" "überspannt")  ;
  uebersteigen_V2 = dirV2 (irregV "übersteigen" "übersteigt" "überstieg" "überstiege" "überstiegen")  ;
  ueberstuerzen_V2 = dirV2 (irregV "überstürzen" "überstürzt" "überstürzte" "überstürzte" "überstürzt")  ;
  uebertragen_V2 = dirV2 (irregV "übertragen" "übertragt" "übertrug" "übertrüge" "übertragen")  ;
  uebertreiben_V2 = dirV2 (irregV "übertreiben" "übertreibt" "übertrieb" "übertriebe" "übertrieben")  ;
  uebertrumpfen_V2 = dirV2 (irregV "übertrumpfen" "übertrumpft" "übertrumpfte" "übertrumpfte" "übertrumpft")  ;
  uebervorteilen_V2 = dirV2 (irregV "übervorteilen" "übervorteilt" "übervorteilte" "übervorteilte" "übervorteilt")  ;
  ueberwachen_V2 = dirV2 (irregV "überwachen" "überwacht" "überwachte" "überwachte" "überwacht")  ;
  ueberwaeltigen_sV2 = dassV2 (irregV "überwältigen" "überwältigt" "überwältigte" "überwältigte" "überwältigt") accPrep ;
  ueberwaeltigen_V2 = dirV2 (irregV "überwältigen" "überwältigt" "überwältigte" "überwältigte" "überwältigt")  ;
  ueberwallen_V = prefixV "über" (regV "wallen") ;
  ueberweisen_dat_V3 = accdatV3 (irregV "überweisen" "überweist" "überwies" "überwiese" "überwiesen")  ;
  ueberwiegen_sV = dassV (irregV "überwiegen" "überwiegt" "überwog" "überwöge" "überwogen")  ;
  ueberwinden_V2 = dirV2 (irregV "überwinden" "überwindet" "überwand" "überwände" "überwunden")  ;
  ueberzeugen_V2 = dirV2 (irregV "überzeugen" "überzeugt" "überzeugte" "überzeugte" "überzeugt")  ;
  ueberziehen_2_V2 = dirV2 (irregV "überziehen" "überzieht" "überzog" "überzöge" "überzogen")  ;
  ueberziehen_dat_V3 = accdatV3 (prefixV "über" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen"))  ;
  uelmen_V = regV "ülmen" ;
  ulken_VS = mkVS (regV "ulken")  ;
  ultrafiltrieren_V0 = mkV0 (regV "ultrafiltrieren")  ;
  umarmen_V2 = dirV2 (regV "umarmen")  ;
  umbenennen_V2 = dirV2 (prefixV "um" (irregV "benennen" "benennt" "benannte" "benannte" "benannt"))  ;
  umbestellen_V2 = dirV2 (prefixV "um" (irregV "bestellen" "bestellt" "bestell" "bestelle" "bestellt"))  ;
  umbinden_dat_V3 = accdatV3 (prefixV "um" (irregV "binden" "bindet" "band" "bände" "gebunden"))  ;
  umbrechen_V2 = dirV2 (prefixV "um" (irregV "brechen" "bricht" "brach" "bräche" "brochen"))  ;
  umbringen_V2 = dirV2 (prefixV "um" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  umdrehen_V2 = dirV2 (prefixV "um" (regV "drehen"))  ;
  umerziehen_V2 = dirV2 (prefixV "um" (irregV "erziehen" "erzieht" "erzog" "erzöge" "erzogen"))  ;
  umfahren2_V = prefixV "um" (irregV "fahren" "fährt" "fuhr" "führe" "gefahren") ;
  umfahren_V2 = dirV2 (irregV "umfahren" "umfährt" "umfuhr" "umführe" "umfahren")  ;
  umfallen_V = prefixV "um" (irregV "fallen" "fallt" "fiel" "fiele" "gefallen") ;
  umfangen_V2 = dirV2 (irregV "umfangen" "umfangt" "umfing" "umfinge" "umfangen")  ;
  umfassen_V2 = dirV2 (regV "umfassen")  ;
  umfliegen_V2 = dirV2 (irregV "umfliegen" "umfliegt" "umflog" "umflögee" "umflogen")  ;
  umfriedigen_V2 = dirV2 (irregV "umfriedigen" "umfriedigt" "umfriedigte" "umfriedigte" "umfriedigt")  ;
  umfunktionieren_zu_V3 = dirV3 (prefixV "um" (regV "funktionieren")) zu_Prep ;
  umgarnen_V2 = dirV2 (regV "umgarnen")  ;
  umgeben_mit_V3 = dirV3 (irregV "umgeben" "umgebt" "umgab" "umgäbe" "umgeben") mit_Prep ;
  umgehen_V2 = dirV2 (irregV "umgehen" "umgeht" "umging" "umging" "umgangen")  ;
  umgestalten_V2 = dirV2 (prefixV "um" (irregV "gestalten" "gestaltet" "gestaltete" "gestaltete" "gestaltet"))  ;
  umhinkoennen_VV = mkVV (prefixV "umhin" (irregV "können" "kann" "konnte" "konnte" "gekonnt"))  ;
  umhuellen_V2 = dirV2 (prefixV "um" (regV "hüllen"))  ;
  umkehren_V2 = dirV2 (prefixV "um" (regV "kehren"))  ;
  umkehren_V = prefixV "um" (regV "kehren") ;
  umkippen_V = prefixV "um" (regV "kippen") ;
  umkommen_bei_V2 = prepV2 (prefixV "um" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) bei_Prep ;
  umkommen_V = prefixV "um" (irregV "kommen" "kommt" "kam" "käme" "gekommen") ;
  umlaufen_V = prefixV "um" (irregV "laufen" "lauft" "lief" "liefe" "gelaufen") ;
  umlegen_V2 = dirV2 (prefixV "um" (regV "legen"))  ;
  ummanteln_V2 = dirV2 (irregV "ummanteln" "ummantelt" "ummantelte" "ummantelte" "ummantelt")  ;
  umplanken_V2 = dirV2 (irregV "umplanken" "umplankt" "umplankte" "umplankte" "umplankt")  ;
  umpolen_V2 = dirV2 (prefixV "um" (regV "polen"))  ;
  umrandeln_V2 = dirV2 (irregV "umrandeln" "umrandelt" "umrandelte" "umrandelte" "umrandelt")  ;
  umranden_V2 = dirV2 (irregV "umranden" "umrandet" "umrandete" "umrandete" "umrandet")  ;
  umrechnen_in_V3 = dirV3 (prefixV "um" (regV "rechnen")) (mkPrep "in" accusative) ;
  umreissen_V2 = dirV2 (prefixV "um" (irregV "reißen" "reißt" "riss" "risse" "gerissen"))  ;
  umreiten_V2 = dirV2 (irregV "umreiten" "umreitet" "umritt" "umritte" "umritten")  ;
  umsargen_V2 = dirV2 (prefixV "um" (regV "sargen"))  ;
  umschliessen_V2 = dirV2 (irregV "umschließen" "umschließt" "umschloss" "umschlösse" "umschlossen")  ;
  umschreiben_V2 = dirV2 (irregV "umschreiben" "umschreibt" "umschrieb" "umschriebe" "umschrieben")  ;
  umsehen_nach_rV2 = reflV2 (prefixV "um" (irregV "sehen" "sieht" "sah" "sah" "gesehen")) accusative (mkPrep "nach" dative) ;
  umsehen_rV = reflV (prefixV "um" (irregV "sehen" "sieht" "sah" "sah" "gesehen")) accusative ;
  umsetzen_rV = reflV (prefixV "um" (regV "setzen")) accusative ;
  umsetzen_V2 = dirV2 (prefixV "um" (regV "setzen"))  ;
  umsorgen_V2 = dirV2 (irregV "umsorgen" "umsorgt" "umsorgte" "umsorgte" "umsorgt")  ;
  umspannen_V2 = dirV2 (irregV "umspannen" "umspannt" "umspannte" "umspannte" "umspannt")  ;
  umsteigen_loc_V2 = prepV2 (prefixV "um" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen")) loc_Prep ;
  umstellen_2_V = prefixV "um" (regV "stellen") ;
  umstellen_V2 = dirV2 (irregV "umstellen" "umstellt" "umstellte" "umstellte" "umstellt")  ;
  umtakeln_V2 = dirV2 (prefixV "um" (regV "takeln"))  ;
  umwandeln_zu_V3 = dirV3 (irregV "umwandeln" "umwandelt" "umwandelte" "umwandelte" "umwandelt") zu_Prep ;
  umwanden_V2 = dirV2 (irregV "umwanden" "umwandet" "umwandete" "umwandete" "umwandet")  ;
  umwandern_V = irregV "umwandern" "umwandert" "umwanderte" "umwanderte" "umwandert" ;
  umwerfen_V2 = dirV2 (prefixV "um" (irregV "werfen" "wirft" "warf" "warf" "geworfen"))  ;
  umwittern_V2 = dirV2 (irregV "umwittern" "umwittert" "umwitterte" "umwitterte" "umwittert")  ;
  umziehen_nach_V2 = prepV2 (prefixV "um" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen")) nach_Prep ;
  umzingeln_V2 = dirV2 (irregV "umzingeln" "umzingelt" "umzingelte" "umzingelte" "umzingelt")  ;
  unieren_V2 = dirV2 (regV "unieren")  ;
  unifizieren_mit_V3 = dirV3 (regV "unifizieren") mit_Prep ;
  unifizieren_V2 = dirV2 (regV "unifizieren")  ;
  uniformieren_V2 = dirV2 (regV "uniformieren")  ;
  uniformisieren_V2 = dirV2 (regV "uniformisieren")  ;
  unken_VS = mkVS (regV "unken")  ;
  unterbinden_V2 = dirV2 (irregV "unterbinden" "unterbindet" "unterband" "unterbände" "unterbunden")  ;
  unterbrechen_V2 = dirV2 (irregV "unterbrechen" "unterbrecht" "unterbrach" "unterbräche" "unterbrochen")  ;
  unterdruecken_V2 = dirV2 (irregV "unterdrücken" "unterdrückt" "unterdrückte" "unterdrückte" "unterdrückt")  ;
  unterfertigen_V2 = dirV2 (irregV "unterfertigen" "unterfertigt" "unterfertigte" "unterfertigte" "unterfertigt")  ;
  untergehen_V = prefixV "unter" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  unterhalten_mit_rV2 = reflV2 (irregV "unterhalten" "unterhält" "unterhielt" "unterhielte" "unterhalten") accusative mit_Prep ;
  unterhalten_V2 = dirV2 (irregV "unterhalten" "unterhält" "unterhielt" "unterhielte" "unterhalten")  ;
  unterlassen_V2 = dirV2 (irregV "unterlassen" "unterlasst" "unterließ" "unterließe" "unterlassen")  ;
  unterlassen_VV = mkVV (irregV "unterlassen" "unterlasst" "unterließ" "unterließe" "unterlassen")  ;
  unterliegen_dat_V2 = mkV2 (prefixV "unter" (irregV "liegen" "liegt" "lag" "läge" "gelegen")) datPrep ;
  unterminieren_V2 = dirV2 (irregV "unterminieren" "unterminiert" "unterminierte" "unterminiere" "unterminiert")  ;
  unternehmen_V2 = dirV2 (irregV "unternehmen" "unternimmt" "unternahm" "unternähme" "unternommen")  ;
  unternehmen_VV = mkVV (irregV "unternehmen" "unternimmt" "unternahm" "unternähme" "unternommen")  ;
  unterpfluegen_V2 = dirV2 (prefixV "unter" (regV "pflügen"))  ;
  unterpunkten_V2 = dirV2 (irregV "unterpunkten" "unterpunktet" "unterpunktete" "unterpunktete" "unterpunktet")  ;
  unterpunkten_V = irregV "unterpunkten" "unterpunktet" "unterpunktete" "unterpunktete" "unterpunktet" ;
  unterrichten_V2 = dirV2 (irregV "unterrichten" "unterrichtet" "unterrichtete" "unterrichte" "unterrichtet")  ;
  untersagen_dat_V2V = mkV2V (irregV "untersagen" "untersagt" "untersagte" "untersagte" "untersagt") datPrep ;
  unterschaetzen_V2 = dirV2 (irregV "unterschätzen" "unterschätzt" "unterschätzte" "unterschätzte" "unterschätzt")  ;
  unterscheiden_von_V3 = dirV3 (irregV "unterscheiden" "unterscheidet" "unterschied" "unterschiede" "unterschieden") (mkPrep "von" dative) ;
  unterschreiben_V2 = dirV2 (irregV "unterschreiben" "unterschreibt" "unterschrieb" "unterschriebe" "unterschrieben")  ;
  unterschreiten_V2 = dirV2 (irregV "unterschreiten" "unterschreitet" "unterschritt" "unterschritt" "unterschritten")  ;
  unterstehen_dat_V2 = mkV2 (irregV "unterstehen" "steht" "stand" "stände" "gestanden") datPrep ;
  unterstehen_rVV = reflVV (irregV "unterstehen" "steht" "stand" "stände" "gestanden") accusative ;
  unterstellen_bei_rV2 = reflV2 (irregV "unterstellen" "unterstellt" "unterstellte" "unterstellte" "unterstellt") accusative bei_Prep ;
  unterstreichen_V2 = dirV2 (irregV "unterstreichen" "unterstreicht" "unterstrich" "unterstrich" "unterstrichen")  ;
  unterstreichen_VS = mkVS (irregV "unterstreichen" "unterstreicht" "unterstrich" "unterstrich" "unterstrichen")  ;
  unterstuetzen_V2 = dirV2 (irregV "unterstützen" "unterstützt" "unterstützte" "unterstütze" "unterstützt")  ;
  unterstuetzen_VS = mkVS (irregV "unterstützen" "unterstützt" "unterstützte" "unterstütze" "unterstützt")  ;
  untersuchen_V2 = dirV2 (irregV "untersuchen" "untersucht" "untersuchte" "untersuchte" "untersucht")  ;
  untersuchen_VQ = mkVQ (irregV "untersuchen" "untersucht" "untersuchte" "untersuchte" "untersucht")  ;
  unterteilen_V2 = dirV2 (irregV "unterteilen" "unterteilt" "unterteilte" "unterteile" "unterteilt")  ;
  unterteufen_unter_V2 = prepV2 (irregV "unterteufen" "unterteuft" "unterteufte" "unterteufte" "unterteuft") (mkPrep "unter" accusative) ;
  unterteufen_V2 = dirV2 (irregV "unterteufen" "unterteuft" "unterteufte" "unterteufte" "unterteuft")  ;
  untertreiben_V = irregV "untertreiben" "untertreibt" "untertrieb" "untertriebe" "untertrieben" ;
  untertunneln_V2 = dirV2 (irregV "untertunneln" "untertunnelt" "untertunnelte" "untertunnelte" "untertunnelt")  ;
  unterweisen_im_V3 = dirV3 (irregV "unterweisen" "unterweist" "unterwies" "unterwiese" "unterwiesen") (mkPrep "in" dative) ;
  unterzeichnen_V2 = dirV2 (irregV "unterzeichnen" "unterzeichnet" "unterzeichnete" "unterzeichnete" "unterzeichnet")  ;
  unterziehen_gen_V3 = dirV3 (prefixV "unter" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen")) genPrep ;
  updaten_V2 = dirV2 (regV "updaten")  ;
  upgraden_auf_V3 = dirV3 (prefixV "up" (regV "graden")) (mkPrep "auf" accusative) ;
  uploaden_V2 = dirV2 (regV "uploaden")  ;
  urauffuehren_V2 = dirV2 (regV "uraufführen")  ;
  urbanisieren_V2 = dirV2 (regV "urbanisieren")  ;
  urbarisieren_V2 = dirV2 (regV "urbarisieren")  ;
  urgieren_V2 = dirV2 (regV "urgieren")  ;
  urgieren_V = regV "urgieren" ;
  urinieren_V = regV "urinieren" ;
  urlauben_V = regV "urlauben" ;
  urteilen_V2 = dirV2 (regV "urteilen")  ;
  urteilen_VS = mkVS (regV "urteilen")  ;
  usurpieren_V2 = dirV2 (regV "usurpieren")  ;
  uzen_V2 = dirV2 (regV "uzen")  ;
  vagabundieren_dir_V2 = prepV2 (regV "vagabundieren") dir_Prep ;
  vagieren_V = regV "vagieren" ;
  validieren_V2 = dirV2 (regV "validieren")  ;
  validieren_VS = mkVS (regV "validieren")  ;
  vaporisieren_V2 = dirV2 (regV "vaporisieren")  ;
  variieren_V2 = dirV2 (regV "variieren")  ;
  vazieren_V = regV "vazieren" ;
  vegetieren_V = regV "vegetieren" ;
  verabreden_mit_rV2 = reflV2 (irregV "verabreden" "verabredet" "verabredete" "verabredete" "verabredet") accusative mit_Prep ;
  verabreichen_dat_V3 = dirV3 (irregV "verabreichen" "verabreicht" "verabreichte" "verabreichte" "verabreicht") datPrep ;
  verabscheuen_V2 = dirV2 (irregV "verabscheuen" "verabscheut" "verabscheute" "verabscheute" "verabscheut")  ;
  verabschieden_V2 = dirV2 (irregV "verabschieden" "verabschiedet" "verabschiedete" "verabschiedete" "verabschiedet")  ;
  verabschieden_von_rV2 = reflV2 (irregV "verabschieden" "verabschiedet" "verabschiedete" "verabschiedete" "verabschiedet") accusative von_Prep ;
  verabschieden_von_V3 = dirV3 (irregV "verabschieden" "verabschiedet" "verabschiedete" "verabschiedete" "verabschiedet") von_Prep ;
  verabsolutieren_V2 = dirV2 (regV "verabsolutieren")  ;
  veraendern_V2 = dirV2 (irregV "verändern" "verändert" "veränderte" "veränderte" "verändert")  ;
  veraeppeln_V2 = dirV2 (irregV "veräppeln" "veräppelt" "veräppelte" "veräppelte" "veräppelt")  ;
  veraeussern_V2 = dirV2 (irregV "veräußern" "veräußert" "veräußerte" "veräußerte" "veräußert")  ;
  verallgemeinern_V2 = dirV2 (irregV "verallgemeinern" "verallgemeinert" "verallgemeinerte" "verallgemeinerte" "verallgemeinert")  ;
  verallgemeinern_VS = mkVS (irregV "verallgemeinern" "verallgemeinert" "verallgemeinerte" "verallgemeinerte" "verallgemeinert")  ;
  veralten_sV = dassV (irregV "veralten" "veraltet" "veraltete" "veralte" "veraltet")  ;
  veralten_V = irregV "veralten" "veraltet" "veraltete" "veralte" "veraltet" ;
  verankern_V2 = dirV2 (irregV "verankern" "verankert" "verankerte" "verankerte" "verankert")  ;
  veranlagen_zu_V3 = dirV3 (irregV "veranlagen" "veranlagt" "veranlagte" "veranlagte" "veranlagt") zu_Prep ;
  veranlassen_V2 = dirV2 (irregV "veranlassen" "veranlasst" "veranlasste" "veranlasste" "veranlasst")  ;
  veranlassen_VS = mkVS (irregV "veranlassen" "veranlasst" "veranlasste" "veranlasste" "veranlasst")  ;
  veranschaulichen_V2 = dirV2 (irregV "veranschaulichen" "veranschaulicht" "veranschaulichte" "veranschaulichte" "veranschaulicht")  ;
  veranschaulichen_VS = mkVS (irregV "veranschaulichen" "veranschaulicht" "veranschaulichte" "veranschaulichte" "veranschaulicht")  ;
  veranschlagen_auf_V3 = dirV3 (irregV "veranschlagen" "veranschlagt" "veranschlagte" "veranschlagte" "veranschlagt") (mkPrep "auf" accusative) ;
  veranschlagen_fuer_V3 = dirV3 (irregV "veranschlagen" "veranschlagt" "veranschlagte" "veranschlagte" "veranschlagt") fuer_Prep ;
  veranstalten_V2 = dirV2 (irregV "veranstalten" "veranstaltet" "veranstaltete" "veranstaltete" "veranstaltet")  ;
  verarbeiten_zu_V3 = dirV3 (irregV "verarbeiten" "verarbeitet" "verarbeitete" "verarbeite" "verarbeitet") zu_Prep ;
  verargen_dat_V2S = mkV2S (irregV "verargen" "verargt" "verargte" "verargte" "verargt") datPrep ;
  verargen_dat_V3 = accdatV3 (irregV "verargen" "verargt" "verargte" "verargte" "verargt")  ;
  verarmen_V = irregV "verarmen" "verarmt" "verarmte" "verarmte" "verarmt" ;
  verarschen_V2 = dirV2 (irregV "verarschen" "verarscht" "verarschte" "verarschte" "verarscht")  ;
  verarzten_V2 = dirV2 (irregV "verarzten" "verarztet" "verarztete" "verarztete" "verarzt")  ;
  verausgaben_rV = reflV (irregV "verausgaben" "verausgabt" "verausgabte" "verausgabte" "verausgabt") accusative ;
  verausgaben_V2 = dirV2 (irregV "verausgaben" "verausgabt" "verausgabte" "verausgabte" "verausgabt")  ;
  verbalisieren_V2 = dirV2 (irregV "verbalisieren" "verbalisiert" "verbalisierte" "verbalisierte" "verbalisiert")  ;
  verballhornen_V2 = dirV2 (irregV "verballhornen" "verballhornt" "verballhornte" "verballhornte" "verballhornt")  ;
  verbannen_dir_V3 = dirV3 (irregV "verbannen" "verbannt" "verbannte" "verbannte" "verbannt") dir_Prep ;
  verbannen_V2 = dirV2 (irregV "verbannen" "verbannt" "verbannte" "verbannte" "verbannt")  ;
  verbarrikadieren_V2 = dirV2 (irregV "verbarrikadieren" "verbarrikadiert" "verbarrikadierte" "verbarrikadierte" "verbarrikadiert")  ;
  verbeamten_V2 = dirV2 (irregV "verbeamten" "verbeamtet" "verbeamtete" "verbeamtete" "verbeamtet")  ;
  verbergen_V2 = dirV2 (irregV "verbergen" "verbergt" "verbarg" "verbärge" "verborgen")  ;
  verbessern_V2 = dirV2 (irregV "verbessern" "verbessert" "verbesserte" "verbesserte" "verbessert")  ;
  verbieten_dat_V2V = mkV2V (irregV "verbieten" "verbietet" "verbot" "verböte" "verboten") datPrep ;
  verbieten_dat_V3 = accdatV3 (irregV "verbieten" "verbietet" "verbot" "verböte" "verboten")  ;
  verbinden_dat_V3 = accdatV3 (irregV "verbinden" "verbindet" "verband" "verbände" "verbunden")  ;
  verbinden_mit_V3 = dirV3 (irregV "verbinden" "verbindet" "verband" "verbände" "verbunden") mit_Prep ;
  verbitten_rV2 = reflV2 (irregV "verbitten" "verbittet" "verbat" "verbat" "verbeten") dative accPrep ;
  verbitten_rVS = reflVS (irregV "verbitten" "verbittet" "verbat" "verbat" "verbeten") dative ;
  verbitten_rVV = reflVV (irregV "verbitten" "verbittet" "verbat" "verbat" "verbeten") dative ;
  verbittern_sV2 = dassV2 (irregV "verbittern" "verbittert" "verbitterte" "verbitterte" "verbittert") accPrep ;
  verbittern_V2 = dirV2 (irregV "verbittern" "verbittert" "verbitterte" "verbitterte" "verbittert")  ;
  verbittern_V = irregV "verbittern" "verbittert" "verbitterte" "verbitterte" "verbittert" ;
  verblaeuen_V2 = dirV2 (irregV "verbläuen" "verbläut" "verbläute" "verbläute" "verbläut")  ;
  verbleiben_loc_V2 = prepV2 (irregV "verbleiben" "verbleibt" "verblieb" "verbliebe" "verblieben") loc_Prep ;
  verbleichen_V = irregV "verbleichen" "verbleicht" "verblich" "verblich" "verblichen" ;
  verblenden_V = irregV "verblenden" "verblendet" "verblendete" "verblendete" "verblendet" ;
  verbloeden_V = irregV "verblöden" "verblödet" "verblödete" "verblödete" "verblödet" ;
  verbluten_V = irregV "verbluten" "verblutet" "verblutete" "verblutete" "verblutet" ;
  verbraemen_V2 = dirV2 (irregV "verbrämen" "verbrämt" "verbrämte" "verbrämte" "verbrämt")  ;
  verbraemen_VS = mkVS (irregV "verbrämen" "verbrämt" "verbrämte" "verbrämte" "verbrämt")  ;
  verbrauchen_V2 = dirV2 (irregV "verbrauchen" "verbraucht" "verbrauchte" "verbrauchte" "verbraucht")  ;
  verbrechen_V2 = dirV2 (irregV "verbrechen" "verbrecht" "verbrach" "verbräche" "verbrochen")  ;
  verbreiten_V2 = dirV2 (irregV "verbreiten" "verbreitet" "verbreitete" "verbreitete" "verbreitet")  ;
  verbreiten_VS = mkVS (irregV "verbreiten" "verbreitet" "verbreitete" "verbreitete" "verbreitet")  ;
  verbrennen_V2 = dirV2 (irregV "verbrennen" "verbrennt" "verbrannte" "verbrennte" "verbrannt")  ;
  verbringen_loc_V3 = dirV3 (irregV "verbringen" "verbringt" "verbrachte" "verbrächte" "verbracht") loc_Prep ;
  verbruedern_mit_rV2 = reflV2 (irregV "verbrüdern" "verbrüdert" "verbrüderte" "verbrüderte" "verbrüdert") accusative mit_Prep ;
  verbruedern_rV = reflV (irregV "verbrüdern" "verbrüdert" "verbrüderte" "verbrüderte" "verbrüdert") accusative ;
  verbuddeln_V2 = dirV2 (irregV "verbuddeln" "verbuddelt" "verbuddelte" "verbuddelte" "verbuddelt")  ;
  verbuenden_gegen_rV2 = reflV2 (irregV "verbünden" "verbündet" "verbündete" "verbündete" "verbündet") accusative gegen_Prep ;
  verbuenden_mit_gegen_rV3 = reflV3 (irregV "verbünden" "verbündet" "verbündete" "verbündete" "verbündet") accusative mit_Prep gegen_Prep ;
  verbuergerlichen_V = irregV "verbürgerlichen" "verbürgerlicht" "verbürgerlichte" "verbürgerlichte" "verbürgerlicht" ;
  verchristlichen_V = irregV "verchristlichen" "verchristlicht" "verchristlichte" "verchristlichte" "verchristlicht" ;
  verdaechtigen_gen_V3 = dirV3 (irregV "verdächtigen" "verdächtigt" "verdächtigte" "verdächtigte" "verdächtigt") genPrep ;
  verdaechtigen_V2S = dirV2S (irregV "verdächtigen" "verdächtigt" "verdächtigte" "verdächtigte" "verdächtigt")  ;
  verdammen_V2 = dirV2 (irregV "verdammen" "verdammt" "verdammte" "verdammte" "verdammt")  ;
  verdammen_zu_V3 = dirV3 (irregV "verdammen" "verdammt" "verdammte" "verdammte" "verdammt") zu_Prep ;
  verdampfen_V = irregV "verdampfen" "verdampft" "verdampfte" "verdampfte" "verdampft" ;
  verdanken_dat_V2S = mkV2S (irregV "verdanken" "verdankt" "verdankte" "verdankte" "verdankt") datPrep ;
  verdanken_dat_V3 = accdatV3 (irregV "verdanken" "verdankt" "verdankte" "verdankte" "verdankt")  ;
  verdauen_V2 = dirV2 (irregV "verdauen" "verdaut" "verdaute" "verdaute" "verdaut")  ;
  verdenken_dat_V2S = mkV2S (irregV "verdenken" "verdenkt" "verdachte" "verdächte" "verdacht") datPrep ;
  verderben_dat_V3 = accdatV3 (irregV "verderben" "verderbt" "verdarb" "verdürbe" "verdorben")  ;
  verderben_V = irregV "verderben" "verderbt" "verdarb" "verdürbe" "verdorben" ;
  verdeutlichen_dat_V2S = mkV2S (irregV "verdeutlichen" "verdeutlicht" "verdeutlichte" "verdeutlichte" "verdeutlicht") datPrep ;
  verdeutlichen_dat_V3 = accdatV3 (irregV "verdeutlichen" "verdeutlicht" "verdeutlichte" "verdeutlichte" "verdeutlicht")  ;
  verdichten_rV = reflV (irregV "verdichten" "verdichtet" "verdichtete" "verdichtete" "verdichtet") accusative ;
  verdichten_V2 = dirV2 (irregV "verdichten" "verdichtet" "verdichtete" "verdichtete" "verdichtet")  ;
  verdicken_V2 = dirV2 (irregV "verdicken" "verdickt" "verdickte" "verdickte" "verdickt")  ;
  verdienen_rV2 = reflV2 (irregV "verdienen" "verdient" "verdiente" "verdiente" "verdient") dative accPrep ;
  verdienen_V2 = dirV2 (irregV "verdienen" "verdient" "verdiente" "verdiente" "verdient")  ;
  verdienen_VS = mkVS (irregV "verdienen" "verdient" "verdiente" "verdiente" "verdient")  ;
  verdingen_V2 = dirV2 (irregV "verdingen" "verdingt" "verdingte" "verdingte" "verdingt")  ;
  verdingen_V2V = dirV2V (irregV "verdingen" "verdingt" "verdingte" "verdingte" "verdingt")  ;
  verdoppeln_V2 = dirV2 (irregV "verdoppeln" "verdoppelt" "verdoppelte" "verdoppelte" "verdoppelt")  ;
  verdraengen_V2 = dirV2 (irregV "verdrängen" "verdrängt" "verdrängte" "verdrängte" "verdrängt")  ;
  verdreschen_V2 = dirV2 (irregV "verdreschen" "verdrescht" "verdrosch" "verdrösche" "verdroschen")  ;
  verdriessen_sV2 = dassV2 (irregV "verdrießen" "verdrießt" "verdross" "verdrösse" "verdrossen") accPrep ;
  verdriessen_V2 = dirV2 (irregV "verdrießen" "verdrießt" "verdross" "verdrösse" "verdrossen")  ;
  verdruecken_rV = reflV (irregV "verdrücken" "verdrückt" "verdrückte" "verdrückte" "verdrückt") accusative ;
  verdruecken_V2 = dirV2 (irregV "verdrücken" "verdrückt" "verdrückte" "verdrückte" "verdrückt")  ;
  verduennen_V2 = dirV2 (irregV "verdünnen" "verdünnt" "verdünnte" "verdünnte" "verdünnt")  ;
  verduennisieren_rV = reflV (irregV "verdünnisieren" "verdünnisiert" "verdünnisierte" "verdünnisierte" "verdünnisiert") accusative ;
  verduften_rV = reflV (irregV "verduften" "verduftet" "verduftete" "verduftete" "verduftet") accusative ;
  verduften_V2 = dirV2 (irregV "verduften" "verduftet" "verduftete" "verduftete" "verduftet")  ;
  verdummen_sV2 = dassV2 (irregV "verdummen" "verdummt" "verdummte" "verdummte" "verdummt") accPrep ;
  verdummen_V2 = dirV2 (irregV "verdummen" "verdummt" "verdummte" "verdummte" "verdummt")  ;
  verdummen_V = irregV "verdummen" "verdummt" "verdummte" "verdummte" "verdummt" ;
  verdumpfen_V2 = dirV2 (irregV "verdumpfen" "verdumpft" "verdumpfte" "verdumpfte" "verdumpft")  ;
  verdumpfen_V = irregV "verdumpfen" "verdumpft" "verdumpfte" "verdumpfte" "verdumpft" ;
  verdutzen_V2 = dirV2 (irregV "verdutzen" "verdutzt" "verdutzte" "verdutzte" "verdutzt")  ;
  verebben_V = irregV "verebben" "verebbt" "verebbte" "verebbte" "verebbt" ;
  veredeln_V2 = dirV2 (irregV "veredeln" "veredelt" "veredelte" "veredelte" "veredelt")  ;
  verehren_V2 = dirV2 (irregV "verehren" "verehrt" "verehrte" "verehrte" "verehrt")  ;
  vereiden_V2 = dirV2 (irregV "vereiden" "vereidet" "vereidete" "vereidete" "vereidet")  ;
  vereidigen_V2 = dirV2 (irregV "vereidigen" "vereidigt" "vereidigte" "vereidigte" "vereidigt")  ;
  vereinbaren_mit_V2S = mkV2S (irregV "vereinbaren" "vereinbart" "vereinbarte" "vereinbarte" "vereinbart") mit_Prep ;
  vereinbaren_mit_V3 = mkV3 (irregV "vereinbaren" "vereinbart" "vereinbarte" "vereinbarte" "vereinbart") mit_Prep accPrep ;
  vereinbaren_plV2 = pldirV2 (irregV "vereinbaren" "vereinbart" "vereinbarte" "vereinbarte" "vereinbart")  ;
  vereinbaren_plVS = plVS (irregV "vereinbaren" "vereinbart" "vereinbarte" "vereinbarte" "vereinbart")  ;
  vereinfachen_V2 = dirV2 (irregV "vereinfachen" "vereinfacht" "vereinfachte" "vereinfachte" "vereinfacht")  ;
  vereinigen_V2 = dirV2 (irregV "vereinigen" "vereinigt" "vereinigte" "vereinigte" "vereinigt")  ;
  vereinnahmen_V2 = dirV2 (irregV "vereinnahmen" "vereinnahmt" "vereinnahmte" "vereinnahmte" "vereinnahmt")  ;
  vereinsamen_V = irregV "vereinsamen" "vereinsamt" "vereinsamte" "vereinsamte" "vereinsamt" ;
  vereinseitigen_V2 = dirV2 (irregV "vereinseitigen" "vereinseitigt" "vereinseitigte" "vereinseitigte" "vereinseitigt")  ;
  vereinzeln_V = irregV "vereinzeln" "vereinzelt" "vereinzelte" "vereinzelte" "vereinzelt" ;
  vereisen_V = irregV "vereisen" "vereist" "vereiste" "vereiste" "vereist" ;
  vereiteln_V2 = dirV2 (irregV "vereiteln" "vereitelt" "vereitelte" "vereitelte" "vereitelt")  ;
  vereitern_V = irregV "vereitern" "vereitert" "vereiterte" "vereiterte" "vereitert" ;
  verenden_V = irregV "verenden" "verendet" "verendete" "verendete" "verendet" ;
  verengen_rV = reflV (irregV "verengen" "verengt" "verengte" "verengte" "verengt") accusative ;
  verengern_V2 = dirV2 (irregV "verengern" "verengert" "verengerte" "verengerte" "verengert")  ;
  verestern_V2 = dirV2 (irregV "verestern" "verestert" "veresterte" "veresterte" "verestert")  ;
  verewigen_loc_V3 = dirV3 (irregV "verewigen" "verewigt" "verewigte" "verewigte" "verewigt") loc_Prep ;
  verfahren_rV = reflV (irregV "verfahren" "verfährt" "verfuhr" "verfuhr" "verfahren") accusative ;
  verfallen_dat_V2 = mkV2 (irregV "verfallen" "verfallt" "verfiel" "verfiele" "verfallen") datPrep ;
  verfangen_im_rV2 = reflV2 (irregV "verfangen" "verfängt" "verfing" "verfing" "verfangen") accusative (mkPrep "in" dative) ;
  verfassen_V2 = dirV2 (irregV "verfassen" "verfasst" "verfasste" "verfasste" "verfasst")  ;
  verfechten_V2 = dirV2 (irregV "verfechten" "verficht" "verfocht" "verfocht" "verfochten")  ;
  verfehlen_V2 = dirV2 (irregV "verfehlen" "verfehlt" "verfehlte" "verfehlte" "verfehlt")  ;
  verfestigen_V2 = dirV2 (irregV "verfestigen" "verfestigt" "verfestigte" "verfestigte" "verfestigt")  ;
  verfilzen_V = irregV "verfilzen" "verfilzt" "verfilzte" "verfilzte" "verfilzt" ;
  verfliegen_V = irregV "verfliegen" "verfliegt" "verflog" "verflog" "verflogen" ;
  verfluchen_V2 = dirV2 (irregV "verfluchen" "verflucht" "verfluchte" "verfluchte" "verflucht")  ;
  verfluessigen_V2 = dirV2 (irregV "verflüssigen" "verflüssigt" "verflüssigte" "verflüssigte" "verflüssigt")  ;
  verfolgen_V2 = dirV2 (irregV "verfolgen" "verfolgt" "verfolgte" "verfolgte" "verfolgt")  ;
  verfranzen_rV = reflV (irregV "verfranzen" "verfranzt" "verfranzte" "verfranzte" "verfranzt") accusative ;
  verfressen_rV = reflV (irregV "verfressen" "verfresst" "verfraß" "verfräße" "verfressen") accusative ;
  verfuegen_ueber_V2 = prepV2 (irregV "verfügen" "verfügt" "verfügte" "verfügte" "verfügt") (mkPrep "über" accusative) ;
  verfuehren_zu_V3 = dirV3 (irregV "verführen" "verführt" "verführte" "verführte" "verführt") zu_Prep ;
  verfumfeien_V2 = dirV2 (irregV "verfumfeien" "verfumfeit" "verfumfeite" "verfumfeite" "verfumfeit")  ;
  vergackeiern_V2 = dirV2 (irregV "vergackeiern" "vergackeiert" "vergackeierte" "vergackeierte" "vergackeiert")  ;
  vergaellen_V2 = dirV2 (irregV "vergällen" "vergällt" "vergällte" "vergällte" "vergällt")  ;
  vergammeln_V = irregV "vergammeln" "vergammelt" "vergammelte" "vergammelte" "vergammelt" ;
  vergasen_V2 = dirV2 (irregV "vergasen" "vergast" "vergaste" "vergaste" "vergast")  ;
  vergattern_zu_V3 = dirV3 (irregV "vergattern" "vergatternt" "vergatterte" "vergatterte" "vergattert") zu_Prep ;
  vergeben_dat_V2S = mkV2S (irregV "vergeben" "vergebt" "vergab" "vergäbe" "vergeben") datPrep ;
  vergegenstaendlichen_V2 = dirV2 (irregV "vergegenständlichen" "vergegenständlicht" "vergegenständlichte" "vergegenständlichte" "vergegenständlicht")  ;
  vergegenwaertigen_dat_V2S = mkV2S (irregV "vergegenwärtigen" "vergegenwärtigt" "vergegenwärtigte" "vergegenwärtigte" "vergegenwärtigt") datPrep ;
  vergegenwaertigen_dat_V3 = accdatV3 (irregV "vergegenwärtigen" "vergegenwärtigt" "vergegenwärtigte" "vergegenwärtigte" "vergegenwärtigt")  ;
  vergehen_V = irregV "vergehen" "vergeht" "verging" "verginge" "vergangen" ;
  vergeigen_V2 = dirV2 (irregV "vergeigen" "vergeigt" "vergeigte" "vergeigte" "vergeigt")  ;
  vergemeinschaften_V2 = dirV2 (irregV "vergemeinschaften" "vergemeinschaften" "vergemeinschaften" "vergemeinschaften" "vergemeinschaften")  ;
  vergenossenschaften_V2 = dirV2 (regV "vergenossenschaften")  ;
  vergenossenschaftlichen_V2 = dirV2 (regV "vergenossenschaftlichen")  ;
  vergesellschaften_V2 = dirV2 (regV "vergesellschaften")  ;
  vergessen_V2 = dirV2 (irregV "vergessen" "vergisst" "vergaß" "vergäße" "vergessen")  ;
  vergessen_VS = mkVS (irregV "vergessen" "vergisst" "vergaß" "vergäße" "vergessen")  ;
  vergeuden_V2 = dirV2 (irregV "vergeuden" "vergeudet" "vergeudete" "vergeudete" "vergeudet")  ;
  vergewaltigen_V2 = dirV2 (irregV "vergewaltigen" "vergewaltigt" "vergewaltigte" "vergewaltigte" "vergewaltigt")  ;
  vergewerkschaften_V2 = dirV2 (irregV "vergewerkschaften" "vergewerkschaftet" "vergewerkschaftete" "vergewerkschaftete""vergewerkschaftet")  ;
  vergewissern_gen_V3 = dirV3 (irregV "vergewissern" "vergewissert" "vergewisserte" "vergewisserte" "vergewissert") genPrep ;
  vergewissern_V2S = dirV2S (irregV "vergewissern" "vergewissert" "vergewisserte" "vergewisserte" "vergewissert")  ;
  vergiessen_V2 = dirV2 (irregV "vergießen" "vergießt" "vergoss" "vergösse" "vergossen")  ;
  vergiften_V2 = dirV2 (irregV "vergiften" "vergiftet" "vergiftete" "vergiftete" "vergiftet")  ;
  vergilben_V = irregV "vergilben" "vergilbt" "vergilbte" "vergilbte" "vergilbt" ;
  vergittern_V2 = dirV2 (irregV "vergittern" "vergittert" "vergitterte" "vergitterte" "vergittert")  ;
  vergleichen_mit_V3 = dirV3 (irregV "vergleichen" "vergleicht" "verglich" "vergliche" "verglichen") mit_Prep ;
  vergnuegen_mit_rV2 = reflV2 (irregV "vergnügen" "vergnügt" "vergnügte" "vergnügte" "vergnügt") accusative mit_Prep ;
  vergnuegen_sV2 = dassV2 (irregV "vergnügen" "vergnügt" "vergnügte" "vergnügte" "vergnügt") accPrep ;
  vergnuegen_V2 = dirV2 (irregV "vergnügen" "vergnügt" "vergnügte" "vergnügte" "vergnügt")  ;
  vergoettern_V2 = dirV2 (irregV "vergöttern" "vergöttert" "vergötterte" "vergötterte" "vergöttert")  ;
  vergoettlichen_V2 = dirV2 (irregV "vergöttlichen" "vergöttlicht" "vergöttlichte" "vergöttlichte" "vergöttlicht")  ;
  vergolden_V2 = dirV2 (irregV "vergolden" "vergoldet" "vergoldete" "vergoldete" "vergoldet")  ;
  vergotten_V2 = dirV2 (irregV "vergotten" "vergottet" "vergottete" "vergottete" "vergottet")  ;
  vergraben_V2 = dirV2 (irregV "vergraben" "vergräbt" "vergrub" "vergrub" "vergraben")  ;
  vergraetzen_sV2 = dassV2 (irregV "vergrätzen" "vergrätzt" "vergrätzte" "vergrätzte" "vergrätzt") accPrep ;
  vergraetzen_V2 = dirV2 (irregV "vergrätzen" "vergrätzt" "vergrätzte" "vergrätzte" "vergrätzt")  ;
  vergraulen_V2 = dirV2 (irregV "vergraulen" "vergrault" "vergraulte" "vergraulte" "vergrault")  ;
  vergreifen_am_rV2 = reflV2 (irregV "vergreifen" "vergreift" "vergriff" "vergriff" "vergriffen") accusative (mkPrep "an" dative) ;
  vergreisen_V = irregV "vergreisen" "vergreist" "vergreiste" "vergreiste" "vergreist" ;
  vergroessern_V2 = dirV2 (irregV "vergrößern" "vergrößert" "vergrößerte" "vergrößerte" "vergrößert")  ;
  verguenstigen_V2 = dirV2 (irregV "vergünstigen" "vergünstigt" "vergünstigte" "vergünstigte" "vergünstiget")  ;
  vergueten_dat_V2S = mkV2S (irregV "vergüten" "vergütet" "vergütete" "vergütete" "vergütet") datPrep ;
  vergueten_dat_V3 = accdatV3 (irregV "vergüten" "vergütet" "vergütete" "vergütete" "vergütet")  ;
  verhackstuecken_V2 = dirV2 (irregV "verhackstücken" "verhackstückt" "verhackstückte" "verhackstückte" "verhackstückt")  ;
  verhaetscheln_V2 = dirV2 (irregV "verhätscheln" "verhätschelt" "verhätschelte" "verhätschelte" "verhätschelt")  ;
  verhaften_V2 = dirV2 (irregV "verhaften" "verhaftet" "verhaftete" "verhaftete" "verhaftet")  ;
  verhageln_dat_V3 = accdatV3 (irregV "verhageln" "verhagelt" "verhagelte" "verhagelte" "verhagelt")  ;
  verhalten_rVA = reflVA (irregV "verhalten" "verhält" "verhielt" "verhielte" "verhalten") accusative ;
  verhandeln_mit_V3 = dirV3 (irregV "verhandeln" "verhandelt" "verhandelte" "verhandelte" "verhandelt") mit_Prep ;
  verharmlosen_V2 = dirV2 (irregV "verharmlosen" "verharmlost" "verharmloste" "verharmloste" "verharmlost")  ;
  verharmlosen_VS = mkVS (irregV "verharmlosen" "verharmlost" "verharmloste" "verharmloste" "verharmlost")  ;
  verharschen_V = irregV "verharschen" "verharscht" "verharschte" "verharschte" "verharscht" ;
  verhaspeln_rV = reflV (irregV "verhaspeln" "verhaspelt" "verhaspelte" "verhaspelte" "verhaspelt") accusative ;
  verheben_rV = reflV (irregV "verheben" "verhebt" "verhob" "verhob" "verhoben") accusative ;
  verhehlen_dat_V2S = mkV2S (irregV "verhehlen" "verhehlt" "verhehlte" "verhehlte" "verhehlt") datPrep ;
  verhehlen_dat_V3 = accdatV3 (irregV "verhehlen" "verhehlt" "verhehlte" "verhehlte" "verhehlt")  ;
  verheimlichen_dat_V2S = mkV2S (irregV "verheimlichen" "verheimlicht" "verheimlichte" "verheimlichte" "verheimlicht") datPrep ;
  verheimlichen_dat_V3 = accdatV3 (irregV "verheimlichen" "verheimlicht" "verheimlichte" "verheimlichte" "verheimlicht")  ;
  verherrlichen_V2 = dirV2 (irregV "verherrlichen" "verherrlicht" "verherrlichte" "verherrlichte" "verherrlicht")  ;
  verherrlichen_VS = mkVS (irregV "verherrlichen" "verherrlicht" "verherrlichte" "verherrlichte" "verherrlicht")  ;
  verhindern_V2 = dirV2 (irregV "verhindern" "verhindert" "verhinderte" "verhinderte" "verhindert")  ;
  verhindern_VS = mkVS (irregV "verhindern" "verhindert" "verhinderte" "verhinderte" "verhindert")  ;
  verhochdeutschen_V2 = dirV2 (irregV "verhochdeutschen" "verhochdeutscht" "verhochdeutschte" "verhochdeutschte" "verhochdeutscht")  ;
  verhoehnen_V2 = dirV2 (irregV "verhöhnen" "verhöhnt" "verhöhnte" "verhöhnte" "verhöhnt")  ;
  verhoekern_V2 = dirV2 (irregV "verhökern" "verhökert" "verhökerte" "verhökerte" "verhökert")  ;
  verhoeren_rV = reflV (irregV "verhören" "verhört" "verhörte" "verhörte" "verhört") accusative ;
  verhoeren_V2 = dirV2 (irregV "verhören" "verhört" "verhörte" "verhörte" "verhört")  ;
  verhohnepiepeln_V2 = dirV2 (irregV "verhohnepiepeln" "verhohnepiepelt" "verhohnepiepelte" "verhohnepiepelte" "verhohnepiepelt")  ;
  verhohnepipeln_V2 = dirV2 (irregV "verhohnepipeln" "verhohnepipelt" "verhohnepipelte" "verhohnepipelte" "verhohnepipelt")  ;
  verholen_V2 = dirV2 (irregV "verholen" "verholt" "verholte" "verholte" "verholt")  ;
  verhueten_V2 = dirV2 (irregV "verhüten" "verhütet" "verhütete" "verhütete" "verhütet")  ;
  verhueten_V = irregV "verhüten" "verhütet" "verhütete" "verhütete" "verhütet" ;
  verhueten_VS = mkVS (irregV "verhüten" "verhütet" "verhütete" "verhütete" "verhütet")  ;
  verhuetten_V2 = dirV2 (irregV "verhütten" "verhüttet" "verhüttete" "verhüttete" "verhüttet")  ;
  verhungern_V = irregV "verhungern" "verhungert" "verhungerte" "verhungerte" "verhungert" ;
  verhunzen_V2 = dirV2 (irregV "verhunzen" "verhunzt" "verhunzte" "verhunzte" "verhunzt")  ;
  verifizieren_V2 = dirV2 (irregV "verifizieren" "verifiziert" "verifizierte" "verifizierte" "verifiziert")  ;
  verifizieren_VQ = mkVQ (irregV "verifizieren" "verifiziert" "verifizierte" "verifizierte" "verifiziert")  ;
  verinnerlichen_V2 = dirV2 (irregV "verinnerlichen" "verinnerlicht" "verinnerlichte" "verinnerlichte" "verinnerlicht")  ;
  verinnerlichen_VS = mkVS (irregV "verinnerlichen" "verinnerlicht" "verinnerlichte" "verinnerlichte" "verinnerlicht")  ;
  verjagen_V2 = dirV2 (irregV "verjagen" "verjagt" "verjagte" "verjagte" "verjagt")  ;
  verjuengen_V2 = dirV2 (irregV "verjüngen" "verjüngt" "verjüngte" "verjüngte" "verjüngt")  ;
  verkapseln_V2 = dirV2 (irregV "verkapseln" "verkapselt" "verkapselte" "verkapselte" "verkapselt")  ;
  verkarten_V2 = dirV2 (irregV "verkarten" "verkartet" "verkartete" "verkartete" "verkartet")  ;
  verkaufen_dat_V3 = accdatV3 (irregV "verkaufen" "verkauft" "verkaufte" "verkaufte" "verkauft")  ;
  verkehren_mit_V2 = prepV2 (irregV "verkehren" "verkehrt" "verkehrte" "verkehrte" "verkehrt") mit_Prep ;
  verkippen_V = irregV "verkippen" "verkippt" "verkippte" "verkippte" "verkippt" ;
  verklaeren_V2 = dirV2 (irregV "verklären" "verklärt" "verklärte" "verklärte" "verklärt")  ;
  verklaeren_VS = mkVS (irregV "verklären" "verklärt" "verklärte" "verklärte" "verklärt")  ;
  verklappen_V2 = dirV2 (irregV "verklappen" "verklappt" "verklappte" "verklappte" "verklappt")  ;
  verklauseln_V2 = dirV2 (irregV "verklauseln" "verklauselt" "verklauselte" "verklauselte" "verklauselt")  ;
  verklauseln_VS = mkVS (irregV "verklauseln" "verklauselt" "verklauselte" "verklauselte" "verklauselt")  ;
  verklemmern_V2 = dirV2 (irregV "verklemmern" "verklemmert" "verklemmerte" "verklemmerte" "verklemmert")  ;
  verknallen_in_rV2 = reflV2 (irregV "verknallen" "verknallt" "verknallte" "verknallte" "verknallt") accusative (mkPrep "in" accusative) ;
  verknappen_V2 = dirV2 (irregV "verknappen" "verknappt" "verknappte" "verknappte" "verknappt")  ;
  verknappen_V = irregV "verknappen" "verknappt" "verknappte" "verknappte" "verknappt" ;
  verknoten_V2 = dirV2 (irregV "verknoten" "verknotet" "verknotete" "verknote" "verknotet")  ;
  verknuepfen_mit_V3 = dirV3 (irregV "verknüpfen" "verknüpft" "verknüpfte" "verknüpfte" "verknüpft") mit_Prep ;
  verknusematuckeln_V0 = mkV0 (irregV "verknusematuckeln" "verknusematuckelt" "verknusematuckelte" "verknusematuckelte" "verknusematuckelt")  ;
  verknusen_V2 = dirV2 (irregV "verknusen" "verknust" "verknuste" "verknuste" "verknust")  ;
  verkoestigen_V2 = dirV2 (irregV "verköstigen" "verköstigt" "verköstigte" "verköstigte" "verköstigt")  ;
  verkommen_zu_V2 = prepV2 (irregV "verkommen" "verkommt" "verkam" "verkäme" "verkommen") zu_Prep ;
  verkopfen_rV = reflV (irregV "verkopfen" "verkopft" "verkopfte" "verkopfte" "verkopft") accusative ;
  verkordeln_V2 = dirV2 (irregV "verkordeln" "verkordelt" "verkordelte" "verkordelte" "verkordelt")  ;
  verkorken_V2 = dirV2 (irregV "verkorken" "verkorkt" "verkorkte" "verkorkte" "verkorkt")  ;
  verkorksen_sV2 = dassV2 (irregV "verkorksen" "verkorkst" "verkorkste" "verkorkste" "verkorkst") accPrep ;
  verkorksen_V2 = dirV2 (irregV "verkorksen" "verkorkst" "verkorkste" "verkorkste" "verkorkst")  ;
  verkostgelden_V2 = dirV2 (irregV "verkostgelden" "verkostgeldet" "verkostgeldete" "verkostgeldete" "verkostgeldet")  ;
  verkuemmern_V = irregV "verkümmern" "verkümmert" "verkümmerte" "verkümmerte" "verkümmert" ;
  verkuemmern_zu_V2 = prepV2 (irregV "verkümmern" "verkümmert" "verkümmerte" "verkümmerte" "verkümmert") zu_Prep ;
  verkuenden_V2 = dirV2 (irregV "verkünden" "verkündet" "verkündete" "verkündete" "verkündet")  ;
  verkuenden_VS = mkVS (irregV "verkünden" "verkündet" "verkündete" "verkündete" "verkündet")  ;
  verkuendigen_V2 = dirV2 (irregV "verkündigen" "verkündigt" "verkündigte" "verkündigte" "verkündigt")  ;
  verkuendigen_VS = mkVS (irregV "verkündigen" "verkündigt" "verkündigte" "verkündigte" "verkündigt")  ;
  verkuerzen_V2 = dirV2 (irregV "verkürzen" "verkürzt" "verkürzte" "verkürzte" "verkürzt")  ;
  verkuppeln_mit_V3 = dirV3 (irregV "verkuppeln" "verkuppelt" "verkuppelte" "verkuppelte" "verkuppelt") mit_Prep ;
  verlachen_V2 = dirV2 (irregV "verlachen" "verlacht" "verlachte" "verlachte" "verlacht")  ;
  verlaengern_V2 = dirV2 (irregV "verlängern" "verlängert" "verlängerte" "verlängerte" "verlängert")  ;
  verlangen_V2 = dirV2 (irregV "verlangen" "verlangt" "verlangte" "verlangte" "verlangt")  ;
  verlangsamen_V2 = dirV2 (irregV "verlangsamen" "verlangsamt" "verlangsamte" "verlangsamte" "verlangsamt")  ;
  verlassen_V2 = dirV2 (irregV "verlassen" "verlasst" "verließ" "verließe" "verlassen")  ;
  verlaufen_rV = reflV (irregV "verlaufen" "verlauft" "verlief" "verliefe" "verlaufen") accusative ;
  verlautbaren_V2 = dirV2 (irregV "verlautbaren" "verlautbart" "verlautbarte" "verlautbarte" "verlautbart")  ;
  verlautbaren_VS = mkVS (irregV "verlautbaren" "verlautbart" "verlautbarte" "verlautbarte" "verlautbart")  ;
  verlautern_V2 = dirV2 (irregV "verlautern" "verlautert" "verlauterte" "verlauterte" "verlautert")  ;
  verleben_V2 = dirV2 (irregV "verleben" "verlebt" "verlebte" "verlebte" "verlebt")  ;
  verlegen_V2 = dirV2 (irregV "verlegen" "verlegt" "verlegte" "verlegte" "verlegt")  ;
  verleiden_dat_V2V = mkV2V (irregV "verleiden" "verleidet" "verleidete" "verleidete" "verleidet") datPrep ;
  verleiden_dat_V3 = accdatV3 (irregV "verleiden" "verleidet" "verleidete" "verleidete" "verleidet")  ;
  verleihen_dat_V3 = accdatV3 (irregV "verleihen" "verleiht" "verlieh" "verliehe" "verliehen")  ;
  verleisern_V2 = dirV2 (irregV "verleisern" "verleisert" "verleiserte" "verleiserte" "verleisert")  ;
  verlernen_V2 = dirV2 (irregV "verlernen" "verlernt" "verlernte" "verlernte" "verlernt")  ;
  verlesen_V2 = dirV2 (irregV "verlesen" "verlest" "verlas" "verläse" "verlesen")  ;
  verletzen_V2 = dirV2 (irregV "verletzen" "verletzt" "verletzte" "verletzte" "verletzt")  ;
  verleumden_V2 = dirV2 (irregV "verleumden" "verleumdet" "verleumdete" "verleumdete" "verleumdet")  ;
  verlieren_V2 = dirV2 (irregV "verlieren" "verliert" "verlor" "verlöre" "verloren")  ;
  verlinken_mit_V3 = dirV3 (irregV "verlinken" "verlinkt" "verlinkte" "verlinkte" "verlinkt") mit_Prep ;
  verlinken_V2 = dirV2 (irregV "verlinken" "verlinkt" "verlinkte" "verlinkte" "verlinkt")  ;
  verloben_mit_rV2 = reflV2 (irregV "verloben" "verlobt" "verlobte" "verlobte" "verlobt") accusative mit_Prep ;
  verlottern_V = irregV "verlottern" "verlottert" "verlotterte" "verlotterte" "verlottert" ;
  verlupfen_V2 = dirV2 (irregV "verlupfen" "verlupft" "verlupfte" "verlupfte" "verlupft")  ;
  verlustieren_mit_rV2 = reflV2 (irregV "verlustieren" "verlustiert" "verlustierte" "verlustierte" "verlustiert") accusative mit_Prep ;
  vermaehlen_mit_rV2 = reflV2 (irregV "vermählen" "vermählt" "vermählte" "vermählte" "vermählt") accusative mit_Prep ;
  vermaehlen_mit_V3 = dirV3 (irregV "vermählen" "vermählt" "vermählte" "vermählte" "vermählt") mit_Prep ;
  vermaehlen_rV = reflV (irregV "vermählen" "vermählt" "vermählte" "vermählte" "vermählt") accusative ;
  vermaehlen_V2 = dirV2 (irregV "vermählen" "vermählt" "vermählte" "vermählte" "vermählt")  ;
  vermaennlichen_sV2 = dassV2 (irregV "vermännlichen" "vermännlicht" "vermännlichte" "vermännlichetn" "vermännlicht") accPrep ;
  vermaennlichen_V2 = dirV2 (irregV "vermännlichen" "vermännlicht" "vermännlichte" "vermännlichetn" "vermännlicht")  ;
  vermaennlichen_V = irregV "vermännlichen" "vermännlicht" "vermännlichte" "vermännlichetn" "vermännlicht" ;
  vermaledeien_V2 = dirV2 (irregV "vermaledeien" "vermaledeit" "vermaledeite" "vermaledeite" "vermaledeit")  ;
  vermasseln_dat_V3 = accdatV3 (irregV "vermasseln" "vermasselt" "vermasselte" "vermasselte" "vermasselt")  ;
  vermehren_rV = reflV (irregV "vermehren" "vermehrt" "vermehrte" "vermehrte" "vermehrt") accusative ;
  vermehren_V2 = dirV2 (irregV "vermehren" "vermehrt" "vermehrte" "vermehrte" "vermehrt")  ;
  vermeiden_V2 = dirV2 (irregV "vermeiden" "vermeidet" "vermied" "vermiede" "vermieden")  ;
  vermeiden_VV = mkVV (irregV "vermeiden" "vermeidet" "vermied" "vermiede" "vermieden")  ;
  vermeinen_VV = mkVV (irregV "vermeinen" "vermeint" "vermeinte" "vermeinte" "vermeint")  ;
  vermelden_VS = mkVS (irregV "vermelden" "vermeldet" "vermeldete" "vermeldete" "vermeldet")  ;
  vermengen_mit_V3 = dirV3 (irregV "vermengen" "vermengt" "vermengte" "vermengte" "vermengt") mit_Prep ;
  vermessen_V2 = dirV2 (irregV "vermessen" "vermesst" "vermaß" "vermäße" "vermessen")  ;
  vermiesen_dat_V2V = mkV2V (irregV "vermiesen" "vermiest" "vermieste" "vermieste" "vermiest") datPrep ;
  vermiesen_dat_V3 = accdatV3 (irregV "vermiesen" "vermiest" "vermieste" "vermieste" "vermiest")  ;
  vermieten_dat_V3 = accdatV3 (irregV "vermieten" "vermietet" "vermietete" "vermietete" "vermietet")  ;
  vermindern_V2 = dirV2 (irregV "vermindern" "vermindert" "verminderte" "verminderte" "vermindert")  ;
  verminen_V2 = dirV2 (irregV "verminen" "vermint" "verminte" "verminte" "vermint")  ;
  vermischen_mit_V3 = dirV3 (irregV "vermischen" "vermischt" "vermischte" "vermischte" "vermischt") mit_Prep ;
  vermissen_V2 = dirV2 (irregV "vermissen" "vermisst" "vermisste" "vermisste" "vermisst")  ;
  vermitteln_dat_V3 = accdatV3 (irregV "vermitteln" "vermittelt" "vermittelte" "vermittelte" "vermittelt")  ;
  vermitteln_mit_V3 = dirV3 (irregV "vermitteln" "vermittelt" "vermittelte" "vermittelte" "vermittelt") mit_Prep ;
  vermoebeln_V2 = dirV2 (irregV "vermöbeln" "vermöbelt" "vermöbelte" "vermöbelte" "vermöbelt")  ;
  vermoegen_VV = mkVV (irregV "vermögen" "vermag" "vermochte" "vermochte" "vermocht")  ;
  vermuten_VS = mkVS (irregV "vermuten" "vermutet" "vermutete" "vermutete" "vermutet")  ;
  vernachlaessigen_V2 = dirV2 (irregV "vernachlässigen" "vernachlässigt" "vernachlässigte" "vernachlässigte" "vernachlässigt")  ;
  vernachlaessigen_VS = mkVS (irregV "vernachlässigen" "vernachlässigt" "vernachlässigte" "vernachlässigte" "vernachlässigt")  ;
  vernadern_V2 = dirV2 (irregV "vernadern" "vernadert" "vernaderte" "vernaderte" "vernadert")  ;
  vernarben_V = irregV "vernarben" "vernarbt" "vernarbte" "vernarbte" "vernarbt" ;
  vernaschen_V2 = dirV2 (irregV "vernaschen" "vernascht" "vernaschte" "vernaschte" "vernascht")  ;
  vernehmen_V2 = dirV2 (irregV "vernehmen" "vernimmt" "vernahm" "vernähme" "vernommen")  ;
  verneinen_V2 = dirV2 (irregV "verneinen" "verneint" "verneinte" "verneinte" "verneint")  ;
  verneinen_VS = mkVS (irregV "verneinen" "verneint" "verneinte" "verneinte" "verneint")  ;
  vernetzen_mit_V3 = dirV3 (irregV "vernetzen" "vernetzt" "vernetzte" "vernetzte" "vernetzt") mit_Prep ;
  vernichten_V2 = dirV2 (irregV "vernichten" "vernichtet" "vernichtete" "vernichte" "vernichtet")  ;
  vernickeln_V2 = dirV2 (irregV "vernickeln" "vernickelt" "vernickelte" "vernickelte" "vernickelt")  ;
  verniedlichen_V2 = dirV2 (irregV "verniedlichen" "verniedlicht" "verniedlichte" "verniedlichte" "verniedlicht")  ;
  verniedlichen_VS = mkVS (irregV "verniedlichen" "verniedlicht" "verniedlichte" "verniedlichte" "verniedlicht")  ;
  vernuenfteln_V = irregV "vernünfteln" "vernünftelt" "vernünftelte" "vernünftelte" "vernünftelt" ;
  veroeffentlichen_V2 = dirV2 (irregV "veröffentlichen" "veröffentlicht" "veröffentlichte" "veröffentlichte" "veröffentlicht")  ;
  veroeffentlichen_VS = mkVS (irregV "veröffentlichen" "veröffentlicht" "veröffentlichte" "veröffentlichte" "veröffentlicht")  ;
  verordnen_dat_V3 = accdatV3 (irregV "verordnen" "verordnet" "verordnete" "verordnete" "verordnet")  ;
  verorten_V2 = dirV2 (irregV "verorten" "verortet" "verortete" "verortete" "verortet")  ;
  verpachten_dat_V3 = accdatV3 (irregV "verpachten" "verpachtet" "verpachtete" "verpachtete" "verpachtet")  ;
  verpacken_V2 = dirV2 (irregV "verpacken" "verpackt" "verpackte" "verpackte" "verpackt")  ;
  verpassen_V2 = dirV2 (irregV "verpassen" "verpasst" "verpasste" "verpasste" "verpasst")  ;
  verpflegen_V2 = dirV2 (irregV "verpflegen" "verpflegt" "verpflegte" "verpflegte" "verpflegt")  ;
  verpflichten_zu_V3 = dirV3 (irregV "verpflichten" "verpflichtet" "verpflichtete" "verpflichtete" "verpflichtet") zu_Prep ;
  verpissen_rV = reflV (irregV "verpissen" "verpisst" "verpisste" "verpisste" "verpisst") accusative ;
  verpixeln_V2 = dirV2 (irregV "verpixeln" "verpixelt" "verpixelte" "verpixelte" "verpixelt")  ;
  verplappern_rV = reflV (irregV "verplappern" "verplappert" "verplapperte" "verplapperte" "verplappert") accusative ;
  verplempern_V2 = dirV2 (irregV "verplempern" "verplempert" "verplemperte" "verplemperte" "verplempert")  ;
  verplomben_V2 = dirV2 (irregV "verplomben" "verplombt" "verplombte" "verplombte" "verplombt")  ;
  verposematuckeln_V2 = dirV2 (irregV "verposematuckeln" "verposematuckelt" "verposematuckelte" "verposematuckelte" "verposematuckelt")  ;
  verpreussen_V2 = dirV2 (irregV "verpreußen" "verpreußt" "verpreußte" "verpreußte" "verpreußt")  ;
  verpreussen_V = irregV "verpreußen" "verpreußt" "verpreußte" "verpreußte" "verpreußt" ;
  verproviantieren_mit_V3 = dirV3 (irregV "verproviantieren" "verproviantiert" "verproviantierte" "verproviantierte" "verproviantiert") mit_Prep ;
  verproviantieren_rV = reflV (irregV "verproviantieren" "verproviantiert" "verproviantierte" "verproviantierte" "verproviantiert") accusative ;
  verpruegeln_V2 = dirV2 (irregV "verprügeln" "verprügelt" "verprügelte" "verprügelte" "verprügelt")  ;
  verputzen_V2 = dirV2 (irregV "verputzen" "verputzt" "verputzte" "verputzte" "verputzt")  ;
  verquicken_mit_V3 = dirV3 (irregV "verquicken" "verquickt" "verquickte" "verquickte" "verquickt") mit_Prep ;
  verraten_dat_V2S = mkV2S (irregV "verraten" "verrät" "verriet" "verriete" "verraten") datPrep ;
  verraten_dat_V3 = accdatV3 (irregV "verraten" "verrät" "verriet" "verriete" "verraten")  ;
  verrecken_V = irregV "verrecken" "verreckt" "verreckte" "verreckte" "verreckt" ;
  verreisen_dir_V2 = prepV2 (irregV "verreisen" "verreist" "verreiste" "verreiste" "verreist") dir_Prep ;
  verreissen_V2 = dirV2 (irregV "verreißen" "verreißt" "verriss" "verriss" "verrissen")  ;
  verrichten_V2 = dirV2 (irregV "verrichten" "verrichtet" "verrichtete" "verrichte" "verrichtet")  ;
  verriegeln_V2 = dirV2 (irregV "verriegeln" "verriegelt" "verriegelte" "verriegelte" "verriegelt")  ;
  verringern_V2 = dirV2 (irregV "verringern" "verringert" "verringerte" "verringerte" "verringert")  ;
  verrohen_sV2 = dassV2 (irregV "verrohen" "verroht" "verrohte" "verrohte" "verroht") accPrep ;
  verrohen_V2 = dirV2 (irregV "verrohen" "verroht" "verrohte" "verrohte" "verroht")  ;
  verrohen_V = irregV "verrohen" "verroht" "verrohte" "verrohte" "verroht" ;
  verrohren_V2 = dirV2 (irregV "verrohren" "verrohrt" "verrohrte" "verrohrte" "verrohrt")  ;
  versachlichen_V2 = dirV2 (irregV "versachlichen" "versachlicht" "versachlichte" "versachlichte" "versachlicht")  ;
  versachlichen_VS = mkVS (irregV "versachlichen" "versachlicht" "versachlichte" "versachlichte" "versachlicht")  ;
  versaeumen_V2 = dirV2 (irregV "versäumen" "versäumt" "versäumte" "versäumte" "versäumt")  ;
  versagen_bei_V2 = prepV2 (irregV "versagen" "versagt" "versagte" "versagte" "versagt") (mkPrep "bei" dative) ;
  versagen_V = irregV "versagen" "versagt" "versagte" "versagte" "versagt" ;
  versalzen_V2 = dirV2 (irregV "versalzen" "versalzt" "versalzte" "versalzte" "versalzt")  ;
  versammeln_rV = reflV (irregV "versammeln" "versammelt" "versammelte" "versammelte" "versammelt") accusative ;
  versaubeuteln_V2 = dirV2 (irregV "versaubeuteln" "versaubeutelt" "versaubeutelte" "versaubeutelte" "versaubeutelt")  ;
  versauen_dat_V3 = accdatV3 (irregV "versauen" "versaut" "versaute" "versaute" "versaut")  ;
  verschachern_V2 = dirV2 (irregV "verschachern" "verschachert" "verschacherte" "verschacherte" "verschachert")  ;
  verschaffen_dat_V3 = accdatV3 (irregV "verschaffen" "verschafft" "verschaffte" "verschaffte" "verschafft")  ;
  verschallen_V = irregV "verschallen" "verschallt" "verschallte" "verschallte" "verschallt" ;
  verschanzen_loc_rV2 = reflV2 (irregV "verschanzen" "verschanzt" "verschanzte" "verschanzte" "verschanzt") accusative loc_Prep ;
  verscharren_loc_V3 = dirV3 (irregV "verscharren" "verscharrt" "verscharrte" "verscharrte" "verscharrt") loc_Prep ;
  verscheiden_V = irregV "verscheiden" "verscheidet" "verschied" "verschiede" "verschieden" ;
  verschenken_V2 = dirV2 (irregV "verschenken" "verschenkt" "verschenkte" "verschenkte" "verschenkt")  ;
  verscherbeln_V2 = dirV2 (irregV "verscherbeln" "verscherbelt" "verscherbelte" "verscherbelte" "verscherbelt")  ;
  verschieben_V2 = dirV2 (irregV "verschieben" "verschiebt" "verschob" "verschöbe" "verschoben")  ;
  verschiessen_rV = reflV (irregV "verschießen" "verschießt" "verschoss" "verschoss" "verschossen") accusative ;
  verschiessen_V2 = dirV2 (irregV "verschießen" "verschießt" "verschoss" "verschoss" "verschossen")  ;
  verschimmeln_V = irregV "verschimmeln" "verschimmelt" "verschimmelte" "verschimmelte" "verschimmelt" ;
  verschlafen_V2 = dirV2 (irregV "verschlafen" "verschlaft" "verschlief" "verschliefe" "verschlafen")  ;
  verschlagen_es_dir_V3 = dirV3 (irregV "verschlagen" "verschlagt" "verschlug" "verschlüge" "verschlagen") dir_Prep ;
  verschlagworten_V2 = dirV2 (irregV "verschlagworten" "verschlagwortet" "verschlagwortete" "verschlagwortete" "verschlagwortet")  ;
  verschlampen_V2 = dirV2 (irregV "verschlampen" "verschlampt" "verschlampte" "verschlampte" "verschlampt")  ;
  verschlechtern_V2 = dirV2 (irregV "verschlechtern" "verschlechtert" "verschlechterte" "verschlechterte" "verschlechtert")  ;
  verschleiern_V2 = dirV2 (irregV "verschleiern" "verschleiert" "verschleierte" "verschleierte" "verschleiert")  ;
  verschleiern_VS = mkVS (irregV "verschleiern" "verschleiert" "verschleierte" "verschleierte" "verschleiert")  ;
  verschliessen_V2 = dirV2 (irregV "verschließen" "verschließt" "verschloss" "verschlösse" "verschlossen")  ;
  verschlimmbessern_V2 = dirV2 (irregV "verschlimmbessern" "verschlimmbessert" "verschlimmbesserte" "verschlimmbesserte" "verschlimmbessert")  ;
  verschlimmern_rV = reflV (irregV "verschlimmern" "verschlimmert" "verschlimmerte" "verschlimmerte" "verschlimmert") accusative ;
  verschlingen_V2 = dirV2 (irregV "verschlingen" "verschlingt" "verschlang" "verschlänge" "verschlungen")  ;
  verschlucken_V2 = dirV2 (irregV "verschlucken" "verschluckt" "verschluckte" "verschluckte" "verschluckt")  ;
  verschluesseln_V2 = dirV2 (irregV "verschlüsseln" "verschlüsselt" "verschlüsselte" "verschlüsselte" "verschlüsselt")  ;
  verschmachten_loc_V2 = prepV2 (irregV "verschmachten" "verschmachtet" "verschmachtete" "verschmachtete" "verschmachtet") loc_Prep ;
  verschmaehen_V2 = dirV2 (irregV "verschmähen" "verschmäht" "verschmähte" "verschmähte" "verschmäht")  ;
  verschmaehen_VV = mkVV (irregV "verschmähen" "verschmäht" "verschmähte" "verschmähte" "verschmäht")  ;
  verschmutzen_V2 = dirV2 (irregV "verschmutzen" "verschmutzt" "verschmutzte" "verschmutzte" "verschmutzt")  ;
  verschneiden_mit_V3 = dirV3 (irregV "verschneiden" "verschneidet" "verschnitt" "verschnitt" "verschnitten") mit_Prep ;
  verschneiden_V2 = dirV2 (irregV "verschneiden" "verschneidet" "verschnitt" "verschnitt" "verschnitten")  ;
  verschrecken_V2 = dirV2 (irregV "verschrecken" "verschreckt" "verschreckte" "verschreckte" "verschreckt")  ;
  verschreiben_dat_V3 = accdatV3 (irregV "verschreiben" "verschreibt" "verschrieb" "verschriebe" "verschrieben")  ;
  verschreien_V2 = dirV2 (irregV "verschreien" "verschreit" "verschrie" "verschriee" "verschrien")  ;
  verschriften_V2 = dirV2 (irregV "verschriften" "verschriftet" "verschriftete" "verschriftete" "verschriftet")  ;
  verschueren_V2 = dirV2 (irregV "verschüren" "verschürt" "verschürte" "verschürte" "verschürt")  ;
  verschulden_rV = reflV (irregV "verschulden" "verschuldet" "verschuldete" "verschuldete" "verschuldet") accusative ;
  verschwaegern_rV = reflV (irregV "verschwägern" "verschwägert" "verschwägerte" "verschwägerte" "verschwägert") accusative ;
  verschweigen_dat_V2S = mkV2S (irregV "verschweigen" "verschweigt" "verschwieg" "verschwiege" "verschwiegen") datPrep ;
  verschweigen_dat_V3 = accdatV3 (irregV "verschweigen" "verschweigt" "verschwieg" "verschwiege" "verschwiegen")  ;
  verschwenden_V2 = dirV2 (irregV "verschwenden" "verschwendet" "verschwendete" "verschwendete" "verschwendet")  ;
  verschwimmen_plV = plV (irregV "verschwimmen" "verschwimmt" "verschwamm" "verschwämme" "verschwommen")  ;
  verschwinden_V = irregV "verschwinden" "verschwindet" "verschwand" "verschwände" "verschwunden" ;
  verschwistern_rV = reflV (irregV "verschwistern" "verschwistert" "verschwisterte" "verschwisterte" "verschwistert") accusative ;
  versehen_mit_V3 = dirV3 (irregV "versehen" "verseht" "versah" "versähe" "versehen") mit_Prep ;
  versehren_V2 = dirV2 (irregV "versehren" "versehrt" "versehrte" "versehrte" "versehrt")  ;
  verseifen_V2 = dirV2 (irregV "verseifen" "verseift" "verseifte" "verseifte" "verseift")  ;
  versemmeln_V2 = dirV2 (irregV "versemmeln" "versemmelt" "versemmelte" "versemmelte" "versemmelt")  ;
  versenden_V2 = dirV2 (irregV "versenden" "versendet" "versendete" "versendete" "versendet")  ;
  versetzen_nach_V3 = dirV3 (irregV "versetzen" "versetzt" "versetzte" "versetzte" "versetzt") nach_Prep ;
  versichern_dat_V2S = mkV2S (irregV "versichern" "versichert" "versicherte" "versicherte" "versichert") datPrep ;
  versichern_gegen_V3 = dirV3 (irregV "versichern" "versichert" "versicherte" "versicherte" "versichert") gegen_Prep ;
  versiegeln_V2 = dirV2 (irregV "versiegeln" "versiegelt" "versiegelte" "versiegelte" "versiegelt")  ;
  versieren_V0 = mkV0 (irregV "versieren" "versiert" "versierte" "versierte" "versiert")  ;
  versifizieren_V2 = dirV2 (irregV "versifizieren" "versifiziert" "versifizierte" "versifizierte" "versifiziert")  ;
  versilbern_V2 = dirV2 (irregV "versilbern" "versilbert" "versilberte" "versilberte" "versilbert")  ;
  versinnbildlichen_mit_V3 = dirV3 (irregV "versinnbildlichen" "versinnbildlicht" "versinnbildlichte" "versinnbildlichte" "versinnbildlicht") mit_Prep ;
  versinnbildlichen_mit_VS2 = mkVS2 (irregV "versinnbildlichen" "versinnbildlicht" "versinnbildlichte" "versinnbildlichte" "versinnbildlicht") mit_Prep ;
  versklaven_V2 = dirV2 (irregV "versklaven" "versklavt" "versklavte" "versklavte" "versklavt")  ;
  versoehnen_mit_V3 = dirV3 (irregV "versöhnen" "versöhnt" "versöhnte" "versöhnte" "versöhnt") mit_Prep ;
  versoehnen_rV = reflV (irregV "versöhnen" "versöhnt" "versöhnte" "versöhnte" "versöhnt") accusative ;
  versoehnen_sV2 = dassV2 (irregV "versöhnen" "versöhnt" "versöhnte" "versöhnte" "versöhnt") accPrep ;
  versoehnen_V2 = dirV2 (irregV "versöhnen" "versöhnt" "versöhnte" "versöhnte" "versöhnt")  ;
  versorgen_mit_V3 = dirV3 (irregV "versorgen" "versorgt" "versorgte" "versorgte" "versorgt") mit_Prep ;
  verspaeten_rV = reflV (irregV "verspäten" "verspätet" "verspätete" "verspätete" "verspätet") accusative ;
  verspeichen_V2 = dirV2 (irregV "verspeichen" "verspeicht" "verspeichte" "verspeichte" "verspeicht")  ;
  verspeisen_V2 = dirV2 (irregV "verspeisen" "verspeist" "verspeiste" "verspeiste" "verspeist")  ;
  verspielen_rV = reflV (irregV "verspielen" "verspielt" "verspielte" "verspielte" "verspielt") accusative ;
  verspielen_V2 = dirV2 (irregV "verspielen" "verspielt" "verspielte" "verspielte" "verspielt")  ;
  verspotten_V2 = dirV2 (irregV "verspotten" "verspottet" "verspottete" "verspotte" "verspottet")  ;
  versprechen_dat_V2V = mkV2V (irregV "versprechen" "versprecht" "versprach" "verspräche" "versprochen") datPrep ;
  versprengen_V2 = dirV2 (irregV "versprengen" "versprengt" "versprengte" "versprengte" "versprengt")  ;
  verspueren_V2 = dirV2 (irregV "verspüren" "verspürt" "verspürte" "verspürte" "verspürt")  ;
  verstaatlichen_V2 = dirV2 (irregV "verstaatlichen" "verstaatlicht" "verstaatlichte" "verstaatlichte" "verstaatlicht")  ;
  verstaendigen_mit_ueber_rV3 = reflV3 (irregV "verständigen" "verständigt" "verständigte" "verständigte" "verständigt") accusative mit_Prep (mkPrep "über" accusative) ;
  verstaendigen_ueber_rV2 = reflV2 (irregV "verständigen" "verständigt" "verständigte" "verständigte" "verständigt") accusative (mkPrep "über" accusative) ;
  verstaendigen_ueber_V3 = dirV3 (irregV "verständigen" "verständigt" "verständigte" "verständigte" "verständigt") (mkPrep "über" accusative) ;
  verstaendigen_von_V3 = dirV3 (irregV "verständigen" "verständigt" "verständigte" "verständigte" "verständigt") von_Prep ;
  verstaerken_V2 = dirV2 (irregV "verstärken" "verstärkt" "verstärkte" "verstärkte" "verstärkt")  ;
  verstatten_dat_V2V = mkV2V (irregV "verstatten" "verstattet" "verstattete" "verstattete" "verstattet") datPrep ;
  verstatten_dat_V3 = accdatV3 (irregV "verstatten" "verstattet" "verstattete" "verstattete" "verstattet")  ;
  verstecken_V2 = dirV2 (irregV "verstecken" "versteckt" "versteckte" "verstecke" "versteckt")  ;
  verstehen_V2 = dirV2 (irregV "verstehen" "versteht" "verstand" "verstände" "verstanden")  ;
  versteifen_auf_rV2 = reflV2 (irregV "versteifen" "versteift" "versteifte" "versteifte" "versteift") accusative (mkPrep "auf" accusative) ;
  versteigen_in_rV2 = reflV2 (irregV "versteigen" "versteigt" "verstieg" "verstieg" "verstiegen") accusative (mkPrep "in" accusative) ;
  versteigern_V2 = dirV2 (irregV "versteigern" "versteigert" "versteigerte" "versteigerte" "versteigert")  ;
  versteinern_V = irregV "versteinern" "versteinert" "versteinerte" "versteinerte" "versteinert" ;
  verstellen_rV = reflV (irregV "verstellen" "verstellt" "verstellte" "verstellte" "verstellt") accusative ;
  versterben_V = irregV "versterben" "versterbt" "verstarb" "verstürbe" "verstorben" ;
  versteten_V2 = dirV2 (irregV "versteten" "verstetet" "verstetete" "verstetete" "verstetet")  ;
  verstimmen_V2 = dirV2 (irregV "verstimmen" "verstimmt" "verstimmte" "verstimmte" "verstimmt")  ;
  verstoffwechseln_V2 = dirV2 (irregV "verstoffwechseln" "verstoffwechselt" "verstoffwechselte" "verstoffwechselte" "verstoffwechselt")  ;
  verstrahlen_V2 = dirV2 (irregV "verstrahlen" "verstrahlt" "verstrahlte" "verstrahlte" "verstrahlt")  ;
  verstreichen_loc_V3 = dirV3 (irregV "verstreichen" "verstreicht" "verstrich" "verstriche" "verstrichen") loc_Prep ;
  verstreichen_V = irregV "verstreichen" "verstreicht" "verstrich" "verstriche" "verstrichen" ;
  verstromen_V2 = dirV2 (irregV "verstromen" "verstromt" "verstromte" "verstromte" "verstromet")  ;
  verstuemmeln_V2 = dirV2 (irregV "verstümmeln" "verstümmelt" "verstümmelte" "verstümmelte" "verstümmelt")  ;
  verstummen_V = irregV "verstummen" "verstummt" "verstummte" "verstummte" "verstummt" ;
  versuchen_VV = mkVV (irregV "versuchen" "versucht" "versuchte" "versuchte" "versucht")  ;
  versuessen_dat_V3 = accdatV3 (irregV "versüßen" "versüßt" "versüßte" "versüßte" "versüßt")  ;
  vertaeuen_V2 = dirV2 (irregV "vertäuen" "vertäut" "vertäute" "vertäute" "vertäut")  ;
  vertagen_V2 = dirV2 (irregV "vertagen" "vertagt" "vertagte" "vertagte" "vertagt")  ;
  verteidigen_gegen_V3 = dirV3 (irregV "verteidigen" "verteidigt" "verteidigte" "verteidige" "verteidigt") gegen_Prep ;
  verteidigen_V2 = dirV2 (irregV "verteidigen" "verteidigt" "verteidigte" "verteidige" "verteidigt")  ;
  verteidigen_VS = mkVS (irregV "verteidigen" "verteidigt" "verteidigte" "verteidige" "verteidigt")  ;
  verteilen_unter_V3 = dirV3 (irregV "verteilen" "verteilt" "verteilte" "verteile" "verteilt") (mkPrep "unter" accusative) ;
  verteilen_V2 = dirV2 (irregV "verteilen" "verteilt" "verteilte" "verteile" "verteilt")  ;
  verteufeln_V2 = dirV2 (irregV "verteufeln" "verteufelt" "verteufelte" "verteufelte" "verteufelt")  ;
  verteufeln_VS = mkVS (irregV "verteufeln" "verteufelt" "verteufelte" "verteufelte" "verteufelt")  ;
  vertilgen_V2 = dirV2 (irregV "vertilgen" "vertilgt" "vertilgte" "vertilgte" "vertilgt")  ;
  vertrauen_dat_V2 = mkV2 (irregV "vertrauen" "vertraut" "vertraute" "vertraute" "vertraut") datPrep ;
  vertreiben_V2 = dirV2 (irregV "vertreiben" "vertreibt" "vertrieb" "vertriebe" "vertrieben")  ;
  vertreten_V2 = dirV2 (irregV "vertreten" "vertritt" "vertrat" "verträte" "vertreten")  ;
  vertun_V2 = dirV2 (irregV "vertun" "vertut" "vertat" "vertäte" "vertan")  ;
  veruebeln_dat_V2S = mkV2S (irregV "verübeln" "verübelt" "verübelte" "verübelte" "verübelt") datPrep ;
  veruebeln_dat_V3 = accdatV3 (irregV "verübeln" "verübelt" "verübelte" "verübelte" "verübelt")  ;
  verueben_V2 = dirV2 (irregV "verüben" "verübt" "verübte" "verübte" "verübt")  ;
  verumstaendlichen_V2 = dirV2 (irregV "verumständlichen" "verumständlicht" "verumständlichte" "verumständlichte" "verumständlicht")  ;
  verumstaendlichen_VQ = mkVQ (irregV "verumständlichen" "verumständlicht" "verumständlichte" "verumständlichte" "verumständlicht")  ;
  verunfallen_V = irregV "verunfallen" "verunfallt" "verunfallte" "verunfallte" "verunfallt" ;
  verunglimpfen_V2 = dirV2 (irregV "verunglimpfen" "verunglimpft" "verunglimpfte" "verunglimpfte" "verunglimpft")  ;
  verunmoeglichen_V2 = dirV2 (irregV "verunmöglichen" "verunmöglicht" "verunmöglichte" "verunmöglichte" "verunmöglicht")  ;
  verunsichern_V2 = dirV2 (irregV "verunsichern" "verunsichert" "verunsicherte" "verunsicherte" "verunsichert")  ;
  verunstalten_V2 = dirV2 (irregV "verunstalten" "verunstaltet" "verunstaltete" "verunstaltete" "verunstaltet")  ;
  veruntreuen_V2 = dirV2 (irregV "veruntreuen" "veruntreut" "veruntreute" "veruntreute" "veruntreut")  ;
  verursachen_V2 = dirV2 (irregV "verursachen" "verursacht" "verursachte" "verursachte" "verursacht")  ;
  vervolkstuemlichen_V2 = dirV2 (irregV "vervolkstümlichen" "vervolkstümlicht" "vervolkstümlichte" "vervolkstümlichte" "vervolkstümlicht")  ;
  vervollstaendigen_V2 = dirV2 (irregV "vervollständigen" "vervollständigt" "vervollständigte" "vervollständigte" "vervollständigt")  ;
  verwackeln_V = irregV "verwackeln" "verwackelt" "verwackelte" "verwackelte" "verwackelt" ;
  verwaehlen_rV = reflV (irregV "verwählen" "verwählt" "verwählte" "verwählte" "verwählt") accusative ;
  verwaessern_V2 = dirV2 (irregV "verwässern" "verwässert" "verwässerte" "verwässerte" "verwässert")  ;
  verwahren_V2 = dirV2 (irregV "verwahren" "verwahrt" "verwahrte" "verwahrte" "verwahrt")  ;
  verwahrlosen_V = irregV "verwahrlosen" "verwahrlost" "verwahrloste" "verwahrloste" "verwahrlost" ;
  verwaisen_V = irregV "verwaisen" "verwaist" "verwaiste" "verwaiste" "verwaist" ;
  verwalten_V2 = dirV2 (irregV "verwalten" "verwaltet" "verwaltete" "verwaltete" "verwaltet")  ;
  verwandeln_in_V3 = dirV3 (irregV "verwandeln" "verwandelt" "verwandelte" "verwandelte" "verwandelt") (mkPrep "in" accusative) ;
  verwechseln_mit_V3 = dirV3 (irregV "verwechseln" "verwechselt" "verwechselte" "verwechselte" "verwechselt") mit_Prep ;
  verwehen_V2 = dirV2 (irregV "verwehen" "verweht" "verwehte" "verwehte" "verweht")  ;
  verwehren_dat_V2V = mkV2V (irregV "verwehren" "verwehrt" "verwehrte" "verwehrte" "verwehrt") datPrep ;
  verwehren_dat_V3 = accdatV3 (irregV "verwehren" "verwehrt" "verwehrte" "verwehrte" "verwehrt")  ;
  verweichlichen_sV2 = dassV2 (irregV "verweichlichen" "verweichlicht" "verweichlichte" "verweichlichte" "verweichlicht") accPrep ;
  verweichlichen_V2 = dirV2 (irregV "verweichlichen" "verweichlicht" "verweichlichte" "verweichlichte" "verweichlicht")  ;
  verweichlichen_V = irregV "verweichlichen" "verweichlicht" "verweichlichte" "verweichlichte" "verweichlicht" ;
  verweigern_dat_V2V = mkV2V (irregV "verweigern" "verweigert" "verweigerte" "verweigerte" "verweigert") datPrep ;
  verweigern_dat_V3 = accdatV3 (irregV "verweigern" "verweigert" "verweigerte" "verweigerte" "verweigert")  ;
  verweigern_V2 = dirV2 (irregV "verweigern" "verweigert" "verweigerte" "verweigerte" "verweigert")  ;
  verweigern_VV = mkVV (irregV "verweigern" "verweigert" "verweigerte" "verweigerte" "verweigert")  ;
  verweilen_loc_V2 = prepV2 (irregV "verweilen" "verweilt" "verweilte" "verweilte" "verweilt") loc_Prep ;
  verweisen_an_V3 = dirV3 (irregV "verweisen" "verweist" "verwies" "verwiese" "verwiesen") (mkPrep "an" accusative) ;
  verweltlichen_V2 = dirV2 (irregV "verweltlichen" "verweltlicht" "verweltlichte" "verweltlichte" "verweltlicht")  ;
  verweltlichen_V = irregV "verweltlichen" "verweltlicht" "verweltlichte" "verweltlichte" "verweltlicht" ;
  verwenden_auf_V3 = dirV3 (irregV "verwenden" "verwendet" "verwendete" "verwendete" "verwendet") (mkPrep "auf" accusative) ;
  verwerfen_V2 = dirV2 (irregV "verwerfen" "verwerft" "verwarf" "verwürfe" "verworfen")  ;
  verwesen_V = irregV "verwesen" "verwest" "verweste" "verweste" "verwest" ;
  verwestlichen_V2 = dirV2 (irregV "verwestlichen" "verwestlicht" "verwestlichte" "verwestlichte" "verwestlicht")  ;
  verwestlichen_V = irregV "verwestlichen" "verwestlicht" "verwestlichte" "verwestlichte" "verwestlicht" ;
  verwinden_V2 = dirV2 (irregV "verwinden" "verwindet" "verwand" "verwände" "verwunden")  ;
  verwirklichen_V2 = dirV2 (irregV "verwirklichen" "verwirklicht" "verwirklichte" "verwirklichte" "verwirklicht")  ;
  verwirklichen_VS = mkVS (irregV "verwirklichen" "verwirklicht" "verwirklichte" "verwirklichte" "verwirklicht")  ;
  verwirren_V2 = dirV2 (irregV "verwirren" "verwirrt" "verwirrte" "verwirrte" "verwirrt")  ;
  verwissenschaftlichen_V2 = dirV2 (irregV "verwissenschaftlichen" "verwissenschaftlicht" "verwissenschaftlichte" "verwissenschaftlichte" "verwissenschaftlicht")  ;
  verwitwen_V = irregV "verwitwen" "verwitwet" "verwitwete" "verwitwete" "verwitwet" ;
  verwoehnen_V2 = dirV2 (irregV "verwöhnen" "verwöhnt" "verwöhnte" "verwöhnte" "verwöhnt")  ;
  verwuenschen_V2 = dirV2 (irregV "verwünschen" "verwünscht" "verwünschte" "verwünschte" "verwünscht")  ;
  verwuesten_V2 = dirV2 (irregV "verwüsten" "verwüstet" "verwüstete" "verwüste" "verwüstet")  ;
  verwunden_V2 = dirV2 (irregV "verwunden" "verwundet" "verwundete" "verwundete" "verwundet")  ;
  verwursten_V2 = dirV2 (irregV "verwursten" "verwurstet" "verwurstete" "verwurstete" "verwurstet")  ;
  verzapfen_V2 = dirV2 (irregV "verzapfen" "verzapft" "verzapfte" "verzapfte" "verzapft")  ;
  verzehren_V2 = dirV2 (irregV "verzehren" "verzehrt" "verzehrte" "verzehrte" "verzehrt")  ;
  verzeigen_V2 = dirV2 (irregV "verzeigen" "verzeigt" "verzeigte" "verzeigte" "verzeigt")  ;
  verzeihen_dat_V2S = mkV2S (irregV "verzeihen" "verzeiht" "verzieh" "verziehe" "verziehen") datPrep ;
  verzichten_auf_V2 = prepV2 (irregV "verzichten" "verzichtet" "verzichtete" "verzichtete" "verzichtet") (mkPrep "auf" accusative) ;
  verziehen_rV = reflV (irregV "verziehen" "verzieht" "verzog" "verzöge" "verzogen") accusative ;
  verzieren_V2 = dirV2 (irregV "verzieren" "verziert" "verzierte" "verzierte" "verziert")  ;
  verzierlichen_V2 = dirV2 (irregV "verzierlichen" "verzierlicht" "verzierlichte" "verzierlichte" "verzierlicht")  ;
  verzinnen_V2 = dirV2 (irregV "verzinnen" "verzinnt" "verzinnte" "verzinnte" "verzinnt")  ;
  verzocken_V2 = dirV2 (irregV "verzocken" "verzockt" "verzockte" "verzockte" "verzockt")  ;
  verzundern_V2 = dirV2 (irregV "verzundern" "verzundert" "verzunderte" "verzunderte" "verzundert")  ;
  verzupfen_rV = reflV (irregV "verzupfen" "verzupft" "verzupfte" "verzupfte" "verzupft") accusative ;
  verzupfen_V2 = dirV2 (irregV "verzupfen" "verzupft" "verzupfte" "verzupfte" "verzupft")  ;
  verzweifeln_am_V2 = prepV2 (irregV "verzweifeln" "verzweifelt" "verzweifelte" "verzweifelte" "verzweifelt") (mkPrep "an" dative) ;
  verzweigen_plV = plV (irregV "verzweigen" "verzweigt" "verzweigte" "verzweigte" "verzweigt")  ;
  vespern_V = irregV "vespern" "vespert" "vesperte" "vesperte" "vespert" ;
  vibrieren_V = irregV "vibrieren" "vibriert" "vibrierte" "vibrierte" "vibriert" ;
  vidieren_V2 = dirV2 (irregV "vidieren" "vidiert" "vidierte" "vidierte" "vidiert")  ;
  vieren_V2 = dirV2 (regV "vieren")  ;
  vierteilen_V2 = dirV2 (irregV "vierteilen" "vierteilt" "vierteilte" "vierteilte" "gevierteilt")  ;
  vierteln_V2 = dirV2 (regV "vierteln")  ;
  vindizieren_von_V3 = dirV3 (irregV "vindizieren" "vindiziert" "vindizierte" "vindizierte" "vindiziert") (mkPrep "von" dative) ;
  voegeln_mit_V2 = prepV2 (regV "vögeln") mit_Prep ;
  voegeln_plV = plV (regV "vögeln")  ;
  voellern_V = regV "völlern" ;
  voipen_mit_V2 = prepV2 (irregV "voipen" "voipt" "voipte" "voipte" "voipt") mit_Prep ;
  vokalisieren_V2 = dirV2 (regV "vokalisieren")  ;
  volkstuemeln_V = regV "volkstümeln" ;
  vollfuehren_V2 = dirV2 (irregV "vollführen" "vollführt" "vollführte" "vollführte" "vollführt")  ;
  vollscheissen_V2 = dirV2 (prefixV "voll" (irregV "scheißen" "scheißt" "schiss" "schisse" "geschissen"))  ;
  volltanken_V2 = dirV2 (prefixV "voll" (regV "tanken"))  ;
  volltanken_V = prefixV "voll" (regV "tanken") ;
  vollziehen_V2 = dirV2 (irregV "vollziehen" "vollzieht" "vollzog" "vollzöge" "vollzogen")  ;
  volontieren_loc_V2 = prepV2 (regV "volontieren") loc_Prep ;
  voltigieren_V = regV "voltigieren" ;
  vomieren_V = irregV "vomieren" "vomiert" "vomierte" "vomierte" "vomiert" ;
  vonstattengehen_sV = dassV (prefixV "vonstatten" (irregV "gehen" "geht" "ging" "ging" "gegangen"))  ;
  voranbringen_V2 = dirV2 (prefixV "voran" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  vorangehen_V = prefixV "voran" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  vorausgehen_dat_sV2 = dassV2 (prefixV "voraus" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) datPrep ;
  vorausgehen_dat_V2 = mkV2 (prefixV "voraus" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) datPrep ;
  vorbehalten_dat_V2S = mkV2S (prefixV "vor" (irregV "behalten" "behält" "behielt" "behielte" "behalten")) datPrep ;
  vorbehalten_dat_V2V = mkV2V (prefixV "vor" (irregV "behalten" "behält" "behielt" "behielte" "behalten")) datPrep ;
  vorbeifahren_am_V2 = prepV2 (prefixV "vorbei" (irregV "fahren" "fahrt" "fuhr" "führe" "gefahren")) (mkPrep "an" dative) ;
  vorbeizwaengen_am_rV2 = reflV2 (prefixV "vorbei" (regV "zwängen")) accusative (mkPrep "an" dative) ;
  vorbereiten_V2 = dirV2 (prefixV "vor" (irregV "bereiten" "bereitet" "bereitete" "bereitete" "bereitet"))  ;
  vorbeugen_dat_V2 = mkV2 (prefixV "vor" (regV "beugen")) datPrep ;
  vorfallen_sV = dassV (irregV "vorfallen" "fallt" "fiel" "fiele" "gefallen")  ;
  vorfuehlen_bei_V2 = prepV2 (prefixV "vor" (regV "fühlen")) bei_Prep ;
  vorgeben_VV = mkVV (prefixV "vor" (irregV "geben" "gebt" "gab" "gäbe" "gegeben"))  ;
  vorgehen_sV = dassV (prefixV "vor" (irregV "gehen" "geht" "ging" "ginge" "gegangen"))  ;
  vorhaben_VV = mkVV (prefixV "vor" (irregV "haben" "hat" "hatte" "hatte" "gehabt"))  ;
  vorhergehen_dat_V2 = mkV2 (prefixV "vor" (irregV "hergehen" "hergeht" "hergehte" "hergehte" "gehergeht")) datPrep ;
  vorherrschen_V = prefixV "vor" (regV "herrschen") ;
  vorkommen_im_V2 = prepV2 (prefixV "vor" (irregV "kommen" "kommt" "kam" "käme" "gekommen")) (mkPrep "in" dative) ;
  vorkommen_sV = dassV (prefixV "vor" (irregV "kommen" "kommt" "kam" "käme" "gekommen"))  ;
  vorladen_V2 = dirV2 (prefixV "vor" (irregV "laden" "lädt" "lud" "lüde" "geladen"))  ;
  vorlassen_V2 = dirV2 (prefixV "vor" (irregV "lassen" "lasst" "ließ" "ließe" "gelassen"))  ;
  vorlegen_dat_V3 = accdatV3 (prefixV "vor" (regV "legen"))  ;
  vorlesen_V2 = dirV2 (prefixV "vor" (irregV "lesen" "liest" "las" "läse" "gelesen"))  ;
  vorliebnehmen_mit_V2 = prepV2 (prefixV "vorlieb" (irregV "nehmen" "nimmt" "nahm" "nahm" "genommen")) mit_Prep ;
  vorliegen_dat_V2 = mkV2 (prefixV "vor" (irregV "liegen" "liegt" "lag" "läge" "gelegen")) datPrep ;
  vorliegen_sV = dassV (prefixV "vor" (irregV "liegen" "liegt" "lag" "läge" "gelegen"))  ;
  vormachen_dat_V2S = mkV2S (prefixV "vor" (regV "machen")) datPrep ;
  vornehmen_rVV = reflVV (prefixV "vor" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen")) dative ;
  vorruecken_V = prefixV "vor" (regV "rücken") ;
  vorschiessen_dat_V3 = accdatV3 (prefixV "vor" (irregV "schießen" "schießt" "schoss" "schösse" "geschossen"))  ;
  vorschlagen_dat_V2V = mkV2V (prefixV "vor" (irregV "schlagen" "schlägt" "schlug" "schlüge" "geschlagen")) datPrep ;
  vorschlagen_dat_V3 = accdatV3 (prefixV "vor" (irregV "schlagen" "schlägt" "schlug" "schlüge" "geschlagen"))  ;
  vorschreiben_dat_V2V = mkV2V (prefixV "vor" (irregV "schreiben" "schreibt" "schrieb" "schrieb" "geschrieben")) datPrep ;
  vorsehen_rV = reflV (prefixV "vor" (irregV "sehen" "sieht" "sah" "sähe" "gesehen")) accusative ;
  vorsehen_VV = mkVV (prefixV "vor" (irregV "sehen" "sieht" "sah" "sähe" "gesehen"))  ;
  vorsorgen_fuer_V2 = prepV2 (prefixV "vor" (regV "sorgen")) fuer_Prep ;
  vorstellen_dat_V3 = accdatV3 (prefixV "vor" (regV "stellen"))  ;
  vorstellen_rVS = reflVS (prefixV "vor" (regV "stellen")) dative ;
  vortaeuschen_dat_V2S = mkV2S (prefixV "vor" (regV "täuschen")) datPrep ;
  vortaeuschen_dat_V3 = accdatV3 (prefixV "vor" (regV "täuschen"))  ;
  vortragen_V2 = dirV2 (prefixV "vor" (irregV "tragen" "trägt" "trug" "trüge" "getragen"))  ;
  vorturnen_V2 = dirV2 (prefixV "vor" (regV "turnen"))  ;
  vorturnen_V = prefixV "vor" (regV "turnen") ;
  voruebergehen_V = prefixV "vorüber" (irregV "gehen" "geht" "ging" "ging" "gegangen") ;
  vorwegnehmen_V2 = dirV2 (prefixV "vorweg" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  vorzeigen_dat_V3 = accdatV3 (prefixV "vor" (regV "zeigen"))  ;
  vorziehen_dat_V3 = accdatV3 (prefixV "vor" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen"))  ;
  vorziehen_VV = mkVV (prefixV "vor" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen"))  ;
  votieren_fuer_V2 = prepV2 (irregV "votieren" "votiert" "votierte" "votierte" "votiert") fuer_Prep ;
  votieren_gegen_V2 = prepV2 (irregV "votieren" "votiert" "votierte" "votierte" "votiert") gegen_Prep ;
  vozieren_vor_V3 = dirV3 (irregV "vozieren" "voziert" "vozierte" "vozierte" "voziert") (mkPrep "vor" accusative) ;
  vulkanisieren_V2 = dirV2 (regV "vulkanisieren")  ;
  wabern_V = regV "wabern" ;
  wachen_ueber_V2 = prepV2 (regV "wachen") (mkPrep "über" accusative) ;
  wachen_V2 = dirV2 (regV "wachen")  ;
  wachsen_V2 = dirV2 (irregV "wachsen" "wächst" "wuchs" "wüchse" "gewachsen")  ;
  wackeln_V = regV "wackeln" ;
  waehlen_als_V3 = dirV3 (regV "wählen") (mkPrep "als" accusative) ;
  waehlen_zu_V3 = dirV3 (regV "wählen") zu_Prep ;
  waehnen_V2 = dirV2 (regV "wähnen")  ;
  waehnen_VS = mkVS (regV "wähnen")  ;
  waehren_VA = mkVA (regV "währen")  ;
  waelzen_dir_V3 = dirV3 (regV "wälzen") dir_Prep ;
  waessern_V2 = dirV2 (regV "wässern")  ;
  wagen_V2 = dirV2 (regV "wagen")  ;
  wagen_VV = mkVV (regV "wagen")  ;
  wahren_V2 = dirV2 (regV "wahren")  ;
  wahrnehmen_V2 = dirV2 (prefixV "wahr" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  waleien_V = regV "waleien" ;
  walken_V2 = dirV2 (regV "walken")  ;
  wallen_V = regV "wallen" ;
  wallfahren_nach_V2 = prepV2 (regV "wallfahren") nach_Prep ;
  walten_ueber_V2 = prepV2 (regV "walten") (mkPrep "über" accusative) ;
  wandeln_dir_V2 = prepV2 (regV "wandeln") dir_Prep ;
  wandern_dir_V2 = prepV2 (regV "wandern") dir_Prep ;
  wankeln_V = regV "wankeln" ;
  wanken_V = regV "wanken" ;
  wappnen_gegen_V3 = dirV3 (regV "wappnen") gegen_Prep ;
  warnen_V2V = dirV2V (regV "warnen")  ;
  warnen_vor_V3 = dirV3 (regV "warnen") (mkPrep "vor" dative) ;
  warten_V2 = dirV2 (regV "warten")  ;
  waschen_V2 = dirV2 (irregV "waschen" "wäscht" "wusch" "wüsche" "gewaschen")  ;
  wassern_V2 = dirV2 (regV "wassern")  ;
  waten_dir_V2 = prepV2 (regV "waten") dir_Prep ;
  waten_loc_V2 = prepV2 (regV "waten") loc_Prep ;
  watschen_V2 = dirV2 (regV "watschen")  ;
  wattieren_V2 = dirV2 (regV "wattieren")  ;
  weben_V2 = dirV2 (irregV "weben" "webt" "wob" "wöbe" "gewoben")  ;
  wechseln_gegen_V3 = dirV3 (regV "wechseln") gegen_Prep ;
  wechselwirken_plV = plV (regV "wechselwirken")  ;
  wecken_V2 = dirV2 (regV "wecken")  ;
  wedeln_dir_V2 = prepV2 (regV "wedeln") dir_Prep ;
  wegbegeben_rV = reflV (prefixV "weg" (irregV "begeben" "begibt" "begab" "begäbe" "begeben")) accusative ;
  wegbringen_V2 = dirV2 (prefixV "weg" (irregV "bringen" "bringt" "brachte" "brächte" "gebracht"))  ;
  wegdenken_V2 = dirV2 (prefixV "weg" (irregV "denken" "denkt" "dachte" "dächte" "gedacht"))  ;
  wegdruecken_V2 = dirV2 (prefixV "weg" (regV "drücken"))  ;
  wegfahren_V = prefixV "weg" (irregV "fahren" "fährt" "fuhr" "führe" "gefahren") ;
  weggehen_V = prefixV "weg" (irregV "gehen" "geht" "ging" "ginge" "gegangen") ;
  wegklicken_V2 = dirV2 (prefixV "weg" (regV "klicken"))  ;
  weglassen_V2 = dirV2 (prefixV "weg" (irregV "lassen" "lässt" "ließ" "ließe" "gelassen"))  ;
  weglaufen_V = prefixV "weg" (irregV "laufen" "läuft" "lief" "lief" "gelaufen") ;
  weglegen_V2 = dirV2 (prefixV "weg" (regV "legen"))  ;
  wegmachen_V2 = dirV2 (prefixV "weg" (regV "machen"))  ;
  wegnehmen_dat_V3 = accdatV3 (prefixV "weg" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  wegraeumen_V2 = dirV2 (prefixV "weg" (regV "räumen"))  ;
  wegsehen_V = prefixV "weg" (irregV "sehen" "sieht" "sah" "sähe" "gesehen") ;
  wegtreten_V = prefixV "weg" (irregV "treten" "tritt" "trat" "träte" "getreten") ;
  wegziehen_V = prefixV "weg" (irregV "ziehen" "zieht" "zog" "zöge" "gezogen") ;
  wehen_V = regV "wehen" ;
  wehklagen_ueber_V2 = prepV2 (regV "wehklagen") (mkPrep "über" accusative) ;
  wehren_gegen_rV2 = reflV2 (regV "wehren") accusative gegen_Prep ;
  wehtun_dat_sV2 = dassV2 (prefixV "weh" (irregV "tun" "tut" "tat" "täte" "getan")) datPrep ;
  weichen_dat_V2 = mkV2 (regV "weichen") datPrep ;
  weiden_am_rV2 = reflV2 (regV "weiden") accusative (mkPrep "an" dative) ;
  weiden_loc_V3 = dirV3 (regV "weiden") loc_Prep ;
  weigern_rVV = reflVV (regV "weigern") accusative ;
  weihen_V2 = dirV2 (regV "weihen")  ;
  weilen_loc_V2 = prepV2 (regV "weilen") loc_Prep ;
  weinen_V = regV "weinen" ;
  weisen_dir_V2 = prepV2 (irregV "weisen" "weist" "wies" "wiese" "gewiesen") dir_Prep ;
  weisseln_V2 = dirV2 (regV "weißeln")  ;
  weissen_V2 = dirV2 (regV "weißen")  ;
  weiterdenken_V = prefixV "weiter" (irregV "denken" "denkt" "dachte" "dächte" "gedacht") ;
  weiterverleihen_V2 = dirV2 (prefixV "weiter" (irregV "verleihen" "verleiht" "verlieh" "verliehe" "verliehen"))  ;
  welken_V = regV "welken" ;
  wellen_V2 = dirV2 (regV "wellen")  ;
  welschen_V = regV "welschen" ;
  wenden_an_rV2 = reflV2 (regV "wenden") accusative (mkPrep "an" accusative) ;
  wenden_V2 = dirV2 (regV "wenden")  ;
  werben_fuer_V2 = prepV2 (irregV "werben" "wirbt" "warb" "würbe" "geworben") fuer_Prep ;
  werben_um_V2 = prepV2 (irregV "werben" "wirbt" "warb" "würbe" "geworben") um_Prep ;
  werden_V0 = mkV0 (irregV "werden" "wird" "wurde" "würde" "geworden")  ;
  werfen_dir_V3 = dirV3 (irregV "werfen" "werft" "warf" "würfe" "geworfen") dir_Prep ;
  werkeln_am_V2 = prepV2 (regV "werkeln") (mkPrep "an" dative) ;
  werkeln_V = regV "werkeln" ;
  werten_als_V3 = dirV3 (regV "werten") (mkPrep "als" accusative) ;
  werten_V2 = dirV2 (regV "werten")  ;
  wetten_mit_um_V3S = mkV3S (regV "wetten") mit_Prep um_Prep ;
  wetten_um_V2S = mkV2S (regV "wetten") um_Prep ;
  wettern_gegen_V2 = prepV2 (regV "wettern") gegen_Prep ;
  wettmachen_V2 = dirV2 (prefixV "wett" (regV "machen"))  ;
  wetzen_dir_V2 = prepV2 (regV "wetzen") dir_Prep ;
  wetzen_V2 = dirV2 (regV "wetzen")  ;
  wichsen_V2 = dirV2 (regV "wichsen")  ;
  wichsen_V = regV "wichsen" ;
  wichtigmachen_rV = reflV (prefixV "wichtig" (regV "machen")) accusative ;
  wickeln_um_V3 = dirV3 (regV "wickeln") um_Prep ;
  widerlegen_V2 = dirV2 (regV "widerlegen")  ;
  widerlegen_VS = mkVS (regV "widerlegen")  ;
  widerrufen_V2 = dirV2 (irregV "widerrufen" "widerruft" "widerrief" "widerriefe" "widerrufen")  ;
  widerrufen_VS = mkVS (irregV "widerrufen" "widerruft" "widerrief" "widerriefe" "widerrufen")  ;
  widerspiegeln_im_rV2 = reflV2 (prefixV "wider" (regV "spiegeln")) accusative (mkPrep "in" dative) ;
  widerspiegeln_V2 = dirV2 (prefixV "wider" (regV "spiegeln"))  ;
  widersprechen_dat_V2 = mkV2 (irregV "widersprechen" "widerspricht" "widersprach" "widerspräche" "widersprochen") datPrep ;
  widerstehen_dat_V2 = mkV2 (irregV "widerstehen" "widersteht" "widerstand" "widerstände" "widerstanden") datPrep ;
  widmen_dat_V3 = accdatV3 (regV "widmen")  ;
  wiederbeleben_V2 = dirV2 (prefixV "wieder" (regV "beleben"))  ;
  wiedererkennen_V2 = dirV2 (prefixV "wieder" (irregV "erkennen" "erkennt" "erkannte" "erkannte" "erkannt"))  ;
  wiedererlangen_V2 = dirV2 (prefixV "wieder" (regV "erlangen"))  ;
  wiedereroeffnen_V2 = dirV2 (prefixV "wieder" (regV "eröffnen"))  ;
  wiedergeben_dat_V3 = accdatV3 (prefixV "wieder" (irregV "geben" "gibt" "gab" "gäbe" "gegeben"))  ;
  wiederholen_rV = reflV (regV "wiederholen") accusative ;
  wiegen_V2 = dirV2 (regV "wiegen")  ;
  wiehern_V = regV "wiehern" ;
  wienern_V2 = dirV2 (regV "wienern")  ;
  wienern_V = regV "wienern" ;
  wieseln_dir_V2 = prepV2 (regV "wieseln") dir_Prep ;
  wildeln_V = regV "wildeln" ;
  wildern_V = regV "wildern" ;
  wimmern_V = regV "wimmern" ;
  wimmern_VS = mkVS (regV "wimmern")  ;
  windeln_V2 = dirV2 (regV "windeln")  ;
  winden_um_V3 = dirV3 (irregV "winden" "windet" "wand" "wände" "gewunden") um_Prep ;
  winken_dat_V2 = mkV2 (regV "winken") datPrep ;
  winken_dir_V3 = dirV3 (regV "winken") dir_Prep ;
  winseln_um_V2 = prepV2 (regV "winseln") um_Prep ;
  winseln_VS = mkVS (regV "winseln")  ;
  wippen_dir_V2 = prepV2 (regV "wippen") dir_Prep ;
  wirbeln_um_V2 = prepV2 (regV "wirbeln") um_Prep ;
  wirken_als_V2 = prepV2 (regV "wirken") (mkPrep "als" nominative) ;
  wirken_V2 = dirV2 (regV "wirken")  ;
  wischen_dir_V3 = dirV3 (regV "wischen") dir_Prep ;
  wischen_V2 = dirV2 (regV "wischen")  ;
  wispeln_V2 = dirV2 (regV "wispeln")  ;
  wispeln_VS = mkVS (regV "wispeln")  ;
  wispern_V2 = dirV2 (regV "wispern")  ;
  wispern_VS = mkVS (regV "wispern")  ;
  wissen_um_V2 = prepV2 (irregV "wissen" "weiß" "wußte" "wüßte" "gewußt") um_Prep ;
  wissen_V2 = dirV2 (irregV "wissen" "weiß" "wußte" "wüßte" "gewußt")  ;
  wittern_V2 = dirV2 (regV "wittern")  ;
  wittern_VS = mkVS (regV "wittern")  ;
  witzeln_VS = mkVS (regV "witzeln")  ;
  woelben_ueber_V3 = dirV3 (regV "wölben") (mkPrep "über" accusative) ;
  wogen_V = regV "wogen" ;
  wohlfuehlen_bei_rV2 = reflV2 (prefixV "wohl" (regV "fühlen")) accusative bei_Prep ;
  wohlfuehlen_rV = reflV (prefixV "wohl" (regV "fühlen")) accusative ;
  wohlwollen_dat_V2 = mkV2 (prefixV "wohl" (regV "wollen")) datPrep ;
  wohnen_loc_V2 = prepV2 (regV "wohnen") loc_Prep ;
  wollen_V2 = dirV2 (regV "wollen")  ;
  wollen_VS = mkVS (regV "wollen")  ;
  worfeln_V2 = dirV2 (regV "worfeln")  ;
  wringen_V2 = dirV2 (irregV "wringen" "wringt" "wrang" "wränge" "gewrungen")  ;
  wuchern_mit_V2 = prepV2 (regV "wuchern") mit_Prep ;
  wuchern_V = regV "wuchern" ;
  wuchten_dir_V3 = dirV3 (regV "wuchten") dir_Prep ;
  wuehlen_im_V2 = prepV2 (regV "wühlen") (mkPrep "in" dative) ;
  wuenschen_V2 = dirV2 (regV "wünschen")  ;
  wuenschen_VS = mkVS (regV "wünschen")  ;
  wuerdigen_V2 = dirV2 (regV "würdigen")  ;
  wuerdigen_VS = mkVS (regV "würdigen")  ;
  wuerfeln_um_V2 = prepV2 (regV "würfeln") um_Prep ;
  wuerfeln_V2 = dirV2 (regV "würfeln")  ;
  wuergen_V2 = dirV2 (regV "würgen")  ;
  wuergen_V = regV "würgen" ;
  wuerzen_V2 = dirV2 (regV "würzen")  ;
  wueten_V = regV "wüten" ;
  wulachen_V = regV "wulachen" ;
  wullacken_V = regV "wullacken" ;
  wundern_sV2 = dassV2 (regV "wundern") accPrep ;
  wundern_ueber_rV2 = reflV2 (regV "wundern") accusative (mkPrep "über" accusative) ;
  wundern_V2 = dirV2 (regV "wundern")  ;
  wuppen_V2 = dirV2 (regV "wuppen")  ;
  wuracken_V = regV "wuracken" ;
  wurmen_sV2 = dassV2 (regV "wurmen") accPrep ;
  wurmen_V2 = dirV2 (regV "wurmen")  ;
  wurschteln_am_V2 = prepV2 (regV "wurschteln") (mkPrep "an" dative) ;
  wurschten_am_V2 = prepV2 (regV "wurschten") (mkPrep "an" dative) ;
  wursteln_am_V2 = prepV2 (regV "wursteln") (mkPrep "an" dative) ;
  wuseln_dir_rV2 = reflV2 (regV "wuseln") accusative dir_Prep ;
  xerographieren_V2 = dirV2 (regV "xerographieren")  ;
  xerokopieren_V2 = dirV2 (regV "xerokopieren")  ;
  zackeln_V2 = dirV2 (regV "zackeln")  ;
  zacken_V2 = dirV2 (regV "zacken")  ;
  zaehlen_V2 = dirV2 (regV "zählen")  ;
  zaehmen_V2 = dirV2 (regV "zähmen")  ;
  zaehneln_V = regV "zähneln" ;
  zaenkeln_mit_V2 = prepV2 (regV "zänkeln") mit_Prep ;
  zaenkeln_plV = plV (regV "zänkeln")  ;
  zaeumen_V2 = dirV2 (regV "zäumen")  ;
  zaeunen_V2 = dirV2 (regV "zäunen")  ;
  zagen_V = regV "zagen" ;
  zahlen_an_fuer_V4 = dirV4 (regV "zahlen") (mkPrep "an" accusative) fuer_Prep ;
  zahlen_V2 = dirV2 (regV "zahlen")  ;
  zahnen_V = regV "zahnen" ;
  zanken_mit_ueber_rV3 = reflV3 (regV "zanken") accusative mit_Prep (mkPrep "über" accusative) ;
  zanken_mit_ueber_V3 = mkV3 (regV "zanken") mit_Prep (mkPrep "über" accusative) ;
  zanken_mit_um_rV3 = reflV3 (regV "zanken") accusative mit_Prep um_Prep ;
  zanken_mit_um_V3 = mkV3 (regV "zanken") mit_Prep um_Prep ;
  zanken_ueber_rV2 = reflV2 (regV "zanken") accusative (mkPrep "über" accusative) ;
  zanken_ueber_V2 = prepV2 (regV "zanken") (mkPrep "über" accusative) ;
  zanken_um_rV2 = reflV2 (regV "zanken") accusative um_Prep ;
  zanken_um_V2 = prepV2 (regV "zanken") um_Prep ;
  zapfen_V2 = dirV2 (regV "zapfen")  ;
  zaponieren_V2 = dirV2 (regV "zaponieren")  ;
  zappeln_V = regV "zappeln" ;
  zappen_V = regV "zappen" ;
  zaubern_V2 = dirV2 (regV "zaubern")  ;
  zaudern_VV = mkVV (regV "zaudern")  ;
  zechen_V = regV "zechen" ;
  zehnteln_V2 = dirV2 (regV "zehnteln")  ;
  zehren_von_V2 = prepV2 (regV "zehren") von_Prep ;
  zeichnen_V2 = dirV2 (regV "zeichnen")  ;
  zeichnen_VS = mkVS (regV "zeichnen")  ;
  zeigen_dat_V2S = mkV2S (regV "zeigen") datPrep ;
  zeigen_dat_V3 = accdatV3 (regV "zeigen")  ;
  zeihen_gen_V3 = dirV3 (irregV "zeihen" "zeiht" "zieh" "ziehe" "geziehen") genPrep ;
  zeihen_V2V = dirV2V (irregV "zeihen" "zeiht" "zieh" "ziehe" "geziehen")  ;
  zeitigen_V2 = dirV2 (regV "zeitigen")  ;
  zelebrieren_V2 = dirV2 (regV "zelebrieren")  ;
  zelebrieren_VS = mkVS (regV "zelebrieren")  ;
  zelten_V = regV "zelten" ;
  zementieren_V2 = dirV2 (regV "zementieren")  ;
  zensieren_V2 = dirV2 (regV "zensieren")  ;
  zensieren_VS = mkVS (regV "zensieren")  ;
  zentrifugieren_V2 = dirV2 (regV "zentrifugieren")  ;
  zerbeulen_V2 = dirV2 (regV "zerbeulen")  ;
  zerbrechen_V2 = dirV2 (irregV "zerbrechen" "zerbrecht" "zerbrach" "zerbräche" "zerbrochen")  ;
  zerbrechen_V = irregV "zerbrechen" "zerbrecht" "zerbrach" "zerbräche" "zerbrochen" ;
  zerbroeseln_V2 = dirV2 (regV "zerbröseln")  ;
  zerbroeseln_V = regV "zerbröseln" ;
  zerdeppern_V2 = dirV2 (regV "zerdeppern")  ;
  zerfallen_in_V2 = prepV2 (irregV "zerfallen" "zerfällt" "zerfiel" "zerfiele" "zerfallen") (mkPrep "in" accusative) ;
  zerfallen_V = irregV "zerfallen" "zerfällt" "zerfiel" "zerfiele" "zerfallen" ;
  zerfallen_zu_V2 = prepV2 (irregV "zerfallen" "zerfällt" "zerfiel" "zerfiele" "zerfallen") zu_Prep ;
  zerfen_am_V2 = prepV2 (regV "zerfen") (mkPrep "an" dative) ;
  zerfen_mit_V2 = prepV2 (regV "zerfen") mit_Prep ;
  zerfleddern_V2 = dirV2 (regV "zerfleddern")  ;
  zerfleischen_V2 = dirV2 (regV "zerfleischen")  ;
  zergen_V2 = dirV2 (regV "zergen")  ;
  zerkauen_V2 = dirV2 (regV "zerkauen")  ;
  zerkleinern_V2 = dirV2 (regV "zerkleinern")  ;
  zerkreuzen_V2 = dirV2 (regV "zerkreuzen")  ;
  zerlassen_V2 = dirV2 (irregV "zerlassen" "zerlasst" "zerließ" "zerließe" "zerlassen")  ;
  zerlegen_V2 = dirV2 (regV "zerlegen")  ;
  zernagen_V2 = dirV2 (regV "zernagen")  ;
  zernichten_V2 = dirV2 (irregV "zernichten" "zernichtet" "zernichtete" "zernichtete" "zernichtet")  ;
  zernieren_V2 = dirV2 (regV "zernieren")  ;
  zerpfluecken_V2 = dirV2 (regV "zerpflücken")  ;
  zerplatzen_V = regV "zerplatzen" ;
  zerreden_V2 = dirV2 (regV "zerreden")  ;
  zerreiben_V2 = dirV2 (irregV "zerreiben" "zerreibt" "zerrieb" "zerriebe" "zerrieben")  ;
  zerreissen_V2 = dirV2 (irregV "zerreißen" "zerreißt" "zerriss" "zerrisse" "zerrissen")  ;
  zerren_am_V2 = prepV2 (regV "zerren") (mkPrep "an" dative) ;
  zerschellen_am_V2 = prepV2 (regV "zerschellen") (mkPrep "an" dative) ;
  zerschlagen_V2 = dirV2 (irregV "zerschlagen" "zerschlägt" "zerschlug" "zerschlüge" "zerschlagen")  ;
  zerschmettern_V2 = dirV2 (irregV "zerschmettern" "zerschmettert" "zerschmetterte" "zerschmetterte" "zerschmettert")  ;
  zerschrammen_V2 = dirV2 (regV "zerschrammen")  ;
  zersetzen_V2 = dirV2 (irregV "zersetzen" "zersetzt" "zersetzte" "zersetzte" "zersetzt")  ;
  zerstaeuben_V2 = dirV2 (regV "zerstäuben")  ;
  zerstampfen_V2 = dirV2 (regV "zerstampfen")  ;
  zerstieben_plV = plV (irregV "zerstieben" "zerstiebt" "zerstob" "zerstöbe" "zerstoben")  ;
  zerstoeren_V2 = dirV2 (regV "zerstören")  ;
  zerstreiten_rV = reflV (irregV "zerstreiten" "zerstreitet" "zerstritt" "zerstritte" "zerstritten") accusative ;
  zerstreuen_rV = reflV (regV "zerstreuen") accusative ;
  zertifizieren_V2 = dirV2 (regV "zertifizieren")  ;
  zerven_V0 = mkV0 (regV "zerven")  ;
  zetern_VS = mkVS (regV "zetern")  ;
  zeugen_V2 = dirV2 (regV "zeugen")  ;
  ziehen_V2 = dirV2 (irregV "ziehen" "zieht" "zog" "zöge" "gezogen")  ;
  zielen_auf_V2 = prepV2 (regV "zielen") (mkPrep "auf" accusative) ;
  ziemen_rV = reflV (regV "ziemen") accusative ;
  ziepen_V = regV "ziepen" ;
  zieren_rVV = reflVV (regV "zieren") accusative ;
  zimmern_V2 = dirV2 (regV "zimmern")  ;
  zinken_V2 = dirV2 (regV "zinken")  ;
  zippen_V2 = dirV2 (regV "zippen")  ;
  zirkulieren_V = regV "zirkulieren" ;
  zischeln_V2 = dirV2 (regV "zischeln")  ;
  zischeln_VS = mkVS (regV "zischeln")  ;
  zischen_V2 = dirV2 (regV "zischen")  ;
  zischen_VS = mkVS (regV "zischen")  ;
  ziselieren_V2 = dirV2 (regV "ziselieren")  ;
  zitieren_V2 = dirV2 (regV "zitieren")  ;
  zitieren_VS = mkVS (regV "zitieren")  ;
  zittern_V = regV "zittern" ;
  zivilisieren_V2 = dirV2 (regV "zivilisieren")  ;
  zocken_mit_V2 = prepV2 (regV "zocken") mit_Prep ;
  zocken_V = regV "zocken" ;
  zoegern_VV = mkVV (regV "zögern")  ;
  zollen_dat_V3 = accdatV3 (regV "zollen")  ;
  zubereiten_V2 = dirV2 (prefixV "zu" (regV "bereiten"))  ;
  zubuttern_V2 = dirV2 (prefixV "zu" (regV "buttern"))  ;
  zuckeln_dir_V2 = prepV2 (regV "zuckeln") dir_Prep ;
  zucken_V = irregV "zucken" "zuckt" "zuckte" "zuckte" "zuckt" ;
  zuckern_V2 = dirV2 (regV "zuckern")  ;
  zudraengen_V0 = mkV0 (prefixV "zu" (regV "drängen"))  ;
  zuechten_V2 = dirV2 (regV "züchten")  ;
  zuechtigen_V2 = dirV2 (regV "züchtigen")  ;
  zuegeln_V2 = dirV2 (regV "zügeln")  ;
  zuendeln_mit_V2 = prepV2 (regV "zündeln") mit_Prep ;
  zuendeln_V = regV "zündeln" ;
  zuenden_V2 = dirV2 (regV "zünden")  ;
  zuengeln_am_V2 = prepV2 (regV "züngeln") (mkPrep "an" dative) ;
  zuernen_dat_V2 = mkV2 (regV "zürnen") datPrep ;
  zufriedenstellen_mit_V3 = dirV3 (prefixV "zufrieden" (regV "stellen")) mit_Prep ;
  zufuegen_dat_V3 = accdatV3 (prefixV "zu" (regV "fügen"))  ;
  zufuehren_V2 = dirV2 (prefixV "zu" (regV "führen"))  ;
  zugeben_VS = mkVS (prefixV "zu" (irregV "geben" "gibt" "gab" "gäbe" "gegeben"))  ;
  zugehen_dat_V2 = mkV2 (prefixV "zu" (irregV "gehen" "geht" "ging" "ging" "gegangen")) datPrep ;
  zugehen_es_VA = mkVA (prefixV "zu" (irregV "gehen" "geht" "ging" "ging" "gegangen"))  ;
  zugehen_VA = mkVA (prefixV "zu" (irregV "gehen" "geht" "ging" "ging" "gegangen"))  ;
  zugesellen_dat_rV2 = reflV2 (regV "zugesellen") accusative datPrep ;
  zuhoeren_dat_V2 = mkV2 (prefixV "zu" (regV "hören")) datPrep ;
  zuknoepfen_V2 = dirV2 (prefixV "zu" (regV "knöpfen"))  ;
  zulassen_VS = mkVS (prefixV "zu" (irregV "lassen" "lässt" "ließ" "ließe" "gelassen"))  ;
  zumachen_V2 = dirV2 (prefixV "zu" (regV "machen"))  ;
  zumuten_dat_V2S = mkV2S (prefixV "zu" (regV "muten")) datPrep ;
  zumuten_dat_V2V = mkV2V (prefixV "zu" (regV "muten")) datPrep ;
  zunaehen_V2 = dirV2 (prefixV "zu" (regV "nähen"))  ;
  zunehmen_V2 = dirV2 (prefixV "zu" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen"))  ;
  zunehmen_V = prefixV "zu" (irregV "nehmen" "nimmt" "nahm" "nähme" "genommen") ;
  zunichtemachen_V2 = dirV2 (prefixV "zunichte" (regV "machen"))  ;
  zuordnen_dat_V3 = accdatV3 (prefixV "zu" (regV "ordnen"))  ;
  zupfen_an_V2 = prepV2 (regV "zupfen") (mkPrep "an" accusative) ;
  zupfen_V2 = dirV2 (regV "zupfen")  ;
  zuraten_dat_zu_V3 = mkV3 (prefixV "zu" (irregV "raten" "rät" "riet" "riete" "geraten")) datPrep zu_Prep ;
  zurechtkommen_mit_V2 = prepV2 (prefixV "zurecht" (irregV "kommen" "kommt" "kam" "kam" "gekommen")) mit_Prep ;
  zurren_am_V2 = prepV2 (irregV "zurren" "zurrt" "zurrte" "zurrte" "zurrt") (mkPrep "an" dative) ;
  zurueckbekommen_V2 = dirV2 (prefixV "zurück" (irregV "bekommen" "bekommt" "bekam" "bekäme" "bekommen"))  ;
  zurueckbilden_rV = reflV (prefixV "zurück" (regV "bilden")) accusative ;
  zurueckbleiben_V = prefixV "zurück" (irregV "bleiben" "bleibt" "blieb" "bliebe" "geblieben") ;
  zurueckfuehren_auf_V3 = dirV3 (prefixV "zurück" (regV "führen")) (mkPrep "auf" accusative) ;
  zurueckgehen_auf_V2 = prepV2 (prefixV "zurück" (irregV "gehen" "geht" "ging" "ginge" "gegangen")) (mkPrep "auf" accusative) ;
  zurueckhalten_V2 = dirV2 (prefixV "zurück" (irregV "halten" "hält" "hielt" "hielte" "gehalten"))  ;
  zurueckkehren_V = prefixV "zurück" (regV "kehren") ;
  zurueckmelden_rV = reflV (prefixV "zurück" (regV "melden")) accusative ;
  zuruecktreten_V = prefixV "zurück" (irregV "treten" "tritt" "trat" "träte" "getreten") ;
  zurueckverfolgen_V2 = dirV2 (prefixV "zurück" (regV "verfolgen"))  ;
  zurueckzucken_V = prefixV "zurück" (regV "zucken") ;
  zusagen_dat_sV2 = dassV2 (prefixV "zu" (regV "sagen")) datPrep ;
  zusagen_dat_V2V = mkV2V (prefixV "zu" (regV "sagen")) datPrep ;
  zusammenarbeiten_mit_V2 = prepV2 (prefixV "zusammen" (regV "arbeiten")) mit_Prep ;
  zusammenfassen_V2 = dirV2 (prefixV "zusammen" (regV "fassen"))  ;
  zusammenfliessen_plV = plV (prefixV "zusammen" (irregV "fließen" "fließt" "floss" "flösse" "geflossen"))  ;
  zusammenhaengen_mit_V2 = prepV2 (prefixV "zusammen" (irregV "hängen" "hängt" "hing" "hinge" "gehangen")) mit_Prep ;
  zusammenhaengen_plV = plV (prefixV "zusammen" (irregV "hängen" "hängt" "hing" "hinge" "gehangen"))  ;
  zusammenklamuesern_V2 = dirV2 (prefixV "zusammen" (irregV "klamüsern" "klamüsert" "klamüserte" "klamüserte" "klamüsert"))  ;
  zusammenkratzen_V2 = dirV2 (prefixV "zusammen" (regV "kratzen"))  ;
  zusammenleben_plV = plV (prefixV "zusammen" (regV "leben"))  ;
  zusammenpressen_V2 = dirV2 (prefixV "zusammen" (regV "pressen"))  ;
  zusammenrechnen_V2 = dirV2 (prefixV "zusammen" (regV "rechnen"))  ;
  zusammensetzen_aus_rV2 = reflV2 (prefixV "zusammen" (regV "setzen")) accusative aus_Prep ;
  zusammensetzen_mit_rV2 = reflV2 (prefixV "zusammen" (regV "setzen")) accusative mit_Prep ;
  zusammensparen_V2 = dirV2 (prefixV "zusammen" (regV "sparen"))  ;
  zusammentrommeln_V2 = dirV2 (prefixV "zusammen" (regV "trommeln"))  ;
  zusammenwirken_mit_V2 = prepV2 (prefixV "zusammen" (regV "wirken")) mit_Prep ;
  zuschliessen_V2 = dirV2 (prefixV "zu" (irregV "schließen" "schließt" "schloss" "schlösse" "geschlossen"))  ;
  zuschreiben_dat_V3 = accdatV3 (prefixV "zu" (irregV "schreiben" "schreibt" "schrieb" "schriebe" "geschrieben"))  ;
  zuschuetten_V2 = dirV2 (prefixV "zu" (regV "schütten"))  ;
  zusehen_dat_bei_V3 = mkV3 (prefixV "zu" (irregV "sehen" "seht" "sah" "sähe" "gesehen")) datPrep bei_Prep ;
  zusehen_VS = mkVS (prefixV "zu" (irregV "sehen" "seht" "sah" "sähe" "gesehen"))  ;
  zusetzen_dat_V2 = mkV2 (prefixV "zu" (regV "setzen")) datPrep ;
  zusprechen_dat_V3 = accdatV3 (prefixV "zu" (irregV "sprechen" "spricht" "sprach" "spräche" "gesprochen"))  ;
  zusteigen_V = prefixV "zu" (irregV "steigen" "steigt" "stieg" "stiege" "gestiegen") ;
  zustimmen_dat_im_V3 = mkV3 (prefixV "zu" (regV "stimmen")) datPrep (mkPrep "in" dative) ;
  zustimmen_dat_V2 = mkV2 (prefixV "zu" (regV "stimmen")) datPrep ;
  zuteilwerden_dat_V2 = mkV2 (prefixV "zuteil" (irregV "werden" "wird" "wurde" "würde" "geworden")) datPrep ;
  zutragen_rV = reflV (prefixV "zu" (irregV "tragen" "trägt" "trug" "trüge" "getragen")) accusative ;
  zutreffen_sV = dassV (prefixV "zu" (irregV "treffen" "trifft" "traf" "träfe" "getroffen"))  ;
  zutschen_V = regV "zutschen" ;
  zutseln_V2 = dirV2 (regV "zutseln")  ;
  zuzeln_V2 = dirV2 (regV "zuzeln")  ;
  zwaengen_dir_V3 = dirV3 (regV "zwängen") dir_Prep ;
  zwangsbegluecken_V2 = dirV2 (prefixV "zwangs" (regV "beglücken"))  ;
  zweckentfremden_V2 = dirV2 (prefixV "zweck" (regV "entfremden"))  ;
  zweifeln_am_V2 = prepV2 (regV "zweifeln") (mkPrep "an" dative) ;
  zwicken_V2 = dirV2 (regV "zwicken")  ;
  zwiebeln_V2 = dirV2 (regV "zwiebeln")  ;
  zwingen_zu_V3 = dirV3 (irregV "zwingen" "zwingt" "zwang" "zwänge" "gezwungen") zu_Prep ;
  zwinkern_mit_V2 = prepV2 (regV "zwinkern") mit_Prep ;
  zwinkern_V = regV "zwinkern" ;
  zwirbeln_V2 = dirV2 (regV "zwirbeln")  ;
  zwirnen_V2 = dirV2 (regV "zwirnen")  ;
  zwirnen_V = regV "zwirnen" ;
  zwitschern_V = regV "zwitschern" ;
}
