concrete TopDictionaryJpn of TopDictionary = CatJpn, ResJpn[VerbGroup] ** open
  ParadigmsJpn, 
  (S = StructuralJpn),
  (L = LexiconJpn)
in {

flags coding = utf8 ;

lin of_Prep = ParadigmsJpn.mkPrep "の" ; -- 
lin and_Conj = S.and_Conj | ParadigmsJpn.mkConj "然して" ;
lin in_Prep = S.in_Prep ;
lin have_VV = mkVV "持つ" | mkVV "ある" | mkVV "いる" ;
lin have_V2 = S.have_V2 | mkV2 "持つ" | mkV2 "ある" | mkV2 "いる" ;
lin have_V = mkV "持つ" | mkV "ある" | mkV "いる" ;
lin it_Pron = S.it_Pron ;
lin to_Prep = S.to_Prep ;
lin for_Prep = S.for_Prep ;
lin i_Pron = S.i_Pron ;
lin iFem_Pron = S.i_Pron ;
lin that_Subj = S.that_Subj ;
lin he_Pron = S.he_Pron ;
lin on_Prep = S.on_Prep ;
lin with_Prep = S.with_Prep ;
lin do_V2 = mkV2 "する" | mkV2 "やる" | mkV2 "なさる" | mkV2 "致す" ;
lin at_Prep = ParadigmsJpn.mkPrep "に" | ParadigmsJpn.mkPrep "で" ;
lin by_Prep = S.by8means_Prep | S.by8agent_Prep ;
lin but_Conj = ParadigmsJpn.mkConj "が" | ParadigmsJpn.mkConj "でも" ;
lin from_Prep = S.from_Prep ;
lin they_Pron = S.they_Pron ;
lin theyFem_Pron = S.they_Pron ; 
lin she_Pron = S.she_Pron ;
lin or_Conj = S.or_Conj | ParadigmsJpn.mkConj "または" | ParadigmsJpn.mkConj "あるいは" | ParadigmsJpn.mkConj "か" | ParadigmsJpn.mkConj "それとも" ;
lin as_Subj = variants{} ; -- 
lin we_Pron = S.we_Pron ;
lin weFem_Pron = S.we_Pron ; -- 
lin say_VS = L.say_VS | mkVS "いとまごいをする" | mkVS "別れを告げる" | mkVS "告別する" ;
lin say_V2 = mkV2 "いとまごいをする" | mkV2 "別れを告げる" | mkV2 "告別する" ;
lin say_V = mkV "いとまごいをする" | mkV "別れを告げる" | mkV "告別する" ;
lin if_Subj = S.if_Subj ;
lin go_VV = mkgoVV ;
lin go_VA = L.go_V ;
lin go_V = L.go_V ;
lin get_V2 = mkV2 "受ける" | mkV2 "得る" | mkV2 "受ける" | mkV2 "買う" | mkV2 "受け取る" | mkV2 "もらう" | mkV2 "してもらう" ;
lin get_VV = mkVV "受ける" | mkVV "得る" | mkVV "受ける" | mkVV "買う" | mkVV "受け取る" | mkVV "もらう" | mkVV "してもらう" ;
lin get_V2V = mkV2V "受ける" | mkV2V "得る" | mkV2V "受ける" | mkV2V "買う" | mkV2V "受け取る" | mkV2V "もらう" | mkV2V "してもらう" ;
lin make_V2V = mkV2V "生計を立てる" | mkV2V "食べていく" ;
lin make_V2A = mkV2A "生計を立てる" | mkV2A "食べていく" ;
lin make_V2 = mkV2 "生計を立てる" | mkV2 "食べていく" ;
lin make_V = mkV "生計を立てる" | mkV "食べていく" ;
lin as_Prep = ParadigmsJpn.mkPrep "として" ; -- 
lin out_Adv = ParadigmsJpn.mkAdv "外に" | ParadigmsJpn.mkAdv "留主" ;
lin up_Adv = ParadigmsJpn.mkAdv "上に" ;
lin see_VS = mkVS "見送る" | mkVS "歓送する" ;
lin see_VQ = mkVQ "見送る" | mkVQ "歓送する" ;
lin see_V2V = mkV2V "見送る" | mkV2V "歓送する" ;
lin see_V2 = L.see_V2 | mkV2 "見送る" | mkV2 "歓送する" ;
lin see_V = mkV "見送る" | mkV "歓送する" ;
lin know_VS = L.know_VS | mkVS "知っている" | mkVS "精通している" ;
lin know_VQ = L.know_VQ | mkVQ "知っている" | mkVQ "精通している" ;
lin know_V2 = L.know_V2 | mkV2 "知っている" | mkV2 "精通している" ;
lin know_V = mkV "知っている" | mkV "精通している" ;
lin time_N = mkN "時間" ;
lin time_2_N = variants{} ; -- 
lin time_1_N = variants{} ; -- 
lin take_V2 = mkV2 "気を付ける" ;
lin so_Adv = ParadigmsJpn.mkAdv "今まで" | ParadigmsJpn.mkAdv "これまで" | ParadigmsJpn.mkAdv "これまでのところ" ;
lin year_N = L.year_N | mkN "学年" ;
lin into_Prep = ParadigmsJpn.mkPrep "中に" ; -- 
lin then_Adv = ParadigmsJpn.mkAdv "その時" | ParadigmsJpn.mkAdv "その時点" ;
lin think_VS = mkVS "考える" | mkVS "意図する" ;
lin think_V2 = mkV2 "考える" | mkV2 "意図する" ;
lin think_V = L.think_V | mkV "考える" | mkV "意図する" ;
lin come_V = L.come_V | mkV "戻る" | mkV "帰る" ;
lin than_Subj = variants{} ; -- 
lin more_Adv = ParadigmsJpn.mkAdv "ますます" | ParadigmsJpn.mkAdv "更に" ;
lin about_Prep = S.on_Prep ;
lin now_Adv = L.now_Adv | ParadigmsJpn.mkAdv "今" ;
lin last_A = mkA "最後の" | mkA "最後" | mkA "最終的" | mkA "終わり" ;
lin last_1_A = variants{} ; -- 
lin last_2_A = variants{} ; -- 
lin other_A = mkA "他の" | mkA "別の" ;
lin give_V3 = L.give_V3 | mkV3 "あげる" | mkV3 "下さる" | mkV3 "差し上げる" | mkV3 "くれる" ;
lin give_V2 = mkV2 "あげる" | mkV2 "下さる" | mkV2 "差し上げる" | mkV2 "くれる" ;
lin give_V = mkV "あげる" | mkV "下さる" | mkV "差し上げる" | mkV "くれる" ;
lin just_Adv = ParadigmsJpn.mkAdv "念のため" ;
lin people_N = mkN "人々" | mkN "人達" | mkN "人" ;
lin also_Adv = ParadigmsJpn.mkAdv "も" | ParadigmsJpn.mkAdv "また" | ParadigmsJpn.mkAdv "さらに" | ParadigmsJpn.mkAdv "にも" ;
lin well_Adv = ParadigmsJpn.mkAdv "よく" ; -- 
lin only_Adv = ParadigmsJpn.mkAdv "だけ" ;
lin new_A = L.new_A | mkA "新しい" ;
lin when_Subj = S.when_Subj ;
lin way_N = mkN "入り口" | mkN "道" | mkN "方法" ;
lin way_2_N = variants{} ; -- 
lin way_1_N = variants{} ; -- 
lin look_VA = mkVA "見える" ;
lin look_V2 = mkV2 "見る" | mkV2 "世話をする" | mkV2 "面倒を見る" ;
lin look_V = mkV "世話をする" | mkV "面倒を見る" ;
lin like_Prep = ParadigmsJpn.mkPrep "のような" ; -- 
lin use_VV = mkVV "用いる" | mkVV "使う" | mkVV "使用する" ;
lin use_V2 = mkV2 "用いる" | mkV2 "使う" | mkV2 "使用する" ;
lin use_V = mkV "用いる" | mkV "使う" | mkV "使用する" ;
lin because_Subj = S.because_Subj ;
lin good_A = L.good_A | mkA "良い" | mkA "いい" | mkA "善意の" ;
lin find_VS = mkVS "評決する" ;
lin find_V2A = mkV2A "評決する" ;
lin find_V2 = L.find_V2 | mkV2 "評決する" ;
lin find_V = mkV "評決する" ;
lin man_N = L.man_N | mkN "男性" | mkN "男の人" | mkN "男" ;
lin want_VV = S.want_VV | mkVV "欲しい" | mkVV "欲する" | mkVV "望む" | mkVV "...たい" | mkVV "...たがる" ;
lin want_V2V = mkV2V "欲しい" | mkV2V "欲する" | mkV2V "望む" | mkV2V "...たい" | mkV2V "...たがる" ;
lin want_V2 = mkV2 "欲しい" | mkV2 "欲する" | mkV2 "望む" | mkV2 "...たい" | mkV2 "...たがる" ;
lin want_V = mkV "欲しい" | mkV "欲する" | mkV "望む" | mkV "...たい" | mkV "...たがる" ;
lin day_N = L.day_N | mkN "明後日" | mkN "明後日" ;
lin between_Prep = S.between_Prep ;
lin even_Adv = ParadigmsJpn.mkAdv "さえ" | ParadigmsJpn.mkAdv "にも" | ParadigmsJpn.mkAdv "も" ;
lin there_Adv = S.there_Adv | ParadigmsJpn.mkAdv "そこ" | ParadigmsJpn.mkAdv "あそこ" ;
lin many_Det = S.many_Det | ParadigmsJpn.mkDet "多くの" | ParadigmsJpn.mkDet "多い" | ParadigmsJpn.mkDet "沢山" ;
lin after_Prep = S.after_Prep ;
lin down_Adv = ParadigmsJpn.mkAdv "下りの" ;
lin yeah_Interj = mkInterj "やった" ;
lin so_Subj = variants{} ; -- 
lin thing_N = mkN "物" ;
lin tell_VS = mkVS "教える" | mkVS "言う" | mkVS "述べる" ;
lin tell_V3 = mkV3 "教える" | mkV3 "言う" | mkV3 "述べる" ;
lin tell_1_V3 = variants{} ; -- 
lin tell_2_V3 = variants{} ; -- 
lin tell_V2V = mkV2V "教える" | mkV2V "言う" | mkV2V "述べる" ;
lin tell_V2S = mkV2S "教える" | mkV2S "言う" | mkV2S "述べる" ;
lin tell_V2 = mkV2 "教える" | mkV2 "言う" | mkV2 "述べる" ;
lin tell_V = mkV "教える" | mkV "言う" | mkV "述べる" ;
lin through_Prep = S.through_Prep ;
lin back_Adv = ParadigmsJpn.mkAdv "戻り" | ParadigmsJpn.mkAdv "元の" | ParadigmsJpn.mkAdv "元通り" | ParadigmsJpn.mkAdv "以前の" ;
lin still_Adv = ParadigmsJpn.mkAdv "まだ" | ParadigmsJpn.mkAdv "それでも" ;
lin child_N = L.child_N | mkN "子供" | mkN "子" ;
lin here_Adv = ParadigmsJpn.mkAdv "ここに" | ParadigmsJpn.mkAdv "ここで" | ParadigmsJpn.mkAdv "ここ" ;
lin over_Prep = ParadigmsJpn.mkPrep "上に" ; -- 
lin too_Adv = ParadigmsJpn.mkAdv "-も" | ParadigmsJpn.mkAdv "また" | ParadigmsJpn.mkAdv "さらに" | ParadigmsJpn.mkAdv "" | ParadigmsJpn.mkAdv "にも" ;
lin put_V2 = L.put_V2 | mkV2 "置く" | mkV2 "据える" ;
lin on_Adv = ParadigmsJpn.mkAdv "四つん這いで" | ParadigmsJpn.mkAdv "四つんばいで" ;
lin no_Interj = mkInterj "ノーコメント" | mkInterj "何も言うことはありません" ;
lin work_V2 = mkV2 "起こす" ;
lin work_V = mkV "起こす" | mkV "仕事する" | mkV "働く" ;
lin work_2_V = variants{} ; -- 
lin work_1_V = variants{} ; -- 
lin become_VA = L.become_VA | mkVA "成る" ;
lin become_V2 = mkV2 "...になる" | mkV2 "...となる" | mkV2 "成る" ;
lin become_V = mkV "...になる" | mkV "...となる" | mkV "成る" ;
lin old_A = L.old_A | mkA "昔風" | mkA "旧弊" | mkA "古臭い" ;
lin government_N = mkN "政府" ; -- 
lin mean_VV = mkVV "意味する" ;
lin mean_VS = mkVS "意味する" ;
lin mean_V2V = mkV2V "意味する" ;
lin mean_V2 = mkV2 "意味する" ;
lin part_N = mkN "一部" | mkN "部分" ;
lin leave_V2V = mkV2V "残す" ;
lin leave_V2 = L.leave_V2 | mkV2 "残す" ;
lin leave_V = mkV "残す" ;
lin life_N = mkN "命" | mkN "人生" | mkN "生存" ;
lin great_A = mkA "大王" ;
lin case_N = mkN "箱" ;
lin woman_N = L.woman_N | mkN "女の人" | mkN "女" | mkN "女性" ;
lin over_Adv = ParadigmsJpn.mkAdv "ここ" ;
lin seem_VV = mkVV "らしい" | mkVV "そう" | mkVV "ように見える" ;
lin seem_VS = mkVS "らしい" | mkVS "そう" | mkVS "ように見える" ;
lin seem_VA = mkVA "らしい" | mkVA "そう" | mkVA "ように見える" ;
lin work_N = mkN "労力" | mkN "労働" | mkN "作業" ;
lin need_VV = mkVV "してはいけない" ;
lin need_VV = mkVV "してはいけない" ;
lin need_V2 = mkV2 "してはいけない" ;
lin need_V = mkV "してはいけない" ;
lin feel_VS = mkVS "感じる" ;
lin feel_VA = mkVA "感じる" ;
lin feel_V2 = mkV2 "感じる" ;
lin feel_V = mkV "感じる" ResJpn.Gr2 ;
lin system_N = mkN "系統" | mkN "系" | mkN "制度" ;
lin each_Det = ParadigmsJpn.mkDet "それぞれの" ;
lin may_2_VV = mkVV "かもしれない" ; -- 
lin may_1_VV = variants{} ; -- 
lin much_Adv = ParadigmsJpn.mkAdv "沢山の" | ParadigmsJpn.mkAdv "多い" ;
lin ask_VQ = mkVQ "頼む" ;
lin ask_V2V = mkV2V "頼む" ;
lin ask_V2 = mkV2 "頼む" ;
lin ask_V = mkV "頼む" ;
lin group_N = mkN "群作用" ;
lin number_N = L.number_N | mkN "数" | mkN "数字" ;
lin number_3_N = variants{} ; -- 
lin number_2_N = variants{} ; -- 
lin number_1_N = variants{} ; -- 
lin yes_Interj = mkInterj "よし" | mkInterj "やった" ;
lin however_Adv = ParadigmsJpn.mkAdv "しかし" | ParadigmsJpn.mkAdv "が" | ParadigmsJpn.mkAdv "でも" | ParadigmsJpn.mkAdv "けれども" | ParadigmsJpn.mkAdv "けれど" | ParadigmsJpn.mkAdv "けども" | ParadigmsJpn.mkAdv "けど" ;
lin another_Det = ParadigmsJpn.mkDet "他の" | ParadigmsJpn.mkDet "別の" ;
lin again_Adv = ParadigmsJpn.mkAdv "何度も" ;
lin world_N = mkN "ワールドカップ" ;
lin area_N = mkN "面積" ;
lin area_6_N = variants{} ; -- 
lin area_5_N = variants{} ; -- 
lin area_4_N = variants{} ; -- 
lin area_3_N = variants{} ; -- 
lin area_2_N = variants{} ; -- 
lin area_1_N = variants{} ; -- 
lin show_VS = mkVS "見せる" | mkVS "示す" | mkVS "表す" ;
lin show_VQ = mkVQ "見せる" | mkVQ "示す" | mkVQ "表す" ;
lin show_V2 = mkV2 "見せる" | mkV2 "示す" | mkV2 "表す" ;
lin show_V = mkV "見せる" | mkV "示す" | mkV "表す" ;
lin course_N = mkN "コース" | mkN "課程" ;
lin company_2_N = mkN "会社" | mkN "企業" ; -- 
lin company_1_N = variants{} ; -- 
lin under_Prep = S.under_Prep ;
lin problem_N = mkN "問題" ;
lin against_Prep = ParadigmsJpn.mkPrep "に対して" ; -- 
lin never_Adv = ParadigmsJpn.mkAdv "決して" | ParadigmsJpn.mkAdv "何時でも" | ParadigmsJpn.mkAdv "曾て" | ParadigmsJpn.mkAdv "万々" ;
lin most_Adv = ParadigmsJpn.mkAdv "最も" | ParadigmsJpn.mkAdv "最" | ParadigmsJpn.mkAdv "一番" ;
lin service_N = mkN "サービス" ;
lin try_VV = mkVV "試着する" ;
lin try_V2 = mkV2 "試着する" ;
lin try_V = mkV "試着する" ;
lin call_V2 = mkV2 "ありのまま言う" ;
lin call_V = mkV "ありのまま言う" ;
lin hand_N = L.hand_N | mkN "喝采" ;
lin party_N = mkN "パーティー" | mkN "宴会" ;
lin party_2_N = mkN "政党" | mkN "公党" ; -- 
lin party_1_N = variants{} ; -- 
lin high_A = mkA "高級な" ;
lin about_Adv = variants{}; -- S.on_Prep ;
lin something_NP = S.something_NP ;
lin school_N = L.school_N | mkN "群れ" | mkN "魚群" ;
lin in_Adv = ParadigmsJpn.mkAdv "内側に" ;
lin in_1_Adv = variants{} ; -- 
lin in_2_Adv = variants{} ; -- 
lin small_A = L.small_A | mkA "小さい" ;
lin place_N = mkN "役目" | mkN "役割" | mkN "居場所" | mkN "境遇" | mkN "環境" | mkN "立場" | mkN "位置" | mkN "身分" | mkN "地位" | mkN "役職" | mkN "職" | mkN "仕事" ;
lin before_Prep = S.before_Prep ;
lin while_Subj = variants{} ; -- 
lin away_Adv = ParadigmsJpn.mkAdv "離れて" | ParadigmsJpn.mkAdv "あちらへ" | ParadigmsJpn.mkAdv "わきへ" ; -- 
lin away_2_Adv = variants{} ; -- 
lin away_1_Adv = variants{} ; -- 
lin keep_VV = mkVV "目をつけている" ;
lin keep_V2A = mkV2A "目をつけている" ;
lin keep_V2 = mkV2 "目をつけている" ;
lin keep_V = mkV "目をつけている" ;
lin point_N = mkN "点" ;
lin point_2_N = variants{} ; -- 
lin point_1_N = variants{} ; -- 
lin house_N = L.house_N | mkN "家" | mkN "建物" | mkN "家屋" | mkN "一戸建て" | mkN "お宅" | mkN "お住まい" ;
lin different_A = mkA "異なる" | mkA "違う" ;
lin country_N = L.country_N | mkN "田舎者" | mkN "お上り様" ;
lin really_Adv = ParadigmsJpn.mkAdv "本当に" ; -- 
lin provide_V2 = mkV2 "供給する" ;
lin provide_V = mkV "供給する" ;
lin week_N = mkN "週" | mkN "週間" ;
lin hold_VS = mkVS "どっこい" ;
lin hold_V2 = L.hold_V2 | mkV2 "どっこい" ;
lin hold_V = mkV "どっこい" ;
lin large_A = mkA "大きい" ;
lin member_N = mkN "会員" | mkN "メンバー" | mkN "構成員" ;
lin off_Adv = variants{} ; -- 
lin always_Adv = ParadigmsJpn.mkAdv "いつも" ;
lin follow_VS = mkVS "付いて行く" | mkVS "従う" ;
lin follow_V2 = mkV2 "付いて行く" | mkV2 "従う" ;
lin follow_V = mkV "付いて行く" | mkV "従う" ;
lin without_Prep = S.without_Prep ;
lin turn_VA = mkVA "見て見ぬふりをする" ;
lin turn_V2 = mkV2 "見て見ぬふりをする" ;
lin turn_V = L.turn_V | mkV "見て見ぬふりをする" ;
lin end_N = mkN "終了" | mkN "終わり" | mkN "端" ;
lin end_2_N = variants{} ; -- 
lin end_1_N = variants{} ; -- 
lin within_Prep = variants{} ; -- 
lin local_A = mkA "局所" ;
lin where_Subj = variants{} ; -- 
lin during_Prep = S.during_Prep ;
lin bring_V3 = mkV3 "生計を立てる" | mkV3 "食べていく" ;
lin bring_V2 = mkV2 "生計を立てる" | mkV2 "食べていく" ;
lin most_Det = ParadigmsJpn.mkDet "大部分" ;
lin word_N = mkN "1980年代" | mkN "80s" ;
lin begin_V2 = mkV2 "始める" | mkV2 "開始する" | mkV2 "始まる" ;
lin begin_V = mkV "始める" | mkV "開始する" | mkV "始まる" ;
lin although_Subj = S.although_Subj ;
lin example_N = mkN "例" | mkN "例え" | mkN "例題" ;
lin next_Adv = ParadigmsJpn.mkAdv "次に" ; -- 
lin family_N = mkN "家業" ;
lin rather_Adv = ParadigmsJpn.mkAdv "寧ろ" | ParadigmsJpn.mkAdv "むしろ" | ParadigmsJpn.mkAdv "一層" ;
lin fact_N = mkN "事実" ;
lin like_VV = mkVV "好き" | mkVV "好く" | mkVV "好む" ;
lin like_VS = mkVS "好き" | mkVS "好く" | mkVS "好む" ;
lin like_V2 = L.like_V2 | mkV2 "好き" | mkV2 "好く" | mkV2 "好む" ;
lin social_A = mkA "社会的な" | mkA "社会の" | mkA "同志的な" ; -- 
lin write_VS = mkVS "値引きする" ;
lin write_V2 = L.write_V2 | mkV2 "値引きする" ;
lin write_V = mkV "値引きする" ;
lin state_N = mkN "状態" | mkN "模様" ;
lin state_2_N = mkN "国家" ; -- 
lin state_1_N = mkN "州" ; -- 
lin percent_N = mkN "パーセント" ;
lin quite_Adv = ParadigmsJpn.mkAdv "すっかり" | ParadigmsJpn.mkAdv "丸で" ;
lin both_Det = ParadigmsJpn.mkDet "両方" | ParadigmsJpn.mkDet "両-" | ParadigmsJpn.mkDet "どちらも" | ParadigmsJpn.mkDet "双方" ;
lin start_V2 = mkV2 "始まる" ;
lin start_V = mkV "始まる" ;
lin run_V2 = mkV2 "走る" ;
lin run_V = L.run_V | mkV "走る" ;
lin long_A = L.long_A | mkA "長い" ;
lin right_Adv = ParadigmsJpn.mkAdv "右に" ;
lin right_2_Adv = ParadigmsJpn.mkAdv "正しく" ; -- 
lin right_1_Adv = variants{} ; -- 
lin set_V2 = mkV2 "セットする" ;
lin help_V2V = mkV2V "助ける" | mkV2V "手伝う" ;
lin help_V2 = mkV2 "助ける" | mkV2 "手伝う" ;
lin help_V = mkV "助ける" | mkV "手伝う" ;
lin every_Det = S.every_Det | ParadigmsJpn.mkDet "あらゆる" | ParadigmsJpn.mkDet "全ての" | ParadigmsJpn.mkDet "それぞれ" | ParadigmsJpn.mkDet "おのおの" | ParadigmsJpn.mkDet "…毎に" | ParadigmsJpn.mkDet "毎" | ParadigmsJpn.mkDet "各" ;
lin home_N = mkN "故郷" | mkN "実家" ;
lin month_N = mkN "月" ;
lin side_N = mkN "辺" | mkN "境界線" ;
lin night_N = L.night_N | mkN "闇" ;
lin important_A = L.important_A | mkA "重要な" | mkA "大切な" ;
lin eye_N = L.eye_N | mkN "目" | mkN "眼" ;
lin head_N = L.head_N | mkN "頭状花" ;
lin information_N = mkN "情報" ;
lin question_N = L.question_N | mkN "質問" ;
lin business_N = mkN "ビジネスアナリスト" ;
lin play_V2 = L.play_V2 | mkV2 "遊ぶ" ;
lin play_V = L.play_V | mkV "遊ぶ" ;
lin play_3_V2 = variants{} ; -- 
lin play_3_V = variants{} ; -- 
lin play_2_V2 = variants{} ; -- 
lin play_2_V = variants{} ; -- 
lin play_1_V2 = variants{} ; -- 
lin play_1_V = variants{} ; -- 
lin power_N = mkN "能天使" ;
lin money_N = mkN "お金" | mkN "貨幣" ;
lin change_N = mkN "お釣り" | mkN "つり銭" | mkN "小銭" ;
lin move_V2 = mkV2 "動く" ;
lin move_V = mkV "動く" ;
lin move_2_V = variants{} ; -- 
lin move_1_V = variants{} ; -- 
lin interest_N = mkN "興味" | mkN "関心" ;
lin interest_4_N = variants{} ; -- 
lin interest_2_N = variants{} ; -- 
lin interest_1_N = variants{} ; -- 
lin order_N = mkN "次" ;
lin book_N = L.book_N | mkN "本" | mkN "書籍" ;
lin often_Adv = ParadigmsJpn.mkAdv "よく" | ParadigmsJpn.mkAdv "度々" | ParadigmsJpn.mkAdv "頻繁に" | ParadigmsJpn.mkAdv "しばしば" ;
lin development_N = mkN "発展" | mkN "開発" ;
lin young_A = L.young_A | mkA "若い" ;
lin national_A = mkA "国家の" | mkA "国民の" | mkA "国立の" ;
lin pay_V3 = mkV3 "払う" | mkV3 "支払う" ;
lin pay_V2V = mkV2V "払う" | mkV2V "支払う" ;
lin pay_V2 = mkV2 "払う" | mkV2 "支払う" ;
lin pay_V = mkV "払う" | mkV "支払う" ;
lin hear_VS = mkVS "聞く" ;
lin hear_V2V = mkV2V "聞く" ;
lin hear_V2 = L.hear_V2 | mkV2 "聞く" ;
lin hear_V = mkV "聞く" ;
lin room_N = mkN "部屋" ;
lin room_1_N = variants{} ; -- 
lin room_2_N = variants{} ; -- 
lin whether_Subj = variants{} ; -- 
lin water_N = L.water_N | mkN "水" ;
lin form_N = mkN "用紙" ;
lin car_N = L.car_N | mkN "車" | mkN "自動車" ;
lin other_N = mkN "他" | mkN "別" ;
lin yet_Adv = ParadigmsJpn.mkAdv "まだ" ;
lin yet_2_Adv = variants{} ; -- 
lin yet_1_Adv = variants{} ; -- 
lin perhaps_Adv = ParadigmsJpn.mkAdv "多分" | ParadigmsJpn.mkAdv "若しや" | ParadigmsJpn.mkAdv "かもしれない" | ParadigmsJpn.mkAdv "でしょう" ;
lin meet_V2 = mkV2 "会う" | mkV2 "遭遇する" | mkV2 "遭う" | mkV2 "お目にかかる" ;
lin meet_V = mkV "会う" | mkV "遭遇する" | mkV "遭う" | mkV "お目にかかる" ;
lin level_N = mkN "踏切" ;
lin level_2_N = variants{} ; -- 
lin level_1_N = variants{} ; -- 
lin until_Subj = variants{} ; -- 
lin though_Subj = variants{} ; -- 
lin policy_N = mkN "契約内容" | mkN "規約" ;
lin include_V2 = mkV2 "含む" ;
lin include_V = mkV "含む" ;
lin believe_VS = mkVS "信じる" ;
lin believe_V2 = mkV2 "信じる" ;
lin believe_V = mkV "信じる" ;
lin council_N = mkN "評定" | mkN "評議会" ; -- 
lin already_Adv = L.already_Adv | ParadigmsJpn.mkAdv "既に" | ParadigmsJpn.mkAdv "もう" | ParadigmsJpn.mkAdv "もはや" | ParadigmsJpn.mkAdv "とっくに" ;
lin possible_A = mkA "可能な" ;
lin nothing_NP = S.nothing_NP ;
lin line_N = mkN "視線" ;
lin allow_V2V = mkV2V "許す" ;
lin allow_V2 = mkV2 "許す" ;
lin need_N = mkN "必要" ;
lin effect_N = mkN "音響効果" ;
lin big_A = L.big_A | mkA "大人" | mkA "成人" ;
lin use_N = mkN "使用" | mkN "利用" ;
lin lead_V2V = mkV2V "率いる" ;
lin lead_V2 = mkV2 "率いる" ;
lin lead_V = mkV "率いる" ;
lin stand_V2 = mkV2 "形式張る" | mkV2 "遠慮する" ;
lin stand_V = L.stand_V | mkV "形式張る" | mkV "遠慮する" ;
lin idea_N = mkN "ちゃくそう" | mkN "考え" | mkN "主意" ;
lin study_N = mkN "学習" | mkN "勉強" ;
lin lot_N = mkN "宿命" ;
lin live_V = L.live_V | mkV "生きる" | mkV "暮らす" ;
lin job_N = mkN "仕事" | mkN "ジョブ" | mkN "バイト" ;
lin since_Subj = variants{} ; -- 
lin name_N = L.name_N | mkN "聖名祝日" ;
lin result_N = mkN "成果" ;
lin body_N = mkN "物体" ;
lin happen_VV = mkVV "起こる" | mkVV "起る" ;
lin happen_V = mkV "起こる" | mkV "起る" ;
lin friend_N = L.friend_N | mkN "彼氏 {m}" | mkN "彼女 {f}" ;
lin right_N = mkN "直角" ;
lin least_Adv = ParadigmsJpn.mkAdv "最低" ; -- 
lin right_A = mkA "直角の" ;
lin right_2_A = mkA "右の" ; -- 
lin right_1_A = variants{} ; -- 
lin almost_Adv = ParadigmsJpn.mkAdv "ほとんど" ;
lin much_Det = S.much_Det | ParadigmsJpn.mkDet "沢山" | ParadigmsJpn.mkDet "多くの" | ParadigmsJpn.mkDet "多い" ;
lin carry_V2 = mkV2 "持って行く" | mkV2 "運ぶ" ;
lin carry_V = mkV "持って行く" | mkV "運ぶ" ;
lin authority_N = mkN "権威" ;
lin authority_2_N = variants{} ; -- 
lin authority_1_N = variants{} ; -- 
lin long_Adv = variants{} ; -- 
lin early_A = mkA "早い" ;
lin view_N = mkN "景色" ;
lin view_2_N = variants{} ; -- 
lin view_1_N = variants{} ; -- 
lin public_A = mkA "公衆の" ;
lin together_Adv = ParadigmsJpn.mkAdv "一緒に" ;
lin talk_V2 = mkV2 "意思疎通する" ;
lin talk_V = mkV "意思疎通する" ;
lin report_N = mkN "成績表" ;
lin after_Subj = variants{} ; -- 
lin only_Predet = S.only_Predet ;
lin before_Subj = variants{} ; -- 
lin bit_N = mkN "ビット" ;
lin face_N = mkN "表情" ;
lin sit_V2 = mkV2 "座る" | mkV2 "腰掛ける" ;
lin sit_V = L.sit_V | mkV "座る" | mkV "腰掛ける" ;
lin market_N = mkN "市場経済" ;
lin market_1_N = variants{} ; -- 
lin market_2_N = variants{} ; -- 
lin appear_VV = mkVV "現れる" ;
lin appear_VS = mkVS "現れる" ;
lin appear_VA = mkVA "現れる" ;
lin appear_V = mkV "現れる" ;
lin continue_VV = mkVV "続く" ;
lin continue_V2 = mkV2 "続く" ;
lin continue_V = mkV "続く" ;
lin able_A = mkA "有資格の" ;
lin political_A = mkA "政治的" ;
lin later_Adv = ParadigmsJpn.mkAdv "後で" ;
lin hour_N = mkN "時" | mkN "時間" ;
lin rate_N = mkN "級" ;
lin law_N = mkN "治安" | mkN "公安" ;
lin law_2_N = variants{} ; -- 
lin law_1_N = variants{} ; -- 
lin door_N = L.door_N | mkN "戸" | mkN "扉" | mkN "ドア" ;
lin court_N = mkN "中庭" | mkN "庭" ;
lin court_2_N = variants{} ; -- 
lin court_1_N = variants{} ; -- 
lin office_N = mkN "事務所" | mkN "オフィス" | mkN "執務室" | mkN "事務室" ;
lin let_V2V = mkV2V "放っておく" | mkV2V "ほっとく" ;
lin war_N = L.war_N | mkN "戦争" | mkN "戦" ;
lin produce_V2 = mkV2 "生産する" ;
lin produce_V = mkV "生産する" ;
lin reason_N = L.reason_N | mkN "理由" | mkN "訳" ;
lin less_Adv = ParadigmsJpn.mkAdv "それほど...ない" ;
lin minister_N = mkN "大臣" ;
lin minister_2_N = variants{} ; -- 
lin minister_1_N = variants{} ; -- 
lin subject_N = mkN "主語" ;
lin subject_2_N = variants{} ; -- 
lin subject_1_N = variants{} ; -- 
lin person_N = L.person_N | mkN "法人" ;
lin term_N = mkN "学期" ;
lin particular_A = mkA "特定の" ; -- 
lin full_A = L.full_A | mkA "完全" ;
lin involve_VS = variants{} ; -- 
lin involve_V2 = variants{} ; -- 
lin involve_V = variants{} ; -- 
lin sort_N = mkN "並べ替え" | mkN "ソート" ;
lin require_VS = mkVS "要求する" ;
lin require_V2V = mkV2V "要求する" ;
lin require_V2 = mkV2 "要求する" ;
lin require_V = mkV "要求する" ;
lin suggest_VS = mkVS "提案する" | mkVS "勧める" ;
lin suggest_V2 = mkV2 "提案する" | mkV2 "勧める" ;
lin suggest_V = mkV "提案する" | mkV "勧める" ;
lin far_A = mkA "遠い" | mkA "遥かな" ;
lin towards_Prep = variants{} ; -- 
lin anything_NP = variants{} ; -- 
lin period_N = mkN "時代" ;
lin period_3_N = variants{} ; -- 
lin period_2_N = variants{} ; -- 
lin period_1_N = variants{} ; -- 
lin consider_VV = mkVV "見なす" ;
lin consider_VS = mkVS "見なす" ;
lin consider_V3 = mkV3 "見なす" ;
lin consider_V2V = mkV2V "見なす" ;
lin consider_V2A = mkV2A "見なす" ;
lin consider_V2 = mkV2 "見なす" ;
lin consider_V = mkV "見なす" ;
lin read_VS = mkVS "言外の意味を読み取る" | mkVS "行間を読む" ;
lin read_V2 = L.read_V2 | mkV2 "言外の意味を読み取る" | mkV2 "行間を読む" ;
lin read_V = mkV "言外の意味を読み取る" | mkV "行間を読む" ;
lin change_V2 = mkV2 "気が変わる" | mkV2 "思い直す" ;
lin change_V = mkV "気が変わる" | mkV "思い直す" ;
lin society_N = mkN "社会" ;
lin process_N = mkN "プロセス" | mkN "過程" ;
lin mother_N = mkN "母" | mkN "お母さん" | mkN "ママ" | mkN "お袋" | mkN "one's mother]" ;
lin offer_VV = mkVV "哀悼の意を表する" ;
lin offer_V2 = mkV2 "哀悼の意を表する" ;
lin late_A = mkA "遅い" ;
lin voice_N = mkN "態" ;
lin both_Adv = variants{} ; -- 
lin once_Adv = ParadigmsJpn.mkAdv "もう一度" | ParadigmsJpn.mkAdv "もう一回" ;
lin police_N = mkN "警察" ;
lin kind_N = mkN "種類" ;
lin lose_V2 = L.lose_V2 | mkV2 "なくす" | mkV2 "落とす" | mkV2 "失う" ;
lin lose_V = mkV "なくす" | mkV "落とす" | mkV "失う" ;
lin add_VS = mkVS "火に油を注ぐ" ;
lin add_V2 = mkV2 "火に油を注ぐ" ;
lin add_V = mkV "火に油を注ぐ" ;
lin probably_Adv = variants{} ; -- 
lin expect_VV = mkVV "期待する" | mkVV "予想する" | mkVV "予期する" ;
lin expect_VS = mkVS "期待する" | mkVS "予想する" | mkVS "予期する" ;
lin expect_V2V = mkV2V "期待する" | mkV2V "予想する" | mkV2V "予期する" ;
lin expect_V2 = mkV2 "期待する" | mkV2 "予想する" | mkV2 "予期する" ;
lin expect_V = mkV "期待する" | mkV "予想する" | mkV "予期する" ;
lin ever_Adv = ParadigmsJpn.mkAdv "ずっと" | ParadigmsJpn.mkAdv "いつも" ;
lin available_A = variants{} ; -- 
lin price_N = mkN "費用" | mkN "手間賃" | mkN "報酬" ;
lin little_A = mkA "小さい" ;
lin action_N = mkN "アクション映画" ;
lin issue_N = variants{} ; -- 
lin issue_2_N = variants{} ; -- 
lin issue_1_N = variants{} ; -- 
lin far_Adv = variants{} ; -- 
lin remember_VS = mkVS "よろしく伝える" ;
lin remember_V2 = mkV2 "よろしく伝える" ;
lin remember_V = mkV "よろしく伝える" ;
lin position_N = mkN "位置" ;
lin low_A = mkA "最低" ;
lin cost_N = mkN "費用" ;
lin little_Det = variants{} ; -- 
lin matter_N = mkN "物質" ;
lin matter_1_N = variants{} ; -- 
lin matter_2_N = variants{} ; -- 
lin community_N = mkN "コミュニティ" ;
lin remain_VV = mkVV "残る" ;
lin remain_VA = mkVA "残る" ;
lin remain_V2 = mkV2 "残る" ;
lin remain_V = mkV "残る" ;
lin figure_N = mkN "体型" ;
lin figure_2_N = variants{} ; -- 
lin figure_1_N = variants{} ; -- 
lin type_N = mkN "型" ;
lin research_N = mkN "研究" ;
lin actually_Adv = ParadigmsJpn.mkAdv "本当に" | ParadigmsJpn.mkAdv "実際に" | ParadigmsJpn.mkAdv "実は" ;
lin education_N = mkN "教育" ;
lin fall_V = mkV "寝る" | mkV "寝静まる" | mkV "眠りに落ちる" | mkV "寝入る" | mkV "寝付く" ;
lin speak_V2 = L.speak_V2 | mkV2 "心のうちを明かす" ;
lin speak_V = mkV "心のうちを明かす" ;
lin few_N = variants{} ; -- 
lin today_Adv = L.today_Adv | ParadigmsJpn.mkAdv "今日" ;
lin enough_Adv = variants{} ; -- 
lin open_V2 = L.open_V2 | mkV2 "開ける" | mkV2 "開く" ;
lin open_V = mkV "開ける" | mkV "開く" ;
lin bad_A = L.bad_A | mkA "悪い" ;
lin buy_V2 = L.buy_V2 | mkV2 "買う" | mkV2 "購入する" ;
lin buy_V = mkV "買う" | mkV "購入する" ;
lin programme_N = variants{} ; -- 
lin minute_N = mkN "分針" | mkN "長針" ;
lin moment_N = mkN "モーメント" ;
lin girl_N = L.girl_N | mkN "女" ;
lin age_N = mkN "世代" ;
lin centre_N = mkN "重心" ;
lin stop_VV = mkVV "止める" ;
lin stop_V2 = mkV2 "止める" ;
lin stop_V = L.stop_V | mkV "止める" ;
lin control_N = mkN "制御" | mkN "支配" | mkN "対照" | mkN "コントロール" ;
lin value_N = mkN "消費税" ;
lin send_V2V = mkV2V "送る" | mkV2V "送信する" ;
lin send_V2 = mkV2 "送る" | mkV2 "送信する" ;
lin send_V = mkV "送る" | mkV "送信する" ;
lin health_N = mkN "健康" | mkN "体" ;
lin decide_VV = mkVV "決める" | mkVV "決する" ;
lin decide_VS = mkVS "決める" | mkVS "決する" ;
lin decide_V2 = mkV2 "決める" | mkV2 "決する" ;
lin decide_V = mkV "決める" | mkV "決する" ;
lin main_A = mkA "主" | mkA "主要" | mkA "主" ;
lin win_V2 = L.win_V2 | mkV2 "勝つ" | mkV2 "勝利する" ;
lin win_V = mkV "勝つ" | mkV "勝利する" ;
lin understand_VS = mkVS "分かる" | mkVS "理解する" ;
lin understand_V2 = L.understand_V2 | mkV2 "分かる" | mkV2 "理解する" ;
lin understand_V = mkV "分かる" | mkV "理解する" ;
lin decision_N = mkN "決定" | mkN "決断" ;
lin develop_V2 = mkV2 "開発する" | mkV2 "発展する" ;
lin develop_V = mkV "開発する" | mkV "発展する" ;
lin class_N = mkN "複雑訴訟形態" ;
lin industry_N = L.industry_N | mkN "産業" | mkN "業界" ;
lin receive_V2 = mkV2 "受け取る" | mkV2 "貰う" | mkV2 "受ける" ;
lin receive_V = mkV "受け取る" | mkV "貰う" | mkV "受ける" ;
lin back_N = L.back_N | mkN "行ったり来たり" ;
lin several_Det = ParadigmsJpn.mkDet "いくらかの" | ParadigmsJpn.mkDet "数人の" | ParadigmsJpn.mkDet "数個の" ;
lin return_V2 = mkV2 "返す" ;
lin return_V = mkV "返す" ;
lin build_V2 = mkV2 "建てる" | mkV2 "建設する" | mkV2 "構築する" ;
lin build_V = mkV "建てる" | mkV "建設する" | mkV "構築する" ;
lin spend_V2 = mkV2 "過ごす" ;
lin spend_V = mkV "過ごす" ;
lin force_N = mkN "力" ;
lin condition_N = mkN "状態" ;
lin condition_1_N = variants{} ; -- 
lin condition_2_N = variants{} ; -- 
lin paper_N = L.paper_N | mkN "論文" ;
lin off_Prep = variants{} ; -- 
lin major_A = variants{} ; -- 
lin describe_VS = mkVS "記述する" | mkVS "描写する" ;
lin describe_V2 = mkV2 "記述する" | mkV2 "描写する" ;
lin agree_VV = mkVV "同意する" | mkVV "同じる" | mkVV "一致する" | mkVV "賛成する" ;
lin agree_VS = mkVS "同意する" | mkVS "同じる" | mkVS "一致する" | mkVS "賛成する" ;
lin agree_V = mkV "同意する" | mkV "同じる" | mkV "一致する" | mkV "賛成する" ;
lin economic_A = variants{} ; -- 
lin increase_V2 = mkV2 "増える" | mkV2 "増加する" | mkV2 "増大する" ;
lin increase_V = mkV "増える" | mkV "増加する" | mkV "増大する" ;
lin upon_Prep = variants{} ; -- 
lin learn_VV = mkVV "習う" | mkVV "学ぶ" ;
lin learn_VS = mkVS "習う" | mkVS "学ぶ" ;
lin learn_V2 = L.learn_V2 | mkV2 "習う" | mkV2 "学ぶ" ;
lin learn_V = mkV "習う" | mkV "学ぶ" ;
lin general_A = mkA "一般" | mkA "全般" | mkA "普通" ;
lin century_N = mkN "世紀" ;
lin therefore_Adv = ParadigmsJpn.mkAdv "従って" ;
lin father_N = mkN "義父" | mkN "岳父" | mkN "舅" ;
lin section_N = mkN "部分" ;
lin patient_N = mkN "患者" ;
lin around_Adv = ParadigmsJpn.mkAdv "四六時中" ;
lin activity_N = mkN "活動" ;
lin road_N = L.road_N | mkN "道" ;
lin table_N = L.table_N | mkN "表" ;
lin including_Prep = variants{} ; -- 
lin church_N = L.church_N | mkN "教会" ;
lin reach_V2 = mkV2 "達する" | mkV2 "到達する" ;
lin reach_V = mkV "達する" | mkV "到達する" ;
lin real_A = mkA "実際の" | mkA "実-" ;
lin lie_VS = mkVS "横になる" ;
lin lie_2_V = variants{} ; -- 
lin lie_1_V = variants{} ; -- 
lin mind_N = mkN "心" | mkN "精神" | mkN "知性" ;
lin likely_A = mkA "きっと" | mkA "おそらく" ;
lin among_Prep = variants{} ; -- 
lin team_N = mkN "チーム" | mkN "隊" ;
lin experience_N = mkN "経験" ;
lin death_N = mkN "死神" ;
lin soon_Adv = ParadigmsJpn.mkAdv "すぐに" | ParadigmsJpn.mkAdv "やがて" ;
lin act_N = mkN "行為" ;
lin sense_N = mkN "意識" ;
lin staff_N = mkN "人員" | mkN "スタッフ" ;
lin staff_2_N = variants{} ; -- 
lin staff_1_N = variants{} ; -- 
lin certain_A = mkA "確か" | mkA "一定" | mkA "定か" | mkA "特定" ;
lin certain_2_A = variants{} ; -- 
lin certain_1_A = variants{} ; -- 
lin studentMasc_N = L.student_N ;
lin half_Predet = variants{} ; -- 
lin half_Predet = variants{} ; -- 
lin around_Prep = variants{} ; -- 
lin language_N = L.language_N | mkN "言葉の壁" ;
lin walk_V2 = mkV2 "歩く" ;
lin walk_V = L.walk_V | mkV "歩く" ;
lin die_V = L.die_V | mkV "死ぬ" | mkV "亡くなる" ;
lin special_A = mkA "特別な" ;
lin difficult_A = mkA "難しい" | mkA "困難な" ;
lin international_A = mkA "国際的" ;
lin particularly_Adv = variants{} ; -- 
lin department_N = mkN "デパート" | mkN "百貨店" ;
lin management_N = mkN "管理" ;
lin morning_N = mkN "朝" | mkN "午前" ;
lin draw_V2 = mkV2 "注意を引く" ;
lin draw_1_V2 = variants{} ; -- 
lin draw_2_V2 = variants{} ; -- 
lin draw_V = mkV "注意を引く" ;
lin hope_VV = mkVV "希望する" | mkVV "望む" ;
lin hope_VS = L.hope_VS | mkVS "希望する" | mkVS "望む" ;
lin hope_V = mkV "希望する" | mkV "望む" ;
lin across_Prep = variants{} ; -- 
lin plan_N = mkN "計画" | mkN "プラン" ;
lin product_N = mkN "生成物" ;
lin city_N = L.city_N | mkN "都市" | mkN "都会" | mkN "町" ;
lin early_Adv = ParadigmsJpn.mkAdv "早く" ;
lin committee_N = mkN "委員会" ;
lin ground_N = mkN "一階" ;
lin ground_2_N = variants{} ; -- 
lin ground_1_N = variants{} ; -- 
lin letter_N = mkN "文字" ;
lin letter_2_N = variants{} ; -- 
lin letter_1_N = variants{} ; -- 
lin create_V2 = mkV2 "創造する" | mkV2 "作る" ;
lin create_V = mkV "創造する" | mkV "作る" ;
lin evidence_N = mkN "証拠" ;
lin evidence_2_N = variants{} ; -- 
lin evidence_1_N = variants{} ; -- 
lin foot_N = L.foot_N | mkN "口蹄疫" ;
lin clear_A = mkA "澄み切った" ;
lin boy_N = L.boy_N | mkN "男人" | mkN "男前" | mkN "男性" ;
lin game_N = mkN "体育" | mkN "競技" | mkN "試合" ;
lin game_3_N = variants{} ; -- 
lin game_2_N = variants{} ; -- 
lin game_1_N = variants{} ; -- 
lin food_N = mkN "食品添加物" ;
lin role_N = mkN "役" | mkN "役割" | mkN "役柄" ;
lin role_2_N = variants{} ; -- 
lin role_1_N = variants{} ; -- 
lin practice_N = mkN "儀式" ;
lin bank_N = L.bank_N | mkN "銀行口座" | mkN "預金" ;
lin else_Adv = variants{} ; -- 
lin support_N = mkN "援助" | mkN "支援" | mkN "扶養" ;
lin sell_V2 = mkV2 "売る" ;
lin sell_V = mkV "売る" ;
lin event_N = mkN "イベント" ;
lin building_N = mkN "建築" | mkN "建造" | mkN "建設" ;
lin range_N = variants{} ; -- 
lin behind_Prep = S.behind_Prep ;
lin sure_A = mkA "確か" ;
lin report_VS = mkVS "報告する" | mkVS "報ずる" ;
lin report_V2 = mkV2 "報告する" | mkV2 "報ずる" ;
lin report_V = mkV "報告する" | mkV "報ずる" ;
lin pass_V = mkV "通る" | mkV "通過する" | mkV "承認する" | mkV "可決する" | mkV "批准する" ;
lin black_A = L.black_A | mkA "黒い" | mkA "黒色の" ;
lin stage_N = mkN "舞台負け" ;
lin meeting_N = mkN "会" ;
lin meeting_N = mkN "会" ;
lin sometimes_Adv = ParadigmsJpn.mkAdv "時時" | ParadigmsJpn.mkAdv "時々" ;
lin thus_Adv = ParadigmsJpn.mkAdv "それ故" | ParadigmsJpn.mkAdv "従って" | ParadigmsJpn.mkAdv "なので" ;
lin accept_VS = mkVS "承諾する" | mkVS "引き受ける" ;
lin accept_V2 = mkV2 "承諾する" | mkV2 "引き受ける" ;
lin accept_V = mkV "承諾する" | mkV "引き受ける" ;
lin town_N = mkN "街" | mkN "町" ;
lin art_N = L.art_N | mkN "技術" | mkN "芸術" | mkN "アート" ;
lin further_Adv = variants{} ; -- 
lin club_N = mkN "クラブ" | mkN "倶楽部" ;
lin club_2_N = variants{} ; -- 
lin club_1_N = variants{} ; -- 
lin cause_V2V = mkV2V "原因となる" | mkV2V "引き起こす" ;
lin cause_V2 = mkV2 "原因となる" | mkV2 "引き起こす" ;
lin arm_N = mkN "腕" ;
lin arm_1_N = variants{} ; -- 
lin arm_2_N = variants{} ; -- 
lin history_N = mkN "歴史" | mkN "沿革" ;
lin parent_N = mkN "親" ;
lin land_N = mkN "領土" | mkN "国土" ;
lin trade_N = mkN "貿易" ;
lin watch_VS = mkVS "気を付ける" ;
lin watch_V2V = mkV2V "気を付ける" ;
lin watch_V2 = L.watch_V2 | mkV2 "気を付ける" ;
lin watch_1_V2 = variants{} ; -- 
lin watch_2_V2 = variants{} ; -- 
lin watch_V = mkV "気を付ける" ;
lin white_A = L.white_A | mkA "白人の" ;
lin situation_N = mkN "Katakana: ホームコメディ" | mkN "Romaji: hōmu komedi" ;
lin ago_Adv = ParadigmsJpn.mkAdv "前" | ParadigmsJpn.mkAdv "以前に" ;
lin teacherMasc_N = L.teacher_N ;
lin record_N = mkN "記録" ;
lin record_3_N = variants{} ; -- 
lin record_2_N = variants{} ; -- 
lin record_1_N = variants{} ; -- 
lin manager_N = mkN "支配人" | mkN "経営者" | mkN "マネージャー" | mkN "管理者" ;
lin relation_N = mkN "関係" ;
lin common_A = mkA "相互" | mkA "共通" ;
lin common_2_A = variants{} ; -- 
lin common_1_A = variants{} ; -- 
lin strong_A = mkA "強い" ;
lin whole_A = mkA "全体の" ;
lin field_N = mkN "フィールド" ;
lin field_4_N = variants{} ; -- 
lin field_3_N = variants{} ; -- 
lin field_2_N = variants{} ; -- 
lin field_1_N = variants{} ; -- 
lin free_A = mkA "自由" ;
lin break_V2 = L.break_V2 | mkV2 "法律を破る" ;
lin break_V = mkV "法律を破る" ;
lin yesterday_Adv = ParadigmsJpn.mkAdv "昨日" | ParadigmsJpn.mkAdv "きのう" | ParadigmsJpn.mkAdv "さくじつ" ;
lin support_V2 = mkV2 "支える" | mkV2 "支援する" ;
lin window_N = L.window_N | mkN "ウィンドウ" ;
lin account_N = mkN "口座" ;
lin explain_VS = mkVS "説明する" ;
lin explain_V2 = mkV2 "説明する" ;
lin stay_VA = mkVA "とどまる" ;
lin stay_V = mkV "とどまる" ;
lin few_Det = S.few_Det | ParadigmsJpn.mkDet "少し" ;
lin wait_VV = mkVV "待つ" ;
lin wait_V2 = L.wait_V2 | mkV2 "待つ" ;
lin wait_V = mkV "待つ" ;
lin usually_Adv = variants{} ; -- 
lin difference_N = mkN "差" ;
lin material_N = mkN "素材" | mkN "生地" | mkN "布" ;
lin air_N = mkN "エアコンディショナー" | mkN "エアコン" | mkN "クーラー" ;
lin wife_N = L.wife_N | mkN "妻" | mkN "家内" | mkN "奥さん" | mkN "奥様" | mkN "honorific]" | mkN "夫人" | mkN "ご夫人" ;
lin cover_V2 = mkV2 "覆う" ;
lin apply_VV = mkVV "用いる" ;
lin apply_V2V = mkV2V "用いる" ;
lin apply_V2 = mkV2 "用いる" ;
lin apply_1_V2 = variants{} ; -- 
lin apply_2_V2 = variants{} ; -- 
lin apply_V = mkV "用いる" ;
lin project_N = mkN "プロジェクトマネージャ" ;
lin raise_V2 = mkV2 "上げる" ;
lin sale_N = mkN "販売" ;
lin relationship_N = mkN "関係" ;
lin indeed_Adv = variants{} ; -- 
lin light_N = mkN "電球" ;
lin claim_VS = variants{} ; -- 
lin claim_V2 = variants{} ; -- 
lin claim_V = variants{} ; -- 
lin form_V2 = mkV2 "形作る" ;
lin form_V = mkV "形作る" ;
lin base_V2 = variants{} ; -- 
lin base_V = variants{} ; -- 
lin care_N = variants{} ; -- 
lin someone_NP = S.somebody_NP ;
lin everything_NP = S.everything_NP ;
lin certainly_Adv = variants{} ; -- 
lin rule_N = L.rule_N | mkN "規則" | mkN "ルール" ;
lin home_Adv = ParadigmsJpn.mkAdv "家に" | ParadigmsJpn.mkAdv "家で" ;
lin cut_V2 = L.cut_V2 | mkV2 "サボる" ;
lin cut_V = mkV "サボる" ;
lin grow_VA = mkVA "成長する" | mkVA "おとなになる" ;
lin grow_V2 = mkV2 "成長する" | mkV2 "おとなになる" ;
lin grow_V = mkV "成長する" | mkV "おとなになる" ;
lin similar_A = mkA "似ている" ;
lin story_N = mkN "物語" | mkN "小説" | mkN "話し" | mkN "ストーリー" ;
lin quality_N = mkN "品" ;
lin tax_N = mkN "税" | mkN "税金" | mkN "租税" ;
lin worker_N = mkN "労働者" | mkN "勤労者" | mkN "働く人" ;
lin nature_N = mkN "自然" ;
lin structure_N = mkN "構造" | mkN "構成" ;
lin data_N = mkN "データ入力" ;
lin necessary_A = mkA "必要" ;
lin pound_N = mkN "ポンド" ;
lin method_N = mkN "方法" | mkN "方式" ;
lin unit_N = mkN "部隊" | mkN "部門" ;
lin unit_6_N = variants{} ; -- 
lin unit_5_N = variants{} ; -- 
lin unit_4_N = variants{} ; -- 
lin unit_3_N = variants{} ; -- 
lin unit_2_N = variants{} ; -- 
lin unit_1_N = variants{} ; -- 
lin central_A = mkA "中心的" | mkA "中央" ;
lin bed_N = mkN "ベッド" | mkN "寝床" ;
lin union_N = mkN "共用体" ;
lin movement_N = mkN "運動" | mkN "動き" ;
lin board_N = mkN "宿泊料金" ;
lin board_2_N = variants{} ; -- 
lin board_1_N = variants{} ; -- 
lin true_A = mkA "真" ;
lin well_Interj = mkInterj "良くやった！" | mkInterj "善哉！" | mkInterj "天晴れ！" ;
lin simply_Adv = variants{} ; -- 
lin contain_V2 = mkV2 "含む" ;
lin especially_Adv = variants{} ; -- 
lin open_A = mkA "開けた" ;
lin short_A = L.short_A | mkA "略語" ;
lin personal_A = mkA "個人の" ;
lin detail_N = variants{} ; -- 
lin model_N = mkN "モデル" | mkN "模型" ;
lin bear_V2 = mkV2 "運ぶ" | mkV2 "持って行く" ;
lin bear_V = mkV "運ぶ" | mkV "持って行く" ;
lin single_A = mkA "独身" | mkA "未婚" | mkA "独り" ;
lin single_2_A = variants{} ; -- 
lin single_1_A = variants{} ; -- 
lin join_V2 = mkV2 "加わる" | mkV2 "参加する" | mkV2 "合流する" ;
lin join_V = mkV "加わる" | mkV "参加する" | mkV "合流する" ;
lin reduce_V2 = mkV2 "還元する" ;
lin reduce_V = mkV "還元する" ;
lin establish_V2 = mkV2 "確立する" ;
lin wall_N = mkN "壁" ;
lin face_V2 = mkV2 "直面する" ;
lin face_V = mkV "直面する" ;
lin easy_A = mkA "簡単な" | mkA "易い" | mkA "容易な" ;
lin private_A = mkA "私立の" ;
lin computer_N = L.computer_N | mkN "計算者" ;
lin hospital_N = mkN "病院" ;
lin chapter_N = mkN "章" ;
lin scheme_N = mkN "計画" | mkN "企画" | mkN "案" | mkN "計画" | mkN "枠組み" ;
lin theory_N = mkN "理論" | mkN "学説" ;
lin choose_VV = mkVV "選ぶ" ;
lin choose_V2 = mkV2 "選ぶ" ;
lin wish_VV = mkVV "願う" | mkVV "祈る" | mkVV "欲する" ;
lin wish_VS = mkVS "願う" | mkVS "祈る" | mkVS "欲する" ;
lin wish_V2V = mkV2V "願う" | mkV2V "祈る" | mkV2V "欲する" ;
lin wish_V2 = mkV2 "願う" | mkV2 "祈る" | mkV2 "欲する" ;
lin wish_V = mkV "願う" | mkV "祈る" | mkV "欲する" ;
lin property_N = mkN "特徴" | mkN "特性" ;
lin property_2_N = variants{} ; -- 
lin property_1_N = variants{} ; -- 
lin achieve_V2 = mkV2 "達成する" | mkV2 "実現する" ;
lin financial_A = variants{} ; -- 
lin poor_A = mkA "教会のネズミのように貧しい" | mkA "非常に貧しい" ;
lin poor_3_A = variants{} ; -- 
lin poor_2_A = variants{} ; -- 
lin poor_1_A = variants{} ; -- 
lin officer_N = mkN "士官" | mkN "将校" ;
lin officer_3_N = variants{} ; -- 
lin officer_2_N = variants{} ; -- 
lin officer_1_N = variants{} ; -- 
lin up_Prep = variants{} ; -- 
lin charge_N = mkN "非難" ;
lin charge_2_N = variants{} ; -- 
lin charge_1_N = variants{} ; -- 
lin director_N = mkN "監督" | mkN "指揮者" ;
lin drive_V2V = mkV2V "退ける" | mkV2V "追い遣る" ;
lin drive_V2 = mkV2 "退ける" | mkV2 "追い遣る" ;
lin drive_V = mkV "退ける" | mkV "追い遣る" ;
lin deal_V2 = mkV2 "対処する" ;
lin deal_V = mkV "対処する" ;
lin place_V2 = mkV2 "なる" | mkV2 "つく" | mkV2 "決まる" | mkV2 "定まる" ;
lin approach_N = mkN "アプローチ" ;
lin chance_N = mkN "機会" | mkN "チャンス" ;
lin application_N = mkN "アプリケーション" ;
lin seek_VV = mkVV "探す" | mkVV "探し回る" ;
lin seek_V2 = L.seek_V2 | mkV2 "探す" | mkV2 "探し回る" ;
lin foreign_A = mkA "外国の" ;
lin foreign_2_A = variants{} ; -- 
lin foreign_1_A = variants{} ; -- 
lin along_Prep = variants{} ; -- 
lin top_N = mkN "表" ;
lin amount_N = mkN "量" ;
lin son_N = mkN "息子" | mkN "坊っちゃん" ;
lin operation_N = mkN "作業" | mkN "操作" ;
lin fail_VV = mkVV "矢敗する" ;
lin fail_V2 = mkV2 "矢敗する" ;
lin fail_V = mkV "矢敗する" ;
lin human_A = mkA "人" ;
lin opportunity_N = mkN "機会" ;
lin simple_A = mkA "簡単な" | mkA "単純な" | mkA "易い" ;
lin leader_N = mkN "指導者" | mkN "リーダー" | mkN "首領" ;
lin look_N = mkN "ルック・アンド・フィール" ;
lin share_N = mkN "株" | mkN "株式" ;
lin production_N = mkN "生産" | mkN "製造" ;
lin recent_A = mkA "最近" ;
lin firm_N = variants{} ; -- 
lin picture_N = mkN "絵本" ;
lin source_N = mkN "ソースコード" ;
lin security_N = mkN "安全" | mkN "セキュリティー" ;
lin serve_V2 = mkV2 "様を見ろ！" ;
lin serve_V = mkV "様を見ろ！" ;
lin according_to_Prep = variants{} ; -- 
lin end_V2 = mkV2 "終わる" ;
lin end_V = mkV "終わる" ;
lin contract_N = mkN "契約" ;
lin wide_A = L.wide_A | mkA "広い" | mkA "幅広い" ;
lin occur_V = mkV "思い浮かぶ" ;
lin agreement_N = mkN "合意" | mkN "一致" | mkN "納得" | mkN "賛成" ;
lin better_Adv = ParadigmsJpn.mkAdv "遅くてもやらないよりまし" ;
lin kill_V2 = L.kill_V2 | mkV2 "殺す" ;
lin kill_V = mkV "殺す" ;
lin act_V2 = mkV2 "行動する" ;
lin act_V = mkV "行動する" ;
lin site_N = mkN "サイトマップ" ;
lin either_Adv = variants{} ; -- 
lin labour_N = mkN "労働" ;
lin plan_VV = mkVV "計画する" ;
lin plan_VS = mkVS "計画する" ;
lin plan_V2V = mkV2V "計画する" ;
lin plan_V2 = mkV2 "計画する" ;
lin plan_V = mkV "計画する" ;
lin various_A = mkA "いろいろな" ;
lin since_Prep = variants{} ; -- 
lin test_N = mkN "試験" | mkN "テスト" ;
lin eat_V2 = L.eat_V2 | mkV2 "食べる" | mkV2 "食う" | mkV2 "食事する" | mkV2 "召し上がる" | mkV2 "頂く" | mkV2 "食う" | mkV2 "vulgar]" ;
lin eat_V = mkV "食べる" | mkV "食う" | mkV "食事する" | mkV "召し上がる" | mkV "頂く" | mkV "食う" | mkV "vulgar]" ;
lin loss_N = mkN "損失" ;
lin close_V2 = L.close_V2 | mkV2 "閉める" | mkV2 "閉まる" | mkV2 "閉じる" ;
lin close_V = mkV "閉める" | mkV "閉まる" | mkV "閉じる" ;
lin represent_V2 = mkV2 "代表する" ;
lin represent_V = mkV "代表する" ;
lin love_VV = mkVV "大好きである" | mkVV "気に入る" ;
lin love_V2 = L.love_V2 | mkV2 "大好きである" | mkV2 "気に入る" ;
lin colour_N = mkN "カラーテレビ" ;
lin clearly_Adv = variants{} ; -- 
lin shop_N = L.shop_N | mkN "店" | mkN "商店" ;
lin benefit_N = mkN "利益" | mkN "public benefit: 公益" | mkN "恩恵" ;
lin animal_N = L.animal_N | mkN "動物" ;
lin heart_N = L.heart_N | mkN "ハート" ;
lin election_N = mkN "選挙" | mkN "選任" | mkN "選出" ;
lin purpose_N = mkN "目的" ;
lin standard_N = mkN "標準" ;
lin due_A = variants{} ; -- 
lin secretary_N = mkN "ヘビクイワシ" ;
lin rise_V2 = mkV2 "あがる" | mkV2 "上昇する" ;
lin rise_V = mkV "あがる" | mkV "上昇する" ;
lin date_N = mkN "デーツ" | mkN "ナツメヤシの実" ;
lin date_7_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_3_N = variants{} ; -- 
lin date_1_N = variants{} ; -- 
lin hard_A = variants{} ; -- 
lin hard_2_A = variants{} ; -- 
lin hard_1_A = variants{} ; -- 
lin music_N = L.music_N | mkN "オルゴール" ;
lin hair_N = L.hair_N | mkN "髪の毛" | mkN "髪" ;
lin prepare_VV = mkVV "準備する" ;
lin prepare_V2V = mkV2V "準備する" ;
lin prepare_V2 = mkV2 "準備する" ;
lin prepare_V = mkV "準備する" ;
lin factor_N = variants{} ; -- 
lin other_A = mkA "他の" | mkA "別の" ;
lin anyone_NP = variants{} ; -- 
lin pattern_N = mkN "模様" | mkN "様式" ;
lin manage_VV = mkVV "管理する" ;
lin manage_V2 = mkV2 "管理する" ;
lin manage_V = mkV "管理する" ;
lin piece_N = mkN "作品" ;
lin discuss_VS = mkVS "議論する" | mkVS "論ずる" ;
lin discuss_V2 = mkV2 "議論する" | mkV2 "論ずる" ;
lin prove_VS = mkVS "証明する" ;
lin prove_VA = mkVA "証明する" ;
lin prove_V2 = mkV2 "証明する" ;
lin prove_V = mkV "証明する" ;
lin front_N = mkN "フロントエンド" ;
lin evening_N = mkN "晩年" | mkN "日暮れ" ;
lin royal_A = mkA "王の" | mkA "王室の" ;
lin tree_N = L.tree_N | mkN "樹洞" ;
lin population_N = mkN "人口" ;
lin fine_A = variants{} ; -- 
lin plant_N = mkN "草" | mkN "草花" ;
lin pressure_N = mkN "圧力" ;
lin response_N = variants{} ; -- 
lin catch_V2 = mkV2 "風邪をひく" | mkV2 "風邪を召す" ;
lin street_N = mkN "道" | mkN "道路" | mkN "通り" ;
lin pick_V2 = mkV2 "いじめる" ;
lin pick_V = mkV "いじめる" ;
lin performance_N = mkN "演奏" ;
lin performance_2_N = variants{} ; -- 
lin performance_1_N = variants{} ; -- 
lin knowledge_N = mkN "知識" | mkN "学識" ;
lin despite_Prep = variants{} ; -- 
lin design_N = mkN "デザイン" ;
lin page_N = mkN "ページ" | mkN "面" ;
lin enjoy_VV = mkVV "楽しむ" ;
lin enjoy_V2 = mkV2 "楽しむ" ;
lin individual_N = mkN "個人" | mkN "個体" | mkN "私人" ;
lin suppose_VS = mkVS "推測する" ;
lin suppose_V2 = mkV2 "推測する" ;
lin rest_N = mkN "休み" ;
lin instead_Adv = ParadigmsJpn.mkAdv "...の代わりに" ;
lin wear_V2 = mkV2 "擦り減る" | mkV2 "擦り減らす" ;
lin wear_V = mkV "擦り減る" | mkV "擦り減らす" ;
lin basis_N = mkN "ベーシスポイント" ;
lin size_N = mkN "サイズ" ;
lin environment_N = mkN "環境" ;
lin per_Prep = variants{} ; -- 
lin fire_N = L.fire_N ;
lin fire_2_N = L.fire_N ; --- info missing in senses-in-Dictionary
lin fire_1_N = L.fire_N ; --- info missing in senses-in-Dictionary
lin series_N = mkN "系列" ;
lin success_N = mkN "成功" ;
lin natural_A = mkA "自然な" ;
lin wrong_A = mkA "悪い" | mkA "よくない" ;
lin near_Prep = variants{} ; -- 
lin round_Adv = variants{} ; -- 
lin thought_N = mkN "思考実験" ;
lin list_N = mkN "リスト" ;
lin argue_VS = mkVS "議論する" | mkVS "論ずる" ;
lin argue_V2 = mkV2 "議論する" | mkV2 "論ずる" ;
lin argue_V = mkV "議論する" | mkV "論ずる" ;
lin final_A = mkA "最終的" | mkA "最後の" ;
lin future_N = mkN "未来" | mkN "将来" ;
lin future_3_N = variants{} ; -- 
lin future_1_N = variants{} ; -- 
lin introduce_V2 = mkV2 "紹介する" ;
lin analysis_N = mkN "分析" ;
lin enter_V2 = mkV2 "入る" ;
lin enter_V = mkV "入る" ;
lin space_N = mkN "宇宙時代" ;
lin arrive_V = mkV "着く" | mkV "到着する" ;
lin ensure_VS = variants{} ; -- 
lin ensure_V2 = variants{} ; -- 
lin ensure_V = variants{} ; -- 
lin demand_N = mkN "需要" ;
lin statement_N = mkN "声明" | mkN "陳述" ;
lin to_Adv = ParadigmsJpn.mkAdv "知る限り" ;
lin attention_N = mkN "注意" | mkN "注目" ;
lin love_N = L.love_N | mkN "情事" | mkN "色恋沙汰" ;
lin principle_N = mkN "主義" ;
lin pull_V2 = L.pull_V2 | mkV2 "引く" | mkV2 "引っ張る" ;
lin pull_V = mkV "引く" | mkV "引っ張る" ;
lin set_N = mkN "集合" ;
lin set_2_N = variants{} ; -- 
lin set_1_N = variants{} ; -- 
lin doctor_N = L.doctor_N | mkN "博士" ;
lin choice_N = mkN "選択肢" ;
lin refer_V2 = mkV2 "問い合わせる" ;
lin refer_V = mkV "問い合わせる" ;
lin feature_N = mkN "特徴" ;
lin couple_N = mkN "二、三" ;
lin step_N = mkN "足跡" ;
lin following_A = variants{} ; -- 
lin thank_V2 = mkV2 "感謝する" ;
lin machine_N = mkN "機械" | mkN "機構" | mkN "組織" ;
lin income_N = mkN "所得" | mkN "収入" ;
lin training_N = mkN "訓練" | mkN "トレーニング" ;
lin present_V2 = mkV2 "進呈する" ;
lin association_N = mkN "連想" | mkN "関連付け" ;
lin film_N = mkN "映画" ;
lin film_2_N = variants{} ; -- 
lin film_1_N = variants{} ; -- 
lin region_N = mkN "地方" ;
lin effort_N = mkN "努力" ;
lin player_N = mkN "俳優" | mkN "芸人" ;
lin everyone_NP = variants{} ; -- 
lin present_A = mkA "現代" ;
lin award_N = variants{} ; -- 
lin village_N = L.village_N | mkN "村" | mkN "むら" | mkN "田舎" ;
lin control_V2 = mkV2 "制御する" | mkV2 "支配する" | mkV2 "コントロールする" ;
lin organisation_N = variants{} ; -- 
lin whatever_Det = variants{} ; -- 
lin news_N = mkN "通信社" ;
lin nice_A = mkA "快い" ;
lin difficulty_N = mkN "困難" | mkN "障害" ;
lin modern_A = mkA "モダンな" | mkA "近代的" | mkA "現代的" ;
lin cell_N = mkN "セル" ;
lin close_A = mkA "近い" ;
lin current_A = mkA "現行" | mkA "現在" | mkA "当座" ;
lin legal_A = mkA "合法" | mkA "法に則った" ;
lin energy_N = mkN "エネルギー" | mkN "動力" ;
lin finally_Adv = ParadigmsJpn.mkAdv "遂に" ;
lin degree_N = variants{} ; -- 
lin degree_3_N = variants{} ; -- 
lin degree_2_N = variants{} ; -- 
lin degree_1_N = variants{} ; -- 
lin mile_N = mkN "マイル" ;
lin means_N = mkN "道具" | mkN "手段" ;
lin growth_N = mkN "生長" ;
lin treatment_N = mkN "治療" ;
lin sound_N = mkN "探子" ;
lin above_Prep = S.above_Prep ;
lin task_N = mkN "任務" ;
lin provision_N = mkN "支給" | mkN "配給" ;
lin affect_V2 = variants{} ; -- 
lin please_Adv = ParadigmsJpn.mkAdv "...ください" | ParadigmsJpn.mkAdv "どうぞ" | ParadigmsJpn.mkAdv "お願いします" | ParadigmsJpn.mkAdv "...をください" | ParadigmsJpn.mkAdv "please]" ;
lin red_A = L.red_A | mkA "現行犯" ;
lin happy_A = mkA "幸せな" | mkA "幸福な" ;
lin behaviour_N = mkN "振舞い" | mkN "行儀" | mkN "行動" | mkN "反応" ;
lin concerned_A = variants{} ; -- 
lin point_V2 = variants{} ; -- 
lin point_V = variants{} ; -- 
lin function_N = mkN "機能" ;
lin identify_V2 = mkV2 "識別する" ;
lin identify_V = mkV "識別する" ;
lin resource_N = mkN "資質" ;
lin defence_N = mkN "防御" | mkN "防禦" ;
lin garden_N = L.garden_N | mkN "庭園" | mkN "庭" ;
lin floor_N = L.floor_N | mkN "フロアスタンド" ;
lin technology_N = mkN "技術" ;
lin style_N = mkN "様式" | mkN "スタイル" | mkN "やり方" ;
lin feeling_N = mkN "感情" ;
lin science_N = L.science_N | mkN "科学" ;
lin relate_V2 = variants{} ; -- 
lin relate_V = variants{} ; -- 
lin doubt_N = mkN "不審" | mkN "疑い" | mkN "疑問" ;
lin horse_N = L.horse_N | mkN "馬" | mkN "うま" | mkN "ウマ" ;
lin force_VS = mkVS "強いる" ;
lin force_V2V = mkV2V "強いる" ;
lin force_V2 = mkV2 "強いる" ;
lin force_V = mkV "強いる" ;
lin answer_N = mkN "返事" | mkN "返答" ;
lin compare_V = mkV "比べる" | mkV "比較" ;
lin suffer_V2 = mkV2 "我慢する" ;
lin suffer_V = mkV "我慢する" ;
lin individual_A = mkA "個々の" ;
lin forward_Adv = ParadigmsJpn.mkAdv "後" ;
lin announce_VS = mkVS "発表する" | mkVS "知らせる" ;
lin announce_V2 = mkV2 "発表する" | mkV2 "知らせる" ;
lin userMasc_N = variants{} ; -- 
lin fund_N = mkN "資金" | mkN "基金" ;
lin character_2_N = variants{} ; -- 
lin character_1_N = variants{} ; -- 
lin risk_N = mkN "リスク" ;
lin normal_A = mkA "正常" | mkA "通常" | mkA "常態" ;
lin nor_Conj = variants{} ; -- 
lin dog_N = L.dog_N | mkN "犬" ;
lin obtain_V2 = mkV2 "手に入れる" | mkV2 "取得する" | mkV2 "獲得する" ;
lin obtain_V = mkV "手に入れる" | mkV "取得する" | mkV "獲得する" ;
lin quickly_Adv = variants{} ; -- 
lin army_N = mkN "陸軍" | mkN "軍隊" ;
lin indicate_VS = mkVS "示す" | mkVS "指す" | mkVS "指摘する" | mkVS "表示する" ;
lin indicate_V2 = mkV2 "示す" | mkV2 "指す" | mkV2 "指摘する" | mkV2 "表示する" ;
lin forget_VS = mkVS "もういいです" ;
lin forget_V2 = L.forget_V2 | mkV2 "もういいです" ;
lin forget_V = mkV "もういいです" ;
lin station_N = mkN "駐屯地" ;
lin glass_N = mkN "ガラス" ;
lin cup_N = mkN "カップ" ;
lin previous_A = mkA "前の" ;
lin husband_N = L.husband_N | mkN "夫" | mkN "旦那" | mkN "亭主" | mkN "主人" | mkN "ご主人" ;
lin recently_Adv = variants{} ; -- 
lin publish_V2 = mkV2 "出版する" ;
lin publish_V = mkV "出版する" ;
lin serious_A = mkA "真面目" | mkA "真剣" ;
lin anyway_Adv = ParadigmsJpn.mkAdv "とにかく" ;
lin visit_V2 = mkV2 "訪れる" | mkV2 "訪ねる" | mkV2 "訪問する" ;
lin visit_V = mkV "訪れる" | mkV "訪ねる" | mkV "訪問する" ;
lin capital_N = mkN "首都" | mkN "都" ;
lin capital_3_N = variants{} ; -- 
lin capital_2_N = variants{} ; -- 
lin capital_1_N = variants{} ; -- 
lin either_Det = ParadigmsJpn.mkDet "どちらか" ;
lin note_N = mkN "音符" ;
lin note_3_N = variants{} ; -- 
lin note_2_N = variants{} ; -- 
lin note_1_N = variants{} ; -- 
lin season_N = mkN "季節" ;
lin argument_N = mkN "引数" ;
lin listen_V = mkV "聞く" ;
lin show_N = mkN "誇示" ;
lin responsibility_N = mkN "責任" ;
lin significant_A = mkA "重要な" | mkA "著しい" ;
lin deal_N = mkN "取引" | mkN "合意" ;
lin prime_A = mkA "最良の" ;
lin economy_N = mkN "経済" ;
lin economy_2_N = variants{} ; -- 
lin economy_1_N = variants{} ; -- 
lin element_N = mkN "元素" ;
lin finish_V2 = mkV2 "終わる" ;
lin finish_V = mkV "終わる" ;
lin duty_N = mkN "関税" ;
lin fight_V2 = L.fight_V2 | mkV2 "戦う" | mkV2 "闘う" ;
lin fight_V = mkV "戦う" | mkV "闘う" ;
lin train_V2V = mkV2V "照準する" ;
lin train_V2 = mkV2 "照準する" ;
lin train_V = mkV "照準する" ;
lin maintain_VS = mkVS "保持する" ;
lin maintain_V2 = mkV2 "保持する" ;
lin maintain_V = mkV "保持する" ;
lin attempt_N = mkN "試み" ;
lin leg_N = L.leg_N | mkN "脚" | mkN "足" ;
lin investment_N = mkN "投資" ;
lin save_V2 = mkV2 "貯金する" ;
lin save_V = mkV "貯金する" ;
lin throughout_Prep = variants{} ; -- 
lin design_V2 = variants{} ; -- 
lin design_V = variants{} ; -- 
lin suddenly_Adv = variants{} ; -- 
lin brother_N = mkN "戦友" ;
lin improve_V2 = mkV2 "良くなる" | mkV2 "上達する" ;
lin improve_V = mkV "良くなる" | mkV "上達する" ;
lin avoid_VV = mkVV "避ける" | mkVV "免れる" | mkVV "斎む" ;
lin avoid_V2 = mkV2 "避ける" | mkV2 "免れる" | mkV2 "斎む" ;
lin wonder_VQ = L.wonder_VQ ;
lin wonder_V = variants{}; -- L.wonder_VQ ;
lin tend_VV = variants{} ; -- 
lin tend_V2 = variants{} ; -- 
lin title_N = mkN "所有証" | mkN "資格証" ;
lin hotel_N = mkN "ホテル" | mkN "旅館" ;
lin aspect_N = mkN "相" | mkN "アスペクト" ;
lin increase_N = mkN "増加" | mkN "増大" ;
lin help_N = mkN "助け" | mkN "手助け" | mkN "手伝い" | mkN "ヘルプ" ;
lin industrial_A = variants{} ; -- 
lin express_V2 = mkV2 "表す" | mkV2 "述べる" ;
lin summer_N = mkN "夏" ;
lin determine_VV = mkVV "定める" | mkVV "決する" | mkVV "決定する" ;
lin determine_VS = mkVS "定める" | mkVS "決する" | mkVS "決定する" ;
lin determine_V2V = mkV2V "定める" | mkV2V "決する" | mkV2V "決定する" ;
lin determine_V2 = mkV2 "定める" | mkV2 "決する" | mkV2 "決定する" ;
lin determine_V = mkV "定める" | mkV "決する" | mkV "決定する" ;
lin generally_Adv = ParadigmsJpn.mkAdv "一般に" ;
lin daughter_N = mkN "娘" | mkN "お嬢さん" ;
lin exist_V = mkV "存在する" ;
lin share_V2 = mkV2 "分担する" | mkV2 "分ける" ;
lin share_V = mkV "分担する" | mkV "分ける" ;
lin baby_N = L.baby_N | mkN "ベビーブーム" ;
lin nearly_Adv = ParadigmsJpn.mkAdv "ほとんど" | ParadigmsJpn.mkAdv "殆ど" ;
lin smile_V = mkV "微笑む" | mkV "笑う" ;
lin sorry_A = mkA "気の毒" | mkA "かわいそう" | mkA "残念" | mkA "遺憾" ;
lin sea_N = L.sea_N | mkN "海" | mkN "海" ;
lin skill_N = mkN "スキル" | mkN "技能" | mkN "技術" ;
lin claim_N = mkN "主張" ;
lin treat_V2 = mkV2 "奢る" ;
lin treat_V = mkV "奢る" ;
lin remove_V2 = mkV2 "移す" | mkV2 "除く" | mkV2 "取り去る" | mkV2 "退ける" ;
lin remove_V = mkV "移す" | mkV "除く" | mkV "取り去る" | mkV "退ける" ;
lin concern_N = mkN "注意事項" | mkN "題目" | mkN "心配事" ;
lin university_N = L.university_N | mkN "大学" ;
lin left_A = mkA "左" ;
lin dead_A = mkA "死んだ" ;
lin discussion_N = mkN "議論" | mkN "討論" ;
lin specific_A = mkA "特殊" ;
lin customerMasc_N = variants{} ; -- 
lin box_N = mkN "箱" | mkN "ボックス" ;
lin outside_Prep = variants{} ; -- 
lin state_VS = mkVS "述べる" ;
lin state_V2 = mkV2 "述べる" ;
lin conference_N = mkN "会議" ;
lin whole_N = mkN "全体" ;
lin total_A = mkA "完全な" ;
lin profit_N = mkN "利益" | mkN "利潤" ;
lin division_N = variants{} ; -- 
lin division_3_N = variants{} ; -- 
lin division_2_N = variants{} ; -- 
lin division_1_N = variants{} ; -- 
lin throw_V2 = L.throw_V2 | mkV2 "棄てる" | mkV2 "捨てる" ;
lin throw_V = mkV "棄てる" | mkV "捨てる" ;
lin procedure_N = mkN "手順" | mkN "行程" | mkN "プロシージャ" | mkN "手続き" ;
lin fill_V2 = mkV2 "満たす" | mkV2 "一杯にする" ;
lin fill_V = mkV "満たす" | mkV "一杯にする" ;
lin king_N = L.king_N | mkN "国王" | mkN "王様" | mkN "王" ;
lin assume_VS = mkVS "負う" | mkVS "引き受ける" ;
lin assume_V2 = mkV2 "負う" | mkV2 "引き受ける" ;
lin image_N = mkN "印象" ;
lin oil_N = L.oil_N | mkN "石油" | mkN "油" ;
lin obviously_Adv = variants{} ; -- 
lin unless_Subj = variants{} ; -- 
lin appropriate_A = mkA "適切" | mkA "適当" | mkA "相応しい" ;
lin circumstance_N = mkN "事件" ;
lin military_A = mkA "軍事的な" | mkA "軍隊の" ;
lin proposal_N = mkN "企画書" | mkN "提案書" ;
lin mention_VS = mkVS "について話す" ;
lin mention_V2 = mkV2 "について話す" ;
lin mention_V = mkV "について話す" ;
lin client_N = mkN "客" | mkN "お客さん" | mkN "顧客" | mkN "クライアント" ;
lin sector_N = variants{} ; -- 
lin direction_N = variants{} ; -- 
lin admit_VS = mkVS "認める" ;
lin admit_V2 = mkV2 "認める" ;
lin admit_V = mkV "認める" ;
lin though_Adv = ParadigmsJpn.mkAdv "にもかかわらず" | ParadigmsJpn.mkAdv "それでも" ;
lin replace_V2 = mkV2 "取り換える" ;
lin basic_A = mkA "塩基性" ;
lin hard_Adv = variants{} ; -- 
lin instance_N = variants{} ; -- 
lin sign_N = mkN "記号" | mkN "符号" ;
lin original_A = mkA "本来の" ;
lin successful_A = mkA "成功した" ;
lin okay_Adv = variants{} ; -- 
lin reflect_V2 = mkV2 "反映する" ;
lin reflect_V = mkV "反映する" ;
lin aware_A = variants{} ; -- 
lin measure_N = mkN "小節" ;
lin attitude_N = mkN "態度" ;
lin disease_N = mkN "病気" | mkN "疾病" ;
lin exactly_Adv = variants{} ; -- 
lin above_Adv = ParadigmsJpn.mkAdv "何よりも" ;
lin commission_N = variants{} ; -- 
lin intend_VV = mkVV "つもりである" | mkVV "意図する" ;
lin beyond_Prep = variants{} ; -- 
lin seat_N = mkN "シートベルト" ;
lin presidentMasc_N = variants{} ; -- 
lin encourage_V2V = mkV2V "勇気付ける" ;
lin encourage_V2 = mkV2 "勇気付ける" ;
lin addition_N = mkN "付加" | mkN "追加" ;
lin goal_N = mkN "ゴール" ;
lin round_Prep = variants{} ; -- 
lin miss_V2 = mkV2 "逃す" ;
lin miss_V = mkV "逃す" ;
lin popular_A = mkA "人気のある" | mkA "受けのよい" ;
lin affair_N = mkN "問題" ;
lin technique_N = variants{} ; -- 
lin respect_N = mkN "尊敬" | mkN "尊重" ;
lin drop_V2 = variants{} ; -- 
lin drop_V = variants{} ; -- 
lin professional_A = variants{} ; -- 
lin less_Det = variants{} ; -- 
lin once_Subj = variants{} ; -- 
lin item_N = mkN "項目" ;
lin fly_V2 = mkV2 "飛ばす" ;
lin fly_V = L.fly_V | mkV "飛ばす" ;
lin reveal_VS = mkVS "現す" | mkVS "表す" | mkVS "表わす" ;
lin reveal_V2 = mkV2 "現す" | mkV2 "表す" | mkV2 "表わす" ;
lin version_N = mkN "バージョン" | mkN "版" ;
lin maybe_Adv = ParadigmsJpn.mkAdv "多分" ;
lin ability_N = mkN "能力" | mkN "才能" ;
lin operate_V2 = mkV2 "操作する" ;
lin operate_V = mkV "操作する" ;
lin good_N = mkN "善" ;
lin campaign_N = variants{} ; -- 
lin heavy_A = L.heavy_A | mkA "重い" ;
lin advice_N = mkN "助言" | mkN "注意" | mkN "忠告" | mkN "アドバイス" ;
lin institution_N = mkN "機構" | mkN "機関" ;
lin discover_VS = mkVS "発見する" | mkVS "見つける" ;
lin discover_V2 = mkV2 "発見する" | mkV2 "見つける" ;
lin discover_V = mkV "発見する" | mkV "見つける" ;
lin surface_N = mkN "表面" ;
lin library_N = mkN "双書" ;
lin pupil_N = mkN "学童" | mkN "児童" | mkN "生徒" | mkN "学生" | mkN "弟子" ;
lin record_V2 = mkV2 "記録する" ;
lin refuse_VV = mkVV "断る" ;
lin refuse_V2 = mkV2 "断る" ;
lin refuse_V = mkV "断る" ;
lin prevent_V2 = mkV2 "予防する" ;
lin advantage_N = mkN "得" ;
lin dark_A = mkA "暗い" ;
lin teach_V2V = mkV2V "教える" ;
lin teach_V2 = L.teach_V2 | mkV2 "教える" ;
lin teach_V = mkV "教える" ;
lin memory_N = mkN "メモリ" | mkN "メモリー" ;
lin culture_N = mkN "文化" ;
lin blood_N = L.blood_N | mkN "義兄弟" ;
lin cost_V2 = mkV2 "費やす" | mkV2 "掛かる" ;
lin cost_V = mkV "費やす" | mkV "掛かる" ;
lin majority_N = mkN "多数" ;
lin answer_V2 = mkV2 "答える" | mkV2 "返事する" ;
lin answer_V = mkV "答える" | mkV "返事する" ;
lin variety_N = mkN "多様性" ;
lin variety_2_N = variants{} ; -- 
lin variety_1_N = variants{} ; -- 
lin press_N = mkN "記者会見" ;
lin depend_V = mkV "依存する" ;
lin bill_N = mkN "嘴" ;
lin competition_N = mkN "競争" | mkN "コンペ" ;
lin ready_A = mkA "用意の出来た" | mkA "出来上がり" | mkA "準備の出来た" ;
lin general_N = mkN "大将" | mkN "将軍" ;
lin access_N = mkN "アクセス" ;
lin hit_V2 = L.hit_V2 | mkV2 "やり逃げ" ;
lin hit_V = mkV "やり逃げ" ;
lin stone_N = L.stone_N | mkN "宝石" ;
lin useful_A = mkA "有用" | mkA "便利" | mkA "役に立つ" ;
lin extent_N = mkN "程度" ;
lin employment_N = mkN "職業紹介所" ;
lin regard_V2 = variants{} ; -- 
lin regard_V = variants{} ; -- 
lin apart_Adv = ParadigmsJpn.mkAdv "ばらばらに" ;
lin present_N = mkN "現在" ;
lin appeal_N = variants{} ; -- 
lin text_N = mkN "伝言" | mkN "メッセージ" | mkN "短信" | mkN "エス・エム・エス" ;
lin parliament_N = mkN "議会" ;
lin cause_N = mkN "原因" ;
lin terms_N = mkN "利用条件" ;
lin bar_N = mkN "バー" | mkN "居酒屋" | mkN "パブ" ;
lin bar_2_N = variants{} ; -- 
lin bar_1_N = variants{} ; -- 
lin attack_N = mkN "攻撃" ;
lin effective_A = variants{} ; -- 
lin mouth_N = L.mouth_N | mkN "河口" ;
lin down_Prep = variants{} ; -- 
lin result_V = variants{} ; -- 
lin fish_N = L.fish_N | mkN "フィッシュ・アンド・チップス" ;
lin future_A = variants{} ; -- 
lin visit_N = mkN "訪問" | mkN "往訪" ;
lin little_Adv = variants{} ; -- 
lin easily_Adv = variants{} ; -- 
lin attempt_VV = mkVV "試みる" | mkVV "試す" ;
lin attempt_V2 = mkV2 "試みる" | mkV2 "試す" ;
lin enable_VS = variants{} ; -- 
lin enable_V2V = variants{} ; -- 
lin enable_V2 = variants{} ; -- 
lin trouble_N = mkN "心配事" | mkN "問題" ;
lin traditional_A = mkA "伝統的な" ;
lin payment_N = mkN "支払い" ;
lin best_Adv = ParadigmsJpn.mkAdv "最高" ;
lin post_N = mkN "記事" ;
lin county_N = mkN "郡" ;
lin lady_N = mkN "女官" ;
lin holiday_N = mkN "休日" | mkN "休暇" ;
lin realize_VS = mkVS "悟る" ;
lin realize_V2 = mkV2 "悟る" ;
lin importance_N = mkN "名声" ;
lin chair_N = L.chair_N | mkN "椅子" | mkN "ソファ" ;
lin facility_N = variants{} ; -- 
lin complete_V2 = mkV2 "完了する" | mkV2 "完成する" ;
lin complete_V = mkV "完了する" | mkV "完成する" ;
lin article_N = mkN "品目" | mkN "項目" ;
lin object_N = mkN "目的語" ;
lin context_N = mkN "前後関係" | mkN "状況" ;
lin survey_N = mkN "調査" ;
lin notice_VS = mkVS "気が付く" | mkVS "認める" | mkVS "見掛ける" ;
lin notice_V2 = mkV2 "気が付く" | mkV2 "認める" | mkV2 "見掛ける" ;
lin complete_A = mkA "完成" | mkA "完全な" ;
lin turn_N = mkN "番" ;
lin direct_A = mkA "直接の" ;
lin immediately_Adv = variants{} ; -- 
lin collection_N = mkN "コレクション" ;
lin reference_N = mkN "出典" ;
lin card_N = mkN "カード" ;
lin interesting_A = mkA "面白い" ;
lin considerable_A = variants{} ; -- 
lin television_N = L.television_N | mkN "テレビジョン・チャンネル" | mkN "チャンネル" ;
lin extend_V2 = variants{} ; -- 
lin extend_V = variants{} ; -- 
lin communication_N = mkN "通信" | mkN "コミュニケーション" ;
lin agency_N = mkN "代理店" ;
lin physical_A = mkA "肉体の" ;
lin except_Conj = variants{} ; -- 
lin check_V2 = mkV2 "点検する" | mkV2 "チェックする" ;
lin check_V = mkV "点検する" | mkV "チェックする" ;
lin sun_N = L.sun_N | mkN "太陽" | mkN "恒星" | mkN "日" ;
lin species_N = mkN "種" | mkN "類" | mkN "種類" ;
lin possibility_N = mkN "可能性" ;
lin officialMasc_N = variants{} ; -- 
lin chairman_N = mkN "議長" | mkN "委員長" | mkN "理事長" ;
lin speaker_N = mkN "スピーカー" | mkN "拡音器" ;
lin second_N = mkN "秒" ;
lin career_N = mkN "経歴" | mkN "キャリア" ;
lin laugh_VS = mkVS "一笑に付す" ;
lin laugh_V2 = mkV2 "一笑に付す" ;
lin laugh_V = L.laugh_V | mkV "一笑に付す" ;
lin weight_N = mkN "重さ" | mkN "重量" | mkN "体重" ;
lin sound_VS = mkVS "関係する" ;
lin sound_VA = mkVA "関係する" ;
lin sound_V2 = mkV2 "関係する" ;
lin sound_V = mkV "関係する" ;
lin responsible_A = mkA "責任のある" ;
lin base_N = mkN "基礎" ;
lin document_N = variants{} ; -- 
lin solution_N = mkN "解答" | mkN "解決" | mkN "解法" ;
lin return_N = mkN "復帰" | mkN "返却" | mkN "帰還" ;
lin medical_A = variants{} ; -- 
lin hot_A = L.hot_A | mkA "" | mkA "food] 熱い" ;
lin recognize_VS = mkVS "認める" | mkVS "認識する" ;
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin talk_N = mkN "話し" | mkN "会話" ;
lin budget_N = mkN "予算" | mkN "バジェット" ;
lin river_N = L.river_N | mkN "川" ;
lin fit_V2 = mkV2 "合う" | mkV2 "合わせる" | mkV2 "適合する" ;
lin fit_V = mkV "合う" | mkV "合わせる" | mkV "適合する" ;
lin organization_N = mkN "組織" | mkN "団体" ;
lin existing_A = mkA "現在の" ;
lin start_N = mkN "開始" | mkN "スタート" | mkN "初め" ;
lin push_VS = mkVS "押す" ;
lin push_V2V = mkV2V "押す" ;
lin push_V2 = L.push_V2 | mkV2 "押す" ;
lin push_V = mkV "押す" ;
lin tomorrow_Adv = ParadigmsJpn.mkAdv "明日" | ParadigmsJpn.mkAdv "あす" ;
lin requirement_N = mkN "要求" ;
lin cold_A = L.cold_A | mkA "冷血の" ;
lin edge_N = mkN "きわ" | mkN "際" | mkN "端" | mkN "縁" ;
lin opposition_N = mkN "衝" ;
lin opinion_N = mkN "意見" ;
lin drug_N = mkN "麻薬" ;
lin quarter_N = mkN "四分の一" | mkN "四半" | mkN "四半分" ;
lin option_N = variants{} ; -- 
lin sign_V2 = mkV2 "サインする" ;
lin sign_V = mkV "サインする" ;
lin worth_Prep = variants{} ; -- 
lin call_N = mkN "呼び出し" ;
lin define_V2 = mkV2 "定義する" ;
lin define_V = mkV "定義する" ;
lin stock_N = mkN "証券取引所" | mkN "株式取引所" ;
lin influence_N = mkN "影響" ;
lin occasion_N = mkN "場合" ;
lin eventually_Adv = variants{} ; -- 
lin software_N = mkN "ソフトウェア" | mkN "ソフト" ;
lin highly_Adv = variants{} ; -- 
lin exchange_N = mkN "為替" | mkN "交換" | mkN "両替" | mkN "取り替え" ;
lin lack_N = mkN "不足" ;
lin shake_V2 = mkV2 "握手する" | mkV2 "ハンドシェークする" ;
lin shake_V = mkV "握手する" | mkV "ハンドシェークする" ;
lin study_V2 = mkV2 "学ぶ" | mkV2 "勉強する" ;
lin study_V = mkV "学ぶ" | mkV "勉強する" ;
lin concept_N = mkN "概念" | mkN "観念" ;
lin blue_A = L.blue_A | mkA "青い" | mkA "青の" ;
lin star_N = L.star_N | mkN "主役" | mkN "主演" ;
lin radio_N = L.radio_N | mkN "電波天文学" ;
lin arrangement_N = mkN "配置" ;
lin examine_V2 = mkV2 "診察する" ;
lin bird_N = L.bird_N | mkN "鳥" | mkN "鳥類" ;
lin green_A = L.green_A | mkA "羨ましい" ;
lin band_N = mkN "バンドエイド" ;
lin sex_N = mkN "性交" | mkN "セックス" ;
lin finger_N = mkN "指" ;
lin past_N = mkN "単純過去 、遠過去" ;
lin independent_A = mkA "独立" ;
lin independent_2_A = variants{} ; -- 
lin independent_1_A = variants{} ; -- 
lin equipment_N = mkN "設備" ;
lin north_N = mkN "北" | mkN "北方" ;
lin mind_VS = variants{} ; -- 
lin mind_V2 = variants{} ; -- 
lin mind_V = variants{} ; -- 
lin move_N = mkN "動き" ;
lin message_N = mkN "伝言" | mkN "メッセージ" | mkN "短信" ;
lin fear_N = mkN "恐怖症" ;
lin afternoon_N = mkN "午後" ;
lin drink_V2 = L.drink_V2 | mkV2 "飲む" | mkV2 "召し上がる" | mkV2 "頂く" ;
lin drink_V = mkV "飲む" | mkV "召し上がる" | mkV "頂く" ;
lin fully_Adv = variants{} ; -- 
lin race_N = mkN "人種" ;
lin race_2_N = variants{} ; -- 
lin race_1_N = variants{} ; -- 
lin gain_V2 = variants{} ; -- 
lin gain_V = variants{} ; -- 
lin strategy_N = mkN "戦略" | mkN "機略" | mkN "戦術" | mkN "策略" | mkN "計略" ;
lin extra_A = mkA "余分な" ;
lin scene_N = mkN "現場" | mkN "シーン" ;
lin slightly_Adv = variants{} ; -- 
lin kitchen_N = mkN "台所" | mkN "厨房" | mkN "キッチン" ;
lin speech_N = mkN "演説" ;
lin arise_V = mkV "起こる" ;
lin network_N = mkN "人脈" ;
lin tea_N = mkN "茶道" | mkN "茶の湯" ;
lin peace_N = L.peace_N | mkN "和睦" | mkN "和平" ;
lin failure_N = mkN "失敗" ;
lin employee_N = mkN "従業員" | mkN "雇員" | mkN "勤務員" | mkN "使用人" ;
lin ahead_Adv = ParadigmsJpn.mkAdv "先に" ;
lin scale_N = mkN "強度" | mkN "等級" ;
lin hardly_Adv = variants{} ; -- 
lin attend_V2 = mkV2 "出席する" | mkV2 "立ち会う" ;
lin attend_V = mkV "出席する" | mkV "立ち会う" ;
lin shoulder_N = mkN "肩" ;
lin otherwise_Adv = ParadigmsJpn.mkAdv "違う様に" | ParadigmsJpn.mkAdv "そうではないと" ;
lin railway_N = mkN "鉄道駅" | mkN "駅" ;
lin directly_Adv = variants{} ; -- 
lin supply_N = mkN "供給" ;
lin expression_N = mkN "表現" ;
lin owner_N = mkN "持主" | mkN "所有者" | mkN "オーナー" ;
lin associate_V2 = mkV2 "結び付けて考える" | mkV2 "" | mkV2 "rensōsuru" ;
lin associate_V = mkV "結び付けて考える" | mkV "" | mkV "rensōsuru" ;
lin corner_N = mkN "隅" ;
lin past_A = variants{} ; -- 
lin match_N = mkN "マッチ" ;
lin match_3_N = variants{} ; -- 
lin match_2_N = variants{} ; -- 
lin match_1_N = variants{} ; -- 
lin sport_N = mkN "運動" | mkN "スポーツ" ;
lin status_N = mkN "地位" | mkN "身分" ;
lin beautiful_A = L.beautiful_A | mkA "美しい" | mkA "綺麗" | mkA "素敵" ;
lin offer_N = mkN "提案" | mkN "提供" ;
lin marriage_N = mkN "結婚相談所" ;
lin hang_V2 = mkV2 "どっこい" ;
lin hang_V = mkV "どっこい" ;
lin civil_A = variants{} ; -- 
lin perform_V2 = mkV2 "演奏する" ;
lin perform_V = mkV "演奏する" ;
lin sentence_N = mkN "判決" ;
lin crime_N = mkN "犯罪" | mkN "罪" | mkN "犯行" ;
lin ball_N = mkN "ボール" ;
lin marry_V2 = mkV2 "結婚する" ;
lin marry_V = mkV "結婚する" ;
lin wind_N = L.wind_N | mkN "息" ;
lin truth_N = mkN "真実" | mkN "しんじつ" | mkN "事実" | mkN "じじつ" | mkN "本当" | mkN "ほんとう" | mkN "真理" ;
lin protect_V2 = mkV2 "守る" | mkV2 "保護する" ;
lin protect_V = mkV "守る" | mkV "保護する" ;
lin safety_N = mkN "安全" ;
lin partner_N = mkN "パートナー" ;
lin completely_Adv = variants{} ; -- 
lin copy_N = mkN "コピー" | mkN "複写" ;
lin balance_N = mkN "均衡" | mkN "バランス" | mkN "釣り合い" | mkN "平衡" ;
lin sister_N = L.sister_N | mkN "修道女" | mkN "シスター" ;
lin reader_N = mkN "読者" | mkN "リーダー" ;
lin below_Adv = variants{} ; -- 
lin trial_N = mkN "試行錯誤" ;
lin rock_N = L.rock_N | mkN "ロックンロール" ;
lin damage_N = mkN "痛手" | mkN "損害" | mkN "損傷" ;
lin adopt_V2 = mkV2 "養子にする" ;
lin newspaper_N = L.newspaper_N | mkN "新聞紙" ;
lin meaning_N = mkN "意味" ;
lin light_A = mkA "明るい" ;
lin essential_A = mkA "肝心な" ;
lin obvious_A = mkA "明らか" ;
lin nation_N = mkN "国家" ;
lin confirm_VS = mkVS "確認する" ;
lin confirm_V2 = mkV2 "確認する" ;
lin south_N = mkN "南" | mkN "南方" ;
lin length_N = mkN "長さ" | mkN "全長" ;
lin branch_N = mkN "部門" | mkN "支店" | mkN "支社" ;
lin deep_A = mkA "深い" ;
lin none_NP = variants{} ; -- 
lin planning_N = variants{} ; -- 
lin trust_N = mkN "信" ;
lin working_A = variants{} ; -- 
lin pain_N = mkN "痛み" | mkN "苦痛" ;
lin studio_N = mkN "工房" | mkN "スタジオ" | mkN "画室" ;
lin positive_A = mkA "明確な" ;
lin spirit_N = mkN "精神レベル" ;
lin college_N = mkN "大学" ;
lin accident_N = mkN "事故" ;
lin star_V2 = mkV2 "主演する" ;
lin hope_N = mkN "希望" ;
lin mark_V3 = mkV3 "印をつける" ;
lin mark_V2 = mkV2 "印をつける" ;
lin works_N = variants{} ; -- 
lin league_N = mkN "連盟" | mkN "同盟" ;
lin league_2_N = variants{} ; -- 
lin league_1_N = variants{} ; -- 
lin clear_V2 = mkV2 "取り除く" | mkV2 "透明になる" ;
lin clear_V = mkV "取り除く" | mkV "透明になる" ;
lin imagine_VS = mkVS "想像する" ;
lin imagine_V2 = mkV2 "想像する" ;
lin imagine_V = mkV "想像する" ;
lin through_Adv = variants{}; -- S.through_Prep ;
lin cash_N = variants{} ; -- 
lin normally_Adv = variants{} ; -- 
lin play_N = mkN "遊び" ;
lin strength_N = mkN "力" ;
lin train_N = L.train_N | mkN "行列" ;
lin travel_V2 = mkV2 "旅行する" ;
lin travel_V = L.travel_V | mkV "旅行する" ;
lin target_N = mkN "標的" ;
lin very_A = mkA "正にその" | mkA "正にこの" ;
lin pair_N = mkN "コンパス" ;
lin male_A = mkA "雄" ;
lin gas_N = mkN "ガス室" ;
lin issue_V2 = variants{} ; -- 
lin issue_V = variants{} ; -- 
lin contribution_N = mkN "貢献" ;
lin complex_A = mkA "複素" ;
lin supply_V2 = mkV2 "代理を務める" ;
lin beat_V2 = mkV2 "要点に触れないでいりなさい" ;
lin beat_V = mkV "要点に触れないでいりなさい" ;
lin artist_N = mkN "芸術家" ;
lin agentMasc_N = variants{} ; -- 
lin presence_N = mkN "存在" | mkN "気配" ;
lin along_Adv = ParadigmsJpn.mkAdv "…に沿って" ;
lin environmental_A = variants{} ; -- 
lin strike_V2 = mkV2 "消す" ;
lin strike_V = mkV "消す" ;
lin contact_N = mkN "接触" ;
lin protection_N = mkN "保護" | mkN "防護" ;
lin beginning_N = mkN "開始" | mkN "初め" ;
lin demand_VS = mkVS "要求する" | mkVS "要する" ;
lin demand_V2 = mkV2 "要求する" | mkV2 "要する" ;
lin media_N = mkN "メディア" | mkN "媒体" ;
lin relevant_A = mkA "適切" | mkA "関連した" ;
lin employ_V2 = mkV2 "雇う" | mkV2 "雇用する" ;
lin shoot_V2 = mkV2 "べらべらとしゃべる" ;
lin shoot_V = mkV "べらべらとしゃべる" ;
lin executive_N = mkN "実行委員会" ;
lin slowly_Adv = variants{} ; -- 
lin relatively_Adv = variants{} ; -- 
lin aid_N = mkN "助手" ;
lin huge_A = mkA "巨大な" ;
lin late_Adv = ParadigmsJpn.mkAdv "遅刻に" | ParadigmsJpn.mkAdv "遅く" ;
lin speed_N = mkN "光速" ;
lin review_N = mkN "感想文" | mkN "レビュー" ;
lin test_V2 = mkV2 "テストする" ;
lin order_VS = mkVS "命令する" | mkVS "命じる" ;
lin order_V2V = mkV2V "命令する" | mkV2V "命じる" ;
lin order_V2 = mkV2 "命令する" | mkV2 "命じる" ;
lin order_V = mkV "命令する" | mkV "命じる" ;
lin route_N = mkN "道筋" | mkN "ルート" | mkN "路線" | mkN "通路" ;
lin consequence_N = mkN "結果" ;
lin telephone_N = mkN "電話" ;
lin release_V2 = mkV2 "解放する" | mkV2 "放す" ;
lin proportion_N = mkN "割合" | mkN "比例" ;
lin primary_A = mkA "最初の" ;
lin consideration_N = variants{} ; -- 
lin reform_N = variants{} ; -- 
lin driverMasc_N = variants{} ; -- 
lin annual_A = mkA "毎年" ;
lin nuclear_A = mkA "核" ;
lin latter_A = mkA "後者" ;
lin practical_A = mkA "実践的な" ;
lin commercial_A = mkA "商業の" ;
lin rich_A = mkA "裕福な" | mkA "豊かな" | mkA "富有な" | mkA "金持の" ;
lin emerge_V = mkV "現れる" ;
lin apparently_Adv = variants{} ; -- 
lin ring_V = mkV "聞こえる" ;
lin ring_6_V2 = variants{} ; -- 
lin ring_4_V2 = variants{} ; -- 
lin distance_N = mkN "距離" ;
lin exercise_N = mkN "練習" ;
lin key_A = mkA "キー" ;
lin close_Adv = variants{} ; -- 
lin skin_N = L.skin_N | mkN "痩せこけた" ;
lin island_N = mkN "島" ;
lin separate_A = mkA "分れた" ;
lin aim_VV = mkVV "目指す" | mkVV "狙う" ;
lin aim_V2 = mkV2 "目指す" | mkV2 "狙う" ;
lin aim_V = mkV "目指す" | mkV "狙う" ;
lin danger_N = mkN "危険" ;
lin credit_N = mkN "クレジット" ;
lin usual_A = mkA "通常" | mkA "いつもの" ;
lin link_V2 = variants{} ; -- 
lin link_V = variants{} ; -- 
lin candidateMasc_N = variants{} ; -- 
lin track_N = mkN "陸上競技" ;
lin safe_A = mkA "無事に" ;
lin interested_A = variants{} ; -- 
lin assessment_N = mkN "評価" ;
lin path_N = mkN "道" | mkN "方針" | mkN "軌道" | mkN "道筋" ;
lin merely_Adv = variants{} ; -- 
lin plus_Prep = variants{} ; -- 
lin district_N = mkN "郭" ;
lin regular_A = mkA "規則" | mkA "規則動詞" ;
lin reaction_N = mkN "反応" | mkN "反動" ;
lin impact_N = mkN "衝突クレーター" | mkN "インパクトクレーター" ;
lin collect_V2 = mkV2 "集める" | mkV2 "収集する" ;
lin collect_V = mkV "集める" | mkV "収集する" ;
lin debate_N = mkN "議論" | mkN "討論" ;
lin lay_V2 = mkV2 "置く" | mkV2 "産む" ;
lin lay_V = mkV "置く" | mkV "産む" ;
lin rise_N = mkN "上昇" ;
lin belief_N = mkN "確信" ;
lin conclusion_N = mkN "結論" ;
lin shape_N = mkN "形" | mkN "型" ;
lin vote_N = mkN "投票" ;
lin aim_N = mkN "目標" | mkN "目的" ;
lin politics_N = mkN "政治" ;
lin reply_VS = mkVS "返事する" ;
lin reply_V = mkV "返事する" ;
lin press_V2V = mkV2V "押す" ;
lin press_V2 = mkV2 "押す" ;
lin press_V = mkV "押す" ;
lin approach_V2 = mkV2 "近づく" ;
lin approach_V = mkV "近づく" ;
lin file_N = mkN "ファイル・アロケーション・テーブル" ;
lin western_A = mkA "西の" | mkA "西方の" ;
lin earth_N = L.earth_N | mkN "接地" | mkN "アース" | mkN "グランド" | mkN "グラウンド" ;
lin public_N = mkN "大衆" ;
lin survive_V2 = mkV2 "生き残る" | mkV2 "生き抜く" ;
lin survive_V = mkV "生き残る" | mkV "生き抜く" ;
lin estate_N = variants{} ; -- 
lin boat_N = L.boat_N | mkN "舟" | mkN "ボート" ;
lin prison_N = mkN "監獄" | mkN "刑務所" ;
lin additional_A = variants{} ; -- 
lin settle_V2 = mkV2 "居着く" | mkV2 "落ち着く" ;
lin settle_V = mkV "居着く" | mkV "落ち着く" ;
lin largely_Adv = variants{} ; -- 
lin wine_N = L.wine_N | mkN "ワイン" | mkN "葡萄酒" ;
lin observe_VS = mkVS "守る" | mkVS "従う" ;
lin observe_V2 = mkV2 "守る" | mkV2 "従う" ;
lin limit_V2V = variants{} ; -- 
lin limit_V2 = variants{} ; -- 
lin deny_V3 = variants{} ; -- 
lin deny_V2 = variants{} ; -- 
lin for_PConj = variants{} ; -- 
lin straight_Adv = ParadigmsJpn.mkAdv "真っすぐに" ;
lin somebody_NP = S.somebody_NP ;
lin writer_N = mkN "著者" | mkN "作家" | mkN "筆者" ;
lin weekend_N = mkN "週末" ;
lin clothes_N = mkN "衣服" | mkN "服" | mkN "衣類" ;
lin active_A = mkA "活発な" | mkA "活躍する" "活発な" ;
lin sight_N = mkN "視覚" ;
lin video_N = mkN "ビデオカメラ" ;
lin reality_N = mkN "現実" ;
lin hall_N = mkN "ホール {m}" ;
lin nevertheless_Adv = ParadigmsJpn.mkAdv "それでも" | ParadigmsJpn.mkAdv "やはり" | ParadigmsJpn.mkAdv "それにもかかわらず" | ParadigmsJpn.mkAdv "しかも" ;
lin regional_A = variants{} ; -- 
lin vehicle_N = mkN "乗り物" ;
lin worry_VS = mkVS "心配する" | mkVS "気にする" ;
lin worry_V2 = mkV2 "心配する" | mkV2 "気にする" ;
lin worry_V = mkV "心配する" | mkV "気にする" ;
lin powerful_A = variants{} ; -- 
lin possibly_Adv = variants{} ; -- 
lin cross_V2 = mkV2 "男装する" | mkV2 "女装する" ;
lin cross_V = mkV "男装する" | mkV "女装する" ;
lin colleague_N = mkN "同僚" ;
lin charge_V2 = mkV2 "突撃する" ;
lin charge_V = mkV "突撃する" ;
lin lead_N = mkN "鉛" ;
lin farm_N = mkN "農場" ;
lin respond_VS = variants{} ; -- 
lin respond_V = variants{} ; -- 
lin employer_N = mkN "雇用者" ;
lin carefully_Adv = variants{} ; -- 
lin understanding_N = variants{} ; -- 
lin connection_N = mkN "連結" | mkN "結合" ;
lin comment_N = mkN "コメント" | mkN "論評" ;
lin grant_V3 = mkV3 "認める" ;
lin grant_V2 = mkV2 "認める" ;
lin concentrate_V2 = mkV2 "集中する" ;
lin concentrate_V = mkV "集中する" ;
lin ignore_V2 = mkV2 "顧みない" | mkV2 "無視する" | mkV2 "目をつぶる" ;
lin ignore_V = mkV "顧みない" | mkV "無視する" | mkV "目をつぶる" ;
lin phone_N = mkN "電話" ;
lin hole_N = mkN "穴" ;
lin insurance_N = mkN "保険業" ;
lin content_N = mkN "コンテンツ" ;
lin confidence_N = mkN "信用" | mkN "信頼" | mkN "信任" ;
lin sample_N = mkN "見本" | mkN "サンプル" ;
lin transport_N = mkN "運送" | mkN "輸送" ;
lin objective_N = mkN "目的" ;
lin alone_A = variants{} ; -- 
lin flower_N = L.flower_N | mkN "花" ;
lin injury_N = mkN "傷害" | mkN "負傷" ;
lin lift_V2 = mkV2 "指一本動かす" ;
lin lift_V = mkV "指一本動かす" ;
lin stick_V2 = mkV2 "突き出る" ;
lin stick_V = mkV "突き出る" ;
lin front_A = variants{} ; -- 
lin mainly_Adv = ParadigmsJpn.mkAdv "おもに" | ParadigmsJpn.mkAdv "主に" ;
lin battle_N = mkN "戦い" | mkN "戦" | mkN "戦闘" ;
lin generation_N = mkN "世代" ;
lin currently_Adv = variants{} ; -- 
lin winter_N = mkN "冬" ;
lin inside_Prep = variants{} ; -- 
lin impossible_A = mkA "不可能" ;
lin somewhere_Adv = S.somewhere_Adv | ParadigmsJpn.mkAdv "どこかに" | ParadigmsJpn.mkAdv "どこかで" ;
lin arrange_V2 = mkV2 "整える" ;
lin arrange_V = mkV "整える" ;
lin will_N = mkN "意志" ;
lin sleep_V = L.sleep_V | mkV "寝坊する" | mkV "寝過ごす" ;
lin progress_N = mkN "進歩" | mkN "進行" ;
lin volume_N = mkN "巻" ;
lin ship_N = L.ship_N | mkN "船" | mkN "船舶" ;
lin legislation_N = mkN "法律" ;
lin commitment_N = mkN "委任" | mkN "責任" ;
lin enough_Predet = variants{} ; -- 
lin conflict_N = mkN "衝突" ;
lin bag_N = mkN "鞄" | mkN "袋" | mkN "バッグ" ;
lin fresh_A = mkA "新鮮な" ;
lin entry_N = mkN "入ること" ;
lin entry_2_N = variants{} ; -- 
lin entry_1_N = variants{} ; -- 
lin smile_N = mkN "微笑み" | mkN "笑み" | mkN "笑顔" | mkN "微笑" ;
lin fair_A = mkA "相当な" ;
lin promise_VV = mkVV "約束する" ;
lin promise_VS = mkVS "約束する" ;
lin promise_V2 = mkV2 "約束する" ;
lin promise_V = mkV "約束する" ;
lin introduction_N = mkN "序" | mkN "序論" | mkN "序説" | mkN "" | mkN "叙文" ;
lin senior_A = variants{} ; -- 
lin manner_N = mkN "マナー" ;
lin background_N = mkN "バックグラウンド" ;
lin key_N = mkN "キー" ;
lin key_2_N = variants{} ; -- 
lin key_1_N = variants{} ; -- 
lin touch_V2 = mkV2 "触る" | mkV2 "触れる" | mkV2 "接触する" ;
lin touch_V = mkV "触る" | mkV "触れる" | mkV "接触する" ;
lin vary_V2 = variants{} ; -- 
lin vary_V = variants{} ; -- 
lin sexual_A = mkA "性的" ;
lin ordinary_A = mkA "通常" | mkA "普通" | mkA "平凡" ;
lin cabinet_N = mkN "キャビネット" | mkN "内閣" ;
lin painting_N = mkN "絵画" | mkN "絵" ;
lin entirely_Adv = variants{} ; -- 
lin engine_N = mkN "機車" | mkN "機関車" ;
lin previously_Adv = variants{} ; -- 
lin administration_N = mkN "管理" ;
lin tonight_Adv = ParadigmsJpn.mkAdv "今晩" ;
lin adult_N = mkN "成人" | mkN "大人" ;
lin prefer_VV = mkVV "の方を好む" | mkVV "～の方が好きです" ;
lin prefer_V2 = mkV2 "の方を好む" | mkV2 "～の方が好きです" ;
lin author_N = mkN "著者" | mkN "作家" | mkN "作者" ;
lin actual_A = mkA "実際の" | mkA "現実の" ;
lin song_N = L.song_N | mkN "歌" | mkN "歌曲" ;
lin investigation_N = mkN "調査" ;
lin debt_N = mkN "負債" | mkN "借金" ;
lin visitor_N = mkN "訪問者" | mkN "客人" | mkN "お客さん" ;
lin forest_N = mkN "森" | mkN "森林" | mkN "林" ;
lin repeat_VS = mkVS "繰り返す" ;
lin repeat_V2 = mkV2 "繰り返す" ;
lin repeat_V = mkV "繰り返す" ;
lin wood_N = L.wood_N | mkN "木" | mkN "木材" ;
lin contrast_N = variants{} ; -- 
lin extremely_Adv = variants{} ; -- 
lin wage_N = mkN "給料" | mkN "サラリー" | mkN "賃金" ;
lin domestic_A = mkA "国内" ;
lin commit_V2 = mkV2 "自殺する" ;
lin threat_N = mkN "脅迫" | mkN "脅かし" ;
lin bus_N = mkN "バス" ;
lin warm_A = L.warm_A | mkA "暖かい" | mkA "温かい" ;
lin sir_N = mkN "だんな" | mkN "サー" ;
lin regulation_N = mkN "規則" ;
lin drink_N = mkN "飲用" ;
lin relief_N = mkN "安心" | mkN "救済" ;
lin internal_A = variants{} ; -- 
lin strange_A = mkA "変" | mkA "奇妙" ;
lin excellent_A = mkA "優れた" | mkA "偉い" | mkA "優良" | mkA "素晴らしい" ;
lin run_N = mkN "量" ;
lin fairly_Adv = ParadigmsJpn.mkAdv "公正に" ;
lin technical_A = variants{} ; -- 
lin tradition_N = mkN "伝統" ;
lin measure_V2 = mkV2 "計る" | mkV2 "はかる" | mkV2 "hakaruはかる" | mkV2 "hakaru" ;
lin measure_V = mkV "計る" | mkV "はかる" | mkV "hakaruはかる" | mkV "hakaru" ;
lin insist_VS = mkVS "主張する" ;
lin insist_V2 = mkV2 "主張する" ;
lin insist_V = mkV "主張する" ;
lin farmer_N = mkN "農夫" | mkN "農家" ;
lin until_Prep = variants{} ; -- 
lin traffic_N = mkN "取引" ;
lin dinner_N = mkN "正餐" ;
lin consumer_N = mkN "消費者" ;
lin meal_N = mkN "食事" ;
lin warn_VS = mkVS "警告する" | mkVS "言い聞かせる" ;
lin warn_V2V = mkV2V "警告する" | mkV2V "言い聞かせる" ;
lin warn_V2 = mkV2 "警告する" | mkV2 "言い聞かせる" ;
lin warn_V = mkV "警告する" | mkV "言い聞かせる" ;
lin living_A = variants{} ; -- 
lin package_N = mkN "包み" ;
lin half_N = mkN "異父母兄弟" ;
lin increasingly_Adv = variants{} ; -- 
lin description_N = mkN "記述" | mkN "説明" | mkN "描写" ;
lin soft_A = mkA "半熟" ;
lin stuff_N = mkN "もの" ;
lin award_V3 = variants{} ; -- 
lin award_V2 = variants{} ; -- 
lin existence_N = mkN "存在" ;
lin improvement_N = mkN "改善" ;
lin coffee_N = mkN "コーヒー豆" ;
lin appearance_N = mkN "様子" | mkN "外観" | mkN "見掛け" ;
lin standard_A = variants{} ; -- 
lin attack_V2 = mkV2 "攻撃する" ;
lin sheet_N = mkN "枚" | mkN "シート" ;
lin category_N = mkN "圏" ;
lin distribution_N = mkN "配布" | mkN "配分" | mkN "分布" ;
lin equally_Adv = variants{} ; -- 
lin session_N = mkN "会期" ;
lin cultural_A = mkA "文化的な" | mkA "文化の" ;
lin loan_N = mkN "貸付け" | mkN "ローン" ;
lin bind_V2 = mkV2 "繋ぐ" | mkV2 "繋げる" | mkV2 "縛る" | mkV2 "結ぶ" ;
lin bind_V = mkV "繋ぐ" | mkV "繋げる" | mkV "縛る" | mkV "結ぶ" ;
lin museum_N = mkN "博物館" | mkN "美術館" ;
lin conversation_N = mkN "会話" | mkN "談話" | mkN "対話" | mkN "話し" | mkN "カンバセーション" ;
lin threaten_VV = mkVV "脅す" | mkVV "脅迫する" | mkVV "脅かす" ;
lin threaten_VS = mkVS "脅す" | mkVS "脅迫する" | mkVS "脅かす" ;
lin threaten_V2 = mkV2 "脅す" | mkV2 "脅迫する" | mkV2 "脅かす" ;
lin threaten_V = mkV "脅す" | mkV "脅迫する" | mkV "脅かす" ;
lin link_N = mkN "リンク" ;
lin launch_V2 = mkV2 "発射する" ;
lin launch_V = mkV "発射する" ;
lin proper_A = mkA "元の" | mkA "本来の" | mkA "固有の" | mkA "特有の" | mkA "独特の" ;
lin victim_N = mkN "被災者" ;
lin audience_N = mkN "聴衆" | mkN "観衆" | mkN "観客" ;
lin famous_A = mkA "有名" | mkA "高名" | mkA "名高い" ;
lin master_N = mkN "おぼっちゃま" ;
lin master_2_N = variants{} ; -- 
lin master_1_N = variants{} ; -- 
lin lip_N = mkN "唇" ;
lin religious_A = mkA "信仰的" ;
lin joint_A = variants{} ; -- 
lin cry_V2 = mkV2 "叫ぶ" ;
lin cry_V = mkV "叫ぶ" ;
lin potential_A = mkA "潜在的" ;
lin broad_A = L.broad_A | mkA "幅が…ある" ;
lin exhibition_N = mkN "展覧会" ;
lin experience_V2 = mkV2 "経験する" | mkV2 "体験する" ;
lin judge_N = mkN "裁判官" | mkN "法官" ;
lin formal_A = mkA "正式" | mkA "公式" ;
lin housing_N = variants{} ; -- 
lin past_Prep = variants{} ; -- 
lin concern_V2 = mkV2 "関係する" | mkV2 "心配させる" ;
lin freedom_N = mkN "自由" ;
lin gentleman_N = mkN "紳士" ;
lin attract_V2 = mkV2 "引きつける" ;
lin explanation_N = mkN "説明" ;
lin appoint_V3 = mkV3 "任命する" ;
lin appoint_V2V = mkV2V "任命する" ;
lin appoint_V2 = mkV2 "任命する" ;
lin note_VS = variants{} ; -- 
lin note_V2 = variants{} ; -- 
lin note_V = variants{} ; -- 
lin chief_A = variants{} ; -- 
lin total_N = mkN "総計" ;
lin lovely_A = variants{} ; -- 
lin official_A = mkA "公式" | mkA "公の" ;
lin date_V2 = mkV2 "付き合う" | mkV2 "交際する" | mkV2 "デートする" ;
lin date_V = mkV "付き合う" | mkV "交際する" | mkV "デートする" ;
lin demonstrate_VS = variants{} ; -- 
lin demonstrate_V2 = variants{} ; -- 
lin demonstrate_V = variants{} ; -- 
lin construction_N = mkN "建設" ;
lin middle_N = mkN "中央" | mkN "中間" ;
lin yard_N = mkN "置き場" ;
lin unable_A = variants{} ; -- 
lin acquire_V2 = mkV2 "得る" ;
lin surely_Adv = variants{} ; -- 
lin crisis_N = mkN "境目" ;
lin propose_VV = mkVV "プロポーズする" | mkVV "結婚を申し込む" | mkVV "求婚する" ;
lin propose_VS = mkVS "プロポーズする" | mkVS "結婚を申し込む" | mkVS "求婚する" ;
lin propose_V2 = mkV2 "プロポーズする" | mkV2 "結婚を申し込む" | mkV2 "求婚する" ;
lin propose_V = mkV "プロポーズする" | mkV "結婚を申し込む" | mkV "求婚する" ;
lin west_N = mkN "西" | mkN "西方" ;
lin impose_V2 = mkV2 "課す" ;
lin impose_V = mkV "課す" ;
lin market_V2 = variants{} ; -- 
lin market_V = variants{} ; -- 
lin care_V = mkV "構う" | mkV "気にする" | mkV "気にかける" ;
lin god_N = mkN "神" ;
lin favour_N = variants{} ; -- 
lin before_Adv = ParadigmsJpn.mkAdv "暮れの前に" ;
lin name_V3 = mkV3 "Bに因んで、Aを名付ける" ;
lin name_V2 = mkV2 "Bに因んで、Aを名付ける" ;
lin equal_A = mkA "等しい" | mkA "同じ" ;
lin capacity_N = variants{} ; -- 
lin flat_N = mkN "パンク" | mkN "フラットタイヤ" ;
lin selection_N = mkN "選択" ;
lin alone_Adv = variants{} ; -- 
lin football_N = mkN "サッカー" | mkN "蹴球" ;
lin victory_N = mkN "勝利" | mkN "勝ち" ;
lin factory_N = L.factory_N | mkN "工場" ;
lin rural_A = mkA "農村" | mkA "いなかの" | mkA "ルーラル" ;
lin twice_Adv = ParadigmsJpn.mkAdv "二度" | ParadigmsJpn.mkAdv "二回" | ParadigmsJpn.mkAdv "二倍" ;
lin sing_V2 = mkV2 "歌う" | mkV2 "鳴く" ;
lin sing_V = L.sing_V | mkV "歌う" | mkV "鳴く" ;
lin whereas_Subj = variants{} ; -- 
lin own_V2 = mkV2 "所有する" ;
lin head_V2 = mkV2 "向かう" ;
lin head_V = mkV "向かう" ;
lin examination_N = mkN "試験" ;
lin deliver_V2 = mkV2 "引き渡す" ;
lin deliver_V = mkV "引き渡す" ;
lin nobody_NP = S.nobody_NP ;
lin substantial_A = mkA "物質的な" | mkA "現実の" ;
lin invite_V2V = mkV2V "誘う" | mkV2V "招待する" | mkV2V "招く" | mkV2V "請う" ;
lin invite_V2 = mkV2 "誘う" | mkV2 "招待する" | mkV2 "招く" | mkV2 "請う" ;
lin intention_N = mkN "意図" ;
lin egg_N = L.egg_N | mkN "卵" | mkN "玉子" ;
lin reasonable_A = variants{} ; -- 
lin onto_Prep = variants{} ; -- 
lin retain_V2 = variants{} ; -- 
lin aircraft_N = mkN "航空機" | mkN "飛行機" ;
lin decade_N = mkN "十年" ;
lin cheap_A = mkA "安い" | mkA "安価" | mkA "激安" ;
lin quiet_A = mkA "静かな" ;
lin bright_A = mkA "賢い" | mkA "聡明" ;
lin contribute_V2 = mkV2 "貢献する" ;
lin contribute_V = mkV "貢献する" ;
lin row_N = mkN "行" ;
lin search_N = mkN "検索" | mkN "捜索" ;
lin limit_N = mkN "限度" | mkN "限界" ;
lin definition_N = mkN "定義" | mkN "語義" ;
lin unemployment_N = mkN "失業" ;
lin spread_V2 = mkV2 "散らす" | mkV2 "ばら撒く" ;
lin spread_V = mkV "散らす" | mkV "ばら撒く" ;
lin mark_N = mkN "成績" ;
lin flight_N = mkN "飛" | mkN "飛行" ;
lin account_V2 = variants{} ; -- 
lin account_V = variants{} ; -- 
lin output_N = variants{} ; -- 
lin last_V = mkV "続く" | mkV "継続する" ;
lin tour_N = mkN "旅行" | mkN "旅" | mkN "ツアー" ;
lin address_N = mkN "住所" | mkN "宛名" ;
lin immediate_A = mkA "即時の" ;
lin reduction_N = variants{} ; -- 
lin interview_N = mkN "面接" ;
lin assess_V2 = variants{} ; -- 
lin promote_V2 = mkV2 "増進させる" ;
lin promote_V = mkV "増進させる" ;
lin everybody_NP = S.everybody_NP ;
lin suitable_A = mkA "適切な" | mkA "相応しい" ;
lin growing_A = variants{} ; -- 
lin nod_V = mkV "頷く" ;
lin reject_V2 = mkV2 "拒絶する" ;
lin while_N = variants{} ; -- 
lin high_Adv = variants{} ; -- 
lin dream_N = mkN "夢" | mkN "希望" | mkN "望み" | mkN "ドリーム" ;
lin vote_VV = mkVV "投票する" ;
lin vote_V3 = variants{}; -- mkV2 "投票する" ;
lin vote_V2 = mkV2 "投票する" ;
lin vote_V = mkV "投票する" ;
lin divide_V2 = mkV2 "分割統治" ;
lin divide_V = mkV "分割統治" ;
lin declare_VS = mkVS "宣言する" ;
lin declare_V2 = mkV2 "宣言する" ;
lin declare_V = mkV "宣言する" ;
lin handle_V2 = variants{} ; -- 
lin handle_V = variants{} ; -- 
lin detailed_A = variants{} ; -- 
lin challenge_N = mkN "チャレンジ" | mkN "挑戦" ;
lin notice_N = variants{} ; -- 
lin rain_N = L.rain_N | mkN "雨" ;
lin destroy_V2 = mkV2 "破壊する" | mkV2 "打ち壊す" | mkV2 "滅ぼす" ;
lin mountain_N = L.mountain_N | mkN "山" ;
lin concentration_N = mkN "濃度" ;
lin limited_A = variants{} ; -- 
lin finance_N = mkN "財政" | mkN "金融" | mkN "ファイナンス" ;
lin pension_N = mkN "年金基金" ;
lin influence_V2 = variants{} ; -- 
lin afraid_A = mkA "怖い" ;
lin murder_N = mkN "殺人" ;
lin neck_N = L.neck_N | mkN "首" | mkN "ネック" ;
lin weapon_N = mkN "武器" | mkN "兵器" ;
lin hide_V2 = mkV2 "隠れる" ;
lin hide_V = mkV "隠れる" ;
lin offence_N = variants{} ; -- 
lin absence_N = mkN "欠席" ;
lin error_N = mkN "エラー" | mkN "失策" ;
lin representativeMasc_N = variants{} ; -- 
lin enterprise_N = mkN "企業" | mkN "事業" ;
lin criticism_N = variants{} ; -- 
lin average_A = mkA "平均な" ;
lin quick_A = mkA "速い" ;
lin sufficient_A = mkA "充分な" | mkA "足りる" ;
lin appointment_N = mkN "任命" ;
lin match_V2 = variants{} ; -- 
lin transfer_V = mkV "移す" | mkV "運ぶ" | mkV "乗り換える" ;
lin acid_N = mkN "酸" ;
lin spring_N = mkN "春休み" ;
lin birth_N = mkN "誕生" ;
lin ear_N = L.ear_N | mkN "外耳道" ;
lin recognize_VS = mkVS "認める" | mkVS "認識する" ;
lin recognize_4_V2 = variants{} ; -- 
lin recognize_1_V2 = variants{} ; -- 
lin recommend_V2V = mkV2V "推薦する" | mkV2V "勧める" ;
lin recommend_V2 = mkV2 "推薦する" | mkV2 "勧める" ;
lin module_N = variants{} ; -- 
lin instruction_N = mkN "指示" | mkN "教訓" ;
lin democratic_A = mkA "民主的な" ;
lin park_N = mkN "競技場" ;
lin weather_N = mkN "天気" ;
lin bottle_N = mkN "瓶" ;
lin address_V2 = variants{} ; -- 
lin bedroom_N = mkN "寝室" ;
lin kid_N = mkN "子供" | mkN "子" ;
lin pleasure_N = mkN "喜び" ;
lin realize_VS = mkVS "悟る" ;
lin realize_V2 = mkV2 "悟る" ;
lin assembly_N = mkN "会議" ;
lin expensive_A = mkA "高い" ;
lin select_VV = mkVV "選ぶ" ;
lin select_V2V = mkV2V "選ぶ" ;
lin select_V2 = mkV2 "選ぶ" ;
lin select_V = mkV "選ぶ" ;
lin teaching_N = mkN "教え" | mkN "教訓" ;
lin desire_N = mkN "願望" ;
lin whilst_Subj = variants{} ; -- 
lin contact_V2 = mkV2 "連絡する" ;
lin implication_N = variants{} ; -- 
lin combine_VV = variants{} ; -- 
lin combine_V2 = variants{} ; -- 
lin combine_V = variants{} ; -- 
lin temperature_N = mkN "温度" ;
lin wave_N = mkN "波" ;
lin magazine_N = mkN "弾倉" ;
lin totally_Adv = variants{} ; -- 
lin mental_A = mkA "心の" | mkA "精神的" ;
lin used_A = variants{} ; -- 
lin store_N = variants{} ; -- 
lin scientific_A = mkA "科学的" ;
lin frequently_Adv = variants{} ; -- 
lin thanks_N = variants{} ; -- 
lin beside_Prep = variants{} ; -- 
lin settlement_N = mkN "入植" | mkN "定住" | mkN "植民地" | mkN "前哨地" ;
lin absolutely_Adv = variants{} ; -- 
lin critical_A = variants{} ; -- 
lin critical_2_A = variants{} ; -- 
lin critical_1_A = variants{} ; -- 
lin recognition_N = variants{} ; -- 
lin touch_N = mkN "接触" | mkN "タッチ" ;
lin consist_V = mkV "成り立つ" | mkV "成る" ;
lin below_Prep = variants{} ; -- 
lin silence_N = mkN "静けさ" | mkN "静寂" | mkN "黙秘" ;
lin expenditure_N = mkN "支出" | mkN "出費" | mkN "費用" ;
lin institute_N = mkN "大学" | mkN "学院" ;
lin dress_V2 = mkV2 "服を着せる" ;
lin dress_V = mkV "服を着せる" ;
lin dangerous_A = mkA "危険" | mkA "危ない" ;
lin familiar_A = mkA "おなじみの" ;
lin asset_N = mkN "資産" ;
lin educational_A = variants{} ; -- 
lin sum_N = mkN "総額" ;
lin publication_N = mkN "出版" | mkN "刊行" | mkN "発行" ;
lin partly_Adv = ParadigmsJpn.mkAdv "部分的に" | ParadigmsJpn.mkAdv "一部" ;
lin block_N = mkN "塊" | mkN "まな板" | mkN "区画" | mkN "障害物" | mkN "断頭台" | mkN "アパート" ;
lin seriously_Adv = variants{} ; -- 
lin youth_N = mkN "青春時代" | mkN "青春" | mkN "青少年" ;
lin tape_N = mkN "テープ" ;
lin elsewhere_Adv = ParadigmsJpn.mkAdv "ほかの場所で" ;
lin cover_N = mkN "ブックカバー" | mkN "カバー" ;
lin fee_N = mkN "料金" ;
lin program_N = mkN "プログラム" ;
lin treaty_N = mkN "条約" ;
lin necessarily_Adv = variants{} ; -- 
lin unlikely_A = variants{} ; -- 
lin properly_Adv = variants{} ; -- 
lin guest_N = mkN "宿帳" ;
lin code_N = mkN "規約" ;
lin hill_N = L.hill_N | mkN "マウンド" ;
lin screen_N = mkN "フェンス" | mkN "柵" ;
lin household_N = mkN "家庭" ;
lin sequence_N = mkN "数列" ;
lin correct_A = L.correct_A | mkA "正しい" | mkA "正解" ;
lin female_A = mkA "雌" ;
lin phase_N = mkN "位相差顕微鏡" ;
lin crowd_N = mkN "人込み" | mkN "群衆" ;
lin welcome_V2 = mkV2 "歓迎する" ;
lin metal_N = mkN "金属" ;
lin human_N = mkN "人間" | mkN "人類" | mkN "人" ;
lin widely_Adv = variants{} ; -- 
lin undertake_V2 = mkV2 "取り掛かる" ;
lin cut_N = variants{} ; -- 
lin sky_N = L.sky_N | mkN "空" | mkN "大空" | mkN "天空" ;
lin brain_N = mkN "頭脳" | mkN "知力" ;
lin expert_N = mkN "専門家" | mkN "熟練者" ;
lin experiment_N = mkN "実験" ;
lin tiny_A = mkA "ちっぽけな" | mkA "小っちゃい" ;
lin perfect_A = mkA "完璧な" ;
lin disappear_V = mkV "消える" ;
lin initiative_N = variants{} ; -- 
lin assumption_N = variants{} ; -- 
lin photograph_N = mkN "写真" ;
lin ministry_N = mkN "部" ;
lin congress_N = mkN "会議" ;
lin transfer_N = mkN "移動" | mkN "転勤" ;
lin reading_N = mkN "読書" | mkN "読むこと" ;
lin scientist_N = mkN "科学者" ;
lin fast_Adv = variants{} ; -- 
lin fast_A = mkA "早い" ;
lin closely_Adv = variants{} ; -- 
lin thin_A = L.thin_A | mkA "シャンクした" ;
lin solicitorMasc_N = variants{} ; -- 
lin secure_V2 = variants{} ; -- 
lin plate_N = mkN "皿" ;
lin pool_N = variants{} ; -- 
lin gold_N = L.gold_N | mkN "金色" ;
lin emphasis_N = mkN "強調" | mkN "強勢" ;
lin recall_VS = mkVS "呼び返す" ;
lin recall_V2 = mkV2 "呼び返す" ;
lin shout_V2 = mkV2 "叫ぶ" ;
lin shout_V = mkV "叫ぶ" ;
lin generate_V2 = variants{} ; -- 
lin location_N = mkN "位置" ;
lin display_VS = variants{} ; -- 
lin display_V2 = variants{} ; -- 
lin heat_N = mkN "熱" | mkN "熱さ" | mkN "暑さ" ;
lin gun_N = mkN "銃" | mkN "鉄砲" | mkN "ガン" ;
lin shut_V2 = mkV2 "閉める" | mkV2 "閉まる" | mkV2 "閉じる" ;
lin journey_N = mkN "旅行" | mkN "旅" | mkN "ツアー" ;
lin imply_VS = mkVS "ほのめかす" ;
lin imply_V2 = mkV2 "ほのめかす" ;
lin imply_V = mkV "ほのめかす" ;
lin violence_N = mkN "暴力" ;
lin dry_A = L.dry_A | mkA "乾いた" ;
lin historical_A = mkA "歴史的な" ;
lin step_V2 = mkV2 "歩く" ;
lin step_V = mkV "歩く" ;
lin curriculum_N = mkN "履歴書" ;
lin noise_N = mkN "騒音公害" ;
lin lunch_N = mkN "昼食" | mkN "昼ご飯" | mkN "お昼" | mkN "ランチ" ;
lin fear_VS = L.fear_VS | mkVS "恐れる" | mkVS "怖る" ;
lin fear_V2 = L.fear_V2 | mkV2 "恐れる" | mkV2 "怖る" ;
lin fear_V = mkV "恐れる" | mkV "怖る" ;
lin succeed_V2 = mkV2 "継ぐ" | mkV2 "継承する" ;
lin succeed_V = mkV "継ぐ" | mkV "継承する" ;
lin fall_N = mkN "落下" ;
lin fall_2_N = variants{} ; -- 
lin fall_1_N = variants{} ; -- 
lin bottom_N = mkN "底" | mkN "下部" ;
lin initial_A = variants{} ; -- 
lin theme_N = mkN "テーマ" ;
lin characteristic_N = mkN "特性" ;
lin pretty_Adv = variants{} ; -- 
lin empty_A = L.empty_A | mkA "空の" | mkA "空っぽな" ;
lin display_N = mkN "ディスプレイ" ;
lin combination_N = variants{} ; -- 
lin interpretation_N = mkN "解釈" ;
lin rely_V2 = variants{}; -- mkV "頼る" | mkV "あてにする" ;
lin rely_V = mkV "頼る" | mkV "あてにする" ;
lin escape_VS = mkVS "逃げる" | mkVS "免れる" ;
lin escape_V2 = mkV2 "逃げる" | mkV2 "免れる" ;
lin escape_V = mkV "逃げる" | mkV "免れる" ;
lin score_V2 = variants{} ; -- 
lin score_V = variants{} ; -- 
lin justice_N = mkN "裁判官" | mkN "法官" ;
lin upper_A = mkA "上の" ;
lin tooth_N = L.tooth_N | mkN "歯" ;
lin organize_V2V = mkV2V "組織する" ;
lin organize_V2 = mkV2 "組織する" ;
lin cat_N = L.cat_N | mkN "いたちごっこ" ;
lin tool_N = mkN "ツール" ;
lin spot_N = mkN "斑" | mkN "斑点" | mkN "染み" ;
lin bridge_N = mkN "橋" ;
lin double_A = variants{} ; -- 
lin direct_V2 = variants{} ; -- 
lin direct_V = variants{} ; -- 
lin conclude_VS = variants{} ; -- 
lin conclude_V2 = variants{} ; -- 
lin conclude_V = variants{} ; -- 
lin relative_A = mkA "相対的" ;
lin soldier_N = mkN "警備員" ;
lin climb_V2 = mkV2 "登る" ;
lin climb_V = mkV "登る" ;
lin breath_N = mkN "呼吸" | mkN "息" ;
lin afford_V2V = mkV2V "余裕がある" | mkV2V "ゆとりがある" ;
lin afford_V2 = mkV2 "余裕がある" | mkV2 "ゆとりがある" ;
lin urban_A = variants{} ; -- 
lin nurse_N = mkN "看護師" | mkN "看護士" | mkN "看護婦" | mkN "ナース" ;
lin narrow_A = L.narrow_A | mkA "狭い" ;
lin liberal_A = variants{} ; -- 
lin coal_N = mkN "石炭" ;
lin priority_N = mkN "優先" | mkN "優先権" ;
lin wild_A = mkA "野生の" ;
lin revenue_N = mkN "歳入" ;
lin membership_N = mkN "メンバーシップ" | mkN "会員" ;
lin grant_N = mkN "譲渡" ;
lin approve_V2 = mkV2 "賛成する" ;
lin approve_V = mkV "賛成する" ;
lin tall_A = mkA "高い" ;
lin apparent_A = variants{} ; -- 
lin faith_N = mkN "信頼" | mkN "" | mkN "信奉" | mkN "信仰" | mkN "信念" | mkN "信教" | mkN "信義" | mkN "信義" ;
lin under_Adv = ParadigmsJpn.mkAdv "下の" | ParadigmsJpn.mkAdv "したの" ;
lin fix_V2 = mkV2 "固定する" ;
lin fix_V = mkV "固定する" ;
lin slow_A = mkA "遅い" | mkA "ゆっくり" | mkA "鈍足" ;
lin troop_N = variants{} ; -- 
lin motion_N = mkN "モーションキャプチャ" ;
lin leading_A = variants{} ; -- 
lin component_N = mkN "部分" ;
lin bloody_A = mkA "流血の" ;
lin literature_N = mkN "文献" | mkN "文学" ;
lin conservative_A = variants{} ; -- 
lin variation_N = variants{} ; -- 
lin remind_V2 = mkV2 "思い出させる" ;
lin inform_V2 = mkV2 "告げる" ;
lin inform_V = mkV "告げる" ;
lin alternative_N = mkN "選択肢" ;
lin neither_Adv = variants{} ; -- 
lin outside_Adv = ParadigmsJpn.mkAdv "外に" ;
lin mass_N = mkN "集団墓地" ;
lin busy_A = mkA "忙しい" | mkA "使用中" ;
lin chemical_N = mkN "化学物質" ;
lin careful_A = mkA "思慮深い" ;
lin investigate_V2 = mkV2 "調べる" | mkV2 "検査する" ;
lin investigate_V = mkV "調べる" | mkV "検査する" ;
lin roll_V2 = mkV2 "巻く" ;
lin roll_V = mkV "巻く" ;
lin instrument_N = mkN "計器" ;
lin guide_N = mkN "旅行ガイドブック" ;
lin criterion_N = mkN "基準" | mkN "判断基準" ;
lin pocket_N = mkN "ポケット" | mkN "懐中" ;
lin suggestion_N = mkN "提案" ;
lin aye_Interj = variants{} ; -- 
lin entitle_VS = variants{} ; -- 
lin entitle_V2V = variants{} ; -- 
lin tone_N = mkN "声調" ;
lin attractive_A = mkA "魅力的な" ;
lin wing_N = L.wing_N | mkN "飛行隊" ;
lin surprise_N = mkN "驚き" ;
lin male_N = mkN "雄" | mkN "牡" ;
lin ring_N = mkN "環" ;
lin pub_N = mkN "居酒屋" | mkN "パブ" | mkN "バー" ;
lin fruit_N = L.fruit_N | mkN "ミバエ" ;
lin passage_N = mkN "通過" ;
lin illustrate_VS = variants{} ; -- 
lin illustrate_V2 = variants{} ; -- 
lin illustrate_V = variants{} ; -- 
lin pay_N = mkN "有料テレビ" | mkN "ペイテレビ" ;
lin ride_V2 = mkV2 "乗る" ;
lin ride_V = mkV "乗る" ;
lin foundation_N = mkN "ファンデーション" ;
lin restaurant_N = L.restaurant_N | mkN "レストラン" | mkN "食堂" | mkN "料理屋" | mkN "料理店" ;
lin vital_A = variants{} ; -- 
lin alternative_A = mkA "代替" ;
lin burn_V2 = mkV2 "燃える" | mkV2 "焼ける" ;
lin burn_V = L.burn_V | mkV "燃える" | mkV "焼ける" ;
lin map_N = mkN "地図" ;
lin united_A = mkA "連合した" ;
lin device_N = mkN "装置" | mkN "デバイス" ;
lin jump_V2 = mkV2 "飛び降りる" ;
lin jump_V = L.jump_V | mkV "飛び降りる" ;
lin estimate_VS = variants{} ; -- 
lin estimate_V2V = variants{} ; -- 
lin estimate_V2 = variants{} ; -- 
lin estimate_V = variants{} ; -- 
lin conduct_V2 = variants{} ; -- 
lin conduct_V = variants{} ; -- 
lin derive_V2 = variants{} ; -- 
lin derive_V = variants{} ; -- 
lin comment_VS = mkVS "論評する" ;
lin comment_V2 = mkV2 "論評する" ;
lin comment_V = mkV "論評する" ;
lin east_N = mkN "東" | mkN "東方" ;
lin advise_VS = mkVS "助言する" ;
lin advise_V2 = mkV2 "助言する" ;
lin advise_V = mkV "助言する" ;
lin advance_N = variants{} ; -- 
lin motor_N = mkN "モーター" | mkN "エンジン" | mkN "機関" | mkN "機械" | mkN "発動機" | mkN "原動機" ;
lin satisfy_V2 = mkV2 "満たす" ;
lin hell_N = mkN "地獄" ;
lin winner_N = mkN "勝者" | mkN "勝利者" | mkN "ウィナー" | mkN "優勝者" ;
lin effectively_Adv = variants{} ; -- 
lin mistake_N = mkN "間違い" | mkN "過ち" | mkN "誤り" | mkN "錯誤" | mkN "ミス" | mkN "エラー" ;
lin incident_N = mkN "事故" ;
lin focus_V2 = mkV2 "絞る" ;
lin focus_V = mkV "絞る" ;
lin exercise_VV = mkVV "練習する" ;
lin exercise_V2 = mkV2 "練習する" ;
lin exercise_V = mkV "練習する" ;
lin representation_N = variants{} ; -- 
lin release_N = mkN "リリース" ;
lin leaf_N = L.leaf_N | mkN "葉" | mkN "葉っぱ" | mkN "木の葉" ;
lin border_N = mkN "国境" | mkN "地境" ;
lin wash_V2 = L.wash_V2 | mkV2 "洗面する" ;
lin wash_V = mkV "洗面する" ;
lin prospect_N = mkN "見通し" ;
lin blow_V2 = mkV2 "鼻をかむ" ;
lin blow_V = L.blow_V | mkV "鼻をかむ" ;
lin trip_N = mkN "無作法" | mkN "不作法" | mkN "不謹慎" ;
lin observation_N = mkN "観察" ;
lin gather_V2 = mkV2 "集める" | mkV2 "収集する" ;
lin gather_V = mkV "集める" | mkV "収集する" ;
lin ancient_A = mkA "古代" | mkA "古い" ;
lin brief_A = mkA "短い" ;
lin gate_N = mkN "ゲート" ;
lin elderly_A = mkA "年配" | mkA "やや年とった" ;
lin persuade_V2V = mkV2V "説得する" | mkV2V "説く" ;
lin persuade_V2 = mkV2 "説得する" | mkV2 "説く" ;
lin overall_A = variants{} ; -- 
lin rare_A = mkA "珍しい" ;
lin index_N = mkN "索引" | mkN "インデックス" | mkN "表題" | mkN "指数" | mkN "指標" | mkN "総目録" ;
lin hand_V2 = mkV2 "配る" | mkV2 "配布する" ;
lin circle_N = mkN "円" | mkN "丸" | mkN "円形" ;
lin creation_N = mkN "創造" | mkN "創作" ;
lin drawing_N = mkN "抽選" ;
lin anybody_NP = variants{} ; -- 
lin flow_N = mkN "フローチャート" ;
lin matter_V = mkV "重要である" ;
lin external_A = mkA "外側の" | mkA "外部の" ;
lin capable_A = mkA "有能" ;
lin recover_V = mkV "回復する" ;
lin shot_N = mkN "ショット" ;
lin request_N = mkN "依頼" | mkN "要求" ;
lin impression_N = mkN "印象" ;
lin neighbour_N = mkN "隣人" | mkN "近所の人" ;
lin theatre_N = variants{} ; -- 
lin beneath_Prep = variants{} ; -- 
lin hurt_V2 = mkV2 "傷つける" | mkV2 "痛い" ;
lin hurt_V = mkV "傷つける" | mkV "痛い" ;
lin mechanism_N = mkN "機構" ;
lin potential_N = mkN "可能性" | mkN "ポテンシャル" | mkN "戦力" ;
lin lean_V2 = mkV2 "傾く" ;
lin lean_V = mkV "傾く" ;
lin defendant_N = mkN "被告" ;
lin atmosphere_N = mkN "雰囲気" | mkN "空気" ;
lin slip_V2 = variants{} ; -- 
lin slip_V = variants{} ; -- 
lin chain_N = mkN "連鎖反応" ;
lin accompany_V2 = mkV2 "付き合う" ;
lin wonderful_A = mkA "素晴しい" ;
lin earn_V2 = mkV2 "値する" ;
lin earn_V = mkV "値する" ;
lin enemy_N = L.enemy_N | mkN "敵国" ;
lin desk_N = mkN "机" ;
lin engineering_N = mkN "工学" | mkN "工務" | mkN "エンジニアリング" ;
lin panel_N = mkN "パネル" ;
lin distinction_N = variants{} ; -- 
lin deputy_N = mkN "代議士" ;
lin discipline_N = mkN "規律" ;
lin strike_N = mkN "ストライク" ;
lin strike_2_N = variants{} ; -- 
lin strike_1_N = variants{} ; -- 
lin married_A = mkA "結婚している" ;
lin plenty_NP = variants{} ; -- 
lin establishment_N = mkN "エスタブリッシュメント" ;
lin fashion_N = mkN "流行" | mkN "はやり" | mkN "ファッション" ;
lin roof_N = L.roof_N | mkN "屋根" ;
lin milk_N = L.milk_N | mkN "牛乳" | mkN "ミルク" | mkN "お乳" ;
lin entire_A = mkA "全部の" | mkA "全体の" ;
lin tear_N = mkN "涙" ;
lin secondary_A = variants{} ; -- 
lin finding_N = variants{} ; -- 
lin welfare_N = mkN "福祉" ;
lin increased_A = variants{} ; -- 
lin attach_V2 = mkV2 "付ける" | mkV2 "添付する" ;
lin attach_V = mkV "付ける" | mkV "添付する" ;
lin typical_A = variants{} ; -- 
lin typical_3_A = variants{} ; -- 
lin typical_2_A = variants{} ; -- 
lin typical_1_A = variants{} ; -- 
lin meanwhile_Adv = ParadigmsJpn.mkAdv "その間に" ;
lin leadership_N = mkN "リーダーシップ" | mkN "指導力" ;
lin walk_N = mkN "四球" | mkN "フォアボール" ;
lin negotiation_N = mkN "交渉" ;
lin clean_A = L.clean_A | mkA "綺麗" | mkA "清潔な" ;
lin religion_N = L.religion_N ;
lin count_V2 = L.count_V2 | mkV2 "数える" ;
lin count_V = mkV "数える" ;
lin grey_A = variants{} ; -- 
lin hence_Adv = ParadigmsJpn.mkAdv "それ故に" ;
lin alright_Adv = variants{} ; -- 
lin first_A = variants{} ; -- 
lin fuel_N = mkN "燃料" ;
lin mine_N = mkN "地雷" ;
lin appeal_V2 = mkV2 "訴える" ;
lin appeal_V = mkV "訴える" ;
lin servantMasc_N = variants{} ; -- 
lin liability_N = mkN "負債" | mkN "借金" ;
lin constant_A = variants{} ; -- 
lin hate_VV = mkVV "憎む" | mkVV "嫌う" | mkVV "いやである" | mkVV "大嫌い" ;
lin hate_V2 = L.hate_V2 | mkV2 "憎む" | mkV2 "嫌う" | mkV2 "いやである" | mkV2 "大嫌い" ;
lin shoe_N = L.shoe_N | mkN "靴墨" | mkN "靴クリーム" ;
lin expense_N = variants{} ; -- 
lin vast_A = mkA "広大" | mkA "莫大" ;
lin soil_N = mkN "土" ;
lin writing_N = mkN "著作" ;
lin nose_N = L.nose_N | mkN "鼻" ;
lin origin_N = mkN "起源" | mkN "原因" ;
lin lord_N = variants{} ; -- 
lin rest_V2 = mkV2 "休む" ;
lin drive_N = mkN "ドライブ" ;
lin ticket_N = mkN "券" | mkN "チケット" | mkN "切符" ;
lin editor_N = mkN "編集長" ;
lin switch_V2 = variants{} ; -- 
lin switch_V = variants{} ; -- 
lin provided_Subj = variants{} ; -- 
lin northern_A = variants{} ; -- 
lin significance_N = mkN "重要性" ;
lin channel_N = mkN "チャンネル" ;
lin convention_N = variants{} ; -- 
lin damage_V2 = variants{} ; -- 
lin funny_A = mkA "面白い" | mkA "可笑しい" ;
lin bone_N = L.bone_N | mkN "骨" ;
lin severe_A = mkA "厳しい" ;
lin search_V2 = mkV2 "探す" ;
lin search_V = mkV "探す" ;
lin iron_N = L.iron_N | mkN "鉄のカーテン" ;
lin vision_N = mkN "啓示" ;
lin via_Prep = variants{} ; -- 
lin somewhat_Adv = ParadigmsJpn.mkAdv "多少" | ParadigmsJpn.mkAdv "やや" | ParadigmsJpn.mkAdv "ある程度" ;
lin inside_Adv = ParadigmsJpn.mkAdv "中に" ;
lin trend_N = mkN "トレンド" ;
lin revolution_N = mkN "革命" | mkN "改革" ;
lin terrible_A = mkA "恐ろしい" | mkA "猛烈な" | mkA "ひどい" ;
lin knee_N = L.knee_N | mkN "膝" ;
lin dress_N = mkN "衣服" ;
lin unfortunately_Adv = ParadigmsJpn.mkAdv "生憎" | ParadigmsJpn.mkAdv "残念ながら" ;
lin steal_V2 = mkV2 "盗塁する" ;
lin steal_V = mkV "盗塁する" ;
lin criminal_A = mkA "犯罪的" | mkA "犯罪" ;
lin signal_N = mkN "信号" ;
lin notion_N = variants{} ; -- 
lin comparison_N = mkN "比較" ;
lin academic_A = mkA "学問の" | mkA "大学の" ;
lin outcome_N = mkN "結果" ;
lin lawyer_N = mkN "弁護士" | mkN "法曹" ;
lin strongly_Adv = variants{} ; -- 
lin surround_V2 = mkV2 "囲む" | mkV2 "取り巻く" ;
lin explore_VS = mkVS "探検する" ;
lin explore_V2 = mkV2 "探検する" ;
lin achievement_N = mkN "達成" | mkN "到達" | mkN "業績" | mkN "成果" | mkN "成績" ;
lin odd_A = mkA "変" ;
lin expectation_N = variants{} ; -- 
lin corporate_A = variants{} ; -- 
lin prisoner_N = mkN "とりこ" ;
lin question_V2 = variants{} ; -- 
lin rapidly_Adv = variants{} ; -- 
lin deep_Adv = variants{} ; -- 
lin southern_A = variants{} ; -- 
lin amongst_Prep = variants{} ; -- 
lin withdraw_V2 = mkV2 "引き出す" | mkV2 "下ろす" ;
lin withdraw_V = mkV "引き出す" | mkV "下ろす" ;
lin afterwards_Adv = ParadigmsJpn.mkAdv "その後" | ParadigmsJpn.mkAdv "それから" | ParadigmsJpn.mkAdv "後で" ;
lin paint_V2 = mkV2 "塗る" ;
lin paint_V = mkV "塗る" ;
lin judge_VS = mkVS "判断する" ;
lin judge_V2 = mkV2 "判断する" ;
lin judge_V = mkV "判断する" ;
lin citizenMasc_N = variants{} ; -- 
lin permanent_A = mkA "永久の" ;
lin weak_A = mkA "薄い" ;
lin separate_V2 = mkV2 "分ける" ;
lin separate_V = mkV "分ける" ;
lin plastic_N = L.plastic_N | mkN "プラスチック" ;
lin connect_V2 = mkV2 "繋ぐ" ;
lin connect_V = mkV "繋ぐ" ;
lin fundamental_A = mkA "基本的な" ;
lin plane_N = mkN "鉋" ;
lin height_N = mkN "高さ" | mkN "高度" ;
lin opening_N = mkN "営業時間" ;
lin lesson_N = mkN "授業" | mkN "学課" | mkN "-課" | mkN "レッスン" ;
lin similarly_Adv = variants{} ; -- 
lin shock_N = mkN "ショックアブソーバー" | mkN "緩衝器" ;
lin rail_N = mkN "手すり" ;
lin tenant_N = mkN "賃借人" | mkN "賃借人" ;
lin owe_V2 = mkV2 "借りがある" | mkV2 "負う" ;
lin owe_V = mkV "借りがある" | mkV "負う" ;
lin originally_Adv = variants{} ; -- 
lin middle_A = mkA "中間の" ;
lin somehow_Adv = ParadigmsJpn.mkAdv "なぜか" | ParadigmsJpn.mkAdv "何とか" ;
lin minor_A = variants{} ; -- 
lin negative_A = mkA "負" ;
lin knock_V2 = mkV2 "ノックする" | mkV2 "叩く" ;
lin knock_V = mkV "ノックする" | mkV "叩く" ;
lin root_N = L.root_N | mkN "歯根" ;
lin pursue_V2 = mkV2 "追跡する" ;
lin pursue_V = mkV "追跡する" ;
lin inner_A = variants{} ; -- 
lin crucial_A = variants{} ; -- 
lin occupy_V2 = mkV2 "占める" ;
lin occupy_V = mkV "占める" ;
lin that_AdA = variants{} ; -- 
lin independence_N = mkN "独立" ;
lin column_N = mkN "縦列" ;
lin proceeding_N = variants{} ; -- 
lin female_N = mkN "女性" | mkN "雌" ;
lin beauty_N = mkN "美人" | mkN "美女" | mkN "別嬪" ;
lin perfectly_Adv = variants{} ; -- 
lin struggle_N = mkN "奮闘" | mkN "闘争" ;
lin gap_N = variants{} ; -- 
lin house_V2 = variants{} ; -- 
lin database_N = mkN "データベース管理者" ;
lin stretch_V2 = mkV2 "伸ばす" ;
lin stretch_V = mkV "伸ばす" ;
lin stress_N = mkN "ストレス" ;
lin passenger_N = mkN "乗客" ;
lin boundary_N = mkN "境界" | mkN "境" ;
lin easy_Adv = variants{} ; -- 
lin view_V2 = variants{} ; -- 
lin manufacturer_N = mkN "メーカー" | mkN "製造業者" ;
lin sharp_A = L.sharp_A | mkA "するどい" ;
lin formation_N = variants{} ; -- 
lin queen_N = L.queen_N | mkN "女王バチ juō-bachi" ;
lin waste_N = mkN "荒れ地" ;
lin virtually_Adv = variants{} ; -- 
lin expand_V2 = variants{} ; -- 
lin expand_V = variants{} ; -- 
lin contemporary_A = mkA "現代的" ;
lin politician_N = mkN "政治家" | mkN "政客" ;
lin back_V = mkV "戻る" | mkV "帰る" | mkV "逆行する" ;
lin territory_N = mkN "領土" ;
lin championship_N = mkN "選手権大会" ;
lin exception_N = mkN "例外" ;
lin thick_A = L.thick_A | mkA "混んだ" ;
lin inquiry_N = mkN "問い合わせ" | mkN "調査" ;
lin topic_N = mkN "話題" | mkN "テーマ" | mkN "トピック" | mkN "主題" ;
lin resident_N = mkN "居住者" | mkN "住民" ;
lin transaction_N = mkN "処理" ;
lin parish_N = mkN "小教区" ;
lin supporter_N = variants{} ; -- 
lin massive_A = variants{} ; -- 
lin light_V2 = mkV2 "照らす" ;
lin light_V = mkV "照らす" ;
lin unique_A = mkA "唯一" | mkA "唯一無二" | mkA "ユニーク" ;
lin challenge_V2 = variants{} ; -- 
lin challenge_V = variants{} ; -- 
lin inflation_N = mkN "膨張" | mkN "膨らみ" ;
lin assistance_N = mkN "援助" ;
lin list_V2V = mkV2V "列記する" | mkV2V "リストする" ;
lin list_V2 = mkV2 "列記する" | mkV2 "リストする" ;
lin list_V = mkV "列記する" | mkV "リストする" ;
lin identity_N = mkN "単位行列" ;
lin suit_V2 = mkV2 "適合する" | mkV2 "似合う" ;
lin suit_V = mkV "適合する" | mkV "似合う" ;
lin parliamentary_A = variants{} ; -- 
lin unknown_A = mkA "未知" | mkA "不明" | mkA "知らない" ;
lin preparation_N = mkN "準備" | mkN "支度" ;
lin elect_V3 = mkV3 "選挙する" ;
lin elect_V2V = mkV2V "選挙する" ;
lin elect_V2 = mkV2 "選挙する" ;
lin elect_V = mkV "選挙する" ;
lin badly_Adv = variants{} ; -- 
lin moreover_Adv = ParadigmsJpn.mkAdv "その上に" | ParadigmsJpn.mkAdv "さらに" | ParadigmsJpn.mkAdv "しかも" ;
lin tie_V2 = L.tie_V2 | mkV2 "結ぶ" ;
lin tie_V = mkV "結ぶ" ;
lin cancer_N = mkN "癌" ;
lin champion_N = mkN "チャンピオン" | mkN "優勝者" ;
lin exclude_V2 = variants{} ; -- 
lin review_V2 = variants{} ; -- 
lin review_V = variants{} ; -- 
lin licence_N = variants{} ; -- 
lin breakfast_N = mkN "朝食" | mkN "朝御飯" | mkN "朝飯" ;
lin minority_N = mkN "少数" ;
lin appreciate_V2 = mkV2 "理解する" ;
lin appreciate_V = mkV "理解する" ;
lin fan_N = variants{} ; -- 
lin fan_3_N = variants{} ; -- 
lin fan_2_N = variants{} ; -- 
lin fan_1_N = variants{} ; -- 
lin chief_N = mkN "最高経営責任者" ;
lin accommodation_N = mkN "調節" | mkN "調整" ;
lin subsequent_A = mkA "結果として起こる" ;
lin democracy_N = mkN "民主主義" ;
lin brown_A = L.brown_A | mkA "茶色い" | mkA "褐色" ;
lin taste_N = mkN "趣味" | mkN "味" ;
lin crown_N = mkN "頭頂" ;
lin permit_V2V = mkV2V "許可する" | mkV2V "許す" ;
lin permit_V2 = mkV2 "許可する" | mkV2 "許す" ;
lin permit_V = mkV "許可する" | mkV "許す" ;
lin buyerMasc_N = variants{} ; -- 
lin gift_N = mkN "天分" | mkN "才能" | mkN "天才" ;
lin resolution_N = mkN "解決" ;
lin angry_A = mkA "怒った" ;
lin metre_N = mkN "メートル ㍍" ;
lin wheel_N = mkN "車輪" | mkN "輪" ;
lin clause_N = mkN "節" ;
lin break_N = mkN "ブレーク" ;
lin tank_N = mkN "タンク" ;
lin benefit_V2 = mkV2 "役立つ" ;
lin benefit_V = mkV "役立つ" ;
lin engage_V2 = variants{} ; -- 
lin engage_V = variants{} ; -- 
lin alive_A = mkA "生きている" ;
lin complaint_N = mkN "不平" | mkN "不満" | mkN "文句" ;
lin inch_N = mkN "インチ" ;
lin firm_A = variants{} ; -- 
lin abandon_V2 = mkV2 "見捨てる" ;
lin blame_V2 = mkV2 "責める" ;
lin blame_V = mkV "責める" ;
lin clean_V2 = mkV2 "きれいにする" ;
lin clean_V = mkV "きれいにする" ;
lin quote_V2 = mkV2 "引用する" ;
lin quote_V = mkV "引用する" ;
lin quantity_N = mkN "量" | mkN "数量" ;
lin rule_VS = mkVS "統治する" ;
lin rule_V2 = mkV2 "統治する" ;
lin rule_V = mkV "統治する" ;
lin guilty_A = mkA "有罪の" | mkA "やましい" ;
lin prior_A = variants{} ; -- 
lin round_A = L.round_A | mkA "丸い" ;
lin eastern_A = mkA "東の" | mkA "東方の" ;
lin coat_N = L.coat_N | mkN "塗装" | mkN "コーティング" ;
lin involvement_N = variants{} ; -- 
lin tension_N = mkN "緊張" | mkN "不安" ;
lin diet_N = mkN "ダイエット" ;
lin enormous_A = mkA "巨大な" ;
lin score_N = mkN "楽譜" ;
lin rarely_Adv = variants{} ; -- 
lin prize_N = mkN "戦利品" ;
lin remaining_A = variants{} ; -- 
lin significantly_Adv = variants{} ; -- 
lin glance_V2 = mkV2 "一目見る" | mkV2 "一瞥する" ;
lin glance_V = mkV "一目見る" | mkV "一瞥する" ;
lin dominate_V2 = variants{} ; -- 
lin dominate_V = variants{} ; -- 
lin trust_VS = variants{} ; -- 
lin trust_V2 = variants{} ; -- 
lin naturally_Adv = variants{} ; -- 
lin interpret_V2 = mkV2 "通訳する" ;
lin interpret_V = mkV "通訳する" ;
lin land_V2 = mkV2 "着陸する" | mkV2 "上陸させる" ;
lin land_V = mkV "着陸する" | mkV "上陸させる" ;
lin frame_N = variants{} ; -- 
lin extension_N = mkN "拡張" | mkN "拡大" | mkN "伸展" | mkN "延長" ;
lin mix_V2 = mkV2 "まぜる" ;
lin mix_V = mkV "まぜる" ;
lin spokesman_N = variants{} ; -- 
lin friendly_A = mkA "気さく" | mkA "友好的" ;
lin acknowledge_VS = mkVS "承認する" | mkVS "認める" ;
lin acknowledge_V2 = mkV2 "承認する" | mkV2 "認める" ;
lin register_V2 = mkV2 "登録する" ;
lin register_V = mkV "登録する" ;
lin regime_N = variants{} ; -- 
lin regime_2_N = variants{} ; -- 
lin regime_1_N = variants{} ; -- 
lin fault_N = mkN "欠点" | mkN "欠陥" ;
lin dispute_N = mkN "論争" | mkN "議論" ;
lin grass_N = L.grass_N | mkN "草" ;
lin quietly_Adv = ParadigmsJpn.mkAdv "静かに" ;
lin decline_N = variants{} ; -- 
lin dismiss_V2 = mkV2 "解雇する" ;
lin delivery_N = mkN "配達" | mkN "引き渡し" | mkN "伝送" ;
lin complain_VS = mkVS "ぼやく" | mkVS "ぶつぶつ言う" | mkVS "とやかく言う" ;
lin complain_V = mkV "ぼやく" | mkV "ぶつぶつ言う" | mkV "とやかく言う" ;
lin conservative_N = variants{} ; -- 
lin shift_V2 = variants{} ; -- 
lin shift_V = variants{} ; -- 
lin port_N = mkN "ポート" ;
lin beach_N = mkN "浜" | mkN "ビーチ" | mkN "海岸" ;
lin string_N = mkN "弦" | mkN "弓弦" ;
lin depth_N = mkN "深さ" ;
lin unusual_A = mkA "珍しい" ;
lin travel_N = mkN "旅行" ;
lin pilot_N = mkN "パイロット" ;
lin obligation_N = mkN "義務" | mkN "責任" ;
lin gene_N = mkN "遺伝子" ;
lin yellow_A = L.yellow_A | mkA "黄色い" ;
lin republic_N = mkN "共和国" ;
lin shadow_N = mkN "影" | mkN "陰影" ;
lin dear_A = mkA "親愛なる" ;
lin analyse_V2 = variants{} ; -- 
lin anywhere_Adv = ParadigmsJpn.mkAdv "どこでも" ;
lin average_N = mkN "平均" ;
lin phrase_N = mkN "句" ;
lin long_term_A = variants{} ; -- 
lin crew_N = mkN "クルー" ;
lin lucky_A = mkA "運の良い" ;
lin restore_V2 = variants{} ; -- 
lin convince_V2V = mkV2V "説得する" | mkV2V "納得させる" | mkV2V "自覚させる" ;
lin convince_V2 = mkV2 "説得する" | mkV2 "納得させる" | mkV2 "自覚させる" ;
lin coast_N = mkN "海岸" ;
lin engineer_N = mkN "機関士" ;
lin heavily_Adv = variants{} ; -- 
lin extensive_A = mkA "広汎な" ;
lin glad_A = variants{} ; -- 
lin charity_N = mkN "慈善" ;
lin oppose_V2 = mkV2 "反対する" ;
lin oppose_V = mkV "反対する" ;
lin defend_V2 = mkV2 "守る" | mkV2 "防ぐ" ;
lin alter_V2 = mkV2 "変える" | mkV2 "変更する" | mkV2 "直す" ;
lin alter_V = mkV "変える" | mkV "変更する" | mkV "直す" ;
lin warning_N = mkN "警告" ;
lin arrest_V2 = mkV2 "逮捕する" | mkV2 "捕える" ;
lin framework_N = mkN "構造" | mkN "フレームワーク" | mkN "骨組み" ;
lin approval_N = mkN "賛成" | mkN "承認" ;
lin bother_VV = variants{} ; -- 
lin bother_V2V = variants{} ; -- 
lin bother_V2 = variants{} ; -- 
lin bother_V = variants{} ; -- 
lin novel_N = mkN "小説" ;
lin accuse_V2 = mkV2 "問う" | mkV2 "着せる" ;
lin surprised_A = mkA "びっくりした" ;
lin currency_N = mkN "通貨" | mkN "貨幣" ;
lin restrict_V2 = mkV2 "制限する" ;
lin restrict_V = mkV "制限する" ;
lin possess_V2 = mkV2 "所持する" | mkV2 "所有する" | mkV2 "占有する" ;
lin moral_A = variants{} ; -- 
lin protein_N = mkN "蛋白質" ;
lin distinguish_V2 = mkV2 "目立つ" ;
lin distinguish_V = mkV "目立つ" ;
lin gently_Adv = ParadigmsJpn.mkAdv "そっと" ;
lin reckon_VS = variants{} ; -- 
lin incorporate_V2 = variants{} ; -- 
lin proceed_V = mkV "前進する" ;
lin assist_V2 = mkV2 "手伝う" ;
lin assist_V = mkV "手伝う" ;
lin sure_Adv = variants{} ; -- 
lin stress_VS = variants{} ; -- 
lin stress_V2 = variants{} ; -- 
lin justify_VV = mkVV "言い開く" ;
lin justify_V2 = mkV2 "言い開く" ;
lin behalf_N = variants{} ; -- 
lin councillor_N = variants{} ; -- 
lin setting_N = mkN "設定" ;
lin command_N = mkN "命令" ;
lin command_2_N = variants{} ; -- 
lin command_1_N = variants{} ; -- 
lin maintenance_N = mkN "保守" | mkN "維持" ;
lin stair_N = mkN "階段" ;
lin poem_N = mkN "詩" | mkN "詩歌" ;
lin chest_N = mkN "胸" | mkN "胸郭" ;
lin like_Adv = ParadigmsJpn.mkAdv "スポンジが水を吸うように" | ParadigmsJpn.mkAdv "水を得た魚" ;
lin secret_N = mkN "秘密" ;
lin restriction_N = variants{} ; -- 
lin efficient_A = variants{} ; -- 
lin suspect_VS = mkVS "疑う" ;
lin suspect_V2 = mkV2 "疑う" ;
lin hat_N = L.hat_N | mkN "帽子" | mkN "ハット" ;
lin tough_A = mkA "辛い" | mkA "たいへん" | mkA "きつい" ;
lin firmly_Adv = variants{} ; -- 
lin willing_A = variants{} ; -- 
lin healthy_A = mkA "健康的な" ;
lin focus_N = mkN "集中" ;
lin construct_V2 = mkV2 "構築する" ;
lin occasionally_Adv = variants{} ; -- 
lin mode_N = mkN "輸送手段" ;
lin saving_N = variants{} ; -- 
lin comfortable_A = mkA "気楽" | mkA "安楽" ;
lin camp_N = mkN "キャンプ" | mkN "幕営" | mkN "収容所" ;
lin trade_V2 = variants{} ; -- 
lin trade_V = variants{} ; -- 
lin export_N = mkN "輸出品" ;
lin wake_V2 = mkV2 "起こす" ;
lin wake_V = mkV "起こす" ;
lin partnership_N = variants{} ; -- 
lin daily_A = mkA "毎日の" ;
lin abroad_Adv = ParadigmsJpn.mkAdv "海外に" | ParadigmsJpn.mkAdv "国外に" ;
lin profession_N = mkN "職業" ;
lin load_N = mkN "多量" ;
lin countryside_N = mkN "田舎" ;
lin boot_N = L.boot_N | mkN "ブーツ" | mkN "ブート" ;
lin mostly_Adv = variants{} ; -- 
lin sudden_A = mkA "突然の" ;
lin implement_V2 = mkV2 "実行する" | mkV2 "実現する" ;
lin reputation_N = mkN "評判" | mkN "名声" ;
lin print_V2 = mkV2 "印刷する" ;
lin print_V = mkV "印刷する" ;
lin calculate_VS = mkVS "計算する" | mkVS "算定する" | mkVS "算出する" | mkVS "見積もる" | mkVS "推定する" ;
lin calculate_V2 = mkV2 "計算する" | mkV2 "算定する" | mkV2 "算出する" | mkV2 "見積もる" | mkV2 "推定する" ;
lin calculate_V = mkV "計算する" | mkV "算定する" | mkV "算出する" | mkV "見積もる" | mkV "推定する" ;
lin keen_A = variants{} ; -- 
lin guess_VS = mkVS "推測する" | mkVS "察する" | mkVS "憶測する" ;
lin guess_V2 = mkV2 "推測する" | mkV2 "察する" | mkV2 "憶測する" ;
lin guess_V = mkV "推測する" | mkV "察する" | mkV "憶測する" ;
lin recommendation_N = mkN "勧告" | mkN "推薦" | mkN "薦め" ;
lin autumn_N = mkN "秋" ;
lin conventional_A = variants{} ; -- 
lin cope_V = mkV "対処する" | mkV "処理する" ;
lin constitute_V2 = mkV2 "任命する" ;
lin poll_N = mkN "ポール {n}" ;
lin voluntary_A = mkA "志願して" ;
lin valuable_A = mkA "貴重な" ;
lin recovery_N = mkN "回収" ;
lin cast_V2 = mkV2 "投じる" | mkV2 "投げる" ;
lin cast_V = mkV "投じる" | mkV "投げる" ;
lin premise_N = mkN "前提" ;
lin resolve_V2 = mkV2 "解く" | mkV2 "分解する" ;
lin resolve_V = mkV "解く" | mkV "分解する" ;
lin regularly_Adv = variants{} ; -- 
lin solve_V2 = mkV2 "解決する" ;
lin plaintiff_N = mkN "原告" ;
lin critic_N = mkN "批評家" | mkN "評論家" ;
lin agriculture_N = mkN "農業" ;
lin ice_N = L.ice_N | mkN "氷河期" | mkN "氷河時代" ;
lin constitution_N = mkN "編成" | mkN "構成" ;
lin communist_N = mkN "共産主義者" | mkN "共産党員" ;
lin layer_N = mkN "重ね" ;
lin recession_N = mkN "不況" | mkN "退去" | mkN "衰退" ;
lin slight_A = mkA "少しの" ;
lin dramatic_A = mkA "劇的" ;
lin golden_A = mkA "黄金の" ;
lin temporary_A = mkA "臨時の" ;
lin suit_N = mkN "スート" ;
lin shortly_Adv = variants{} ; -- 
lin initially_Adv = variants{} ; -- 
lin arrival_N = mkN "到着" ;
lin protest_N = mkN "抗議" | mkN "プロテスト" ;
lin resistance_N = mkN "抵抗" | mkN "反抗" ;
lin silent_A = variants{} ; -- 
lin presentation_N = mkN "贈呈" | mkN "プレゼンテーション" | mkN "プレゼン" ;
lin soul_N = mkN "魂" | mkN "精神" ;
lin self_N = mkN "自己" | mkN "自身" | mkN "自我" ;
lin judgment_N = variants{} ; -- 
lin feed_V2 = mkV2 "食べ物を与える" ;
lin feed_V = mkV "食べ物を与える" ;
lin muscle_N = mkN "筋肉" ;
lin shareholder_N = mkN "株主" ;
lin opposite_A = mkA "反対の" | mkA "逆くの" ;
lin pollution_N = mkN "汚染物質" ;
lin wealth_N = mkN "豊富" ;
lin video_taped_A = variants{} ; -- 
lin kingdom_N = mkN "界" ;
lin bread_N = L.bread_N | mkN "パン" ;
lin perspective_N = variants{} ; -- 
lin camera_N = L.camera_N | mkN "ビデオカメラ" ;
lin prince_N = mkN "王子" ;
lin illness_N = mkN "病気" | mkN "疾病" ;
lin cake_N = mkN "ケーキ" ;
lin meat_N = L.meat_N | mkN "肉" ;
lin submit_V2 = mkV2 "提出する" ;
lin submit_V = mkV "提出する" ;
lin ideal_A = mkA "理想的な" | mkA "理想な" ;
lin relax_V2 = mkV2 "落ち着く" | mkV2 "緊張を解く" | mkV2 "ほっとする" ;
lin relax_V = mkV "落ち着く" | mkV "緊張を解く" | mkV "ほっとする" ;
lin penalty_N = mkN "ペナルティーキック" | mkN "ペナルティー" ;
lin purchase_V2 = variants{} ; -- 
lin tired_A = mkA "疲れた" ;
lin beer_N = L.beer_N | mkN "ビール" ;
lin specify_VS = variants{} ; -- 
lin specify_V2 = variants{} ; -- 
lin specify_V = variants{} ; -- 
lin short_Adv = variants{} ; -- 
lin monitor_V2 = variants{} ; -- 
lin monitor_V = variants{} ; -- 
lin electricity_N = mkN "電気" ;
lin specifically_Adv = variants{} ; -- 
lin bond_N = variants{} ; -- 
lin statutory_A = variants{} ; -- 
lin laboratory_N = mkN "研究所 {m}" ;
lin federal_A = variants{} ; -- 
lin captain_N = mkN "大佐" ;
lin deeply_Adv = variants{} ; -- 
lin pour_V2 = mkV2 "注ぎ出す" ;
lin pour_V = mkV "注ぎ出す" ;
lin boss_N = L.boss_N | mkN "ボス" ;
lin creature_N = mkN "生き物" | mkN "生物" ;
lin urge_VS = mkVS "催促する" ;
lin urge_V2V = mkV2V "催促する" ;
lin urge_V2 = mkV2 "催促する" ;
lin locate_V2 = variants{} ; -- 
lin locate_V = variants{} ; -- 
lin being_N = mkN "生き物" | mkN "生物" ;
lin struggle_VV = mkVV "闘争する" | mkVV "奮闘する" ;
lin struggle_V = mkV "闘争する" | mkV "奮闘する" ;
lin lifespan_N = variants{} ; -- 
lin flat_A = mkA "平ら" ;
lin valley_N = mkN "谷" ;
lin like_A = mkA "...のように" ;
lin guard_N = mkN "監視者" | mkN "衛兵" | mkN "ガード" ;
lin emergency_N = mkN "非常時" | mkN "緊急事態" ;
lin dark_N = mkN "暗黒" | mkN "暗闇" | mkN "闇" ;
lin bomb_N = mkN "爆弾" ;
lin dollar_N = mkN "ドル" ;
lin efficiency_N = variants{} ; -- 
lin mood_N = mkN "法" ;
lin convert_V2 = variants{} ; -- 
lin convert_V = variants{} ; -- 
lin possession_N = mkN "憑依" ;
lin marketing_N = mkN "マーケティング" ;
lin please_VV = mkVV "喜ばす" ;
lin please_V2V = mkV2V "喜ばす" ;
lin please_V2 = mkV2 "喜ばす" ;
lin please_V = mkV "喜ばす" ;
lin habit_N = mkN "習慣" ;
lin subsequently_Adv = variants{} ; -- 
lin round_N = mkN "円" | mkN "丸" ;
lin purchase_N = mkN "購入" | mkN "購買" ;
lin sort_V2 = mkV2 "整列する" | mkV2 "ソートする" ;
lin sort_V = mkV "整列する" | mkV "ソートする" ;
lin outside_A = variants{} ; -- 
lin gradually_Adv = variants{} ; -- 
lin expansion_N = mkN "拡大" | mkN "拡張" | mkN "展開" ;
lin competitive_A = variants{} ; -- 
lin cooperation_N = mkN "協力" ;
lin acceptable_A = variants{} ; -- 
lin angle_N = mkN "角" | mkN "隅" ;
lin cook_V2 = mkV2 "料理する" ;
lin cook_V = mkV "料理する" ;
lin net_A = variants{} ; -- 
lin sensitive_A = mkA "敏感" ;
lin ratio_N = variants{} ; -- 
lin kiss_V2 = mkV2 "キスする" | mkV2 "口付けする" | mkV2 "接吻する" | mkV2 "チューする" ;
lin amount_V = mkV "なる" ;
lin sleep_N = mkN "仮眠" ;
lin finance_V2 = mkV2 "融資する" | mkV2 "資金を調達する" ;
lin essentially_Adv = variants{} ; -- 
lin fund_V2 = variants{} ; -- 
lin preserve_V2 = variants{} ; -- 
lin wedding_N = mkN "結婚式" ;
lin personality_N = mkN "人格" ;
lin bishop_N = mkN "ビショップ" | mkN "角行" ;
lin dependent_A = mkA "次第" | mkA "依存する" | mkA "頼る" ;
lin landscape_N = variants{} ; -- 
lin pure_A = mkA "純粋" | mkA "清らか" ;
lin mirror_N = mkN "鏡" ;
lin lock_V2 = mkV2 "鍵を掛ける" ;
lin lock_V = mkV "鍵を掛ける" ;
lin symptom_N = mkN "症状" ;
lin promotion_N = mkN "昇進" ;
lin global_A = mkA "グローバル" | mkA "世界的" | mkA "万国の" ;
lin aside_Adv = ParadigmsJpn.mkAdv "傍らに" | ParadigmsJpn.mkAdv "わきへ" ;
lin tendency_N = mkN "傾向" ;
lin conservation_N = mkN "節約" | mkN "保護" ;
lin reply_N = mkN "返事" ;
lin estimate_N = variants{} ; -- 
lin qualification_N = mkN "資格" ;
lin pack_V2 = variants{} ; -- 
lin pack_V = variants{} ; -- 
lin governor_N = mkN "知事" ;
lin expected_A = variants{} ; -- 
lin invest_V2 = mkV2 "投資する" ;
lin invest_V = mkV "投資する" ;
lin cycle_N = mkN "周期" ;
lin alright_A = variants{} ; -- 
lin philosophy_N = mkN "哲学" ;
lin gallery_N = mkN "画廊" | mkN "ギャラリー" ;
lin sad_A = mkA "悲しい" ;
lin intervention_N = mkN "介入" ;
lin emotional_A = mkA "感情的" ;
lin advertising_N = variants{} ; -- 
lin regard_N = variants{} ; -- 
lin dance_V2 = mkV2 "踊る" | mkV2 "ダンスする" ;
lin dance_V = mkV "踊る" | mkV "ダンスする" ;
lin cigarette_N = mkN "タバコ" | mkN "煙草" | mkN "紙巻き煙草" ;
lin predict_VS = mkVS "予言する" ;
lin predict_V2 = mkV2 "予言する" ;
lin adequate_A = mkA "適当な" | mkA "適切な" | mkA "十分な" ;
lin variable_N = mkN "カワリアリモズ" ;
lin net_N = mkN "網" ;
lin retire_V2 = mkV2 "退職する" | mkV2 "引退する" ;
lin retire_V = mkV "退職する" | mkV "引退する" ;
lin sugar_N = mkN "糖質" ;
lin pale_A = mkA "青ざめた" ;
lin frequency_N = mkN "Kanji: 周波数変調" | mkN "Hiragana: しゅうはすうへんちょう" | mkN "Romaji: shūhasūhenchō" ;
lin guy_N = mkN "やつら" | mkN "奴ら" ;
lin feature_V2 = variants{} ; -- 
lin furniture_N = mkN "家具" ;
lin administrative_A = variants{} ; -- 
lin wooden_A = variants{} ; -- 
lin input_N = mkN "入力" | mkN "インプット" ;
lin phenomenon_N = mkN "現象" ;
lin surprising_A = variants{} ; -- 
lin jacket_N = mkN "ジャケット" ;
lin actor_N = mkN "俳優" | mkN "役者" | mkN "女優" ;
lin actor_2_N = variants{} ; -- 
lin actor_1_N = variants{} ; -- 
lin kick_V2 = mkV2 "蹴る" ;
lin kick_V = mkV "蹴る" ;
lin producer_N = mkN "製作者" | mkN "プロデューサー" ;
lin hearing_N = mkN "補聴器" ;
lin chip_N = mkN "ポテトチップ" ;
lin equation_N = mkN "方程式" ;
lin certificate_N = mkN "認証" | mkN "認定書" ;
lin hello_Interj = mkInterj "本当？" | mkInterj "冗談だろ？" | mkInterj "大丈夫？" | mkInterj "大丈夫かよ？" | mkInterj "マジ？" | mkInterj "マジかよ" ;
lin remarkable_A = variants{} ; -- 
lin alliance_N = mkN "同盟" ;
lin smoke_V2 = mkV2 "煙る" ;
lin smoke_V = mkV "煙る" ;
lin awareness_N = mkN "意識" ;
lin throat_N = mkN "喉" ;
lin discovery_N = mkN "発見" ;
lin festival_N = mkN "祭り" | mkN "祭典" | mkN "祝祭" ;
lin dance_N = mkN "ダンス" | mkN "踊り" | mkN "舞踊" ;
lin promise_N = mkN "約束" ;
lin rose_N = mkN "バラコガネムシ" ;
lin principal_A = mkA "主要な" ;
lin brilliant_A = variants{} ; -- 
lin proposed_A = variants{} ; -- 
lin coach_N = mkN "コーチ" | mkN "トレーナー" ;
lin coach_3_N = variants{} ; -- 
lin coach_2_N = variants{} ; -- 
lin coach_1_N = variants{} ; -- 
lin absolute_A = mkA "絶対の" | mkA "絶対的な" | mkA "無条件の" ;
lin drama_N = mkN "ドラマ" ;
lin recording_N = mkN "録音" ;
lin precisely_Adv = variants{} ; -- 
lin bath_N = mkN "入浴" | mkN "沐浴" | mkN "お湯" ;
lin celebrate_V2 = mkV2 "祝う" ;
lin substance_N = mkN "薬物乱用" ;
lin swing_V2 = mkV2 "振れる" | mkV2 "揺さぶる" | mkV2 "揺れる" ;
lin swing_V = mkV "振れる" | mkV "揺さぶる" | mkV "揺れる" ;
lin for_Adv = ParadigmsJpn.mkAdv "善かれ悪しかれ" ;
lin rapid_A = mkA "速い" | mkA "急な" | mkA "迅速な" ;
lin rough_A = mkA "粗野" ;
lin investor_N = mkN "投資家" | mkN "出資者" ;
lin fire_V2 = mkV2 "発射する" ;
lin fire_V = mkV "発射する" ;
lin rank_N = variants{} ; -- 
lin compete_V = mkV "争う" | mkV "競争する" | mkV "張り合う" ;
lin sweet_A = mkA "素晴らしい" ;
lin decline_VV = variants{} ; -- 
lin decline_V2 = variants{} ; -- 
lin decline_V = variants{} ; -- 
lin rent_N = mkN "家賃" ;
lin dealer_N = variants{} ; -- 
lin bend_V2 = mkV2 "かがむ" ;
lin bend_V = mkV "かがむ" ;
lin solid_A = mkA "詰まった" | mkA "ソリッドな" ;
lin cloud_N = L.cloud_N | mkN "曇り" | mkN "濁り" ;
lin across_Adv = variants{} ; -- 
lin level_A = mkA "水平な" ;
lin enquiry_N = variants{} ; -- 
lin fight_N = mkN "戦闘" ;
lin abuse_N = mkN "濫用" ;
lin golf_N = mkN "ゴルフ" ;
lin guitar_N = mkN "ギター" ;
lin electronic_A = mkA "電子" ;
lin cottage_N = mkN "コテージ" | mkN "小屋" ;
lin scope_N = variants{} ; -- 
lin pause_VS = mkVS "中断する" | mkVS "途切れる" ;
lin pause_V2V = mkV2V "中断する" | mkV2V "途切れる" ;
lin pause_V = mkV "中断する" | mkV "途切れる" ;
lin mixture_N = variants{} ; -- 
lin emotion_N = mkN "感情" ;
lin comprehensive_A = mkA "包括的な" ;
lin shirt_N = L.shirt_N | mkN "シャツ" ;
lin allowance_N = mkN "給与" | mkN "こずかい" ;
lin retirement_N = mkN "退職" | mkN "停年退職" ;
lin breach_N = variants{} ; -- 
lin infection_N = mkN "伝染" ;
lin resist_VV = mkVV "抵抗する" | mkVV "反抗する" | mkVV "耐える" ;
lin resist_V2 = mkV2 "抵抗する" | mkV2 "反抗する" | mkV2 "耐える" ;
lin resist_V = mkV "抵抗する" | mkV "反抗する" | mkV "耐える" ;
lin qualify_V2 = variants{} ; -- 
lin qualify_V = variants{} ; -- 
lin paragraph_N = mkN "段落" ;
lin sick_A = mkA "病気" ;
lin near_A = L.near_A | mkA "近い" ;
lin researcherMasc_N = variants{} ; -- 
lin consent_N = mkN "承諾" | mkN "同意" ;
lin written_A = variants{} ; -- 
lin literary_A = mkA "文学" ;
lin ill_A = mkA "病気" ;
lin wet_A = L.wet_A | mkA "尻が青い" ;
lin lake_N = L.lake_N | mkN "湖" | mkN "-湖" ;
lin entrance_N = mkN "入口" ;
lin peak_N = mkN "頂上" | mkN "山頂" ;
lin successfully_Adv = variants{} ; -- 
lin sand_N = L.sand_N | mkN "砂浜" | mkN "ビーチ" ;
lin breathe_V2 = mkV2 "一息つく" ;
lin breathe_V = L.breathe_V | mkV "一息つく" ;
lin cold_N = mkN "風邪" | mkN "感冒" ;
lin cheek_N = mkN "頬" | mkN "ほっぺた" ;
lin platform_N = mkN "演壇" ;
lin interaction_N = variants{} ; -- 
lin watch_N = mkN "警戒" ;
lin borrow_VV = mkVV "借りる" ;
lin borrow_V2 = mkV2 "借りる" ;
lin borrow_V = mkV "借りる" ;
lin birthday_N = mkN "誕生日" | mkN "バースデー" ;
lin knife_N = mkN "ナイフ" | mkN "小刀" ;
lin extreme_A = mkA "究極の" ;
lin core_N = mkN "芯" | mkN "中心" ;
lin peasantMasc_N = variants{} ; -- 
lin armed_A = variants{} ; -- 
lin permission_N = mkN "許可" ;
lin supreme_A = mkA "至高の" | mkA "最高の" ;
lin overcome_V2 = mkV2 "克服する" | mkV2 "征服する" | mkV2 "乗り越える" ;
lin overcome_V = mkV "克服する" | mkV "征服する" | mkV "乗り越える" ;
lin greatly_Adv = variants{} ; -- 
lin visual_A = variants{} ; -- 
lin lad_N = mkN "青年" | mkN "若者" ;
lin genuine_A = mkA "本物の" ;
lin personnel_N = variants{} ; -- 
lin judgement_N = variants{} ; -- 
lin exciting_A = variants{} ; -- 
lin stream_N = mkN "流れ" ;
lin perception_N = mkN "知覚" ;
lin guarantee_VS = variants{} ; -- 
lin guarantee_V2 = variants{} ; -- 
lin guarantee_V = variants{} ; -- 
lin disaster_N = mkN "災害" | mkN "天災" | mkN "惨事" | mkN "災い" ;
lin darkness_N = mkN "闇" | mkN "暗黒" ;
lin bid_N = mkN "付け値" ;
lin sake_N = mkN "酒" | mkN "日本酒" | mkN "清酒" ;
lin sake_2_N = variants{} ; -- 
lin sake_1_N = variants{} ; -- 
lin organize_V2V = mkV2V "組織する" ;
lin organize_V2 = mkV2 "組織する" ;
lin tourist_N = mkN "旅行者" | mkN "観光客" | mkN "ツーリスト" ;
lin policeman_N = L.policeman_N | mkN "警察官" | mkN "警官" ;
lin castle_N = mkN "城" | mkN "城郭" ;
lin figure_VS = variants{} ; -- 
lin figure_V = variants{} ; -- 
lin race_VV = mkVV "突進する" ;
lin race_V2V = mkV2V "突進する" ;
lin race_V2 = mkV2 "突進する" ;
lin race_V = mkV "突進する" ;
lin demonstration_N = mkN "実証" ;
lin anger_N = mkN "怒り" | mkN "忿怒" | mkN "怒気" ;
lin briefly_Adv = variants{} ; -- 
lin presumably_Adv = ParadigmsJpn.mkAdv "おそらく" | ParadigmsJpn.mkAdv "思うに" | ParadigmsJpn.mkAdv "推定上" ;
lin clock_N = mkN "クロック" ;
lin hero_N = mkN "主人公" ;
lin expose_V2 = mkV2 "露光させる" ;
lin expose_V = mkV "露光させる" ;
lin custom_N = mkN "習慣" | mkN "風俗" ;
lin maximum_A = mkA "最大" | mkA "極大" ;
lin wish_N = mkN "願い" | mkN "願望" | mkN "希望" ;
lin earning_N = variants{} ; -- 
lin priest_N = L.priest_N | mkN "司祭" | mkN "牧師" | mkN "僧" | mkN "法師" | mkN "司祭" | mkN "祭司" | mkN "神父" ;
lin resign_V2 = mkV2 "辞任する" | mkV2 "辞職する" | mkV2 "辞める" ;
lin resign_V = mkV "辞任する" | mkV "辞職する" | mkV "辞める" ;
lin store_V2 = mkV2 "蓄える" ;
lin widespread_A = variants{} ; -- 
lin comprise_V2 = variants{} ; -- 
lin chamber_N = mkN "寝室" | mkN "部屋" ;
lin acquisition_N = mkN "獲得" ;
lin involved_A = variants{} ; -- 
lin confident_A = mkA "確信する" ;
lin circuit_N = mkN "回路" ;
lin radical_A = variants{} ; -- 
lin detect_V2 = mkV2 "検出する" | mkV2 "見付ける" ;
lin stupid_A = L.stupid_A | mkA "馬鹿" | mkA "馬鹿げた" | mkA "間抜け" | mkA "愚か" ;
lin grand_A = mkA "壮麗な" ;
lin consumption_N = mkN "消費" ;
lin hold_N = variants{} ; -- 
lin zone_N = mkN "地帯" | mkN "地域" | mkN "地区" | mkN "場所" ;
lin mean_A = mkA "意地が悪い" | mkA "意地悪" ;
lin altogether_Adv = variants{} ; -- 
lin rush_VV = mkVV "急ぐ" | mkVV "駆け付ける" ;
lin rush_V2 = mkV2 "急ぐ" | mkV2 "駆け付ける" ;
lin rush_V = mkV "急ぐ" | mkV "駆け付ける" ;
lin numerous_A = mkA "多数の" ;
lin sink_V2 = mkV2 "沈める" ;
lin sink_V = mkV "沈める" ;
lin everywhere_Adv = S.everywhere_Adv | ParadigmsJpn.mkAdv "どこでも" ;
lin classical_A = mkA "古典的" ;
lin respectively_Adv = variants{} ; -- 
lin distinct_A = mkA "異なる" ;
lin mad_A = mkA "気が狂った" | mkA "狂しい" | mkA "頭がおかしい" ;
lin honour_N = mkN "名誉" ;
lin statistics_N = mkN "統計" ;
lin false_A = mkA "虚偽" | mkA "偽の" ;
lin square_N = mkN "平方センチメートル" | mkN "cm^2" ;
lin differ_V = mkV "異なる" | mkV "違う" ;
lin disk_N = mkN "ディスク" | mkN "円盤" ;
lin truly_Adv = variants{} ; -- 
lin survival_N = mkN "生存" | mkN "サバイバル" ;
lin proud_A = mkA "誇らしい" | mkA "自慢の" ;
lin tower_N = mkN "塔" ;
lin deposit_N = mkN "保証金" ;
lin pace_N = mkN "歩調" | mkN "速度" | mkN "ペース" ;
lin compensation_N = variants{} ; -- 
lin adviserMasc_N = variants{} ; -- 
lin consultant_N = mkN "顧問" | mkN "相談役" | mkN "コンサルタント" ;
lin drag_V2 = mkV2 "引く" | mkV2 "引きずる" | mkV2 "引き離す" ;
lin drag_V = mkV "引く" | mkV "引きずる" | mkV "引き離す" ;
lin advanced_A = mkA "高度の" | mkA "高尚の" ;
lin landlord_N = mkN "家主" | mkN "地主" | mkN "大家" ;
lin whenever_Adv = ParadigmsJpn.mkAdv "いつでも" ;
lin delay_N = mkN "遅れ" | mkN "遅延" ;
lin green_N = mkN "緑" | mkN "緑色" ;
lin car_V = variants{} ; -- 
lin holder_N = variants{} ; -- 
lin secret_A = variants{} ; -- 
lin edition_N = mkN "版" ;
lin occupation_N = mkN "仕事" | mkN "職業" ;
lin agricultural_A = variants{} ; -- 
lin intelligence_N = variants{} ; -- 
lin intelligence_2_N = variants{} ; -- 
lin intelligence_1_N = variants{} ; -- 
lin empire_N = mkN "企業帝国" ;
lin definitely_Adv = variants{} ; -- 
lin negotiate_VV = mkVV "交渉する" ;
lin negotiate_V2 = mkV2 "交渉する" ;
lin negotiate_V = mkV "交渉する" ;
lin host_N = mkN "ホスト" ;
lin relative_N = mkN "親戚" | mkN "身内" | mkN "関係詞" ;
lin mass_A = variants{} ; -- 
lin helpful_A = variants{} ; -- 
lin fellow_N = variants{} ; -- 
lin sweep_V2 = mkV2 "掃く" ;
lin sweep_V = mkV "掃く" ;
lin poet_N = mkN "詩人" ;
lin journalist_N = mkN "記者" | mkN "ジャーナリスト" ;
lin defeat_N = mkN "敗北" | mkN "挫折" ;
lin unlike_Prep = variants{} ; -- 
lin primarily_Adv = variants{} ; -- 
lin tight_A = variants{} ; -- 
lin indication_N = variants{} ; -- 
lin dry_V2 = mkV2 "乾く" ;
lin dry_V = mkV "乾く" ;
lin cricket_N = mkN "クリケット" ;
lin whisper_V2 = mkV2 "囁く" ;
lin whisper_V = mkV "囁く" ;
lin routine_N = mkN "ルーチン" ;
lin print_N = variants{} ; -- 
lin anxiety_N = mkN "心配" ;
lin witness_N = mkN "証人" | mkN "証" ;
lin concerning_Prep = variants{} ; -- 
lin mill_N = mkN "製粉所" ;
lin gentle_A = variants{} ; -- 
lin curtain_N = mkN "カーテン" ;
lin mission_N = mkN "伝道" | mkN "宣教" ;
lin supplier_N = mkN "サプライヤー" | mkN "供給者" | mkN "仕入れ先" ;
lin basically_Adv = variants{} ; -- 
lin assure_V2S = variants{} ; -- 
lin assure_V2 = variants{} ; -- 
lin poverty_N = mkN "欠乏" ;
lin snow_N = L.snow_N | mkN "雪" ;
lin prayer_N = mkN "念珠" | mkN "数珠" ;
lin pipe_N = mkN "夢物語" ;
lin deserve_VV = mkVV "値する" ;
lin deserve_V2 = mkV2 "値する" ;
lin deserve_V = mkV "値する" ;
lin shift_N = variants{} ; -- 
lin split_V2 = L.split_V2 | mkV2 "割る" ;
lin split_V = mkV "割る" ;
lin near_Adv = ParadigmsJpn.mkAdv "近く" ;
lin consistent_A = variants{} ; -- 
lin carpet_N = L.carpet_N | mkN "カーペット" | mkN "絨毯" ;
lin ownership_N = mkN "所有権" ;
lin joke_N = mkN "冗談" ;
lin fewer_Det = variants{} ; -- 
lin workshop_N = mkN "講習会" | mkN "研修会" | mkN "作業部会" | mkN "ワークショップ" ;
lin salt_N = L.salt_N | mkN "ソルト" ;
lin aged_Prep = variants{} ; -- 
lin symbol_N = mkN "記号" | mkN "符号" ;
lin slide_V2 = mkV2 "滑る" | mkV2 "慴動させる" ;
lin slide_V = mkV "滑る" | mkV "慴動させる" ;
lin cross_N = mkN "クロスカントリー" ;
lin anxious_A = mkA "心配した" ;
lin tale_N = variants{} ; -- 
lin preference_N = mkN "えこひいき" ;
lin inevitably_Adv = variants{} ; -- 
lin mere_A = variants{} ; -- 
lin behave_V = mkV "振る舞う" ;
lin gain_N = mkN "利得" | mkN "増幅率" ;
lin nervous_A = mkA "神経の" ;
lin guide_V2 = mkV2 "案内する" ;
lin remark_N = mkN "注意" ;
lin pleased_A = mkA "嬉しい" ;
lin province_N = mkN "県" | mkN "地方" | mkN "" | mkN "province] 州" | mkN "省" ;
lin steel_N = L.steel_N | mkN "鋼鉄" | mkN "はがね" ;
lin practise_V2 = variants{} ; -- 
lin practise_V = variants{} ; -- 
lin flow_V = L.flow_V ;
lin holy_A = mkA "神聖" | mkA "聖なる" ;
lin dose_N = mkN "用量" ;
lin alcohol_N = mkN "アルコール" | mkN "酒" ;
lin guidance_N = variants{} ; -- 
lin constantly_Adv = variants{} ; -- 
lin climate_N = mkN "気候" | mkN "風土" ;
lin enhance_V2 = variants{} ; -- 
lin reasonably_Adv = variants{} ; -- 
lin waste_V2 = mkV2 "やせ衰える" ;
lin waste_V = mkV "やせ衰える" ;
lin smooth_A = L.smooth_A | mkA "滑らかな" ;
lin dominant_A = mkA "支配的" ;
lin conscious_A = mkA "意識した" ;
lin formula_N = mkN "公式" | mkN "定式" ;
lin tail_N = L.tail_N | mkN "尻尾" | mkN "しっぽ" | mkN "尾" ;
lin ha_Interj = mkInterj "ふ" ;
lin electric_A = mkA "電動の" | mkA "電気的な" | mkA "エレクトリック" ;
lin sheep_N = L.sheep_N | mkN "羊" ;
lin medicine_N = mkN "医学" ;
lin strategic_A = mkA "戦略的な" ;
lin disabled_A = variants{} ; -- 
lin smell_N = mkN "匂い" ;
lin operator_N = mkN "演算子" | mkN "作用素" ;
lin mount_V2 = variants{} ; -- 
lin mount_V = variants{} ; -- 
lin advance_V2 = mkV2 "進む" ;
lin advance_V = mkV "進む" ;
lin remote_A = mkA "遠い" | mkA "遠隔な" | mkA "辺鄙な" | mkA "遥かな" ;
lin measurement_N = variants{} ; -- 
lin favour_VS = variants{} ; -- 
lin favour_V2 = variants{} ; -- 
lin favour_V = variants{} ; -- 
lin neither_Det = ParadigmsJpn.mkDet "どちらも…ない" ;
lin architecture_N = mkN "建築" | mkN "建築学" ;
lin worth_N = mkN "価値" ;
lin tie_N = mkN "引き分け" ;
lin barrier_N = variants{} ; -- 
lin practitioner_N = variants{} ; -- 
lin outstanding_A = mkA "顕著" ;
lin enthusiasm_N = mkN "情熱" | mkN "熱意" ;
lin theoretical_A = variants{} ; -- 
lin implementation_N = mkN "履行" ;
lin worried_A = variants{} ; -- 
lin pitch_N = mkN "高低アクセント 高さアクセント" | mkN "音声高さアクセント" | mkN "ピッチアクセント" ;
lin drop_N = mkN "滴" | mkN "雫" ;
lin phone_V2 = mkV2 "電話をかける" | mkV2 "電話する" ;
lin phone_V = mkV "電話をかける" | mkV "電話する" ;
lin shape_VV = mkVV "形作る" ;
lin shape_V2 = mkV2 "形作る" ;
lin shape_V = mkV "形作る" ;
lin clinical_A = mkA "臨床の" ;
lin lane_N = mkN "規定航路" ;
lin apple_N = L.apple_N | mkN "林檎" | mkN "リンゴ" ;
lin catalogue_N = mkN "カタログ" | mkN "目録" ;
lin tip_N = mkN "先" | mkN "先端" ;
lin publisher_N = mkN "出版社" | mkN "発行人" ;
lin opponentMasc_N = variants{} ; -- 
lin live_A = mkA "ライブ" ;
lin burden_N = mkN "心配事" ;
lin tackle_V2 = variants{} ; -- 
lin tackle_V = variants{} ; -- 
lin historian_N = mkN "歴史家" | mkN "史家" ;
lin bury_V2 = mkV2 "埋葬する" ;
lin bury_V = mkV "埋葬する" ;
lin stomach_N = mkN "お腹" | mkN "腹" ;
lin percentage_N = mkN "ポイント" ;
lin evaluation_N = mkN "評価" ;
lin outline_V2 = variants{} ; -- 
lin talent_N = mkN "才能" ;
lin lend_V2 = mkV2 "貸す" ;
lin lend_V = mkV "貸す" ;
lin silver_N = L.silver_N | mkN "銀の弾丸" ;
lin pack_N = mkN "群れ" ;
lin fun_N = mkN "遊び" ;
lin democrat_N = mkN "民主主義者" ;
lin fortune_N = mkN "機会" | mkN "チャンス" ;
lin storage_N = mkN "貯蔵" | mkN "保管" ;
lin professional_N = mkN "プロフェッショナル" | mkN "プロ" | mkN "専門家" ;
lin reserve_N = mkN "準備金" | mkN "引当金" ;
lin interval_N = mkN "間隔" ;
lin dimension_N = mkN "次元" ;
lin honest_A = mkA "正直" | mkA "誠実" ;
lin awful_A = mkA "大変な" ;
lin manufacture_V2 = mkV2 "捏造する" | mkV2 "でっちあげる" ;
lin confusion_N = variants{} ; -- 
lin pink_A = variants{} ; -- 
lin impressive_A = mkA "印象的な" ;
lin satisfaction_N = mkN "満足" ;
lin visible_A = mkA "見える" | mkA "目に見える" ;
lin vessel_N = mkN "容器" ;
lin stand_N = mkN "停留所" ;
lin curve_N = mkN "曲線" ;
lin pot_N = mkN "鍋" ;
lin replacement_N = variants{} ; -- 
lin accurate_A = mkA "正確な" | mkA "精密な" ;
lin mortgage_N = mkN "抵当" | mkN "抵当権" | mkN "住宅ローン" ;
lin salary_N = mkN "サラリー" | mkN "給料" ;
lin impress_V2 = variants{} ; -- 
lin impress_V = variants{} ; -- 
lin constitutional_A = variants{} ; -- 
lin emphasize_VS = mkVS "強調する" | mkVS "アクセントをつける" ;
lin emphasize_V2 = mkV2 "強調する" | mkV2 "アクセントをつける" ;
lin developing_A = mkA "発展途上" ;
lin proof_N = mkN "証拠" ;
lin furthermore_Adv = variants{} ; -- 
lin dish_N = mkN "皿" ;
lin interview_V2 = mkV2 "面接する" ;
lin considerably_Adv = variants{} ; -- 
lin distant_A = mkA "遠い" | mkA "遠隔な" | mkA "辺鄙な" ;
lin lower_V2 = mkV2 "下げる" | mkV2 "下ろす" ;
lin lower_V = mkV "下げる" | mkV "下ろす" ;
lin favouriteMasc_N = variants{} ; -- 
lin tear_V2 = mkV2 "破る" | mkV2 "引き裂く" ;
lin tear_V = mkV "破る" | mkV "引き裂く" ;
lin fixed_A = variants{} ; -- 
lin by_Adv = ParadigmsJpn.mkAdv "道に沿って" ;
lin luck_N = mkN "運" | mkN "運勢" ;
lin count_N = mkN "伯爵" ;
lin precise_A = mkA "正確な" | mkA "精密な" | mkA "厳密な" ;
lin determination_N = variants{} ; -- 
lin bite_V2 = L.bite_V2 | mkV2 "噛む" | mkV2 "嚙む" | mkV2 "嚼む" | mkV2 "噛み切る" ;
lin bite_V = mkV "噛む" | mkV "嚙む" | mkV "嚼む" | mkV "噛み切る" ;
lin dear_Interj = variants{} ; -- 
lin consultation_N = variants{} ; -- 
lin range_V = variants{} ; -- 
lin residential_A = variants{} ; -- 
lin conduct_N = variants{} ; -- 
lin capture_V2 = mkV2 "とる" ;
lin ultimately_Adv = variants{} ; -- 
lin cheque_N = mkN "小切手" ;
lin economics_N = mkN "経済学" ;
lin sustain_V2 = variants{} ; -- 
lin secondly_Adv = ParadigmsJpn.mkAdv "第二に" ;
lin silly_A = mkA "馬鹿げた" | mkA "他愛ない" | mkA "馬鹿" ;
lin merchant_N = mkN "商人" ;
lin lecture_N = mkN "講義" ;
lin musical_A = mkA "音楽的な" ;
lin leisure_N = mkN "" | mkN "余暇" | mkN "レジャー" ;
lin check_N = mkN "請求書" ;
lin cheese_N = L.cheese_N | mkN "チーズ" | mkN "乾酪" ;
lin lift_N = mkN "エレベーター" | mkN "リフト" ;
lin participate_V2 = mkV2 "参加する" ;
lin participate_V = mkV "参加する" ;
lin fabric_N = mkN "柔軟剤" ;
lin distribute_V2 = mkV2 "分散する" ;
lin lover_N = mkN "恋人" ;
lin childhood_N = mkN "小児期" | mkN "幼年" ;
lin cool_A = mkA "クール" | mkA "素敵" | mkA "すごい" ;
lin ban_V2 = mkV2 "禁止する" ;
lin supposed_A = variants{} ; -- 
lin mouse_N = mkN "ネズミアリモズ" ;
lin strain_N = variants{} ; -- 
lin specialist_A = variants{} ; -- 
lin consult_V2 = variants{} ; -- 
lin consult_V = variants{} ; -- 
lin minimum_A = mkA "最小" | mkA "最低" | mkA "極小" ;
lin approximately_Adv = variants{} ; -- 
lin participant_N = mkN "参加者" | mkN "関与者" ;
lin monetary_A = mkA "貨幣の" | mkA "金銭的な" ;
lin confuse_V2 = mkV2 "混乱させる" ;
lin dare_VV = mkVV "冒す" | mkVV "堪える" ;
lin dare_V2 = mkV2 "冒す" | mkV2 "堪える" ;
lin smoke_N = L.smoke_N | mkN "煙" ;
lin movie_N = mkN "映画" ;
lin seed_N = L.seed_N | mkN "種" ;
lin cease_V2 = mkV2 "終え、止めなさい" ;
lin cease_V = mkV "終え、止めなさい" ;
lin open_Adv = variants{} ; -- 
lin journal_N = mkN "ジャーナル" ;
lin shopping_N = mkN "買い物" | mkN "買物" | mkN "ショッピング" ;
lin equivalent_N = variants{} ; -- 
lin palace_N = mkN "宮殿" ;
lin exceed_V2 = variants{} ; -- 
lin isolated_A = variants{} ; -- 
lin poetry_N = mkN "詩" | mkN "詩歌" ;
lin perceive_VS = mkVS "知覚する" | mkVS "認める" | mkVS "気付く" ;
lin perceive_V2V = mkV2V "知覚する" | mkV2V "認める" | mkV2V "気付く" ;
lin perceive_V2 = mkV2 "知覚する" | mkV2 "認める" | mkV2 "気付く" ;
lin lack_V2 = mkV2 "欠ける" | mkV2 "欠く" ;
lin lack_V = mkV "欠ける" | mkV "欠く" ;
lin strengthen_V2 = mkV2 "強くする" | mkV2 "強める" ;
lin snap_V2 = variants{} ; -- 
lin snap_V = variants{} ; -- 
lin readily_Adv = variants{} ; -- 
lin spite_N = variants{} ; -- 
lin conviction_N = mkN "信念" ;
lin corridor_N = mkN "空中回廊" ;
lin behind_Adv = variants{}; -- S.behind_Prep ;
lin ward_N = mkN "-区" ;
lin profile_N = mkN "プロフィール" ;
lin fat_A = mkA "太った" | mkA "肥満" ;
lin comfort_N = mkN "慰め" ;
lin bathroom_N = mkN "風呂場" | mkN "浴室" ;
lin shell_N = mkN "空洞" ;
lin reward_N = mkN "報い" ;
lin deliberately_Adv = variants{} ; -- 
lin automatically_Adv = variants{} ; -- 
lin vegetable_N = mkN "植物人間" ;
lin imagination_N = mkN "想像" | mkN "空想" ;
lin junior_A = mkA "年下の" ;
lin unemployed_A = mkA "失業者" ;
lin mystery_N = mkN "ミステリー" ;
lin pose_V2 = mkV2 "ポーズをつくる" ;
lin pose_V = mkV "ポーズをつくる" ;
lin violent_A = mkA "激しい" ;
lin march_N = variants{} ; -- 
lin found_V2 = variants{} ; -- 
lin dig_V2 = mkV2 "掘る" ;
lin dig_V = L.dig_V | mkV "掘る" ;
lin dirty_A = L.dirty_A | mkA "汚い" ;
lin straight_A = L.straight_A | mkA "実直な" ;
lin psychological_A = variants{} ; -- 
lin grab_V2 = mkV2 "掴む" ;
lin grab_V = mkV "掴む" ;
lin pleasant_A = mkA "愉快な" ;
lin surgery_N = mkN "外科" ;
lin inevitable_A = mkA "不可避" | mkA "避けることのできない" ;
lin transform_V2 = mkV2 "変形する" ;
lin bell_N = mkN "ベルボトム" ;
lin announcement_N = mkN "発表" | mkN "お知らせ" ;
lin draft_N = mkN "下書き" ;
lin unity_N = variants{} ; -- 
lin airport_N = mkN "空港" ;
lin upset_V2 = mkV2 "引っ繰り返す" ;
lin upset_V = mkV "引っ繰り返す" ;
lin pretend_VS = mkVS "...の振りをする" | mkVS "見せ掛ける" | mkVS "装う" ;
lin pretend_V2 = mkV2 "...の振りをする" | mkV2 "見せ掛ける" | mkV2 "装う" ;
lin pretend_V = mkV "...の振りをする" | mkV "見せ掛ける" | mkV "装う" ;
lin plant_V2 = mkV2 "植える" ;
lin till_Prep = variants{} ; -- 
lin known_A = variants{} ; -- 
lin admission_N = mkN "入場" ;
lin tissue_N = mkN "組織" ;
lin magistrate_N = variants{} ; -- 
lin joy_N = mkN "喜び" ;
lin free_V2V = mkV2V "解放する" ;
lin free_V2 = mkV2 "解放する" ;
lin pretty_A = mkA "綺麗な" | mkA "プリティ" | mkA "可愛い" ;
lin operating_N = mkN "オペレーティングシステム" ;
lin headquarters_N = mkN "本部" | mkN "本社" ;
lin grateful_A = mkA "感謝する" | mkA "有難い" ;
lin classroom_N = mkN "教室" | mkN "教場" ;
lin turnover_N = mkN "取引高" ;
lin project_VS = variants{} ; -- 
lin project_V2V = variants{} ; -- 
lin project_V2 = variants{} ; -- 
lin project_V = variants{} ; -- 
lin shrug_V2 = mkV2 "肩を竦める" | mkV2 "肩を窄める" ;
lin sensible_A = variants{} ; -- 
lin limitation_N = variants{} ; -- 
lin specialist_N = mkN "専門家" | mkN "熟練者" ;
lin newly_Adv = variants{} ; -- 
lin tongue_N = L.tongue_N | mkN "舌" | mkN "べろ informal" ;
lin refugee_N = mkN "難民" ;
lin delay_V2 = mkV2 "遅らせる" | mkV2 "遅延させる" ;
lin delay_V = mkV "遅らせる" | mkV "遅延させる" ;
lin dream_V2 = mkV2 "夢を見る" | mkV2 "...を夢見る" ;
lin dream_V = mkV "夢を見る" | mkV "...を夢見る" ;
lin composition_N = variants{} ; -- 
lin alongside_Prep = variants{} ; -- 
lin ceiling_N = L.ceiling_N | mkN "天井関数" ;
lin highlight_V2 = variants{} ; -- 
lin stick_N = L.stick_N | mkN "ステッキ" | mkN "杖" ;
lin favourite_A = variants{} ; -- 
lin tap_V2 = variants{} ; -- 
lin tap_V = variants{} ; -- 
lin universe_N = mkN "宇宙" ;
lin request_VS = mkVS "要望する" | mkVS "要請する" | mkVS "求める" | mkVS "頼む" | mkVS "頼む" ;
lin request_V2 = mkV2 "要望する" | mkV2 "要請する" | mkV2 "求める" | mkV2 "頼む" | mkV2 "頼む" ;
lin label_N = mkN "ラベル" ;
lin confine_V2 = mkV2 "限る" ;
lin scream_VS = mkVS "悲鳴を上げる" | mkVS "喚く" | mkVS "怒鳴り付ける" | mkVS "キャーと叫ぶ" ;
lin scream_V2 = mkV2 "悲鳴を上げる" | mkV2 "喚く" | mkV2 "怒鳴り付ける" | mkV2 "キャーと叫ぶ" ;
lin scream_V = mkV "悲鳴を上げる" | mkV "喚く" | mkV "怒鳴り付ける" | mkV "キャーと叫ぶ" ;
lin rid_V2 = variants{} ; -- 
lin acceptance_N = mkN "承諾" ;
lin detective_N = mkN "探偵" ;
lin sail_V = mkV "航海する" | mkV "帆走する" ;
lin adjust_V2 = mkV2 "調整する" ;
lin adjust_V = mkV "調整する" ;
lin designer_N = mkN "デザイナー" | mkN "設計士" ;
lin running_A = variants{} ; -- 
lin summit_N = mkN "首脳会談" | mkN "サミット" ;
lin participation_N = mkN "参加" ;
lin weakness_N = mkN "弱さ" ;
lin block_V2 = variants{} ; -- 
lin socalled_A = variants{} ; -- 
lin adapt_V2 = mkV2 "適応する" ;
lin adapt_V = mkV "適応する" ;
lin absorb_V2 = mkV2 "負担する" ;
lin encounter_V2 = mkV2 "出会う" | mkV2 "遭遇する" | mkV2 "遭う" ;
lin defeat_V2 = mkV2 "負かす" | mkV2 "やっつける" | mkV2 "倒す" ;
lin excitement_N = variants{} ; -- 
lin brick_N = mkN "煉瓦" | mkN "れんが" ;
lin blind_A = mkA "視覚障害者" | mkA "目の見えない" | mkA "盲目" | mkA "盲" ;
lin wire_N = mkN "ニッパー" ;
lin crop_N = mkN "収穫" ;
lin square_A = mkA "平方" ;
lin transition_N = variants{} ; -- 
lin thereby_Adv = ParadigmsJpn.mkAdv "それによって" | ParadigmsJpn.mkAdv "そのために" ;
lin protest_V2 = mkV2 "抗議する" ;
lin protest_V = mkV "抗議する" ;
lin roll_N = mkN "巻子本" ;
lin stop_N = mkN "バス停" | mkN "停留所" ;
lin assistant_N = mkN "助手" ;
lin deaf_A = mkA "聴覚障害者" | mkA "耳の聞こえない" | mkA "聾" | mkA "聾者" ;
lin constituency_N = mkN "選挙区" ;
lin continuous_A = variants{} ; -- 
lin concert_N = mkN "コンサート" | mkN "音楽会" | mkN "合奏" ;
lin breast_N = L.breast_N | mkN "豊胸手術" ;
lin extraordinary_A = mkA "並外れた" | mkA "傑出した" | mkA "非凡な" ;
lin squad_N = variants{} ; -- 
lin wonder_N = mkN "驚嘆" | mkN "驚異" ;
lin cream_N = mkN "クリーム色" ;
lin tennis_N = mkN "テニス" ;
lin personally_Adv = variants{} ; -- 
lin communicate_V2 = variants{} ; -- 
lin communicate_V = variants{} ; -- 
lin pride_N = mkN "傲慢" ;
lin bowl_N = mkN "ボール" | mkN "丼" | mkN "鉢" ;
lin file_V2 = mkV2 "保管する" ;
lin file_V = mkV "保管する" ;
lin expertise_N = mkN "専門的知識" ;
lin govern_V2 = variants{} ; -- 
lin govern_V = variants{} ; -- 
lin leather_N = L.leather_N | mkN "皮" ;
lin observer_N = mkN "傍観者" | mkN "オブザーバー" ;
lin margin_N = variants{} ; -- 
lin uncertainty_N = variants{} ; -- 
lin reinforce_V2 = mkV2 "補強する" ;
lin ideal_N = mkN "理想" ;
lin injure_V2 = variants{} ; -- 
lin holding_N = mkN "持株会社" | mkN "also spelled: 持ち株会社" ;
lin universal_A = mkA "全世界の" ;
lin evident_A = variants{} ; -- 
lin dust_N = L.dust_N | mkN "埃" | mkN "ほこり" ;
lin overseas_A = mkA "海外の" ;
lin desperate_A = mkA "絶望的" ;
lin swim_V2 = mkV2 "泳ぐ" ;
lin swim_V = L.swim_V | mkV "泳ぐ" ;
lin occasional_A = mkA "時折の" | mkA "偶発的" | mkA "偶" | mkA "偶然な" ;
lin trouser_N = variants{} ; -- 
lin surprisingly_Adv = variants{} ; -- 
lin register_N = variants{} ; -- 
lin album_N = mkN "アルバム" ;
lin guideline_N = mkN "指針" | mkN "ガイドライン" ;
lin disturb_V2 = mkV2 "乱す" ;
lin amendment_N = mkN "修正案" | mkN "改正" ;
lin architectMasc_N = variants{} ; -- 
lin objection_N = mkN "異議あり" ;
lin chart_N = mkN "チャート" | mkN "図表" ;
lin cattle_N = mkN "家畜" ;
lin doubt_VS = mkVS "疑う" | mkVS "訝しむ" | mkVS "疑問する" | mkVS "不審に思う" ;
lin doubt_V2 = mkV2 "疑う" | mkV2 "訝しむ" | mkV2 "疑問する" | mkV2 "不審に思う" ;
lin react_V = mkV "反応する" ;
lin consciousness_N = mkN "意識" | mkN "人心地" ;
lin right_Interj = mkInterj "ね" ;
lin purely_Adv = variants{} ; -- 
lin tin_N = mkN "罐詰" | mkN "缶" ;
lin tube_N = mkN "管" | mkN "筒" | mkN "チューブ" | mkN "パイプ" ;
lin fulfil_V2 = variants{} ; -- 
lin commonly_Adv = variants{} ; -- 
lin sufficiently_Adv = variants{} ; -- 
lin coin_N = mkN "硬貨" | mkN "コイン" ;
lin frighten_V2 = mkV2 "怖がらせる" ;
lin grammar_N = L.grammar_N | mkN "文法書" | mkN "文法書" ;
lin diary_N = mkN "日記" ;
lin flesh_N = variants{} ; -- 
lin summary_N = variants{} ; -- 
lin infant_N = mkN "赤ちゃん" | mkN "赤ん坊" | mkN "幼児" | mkN "乳児" ;
lin stir_V2 = mkV2 "炒める" ;
lin stir_V = mkV "炒める" ;
lin storm_N = mkN "嵐" ;
lin mail_N = mkN "郵便" ;
lin rugby_N = mkN "ラグビー" ;
lin virtue_N = mkN "美徳" ;
lin specimen_N = mkN "見本" ;
lin psychology_N = mkN "心理学" | mkN "サイコロジー" ;
lin paint_N = mkN "ペンキ" ;
lin constraint_N = mkN "束縛" ;
lin trace_V2 = variants{} ; -- 
lin trace_V = variants{} ; -- 
lin privilege_N = mkN "特権" ;
lin completion_N = variants{} ; -- 
lin progress_V2 = variants{} ; -- 
lin progress_V = variants{} ; -- 
lin grade_N = mkN "等級" ;
lin exploit_V2 = mkV2 "搾り取る" ;
lin import_N = mkN "輸入" | mkN "輸入" ;
lin potato_N = mkN "じゃがいも" | mkN "馬鈴薯" ;
lin repair_N = mkN "修理" ;
lin passion_N = mkN "激情" ;
lin seize_V2 = mkV2 "捉える" | mkV2 "つかむ" ;
lin seize_V = mkV "捉える" | mkV "つかむ" ;
lin low_Adv = variants{} ; -- 
lin underlying_A = variants{} ; -- 
lin heaven_N = mkN "天国" | mkN "天堂" | mkN "楽園" ;
lin nerve_N = mkN "神経" ;
lin park_V2 = mkV2 "停まる" | mkV2 "駐車する" ;
lin park_V = mkV "停まる" | mkV "駐車する" ;
lin collapse_V2 = mkV2 "潰える" | mkV2 "崩壊する" ;
lin collapse_V = mkV "潰える" | mkV "崩壊する" ;
lin win_N = mkN "勝ち" | mkN "勝利" ;
lin printer_N = mkN "プリンター" | mkN "印刷機" ;
lin coalition_N = mkN "連立" ;
lin button_N = mkN "バッジ" ;
lin pray_V2 = mkV2 "願う" | mkV2 "請う" | mkV2 "嘆願する" ;
lin pray_V = mkV "願う" | mkV "請う" | mkV "嘆願する" ;
lin ultimate_A = variants{} ; -- 
lin venture_N = variants{} ; -- 
lin timber_N = mkN "梁" ;
lin companion_N = mkN "仲間" | mkN "友人" ;
lin horror_N = mkN "ホラー映画" ;
lin gesture_N = variants{} ; -- 
lin moon_N = L.moon_N | mkN "衛星" ;
lin remark_VS = mkVS "述べる" | mkVS "評する" | mkVS "言及する" ;
lin remark_V = mkV "述べる" | mkV "評する" | mkV "言及する" ;
lin clever_A = L.clever_A | mkA "賢い" | mkA "利口な" | mkA "頭がいい" ;
lin van_N = mkN "バン" | mkN "貨車" ;
lin consequently_Adv = variants{} ; -- 
lin raw_A = mkA "生の" ;
lin glance_N = mkN "一目" ;
lin broken_A = mkA "壊れた" | mkA "割れた" ;
lin jury_N = mkN "陪審" ;
lin gaze_V = variants{} ; -- 
lin burst_V2 = mkV2 "破裂する" ;
lin burst_V = mkV "破裂する" ;
lin charter_N = variants{} ; -- 
lin feministMasc_N = variants{} ; -- 
lin discourse_N = mkN "論文" ;
lin reflection_N = mkN "反射" ;
lin carbon_N = mkN "炭素" ;
lin sophisticated_A = variants{} ; -- 
lin ban_N = mkN "禁止" ;
lin taxation_N = mkN "課税" ;
lin prosecution_N = variants{} ; -- 
lin softly_Adv = variants{} ; -- 
lin asleep_A = mkA "寝ている" | mkA "眠っている" | mkA "熟睡" ;
lin aids_N = variants{} ; -- 
lin publicity_N = mkN "宣伝" | mkN "広報" ;
lin departure_N = mkN "出発" | mkN "発車" ;
lin welcome_A = mkA "歓迎すべき" ;
lin sharply_Adv = variants{} ; -- 
lin reception_N = mkN "受付" | mkN "受理" | mkN "収容" | mkN "入会" | mkN "加入" ;
lin cousin_N = L.cousin_N | mkN "いとこ" | mkN "従兄弟" | mkN "従姉妹" ;
lin relieve_V2 = variants{} ; -- 
lin linguistic_A = variants{} ; -- 
lin vat_N = variants{} ; -- 
lin forward_A = mkA "前の" | mkA "前方" ;
lin blue_N = mkN "青" ;
lin multiple_A = mkA "多重" ;
lin pass_N = mkN "通行証" | mkN "許可証" ;
lin outer_A = variants{} ; -- 
lin vulnerable_A = mkA "傷つきやすい" | mkA "脆い" | mkA "弱い" ;
lin patient_A = mkA "忍耐強い" | mkA "我慢強い" | mkA "気が長い" | mkA "しんぼう強い" ;
lin evolution_N = mkN "進化" ;
lin allocate_V2 = mkV2 "配置する" ;
lin allocate_V = mkV "配置する" ;
lin creative_A = variants{} ; -- 
lin potentially_Adv = variants{} ; -- 
lin just_A = mkA "公正な" ;
lin out_Prep = variants{} ; -- 
lin judicial_A = mkA "司法の" ;
lin risk_VV = variants{} ; -- 
lin risk_V2 = variants{} ; -- 
lin ideology_N = mkN "観念形態" | mkN "イデオロギー" ;
lin smell_VA = mkVA "匂う" ;
lin smell_V2 = mkV2 "匂う" ;
lin smell_V = L.smell_V | mkV "匂う" ;
lin agenda_N = mkN "議事" ;
lin transport_V2 = mkV2 "運送する" | mkV2 "輸送する" ;
lin illegal_A = mkA "不法の" | mkA "非合法の" ;
lin chicken_N = mkN "鶏" | mkN "ニワトリ" ;
lin plain_A = mkA "平" ;
lin innovation_N = mkN "イノベーション" | mkN "革新" ;
lin opera_N = mkN "喜歌劇" ;
lin lock_N = mkN "錠前" | mkN "錠" | mkN "ロック" ;
lin grin_V = variants{} ; -- 
lin shelf_N = mkN "棚" ;
lin pole_N = mkN "ポールダンス" ;
lin punishment_N = mkN "罰" | mkN "刑罰" | mkN "処罰" ;
lin strict_A = mkA "厳しい" ;
lin wave_V2 = mkV2 "振り動かす" ;
lin wave_V = mkV "振り動かす" ;
lin inside_N = mkN "内部" ;
lin carriage_N = mkN "客車" ;
lin fit_A = mkA "美人" | mkA "別嬪" ;
lin conversion_N = variants{} ; -- 
lin hurry_V = mkV "急ぐ" ;
lin essay_N = mkN "エッセイ" | mkN "随筆" ;
lin integration_N = mkN "統合" | mkN "融合" ;
lin resignation_N = mkN "辞任" | mkN "辞職" ;
lin treasury_N = mkN "宝庫" ;
lin traveller_N = mkN "旅人" | mkN "旅行者" ;
lin chocolate_N = mkN "チョコチップ" ;
lin assault_N = mkN "突撃" | mkN "攻撃" ;
lin schedule_N = mkN "予定" | mkN "日程" | mkN "スケジュール" ;
lin undoubtedly_Adv = variants{} ; -- 
lin twin_N = mkN "双子の一人" ;
lin format_N = mkN "形式" | mkN "フォーマット" ;
lin murder_V2 = mkV2 "殺す" | mkV2 "殺害する" ;
lin sigh_VS = mkVS "嘆く" | mkVS "嘆息する" | mkVS "ため息をつく" ;
lin sigh_V2 = mkV2 "嘆く" | mkV2 "嘆息する" | mkV2 "ため息をつく" ;
lin sigh_V = mkV "嘆く" | mkV "嘆息する" | mkV "ため息をつく" ;
lin sellerMasc_N = variants{} ; -- 
lin lease_N = variants{} ; -- 
lin bitter_A = mkA "激しい" | mkA "過酷な" | mkA "荒々しい" ;
lin double_V2 = mkV2 "ダブルクリックする" ;
lin double_V = mkV "ダブルクリックする" ;
lin ally_N = mkN "味方" ;
lin stake_N = mkN "棒" | mkN "杭" ;
lin processing_N = variants{} ; -- 
lin informal_A = mkA "非公式" ;
lin flexible_A = mkA "柔軟な" ;
lin cap_N = L.cap_N | mkN "被せ" ;
lin stable_A = mkA "安定した" ;
lin till_Subj = variants{} ; -- 
lin sympathy_N = mkN "共感" | mkN "共鳴" | mkN "交感" ;
lin tunnel_N = mkN "トンネル" | mkN "地下道" | mkN "隧道" | mkN "坑道" ;
lin pen_N = L.pen_N | mkN "ペン" | mkN "ボールペン" ;
lin instal_V = variants{} ; -- 
lin suspend_V2 = mkV2 "停止する" ;
lin suspend_V = mkV "停止する" ;
lin blow_N = variants{} ; -- 
lin wander_V = mkV "横道にそれる" ;
lin notably_Adv = variants{} ; -- 
lin disappoint_V2 = mkV2 "失望させる" ;
lin wipe_V2 = L.wipe_V2 | mkV2 "拭く" ;
lin wipe_V = mkV "拭く" ;
lin folk_N = mkN "フォークダンス" | mkN "民族舞踊" ;
lin attraction_N = variants{} ; -- 
lin disc_N = mkN "ディスクジョッキー" | mkN "DJ" | mkN "ディージェイ" ;
lin inspire_V2V = mkV2V "動かす" ;
lin inspire_V2 = mkV2 "動かす" ;
lin machinery_N = mkN "機械類" ;
lin undergo_V2 = variants{} ; -- 
lin nowhere_Adv = ParadigmsJpn.mkAdv "どこにも" ;
lin inspector_N = mkN "警部" ;
lin wise_A = mkA "賢い" | mkA "賢明な" ;
lin balance_V2 = variants{} ; -- 
lin balance_V = variants{} ; -- 
lin purchaser_N = variants{} ; -- 
lin resort_N = mkN "リゾート" ;
lin pop_N = mkN "ポップ" | mkN "ポップス" ;
lin organ_N = mkN "オルガン" ;
lin ease_V2 = variants{} ; -- 
lin ease_V = variants{} ; -- 
lin friendship_N = mkN "交際" ;
lin deficit_N = mkN "赤字" | mkN "欠損" ;
lin dear_N = variants{} ; -- 
lin convey_V2 = mkV2 "運ぶ" | mkV2 "運搬する" ;
lin reserve_V2 = mkV2 "予約する" ;
lin reserve_V = mkV "予約する" ;
lin planet_N = L.planet_N | mkN "惑星" | mkN "プラネット" ;
lin frequent_A = mkA "頻繁な" ;
lin loose_A = mkA "ゆるんだ" ;
lin intense_A = mkA "激烈な" ;
lin retail_A = variants{} ; -- 
lin wind_V = mkV "巻き戻す" ;
lin lost_A = mkA "失った" | mkA "負けた" ;
lin grain_N = mkN "穀物" | mkN "穀類" ;
lin particle_N = mkN "粒子加速器" ;
lin destruction_N = mkN "破壊" | mkN "滅亡" | mkN "絶滅" ;
lin witness_V2 = variants{} ; -- 
lin witness_V = variants{} ; -- 
lin pit_N = mkN "落とし穴" | mkN "穴" ;
lin registration_N = mkN "登録" ;
lin conception_N = mkN "妊娠" | mkN "受胎" ;
lin steady_A = mkA "着実" | mkA "安定した" ;
lin rival_N = mkN "ライバル" | mkN "敵" ;
lin steam_N = mkN "蒸気機関" ;
lin back_A = mkA "裏" ;
lin chancellor_N = variants{} ; -- 
lin crash_V = mkV "クラッシュする" ;
lin belt_N = mkN "ベルト" ;
lin logic_N = mkN "論理" ;
lin premium_N = variants{} ; -- 
lin confront_V2 = variants{} ; -- 
lin precede_V2 = variants{} ; -- 
lin experimental_A = variants{} ; -- 
lin alarm_N = mkN "警報" ;
lin rational_A = mkA "有理の" ;
lin incentive_N = mkN "報酬" | mkN "賞与" ;
lin roughly_Adv = variants{} ; -- 
lin bench_N = mkN "ベンチ" ;
lin wrap_V2 = mkV2 "包む" | mkV2 "包装する" ;
lin wrap_V = mkV "包む" | mkV "包装する" ;
lin regarding_Prep = variants{} ; -- 
lin inadequate_A = mkA "不適当" | mkA "不十分" ;
lin ambition_N = mkN "野望" ;
lin since_Adv = variants{} ; -- 
lin fate_N = mkN "運命" | mkN "宿命" ;
lin vendor_N = mkN "売り手" | mkN "販売者" ;
lin stranger_N = mkN "外国人" | mkN "外人" ;
lin spiritual_A = mkA "精神的" ;
lin increasing_A = variants{} ; -- 
lin anticipate_VV = mkVV "予想する" ;
lin anticipate_VS = mkVS "予想する" ;
lin anticipate_V2 = mkV2 "予想する" ;
lin anticipate_V = mkV "予想する" ;
lin logical_A = variants{} ; -- 
lin fibre_N = mkN "繊維" ;
lin attribute_V2 = variants{} ; -- 
lin sense_VS = mkVS "感じる" | mkVS "察する" | mkVS "気づく" ;
lin sense_V2 = mkV2 "感じる" | mkV2 "察する" | mkV2 "気づく" ;
lin black_N = mkN "黒人" ;
lin petrol_N = variants{} ; -- 
lin maker_N = mkN "メーカー" ;
lin generous_A = mkA "気の大きい" ;
lin allocation_N = variants{} ; -- 
lin depression_N = mkN "低気圧" ;
lin declaration_N = mkN "宣言" ;
lin spot_VS = variants{} ; -- 
lin spot_V2 = variants{} ; -- 
lin spot_V = variants{} ; -- 
lin modest_A = mkA "謙虚" | mkA "謙遜した" ;
lin bottom_A = variants{} ; -- 
lin dividend_N = mkN "被除数" ;
lin devote_V2 = variants{} ; -- 
lin condemn_V2 = mkV2 "責める" | mkV2 "非難する" ;
lin integrate_V2 = variants{} ; -- 
lin integrate_V = variants{} ; -- 
lin pile_N = mkN "積み重ね" ;
lin identification_N = mkN "身分証明" | mkN "身分証明書" ;
lin acute_A = mkA "鋭角の" ;
lin barely_Adv = ParadigmsJpn.mkAdv "ぎりぎり" ;
lin providing_Subj = variants{} ; -- 
lin directive_N = mkN "指示" ;
lin bet_VS = mkVS "賭ける" ;
lin bet_V2 = mkV2 "賭ける" ;
lin bet_V = mkV "賭ける" ;
lin modify_V2 = variants{} ; -- 
lin bare_A = variants{} ; -- 
lin swear_VV = mkVV "怒鳴る" | mkVV "ののしる" | mkVV "悪態をつく" ;
lin swear_V2 = mkV2 "怒鳴る" | mkV2 "ののしる" | mkV2 "悪態をつく" ;
lin swear_V = mkV "怒鳴る" | mkV "ののしる" | mkV "悪態をつく" ;
lin final_N = mkN "韻母" ;
lin accordingly_Adv = variants{} ; -- 
lin valid_A = mkA "有効な" ;
lin wherever_Adv = variants{} ; -- 
lin mortality_N = mkN "死亡率" ;
lin medium_N = variants{} ; -- 
lin silk_N = mkN "絹" | mkN "絹布" | mkN "絹地" ;
lin funeral_N = mkN "葬式" | mkN "葬儀" ;
lin depending_A = variants{} ; -- 
lin cow_N = L.cow_N | mkN "牛" ;
lin correspond_V2 = variants{}; -- mkV "文通する" ;
lin correspond_V = mkV "文通する" ;
lin cite_V2 = variants{} ; -- 
lin classic_A = variants{} ; -- 
lin inspection_N = mkN "検査" ;
lin calculation_N = variants{} ; -- 
lin rubbish_N = mkN "ゴミ" | mkN "ガラクタ" | mkN "廃品" ;
lin minimum_N = mkN "最小" | mkN "最低" | mkN "極小" ;
lin hypothesis_N = mkN "仮定" ;
lin youngster_N = mkN "若者" | mkN "小僧" ;
lin slope_N = mkN "坂" | mkN "坂道" | mkN "スロープ" | mkN "傾斜" | mkN "勾配" ;
lin patch_N = mkN "パッチ" ;
lin invitation_N = mkN "招待" | mkN "招き" | mkN "誘い" ;
lin ethnic_A = variants{} ; -- 
lin federation_N = mkN "連邦" | mkN "連盟" | mkN "同盟" ;
lin duke_N = mkN "公爵" ;
lin wholly_Adv = variants{} ; -- 
lin closure_N = mkN "関数閉包" | mkN "クロージャ" ;
lin dictionary_N = mkN "辞書" ;
lin withdrawal_N = mkN "膣外射精" ;
lin automatic_A = mkA "自動な" | mkA "自動的な" ;
lin liable_A = variants{} ; -- 
lin cry_N = mkN "泣き声" ;
lin slow_V2 = variants{} ; -- 
lin slow_V = variants{} ; -- 
lin borough_N = mkN "区" ;
lin well_A = mkA "元気" ;
lin suspicion_N = mkN "疑い" ;
lin portrait_N = mkN "画像" | mkN "肖像" ;
lin local_N = mkN "ローカル・エリア・ネットワーク" ;
lin jew_N = variants{} ; -- 
lin fragment_N = mkN "断片" ;
lin revolutionary_A = variants{} ; -- 
lin evaluate_V2 = mkV2 "評する" ;
lin evaluate_V = mkV "評する" ;
lin competitor_N = mkN "競争者" ;
lin sole_A = mkA "唯一の" ;
lin reliable_A = mkA "頼もしい" ;
lin weigh_V2 = mkV2 "抜錨する" | mkV2 "錨を上げる" ;
lin weigh_V = mkV "抜錨する" | mkV "錨を上げる" ;
lin medieval_A = variants{} ; -- 
lin clinic_N = mkN "医院" ;
lin shine_V2 = mkV2 "照らす" ;
lin shine_V = mkV "照らす" ;
lin knit_V2 = mkV2 "編む" ;
lin knit_V = mkV "編む" ;
lin complexity_N = mkN "複雑さ" ;
lin remedy_N = mkN "医学" ;
lin fence_N = mkN "垣" | mkN "塀" | mkN "垣根" | mkN "囲い" ;
lin bike_N = L.bike_N | mkN "自転車" | mkN "チャリンコ" ;
lin freeze_V2 = mkV2 "凍る" | mkV2 "凍らせる" ;
lin freeze_V = L.freeze_V | mkV "凍る" | mkV "凍らせる" ;
lin eliminate_V2 = mkV2 "除去する" ;
lin interior_N = mkN "内装" | mkN "内部" | mkN "インテリア" ;
lin intellectual_A = mkA "知識人" ;
lin established_A = variants{} ; -- 
lin voter_N = mkN "投票者" | mkN "選挙人" ;
lin garage_N = mkN "車庫" | mkN "ガレージ" ;
lin era_N = mkN "時代" ;
lin pregnant_A = mkA "妊娠している" | mkA "おめでた" ;
lin plot_N = mkN "プロット" ;
lin greet_V2 = mkV2 "挨拶する" | mkV2 "出迎える" | mkV2 "歓迎する" ;
lin electrical_A = variants{} ; -- 
lin lie_N = mkN "嘘発見器" ;
lin disorder_N = mkN "混乱" ;
lin formally_Adv = variants{} ; -- 
lin excuse_N = mkN "言い訳" | mkN "口実" | mkN "弁解" ;
lin socialist_A = variants{} ; -- 
lin cancel_V2 = mkV2 "取り消す" | mkV2 "キャンセルする" ;
lin cancel_V = mkV "取り消す" | mkV "キャンセルする" ;
lin harm_N = mkN "損害" ;
lin excess_N = variants{} ; -- 
lin exact_A = mkA "正確な" | mkA "精密な" | mkA "詳しい" ;
lin oblige_V2V = mkV2V "恩義がある" | mkV2V "世話になる" ;
lin oblige_V2 = mkV2 "恩義がある" | mkV2 "世話になる" ;
lin accountant_N = mkN "会計士" ;
lin mutual_A = mkA "相互" | mkA "互いの" ;
lin fat_N = L.fat_N | mkN "脂肪" | mkN "脂" ;
lin volunteerMasc_N = variants{} ; -- 
lin laughter_N = mkN "笑い" ;
lin trick_N = mkN "手品" | mkN "トリック" ;
lin load_V2 = mkV2 "弾を込める" | mkV2 "装塡する" ;
lin load_V = mkV "弾を込める" | mkV "装塡する" ;
lin disposal_N = variants{} ; -- 
lin taxi_N = mkN "タクシー" ;
lin murmur_V2 = mkV2 "呟く" ;
lin murmur_V = mkV "呟く" ;
lin tonne_N = variants{} ; -- 
lin spell_V2 = mkV2 "綴る" ;
lin spell_V = mkV "綴る" ;
lin clerk_N = mkN "事務員" | mkN "店員" | mkN "書記" ;
lin curious_A = mkA "好奇心の強い" | mkA "知りたがる" ;
lin satisfactory_A = variants{} ; -- 
lin identical_A = mkA "同一の" ;
lin applicant_N = mkN "志願者" | mkN "応募者" | mkN "申し込み者" | mkN "申し立て人" | mkN "申請人" ;
lin removal_N = variants{} ; -- 
lin processor_N = mkN "プロセッサー" | mkN "演算機" ;
lin cotton_N = mkN "綿生地" | mkN "コットン" ;
lin reverse_V2 = variants{} ; -- 
lin reverse_V = variants{} ; -- 
lin hesitate_VV = mkVV "ためらう" | mkVV "躊躇する" ;
lin hesitate_V = mkV "ためらう" | mkV "躊躇する" ;
lin professor_N = mkN "教授" | mkN "先生" ;
lin admire_V2 = mkV2 "感心する" ;
lin namely_Adv = ParadigmsJpn.mkAdv "即ち" | ParadigmsJpn.mkAdv "つまり" ;
lin electoral_A = variants{} ; -- 
lin delight_N = variants{} ; -- 
lin urgent_A = mkA "緊急の" | mkA "急を要する" ;
lin prompt_V2V = variants{} ; -- 
lin prompt_V2 = variants{} ; -- 
lin mate_N = mkN "友達" ;
lin mate_2_N = variants{} ; -- 
lin mate_1_N = variants{} ; -- 
lin exposure_N = mkN "露出" ;
lin server_N = mkN "サーバー" ;
lin distinctive_A = variants{} ; -- 
lin marginal_A = variants{} ; -- 
lin structural_A = variants{} ; -- 
lin rope_N = L.rope_N | mkN "ロープ" | mkN "綱" | mkN "縄" ;
lin miner_N = mkN "鉱夫" | mkN "坑夫" | mkN "鉱山労働者" ;
lin entertainment_N = mkN "娯楽" | mkN "エンタメ" ;
lin acre_N = mkN "エーカー" ;
lin pig_N = mkN "豚" | mkN "ブタ" ;
lin encouraging_A = variants{} ; -- 
lin guarantee_N = mkN "保証" ;
lin gear_N = mkN "ギア" ;
lin anniversary_N = mkN "記念日" | mkN "周年" ;
lin past_Adv = variants{} ; -- 
lin ceremony_N = mkN "儀礼" ;
lin rub_V2 = L.rub_V2 | mkV2 "擦る" ;
lin rub_V = mkV "擦る" ;
lin monopoly_N = mkN "独占" | mkN "独り占め" ;
lin left_N = mkN "左利き" | mkN "ぎっちょ" ;
lin flee_V2 = mkV2 "逃げる" ;
lin flee_V = mkV "逃げる" ;
lin yield_V2 = mkV2 "譲る" ;
lin discount_N = mkN "割引" | mkN "値引き" | mkN "ディスカウント" ;
lin above_A = mkA "上述" "上述の" ;
lin uncle_N = mkN "伯父" | mkN "伯父さん" | mkN "" | mkN "伯父貴 叔父" | mkN "叔父さん" | mkN "叔父貴" ;
lin audit_N = mkN "監査" ;
lin advertisement_N = mkN "広告" | mkN "CM" ;
lin explosion_N = mkN "爆発音" ;
lin contrary_A = variants{} ; -- 
lin tribunal_N = mkN "法廷" ;
lin swallow_V2 = mkV2 "飲み込む" ;
lin swallow_V = mkV "飲み込む" ;
lin typically_Adv = variants{} ; -- 
lin fun_A = mkA "楽しい" ;
lin rat_N = mkN "鼠" | mkN "ネズミ" | mkN "ラット" | mkN "熊鼠" | mkN "クマネズミ" ;
lin cloth_N = mkN "布" ;
lin cable_N = mkN "ケーブル" | mkN "電線" ;
lin interrupt_V2 = mkV2 "割り込む" ;
lin interrupt_V = mkV "割り込む" ;
lin crash_N = mkN "クラッシュ" | mkN "激突" ;
lin flame_N = mkN "炎色" ;
lin controversy_N = mkN "論争" ;
lin rabbit_N = mkN "兎" | mkN "ウサギ" ;
lin everyday_A = variants{} ; -- 
lin allegation_N = mkN "主張" | mkN "申し立て" ;
lin strip_N = mkN "ストリップクラブ" ;
lin stability_N = mkN "安定性" | mkN "安定" | mkN "スタビリティー" ;
lin tide_N = mkN "潮" | mkN "潮汐" ;
lin illustration_N = mkN "イラストレーション" | mkN "イラスト" | mkN "絵図" | mkN "絵" | mkN "図" ;
lin insect_N = mkN "昆虫" | mkN "虫" ;
lin correspondent_N = variants{} ; -- 
lin devise_V2 = variants{} ; -- 
lin determined_A = mkA "断固とした" ;
lin brush_V2 = mkV2 "塗る" ;
lin brush_V = mkV "塗る" ;
lin adjustment_N = mkN "調整" | mkN "調節" ;
lin controversial_A = variants{} ; -- 
lin organic_A = mkA "有機" ;
lin escape_N = mkN "脱出" ;
lin thoroughly_Adv = variants{} ; -- 
lin interface_N = mkN "インターフェース" ;
lin historic_A = variants{} ; -- 
lin collapse_N = mkN "崩壊" ;
lin temple_N = mkN "伸子" ;
lin shade_N = mkN "影" ;
lin craft_N = mkN "職業" ;
lin nursery_N = mkN "童謡" ;
lin piano_N = mkN "ピアノ" ;
lin desirable_A = mkA "望ましい" ;
lin assurance_N = variants{} ; -- 
lin jurisdiction_N = mkN "管轄" ;
lin advertise_V2 = mkV2 "宣伝する" ;
lin advertise_V = mkV "宣伝する" ;
lin bay_N = mkN "湾" ;
lin specification_N = mkN "仕様" ;
lin disability_N = mkN "身体障害" ;
lin presidential_A = variants{} ; -- 
lin arrest_N = mkN "検挙" ;
lin unexpected_A = variants{} ; -- 
lin switch_N = mkN "スイッチ" | mkN "開閉器" ;
lin penny_N = variants{} ; -- 
lin respect_V2 = mkV2 "尊敬する" ;
lin celebration_N = mkN "お祝い" | mkN "祝賀" | mkN "慶祝" ;
lin gross_A = mkA "きもい" ;
lin aid_V2 = mkV2 "補助する" | mkV2 "援助する" ;
lin aid_V = mkV "補助する" | mkV "援助する" ;
lin superb_A = variants{} ; -- 
lin process_V2 = variants{} ; -- 
lin process_V = variants{} ; -- 
lin innocent_A = mkA "無邪気な" ;
lin leap_V2 = mkV2 "飛躍する" | mkV2 "跳躍する" ;
lin leap_V = mkV "飛躍する" | mkV "跳躍する" ;
lin colony_N = mkN "コロニー" | mkN "植民地" ;
lin wound_N = mkN "傷" | mkN "怪我" ;
lin hardware_N = mkN "ハードウェア" | mkN "ハード" ;
lin satellite_N = mkN "従者" ;
lin float_V = L.float_V | mkV "超える" ;
lin bible_N = mkN "虎の巻" ;
lin statistical_A = variants{} ; -- 
lin marked_A = variants{} ; -- 
lin hire_V2V = mkV2V "雇う" | mkV2V "雇用する" ;
lin hire_V2 = mkV2 "雇う" | mkV2 "雇用する" ;
lin cathedral_N = mkN "大聖堂" ;
lin motive_N = mkN "動機" ;
lin correct_VS = mkVS "正す" | mkVS "直す" | mkVS "修正する" | mkVS "改正する" | mkVS "訂正する" ;
lin correct_V2 = mkV2 "正す" | mkV2 "直す" | mkV2 "修正する" | mkV2 "改正する" | mkV2 "訂正する" ;
lin correct_V = mkV "正す" | mkV "直す" | mkV "修正する" | mkV "改正する" | mkV "訂正する" ;
lin gastric_A = variants{} ; -- 
lin raid_N = mkN "襲撃" ;
lin comply_V2 = mkV2 "従う" | mkV2 "応じる" ;
lin comply_V = mkV "従う" | mkV "応じる" ;
lin accommodate_V2 = variants{} ; -- 
lin accommodate_V = variants{} ; -- 
lin mutter_V2 = mkV2 "呟く" | mkV2 "囁く" ;
lin mutter_V = mkV "呟く" | mkV "囁く" ;
lin induce_V2 = variants{} ; -- 
lin trap_V2 = variants{} ; -- 
lin trap_V = variants{} ; -- 
lin invasion_N = mkN "侵略" | mkN "侵攻" ;
lin humour_N = mkN "気分" | mkN "気持ち" ;
lin bulk_N = variants{} ; -- 
lin traditionally_Adv = variants{} ; -- 
lin commission_V2V = variants{} ; -- 
lin commission_V2 = variants{} ; -- 
lin upstairs_Adv = ParadigmsJpn.mkAdv "階上" ;
lin translate_V2 = mkV2 "訳す" | mkV2 "翻訳する" ;
lin translate_V = mkV "訳す" | mkV "翻訳する" ;
lin rhythm_N = mkN "リズム" ;
lin emission_N = variants{} ; -- 
lin collective_A = variants{} ; -- 
lin transformation_N = mkN "変態" ;
lin battery_N = mkN "殴打" ;
lin stimulus_N = mkN "刺激" ;
lin naked_A = mkA "裸の" ;
lin white_N = mkN "白人" ;
lin menu_N = mkN "メニュー" | mkN "お品書き" ;
lin toilet_N = mkN "トイレ" | mkN "お手洗い" | mkN "便所" | mkN "化粧室" ;
lin butter_N = L.butter_N | mkN "バター" | mkN "乳酪" ;
lin surprise_V2V = mkV2V "驚かす" ;
lin surprise_V2 = mkV2 "驚かす" ;
lin needle_N = mkN "針" ;
lin effectiveness_N = variants{} ; -- 
lin accordance_N = variants{} ; -- 
lin molecule_N = mkN "分子" ;
lin fiction_N = mkN "フィクション" ;
lin learning_N = mkN "学習" ;
lin statute_N = mkN "律令" ;
lin reluctant_A = variants{} ; -- 
lin overlook_V2 = mkV2 "見落とす" | mkV2 "見逃す" ;
lin junction_N = mkN "合流点" | mkN "ジャンクション" ;
lin necessity_N = mkN "必要性" ;
lin nearby_A = variants{} ; -- 
lin experienced_A = mkA "経験豊かな" ;
lin lorry_N = variants{} ; -- 
lin exclusive_A = variants{} ; -- 
lin graphics_N = mkN "ビデオカード" | mkN "グラフィックスカード" | mkN "グラボ" ;
lin stimulate_V2 = mkV2 "刺激する" ;
lin warmth_N = mkN "暖かさ" | mkN "温かみ" ;
lin therapy_N = mkN "治癒力" ;
lin convenient_A = mkA "便利" ;
lin cinema_N = mkN "映画" ;
lin domain_N = mkN "ドメイン" ;
lin tournament_N = mkN "トーナメント" | mkN "大会" ;
lin doctrine_N = variants{} ; -- 
lin sheer_A = mkA "純粋な" ;
lin proposition_N = mkN "命題" ;
lin grip_N = mkN "つかむこと" ;
lin widow_N = mkN "孤立行" | mkN "ウィドー" ;
lin discrimination_N = mkN "差別" ;
lin bloody_Adv = variants{} ; -- 
lin ruling_A = variants{} ; -- 
lin fit_N = variants{} ; -- 
lin nonetheless_Adv = variants{} ; -- 
lin myth_N = mkN "伝説" ;
lin episode_N = mkN "出来事" | mkN "挿話" | mkN "エピソード" ;
lin drift_V2 = mkV2 "漂流する" ;
lin drift_V = mkV "漂流する" ;
lin assert_VS = mkVS "主張する" ;
lin assert_V2 = mkV2 "主張する" ;
lin assert_V = mkV "主張する" ;
lin terrace_N = variants{} ; -- 
lin uncertain_A = variants{} ; -- 
lin twist_V2 = mkV2 "捻る" | mkV2 "捻る" ;
lin insight_N = variants{} ; -- 
lin undermine_V2 = variants{} ; -- 
lin tragedy_N = mkN "悲劇" ;
lin enforce_V2 = variants{} ; -- 
lin criticize_V2 = variants{} ; -- 
lin criticize_V = variants{} ; -- 
lin march_V2 = mkV2 "行軍する" ;
lin march_V = mkV "行軍する" ;
lin leaflet_N = mkN "散らし" | mkN "チラシ" | mkN "リーフレット" ;
lin fellow_A = variants{} ; -- 
lin object_V2 = mkV2 "反対する" ;
lin object_V = mkV "反対する" ;
lin pond_N = mkN "池" ;
lin adventure_N = mkN "冒険" ;
lin diplomatic_A = variants{} ; -- 
lin mixed_A = mkA "混合した" | mkA "交じった" ;
lin rebel_N = mkN "反逆者" ;
lin equity_N = mkN "自己資本" | mkN "純資産" ;
lin literally_Adv = variants{} ; -- 
lin magnificent_A = mkA "素晴しい" ;
lin loyalty_N = mkN "忠誠心" ;
lin tremendous_A = mkA "莫大" ;
lin airline_N = mkN "航空会社" | mkN "エアライン" ;
lin shore_N = mkN "岸" | mkN "海岸" | mkN "海浜" | mkN "湖岸" | mkN "河岸" ;
lin restoration_N = mkN "回復" ;
lin physically_Adv = variants{} ; -- 
lin render_V2 = variants{} ; -- 
lin institutional_A = variants{} ; -- 
lin emphasize_VS = mkVS "強調する" | mkVS "アクセントをつける" ;
lin emphasize_V2 = mkV2 "強調する" | mkV2 "アクセントをつける" ;
lin mess_N = mkN "混乱" ;
lin commander_N = mkN "司令" ;
lin straightforward_A = mkA "率直" | mkA "まっすぐ" | mkA "簡単" ;
lin singer_N = mkN "歌手" ;
lin squeeze_V2 = L.squeeze_V2 | mkV2 "スクイズする" ;
lin squeeze_V = mkV "スクイズする" ;
lin full_time_A = variants{} ; -- 
lin breed_V2 = mkV2 "育てる" | mkV2 "育成する" ;
lin breed_V = mkV "育てる" | mkV "育成する" ;
lin successor_N = mkN "相続人" ;
lin triumph_N = mkN "意気揚々" | mkN "勝ち誇り" ;
lin heading_N = variants{} ; -- 
lin mathematics_N = mkN "数学" ;
lin laugh_N = mkN "笑い" ;
lin clue_N = mkN "手がかり" | mkN "切っ掛け" | mkN "きっかけ" ;
lin still_A = mkA "止まっている" | mkA "静止した" ;
lin ease_N = variants{} ; -- 
lin specially_Adv = variants{} ; -- 
lin biological_A = mkA "生物学の" ;
lin forgive_V2 = mkV2 "許す" ;
lin forgive_V = mkV "許す" ;
lin trustee_N = mkN "受託者" | mkN "管財人" | mkN "保管人" ;
lin photo_N = mkN "写真" ;
lin fraction_N = mkN "分数" ;
lin chase_V2 = mkV2 "追いかける" | mkV2 "追跡する" | mkV2 "追う" ;
lin chase_V = mkV "追いかける" | mkV "追跡する" | mkV "追う" ;
lin whereby_Adv = variants{} ; -- 
lin mud_N = mkN "泥" ;
lin pensioner_N = variants{} ; -- 
lin functional_A = mkA "機能の" | mkA "機能する" ;
lin copy_V2 = mkV2 "写す" | mkV2 "コピーする" ;
lin copy_V = mkV "写す" | mkV "コピーする" ;
lin strictly_Adv = variants{} ; -- 
lin desperately_Adv = variants{} ; -- 
lin await_V2 = mkV2 "待つ" ;
lin coverage_N = variants{} ; -- 
lin wildlife_N = mkN "野生動物" ;
lin indicator_N = mkN "針" ;
lin lightly_Adv = variants{} ; -- 
lin hierarchy_N = mkN "階層" | mkN "序列" ;
lin evolve_V2 = variants{} ; -- 
lin evolve_V = variants{} ; -- 
lin mechanical_A = variants{} ; -- 
lin expert_A = mkA "専門的" ;
lin creditor_N = mkN "債権者" | mkN "貸方" ;
lin capitalist_N = variants{} ; -- 
lin essence_N = mkN "本質" ;
lin compose_V2 = mkV2 "構成する" ;
lin compose_V = mkV "構成する" ;
lin mentally_Adv = variants{} ; -- 
lin gaze_N = variants{} ; -- 
lin seminar_N = mkN "ゼミナール" | mkN "ゼミ" | mkN "セミナー" ;
lin target_V2V = variants{} ; -- 
lin target_V2 = variants{} ; -- 
lin label_V3 = variants{} ; -- 
lin label_V2 = variants{} ; -- 
lin label_V = variants{} ; -- 
lin fig_N = mkN "イチジク" ;
lin continent_N = mkN "大陸" ;
lin chap_N = mkN "やつ" | mkN "奴" ;
lin flexibility_N = mkN "柔軟性" | mkN "可撓性" | mkN "フレキシビリティ" ;
lin verse_N = variants{} ; -- 
lin minute_A = variants{} ; -- 
lin whisky_N = variants{} ; -- 
lin equivalent_A = mkA "相当" ;
lin recruit_V2 = variants{} ; -- 
lin recruit_V = variants{} ; -- 
lin echo_V2 = mkV2 "響く" ;
lin echo_V = mkV "響く" ;
lin unfair_A = mkA "不公平" ;
lin launch_N = mkN "発射" ;
lin cupboard_N = mkN "食器棚" ;
lin bush_N = mkN "灌木" | mkN "低木" | mkN "茂み" ;
lin shortage_N = variants{} ; -- 
lin prominent_A = mkA "著名な" ;
lin merger_N = mkN "合併" | mkN "統合" ;
lin command_V2 = variants{} ; -- 
lin command_V = variants{} ; -- 
lin subtle_A = mkA "巧妙" ;
lin capital_A = mkA "優れた" | mkA "素晴らしい" ;
lin gang_N = mkN "団" ;
lin fish_V2 = mkV2 "釣る" ;
lin fish_V = mkV "釣る" ;
lin unhappy_A = variants{} ; -- 
lin lifetime_N = mkN "生涯" | mkN "一生" | mkN "一生涯" ;
lin elite_N = variants{} ; -- 
lin refusal_N = mkN "拒絶" | mkN "拒否" | mkN "断わり" ;
lin finish_N = variants{} ; -- 
lin aggressive_A = mkA "積極的な" | mkA "侵略的な" | mkA "攻撃的な" ;
lin superior_A = mkA "目上の" | mkA "優れた" ;
lin landing_N = mkN "船着き場" ;
lin exchange_V2 = variants{} ; -- 
lin debate_V2 = variants{} ; -- 
lin debate_V = variants{} ; -- 
lin educate_V2 = variants{} ; -- 
lin separation_N = mkN "三権分立" ;
lin productivity_N = variants{} ; -- 
lin initiate_V2 = variants{} ; -- 
lin probability_N = mkN "確率" ;
lin virus_N = variants{} ; -- 
lin reporterMasc_N = variants{} ; -- 
lin fool_N = mkN "道化 師" ;
lin pop_V2 = variants{} ; -- 
lin capitalism_N = mkN "資本主義" ;
lin painful_A = mkA "苦しい" | mkA "困難な" | mkA "骨の折れる" ;
lin correctly_Adv = variants{} ; -- 
lin complex_N = mkN "コンプレックス" ;
lin rumour_N = variants{} ; -- 
lin imperial_A = variants{} ; -- 
lin justification_N = mkN "正当化" ;
lin availability_N = mkN "供給" ;
lin spectacular_A = mkA "華華しい" | mkA "壮大な" | mkA "壮観な" ;
lin remain_N = variants{} ; -- 
lin ocean_N = mkN "大洋" | mkN "海洋" | mkN "海" ;
lin cliff_N = mkN "崖" ;
lin sociology_N = mkN "社会学" ;
lin sadly_Adv = variants{} ; -- 
lin missile_N = mkN "弾丸" ;
lin situate_V2 = variants{} ; -- 
lin artificial_A = mkA "人工の" ;
lin apartment_N = L.apartment_N | mkN "アパート" | mkN "マンション" ;
lin provoke_V2 = mkV2 "怒らせる" | mkV2 "立腹させる" | mkV2 "憤慨させる" ;
lin oral_A = mkA "口頭の" ;
lin maximum_N = mkN "最大" | mkN "極大" ;
lin angel_N = mkN "天使" ;
lin spare_A = variants{} ; -- 
lin shame_N = mkN "恥" | mkN "羞恥心" | mkN "面汚し" ;
lin intelligent_A = mkA "聡明な" | mkA "賢い" | mkA "利口な" ;
lin discretion_N = variants{} ; -- 
lin businessman_N = mkN "実業家" | mkN "ビジネスマン" ;
lin explicit_A = mkA "どぎつい" | mkA "あからさま" ;
lin book_V2 = mkV2 "調書を取る" ;
lin uniform_N = mkN "制服" | mkN "ユニフォーム" ;
lin push_N = mkN "腕立て伏せ" ;
lin counter_N = mkN "カウンタ" | mkN "カウンター" ;
lin subject_A = variants{} ; -- 
lin objective_A = mkA "客観" ;
lin hungry_A = mkA "空腹な" | mkA "飢えた" | mkA "お腹が空いている" ;
lin clothing_N = mkN "服" ;
lin ride_N = variants{} ; -- 
lin romantic_A = mkA "ロマンチック" | mkA "浪漫的" ;
lin attendance_N = mkN "出席" ;
lin part_time_A = variants{} ; -- 
lin trace_N = mkN "跡" ;
lin backing_N = variants{} ; -- 
lin sensation_N = mkN "感覚" ;
lin carrier_N = mkN "キャリアバッグ" | mkN "ビニール袋" ;
lin interest_V2 = mkV2 "興味を引く" ;
lin interest_V = mkV "興味を引く" ;
lin classification_N = mkN "分類" ;
lin classic_N = mkN "クラシック" | mkN "古典" ;
lin beg_V2 = mkV2 "物乞い" ;
lin beg_V = mkV "物乞い" ;
lin appendix_N = mkN "付録" ;
lin doorway_N = mkN "戸口" ;
lin density_N = mkN "濃度" ;
lin working_class_A = variants{} ; -- 
lin legislative_A = variants{} ; -- 
lin hint_N = mkN "ヒント" | mkN "手がかり" ;
lin shower_N = mkN "にわか雨" | mkN "にわか雨" ;
lin current_N = mkN "当座預金" ;
lin succession_N = mkN "相続" ;
lin nasty_A = variants{} ; -- 
lin duration_N = mkN "期間" | mkN "存続" ;
lin desert_N = variants{} ; -- 
lin receipt_N = mkN "受け取り" | mkN "領収" | mkN "領収証" | mkN "受領書" | mkN "受領証" | mkN "レシット" ;
lin native_A = mkA "自国の" ;
lin chapel_N = mkN "チャペル" ;
lin amazing_A = mkA "驚くべき" | mkA "凄い" ;
lin hopefully_Adv = variants{} ; -- 
lin fleet_N = variants{} ; -- 
lin comparable_A = mkA "比較できる" ;
lin oxygen_N = mkN "酸素" | mkN "オキシジェン" ;
lin installation_N = mkN "インストール" | mkN "取り付け" ;
lin developer_N = mkN "現像液" ;
lin disadvantage_N = variants{} ; -- 
lin recipe_N = mkN "調理手順" | mkN "レシピ" | mkN "料理法" ;
lin crystal_N = mkN "結晶" ;
lin modification_N = mkN "修正" ;
lin schedule_V2V = variants{} ; -- 
lin schedule_V2 = variants{} ; -- 
lin schedule_V = variants{} ; -- 
lin midnight_N = mkN "深夜" | mkN "真夜中" ;
lin successive_A = variants{} ; -- 
lin formerly_Adv = variants{} ; -- 
lin loud_A = mkA "煩い" | mkA "姦しい" | mkA "囂しい" | mkA "騒がしい" | mkA "騒々しい" | mkA "騒然" | mkA "喧しい" ;
lin value_V2 = variants{} ; -- 
lin value_V = variants{} ; -- 
lin physics_N = mkN "物理学" ;
lin truck_N = mkN "トラック" | mkN "貨物自動車" ;
lin stroke_N = mkN "脳梗塞" ;
lin kiss_N = mkN "キス" | mkN "接吻" | mkN "口付け" | mkN "チュー" ;
lin envelope_N = mkN "封筒" ;
lin speculation_N = mkN "投機" ;
lin canal_N = mkN "運河" ;
lin unionist_N = variants{} ; -- 
lin directory_N = mkN "一覧" | mkN "名鑑" ;
lin receiver_N = mkN "受取人" ;
lin isolation_N = variants{} ; -- 
lin fade_V2 = variants{} ; -- 
lin fade_V = variants{} ; -- 
lin chemistry_N = mkN "化学" ;
lin unnecessary_A = mkA "不必要な" ;
lin hit_N = mkN "ヒット" ;
lin defenderMasc_N = variants{} ; -- 
lin stance_N = mkN "立場" | mkN "姿勢" | mkN "態度" ;
lin sin_N = mkN "罪" ;
lin realistic_A = mkA "現実的" ;
lin socialist_N = variants{} ; -- 
lin subsidy_N = mkN "援助" | mkN "補助" ;
lin content_A = mkA "満足している" ;
lin toy_N = mkN "おもちゃ" | mkN "玩具" ;
lin darling_N = mkN "愛すべき" | mkN "ダーリン" | mkN "スイートハート" | mkN "ハニー" | mkN "貴方" | mkN "君" ;
lin decent_A = variants{} ; -- 
lin liberty_N = mkN "自由" ;
lin forever_Adv = ParadigmsJpn.mkAdv "永久に" | ParadigmsJpn.mkAdv "永遠に" ;
lin skirt_N = mkN "スカート" ;
lin coordinate_V2 = variants{} ; -- 
lin coordinate_V = variants{} ; -- 
lin tactic_N = mkN "戦術" | mkN "戦法" ;
lin influential_A = variants{} ; -- 
lin import_V2 = mkV2 "輸入する" ;
lin accent_N = mkN "アクセント" ;
lin compound_N = mkN "化合物" ;
lin bastard_N = mkN "私生子" ;
lin ingredient_N = mkN "成分" | mkN "原材料" | mkN "食材" ;
lin dull_A = L.dull_A | mkA "退屈な" | mkA "つまらない" ;
lin cater_V = variants{} ; -- 
lin scholar_N = variants{} ; -- 
lin faint_A = mkA "勇気のない" ;
lin ghost_N = mkN "幽霊" | mkN "亡霊" | mkN "化け物" | mkN "死霊" | mkN "妖怪" | mkN "お化け" | mkN "怨霊" | mkN "幽鬼" | mkN "魂魄" | mkN "精霊" | mkN "妖魔" | mkN "魂" | mkN "霊" | mkN "変化" | mkN "物の怪" | mkN "ゴースト" ;
lin sculpture_N = mkN "彫刻" ;
lin ridiculous_A = mkA "馬鹿らしい" ;
lin diagnosis_N = mkN "診断" ;
lin delegate_N = mkN "代表" | mkN "使節" | mkN "代理人" ;
lin neat_A = mkA "きちんとした" ;
lin kit_N = mkN "道具" | mkN "セット" | mkN "設備" ;
lin lion_N = mkN "ライオン" | mkN "獅子" ;
lin dialogue_N = mkN "対話" | mkN "討論" | mkN "会話" ;
lin repair_V2 = mkV2 "修理する" ;
lin repair_V = mkV "修理する" ;
lin tray_N = mkN "トレイ" ;
lin fantasy_N = mkN "幻想" | mkN "空想" | mkN "ファンタジー" ;
lin leave_N = variants{} ; -- 
lin export_V2 = mkV2 "輸出する" ;
lin export_V = mkV "輸出する" ;
lin forth_Adv = variants{} ; -- 
lin lamp_N = L.lamp_N | mkN "ランプ" | mkN "明かり" | mkN "灯" | mkN "電灯" ;
lin allege_VS = mkVS "主張する" | mkVS "喧伝する" | mkVS "言い張る" ;
lin allege_V2 = mkV2 "主張する" | mkV2 "喧伝する" | mkV2 "言い張る" ;
lin pavement_N = mkN "歩道" | mkN "舗道" | mkN "舗装" ;
lin brand_N = mkN "ブランド" ;
lin constable_N = variants{} ; -- 
lin compromise_N = mkN "妥協" | mkN "折衷" | mkN "和解" ;
lin flag_N = mkN "旗" ;
lin filter_N = mkN "フィルター" ;
lin reign_N = variants{} ; -- 
lin execute_V2 = mkV2 "実行する" ;
lin pity_N = mkN "憐れみ" ;
lin merit_N = mkN "価値" ;
lin diagram_N = mkN "図" | mkN "ダイヤグラム" | mkN "図表" | mkN "グラフ" | mkN "チャート" ;
lin wool_N = mkN "羊毛" ;
lin organism_N = mkN "有機体" ;
lin elegant_A = mkA "優雅な" | mkA "立派な" | mkA "高雅な" | mkA "典雅な" ;
lin red_N = mkN "赤" ;
lin undertaking_N = variants{} ; -- 
lin lesser_A = variants{} ; -- 
lin reach_N = mkN "到達範囲" ;
lin marvellous_A = variants{} ; -- 
lin improved_A = variants{} ; -- 
lin locally_Adv = variants{} ; -- 
lin entity_N = variants{} ; -- 
lin rape_N = mkN "強姦" | mkN "手込め" | mkN "手篭" | mkN "レイプ" ;
lin secure_A = variants{} ; -- 
lin descend_V2 = variants{} ; -- 
lin descend_V = variants{} ; -- 
lin backwards_Adv = variants{} ; -- 
lin peer_V = variants{} ; -- 
lin excuse_V2 = mkV2 "言い訳をする" ;
lin genetic_A = mkA "遺伝的" ;
lin fold_V2 = mkV2 "折る" | mkV2 "畳む" ;
lin fold_V = mkV "折る" | mkV "畳む" ;
lin portfolio_N = variants{} ; -- 
lin consensus_N = mkN "総意" | mkN "協心" | mkN "コンセンサス" ;
lin thesis_N = mkN "論題" | mkN "主張" | mkN "テーゼ" | mkN "定立" ;
lin shop_V = mkV "買い物をする" ;
lin nest_N = mkN "巣" | mkN "ネスト" ;
lin frown_V = mkV "顔を顰める" ;
lin builder_N = mkN "ビルダー" ;
lin administer_V2 = mkV2 "管理する" ;
lin administer_V = mkV "管理する" ;
lin tip_V2 = variants{} ; -- 
lin tip_V = variants{} ; -- 
lin lung_N = mkN "肺臓" | mkN "肺" ;
lin delegation_N = variants{} ; -- 
lin outside_N = mkN "外界" ;
lin heating_N = mkN "加熱" ;
lin like_Subj = variants{} ; -- 
lin instinct_N = mkN "本能" ;
lin teenager_N = mkN "ティーネージャー" | mkN "少年" ;
lin lonely_A = mkA "さびしい" | mkA "寂しい" ;
lin residence_N = mkN "住宅" ;
lin radiation_N = mkN "放射" ;
lin extract_V2 = variants{} ; -- 
lin concession_N = variants{} ; -- 
lin autonomy_N = mkN "自治" ;
lin norm_N = variants{} ; -- 
lin musicianMasc_N = variants{} ; -- 
lin graduate_N = mkN "卒業生" ;
lin glory_N = mkN "栄光の日々" | mkN "全盛期" ;
lin bear_N = mkN "小熊" ;
lin persist_V = mkV "固執する" | mkV "言い張る" | mkV "貫く" | mkV "持続する" | mkV "残存する" | mkV "尾を引く" ;
lin rescue_V2 = mkV2 "救う" | mkV2 "助ける" | mkV2 "救い出す" | mkV2 "救助する" ;
lin equip_V2 = mkV2 "装着" ;
lin partial_A = variants{} ; -- 
lin officially_Adv = variants{} ; -- 
lin capability_N = mkN "能力" ;
lin worry_N = mkN "心配" ;
lin liberation_N = mkN "解放" ;
lin hunt_V2 = L.hunt_V2 | mkV2 "狩る" ;
lin hunt_V = mkV "狩る" ;
lin daily_Adv = ParadigmsJpn.mkAdv "毎日" | ParadigmsJpn.mkAdv "日々" ;
lin heel_N = mkN "踵" | mkN "ヒール" ;
lin contract_V2V = mkV2V "罹る" ;
lin contract_V2 = mkV2 "罹る" ;
lin contract_V = mkV "罹る" ;
lin update_V2 = mkV2 "更新する" | mkV2 "アップデートする" ;
lin assign_V2V = mkV2V "割り当てる" ;
lin assign_V2 = mkV2 "割り当てる" ;
lin spring_V2 = mkV2 "跳ね上がる" | mkV2 "跳ねる" ;
lin spring_V = mkV "跳ね上がる" | mkV "跳ねる" ;
lin single_N = mkN "単打" ;
lin commons_N = variants{} ; -- 
lin weekly_A = mkA "毎週の" ;
lin stretch_N = mkN "ストレッチ" ;
lin pregnancy_N = mkN "妊娠" ;
lin happily_Adv = variants{} ; -- 
lin spectrum_N = mkN "スペクトル" ;
lin interfere_V = mkV "妨げる" | mkV "干渉する" ;
lin suicide_N = mkN "自爆テロ" ;
lin panic_N = mkN "パニック" | mkN "恐慌" ;
lin invent_V2 = mkV2 "発明する" ;
lin invent_V = mkV "発明する" ;
lin intensive_A = variants{} ; -- 
lin damp_A = mkA "湿っぽい" | mkA "湿った" ;
lin simultaneously_Adv = variants{} ; -- 
lin giant_N = mkN "巨人" ;
lin casual_A = mkA "カジュアルな" ;
lin sphere_N = mkN "球" | mkN "球体" ;
lin precious_A = mkA "大切な" ;
lin sword_N = mkN "刀" | mkN "剣" ;
lin envisage_V2 = variants{} ; -- 
lin bean_N = mkN "豆" ;
lin time_V2 = variants{} ; -- 
lin crazy_A = mkA "狂しい" ;
lin changing_A = variants{} ; -- 
lin primary_N = mkN "主キー" ;
lin concede_VS = mkVS "認める" ;
lin concede_V2 = mkV2 "認める" ;
lin concede_V = mkV "認める" ;
lin besides_Adv = ParadigmsJpn.mkAdv "それに" | ParadigmsJpn.mkAdv "ほかに" ;
lin unite_V2 = mkV2 "結合する" ;
lin unite_V = mkV "結合する" ;
lin severely_Adv = variants{} ; -- 
lin separately_Adv = variants{} ; -- 
lin instruct_V2 = variants{} ; -- 
lin insert_V2 = mkV2 "差し込む" | mkV2 "挟み込む" | mkV2 "挿入する" ;
lin go_N = mkN "囲碁" | mkN "碁" ;
lin exhibit_V2 = variants{} ; -- 
lin brave_A = mkA "勇敢な" | mkA "勇気ある" | mkA "勇猛な" ;
lin tutor_N = mkN "チューター" ;
lin tune_N = variants{} ; -- 
lin debut_N = mkN "デビュー" ;
lin debut_2_N = variants{} ; -- 
lin debut_1_N = variants{} ; -- 
lin continued_A = variants{} ; -- 
lin bid_V2 = mkV2 "値をつける" | mkV2 "入札する" ;
lin bid_V = mkV "値をつける" | mkV "入札する" ;
lin incidence_N = variants{} ; -- 
lin downstairs_Adv = ParadigmsJpn.mkAdv "階下" ;
lin cafe_N = variants{} ; -- 
lin regret_VS = mkVS "後悔する" | mkVS "悔いる" | mkVS "残念に思う" ;
lin regret_V2 = mkV2 "後悔する" | mkV2 "悔いる" | mkV2 "残念に思う" ;
lin killer_N = mkN "殺人者" | mkN "人殺し" ;
lin delicate_A = mkA "繊細な、優美な、精緻な" ;
lin subsidiary_N = mkN "子会社" ;
lin gender_N = mkN "性" | mkN "性別" ;
lin entertain_V2 = mkV2 "楽しませる" | mkV2 "歓待する" | mkV2 "もてなす" ;
lin cling_V = mkV "掛ける" | mkV "ぶら下がる" | mkV "ぶら下げる" ;
lin vertical_A = mkA "垂直の" | mkA "縦の" | mkA "直立の" ;
lin fetch_V2 = mkV2 "持ち帰る" ;
lin strip_V2 = mkV2 "奪い取る" ;
lin strip_V = mkV "奪い取る" ;
lin plead_VS = mkVS "嘆願する" ;
lin plead_V2 = mkV2 "嘆願する" ;
lin plead_V = mkV "嘆願する" ;
lin duck_N = mkN "アヒル" | mkN "鴨" | mkN "カモ" ;
lin breed_N = variants{} ; -- 
lin assistant_A = variants{} ; -- 
lin pint_N = mkN "パイント" ;
lin abolish_V2 = mkV2 "廃止する" ;
lin translation_N = mkN "翻訳" ;
lin princess_N = mkN "姫" | mkN "王女" | mkN "プリンセス" ;
lin line_V2 = variants{} ; -- 
lin line_V = variants{} ; -- 
lin excessive_A = mkA "過度の" ;
lin digital_A = mkA "デジタル" ;
lin steep_A = variants{} ; -- 
lin jet_N = mkN "ジェット機" ;
lin hey_Interj = mkInterj "おい" | mkInterj "ねえ" ;
lin grave_N = mkN "墓" ;
lin exceptional_A = variants{} ; -- 
lin boost_V2 = variants{} ; -- 
lin random_A = mkA "任意の" | mkA "適当な" ;
lin correlation_N = variants{} ; -- 
lin outline_N = mkN "概略" | mkN "概要" ;
lin intervene_V2V = variants{} ; -- 
lin intervene_V = variants{} ; -- 
lin packet_N = variants{} ; -- 
lin motivation_N = mkN "動機" ;
lin safely_Adv = variants{} ; -- 
lin harsh_A = mkA "粗い" ;
lin spell_N = mkN "スペルチェッカ" | mkN "スペルチェッカー" ;
lin spread_N = mkN "拡散" | mkN "展開" ;
lin draw_N = mkN "引き分け" ;
lin concrete_A = mkA "コンクリートの" ;
lin complicated_A = mkA "複雑" ;
lin alleged_A = variants{} ; -- 
lin redundancy_N = mkN "冗長" ;
lin progressive_A = variants{} ; -- 
lin intensity_N = mkN "強度" ;
lin crack_N = mkN "ひび" | mkN "亀裂" | mkN "裂け目" ;
lin fly_N = mkN "蝿" | mkN "ハエ" ;
lin fancy_V2 = variants{} ; -- 
lin alternatively_Adv = variants{} ; -- 
lin waiting_A = variants{} ; -- 
lin scandal_N = mkN "不祥事" | mkN "スキャンダル" ;
lin resemble_V2 = mkV2 "似ている" ;
lin parameter_N = mkN "パラメーター" | mkN "引数" ;
lin fierce_A = variants{} ; -- 
lin tropical_A = mkA "熱帯" ;
lin colour_V2A = variants{} ; -- 
lin colour_V2 = variants{} ; -- 
lin colour_V = variants{} ; -- 
lin engagement_N = mkN "婚約" ;
lin contest_N = mkN "コンクール" | mkN "コンテスト" | mkN "競争" ;
lin edit_V2 = mkV2 "編集する" ;
lin courage_N = mkN "勇気" | mkN "度胸" ;
lin hip_N = mkN "ヒップ" | mkN "腰" ;
lin delighted_A = mkA "喜ぶ" | mkA "嬉しがる" ;
lin sponsor_V2 = variants{} ; -- 
lin carer_N = variants{} ; -- 
lin crack_V2 = variants{} ; -- 
lin substantially_Adv = variants{} ; -- 
lin occupational_A = variants{} ; -- 
lin trainer_N = mkN "トレーナー" | mkN "コーチ" ;
lin remainder_N = mkN "売れ残り" ;
lin related_A = variants{} ; -- 
lin inherit_V2 = mkV2 "受継ぐ" ;
lin inherit_V = mkV "受継ぐ" ;
lin resume_V2 = mkV2 "再開する" ;
lin resume_V = mkV "再開する" ;
lin assignment_N = mkN "代入" ;
lin conceal_V2 = mkV2 "隠す" ;
lin disclose_VS = variants{} ; -- 
lin disclose_V2 = variants{} ; -- 
lin disclose_V = variants{} ; -- 
lin exclusively_Adv = variants{} ; -- 
lin working_N = mkN "労働者階級" ;
lin mild_A = mkA "穏やか" | mkA "緩やか" | mkA "温厚" ;
lin chronic_A = mkA "慢性的" ;
lin splendid_A = mkA "立派" | mkA "輝かしい" ;
lin function_V = mkV "機能する" ;
lin riderMasc_N = variants{} ; -- 
lin clay_N = mkN "粘土" ;
lin firstly_Adv = ParadigmsJpn.mkAdv "先ず" | ParadigmsJpn.mkAdv "第一に" | ParadigmsJpn.mkAdv "最初に" | ParadigmsJpn.mkAdv "初めに" ;
lin conceive_V2 = mkV2 "孕む" | mkV2 "妊娠になる" | mkV2 "おめでたになる" ;
lin conceive_V = mkV "孕む" | mkV "妊娠になる" | mkV "おめでたになる" ;
lin politically_Adv = variants{} ; -- 
lin terminal_N = mkN "ターミナル" | mkN "エアターミナル" ;
lin accuracy_N = mkN "正確性" | mkN "正確さ" | mkN "精密性" | mkN "精密さ" | mkN "確度" ;
lin coup_N = mkN "クーデター" | mkN "政変" ;
lin ambulance_N = mkN "救急車" ;
lin living_N = mkN "暮らし" | mkN "生活" ;
lin offenderMasc_N = variants{} ; -- 
lin similarity_N = mkN "類似" ;
lin orchestra_N = mkN "オーケストラ" ;
lin brush_N = mkN "ブラシがけ" | mkN "磨き" ;
lin systematic_A = variants{} ; -- 
lin striker_N = variants{} ; -- 
lin guard_V2 = mkV2 "守る" ;
lin guard_V = mkV "守る" ;
lin casualty_N = mkN "犠牲者" ;
lin steadily_Adv = variants{} ; -- 
lin painter_N = mkN "画家" | mkN "絵かき" ;
lin opt_VV = variants{} ; -- 
lin opt_V = variants{} ; -- 
lin handsome_A = mkA "ハンサムな" ;
lin banking_N = variants{} ; -- 
lin sensitivity_N = variants{} ; -- 
lin navy_N = mkN "ネービーブルー" ;
lin fascinating_A = variants{} ; -- 
lin disappointment_N = mkN "失望" ;
lin auditor_N = mkN "監査役" ;
lin hostility_N = mkN "敵意" ;
lin spending_N = variants{} ; -- 
lin scarcely_Adv = variants{} ; -- 
lin compulsory_A = mkA "強制的" ;
lin photographer_N = mkN "撮影者" | mkN "写真師" | mkN "写真家" ;
lin ok_Interj = variants{} ; -- 
lin neighbourhood_N = mkN "近所" | mkN "近隣" | mkN "周辺" ;
lin ideological_A = mkA "イデオロギーの" ;
lin wide_Adv = variants{} ; -- 
lin pardon_N = mkN "許し" ;
lin double_N = mkN "漫才" ;
lin criticize_V2 = variants{} ; -- 
lin criticize_V = variants{} ; -- 
lin supervision_N = variants{} ; -- 
lin guilt_N = mkN "罪悪感" ;
lin deck_N = mkN "デッキ" | mkN "甲板" ;
lin payable_A = variants{} ; -- 
lin execution_N = mkN "実行" ;
lin suite_N = variants{} ; -- 
lin elected_A = variants{} ; -- 
lin solely_Adv = variants{} ; -- 
lin moral_N = mkN "教訓" ;
lin collector_N = mkN "集める人" | mkN "かけ取り" | mkN "bill]" ;
lin questionnaire_N = mkN "アンケート" ;
lin flavour_N = variants{} ; -- 
lin couple_V2 = variants{} ; -- 
lin couple_V = variants{} ; -- 
lin faculty_N = variants{} ; -- 
lin tour_V2 = variants{} ; -- 
lin tour_V = variants{} ; -- 
lin basket_N = mkN "ゴール得点" ;
lin mention_N = variants{} ; -- 
lin kick_N = mkN "缶蹴り" ;
lin horizon_N = mkN "地平線" | mkN "水平線" ;
lin drain_V2 = variants{} ; -- 
lin drain_V = variants{} ; -- 
lin happiness_N = mkN "幸福" | mkN "幸せ" | mkN "愉快" ;
lin fighter_N = mkN "戦闘機" ;
lin estimated_A = variants{} ; -- 
lin copper_N = mkN "銅" | mkN "赤金" ;
lin legend_N = mkN "凡例" ;
lin relevance_N = mkN "関連性" ;
lin decorate_V2 = mkV2 "飾る" | mkV2 "装飾する" ;
lin continental_A = variants{} ; -- 
lin ship_V2 = mkV2 "発送する" | mkV2 "出荷する" ;
lin ship_V = mkV "発送する" | mkV "出荷する" ;
lin operational_A = variants{} ; -- 
lin incur_V2 = variants{} ; -- 
lin parallel_A = mkA "平行の" ;
lin divorce_N = mkN "離婚" ;
lin opposed_A = variants{} ; -- 
lin equilibrium_N = mkN "平衡" ;
lin trader_N = mkN "商人" | mkN "トレーダー" ;
lin ton_N = mkN "トン" ;
lin can_N = mkN "缶" ;
lin juice_N = mkN "ジュース" ;
lin forum_N = mkN "フォーラム" | mkN "伝言板" ;
lin spin_V2 = mkV2 "紡ぐ" ;
lin spin_V = mkV "紡ぐ" ;
lin research_V2 = mkV2 "研究する" ;
lin research_V = mkV "研究する" ;
lin hostile_A = mkA "敵対的" ;
lin consistently_Adv = variants{} ; -- 
lin technological_A = variants{} ; -- 
lin nightmare_N = mkN "悪夢" ;
lin medal_N = mkN "賞牌" | mkN "メダル" | mkN "勲章" ;
lin diamond_N = mkN "鑽石" ;
lin speed_V2 = variants{} ; -- 
lin speed_V = variants{} ; -- 
lin peaceful_A = mkA "平和な" ;
lin accounting_A = variants{} ; -- 
lin scatter_V2 = mkV2 "散乱する" ;
lin scatter_V = mkV "散乱する" ;
lin monster_N = mkN "怪物" | mkN "モンスター" | mkN "化け物" ;
lin horrible_A = variants{} ; -- 
lin nonsense_N = mkN "無意味" | mkN "ナンセンス" | mkN "馬鹿げた事" ;
lin chaos_N = mkN "混沌" ;
lin accessible_A = variants{} ; -- 
lin humanity_N = mkN "人類" ;
lin frustration_N = variants{} ; -- 
lin chin_N = mkN "顎" ;
lin bureau_N = mkN "両替屋" | mkN "通貨両替" ;
lin advocate_VS = mkVS "説く" | mkVS "主張する" ;
lin advocate_V2 = mkV2 "説く" | mkV2 "主張する" ;
lin polytechnic_N = variants{} ; -- 
lin inhabitant_N = mkN "居住者" | mkN "住民" ;
lin evil_A = variants{} ; -- 
lin slave_N = mkN "スレーブ" ;
lin reservation_N = mkN "保留" ;
lin slam_V2 = mkV2 "ばたんと閉める" ;
lin slam_V = mkV "ばたんと閉める" ;
lin handle_N = mkN "ハンドル" ;
lin provincial_A = variants{} ; -- 
lin fishing_N = mkN "漁船" ;
lin facilitate_V2 = variants{} ; -- 
lin yield_N = mkN "収穫" | mkN "利益" ;
lin elbow_N = mkN "肘" ;
lin bye_Interj = mkInterj "では" | mkInterj "またね" | mkInterj "じゃ、また" | mkInterj "バイバイ" | mkInterj "バイ" ;
lin warm_V2 = mkV2 "心を温める" ;
lin warm_V = mkV "心を温める" ;
lin sleeve_N = mkN "袖" | mkN "スリーブ" ;
lin exploration_N = variants{} ; -- 
lin creep_V = mkV "這う" | mkV "伝う" ;
lin adjacent_A = variants{} ; -- 
lin theft_N = mkN "盗み" ;
lin round_V2 = variants{} ; -- 
lin round_V = variants{} ; -- 
lin grace_N = mkN "加護" ;
lin predecessor_N = mkN "前機種" ;
lin supermarket_N = mkN "スーパーマーケット" | mkN "スーパー" ;
lin smart_A = mkA "賢い" | mkA "利口な" | mkA "頭がいい" ;
lin sergeant_N = mkN "軍曹" ;
lin regulate_V2 = mkV2 "調節する" ;
lin clash_N = variants{} ; -- 
lin assemble_V2 = mkV2 "集まる" ;
lin assemble_V = mkV "集まる" ;
lin arrow_N = mkN "矢" ;
lin nowadays_Adv = ParadigmsJpn.mkAdv "現在" | ParadigmsJpn.mkAdv "現代" ;
lin giant_A = variants{} ; -- 
lin waiting_N = mkN "待つこと" ;
lin tap_N = mkN "蛇口" ;
lin shit_N = mkN "下痢" | mkN "げり" ;
lin sandwich_N = mkN "サンドイッチ" ;
lin vanish_V = mkV "消える" ;
lin commerce_N = mkN "貿易" | mkN "交易" | mkN "商業" ;
lin pursuit_N = mkN "追求" ;
lin post_war_A = variants{} ; -- 
lin will_V2 = mkV2 "なる" ;
lin will_V = mkV "なる" ;
lin waste_A = mkA "荒れた" ;
lin collar_N = mkN "首輪" ;
lin socialism_N = mkN "社会主義" ;
lin skill_V = variants{} ; -- 
lin rice_N = mkN "もち" | mkN "餅" ;
lin exclusion_N = variants{} ; -- 
lin upwards_Adv = variants{} ; -- 
lin transmission_N = mkN "転送" | mkN "伝送" ;
lin instantly_Adv = variants{} ; -- 
lin forthcoming_A = mkA "来たる" | mkA "今度の" ;
lin appointed_A = variants{} ; -- 
lin geographical_A = variants{} ; -- 
lin fist_N = mkN "拳" ;
lin abstract_A = mkA "抽象的な" ;
lin embrace_V2 = mkV2 "抱く" ;
lin embrace_V = mkV "抱く" ;
lin dynamic_A = variants{} ; -- 
lin drawer_N = mkN "引き出し" | mkN "引出し" ;
lin dismissal_N = mkN "解雇" ;
lin magic_N = mkN "魔術" | mkN "魔法" | mkN "マジック" ;
lin endless_A = mkA "終わりのない" | mkA "果てしない" ;
lin definite_A = variants{} ; -- 
lin broadly_Adv = variants{} ; -- 
lin affection_N = mkN "愛情" ;
lin dawn_N = mkN "夜明け" ;
lin principal_N = mkN "学校長" ;
lin bloke_N = variants{} ; -- 
lin trap_N = mkN "罠" ;
lin communist_A = mkA "共産主義者の" | mkA "共産主義の" ;
lin competence_N = mkN "実力" ;
lin complicate_V2 = mkV2 "複雑にする" ;
lin neutral_A = mkA "中立の" ;
lin fortunately_Adv = ParadigmsJpn.mkAdv "幸運にも" ;
lin commonwealth_N = mkN "連邦" | mkN "コモンウェルス" ;
lin breakdown_N = mkN "故障" ;
lin combined_A = variants{} ; -- 
lin candle_N = mkN "蝋燭" ;
lin venue_N = variants{} ; -- 
lin supper_N = mkN "夕食" ;
lin analyst_N = mkN "アナリスト" ;
lin vague_A = mkA "漠然とした" ;
lin publicly_Adv = variants{} ; -- 
lin marine_A = variants{} ; -- 
lin fair_Adv = ParadigmsJpn.mkAdv "公明正大" | ParadigmsJpn.mkAdv "堂々と" ;
lin pause_N = mkN "休止" | mkN "中断" ;
lin notable_A = mkA "顕著な" ;
lin freely_Adv = variants{} ; -- 
lin counterpart_N = variants{} ; -- 
lin lively_A = variants{} ; -- 
lin script_N = mkN "文字" ;
lin sue_V2V = mkV2V "訴える" ;
lin sue_V2 = mkV2 "訴える" ;
lin sue_V = mkV "訴える" ;
lin legitimate_A = variants{} ; -- 
lin geography_N = mkN "地理学" ;
lin reproduce_V2 = variants{} ; -- 
lin reproduce_V = variants{} ; -- 
lin moving_A = mkA "感動的な" ;
lin lamb_N = mkN "ラム" | mkN "羊肉" ;
lin gay_A = mkA "派手な" ;
lin contemplate_VS = mkVS "熟考する" ;
lin contemplate_V2 = mkV2 "熟考する" ;
lin contemplate_V = mkV "熟考する" ;
lin terror_N = mkN "恐怖" ;
lin stable_N = mkN "馬小屋" ;
lin founder_N = mkN "創設者" ;
lin utility_N = mkN "ユーティリティ" ;
lin signal_VS = variants{} ; -- 
lin signal_V2 = variants{} ; -- 
lin shelter_N = variants{} ; -- 
lin poster_N = mkN "ポスター" ;
lin hitherto_Adv = ParadigmsJpn.mkAdv "今まで" | ParadigmsJpn.mkAdv "これまで" | ParadigmsJpn.mkAdv "これまでのところ" ;
lin mature_A = mkA "成熟" | mkA "成熟した" | mkA "円熟した" | mkA "十分成長した" ;
lin cooking_N = mkN "料理" ;
lin head_A = mkA "向かい" ;
lin wealthy_A = mkA "裕福な" | mkA "豊かな" | mkA "富有な" | mkA "金持の" ;
lin fucking_A = mkA "むかつく" | mkA "糞の" ;
lin confess_VS = mkVS "認める" | mkVS "自白する" | mkVS "告白する" | mkVS "告解する" ;
lin confess_V2 = mkV2 "認める" | mkV2 "自白する" | mkV2 "告白する" | mkV2 "告解する" ;
lin confess_V = mkV "認める" | mkV "自白する" | mkV "告白する" | mkV "告解する" ;
lin age_V = mkV "年を取る" | mkV "としをとる" ;
lin miracle_N = mkN "奇跡" ;
lin magic_A = mkA "マジック" ;
lin jaw_N = mkN "齶" ;
lin pan_N = mkN "汎アラブ主義" | mkN "パンアラブ主義" ;
lin coloured_A = variants{} ; -- 
lin tent_N = mkN "テント" | mkN "幕屋" ;
lin telephone_V2 = mkV2 "電話をかける" ;
lin telephone_V = mkV "電話をかける" ;
lin reduced_A = variants{} ; -- 
lin tumour_N = variants{} ; -- 
lin super_A = mkA "超" ;
lin funding_N = mkN "資金" | mkN "融資" ;
lin dump_V2 = variants{} ; -- 
lin dump_V = variants{} ; -- 
lin stitch_N = variants{} ; -- 
lin shared_A = variants{} ; -- 
lin ladder_N = mkN "梯子" | mkN "はしご" ;
lin keeper_N = mkN "番人" ;
lin endorse_V2 = variants{} ; -- 
lin invariably_Adv = variants{} ; -- 
lin smash_V2 = mkV2 "打ち砕く" ;
lin smash_V = mkV "打ち砕く" ;
lin shield_N = mkN "盾" ;
lin heat_V2 = variants{} ; -- 
lin heat_V = variants{} ; -- 
lin surgeon_N = mkN "外科医" | mkN "執刀医" ;
lin centre_V2 = variants{} ; -- 
lin centre_V = variants{} ; -- 
lin orange_N = variants{} ; -- 
lin orange_2_N = variants{} ; -- 
lin orange_1_N = variants{} ; -- 
lin explode_V = mkV "爆発する" ;
lin comedy_N = variants{} ; -- 
lin classify_V2 = variants{} ; -- 
lin artistic_A = mkA "芸術的な" ;
lin ruler_N = mkN "定規" | mkN "物差し" | mkN "ルーラー" ;
lin biscuit_N = mkN "ビスケット" ;
lin workstation_N = mkN "ワークステーション" ;
lin prey_N = variants{} ; -- 
lin manual_N = mkN "手引き" | mkN "説明書" | mkN "マニュアル" ;
lin cure_N = variants{} ; -- 
lin cure_2_N = variants{} ; -- 
lin cure_1_N = variants{} ; -- 
lin overall_N = variants{} ; -- 
lin tighten_V2 = variants{} ; -- 
lin tighten_V = variants{} ; -- 
lin tax_V2 = variants{} ; -- 
lin pope_N = mkN "法王" | mkN "教皇" | mkN "ローマ教皇" ;
lin manufacturing_A = variants{} ; -- 
lin adult_A = variants{} ; -- 
lin rush_N = variants{} ; -- 
lin blanket_N = mkN "毛布" ;
lin republican_N = variants{} ; -- 
lin referendum_N = mkN "住民投票" | mkN "国民投票" ;
lin palm_N = mkN "肉球" ;
lin nearby_Adv = ParadigmsJpn.mkAdv "近くに" ;
lin mix_N = variants{} ; -- 
lin devil_N = mkN "悪魔" | mkN "鬼" | mkN "悪鬼" ;
lin adoption_N = mkN "養子縁組" ;
lin workforce_N = mkN "労働力" | mkN "労働人口" ;
lin segment_N = mkN "切片" ;
lin regardless_Adv = variants{} ; -- 
lin contractor_N = variants{} ; -- 
lin portion_N = mkN "部分" ;
lin differently_Adv = variants{} ; -- 
lin deposit_V2 = mkV2 "預金する" | mkV2 "預け入れる" | mkV2 "預ける" ;
lin cook_N = mkN "調理師" | mkN "料理人" | mkN "コック" | mkN "シェフ" ;
lin prediction_N = mkN "予言" | mkN "予測" ;
lin oven_N = mkN "オーブン" ;
lin matrix_N = mkN "行列" ;
lin liver_N = L.liver_N | mkN "レバー" ;
lin fraud_N = mkN "詐欺" ;
lin beam_N = mkN "梁" ;
lin signature_N = mkN "署名" | mkN "サイン" ;
lin limb_N = mkN "肢" ;
lin verdict_N = variants{} ; -- 
lin dramatically_Adv = variants{} ; -- 
lin container_N = mkN "コンテナ" ;
lin aunt_N = mkN "おば" | mkN "叔母" | mkN "伯母" ;
lin dock_N = mkN "酸葉" | mkN "羊蹄" ;
lin submission_N = variants{} ; -- 
lin arm_V2 = mkV2 "武装する" ;
lin arm_V = mkV "武装する" ;
lin odd_N = variants{} ; -- 
lin certainty_N = mkN "確信 {f}" ;
lin boring_A = mkA "つまらない" | mkA "退屈な" | mkA "うんざりさせた" ;
lin electron_N = mkN "エレクトロン" | mkN "マグネシウム合金" ;
lin drum_N = mkN "太鼓" | mkN "ドラム" ;
lin wisdom_N = mkN "英知" | mkN "知識" ;
lin antibody_N = mkN "抗体" ;
lin unlike_A = variants{} ; -- 
lin terrorist_N = mkN "テロリスト" | mkN "テロ" ;
lin post_V2 = mkV2 "書き込む" ;
lin post_V = mkV "書き込む" ;
lin circulation_N = mkN "血液循環" ;
lin alteration_N = variants{} ; -- 
lin fluid_N = mkN "流体" | mkN "液体" ;
lin ambitious_A = mkA "野心的" ;
lin socially_Adv = variants{} ; -- 
lin riot_N = mkN "暴動" | mkN "騒乱" | mkN "動乱" | mkN "狼藉" ;
lin petition_N = mkN "請願" ;
lin fox_N = mkN "狐" | mkN "キツネ" | mkN "フォックス" ;
lin recruitment_N = variants{} ; -- 
lin well_known_A = variants{} ; -- 
lin top_V2 = variants{} ; -- 
lin service_V2 = variants{} ; -- 
lin flood_V2 = mkV2 "氾濫する" ;
lin flood_V = mkV "氾濫する" ;
lin taste_V2 = mkV2 "味がする" ;
lin taste_V = mkV "味がする" ;
lin memorial_N = variants{} ; -- 
lin helicopter_N = mkN "ヘリコプター" ;
lin correspondence_N = mkN "対応" ;
lin beef_N = mkN "牛肉" | mkN "ビーフ" ;
lin overall_Adv = variants{} ; -- 
lin lighting_N = variants{} ; -- 
lin harbour_N = L.harbour_N | mkN "港" | mkN "ハーバー" ;
lin empirical_A = variants{} ; -- 
lin shallow_A = mkA "浅い" ;
lin seal_V2 = variants{} ; -- 
lin seal_V = variants{} ; -- 
lin decrease_V2 = mkV2 "減少する" ;
lin decrease_V = mkV "減少する" ;
lin constituent_N = variants{} ; -- 
lin exam_N = variants{} ; -- 
lin toe_N = mkN "足指" | mkN "つま先" | mkN "蹄" ;
lin reward_V2 = mkV2 "報いる" ;
lin thrust_V2 = mkV2 "押す" | mkV2 "突く" | mkV2 "刺す" ;
lin thrust_V = mkV "押す" | mkV "突く" | mkV "刺す" ;
lin bureaucracy_N = mkN "官僚制" ;
lin wrist_N = mkN "手首" ;
lin nut_N = mkN "木の実" ;
lin plain_N = mkN "平地" | mkN "平野" ;
lin magnetic_A = mkA "磁気の" ;
lin evil_N = mkN "邪悪" | mkN "悪" ;
lin widen_V2 = mkV2 "広がる" | mkV2 "広まる" ;
lin hazard_N = mkN "ハザード" | mkN "危険" | mkN "リスク" ;
lin dispose_V2 = variants{} ; -- 
lin dispose_V = variants{} ; -- 
lin dealing_N = variants{} ; -- 
lin absent_A = mkA "欠席する" "不在の" ;
lin reassure_V2S = variants{} ; -- 
lin reassure_V2 = variants{} ; -- 
lin model_V2 = variants{} ; -- 
lin model_V = variants{} ; -- 
lin inn_N = mkN "宿屋" | mkN "旅館" ;
lin initial_N = mkN "イニシャル" ;
lin suspension_N = mkN "吊り橋" ;
lin respondent_N = variants{} ; -- 
lin over_N = variants{} ; -- 
lin naval_A = variants{} ; -- 
lin monthly_A = variants{} ; -- 
lin log_N = mkN "薪" ;
lin advisory_A = variants{} ; -- 
lin fitness_N = mkN "適当" ;
lin blank_A = mkA "空の" | mkA "からの" ;
lin indirect_A = variants{} ; -- 
lin tile_N = mkN "タイル" | mkN "瓦" ;
lin rally_N = mkN "大会" ;
lin economist_N = mkN "経済学者" | mkN "エコノミスト" ;
lin vein_N = mkN "静脈" ;
lin strand_N = variants{} ; -- 
lin disturbance_N = variants{} ; -- 
lin stuff_V2 = mkV2 "壊れる" ;
lin seldom_Adv = ParadigmsJpn.mkAdv "稀に" | ParadigmsJpn.mkAdv "滅多に…ない" ;
lin coming_A = variants{} ; -- 
lin cab_N = variants{} ; -- 
lin grandfather_N = mkN "お爺さん" | mkN "祖父" | mkN "外祖父" | mkN "only about one's own)" ;
lin flash_V = variants{} ; -- 
lin destination_N = mkN "目的地" ;
lin actively_Adv = variants{} ; -- 
lin regiment_N = mkN "連隊" ;
lin closed_A = mkA "準備中" | mkA "閉められた" ;
lin boom_N = mkN "ブーム" ;
lin handful_N = variants{} ; -- 
lin remarkably_Adv = variants{} ; -- 
lin encouragement_N = mkN "奨励" ;
lin awkward_A = mkA "不器用な" ;
lin required_A = variants{} ; -- 
lin flood_N = mkN "洪水" ;
lin defect_N = mkN "欠陥" | mkN "欠点" ;
lin surplus_N = mkN "余り" ;
lin champagne_N = mkN "シャンパン色" ;
lin liquid_N = mkN "液体" | mkN "流体" ;
lin shed_V2 = mkV2 "涙を流す" ;
lin welcome_N = mkN "歓迎" ;
lin rejection_N = variants{} ; -- 
lin discipline_V2 = variants{} ; -- 
lin halt_V2 = mkV2 "押し止める" | mkV2 "さまたげる" ;
lin halt_V = mkV "押し止める" | mkV "さまたげる" ;
lin electronics_N = mkN "電子デバイス" ;
lin administratorMasc_N = variants{} ; -- 
lin sentence_V2 = mkV2 "判決を下す" ;
lin sentence_V = mkV "判決を下す" ;
lin ill_Adv = variants{} ; -- 
lin contradiction_N = mkN "矛盾" ;
lin nail_N = mkN "爪切り" | mkN "爪切" ;
lin senior_N = mkN "先輩" | mkN "年上" ;
lin lacking_A = variants{} ; -- 
lin colonial_A = variants{} ; -- 
lin primitive_A = mkA "原始的" ;
lin whoever_NP = variants{} ; -- 
lin lap_N = variants{} ; -- 
lin commodity_N = mkN "商品" ;
lin planned_A = variants{} ; -- 
lin intellectual_N = mkN "知識人" ;
lin imprisonment_N = mkN "徒刑" | mkN "懲役" | mkN "投獄" ;
lin coincide_V = mkV "一致する" | mkV "相当する" ;
lin sympathetic_A = variants{} ; -- 
lin atom_N = mkN "元素" ;
lin tempt_V2V = variants{} ; -- 
lin tempt_V2 = variants{} ; -- 
lin sanction_N = mkN "承認" | mkN "認可" | mkN "許可" ;
lin praise_V2 = mkV2 "褒める" ;
lin favourable_A = variants{} ; -- 
lin dissolve_V2 = mkV2 "溶ける" ;
lin dissolve_V = mkV "溶ける" ;
lin tightly_Adv = variants{} ; -- 
lin surrounding_N = variants{} ; -- 
lin soup_N = mkN "スープ" | mkN "汁" ;
lin encounter_N = mkN "出会い" ;
lin abortion_N = mkN "妊娠中絶" | mkN "人工流産" | mkN "中絶" ;
lin grasp_V2 = mkV2 "掴む" ;
lin grasp_V = mkV "掴む" ;
lin custody_N = mkN "養育権" ;
lin composer_N = mkN "作曲家" | mkN "作曲者" ;
lin charm_N = mkN "チャーム" ;
lin short_term_A = variants{} ; -- 
lin metropolitan_A = mkA "大都市の" | mkA "refering to large urban" | mkA "府主教" | mkA "Metropolitan bishop in Orthodox Church" | mkA "首都大司教" | mkA "Metropolitan bishop in Catholic Church" ;
lin waist_N = mkN "胴のくびれ" | mkN "腰部" | mkN "胴回り" ;
lin equality_N = mkN "平等" ;
lin tribute_N = variants{} ; -- 
lin bearing_N = mkN "軸受" ;
lin auction_N = mkN "競売" | mkN "オークション" ;
lin standing_N = mkN "スタンディングオベーション" ;
lin manufacture_N = variants{} ; -- 
lin horn_N = L.horn_N | mkN "ヤリチン" ;
lin barn_N = mkN "納屋" | mkN "家畜小屋" ;
lin mayor_N = mkN "市長" ;
lin emperor_N = mkN "皇帝" | mkN "帝王" | mkN "天皇" ;
lin rescue_N = mkN "救出" ;
lin integrated_A = variants{} ; -- 
lin conscience_N = mkN "良心" ;
lin commence_V2 = variants{} ; -- 
lin commence_V = variants{} ; -- 
lin grandmother_N = mkN "お婆さん" | mkN "お婆ちゃん" | mkN "spoken more by smaller children]" | mkN "ばば" | mkN "spoken more by smaller children]" | mkN "祖母" | mkN "polite ]" | mkN "外祖母" | mkN "only about one's own]" ;
lin discharge_V2 = mkV2 "発射する" ;
lin discharge_V = mkV "発射する" ;
lin profound_A = variants{} ; -- 
lin takeover_N = mkN "乗っ取り" | mkN "買収" ;
lin nationalist_N = mkN "民族主義者" ;
lin effect_V2 = mkV2 "達成する" ;
lin dolphin_N = mkN "海豚" | mkN "イルカ" ;
lin fortnight_N = variants{} ; -- 
lin elephant_N = mkN "象" | mkN "ゾウ" ;
lin seal_N = mkN "判" | mkN "印章" | mkN "璽" | mkN "封印" ;
lin spoil_V2 = mkV2 "腐る" ;
lin spoil_V = mkV "腐る" ;
lin plea_N = mkN "嘆願" ;
lin forwards_Adv = variants{} ; -- 
lin breeze_N = mkN "微風" ;
lin prevention_N = variants{} ; -- 
lin mineral_N = mkN "鉱物" ;
lin runner_N = variants{} ; -- 
lin pin_V2 = variants{} ; -- 
lin integrity_N = variants{} ; -- 
lin thereafter_Adv = variants{} ; -- 
lin quid_N = variants{} ; -- 
lin owl_N = mkN "フクロウ" | mkN "梟" ;
lin rigid_A = mkA "固定された" ;
lin orange_A = mkA "オレンジ色の" | mkA "橙色の" ;
lin draft_V2 = variants{} ; -- 
lin reportedly_Adv = variants{} ; -- 
lin hedge_N = mkN "垣根" ;
lin formulate_V2 = variants{} ; -- 
lin associated_A = variants{} ; -- 
lin position_V2 = variants{} ; -- 
lin thief_N = mkN "泥棒" | mkN "盗賊" | mkN "窃盗" ;
lin tomato_N = mkN "トマト" ;
lin exhaust_V2 = mkV2 "使い尽くす" | mkV2 "尽くす" | mkV2 "使い切る" ;
lin evidently_Adv = variants{} ; -- 
lin eagle_N = mkN "鷲" | mkN "ワシ" ;
lin specified_A = variants{} ; -- 
lin resulting_A = variants{} ; -- 
lin blade_N = mkN "刃" ;
lin peculiar_A = variants{} ; -- 
lin killing_N = mkN "殺すこと" ;
lin desktop_N = mkN "デスクトップコンピューター" ;
lin bowel_N = mkN "腸" ;
lin long_V = mkV "あこがれる" | mkV "憧れる" | mkV "恋い慕う" ;
lin ugly_A = L.ugly_A | mkA "醜い" | mkA "見苦しい" | mkA "格好悪い" ;
lin expedition_N = mkN "遠征" ;
lin saint_N = mkN "聖人" ;
lin variable_A = mkA "可変" | mkA "変えられる" ;
lin supplement_V2 = variants{} ; -- 
lin stamp_N = mkN "印鑑" | mkN "印章" | mkN "判子" ;
lin slide_N = mkN "スライディング" ;
lin faction_N = mkN "派閥" ;
lin enthusiastic_A = mkA "熱心" ;
lin enquire_V2 = variants{} ; -- 
lin enquire_V = variants{} ; -- 
lin brass_N = mkN "黄銅" | mkN "真鍮" ;
lin inequality_N = mkN "不等式" ;
lin eager_A = variants{} ; -- 
lin bold_A = mkA "勇敢な" | mkA "大胆な" ;
lin neglect_V2 = variants{} ; -- 
lin saying_N = mkN "格言" ;
lin ridge_N = mkN "大棟" ;
lin earl_N = mkN "伯爵" ;
lin yacht_N = mkN "船" | mkN "ボート" ;
lin suck_V2 = L.suck_V2 | mkV2 "サック" ;
lin suck_V = mkV "サック" ;
lin missing_A = variants{} ; -- 
lin extended_A = variants{} ; -- 
lin valuation_N = variants{} ; -- 
lin delight_V2 = variants{} ; -- 
lin delight_V = variants{} ; -- 
lin beat_N = variants{} ; -- 
lin worship_N = variants{} ; -- 
lin fossil_N = mkN "化石" ;
lin diminish_V2 = variants{} ; -- 
lin diminish_V = variants{} ; -- 
lin taxpayer_N = mkN "納税者" ;
lin corruption_N = mkN "腐敗" | mkN "堕落" | mkN "汚職" ;
lin accurately_Adv = variants{} ; -- 
lin honour_V2 = variants{} ; -- 
lin depict_V2 = variants{} ; -- 
lin pencil_N = mkN "鉛筆" ;
lin drown_V2 = mkV2 "水死する" | mkV2 "溺死する" | mkV2 "溺れる" ;
lin drown_V = mkV "水死する" | mkV "溺死する" | mkV "溺れる" ;
lin stem_N = mkN "" | mkN "glass] 茎" | mkN "幹" ;
lin lump_N = mkN "塊" | mkN "たんこぶ" ;
lin applicable_A = variants{} ; -- 
lin rate_V2 = variants{} ; -- 
lin rate_V = variants{} ; -- 
lin mobility_N = variants{} ; -- 
lin immense_A = mkA "広大" | mkA "莫大" ;
lin goodness_N = variants{} ; -- 
lin price_V2V = variants{} ; -- 
lin price_V2 = variants{} ; -- 
lin price_V = variants{} ; -- 
lin preliminary_A = mkA "予備的" ;
lin graph_N = mkN "グラフ" | mkN "図表" ;
lin referee_N = mkN "審判" | mkN "レフェリー" ;
lin calm_A = mkA "穏やか" | mkA "静か" ;
lin onwards_Adv = variants{} ; -- 
lin omit_V2 = mkV2 "省略する" | mkV2 "抜かす" ;
lin genuinely_Adv = variants{} ; -- 
lin excite_V2 = mkV2 "刺激する" | mkV2 "活性化させる" ;
lin dreadful_A = variants{} ; -- 
lin cave_N = mkN "洞窟" ;
lin revelation_N = mkN "啓示" ;
lin grief_N = mkN "悲しみ" | mkN "悲哀" ;
lin erect_V2 = variants{} ; -- 
lin tuck_V2 = variants{} ; -- 
lin tuck_V = variants{} ; -- 
lin meantime_N = variants{} ; -- 
lin barrel_N = mkN "銃身" ;
lin lawn_N = mkN "ローン" | mkN "寒冷紗" ;
lin hut_N = mkN "小屋" ;
lin swing_N = mkN "ブランコ" | mkN "鞦韆" ;
lin subject_V2 = variants{} ; -- 
lin ruin_V2 = mkV2 "滅ぼす" ;
lin slice_N = variants{} ; -- 
lin transmit_V2 = variants{} ; -- 
lin thigh_N = mkN "腿" | mkN "股" | mkN "太股" ;
lin practically_Adv = variants{} ; -- 
lin dedicate_V2 = mkV2 "捧げる" | mkV2 "奉納する" ;
lin mistake_V2 = mkV2 "勘違いする" | mkV2 "誤解する" ;
lin mistake_V = mkV "勘違いする" | mkV "誤解する" ;
lin corresponding_A = variants{} ; -- 
lin albeit_Subj = variants{} ; -- 
lin sound_A = mkA "健全な" | mkA "堅固な" ;
lin nurse_V2 = variants{} ; -- 
lin discharge_N = mkN "放電" ;
lin comparative_A = variants{} ; -- 
lin cluster_N = mkN "クラスター爆弾" ;
lin propose_VV = mkVV "プロポーズする" | mkVV "結婚を申し込む" | mkVV "求婚する" ;
lin propose_VS = mkVS "プロポーズする" | mkVS "結婚を申し込む" | mkVS "求婚する" ;
lin propose_V2 = mkV2 "プロポーズする" | mkV2 "結婚を申し込む" | mkV2 "求婚する" ;
lin propose_V = mkV "プロポーズする" | mkV "結婚を申し込む" | mkV "求婚する" ;
lin obstacle_N = mkN "障害" | mkN "邪魔" ;
lin motorway_N = variants{} ; -- 
lin heritage_N = variants{} ; -- 
lin counselling_N = variants{} ; -- 
lin breeding_N = variants{} ; -- 
lin characteristic_A = variants{} ; -- 
lin bucket_N = mkN "バケツ" | mkN "桶" | mkN "手桶" ;
lin migration_N = mkN "移行" ;
lin campaign_V = variants{} ; -- 
lin ritual_N = mkN "儀式" ;
lin originate_V2 = variants{} ; -- 
lin originate_V = variants{} ; -- 
lin hunting_N = mkN "狩り小屋" | mkN "狩猟小屋" ;
lin crude_A = variants{} ; -- 
lin protocol_N = variants{} ; -- 
lin prejudice_N = mkN "偏見" | mkN "僻見" | mkN "先入観" ;
lin inspiration_N = mkN "霊感" | mkN "鼓舞" ;
lin dioxide_N = mkN "二酸化物" ;
lin chemical_A = mkA "化学～" | mkA "化学的" ;
lin uncomfortable_A = variants{} ; -- 
lin worthy_A = mkA "値する" | mkA "価値ある" ;
lin inspect_V2 = variants{} ; -- 
lin summon_V2 = mkV2 "召喚する" | mkV2 "出頭を命ずる" ;
lin parallel_N = mkN "緯線" ;
lin outlet_N = mkN "捌け口" ;
lin okay_A = variants{} ; -- 
lin collaboration_N = mkN "コラボレーション" | mkN "コラボ" | mkN "協調" | mkN "協力" | mkN "共働" | mkN "合作" ;
lin booking_N = mkN "予約" ;
lin salad_N = mkN "サラダ" ;
lin productive_A = mkA "生産的" ;
lin charming_A = variants{} ; -- 
lin polish_A = variants{} ; -- 
lin oak_N = mkN "オーク" | mkN "カシワ" ;
lin access_V2 = variants{} ; -- 
lin tourism_N = mkN "観光" | mkN "旅行" ;
lin independently_Adv = variants{} ; -- 
lin cruel_A = mkA "残酷" | mkA "酷い" | mkA "惨い" ;
lin diversity_N = mkN "多様性" | mkN "変化" ;
lin accused_A = variants{} ; -- 
lin supplement_N = variants{} ; -- 
lin fucking_Adv = variants{} ; -- 
lin forecast_N = mkN "予想" | mkN "予報" ;
lin amend_V2V = mkV2V "改正する" | mkV2V "改める" | mkV2V "修正する" ;
lin amend_V2 = mkV2 "改正する" | mkV2 "改める" | mkV2 "修正する" ;
lin amend_V = mkV "改正する" | mkV "改める" | mkV "修正する" ;
lin soap_N = mkN "石鹸" | mkN "シャボン" ;
lin ruling_N = mkN "カラス口" | mkN "烏口" ;
lin interference_N = variants{} ; -- 
lin executive_A = variants{} ; -- 
lin mining_N = variants{} ; -- 
lin minimal_A = variants{} ; -- 
lin clarify_V2 = variants{} ; -- 
lin clarify_V = variants{} ; -- 
lin strain_V2 = variants{} ; -- 
lin novel_A = mkA "新奇" ;
lin try_N = mkN "トライ" ;
lin coastal_A = variants{} ; -- 
lin rising_A = variants{} ; -- 
lin quota_N = mkN "割当" | mkN "割り当て" | mkN "クォータ" ;
lin minus_Prep = variants{} ; -- 
lin kilometre_N = mkN "キロメートル" ;
lin characterize_V2 = variants{} ; -- 
lin suspicious_A = mkA "怪しい" | mkA "不審" ;
lin pet_N = mkN "ペット" ;
lin beneficial_A = mkA "有益な" ;
lin fling_V2 = mkV2 "投げる" ;
lin fling_V = mkV "投げる" ;
lin deprive_V2 = mkV2 "奪う" | mkV2 "取り上げる" ;
lin covenant_N = mkN "誓約" ;
lin bias_N = variants{} ; -- 
lin trophy_N = variants{} ; -- 
lin verb_N = mkN "動詞" ;
lin honestly_Adv = variants{} ; -- 
lin extract_N = variants{} ; -- 
lin straw_N = mkN "藁" | mkN "ワラ" ;
lin stem_V2 = mkV2 "シュテムする" ;
lin stem_V = mkV "シュテムする" ;
lin eyebrow_N = mkN "まゆ" | mkN "眉" | mkN "まゆ毛" | mkN "眉毛" ;
lin noble_A = mkA "高貴" ;
lin mask_N = mkN "マスク" ;
lin lecturer_N = mkN "講師" ;
lin girlfriend_N = mkN "彼女" | mkN "意中の女" | mkN "ガールフレンド" ;
lin forehead_N = mkN "額" | mkN "おでこ" ;
lin timetable_N = mkN "時刻表" | mkN "時間表" | mkN "時間割" | mkN "予定表" ;
lin symbolic_A = variants{} ; -- 
lin farming_N = variants{} ; -- 
lin lid_N = mkN "蓋" ;
lin librarian_N = mkN "司書" | mkN "図書館員" ;
lin injection_N = mkN "注射" ;
lin sexuality_N = mkN "性欲" ;
lin irrelevant_A = variants{} ; -- 
lin bonus_N = mkN "賞与" | mkN "ボーナス" | mkN "褒奨金" ;
lin abuse_V2 = mkV2 "酷使する" | mkV2 "虐待する" ;
lin thumb_N = mkN "親指" ;
lin survey_V2 = mkV2 "見渡す" ;
lin ankle_N = mkN "足首" | mkN "踝" ;
lin psychologist_N = mkN "心理学者" ;
lin occurrence_N = mkN "出来事" ;
lin profitable_A = mkA "有益な" | mkA "利益になる" ;
lin deliberate_A = mkA "思慮深い" ;
lin bow_V2 = mkV2 "辞儀する" | mkV2 "お辞儀する" ;
lin bow_V = mkV "辞儀する" | mkV "お辞儀する" ;
lin tribe_N = mkN "部族" | mkN "民族" ;
lin rightly_Adv = variants{} ; -- 
lin representative_A = variants{} ; -- 
lin code_V2 = variants{} ; -- 
lin validity_N = variants{} ; -- 
lin marble_N = mkN "大理石" | mkN "マーブル" ;
lin bow_N = mkN "弓矢" ;
lin plunge_V2 = variants{} ; -- 
lin plunge_V = variants{} ; -- 
lin maturity_N = variants{} ; -- 
lin maturity_3_N = variants{} ; -- 
lin maturity_2_N = variants{} ; -- 
lin maturity_1_N = variants{} ; -- 
lin hidden_A = variants{} ; -- 
lin contrast_V2 = variants{} ; -- 
lin contrast_V = variants{} ; -- 
lin tobacco_N = mkN "タバコ" | mkN "煙草" ;
lin middle_class_A = variants{} ; -- 
lin grip_V2 = mkV2 "掴む" ;
lin clergy_N = mkN "聖職者" ;
lin trading_A = variants{} ; -- 
lin passive_A = mkA "受動態" ;
lin decoration_N = mkN "装飾" ;
lin racial_A = variants{} ; -- 
lin well_N = mkN "井戸" ;
lin embarrassment_N = variants{} ; -- 
lin sauce_N = mkN "ソース" ;
lin fatal_A = variants{} ; -- 
lin banker_N = mkN "銀行家" ;
lin compensate_V2 = mkV2 "補填する" ;
lin compensate_V = mkV "補填する" ;
lin make_up_N = variants{} ; -- 
lin popularity_N = mkN "人気" ;
lin interior_A = mkA "内部" ;
lin eligible_A = variants{} ; -- 
lin continuity_N = variants{} ; -- 
lin bunch_N = variants{} ; -- 
lin hook_N = mkN "フックシュート" ;
lin wicket_N = variants{} ; -- 
lin pronounce_V2 = mkV2 "発音する" ;
lin pronounce_V = mkV "発音する" ;
lin ballet_N = mkN "バレエ" ;
lin heir_N = mkN "継承者" ;
lin positively_Adv = variants{} ; -- 
lin insufficient_A = mkA "不十分" ;
lin substitute_V2 = mkV2 "替える" | mkV2 "代える" | mkV2 "替わる" | mkV2 "替わる" | mkV2 "代用する" ;
lin substitute_V = mkV "替える" | mkV "代える" | mkV "替わる" | mkV "替わる" | mkV "代用する" ;
lin mysterious_A = mkA "神秘的な" | mkA "ミステリアスな" | mkA "不思議な" ;
lin dancer_N = mkN "ダンサー" | mkN "踊り子" | mkN "舞踊家" ;
lin trail_N = variants{} ; -- 
lin caution_N = variants{} ; -- 
lin donation_N = mkN "寄付" ;
lin added_A = variants{} ; -- 
lin weaken_V2 = mkV2 "弱くなる" | mkV2 "衰える" | mkV2 "弱気になる" ;
lin weaken_V = mkV "弱くなる" | mkV "衰える" | mkV "弱気になる" ;
lin tyre_N = mkN "タイヤ" ;
lin sufferer_N = variants{} ; -- 
lin managerial_A = variants{} ; -- 
lin elaborate_A = variants{} ; -- 
lin restraint_N = variants{} ; -- 
lin renew_V2 = variants{} ; -- 
lin gardenerMasc_N = variants{} ; -- 
lin dilemma_N = mkN "ジレンマ" ;
lin configuration_N = mkN "構成" | mkN "配置" | mkN "設定" | mkN "コンフィギュレーション" ;
lin rear_A = mkA "後ろの" | mkA "後方の" ;
lin embark_V2 = variants{} ; -- 
lin embark_V = variants{} ; -- 
lin misery_N = mkN "悲惨" | mkN "苦痛" | mkN "惨めさ" ;
lin importantly_Adv = variants{} ; -- 
lin continually_Adv = variants{} ; -- 
lin appreciation_N = mkN "感謝" ;
lin radical_N = mkN "部首" ;
lin diverse_A = mkA "さまざまな" ;
lin revive_V2 = variants{} ; -- 
lin revive_V = variants{} ; -- 
lin trip_V = mkV "躓く" | mkV "転ぶ" ;
lin lounge_N = variants{} ; -- 
lin dwelling_N = mkN "居留" | mkN "住居" | mkN "住宅" ;
lin parental_A = variants{} ; -- 
lin loyal_A = mkA "忠実な" | mkA "忠誠な" ;
lin privatisation_N = variants{} ; -- 
lin outsider_N = mkN "アウトサイダー" | mkN "部外者" | mkN "外人" | mkN "局外者" ;
lin forbid_V2 = mkV2 "禁じる" | mkV2 "禁ずる" ;
lin yep_Interj = variants{} ; -- 
lin prospective_A = variants{} ; -- 
lin manuscript_N = mkN "原稿" | mkN "草稿" | mkN "稿本" | mkN "稿" | mkN "記録" ;
lin inherent_A = variants{} ; -- 
lin deem_V2V = mkV2V "見なす" ;
lin deem_V2A = mkV2A "見なす" ;
lin deem_V2 = mkV2 "見なす" ;
lin telecommunication_N = variants{} ; -- 
lin intermediate_A = variants{} ; -- 
lin worthwhile_A = variants{} ; -- 
lin calendar_N = mkN "暦" | mkN "カレンダー" ;
lin basin_N = mkN "盆地" | mkN "流域" ;
lin utterly_Adv = variants{} ; -- 
lin rebuild_V2 = mkV2 "建て直す" | mkV2 "再建する" ;
lin pulse_N = mkN "脈搏" | mkN "脈" ;
lin suppress_V2 = mkV2 "抑える" ;
lin predator_N = mkN "天敵" ;
lin width_N = mkN "幅" | mkN "巾" ;
lin stiff_A = mkA "堅い" ;
lin spine_N = mkN "背骨" | mkN "脊椎" | mkN "脊柱" ;
lin betray_V2 = mkV2 "裏切る" ;
lin punish_V2 = mkV2 "罰する" | mkV2 "懲罰する" ;
lin stall_N = mkN "馬小屋" | mkN "厩舎" ;
lin lifestyle_N = mkN "ライフスタイル" | mkN "生活様式" | mkN "生き方" ;
lin compile_V2 = variants{} ; -- 
lin arouse_V2V = variants{} ; -- 
lin arouse_V2 = variants{} ; -- 
lin partially_Adv = variants{} ; -- 
lin headline_N = mkN "見出し" | mkN "標題" ;
lin divine_A = variants{} ; -- 
lin unpleasant_A = variants{} ; -- 
lin sacred_A = mkA "神聖" | mkA "聖なる" ;
lin useless_A = mkA "無用な" ;
lin cool_V2 = mkV2 "冷める" | mkV2 "冷える" ;
lin cool_V = mkV "冷める" | mkV "冷える" ;
lin tremble_V = mkV "震える" ;
lin statue_N = mkN "像" ;
lin obey_V2 = variants{} ; -- 
lin obey_V = variants{} ; -- 
lin drunk_A = mkA "酔っ払い" | mkA "酔い" | mkA "酔っぱらった" ;
lin tender_A = mkA "優しい" ;
lin molecular_A = variants{} ; -- 
lin circulate_V2 = variants{} ; -- 
lin circulate_V = variants{} ; -- 
lin exploitation_N = variants{} ; -- 
lin explicitly_Adv = variants{} ; -- 
lin utterance_N = variants{} ; -- 
lin linear_A = mkA "リニア" | mkA "リンネル" | mkA "線形" | mkA "一次" ;
lin chat_V = variants{} ; -- 
lin revision_N = mkN "復習" ;
lin distress_N = variants{} ; -- 
lin spill_V2 = mkV2 "零れる" | mkV2 "零す" ;
lin spill_V = mkV "零れる" | mkV "零す" ;
lin steward_N = mkN "スチュワード" ;
lin knight_N = mkN "ナイト" | mkN "桂馬" ;
lin sum_V2 = variants{} ; -- 
lin sum_V = variants{} ; -- 
lin semantic_A = mkA "セマンティック" ;
lin selective_A = variants{} ; -- 
lin learner_N = variants{} ; -- 
lin dignity_N = mkN "尊厳" ;
lin senate_N = mkN "上院" | mkN "元老院" ;
lin grid_N = mkN "格子" | mkN "グリッド" ;
lin fiscal_A = variants{} ; -- 
lin activate_V2 = mkV2 "活性化する" ;
lin rival_A = variants{} ; -- 
lin fortunate_A = variants{} ; -- 
lin jeans_N = mkN "ジーンズ" | mkN "ジーパン" ;
lin select_A = variants{} ; -- 
lin fitting_N = mkN "フィッティング" ;
lin commentator_N = variants{} ; -- 
lin weep_V2 = mkV2 "泣く" | mkV2 "すすり泣く" | mkV2 "しくしく泣く" ;
lin weep_V = mkV "泣く" | mkV "すすり泣く" | mkV "しくしく泣く" ;
lin handicap_N = variants{} ; -- 
lin crush_V2 = variants{} ; -- 
lin crush_V = variants{} ; -- 
lin towel_N = mkN "タオル" ;
lin stay_N = variants{} ; -- 
lin skilled_A = variants{} ; -- 
lin repeatedly_Adv = variants{} ; -- 
lin defensive_A = variants{} ; -- 
lin calm_V2 = mkV2 "落ち着く" ;
lin calm_V = mkV "落ち着く" ;
lin temporarily_Adv = variants{} ; -- 
lin rain_V2 = mkV2 "雨が降る" ;
lin rain_V = mkV "雨が降る" ;
lin pin_N = mkN "バッジ" ;
lin villa_N = mkN "別荘" | mkN "ビラ" | mkN "ヴィラ" | mkN "ヴィッラ" ;
lin rod_N = mkN "杆体細胞" | mkN "桿体細胞" ;
lin frontier_N = mkN "境界" | mkN "国境" ;
lin enforcement_N = variants{} ; -- 
lin protective_A = variants{} ; -- 
lin philosophical_A = variants{} ; -- 
lin lordship_N = variants{} ; -- 
lin disagree_VS = mkVS "反対する" | mkVS "異なる" | mkVS "揉める" ;
lin disagree_V2 = mkV2 "反対する" | mkV2 "異なる" | mkV2 "揉める" ;
lin disagree_V = mkV "反対する" | mkV "異なる" | mkV "揉める" ;
lin boyfriend_N = mkN "カレ" | mkN "彼" | mkN "a fiance and he.]" | mkN "彼氏" | mkN "カレシ" | mkN "ボーイフレンド" ;
lin activistMasc_N = variants{} ; -- 
lin viewer_N = variants{} ; -- 
lin slim_A = mkA "ほっそりした" ;
lin textile_N = mkN "織物" | mkN "テクスタイル" ;
lin mist_N = mkN "霞み" | mkN "霧" ;
lin harmony_N = mkN "調和" ;
lin deed_N = mkN "行為" ;
lin merge_V2 = mkV2 "合併する" | mkV2 "くっつける" ;
lin merge_V = mkV "合併する" | mkV "くっつける" ;
lin invention_N = mkN "インベンション" ;
lin commissioner_N = variants{} ; -- 
lin caravan_N = mkN "隊商" | mkN "キャラバン" ;
lin bolt_N = mkN "ボルトカッタ" ;
lin ending_N = mkN "語尾" ;
lin publishing_N = mkN "出版社" ;
lin gut_N = mkN "直感" | mkN "予感" ;
lin stamp_V2 = variants{} ; -- 
lin stamp_V = variants{} ; -- 
lin map_V2 = variants{} ; -- 
lin loud_Adv = variants{} ; -- 
lin stroke_V2 = mkV2 "なでる" | mkV2 "撫でる" ;
lin shock_V2 = variants{} ; -- 
lin rug_N = mkN "ラグ" ;
lin picture_V2 = variants{} ; -- 
lin slip_N = mkN "舌禍" | mkN "言い損ない" | mkN "失言" | mkN "言い違い" ;
lin praise_N = mkN "賞賛" ;
lin fine_N = mkN "罰金" | mkN "反則金" ;
lin monument_N = mkN "記念碑" | mkN "モニュメント" ;
lin material_A = variants{} ; -- 
lin garment_N = variants{} ; -- 
lin toward_Prep = variants{} ; -- 
lin realm_N = mkN "王国" ;
lin melt_V2 = mkV2 "溶ける" ;
lin melt_V = mkV "溶ける" ;
lin reproduction_N = mkN "複製" ;
lin reactor_N = mkN "原子炉" ;
lin furious_A = variants{} ; -- 
lin distinguished_A = variants{} ; -- 
lin characterize_V2 = variants{} ; -- 
lin alike_Adv = variants{} ; -- 
lin pump_N = mkN "ポンプ" ;
lin probe_N = mkN "調査" ;
lin feedback_N = mkN "フィードバック" | mkN "反応" ;
lin aspiration_N = mkN "吸引" ;
lin suspect_N = variants{} ; -- 
lin solar_A = variants{} ; -- 
lin fare_N = mkN "ただ乗り" ;
lin carve_V2 = variants{} ; -- 
lin carve_V = variants{} ; -- 
lin qualified_A = mkA "適格な" | mkA "資格のある" ;
lin membrane_N = mkN "膜" ;
lin dependence_N = variants{} ; -- 
lin convict_V2 = variants{} ; -- 
lin bacteria_N = mkN "細菌" ;
lin trading_N = mkN "取引パートナー" ;
lin ambassador_N = mkN "大使" ;
lin wound_V2 = mkV2 "傷つける" ;
lin drug_V2 = variants{} ; -- 
lin conjunction_N = mkN "結合" | mkN "接合" | mkN "接続" | mkN "連接" ;
lin cabin_N = mkN "キャビン" ;
lin trail_V2 = variants{} ; -- 
lin trail_V = variants{} ; -- 
lin shaft_N = variants{} ; -- 
lin treasure_N = mkN "宝" | mkN "宝物" ;
lin inappropriate_A = variants{} ; -- 
lin half_Adv = ParadigmsJpn.mkAdv "３０分おきに" ;
lin attribute_N = mkN "性質" ;
lin liquid_A = variants{} ; -- 
lin embassy_N = mkN "大使館" ;
lin terribly_Adv = variants{} ; -- 
lin exemption_N = variants{} ; -- 
lin array_N = mkN "配列" ;
lin tablet_N = mkN "タブレット" | mkN "タブレットコンピュータ" ;
lin sack_V2 = variants{} ; -- 
lin erosion_N = variants{} ; -- 
lin bull_N = mkN "雄牛" | mkN "牡牛" ;
lin warehouse_N = mkN "倉庫" ;
lin unfortunate_A = variants{} ; -- 
lin promoter_N = variants{} ; -- 
lin compel_VV = variants{} ; -- 
lin compel_V2V = variants{} ; -- 
lin compel_V2 = variants{} ; -- 
lin motivate_V2V = mkV2V "動機を与える" ;
lin motivate_V2 = mkV2 "動機を与える" ;
lin burning_A = variants{} ; -- 
lin vitamin_N = mkN "ビタミンA" ;
lin sail_N = mkN "帆" ;
lin lemon_N = mkN "西洋山薄荷" | mkN "レモンバーム" ;
lin foreigner_N = mkN "外国人" | mkN "外人" ;
lin powder_N = mkN "粉" ;
lin persistent_A = mkA "長引く" | mkA "じぞくせいの" | mkA "持続性の" | mkA "いつまでも続く" ;
lin bat_N = mkN "バット" ;
lin ancestor_N = mkN "祖先" ;
lin predominantly_Adv = variants{} ; -- 
lin mathematical_A = variants{} ; -- 
lin compliance_N = mkN "法令遵守" ;
lin arch_N = mkN "アーチ" ;
lin woodland_N = variants{} ; -- 
lin serum_N = mkN "血清" ;
lin overnight_Adv = variants{} ; -- 
lin doubtful_A = variants{} ; -- 
lin doing_N = mkN "すること" | mkN "行為" ;
lin coach_V2 = variants{} ; -- 
lin coach_V = variants{} ; -- 
lin binding_A = variants{} ; -- 
lin surrounding_A = variants{} ; -- 
lin peer_N = mkN "貴族" | mkN "華族" ;
lin ozone_N = mkN "オゾン" ;
lin mid_A = variants{} ; -- 
lin invisible_A = mkA "見えない" | mkA "不可視" ;
lin depart_V = mkV "出発する" | mkV "立ち去る" | mkV "発車する" ;
lin brigade_N = mkN "旅団" ;
lin manipulate_V2 = variants{} ; -- 
lin consume_V2 = variants{} ; -- 
lin consume_V = variants{} ; -- 
lin temptation_N = mkN "誘惑" ;
lin intact_A = variants{} ; -- 
lin glove_N = L.glove_N | mkN "手袋" ;
lin aggression_N = mkN "侵略" ;
lin emergence_N = mkN "創発科学" ;
lin stag_V = variants{} ; -- 
lin coffin_N = mkN "棺" ;
lin beautifully_Adv = variants{} ; -- 
lin clutch_V2 = mkV2 "掴む" ;
lin clutch_V = mkV "掴む" ;
lin wit_N = variants{} ; -- 
lin underline_V2 = variants{} ; -- 
lin trainee_N = mkN "研修生" ;
lin scrutiny_N = variants{} ; -- 
lin neatly_Adv = variants{} ; -- 
lin follower_N = variants{} ; -- 
lin sterling_A = variants{} ; -- 
lin tariff_N = variants{} ; -- 
lin bee_N = mkN "蜂" | mkN "蜜蜂" ;
lin relaxation_N = variants{} ; -- 
lin negligence_N = mkN "過失" | mkN "疎か" ;
lin sunlight_N = mkN "光" ;
lin penetrate_V2 = mkV2 "貫通する" | mkV2 "突き通る" ;
lin penetrate_V = mkV "貫通する" | mkV "突き通る" ;
lin knot_N = mkN "結び目" ;
lin temper_N = variants{} ; -- 
lin skull_N = mkN "頭蓋骨" | mkN "頭骨" ;
lin openly_Adv = variants{} ; -- 
lin grind_V2 = mkV2 "挽く" ;
lin grind_V = mkV "挽く" ;
lin whale_N = mkN "鯨" | mkN "クジラ" | mkN "勇魚" ;
lin throne_N = mkN "便器" | mkN "便座" | mkN "トイレ" ;
lin supervise_V2 = variants{} ; -- 
lin supervise_V = variants{} ; -- 
lin sickness_N = mkN "吐き気" ;
lin package_V2 = mkV2 "包む" ;
lin intake_N = variants{} ; -- 
lin within_Adv = variants{} ; -- 
lin inland_A = variants{} ; -- 
lin beast_N = mkN "wild beast: 野獣" | mkN "savage beast: 猛獣" | mkN "獣" ;
lin rear_N = mkN "後ろ" | mkN "後方" ;
lin morality_N = mkN "道徳" ;
lin competent_A = variants{} ; -- 
lin sink_N = mkN "シンク" | mkN "流し" ;
lin uniform_A = mkA "普遍な" | mkA "統一された" ;
lin reminder_N = mkN "備忘" | mkN "念押し" | mkN "リマインダー" ;
lin permanently_Adv = variants{} ; -- 
lin optimistic_A = mkA "楽観的" ;
lin bargain_N = mkN "買い得" | mkN "買い取り" ;
lin seemingly_Adv = variants{} ; -- 
lin respective_A = variants{} ; -- 
lin horizontal_A = mkA "水平な" | mkA "横の" ;
lin decisive_A = variants{} ; -- 
lin bless_V2 = mkV2 "恵む" ;
lin bile_N = mkN "胆汁" ;
lin spatial_A = mkA "空間的" ;
lin bullet_N = mkN "弾丸" | mkN "弾" ;
lin respectable_A = mkA "まともな" ;
lin overseas_Adv = ParadigmsJpn.mkAdv "海外に" ;
lin convincing_A = variants{} ; -- 
lin unacceptable_A = mkA "容認できない" ;
lin confrontation_N = mkN "対決" ;
lin swiftly_Adv = variants{} ; -- 
lin paid_A = variants{} ; -- 
lin joke_V = mkV "冗談を言う" | mkV "冷やかす" | mkV "巫山戯る" ;
lin instant_A = mkA "即席の" | mkA "その場で決めた" | mkA "瞬時の" ;
lin illusion_N = mkN "幻覚" | mkN "幻想" ;
lin cheer_V2 = mkV2 "喝采する" | mkV2 "声援する" | mkV2 "励ます" ;
lin cheer_V = mkV "喝采する" | mkV "声援する" | mkV "励ます" ;
lin congregation_N = mkN "集団" ;
lin worldwide_Adv = ParadigmsJpn.mkAdv "世界的に" ;
lin winning_A = variants{} ; -- 
lin wake_N = mkN "航跡" ;
lin toss_V2 = mkV2 "混ぜ合わせる" ;
lin toss_V = mkV "混ぜ合わせる" ;
lin medium_A = mkA "中型" ;
lin jewellery_N = mkN "装身具" | mkN "宝飾品" | mkN "ジュエリー" ;
lin fond_A = mkA "気に入る" | mkA "好く" ;
lin alarm_V2 = variants{} ; -- 
lin guerrilla_N = variants{} ; -- 
lin dive_V = mkV "飛び込む" ;
lin desire_V2 = mkV2 "望む" | mkV2 "願う" | mkV2 "欲する" ;
lin cooperation_N = mkN "協力" ;
lin thread_N = mkN "糸" ;
lin prescribe_V2 = mkV2 "処方する" ;
lin prescribe_V = mkV "処方する" ;
lin calcium_N = mkN "カルシウム" ;
lin redundant_A = variants{} ; -- 
lin marker_N = mkN "フェルトペン" | mkN "マーキングペン" | mkN "マーカーペン" | mkN "マーカー" ;
lin chemistMasc_N = variants{} ; -- 
lin mammal_N = mkN "哺乳類" ;
lin legacy_N = mkN "遺産" ;
lin debtor_N = mkN "債務者" | mkN "借方" ;
lin testament_N = variants{} ; -- 
lin tragic_A = mkA "悲惨" ;
lin silver_A = mkA "銀白色の" ;
lin grin_N = variants{} ; -- 
lin spectacle_N = mkN "壮観" | mkN "光景" ;
lin inheritance_N = variants{} ; -- 
lin heal_V2 = mkV2 "治る" ;
lin heal_V = mkV "治る" ;
lin sovereignty_N = mkN "主権" ;
lin enzyme_N = mkN "酵素" ;
lin host_V2 = variants{} ; -- 
lin neighbouring_A = variants{} ; -- 
lin corn_N = mkN "穀物" ;
lin layout_N = mkN "レイアウト" ;
lin dictate_VS = variants{} ; -- 
lin dictate_V2 = variants{} ; -- 
lin dictate_V = variants{} ; -- 
lin rip_V2 = mkV2 "法外な額を請求する" ;
lin rip_V = mkV "法外な額を請求する" ;
lin regain_V2 = variants{} ; -- 
lin probable_A = variants{} ; -- 
lin inclusion_N = variants{} ; -- 
lin booklet_N = mkN "小冊子" | mkN "小冊" | mkN "パンフレット" | mkN "ブックレット" ;
lin bar_V2 = variants{} ; -- 
lin privately_Adv = variants{} ; -- 
lin laser_N = mkN "レーザー" ;
lin fame_N = mkN "有名" | mkN "名声" ;
lin bronze_N = mkN "青銅" ;
lin mobile_A = mkA "可動" ;
lin metaphor_N = mkN "比喩" | mkN "隠喩" | mkN "象徴" ;
lin complication_N = variants{} ; -- 
lin narrow_V2 = variants{} ; -- 
lin narrow_V = variants{} ; -- 
lin old_fashioned_A = variants{} ; -- 
lin chop_V2 = variants{} ; -- 
lin chop_V = variants{} ; -- 
lin synthesis_N = mkN "合成" ;
lin diameter_N = mkN "直径" ;
lin bomb_V2 = mkV2 "爆撃" ;
lin bomb_V = mkV "爆撃" ;
lin silently_Adv = variants{} ; -- 
lin shed_N = mkN "小屋" ;
lin fusion_N = mkN "溶融" ;
lin trigger_V2 = variants{} ; -- 
lin printing_N = mkN "印刷会社" | mkN "印刷所" ;
lin onion_N = mkN "玉葱" | mkN "タマネギ" ;
lin dislike_V2 = mkV2 "嫌う" | mkV2 "否む" | mkV2 "嫌い" ;
lin embody_V2 = variants{} ; -- 
lin curl_V = variants{} ; -- 
lin sunshine_N = mkN "日光" | mkN "太陽の光" ;
lin sponsorship_N = variants{} ; -- 
lin rage_N = mkN "激怒" ;
lin loop_N = mkN "輪" | mkN "ループ" ;
lin halt_N = variants{} ; -- 
lin cop_V2 = variants{} ; -- 
lin bang_V2 = mkV2 "やる" | mkV2 "食う" | mkV2 "犯す" ;
lin bang_V = mkV "やる" | mkV "食う" | mkV "犯す" ;
lin toxic_A = variants{} ; -- 
lin thinking_A = variants{} ; -- 
lin orientation_N = mkN "案内指導" ;
lin likelihood_N = variants{} ; -- 
lin wee_A = variants{} ; -- 
lin up_to_date_A = variants{} ; -- 
lin polite_A = mkA "丁寧" | mkA "礼儀正しい" ;
lin apology_N = mkN "詫び わび" | mkN "wabiしゃざい" | mkN "shazai" ;
lin exile_N = mkN "亡命" | mkN "追放" ;
lin brow_N = variants{} ; -- 
lin miserable_A = mkA "惨めな" | mkA "悲惨な" ;
lin outbreak_N = variants{} ; -- 
lin comparatively_Adv = variants{} ; -- 
lin pump_V2 = variants{} ; -- 
lin pump_V = variants{} ; -- 
lin fuck_V2 = mkV2 "エッチする" | mkV2 "犯す" | mkV2 "ファックする" | mkV2 "やる" ;
lin fuck_V = mkV "エッチする" | mkV "犯す" | mkV "ファックする" | mkV "やる" ;
lin forecast_VS = mkVS "予想する" ;
lin forecast_V2 = mkV2 "予想する" ;
lin forecast_V = mkV "予想する" ;
lin timing_N = variants{} ; -- 
lin headmaster_N = variants{} ; -- 
lin terrify_V2 = variants{} ; -- 
lin sigh_N = mkN "嘆息" | mkN "ため息" ;
lin premier_A = variants{} ; -- 
lin joint_N = mkN "関節" ;
lin incredible_A = mkA "驚異的な" ;
lin gravity_N = mkN "引力" ;
lin regulatory_A = variants{} ; -- 
lin cylinder_N = variants{} ; -- 
lin curiosity_N = mkN "好奇心" ;
lin resident_A = variants{} ; -- 
lin narrative_N = mkN "物語" ;
lin cognitive_A = variants{} ; -- 
lin lengthy_A = variants{} ; -- 
lin gothic_A = variants{} ; -- 
lin dip_V2 = variants{} ; -- 
lin dip_V = variants{} ; -- 
lin adverse_A = variants{} ; -- 
lin accountability_N = variants{} ; -- 
lin hydrogen_N = mkN "水素" ;
lin gravel_N = mkN "砂利" ;
lin willingness_N = variants{} ; -- 
lin inhibit_V2 = mkV2 "抑制する" | mkV2 "阻止する" | mkV2 "制止する" | mkV2 "抑止する" ;
lin attain_V2 = mkV2 "到る" | mkV2 "達成する" ;
lin attain_V = mkV "到る" | mkV "達成する" ;
lin specialize_V2 = variants{} ; -- 
lin specialize_V = variants{} ; -- 
lin steer_V2 = mkV2 "操縦する" | mkV2 "舵を取る" | mkV2 "操舵する" | mkV2 "運転する" ;
lin steer_V = mkV "" | mkV "vehicle" | mkV "操縦する" | mkV "舵を取る" | mkV "操舵する" | mkV "運転する" ;
lin selected_A = variants{} ; -- 
lin like_N = mkN "好み" ;
lin confer_V = variants{} ; -- 
lin usage_N = mkN "使い方" | mkN "習慣" ;
lin portray_V2 = variants{} ; -- 
lin planner_N = variants{} ; -- 
lin manual_A = mkA "手動" ;
lin boast_VS = mkVS "自慢する" | mkVS "力む" ;
lin boast_V2 = mkV2 "自慢する" | mkV2 "力む" ;
lin boast_V = mkV "自慢する" | mkV "力む" ;
lin unconscious_A = mkA "無意識" ;
lin jail_N = variants{} ; -- 
lin fertility_N = variants{} ; -- 
lin documentation_N = mkN "文書" | mkN "ドキュメンテーション" ;
lin wolf_N = mkN "狼" | mkN "オオカミ" | mkN "ウルフ" ;
lin patent_N = mkN "特許" ;
lin exit_N = mkN "出口" ;
lin corps_N = mkN "軍団" ;
lin proclaim_VS = variants{} ; -- 
lin proclaim_V2 = variants{} ; -- 
lin multiply_V2 = mkV2 "掛ける" ;
lin multiply_V = mkV "掛ける" ;
lin brochure_N = mkN "小冊子" | mkN "小冊" | mkN "パンフレット" ;
lin screen_V2 = mkV2 "発表する" ;
lin screen_V = mkV "発表する" ;
lin orthodox_A = variants{} ; -- 
lin locomotive_N = mkN "機関車" ;
lin considering_Prep = variants{} ; -- 
lin unaware_A = variants{} ; -- 
lin syndrome_N = mkN "症候群" | mkN "シンドローム" ;
lin reform_V2 = variants{} ; -- 
lin reform_V = variants{} ; -- 
lin confirmation_N = variants{} ; -- 
lin printed_A = variants{} ; -- 
lin curve_V2 = mkV2 "曲がる" ;
lin curve_V = mkV "曲がる" ;
lin costly_A = variants{} ; -- 
lin underground_A = mkA "地下" ;
lin territorial_A = variants{} ; -- 
lin designate_VS = mkVS "称する" ;
lin designate_V2V = mkV2V "称する" ;
lin designate_V2 = mkV2 "称する" ;
lin designate_V = mkV "称する" ;
lin comfort_V2 = mkV2 "慰める" ;
lin plot_V2 = variants{} ; -- 
lin plot_V = variants{} ; -- 
lin misleading_A = mkA "紛らわしい" ;
lin weave_V2 = mkV2 "編む" | mkV2 "織る" ;
lin weave_V = mkV "編む" | mkV "織る" ;
lin scratch_V2 = L.scratch_V2 | mkV2 "引っ掻く" ;
lin scratch_V = mkV "引っ掻く" ;
lin echo_N = mkN "反響" | mkN "こだま" | mkN "エコー" | mkN "やまびこ" ;
lin ideally_Adv = variants{} ; -- 
lin endure_V2 = mkV2 "耐える" ;
lin endure_V = mkV "耐える" ;
lin verbal_A = variants{} ; -- 
lin stride_V = variants{} ; -- 
lin nursing_N = mkN "老人ホーム" | mkN "養護ホーム" ;
lin exert_V2 = mkV2 "行使する" ;
lin compatible_A = variants{} ; -- 
lin causal_A = variants{} ; -- 
lin mosaic_N = mkN "モザイク" ;
lin manor_N = mkN "荘園" ;
lin implicit_A = mkA "潜在的な" ;
lin following_Prep = variants{} ; -- 
lin fashionable_A = mkA "はやりの" | mkA "洒落た" | mkA "流行の" ;
lin valve_N = mkN "バルブ" ;
lin proceed_N = variants{} ; -- 
lin sofa_N = mkN "ソファー" | mkN "長椅子" ;
lin snatch_V2 = mkV2 "奪う" ;
lin snatch_V = mkV "奪う" ;
lin jazz_N = mkN "ジャズ" ;
lin patron_N = variants{} ; -- 
lin provider_N = variants{} ; -- 
lin interim_A = variants{} ; -- 
lin intent_N = variants{} ; -- 
lin chosen_A = variants{} ; -- 
lin applied_A = mkA "応用" ;
lin shiver_V = mkV "震える" ;
lin pie_N = mkN "パイ" ;
lin fury_N = variants{} ; -- 
lin abolition_N = mkN "廃止" ;
lin soccer_N = mkN "サッカー" | mkN "蹴球" | mkN "フットボール" ;
lin corpse_N = mkN "死体" | mkN "屍体" ;
lin accusation_N = mkN "告発" ;
lin kind_A = mkA "親切" | mkA "優しい" ;
lin dead_Adv = variants{} ; -- 
lin nursing_A = variants{} ; -- 
lin contempt_N = mkN "軽蔑" ;
lin prevail_V = variants{} ; -- 
lin murderer_N = mkN "人殺し" | mkN "殺人者" ;
lin liberal_N = variants{} ; -- 
lin gathering_N = mkN "集まり" ;
lin adequately_Adv = variants{} ; -- 
lin subjective_A = variants{} ; -- 
lin disagreement_N = variants{} ; -- 
lin cleaner_N = mkN "掃除する人" ;
lin boil_V2 = mkV2 "沸く" ;
lin boil_V = mkV "沸く" ;
lin static_A = variants{} ; -- 
lin scent_N = mkN "香り" | mkN "匂い" | mkN "臭い" | mkN "" ;
lin civilian_N = mkN "文民" ;
lin monk_N = mkN "僧侶" | mkN "坊さん" | mkN "修道士" | mkN "僧" | mkN "法師" ;
lin abruptly_Adv = variants{} ; -- 
lin keyboard_N = mkN "鍵盤" ;
lin hammer_N = mkN "金槌" | mkN "槌" | mkN "ハンマー" ;
lin despair_N = mkN "絶望" ;
lin controller_N = variants{} ; -- 
lin yell_V2 = mkV2 "叫ぶ" ;
lin yell_V = mkV "叫ぶ" ;
lin entail_V2 = variants{} ; -- 
lin cheerful_A = mkA "楽しげな" | mkA "陽気な" ;
lin reconstruction_N = variants{} ; -- 
lin patience_N = mkN "辛抱" | mkN "忍耐" | mkN "我慢" ;
lin legally_Adv = variants{} ; -- 
lin habitat_N = mkN "生息地" ;
lin queue_N = mkN "列" | mkN "待ち行列" ;
lin spectatorMasc_N = variants{} ; -- 
lin given_A = variants{} ; -- 
lin purple_A = mkA "紫色" | mkA "紫の" | mkA "パープル" ;
lin outlook_N = variants{} ; -- 
lin genius_N = mkN "天才" ;
lin dual_A = variants{} ; -- 
lin canvas_N = mkN "画布" | mkN "カンバス" ;
lin grave_A = mkA "物々しい" ;
lin pepper_N = mkN "胡椒" ;
lin conform_V2 = variants{} ; -- 
lin conform_V = variants{} ; -- 
lin cautious_A = mkA "慎重な" ;
lin dot_N = mkN "ドット" | mkN "点" ;
lin conspiracy_N = mkN "密議" | mkN "陰謀" ;
lin butterfly_N = mkN "蝶々" | mkN "蝶" | mkN "蝴蝶" | mkN "バタフライ" | mkN "チョウ" ;
lin sponsor_N = variants{} ; -- 
lin sincerely_Adv = variants{} ; -- 
lin rating_N = variants{} ; -- 
lin weird_A = mkA "変" ;
lin teenage_A = variants{} ; -- 
lin salmon_N = mkN "サーモン" | mkN "鮭" ;
lin recorder_N = mkN "レコーダー" ;
lin postpone_V2 = mkV2 "延期する" ;
lin maid_N = mkN "女中" | mkN "メイド" ;
lin furnish_V2 = mkV2 "備え付ける" ;
lin ethical_A = variants{} ; -- 
lin bicycle_N = mkN "自転車" | mkN "チャリンコ" | mkN "チャリ" ;
lin sick_N = variants{} ; -- 
lin sack_N = mkN "袋" ;
lin renaissance_N = variants{} ; -- 
lin luxury_N = mkN "高級品" ;
lin gasp_V2 = mkV2 "喘ぐ" ;
lin gasp_V = mkV "喘ぐ" ;
lin wardrobe_N = mkN "洋服だんす" | mkN "ワードローブ" ;
lin native_N = mkN "母国語" | mkN "自国語" | mkN "母語" ;
lin fringe_N = mkN "前髪" ;
lin adaptation_N = mkN "適応" ;
lin quotation_N = mkN "引用" ;
lin hunger_N = mkN "飢え" | mkN "空腹" | mkN "飢餓" ;
lin enclose_V2 = variants{} ; -- 
lin disastrous_A = variants{} ; -- 
lin choir_N = mkN "聖歌隊" | mkN "合唱団" ;
lin overwhelming_A = variants{} ; -- 
lin glimpse_N = variants{} ; -- 
lin divorce_V2 = mkV2 "離婚する" ;
lin circular_A = mkA "丸い" ;
lin locality_N = variants{} ; -- 
lin ferry_N = mkN "フェリー" | mkN "渡し船" | mkN "渡船" ;
lin balcony_N = mkN "バルコニー" ;
lin sailor_N = mkN "船員" | mkN "水夫" | mkN "船乗り" | mkN "水兵" | mkN "セーラー" ;
lin precision_N = mkN "精度" | mkN "正確性" ;
lin desert_V2 = mkV2 "見捨てる" | mkV2 "去る" ;
lin desert_V = mkV "見捨てる" | mkV "去る" ;
lin dancing_N = variants{} ; -- 
lin alert_V2 = variants{} ; -- 
lin surrender_V2 = mkV2 "降服する" | mkV2 "投降する" | mkV2 "自首する" | mkV2 "譲渡する" | mkV2 "放棄する" ;
lin surrender_V = mkV "降服する" | mkV "投降する" | mkV "自首する" | mkV "譲渡する" | mkV "放棄する" ;
lin archive_N = mkN "書庫" | mkN "文書の保管所" | mkN "アーカイブ" ;
lin jump_N = mkN "縄跳び" ;
lin philosopher_N = mkN "哲学者" ;
lin revival_N = variants{} ; -- 
lin presume_VS = mkVS "推定する" ;
lin presume_V2 = mkV2 "推定する" ;
lin presume_V = mkV "推定する" ;
lin node_N = mkN "ノード" ;
lin fantastic_A = mkA "素晴らしい" | mkA "素敵" | mkA "ファンタスティック" ;
lin herb_N = mkN "薬草" ;
lin assertion_N = mkN "主張" ;
lin thorough_A = variants{} ; -- 
lin quit_V2 = mkV2 "止める" ;
lin quit_V = mkV "止める" ;
lin grim_A = variants{} ; -- 
lin fair_N = mkN "フェアー" ;
lin broadcast_V2 = mkV2 "放送する" ;
lin broadcast_V = mkV "放送する" ;
lin annoy_V2 = mkV2 "煩わす" | mkV2 "騒がす" | mkV2 "苦しめる" | mkV2 "いらいらさせる" ;
lin divert_V = variants{} ; -- 
lin accelerate_V2 = mkV2 "加速する" ;
lin accelerate_V = mkV "加速する" ;
lin polymer_N = mkN "重合体" | mkN "高分子" ;
lin sweat_N = mkN "汗" ;
lin survivor_N = variants{} ; -- 
lin subscription_N = mkN "予約購読" | mkN "購読" ;
lin repayment_N = variants{} ; -- 
lin anonymous_A = mkA "無名" | mkA "匿名の" ;
lin summarize_V2 = mkV2 "要約する" ;
lin punch_N = mkN "パンチ" ;
lin lodge_V2 = variants{} ; -- 
lin lodge_V = variants{} ; -- 
lin landowner_N = mkN "地主" ;
lin ignorance_N = mkN "無知" ;
lin discourage_V2 = mkV2 "落胆させる" | mkV2 "がっかりさせる" ;
lin bride_N = mkN "花嫁" | mkN "新婦" | mkN "嫁" ;
lin likewise_Adv = variants{} ; -- 
lin depressed_A = variants{} ; -- 
lin abbey_N = mkN "修道院" ;
lin quarry_N = variants{} ; -- 
lin archbishop_N = mkN "大主教" | mkN "in Orthodox Church and Anglicanism" | mkN "大司教" | mkN "in Catholic Church" ;
lin sock_N = L.sock_N | mkN "靴下" | mkN "ソックス" ;
lin large_scale_A = variants{} ; -- 
lin glare_V2 = variants{} ; -- 
lin glare_V = variants{} ; -- 
lin descent_N = variants{} ; -- 
lin stumble_V = variants{} ; -- 
lin mistress_N = mkN "愛人" | mkN "情婦" ;
lin empty_V2 = mkV2 "空にする" ;
lin empty_V = mkV "空にする" ;
lin prosperity_N = mkN "繁栄" ;
lin harm_V2 = variants{} ; -- 
lin formulation_N = variants{} ; -- 
lin atomic_A = mkA "原子" ;
lin agreed_A = variants{} ; -- 
lin wicked_A = mkA "邪悪" | mkA "意地悪い" | mkA "腕白" ;
lin threshold_N = mkN "敷居" ;
lin lobby_N = mkN "ロビー" | mkN "休息所" ;
lin repay_V2 = mkV2 "払い戻す" ;
lin repay_V = mkV "払い戻す" ;
lin varying_A = variants{} ; -- 
lin track_V2 = mkV2 "追" ;
lin track_V = mkV "追" ;
lin crawl_V = mkV "這う" ;
lin tolerate_V2 = mkV2 "黙認する" ;
lin salvation_N = mkN "救済" | mkN "救い" ;
lin pudding_N = mkN "プリン" | mkN "プディング" ;
lin counter_VS = variants{} ; -- 
lin counter_V = variants{} ; -- 
lin propaganda_N = mkN "宣伝" ;
lin cage_N = mkN "檻" | mkN "篭" | mkN "ケージ" ;
lin broker_N = variants{} ; -- 
lin ashamed_A = mkA "恥ずかしい" ;
lin scan_V2 = mkV2 "スキャンする" ;
lin scan_V = mkV "スキャンする" ;
lin document_V2 = variants{} ; -- 
lin apparatus_N = mkN "装置" | mkN "機器" ;
lin theology_N = mkN "神学" ;
lin analogy_N = mkN "類推" | mkN "アナロジー" | mkN "類似" | mkN "類比" ;
lin efficiently_Adv = variants{} ; -- 
lin bitterly_Adv = variants{} ; -- 
lin performer_N = variants{} ; -- 
lin individually_Adv = variants{} ; -- 
lin amid_Prep = variants{} ; -- 
lin squadron_N = mkN "戦隊" ;
lin sentiment_N = mkN "感情" ;
lin making_N = variants{} ; -- 
lin exotic_A = mkA "エキゾチック" ;
lin dominance_N = variants{} ; -- 
lin coherent_A = variants{} ; -- 
lin placement_N = variants{} ; -- 
lin flick_V2 = mkV2 "弾く" ;
lin colourful_A = variants{} ; -- 
lin mercy_N = mkN "情け" ;
lin angrily_Adv = variants{} ; -- 
lin amuse_V2 = variants{} ; -- 
lin mainstream_N = mkN "主流" ;
lin appraisal_N = mkN "評価" ;
lin annually_Adv = variants{} ; -- 
lin torch_N = mkN "懐中電燈" ;
lin intimate_A = mkA "親密な" ;
lin gold_A = variants{} ; -- 
lin arbitrary_A = mkA "恣意的な" ;
lin venture_VS = variants{} ; -- 
lin venture_V2 = variants{} ; -- 
lin venture_V = variants{} ; -- 
lin preservation_N = mkN "保存" ;
lin shy_A = mkA "慎重" ;
lin disclosure_N = variants{} ; -- 
lin lace_N = mkN "レース" | mkN "靴紐" ;
lin inability_N = variants{} ; -- 
lin motif_N = mkN "モチーフ" ;
lin listenerMasc_N = variants{} ; -- 
lin hunt_N = mkN "狩り" | mkN "狩猟" ;
lin delicious_A = mkA "美味しい" | mkA "おいしい" | mkA "旨い" ;
lin term_VS = variants{} ; -- 
lin term_V2 = variants{} ; -- 
lin substitute_N = variants{} ; -- 
lin highway_N = mkN "公道" | mkN "街道" | mkN "公路" ;
lin haul_V2 = variants{} ; -- 
lin haul_V = variants{} ; -- 
lin dragon_N = mkN "竜 りゅう" | mkN "ryū" | mkN "りょう" | mkN "りょう" | mkN "たつ" | mkN "tatsu" | mkN "ドラゴン" ;
lin chair_V2 = variants{} ; -- 
lin accumulate_V2 = mkV2 "蓄積する" | mkV2 "溜まる" ;
lin accumulate_V = mkV "蓄積する" | mkV "溜まる" ;
lin unchanged_A = variants{} ; -- 
lin sediment_N = mkN "堆積物" ;
lin sample_V2 = mkV2 "試す" ;
lin exclaim_V2 = mkV2 "叫ぶ" ;
lin fan_V2 = variants{} ; -- 
lin fan_V = variants{} ; -- 
lin volunteer_V2 = mkV2 "志願する" ;
lin volunteer_V = mkV "志願する" ;
lin root_V2 = variants{} ; -- 
lin root_V = variants{} ; -- 
lin parcel_N = mkN "地割" ;
lin psychiatric_A = variants{} ; -- 
lin delightful_A = mkA "楽しい" | mkA "愉快な" ;
lin confidential_A = mkA "親展" ;
lin calorie_N = mkN "カロリー" ;
lin flash_N = mkN "フラッシュ" ;
lin crowd_V2 = variants{} ; -- 
lin crowd_V = variants{} ; -- 
lin aggregate_A = variants{} ; -- 
lin scholarship_N = mkN "奨学金" ;
lin monitor_N = mkN "モニター" ;
lin disciplinary_A = variants{} ; -- 
lin rock_V2 = variants{} ; -- 
lin rock_V = variants{} ; -- 
lin hatred_N = mkN "憎悪" ;
lin pill_N = mkN "丸薬" ;
lin noisy_A = mkA "うるさい" | mkA "騒がしい" ;
lin feather_N = L.feather_N | mkN "羽" ;
lin lexical_A = mkA "語彙的な" ;
lin staircase_N = mkN "階段" ;
lin autonomous_A = mkA "自立した" ;
lin viewpoint_N = variants{} ; -- 
lin projection_N = variants{} ; -- 
lin offensive_A = mkA "攻撃的な" | mkA "侮辱的な" ;
lin controlled_A = variants{} ; -- 
lin flush_V2 = variants{} ; -- 
lin flush_V = variants{} ; -- 
lin racism_N = mkN "人種差別" | mkN "レイシズム" ;
lin flourish_V = mkV "栄える" ;
lin resentment_N = mkN "憤慨" | mkN "憤り" | mkN "憤懣" ;
lin pillow_N = mkN "枕" ;
lin courtesy_N = mkN "愛想" | mkN "礼儀" ;
lin photography_N = mkN "写真撮影" | mkN "写真術" | mkN "撮影" ;
lin monkey_N = mkN "猿" | mkN "サル" ;
lin glorious_A = mkA "見事な" | mkA "栄光ある" ;
lin evolutionary_A = variants{} ; -- 
lin gradual_A = variants{} ; -- 
lin bankruptcy_N = mkN "破産" | mkN "破綻" | mkN "倒産" ;
lin sacrifice_N = mkN "犠牲" | mkN "生贄" ;
lin uphold_V2 = mkV2 "支持する" | mkV2 "支える" | mkV2 "保つ" ;
lin sketch_N = mkN "スケッチ" ;
lin presidency_N = mkN "大統領職" | mkN "社長職" ;
lin formidable_A = variants{} ; -- 
lin differentiate_V2 = variants{} ; -- 
lin differentiate_V = variants{} ; -- 
lin continuing_A = variants{} ; -- 
lin cart_N = mkN "荷車" | mkN "カート" ;
lin stadium_N = mkN "スタジアム" | mkN "競技場" ;
lin dense_A = mkA "濃い" | mkA "密" ;
lin catch_N = mkN "捕る" ;
lin beyond_Adv = variants{} ; -- 
lin immigration_N = mkN "移民" | mkN "イミグレーション" | mkN "入植" | mkN "移住" ;
lin clarity_N = mkN "明快さ" ;
lin worm_N = L.worm_N | mkN "虫" | mkN "虫螻" ;
lin slot_N = mkN "スロットマシン" ;
lin rifle_N = mkN "小銃" | mkN "ライフル" | mkN "ライフル銃" ;
lin screw_V2 = variants{} ; -- 
lin screw_V = variants{} ; -- 
lin harvest_N = mkN "ツツガムシ *" ;
lin foster_V2 = variants{} ; -- 
lin academic_N = mkN "プラトン学派の人" ;
lin impulse_N = mkN "衝動" | mkN "衝撃" | mkN "推進力" | mkN "インパルス" | mkN "出来心" ;
lin guardian_N = mkN "守護天使" ;
lin ambiguity_N = variants{} ; -- 
lin triangle_N = mkN "三角不等式" ;
lin terminate_V2 = variants{} ; -- 
lin terminate_V = variants{} ; -- 
lin retreat_V = mkV "退却する" | mkV "後退する" ;
lin pony_N = mkN "子馬" | mkN "仔馬" | mkN "小馬" | mkN "ポニー" ;
lin outdoor_A = mkA "戸外の" | mkA "アウトドアの" | mkA "室外の" | mkA "屋外の" ;
lin deficiency_N = variants{} ; -- 
lin decree_N = variants{} ; -- 
lin apologize_V = mkV "謝る" | mkV "詫びる" ;
lin yarn_N = mkN "糸" ;
lin staff_V2 = variants{} ; -- 
lin renewal_N = variants{} ; -- 
lin rebellion_N = mkN "反乱" | mkN "むほん" | mkN "蜂起" ;
lin incidentally_Adv = variants{} ; -- 
lin flour_N = mkN "小麦粉" ;
lin developed_A = mkA "開発" | mkA "先進" ;
lin chorus_N = mkN "コーラス" | mkN "合唱" ;
lin ballot_N = mkN "投票用紙" ;
lin appetite_N = mkN "食欲" ;
lin stain_V2 = variants{} ; -- 
lin stain_V = variants{} ; -- 
lin notebook_N = mkN "帳面" | mkN "ノート" | mkN "手帳" | mkN "手帖" ;
lin loudly_Adv = variants{} ; -- 
lin homeless_A = mkA "家のない" | mkA "ホームレス" ;
lin census_N = mkN "人口調査" | mkN "戸籍" ;
lin bizarre_A = mkA "奇妙" ;
lin striking_A = variants{} ; -- 
lin greenhouse_N = mkN "温室" | mkN "ハウス" ;
lin part_V2 = variants{} ; -- 
lin part_V = variants{} ; -- 
lin burial_N = mkN "埋葬" ;
lin embarrassed_A = mkA "恥ずかしい" ;
lin ash_N = mkN "灰" ;
lin actress_N = mkN "女優" ;
lin cassette_N = mkN "カセット" ;
lin privacy_N = mkN "グライバシー" ;
lin fridge_N = L.fridge_N ;
lin feed_N = variants{} ; -- 
lin excess_A = variants{} ; -- 
lin calf_N = mkN "脹脛" ;
lin associate_N = mkN "仲間" | mkN "同僚" ;
lin ruin_N = mkN "廃墟" | mkN "遺跡" ;
lin jointly_Adv = variants{} ; -- 
lin drill_V2 = variants{} ; -- 
lin drill_V = variants{} ; -- 
lin photograph_V2 = mkV2 "写真を撮る" ;
lin devoted_A = variants{} ; -- 
lin indirectly_Adv = variants{} ; -- 
lin driving_A = variants{} ; -- 
lin memorandum_N = mkN "メモ" | mkN "備忘録" | mkN "忘備録" ;
lin default_N = variants{} ; -- 
lin costume_N = mkN "衣裳" ;
lin variant_N = variants{} ; -- 
lin shatter_V2 = variants{} ; -- 
lin shatter_V = variants{} ; -- 
lin methodology_N = mkN "手順" | mkN "方法" | mkN "手法" ;
lin frame_V2 = mkV2 "陥れる" | mkV2 "着せる" ;
lin frame_V = mkV "陥れる" | mkV "着せる" ;
lin allegedly_Adv = variants{} ; -- 
lin swell_V2 = mkV2 "膨れる" | mkV2 "隆起する" | mkV2 "腫れる" ;
lin swell_V = L.swell_V | mkV "膨れる" | mkV "隆起する" | mkV "腫れる" ;
lin investigator_N = mkN "捜査員" ;
lin imaginative_A = variants{} ; -- 
lin bored_A = mkA "うんざり" ;
lin bin_N = variants{} ; -- 
lin awake_A = mkA "目が覚めて" ;
lin recycle_V2 = mkV2 "再生する" | mkV2 "リサイクルする" ;
lin group_V2 = variants{} ; -- 
lin group_V = variants{} ; -- 
lin enjoyment_N = variants{} ; -- 
lin contemporary_N = variants{} ; -- 
lin texture_N = mkN "テクスチャ" ;
lin donor_N = mkN "寄贈者" | mkN "ドナー" ;
lin bacon_N = mkN "ベーコン" ;
lin sunny_A = mkA "晴れた" ;
lin stool_N = variants{} ; -- 
lin prosecute_V2 = variants{} ; -- 
lin commentary_N = variants{} ; -- 
lin bass_N = mkN "低音部記号" | mkN "ヘ音記号" ;
lin sniff_V2 = mkV2 "嗅ぎ付ける" ;
lin sniff_V = mkV "嗅ぎ付ける" ;
lin repetition_N = mkN "繰り返し" ;
lin eventual_A = variants{} ; -- 
lin credit_V2 = variants{} ; -- 
lin suburb_N = mkN "地区" ;
lin newcomer_N = variants{} ; -- 
lin romance_N = mkN "恋愛" | mkN "ロマンス" | mkN "恋" ;
lin film_V2 = variants{} ; -- 
lin film_V = variants{} ; -- 
lin experiment_V2 = mkV2 "実験する" ;
lin experiment_V = mkV "実験する" ;
lin daylight_N = mkN "夏時間" | mkN "サマータイム" ;
lin warrant_N = mkN "准士官" | mkN "准尉" ;
lin fur_N = mkN "毛皮" ;
lin parking_N = mkN "駐車" ;
lin nuisance_N = mkN "迷惑" | mkN "迷惑な物" | mkN "迷惑な人" ;
lin civilian_A = mkA "市民の" ;
lin foolish_A = mkA "愚かな" | mkA "馬鹿げた" | mkA "馬鹿な" ;
lin bulb_N = mkN "球根" ;
lin balloon_N = mkN "風船" | mkN "バルーン" ;
lin vivid_A = mkA "鮮明" ;
lin surveyor_N = variants{} ; -- 
lin spontaneous_A = variants{} ; -- 
lin biology_N = mkN "生物学" ;
lin injunction_N = variants{} ; -- 
lin appalling_A = variants{} ; -- 
lin amusement_N = mkN "娯楽" | mkN "アミューズメント" | mkN "遊び" ;
lin aesthetic_A = mkA "美的な" ;
lin vegetation_N = mkN "草木" | mkN "植生" ;
lin stab_V2 = L.stab_V2 ;
lin stab_V = variants{}; -- L.stab_V2 ;
lin rude_A = mkA "無礼な" | mkA "失礼 しつれい" | mkA "shitsurei" ;
lin offset_V2 = variants{} ; -- 
lin thinking_N = variants{} ; -- 
lin mainframe_N = variants{} ; -- 
lin flock_N = mkN "ひとむれ" | mkN "群れ" | mkN "一群" ;
lin amateur_A = variants{} ; -- 
lin academy_N = mkN "学園" | mkN "学院" ;
lin shilling_N = mkN "シリング" ;
lin reluctance_N = variants{} ; -- 
lin velocity_N = mkN "速さ" | mkN "速度" ;
lin spare_V2 = variants{} ; -- 
lin spare_V = variants{} ; -- 
lin wartime_N = mkN "戦時" ;
lin soak_V2 = mkV2 "濡れる" ;
lin soak_V = mkV "濡れる" ;
lin rib_N = mkN "胸郭" ;
lin mighty_A = mkA "強大な" ;
lin shocked_A = variants{} ; -- 
lin vocational_A = variants{} ; -- 
lin spit_V2 = mkV2 "つばを吐く" ;
lin spit_V = L.spit_V | mkV "つばを吐く" ;
lin gall_N = mkN "胆汁" ;
lin bowl_V2 = variants{} ; -- 
lin bowl_V = variants{} ; -- 
lin prescription_N = mkN "処方" ;
lin fever_N = mkN "熱" | mkN "発熱" ;
lin axis_N = mkN "軸" ;
lin reservoir_N = variants{} ; -- 
lin magnitude_N = mkN "等級" ;
lin rape_V2 = mkV2 "強姦する" | mkV2 "暴行する" | mkV2 "犯す" | mkV2 "手込めにする" | mkV2 "手篭にする" | mkV2 "レイプする" ;
lin cutting_N = variants{} ; -- 
lin bracket_N = mkN "括弧" ;
lin agony_N = variants{} ; -- 
lin strive_VV = mkVV "努力する" | mkVV "闘う" | mkVV "努める" | mkVV "奮闘する" ;
lin strive_V = mkV "努力する" | mkV "闘う" | mkV "努める" | mkV "奮闘する" ;
lin strangely_Adv = variants{} ; -- 
lin pledge_VS = mkVS "公約する" | mkVS "保証する" ;
lin pledge_V2V = mkV2V "公約する" | mkV2V "保証する" ;
lin pledge_V2 = mkV2 "公約する" | mkV2 "保証する" ;
lin recipient_N = mkN "受取人" ;
lin moor_N = mkN "荒野" | mkN "荒れ地" ;
lin invade_V2 = mkV2 "侵略する" | mkV2 "侵害する" | mkV2 "襲う" ;
lin dairy_N = mkN "コンビニ" ;
lin chord_N = mkN "和音" ;
lin shrink_V2 = mkV2 "尻込みする" ;
lin shrink_V = mkV "尻込みする" ;
lin poison_N = mkN "毒" ;
lin pillar_N = mkN "柱" ;
lin washing_N = mkN "洗濯" ;
lin warrior_N = mkN "戦士" | mkN "武士" ;
lin supervisor_N = mkN "主管" | mkN "スーパーバイザー" ;
lin outfit_N = variants{} ; -- 
lin innovative_A = mkA "革新的な" ;
lin dressing_N = mkN "ドレッシング" ;
lin dispute_V2 = mkV2 "反論する" ;
lin dispute_V = mkV "反論する" ;
lin jungle_N = mkN "密林" | mkN "ジャングル" ;
lin brewery_N = mkN "醸造所" ;
lin adjective_N = mkN "形容詞" | mkN "形容動詞" ;
lin straighten_V2 = variants{} ; -- 
lin straighten_V = variants{} ; -- 
lin restrain_V2 = variants{} ; -- 
lin monarchy_N = mkN "君主制" ;
lin trunk_N = mkN "鼻" ;
lin herd_N = mkN "群衆" ;
lin deadline_N = mkN "期限" | mkN "締め切り" | mkN "デッドライン" ;
lin tiger_N = mkN "虎" ;
lin supporting_A = variants{} ; -- 
lin moderate_A = variants{} ; -- 
lin kneel_V = mkV "跪く" ;
lin ego_N = mkN "自我" | mkN "エゴ" ;
lin sexually_Adv = variants{} ; -- 
lin ministerial_A = variants{} ; -- 
lin bitch_N = mkN "すべた" | mkN "じゃじゃ馬" | mkN "阿婆擦れ" | mkN "尼" ;
lin wheat_N = mkN "小麦" ;
lin stagger_V = mkV "よろめく" ;
lin snake_N = L.snake_N | mkN "蛇" | mkN "ヘビ" ;
lin ribbon_N = mkN "リボン" ;
lin mainland_N = mkN "本土" | mkN "内地" ;
lin fisherman_N = mkN "漁師" ;
lin economically_Adv = variants{} ; -- 
lin unwilling_A = variants{} ; -- 
lin nationalism_N = mkN "民族主義" | mkN "ナショナリズム" ;
lin knitting_N = mkN "編むこと" ;
lin irony_N = mkN "反語" | mkN "諷刺" | mkN "sarcasm]" | mkN "アイロニー" ;
lin handling_N = mkN "取り扱い" ;
lin desired_A = variants{} ; -- 
lin bomber_N = mkN "爆撃機" ;
lin voltage_N = mkN "電圧" ;
lin unusually_Adv = variants{} ; -- 
lin toast_N = mkN "祝杯" ;
lin feel_N = variants{} ; -- 
lin suffering_N = mkN "苦痛" | mkN "苦しみ" ;
lin polish_V2 = mkV2 "磨く" | mkV2 "研ぐ" ;
lin polish_V = mkV "磨く" | mkV "研ぐ" ;
lin technically_Adv = variants{} ; -- 
lin meaningful_A = mkA "有意義な" ;
lin aloud_Adv = ParadigmsJpn.mkAdv "声を出して" ;
lin waiter_N = mkN "ウエーター" | mkN "ウエイター" ;
lin tease_V2 = mkV2 "誘う" ;
lin opposite_Adv = ParadigmsJpn.mkAdv "あべこべ" ;
lin goat_N = mkN "ヤギ" | mkN "山羊" ;
lin conceptual_A = variants{} ; -- 
lin ant_N = mkN "蟻" | mkN "アリ" ;
lin inflict_V2 = variants{} ; -- 
lin bowler_N = mkN "山高帽" | mkN "山高帽子" ;
lin roar_V2 = mkV2 "吠える" | mkV2 "ガオー" ;
lin roar_V = mkV "吠える" | mkV "ガオー" ;
lin drain_N = variants{} ; -- 
lin wrong_N = variants{} ; -- 
lin galaxy_N = mkN "銀河" | mkN "銀河系" | mkN "星雲" ;
lin aluminium_N = mkN "アルミニウム" ;
lin receptor_N = variants{} ; -- 
lin preach_V2 = variants{} ; -- 
lin preach_V = variants{} ; -- 
lin parade_N = mkN "パレード" | mkN "行進" ;
lin opposite_N = mkN "あべこべ" ;
lin critique_N = variants{} ; -- 
lin query_N = mkN "クエリ" | mkN "問い合わせ" ;
lin outset_N = variants{} ; -- 
lin integral_A = variants{} ; -- 
lin grammatical_A = variants{} ; -- 
lin testing_N = variants{} ; -- 
lin patrol_N = mkN "パトロール" ;
lin pad_N = mkN "パッド" ;
lin unreasonable_A = variants{} ; -- 
lin sausage_N = mkN "ソーセージ" ;
lin criminal_N = mkN "犯罪者" | mkN "犯人" ;
lin constructive_A = variants{} ; -- 
lin worldwide_A = mkA "世界的な" ;
lin highlight_N = variants{} ; -- 
lin doll_N = mkN "人形" ;
lin frightened_A = variants{} ; -- 
lin biography_N = mkN "伝記" ;
lin vocabulary_N = mkN "語彙集" ;
lin offend_V2 = mkV2 "怒らせる" ;
lin offend_V = mkV "怒らせる" ;
lin accumulation_N = variants{} ; -- 
lin linen_N = mkN "リネン製品" ;
lin fairy_N = mkN "妖精" | mkN "仙女" ;
lin disco_N = mkN "ディスコ" ;
lin hint_VS = mkVS "ほのめかす" ;
lin hint_V2 = mkV2 "ほのめかす" ;
lin hint_V = mkV "ほのめかす" ;
lin versus_Prep = variants{} ; -- 
lin ray_N = mkN "光線" ;
lin pottery_N = mkN "陶器" ;
lin immune_A = variants{} ; -- 
lin retreat_N = variants{} ; -- 
lin master_V2 = mkV2 "マスターする" ;
lin injured_A = variants{} ; -- 
lin holly_N = mkN "セイヨウヒイラギ" | mkN "犬黄楊" | mkN "モチノキ" ;
lin battle_V2 = mkV2 "戦う" ;
lin battle_V = mkV "戦う" ;
lin solidarity_N = mkN "連帯" ;
lin embarrassing_A = variants{} ; -- 
lin cargo_N = mkN "積荷" ;
lin theorist_N = variants{} ; -- 
lin reluctantly_Adv = variants{} ; -- 
lin preferred_A = variants{} ; -- 
lin dash_V = variants{} ; -- 
lin total_V2 = variants{} ; -- 
lin total_V = variants{} ; -- 
lin reconcile_V2 = variants{} ; -- 
lin drill_N = mkN "訓練" ;
lin credibility_N = mkN "信用性" ;
lin copyright_N = mkN "著作権" ;
lin beard_N = mkN "顎鬚" | mkN "あごひげ" ;
lin bang_N = variants{} ; -- 
lin vigorous_A = variants{} ; -- 
lin vaguely_Adv = variants{} ; -- 
lin punch_V2 = mkV2 "パンチする" ;
lin prevalence_N = variants{} ; -- 
lin uneasy_A = variants{} ; -- 
lin boost_N = variants{} ; -- 
lin scrap_N = mkN "くず鉄" | mkN "屑鉄" | mkN "スクラップ" ;
lin ironically_Adv = variants{} ; -- 
lin fog_N = L.fog_N | mkN "霧" ;
lin faithful_A = mkA "忠実な" ;
lin bounce_V2 = variants{} ; -- 
lin bounce_V = variants{} ; -- 
lin batch_N = mkN "バッチ" ;
lin smooth_V2 = variants{} ; -- 
lin smooth_V = variants{} ; -- 
lin sleeping_A = variants{} ; -- 
lin poorly_Adv = variants{} ; -- 
lin accord_V = variants{} ; -- 
lin vice_president_N = variants{} ; -- 
lin duly_Adv = variants{} ; -- 
lin blast_N = mkN "疾風" | mkN "突風" ;
lin square_V2 = variants{} ; -- 
lin square_V = variants{} ; -- 
lin prohibit_V2 = mkV2 "禁じる" | mkV2 "禁止する" ;
lin prohibit_V = mkV "禁じる" | mkV "禁止する" ;
lin brake_N = mkN "ブレーキ" | mkN "制動機" ;
lin asylum_N = mkN "アジール" | mkN "避難所" | mkN "養護施設" ;
lin obscure_V2 = variants{} ; -- 
lin nun_N = mkN "修道女" | mkN "修道女" | mkN "尼僧" | mkN "童貞" | mkN "尼" ;
lin heap_N = mkN "ヒープ" ;
lin smoothly_Adv = variants{} ; -- 
lin rhetoric_N = variants{} ; -- 
lin privileged_A = mkA "特権を持つ" | mkA "特権的な" ;
lin liaison_N = variants{} ; -- 
lin jockey_N = mkN "騎手" ;
lin concrete_N = mkN "コンクリート" ;
lin allied_A = variants{} ; -- 
lin rob_V2 = mkV2 "奪う" | mkV2 "奪い取る" | mkV2 "略奪する" ;
lin indulge_V2 = mkV2 "甘やかす" ;
lin indulge_V = mkV "甘やかす" ;
lin except_Prep = S.except_Prep ;
lin distort_V2 = mkV2 "歪める" | mkV2 "曲げる" ;
lin whatsoever_Adv = variants{} ; -- 
lin viable_A = variants{} ; -- 
lin nucleus_N = mkN "核" ;
lin exaggerate_V2 = mkV2 "誇張する" ;
lin exaggerate_V = mkV "誇張する" ;
lin compact_N = mkN "コンパクト" ;
lin nationality_N = mkN "国籍" ;
lin direct_Adv = variants{} ; -- 
lin cast_N = mkN "演奏" ;
lin altar_N = mkN "祭壇" ;
lin refuge_N = mkN "避難所" ;
lin presently_Adv = variants{} ; -- 
lin mandatory_A = mkA "強制的な" ;
lin authorize_V2V = variants{} ; -- 
lin authorize_V2 = variants{} ; -- 
lin accomplish_V2 = mkV2 "完成させる" | mkV2 "成し遂げる" | mkV2 "完了させる" ;
lin startle_V2 = variants{} ; -- 
lin indigenous_A = variants{} ; -- 
lin worse_Adv = variants{} ; -- 
lin retailer_N = mkN "小売商人" ;
lin compound_V2 = variants{} ; -- 
lin compound_V = variants{} ; -- 
lin admiration_N = mkN "賞賛" | mkN "感心" ;
lin absurd_A = mkA "馬鹿らしい" ;
lin coincidence_N = variants{} ; -- 
lin principally_Adv = variants{} ; -- 
lin passport_N = mkN "パスポート" ;
lin depot_N = variants{} ; -- 
lin soften_V2 = variants{} ; -- 
lin soften_V = variants{} ; -- 
lin secretion_N = mkN "分泌" ;
lin invoke_V2 = variants{} ; -- 
lin dirt_N = mkN "泥" | mkN "土" | mkN "泥土" | mkN "ダート" ;
lin scared_A = mkA "おびえた" ;
lin mug_N = mkN "マグカップ" | mkN "ジョッキ" ;
lin convenience_N = mkN "便利なこと" ;
lin calm_N = mkN "静か" ;
lin optional_A = variants{} ; -- 
lin unsuccessful_A = mkA "不成功" ;
lin consistency_N = variants{} ; -- 
lin umbrella_N = mkN "傘" ;
lin solo_N = mkN "ソロ" | mkN "独奏" | mkN "独唱" ;
lin hemisphere_N = mkN "半球" ;
lin extreme_N = mkN "極端" ;
lin brandy_N = mkN "ブランデー" | mkN "コニャック" ;
lin belly_N = L.belly_N | mkN "胃" | mkN "お腹" | mkN "腹" ;
lin attachment_N = mkN "添付ファイル" ;
lin wash_N = variants{} ; -- 
lin uncover_V2 = variants{} ; -- 
lin treat_N = variants{} ; -- 
lin repeated_A = variants{} ; -- 
lin pine_N = mkN "松" | mkN "ゴヨウ" ;
lin offspring_N = mkN "胤" ;
lin communism_N = mkN "共産主義" ;
lin nominate_V2 = variants{} ; -- 
lin soar_V2 = mkV2 "舞う" | mkV2 "翔る" ;
lin soar_V = mkV "舞う" | mkV "翔る" ;
lin geological_A = variants{} ; -- 
lin frog_N = mkN "蛙" | mkN "かはづ" | mkN "カエル" ;
lin donate_V2 = variants{} ; -- 
lin donate_V = variants{} ; -- 
lin cooperative_A = variants{} ; -- 
lin nicely_Adv = variants{} ; -- 
lin innocence_N = variants{} ; -- 
lin housewife_N = mkN "主婦" ;
lin disguise_V2 = variants{} ; -- 
lin demolish_V2 = variants{} ; -- 
lin counsel_N = variants{} ; -- 
lin cord_N = mkN "縄" ;
lin semi_final_N = variants{} ; -- 
lin reasoning_N = mkN "推論" ;
lin litre_N = mkN "リットル" | mkN "㍑" ;
lin inclined_A = variants{} ; -- 
lin evoke_V2 = mkV2 "喚起する" ;
lin courtyard_N = mkN "中庭" ;
lin arena_N = mkN "アリーナ" | mkN "闘技場" | mkN "土俵" ;
lin simplicity_N = variants{} ; -- 
lin inhibition_N = variants{} ; -- 
lin frozen_A = variants{} ; -- 
lin vacuum_N = mkN "真空" ;
lin immigrant_N = mkN "移民" | mkN "移住者" ;
lin bet_N = variants{} ; -- 
lin revenge_N = mkN "復讐" | mkN "報復" | mkN "リベンジ" ;
lin jail_V2 = variants{} ; -- 
lin helmet_N = mkN "ヘルメット" | mkN "兜" ;
lin unclear_A = mkA "不明" ;
lin jerk_V2 = mkV2 "めく" | mkV2 "マスをかく" ;
lin jerk_V = mkV "めく" | mkV "マスをかく" ;
lin disruption_N = variants{} ; -- 
lin attainment_N = variants{} ; -- 
lin sip_V2 = variants{} ; -- 
lin sip_V = variants{} ; -- 
lin program_V2V = mkV2V "プログラムを供給する" | mkV2V "プログラムを作る" ;
lin program_V2 = mkV2 "プログラムを供給する" | mkV2 "プログラムを作る" ;
lin lunchtime_N = variants{} ; -- 
lin cult_N = mkN "カルト" ;
lin chat_N = mkN "チャット" ;
lin accord_N = mkN "合意" ;
lin supposedly_Adv = variants{} ; -- 
lin offering_N = variants{} ; -- 
lin broadcast_N = mkN "放送" ;
lin secular_A = mkA "世俗的な" | mkA "世俗の" | mkA "非宗教的な" ;
lin overwhelm_V2 = mkV2 "圧倒" ;
lin momentum_N = mkN "運動量" ;
lin infinite_A = variants{} ; -- 
lin manipulation_N = variants{} ; -- 
lin inquest_N = variants{} ; -- 
lin decrease_N = mkN "減少" ;
lin cellar_N = mkN "地下室" | mkN "穴蔵" | mkN "穴倉" | mkN "窖" ;
lin counsellor_N = variants{} ; -- 
lin avenue_N = mkN "大道り" ;
lin rubber_A = variants{} ; -- 
lin labourer_N = variants{} ; -- 
lin lab_N = variants{} ; -- 
lin damn_V2 = mkV2 "地獄に落とす" ;
lin comfortably_Adv = variants{} ; -- 
lin tense_A = mkA "緊張した" ;
lin socket_N = mkN "コンセント" ;
lin par_N = variants{} ; -- 
lin thrust_N = mkN "突き" ;
lin scenario_N = mkN "シナリオ" | mkN "脚本" | mkN "台本" ;
lin frankly_Adv = variants{} ; -- 
lin slap_V2 = variants{} ; -- 
lin recreation_N = mkN "娯楽" ;
lin rank_V2 = variants{} ; -- 
lin rank_V = variants{} ; -- 
lin spy_N = mkN "間諜" | mkN "スパイ" ;
lin filter_V2 = variants{} ; -- 
lin filter_V = variants{} ; -- 
lin clearance_N = variants{} ; -- 
lin blessing_N = mkN "祝福" ;
lin embryo_N = mkN "胚" ;
lin varied_A = variants{} ; -- 
lin predictable_A = variants{} ; -- 
lin mutation_N = mkN "変異" | mkN "突然変異" ;
lin equal_V2 = variants{} ; -- 
lin can_1_VV = S.can_VV ;
lin can_2_VV = S.can8know_VV ;
lin can_V2 = mkV2 "できる" | mkV2 "-れる" | mkV2 "-られる" ;
lin burst_N = variants{} ; -- 
lin retrieve_V2 = variants{} ; -- 
lin retrieve_V = variants{} ; -- 
lin elder_N = mkN "長老" ;
lin rehearsal_N = variants{} ; -- 
lin optical_A = variants{} ; -- 
lin hurry_N = variants{} ; -- 
lin conflict_V = mkV "衝突する" | mkV "対立する" ;
lin combat_V2 = variants{} ; -- 
lin combat_V = variants{} ; -- 
lin absorption_N = mkN "吸収" | mkN "吸い込み" ;
lin ion_N = mkN "イオン" ;
lin wrong_Adv = variants{} ; -- 
lin heroin_N = mkN "ヘロイン" ;
lin bake_V2 = mkV2 "焼ける" ;
lin bake_V = mkV "焼ける" ;
lin x_ray_N = variants{} ; -- 
lin vector_N = mkN "ベクトル" ;
lin stolen_A = variants{} ; -- 
lin sacrifice_V2 = mkV2 "捧げる" ;
lin sacrifice_V = mkV "捧げる" ;
lin robbery_N = mkN "強盗" ;
lin probe_V2 = mkV2 "調査する" ;
lin probe_V = mkV "調査する" ;
lin organizational_A = variants{} ; -- 
lin chalk_N = mkN "チョーク" ;
lin bourgeois_A = variants{} ; -- 
lin villager_N = mkN "村人" | mkN "村民" ;
lin morale_N = mkN "士気" ;
lin express_A = mkA "快速" ;
lin climb_N = variants{} ; -- 
lin notify_V2 = mkV2 "通告する" | mkV2 "通知する" ;
lin jam_N = mkN "ジャム" ;
lin bureaucratic_A = variants{} ; -- 
lin literacy_N = variants{} ; -- 
lin frustrate_V2 = variants{} ; -- 
lin freight_N = mkN "貨物" ;
lin clearing_N = variants{} ; -- 
lin aviation_N = mkN "航空" | mkN "飛行" ;
lin legislature_N = mkN "立法府" ;
lin curiously_Adv = variants{} ; -- 
lin banana_N = mkN "バナナ" ;
lin deploy_V2 = variants{} ; -- 
lin deploy_V = variants{} ; -- 
lin passionate_A = mkA "熱烈" ;
lin monastery_N = mkN "修道院" ;
lin kettle_N = variants{} ; -- 
lin enjoyable_A = variants{} ; -- 
lin diagnose_V2 = variants{} ; -- 
lin quantitative_A = variants{} ; -- 
lin distortion_N = variants{} ; -- 
lin monarch_N = mkN "君主" | mkN "王" ;
lin kindly_Adv = variants{} ; -- 
lin glow_V = variants{} ; -- 
lin acquaintance_N = mkN "知人" | mkN "知り合い" ;
lin unexpectedly_Adv = variants{} ; -- 
lin handy_A = variants{} ; -- 
lin deprivation_N = variants{} ; -- 
lin attacker_N = variants{} ; -- 
lin assault_V2 = mkV2 "攻める" ;
lin screening_N = variants{} ; -- 
lin retired_A = variants{} ; -- 
lin quick_Adv = variants{} ; -- 
lin portable_A = variants{} ; -- 
lin hostage_N = mkN "人質" ;
lin underneath_Prep = variants{} ; -- 
lin jealous_A = mkA "妬ましい" | mkA "嫉妬" | mkA "嫉妬深い" ;
lin proportional_A = variants{} ; -- 
lin gown_N = variants{} ; -- 
lin chimney_N = mkN "煙突" ;
lin bleak_A = variants{} ; -- 
lin seasonal_A = variants{} ; -- 
lin plasma_N = mkN "プラズマ加速" ;
lin stunning_A = variants{} ; -- 
lin spray_N = mkN "スプレー" ;
lin referral_N = variants{} ; -- 
lin promptly_Adv = variants{} ; -- 
lin fluctuation_N = mkN "波動" ;
lin decorative_A = variants{} ; -- 
lin unrest_N = mkN "動乱" | mkN "動揺" ;
lin resent_VS = mkVS "憤慨する" ;
lin resent_V2 = mkV2 "憤慨する" ;
lin plaster_N = variants{} ; -- 
lin chew_V2 = mkV2 "噛む" ;
lin chew_V = mkV "噛む" ;
lin grouping_N = variants{} ; -- 
lin gospel_N = mkN "福音書" | mkN "ゴスペル" ;
lin distributor_N = variants{} ; -- 
lin differentiation_N = mkN "区別" ;
lin blonde_A = variants{} ; -- 
lin aquarium_N = mkN "水族館" | mkN "アクアリウム" ;
lin witch_N = mkN "鬼女" ;
lin renewed_A = variants{} ; -- 
lin jar_N = mkN "広口瓶" | mkN "ジャー" | mkN "つぼ" ;
lin approved_A = variants{} ; -- 
lin advocateMasc_N = variants{} ; -- 
lin worrying_A = variants{} ; -- 
lin minimize_V2 = mkV2 "最小化する" ;
lin footstep_N = variants{} ; -- 
lin delete_V2 = mkV2 "消す" | mkV2 "削除する" ;
lin underneath_Adv = variants{} ; -- 
lin lone_A = mkA "ひとりの" ;
lin level_V2 = variants{} ; -- 
lin level_V = variants{} ; -- 
lin exceptionally_Adv = variants{} ; -- 
lin drift_N = mkN "漂流" ;
lin spider_N = mkN "蜘蛛" | mkN "クモ" | mkN "スパイダー" ;
lin hectare_N = mkN "ヘクタール" | mkN "㌶" ;
lin colonel_N = mkN "大佐" ;
lin swimming_N = mkN "水泳" ;
lin realism_N = mkN "現実主義" | mkN "写実主義" | mkN "リアリズム" ;
lin insider_N = mkN "インサイダー" | mkN "内部の人" ;
lin hobby_N = mkN "趣味" ;
lin computing_N = variants{} ; -- 
lin infrastructure_N = mkN "インフラストラクチャ" | mkN "インフラ" ;
lin cooperate_V = mkV "協力する" ;
lin burn_N = mkN "やけど" | mkN "焼け焦げ" ;
lin cereal_N = mkN "穀物" ;
lin fold_N = variants{} ; -- 
lin compromise_V2 = variants{} ; -- 
lin compromise_V = variants{} ; -- 
lin boxing_N = mkN "ボクシング" | mkN "拳闘" ;
lin rear_V2 = mkV2 "育てる" | mkV2 "飼育する" ;
lin rear_V = mkV "育てる" | mkV "飼育する" ;
lin lick_V2 = mkV2 "負かす" ;
lin constrain_V2 = variants{} ; -- 
lin clerical_A = variants{} ; -- 
lin hire_N = variants{} ; -- 
lin contend_VS = variants{} ; -- 
lin contend_V = variants{} ; -- 
lin amateurMasc_N = variants{} ; -- 
lin instrumental_A = variants{} ; -- 
lin terminal_A = variants{} ; -- 
lin electorate_N = mkN "有権者" ;
lin congratulate_V2 = variants{} ; -- 
lin balanced_A = variants{} ; -- 
lin manufacturing_N = variants{} ; -- 
lin split_N = mkN "開脚" | mkN "股割り" ;
lin domination_N = variants{} ; -- 
lin blink_V2 = mkV2 "まばたきする" | mkV2 "瞬く" ;
lin blink_V = mkV "まばたきする" | mkV "瞬く" ;
lin bleed_VS = mkVS "出血する" | mkVS "血を流す" ;
lin bleed_V2 = mkV2 "出血する" | mkV2 "血を流す" ;
lin bleed_V = mkV "出血する" | mkV "血を流す" ;
lin unlawful_A = variants{} ; -- 
lin precedent_N = mkN "先例" ;
lin notorious_A = variants{} ; -- 
lin indoor_A = mkA "屋内の" | mkA "インドアの" ;
lin upgrade_V2 = variants{} ; -- 
lin trench_N = mkN "塹壕" | mkN "トレンチ" ;
lin therapist_N = variants{} ; -- 
lin illuminate_V2 = mkV2 "照らす" | mkV2 "照明する" ;
lin bargain_V2 = variants{} ; -- 
lin bargain_V = variants{} ; -- 
lin warranty_N = mkN "保証" ;
lin scar_V2 = variants{} ; -- 
lin scar_V = variants{} ; -- 
lin consortium_N = mkN "コンソーシアム" ;
lin anger_V2 = variants{} ; -- 
lin insure_VS = variants{} ; -- 
lin insure_V2 = variants{} ; -- 
lin insure_V = variants{} ; -- 
lin extensively_Adv = variants{} ; -- 
lin appropriately_Adv = variants{} ; -- 
lin spoon_N = mkN "スプーン" ;
lin sideways_Adv = variants{} ; -- 
lin enhanced_A = variants{} ; -- 
lin disrupt_V2 = variants{} ; -- 
lin disrupt_V = variants{} ; -- 
lin satisfied_A = variants{} ; -- 
lin precaution_N = variants{} ; -- 
lin kite_N = mkN "トビ" | mkN "鳶" ;
lin instant_N = mkN "インスタントコーヒー" ;
lin gig_N = mkN "仕事" | mkN "出演" ;
lin continuously_Adv = variants{} ; -- 
lin consolidate_V2 = mkV2 "統合する" | mkV2 "]" ;
lin consolidate_V = mkV "統合する" | mkV "]" ;
lin fountain_N = mkN "噴水" ;
lin graduate_V2 = mkV2 "卒業する" ;
lin graduate_V = mkV "卒業する" ;
lin gloom_N = variants{} ; -- 
lin bite_N = mkN "咬傷" ;
lin structure_V2 = variants{} ; -- 
lin noun_N = mkN "名詞" ;
lin nomination_N = variants{} ; -- 
lin armchair_N = mkN "アームチェア" | mkN "肘掛け椅子" ;
lin virtual_A = mkA "事実上の" ;
lin unprecedented_A = mkA "前例のない" | mkA "空前" ;
lin tumble_V2 = variants{} ; -- 
lin tumble_V = variants{} ; -- 
lin ski_N = mkN "スキー" ;
lin architectural_A = variants{} ; -- 
lin violation_N = mkN "違反" ;
lin rocket_N = mkN "打ち上げ花火" ;
lin inject_V2 = variants{} ; -- 
lin departmental_A = variants{} ; -- 
lin row_V2 = mkV2 "漕ぐ" ;
lin row_V = mkV "漕ぐ" ;
lin luxury_A = variants{} ; -- 
lin fax_N = mkN "ファックス" | mkN "ファクシミリ" ;
lin deer_N = mkN "鹿" | mkN "シカ" ;
lin climber_N = mkN "登山家" ;
lin photographic_A = variants{} ; -- 
lin haunt_V2 = mkV2 "出没する" ;
lin fiercely_Adv = variants{} ; -- 
lin dining_N = mkN "食堂車" ;
lin sodium_N = mkN "ナトリウム" ;
lin gossip_N = mkN "噂" | mkN "ゴシップ" ;
lin bundle_N = variants{} ; -- 
lin bend_N = variants{} ; -- 
lin recruit_N = mkN "新兵" ;
lin hen_N = mkN "雌鶏" ;
lin fragile_A = mkA "壊れやすい" | mkA "脆い" | mkA "脆弱な" ;
lin deteriorate_V2 = mkV2 "悪化する" ;
lin deteriorate_V = mkV "悪化する" ;
lin dependency_N = variants{} ; -- 
lin swift_A = variants{} ; -- 
lin scramble_V2 = variants{} ; -- 
lin scramble_V = variants{} ; -- 
lin overview_N = mkN "概要" ;
lin imprison_V2 = mkV2 "刑務所に入れる" | mkV2 "投獄する" | mkV2 "閉じ込める" ;
lin trolley_N = mkN "トロリー" ;
lin rotation_N = mkN "回転" | mkN "自転" ;
lin denial_N = mkN "否認" ;
lin boiler_N = mkN "ボイラー" ;
lin amp_N = variants{} ; -- 
lin trivial_A = mkA "ありふれた" ;
lin shout_N = variants{} ; -- 
lin overtake_V2 = mkV2 "追い越す" ;
lin make_N = mkN "負け越し" ;
lin hunter_N = mkN "狩猟採集民" ;
lin guess_N = mkN "推測" ;
lin doubtless_Adv = variants{} ; -- 
lin syllable_N = mkN "音節" ;
lin obscure_A = mkA "朦朧とした" | mkA "不明瞭" ;
lin mould_N = variants{} ; -- 
lin limestone_N = mkN "石灰岩" ;
lin leak_V2 = mkV2 "漏れる" ;
lin leak_V = mkV "漏れる" ;
lin beneficiary_N = variants{} ; -- 
lin veteran_N = variants{} ; -- 
lin surplus_A = variants{} ; -- 
lin manifestation_N = mkN "明示" ;
lin vicar_N = variants{} ; -- 
lin textbook_N = mkN "教科書" | mkN "テキストブック" ;
lin novelist_N = mkN "小説家" ;
lin halfway_Adv = ParadigmsJpn.mkAdv "途中で" | ParadigmsJpn.mkAdv "中間で" ;
lin contractual_A = variants{} ; -- 
lin swap_V2 = variants{} ; -- 
lin swap_V = variants{} ; -- 
lin guild_N = mkN "ギルド" ;
lin ulcer_N = mkN "潰瘍" ;
lin slab_N = variants{} ; -- 
lin detector_N = variants{} ; -- 
lin detection_N = mkN "探知犬" ;
lin cough_V = mkV "咳払いをする" ;
lin whichever_Quant = variants{} ; -- 
lin spelling_N = mkN "正字法" | mkN "綴り" | mkN "文字綴り" | mkN "スペル" ;
lin lender_N = mkN "貸手" ;
lin glow_N = variants{} ; -- 
lin raised_A = variants{} ; -- 
lin prolonged_A = variants{} ; -- 
lin voucher_N = mkN "バウチャー" ;
lin t_shirt_N = variants{} ; -- 
lin linger_V = variants{} ; -- 
lin humble_A = mkA "謙虚な" | mkA "謙遜した" | mkA "謙遜な" ;
lin honey_N = mkN "蜜蜂" ;
lin scream_N = mkN "悲鳴" ;
lin postcard_N = mkN "葉書" ;
lin managing_A = variants{} ; -- 
lin alien_A = variants{} ; -- 
lin trouble_V2 = mkV2 "手数を掛ける" | mkV2 "面倒を掛ける" ;
lin reverse_N = mkN "リバースエンジニアリング" ;
lin odour_N = mkN "匂い" ;
lin fundamentally_Adv = variants{} ; -- 
lin discount_V2 = variants{} ; -- 
lin discount_V = variants{} ; -- 
lin blast_V2 = variants{} ; -- 
lin blast_V = variants{} ; -- 
lin syntactic_A = variants{} ; -- 
lin scrape_V2 = mkV2 "削る" | mkV2 "擦る" ;
lin scrape_V = mkV "削る" | mkV "擦る" ;
lin residue_N = variants{} ; -- 
lin procession_N = mkN "行列" ;
lin pioneer_N = mkN "ピオネール" | mkN "パイオニア" ;
lin intercourse_N = variants{} ; -- 
lin deter_V2 = mkV2 "予防する" ;
lin deadly_A = variants{} ; -- 
lin complement_V2 = variants{} ; -- 
lin restrictive_A = mkA "限定的" ;
lin nitrogen_N = mkN "窒素" ;
lin citizenship_N = mkN "市民権" | mkN "公民権" | mkN "国籍" ;
lin pedestrian_N = mkN "歩行者" ;
lin detention_N = mkN "拘留" | mkN "拘置" | mkN "抑留" ;
lin wagon_N = mkN "荷馬車" ;
lin microphone_N = mkN "マイクロフォン" | mkN "マイク" ;
lin hastily_Adv = variants{} ; -- 
lin fixture_N = variants{} ; -- 
lin choke_V2 = mkV2 "窒息する" | mkV2 "むせる" ;
lin choke_V = mkV "窒息する" | mkV "むせる" ;
lin wet_V2 = mkV2 "濡れる" ;
lin weed_N = mkN "葉巻" ;
lin programming_N = mkN "プログラミング" ;
lin power_V2 = mkV2 "供給する" ;
lin nationally_Adv = variants{} ; -- 
lin dozen_N = mkN "ダース" ;
lin carrot_N = mkN "ニンジン" | mkN "人参" ;
lin bulletin_N = mkN "掲示板" ;
lin wording_N = mkN "言葉遣い" | mkN "言い回し" ;
lin vicious_A = variants{} ; -- 
lin urgency_N = variants{} ; -- 
lin spoken_A = variants{} ; -- 
lin skeleton_N = mkN "骨格" | mkN "骸骨" ;
lin motorist_N = variants{} ; -- 
lin interactive_A = variants{} ; -- 
lin compute_V2 = variants{} ; -- 
lin compute_V = variants{} ; -- 
lin whip_N = mkN "鞭" ;
lin urgently_Adv = variants{} ; -- 
lin telly_N = variants{} ; -- 
lin shrub_N = mkN "低木" ;
lin porter_N = variants{} ; -- 
lin ethics_N = mkN "倫理" ;
lin banner_N = mkN "バナー" ;
lin velvet_N = mkN "ベルベット" | mkN "ビロード" ;
lin omission_N = mkN "省略" ;
lin hook_V2 = mkV2 "接続" ;
lin hook_V = mkV "接続" ;
lin gallon_N = mkN "ガロン" ;
lin financially_Adv = variants{} ; -- 
lin superintendent_N = mkN "管理者" | mkN "局長" | mkN "警視" ;
lin plug_V2 = variants{} ; -- 
lin plug_V = variants{} ; -- 
lin continuation_N = variants{} ; -- 
lin reliance_N = variants{} ; -- 
lin justified_A = variants{} ; -- 
lin fool_V2 = mkV2 "ばかにする" ;
lin detain_V2 = mkV2 "拘留する" | mkV2 "引き留める" ;
lin damaging_A = variants{} ; -- 
lin orbit_N = mkN "軌道" ;
lin mains_N = variants{} ; -- 
lin discard_V2 = mkV2 "捨てる" | mkV2 "棄てる" ;
lin dine_V = variants{} ; -- 
lin compartment_N = mkN "コンパートメント" | mkN "仕切り" | mkN "区画" ;
lin revised_A = variants{} ; -- 
lin privatization_N = mkN "民営化" ;
lin memorable_A = variants{} ; -- 
lin lately_Adv = variants{} ; -- 
lin distributed_A = variants{} ; -- 
lin disperse_V2 = variants{} ; -- 
lin disperse_V = variants{} ; -- 
lin blame_N = variants{} ; -- 
lin basement_N = mkN "地下室" ;
lin slump_V2 = variants{} ; -- 
lin slump_V = variants{} ; -- 
lin puzzle_V2 = variants{} ; -- 
lin monitoring_N = mkN "監視" | mkN "モニタリング" ;
lin talented_A = mkA "多才" ;
lin nominal_A = variants{} ; -- 
lin mushroom_N = mkN "キノコ" | mkN "茸" | mkN "きのこ" ;
lin instructor_N = mkN "インストラクター" | mkN "教師" ;
lin fork_N = variants{} ; -- 
lin fork_4_N = variants{} ; -- 
lin fork_3_N = variants{} ; -- 
lin fork_1_N = variants{} ; -- 
lin board_V2 = mkV2 "乗り込む" ;
lin want_N = mkN "求人広告" ;
lin disposition_N = variants{} ; -- 
lin cemetery_N = variants{} ; -- 
lin attempted_A = variants{} ; -- 
lin nephew_N = mkN "甥" ;
lin magical_A = variants{} ; -- 
lin ivory_N = mkN "象牙" ;
lin hospitality_N = mkN "款待" | mkN "持て成し" | mkN "厚情" ;
lin besides_Prep = variants{} ; -- 
lin astonishing_A = variants{} ; -- 
lin tract_N = variants{} ; -- 
lin proprietor_N = mkN "所有者" | mkN "所有者団体" ;
lin license_V2 = variants{} ; -- 
lin differential_A = variants{} ; -- 
lin affinity_N = mkN "アフィニティ" ;
lin talking_N = variants{} ; -- 
lin royalty_N = variants{} ; -- 
lin neglect_N = mkN "怠慢" ;
lin irrespective_A = variants{} ; -- 
lin whip_V2 = mkV2 "むち打つ" ;
lin whip_V = mkV "むち打つ" ;
lin sticky_A = mkA "ベタベタする" ;
lin regret_N = mkN "後悔" ;
lin incapable_A = variants{} ; -- 
lin franchise_N = variants{} ; -- 
lin dentist_N = mkN "歯医者" | mkN "歯科医" | mkN "歯科医師" ;
lin contrary_N = variants{} ; -- 
lin profitability_N = variants{} ; -- 
lin enthusiast_N = variants{} ; -- 
lin crop_V2 = variants{} ; -- 
lin crop_V = variants{} ; -- 
lin utter_V2 = mkV2 "発する" ;
lin pile_V2 = variants{} ; -- 
lin pile_V = variants{} ; -- 
lin pier_N = mkN "桟橋" | mkN "波止場" | mkN "埠頭" ;
lin dome_N = mkN "円屋根" | mkN "円蓋" | mkN "天蓋" ;
lin bubble_N = mkN "バブル" ;
lin treasurer_N = mkN "会計係" ;
lin stocking_N = mkN "ストッキング" ;
lin sanctuary_N = variants{} ; -- 
lin ascertain_V2 = mkV2 "確かめる" ;
lin arc_N = mkN "弧" ;
lin quest_N = mkN "探索" | mkN "探求" ;
lin mole_N = mkN "モグラ" ;
lin marathon_N = mkN "マラソン" ;
lin feast_N = mkN "饗宴" | mkN "祝宴" | mkN "ごちそう" ;
lin crouch_V = mkV "しゃがむ" | mkV "蹲る" ;
lin storm_V2 = variants{} ; -- 
lin storm_V = variants{} ; -- 
lin hardship_N = mkN "苦難" | mkN "苦しみ" | mkN "難儀" ;
lin entitlement_N = variants{} ; -- 
lin circular_N = mkN "檄" ;
lin walking_A = variants{} ; -- 
lin strap_N = mkN "肩章" ;
lin sore_A = variants{} ; -- 
lin complementary_A = variants{} ; -- 
lin understandable_A = variants{} ; -- 
lin noticeable_A = variants{} ; -- 
lin mankind_N = mkN "人類" ;
lin majesty_N = variants{} ; -- 
lin pigeon_N = mkN "鳩" ;
lin goalkeeper_N = mkN "ゴールキーパー" | mkN "キーパー" ;
lin ambiguous_A = mkA "あいまいな" ;
lin walker_N = variants{} ; -- 
lin virgin_N = mkN "処女" | mkN "未通女" | mkN "童貞" | mkN "バージン" ;
lin prestige_N = mkN "名誉" | mkN "威信" ;
lin preoccupation_N = variants{} ; -- 
lin upset_A = mkA "くよくよ" ;
lin municipal_A = variants{} ; -- 
lin groan_V2 = mkV2 "呻く" ;
lin groan_V = mkV "呻く" ;
lin craftsman_N = variants{} ; -- 
lin anticipation_N = variants{} ; -- 
lin revise_V2 = mkV2 "復習する" ;
lin revise_V = mkV "復習する" ;
lin knock_N = variants{} ; -- 
lin infect_V2 = mkV2 "感染させる" ;
lin infect_V = mkV "感染させる" ;
lin denounce_V2 = mkV2 "非難する" ;
lin confession_N = mkN "懺悔" | mkN "告解" ;
lin turkey_N = mkN "七面鳥" | mkN "カラクン" | mkN "カラクン鳥" | mkN "ターキー" ;
lin toll_N = mkN "通行料金" | mkN "通行料" | mkN "有料" ;
lin pal_N = variants{} ; -- 
lin transcription_N = mkN "転写" ;
lin sulphur_N = variants{} ; -- 
lin provisional_A = variants{} ; -- 
lin hug_V2 = mkV2 "抱く" ;
lin particular_N = variants{} ; -- 
lin intent_A = variants{} ; -- 
lin fascinate_V2 = mkV2 "魅惑する" ;
lin conductor_N = mkN "指揮者" ;
lin feasible_A = mkA "実行できる" | mkA "実現可能な" ;
lin vacant_A = mkA "空の" ;
lin trait_N = mkN "特徴" ;
lin meadow_N = mkN "草原" ;
lin creed_N = mkN "信条" ;
lin unfamiliar_A = mkA "知られていない" ;
lin optimism_N = mkN "楽観主義" ;
lin wary_A = mkA "用心深い" ;
lin twist_N = variants{} ; -- 
lin sweet_N = mkN "糖菓" ;
lin substantive_A = variants{} ; -- 
lin excavation_N = mkN "発掘" ;
lin destiny_N = mkN "運命" | mkN "宿命" ;
lin thick_Adv = ParadigmsJpn.mkAdv "厚く" ;
lin pasture_N = mkN "牧草地" ;
lin archaeological_A = variants{} ; -- 
lin tick_V2 = variants{} ; -- 
lin tick_V = variants{} ; -- 
lin profit_V2 = variants{} ; -- 
lin profit_V = variants{} ; -- 
lin pat_V2 = mkV2 "摩する" | mkV2 "撫でる" ;
lin pat_V = mkV "摩する" | mkV "撫でる" ;
lin papal_A = variants{} ; -- 
lin cultivate_V2 = mkV2 "栽培する" ;
lin awake_V = mkV "起こす" | mkV "目ざめさせる" ;
lin trained_A = variants{} ; -- 
lin civic_A = variants{} ; -- 
lin voyage_N = mkN "航海" | mkN "旅" | mkN "旅行" ;
lin siege_N = mkN "攻城戦" | mkN "包囲" ;
lin enormously_Adv = variants{} ; -- 
lin distract_V2 = mkV2 "気をそらす" ;
lin distract_V = mkV "気をそらす" ;
lin stroll_V = mkV "散歩する" ;
lin jewel_N = mkN "宝" ;
lin honourable_A = variants{} ; -- 
lin helpless_A = mkA "無力な" ;
lin hay_N = mkN "干草" ;
lin expel_V2 = mkV2 "追放する" ;
lin eternal_A = mkA "永遠の" | mkA "永久の" ;
lin demonstrator_N = mkN "示威運動者" | mkN "抗議者" ;
lin correction_N = variants{} ; -- 
lin civilization_N = mkN "文明化" ;
lin ample_A = variants{} ; -- 
lin retention_N = variants{} ; -- 
lin rehabilitation_N = variants{} ; -- 
lin premature_A = variants{} ; -- 
lin encompass_V2 = variants{} ; -- 
lin distinctly_Adv = variants{} ; -- 
lin diplomat_N = mkN "外交官" ;
lin articulate_V2 = variants{} ; -- 
lin articulate_V = variants{} ; -- 
lin restricted_A = variants{} ; -- 
lin prop_V2 = variants{} ; -- 
lin intensify_V2 = variants{} ; -- 
lin intensify_V = variants{} ; -- 
lin deviation_N = mkN "偏差" ;
lin contest_V2 = variants{} ; -- 
lin contest_V = variants{} ; -- 
lin workplace_N = mkN "職場" ;
lin lazy_A = mkA "ナマケモノ" | mkA "怠惰な" | mkA "ぐうたら" ;
lin kidney_N = mkN "腎臓" ;
lin insistence_N = variants{} ; -- 
lin whisper_N = mkN "囁き" ;
lin multimedia_N = mkN "マルチメディア" | mkN "複合媒体" ;
lin forestry_N = mkN "林業" ;
lin excited_A = mkA "興奮する" ;
lin decay_N = variants{} ; -- 
lin screw_N = mkN "ねじ" | mkN "螺子" ;
lin rally_V2V = variants{} ; -- 
lin rally_V2 = variants{} ; -- 
lin rally_V = variants{} ; -- 
lin pest_N = variants{} ; -- 
lin invaluable_A = variants{} ; -- 
lin homework_N = mkN "宿題" ;
lin harmful_A = mkA "有害な" ;
lin bump_V2 = variants{} ; -- 
lin bump_V = variants{} ; -- 
lin bodily_A = variants{} ; -- 
lin grasp_N = variants{} ; -- 
lin finished_A = variants{} ; -- 
lin facade_N = variants{} ; -- 
lin cushion_N = mkN "クッション" ;
lin conversely_Adv = variants{} ; -- 
lin urge_N = mkN "願望" | mkN "衝動" ;
lin tune_V2 = variants{} ; -- 
lin tune_V = variants{} ; -- 
lin solvent_N = mkN "溶媒" | mkN "溶剤" ;
lin slogan_N = mkN "スローガン" | mkN "標語" ;
lin petty_A = variants{} ; -- 
lin perceived_A = variants{} ; -- 
lin install_V2 = mkV2 "導入する" | mkV2 "インストールする" ;
lin install_V = mkV "導入する" | mkV "インストールする" ;
lin fuss_N = variants{} ; -- 
lin rack_N = variants{} ; -- 
lin imminent_A = variants{} ; -- 
lin short_N = mkN "短絡" | mkN "ショート" ;
lin revert_V = variants{} ; -- 
lin ram_N = mkN "牡羊" | mkN "雄羊" ;
lin contraction_N = mkN "陣痛" ;
lin tread_V2 = mkV2 "踏む" ;
lin tread_V = mkV "踏む" ;
lin supplementary_A = mkA "補足の" ;
lin ham_N = mkN "大根" | mkN "大根役者" ;
lin defy_V2V = variants{} ; -- 
lin defy_V2 = variants{} ; -- 
lin athlete_N = mkN "陸上選手" ;
lin sociological_A = variants{} ; -- 
lin physician_N = mkN "医師" ;
lin crossing_N = mkN "交差点" | mkN "踏切" ;
lin bail_N = mkN "保釈金" ;
lin unwanted_A = variants{} ; -- 
lin tight_Adv = variants{} ; -- 
lin plausible_A = variants{} ; -- 
lin midfield_N = variants{} ; -- 
lin alert_A = mkA "機敏な" | mkA "警戒する" "警戒の" ;
lin feminine_A = mkA "女性の" ;
lin drainage_N = mkN "流域" ;
lin cruelty_N = mkN "残酷さ" ;
lin abnormal_A = mkA "不自然" "不自然の" | mkA "異常" "異常の" ;
lin relate_N = variants{} ; -- 
lin poison_V2 = mkV2 "毒を混入する" | mkV2 "毒を盛る" ;
lin symmetry_N = variants{} ; -- 
lin stake_V2 = variants{} ; -- 
lin rotten_A = L.rotten_A | mkA "腐った" | mkA "腐朽した" ;
lin prone_A = variants{} ; -- 
lin marsh_N = mkN "湿地" | mkN "湿原" ;
lin litigation_N = mkN "訴訟" ;
lin curl_N = mkN "巻き毛" ;
lin urine_N = mkN "尿" | mkN "小便" ;
lin latin_A = variants{} ; -- 
lin hover_V = variants{} ; -- 
lin greeting_N = mkN "挨拶" ;
lin chase_N = mkN "追跡" | mkN "追求" ;
lin spouseMasc_N = variants{} ; -- 
lin produce_N = variants{} ; -- 
lin forge_V2 = variants{} ; -- 
lin forge_V = variants{} ; -- 
lin salon_N = mkN "サロン" ;
lin handicapped_A = mkA "障害者" ;
lin sway_V2 = variants{} ; -- 
lin sway_V = variants{} ; -- 
lin homosexual_A = mkA "同性愛者" ;
lin handicap_V2 = variants{} ; -- 
lin colon_N = mkN "大腸" ;
lin upstairs_N = variants{} ; -- 
lin stimulation_N = mkN "刺激" ;
lin spray_V2 = variants{} ; -- 
lin original_N = mkN "原作" | mkN "原文" | mkN "原物" ;
lin lay_A = variants{} ; -- 
lin garlic_N = mkN "大蒜" | mkN "ニンニク" ;
lin suitcase_N = mkN "スーツケース" | mkN "トランク" ;
lin skipper_N = variants{} ; -- 
lin moan_VS = mkVS "呻く" ;
lin moan_V = mkV "呻く" ;
lin manpower_N = variants{} ; -- 
lin manifest_V2 = variants{} ; -- 
lin incredibly_Adv = variants{} ; -- 
lin historically_Adv = variants{} ; -- 
lin decision_making_N = variants{} ; -- 
lin wildly_Adv = variants{} ; -- 
lin reformer_N = mkN "リフォーマー" ;
lin quantum_N = mkN "量子ドット" ;
lin considering_Subj = variants{} ; -- 
}
