module TypeFormat where

import CfFormat
import MorphFormat


-- dependent categories for natural language grammars. AR 1998

data Term = App Term Term | Abs Var Term | Id String | Meta String 
             deriving(Eq,Read,Show)

type Cont  = [(Var,(Cat,[Term]))]
type Type  = (Cont,(Cat,[Term]))
type Funct = ([(Var,Type)],(Cat,[Term]))
type Rul   = (Funct,Pattern)
type Gramm = [(String,Rul)]
type MRul  = (Funct,MEntry)
type MGramm = [(String,MRul)]

ITree :: Tree -> Term
ITree (Apply (Fun F) X) =   
 foldl App (Id F) (makeAbs X) 
  where
   makeAbs (VarL x : b : l) = foldr Abs (ITree b) x : makeAbs l
   makeAbs (a : l)          = ITree a : makeAbs l
   makeAbs []               = []
ITree (Place (Var s))   = Meta s
ITree (VarL x)          = error "abstraction without head"

ShowTerm :: Term -> String
ShowTerm (App f a) = 
 fn f ++ "(" ++ foldl1 (\ x y -> x ++ "," ++ y) (ar a) ++ ")"
  where fn f = case f of App g b -> fn g
                         _       -> ShowTerm f
        ar a = case f of App g b -> ar b ++ [ShowTerm a]
                         _       -> [ShowTerm a]
ShowTerm (Abs x b) = 
 "(" ++ foldl1 (\ x y -> x ++ ")(" ++ y) (vr x) ++ ")" ++ hd b
  where vr (Var x) = case b of Abs y c -> x : vr y
                               _       -> [x]
        hd b = case b of Abs y c -> hd c
                         _       -> ShowTerm b
ShowTerm (Id x) = x
ShowTerm (Meta x) = x

StripFunct :: Funct -> Function
StripFunct (X,((A,D))) = 
 (StripArgs X, A)
  where
   StripArgs ((x,([],(A,D))) : L) = A : StripArgs L
   StripArgs ((x,(G,(A,D))) : L)  = Vars : A : StripArgs L
   StripArgs []                   = []

-- StripGramm :: Gramm -> Grammar  -- also from MGramm to MGrammar
StripGramm G = [(s,(StripFunct F,P)) | (s,(F,P)) <- G]
