module gfits_types
  use gildas_def
  !
  !---------------------------------------------------------------------
  !
  integer(kind=4), parameter :: key_length=15
  integer(kind=4), parameter :: char0d_length=80   ! FITS character scalar values
  integer(kind=4), parameter :: char1d_length=16   ! FITS character array values
  integer(kind=4), parameter :: comment_length=72
  !
  ! Scalar types
  type fits_unkn_0d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     character(len=char0d_length) :: val = ''
  end type fits_unkn_0d_t
  type fits_dble_0d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     real(kind=8) :: val = 0.d0
  end type fits_dble_0d_t
  type fits_inte_0d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     integer(kind=4) :: val = 0
  end type fits_inte_0d_t
  type fits_logi_0d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     logical :: val = .false.
  end type fits_logi_0d_t
  type fits_char_0d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     character(len=char0d_length) :: val = ''
  end type fits_char_0d_t
  !
  ! 1D array types
  type fits_inte_1d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     integer(kind=index_length) :: n = 0
     integer(kind=4), pointer :: val(:) => null()
  end type fits_inte_1d_t
  type fits_real_1d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     integer(kind=index_length) :: n = 0
     real(kind=4), pointer :: val(:) => null()
  end type fits_real_1d_t
  type fits_dble_1d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     integer(kind=index_length) :: n = 0
     real(kind=8), pointer :: val(:) => null()
  end type fits_dble_1d_t
  type fits_logi_1d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     integer(kind=index_length) :: n = 0
     logical, pointer :: val(:) => null()
  end type fits_logi_1d_t
  type fits_char_1d_t
     character(len=comment_length) :: comment = ''
     character(len=key_length) :: key = ''
     integer(kind=index_length) :: n = 0
     character(len=char1d_length), pointer :: val(:) => null()
  end type fits_char_1d_t
  !
  !---------------------------------------------------------------------
  !
  ! FITS header descriptor
  type :: gfits_hdesc_t
    real(kind=4)    :: bscal   ! Tape scaling factor
    real(kind=4)    :: bzero   ! Map offset
    integer(kind=4) :: nbit    ! Number of bits per value in current file
    integer(kind=4) :: snbit   ! Number of bits per value for FITS writing
    integer(kind=4) :: nb      ! Pointer within I/O buffer
    real(kind=4)    :: bval0   ! Default blanking value
  end type gfits_hdesc_t
  !
  ! Dictionary of cards in the header
  type :: gfits_hdict_t
    integer(kind=4) :: ncard
    type(fits_unkn_0d_t), allocatable :: card(:)
    integer(kind=4), allocatable :: sort(:)  ! Sorting array
  end type gfits_hdict_t
  !
  !---------------------------------------------------------------------
  !
end module gfits_types
