module cubeadm_flaglist
  use cubetools_structure
  use cubeadm_messaging
  !
  public :: flaglist
  private
  !
  type flaglist_comm_t
     type(option_t) , pointer :: comm
   contains
     procedure, public  :: register => cubeadm_flaglist_register
     procedure, private :: main     => cubeadm_flaglist_main
  end type flaglist_comm_t
  type(flaglist_comm_t) :: flaglist
  !
contains
  !
  subroutine cubeadm_flaglist_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    character(len=*), parameter :: rname='FLAGLIST>COMMAND'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call flaglist%main(error)
    if (error) return
  end subroutine cubeadm_flaglist_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeadm_flaglist_register(flaglist,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(flaglist_comm_t), intent(inout) :: flaglist
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='FLAGLIST>REGISTER'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'FLAGLIST','',&
         'List available flags',&
         'List all the available flags and their properties',&
         cubeadm_flaglist_command,&
         flaglist%comm,error)
    if (error) return
  end subroutine cubeadm_flaglist_register
  !
  subroutine cubeadm_flaglist_main(flaglist,error)
    use cubedag_flag
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(flaglist_comm_t), intent(in)    :: flaglist
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='FLAGLIST>MAIN'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubedag_flaglist_list_all(error)
    if (error) return
    call cubeadm_message(seve%r,rname,blankstr)
  end subroutine cubeadm_flaglist_main
end module cubeadm_flaglist
