!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubestatistics_one2two_real_template
  use cube_types
  use cubetools_parameters
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubeadm_cubeprod_types
  use cubetopology_cuberegion_types
  use cubestatistics_messaging
  !
  public :: one2two_real_comm_t,one2two_real_user_t,one2two_real_prog_t
  private
  !
  type one2two_real_comm_t
     type(option_t), pointer :: comm
     type(cuberegion_comm_t) :: region
     type(cubeid_arg_t), pointer :: incube
     type(cube_prod_t),  pointer :: oucube1
     type(cube_prod_t),  pointer :: oucube2
     procedure(cubestatistics_one2two_real_prog_act), pointer, nopass, public :: act => null()
   contains
     procedure, public :: register_syntax => cubestatistics_one2two_real_register_syntax
     procedure, public :: register_act    => cubestatistics_one2two_real_register_act
     procedure, public :: parse           => cubestatistics_one2two_real_parse
     procedure, public :: main            => cubestatistics_one2two_real_main
  end type one2two_real_comm_t
  !
  type one2two_real_user_t
     type(cubeid_user_t)     :: cubeids
     type(cuberegion_user_t) :: region
   contains
     procedure, private :: toprog => cubestatistics_one2two_real_user_toprog
  end type one2two_real_user_t
  !
  type one2two_real_prog_t
     type(cuberegion_prog_t) :: region
     type(cube_t), pointer :: incube
     type(cube_t), pointer :: oucube1
     type(cube_t), pointer :: oucube2
     procedure(cubestatistics_one2two_real_prog_act), pointer, public :: act => null()
   contains
     procedure, private :: header => cubestatistics_one2two_real_prog_header
     procedure, private :: data   => cubestatistics_one2two_real_prog_data
     procedure, private :: loop   => cubestatistics_one2two_real_prog_loop
  end type one2two_real_prog_t
  !
contains
  !
  subroutine cubestatistics_one2two_real_register_syntax(comm,opername,opercomm,ou1name,ou1flags,ou2name,ou2flags,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2two_real_comm_t), intent(inout)    :: comm
    character(len=*),           intent(in)       :: opername
    external                                     :: opercomm
    character(len=*),           intent(in)       :: ou1name
    type(flag_t),               intent(in)       :: ou1flags(:)
    character(len=*),           intent(in)       :: ou2name
    type(flag_t),               intent(in)       :: ou2flags(:)
    logical,                    intent(inout)    :: error
    !
    type(cubeid_arg_t) :: incube
    type(cube_prod_t) :: oucube1,oucube2
    character(len=*), parameter :: comm_help = &
         'Input and output cubes must be real'
    character(len=*), parameter :: rname='ONE2TWO>REAL>REGISTER>SYNTAX'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    ! Syntax
    call cubetools_register_command(&
         opername, 'histo3d',&
         'Statistics the '//trim(opername)//' image of spectrum of a 3D histogram',&
         comm_help,&
         opercomm,&
         comm%comm,error)
    if (error) return
    call incube%register(&
         'HISTO3D',&
         '3D histogram',&
         strg_id,&
         code_arg_optional,&
         [flag_histo3d],&
         code_read,&
         code_access_speset,&
         comm%incube,&
         error)
    if (error) return
    !
    call comm%region%register(error)
    if (error) return
    !
    ! Product
    call oucube1%register(&
         ou1name,&
         trim(ou1name)//' cube',&
         strg_id,&
         ou1flags,&
         comm%oucube1,&
         error)
    if (error)  return
    call oucube2%register(&
         ou2name,&
         trim(ou2name)//' cube',&
         strg_id,&
         ou2flags,&
         comm%oucube2,&
         error)
    if (error)  return
  end subroutine cubestatistics_one2two_real_register_syntax
  !
  subroutine cubestatistics_one2two_real_register_act(comm,act,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2two_real_comm_t),                     intent(inout) :: comm
    procedure(cubestatistics_one2two_real_prog_act)               :: act
    logical,                                        intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2TWO>REAL>REGISTER>ACT'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    comm%act => act
  end subroutine cubestatistics_one2two_real_register_act
  !
  subroutine cubestatistics_one2two_real_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    ! ONE2TWO cubeid
    ! /SIZE sx [sy]
    ! /CENTER xcen ycen
    ! /RANGE zfirst zlast
    ! /SPECTRUM
    ! /IMAGE
    !----------------------------------------------------------------------
    class(one2two_real_comm_t), intent(in)    :: comm
    character(len=*),           intent(in)    :: line
    type(one2two_real_user_t),  intent(out)   :: user
    logical,                    intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2TWO>REAL>PARSE'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,comm%comm,user%cubeids,error)
    if (error) return
    call comm%region%parse(line,user%region,error)
    if (error) return
  end subroutine cubestatistics_one2two_real_parse
  !
  subroutine cubestatistics_one2two_real_main(comm,user,error)
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2two_real_comm_t), intent(in)    :: comm
    type(one2two_real_user_t),  intent(inout) :: user
    logical,                    intent(inout) :: error
    !
    type(one2two_real_prog_t) :: prog
    character(len=*), parameter :: rname='ONE2TWO>REAL>MAIN'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call user%toprog(comm,prog,error)
    if (error) return
    call prog%header(comm,error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubestatistics_one2two_real_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubestatistics_one2two_real_user_toprog(user,comm,prog,error)
    use cubeadm_get
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(one2two_real_user_t), intent(in)    :: user
    type(one2two_real_comm_t),  intent(in)    :: comm
    type(one2two_real_prog_t),  intent(out)   :: prog
    logical,                    intent(inout) :: error
    !
    character(len=*), parameter :: rname='ONE2TWO>REAL>USER>TOPROG'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubeadm_get_header(comm%incube,user%cubeids,prog%incube,error)
    if (error) return
    call user%region%toprog(prog%incube,prog%region,error)
    if (error) return
    call prog%region%list(error)
    if (error) return
    !
    prog%act => comm%act
  end subroutine cubestatistics_one2two_real_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubestatistics_one2two_real_prog_header(prog,comm,error)
    use cubeadm_clone
    use cubetools_header_methods
    !----------------------------------------------------------------------
    ! For the moment, the header of the numerator is copied. On the longer
    ! term, only the common part of the header could/should be copied. The
    ! other ones should stay to unknown, as the user would be able to get
    ! the information by listing the headers of the parent cubes.
    !----------------------------------------------------------------------
    class(one2two_real_prog_t), intent(inout) :: prog
    type(one2two_real_comm_t),  intent(in)    :: comm
    logical,                    intent(inout) :: error
    !
    character(len=unit_l) :: unit
    integer(kind=chan_k), parameter :: one=1
    character(len=*), parameter :: rname='ONE2TWO>REAL>PROG>HEADER'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(comm%oucube1,prog%incube,prog%oucube1,error)
    if (error) return
    call prog%region%header(prog%oucube1,error)
    if (error) return
    call cubetools_header_put_nchan(one,prog%oucube1%head,error)
    if (error) return
    !
    call cubeadm_clone_header(comm%oucube2,prog%incube,prog%oucube2,error)
    if (error) return
    call prog%region%header(prog%oucube2,error)
    if (error) return
    call cubetools_header_put_nchan(one,prog%oucube2%head,error)
    if (error) return
    ! 
    call cubetools_header_get_array_unit(prog%incube%head,unit,error)
    if (error) return
    call cubetools_header_put_array_unit(trim(unit),prog%oucube1%head,error)
    if (error) return
    call cubetools_header_put_array_unit(trim(unit),prog%oucube2%head,error)
    if (error) return
  end subroutine cubestatistics_one2two_real_prog_header
  !
  subroutine cubestatistics_one2two_real_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(one2two_real_prog_t), intent(inout) :: prog
    logical,                    intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='ONE2TWO>REAL>PROG>DATA'
    !
    call cubestatistics_message(statisticsseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error) exit
       !$OMP TASK SHARED(prog,error) FIRSTPRIVATE(iter)
       if (.not.error) &
         call prog%loop(iter,error)
       !$OMP END TASK
    enddo ! iter
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubestatistics_one2two_real_prog_data
  !   
  subroutine cubestatistics_one2two_real_prog_loop(prog,iter,error)
    use cubeadm_taskloop
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2two_real_prog_t), intent(inout) :: prog
    type(cubeadm_iterator_t),   intent(inout) :: iter
    logical,                    intent(inout) :: error
    !
    type(spectrum_t) :: inspe,ouspe1,ouspe2
    character(len=*), parameter :: rname='ONE2TWO>REAL>PROG>LOOP'
    !
    call inspe%associate('input histo3d',prog%incube,iter,error)
    if (error) return
    call inspe%associate_x(error)
    if (error) return
    call ouspe1%allocate('output cube #1',prog%oucube1,iter,error)
    if (error) return
    call ouspe2%allocate('output cube #2',prog%oucube2,iter,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
       call prog%act(iter%ie,inspe,ouspe1,ouspe2,error)
       if (error) return
    enddo ! ie
  end subroutine cubestatistics_one2two_real_prog_loop
    !   
  subroutine cubestatistics_one2two_real_prog_act(prog,ie,inspe,ouspe1,ouspe2,error)
    use cubeadm_spectrum_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(one2two_real_prog_t), intent(inout) :: prog
    integer(kind=entr_k),       intent(in)    :: ie
    type(spectrum_t),           intent(inout) :: inspe
    type(spectrum_t),           intent(inout) :: ouspe1
    type(spectrum_t),           intent(inout) :: ouspe2
    logical,                    intent(inout) :: error
  end subroutine cubestatistics_one2two_real_prog_act
end module cubestatistics_one2two_real_template
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
