module cubedag_repositories
  use cubedag_dag
  use cubedag_repository
  use cubedag_history
  use cubedag_hrepository
  !---------------------------------------------------------------------
  ! Support module for both DAG and HISTORY repositories. There are
  ! actions where they must be treated at the same time for consistency,
  ! as they have cross links.
  !---------------------------------------------------------------------

  public :: cubedag_repositories_init,cubedag_repositories_free
  private

contains

  subroutine cubedag_repositories_init(error)
    !-------------------------------------------------------------------
    ! Initialize both the DAG and HISTORY repositories
    !-------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    call cubedag_repository_init('zzz',error)
    if (error)  return
    call cubedag_hrepository_init('zzz',error)
    if (error)  return
  end subroutine cubedag_repositories_init

  subroutine cubedag_repositories_free(error)
    !-------------------------------------------------------------------
    ! Free (empty) the DAG and HISTORY repositories from the memory.
    ! ZZZ It is unclear if the repository files should be destroyed too.
    ! ZZZ Both use cases (keeping or destroying these files) are valid.
    !-------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    ! Use brute-force destruction (works if both are destroyed simultaneously)
    call cubedag_dag_destroy(error)
    if (error)  continue
    call cubedag_history_destroy(error)
    if (error)  continue
  end subroutine cubedag_repositories_free

end module cubedag_repositories
