!-----------------------------------------------------------------------
! Support subroutines to create a cube type and header from scratch
!-----------------------------------------------------------------------
!
subroutine cubeio_create_cube_data(rname,cubset,cubdef,head,cub,error)
  use cubecdf_image_write
  use cubefitsio_image_write
  use cubetools_header_types
  use cubetools_setup_types
  use cubeio_interfaces, except_this=>cubeio_create_cube_data
  use cubeio_block
  use cubeio_range
  use cubeio_cube
  use cubeio_cube_define
  use cubeio_header
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ public
  !---------------------------------------------------------------------
  character(len=*),    intent(in)    :: rname
  type(cube_setup_t),  intent(in)    :: cubset
  type(cube_define_t), intent(in)    :: cubdef
  type(cube_header_t), intent(in)    :: head
  type(cubeio_cube_t), intent(inout) :: cub
  logical,             intent(inout) :: error
  !
  if (cub%ready())  return
  !
  ! ZZZ deplacer le core
  call cubeio_create_cube_data_core(error)
  if (error)  return
  !
  cub%memo%ready = cub%desc%buffered
  !
contains
  subroutine cubeio_create_cube_data_core(error)
    use cubetools_access
    use cubetools_nan
    use cubetools_dataformat
    logical, intent(inout) :: error
    ! Local
    character(len=12) :: extension
    integer(kind=4) :: nch,lext
    integer(kind=chan_k) :: nc
    integer(kind=pixe_k) :: nx,ny
    type(cubeio_range_t) :: range
    integer(kind=data_k) :: dim(maxdim)
    integer(kind=data_k), parameter :: initdim=1  ! 0 not allowed by GIO
    !
    ! Sanity
    if (cub%desc%order.eq.code_null) then
      call cubeio_message(seve%e,rname,  &
        'Attempt to write cube data while header is not prepared')
      error = .true.
      return
    endif
    !
    select case (cub%desc%buffered)
    case (code_buffer_none)
      ! No data at all
      cub%file%kind = code_dataformat_none
      call cub%memo%free(error)
      if (error)  return
      !
    case (code_buffer_memory)
      ! Allocate a memory buffer
      call cubeio_message(ioseve%others,rname,'File is buffered in memory')
      cub%file%kind = code_dataformat_none
      call cub%memo%reallocate(cub%desc%iscplx, &
        cub%desc%nx,cub%desc%ny,cub%desc%nc,cub%desc%order,error)
      if (error) return
      !
    case (code_buffer_disk)
      ! Create a file on disk
      if (cubdef%dofilekind)  cub%file%kind = cubdef%filekind
      if (cubdef%dofilename)  cub%file%name = cubdef%filename
      if (cub%file%name.eq.'') then
        call cubeio_message(seve%e,rname,'Missing file name')
        error = .true.
        return
      endif
      extension = '.unk'
      lext = 4
      select case (cub%file%kind)
      case (code_dataformat_fits)
        extension = '.fits'
        lext = 5
      case (code_dataformat_gdf)
        extension = cubetools_order2ext(cub%desc%order)
        lext = len_trim(extension)
      case (code_dataformat_cdf)
        extension = '.cdf'
        lext = 4
      end select
      nch = len_trim(cub%file%name)
      if (nch.gt.lext .and. cub%file%name(nch-lext+1:nch).eq.extension) then
        ! File name has already the correct extension
        continue
      else
        ! Append correct extension to file name
        cub%file%name = cub%file%name(1:nch)//extension
      endif
      !
      call cubeio_message(ioseve%others,rname,  &
        'File is not buffered in memory, using file '//cub%file%name)
      !
      ! Create a file with dummy/minimal data area:
      select case (cub%file%kind)
      case (code_dataformat_fits)
        call cubeio_create_and_truncate_hfits(head,cubdef%order,initdim,cub%file%hfits,error)
        if (error)  return
        call cubefitsio_image_create(cub%file%hfits,cub%file%name,cubdef%dochecksum,error)
        if (error)  continue  ! Error message below
        dim(:) = cub%file%hfits%dim(:)
      case (code_dataformat_gdf)
        call gildas_null(cub%file%hgdf)
        call cubeio_create_and_truncate_hgdf(head,cub%desc,cubdef%order,initdim,cub%file%hgdf,error)
        if (error)  return
        cub%file%hgdf%file = cub%file%name
        cub%file%hgdf%gil%extr_words = 0  ! Disable the extrema section. It will be reenabled if and when relevant
        call gdf_create_image(cub%file%hgdf,error)
        if (error)  continue  ! Error message below
        dim(:) = cub%file%hgdf%gil%dim(:)
      case (code_dataformat_cdf)
        call cubeio_create_and_truncate_hcdf(head,cubdef%order,initdim,cub%file%hcdf,error)
        if (error)  return
        call cubecdf_image_create(cub%file%hcdf,cub%file%name,error)
        if (error)  continue  ! Error message below
        dim(:) = cub%file%hcdf%dim(:)
      case default
        call cubeio_message(seve%e,rname,'No associated file on disk or file kind not supported')
        error = .true.
        return
      end select
      if (error) then
        call cubeio_message(seve%e,rname,'Error creating file '//cub%file%name)
        return
      endif
      ! Create dummy data
      if (cub%desc%order.eq.code_cube_imaset) then
        nx = dim(1)  ! Actual size of disk
        ny = dim(2)  ! Actual size of disk
        nc = dim(3)  !
      else
        nc = dim(1)  ! Actual size of disk
        nx = dim(2)  ! Actual size of disk
        ny = dim(3)  !
      endif
      call cubeio_block_reallocate(cubset,cub%file%block,cub%desc%iscplx,nx,ny,nc,  &
        cub%desc%order,error)
      if (error)  return
      if (cub%desc%iscplx) then
        cub%file%block%c4(:,:,:) = gr4nan  ! ZZZ what is a blank value for C*4?
      else
        cub%file%block%r4(:,:,:) = gr4nan
      endif
      ! Write dummy data, so that the GDF header and the records available on
      ! disk are consistent. Future calls to gdf_extend_image will work even
      ! when extending to 1 i.e. no actual extension.
      range%blc(:) = 0
      range%trc(:) = 0
      if (cub%desc%iscplx) then
        call cubeio_write_cube_data(rname,cubset,cub,range,cub%file%block%c4,error)
      else
        call cubeio_write_cube_data(rname,cubset,cub,range,cub%file%block%r4,error)
      endif
      if (error)  return
      ! NB: we leave the image opened, so that we can write e.g. one visibility
      ! after the other.
      !
    case default
      call cubeio_message(seve%e,rname,'Unexpected buffering kind')
      error = .true.
      return
    end select
  end subroutine cubeio_create_cube_data_core
end subroutine cubeio_create_cube_data
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
