!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetools_option_types
  use cubetools_parameters
  use cubetools_structure
  use cubetools_messaging
  !
  public :: option_key_t,option_user_t,option_prog_t
  private
  !
  type :: option_key_t
     type(option_t), pointer :: option
   contains
     procedure, public :: register => cubetools_option_key_register
     procedure, public :: parse    => cubetools_option_key_parse
  end type option_key_t
  !
  type :: option_user_t
     logical :: present = .false.
   contains
     procedure, public :: toprog => cubetools_option_user_toprog
  end type option_user_t
  !
  type :: option_prog_t
     logical :: act = .false.
  end type option_prog_t
  !
contains
  !
  subroutine cubetools_option_key_register(key,name,abstract,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(option_key_t), intent(inout) :: key
    character(len=*),    intent(in)    :: name
    character(len=*),    intent(in)    :: abstract
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='OPTION>KEY>REGISTER'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call cubetools_register_option(&
         name,'',&
         abstract,strg_id,&
         key%option,error)
    if (error) return
  end subroutine cubetools_option_key_register
  !
  subroutine cubetools_option_key_parse(key,line,user,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(option_key_t), intent(inout) :: key
    character(len=*),    intent(in)    :: line
    type(option_user_t), intent(inout) :: user
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='OPTION>KEY>PARSE'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    call key%option%present(line,user%present,error)
    if (error) return
  end subroutine cubetools_option_key_parse
  !
  !---------------------------------------------------------------------
  !
  subroutine cubetools_option_user_toprog(user,key,prog,error)
    use cubetools_disambiguate
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(option_user_t), intent(in)    :: user
    type(option_key_t),   intent(in)    :: key
    type(option_prog_t),  intent(inout) :: prog
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='OPTION>USER>TOPROG'
    !
    call cubetools_message(toolseve%trace,rname,'Welcome')
    !
    prog%act = user%present
  end subroutine cubetools_option_user_toprog
end module cubetools_option_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
