!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
subroutine class_catalog(line,error)
  use gildas_def
  use gkernel_interfaces
  use gbl_message
  !---------------------------------------------------------------------
  ! @ public (for libclass only)
  ! Support routine for command
  !     CATALOG [filename]
  !     1. /STATUS
  !---------------------------------------------------------------------
  character(len=*) :: line
  logical :: error
  ! Local
  character(len=filename_length) :: molfile
  character(len=256) :: chain
  !
  integer(kind=4), save :: mmol=1000
  integer(kind=4), save :: nmol
  character(len=32), save :: molname(1000)
  real(kind=8), save :: molfreq(1000)
  integer(kind=4), save :: molstatus(1000)
  !
  integer(kind=4) :: lun,nv,ier,nmolfile
  integer(kind=4) :: astatus
  real(kind=8) :: afreq
  character(len=32) :: aname
  character(len=16) :: varname
  character(len=*), parameter :: rname='catalog'
  !
  ! Initialization
  error = .false.
  !
  molfile = 'gag_molecules'
  if (sic_present(0,1)) then
     call sic_ch(line,0,1,molfile,nmolfile,.false.,error)
     if (error) return
  endif
  if (.not.sic_query_file(molfile,'data#dir:','.dat',molfile)) then
    call class_message(seve%e,rname,trim(molfile)//' not found')
    error = .true.
    return
  endif
  !
  ! Open file
  ier = sic_getlun(lun)
  if (ier.ne.1) then
     call class_message(seve%e,rname,'Cannot allocate LUN')
     call putios('E-LINE, ',ier)
     return
  endif
  open(unit=lun,file=trim(molfile), status='old',iostat=ier)
  if (ier.ne.0) then
     call class_message(seve%e,rname,'Cannot open file: '//trim(molfile))
     call putios('E-LINE, ',ier)
     goto 9
  endif
  !
  ! Read file
  nmol = 0
  if (sic_present(1,0)) then
4    read(lun,'(a)',iostat=ier,end=9) chain
     if (ier.ne.0 .or. lenc(chain).eq.0) goto 4
     if (chain(1:1).ne.'!') then
        read(chain,*,err=4) afreq,aname,astatus
        nmol = nmol + 1
        molfreq(nmol) = afreq
        molname(nmol) = aname
        molstatus(nmol) = astatus
        if (nmol.le.mmol) goto 4
     else
        goto 4
     endif
  else
5    read(lun,'(a)',iostat=ier,end=9) chain
     if (ier.ne.0 .or. lenc(chain).eq.0) goto 5
     if (chain(1:1).ne.'!') then
        read(chain,*,err=5) afreq,aname
        nmol = nmol + 1
        molfreq(nmol) = afreq
        molname(nmol) = aname
        molstatus(nmol) = 1
        if (nmol.le.mmol) goto 5
     else
        goto 5
     endif
 endif
9 close(unit=lun)
  call sic_frelun(lun)
  !
  ! Create the SIC substructure (Delete it first if needed)
  varname = 'CLASS'
  if (.not.sic_varexist(varname)) then
     call sic_defstructure(varname,.true.,error)
     if (error) return
  endif
  varname = 'CLASS%LINE'
  if (sic_varexist(varname)) then
     call sic_delvariable(varname,.false.,error)
     if (error) return
  endif
  call sic_defstructure(varname,.true.,error)
  if (error) return
  nv = lenc(varname)
  call sic_def_inte(varname(1:nv)//'%N',nmol,0,0,.true.,error)
  call sic_def_dble(varname(1:nv)//'%FREQ',molfreq,1,nmol,.true.,error)
  call sic_def_charn(varname(1:nv)//'%NAME',molname,1,nmol,.true.,error)
  call sic_def_inte(varname(1:nv)//'%STATUS',molstatus,1,nmol,.true.,error)
  if (error) return
  !
end subroutine class_catalog
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
