!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeadm_image_types
  use cubetools_array_types
  use cube_types
  use cubeadm_messaging
  !
  public :: image_t
  private
  !
  type, extends(real_2d_t) :: image_t
     type(cube_t), pointer :: cube => null() ! Associated cube
   contains
     procedure, public :: allocate  => cubeadm_image_allocate
     procedure, public :: associate => cubeadm_image_associate
     procedure, public :: get       => cubeadm_image_get
     procedure, public :: put       => cubeadm_image_put
  end type image_t
  !
contains
  !
  subroutine cubeadm_image_allocate(image,name,cube,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image_t),       intent(out)   :: image
    character(len=*),     intent(in)    :: name
    type(cube_t), target, intent(in)    :: cube
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE>ALLOCATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (cube%iscplx()) then
       call cubeadm_message(seve%e,rname,  &
            'Invalid attempt to get a R*4 image from a C*4 cube')
       error = .true.
       return
    endif
    !
    call image%reallocate(name,&
         cube%tuple%current%desc%nx,&
         cube%tuple%current%desc%ny,&
         error)
    if (error) return
    image%cube => cube
  end subroutine cubeadm_image_allocate
  !
  subroutine cubeadm_image_associate(image,name,cube,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(image_t),       intent(out)   :: image
    character(len=*),     intent(in)    :: name
    type(cube_t), target, intent(in)    :: cube
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='IMAGE>ASSOCIATE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    if (cube%iscplx()) then
       call cubeadm_message(seve%e,rname,  &
            'Invalid attempt to get a R*4 image from a C*4 cube')
       error = .true.
       return
    endif
    !
    call image%prepare_association(name,&
         cube%tuple%current%desc%nx,&
         cube%tuple%current%desc%ny,&
         error)
    if (error) return
    image%cube => cube
  end subroutine cubeadm_image_associate
  !
  !------------------------------------------------------------------------
  !
  subroutine cubeadm_image_get(image,ient,error)
    use cubeio_types
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Get the ient image from the cube
    ! When image%val is an allocated pointer, we make a copy.
    ! In all other cases (associated or null), we make it point to the data.
    !---------------------------------------------------------------------
    class(image_t),       intent(inout) :: image
    integer(kind=entr_k), intent(in)    :: ient
    logical,              intent(inout) :: error
    ! 
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='GET>IMAGE'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    call cubetuple_get_chan(image%cube%user,image%cube%prog,image%cube,ient,entry,error)
    if (error) return
    !
    if (image%pointeris.eq.code_pointer_allocated) then
       image%val(:,:) = entry%r4(:,:)
    else
       image%val => entry%r4
       image%pointeris = code_pointer_associated
    endif
    image%nx = entry%nx
    image%ny = entry%ny
    !
    call cubeio_free_chan(entry,error)
    if (error) return
  end subroutine cubeadm_image_get
  !
  subroutine cubeadm_image_put(image,ient,error)
    use cubeio_types
    use cubeio_chan
    use cubetuple_entry
    !---------------------------------------------------------------------
    ! Put the ient image to the cube
    ! Only use pointers => Nothing to free
    !---------------------------------------------------------------------
    class(image_t),       intent(in)    :: image
    integer(kind=entr_k), intent(in)    :: ient
    logical,              intent(inout) :: error
    !
    type(cube_chan_t) :: entry
    character(len=*), parameter :: rname='IMAGE>PUT>ARRAY'
    !
    call cubeadm_message(admseve%trace,rname,'Welcome')
    !
    entry%allocated = code_pointer_associated
    entry%nx = image%nx
    entry%ny = image%ny
    entry%r4 => image%val
    entry%iscplx = .false.
    !
    call cubetuple_put_chan(image%cube%user,image%cube%prog,image%cube,ient,entry,error)
    if (error) return
  end subroutine cubeadm_image_put
end module cubeadm_image_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
