subroutine cubeio_iterate_chan(cubset,cubdef,head,cub,fchan,lchan,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_chan
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ public
  ! Prepare buffers for working (at least) on the requested channel
  ! range
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: cub
  integer(kind=chan_k), intent(in)    :: fchan
  integer(kind=chan_k), intent(in)    :: lchan
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>CHAN'
  !
  select case (cub%desc%action)
  case (code_read_head)
    call cubeio_message(seve%e,rname,'Access to data not allowed for action read-header')
    error = .true.
  case (code_read,code_update)
    call cubeio_iterate_read_chan(cubset,cubdef,head,cub,fchan,lchan,error)
  case (code_write)
    call cubeio_iterate_write_chan(cubset,cubdef,head,cub,fchan,lchan,error)
  case default
    call cubeio_message(seve%e,rname,'Unexpected action mode')
    error = .true.
  end select
  !
end subroutine cubeio_iterate_chan
!
subroutine cubeio_iterate_pix(cubset,cubdef,head,cub,fypix,lypix,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_pix
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ public
  ! Prepare buffers for working (at least) on the requested Y pixel row
  ! range
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: cub
  integer(kind=pixe_k), intent(in)    :: fypix
  integer(kind=pixe_k), intent(in)    :: lypix
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>PIX'
  !
  select case (cub%desc%action)
  case (code_read_head)
    call cubeio_message(seve%e,rname,'Access to data not allowed for action read-header')
    error = .true.
  case (code_read,code_update)
    call cubeio_iterate_read_pix(cubset,cubdef,head,cub,fypix,lypix,error)
  case (code_write)
    call cubeio_iterate_write_pix(cubset,cubdef,head,cub,fypix,lypix,error)
  case default
    call cubeio_message(seve%e,rname,'Unexpected action mode')
    error = .true.
  end select
  !
end subroutine cubeio_iterate_pix
!
subroutine cubeio_iterate_subcube(cubset,cubdef,head,cub,first,last,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_subcube
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ public
  ! Prepare buffers for working (at least) on the requested range
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: cub
  integer(kind=data_k), intent(in)    :: first
  integer(kind=data_k), intent(in)    :: last
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>SUBCUBE'
  !
  select case (cub%desc%action)
  case (code_read_head)
    call cubeio_message(seve%e,rname,'Access to data not allowed for action read-header')
    error = .true.
  case (code_read,code_update)
    call cubeio_iterate_read_subcube(cubset,cubdef,head,cub,first,last,error)
  case (code_write)
    call cubeio_iterate_write_subcube(cubset,cubdef,head,cub,first,last,error)
  case default
    call cubeio_message(seve%e,rname,'Unexpected action mode')
    error = .true.
  end select
  !
end subroutine cubeio_iterate_subcube
!
subroutine cubeio_iterate_read_chan(cubset,cubdef,head,icub,fchan,lchan,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_read_chan
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ private
  ! Pre-load all or part of the data from disk in a buffer which
  ! provides (at least) the requested channel range.
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: icub
  integer(kind=chan_k), intent(in)    :: fchan
  integer(kind=chan_k), intent(in)    :: lchan
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>READ>CHAN'
  !
  ! On first iteration, read or prepare the cube data (does nothing on
  ! subsequent iterations):
  call cubeio_get_cube_data(cubset,cubdef,icub,error)
  if (error)  return
  !
  ! Work to be done on next iterations
  select case (icub%desc%buffered)
  case (code_buffer_none)
    return
  case (code_buffer_memory)
    return
  case (code_buffer_disk)
    ! Ensure the proper buffer is available in memory
    call cubeio_check_input_chan_block(cubset,head,icub,fchan,lchan,error)
    if (error)  return
  case default
    call cubeio_message(seve%e,rname,'Unexpected buffering kind')
    error = .true.
    return
  end select
  !
end subroutine cubeio_iterate_read_chan
!
subroutine cubeio_iterate_read_pix(cubset,cubdef,head,icub,fypix,lypix,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_read_pix
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ private
  ! Pre-load all or part of the data from disk in a buffer which
  ! provides (at least) the requested Y pixel row range.
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: icub
  integer(kind=pixe_k), intent(in)    :: fypix
  integer(kind=pixe_k), intent(in)    :: lypix
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>READ>PIX'
  !
  ! On first iteration, read or prepare the cube data (does nothing on
  ! subsequent iterations):
  call cubeio_get_cube_data(cubset,cubdef,icub,error)
  if (error)  return
  !
  ! Work to be done on next iterations
  select case (icub%desc%buffered)
  case (code_buffer_none)
    return
  case (code_buffer_memory)
    return
  case (code_buffer_disk)
    ! Ensure the proper buffer is available in memory
    call cubeio_check_input_pix_block(cubset,head,icub,fypix,lypix,error)
    if (error)  return
  case default
    call cubeio_message(seve%e,rname,'Unexpected buffering kind')
    error = .true.
    return
  end select
  !
end subroutine cubeio_iterate_read_pix
!
subroutine cubeio_iterate_read_subcube(cubset,cubdef,head,icub,first,last,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_read_subcube
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ private
  ! Pre-load all or part of the data from disk in a buffer which
  ! provides (at least) the requested range.
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: icub
  integer(kind=data_k), intent(in)    :: first
  integer(kind=data_k), intent(in)    :: last
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>READ>SUBCUBE'
  !
  ! On first iteration, read or prepare the cube data (does nothing on
  ! subsequent iterations):
  call cubeio_get_cube_data(cubset,cubdef,icub,error)
  if (error)  return
  !
  ! Work to be done on next iterations
  select case (icub%desc%buffered)
  case (code_buffer_none)
    return
  case (code_buffer_memory)
    return
  case (code_buffer_disk)
    ! Ensure the proper buffer is available in memory
    call cubeio_check_input_any_block(cubset,head,icub,first,last,error)
    if (error)  return
  case default
    call cubeio_message(seve%e,rname,'Unexpected buffering kind')
    error = .true.
    return
  end select
  !
end subroutine cubeio_iterate_read_subcube
!
subroutine cubeio_iterate_write_chan(cubset,cubdef,head,ocub,fchan,lchan,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_write_chan
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ private
  ! Prepare a buffer covering all or part of the data, providing
  ! (at least) the requested channel range.
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: ocub
  integer(kind=chan_k), intent(in)    :: fchan
  integer(kind=chan_k), intent(in)    :: lchan
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>WRITE>CHAN'
  !
  ! On first iteration, prepare the cube data (does nothing on
  ! subsequent iterations):
  call cubeio_create_cube_data(rname,cubset,cubdef,head,ocub,error)
  if (error)  return
  !
  ! Work to be done on next iterations
  select case (ocub%desc%buffered)
  case (code_buffer_none)
    return
  case (code_buffer_memory)
    return
  case (code_buffer_disk)
    ! Ensure the proper buffer is available in memory
    call cubeio_check_output_chan_block(cubset,head,ocub,fchan,lchan,error)
    if (error)  return
  case default
    call cubeio_message(seve%e,rname,'Unexpected buffering kind')
    error = .true.
    return
  end select
  !
end subroutine cubeio_iterate_write_chan
!
subroutine cubeio_iterate_write_pix(cubset,cubdef,head,ocub,fypix,lypix,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_write_pix
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ private
  ! Prepare a buffer covering all or part of the data, providing
  ! (at least) the requested Y pixel row range
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: ocub
  integer(kind=pixe_k), intent(in)    :: fypix
  integer(kind=pixe_k), intent(in)    :: lypix
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>WRITE>PIX'
  !
  ! On first iteration, prepare the cube data (does nothing on
  ! subsequent iterations):
  call cubeio_create_cube_data(rname,cubset,cubdef,head,ocub,error)
  if (error)  return
  !
  select case (ocub%desc%buffered)
  case (code_buffer_none)
    return
  case (code_buffer_memory)
    return
  case (code_buffer_disk)
    ! Ensure the proper buffer is available in memory
    call cubeio_check_output_pix_block(cubset,head,ocub,fypix,lypix,error)
    if (error)  return
  case default
    call cubeio_message(seve%e,rname,'Unexpected buffering kind')
    error = .true.
    return
  end select
  !
end subroutine cubeio_iterate_write_pix
!
subroutine cubeio_iterate_write_subcube(cubset,cubdef,head,ocub,first,last,error)
  use cubeio_interfaces, except_this=>cubeio_iterate_write_subcube
  use cubeio_types
  use cubeio_messaging
  !---------------------------------------------------------------------
  ! @ private
  ! Prepare a buffer covering all or part of the data, providing
  ! (at least) the requested range.
  !---------------------------------------------------------------------
  type(cube_setup_t),   intent(in)    :: cubset
  type(cube_define_t),  intent(in)    :: cubdef
  type(cube_header_t),  intent(in)    :: head
  type(cubeio_cube_t),  intent(inout) :: ocub
  integer(kind=data_k), intent(in)    :: first
  integer(kind=data_k), intent(in)    :: last
  logical,              intent(inout) :: error
  ! Local
  character(len=*), parameter :: rname='ITERATE>WRITE>SUBCUBE'
  !
  ! On first iteration, prepare the cube data (does nothing on
  ! subsequent iterations):
  call cubeio_create_cube_data(rname,cubset,cubdef,head,ocub,error)
  if (error)  return
  !
  ! Work to be done on next iterations
  select case (ocub%desc%buffered)
  case (code_buffer_none)
    return
  case (code_buffer_memory)
    return
  case (code_buffer_disk)
    ! Ensure the proper buffer is available in memory
    call cubeio_check_output_any_block(cubset,head,ocub,first,last,error)
    if (error)  return
  case default
    call cubeio_message(seve%e,rname,'Unexpected buffering kind')
    error = .true.
    return
  end select
  !
end subroutine cubeio_iterate_write_subcube
