!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_stitch_v2
  use cube_types
  use cubemain_messaging
  use cubemain_lists
  use cubemain_stitch_spatial
  use cubemain_stitch_spectral
  !
  public :: cubemain_stitch_v2_data
  private
  !
contains
  subroutine cubemain_stitch_v2_data(inlist,dorepro,doresam,stitch,weight,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(cublist_t),       intent(inout) :: inlist  ! List of input cubes
    logical,               intent(in)    :: dorepro ! Do reprojection
    logical,               intent(in)    :: doresam ! Do resampling
    type(cube_t), pointer, intent(inout) :: stitch  ! Output stitched cube
    type(cube_t), pointer, intent(inout) :: weight  ! Output weight cube
    logical,               intent(inout) :: error   
    !
    character(len=*), parameter :: rname='STITCH>V2>DATA'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (doresam.and.(.not.dorepro)) then
       call cubemain_stitch_v2_resample_only(inlist,stitch,weight,error)
       if(error) return
    else if (doresam.and.dorepro) then
       if (inlist%access.eq.code_cube_speset) then
          call cubemain_stitch_v2_resample_reproject(inlist,stitch,weight,error)
          if(error) return
       else
          call cubemain_stitch_v2_reproject_resample(inlist,stitch,weight,error)
          if(error) return
       endif
    else if ((.not.doresam).and.dorepro) then
       call cubemain_stitch_v2_reproject_only(inlist,stitch,weight,error)
       if(error) return
    else
       if (inlist%access.eq.code_cube_speset) then
          call cubemain_stitch_spectral_merge(inlist,stitch,weight,error)
          if (error) return
       else
          call cubemain_stitch_spatial_merge(inlist,stitch,weight,error)
          if (error) return
       endif
    endif
  end subroutine cubemain_stitch_v2_data
  !
  subroutine cubemain_stitch_v2_resample_only(inlist,oucube,weight,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(cublist_t),       intent(inout) :: inlist
    type(cube_t), pointer, intent(inout) :: oucube
    type(cube_t), pointer, intent(inout) :: weight
    logical,               intent(inout) :: error
    !
    integer(kind=4) :: icub
    character(len=*), parameter :: rname='STITCH>V2>RESAMPLE>ONLY'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubemain_stitch_spectral_init_output(oucube,weight,error)
    if (error) return
    !
    do icub=1,inlist%n
       call cubemain_stitch_spectral_resample_add_cube(inlist%entries(icub),oucube,weight,error)
       if (error) return
    enddo
  end subroutine cubemain_stitch_v2_resample_only
  !
  subroutine cubemain_stitch_v2_reproject_only(inlist,oucube,weight,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(cublist_t),       intent(inout) :: inlist
    type(cube_t), pointer, intent(inout) :: oucube
    type(cube_t), pointer, intent(inout) :: weight
    logical,               intent(inout) :: error
    !
    integer(kind=4) :: icub
    character(len=*), parameter :: rname='STITCH>V2>REPROJECT>ONLY'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubemain_stitch_spatial_init_output(oucube,weight,error)
    if (error) return
    !
    do icub=1,inlist%n
       call cubemain_stitch_spatial_reproject_add_cube(inlist%entries(icub),oucube,weight,error)
       if (error) return
    enddo
  end subroutine cubemain_stitch_v2_reproject_only
  !
  subroutine cubemain_stitch_v2_resample_reproject(inlist,oucube,weight,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(cublist_t),       intent(inout) :: inlist
    type(cube_t), pointer, intent(inout) :: oucube
    type(cube_t), pointer, intent(inout) :: weight
    logical,               intent(inout) :: error
    !
    integer(kind=4) :: icub
    type(entry_t) :: resampled
    character(len=*), parameter :: rname='STITCH>V2>RESAMPLE>REPROJECT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubemain_stitch_spatial_init_output(oucube,weight,error)
    if (error) return
    !
    do icub=1,inlist%n
       call cubemain_stitch_spectral_resample_cube(inlist%entries(icub),oucube,resampled,error)
       if (error) return
       call cubemain_stitch_spatial_reproject_add_cube(resampled,oucube,weight,error)
       if (error) return
    enddo
  end subroutine cubemain_stitch_v2_resample_reproject
  !
  subroutine cubemain_stitch_v2_reproject_resample(inlist,oucube,weight,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(cublist_t),       intent(inout) :: inlist
    type(cube_t), pointer, intent(inout) :: oucube
    type(cube_t), pointer, intent(inout) :: weight
    logical,               intent(inout) :: error
    !
    integer(kind=4) :: icub
    type(entry_t) :: reprojected
    character(len=*), parameter :: rname='STITCH>V2>REPROJECT>RESAMPLE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubemain_stitch_spectral_init_output(oucube,weight,error)
    if (error) return
    !
    do icub=1,inlist%n
       call cubemain_stitch_spatial_reproject_cube(inlist%entries(icub),oucube,reprojected,error)
       if (error) return 
       call cubemain_stitch_spectral_resample_add_cube(reprojected,oucube,weight,error)
       if (error) return
    enddo
  end subroutine cubemain_stitch_v2_reproject_resample
end module cubemain_stitch_v2
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
