!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeset_axset
  use cubetools_structure
  use cubetools_axset_types
  use cubeset_messaging
  use cubetools_topic
  !
  public :: axset,cubeset_axset_command
  private
  !
  type :: axset_comm_t
     type(option_t), pointer :: comm
     type(topic_opt_t)       :: ignoredegenerate
   contains
     procedure, public  :: register => cubeset_axset_register
     procedure, private :: main     => cubeset_axset_main
     procedure, private :: list     => cubeset_axset_list
  end type axset_comm_t
  type(axset_comm_t) :: axset
  !
contains
  !
  subroutine cubeset_axset_command(line,error)
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    character(len=*),    intent(in)    :: line
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='AXSET>COMMAND'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call axset%main(line,error)
    if (error) return
  end subroutine cubeset_axset_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubeset_axset_register(axset,error)
    use cubeadm_setup
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(axset_comm_t), intent(inout) :: axset
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: comm_abstract = &
         'Set how axes set are treated when reading'
    character(len=*), parameter :: comm_help = &
         'The behaviour set by this command is the global behaviour&
         & for CUBE. If the user desires to keep degenerate axes by&
         & default this should be set to off. Degenerate axes can be&
         & deactivated in per cube basis with command CUBE\MODIFY'
    character(len=*), parameter :: rname='AXSET>REGISTER'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'AXSET','',&
         comm_abstract,&
         comm_help,&
         cubeset_axset_command,&
         axset%comm,error)
    if (error) return
    !
    call axset%ignoredegenerate%register(&
         'IGNOREDEGENERAT','Ignore degenerate axes or not?',error)
    if (error) return
  end subroutine cubeset_axset_register
  !
  subroutine cubeset_axset_main(axset,line,error)
    !---------------------------------------------------------------------
    ! Support routine for command
    ! AXSET /IGNOREDEGENERATE ON|OFF
    !---------------------------------------------------------------------
    class(axset_comm_t), intent(inout) :: axset
    character(len=*),    intent(in)    :: line
    logical,             intent(inout) :: error
    !
    character(len=*), parameter :: rname='AXSET>COMMAND'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call axset%ignoredegenerate%parse(line,error)
    if (error) return
    !
    if (axset%ignoredegenerate%do) then
      call cubetools_axset_set_ignore_degenerate(axset%ignoredegenerate%enabled,error)
      if (error)  return
    else
      call axset%list(error)
      if (error)  return
    endif
  end subroutine cubeset_axset_main
  !
  subroutine cubeset_axset_list(axset,error)
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(axset_comm_t), intent(in)    :: axset
    logical,             intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='AXSET>LIST'
    !
    call cubeset_message(seve%r,rname,'  Axset')
    write(mess,'(a,l)') '    Ignore degenerate: ',cubetools_axset_get_ignore_degenerate()
    call cubeset_message(seve%r,rname,mess)
  end subroutine cubeset_axset_list
end module cubeset_axset
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
