!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubeset_timing
  use cubetools_structure
  use cubeset_messaging
  use cubetools_topic
  !
  public :: timing,cubeset_timing_command
  private
  !
  type :: timing_comm_t
     type(option_t), pointer :: comm
     type(topic_opt_t)       :: io
     type(topic_opt_t)       :: command
     type(option_t), pointer :: defaults
   contains
     procedure, public  :: register => cubeset_timing_register
     procedure, private :: parse    => cubeset_timing_parse
     procedure, private :: main     => cubeset_timing_main
     procedure, private :: list     => cubeset_timing_list
  end type timing_comm_t
  type(timing_comm_t) :: timing
  !
  type :: timing_user_t
     logical :: list
     logical :: dodefaults
  end type timing_user_t
  !
contains
  !
  subroutine cubeset_timing_command(line,error)
    !---------------------------------------------------------------------
    ! Support routine for command
    ! TIMING Mode
    !---------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(timing_user_t) :: user
    character(len=*), parameter :: rname='TIMING>COMMAND'    
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call timing%parse(line,user,error)
    if (error) return
    call timing%main(user,error)
    if (error) return
  end subroutine cubeset_timing_command
  !  
  !----------------------------------------------------------------------
  !
  subroutine cubeset_timing_register(timing,error)
    use cubetools_parameters
    !---------------------------------------------------------------------
    ! 
    !---------------------------------------------------------------------
    class(timing_comm_t), intent(inout) :: timing
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: comm_abstract = &
         'Enable or disable timing feedback at the end of processing'
    character(len=*), parameter :: comm_help = &
         'Default is OFF. Two topics are available: /COMMAND for&
         & execution times, and /IO for data Input and Output,&
         & Defaults can be reset with option /DEFAULTS. TIMING&
         & without any options displays the current timing setup'
    character(len=*), parameter :: rname='TIMING>REGISTER'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'TIMING','',&
         comm_abstract,&
         comm_help,&
         cubeset_timing_command,&
         timing%comm,error)
    if (error) return
    !
    call timing%io%register('IO','Turn IO timing on and off',error)
    if (error) return
    !
    call timing%command%register('COMMAND','Turn command timing on and off',error)
    if (error) return
    !
    call cubetools_register_option(&
         'DEFAULTS','',&
         'Reset timing defaults',&
         strg_id,&
         timing%defaults,error)
    if (error) return
  end subroutine cubeset_timing_register
  !
  subroutine cubeset_timing_parse(timing,line,user,error)
    use cubeadm_setup
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(timing_comm_t), intent(inout) :: timing
    character(len=*),     intent(in)    :: line
    type(timing_user_t),  intent(out)   :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='TIMING>PARSE'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    user%list = cubetools_nopt().eq.0
    !
    if (user%list) then
       ! nothing to do
    else
       call timing%io%parse(line,error)
       if (error) return
       call timing%command%parse(line,error)
       if (error) return
       call timing%defaults%present(line,user%dodefaults,error)
       if (error) return
    endif
  end subroutine cubeset_timing_parse
  !
  subroutine cubeset_timing_main(timing,user,error)
    use cubeadm_setup
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(timing_comm_t), intent(inout) :: timing
    type(timing_user_t),  intent(in)    :: user
    logical,              intent(inout) :: error
    !
    character(len=*), parameter :: rname='TIMING>MAIN'
    !
    call cubeset_message(setseve%trace,rname,'Welcome')
    !
    if (user%list) then
       call timing%list(error)
       if (error) return
    else
       if (user%dodefaults) then
          cubset%timing%io      = .false.
          cubset%timing%command = .false.
       endif
       !
       if (timing%io%do) cubset%timing%io = timing%io%enabled
       if (timing%command%do) cubset%timing%command = timing%command%enabled
    endif
  end subroutine cubeset_timing_main
  !
  subroutine cubeset_timing_list(timing,error)
    use cubeadm_setup
    !---------------------------------------------------------------------
    !
    !---------------------------------------------------------------------
    class(timing_comm_t), intent(in)    :: timing
    logical,              intent(inout) :: error
    !
    character(len=mess_l) :: mess
    character(len=*), parameter :: rname='TIMING>LIST'
    !
    call cubeset_message(seve%r,rname,'  Timing')
    write(mess,'(a,l)') '    IO:      ',cubset%timing%io
    call cubeset_message(seve%r,rname,mess)
    write(mess,'(a,l)') '    COMMAND: ',cubset%timing%command
    call cubeset_message(seve%r,rname,mess)
  end subroutine cubeset_timing_list
end module cubeset_timing
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
