module cubetuple_header
  use cubetuple_messaging
  use cubeio_desc
  use cube_types

  public :: cubetuple_header_list_hgdf,cubetuple_header_list_hfits
  private

contains

  subroutine cubetuple_header_list_hgdf(tuple,error)
    use gkernel_interfaces
    !-------------------------------------------------------------------
    !
    !-------------------------------------------------------------------
    type(cubetuple_t), intent(in)    :: tuple
    logical,           intent(inout) :: error
    !
    character(len=*), parameter :: rname='HEADER>LIST>HGDF'
    !
    if (.not.associated(tuple%current)) then
      call cubetuple_message(seve%e,rname,'No current IO cube to show')
      error = .true.
      return
    endif
    if (.not.tuple%haskind(code_filekind_gdf)) then
      call cubetuple_message(seve%e,rname,'Current IO cube header is not GDF')
      error = .true.
      return
    endif
    !
    call gdf_print_header(tuple%current%hgdf)
  end subroutine cubetuple_header_list_hgdf

  subroutine cubetuple_header_list_hfits(tuple,error)
    use gfits_types
    !-------------------------------------------------------------------
    !
    !-------------------------------------------------------------------
    type(cubetuple_t), intent(in)    :: tuple
    logical,           intent(inout) :: error
    !
    character(len=*), parameter :: rname='HEADER>LIST>HFITS'
    !
    if (.not.associated(tuple%current)) then
      call cubetuple_message(seve%e,rname,'No current IO cube to show')
      error = .true.
      return
    endif
    if (.not.tuple%haskind(code_filekind_fits)) then
      call cubetuple_message(seve%e,rname,'Current IO cube header is not FITS')
      error = .true.
      return
    endif
    !
    call gfits_list_dict(tuple%current%hfits%dict,error)
    if (error)  return
  end subroutine cubetuple_header_list_hfits

end module cubetuple_header
