!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_rotate
  use cubetools_structure
  use cubetools_spatial_types
  use cubemain_messaging
  use cubemain_reproject
  !
  public :: rotate
  public :: cubemain_rotate_command
  private
  !
  type :: rotate_comm_t
     type(option_t), pointer   :: comm
     type(spapro_center_opt_t) :: center
     type(spapro_angle_opt_t)  :: angle
   contains
     procedure, public  :: register => cubemain_rotate_register
     procedure, private :: parse    => cubemain_rotate_parse
  end type rotate_comm_t
  type(rotate_comm_t) :: rotate
  !
contains
  !
  subroutine cubemain_rotate_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(reproject_user_t) :: user
    character(len=*), parameter :: rname='ROTATE>COMMAND'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call rotate%parse(line,user,error)
    if (error) return
    call reproject%main(user,error)
    if (error) continue
  end subroutine cubemain_rotate_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubemain_rotate_register(rotate,error)
    use cubedag_allflags
    use cubeadm_cubeid_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(rotate_comm_t), intent(inout) :: rotate
    logical,              intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    character(len=*), parameter :: comm_abstract='Rotate a cube around a center'
    character(len=*), parameter :: comm_help=strg_id
    character(len=*), parameter :: rname='ROTATE>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'ROTATE','[cube]',&
         comm_abstract,&
         comm_help,&
         cubemain_rotate_command,&
         rotate%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         'Signal cube',  &
         strg_id,&
         code_arg_optional,  &
         [flag_cube], &
         error)
    if (error) return
    !
    call rotate%center%register(&
         'CENTER',&
         'Define the center about which to rotate',&
         error)
    if (error) return
    call rotate%angle%register(&
         'ANGLE',&
         'Define the new projection angle',&
         error)
    if (error) return
  end subroutine cubemain_rotate_register
  !
  subroutine cubemain_rotate_parse(rotate,line,user,error)
    use cubedag_allflags
    use cubeadm_cubeid_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(rotate_comm_t),   intent(in)    :: rotate
    character(len=*),       intent(in)    :: line
    type(reproject_user_t), intent(out)   :: user
    logical,                intent(inout) :: error
    !
    character(len=*), parameter :: rname='ROTATE>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call user%init(flag_rotate,error)
    if (error) return
    call cubeadm_cubeid_parse(line,rotate%comm,user%cubeids,error)
    if (error) return
    call rotate%center%parse(line,user%pcenter,error)
    if (error) return
    call rotate%angle%parse(line,user%pangle,error)
    if (error) return 
  end subroutine cubemain_rotate_parse
end module cubemain_rotate
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
