!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_visi
  use cube_types
  use cubetools_structure
  use cubeadm_cubeid_types
  use cubemain_sperange_types
  use cubetemplate_messaging
  !
  public :: visi
  public :: cubetemplate_visi_command
  private
  !
  type :: visi_comm_t
     type(option_t), pointer :: comm
     type(option_t), pointer :: factor
     type(sperange_opt_t)    :: range
   contains
     procedure, public  :: register => cubetemplate_visi_register
     procedure, private :: parse    => cubetemplate_visi_parse
     procedure, private :: main     => cubetemplate_visi_main
  end type visi_comm_t
  type(visi_comm_t) :: visi
  !
  integer(kind=4), parameter :: icube = 1
  type visi_user_t
     type(cubeid_user_t)   :: cubeids
     type(sperange_user_t) :: range
     character(len=argu_l) :: factor
   contains
     procedure, private :: toprog => cubetemplate_visi_user_toprog
  end type visi_user_t
  !
  type visi_prog_t
     type(sperange_prog_t) :: range
     real(kind=sign_k)     :: factor
     type(cube_t), pointer :: incube
     type(cube_t), pointer :: oucube
   contains
     procedure, private :: header => cubetemplate_visi_prog_header
     procedure, private :: data   => cubetemplate_visi_prog_data
  end type visi_prog_t
  !
contains
  !
  subroutine cubetemplate_visi_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(visi_user_t) :: user
    character(len=*), parameter :: rname='VISI>COMMAND'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call visi%parse(line,user,error)
    if (error) return
    call visi%main(user,error)
    if (error) continue
  end subroutine cubetemplate_visi_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_visi_register(visi,error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi_comm_t), intent(inout) :: visi
    logical,            intent(inout) :: error
    !
    type(cubeid_arg_t) :: cubearg
    type(standard_arg_t) :: stdarg
    character(len=*), parameter :: comm_abstract = 'Template command for working image wise'
    character(len=*), parameter :: comm_help = &
         'Input and output cubes ares complex'
    character(len=*), parameter :: rname='VISI>REGISTER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubetools_register_command(&
         'VISI','[cube]',&
         comm_abstract,&
         comm_help,&
         cubetemplate_visi_command,&
         visi%comm,error)
    if (error) return
    call cubearg%register( &
         'CUBE', &
         'Signal cube',  &
         strg_id,&
         code_arg_optional,  &
         [flag_any], &
         error)
    if (error) return
    !
    call visi%range%register(&
         'RANGE',&
         'Define velocity range(s)',&
         error)
    if (error) return
    !
    call cubetools_register_option(&
         'FACTOR','factor',&
         'Multiply data by a factor',&
         strg_id,&
         visi%factor,error)
    if (error) return
    call stdarg%register( &
         'factor',  &
         'factor', &
         'default is 1',&
         code_arg_mandatory, error)
    if (error) return
    !
  end subroutine cubetemplate_visi_register
  !
  subroutine cubetemplate_visi_parse(visi,line,user,error)
    !----------------------------------------------------------------------
    ! VISI cubname
    ! /RANGE vfirst vlast
    ! /FACTOR factor
    !----------------------------------------------------------------------
    class(visi_comm_t), intent(in)    :: visi
    character(len=*),   intent(in)    :: line
    type(visi_user_t),  intent(out)   :: user
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='VISI>PARSE'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_parse(line,visi%comm,user%cubeids,error)
    if (error) return
    call visi%range%parse(line,user%range,error)
    if (error) return
    call cubetemplate_visi_parse_factor(line,visi%factor,user%factor,error)
    if (error) return
  end subroutine cubetemplate_visi_parse
  !
  subroutine cubetemplate_visi_parse_factor(line,opt,user,error)
    !----------------------------------------------------------------------
    ! /FACTOR factor
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    type(option_t),   intent(in)    :: opt
    character(len=*), intent(out)   :: user
    logical,          intent(inout) :: error
    !
    logical :: present
    integer(kind=4), parameter :: iarg=1
    character(len=*), parameter :: rname='VISI>PARSE>FACTOR'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call opt%present(line,present,error)
    if (error) return
    if (present) then
       call cubetools_getarg(line,opt,iarg,user,mandatory,error)
       if (error) return
    else
       user = strg_star
    endif
  end subroutine cubetemplate_visi_parse_factor
  !
  subroutine cubetemplate_visi_main(visi,user,error)    
    use cubeadm_timing
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi_comm_t), intent(in)    :: visi
    type(visi_user_t),  intent(inout) :: user
    logical,            intent(inout) :: error
    !
    type(visi_prog_t) :: prog
    character(len=*), parameter :: rname='VISI>MAIN'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call user%toprog(prog,error)
    if (error) return
    call prog%header(error)
    if (error) return
    call cubeadm_timing_prepro2process()
    call prog%data(error)
    if (error) return
    call cubeadm_timing_process2postpro()
  end subroutine cubetemplate_visi_main
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_visi_user_toprog(user,prog,error)
    use cubetools_user2prog
    use cubetools_unit
    use cubeadm_get
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi_user_t), intent(in)    :: user
    type(visi_prog_t),  intent(out)   :: prog
    logical,            intent(inout) :: error
    !
    real(kind=sign_k), parameter :: default=1.0
    type(unit_user_t) :: nounit
    character(len=*), parameter :: rname='VISI>USER>TOPROG'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_cubeid_get_header(visi%comm,icube,user%cubeids,&
         code_access_imaset,code_read,prog%incube,error)
    if (error) return
    !
    call user%range%toprog(prog%incube,prog%range,error)
    if (error) return
    !
    call cubetools_unit_get(strg_star,code_unit_unk,nounit,error)
    if (error) return
    call cubetools_user2prog_resolve_star(user%factor,nounit,default,prog%factor,error)
    if (error) return
  end subroutine cubetemplate_visi_user_toprog
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_visi_prog_header(prog,error)
    use cubedag_allflags
    use cubeadm_clone
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi_prog_t), intent(inout) :: prog
    logical,            intent(inout) :: error
    !
    character(len=*), parameter :: rname='VISI>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_clone_header(prog%incube,flag_template,prog%oucube,error)
    if (error) return
    !
  end subroutine cubetemplate_visi_prog_header
  !
  subroutine cubetemplate_visi_prog_data(prog,error)
    use cubeadm_opened
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    class(visi_prog_t), intent(inout) :: prog
    logical,            intent(inout) :: error
    !
    type(cubeadm_iterator_t) :: iter
    character(len=*), parameter :: rname='VISI>PROG>DATA'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call cubeadm_datainit_all(iter,error)
    if (error) return
    !$OMP PARALLEL DEFAULT(none) SHARED(prog,error) FIRSTPRIVATE(iter)
    !$OMP SINGLE
    do while (cubeadm_dataiterate_all(iter,error))
       if (error)  exit
       !$OMP TASK SHARED(prog) FIRSTPRIVATE(iter,error)
       if (.not.error)  &
         call cubetemplate_visi_loop(prog,iter%first,iter%last,error)
       !$OMP END TASK
    enddo ! ie
    !$OMP END SINGLE
    !$OMP END PARALLEL
  end subroutine cubetemplate_visi_prog_data
  !   
  subroutine cubetemplate_visi_loop(prog,first,last,error)
    use cubeadm_entryloop
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(visi_prog_t),    intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: first
    integer(kind=entr_k), intent(in)    :: last
    logical,              intent(inout) :: error
    !
    integer(kind=entr_k) :: ie
    type(visi_t) :: inima,ouima
    character(len=*), parameter :: rname='VISI>LOOP'
    !
    call inima%associate('inima',prog%incube,error)
    if (error) return
    call ouima%allocate('ouima',prog%oucube,error)
    if (error) return
    !
    do ie=first,last
      call cubeadm_entryloop_iterate(ie,error)
      if (error)  return
      call cubetemplate_visi_act(prog,ie,inima,ouima,error)
      if (error)  return
    enddo
  end subroutine cubetemplate_visi_loop
  !   
  subroutine cubetemplate_visi_act(prog,ie,inima,ouima,error)
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    type(visi_prog_t),    intent(inout) :: prog
    integer(kind=entr_k), intent(in)    :: ie
    type(visi_t),         intent(inout) :: inima
    type(visi_t),         intent(inout) :: ouima
    logical,              intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    character(len=*), parameter :: rname='VISI>ACT'
    !
    call inima%get(ie,error)
    if (error)  return
    do iy=1,inima%ny
       do ix=1,inima%nx
          ouima%val(ix,iy) = prog%factor*cmplx(real(inima%val(ix,iy)),ix+iy+ie)
       enddo ! iy
    enddo ! ix
    call ouima%put(ie,error)
    if (error)  return
  end subroutine cubetemplate_visi_act
end module cubetemplate_visi
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
