module cubetuple_export
  use gkernel_interfaces
  use cubetools_parameters
  use cubetools_access
  use cubedag_tuple
  use cubeio_interfaces_public
  use cube_types
  use cubetuple_messaging

  public :: cubetuple_export_cube
  private

contains

  subroutine cubetuple_export_cube(cube,newname,tofits,error)
    use cubetools_dataformat
    use cubeio_cube_define
    use cubetuple_transpose
    !-------------------------------------------------------------------
    ! Export the current cube to disk
    !-------------------------------------------------------------------
    type(cube_t),     intent(inout) :: cube
    character(len=*), intent(in)    :: newname
    logical,          intent(in)    :: tofits
    logical,          intent(inout) :: error
    ! Local
    character(len=*), parameter :: rname='EXPORT>CUBE'
    character(len=file_l) :: oldname
    integer(kind=4) :: ier
    !
    ! If a transposition is pending, time has come to do it NOW before
    ! we dump the data!
    call cubetuple_autotranspose_cube(cube,error)
    if (error)  return
    !
    ! Which cube is to be exported?
    ! - As of today, the "current" one, i.e. the last which was used.
    ! - We could be a bit more clever, and check among all the cubes
    !   in the tuple, if there is one already written (i.e. save time!)
    !   This means asking for the tuple if there is a file already
    !   available (code_buffer_disk). BUT, is this file up-to-date?
    !   For now, we assume that the memory content is always newer or
    !   equal to the disk contents.
    !
    oldname = cube%tuple%current%file%hgdf%file
    !
    ! Rename the file in memory
    cube%tuple%current%file%hgdf%file = newname
    !
    ! Rename the file on disk (for e.g. files in disk mode)
    if (gag_inquire(oldname,len_trim(oldname)).eq.0) then
      ier = gag_filrename(oldname,newname)
      if (ier.ne.0)  error = .true.
    endif
    !
    ! Dump (for e.g. files in memory mode)
    call cubeio_cube_define_action(cube%prog,code_write,error)
    if (error)  return
    call cubeio_cube_define_access(cube%prog,cube%access(),error)  ! i.e. the current access, as explained above
    if (error)  return
    call cubeio_cube_define_order(cube%prog,cube%order(),error)  ! i.e. the current order, as explained above
    if (error)  return
    call cubeio_cube_define_filename(cube%prog,newname,error)
    if (error)  return
    if (tofits) then
      call cubeio_cube_define_filekind(cube%prog,code_dataformat_fits,error)
    else
      call cubeio_cube_define_filekind(cube%prog,code_dataformat_gdf,error)
    endif
    if (error)  return
    call cubeio_dump_cube(cube%user,cube%prog,cube%head,cube%tuple%current,error)
    if (error)  return
    !
    ! Update the tuple if relevant
    call cubedag_tuple_upsert(cube%node%tuple,  &
                              cube%order(),  &
                              code_buffer_disk,  &
                              cube%tuple%current%file%hgdf%file,error)
    if (error)  return
    !
    call cubetuple_message(seve%i,rname,'Exported cube to '//newname)
  end subroutine cubetuple_export_cube

end module cubetuple_export
