/*
 * G-ToDo Gkrellm Plugin
 * Copyright 2003-2004 Dimitar Haralanov
 *
 */
/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __DEBUG_H
#define __DEBUG_H

#include <stdarg.h>

/* some debugging macros */
#ifdef DEBUG
/* Print a debugging message */
#define DPRINTF(fmt, ...) do { \
                               fprintf (stderr, "G-Todo: %s() [%d]: " fmt "\n", __FUNCTION__, __LINE__, ##__VA_ARGS__); \
                               fflush (stderr); \
                             } while (0)
/* Print a check pointing message */
#define DPRINTF_CHECK do { \
                          fprintf (stderr, "G-Todo: %s() [%d]: CHECKPOINT\n", __FUNCTION__, __LINE__); \
                          fflush (stderr); \
                        } while (0)
/* If expr is true print out the formatted
 * message */
#define DPRINTF_IF_TRUE(expr, fmt, ...) do { \
                                            if ((expr)) { \
                                                 fprintf (stderr, "G-Todo: %s() [%d]: %s success: " fmt "\n", __FUNCTION__, \
                                                          __LINE__, #expr, ##__VA_ARGS__); \
                                                 fflush (stderr); \
                                            } \
                                          } while (0)
#else
#define DPRINTF(fmt, ...)
#define DPRINTF_CHECK
#define DPRINTF_IF_TRUE(expr, fmt, ...)
#endif /* ifdef DEBUG */

#endif /* debug.h */
