/*
 * G-ToDo Gkrellm Plugin
 * Copyright 2003-2004 Dimitar Haralanov
 *
 */
/* This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __QUICK_VIEW_H
#define __QUICK_VIEW_H

#include <main.h>
#include <config.h>

/* Create the Quick-View window, arrange all the widgets inside it,
 * and connect them to the appropriate signals. Returns the toplevel
 * widget
 */
GtkWidget * gtodo_create_quick_view      (GkrellmMonitor *, GtkTreeIter *);

/* Callback which will handle events from the mouse
 * wheel */
gboolean    gtodo_mouse_wheel_scrolled   (GtkWidget *, GdkEventScroll *, gpointer);

/* Deternine whether the "View" button should be sensitive or not
 * and set it
 */
void gtodo_quick_view_set_comment_button (GtkTreeIter *);
#endif /* quick_view.h */
