/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.execution;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.OverlappingOutputs;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputCachingState;
import org.gradle.api.internal.tasks.CacheableTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.DefaultTaskOutputCachingState;
import org.gradle.api.internal.tasks.TaskExecuter;
import org.gradle.api.internal.tasks.TaskExecuterResult;
import org.gradle.api.internal.tasks.TaskExecutionContext;
import org.gradle.api.internal.tasks.TaskOutputCachingDisabledReasonCategory;
import org.gradle.api.internal.tasks.TaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.TaskStateInternal;
import org.gradle.api.internal.tasks.execution.SelfDescribingSpec;
import org.gradle.caching.internal.tasks.BuildCacheKeyInputs;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.internal.file.RelativeFilePathResolver;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveTaskOutputCachingStateExecuter
implements TaskExecuter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolveTaskOutputCachingStateExecuter.class);
    private static final TaskOutputCachingState ENABLED = DefaultTaskOutputCachingState.enabled();
    private static final TaskOutputCachingState DISABLED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.BUILD_CACHE_DISABLED, "Task output caching is disabled");
    private static final TaskOutputCachingState CACHING_NOT_ENABLED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NOT_ENABLED_FOR_TASK, "Caching has not been enabled for the task");
    private static final TaskOutputCachingState NO_OUTPUTS_DECLARED = DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NO_OUTPUTS_DECLARED, "No outputs declared");
    private final boolean buildCacheEnabled;
    private final RelativeFilePathResolver relativeFilePathResolver;
    private final TaskExecuter delegate;

    public ResolveTaskOutputCachingStateExecuter(boolean buildCacheEnabled, RelativeFilePathResolver relativeFilePathResolver, TaskExecuter delegate) {
        this.buildCacheEnabled = buildCacheEnabled;
        this.relativeFilePathResolver = relativeFilePathResolver;
        this.delegate = delegate;
    }

    @Override
    public TaskExecuterResult execute(TaskInternal task, TaskStateInternal state, TaskExecutionContext context) {
        if (this.buildCacheEnabled) {
            TaskOutputCachingState taskOutputCachingState = ResolveTaskOutputCachingStateExecuter.resolveCachingState(context.getTaskProperties().hasDeclaredOutputs(), context.getTaskProperties().getOutputFileProperties(), context.getBuildCacheKey(), task, task.getOutputs().getCacheIfSpecs(), task.getOutputs().getDoNotCacheIfSpecs(), context.getOverlappingOutputs().orElse(null), this.relativeFilePathResolver);
            context.setTaskCachingEnabled(taskOutputCachingState.isEnabled());
            state.setTaskOutputCaching(taskOutputCachingState);
            if (!taskOutputCachingState.isEnabled()) {
                LOGGER.info("Caching disabled for {}: {}", (Object)task, (Object)taskOutputCachingState.getDisabledReason());
            }
        } else {
            state.setTaskOutputCaching(DISABLED);
        }
        return this.delegate.execute(task, state, context);
    }

    @VisibleForTesting
    static TaskOutputCachingState resolveCachingState(boolean hasDeclaredOutputs, Collection<TaskOutputFilePropertySpec> outputFileProperties, TaskOutputCachingBuildCacheKey buildCacheKey, TaskInternal task, Collection<SelfDescribingSpec<TaskInternal>> cacheIfSpecs, Collection<SelfDescribingSpec<TaskInternal>> doNotCacheIfSpecs, @Nullable OverlappingOutputs overlappingOutputs, RelativeFilePathResolver relativeFilePathResolver) {
        if (cacheIfSpecs.isEmpty()) {
            return CACHING_NOT_ENABLED;
        }
        if (!hasDeclaredOutputs) {
            return NO_OUTPUTS_DECLARED;
        }
        if (overlappingOutputs != null) {
            String relativePath = relativeFilePathResolver.resolveAsRelativePath((Object)overlappingOutputs.getOverlappedFilePath());
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.OVERLAPPING_OUTPUTS, String.format("Gradle does not know how file '%s' was created (output property '%s'). Task output caching requires exclusive access to output paths to guarantee correctness.", relativePath, overlappingOutputs.getPropertyName()));
        }
        for (TaskOutputFilePropertySpec taskOutputFilePropertySpec : outputFileProperties) {
            if (taskOutputFilePropertySpec instanceof CacheableTaskOutputFilePropertySpec) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NON_CACHEABLE_TREE_OUTPUT, "Output property '" + taskOutputFilePropertySpec.getPropertyName() + "' contains a file tree");
        }
        for (SelfDescribingSpec selfDescribingSpec : cacheIfSpecs) {
            if (selfDescribingSpec.isSatisfiedBy(task)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.CACHE_IF_SPEC_NOT_SATISFIED, "'" + selfDescribingSpec.getDisplayName() + "' not satisfied");
        }
        for (SelfDescribingSpec selfDescribingSpec : doNotCacheIfSpecs) {
            if (!selfDescribingSpec.isSatisfiedBy(task)) continue;
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.DO_NOT_CACHE_IF_SPEC_SATISFIED, "'" + selfDescribingSpec.getDisplayName() + "' satisfied");
        }
        if (!buildCacheKey.isValid()) {
            return ResolveTaskOutputCachingStateExecuter.getCachingStateForInvalidCacheKey(buildCacheKey);
        }
        return ENABLED;
    }

    private static TaskOutputCachingState getCachingStateForInvalidCacheKey(TaskOutputCachingBuildCacheKey buildCacheKey) {
        ImmutableSortedMap<String, String> invalidInputProperties;
        BuildCacheKeyInputs buildCacheKeyInputs = buildCacheKey.getInputs();
        ImplementationSnapshot taskImplementation = buildCacheKeyInputs.getTaskImplementation();
        if (taskImplementation != null && taskImplementation.isUnknown()) {
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NON_CACHEABLE_TASK_IMPLEMENTATION, "Task class " + taskImplementation.getUnknownReason());
        }
        List<ImplementationSnapshot> actionImplementations = buildCacheKeyInputs.getActionImplementations();
        if (actionImplementations != null && !actionImplementations.isEmpty()) {
            for (ImplementationSnapshot actionImplementation : actionImplementations) {
                if (!actionImplementation.isUnknown()) continue;
                return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NON_CACHEABLE_TASK_ACTION, "Task action " + actionImplementation.getUnknownReason());
            }
        }
        if ((invalidInputProperties = buildCacheKeyInputs.getNonCacheableInputProperties()) != null && !invalidInputProperties.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Non-cacheable inputs: ");
            boolean first = true;
            for (Map.Entry entry : ((ImmutableSortedMap)Preconditions.checkNotNull(invalidInputProperties)).entrySet()) {
                if (!first) {
                    builder.append(", ");
                }
                first = false;
                builder.append("property '").append((String)entry.getKey()).append("' ").append((String)entry.getValue());
            }
            return DefaultTaskOutputCachingState.disabled(TaskOutputCachingDisabledReasonCategory.NON_CACHEABLE_INPUTS, builder.toString());
        }
        throw new IllegalStateException("Cache key is invalid without a known reason: " + buildCacheKey);
    }
}

