/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.GradleException;
import org.gradle.buildinit.plugins.internal.BuildConverter;
import org.gradle.buildinit.plugins.internal.BuildInitializer;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.util.CollectionUtils;

public class ProjectLayoutSetupRegistry {
    private final Map<String, BuildInitializer> registeredProjectDescriptors = new TreeMap<String, BuildInitializer>();
    private final BuildInitializer defaultType;
    private final BuildConverter converter;

    public ProjectLayoutSetupRegistry(BuildInitializer defaultType, BuildConverter converter) {
        this.defaultType = defaultType;
        this.converter = converter;
        this.add(defaultType);
        this.add(converter);
    }

    public void add(BuildInitializer descriptor) {
        if (this.registeredProjectDescriptors.containsKey(descriptor.getId())) {
            throw new GradleException(String.format("ProjectDescriptor with ID '%s' already registered.", descriptor.getId()));
        }
        this.registeredProjectDescriptors.put(descriptor.getId(), descriptor);
    }

    public BuildConverter getBuildConverter() {
        return this.converter;
    }

    public BuildInitializer getDefault() {
        return this.defaultType;
    }

    public BuildInitializer get(String type) {
        if (!this.registeredProjectDescriptors.containsKey(type)) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("The requested build setup type '" + type + "' is not supported. Supported types");
            formatter.startChildren();
            for (String candidate : this.getAllTypes()) {
                formatter.node("'" + candidate + "'");
            }
            formatter.endChildren();
            throw new GradleException(formatter.toString());
        }
        return this.registeredProjectDescriptors.get(type);
    }

    public List<BuildInitializer> getAll() {
        return CollectionUtils.toList(this.registeredProjectDescriptors.values());
    }

    public List<String> getBuildGenerators() {
        ArrayList<String> result = new ArrayList<String>(this.registeredProjectDescriptors.size());
        for (BuildInitializer initDescriptor : this.registeredProjectDescriptors.values()) {
            if (initDescriptor == this.converter) continue;
            result.add(initDescriptor.getId());
        }
        return result;
    }

    public List<String> getAllTypes() {
        ArrayList<String> result = new ArrayList<String>(this.registeredProjectDescriptors.size());
        for (BuildInitializer initDescriptor : this.registeredProjectDescriptors.values()) {
            result.add(initDescriptor.getId());
        }
        return result;
    }
}

